/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.primitives.TeXFontDeclaration;
import java.io.IOException;

public class TeXFontFamilyDeclaration
extends TeXFontDeclaration {
    private int family;
    private int orgWeight;
    private int orgFamily;
    private int orgShape;

    public TeXFontFamilyDeclaration(String string, int n) {
        super(string);
        this.family = n;
        this.orgWeight = -1;
        this.orgFamily = -1;
        this.orgShape = -1;
    }

    @Override
    public Object clone() {
        return new TeXFontFamilyDeclaration(this.getName(), this.family);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgWeight = teXSettings.getCurrentFontWeight();
        this.orgShape = teXSettings.getCurrentFontShape();
        this.orgFamily = teXSettings.getCurrentFontFamily();
        teXSettings.setFontWeight(0);
        teXSettings.setFontShape(0);
        teXSettings.setFontFamily(this.family);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontWeight(this.orgWeight);
        teXSettings.setFontShape(this.orgShape);
        teXSettings.setFontFamily(this.orgFamily);
    }
}

