/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.filters.JavaTypeFilter;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.profiling.presets.PresetsUtils;
import org.graalvm.visualvm.profiling.presets.ProfilerCPUSettings;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.graalvm.visualvm.profiling.presets.ProfilerPresets;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class ProfilerCPUPanel
extends JPanel {
    private JLabel rootClassesLabel;
    private TextAreaComponent rootsArea;
    private JRadioButton inclFilterRadioButton;
    private JRadioButton exclFilterRadioButton;
    private TextAreaComponent filtersArea;
    private final Runnable validator;
    private boolean rootsValid = true;
    private boolean filtersValid = true;
    private boolean internalChange;

    public ProfilerCPUPanel() {
        this((Runnable)null, false);
    }

    ProfilerCPUPanel(Runnable validator, boolean mnemonics) {
        this.validator = validator;
        this.initComponents(mnemonics);
    }

    public ProfilingSettings getSettings() {
        ProfilingSettings settings = ProfilerIDESettings.getInstance().createDefaultProfilingSettings();
        settings.setProfilingType(16);
        settings.setCPUProfilingType(settings.getSamplingInterval() <= 0 ? 0 : 1);
        String[] rootsValues = GenericFilter.values((String)PresetsUtils.normalizeValue(this.getRootsValue()));
        ClientUtils.SourceCodeSelection[] roots = rootsValues.length == 1 && rootsValues[0].isEmpty() ? new ClientUtils.SourceCodeSelection[]{} : new ClientUtils.SourceCodeSelection[rootsValues.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = new ClientUtils.SourceCodeSelection(rootsValues[i], "*", null);
        }
        settings.addRootMethods(roots);
        String filter = this.getFilterValue();
        if (filter.isEmpty() || "*".equals(filter) || "**".equals(filter)) {
            settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter());
        } else {
            int filterType = this.inclFilterRadioButton.isSelected() ? 10 : 20;
            String filterValue = PresetsUtils.normalizeValue(filter);
            settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(filterValue, filterType));
        }
        settings.setStackDepthLimit(Integer.MAX_VALUE);
        return settings;
    }

    public boolean settingsValid() {
        return this.rootsValid && this.filtersValid;
    }

    public void highlighInvalid() {
        if (this.getRootsValue().isEmpty()) {
            this.rootsArea.getTextArea().setText(ProfilerPresets.DEFINE_CLASSES);
        }
    }

    public void loadFromPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        this.internalChange = true;
        this.rootsArea.getTextArea().setText(preset.getRootsP());
        this.inclFilterRadioButton.setSelected(!preset.getFilterModeP());
        this.exclFilterRadioButton.setSelected(preset.getFilterModeP());
        this.filtersArea.getTextArea().setText(preset.getFilterP());
        this.highlighInvalid();
        this.internalChange = false;
        this.checkRootValidity();
        this.checkFilterValidity();
    }

    public void saveToPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        preset.setRootsP(this.getRootsValue());
        preset.setFilterModeP(this.exclFilterRadioButton.isSelected());
        preset.setFilterP(this.getFilterValue());
    }

    public abstract void settingsChanged();

    private void syncUI() {
        if (this.internalChange) {
            return;
        }
        this.settingsChanged();
    }

    private void checkRootValidity() {
        this.rootsValid = this.isRootValueValid();
        this.rootsArea.getTextArea().setForeground(this.rootsValid ? UIManager.getColor("TextArea.foreground") : Color.RED);
        if (this.validator != null) {
            this.validator.run();
        }
    }

    public boolean isRootValueValid() {
        String rootsValue = PresetsUtils.normalizeValue(this.getRootsValue());
        return PresetsUtils.isValidJavaValue(rootsValue, false, false);
    }

    private String getRootsValue() {
        return this.rootsArea.getTextArea().getText().trim();
    }

    private void checkFilterValidity() {
        this.filtersValid = this.isFilterValueValid();
        this.filtersArea.getTextArea().setForeground(this.filtersValid ? UIManager.getColor("TextArea.foreground") : Color.RED);
        if (this.validator != null) {
            this.validator.run();
        }
    }

    public boolean isFilterValueValid() {
        String filterValue = PresetsUtils.normalizeValue(this.getFilterValue());
        return PresetsUtils.isValidJavaValue(filterValue, true, false);
    }

    private String getFilterValue() {
        return this.filtersArea.getTextArea().getText().trim();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private void initComponents(boolean mnemonics) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        ButtonGroup filterRadiosGroup = new ButtonGroup();
        this.rootClassesLabel = new JLabel();
        ProfilerCPUPanel.setText(this.rootClassesLabel, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Root_Classes"), mnemonics);
        Dimension d = this.rootClassesLabel.getPreferredSize();
        JRadioButton refRadion = new JRadioButton(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Root_Classes"));
        refRadion.setBorder(this.rootClassesLabel.getBorder());
        d.height = Math.max(d.height, refRadion.getPreferredSize().height);
        this.rootClassesLabel.setPreferredSize(d);
        this.rootClassesLabel.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Root_Classes"));
        this.rootClassesLabel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        this.add((Component)this.rootClassesLabel, constraints);
        this.rootsArea = ProfilerCPUPanel.createTextArea(2);
        this.rootClassesLabel.setLabelFor(this.rootsArea.getTextArea());
        this.rootsArea.getTextArea().setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Root_Classes"));
        this.rootsArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkRootValidity();
                ProfilerCPUPanel.this.syncUI();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkRootValidity();
                ProfilerCPUPanel.this.syncUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkRootValidity();
                ProfilerCPUPanel.this.syncUI();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.65;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.rootsArea, constraints);
        this.inclFilterRadioButton = new JRadioButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerCPUPanel.this.syncUI();
            }
        };
        ProfilerCPUPanel.setText(this.inclFilterRadioButton, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Profile_Incl"), mnemonics);
        this.inclFilterRadioButton.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Inclusive_Filter"));
        this.inclFilterRadioButton.setOpaque(false);
        this.inclFilterRadioButton.setBorder(this.rootClassesLabel.getBorder());
        filterRadiosGroup.add(this.inclFilterRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 5, 5);
        this.add((Component)this.inclFilterRadioButton, constraints);
        this.exclFilterRadioButton = new JRadioButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilerCPUPanel.this.syncUI();
            }
        };
        ProfilerCPUPanel.setText(this.exclFilterRadioButton, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Profile_Excl"), mnemonics);
        this.exclFilterRadioButton.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Exclusive_Filter"));
        this.exclFilterRadioButton.setOpaque(false);
        this.exclFilterRadioButton.setBorder(this.rootClassesLabel.getBorder());
        filterRadiosGroup.add(this.exclFilterRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.exclFilterRadioButton, constraints);
        this.filtersArea = ProfilerCPUPanel.createTextArea(2);
        this.filtersArea.getTextArea().setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Instrumentation_Filter"));
        this.filtersArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkFilterValidity();
                ProfilerCPUPanel.this.syncUI();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkFilterValidity();
                ProfilerCPUPanel.this.syncUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilerCPUPanel.this.checkFilterValidity();
                ProfilerCPUPanel.this.syncUI();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weighty = 0.35;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.filtersArea, constraints);
    }

    private static void setText(JLabel l, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((JLabel)l, (String)text);
        } else {
            l.setText(text.replace("&", ""));
        }
    }

    private static void setText(AbstractButton b, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((AbstractButton)b, (String)text);
        } else {
            b.setText(text.replace("&", ""));
        }
    }

    private static TextAreaComponent createTextArea(int rows) {
        final JTextArea rootsArea = new JTextArea();
        rootsArea.setFont(new Font("Monospaced", 0, UIManager.getFont("Label.font").getSize()));
        TextAreaComponent rootsAreaScrollPane = new TextAreaComponent(rootsArea, 20, 30){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                rootsArea.setEnabled(enabled);
            }
        };
        rootsAreaScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JTextArea referenceArea = new JTextArea("X");
        referenceArea.setFont(rootsArea.getFont());
        referenceArea.setRows(rows);
        Insets insets = rootsAreaScrollPane.getInsets();
        rootsAreaScrollPane.setPreferredSize(new Dimension(1, referenceArea.getPreferredSize().height + (insets != null ? insets.top + insets.bottom : 0)));
        return rootsAreaScrollPane;
    }

    private static class TextAreaComponent
    extends JScrollPane {
        public TextAreaComponent(JTextArea textArea, int vPolicy, int hPolicy) {
            super(textArea, vPolicy, hPolicy);
        }

        public JTextArea getTextArea() {
            return (JTextArea)this.getViewport().getView();
        }
    }
}

