/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.aix;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum Errno implements Constant
{
    EPERM(1L),
    ENOENT(2L),
    ESRCH(3L),
    EINTR(4L),
    EIO(5L),
    ENXIO(6L),
    E2BIG(7L),
    ENOEXEC(8L),
    EBADF(9L),
    ECHILD(10L),
    EDEADLK(45L),
    ENOMEM(12L),
    EACCES(13L),
    EFAULT(14L),
    ENOTBLK(15L),
    EBUSY(16L),
    EEXIST(17L),
    EXDEV(18L),
    ENODEV(19L),
    ENOTDIR(20L),
    EISDIR(21L),
    EINVAL(22L),
    ENFILE(23L),
    EMFILE(24L),
    ENOTTY(25L),
    ETXTBSY(26L),
    EFBIG(27L),
    ENOSPC(28L),
    ESPIPE(29L),
    EROFS(30L),
    EMLINK(31L),
    EPIPE(32L),
    EDOM(33L),
    ERANGE(34L),
    EWOULDBLOCK(11L),
    EAGAIN(11L),
    EINPROGRESS(55L),
    EALREADY(56L),
    ENOTSOCK(57L),
    EDESTADDRREQ(58L),
    EMSGSIZE(59L),
    EPROTOTYPE(60L),
    ENOPROTOOPT(61L),
    EPROTONOSUPPORT(62L),
    ESOCKTNOSUPPORT(63L),
    EOPNOTSUPP(64L),
    EPFNOSUPPORT(65L),
    EAFNOSUPPORT(66L),
    EADDRINUSE(67L),
    EADDRNOTAVAIL(68L),
    ENETDOWN(69L),
    ENETUNREACH(70L),
    ENETRESET(71L),
    ECONNABORTED(72L),
    ECONNRESET(73L),
    ENOBUFS(74L),
    EISCONN(75L),
    ENOTCONN(76L),
    ESHUTDOWN(77L),
    ETOOMANYREFS(115L),
    ETIMEDOUT(78L),
    ECONNREFUSED(79L),
    ELOOP(85L),
    ENAMETOOLONG(86L),
    EHOSTDOWN(80L),
    EHOSTUNREACH(81L),
    ENOTEMPTY(17L),
    EUSERS(84L),
    EDQUOT(88L),
    ESTALE(52L),
    EREMOTE(93L),
    ENOLCK(49L),
    ENOSYS(109L),
    EOVERFLOW(127L),
    EIDRM(36L),
    ENOMSG(35L),
    EILSEQ(116L),
    EBADMSG(120L),
    EMULTIHOP(125L),
    ENODATA(122L),
    ENOLINK(126L),
    ENOSR(118L),
    ENOSTR(123L),
    EPROTO(121L),
    ETIME(119L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 127L;

    private Errno(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(EPERM, "Not owner");
            map2.put(ENOENT, "No such file or directory");
            map2.put(ESRCH, "No such process");
            map2.put(EINTR, "Interrupted system call");
            map2.put(EIO, "I/O error");
            map2.put(ENXIO, "No such device or address");
            map2.put(E2BIG, "Arg list too long");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(EBADF, "Bad file number");
            map2.put(ECHILD, "No child processes");
            map2.put(EDEADLK, "Deadlock condition if locked");
            map2.put(ENOMEM, "Not enough space");
            map2.put(EACCES, "Permission denied");
            map2.put(EFAULT, "Bad address");
            map2.put(ENOTBLK, "Block device required");
            map2.put(EBUSY, "Device busy");
            map2.put(EEXIST, "File exists");
            map2.put(EXDEV, "Cross-device link");
            map2.put(ENODEV, "No such device");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EISDIR, "Is a directory");
            map2.put(EINVAL, "Invalid argument");
            map2.put(ENFILE, "File table overflow");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENOTTY, "Not a typewriter");
            map2.put(ETXTBSY, "Text file busy");
            map2.put(EFBIG, "File too large");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ESPIPE, "Illegal seek");
            map2.put(EROFS, "Read-only file system");
            map2.put(EMLINK, "Too many links");
            map2.put(EPIPE, "Broken pipe");
            map2.put(EDOM, "Argument out of domain");
            map2.put(ERANGE, "Result too large");
            map2.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(EINPROGRESS, "Operation now in progress");
            map2.put(EALREADY, "Operation already in progress");
            map2.put(ENOTSOCK, "Socket operation on non-socket");
            map2.put(EDESTADDRREQ, "Destination address required");
            map2.put(EMSGSIZE, "Message too long");
            map2.put(EPROTOTYPE, "Protocol wrong type for socket");
            map2.put(ENOPROTOOPT, "Protocol not available");
            map2.put(EPROTONOSUPPORT, "Protocol not supported");
            map2.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map2.put(EOPNOTSUPP, "Operation not supported on socket");
            map2.put(EPFNOSUPPORT, "Protocol family not supported");
            map2.put(EAFNOSUPPORT, "Addr family not supported by protocol");
            map2.put(EADDRINUSE, "Address already in use");
            map2.put(EADDRNOTAVAIL, "Can't assign requested address");
            map2.put(ENETDOWN, "Network is down");
            map2.put(ENETUNREACH, "Network is unreachable");
            map2.put(ENETRESET, "Network dropped connection on reset");
            map2.put(ECONNABORTED, "Software caused connection abort");
            map2.put(ECONNRESET, "Connection reset by peer");
            map2.put(ENOBUFS, "No buffer space available");
            map2.put(EISCONN, "Socket is already connected");
            map2.put(ENOTCONN, "Socket is not connected");
            map2.put(ESHUTDOWN, "Can't send after socket shutdown");
            map2.put(ETOOMANYREFS, "Too many references: can't splice");
            map2.put(ETIMEDOUT, "Connection timed out");
            map2.put(ECONNREFUSED, "Connection refused");
            map2.put(ELOOP, "Too many levels of symbolic links");
            map2.put(ENAMETOOLONG, "File name too long");
            map2.put(EHOSTDOWN, "Host is down");
            map2.put(EHOSTUNREACH, "No route to host");
            map2.put(ENOTEMPTY, "File exists");
            map2.put(EUSERS, "Too many users");
            map2.put(EDQUOT, "Disk quota exceeded");
            map2.put(ESTALE, "Missing file or filesystem");
            map2.put(EREMOTE, "Item is not local to host");
            map2.put(ENOLCK, "No locks available");
            map2.put(ENOSYS, "Function not implemented");
            map2.put(EOVERFLOW, "Value too large to be stored in data type");
            map2.put(EIDRM, "Identifier removed");
            map2.put(ENOMSG, "No message of desired type");
            map2.put(EILSEQ, "Invalid wide character");
            map2.put(EBADMSG, "Next message has wrong type");
            map2.put(EMULTIHOP, "Multihop is not allowed");
            map2.put(ENODATA, "No message on stream head read q");
            map2.put(ENOLINK, "The server link has been severed");
            map2.put(ENOSR, "Out of STREAMS resources");
            map2.put(ENOSTR, "fd not associated with a stream");
            map2.put(EPROTO, "Error in protocol");
            map2.put(ETIME, "System call timed out");
            return map2;
        }
    }
}

