from typing import Any, Optional, Sequence, Union

from lxml.etree import _Element

from xmlsec.constants import __Transform as Transform

def add_encrypted_key(
    node: _Element, method: Transform, id: Optional[str] = None, type: Optional[str] = None, recipient: Optional[str] = None
) -> _Element: ...
def add_key_name(node: _Element, name: Optional[str] = ...) -> _Element: ...
def add_key_value(node: _Element) -> _Element: ...
def add_reference(
    node: _Element, digest_method: Transform, id: Optional[str] = ..., uri: Optional[str] = ..., type: Optional[str] = ...
) -> _Element: ...
def add_transform(node: _Element, transform: Transform) -> Any: ...
def add_x509_data(node: _Element) -> _Element: ...
def create(node: _Element, c14n_method: Transform, sign_method: Transform) -> _Element: ...
def encrypted_data_create(
    node: _Element,
    method: Transform,
    id: Optional[str] = ...,
    type: Optional[str] = ...,
    mime_type: Optional[str] = ...,
    encoding: Optional[str] = ...,
    ns: Optional[str] = ...,
) -> _Element: ...
def encrypted_data_ensure_cipher_value(node: _Element) -> _Element: ...
def encrypted_data_ensure_key_info(node: _Element, id: Optional[str] = ..., ns: Optional[str] = ...) -> _Element: ...
def ensure_key_info(node: _Element, id: Optional[str] = ...) -> _Element: ...
def transform_add_c14n_inclusive_namespaces(node: _Element, prefixes: Union[str, Sequence[str]]) -> None: ...
def x509_data_add_certificate(node: _Element) -> _Element: ...
def x509_data_add_crl(node: _Element) -> _Element: ...
def x509_data_add_issuer_serial(node: _Element) -> _Element: ...
def x509_data_add_ski(node: _Element) -> _Element: ...
def x509_data_add_subject_name(node: _Element) -> _Element: ...
def x509_issuer_serial_add_issuer_name(node: _Element, name: Optional[str] = ...) -> _Element: ...
def x509_issuer_serial_add_serial_number(node: _Element, serial: Optional[str] = ...) -> _Element: ...
