/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class ElementFilter {
    private static Set<ElementKind> CONSTRUCTOR_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.CONSTRUCTOR));
    private static Set<ElementKind> FIELD_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.FIELD, ElementKind.ENUM_CONSTANT));
    private static Set<ElementKind> METHOD_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.METHOD));
    private static Set<ElementKind> PACKAGE_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.PACKAGE));
    private static Set<ElementKind> TYPE_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE));

    private ElementFilter() {
    }

    public static List<VariableElement> fieldsIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, FIELD_KINDS, VariableElement.class);
    }

    public static Set<VariableElement> fieldsIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, FIELD_KINDS, VariableElement.class);
    }

    public static List<ExecutableElement> constructorsIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, CONSTRUCTOR_KIND, ExecutableElement.class);
    }

    public static Set<ExecutableElement> constructorsIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, CONSTRUCTOR_KIND, ExecutableElement.class);
    }

    public static List<ExecutableElement> methodsIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, METHOD_KIND, ExecutableElement.class);
    }

    public static Set<ExecutableElement> methodsIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, METHOD_KIND, ExecutableElement.class);
    }

    public static List<TypeElement> typesIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, TYPE_KINDS, TypeElement.class);
    }

    public static Set<TypeElement> typesIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, TYPE_KINDS, TypeElement.class);
    }

    public static List<PackageElement> packagesIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, PACKAGE_KIND, PackageElement.class);
    }

    public static Set<PackageElement> packagesIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, PACKAGE_KIND, PackageElement.class);
    }

    private static <E extends Element> List<E> listFilter(Iterable<? extends Element> elements, Set<ElementKind> targetKinds, Class<E> clazz) {
        ArrayList<E> list = new ArrayList<E>();
        for (Element element : elements) {
            if (!targetKinds.contains((Object)element.getKind())) continue;
            list.add(clazz.cast(element));
        }
        return list;
    }

    private static <E extends Element> Set<E> setFilter(Set<? extends Element> elements, Set<ElementKind> targetKinds, Class<E> clazz) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        for (Element element : elements) {
            if (!targetKinds.contains((Object)element.getKind())) continue;
            set.add(clazz.cast(element));
        }
        return set;
    }
}

