/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.ArrayList;
import java.util.List;

public class SmapStratum {
    private String stratumName;
    private List<String> fileNameList;
    private List<String> filePathList;
    private List<LineInfo> lineData;
    private int lastFileID;

    public SmapStratum(String string) {
        this.stratumName = string;
        this.fileNameList = new ArrayList<String>();
        this.filePathList = new ArrayList<String>();
        this.lineData = new ArrayList<LineInfo>();
        this.lastFileID = 0;
    }

    public void addFile(String string) {
        this.addFile(string, string);
    }

    public void addFile(String string, String string2) {
        int n = this.filePathList.indexOf(string2);
        if (n == -1) {
            this.fileNameList.add(string);
            this.filePathList.add(string2);
        }
    }

    public void optimizeLineSection() {
        LineInfo lineInfo;
        LineInfo lineInfo2;
        int n = 0;
        while (n < this.lineData.size() - 1) {
            lineInfo2 = this.lineData.get(n);
            lineInfo = this.lineData.get(n + 1);
            if (!lineInfo.lineFileIDSet && lineInfo.inputStartLine == lineInfo2.inputStartLine && lineInfo.inputLineCount == 1 && lineInfo2.inputLineCount == 1 && lineInfo.outputStartLine == lineInfo2.outputStartLine + lineInfo2.inputLineCount * lineInfo2.outputLineIncrement) {
                lineInfo2.setOutputLineIncrement(lineInfo.outputStartLine - lineInfo2.outputStartLine + lineInfo.outputLineIncrement);
                this.lineData.remove(n + 1);
                continue;
            }
            ++n;
        }
        n = 0;
        while (n < this.lineData.size() - 1) {
            lineInfo2 = this.lineData.get(n);
            lineInfo = this.lineData.get(n + 1);
            if (!lineInfo.lineFileIDSet && lineInfo.inputStartLine == lineInfo2.inputStartLine + lineInfo2.inputLineCount && lineInfo.outputLineIncrement == lineInfo2.outputLineIncrement && lineInfo.outputStartLine == lineInfo2.outputStartLine + lineInfo2.inputLineCount * lineInfo2.outputLineIncrement) {
                lineInfo2.setInputLineCount(lineInfo2.inputLineCount + lineInfo.inputLineCount);
                this.lineData.remove(n + 1);
                continue;
            }
            ++n;
        }
    }

    public void addLineData(int n, String string, int n2, int n3, int n4) {
        int n5 = this.filePathList.indexOf(string);
        if (n5 == -1) {
            throw new IllegalArgumentException("inputFileName: " + string);
        }
        if (n3 == 0) {
            return;
        }
        LineInfo lineInfo = new LineInfo();
        lineInfo.setInputStartLine(n);
        lineInfo.setInputLineCount(n2);
        lineInfo.setOutputStartLine(n3);
        lineInfo.setOutputLineIncrement(n4);
        if (n5 != this.lastFileID) {
            lineInfo.setLineFileID(n5);
        }
        this.lastFileID = n5;
        this.lineData.add(lineInfo);
    }

    public String getStratumName() {
        return this.stratumName;
    }

    public String getString() {
        Object object;
        int n;
        if (this.fileNameList.size() == 0 || this.lineData.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("*S " + this.stratumName + "\n");
        stringBuilder.append("*F\n");
        int n2 = this.fileNameList.size();
        for (n = 0; n < n2; ++n) {
            if (this.filePathList.get(n) != null) {
                stringBuilder.append("+ " + n + " " + this.fileNameList.get(n) + "\n");
                object = this.filePathList.get(n);
                if (((String)object).startsWith("/")) {
                    object = ((String)object).substring(1);
                }
                stringBuilder.append((String)object + "\n");
                continue;
            }
            stringBuilder.append(n + " " + this.fileNameList.get(n) + "\n");
        }
        stringBuilder.append("*L\n");
        n2 = this.lineData.size();
        for (n = 0; n < n2; ++n) {
            object = this.lineData.get(n);
            stringBuilder.append(((LineInfo)object).getString());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getString();
    }

    public static class LineInfo {
        private int inputStartLine = -1;
        private int outputStartLine = -1;
        private int lineFileID = 0;
        private int inputLineCount = 1;
        private int outputLineIncrement = 1;
        private boolean lineFileIDSet = false;

        public void setInputStartLine(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.inputStartLine = n;
        }

        public void setOutputStartLine(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.outputStartLine = n;
        }

        public void setLineFileID(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.lineFileID = n;
            this.lineFileIDSet = true;
        }

        public void setInputLineCount(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.inputLineCount = n;
        }

        public void setOutputLineIncrement(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("" + n);
            }
            this.outputLineIncrement = n;
        }

        public String getString() {
            if (this.inputStartLine == -1 || this.outputStartLine == -1) {
                throw new IllegalStateException();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.inputStartLine);
            if (this.lineFileIDSet) {
                stringBuilder.append("#" + this.lineFileID);
            }
            if (this.inputLineCount != 1) {
                stringBuilder.append("," + this.inputLineCount);
            }
            stringBuilder.append(":" + this.outputStartLine);
            if (this.outputLineIncrement != 1) {
                stringBuilder.append("," + this.outputLineIncrement);
            }
            stringBuilder.append('\n');
            return stringBuilder.toString();
        }

        public String toString() {
            return this.getString();
        }
    }
}

