/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public final class IntrospectionUtils {
    private static final Log log = LogFactory.getLog(IntrospectionUtils.class);
    @Deprecated
    public static final String PATH_SEPARATOR = File.pathSeparator;
    static Hashtable<Class<?>, Method[]> objectMethods = new Hashtable();
    @Deprecated
    private static final Object[] emptyArray = new Object[0];

    @Deprecated
    public static void execute(Object object, String string) throws Exception {
        Class[] classArray;
        Method method = null;
        Class<?> clazz = object.getClass();
        method = IntrospectionUtils.findMethod(clazz, string, classArray = new Class[0]);
        if (method == null) {
            throw new RuntimeException("No execute in " + object.getClass());
        }
        method.invoke(object, (Object[])null);
    }

    @Deprecated
    public static void setAttribute(Object object, String string, Object object2) throws Exception {
        if (object instanceof AttributeHolder) {
            ((AttributeHolder)object).setAttribute(string, object2);
            return;
        }
        Method method = null;
        Class<?> clazz = object.getClass();
        Class[] classArray = new Class[]{String.class, Object.class};
        method = IntrospectionUtils.findMethod(clazz, "setAttribute", classArray);
        if (method == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No setAttribute in " + object.getClass()));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting " + string + "=" + object2 + "  in " + object));
        }
        method.invoke(object, string, object2);
    }

    @Deprecated
    public static Object getAttribute(Object object, String string) throws Exception {
        Method method = null;
        Class<?> clazz = object.getClass();
        Class[] classArray = new Class[]{String.class};
        method = IntrospectionUtils.findMethod(clazz, "getAttribute", classArray);
        if (method == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No getAttribute in " + object.getClass()));
            }
            return null;
        }
        return method.invoke(object, string);
    }

    @Deprecated
    public static ClassLoader getURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName("java.net.URLClassLoader");
            Class[] classArray = new Class[]{uRLArray.getClass(), ClassLoader.class};
            Method method = IntrospectionUtils.findMethod(clazz, "newInstance", classArray);
            if (method == null) {
                return null;
            }
            ClassLoader classLoader2 = (ClassLoader)method.invoke(clazz, uRLArray, classLoader);
            return classLoader2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static String guessInstall(String string, String string2, String string3) {
        return IntrospectionUtils.guessInstall(string, string2, string3, null);
    }

    @Deprecated
    public static String guessInstall(String string, String string2, String string3, String string4) {
        String string5 = null;
        String string6 = null;
        if (string != null) {
            string5 = System.getProperty(string);
        }
        if (string2 != null) {
            string6 = System.getProperty(string2);
        }
        if (string5 != null) {
            if (string6 == null) {
                System.getProperties().put(string2, string5);
            }
            return string5;
        }
        String string7 = System.getProperty("java.class.path");
        String string8 = File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(string7, string8);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string9 = stringTokenizer.nextToken();
            if (string9.endsWith(string3)) {
                string6 = string9.substring(0, string9.length() - string3.length());
                try {
                    if ("".equals(string6)) {
                        string6 = new File("./").getCanonicalPath();
                    } else if (string6.endsWith(File.separator)) {
                        string6 = string6.substring(0, string6.length() - 1);
                    }
                    object = new File(string6);
                    String string10 = ((File)object).getParent();
                    if (string10 == null) {
                        string10 = string6;
                    }
                    File file = new File(string10);
                    string5 = file.getCanonicalPath();
                    if (string != null) {
                        System.getProperties().put(string, string5);
                    }
                    if (string2 != null) {
                        System.getProperties().put(string2, string5);
                    }
                    return string5;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
            }
            object = string9 + (string9.endsWith("/") ? "" : "/") + string4;
            if (!new File((String)object).exists()) continue;
            try {
                File file = new File(string9);
                String string11 = file.getParent();
                if (string11 == null) {
                    string11 = string9;
                }
                File file2 = new File(string11);
                string5 = file2.getCanonicalPath();
                if (string != null) {
                    System.getProperties().put(string, string5);
                }
                if (string6 == null && string2 != null) {
                    System.getProperties().put(string2, string5);
                }
                return string5;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string6 != null) {
            System.getProperties().put(string, string6);
            return string6;
        }
        return null;
    }

    @Deprecated
    public static void displayClassPath(String string, URL[] uRLArray) {
        if (log.isDebugEnabled()) {
            log.debug((Object)string);
            for (int i = 0; i < uRLArray.length; ++i) {
                log.debug((Object)uRLArray[i].getFile());
            }
        }
    }

    @Deprecated
    public static String classPathAdd(URL[] uRLArray, String string) {
        if (uRLArray == null) {
            return string;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            string = string != null ? string + PATH_SEPARATOR + uRLArray[i].getFile() : uRLArray[i].getFile();
        }
        return string;
    }

    public static boolean setProperty(Object object, String string, String string2) {
        return IntrospectionUtils.setProperty(object, string, string2, true);
    }

    public static boolean setProperty(Object object, String string, String string2, boolean bl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: setProperty(" + object.getClass() + " " + string + "=" + string2 + ")"));
        }
        String string3 = "set" + IntrospectionUtils.capitalize(string);
        try {
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            Method method = null;
            Method method2 = null;
            for (Method method3 : methodArray) {
                Class<?>[] classArray = method3.getParameterTypes();
                if (!string3.equals(method3.getName()) || classArray.length != 1 || !"java.lang.String".equals(classArray[0].getName())) continue;
                method3.invoke(object, string2);
                return true;
            }
            for (Method method3 : methodArray) {
                boolean bl2 = true;
                if (string3.equals(method3.getName()) && method3.getParameterTypes().length == 1) {
                    Class<?> clazz = method3.getParameterTypes()[0];
                    Object[] objectArray = new Object[1];
                    if ("java.lang.Integer".equals(clazz.getName()) || "int".equals(clazz.getName())) {
                        try {
                            objectArray[0] = Integer.valueOf(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = false;
                        }
                    } else if ("java.lang.Long".equals(clazz.getName()) || "long".equals(clazz.getName())) {
                        try {
                            objectArray[0] = Long.valueOf(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = false;
                        }
                    } else if ("java.lang.Boolean".equals(clazz.getName()) || "boolean".equals(clazz.getName())) {
                        objectArray[0] = Boolean.valueOf(string2);
                    } else if ("java.net.InetAddress".equals(clazz.getName())) {
                        try {
                            objectArray[0] = InetAddress.getByName(string2);
                        }
                        catch (UnknownHostException unknownHostException) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("IntrospectionUtils: Unable to resolve host name:" + string2));
                            }
                            bl2 = false;
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("IntrospectionUtils: Unknown type " + clazz.getName()));
                    }
                    if (bl2) {
                        method3.invoke(object, objectArray);
                        return true;
                    }
                }
                if (!"setProperty".equals(method3.getName())) continue;
                if (method3.getReturnType() == Boolean.TYPE) {
                    method2 = method3;
                    continue;
                }
                method = method3;
            }
            if (bl && (method2 != null || method != null)) {
                Object[] objectArray = new Object[]{string, string2};
                if (method2 != null) {
                    try {
                        return (Boolean)method2.invoke(object, objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (method != null) {
                            method.invoke(object, objectArray);
                            return true;
                        }
                        throw illegalArgumentException;
                    }
                }
                method.invoke(object, objectArray);
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn((Object)("IAE " + object + " " + string + " " + string2), (Throwable)illegalArgumentException);
        }
        catch (SecurityException securityException) {
            log.warn((Object)("IntrospectionUtils: SecurityException for " + object.getClass() + " " + string + "=" + string2 + ")"), (Throwable)securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)("IntrospectionUtils: IllegalAccessException for " + object.getClass() + " " + string + "=" + string2 + ")"), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            log.warn((Object)("IntrospectionUtils: InvocationTargetException for " + object.getClass() + " " + string + "=" + string2 + ")"), (Throwable)invocationTargetException);
        }
        return false;
    }

    public static Object getProperty(Object object, String string) {
        String string2 = "get" + IntrospectionUtils.capitalize(string);
        String string3 = "is" + IntrospectionUtils.capitalize(string);
        try {
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            Method method = null;
            for (Method method2 : methodArray) {
                Class<?>[] classArray = method2.getParameterTypes();
                if (string2.equals(method2.getName()) && classArray.length == 0) {
                    return method2.invoke(object, (Object[])null);
                }
                if (string3.equals(method2.getName()) && classArray.length == 0) {
                    return method2.invoke(object, (Object[])null);
                }
                if (!"getProperty".equals(method2.getName())) continue;
                method = method2;
            }
            if (method != null) {
                Object[] objectArray = new Object[]{string};
                return method.invoke(object, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn((Object)("IAE " + object + " " + string), (Throwable)illegalArgumentException);
        }
        catch (SecurityException securityException) {
            log.warn((Object)("IntrospectionUtils: SecurityException for " + object.getClass() + " " + string + ")"), (Throwable)securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)("IntrospectionUtils: IllegalAccessException for " + object.getClass() + " " + string + ")"), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            log.warn((Object)("IntrospectionUtils: InvocationTargetException for " + object.getClass() + " " + string + ")"), (Throwable)invocationTargetException);
        }
        return null;
    }

    @Deprecated
    public static void setProperty(Object object, String string) {
        block3: {
            String string2 = "set" + IntrospectionUtils.capitalize(string);
            try {
                Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
                for (int i = 0; i < methodArray.length; ++i) {
                    Class<?>[] classArray = methodArray[i].getParameterTypes();
                    if (!string2.equals(methodArray[i].getName()) || classArray.length != 0) continue;
                    methodArray[i].invoke(object, new Object[0]);
                    return;
                }
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("IntrospectionUtils: Exception for " + object.getClass() + " " + string), (Throwable)exception);
            }
        }
    }

    @Deprecated
    public static String replaceProperties(String string, Hashtable<Object, Object> hashtable, PropertySource[] propertySourceArray) {
        return IntrospectionUtils.replaceProperties(string, hashtable, propertySourceArray, null);
    }

    public static String replaceProperties(String string, Hashtable<Object, Object> hashtable, PropertySource[] propertySourceArray, ClassLoader classLoader) {
        int n;
        if (string.indexOf(36) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while ((n = string.indexOf(36, n2)) >= 0) {
            if (n > 0) {
                stringBuilder.append(string.substring(n2, n));
            }
            if (n == string.length() - 1) {
                stringBuilder.append('$');
                n2 = n + 1;
                continue;
            }
            if (string.charAt(n + 1) != '{') {
                stringBuilder.append('$');
                n2 = n + 1;
                continue;
            }
            int n3 = string.indexOf(125, n);
            if (n3 < 0) {
                stringBuilder.append(string.substring(n));
                n2 = string.length();
                continue;
            }
            String string2 = string.substring(n + 2, n3);
            String string3 = IntrospectionUtils.getProperty(string2, hashtable, propertySourceArray, classLoader);
            if (string3 == null) {
                int n4 = string2.indexOf(":-");
                if (n4 != -1) {
                    String string4 = string2.substring(n4 + 2);
                    string3 = IntrospectionUtils.getProperty(string2 = string2.substring(0, n4), hashtable, propertySourceArray, classLoader);
                    if (string3 == null) {
                        string3 = string4;
                    }
                } else {
                    string3 = "${" + string2 + "}";
                }
            }
            stringBuilder.append(string3);
            n2 = n3 + 1;
        }
        if (n2 < string.length()) {
            stringBuilder.append(string.substring(n2));
        }
        return stringBuilder.toString();
    }

    private static String getProperty(String string, Hashtable<Object, Object> hashtable, PropertySource[] propertySourceArray, ClassLoader classLoader) {
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get(string);
        }
        if (string2 == null && propertySourceArray != null) {
            PropertySource propertySource;
            PropertySource[] propertySourceArray2 = propertySourceArray;
            int n = propertySourceArray2.length;
            for (int i = 0; i < n && (string2 = (propertySource = propertySourceArray2[i]) instanceof SecurePropertySource ? ((SecurePropertySource)propertySource).getProperty(string, classLoader) : propertySource.getProperty(string)) == null; ++i) {
            }
        }
        return string2;
    }

    public static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    @Deprecated
    public static String unCapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    @Deprecated
    public static void addToClassPath(Vector<URL> vector, String string) {
        try {
            String[] stringArray = IntrospectionUtils.getFilesByExt(string, ".jar");
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    URL uRL = IntrospectionUtils.getURL(string, stringArray[i]);
                    if (uRL == null) continue;
                    vector.addElement(uRL);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Deprecated
    public static void addToolsJar(Vector<URL> vector) {
        try {
            File file = new File(System.getProperty("java.home") + "/../lib/tools.jar");
            if (!file.exists() && (file = new File(System.getProperty("java.home") + "/lib/tools.jar")).exists() && log.isDebugEnabled()) {
                log.debug((Object)("Detected strange java.home value " + System.getProperty("java.home") + ", it should point to jre"));
            }
            URL uRL = new URL("file", "", file.getAbsolutePath());
            vector.addElement(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    @Deprecated
    public static String[] getFilesByExt(String string, String string2) {
        File file = new File(string);
        String[] stringArray = null;
        final String string3 = string2;
        if (file.isDirectory()) {
            stringArray = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(string3);
                }
            });
        }
        return stringArray;
    }

    @Deprecated
    public static URL getURL(String string, String string2) {
        try {
            File file = new File(string);
            File file2 = new File(file, string2);
            String string3 = file2.getCanonicalPath();
            if (file2.isDirectory()) {
                string3 = string3 + "/";
            }
            if (!file2.exists()) {
                return null;
            }
            return new URL("file", "", string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static void addJarsFromClassPath(Vector<URL> vector, String string) throws IOException, MalformedURLException {
        String string2 = File.pathSeparator;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                URL uRL;
                File file = new File(stringTokenizer.nextToken());
                String string3 = file.getCanonicalPath();
                if (file.isDirectory()) {
                    string3 = string3 + "/";
                }
                if (vector.contains(uRL = new URL("file", "", string3))) continue;
                vector.addElement(uRL);
            }
        }
    }

    @Deprecated
    public static URL[] getClassPath(Vector<URL> vector) {
        URL[] uRLArray = new URL[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            uRLArray[i] = vector.elementAt(i);
        }
        return uRLArray;
    }

    @Deprecated
    public static URL[] getClassPath(String string, String string2, String string3, boolean bl) throws IOException, MalformedURLException {
        Object object;
        Vector<URL> vector = new Vector<URL>();
        if (string != null) {
            object = IntrospectionUtils.getURL(string, "classes");
            if (object != null) {
                vector.addElement((URL)object);
            }
            IntrospectionUtils.addToClassPath(vector, string);
        }
        if (string2 != null) {
            IntrospectionUtils.addJarsFromClassPath(vector, string2);
        }
        if (string3 != null) {
            object = System.getProperty(string3);
            IntrospectionUtils.addJarsFromClassPath(vector, (String)object);
        }
        if (bl) {
            IntrospectionUtils.addToolsJar(vector);
        }
        return IntrospectionUtils.getClassPath(vector);
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static Method[] findMethods(Class<?> clazz) {
        Method[] methodArray = objectMethods.get(clazz);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = clazz.getMethods();
        objectMethods.put(clazz, methodArray);
        return methodArray;
    }

    public static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        Method[] methodArray;
        for (Method method : methodArray = IntrospectionUtils.findMethods(clazz)) {
            if (!method.getName().equals(string)) continue;
            Class<?>[] classArray2 = method.getParameterTypes();
            if (classArray == null && classArray2.length == 0) {
                return method;
            }
            if (classArray.length != classArray2.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == classArray2[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return method;
        }
        return null;
    }

    @Deprecated
    public static boolean hasHook(Object object, String string) {
        try {
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?> clazz;
                Class<?> clazz2;
                if (!string.equals(methodArray[i].getName()) || "java.lang.Object".equals((clazz2 = (clazz = methodArray[i].getDeclaringClass()).getSuperclass()).getName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Deprecated
    public static void callMain(Class<?> clazz, String[] stringArray) throws Exception {
        Class[] classArray = new Class[]{stringArray.getClass()};
        Method method = clazz.getMethod("main", classArray);
        method.invoke(clazz, new Object[]{stringArray});
    }

    public static Object callMethod1(Object object, String string, Object object2, String string2, ClassLoader classLoader) throws Exception {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException("IntrospectionUtils: Assert: Illegal params " + object + " " + object2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: callMethod1 " + object.getClass().getName() + " " + object2.getClass().getName() + " " + string2));
        }
        Class[] classArray = new Class[]{string2 == null ? object2.getClass() : classLoader.loadClass(string2)};
        Method method = IntrospectionUtils.findMethod(object.getClass(), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(object.getClass().getName() + " " + string);
        }
        try {
            return method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            throw invocationTargetException;
        }
    }

    @Deprecated
    public static Object callMethod0(Object object, String string) throws Exception {
        if (object == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IntrospectionUtils: Assert: Illegal params " + object));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: callMethod0 " + object.getClass().getName() + "." + string));
        }
        Class[] classArray = new Class[]{};
        Method method = IntrospectionUtils.findMethod(object.getClass(), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(object.getClass().getName() + " " + string);
        }
        try {
            return method.invoke(object, emptyArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            throw invocationTargetException;
        }
    }

    public static Object callMethodN(Object object, String string, Object[] objectArray, Class<?>[] classArray) throws Exception {
        Method method = null;
        method = IntrospectionUtils.findMethod(object.getClass(), string, classArray);
        if (method == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IntrospectionUtils: Can't find method " + string + " in " + object + " CLASS " + object.getClass()));
            }
            return null;
        }
        try {
            Object object2 = method.invoke(object, objectArray);
            if (log.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(object.getClass().getName()).append('.').append(string).append("( ");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(objectArray[i]);
                }
                stringBuilder.append(")");
                log.debug((Object)("IntrospectionUtils:" + stringBuilder.toString()));
            }
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            throw invocationTargetException;
        }
    }

    public static Object convert(String string, Class<?> clazz) {
        Object object = null;
        if ("java.lang.String".equals(clazz.getName())) {
            object = string;
        } else if ("java.lang.Integer".equals(clazz.getName()) || "int".equals(clazz.getName())) {
            try {
                object = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("java.lang.Boolean".equals(clazz.getName()) || "boolean".equals(clazz.getName())) {
            object = Boolean.valueOf(string);
        } else if ("java.net.InetAddress".equals(clazz.getName())) {
            try {
                object = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IntrospectionUtils: Unable to resolve host name:" + string));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: Unknown type " + clazz.getName()));
        }
        if (object == null) {
            throw new IllegalArgumentException("Can't convert argument: " + string);
        }
        return object;
    }

    public static boolean isInstance(Class<?> clazz, String string) {
        Class<?>[] classArray;
        if (string.equals(clazz.getName())) {
            return true;
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!IntrospectionUtils.isInstance(clazz2, string)) continue;
            return true;
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        return IntrospectionUtils.isInstance(clazz3, string);
    }

    @Deprecated
    public static interface AttributeHolder {
        public void setAttribute(String var1, Object var2);
    }

    public static interface SecurePropertySource
    extends PropertySource {
        public String getProperty(String var1, ClassLoader var2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

