/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

public class SynchronizedStack<T> {
    public static final int DEFAULT_SIZE = 128;
    private static final int DEFAULT_LIMIT = -1;
    private int size;
    private final int limit;
    private int index = -1;
    private Object[] stack;

    public SynchronizedStack() {
        this(128, -1);
    }

    public SynchronizedStack(int n, int n2) {
        this.size = n2 > -1 && n > n2 ? n2 : n;
        this.limit = n2;
        this.stack = new Object[n];
    }

    public synchronized boolean push(T t) {
        ++this.index;
        if (this.index == this.size) {
            if (this.limit == -1 || this.size < this.limit) {
                this.expand();
            } else {
                --this.index;
                return false;
            }
        }
        this.stack[this.index] = t;
        return true;
    }

    public synchronized T pop() {
        if (this.index == -1) {
            return null;
        }
        Object object = this.stack[this.index];
        this.stack[this.index--] = null;
        return (T)object;
    }

    public synchronized void clear() {
        if (this.index > -1) {
            for (int i = 0; i < this.index + 1; ++i) {
                this.stack[i] = null;
            }
        }
        this.index = -1;
    }

    private void expand() {
        int n = this.size * 2;
        if (this.limit != -1 && n > this.limit) {
            n = this.limit;
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.stack, 0, objectArray, 0, this.size);
        this.stack = objectArray;
        this.size = n;
    }
}

