/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.DataTransferSupport;
import org.openide.loaders.FolderChildren;
import org.openide.loaders.FolderComparator;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.loaders.FolderRenameHandler;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.SortModeEditor;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class DataFolder
extends MultiDataObject
implements DataObject.Container {
    static final long serialVersionUID = -8244904281845488751L;
    public static final String PROP_CHILDREN = "children";
    public static final String PROP_SORT_MODE = "sortMode";
    static final String EA_SORT_MODE = "OpenIDE-Folder-SortMode";
    static final String EA_ORDER = "OpenIDE-Folder-Order";
    public static final String PROP_ORDER = "order";
    public static final String SET_SORTING = "sorting";
    private static final String FOLDER_ICON_BASE = "org/openide/loaders/defaultFolder.gif";
    private static final String ROOT_SHADOW_NAME = "Root";
    private static DataFlavor uriListDataFlavor;
    private FolderList list;
    private PropertyChangeListener pcl;
    private DataTransferSupport dataTransferSupport = new Paste();
    private static final ThreadLocal<boolean[]> KEEP_ALIVE;
    private static Image[] IMGS;

    @Deprecated
    public DataFolder(FileObject fileObject) throws DataObjectExistsException, IllegalArgumentException {
        this(fileObject, DataLoaderPool.getFolderLoader());
    }

    protected DataFolder(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException, IllegalArgumentException {
        this(fileObject, multiFileLoader, true);
    }

    @Deprecated
    protected DataFolder(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException, IllegalArgumentException {
        super(fileObject, dataLoader);
        this.init(fileObject, true);
    }

    private DataFolder(FileObject fileObject, MultiFileLoader multiFileLoader, boolean bl) throws DataObjectExistsException, IllegalArgumentException {
        super(fileObject, multiFileLoader);
        this.init(fileObject, bl);
    }

    private void init(FileObject fileObject, boolean bl) throws IllegalArgumentException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Not folder: " + fileObject);
        }
        this.list = this.reassignList(fileObject, bl);
    }

    private FolderList reassignList(FileObject fileObject, boolean bl) {
        FolderList folderList = FolderList.find(fileObject, true);
        if (bl) {
            this.pcl = new ListPCL();
            folderList.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)folderList));
        }
        return folderList;
    }

    public static DataFolder create(DataFolder dataFolder, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (DataFolder.confirmName(string2)) continue;
            throw new IOException(NbBundle.getMessage(DataFolder.class, (String)"EXC_WrongName", (Object)string2));
        }
        return DataFolder.findFolder(FileUtil.createFolder((FileObject)dataFolder.getPrimaryFile(), (String)string));
    }

    public final synchronized void setSortMode(SortMode sortMode) throws IOException {
        SortMode sortMode2 = this.getOrder().getSortMode();
        this.getOrder().setSortMode(sortMode);
        this.firePropertyChange(PROP_SORT_MODE, sortMode2, this.getOrder().getSortMode());
    }

    public final SortMode getSortMode() {
        return this.getOrder().getSortMode();
    }

    public final synchronized void setOrder(DataObject[] dataObjectArray) throws IOException {
        this.getOrder().setOrder(dataObjectArray);
        this.firePropertyChange(PROP_ORDER, null, null);
    }

    private FolderOrder getOrder() {
        return FolderOrder.findFor(this.getPrimaryFile());
    }

    @Override
    public Lookup getLookup() {
        if (DataFolder.class == this.getClass()) {
            return this.getCookieSet().getLookup();
        }
        return super.getLookup();
    }

    @Override
    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    @Override
    public DataObject[] getChildren() {
        return this.list.getChildren();
    }

    final List<DataObject> getChildrenList() {
        return this.list.getChildrenList();
    }

    final RequestProcessor.Task computeChildrenList(FolderListListener folderListListener) {
        return this.list.computeChildrenList(folderListListener);
    }

    public Enumeration<DataObject> children() {
        return Collections.enumeration(this.getChildrenList());
    }

    public Enumeration<DataObject> children(final boolean bl) {
        if (!bl) {
            return this.children();
        }
        class Processor
        implements Enumerations.Processor<DataObject, DataObject> {
            Processor() {
            }

            public DataObject process(DataObject dataObject, Collection<DataObject> collection) {
                if (bl && dataObject instanceof DataFolder) {
                    collection.addAll(Arrays.asList(((DataFolder)dataObject).getChildren()));
                }
                return dataObject;
            }
        }
        Enumeration enumeration = Enumerations.queue((Enumeration)Enumerations.array((Object[])this.getChildren()), (Enumerations.Processor)new Processor());
        return enumeration;
    }

    @Override
    protected synchronized Node createNodeDelegate() {
        return new FolderNode();
    }

    @Override
    Node getClonedNodeDelegate(DataFilter dataFilter) {
        Node node = this.getNodeDelegate();
        Children children = node.getChildren();
        if (children.getClass() == FolderChildren.class) {
            DataFilter dataFilter2 = ((FolderChildren)children).getFilter();
            if (dataFilter2 == DataFilter.ALL) {
                return new ClonedFilter(node, dataFilter);
            }
            if (dataFilter != DataFilter.ALL && dataFilter != dataFilter2) {
                return new ClonedFilter(node, DataFolder.filterCompose(dataFilter2, dataFilter));
            }
            return node.cloneNode();
        }
        return node.cloneNode();
    }

    private static DataFilter filterCompose(final DataFilter dataFilter, final DataFilter dataFilter2) {
        if (dataFilter.equals(dataFilter2)) {
            return dataFilter;
        }
        return new DataFilter(){

            @Override
            public boolean acceptDataObject(DataObject dataObject) {
                return dataFilter.acceptDataObject(dataObject) && dataFilter2.acceptDataObject(dataObject);
            }
        };
    }

    static Children createNodeChildren(DataFolder dataFolder, DataFilter dataFilter) {
        return new FolderChildren(dataFolder, dataFilter);
    }

    public Children createNodeChildren(DataFilter dataFilter) {
        return DataFolder.createNodeChildren(this, dataFilter);
    }

    @Override
    public boolean isDeleteAllowed() {
        return this.isRenameAllowed();
    }

    @Override
    public boolean isCopyAllowed() {
        return true;
    }

    @Override
    public boolean isMoveAllowed() {
        return this.isRenameAllowed();
    }

    @Override
    public boolean isRenameAllowed() {
        FileObject fileObject = this.getPrimaryFile();
        return !fileObject.isRoot() && fileObject.canWrite();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return null;
    }

    public static DataFolder findFolder(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find(fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new IllegalArgumentException(dataObjectNotFoundException);
        }
        if (!(dataObject instanceof DataFolder)) {
            throw new IllegalArgumentException("Not a DataFolder: " + fileObject + " (was a " + dataObject.getClass().getName() + ") (file is folder? " + fileObject.isFolder() + ")");
        }
        return (DataFolder)dataObject;
    }

    public static DataObject.Container findContainer(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return FolderList.find(fileObject, true);
        }
        throw new IllegalArgumentException("Not a folder: " + fileObject);
    }

    @Override
    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        DataFolder dataFolder2;
        DataFolder.testNesting(this, dataFolder);
        Enumeration<DataObject> enumeration = this.children();
        DataObject dataObject = super.handleCopy(dataFolder);
        if (dataObject instanceof DataFolder) {
            dataFolder2 = (DataFolder)dataObject;
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_FMT_FileExists", (Object)this.getName(), (Object)dataFolder.getName()), 2));
            return dataObject;
        }
        while (enumeration.hasMoreElements()) {
            try {
                DataObject dataObject2 = enumeration.nextElement();
                if (dataObject2.isCopyAllowed()) {
                    dataObject2.copy(dataFolder2);
                    continue;
                }
                DataObject.LOG.warning(NbBundle.getMessage(DataFolder.class, (String)"FMT_CannotCopyDo", (Object)dataObject2.getName()));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return dataFolder2;
    }

    static void testNesting(DataFolder dataFolder, DataFolder dataFolder2) throws IOException {
        if (dataFolder2.equals(dataFolder)) {
            IOException iOException = new IOException("Error Copying File or Folder");
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(DataFolder.class, (String)"EXC_CannotCopyTheSame", (Object)dataFolder.getName()));
            throw iOException;
        }
        for (DataFolder dataFolder3 = dataFolder2.getFolder(); dataFolder3 != null; dataFolder3 = dataFolder3.getFolder()) {
            if (!dataFolder3.equals(dataFolder)) continue;
            IOException iOException = new IOException("Error copying file or folder: " + dataFolder.getPrimaryFile() + " cannot be copied to its subfolder " + dataFolder2.getPrimaryFile());
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(DataFolder.class, (String)"EXC_CannotCopySubfolder", (Object)dataFolder.getName()));
            throw iOException;
        }
    }

    @Override
    protected void handleDelete() throws IOException {
        Enumeration<DataObject> enumeration = this.children();
        FileLock fileLock = null;
        try {
            fileLock = DataFolder.createLightWeightLock(this);
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = enumeration.nextElement();
                if (!dataObject.isValid()) continue;
                dataObject.delete();
            }
        }
        catch (IOException iOException) {
            FileObject fileObject = this.getPrimaryFile();
            String string = NbBundle.getMessage(DataFolder.class, (String)"EXC_CannotDelete2", (Object)FileUtil.getFileDisplayName((FileObject)fileObject));
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        if (!DataObject.isCurrentActionTerminated()) {
            super.handleDelete();
        }
    }

    private static FileLock createLightWeightLock(DataFolder dataFolder) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        assert (fileObject != null);
        Object object = fileObject.getAttribute("LIGHTWEIGHT_LOCK_SET");
        assert (object == null || object instanceof FileLock) : fileObject.toString();
        return (FileLock)object;
    }

    @Override
    protected FileObject handleRename(String string) throws IOException {
        if (!DataFolder.confirmName(string)) {
            IOException iOException = new IOException("bad name: " + string);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(DataFolder.class, (String)"EXC_WrongName", (Object)string));
            throw iOException;
        }
        return super.handleRename(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        FileObject fileObject = this.getPrimaryFile();
        FileLock fileLock = fileObject.lock();
        List<MultiDataObject.Pair> list = this.saveEntries();
        boolean bl = false;
        try {
            Object object;
            Object object2;
            FileObject fileObject2 = super.handleMove(dataFolder);
            DataFolder dataFolder2 = null;
            boolean bl2 = false;
            boolean[] blArray = KEEP_ALIVE.get();
            if (blArray == null) {
                blArray = new boolean[]{false};
                KEEP_ALIVE.set(blArray);
            }
            for (int i = 20; i >= 0; --i) {
                try {
                    object2 = this.getMultiFileLoader();
                    assert (object2 instanceof DataLoaderPool.FolderLoader) : "This has to be FolderLoader: " + object2 + " for " + this.getPrimaryFile();
                    object = (DataLoaderPool.FolderLoader)object2;
                    dataFolder2 = (DataFolder)DataObjectPool.createMultiObject((DataLoaderPool.FolderLoader)object, fileObject2, this);
                    bl2 = false;
                    break;
                }
                catch (DataObjectExistsException dataObjectExistsException) {
                    dataFolder2 = (DataFolder)dataObjectExistsException.getDataObject();
                    dataFolder2.dispose();
                    bl2 = true;
                    continue;
                }
            }
            object2 = this.children();
            while (object2.hasMoreElements()) {
                try {
                    object = (DataObject)object2.nextElement();
                    if (((DataObject)object).isMoveAllowed()) {
                        ((DataObject)object).move(dataFolder2);
                        continue;
                    }
                    blArray[0] = true;
                    DataObject.LOG.warning(NbBundle.getMessage(DataFolder.class, (String)"FMT_CannotMoveDo", (Object)((DataObject)object).getName()));
                }
                catch (IOException iOException) {
                    blArray[0] = true;
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (blArray[0]) {
                this.restoreEntries(list);
                this.list.refresh();
                assert (dataFolder2.getClass().getName().indexOf("NodeSharingDataFolder") >= 0);
                dataFolder2.dispose();
                object = fileObject;
                return object;
            }
            try {
                if (!DataObject.isCurrentActionTerminated()) {
                    fileObject.delete(fileLock);
                }
            }
            catch (IOException iOException) {
                Throwable throwable = Exceptions.attachLocalizedMessage((Throwable)iOException, (String)DataObject.getString("EXC_folder_delete_failed"));
                Exceptions.printStackTrace((Throwable)throwable);
            }
            if (bl2) {
                try {
                    this.setValid(false);
                    fileObject2 = fileObject;
                }
                catch (PropertyVetoException propertyVetoException) {
                    this.restoreEntries(list);
                    fileObject2 = this.getPrimaryEntry().getFile();
                }
            } else {
                this.changeItemByFolder(this.item().changePrimaryFile(fileObject2));
                dataFolder2.dispose();
                this.list = this.reassignList(fileObject2, true);
            }
            object = fileObject2;
            return object;
        }
        finally {
            if (bl) {
                KEEP_ALIVE.remove();
            }
            fileLock.releaseLock();
        }
    }

    @Override
    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        DataFolder dataFolder2 = (DataFolder)super.handleCreateFromTemplate(dataFolder, string);
        Enumeration<DataObject> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            try {
                DataObject dataObject = enumeration.nextElement();
                dataObject.createFromTemplate(dataFolder2);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return dataFolder2;
    }

    @Override
    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        DataFolder.testNesting(this, dataFolder);
        String string = this.getPrimaryFile().isRoot() ? FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)ROOT_SHADOW_NAME, (String)"shadow") : null;
        return DataShadow.create(dataFolder, string, this);
    }

    @Override
    boolean isMergingFolders(FileObject fileObject, FileObject fileObject2) {
        return !fileObject2.equals(fileObject.getParent());
    }

    private static boolean confirmName(String string) {
        return string.indexOf(47) == -1 && string.indexOf(92) == -1;
    }

    private static Image icon2image(String string) {
        Object object = UIManager.get(string);
        if (object instanceof Image) {
            return (Image)object;
        }
        if (object instanceof Icon) {
            Icon icon = (Icon)object;
            return ImageUtilities.icon2Image((Icon)icon);
        }
        return null;
    }

    static Image findIcon(int n, String string, String string2) {
        if (IMGS[n] != null) {
            return IMGS[n];
        }
        Image image = DataFolder.icon2image(string);
        if (image == null) {
            image = DataFolder.icon2image(string2);
        }
        DataFolder.IMGS[n] = image;
        return image;
    }

    static {
        KEEP_ALIVE = new ThreadLocal();
        IMGS = new Image[2];
    }

    private final class ListPCL
    implements PropertyChangeListener {
        ListPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this == DataFolder.this.pcl && !"refresh".equals(propertyChangeEvent.getPropertyName())) {
                DataFolder.this.firePropertyChange(DataFolder.PROP_CHILDREN, null, null);
            }
        }
    }

    private class Paste
    extends DataTransferSupport {
        Paste() {
        }

        @Override
        protected DataTransferSupport.PasteTypeExt[] definePasteTypes(int n) {
            switch (n) {
                case 4: {
                    return new DataTransferSupport.PasteTypeExt[]{new DataTransferSupport.PasteTypeExt(){

                        public String getName() {
                            return DataObject.getString("PT_move");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx(Paste.class.getName() + ".move");
                        }

                        @Override
                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isMoveAllowed() && !this.isParent(DataFolder.this.getPrimaryFile(), dataObject.getPrimaryFile());
                        }

                        @Override
                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.move(DataFolder.this);
                        }

                        @Override
                        protected boolean cleanClipboard() {
                            return true;
                        }

                        private boolean isParent(FileObject fileObject, FileObject fileObject2) {
                            File file = FileUtil.toFile((FileObject)fileObject2);
                            File file2 = FileUtil.toFile((FileObject)fileObject);
                            if (file2 != null && file != null) {
                                return Paste.this.isParentFile(file2, file);
                            }
                            try {
                                if (fileObject.getFileSystem() != fileObject2.getFileSystem()) {
                                    return false;
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            while (fileObject != null) {
                                if (fileObject.equals(fileObject2)) {
                                    return true;
                                }
                                fileObject = fileObject.getParent();
                            }
                            return false;
                        }
                    }};
                }
                case 1: {
                    return new DataTransferSupport.PasteTypeExt[]{new DataTransferSupport.PasteTypeExt(){

                        public String getName() {
                            return DataObject.getString("PT_copy");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx(Paste.class.getName() + ".copy");
                        }

                        @Override
                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isCopyAllowed();
                        }

                        @Override
                        protected void handlePaste(DataObject dataObject) throws IOException {
                            this.saveIfModified(dataObject);
                            dataObject.copy(DataFolder.this);
                        }

                        private void saveIfModified(DataObject dataObject) throws IOException {
                            SaveCookie saveCookie;
                            if (dataObject.isModified() && (saveCookie = dataObject.getCookie(SaveCookie.class)) != null) {
                                saveCookie.save();
                            }
                        }
                    }, new DataTransferSupport.PasteTypeExt(){

                        public String getName() {
                            return DataObject.getString("PT_instantiate");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx(Paste.class.getName() + ".instantiate");
                        }

                        @Override
                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isTemplate();
                        }

                        @Override
                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.createFromTemplate(DataFolder.this);
                        }
                    }, new DataTransferSupport.PasteTypeExt(){

                        public String getName() {
                            return DataObject.getString("PT_shadow");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx(Paste.class.getName() + ".shadow");
                        }

                        @Override
                        protected boolean handleCanPaste(DataObject dataObject) {
                            try {
                                if (!DataFolder.this.getPrimaryFile().getFileSystem().isDefault()) {
                                    return false;
                                }
                            }
                            catch (FileStateInvalidException fileStateInvalidException) {
                                return false;
                            }
                            return dataObject.isShadowAllowed();
                        }

                        @Override
                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.createShadow(DataFolder.this);
                        }
                    }};
                }
            }
            return new DataTransferSupport.PasteTypeExt[0];
        }

        private boolean isParentFile(File file, File file2) {
            boolean bl = false;
            while (file != null) {
                if (file.equals(file2)) {
                    bl = true;
                    break;
                }
                file = file.getParentFile();
            }
            return bl;
        }

        @Override
        protected int[] defineOperations() {
            return new int[]{4, 1};
        }

        @Override
        protected void handleCreatePasteTypes(Transferable transferable, List<PasteType> list) {
            Node node = NodeTransfer.node((Transferable)transferable, (int)1);
            if (node != null) {
                try {
                    InstanceCookie instanceCookie = (InstanceCookie)node.getCookie(InstanceCookie.class);
                    if (instanceCookie != null && Serializable.class.isAssignableFrom(instanceCookie.instanceClass())) {
                        list.add(new DataTransferSupport.SerializePaste(DataFolder.this, instanceCookie));
                        list.add(new DataTransferSupport.InstantiatePaste(DataFolder.this, instanceCookie));
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private final class NewFolder
    extends NewType {
        NewFolder() {
        }

        public String getName() {
            return DataObject.getString("CTL_NewFolder");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void create() throws IOException {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(DataObject.getString("CTL_NewFolderName"), DataObject.getString("CTL_NewFolderTitle"));
            inputLine.setInputText(DataObject.getString("CTL_NewFolderValue"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
                Object object;
                String string;
                String string2 = inputLine.getInputText();
                if ("".equals(string2)) {
                    return;
                }
                FileObject fileObject = DataFolder.this.getPrimaryFile();
                int n = -1;
                while ((n = string2.indexOf(".")) != -1) {
                    string = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                    object = fileObject.getFileObject(string);
                    if (object != null) {
                        if (!object.isFolder()) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_FMT_FileExists", (Object)string, (Object)fileObject.getName()), 2));
                            return;
                        }
                        fileObject = object;
                        continue;
                    }
                    if (!DataFolder.confirmName(string)) {
                        throw new IOException(NbBundle.getMessage(DataObject.class, (String)"EXC_WrongName", (Object)string));
                    }
                    fileObject = fileObject.createFolder(string);
                }
                if (!"".equals(string2)) {
                    string = fileObject.getFileObject(string2);
                    if (string != null) {
                        if (string.isFolder()) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_FMT_FolderExists", (Object)string2, (Object)fileObject.getName()), 1));
                        } else {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_FMT_FileExists", (Object)string2, (Object)fileObject.getName()), 2));
                        }
                        return;
                    }
                    if (!DataFolder.confirmName(string2)) {
                        throw new IOException(NbBundle.getMessage(DataObject.class, (String)"EXC_WrongName", (Object)string2));
                    }
                    object = DataObject.find(fileObject.createFolder(string2));
                    if (object != null) {
                        DataLoaderPool.getDefault().fireOperationEvent(new OperationEvent.Copy((DataObject)object, DataFolder.this), 6);
                    }
                }
            }
        }
    }

    public class FolderNode
    extends DataNode {
        public FolderNode(Children children) {
            super(DataFolder.this, children);
            this.setIconBaseWithExtension(DataFolder.FOLDER_ICON_BASE);
        }

        protected FolderNode() {
            super(DataFolder.this, DataFolder.createNodeChildren(DataFolder.this, DataFilter.ALL));
            this.setIconBaseWithExtension(DataFolder.FOLDER_ICON_BASE);
        }

        @Override
        public Image getIcon(int n) {
            Image image = null;
            if (n == 1) {
                image = DataFolder.findIcon(0, "Nb.Explorer.Folder.icon", "Tree.closedIcon");
            }
            if (image == null) {
                image = super.getIcon(n);
            } else {
                try {
                    DataObject dataObject = this.getDataObject();
                    image = FileUIUtils.getImageDecorator((FileSystem)dataObject.getPrimaryFile().getFileSystem()).annotateIcon(image, n, dataObject.files());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return image;
        }

        @Override
        public Image getOpenedIcon(int n) {
            Image image = null;
            if (n == 1) {
                image = DataFolder.findIcon(1, "Nb.Explorer.Folder.openedIcon", "Tree.openIcon");
            }
            if (image == null) {
                image = super.getOpenedIcon(n);
            } else {
                try {
                    DataObject dataObject = this.getDataObject();
                    image = FileUIUtils.getImageDecorator((FileSystem)dataObject.getPrimaryFile().getFileSystem()).annotateIcon(image, n, dataObject.files());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return image;
        }

        @Override
        public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
            if (clazz == org.openide.nodes.Index.class || clazz == Index.class) {
                try {
                    if (DataFolder.this.getPrimaryFile().getFileSystem().isDefault() || Boolean.TRUE.equals(DataFolder.this.getPrimaryFile().getAttribute("DataFolder.Index.reorderable"))) {
                        return (T)((Node.Cookie)clazz.cast((Object)new Index(DataFolder.this, (Node)this)));
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Logger.getLogger(DataFolder.class.getName()).log(Level.WARNING, null, fileStateInvalidException);
                }
            }
            return super.getCookie(clazz);
        }

        @Override
        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = new Sheet.Set();
            set.setName(DataFolder.SET_SORTING);
            set.setDisplayName(DataObject.getString("PROP_sorting"));
            set.setShortDescription(DataObject.getString("HINT_sorting"));
            PropertySupport.ReadWrite<SortMode> readWrite = new PropertySupport.ReadWrite<SortMode>(DataFolder.PROP_SORT_MODE, SortMode.class, DataObject.getString("PROP_sort"), DataObject.getString("HINT_sort")){

                public SortMode getValue() {
                    return DataFolder.this.getSortMode();
                }

                public void setValue(SortMode sortMode) throws InvocationTargetException {
                    try {
                        DataFolder.this.setSortMode(sortMode);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new SortModeEditor();
                }
            };
            set.put((Node.Property)readWrite);
            sheet.put(set);
            return sheet;
        }

        @Override
        public Action getPreferredAction() {
            return null;
        }

        public NewType[] getNewTypes() {
            return new NewType[0];
        }

        private synchronized FolderRenameHandler getRenameHandler() {
            Collection collection = Lookup.getDefault().lookupAll(FolderRenameHandler.class);
            if (collection.size() == 0) {
                return null;
            }
            if (collection.size() > 1) {
                DataObject.LOG.warning("Multiple instances of FolderRenameHandler found in Lookup; only using first one: " + collection);
            }
            return (FolderRenameHandler)collection.iterator().next();
        }

        @Override
        public void setName(String string) {
            FolderRenameHandler folderRenameHandler = this.getRenameHandler();
            if (folderRenameHandler == null) {
                super.setName(string);
            } else {
                folderRenameHandler.handleRename(DataFolder.this, string);
            }
        }

        @Override
        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
            List<File> list2;
            super.createPasteTypes(transferable, list);
            if (DataFolder.this.getPrimaryFile().canWrite()) {
                DataFolder.this.dataTransferSupport.createPasteTypes(transferable, list);
            }
            if (null != (list2 = this.getDraggedFilesList(transferable)) && !list2.isEmpty() && list.isEmpty()) {
                ArrayList<Transferable> arrayList = new ArrayList<Transferable>(list2.size());
                for (File file : list2) {
                    Transferable transferable2;
                    if (file.getName().length() == 0 || null == (transferable2 = this.createNodeTransferable(file))) continue;
                    arrayList.add(transferable2);
                }
                if (arrayList.size() == 0) {
                    return;
                }
                ExTransferable.Multi multi = new ExTransferable.Multi(arrayList.toArray(new Transferable[arrayList.size()]));
                super.createPasteTypes((Transferable)multi, list);
                if (DataFolder.this.getPrimaryFile().canWrite()) {
                    DataFolder.this.dataTransferSupport.createPasteTypes((Transferable)multi, list);
                }
            }
        }

        Transferable createNodeTransferable(File file) {
            Transferable transferable = null;
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (null != fileObject) {
                try {
                    Node node;
                    DataObject dataObject = DataObject.find(fileObject);
                    if (null != dataObject && !(node = dataObject.getNodeDelegate()).equals((Object)this)) {
                        transferable = dataObject.getNodeDelegate().clipboardCopy();
                        ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                        if (exClipboard != null) {
                            transferable = exClipboard.convert(transferable);
                        }
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(DataFolder.class.getName()).log(Level.INFO, null, iOException);
                }
            }
            return transferable;
        }

        private List<File> getDraggedFilesList(Transferable transferable) {
            try {
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (null != list) {
                        List list2 = NbCollections.checkedListByCopy((List)list, File.class, (boolean)true);
                        return this.filterRelativePaths(list2);
                    }
                } else if (transferable.isDataFlavorSupported(this.getUriListDataFlavor())) {
                    String string = (String)transferable.getTransferData(this.getUriListDataFlavor());
                    return this.textURIListToFileList(string);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.getLogger(DataFolder.class.getName()).log(Level.WARNING, null, unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Logger.getLogger(DataFlavor.class.getName()).log(Level.FINE, null, iOException);
            }
            return null;
        }

        private List<File> filterRelativePaths(List<File> list) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file : list) {
                if (!file.isAbsolute()) continue;
                arrayList.add(file);
            }
            return arrayList;
        }

        private DataFlavor getUriListDataFlavor() {
            if (null == uriListDataFlavor) {
                try {
                    uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AssertionError((Object)classNotFoundException);
                }
            }
            return uriListDataFlavor;
        }

        private List<File> textURIListToFileList(String string) {
            ArrayList<File> arrayList = new ArrayList<File>(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("#")) continue;
                try {
                    URI uRI = new URI(string2);
                    File file = Utilities.toFile((URI)uRI);
                    arrayList.add(file);
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return arrayList;
        }
    }

    public static abstract class SortMode
    implements Comparator<DataObject> {
        public static final SortMode NONE = new FolderComparator(0);
        public static final SortMode NAMES = new FolderComparator(1);
        public static final SortMode CLASS = new FolderComparator(2);
        public static final SortMode FOLDER_NAMES = new FolderComparator(3);
        public static final SortMode LAST_MODIFIED = new FolderComparator(4);
        public static final SortMode SIZE = new FolderComparator(5);
        public static final SortMode EXTENSIONS = new FolderComparator(6);
        public static final SortMode NATURAL = new FolderComparator(7);

        void write(FileObject fileObject) throws IOException {
            String string = this == FOLDER_NAMES ? "F" : (this == NAMES ? "N" : (this == CLASS ? "C" : (this == LAST_MODIFIED ? "M" : (this == SIZE ? "S" : (this == EXTENSIONS ? "X" : (this == NATURAL ? "L" : "O"))))));
            fileObject.setAttribute(DataFolder.EA_SORT_MODE, (Object)string);
        }

        static SortMode read(FileObject fileObject) {
            String string = (String)fileObject.getAttribute(DataFolder.EA_SORT_MODE);
            if (string == null || string.length() != 1) {
                return FOLDER_NAMES;
            }
            char c = string.charAt(0);
            switch (c) {
                case 'N': {
                    return NAMES;
                }
                case 'C': {
                    return CLASS;
                }
                case 'O': {
                    return NONE;
                }
                case 'M': {
                    return LAST_MODIFIED;
                }
                case 'S': {
                    return SIZE;
                }
                case 'X': {
                    return EXTENSIONS;
                }
                case 'L': {
                    return NATURAL;
                }
            }
            return FOLDER_NAMES;
        }
    }

    public static class Index
    extends Index.Support {
        private DataFolder df;
        private Node node;
        private Listener listener;

        @Deprecated
        public Index(DataFolder dataFolder) {
            this(dataFolder, dataFolder.getNodeDelegate());
        }

        public Index(DataFolder dataFolder, Node node) {
            this.df = dataFolder;
            this.node = node;
            this.listener = new Listener();
            node.addNodeListener(NodeOp.weakNodeListener((NodeListener)this.listener, (Object)node));
        }

        public int getNodesCount() {
            return this.node.getChildren().getNodesCount(FolderChildren.checkChildrenMutex());
        }

        public Node[] getNodes() {
            return this.node.getChildren().getNodes(FolderChildren.checkChildrenMutex());
        }

        public void reorder(int[] nArray) {
            DataObject[] dataObjectArray = this.df.getChildren();
            DataObject[] dataObjectArray2 = new DataObject[dataObjectArray.length];
            Node[] nodeArray = this.getNodes();
            if (nodeArray.length != nArray.length) {
                throw new IllegalArgumentException("permutation of incorrect length: " + nArray.length + " rather than " + nodeArray.length);
            }
            HashMap<String, DataObject> hashMap = new HashMap<String, DataObject>(2 * dataObjectArray.length);
            for (int i = 0; i < dataObjectArray.length; ++i) {
                Node node = dataObjectArray[i].getNodeDelegate();
                if (node.getCookie(DataObject.class) != null) continue;
                hashMap.put(node.getName(), dataObjectArray[i]);
            }
            DataObject[] dataObjectArray3 = new DataObject[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                if (dataObject == null) {
                    dataObject = (DataObject)hashMap.get(nodeArray[i].getName());
                }
                if (dataObject == null) {
                    throw new IllegalArgumentException("cannot reorder node with no DataObject: " + nodeArray[i]);
                }
                if (dataObject.getFolder() != this.df) {
                    throw new IllegalArgumentException("wrong folder for: " + dataObject.getPrimaryFile() + " rather than " + this.df.getPrimaryFile());
                }
                dataObjectArray3[nArray[i]] = dataObject;
            }
            HashSet<DataObject> hashSet = new HashSet<DataObject>(Arrays.asList(dataObjectArray3));
            if (hashSet.size() != dataObjectArray3.length) {
                throw new IllegalArgumentException("duplicate DataObject's among reordered childen");
            }
            int n = 0;
            for (int i = 0; i < dataObjectArray.length; ++i) {
                dataObjectArray2[i] = hashSet.remove(dataObjectArray[i]) ? dataObjectArray3[n++] : dataObjectArray[i];
            }
            try {
                this.df.setOrder(dataObjectArray2);
            }
            catch (IOException iOException) {
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)DataObject.getString("EXC_ReorderFailed"));
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void reorder() {
            Index.Support.showIndexedCustomizer((org.openide.nodes.Index)this);
        }

        void fireChangeEventAccess() {
            this.fireChangeEvent(new ChangeEvent((Object)this));
        }

        private final class Listener
        implements NodeListener {
            Listener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
            }

            public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
                Index.this.fireChangeEventAccess();
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
                Index.this.fireChangeEventAccess();
            }

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                Index.this.fireChangeEventAccess();
            }
        }
    }

    private static final class ClonedFilterHandle
    implements Node.Handle {
        private static final long serialVersionUID = 24234097765186L;
        private DataObject folder;
        private DataFilter filter;

        public ClonedFilterHandle(DataFolder dataFolder, DataFilter dataFilter) {
            this.folder = dataFolder;
            this.filter = dataFilter;
        }

        public Node getNode() throws IOException {
            if (this.folder instanceof DataFolder) {
                DataFolder dataFolder = (DataFolder)this.folder;
                dataFolder.getClass();
                return dataFolder.new ClonedFilter(this.filter);
            }
            throw new InvalidObjectException(this.folder == null ? "" : this.folder.toString());
        }
    }

    private final class ClonedFilter
    extends FilterNode {
        private DataFilter filter;
        private int hashCode;

        public ClonedFilter(Node node, DataFilter dataFilter) {
            super(node, DataFolder.this.createNodeChildren(dataFilter));
            this.hashCode = -1;
            this.filter = dataFilter;
        }

        public ClonedFilter(DataFilter dataFilter) {
            this(dataFolder.getNodeDelegate(), dataFilter);
        }

        public Node cloneNode() {
            if (DataFolder.this.isValid()) {
                return new ClonedFilter(this.filter);
            }
            return super.cloneNode();
        }

        public Node.Handle getHandle() {
            return new ClonedFilterHandle(DataFolder.this, this.filter);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object instanceof FolderNode) {
                FolderNode folderNode = (FolderNode)((Object)object);
                if (folderNode.getCookie(DataFolder.class) != DataFolder.this) {
                    return false;
                }
                Children children = folderNode.getChildren();
                if (children instanceof FolderChildren) {
                    ((FolderChildren)children).getFilter().equals(this.filter);
                }
                return false;
            }
            if (object instanceof ClonedFilter) {
                ClonedFilter clonedFilter = (ClonedFilter)((Object)object);
                return clonedFilter.getCookie(DataFolder.class) == DataFolder.this && clonedFilter.filter.equals(this.filter);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = DataFolder.this.isValid() ? DataFolder.this.getNodeDelegate().hashCode() : super.hashCode();
                if (this.hashCode == -1) {
                    this.hashCode = -2;
                }
            }
            return this.hashCode;
        }
    }
}

