/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.LocalObjectNode;
import org.graalvm.visualvm.heapviewer.java.StackFrameNode;
import org.graalvm.visualvm.heapviewer.java.ThreadNode;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.JavaFrameGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.JniLocalGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.ThreadObjectGCRoot;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;

class JavaThreadsProvider {
    private static final String OPEN_THREADS_URL = "file:/stackframe/";
    private static final int JVMTI_THREAD_STATE_ALIVE = 1;
    private static final int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static final int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static final int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static final int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static final int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;

    JavaThreadsProvider() {
    }

    static String getThreadName(Instance instance) {
        String threadName = JavaThreadsProvider.getThreadInstanceName(instance);
        Boolean daemon = (Boolean)instance.getValueOfField("daemon");
        Integer priority = (Integer)instance.getValueOfField("priority");
        Long threadId = (Long)instance.getValueOfField("tid");
        Integer threadStatus = (Integer)instance.getValueOfField("threadStatus");
        String tName = "\"" + threadName + "\"" + (daemon != false ? " daemon" : "") + " prio=" + priority;
        if (threadId != null) {
            tName = tName + " tid=" + threadId;
        }
        if (threadStatus != null) {
            tName = tName + " " + (Object)((Object)JavaThreadsProvider.toThreadState(threadStatus));
        }
        return tName;
    }

    static ThreadObjectGCRoot getOOMEThread(Heap heap) {
        Collection roots = heap.getGCRoots();
        for (GCRoot root : roots) {
            ThreadObjectGCRoot threadRoot;
            StackTraceElement[] stackTrace;
            if (!root.getKind().equals("thread object") || (stackTrace = (threadRoot = (ThreadObjectGCRoot)root).getStackTrace()) == null || stackTrace.length < 1) continue;
            StackTraceElement ste = stackTrace[0];
            if (!OutOfMemoryError.class.getName().equals(ste.getClassName()) || !"<init>".equals(ste.getMethodName())) continue;
            return threadRoot;
        }
        return null;
    }

    static HeapViewerNode getNode(URL url, HeapContext context) {
        String urls = url.toString();
        if (HeapUtils.isInstance(urls)) {
            Instance instance = HeapUtils.instanceFromHtml(urls, context.getFragment().getHeap());
            if (instance != null) {
                return new InstanceNode(instance);
            }
            ProfilerDialogs.displayError((String)Bundle.JavaThreadsProvider_CannotResolveInstanceMsg());
        } else if (HeapUtils.isClass(urls)) {
            JavaClass javaClass = HeapUtils.classFromHtml(urls, context.getFragment().getHeap());
            if (javaClass != null) {
                return new ClassNode(javaClass);
            }
            ProfilerDialogs.displayError((String)Bundle.JavaThreadsProvider_CannotResolveClassMsg());
        }
        return null;
    }

    static HeapViewerNode[] getThreadsNodes(RootNode rootNode, Heap heap) throws InterruptedException {
        ArrayList<ThreadNode> threadNodes = new ArrayList<ThreadNode>();
        Collection roots = heap.getGCRoots();
        Map<ThreadObjectGCRoot, Map<Integer, List<GCRoot>>> javaFrameMap = JavaThreadsProvider.computeJavaFrameMap(roots);
        ThreadObjectGCRoot oome = JavaThreadsProvider.getOOMEThread(heap);
        Thread worker = Thread.currentThread();
        for (GCRoot root : roots) {
            if (!root.getKind().equals("thread object")) continue;
            ThreadObjectGCRoot threadRoot = (ThreadObjectGCRoot)root;
            Instance threadInstance = threadRoot.getInstance();
            if (threadInstance != null) {
                StackTraceElement[] stack = threadRoot.getStackTrace();
                Map<Integer, List<GCRoot>> localsMap = javaFrameMap.get(threadRoot);
                String tName = JavaThreadsProvider.getThreadName(threadInstance);
                final ArrayList<StackFrameNode> stackFrameNodes = new ArrayList<StackFrameNode>();
                ThreadNode threadNode = new ThreadNode(tName, threadRoot.equals(oome), threadInstance){

                    @Override
                    protected HeapViewerNode[] computeChildren(RootNode root) {
                        return stackFrameNodes.toArray(HeapViewerNode.NO_NODES);
                    }
                };
                if (stack != null) {
                    for (int i = 0; i < stack.length; ++i) {
                        List<GCRoot> locals;
                        ArrayList<LocalObjectNode> localVariableNodes = new ArrayList<LocalObjectNode>();
                        if (localsMap != null && (locals = localsMap.get(i)) != null) {
                            for (GCRoot local : locals) {
                                Instance localInstance = local.getInstance();
                                if (localInstance != null) {
                                    String text = "";
                                    if ("Java frame".equals(local.getKind())) {
                                        text = Bundle.JavaThreadsProvider_LocalVariable();
                                    } else if ("JNI local".equals(local.getKind())) {
                                        text = Bundle.JavaThreadsProvider_JniLocal();
                                    }
                                    localVariableNodes.add(new LocalObjectNode(localInstance, text));
                                    continue;
                                }
                                localVariableNodes.add(new LocalObjectNode.Unknown());
                            }
                        }
                        StackTraceElement stackElement = stack[i];
                        StackFrameNode stackFrameNode = new StackFrameNode(stackElement.toString(), localVariableNodes.toArray(HeapViewerNode.NO_NODES));
                        stackFrameNodes.add(stackFrameNode);
                        if (!worker.isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                threadNodes.add(threadNode);
                continue;
            }
            threadNodes.add(new ThreadNode.Unknown());
        }
        return threadNodes.toArray(HeapViewerNode.NO_NODES);
    }

    static String getThreadsHTML(HeapContext context) {
        boolean gotoSourceAvailable = false;
        StringBuilder sb = new StringBuilder();
        Heap heap = context.getFragment().getHeap();
        Collection roots = heap.getGCRoots();
        Map<ThreadObjectGCRoot, Map<Integer, List<GCRoot>>> javaFrameMap = JavaThreadsProvider.computeJavaFrameMap(roots);
        ThreadObjectGCRoot oome = JavaThreadsProvider.getOOMEThread(heap);
        JavaClass javaClassClass = heap.getJavaClassByName(Class.class.getName());
        sb.append("<pre>");
        for (GCRoot root : roots) {
            if (!root.getKind().equals("thread object")) continue;
            ThreadObjectGCRoot threadRoot = (ThreadObjectGCRoot)root;
            Instance threadInstance = threadRoot.getInstance();
            if (threadInstance != null) {
                String threadName = JavaThreadsProvider.getThreadName(threadInstance);
                StackTraceElement[] stack = threadRoot.getStackTrace();
                Map<Integer, List<GCRoot>> localsMap = javaFrameMap.get(threadRoot);
                String style = "";
                if (threadRoot.equals(oome)) {
                    style = "style=\"color: #FF0000\"";
                }
                sb.append("<a name='").append(threadInstance.getInstanceId()).append("'><b ").append(style).append(">");
                sb.append(HeapUtils.htmlize(threadName));
                sb.append("</b></a><br>");
                if (stack != null) {
                    for (int i = 0; i < stack.length; ++i) {
                        List<GCRoot> locals;
                        String stackElHref;
                        StackTraceElement stackElement = stack[i];
                        String stackElementText = HeapUtils.htmlize(stackElement.toString());
                        if (gotoSourceAvailable) {
                            String className = stackElement.getClassName();
                            String method = stackElement.getMethodName();
                            int lineNo = stackElement.getLineNumber();
                            String stackUrl = OPEN_THREADS_URL + className + "|" + method + "|" + lineNo;
                            stackElHref = "<a href=\"" + stackUrl + "\">" + stackElementText + "</a>";
                        } else {
                            stackElHref = stackElementText;
                        }
                        sb.append("    at ").append(stackElHref).append("<br>");
                        if (localsMap == null || (locals = localsMap.get(i)) == null) continue;
                        for (GCRoot local : locals) {
                            String text;
                            Instance localInstance = local.getInstance();
                            if (localInstance != null) {
                                text = "";
                                if ("Java frame".equals(local.getKind())) {
                                    text = Bundle.JavaThreadsProvider_LocalVariable();
                                } else if ("JNI local".equals(local.getKind())) {
                                    text = Bundle.JavaThreadsProvider_JniLocal();
                                }
                                sb.append("       <span style=\"color: #666666\">" + text + ":</span> ").append(HeapUtils.instanceToHtml(localInstance, false, javaClassClass)).append("<br>");
                                continue;
                            }
                            text = "";
                            if ("Java frame".equals(local.getKind())) {
                                text = Bundle.JavaThreadsProvider_UnknownLocalVariable();
                            } else if ("JNI local".equals(local.getKind())) {
                                text = Bundle.JavaThreadsProvider_UnknownJniLocal();
                            }
                            sb.append("       <span style=\"color: #666666\">" + text + "</span><br>");
                        }
                    }
                }
            } else {
                sb.append(Bundle.JavaThreadsProvider_UnknownThread() + "<br>");
            }
            sb.append("<br>");
        }
        sb.append("</pre>");
        return sb.toString();
    }

    private static String getThreadInstanceName(Instance threadInstance) {
        Object threadName = threadInstance.getValueOfField("name");
        if (threadName == null) {
            return "*null*";
        }
        return DetailsSupport.getDetailsString((Instance)((Instance)threadName));
    }

    private static Map<ThreadObjectGCRoot, Map<Integer, List<GCRoot>>> computeJavaFrameMap(Collection<GCRoot> roots) {
        HashMap<ThreadObjectGCRoot, Map<Integer, List<GCRoot>>> javaFrameMap = new HashMap<ThreadObjectGCRoot, Map<Integer, List<GCRoot>>>();
        for (GCRoot root : roots) {
            ArrayList<GCRoot> locals;
            Integer frameNo;
            ThreadObjectGCRoot threadObj;
            if ("Java frame".equals(root.getKind())) {
                JavaFrameGCRoot frameGCroot = (JavaFrameGCRoot)root;
                threadObj = frameGCroot.getThreadGCRoot();
                frameNo = frameGCroot.getFrameNumber();
            } else {
                if (!"JNI local".equals(root.getKind())) continue;
                JniLocalGCRoot jniGCroot = (JniLocalGCRoot)root;
                threadObj = jniGCroot.getThreadGCRoot();
                frameNo = jniGCroot.getFrameNumber();
            }
            HashMap<Integer, ArrayList<GCRoot>> stackMap = (HashMap<Integer, ArrayList<GCRoot>>)javaFrameMap.get(threadObj);
            if (stackMap == null) {
                stackMap = new HashMap<Integer, ArrayList<GCRoot>>();
                javaFrameMap.put(threadObj, stackMap);
            }
            if ((locals = (ArrayList<GCRoot>)stackMap.get(frameNo)) == null) {
                locals = new ArrayList<GCRoot>(2);
                stackMap.put(frameNo, locals);
            }
            locals.add(root);
        }
        return javaFrameMap;
    }

    private static Thread.State toThreadState(int threadStatus) {
        if ((threadStatus & 4) != 0) {
            return Thread.State.RUNNABLE;
        }
        if ((threadStatus & 0x400) != 0) {
            return Thread.State.BLOCKED;
        }
        if ((threadStatus & 0x10) != 0) {
            return Thread.State.WAITING;
        }
        if ((threadStatus & 0x20) != 0) {
            return Thread.State.TIMED_WAITING;
        }
        if ((threadStatus & 2) != 0) {
            return Thread.State.TERMINATED;
        }
        if ((threadStatus & 1) == 0) {
            return Thread.State.NEW;
        }
        return Thread.State.RUNNABLE;
    }
}

