/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openjdk.jmc.common.io.IOToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class XmlToolkit {
    private static final String XML_PARSER_DISALLOW_DOCTYPE_ATTRIBUTE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.common.xml");
    private static final Pattern AMP = Pattern.compile("&");
    private static final Pattern LT = Pattern.compile("<");
    private static final Pattern GT = Pattern.compile(">");
    private static final Pattern QUOT = Pattern.compile("\"");
    private static final Pattern APOS = Pattern.compile("'");
    private static final Pattern CR = Pattern.compile("\r");
    private static final Pattern NL = Pattern.compile("\n");
    private static final Pattern TAB = Pattern.compile("\t");

    private XmlToolkit() {
    }

    public static Element getOrCreateElement(Element parentNode, String tagName) {
        NodeList list = parentNode.getElementsByTagName(tagName);
        if (list.getLength() == 0) {
            Element newElement = parentNode.getOwnerDocument().createElement(tagName);
            parentNode.appendChild(newElement);
            return newElement;
        }
        return (Element)list.item(0);
    }

    public static Element createElement(Element parentNode, String tagName) {
        Element newElement = parentNode.getOwnerDocument().createElement(tagName);
        parentNode.appendChild(newElement);
        return newElement;
    }

    public static void setSetting(Element parentNode, String settingName, String settingValue) {
        String sValue;
        Element settingElement = XmlToolkit.getOrCreateElement(parentNode, settingName);
        String string = sValue = settingValue != null ? settingValue : "";
        if (settingElement == null) {
            settingElement = parentNode.getOwnerDocument().createElement(settingName);
            parentNode.appendChild(settingElement);
        }
        XmlToolkit.setStringValue(settingElement, sValue);
    }

    public static Document createNewDocument(String rootElementName) throws IOException {
        Document doc = null;
        try {
            InputSource xml = new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><" + rootElementName + "/>"));
            DocumentBuilderFactory dbf = XmlToolkit.createDocumentBuildFactoryInstance();
            doc = dbf.newDocumentBuilder().parse(xml);
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXException e) {
            LOGGER.log(Level.WARNING, "Error in creating new XML document", e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Error in creating new XML document", e);
        }
        catch (FactoryConfigurationError e) {
            LOGGER.log(Level.WARNING, "Error in creating new XML document", e);
        }
        return doc;
    }

    public static SAXParserFactory createSAXParserFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature(XML_PARSER_DISALLOW_DOCTYPE_ATTRIBUTE, true);
        return factory;
    }

    public static DocumentBuilderFactory createDocumentBuildFactoryInstance() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature(XML_PARSER_DISALLOW_DOCTYPE_ATTRIBUTE, true);
        return dbf;
    }

    public static TransformerFactory createTransformerFactory() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    }

    public static void setStringValue(Element element, String value) {
        if (element == null) {
            return;
        }
        if (element.getFirstChild() == null) {
            element.appendChild(element.getOwnerDocument().createTextNode(value));
        } else {
            element.getFirstChild().setNodeValue(value);
        }
    }

    public static String getSetting(Element parent, String settingName, String defaultValue) {
        Element settingsNode = XmlToolkit.getOrCreateElement(parent, settingName);
        String value = XmlToolkit.getStringValue(settingsNode);
        if (value == null) {
            XmlToolkit.setSetting(parent, settingName, defaultValue);
            value = defaultValue;
        }
        return value;
    }

    public static String getStringValue(Element element) {
        if (element == null) {
            return null;
        }
        Node n = element.getFirstChild();
        if (n == null || n.getNodeType() != 3) {
            return null;
        }
        return element.getFirstChild().getNodeValue();
    }

    public static String prettyPrint(Element node) {
        StringWriter wrt = new StringWriter();
        XmlToolkit.prettyPrint(node, wrt);
        return wrt.toString();
    }

    public static void prettyPrint(Element node, Writer wrt) {
        try {
            TransformerFactory factory = XmlToolkit.createTransformerFactory();
            try {
                factory.setAttribute("indent-number", "4");
            }
            catch (IllegalArgumentException iae) {
                LOGGER.info("Could not set indent-number attribute on the transformer factory.");
            }
            Transformer passThrough = factory.newTransformer();
            passThrough.setOutputProperty("indent", "yes");
            passThrough.transform(new DOMSource(node), new StreamResult(wrt));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't serialize the document to string!", e);
        }
    }

    public static List<Element> getChildElementsByTag(Node contextNode, String tag) {
        LinkedList<Element> resultList = new LinkedList<Element>();
        NodeList fullList = contextNode.getChildNodes();
        for (int i = 0; i < fullList.getLength(); ++i) {
            Node n = fullList.item(i);
            if (!fullList.item(i).getNodeName().equals(tag) || !(n instanceof Element)) continue;
            resultList.add((Element)n);
        }
        return resultList;
    }

    private static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory factory = XmlToolkit.createDocumentBuildFactoryInstance();
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Parser configuration error", e);
        }
        return docBuilder;
    }

    public static Document loadDocumentFromFile(File file) throws SAXException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Document document = XmlToolkit.loadDocumentFromStream(new BufferedInputStream(is));
            return document;
        }
        finally {
            if (is != null) {
                IOToolkit.closeSilently(is);
            }
        }
    }

    public static Document loadDocumentFromStream(InputStream stream) throws SAXException, IOException {
        return XmlToolkit.getDocumentBuilder().parse(stream);
    }

    public static Document loadDocumentFromString(String doc) throws SAXException {
        try {
            if (doc == null) {
                throw new NullPointerException();
            }
            return XmlToolkit.getDocumentBuilder().parse(new InputSource(new StringReader(doc)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void storeDocumentToFile(Document doc, File file) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(file, "UTF-8");
            XmlToolkit.prettyPrint(doc.getDocumentElement(), pw);
        }
        finally {
            if (pw != null) {
                IOToolkit.closeSilently(pw);
            }
        }
    }

    public static String storeDocumentToString(Document doc) {
        return XmlToolkit.prettyPrint(doc.getDocumentElement());
    }

    public static Element getChildElementOrNull(Element parent, String name) {
        List<Element> nodes = XmlToolkit.getChildElementsByTag(parent, name);
        if (nodes.isEmpty()) {
            return null;
        }
        return nodes.get(0);
    }

    public static String escapeAll(String s) {
        s = XmlToolkit.escapeTagContent(s);
        s = QUOT.matcher(s).replaceAll("&quot;");
        s = APOS.matcher(s).replaceAll("&apos;");
        s = CR.matcher(s).replaceAll("&#x0D;");
        s = NL.matcher(s).replaceAll("&#x0A;");
        return TAB.matcher(s).replaceAll("&#x09;");
    }

    public static String escapeTagContent(String s) {
        s = AMP.matcher(s).replaceAll("&amp;");
        s = LT.matcher(s).replaceAll("&lt;");
        return GT.matcher(s).replaceAll("&gt;");
    }
}

