/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.plugins;

import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"processCompilerPluginsOptions", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "pluginOptions", "", "", "commandLineProcessors", "", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "cli"})
public final class PluginCliParserKt {
    /*
     * WARNING - void declaration
     */
    public static final void processCompilerPluginsOptions(@NotNull CompilerConfiguration configuration, @Nullable Iterable<String> pluginOptions, @NotNull List<? extends CommandLineProcessor> commandLineProcessors) {
        Map map;
        Object object;
        Object object2;
        Object destination$iv$iv;
        Object object3;
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(commandLineProcessors, "commandLineProcessors");
        Iterable<String> iterable = pluginOptions;
        if (iterable == null) {
            object3 = null;
        } else {
            void $this$groupByTo$iv$iv;
            boolean bl;
            Iterable $this$mapTo$iv$iv;
            Iterable<String> $this$map$iv = iterable;
            boolean $i$f$map = false;
            Iterable<String> iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                object2 = destination$iv$iv;
                bl = false;
                object = CliOptionsKt.parsePluginOption((String)p0);
                object2.add(object);
            }
            List list2 = (List)destination$iv$iv;
            Iterable $this$groupBy$iv = list2;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object4;
                CliOptionValue it = (CliOptionValue)element$iv$iv;
                bl = false;
                if (it == null) {
                    throw new CliOptionProcessingException("Wrong plugin option format: " + it + ", should be plugin:<pluginId>:<optionName>=<value>", null, 2, null);
                }
                String key$iv$iv = it.getPluginId();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv);
            }
            object3 = destination$iv$iv;
        }
        Object object5 = object3;
        if (object5 == null) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        } else {
            map = object5;
        }
        Map optionValuesByPlugin = map;
        for (CommandLineProcessor commandLineProcessor : commandLineProcessors) {
            Iterator iterator2;
            void $this$associateByTo$iv$iv22;
            Iterable $this$associateBy$iv = commandLineProcessor.getPluginOptions();
            boolean $i$f$associateBy = false;
            int capacity$iv232 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv232);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv22) {
                void it;
                AbstractCliOption bl = (AbstractCliOption)element$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl3 = false;
                object = it.getOptionName();
                object2.put(object, element$iv$iv);
            }
            Map declaredOptions = destination$iv$iv2;
            MultiMap<AbstractCliOption, CliOptionValue> optionsToValues = new MultiMap<AbstractCliOption, CliOptionValue>();
            List<CliOptionValue> capacity$iv232 = (List<CliOptionValue>)optionValuesByPlugin.get(commandLineProcessor.getPluginId());
            boolean $this$associateByTo$iv$iv22 = false;
            List<CliOptionValue> list2 = capacity$iv232;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (CliOptionValue optionValue : list2) {
                if (optionValue == null) {
                    Intrinsics.throwNpe();
                }
                if ((iterator2 = (AbstractCliOption)declaredOptions.get(optionValue.getOptionName())) == null) {
                    throw new CliOptionProcessingException(Intrinsics.stringPlus("Unsupported plugin option: ", optionValue), null, 2, null);
                }
                AbstractCliOption option = iterator2;
                optionsToValues.putValue(option, optionValue);
            }
            for (AbstractCliOption option : commandLineProcessor.getPluginOptions()) {
                iterator2 = optionsToValues.get(option);
                Intrinsics.checkExpressionValueIsNotNull(iterator2, "optionsToValues[option]");
                Iterator values2 = iterator2;
                if (option.getRequired() && values2.isEmpty()) {
                    throw new PluginCliOptionProcessingException(commandLineProcessor.getPluginId(), commandLineProcessor.getPluginOptions(), "Required plugin option not present: " + commandLineProcessor.getPluginId() + ':' + option.getOptionName(), null, 8, null);
                }
                if (!option.getAllowMultipleOccurrences() && values2.size() > 1) {
                    throw new PluginCliOptionProcessingException(commandLineProcessor.getPluginId(), commandLineProcessor.getPluginOptions(), "Multiple values are not allowed for plugin option " + commandLineProcessor.getPluginId() + ':' + option.getOptionName(), null, 8, null);
                }
                iterator2 = values2.iterator();
                while (iterator2.hasNext()) {
                    CliOptionValue value2 = (CliOptionValue)iterator2.next();
                    commandLineProcessor.processOption(option, value2.getValue(), configuration);
                }
            }
        }
    }
}

