/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0012 \b\u0002\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/UpperBoundViolatedReporter;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "argumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "baseDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "diagnosticForTypeAliases", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;)V", "report", "", "typeArgumentReference", "substitutedBound", "reportForTypeAliasExpansion", "callElement", "frontend"})
public final class UpperBoundViolatedReporter {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final KotlinType argumentType;
    @NotNull
    private final TypeParameterDescriptor typeParameterDescriptor;
    @NotNull
    private final DiagnosticFactory2<KtTypeReference, KotlinType, KotlinType> baseDiagnostic;
    @NotNull
    private final DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases;

    public UpperBoundViolatedReporter(@NotNull BindingTrace trace, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull DiagnosticFactory2<KtTypeReference, KotlinType, KotlinType> baseDiagnostic, @NotNull DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(typeParameterDescriptor, "typeParameterDescriptor");
        Intrinsics.checkNotNullParameter(baseDiagnostic, "baseDiagnostic");
        Intrinsics.checkNotNullParameter(diagnosticForTypeAliases, "diagnosticForTypeAliases");
        this.trace = trace;
        this.argumentType = argumentType;
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.baseDiagnostic = baseDiagnostic;
        this.diagnosticForTypeAliases = diagnosticForTypeAliases;
    }

    public /* synthetic */ UpperBoundViolatedReporter(BindingTrace bindingTrace, KotlinType kotlinType, TypeParameterDescriptor typeParameterDescriptor, DiagnosticFactory2 diagnosticFactory2, DiagnosticFactory3 diagnosticFactoryWithPsiElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        DiagnosticFactoryWithPsiElement diagnosticFactoryWithPsiElement2;
        if ((n & 8) != 0) {
            diagnosticFactoryWithPsiElement2 = Errors.UPPER_BOUND_VIOLATED;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactoryWithPsiElement2, "UPPER_BOUND_VIOLATED");
            diagnosticFactory2 = diagnosticFactoryWithPsiElement2;
        }
        if ((n & 0x10) != 0) {
            diagnosticFactoryWithPsiElement2 = Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactoryWithPsiElement2, "UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION");
            diagnosticFactoryWithPsiElement = diagnosticFactoryWithPsiElement2;
        }
        this(bindingTrace, kotlinType, typeParameterDescriptor, diagnosticFactory2, (DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor>)diagnosticFactoryWithPsiElement);
    }

    public final void report(@NotNull KtTypeReference typeArgumentReference, @NotNull KotlinType substitutedBound) {
        Intrinsics.checkNotNullParameter(typeArgumentReference, "typeArgumentReference");
        Intrinsics.checkNotNullParameter(substitutedBound, "substitutedBound");
        ParametrizedDiagnostic<KtTypeReference> parametrizedDiagnostic = this.baseDiagnostic.on((KtTypeReference)((PsiElement)typeArgumentReference), substitutedBound, this.argumentType);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "baseDiagnostic.on(typeArgumentReference, substitutedBound, argumentType)");
        DiagnosticUtilsKt.reportDiagnosticOnce(this.trace, parametrizedDiagnostic);
    }

    public final void reportForTypeAliasExpansion(@NotNull KtElement callElement, @NotNull KotlinType substitutedBound) {
        Intrinsics.checkNotNullParameter(callElement, "callElement");
        Intrinsics.checkNotNullParameter(substitutedBound, "substitutedBound");
        ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = this.diagnosticForTypeAliases.on((KtElement)((PsiElement)callElement), substitutedBound, this.argumentType, this.typeParameterDescriptor);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "diagnosticForTypeAliases.on(callElement, substitutedBound, argumentType, typeParameterDescriptor)");
        DiagnosticUtilsKt.reportDiagnosticOnce(this.trace, parametrizedDiagnostic);
    }
}

