/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class ImportsStructureObjectSorter<O> {
    @Nonnull
    private final OWLOntology ontology;
    @Nonnull
    private final ObjectSelector<O> objectSelector;

    public ImportsStructureObjectSorter(@Nonnull OWLOntology ontology, @Nonnull ObjectSelector<O> objectSelector) {
        this.ontology = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        this.objectSelector = OWLAPIPreconditions.checkNotNull(objectSelector, "objectSelector cannot be null");
    }

    @Nonnull
    public Map<OWLOntology, Set<O>> getObjects() {
        ArrayList<OWLOntology> imports = new ArrayList<OWLOntology>(this.ontology.getImportsClosure());
        HashMap<OWLOntology, Set<O>> ontology2EntityMap = new HashMap<OWLOntology, Set<O>>();
        HashSet<O> processed = new HashSet<O>();
        for (int i = imports.size() - 1; i > -1; --i) {
            OWLOntology currentOnt = (OWLOntology)imports.get(i);
            assert (currentOnt != null);
            HashSet<O> objects = new HashSet<O>();
            for (O obj : this.objectSelector.getObjects(currentOnt)) {
                if (processed.contains(obj)) continue;
                processed.add(obj);
                objects.add(obj);
            }
            ontology2EntityMap.put(currentOnt, objects);
        }
        return ontology2EntityMap;
    }

    public static interface ObjectSelector<O> {
        @Nonnull
        public Set<O> getObjects(@Nonnull OWLOntology var1);
    }
}

