/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport;

import java.util.HashMap;
import org.apache.catalina.tribes.Member;

public class SenderState {
    public static final int READY = 0;
    public static final int SUSPECT = 1;
    public static final int FAILING = 2;
    protected static HashMap<Member, SenderState> memberStates = new HashMap();
    private int state = 0;

    public static SenderState getSenderState(Member member) {
        return SenderState.getSenderState(member, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SenderState getSenderState(Member member, boolean bl) {
        SenderState senderState = memberStates.get(member);
        if (senderState == null && bl) {
            HashMap<Member, SenderState> hashMap = memberStates;
            synchronized (hashMap) {
                senderState = memberStates.get(member);
                if (senderState == null) {
                    senderState = new SenderState();
                    memberStates.put(member, senderState);
                }
            }
        }
        return senderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSenderState(Member member) {
        HashMap<Member, SenderState> hashMap = memberStates;
        synchronized (hashMap) {
            memberStates.remove(member);
        }
    }

    private SenderState() {
        this(0);
    }

    private SenderState(int n) {
        this.state = n;
    }

    public boolean isSuspect() {
        return this.state == 1 || this.state == 2;
    }

    public void setSuspect() {
        this.state = 1;
    }

    public boolean isReady() {
        return this.state == 0;
    }

    public void setReady() {
        this.state = 0;
    }

    public boolean isFailing() {
        return this.state == 2;
    }

    public void setFailing() {
        this.state = 2;
    }
}

