/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class CallStreamEndpointInterface
 * \headerfile TelepathyQt/call-stream-endpoint.h <TelepathyQt/CallStreamEndpoint>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Stream.Endpoint".
 */
class TP_QT_EXPORT CallStreamEndpointInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Stream.Endpoint", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Stream.Endpoint");
    }

    /**
     * Creates a CallStreamEndpointInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallStreamEndpointInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallStreamEndpointInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallStreamEndpointInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallStreamEndpointInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallStreamEndpointInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c RemoteCredentials of type \c Tp::StreamCredentials.
     *
     * 
     * The ICE credentials used for all candidates. If each candidate has 
     * different credentials, then this property SHOULD be (&quot;&quot;, 
     * &quot;&quot;). Per-candidate credentials are set in the 
     * Candidate&apos;s Candidate_Info a{sv}.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRemoteCredentials() const
    {
        return internalRequestProperty(QLatin1String("RemoteCredentials"));
    }

    /**
     * Asynchronous getter for the remote object property \c RemoteCandidates of type \c Tp::CandidateList.
     *
     * 
     * A list of candidates for this endpoint.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRemoteCandidates() const
    {
        return internalRequestProperty(QLatin1String("RemoteCandidates"));
    }

    /**
     * Asynchronous getter for the remote object property \c SelectedCandidatePairs of type \c Tp::CandidatePairList.
     *
     * 
     * \htmlonly
     * <p>The candidates that have been selected for use to stream packets
     * to the remote contact for each component of the stream.
     * Change notification is given via the
     * the  \endhtmlonly CandidatePairSelected() \htmlonly  signal.</p>
     * 
     * <p>Note to client implementors (from <a href="http://tools.ietf.org/html/rfc5245#section-9.2.2.3">RFC 5245
     * section 9.2.2.3</a>):</p>
     * 
     * <blockquote>
     *   <p>If at least one of the pairs is In-Progress, the agent SHOULD wait
     *   for those checks to complete, and as each completes, redo the
     *   processing in this section until there are no losing pairs.</p>
     * </blockquote>
     * 
     * <p>Also note that some or all of the local candidates in this list may
     * represent a peer-reflexive candidate that do not appear in
     *  \endhtmlonly \link CallStreamInterfaceMediaInterface::requestPropertyLocalCandidates() CallStreamInterfaceMediaInterface::LocalCandidates \endlink \htmlonly .</p>
     * 
     * <p>See <a href="http://tools.ietf.org/html/rfc5245#appendix-B.6">RFC
     * 5245 Appendix B.6.</a> for more details about why this is.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySelectedCandidatePairs() const
    {
        return internalRequestProperty(QLatin1String("SelectedCandidatePairs"));
    }

    /**
     * Asynchronous getter for the remote object property \c EndpointState of type \c Tp::ComponentStateMap.
     *
     * 
     * The state of ICE negotiation with this Endpoint for each component of 
     * the stream.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyEndpointState() const
    {
        return internalRequestProperty(QLatin1String("EndpointState"));
    }

    /**
     * Asynchronous getter for the remote object property \c Transport of type \c uint.
     *
     * 
     * The transport type for the stream endpoint. This can be different from 
     * the transport of the Stream in the case where of falling back from ICE 
     * to Raw_UDP.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyTransport() const
    {
        return internalRequestProperty(QLatin1String("Transport"));
    }

    /**
     * Asynchronous getter for the remote object property \c Controlling of type \c bool.
     *
     * 
     * \htmlonly
     * <p>
     * The local side is taking the controlling role (as defined by ICE RFC
     * 5245). Change notification is given via the
     *  \endhtmlonly ControllingChanged() \htmlonly  signal.</p>
     * 
     * <div class="rationale">In ICE, the Caller is normally in controlling mode (and
     * the Callee in controlled-mode), except if the Caller is doing ICE-Lite,
     * in which case it's reversed. The Controlling side is responsible for
     * selecting nominated pairs, and generating updated offers upon
     * conclusion of ICE.</div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyControlling() const
    {
        return internalRequestProperty(QLatin1String("Controlling"));
    }

    /**
     * Asynchronous getter for the remote object property \c IsICELite of type \c bool.
     *
     * 
     * The Remote side is an ICE Lite endpoint. (The local side is assumed to 
     * always be an ICE Full implementation.)
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyIsICELite() const
    {
        return internalRequestProperty(QLatin1String("IsICELite"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetSelectedCandidatePair on the remote object.
     * 
     * \htmlonly
     * <p>Update the entry in
     *  \endhtmlonly \link requestPropertySelectedCandidatePairs() SelectedCandidatePairs \endlink \htmlonly 
     * for a particular component, and signal it to the remote side.</p>
     * 
     * <p>This method should only be called by the controlling side of an
     * ICE session. See  \endhtmlonly CandidatePairSelected() \htmlonly 
     * for details.</p>
     * 
     * <div class="rationale">
     *   <p>In the SDP offer/answer model, this signalling will take place as
     *   generating an updated offer.
     *   Note that updates may be queued up until information about all
     *   components of all streams is gathered.</p>
     * </div>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param localCandidate
     *     
     *     The local candidate that has been selected.
     *
     * \param remoteCandidate
     *     
     *     The remote candidate that has been selected.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetSelectedCandidatePair(const Tp::Candidate& localCandidate, const Tp::Candidate& remoteCandidate, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetSelectedCandidatePair"));
        callMessage << QVariant::fromValue(localCandidate) << QVariant::fromValue(remoteCandidate);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetEndpointState on the remote object.
     * 
     * Change the EndpointState of the endpoint.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param component
     *     
     *     The component whose state needs updating.
     *
     * \param state
     *     
     *     The new state of this component.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetEndpointState(uint component, uint state, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetEndpointState"));
        callMessage << QVariant::fromValue(component) << QVariant::fromValue(state);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AcceptSelectedCandidatePair on the remote object.
     * 
     * Called in response to CandidatePairSelected if/when this candidate pair 
     * is known to have passed its connectivity checks.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param localCandidate
     *     
     *     The local candidate that has been selected.
     *
     * \param remoteCandidate
     *     
     *     The remote candidate that has been selected.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AcceptSelectedCandidatePair(const Tp::Candidate& localCandidate, const Tp::Candidate& remoteCandidate, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AcceptSelectedCandidatePair"));
        callMessage << QVariant::fromValue(localCandidate) << QVariant::fromValue(remoteCandidate);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RejectSelectedCandidatePair on the remote object.
     * 
     * Called in response to CandidatePairSelected if/when this candidate pair 
     * is known to have failed its connectivity checks.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param localCandidate
     *     
     *     The local candidate that has been selected.
     *
     * \param remoteCandidate
     *     
     *     The remote candidate that has been selected.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RejectSelectedCandidatePair(const Tp::Candidate& localCandidate, const Tp::Candidate& remoteCandidate, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RejectSelectedCandidatePair"));
        callMessage << QVariant::fromValue(localCandidate) << QVariant::fromValue(remoteCandidate);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetControlling on the remote object.
     * 
     * Set whether the local side is taking the Controlling role. Note that if 
     * there are multiple endpoints (e.g. SIP call forking) it may be the case 
     * that all endpoints need to have the same controlling/controlled 
     * orientation.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param controlling
     *     
     *     The new value of Controlling.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetControlling(bool controlling, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetControlling"));
        callMessage << QVariant::fromValue(controlling);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c RemoteCredentialsSet on the remote object.
     * 
     * Emitted when the remote ICE credentials for the endpoint are set. If 
     * each candidate has different credentials, then this signal will never 
     * be fired.
     *
     * \param username
     *     
     *     The username set.
     *
     * \param password
     *     
     *     The password set.
     */
    void RemoteCredentialsSet(const QString& username, const QString& password);

    /**
     * Represents the signal \c RemoteCandidatesAdded on the remote object.
     * 
     * Emitted when remote candidates are added to the RemoteCandidates 
     * property.
     *
     * \param candidates
     *     
     *     The candidates that were added.
     */
    void RemoteCandidatesAdded(const Tp::CandidateList& candidates);

    /**
     * Represents the signal \c CandidatePairSelected on the remote object.
     * 
     * Emitted when a candidate is selected for use in the stream by the 
     * controlling side of an ICE session. The controlled side should call 
     * AcceptSelectedCandidatePair or RejectSelectedCandidatePair when 
     * connectivity checks have either succeeded or failed for this candidate 
     * pair. See also: SelectedCandidatePairs.
     *
     * \param localCandidate
     *     
     *     The local candidate that has been selected.
     *
     * \param remoteCandidate
     *     
     *     The remote candidate that has been selected.
     */
    void CandidatePairSelected(const Tp::Candidate& localCandidate, const Tp::Candidate& remoteCandidate);

    /**
     * Represents the signal \c EndpointStateChanged on the remote object.
     * 
     * Emitted when the EndpointState property changes.
     *
     * \param component
     *     
     *     The component whose state has changed.
     *
     * \param state
     *     
     *     The new state of this component.
     */
    void EndpointStateChanged(uint component, uint state);

    /**
     * Represents the signal \c ControllingChanged on the remote object.
     * 
     * The value of Controlling has changed.
     *
     * \param controlling
     *     
     *     The new value of Controlling.
     */
    void ControllingChanged(bool controlling);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::CallStreamEndpointInterface*)
