/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Http11AprProcessor;
import org.apache.coyote.http11.upgrade.AprProcessor;
import org.apache.coyote.http11.upgrade.UpgradeAprProcessor;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11AprProtocol
extends AbstractHttp11Protocol<Long> {
    private static final Log log = LogFactory.getLog(Http11AprProtocol.class);
    private final Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    @Override
    public boolean isAprRequired() {
        return true;
    }

    public Http11AprProtocol() {
        this.endpoint = new AprEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((AprEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public boolean getUseSendfile() {
        return ((AprEndpoint)this.endpoint).getUseSendfile();
    }

    public void setUseSendfile(boolean bl) {
        ((AprEndpoint)this.endpoint).setUseSendfile(bl);
    }

    public int getPollTime() {
        return ((AprEndpoint)this.endpoint).getPollTime();
    }

    public void setPollTime(int n) {
        ((AprEndpoint)this.endpoint).setPollTime(n);
    }

    public void setPollerSize(int n) {
        this.endpoint.setMaxConnections(n);
    }

    public int getPollerSize() {
        return this.endpoint.getMaxConnections();
    }

    public int getSendfileSize() {
        return ((AprEndpoint)this.endpoint).getSendfileSize();
    }

    public void setSendfileSize(int n) {
        ((AprEndpoint)this.endpoint).setSendfileSize(n);
    }

    public void setSendfileThreadCount(int n) {
        ((AprEndpoint)this.endpoint).setSendfileThreadCount(n);
    }

    public int getSendfileThreadCount() {
        return ((AprEndpoint)this.endpoint).getSendfileThreadCount();
    }

    public boolean getDeferAccept() {
        return ((AprEndpoint)this.endpoint).getDeferAccept();
    }

    public void setDeferAccept(boolean bl) {
        ((AprEndpoint)this.endpoint).setDeferAccept(bl);
    }

    public String getSSLProtocol() {
        return ((AprEndpoint)this.endpoint).getSSLProtocol();
    }

    public void setSSLProtocol(String string) {
        ((AprEndpoint)this.endpoint).setSSLProtocol(string);
    }

    public String getSSLPassword() {
        return ((AprEndpoint)this.endpoint).getSSLPassword();
    }

    public void setSSLPassword(String string) {
        ((AprEndpoint)this.endpoint).setSSLPassword(string);
    }

    public String getSSLCipherSuite() {
        return ((AprEndpoint)this.endpoint).getSSLCipherSuite();
    }

    public void setSSLCipherSuite(String string) {
        ((AprEndpoint)this.endpoint).setSSLCipherSuite(string);
    }

    public boolean getSSLHonorCipherOrder() {
        return ((AprEndpoint)this.endpoint).getSSLHonorCipherOrder();
    }

    public void setSSLHonorCipherOrder(boolean bl) {
        ((AprEndpoint)this.endpoint).setSSLHonorCipherOrder(bl);
    }

    public String getSSLCertificateFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateFile();
    }

    public void setSSLCertificateFile(String string) {
        ((AprEndpoint)this.endpoint).setSSLCertificateFile(string);
    }

    public String getSSLCertificateKeyFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String string) {
        ((AprEndpoint)this.endpoint).setSSLCertificateKeyFile(string);
    }

    public String getSSLCertificateChainFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String string) {
        ((AprEndpoint)this.endpoint).setSSLCertificateChainFile(string);
    }

    public String getSSLCACertificatePath() {
        return ((AprEndpoint)this.endpoint).getSSLCACertificatePath();
    }

    public void setSSLCACertificatePath(String string) {
        ((AprEndpoint)this.endpoint).setSSLCACertificatePath(string);
    }

    public String getSSLCACertificateFile() {
        return ((AprEndpoint)this.endpoint).getSSLCACertificateFile();
    }

    public void setSSLCACertificateFile(String string) {
        ((AprEndpoint)this.endpoint).setSSLCACertificateFile(string);
    }

    public String getSSLCARevocationPath() {
        return ((AprEndpoint)this.endpoint).getSSLCARevocationPath();
    }

    public void setSSLCARevocationPath(String string) {
        ((AprEndpoint)this.endpoint).setSSLCARevocationPath(string);
    }

    public String getSSLCARevocationFile() {
        return ((AprEndpoint)this.endpoint).getSSLCARevocationFile();
    }

    public void setSSLCARevocationFile(String string) {
        ((AprEndpoint)this.endpoint).setSSLCARevocationFile(string);
    }

    public String getSSLVerifyClient() {
        return ((AprEndpoint)this.endpoint).getSSLVerifyClient();
    }

    public void setSSLVerifyClient(String string) {
        ((AprEndpoint)this.endpoint).setSSLVerifyClient(string);
    }

    public int getSSLVerifyDepth() {
        return ((AprEndpoint)this.endpoint).getSSLVerifyDepth();
    }

    public void setSSLVerifyDepth(int n) {
        ((AprEndpoint)this.endpoint).setSSLVerifyDepth(n);
    }

    public boolean getSSLDisableCompression() {
        return ((AprEndpoint)this.endpoint).getSSLDisableCompression();
    }

    public void setSSLDisableCompression(boolean bl) {
        ((AprEndpoint)this.endpoint).setSSLDisableCompression(bl);
    }

    @Override
    protected String getNamePrefix() {
        return "http-apr";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<Long, Http11AprProcessor>
    implements AprEndpoint.Handler {
        protected Http11AprProtocol proto;

        Http11ConnectionHandler(Http11AprProtocol http11AprProtocol) {
            this.proto = http11AprProtocol;
        }

        @Override
        protected AbstractProtocol<Long> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public void release(SocketWrapper<Long> socketWrapper, Processor<Long> processor, boolean bl, boolean bl2) {
            processor.recycle(bl);
            this.recycledProcessors.offer(processor);
            if (bl2 && this.proto.endpoint.isRunning()) {
                ((AprEndpoint)this.proto.endpoint).getPoller().add(socketWrapper.getSocket(), this.proto.endpoint.getKeepAliveTimeout(), true, false);
            }
        }

        @Override
        protected void initSsl(SocketWrapper<Long> socketWrapper, Processor<Long> processor) {
        }

        @Override
        protected void longPoll(SocketWrapper<Long> socketWrapper, Processor<Long> processor) {
            if (processor.isAsync()) {
                socketWrapper.setAsync(true);
            } else if (processor.isComet()) {
                if (this.proto.endpoint.isRunning()) {
                    socketWrapper.setComet(true);
                    ((AprEndpoint)this.proto.endpoint).getPoller().add(socketWrapper.getSocket(), this.proto.endpoint.getSoTimeout(), true, false);
                } else {
                    ((AprEndpoint)this.proto.endpoint).processSocket(socketWrapper.getSocket(), SocketStatus.STOP);
                }
            } else if (processor.isUpgrade()) {
                AprEndpoint.Poller poller = ((AprEndpoint)this.proto.endpoint).getPoller();
                if (poller == null) {
                    this.release(socketWrapper, processor, true, false);
                } else {
                    poller.add(socketWrapper.getSocket(), -1, true, false);
                }
            } else {
                ((AprEndpoint)this.proto.endpoint).getPoller().add(socketWrapper.getSocket(), processor.getUpgradeInbound().getReadTimeout(), true, false);
            }
        }

        @Override
        protected Http11AprProcessor createProcessor() {
            Http11AprProcessor http11AprProcessor = new Http11AprProcessor(this.proto.getMaxHttpHeaderSize(), this.proto.getRejectIllegalHeader(), (AprEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize(), this.proto.getAllowedTrailerHeadersAsSet(), this.proto.getMaxExtensionSize(), this.proto.getMaxSwallowSize(), this.proto.getRelaxedPathChars(), this.proto.getRelaxedQueryChars());
            this.proto.configureProcessor(http11AprProcessor);
            http11AprProcessor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(http11AprProcessor);
            return http11AprProcessor;
        }

        @Override
        @Deprecated
        protected Processor<Long> createUpgradeProcessor(SocketWrapper<Long> socketWrapper, UpgradeInbound upgradeInbound) throws IOException {
            return new UpgradeAprProcessor(socketWrapper, upgradeInbound);
        }

        @Override
        protected Processor<Long> createUpgradeProcessor(SocketWrapper<Long> socketWrapper, HttpUpgradeHandler httpUpgradeHandler) throws IOException {
            return new AprProcessor(socketWrapper, httpUpgradeHandler, (AprEndpoint)this.proto.endpoint, this.proto.getUpgradeAsyncWriteBufferSize());
        }
    }
}

