/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoConvertNamesToTimes
implements UndoOperation {
    private int _startIndex;
    private int _endIndex;
    private String[] _waypointNames = null;
    private String[] _timestamps = null;

    public UndoConvertNamesToTimes(TrackInfo trackInfo) {
        this._startIndex = trackInfo.getSelection().getStart();
        this._endIndex = trackInfo.getSelection().getEnd();
        int n = this._endIndex - this._startIndex + 1;
        this._waypointNames = new String[n];
        this._timestamps = new String[n];
        int n2 = this._startIndex;
        while (n2 <= this._endIndex) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(n2);
            if (dataPoint.isWaypoint()) {
                this._waypointNames[n2 - this._startIndex] = dataPoint.getWaypointName();
                this._timestamps[n2 - this._startIndex] = dataPoint.getFieldValue(Field.TIMESTAMP);
            }
            ++n2;
        }
    }

    @Override
    public String getDescription() {
        return I18nManager.getText("undo.convertnamestotimes");
    }

    @Override
    public void performUndo(TrackInfo trackInfo) throws UndoException {
        Track track = trackInfo.getTrack();
        if (track.getNumPoints() <= this._endIndex || this._endIndex <= this._startIndex) {
            throw new UndoException("Cannot undo conversion, track length doesn't match");
        }
        int n = this._startIndex;
        while (n <= this._endIndex) {
            String string = this._waypointNames[n - this._startIndex];
            if (string != null) {
                DataPoint dataPoint = track.getPoint(n);
                dataPoint.setFieldValue(Field.WAYPT_NAME, string, true);
                dataPoint.setFieldValue(Field.TIMESTAMP, this._timestamps[n - this._startIndex], true);
            }
            ++n;
        }
        track.requestRescale();
        UpdateMessageBroker.informSubscribers();
    }
}

