
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : fricas-input.scm
;; DESCRIPTION : FriCAS input converters
;; COPYRIGHT   : (C) 1999, 2012  Joris van der Hoeven and Andrey Grozin
;;
;; This software falls under the GNU general public license version 3 or later.
;; It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
;; in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(texmacs-module (fricas-input)
  (:use (utils plugins plugin-convert)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Specific conversion routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (fricas-input-var-row r)
  (if (nnull? r)
      (begin
        (display ", ")
        (plugin-input (car r))
        (fricas-input-var-row (cdr r)))))

(define (fricas-input-row r)
  (display "[")
  (plugin-input (car r))
  (fricas-input-var-row (cdr r))
  (display "]"))

(define (fricas-input-var-rows t)
  (if (nnull? t)
      (begin
        (display ", ")
        (fricas-input-row (car t))
        (fricas-input-var-rows (cdr t)))))

(define (fricas-input-rows t)
  (display "matrix([")
  (fricas-input-row (car t))
  (fricas-input-var-rows (cdr t))
  (display "])"))

(define (fricas-input-descend-last args)
  (if (null? (cdr args))
      (plugin-input (car args))
      (fricas-input-descend-last (cdr args))))

(define (fricas-input-det args)
  (display "determinant(")
  (fricas-input-descend-last args)
  (display ")"))

(define (fricas-input-big-around args)
  (let* ((b `(big-around ,@args))
         (op (big-name b))
         (sub (big-subscript b))
         (sup (big-supscript b))
         (body (big-body b)))
    (cond
        ((== op "int")
            (begin (display "integrate(") (plugin-input body)
                (if (and sub sup)
                    (begin (display "=") (plugin-input sub)
                        (display "..") (plugin-input sup)))))
        ((== op "sum")
            (begin (display "sum(") (plugin-input body)
                (cond
                    ((and sub sup)
                        (begin (display ",")
                            (plugin-input (texmacs->code (tm->tree sub)))
                            (display "..") (plugin-input sup)))
                    (sub (begin (display ",") (plugin-input sub))))))
        ((== op "prod")
            (begin (display "product(") (plugin-input body)
                (cond
                    ((and sub sup)
                        (begin (display ",")
                            (plugin-input (texmacs->code (tm->tree sub)))
                            (display "..") (plugin-input sup)))
                    (sub (begin (display ",") (plugin-input sub))))))
        (else (display op) (display "(") (plugin-input body)))
    (display ")")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Initialization
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (send-fricas-identifier arg)
;;  (display "_<") (display (substring arg 1 (- (string-length arg) 1))) (display "_>")
;;  (display "_<")
;;  (cond ((== (substring arg 0 3) "<b-") (begin (display "b_-") (display (substring arg 3 (- (string-length arg) 1))) ))
;;        ((== (substring arg 0 5) "<cal-") (begin (display "cal_-") (display (substring arg 5 (- (string-length arg) 1))) ))
;;        ((== (substring arg 0 6) "<frak-") (begin (display "frak_-") (display (substring arg 6 (- (string-length arg) 1))) ))
;;        ((== (substring arg 0 5) "<bbb-") (begin (display "bbb_-") (display (substring arg 5 (- (string-length arg) 1))) ))
;;        (else (display (substring arg 1 (- (string-length arg) 1))) )
;;  )
;;  (display "_>")
;;  (display (cork->utf8 arg))
  (display arg)
)

(plugin-input-converters fricas
  (rows fricas-input-rows)
  (det fricas-input-det)
  (big-around fricas-input-big-around)
  ("<infty>"      "%infinity")
  ("<emptyset>"   "[]")
  ("<mathd>"      "1,")
;;  ("<pi>"         "%pi")
  ("<mathpi>"     "%pi")
  ("<mathi>"      "%i")
  ("<mathe>"      "%e")
  ("<ldots>"      " .. ")
  ("<cdots>"      " .. ")

  ("<mapsto>"     " +-> ")
  ("<assign>"     " := ")
  ("<hbar>"       display)

  ("<Mho>"        display)
  ("<aleph>"      display)
  ("<beth>"       display)
  ("<gimel>"      display)
  ("<daleth>"     display)

  ("<alpha>"      display)
  ("<beta>"       display)
  ("<gamma>"      display)
  ("<delta>"      display)
  ("<epsilon>"    display)
  ("<varepsilon>" display)
  ("<zeta>"       display)
  ("<eta>"        display)
  ("<theta>"      display)
  ("<vartheta>"   display)
  ("<iota>"       display)
  ("<kappa>"      display)
  ("<lambda>"     display)
  ("<mu>"         display)
  ("<nu>"         display)
  ("<xi>"         display)
  ("<omicron>"    display)
  ("<pi>"         display)
  ("<varpi>"      display)
  ("<rho>"        display)
  ("<varrho>"     display)
  ("<sigma>"      display)
  ("<varsigma>"   display)
  ("<tau>"        display)
  ("<upsilon>"    display)
  ("<phi>"        display)
  ("<varphi>"     display)
  ("<chi>"        display)
  ("<psi>"        display)
  ("<omega>"      display)
  ("<Gamma>"      display)
  ("<Delta>"      display)
  ("<Theta>"      display)
  ("<Lambda>"     display)
  ("<Xi>"         display)
  ("<Pi>"         display)
  ("<Sigma>"      display)
  ("<Upsilon>"    display)
  ("<Phi>"        display)
  ("<Psi>"        display)
  ("<Omega>"      display)

  ("<b-0>" display)
  ("<b-1>" display)
  ("<b-2>" display)
  ("<b-3>" display)
  ("<b-4>" display)
  ("<b-5>" display)
  ("<b-6>" display)
  ("<b-7>" display)
  ("<b-8>" display)
  ("<b-9>" display)
  
  ("<b-a>" display)
  ("<b-b>" display)
  ("<b-c>" display)
  ("<b-d>" display)
  ("<b-e>" display)
  ("<b-f>" display)
  ("<b-g>" display)
  ("<b-h>" display)
  ("<b-i>" display)
  ("<b-j>" display)
  ("<b-k>" display)
  ("<b-l>" display)
  ("<b-m>" display)
  ("<b-n>" display)
  ("<b-o>" display)
  ("<b-p>" display)
  ("<b-q>" display)
  ("<b-r>" display)
  ("<b-s>" display)
  ("<b-t>" display)
  ("<b-u>" display)
  ("<b-v>" display)
  ("<b-w>" display)
  ("<b-x>" display)
  ("<b-y>" display)
  ("<b-z>" display)
  ("<b-A>" display)
  ("<b-B>" display)
  ("<b-C>" display)
  ("<b-D>" display)
  ("<b-E>" display)
  ("<b-F>" display)
  ("<b-G>" display)
  ("<b-H>" display)
  ("<b-I>" display)
  ("<b-J>" display)
  ("<b-K>" display)
  ("<b-L>" display)
  ("<b-M>" display)
  ("<b-N>" display)
  ("<b-O>" display)
  ("<b-P>" display)
  ("<b-Q>" display)
  ("<b-R>" display)
  ("<b-S>" display)
  ("<b-T>" display)
  ("<b-U>" display)
  ("<b-V>" display)
  ("<b-W>" display)
  ("<b-X>" display)
  ("<b-Y>" display)
  ("<b-Z>" display)

  ("<b-up-A>" display)
  ("<b-up-B>" display)
  ("<b-up-C>" display)
  ("<b-up-D>" display)
  ("<b-up-E>" display)
  ("<b-up-F>" display)
  ("<b-up-G>" display)
  ("<b-up-H>" display)
  ("<b-up-I>" display)
  ("<b-up-J>" display)
  ("<b-up-K>" display)
  ("<b-up-L>" display)
  ("<b-up-M>" display)
  ("<b-up-N>" display)
  ("<b-up-O>" display)
  ("<b-up-P>" display)
  ("<b-up-Q>" display)
  ("<b-up-R>" display)
  ("<b-up-S>" display)
  ("<b-up-T>" display)
  ("<b-up-U>" display)
  ("<b-up-V>" display)
  ("<b-up-W>" display)
  ("<b-up-X>" display)
  ("<b-up-Y>" display)
  ("<b-up-Z>" display)
  ("<b-up-a>" display)
  ("<b-up-b>" display)
  ("<b-up-c>" display)
  ("<b-up-d>" display)
  ("<b-up-e>" display)
  ("<b-up-f>" display)
  ("<b-up-g>" display)
  ("<b-up-h>" display)
  ("<b-up-i>" display)
  ("<b-up-j>" display)
  ("<b-up-k>" display)
  ("<b-up-l>" display)
  ("<b-up-m>" display)
  ("<b-up-n>" display)
  ("<b-up-o>" display)
  ("<b-up-p>" display)
  ("<b-up-q>" display)
  ("<b-up-r>" display)
  ("<b-up-s>" display)
  ("<b-up-t>" display)
  ("<b-up-u>" display)
  ("<b-up-v>" display)
  ("<b-up-w>" display)
  ("<b-up-x>" display)
  ("<b-up-y>" display)
  ("<b-up-z>" display)
 
  ("<b-alpha>"      display)
  ("<b-beta>"       display)
  ("<b-gamma>"      display)
  ("<b-delta>"      display)
  ("<b-epsilon>"    display)
  ("<b-varepsilon>" display)
  ("<b-zeta>"       display)
  ("<b-eta>"        display)
  ("<b-theta>"      display)
  ("<b-vartheta>"   display)
  ("<b-iota>"       display)
  ("<b-kappa>"      display)
  ("<b-lambda>"     display)
  ("<b-mu>"         display)
  ("<b-nu>"         display)
  ("<b-xi>"         display)
  ("<b-omicron>"    display)
  ("<b-pi>"         display)
  ("<b-varpi>"      display)
  ("<b-rho>"        display)
  ("<b-varrho>"     display)
  ("<b-sigma>"      display)
  ("<b-varsigma>"   display)
  ("<b-tau>"        display)
  ("<b-upsilon>"    display)
  ("<b-phi>"        display)
  ("<b-varphi>"     display)
  ("<b-chi>"        display)
  ("<b-psi>"        display)
  ("<b-omega>"      display)
  ("<b-Gamma>"      display)
  ("<b-Delta>"      display)
  ("<b-Theta>"      display)
  ("<b-Lambda>"     display)
  ("<b-Xi>"         display)
  ("<b-Pi>"         display)
  ("<b-Sigma>"      display)
  ("<b-Upsilon>"    display)
  ("<b-Phi>"        display)
  ("<b-Psi>"        display)
  ("<b-Omega>"      display)

  ("<cal-A>" display)
  ("<cal-B>" display)
  ("<cal-C>" display)
  ("<cal-D>" display)
  ("<cal-E>" display)
  ("<cal-F>" display)
  ("<cal-G>" display)
  ("<cal-H>" display)
  ("<cal-I>" display)
  ("<cal-J>" display)
  ("<cal-K>" display)
  ("<cal-L>" display)
  ("<cal-M>" display)
  ("<cal-N>" display)
  ("<cal-O>" display)
  ("<cal-P>" display)
  ("<cal-Q>" display)
  ("<cal-R>" display)
  ("<cal-S>" display)
  ("<cal-T>" display)
  ("<cal-U>" display)
  ("<cal-V>" display)
  ("<cal-W>" display)
  ("<cal-X>" display)
  ("<cal-Y>" display)
  ("<cal-Z>" display)
  ("<cal-a>" display)
  ("<cal-b>" display)
  ("<cal-c>" display)
  ("<cal-d>" display)
  ("<cal-e>" display)
  ("<cal-f>" display)
  ("<cal-g>" display)
  ("<cal-h>" display)
  ("<cal-i>" display)
  ("<cal-j>" display)
  ("<cal-k>" display)
  ("<cal-l>" display)
  ("<cal-m>" display)
  ("<cal-n>" display)
  ("<cal-o>" display)
  ("<cal-p>" display)
  ("<cal-q>" display)
  ("<cal-r>" display)
  ("<cal-s>" display)
  ("<cal-t>" display)
  ("<cal-u>" display)
  ("<cal-v>" display)
  ("<cal-w>" display)
  ("<cal-x>" display)
  ("<cal-y>" display)
  ("<cal-z>" display)

  ("<frak-a>" display)
  ("<frak-b>" display)
  ("<frak-c>" display)
  ("<frak-d>" display)
  ("<frak-e>" display)
  ("<frak-f>" display)
  ("<frak-g>" display)
  ("<frak-h>" display)
  ("<frak-i>" display)
  ("<frak-j>" display)
  ("<frak-k>" display)
  ("<frak-l>" display)
  ("<frak-m>" display)
  ("<frak-n>" display)
  ("<frak-o>" display)
  ("<frak-p>" display)
  ("<frak-q>" display)
  ("<frak-r>" display)
  ("<frak-s>" display)
  ("<frak-t>" display)
  ("<frak-u>" display)
  ("<frak-v>" display)
  ("<frak-w>" display)
  ("<frak-x>" display)
  ("<frak-y>" display)
  ("<frak-z>" display)
  ("<frak-A>" display)
  ("<frak-B>" display)
  ("<frak-C>" display)
  ("<frak-D>" display)
  ("<frak-E>" display)
  ("<frak-F>" display)
  ("<frak-G>" display)
  ("<frak-H>" display)
  ("<frak-I>" display)
  ("<frak-J>" display)
  ("<frak-K>" display)
  ("<frak-L>" display)
  ("<frak-M>" display)
  ("<frak-N>" display)
  ("<frak-O>" display)
  ("<frak-P>" display)
  ("<frak-Q>" display)
  ("<frak-R>" display)
  ("<frak-S>" display)
  ("<frak-T>" display)
  ("<frak-U>" display)
  ("<frak-V>" display)
  ("<frak-W>" display)
  ("<frak-X>" display)
  ("<frak-Y>" display)
  ("<frak-Z>" display)

  ("<bbb-a>" display)
  ("<bbb-b>" display)
  ("<bbb-c>" display)
  ("<bbb-d>" display)
  ("<bbb-e>" display)
  ("<bbb-f>" display)
  ("<bbb-g>" display)
  ("<bbb-h>" display)
  ("<bbb-i>" display)
  ("<bbb-j>" display)
  ("<bbb-k>" display)
  ("<bbb-l>" display)
  ("<bbb-m>" display)
  ("<bbb-n>" display)
  ("<bbb-o>" display)
  ("<bbb-p>" display)
  ("<bbb-q>" display)
  ("<bbb-r>" display)
  ("<bbb-s>" display)
  ("<bbb-t>" display)
  ("<bbb-u>" display)
  ("<bbb-v>" display)
  ("<bbb-w>" display)
  ("<bbb-x>" display)
  ("<bbb-y>" display)
  ("<bbb-z>" display)
  ("<bbb-A>" display)
  ("<bbb-B>" display)
  ("<bbb-C>" display)
  ("<bbb-D>" display)
  ("<bbb-E>" display)
  ("<bbb-F>" display)
  ("<bbb-G>" display)
  ("<bbb-H>" display)
  ("<bbb-I>" display)
  ("<bbb-J>" display)
  ("<bbb-K>" display)
  ("<bbb-L>" display)
  ("<bbb-M>" display)
  ("<bbb-N>" display)
  ("<bbb-O>" display)
  ("<bbb-P>" display)
  ("<bbb-Q>" display)
  ("<bbb-R>" display)
  ("<bbb-S>" display)
  ("<bbb-T>" display)
  ("<bbb-U>" display)
  ("<bbb-V>" display)
  ("<bbb-W>" display)
  ("<bbb-X>" display)
  ("<bbb-Y>" display)
  ("<bbb-Z>" display)

;;  ("<less>" display)
;;  ("<gtr>" display)
)
