/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.jar.JarFile;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JarResource;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;

public class JavacErrorDetail {
    private String javaFileName;
    private int javaLineNum;
    private String jspFileName;
    private int jspBeginLineNum;
    private StringBuilder errMsg;
    private String jspExtract = null;

    public JavacErrorDetail(String string, int n, StringBuilder stringBuilder) {
        this.javaFileName = string;
        this.javaLineNum = n;
        this.errMsg = stringBuilder;
        this.jspBeginLineNum = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavacErrorDetail(String string, int n, String string2, int n2, StringBuilder stringBuilder, JspCompilationContext jspCompilationContext) {
        this(string, n, stringBuilder);
        this.jspFileName = string2;
        this.jspBeginLineNum = n2;
        if (n2 > 0 && jspCompilationContext != null) {
            InputStream inputStream = null;
            FileInputStream fileInputStream = null;
            try {
                int n3;
                CharSequence charSequence;
                JarFile jarFile = null;
                JarResource jarResource = jspCompilationContext.getTagFileJarResource();
                if (jarResource != null) {
                    jarFile = jarResource.getJarFile();
                }
                inputStream = JspUtil.getInputStream(string2, jarFile, jspCompilationContext, null);
                String[] stringArray = this.readFile(inputStream);
                fileInputStream = new FileInputStream(jspCompilationContext.getServletJavaFileName());
                String[] stringArray2 = this.readFile(fileInputStream);
                if (stringArray.length < n2) {
                    this.jspExtract = Localizer.getMessage("jsp.error.bug48498");
                    return;
                }
                if (stringArray[n2 - 1].lastIndexOf("<%") > stringArray[n2 - 1].lastIndexOf("%>")) {
                    charSequence = stringArray2[n - 1].trim();
                    for (n3 = n2 - 1; n3 < stringArray.length; ++n3) {
                        if (stringArray[n3].indexOf((String)charSequence) == -1) continue;
                        this.jspBeginLineNum = n3 + 1;
                        break;
                    }
                }
                charSequence = new StringBuilder(1024);
                n3 = Math.max(0, this.jspBeginLineNum - 1 - 3);
                int n4 = Math.min(stringArray.length - 1, this.jspBeginLineNum - 1 + 3);
                for (int i = n3; i <= n4; ++i) {
                    ((StringBuilder)charSequence).append(i + 1);
                    ((StringBuilder)charSequence).append(": ");
                    ((StringBuilder)charSequence).append(stringArray[i]);
                    ((StringBuilder)charSequence).append(Constants.NEWLINE);
                }
                this.jspExtract = ((StringBuilder)charSequence).toString();
            }
            catch (JasperException jasperException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public String getJavaFileName() {
        return this.javaFileName;
    }

    public int getJavaLineNumber() {
        return this.javaLineNum;
    }

    public String getJspFileName() {
        return this.jspFileName;
    }

    public int getJspBeginLineNumber() {
        return this.jspBeginLineNum;
    }

    public String getErrorMessage() {
        return this.errMsg.toString();
    }

    public String getJspExtract() {
        return this.jspExtract;
    }

    private String[] readFile(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }
}

