/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.util.res.StringManager;

public class CoyoteInputStream
extends ServletInputStream {
    protected static final StringManager sm = StringManager.getManager(CoyoteInputStream.class);
    protected InputBuffer ib;

    protected CoyoteInputStream(InputBuffer inputBuffer) {
        this.ib = inputBuffer;
    }

    void clear() {
        this.ib = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int read() throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer n = CoyoteInputStream.this.ib.readByte();
                        return n;
                    }
                });
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.readByte();
    }

    public int available() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer n = CoyoteInputStream.this.ib.available();
                        return n;
                    }
                });
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.available();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(final byte[] byArray, final int n, final int n2) throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n3 = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer n3 = CoyoteInputStream.this.ib.read(byArray, n, n2);
                        return n3;
                    }
                });
                return n3;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.read(byArray, n, n2);
    }

    public int read(final ByteBuffer byteBuffer) throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer n = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer n = CoyoteInputStream.this.ib.read(byteBuffer);
                        return n;
                    }
                });
                return n;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        }
        return this.ib.read(byteBuffer);
    }

    public void close() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        CoyoteInputStream.this.ib.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception.getMessage(), exception);
            }
        } else {
            this.ib.close();
        }
    }

    public boolean isFinished() {
        return this.ib.isFinished();
    }

    public boolean isReady() {
        return this.ib.isReady();
    }

    public void setReadListener(ReadListener readListener) {
        this.ib.setReadListener(readListener);
    }

    private void checkNonBlockingRead() {
        if (!this.ib.isBlocking() && !this.ib.isReady()) {
            throw new IllegalStateException(sm.getString("coyoteInputStream.nbNotready"));
        }
    }
}

