/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server;

import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntimeCPU;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerServer;
import org.graalvm.visualvm.lib.jfluid.server.SamplingThread;
import org.graalvm.visualvm.lib.jfluid.server.ThreadInfo;

public class ProfilerRuntimeCPUSampledInstr
extends ProfilerRuntimeCPU {
    protected static int samplingInterval = 10;
    protected static SamplingThread st;

    public static void setSamplingInterval(int v) {
        samplingInterval = v;
    }

    public static void enableProfiling(boolean v) {
        if (v) {
            ProfilerRuntimeCPUSampledInstr.createNewDataStructures();
            ProfilerRuntimeCPU.enableProfiling(v);
        } else {
            ProfilerRuntimeCPU.enableProfiling(v);
            ProfilerRuntimeCPUSampledInstr.clearDataStructures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void markerMethodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!ti.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0 || ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            ti.initialize();
            ti.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++ti.inProfilingRuntimeMethod;
                ti.inCallGraph = true;
                ProfilerRuntimeCPUSampledInstr.writeThreadCreationEvent(ti);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            ++ti.inProfilingRuntimeMethod;
            ti.inCallGraph = true;
        }
        {
            if (ti.stackDepth <= stackDepthLimit) {
                int methodIdInt = methodId & 0xFF;
                if (!instrMethodInvoked[methodIdInt |= methodId & 0xFF00]) {
                    ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[methodIdInt] = true;
                    if (ti.rootMethodStackDepth > 0) {
                        ProfilerRuntimeCPUSampledInstr.firstTimeMethodInvoke(ti, methodId);
                    }
                }
                ProfilerServer.notifyClientOnResultsAvailability();
                ProfilerRuntimeCPUSampledInstr.writeParametersEvent(ti);
                if (ti.stackDepth > 0) {
                    if (!ti.sampleDue) {
                        ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)18, ti, methodId);
                    } else {
                        ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)3, ti, methodId);
                        ti.sampleDue = false;
                    }
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)3, ti, methodId);
                }
            }
            ++ti.stackDepth;
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    public static void markerMethodExit(char methodId) {
        ProfilerRuntimeCPUSampledInstr.markerMethodExit(NO_RET_VALUE, methodId);
    }

    public static void markerMethodExit(Object ret, char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            --ti.stackDepth;
            if (ti.stackDepth < 1) {
                ti.inCallGraph = false;
                ProfilerRuntimeCPUSampledInstr.writeRetValue(ret, ti);
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)4, ti, methodId);
            } else if (ti.stackDepth <= stackDepthLimit) {
                if (!ti.sampleDue) {
                    ProfilerRuntimeCPUSampledInstr.writeRetValue(ret, ti);
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)19, ti, methodId);
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeRetValue(ret, ti);
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)4, ti, methodId);
                    ti.sampleDue = false;
                }
            }
            --ti.inProfilingRuntimeMethod;
        }
    }

    public static void methodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            if (ti.stackDepth <= stackDepthLimit) {
                int methodIdInt = methodId & 0xFF;
                if (!instrMethodInvoked[methodIdInt |= methodId & 0xFF00]) {
                    ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[methodIdInt] = true;
                    ProfilerRuntimeCPUSampledInstr.firstTimeMethodInvoke(ti, methodId);
                }
                if (!ti.sampleDue) {
                    if (methodId <= '\u3fff') {
                        ProfilerRuntimeCPUSampledInstr.writeCompactEvent(ti, (char)(0x8000 | methodId));
                    } else {
                        ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)16, ti, methodId);
                    }
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)6, ti, methodId);
                    ti.sampleDue = false;
                }
            }
            ++ti.stackDepth;
            --ti.inProfilingRuntimeMethod;
        }
    }

    public static void methodExit(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            if (ti.rootMethodStackDepth == ti.stackDepth) {
                ti.rootMethodStackDepth = 0;
            }
            --ti.stackDepth;
            if (ti.stackDepth < 1) {
                ti.inCallGraph = false;
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)2, ti, methodId);
            } else if (ti.rootMethodStackDepth == 0) {
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)2, ti, methodId);
            } else if (ti.stackDepth <= stackDepthLimit) {
                if (!ti.sampleDue) {
                    if ((methodId = (char)methodId) <= '\u3fff') {
                        ProfilerRuntimeCPUSampledInstr.writeCompactEvent(ti, (char)(0xC000 | methodId));
                    } else {
                        ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)17, ti, methodId);
                    }
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)7, ti, methodId);
                    ti.sampleDue = false;
                }
            }
            --ti.inProfilingRuntimeMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rootMethodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ProfilerServer.notifyClientOnResultsAvailability();
        if (ti.isInitialized() && !ti.inCallGraph && ti.stackDepth > 0) {
            ti.inCallGraph = true;
            ProfilerRuntimeCPUSampledInstr.methodEntry(methodId);
            ti.inCallGraph = false;
            return;
        }
        if (ti.isInitialized() && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            ProfilerRuntimeCPUSampledInstr.methodEntry(methodId);
            return;
        }
        if (!ti.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0) return;
            if (ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            ti.initialize();
            ti.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++ti.inProfilingRuntimeMethod;
                if (!ProfilerServer.startProfilingPointsActive()) {
                    ti.inCallGraph = true;
                }
                ProfilerRuntimeCPUSampledInstr.writeThreadCreationEvent(ti);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            ++ti.inProfilingRuntimeMethod;
            if (ti.stackDepth == 0 && !ProfilerServer.startProfilingPointsActive()) {
                ti.inCallGraph = true;
            }
        }
        {
            int methodIdInt = methodId & 0xFF;
            if (!instrMethodInvoked[methodIdInt |= methodId & 0xFF00]) {
                ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[methodIdInt] = true;
                if (enableFirstTimeMethodInvoke) {
                    externalActionsHandler.handleFirstTimeMethodInvoke(methodId);
                }
            }
            ++ti.stackDepth;
            ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)1, ti, methodId);
            ti.rootMethodStackDepth = ti.stackDepth;
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeCPU.clearDataStructures();
        if (st != null) {
            st.terminate();
        }
    }

    protected static void createNewDataStructures() {
        ProfilerRuntimeCPU.createNewDataStructures();
        st = new TimeSampler(samplingInterval);
        st.start();
    }

    static void writeCompactEvent(ThreadInfo ti, char event) {
        ti.evBuf[ti.evBufPos++] = (byte)(event >> 8 & 0xFF);
        ti.evBuf[ti.evBufPos++] = (byte)(event & 0xFF);
        if (ti.evBufPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPUSampledInstr.copyLocalBuffer(ti);
        }
    }

    static void writeUnstampedEvent(byte eventType, ThreadInfo ti, char methodId) {
        byte[] evBuf = ti.evBuf;
        int curPos = ti.evBufPos;
        evBuf[curPos++] = eventType;
        evBuf[curPos++] = (byte)(methodId >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(methodId & 0xFF);
        ti.evBufPos = curPos;
        if (curPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPUSampledInstr.copyLocalBuffer(ti);
        }
    }

    static class TimeSampler
    extends SamplingThread {
        TimeSampler(int sampilingInterval) {
            super(sampilingInterval);
            this.setName("*** Profiler Agent Special Execution Thread 9");
        }

        void sample() {
            ThreadInfo.setSampleDueForAllThreads();
        }
    }
}

