/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import java.io.IOException;
import java.io.InputStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class InputSourceStream
implements PullSourceStream {
    protected InputStream stream;
    protected boolean eosReached;
    ContentDescriptor contentType;

    public InputSourceStream(InputStream s, ContentDescriptor type) {
        this.stream = s;
        this.eosReached = false;
        this.contentType = type;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.contentType;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean willReadBlock() {
        if (this.eosReached) {
            return true;
        }
        try {
            return this.stream.available() == 0;
        }
        catch (IOException e) {
            return true;
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = this.stream.read(buffer, offset, length);
        if (bytesRead == -1) {
            this.eosReached = true;
        }
        return bytesRead;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public boolean endOfStream() {
        return this.eosReached;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlName) {
        return null;
    }
}

