/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ContextData {
    private static final int[] DEFAULT_ACTIVE = new int[]{2055, 2056, 1027, 1283, 1539, 2052, 2053, 2054, 2057, 2058, 2059, 1025, 1281, 1537, 1026, 771, 769, 770, 515, 513, 514, 257};
    private final ProvSSLContextSpi context;
    private final JcaTlsCrypto crypto;
    private final X509ExtendedKeyManager x509KeyManager;
    private final BCX509ExtendedTrustManager x509TrustManager;
    private final ProvSSLSessionContext clientSessionContext;
    private final ProvSSLSessionContext serverSessionContext;
    private final Map<Integer, SignatureSchemeInfo> signatureSchemesMap;

    private static void addSignatureScheme(JcaTlsCrypto jcaTlsCrypto, Map<Integer, SignatureSchemeInfo> map, int n, String string, String string2, String string3) {
        boolean bl = jcaTlsCrypto.hasSignatureScheme(n);
        AlgorithmParameters algorithmParameters = null;
        if (bl) {
            try {
                algorithmParameters = jcaTlsCrypto.getSignatureAlgorithmParameters(n);
            }
            catch (GeneralSecurityException generalSecurityException) {
                bl = false;
            }
        }
        SignatureSchemeInfo signatureSchemeInfo = new SignatureSchemeInfo(n, string, string2, string3, algorithmParameters, bl);
        if (null != map.put(n, signatureSchemeInfo)) {
            throw new IllegalStateException("Duplicate entries for SignatureSchemeInfo");
        }
    }

    private static void addSignatureScheme(JcaTlsCrypto jcaTlsCrypto, Map<Integer, SignatureSchemeInfo> map, int n, String string, String string2) {
        String string3 = SignatureScheme.getName(n);
        ContextData.addSignatureScheme(jcaTlsCrypto, map, n, string3, string, string2);
    }

    private static void addSignatureSchemeHistorical(JcaTlsCrypto jcaTlsCrypto, Map<Integer, SignatureSchemeInfo> map, int n, String string, String string2, String string3) {
        ContextData.addSignatureScheme(jcaTlsCrypto, map, n, string, string2, string3);
    }

    private static void addSignatureSchemeLegacy(JcaTlsCrypto jcaTlsCrypto, Map<Integer, SignatureSchemeInfo> map, int n, String string, String string2) {
        ContextData.addSignatureScheme(jcaTlsCrypto, map, n, string, string2);
    }

    private static Map<Integer, SignatureSchemeInfo> createSignatureSchemesMap(ProvSSLContextSpi provSSLContextSpi, JcaTlsCrypto jcaTlsCrypto) {
        TreeMap<Integer, SignatureSchemeInfo> treeMap = new TreeMap<Integer, SignatureSchemeInfo>();
        ContextData.addSignatureScheme(jcaTlsCrypto, treeMap, 1025, "SHA256withRSA", "RSA");
        ContextData.addSignatureScheme(jcaTlsCrypto, treeMap, 1281, "SHA384withRSA", "RSA");
        ContextData.addSignatureScheme(jcaTlsCrypto, treeMap, 1537, "SHA512withRSA", "RSA");
        ContextData.addSignatureScheme(jcaTlsCrypto, treeMap, 1027, "SHA256withECDSA", "EC");
        ContextData.addSignatureScheme(jcaTlsCrypto, treeMap, 1283, "SHA384withECDSA", "EC");
        ContextData.addSignatureScheme(jcaTlsCrypto, treeMap, 1539, "SHA512withECDSA", "EC");
        if (!provSSLContextSpi.isFips()) {
            ContextData.addSignatureScheme(jcaTlsCrypto, treeMap, 2055, "Ed25519", "Ed25519");
            ContextData.addSignatureScheme(jcaTlsCrypto, treeMap, 2056, "Ed448", "Ed448");
        }
        ContextData.addSignatureSchemeLegacy(jcaTlsCrypto, treeMap, 513, "SHA1withRSA", "RSA");
        ContextData.addSignatureSchemeLegacy(jcaTlsCrypto, treeMap, 515, "SHA1withECDSA", "EC");
        ContextData.addSignatureSchemeHistorical(jcaTlsCrypto, treeMap, 257, "rsa_md5", "MD5withRSA", "RSA");
        ContextData.addSignatureSchemeHistorical(jcaTlsCrypto, treeMap, 769, "rsa_sha224", "SHA224withRSA", "RSA");
        ContextData.addSignatureSchemeHistorical(jcaTlsCrypto, treeMap, 514, "dsa_sha1", "SHA1withDSA", "DSA");
        ContextData.addSignatureSchemeHistorical(jcaTlsCrypto, treeMap, 770, "dsa_sha224", "SHA224withDSA", "DSA");
        ContextData.addSignatureSchemeHistorical(jcaTlsCrypto, treeMap, 1026, "dsa_sha256", "SHA256withDSA", "DSA");
        ContextData.addSignatureSchemeHistorical(jcaTlsCrypto, treeMap, 771, "ecdsa_sha224", "SHA224withECDSA", "EC");
        return Collections.unmodifiableMap(treeMap);
    }

    ContextData(ProvSSLContextSpi provSSLContextSpi, JcaTlsCrypto jcaTlsCrypto, X509ExtendedKeyManager x509ExtendedKeyManager, BCX509ExtendedTrustManager bCX509ExtendedTrustManager) {
        this.context = provSSLContextSpi;
        this.crypto = jcaTlsCrypto;
        this.x509KeyManager = x509ExtendedKeyManager;
        this.x509TrustManager = bCX509ExtendedTrustManager;
        this.clientSessionContext = new ProvSSLSessionContext(this);
        this.serverSessionContext = new ProvSSLSessionContext(this);
        this.signatureSchemesMap = ContextData.createSignatureSchemesMap(provSSLContextSpi, jcaTlsCrypto);
    }

    List<SignatureSchemeInfo> getActiveSignatureSchemes(ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray) {
        if (!ProtocolVersion.contains(protocolVersionArray, ProtocolVersion.TLSv12)) {
            return null;
        }
        BCAlgorithmConstraints bCAlgorithmConstraints = provSSLParameters.getAlgorithmConstraints();
        int n = DEFAULT_ACTIVE.length;
        ArrayList<SignatureSchemeInfo> arrayList = new ArrayList<SignatureSchemeInfo>(n);
        for (int i = 0; i < n; ++i) {
            SignatureSchemeInfo signatureSchemeInfo = this.signatureSchemesMap.get(DEFAULT_ACTIVE[i]);
            if (null == signatureSchemeInfo || !signatureSchemeInfo.isActive(bCAlgorithmConstraints)) continue;
            arrayList.add(signatureSchemeInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    ProvSSLContextSpi getContext() {
        return this.context;
    }

    JcaTlsCrypto getCrypto() {
        return this.crypto;
    }

    ProvSSLSessionContext getClientSessionContext() {
        return this.clientSessionContext;
    }

    ProvSSLSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    Vector<SignatureAndHashAlgorithm> getSignatureAndHashAlgorithms(List<SignatureSchemeInfo> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        int n = list.size();
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(n);
        for (SignatureSchemeInfo signatureSchemeInfo : list) {
            if (null == signatureSchemeInfo) continue;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = signatureSchemeInfo.getSignatureAndHashAlgorithm();
            vector.add(signatureAndHashAlgorithm);
        }
        if (vector.isEmpty()) {
            return null;
        }
        vector.trimToSize();
        return vector;
    }

    List<SignatureSchemeInfo> getSignatureSchemes(Vector<SignatureAndHashAlgorithm> vector) {
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        int n = vector.size();
        ArrayList<SignatureSchemeInfo> arrayList = new ArrayList<SignatureSchemeInfo>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            SignatureSchemeInfo signatureSchemeInfo;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = vector.elementAt(i);
            if (null == signatureAndHashAlgorithm || null == (signatureSchemeInfo = this.signatureSchemesMap.get(n2 = SignatureSchemeInfo.getSignatureScheme(signatureAndHashAlgorithm)))) continue;
            arrayList.add(signatureSchemeInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.x509KeyManager;
    }

    BCX509ExtendedTrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }
}

