/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.io.ObjectStreamField;
import com.sun.corba.se.impl.io.ValueUtility;
import com.sun.corba.se.impl.util.RepositoryId;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.omg.CORBA.ValueMember;
import sun.corba.Bridge;
import sun.misc.JavaSecurityAccess;
import sun.misc.SharedSecrets;

public class ObjectStreamClass
implements Serializable {
    private static final boolean DEBUG_SVUID = false;
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class<?>[] noTypesList = new Class[0];
    private boolean isEnum;
    private static final Bridge bridge = AccessController.doPrivileged(new PrivilegedAction<Bridge>(){

        @Override
        public Bridge run() {
            return Bridge.get();
        }
    });
    private static final PersistentFieldsValue persistentFieldsValue = new PersistentFieldsValue();
    public static final int CLASS_MASK = 1553;
    public static final int FIELD_MASK = 223;
    public static final int METHOD_MASK = 3391;
    private static ObjectStreamClassEntry[] descriptorFor = new ObjectStreamClassEntry[61];
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class<?> ofClass;
    boolean forProxyClass;
    private long suid = -1L;
    private String suidStr = null;
    private long actualSuid = -1L;
    private String actualSuidStr = null;
    int primBytes;
    int objFields;
    private boolean initialized = false;
    private Object lock = new Object();
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    private transient Method writeReplaceObjectMethod;
    private transient Method readResolveObjectMethod;
    private Constructor<?> cons;
    private transient ProtectionDomain[] domains;
    private String rmiiiopOptionalDataRepId = null;
    private ObjectStreamClass localClassDesc;
    private static Method hasStaticInitializerMethod = null;
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static Comparator compareClassByName = new CompareClassByName();
    private static final Comparator compareObjStrFieldsByName = new CompareObjStrFieldsByName();
    private static Comparator compareMemberByName = new CompareMemberByName();

    static final ObjectStreamClass lookup(Class<?> cl) {
        ObjectStreamClass desc = ObjectStreamClass.lookupInternal(cl);
        if (desc.isSerializable() || desc.isExternalizable()) {
            return desc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookupInternal(Class<?> cl) {
        ObjectStreamClass desc = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (descriptorFor) {
            desc = ObjectStreamClass.findDescriptorFor(cl);
            if (desc == null) {
                Class<?> superclass;
                boolean serializable = Serializable.class.isAssignableFrom(cl);
                ObjectStreamClass superdesc = null;
                if (serializable && (superclass = cl.getSuperclass()) != null) {
                    superdesc = ObjectStreamClass.lookup(superclass);
                }
                boolean externalizable = false;
                if (serializable) {
                    boolean bl = externalizable = superdesc != null && superdesc.isExternalizable() || Externalizable.class.isAssignableFrom(cl);
                    if (externalizable) {
                        serializable = false;
                    }
                }
                desc = new ObjectStreamClass(cl, superdesc, serializable, externalizable);
            }
            desc.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return desc;
        }
    }

    public final String getName() {
        return this.name;
    }

    public static final long getSerialVersionUID(Class<?> clazz) {
        ObjectStreamClass theosc = ObjectStreamClass.lookup(clazz);
        if (theosc != null) {
            return theosc.getSerialVersionUID();
        }
        return 0L;
    }

    public final long getSerialVersionUID() {
        return this.suid;
    }

    public final String getSerialVersionUIDStr() {
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.suid).toUpperCase();
        }
        return this.suidStr;
    }

    public static final long getActualSerialVersionUID(Class<?> clazz) {
        ObjectStreamClass theosc = ObjectStreamClass.lookup(clazz);
        if (theosc != null) {
            return theosc.getActualSerialVersionUID();
        }
        return 0L;
    }

    public final long getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public final String getActualSerialVersionUIDStr() {
        if (this.actualSuidStr == null) {
            this.actualSuidStr = Long.toHexString(this.actualSuid).toUpperCase();
        }
        return this.actualSuidStr;
    }

    public final Class<?> forClass() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] dup = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, dup, 0, this.fields.length);
            return dup;
        }
        return this.fields;
    }

    public boolean hasField(ValueMember field) {
        try {
            for (int i = 0; i < this.fields.length; ++i) {
                if (!this.fields[i].getName().equals(field.name) || !this.fields[i].getSignature().equals(ValueUtility.getSignature(field))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final ObjectStreamField getField(String name) {
        for (int i = this.fields.length - 1; i >= 0; --i) {
            if (!name.equals(this.fields[i].getName())) continue;
            return this.fields[i];
        }
        return null;
    }

    public Serializable writeReplace(Serializable value) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke(value, noArgsList);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return value;
    }

    public Object readResolve(Object value) {
        if (this.readResolveObjectMethod != null) {
            try {
                return this.readResolveObjectMethod.invoke(value, noArgsList);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return value;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(": static final long serialVersionUID = ");
        sb.append(Long.toString(this.suid));
        sb.append("L;");
        return sb.toString();
    }

    private ObjectStreamClass(Class<?> cl, ObjectStreamClass superdesc, boolean serial, boolean extern) {
        this.ofClass = cl;
        if (Proxy.isProxyClass(cl)) {
            this.forProxyClass = true;
        }
        this.name = cl.getName();
        this.isEnum = Enum.class.isAssignableFrom(cl);
        this.superclass = superdesc;
        this.serializable = serial;
        if (!this.forProxyClass) {
            this.externalizable = extern;
        }
        ObjectStreamClass.insertDescriptorFor(this);
    }

    private ProtectionDomain noPermissionsDomain() {
        Permissions perms = new Permissions();
        perms.setReadOnly();
        return new ProtectionDomain(null, perms);
    }

    private ProtectionDomain[] getProtectionDomains(Constructor<?> cons, Class<?> cl) {
        ProtectionDomain[] domains = null;
        if (cons != null && cl.getClassLoader() != null && System.getSecurityManager() != null) {
            Class<?> cls = cl;
            Class<?> fnscl = cons.getDeclaringClass();
            HashSet<ProtectionDomain> pds = null;
            while (cls != fnscl) {
                ProtectionDomain pd = cls.getProtectionDomain();
                if (pd != null) {
                    if (pds == null) {
                        pds = new HashSet<ProtectionDomain>();
                    }
                    pds.add(pd);
                }
                if ((cls = cls.getSuperclass()) != null) continue;
                if (pds == null) {
                    pds = new HashSet();
                } else {
                    pds.clear();
                }
                pds.add(this.noPermissionsDomain());
                break;
            }
            if (pds != null) {
                domains = pds.toArray(new ProtectionDomain[0]);
            }
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            final Class<?> cl = this.ofClass;
            if (!this.serializable || this.externalizable || this.forProxyClass || this.name.equals("java.lang.String")) {
                this.fields = NO_FIELDS;
            } else if (this.serializable) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ObjectStreamClass.access$002(ObjectStreamClass.this, persistentFieldsValue.get(cl));
                        if (ObjectStreamClass.this.fields == null) {
                            Field[] actualfields = cl.getDeclaredFields();
                            int numFields = 0;
                            ObjectStreamField[] tempFields = new ObjectStreamField[actualfields.length];
                            for (int i = 0; i < actualfields.length; ++i) {
                                Field fld = actualfields[i];
                                int modifiers = fld.getModifiers();
                                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                                fld.setAccessible(true);
                                tempFields[numFields++] = new ObjectStreamField(fld);
                            }
                            ObjectStreamClass.access$002(ObjectStreamClass.this, new ObjectStreamField[numFields]);
                            System.arraycopy(tempFields, 0, ObjectStreamClass.this.fields, 0, numFields);
                        } else {
                            for (int j = ObjectStreamClass.this.fields.length - 1; j >= 0; --j) {
                                try {
                                    Field reflField = cl.getDeclaredField(ObjectStreamClass.this.fields[j].getName());
                                    if (ObjectStreamClass.this.fields[j].getType() != reflField.getType()) continue;
                                    reflField.setAccessible(true);
                                    ObjectStreamClass.this.fields[j].setField(reflField);
                                    continue;
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    // empty catch block
                                }
                            }
                        }
                        return null;
                    }
                });
                if (this.fields.length > 1) {
                    Arrays.sort(this.fields);
                }
                this.computeFieldInfo();
            }
            if (this.isNonSerializable() || this.isEnum) {
                this.suid = 0L;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (ObjectStreamClass.this.forProxyClass) {
                            ObjectStreamClass.this.suid = 0L;
                        } else {
                            try {
                                Field f = cl.getDeclaredField("serialVersionUID");
                                int mods = f.getModifiers();
                                if (Modifier.isStatic(mods) && Modifier.isFinal(mods)) {
                                    f.setAccessible(true);
                                    ObjectStreamClass.this.suid = f.getLong(cl);
                                } else {
                                    ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(cl);
                                }
                            }
                            catch (NoSuchFieldException ex) {
                                ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(cl);
                            }
                            catch (IllegalAccessException ex) {
                                ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(cl);
                            }
                        }
                        ObjectStreamClass.this.writeReplaceObjectMethod = ObjectStreamClass.getInheritableMethod(cl, "writeReplace", noTypesList, Object.class);
                        ObjectStreamClass.this.readResolveObjectMethod = ObjectStreamClass.getInheritableMethod(cl, "readResolve", noTypesList, Object.class);
                        ObjectStreamClass.access$802(ObjectStreamClass.this, new ProtectionDomain[]{ObjectStreamClass.this.noPermissionsDomain()});
                        if (ObjectStreamClass.this.externalizable) {
                            ObjectStreamClass.this.cons = ObjectStreamClass.getExternalizableConstructor(cl);
                        } else {
                            ObjectStreamClass.this.cons = ObjectStreamClass.getSerializableConstructor(cl);
                        }
                        ObjectStreamClass.access$802(ObjectStreamClass.this, ObjectStreamClass.this.getProtectionDomains(ObjectStreamClass.this.cons, cl));
                        if (ObjectStreamClass.this.serializable && !ObjectStreamClass.this.forProxyClass) {
                            ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.getPrivateMethod(cl, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
                            ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.getPrivateMethod(cl, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
                        }
                        return null;
                    }
                });
            }
            this.actualSuid = ObjectStreamClass.computeStructuralUID(this, cl);
            if (this.hasWriteObject()) {
                this.rmiiiopOptionalDataRepId = this.computeRMIIIOPOptionalDataRepId();
            }
            this.initialized = true;
        }
    }

    private static Method getPrivateMethod(Class<?> cl, String name, Class<?>[] argTypes, Class<?> returnType) {
        try {
            Method meth = cl.getDeclaredMethod(name, argTypes);
            meth.setAccessible(true);
            int mods = meth.getModifiers();
            return meth.getReturnType() == returnType && (mods & 8) == 0 && (mods & 2) != 0 ? meth : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private String computeRMIIIOPOptionalDataRepId() {
        StringBuffer sbuf = new StringBuffer("RMI:org.omg.custom.");
        sbuf.append(RepositoryId.convertToISOLatin1(this.getName()));
        sbuf.append(':');
        sbuf.append(this.getActualSerialVersionUIDStr());
        sbuf.append(':');
        sbuf.append(this.getSerialVersionUIDStr());
        return sbuf.toString();
    }

    public final String getRMIIIOPOptionalDataRepId() {
        return this.rmiiiopOptionalDataRepId;
    }

    ObjectStreamClass(String n, long s) {
        this.name = n;
        this.suid = s;
        this.superclass = null;
    }

    final void setClass(Class<?> cl) throws InvalidClassException {
        if (cl == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(cl);
        if (this.localClassDesc == null) {
            throw new InvalidClassException(cl.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid) {
            boolean arraySUID;
            boolean addedSerialOrExtern = this.isNonSerializable() || this.localClassDesc.isNonSerializable();
            boolean bl = arraySUID = cl.isArray() && !cl.getName().equals(this.name);
            if (!arraySUID && !addedSerialOrExtern) {
                throw new InvalidClassException(cl.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
            }
        }
        if (!ObjectStreamClass.compareClassNames(this.name, cl.getName(), '.')) {
            throw new InvalidClassException(cl.getName(), "Incompatible local class name. Expected class name compatible with " + this.name);
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable || !this.serializable && !this.externalizable) {
            throw new InvalidClassException(cl.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] destfield = this.localClassDesc.fields;
        ObjectStreamField[] srcfield = this.fields;
        int j = 0;
        block0: for (int i = 0; i < srcfield.length; ++i) {
            for (int k = j; k < destfield.length; ++k) {
                if (!srcfield[i].getName().equals(destfield[k].getName())) continue;
                if (srcfield[i].isPrimitive() && !srcfield[i].typeEquals(destfield[k])) {
                    throw new InvalidClassException(cl.getName(), "The type of field " + srcfield[i].getName() + " of class " + this.name + " is incompatible.");
                }
                j = k;
                srcfield[i].setField(destfield[j].getField());
                continue block0;
            }
        }
        this.computeFieldInfo();
        this.ofClass = cl;
        this.readObjectMethod = this.localClassDesc.readObjectMethod;
        this.readResolveObjectMethod = this.localClassDesc.readResolveObjectMethod;
    }

    static boolean compareClassNames(String streamName, String localName, char pkgSeparator) {
        int localNameIndex;
        int streamNameIndex = streamName.lastIndexOf(pkgSeparator);
        if (streamNameIndex < 0) {
            streamNameIndex = 0;
        }
        if ((localNameIndex = localName.lastIndexOf(pkgSeparator)) < 0) {
            localNameIndex = 0;
        }
        return streamName.regionMatches(false, streamNameIndex, localName, localNameIndex, streamName.length() - streamNameIndex);
    }

    final boolean typeEquals(ObjectStreamClass other) {
        return this.suid == other.suid && ObjectStreamClass.compareClassNames(this.name, other.name, '.');
    }

    final void setSuperclass(ObjectStreamClass s) {
        this.superclass = s;
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    final boolean hasReadObject() {
        return this.readObjectMethod != null;
    }

    final boolean hasWriteObject() {
        return this.writeObjectMethod != null;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable() || this.superclass != null && this.superclass.isCustomMarshaled();
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        if (!this.initialized) {
            throw new InternalError("Unexpected call when not initialized");
        }
        if (this.cons != null) {
            try {
                if (this.domains == null || this.domains.length == 0) {
                    return this.cons.newInstance(new Object[0]);
                }
                JavaSecurityAccess jsa = SharedSecrets.getJavaSecurityAccess();
                PrivilegedAction pea = new PrivilegedAction(){

                    public Object run() {
                        try {
                            return ObjectStreamClass.this.cons.newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | InstantiationException | InvocationTargetException x) {
                            throw new UndeclaredThrowableException(x);
                        }
                    }
                };
                try {
                    return jsa.doIntersectionPrivilege(pea, AccessController.getContext(), new AccessControlContext(this.domains));
                }
                catch (UndeclaredThrowableException x) {
                    Throwable cause = x.getCause();
                    if (cause instanceof InstantiationException) {
                        throw (InstantiationException)cause;
                    }
                    if (cause instanceof InvocationTargetException) {
                        throw (InvocationTargetException)cause;
                    }
                    if (cause instanceof IllegalAccessException) {
                        throw (IllegalAccessException)cause;
                    }
                    throw x;
                }
            }
            catch (IllegalAccessException ex) {
                InternalError ie = new InternalError();
                ie.initCause(ex);
                throw ie;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Constructor getExternalizableConstructor(Class<?> cl) {
        try {
            Constructor<?> cons = cl.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return (cons.getModifiers() & 1) != 0 ? cons : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Constructor getSerializableConstructor(Class<?> cl) {
        Class<?> initCl = cl;
        while (Serializable.class.isAssignableFrom(initCl)) {
            if ((initCl = initCl.getSuperclass()) != null) continue;
            return null;
        }
        try {
            Constructor cons = initCl.getDeclaredConstructor(new Class[0]);
            int mods = cons.getModifiers();
            if ((mods & 2) != 0 || (mods & 5) == 0 && !ObjectStreamClass.packageEquals(cl, initCl)) {
                return null;
            }
            cons = bridge.newConstructorForSerialization(cl, cons);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    final ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isNonSerializable() {
        return !this.externalizable && !this.serializable;
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        block7: for (int i = 0; i < this.fields.length; ++i) {
            switch (this.fields[i].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                }
            }
        }
    }

    private static void msg(String str) {
        System.out.println(str);
    }

    private static long _computeSerialVersionUID(Class<?> cl) {
        ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
        long h = 0L;
        try {
            int modifier;
            String desc;
            int i;
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream mdo = new DigestOutputStream(devnull, md);
            DataOutputStream data = new DataOutputStream(mdo);
            data.writeUTF(cl.getName());
            int classaccess = cl.getModifiers();
            Member[] method = cl.getDeclaredMethods();
            if (((classaccess &= 0x611) & 0x200) != 0) {
                classaccess &= 0xFFFFFBFF;
                if (method.length > 0) {
                    classaccess |= 0x400;
                }
            }
            data.writeInt(classaccess &= 0x611);
            if (!cl.isArray()) {
                Class<?>[] interfaces = cl.getInterfaces();
                Arrays.sort(interfaces, compareClassByName);
                for (i = 0; i < interfaces.length; ++i) {
                    data.writeUTF(interfaces[i].getName());
                }
            }
            Field[] field = cl.getDeclaredFields();
            Arrays.sort(field, compareMemberByName);
            for (i = 0; i < field.length; ++i) {
                Field f = field[i];
                int m = f.getModifiers();
                if (Modifier.isPrivate(m) && (Modifier.isTransient(m) || Modifier.isStatic(m))) continue;
                data.writeUTF(f.getName());
                data.writeInt(m &= 0xDF);
                data.writeUTF(ObjectStreamClass.getSignature(f.getType()));
            }
            if (ObjectStreamClass.hasStaticInitializer(cl)) {
                data.writeUTF("<clinit>");
                data.writeInt(8);
                data.writeUTF("()V");
            }
            MethodSignature[] constructors = MethodSignature.removePrivateAndSort(cl.getDeclaredConstructors());
            for (int i2 = 0; i2 < constructors.length; ++i2) {
                MethodSignature c = constructors[i2];
                String mname = "<init>";
                desc = c.signature;
                desc = desc.replace('/', '.');
                data.writeUTF(mname);
                modifier = c.member.getModifiers() & 0xD3F;
                data.writeInt(modifier);
                data.writeUTF(desc);
            }
            MethodSignature[] methods = MethodSignature.removePrivateAndSort(method);
            for (int i3 = 0; i3 < methods.length; ++i3) {
                MethodSignature m = methods[i3];
                desc = m.signature;
                desc = desc.replace('/', '.');
                data.writeUTF(m.member.getName());
                modifier = m.member.getModifiers() & 0xD3F;
                data.writeInt(modifier);
                data.writeUTF(desc);
            }
            data.flush();
            byte[] hasharray = md.digest();
            for (int i4 = 0; i4 < Math.min(8, hasharray.length); ++i4) {
                h += (long)(hasharray[i4] & 0xFF) << i4 * 8;
            }
        }
        catch (IOException ignore) {
            h = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            SecurityException se = new SecurityException();
            se.initCause(complain);
            throw se;
        }
        return h;
    }

    private static long computeStructuralUID(ObjectStreamClass osc, Class<?> cl) {
        ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
        long h = 0L;
        try {
            if (!Serializable.class.isAssignableFrom(cl) || cl.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(cl)) {
                return 1L;
            }
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream mdo = new DigestOutputStream(devnull, md);
            DataOutputStream data = new DataOutputStream(mdo);
            Class<?> parent = cl.getSuperclass();
            if (parent != null) {
                data.writeLong(ObjectStreamClass.computeStructuralUID(ObjectStreamClass.lookup(parent), parent));
            }
            if (osc.hasWriteObject()) {
                data.writeInt(2);
            } else {
                data.writeInt(1);
            }
            ObjectStreamField[] field = osc.getFields();
            if (field.length > 1) {
                Arrays.sort(field, compareObjStrFieldsByName);
            }
            for (int i = 0; i < field.length; ++i) {
                data.writeUTF(field[i].getName());
                data.writeUTF(field[i].getSignature());
            }
            data.flush();
            byte[] hasharray = md.digest();
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                h += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException ignore) {
            h = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            SecurityException se = new SecurityException();
            se.initCause(complain);
            throw se;
        }
        return h;
    }

    static String getSignature(Class<?> clazz) {
        String type = null;
        if (clazz.isArray()) {
            Class<?> cl = clazz;
            int dimensions = 0;
            while (cl.isArray()) {
                ++dimensions;
                cl = cl.getComponentType();
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dimensions; ++i) {
                sb.append("[");
            }
            sb.append(ObjectStreamClass.getSignature(cl));
            type = sb.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                type = "I";
            } else if (clazz == Byte.TYPE) {
                type = "B";
            } else if (clazz == Long.TYPE) {
                type = "J";
            } else if (clazz == Float.TYPE) {
                type = "F";
            } else if (clazz == Double.TYPE) {
                type = "D";
            } else if (clazz == Short.TYPE) {
                type = "S";
            } else if (clazz == Character.TYPE) {
                type = "C";
            } else if (clazz == Boolean.TYPE) {
                type = "Z";
            } else if (clazz == Void.TYPE) {
                type = "V";
            }
        } else {
            type = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return type;
    }

    static String getSignature(Method meth) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Class<?>[] params = meth.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(ObjectStreamClass.getSignature(params[j]));
        }
        sb.append(")");
        sb.append(ObjectStreamClass.getSignature(meth.getReturnType()));
        return sb.toString();
    }

    static String getSignature(Constructor cons) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Class<?>[] params = cons.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(ObjectStreamClass.getSignature(params[j]));
        }
        sb.append(")V");
        return sb.toString();
    }

    private static ObjectStreamClass findDescriptorFor(Class<?> cl) {
        ObjectStreamClassEntry e;
        int hash = cl.hashCode();
        int index = (hash & Integer.MAX_VALUE) % descriptorFor.length;
        while ((e = descriptorFor[index]) != null && e.get() == null) {
            ObjectStreamClass.descriptorFor[index] = e.next;
        }
        ObjectStreamClassEntry prev = e;
        while (e != null) {
            ObjectStreamClass desc = (ObjectStreamClass)e.get();
            if (desc == null) {
                prev.next = e.next;
            } else {
                if (desc.ofClass == cl) {
                    return desc;
                }
                prev = e;
            }
            e = e.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass desc) {
        if (ObjectStreamClass.findDescriptorFor(desc.ofClass) != null) {
            return;
        }
        int hash = desc.ofClass.hashCode();
        int index = (hash & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry e = new ObjectStreamClassEntry(desc);
        e.next = descriptorFor[index];
        ObjectStreamClass.descriptorFor[index] = e;
    }

    private static Field[] getDeclaredFields(final Class<?> clz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clz.getDeclaredFields();
            }
        });
    }

    private static boolean hasStaticInitializer(Class<?> cl) {
        if (hasStaticInitializerMethod == null) {
            Class<java.io.ObjectStreamClass> classWithThisMethod = null;
            try {
                if (classWithThisMethod == null) {
                    classWithThisMethod = java.io.ObjectStreamClass.class;
                }
                hasStaticInitializerMethod = classWithThisMethod.getDeclaredMethod("hasStaticInitializer", Class.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (hasStaticInitializerMethod == null) {
                throw new InternalError("Can't find hasStaticInitializer method on " + classWithThisMethod.getName());
            }
            hasStaticInitializerMethod.setAccessible(true);
        }
        try {
            Boolean retval = (Boolean)hasStaticInitializerMethod.invoke(null, cl);
            return retval;
        }
        catch (Exception ex) {
            InternalError ie = new InternalError("Error invoking hasStaticInitializer");
            ie.initCause(ex);
            throw ie;
        }
    }

    private static Method getInheritableMethod(Class<?> cl, String name, Class<?>[] argTypes, Class<?> returnType) {
        Class<?> defCl;
        Method meth = null;
        for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                meth = defCl.getDeclaredMethod(name, argTypes);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (meth == null || meth.getReturnType() != returnType) {
            return null;
        }
        meth.setAccessible(true);
        int mods = meth.getModifiers();
        if ((mods & 0x408) != 0) {
            return null;
        }
        if ((mods & 5) != 0) {
            return meth;
        }
        if ((mods & 2) != 0) {
            return cl == defCl ? meth : null;
        }
        return ObjectStreamClass.packageEquals(cl, defCl) ? meth : null;
    }

    private static boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        Package pkg2;
        Package pkg1 = cl1.getPackage();
        return pkg1 == (pkg2 = cl2.getPackage()) || pkg1 != null && pkg1.equals(pkg2);
    }

    static /* synthetic */ ObjectStreamField[] access$002(ObjectStreamClass x0, ObjectStreamField[] x1) {
        x0.fields = x1;
        return x1;
    }

    static /* synthetic */ ProtectionDomain[] access$802(ObjectStreamClass x0, ProtectionDomain[] x1) {
        x0.domains = x1;
        return x1;
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] m) {
            int numNonPrivate = 0;
            for (int i = 0; i < m.length; ++i) {
                if (Modifier.isPrivate(m[i].getModifiers())) continue;
                ++numNonPrivate;
            }
            MethodSignature[] cm = new MethodSignature[numNonPrivate];
            int cmi = 0;
            for (int i = 0; i < m.length; ++i) {
                if (Modifier.isPrivate(m[i].getModifiers())) continue;
                cm[cmi] = new MethodSignature(m[i]);
                ++cmi;
            }
            if (cmi > 0) {
                Arrays.sort(cm, cm[0]);
            }
            return cm;
        }

        public int compare(Object o1, Object o2) {
            int result;
            if (o1 == o2) {
                return 0;
            }
            MethodSignature c1 = (MethodSignature)o1;
            MethodSignature c2 = (MethodSignature)o2;
            if (this.isConstructor()) {
                result = c1.signature.compareTo(c2.signature);
            } else {
                result = c1.member.getName().compareTo(c2.member.getName());
                if (result == 0) {
                    result = c1.signature.compareTo(c2.signature);
                }
            }
            return result;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member m) {
            this.member = m;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)m) : ObjectStreamClass.getSignature((Method)m);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((Member)o1).getName();
            String s2 = ((Member)o2).getName();
            if (o1 instanceof Method) {
                s1 = s1 + ObjectStreamClass.getSignature((Method)o1);
                s2 = s2 + ObjectStreamClass.getSignature((Method)o2);
            } else if (o1 instanceof Constructor) {
                s1 = s1 + ObjectStreamClass.getSignature((Constructor)o1);
                s2 = s2 + ObjectStreamClass.getSignature((Constructor)o2);
            }
            return s1.compareTo(s2);
        }
    }

    private static class CompareObjStrFieldsByName
    implements Comparator {
        private CompareObjStrFieldsByName() {
        }

        public int compare(Object o1, Object o2) {
            ObjectStreamField osf1 = (ObjectStreamField)o1;
            ObjectStreamField osf2 = (ObjectStreamField)o2;
            return osf1.getName().compareTo(osf2.getName());
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass c) {
            this.c = c;
        }

        public Object get() {
            return this.c;
        }
    }

    private static final class PersistentFieldsValue {
        private final ConcurrentMap map = new ConcurrentHashMap();
        private static final Object NULL_VALUE = PersistentFieldsValue.class.getName() + ".NULL_VALUE";

        PersistentFieldsValue() {
        }

        ObjectStreamField[] get(Class<?> type) {
            Object value = this.map.get(type);
            if (value == null) {
                value = PersistentFieldsValue.computeValue(type);
                this.map.putIfAbsent(type, value);
            }
            return value == NULL_VALUE ? null : (ObjectStreamField[])value;
        }

        private static Object computeValue(Class<?> type) {
            try {
                Field pf = type.getDeclaredField("serialPersistentFields");
                int mods = pf.getModifiers();
                if (Modifier.isPrivate(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods)) {
                    pf.setAccessible(true);
                    java.io.ObjectStreamField[] fields = (java.io.ObjectStreamField[])pf.get(type);
                    return PersistentFieldsValue.translateFields(fields);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return NULL_VALUE;
        }

        private static ObjectStreamField[] translateFields(java.io.ObjectStreamField[] fields) {
            ObjectStreamField[] translation = new ObjectStreamField[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                translation[i] = new ObjectStreamField(fields[i].getName(), fields[i].getType());
            }
            return translation;
        }
    }
}

