/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.reflect.AccessorGenerator;
import sun.reflect.ByteVector;
import sun.reflect.ByteVectorFactory;
import sun.reflect.ClassDefiner;
import sun.reflect.ClassFileAssembler;
import sun.reflect.ConstructorAccessor;
import sun.reflect.Label;
import sun.reflect.MagicAccessorImpl;
import sun.reflect.MethodAccessor;
import sun.reflect.SerializationConstructorAccessorImpl;

class MethodAccessorGenerator
extends AccessorGenerator {
    private static final short NUM_BASE_CPOOL_ENTRIES = 12;
    private static final short NUM_METHODS = 2;
    private static final short NUM_SERIALIZATION_CPOOL_ENTRIES = 2;
    private static volatile int methodSymnum = 0;
    private static volatile int constructorSymnum = 0;
    private static volatile int serializationConstructorSymnum = 0;
    private Class<?> declaringClass;
    private Class<?>[] parameterTypes;
    private Class<?> returnType;
    private boolean isConstructor;
    private boolean forSerialization;
    private short targetMethodRef;
    private short invokeIdx;
    private short invokeDescriptorIdx;
    private short nonPrimitiveParametersBaseIdx;

    MethodAccessorGenerator() {
    }

    public MethodAccessor generateMethod(Class<?> declaringClass, String name, Class<?>[] parameterTypes, Class<?> returnType, Class<?>[] checkedExceptions, int modifiers) {
        return (MethodAccessor)((Object)this.generate(declaringClass, name, parameterTypes, returnType, checkedExceptions, modifiers, false, false, null));
    }

    public ConstructorAccessor generateConstructor(Class<?> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers) {
        return (ConstructorAccessor)((Object)this.generate(declaringClass, "<init>", parameterTypes, Void.TYPE, checkedExceptions, modifiers, true, false, null));
    }

    public SerializationConstructorAccessorImpl generateSerializationConstructor(Class<?> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers, Class<?> targetConstructorClass) {
        return (SerializationConstructorAccessorImpl)this.generate(declaringClass, "<init>", parameterTypes, Void.TYPE, checkedExceptions, modifiers, true, true, targetConstructorClass);
    }

    private MagicAccessorImpl generate(final Class<?> declaringClass, String name, Class<?>[] parameterTypes, Class<?> returnType, Class<?>[] checkedExceptions, int modifiers, boolean isConstructor, boolean forSerialization, Class<?> serializationTargetClass) {
        ByteVector vec = ByteVectorFactory.create();
        this.asm = new ClassFileAssembler(vec);
        this.declaringClass = declaringClass;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.isConstructor = isConstructor;
        this.forSerialization = forSerialization;
        this.asm.emitMagicAndVersion();
        short numCPEntries = 42;
        boolean usesPrimitives = this.usesPrimitiveTypes();
        if (usesPrimitives) {
            numCPEntries = (short)(numCPEntries + 72);
        }
        if (forSerialization) {
            numCPEntries = (short)(numCPEntries + 2);
        }
        numCPEntries = (short)(numCPEntries + (short)(2 * this.numNonPrimitiveParameterTypes()));
        this.asm.emitShort(MethodAccessorGenerator.add(numCPEntries, (short)1));
        final String generatedName = MethodAccessorGenerator.generateName(isConstructor, forSerialization);
        this.asm.emitConstantPoolUTF8(generatedName);
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.thisClass = this.asm.cpi();
        if (isConstructor) {
            if (forSerialization) {
                this.asm.emitConstantPoolUTF8("sun/reflect/SerializationConstructorAccessorImpl");
            } else {
                this.asm.emitConstantPoolUTF8("sun/reflect/ConstructorAccessorImpl");
            }
        } else {
            this.asm.emitConstantPoolUTF8("sun/reflect/MethodAccessorImpl");
        }
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.superClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8(MethodAccessorGenerator.getClassName(declaringClass, false));
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.targetClass = this.asm.cpi();
        short serializationTargetClassIdx = 0;
        if (forSerialization) {
            this.asm.emitConstantPoolUTF8(MethodAccessorGenerator.getClassName(serializationTargetClass, false));
            this.asm.emitConstantPoolClass(this.asm.cpi());
            serializationTargetClassIdx = this.asm.cpi();
        }
        this.asm.emitConstantPoolUTF8(name);
        this.asm.emitConstantPoolUTF8(this.buildInternalSignature());
        this.asm.emitConstantPoolNameAndType(MethodAccessorGenerator.sub(this.asm.cpi(), (short)1), this.asm.cpi());
        if (this.isInterface()) {
            this.asm.emitConstantPoolInterfaceMethodref(this.targetClass, this.asm.cpi());
        } else if (forSerialization) {
            this.asm.emitConstantPoolMethodref(serializationTargetClassIdx, this.asm.cpi());
        } else {
            this.asm.emitConstantPoolMethodref(this.targetClass, this.asm.cpi());
        }
        this.targetMethodRef = this.asm.cpi();
        if (isConstructor) {
            this.asm.emitConstantPoolUTF8("newInstance");
        } else {
            this.asm.emitConstantPoolUTF8("invoke");
        }
        this.invokeIdx = this.asm.cpi();
        if (isConstructor) {
            this.asm.emitConstantPoolUTF8("([Ljava/lang/Object;)Ljava/lang/Object;");
        } else {
            this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        this.invokeDescriptorIdx = this.asm.cpi();
        this.nonPrimitiveParametersBaseIdx = MethodAccessorGenerator.add(this.asm.cpi(), (short)2);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> c = parameterTypes[i];
            if (MethodAccessorGenerator.isPrimitive(c)) continue;
            this.asm.emitConstantPoolUTF8(MethodAccessorGenerator.getClassName(c, false));
            this.asm.emitConstantPoolClass(this.asm.cpi());
        }
        this.emitCommonConstantPoolEntries();
        if (usesPrimitives) {
            this.emitBoxingContantPoolEntries();
        }
        if (this.asm.cpi() != numCPEntries) {
            throw new InternalError("Adjust this code (cpi = " + this.asm.cpi() + ", numCPEntries = " + numCPEntries + ")");
        }
        this.asm.emitShort((short)1);
        this.asm.emitShort(this.thisClass);
        this.asm.emitShort(this.superClass);
        this.asm.emitShort((short)0);
        this.asm.emitShort((short)0);
        this.asm.emitShort((short)2);
        this.emitConstructor();
        this.emitInvoke();
        this.asm.emitShort((short)0);
        vec.trim();
        final byte[] bytes = vec.getData();
        return AccessController.doPrivileged(new PrivilegedAction<MagicAccessorImpl>(){

            @Override
            public MagicAccessorImpl run() {
                try {
                    return (MagicAccessorImpl)ClassDefiner.defineClass(generatedName, bytes, 0, bytes.length, declaringClass.getClassLoader()).newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw (InternalError)new InternalError().initCause(e);
                }
            }
        });
    }

    private void emitInvoke() {
        if (this.parameterTypes.length > 65535) {
            throw new InternalError("Can't handle more than 65535 parameters");
        }
        ClassFileAssembler cb = new ClassFileAssembler();
        if (this.isConstructor) {
            cb.setMaxLocals(2);
        } else {
            cb.setMaxLocals(3);
        }
        short illegalArgStartPC = 0;
        if (this.isConstructor) {
            cb.opc_new(this.targetClass);
            cb.opc_dup();
        } else {
            if (MethodAccessorGenerator.isPrimitive(this.returnType)) {
                cb.opc_new(this.indexForPrimitiveType(this.returnType));
                cb.opc_dup();
            }
            if (!this.isStatic()) {
                cb.opc_aload_1();
                Label l = new Label();
                cb.opc_ifnonnull(l);
                cb.opc_new(this.nullPointerClass);
                cb.opc_dup();
                cb.opc_invokespecial(this.nullPointerCtorIdx, 0, 0);
                cb.opc_athrow();
                l.bind();
                illegalArgStartPC = cb.getLength();
                cb.opc_aload_1();
                cb.opc_checkcast(this.targetClass);
            }
        }
        Label successLabel = new Label();
        if (this.parameterTypes.length == 0) {
            if (this.isConstructor) {
                cb.opc_aload_1();
            } else {
                cb.opc_aload_2();
            }
            cb.opc_ifnull(successLabel);
        }
        if (this.isConstructor) {
            cb.opc_aload_1();
        } else {
            cb.opc_aload_2();
        }
        cb.opc_arraylength();
        cb.opc_sipush((short)this.parameterTypes.length);
        cb.opc_if_icmpeq(successLabel);
        cb.opc_new(this.illegalArgumentClass);
        cb.opc_dup();
        cb.opc_invokespecial(this.illegalArgumentCtorIdx, 0, 0);
        cb.opc_athrow();
        successLabel.bind();
        short paramTypeCPIdx = this.nonPrimitiveParametersBaseIdx;
        Label nextParamLabel = null;
        byte count = 1;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            Class<?> paramType = this.parameterTypes[i];
            count = (byte)(count + (byte)this.typeSizeInStackSlots(paramType));
            if (nextParamLabel != null) {
                nextParamLabel.bind();
                nextParamLabel = null;
            }
            if (this.isConstructor) {
                cb.opc_aload_1();
            } else {
                cb.opc_aload_2();
            }
            cb.opc_sipush((short)i);
            cb.opc_aaload();
            if (MethodAccessorGenerator.isPrimitive(paramType)) {
                if (this.isConstructor) {
                    cb.opc_astore_2();
                } else {
                    cb.opc_astore_3();
                }
                Label l = null;
                nextParamLabel = new Label();
                for (int j = 0; j < primitiveTypes.length; ++j) {
                    Class c = primitiveTypes[j];
                    if (!MethodAccessorGenerator.canWidenTo(c, paramType)) continue;
                    if (l != null) {
                        l.bind();
                    }
                    if (this.isConstructor) {
                        cb.opc_aload_2();
                    } else {
                        cb.opc_aload_3();
                    }
                    cb.opc_instanceof(this.indexForPrimitiveType(c));
                    l = new Label();
                    cb.opc_ifeq(l);
                    if (this.isConstructor) {
                        cb.opc_aload_2();
                    } else {
                        cb.opc_aload_3();
                    }
                    cb.opc_checkcast(this.indexForPrimitiveType(c));
                    cb.opc_invokevirtual(this.unboxingMethodForPrimitiveType(c), 0, this.typeSizeInStackSlots(c));
                    MethodAccessorGenerator.emitWideningBytecodeForPrimitiveConversion(cb, c, paramType);
                    cb.opc_goto(nextParamLabel);
                }
                if (l == null) {
                    throw new InternalError("Must have found at least identity conversion");
                }
                l.bind();
                cb.opc_new(this.illegalArgumentClass);
                cb.opc_dup();
                cb.opc_invokespecial(this.illegalArgumentCtorIdx, 0, 0);
                cb.opc_athrow();
                continue;
            }
            cb.opc_checkcast(paramTypeCPIdx);
            paramTypeCPIdx = MethodAccessorGenerator.add(paramTypeCPIdx, (short)2);
        }
        if (nextParamLabel != null) {
            nextParamLabel.bind();
        }
        short invokeStartPC = cb.getLength();
        if (this.isConstructor) {
            cb.opc_invokespecial(this.targetMethodRef, count, 0);
        } else if (this.isStatic()) {
            cb.opc_invokestatic(this.targetMethodRef, count, this.typeSizeInStackSlots(this.returnType));
        } else if (this.isInterface()) {
            cb.opc_invokeinterface(this.targetMethodRef, count, count, this.typeSizeInStackSlots(this.returnType));
        } else {
            cb.opc_invokevirtual(this.targetMethodRef, count, this.typeSizeInStackSlots(this.returnType));
        }
        short invokeEndPC = cb.getLength();
        if (!this.isConstructor) {
            if (MethodAccessorGenerator.isPrimitive(this.returnType)) {
                cb.opc_invokespecial(this.ctorIndexForPrimitiveType(this.returnType), this.typeSizeInStackSlots(this.returnType), 0);
            } else if (this.returnType == Void.TYPE) {
                cb.opc_aconst_null();
            }
        }
        cb.opc_areturn();
        short classCastHandler = cb.getLength();
        cb.setStack(1);
        cb.opc_invokespecial(this.toStringIdx, 0, 1);
        cb.opc_new(this.illegalArgumentClass);
        cb.opc_dup_x1();
        cb.opc_swap();
        cb.opc_invokespecial(this.illegalArgumentStringCtorIdx, 1, 0);
        cb.opc_athrow();
        short invocationTargetHandler = cb.getLength();
        cb.setStack(1);
        cb.opc_new(this.invocationTargetClass);
        cb.opc_dup_x1();
        cb.opc_swap();
        cb.opc_invokespecial(this.invocationTargetCtorIdx, 1, 0);
        cb.opc_athrow();
        ClassFileAssembler exc = new ClassFileAssembler();
        exc.emitShort(illegalArgStartPC);
        exc.emitShort(invokeStartPC);
        exc.emitShort(classCastHandler);
        exc.emitShort(this.classCastClass);
        exc.emitShort(illegalArgStartPC);
        exc.emitShort(invokeStartPC);
        exc.emitShort(classCastHandler);
        exc.emitShort(this.nullPointerClass);
        exc.emitShort(invokeStartPC);
        exc.emitShort(invokeEndPC);
        exc.emitShort(invocationTargetHandler);
        exc.emitShort(this.throwableClass);
        this.emitMethod(this.invokeIdx, cb.getMaxLocals(), cb, exc, new short[]{this.invocationTargetClass});
    }

    private boolean usesPrimitiveTypes() {
        if (this.returnType.isPrimitive()) {
            return true;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (!this.parameterTypes[i].isPrimitive()) continue;
            return true;
        }
        return false;
    }

    private int numNonPrimitiveParameterTypes() {
        int num = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i].isPrimitive()) continue;
            ++num;
        }
        return num;
    }

    private boolean isInterface() {
        return this.declaringClass.isInterface();
    }

    private String buildInternalSignature() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            buf.append(MethodAccessorGenerator.getClassName(this.parameterTypes[i], true));
        }
        buf.append(")");
        buf.append(MethodAccessorGenerator.getClassName(this.returnType, true));
        return buf.toString();
    }

    private static synchronized String generateName(boolean isConstructor, boolean forSerialization) {
        if (isConstructor) {
            if (forSerialization) {
                int num = ++serializationConstructorSymnum;
                return "sun/reflect/GeneratedSerializationConstructorAccessor" + num;
            }
            int num = ++constructorSymnum;
            return "sun/reflect/GeneratedConstructorAccessor" + num;
        }
        int num = ++methodSymnum;
        return "sun/reflect/GeneratedMethodAccessor" + num;
    }
}

