/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.Objects;
import sun.security.krb5.internal.rcache.AuthTime;

public class AuthTimeWithHash
extends AuthTime
implements Comparable<AuthTimeWithHash> {
    final String hash;

    public AuthTimeWithHash(String client, String server, int ctime, int cusec, String hash) {
        super(client, server, ctime, cusec);
        this.hash = hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthTimeWithHash)) {
            return false;
        }
        AuthTimeWithHash that = (AuthTimeWithHash)o;
        return Objects.equals(this.hash, that.hash) && Objects.equals(this.client, that.client) && Objects.equals(this.server, that.server) && this.ctime == that.ctime && this.cusec == that.cusec;
    }

    public int hashCode() {
        return Objects.hash(this.hash);
    }

    @Override
    public String toString() {
        return String.format("%d/%06d/%s/%s", this.ctime, this.cusec, this.hash, this.client);
    }

    @Override
    public int compareTo(AuthTimeWithHash other) {
        int cmp = 0;
        cmp = this.ctime != other.ctime ? Integer.compare(this.ctime, other.ctime) : (this.cusec != other.cusec ? Integer.compare(this.cusec, other.cusec) : this.hash.compareTo(other.hash));
        return cmp;
    }

    public boolean isSameIgnoresHash(AuthTime old) {
        return this.client.equals(old.client) && this.server.equals(old.server) && this.ctime == old.ctime && this.cusec == old.cusec;
    }

    @Override
    public byte[] encode(boolean withHash) {
        String sstring;
        String cstring;
        if (withHash) {
            cstring = "";
            sstring = String.format("HASH:%s %d:%s %d:%s", this.hash, this.client.length(), this.client, this.server.length(), this.server);
        } else {
            cstring = this.client;
            sstring = this.server;
        }
        return this.encode0(cstring, sstring);
    }
}

