/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.rcache.AuthList;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class MemoryCache
extends ReplayCache {
    private static final int lifespan = KerberosTime.getDefaultSkew();
    private static final boolean DEBUG = Krb5.DEBUG;
    private final ConcurrentMap<String, AuthList> content = new ConcurrentHashMap<String, AuthList>();

    @Override
    public synchronized void checkAndStore(KerberosTime currTime, AuthTimeWithHash time) throws KrbApErrException {
        AuthList newAuthList;
        String key = time.client + "|" + time.server;
        AuthList authList = this.content.putIfAbsent(key, newAuthList = new AuthList(lifespan));
        if (authList == null) {
            authList = newAuthList;
        }
        authList.put(time, currTime);
        if (DEBUG) {
            System.out.println("MemoryCache: add " + time + " to " + key);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AuthList rc : this.content.values()) {
            sb.append(rc.toString());
        }
        return sb.toString();
    }
}

