/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.ProviderException;
import java.util.List;
import sun.security.util.BiFunction;
import sun.security.util.Function;
import sun.security.util.Preconditions;

public final class ArrayUtil {
    private static final Function<String, ArrayIndexOutOfBoundsException> aioobeGenerator = new Function<String, ArrayIndexOutOfBoundsException>(){

        @Override
        public ArrayIndexOutOfBoundsException apply(String x) {
            return new ArrayIndexOutOfBoundsException(x);
        }
    };
    private static final BiFunction<String, List<Integer>, ArrayIndexOutOfBoundsException> AIOOBE_SUPPLIER = Preconditions.outOfBoundsExceptionFormatter(aioobeGenerator);

    public static void blockSizeCheck(int len, int blockSize) {
        if (len % blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
    }

    public static void nullAndBoundsCheck(byte[] array, int offset, int len) {
        Preconditions.checkFromIndexSize(offset, len, array.length, AIOOBE_SUPPLIER);
    }

    private static void swap(byte[] arr, int i, int j) {
        byte tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void reverse(byte[] arr) {
        int i = 0;
        for (int j = arr.length - 1; i < j; ++i, --j) {
            ArrayUtil.swap(arr, i, j);
        }
    }
}

