/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.FileInputStream;
import java.security.AccessController;
import java.security.CryptoPrimitive;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.AbstractKeyManagerWrapper;
import sun.security.ssl.AbstractTrustManagerWrapper;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.Debug;
import sun.security.ssl.DummyX509KeyManager;
import sun.security.ssl.DummyX509TrustManager;
import sun.security.ssl.EphemeralKeyManager;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLServerSocketFactoryImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSocketFactoryImpl;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.SunX509KeyManagerImpl;
import sun.security.ssl.TrustManagerFactoryImpl;
import sun.security.ssl.X509KeyManagerImpl;
import sun.security.ssl.X509TrustManagerImpl;

public abstract class SSLContextImpl
extends SSLContextSpi {
    private static final Debug debug = Debug.getInstance("ssl");
    private final EphemeralKeyManager ephemeralKeyManager = new EphemeralKeyManager();
    private final SSLSessionContextImpl clientCache = new SSLSessionContextImpl();
    private final SSLSessionContextImpl serverCache = new SSLSessionContextImpl();
    private boolean isInitialized;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;
    private static final Collection<CipherSuite> clientCustomizedCipherSuites = SSLContextImpl.getCustomizedCipherSuites("jdk.tls.client.cipherSuites");
    private static final Collection<CipherSuite> serverCustomizedCipherSuites = SSLContextImpl.getCustomizedCipherSuites("jdk.tls.server.cipherSuites");

    SSLContextImpl() {
    }

    @Override
    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        this.isInitialized = false;
        this.keyManager = this.chooseKeyManager(km);
        if (tm == null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                tm = tmf.getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.trustManager = this.chooseTrustManager(tm);
        if (sr == null) {
            this.secureRandom = JsseJce.getSecureRandom();
        } else {
            if (SunJSSE.isFIPS() && sr.getProvider() != SunJSSE.cryptoProvider) {
                throw new KeyManagementException("FIPS mode: SecureRandom must be from provider " + SunJSSE.cryptoProvider.getName());
            }
            this.secureRandom = sr;
        }
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.secureRandom.nextInt();
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
        this.isInitialized = true;
    }

    private X509TrustManager chooseTrustManager(TrustManager[] tm) throws KeyManagementException {
        for (int i = 0; tm != null && i < tm.length; ++i) {
            if (!(tm[i] instanceof X509TrustManager)) continue;
            if (SunJSSE.isFIPS() && !(tm[i] instanceof X509TrustManagerImpl)) {
                throw new KeyManagementException("FIPS mode: only SunJSSE TrustManagers may be used");
            }
            if (tm[i] instanceof X509ExtendedTrustManager) {
                return (X509TrustManager)tm[i];
            }
            return new AbstractTrustManagerWrapper((X509TrustManager)tm[i]);
        }
        return DummyX509TrustManager.INSTANCE;
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManager[] kms) throws KeyManagementException {
        for (int i = 0; kms != null && i < kms.length; ++i) {
            KeyManager km = kms[i];
            if (!(km instanceof X509KeyManager)) continue;
            if (SunJSSE.isFIPS()) {
                if (km instanceof X509KeyManagerImpl || km instanceof SunX509KeyManagerImpl) {
                    return (X509ExtendedKeyManager)km;
                }
                throw new KeyManagementException("FIPS mode: only SunJSSE KeyManagers may be used");
            }
            if (km instanceof X509ExtendedKeyManager) {
                return (X509ExtendedKeyManager)km;
            }
            if (debug != null && Debug.isOn("sslctx")) {
                System.out.println("X509KeyManager passed to SSLContext.init():  need an X509ExtendedKeyManager for SSLEngine use");
            }
            return new AbstractKeyManagerWrapper((X509KeyManager)km);
        }
        return DummyX509KeyManager.INSTANCE;
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLSocketFactoryImpl(this);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    abstract SSLEngine createSSLEngineImpl();

    abstract SSLEngine createSSLEngineImpl(String var1, int var2);

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return this.createSSLEngineImpl();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return this.createSSLEngineImpl(host, port);
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    EphemeralKeyManager getEphemeralKeyManager() {
        return this.ephemeralKeyManager;
    }

    abstract ProtocolList getSuportedProtocolList();

    abstract ProtocolList getServerDefaultProtocolList();

    abstract ProtocolList getClientDefaultProtocolList();

    abstract CipherSuiteList getSupportedCipherSuiteList();

    abstract CipherSuiteList getServerDefaultCipherSuiteList();

    abstract CipherSuiteList getClientDefaultCipherSuiteList();

    ProtocolList getDefaultProtocolList(boolean roleIsServer) {
        return roleIsServer ? this.getServerDefaultProtocolList() : this.getClientDefaultProtocolList();
    }

    CipherSuiteList getDefaultCipherSuiteList(boolean roleIsServer) {
        return roleIsServer ? this.getServerDefaultCipherSuiteList() : this.getClientDefaultCipherSuiteList();
    }

    boolean isDefaultProtocolList(ProtocolList protocols) {
        return protocols == this.getServerDefaultProtocolList() || protocols == this.getClientDefaultProtocolList();
    }

    boolean isDefaultCipherSuiteList(CipherSuiteList cipherSuites) {
        return cipherSuites == this.getServerDefaultCipherSuiteList() || cipherSuites == this.getClientDefaultCipherSuiteList();
    }

    private static CipherSuiteList getApplicableSupportedCipherSuiteList(ProtocolList protocols) {
        return SSLContextImpl.getApplicableCipherSuiteList(CipherSuite.allowedCipherSuites(), protocols, 1);
    }

    private static CipherSuiteList getApplicableEnabledCipherSuiteList(ProtocolList protocols, boolean isClient) {
        if (isClient) {
            if (!clientCustomizedCipherSuites.isEmpty()) {
                return SSLContextImpl.getApplicableCipherSuiteList(clientCustomizedCipherSuites, protocols, 1);
            }
        } else if (!serverCustomizedCipherSuites.isEmpty()) {
            return SSLContextImpl.getApplicableCipherSuiteList(serverCustomizedCipherSuites, protocols, 1);
        }
        return SSLContextImpl.getApplicableCipherSuiteList(CipherSuite.allowedCipherSuites(), protocols, 300);
    }

    private static CipherSuiteList getApplicableCipherSuiteList(Collection<CipherSuite> allowedCipherSuites, ProtocolList protocols, int minPriority) {
        TreeSet<CipherSuite> suites = new TreeSet<CipherSuite>();
        if (!protocols.collection().isEmpty() && protocols.min.v != ProtocolVersion.NONE.v) {
            for (CipherSuite suite : allowedCipherSuites) {
                if (!suite.allowed || suite.priority < minPriority) continue;
                if (suite.isAvailable() && suite.obsoleted > protocols.min.v && suite.supported <= protocols.max.v) {
                    if (SSLAlgorithmConstraints.DEFAULT.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), suite.name, null)) {
                        suites.add(suite);
                        continue;
                    }
                    if (debug == null || !Debug.isOn("sslctx") || !Debug.isOn("verbose")) continue;
                    System.out.println("Ignoring disabled cipher suite: " + suite.name);
                    continue;
                }
                if (debug == null || !Debug.isOn("sslctx") || !Debug.isOn("verbose")) continue;
                if (suite.obsoleted <= protocols.min.v) {
                    System.out.println("Ignoring obsoleted cipher suite: " + suite);
                    continue;
                }
                if (suite.supported > protocols.max.v) {
                    System.out.println("Ignoring unsupported cipher suite: " + suite);
                    continue;
                }
                System.out.println("Ignoring unavailable cipher suite: " + suite);
            }
        }
        return new CipherSuiteList(suites);
    }

    private static Collection<CipherSuite> getCustomizedCipherSuites(String propertyName) {
        String property = AccessController.doPrivileged(new GetPropertyAction(propertyName));
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("System property " + propertyName + " is set to '" + property + "'");
        }
        if (property != null && property.length() != 0 && property.length() > 1 && property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
            property = property.substring(1, property.length() - 1);
        }
        if (property != null && property.length() != 0) {
            String[] cipherSuiteNames = property.split(",");
            ArrayList<CipherSuite> cipherSuites = new ArrayList<CipherSuite>(cipherSuiteNames.length);
            for (int i = 0; i < cipherSuiteNames.length; ++i) {
                CipherSuite suite;
                cipherSuiteNames[i] = cipherSuiteNames[i].trim();
                if (cipherSuiteNames[i].isEmpty()) continue;
                try {
                    suite = CipherSuite.valueOf(cipherSuiteNames[i]);
                }
                catch (IllegalArgumentException iae) {
                    if (debug == null || !Debug.isOn("sslctx")) continue;
                    System.out.println("Unknown or unsupported cipher suite name: " + cipherSuiteNames[i]);
                    continue;
                }
                if (suite.isAvailable()) {
                    cipherSuites.add(suite);
                    continue;
                }
                if (debug == null || !Debug.isOn("sslctx")) continue;
                System.out.println("The current installed providers do not support cipher suite: " + cipherSuiteNames[i]);
            }
            return cipherSuites;
        }
        return Collections.emptyList();
    }

    private static String[] getAvailableProtocols(ProtocolVersion[] protocolCandidates) {
        List<String> availableProtocols = Collections.emptyList();
        if (protocolCandidates != null && protocolCandidates.length != 0) {
            availableProtocols = new ArrayList(protocolCandidates.length);
            for (ProtocolVersion p : protocolCandidates) {
                if (!ProtocolVersion.availableProtocols.contains(p)) continue;
                availableProtocols.add(p.name);
            }
        }
        return availableProtocols.toArray(new String[0]);
    }

    public static final class DefaultSSLContext
    extends CustomizedTLSContext {
        public DefaultSSLContext() throws Exception {
            if (DefaultManagersHolder.reservedException != null) {
                throw DefaultManagersHolder.reservedException;
            }
            try {
                super.engineInit(DefaultManagersHolder.keyManagers, DefaultManagersHolder.trustManagers, null);
            }
            catch (Exception e) {
                if (debug != null && Debug.isOn("defaultctx")) {
                    System.out.println("default context init failed: " + e);
                }
                throw e;
            }
        }

        @Override
        protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
            throw new KeyManagementException("Default SSLContext is initialized automatically");
        }

        static SSLContextImpl getDefaultImpl() throws Exception {
            if (DefaultSSLContextHolder.reservedException != null) {
                throw DefaultSSLContextHolder.reservedException;
            }
            return DefaultSSLContextHolder.sslContext;
        }
    }

    private static final class DefaultSSLContextHolder {
        private static final SSLContextImpl sslContext;
        static Exception reservedException;

        private DefaultSSLContextHolder() {
        }

        static {
            reservedException = null;
            DefaultSSLContext mediator = null;
            if (DefaultManagersHolder.reservedException != null) {
                reservedException = DefaultManagersHolder.reservedException;
            } else {
                try {
                    mediator = new DefaultSSLContext();
                }
                catch (Exception e) {
                    reservedException = e;
                }
            }
            sslContext = mediator;
        }
    }

    private static final class DefaultManagersHolder {
        private static final String NONE = "NONE";
        private static final String P11KEYSTORE = "PKCS11";
        private static final TrustManager[] trustManagers;
        private static final KeyManager[] keyManagers;
        static Exception reservedException;

        private DefaultManagersHolder() {
        }

        private static TrustManager[] getTrustManagers() throws Exception {
            KeyStore ks = TrustManagerFactoryImpl.getCacertsKeyStore("defaultctx");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            return tmf.getTrustManagers();
        }

        private static KeyManager[] getKeyManagers() throws Exception {
            final HashMap props = new HashMap();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    props.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                    props.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                    props.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                    props.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                    return null;
                }
            });
            final String defaultKeyStore = (String)props.get("keyStore");
            String defaultKeyStoreType = (String)props.get("keyStoreType");
            String defaultKeyStoreProvider = (String)props.get("keyStoreProvider");
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("keyStore is : " + defaultKeyStore);
                System.out.println("keyStore type is : " + defaultKeyStoreType);
                System.out.println("keyStore provider is : " + defaultKeyStoreProvider);
            }
            if (P11KEYSTORE.equals(defaultKeyStoreType) && !NONE.equals(defaultKeyStore)) {
                throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
            }
            FileInputStream fs = null;
            if (defaultKeyStore.length() != 0 && !NONE.equals(defaultKeyStore)) {
                fs = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws Exception {
                        return new FileInputStream(defaultKeyStore);
                    }
                });
            }
            String defaultKeyStorePassword = (String)props.get("keyStorePasswd");
            char[] passwd = null;
            if (defaultKeyStorePassword.length() != 0) {
                passwd = defaultKeyStorePassword.toCharArray();
            }
            KeyStore ks = null;
            if (defaultKeyStoreType.length() != 0) {
                if (debug != null && Debug.isOn("defaultctx")) {
                    System.out.println("init keystore");
                }
                ks = defaultKeyStoreProvider.length() == 0 ? KeyStore.getInstance(defaultKeyStoreType) : KeyStore.getInstance(defaultKeyStoreType, defaultKeyStoreProvider);
                ks.load(fs, passwd);
            }
            if (fs != null) {
                fs.close();
                fs = null;
            }
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (P11KEYSTORE.equals(defaultKeyStoreType)) {
                kmf.init(ks, null);
            } else {
                kmf.init(ks, passwd);
            }
            return kmf.getKeyManagers();
        }

        static {
            TrustManager[] tmMediator;
            reservedException = null;
            try {
                tmMediator = DefaultManagersHolder.getTrustManagers();
            }
            catch (Exception e) {
                reservedException = e;
                tmMediator = new TrustManager[]{};
            }
            trustManagers = tmMediator;
            if (reservedException == null) {
                KeyManager[] kmMediator;
                try {
                    kmMediator = DefaultManagersHolder.getKeyManagers();
                }
                catch (Exception e) {
                    reservedException = e;
                    kmMediator = new KeyManager[]{};
                }
                keyManagers = kmMediator;
            } else {
                keyManagers = new KeyManager[0];
            }
        }
    }

    public static final class TLSContext
    extends CustomizedTLSContext {
    }

    private static class CustomizedTLSContext
    extends AbstractTLSContext {
        private static final ProtocolList clientDefaultProtocolList;
        private static final CipherSuiteList clientDefaultCipherSuiteList;
        private static IllegalArgumentException reservedException;

        protected CustomizedTLSContext() {
            if (reservedException != null) {
                throw reservedException;
            }
        }

        @Override
        ProtocolList getClientDefaultProtocolList() {
            return clientDefaultProtocolList;
        }

        @Override
        CipherSuiteList getClientDefaultCipherSuiteList() {
            return clientDefaultCipherSuiteList;
        }

        static {
            reservedException = null;
            reservedException = CustomizedSSLProtocols.reservedException;
            if (reservedException == null) {
                ProtocolVersion[] candidates;
                ArrayList<ProtocolVersion> customizedTLSProtocols = new ArrayList<ProtocolVersion>();
                for (ProtocolVersion protocol : CustomizedSSLProtocols.customizedProtocols) {
                    customizedTLSProtocols.add(protocol);
                }
                if (customizedTLSProtocols.isEmpty()) {
                    candidates = SunJSSE.isFIPS() ? new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12} : new ProtocolVersion[]{ProtocolVersion.SSL30, ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12};
                } else {
                    candidates = new ProtocolVersion[customizedTLSProtocols.size()];
                    candidates = customizedTLSProtocols.toArray(candidates);
                }
                clientDefaultProtocolList = new ProtocolList(SSLContextImpl.getAvailableProtocols(candidates));
                clientDefaultCipherSuiteList = SSLContextImpl.getApplicableEnabledCipherSuiteList(CustomizedTLSContext.clientDefaultProtocolList, true);
            } else {
                clientDefaultProtocolList = null;
                clientDefaultCipherSuiteList = null;
            }
        }
    }

    private static class CustomizedSSLProtocols {
        private static final String PROPERTY_NAME = "jdk.tls.client.protocols";
        static IllegalArgumentException reservedException = null;
        static ArrayList<ProtocolVersion> customizedProtocols = new ArrayList();

        private CustomizedSSLProtocols() {
        }

        static {
            String property = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME));
            if (property != null && property.length() != 0 && property.length() > 1 && property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
                property = property.substring(1, property.length() - 1);
            }
            if (property != null && property.length() != 0) {
                String[] protocols = property.split(",");
                for (int i = 0; i < protocols.length; ++i) {
                    protocols[i] = protocols[i].trim();
                    try {
                        ProtocolVersion pro = ProtocolVersion.valueOf(protocols[i]);
                        if (SunJSSE.isFIPS() && (pro.v == ProtocolVersion.SSL30.v || pro.v == ProtocolVersion.SSL20Hello.v)) {
                            reservedException = new IllegalArgumentException("jdk.tls.client.protocols: " + pro + " is not FIPS compliant");
                            break;
                        }
                        if (customizedProtocols.contains(pro)) continue;
                        customizedProtocols.add(pro);
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        reservedException = new IllegalArgumentException("jdk.tls.client.protocols: " + protocols[i] + " is not a standard SSL protocol name", iae);
                    }
                }
            }
        }
    }

    public static final class TLS12Context
    extends AbstractTLSContext {
        private static final ProtocolList clientDefaultProtocolList = SunJSSE.isFIPS() ? new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12})) : new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.SSL30, ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12}));
        private static final CipherSuiteList clientDefaultCipherSuiteList = SSLContextImpl.access$200(clientDefaultProtocolList, true);

        @Override
        ProtocolList getClientDefaultProtocolList() {
            return clientDefaultProtocolList;
        }

        @Override
        CipherSuiteList getClientDefaultCipherSuiteList() {
            return clientDefaultCipherSuiteList;
        }
    }

    public static final class TLS11Context
    extends AbstractTLSContext {
        private static final ProtocolList clientDefaultProtocolList = SunJSSE.isFIPS() ? new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.TLS11})) : new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.SSL30, ProtocolVersion.TLS10, ProtocolVersion.TLS11}));
        private static final CipherSuiteList clientDefaultCipherSuiteList = SSLContextImpl.access$200(clientDefaultProtocolList, true);

        @Override
        ProtocolList getClientDefaultProtocolList() {
            return clientDefaultProtocolList;
        }

        @Override
        CipherSuiteList getClientDefaultCipherSuiteList() {
            return clientDefaultCipherSuiteList;
        }
    }

    public static final class TLS10Context
    extends AbstractTLSContext {
        private static final ProtocolList clientDefaultProtocolList = SunJSSE.isFIPS() ? new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS10})) : new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.SSL30, ProtocolVersion.TLS10}));
        private static final CipherSuiteList clientDefaultCipherSuiteList = SSLContextImpl.access$200(clientDefaultProtocolList, true);

        @Override
        ProtocolList getClientDefaultProtocolList() {
            return clientDefaultProtocolList;
        }

        @Override
        CipherSuiteList getClientDefaultCipherSuiteList() {
            return clientDefaultCipherSuiteList;
        }
    }

    private static abstract class AbstractTLSContext
    extends SSLContextImpl {
        private static final ProtocolList supportedProtocolList;
        private static final ProtocolList serverDefaultProtocolList;
        private static final CipherSuiteList supportedCipherSuiteList;
        private static final CipherSuiteList serverDefaultCipherSuiteList;

        private AbstractTLSContext() {
        }

        @Override
        ProtocolList getSuportedProtocolList() {
            return supportedProtocolList;
        }

        @Override
        CipherSuiteList getSupportedCipherSuiteList() {
            return supportedCipherSuiteList;
        }

        @Override
        ProtocolList getServerDefaultProtocolList() {
            return serverDefaultProtocolList;
        }

        @Override
        CipherSuiteList getServerDefaultCipherSuiteList() {
            return serverDefaultCipherSuiteList;
        }

        @Override
        SSLEngine createSSLEngineImpl() {
            return new SSLEngineImpl(this);
        }

        @Override
        SSLEngine createSSLEngineImpl(String host, int port) {
            return new SSLEngineImpl(this, host, port);
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedProtocolList = new ProtocolList(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                serverDefaultProtocolList = new ProtocolList(SSLContextImpl.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12}));
            } else {
                supportedProtocolList = new ProtocolList(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                serverDefaultProtocolList = new ProtocolList(SSLContextImpl.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.SSL20Hello, ProtocolVersion.SSL30, ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12}));
            }
            supportedCipherSuiteList = SSLContextImpl.getApplicableSupportedCipherSuiteList(AbstractTLSContext.supportedProtocolList);
            serverDefaultCipherSuiteList = SSLContextImpl.getApplicableEnabledCipherSuiteList(AbstractTLSContext.serverDefaultProtocolList, false);
        }
    }
}

