Object.assign(window.search, {"doc_urls":["introduction.html#introduction","editions/index.html#what-are-editions","editions/index.html#editions-do-not-split-the-ecosystem","editions/index.html#edition-migration-is-easy-and-largely-automated","editions/creating-a-new-project.html#creating-a-new-project","editions/transitioning-an-existing-project-to-a-new-edition.html#transitioning-an-existing-project-to-a-new-edition","editions/transitioning-an-existing-project-to-a-new-edition.html#updating-your-code-to-be-compatible-with-the-new-edition","editions/transitioning-an-existing-project-to-a-new-edition.html#enabling-the-new-edition-to-use-new-features","editions/transitioning-an-existing-project-to-a-new-edition.html#writing-idiomatic-code-in-a-new-edition","rust-2015/index.html#rust-2015","rust-2018/index.html#rust-2018","rust-2018/path-changes.html#path-and-module-system-changes","rust-2018/path-changes.html#summary","rust-2018/path-changes.html#motivation","rust-2018/path-changes.html#more-details","rust-2018/path-changes.html#no-more-extern-crate","rust-2018/path-changes.html#the-crate-keyword-refers-to-the-current-crate","rust-2018/path-changes.html#extern-crate-paths","rust-2018/path-changes.html#no-more-modrs","rust-2018/path-changes.html#use-paths","rust-2018/trait-fn-parameters.html#anonymous-trait-function-parameters-deprecated","rust-2018/trait-fn-parameters.html#summary","rust-2018/trait-fn-parameters.html#details","rust-2018/new-keywords.html#new-keywords","rust-2018/new-keywords.html#summary","rust-2018/new-keywords.html#motivation","rust-2018/new-keywords.html#dyn-trait-for-trait-objects","rust-2018/new-keywords.html#async-and-await","rust-2018/new-keywords.html#try-keyword","rust-2018/tyvar-behind-raw-pointer.html#method-dispatch-for-raw-pointers-to-inference-variables","rust-2018/tyvar-behind-raw-pointer.html#summary","rust-2018/tyvar-behind-raw-pointer.html#details","rust-2018/cargo.html#cargo-changes","rust-2018/cargo.html#summary","rust-2021/index.html#rust-2021","rust-2021/prelude.html#additions-to-the-prelude","rust-2021/prelude.html#summary","rust-2021/prelude.html#details","rust-2021/default-cargo-resolver.html#default-cargo-feature-resolver","rust-2021/default-cargo-resolver.html#summary","rust-2021/default-cargo-resolver.html#details","rust-2021/IntoIterator-for-arrays.html#intoiterator-for-arrays","rust-2021/IntoIterator-for-arrays.html#summary","rust-2021/IntoIterator-for-arrays.html#details","rust-2021/disjoint-capture-in-closures.html#disjoint-capture-in-closures","rust-2021/disjoint-capture-in-closures.html#summary","rust-2021/disjoint-capture-in-closures.html#details","rust-2021/panic-macro-consistency.html#panic-macro-consistency","rust-2021/panic-macro-consistency.html#summary","rust-2021/panic-macro-consistency.html#details","rust-2021/reserving-syntax.html#reserving-syntax","rust-2021/reserving-syntax.html#summary","rust-2021/reserving-syntax.html#details","rust-2021/warnings-promoted-to-error.html#warnings-promoted-to-errors","rust-2021/warnings-promoted-to-error.html#summary","rust-2021/warnings-promoted-to-error.html#details","rust-2021/or-patterns-macro-rules.html#or-patterns-in-macro-rules","rust-2021/or-patterns-macro-rules.html#summary","rust-2021/or-patterns-macro-rules.html#details"],"index":{"documentStore":{"docInfo":{"0":{"body":26,"breadcrumbs":2,"title":1},"1":{"body":117,"breadcrumbs":2,"title":1},"10":{"body":43,"breadcrumbs":4,"title":2},"11":{"body":4,"breadcrumbs":10,"title":4},"12":{"body":23,"breadcrumbs":7,"title":1},"13":{"body":107,"breadcrumbs":7,"title":1},"14":{"body":6,"breadcrumbs":8,"title":2},"15":{"body":265,"breadcrumbs":9,"title":3},"16":{"body":43,"breadcrumbs":11,"title":5},"17":{"body":63,"breadcrumbs":9,"title":3},"18":{"body":66,"breadcrumbs":8,"title":2},"19":{"body":231,"breadcrumbs":8,"title":2},"2":{"body":50,"breadcrumbs":4,"title":3},"20":{"body":4,"breadcrumbs":12,"title":5},"21":{"body":8,"breadcrumbs":8,"title":1},"22":{"body":34,"breadcrumbs":8,"title":1},"23":{"body":4,"breadcrumbs":6,"title":2},"24":{"body":13,"breadcrumbs":5,"title":1},"25":{"body":0,"breadcrumbs":5,"title":1},"26":{"body":98,"breadcrumbs":8,"title":4},"27":{"body":11,"breadcrumbs":6,"title":2},"28":{"body":10,"breadcrumbs":6,"title":2},"29":{"body":0,"breadcrumbs":14,"title":6},"3":{"body":92,"breadcrumbs":6,"title":5},"30":{"body":5,"breadcrumbs":9,"title":1},"31":{"body":5,"breadcrumbs":9,"title":1},"32":{"body":0,"breadcrumbs":6,"title":2},"33":{"body":33,"breadcrumbs":5,"title":1},"34":{"body":77,"breadcrumbs":4,"title":2},"35":{"body":0,"breadcrumbs":6,"title":2},"36":{"body":0,"breadcrumbs":5,"title":1},"37":{"body":112,"breadcrumbs":5,"title":1},"38":{"body":0,"breadcrumbs":10,"title":4},"39":{"body":0,"breadcrumbs":7,"title":1},"4":{"body":66,"breadcrumbs":7,"title":3},"40":{"body":39,"breadcrumbs":7,"title":1},"41":{"body":0,"breadcrumbs":6,"title":2},"42":{"body":0,"breadcrumbs":5,"title":1},"43":{"body":170,"breadcrumbs":5,"title":1},"44":{"body":0,"breadcrumbs":8,"title":3},"45":{"body":0,"breadcrumbs":6,"title":1},"46":{"body":107,"breadcrumbs":6,"title":1},"47":{"body":0,"breadcrumbs":8,"title":3},"48":{"body":0,"breadcrumbs":6,"title":1},"49":{"body":140,"breadcrumbs":6,"title":1},"5":{"body":85,"breadcrumbs":11,"title":5},"50":{"body":0,"breadcrumbs":6,"title":2},"51":{"body":0,"breadcrumbs":5,"title":1},"52":{"body":116,"breadcrumbs":5,"title":1},"53":{"body":0,"breadcrumbs":8,"title":3},"54":{"body":0,"breadcrumbs":6,"title":1},"55":{"body":41,"breadcrumbs":6,"title":1},"56":{"body":0,"breadcrumbs":8,"title":3},"57":{"body":0,"breadcrumbs":6,"title":1},"58":{"body":100,"breadcrumbs":6,"title":1},"6":{"body":106,"breadcrumbs":11,"title":5},"7":{"body":45,"breadcrumbs":12,"title":6},"8":{"body":242,"breadcrumbs":11,"title":5},"9":{"body":89,"breadcrumbs":4,"title":2}},"docs":{"0":{"body":"Welcome to the Rust Edition Guide! \"Editions\" are Rust's way of introducing changes into the language that would not otherwise be backwards compatible. In this guide, we'll discuss: What editions are Which changes are contained in each edition How to migrate your code from one edition to another","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"The release of Rust 1.0 established \"stability without stagnation\" as a core Rust deliverable. Ever since the 1.0 release, the rule for Rust has been that once a feature has been released on stable, we are committed to supporting that feature for all future releases. There are times, however, when it is useful to be able to make small changes to the language that are not backwards compatible. The most obvious example is introducing a new keyword, which would invalidate variables with the same name. For example, the first version of Rust did not have the async and await keywords. Suddenly changing those words to keywords in a later version would've broken code like let async = 1;. Editions are the mechanism we use to solve this problem. When we want to release a feature that would otherwise be backwards incompatible, we do so as part of a new Rust edition . Editions are opt-in, and so existing crates do not see these changes until they explicitly migrate over to the new edition. This means that even the latest version of Rust will still not treat async as a keyword, unless edition 2018 or later is chosen. This choice is made per crate as part of its Cargo.toml . New crates created by cargo new are always configured to use the latest stable edition.","breadcrumbs":"What are editions? » What are Editions?","id":"1","title":"What are Editions?"},"10":{"body":"Info RFC #2052 , which also proposed the Edition system Release version 1.31.0 The edition system was created for the release of Rust 2018. The release of the Rust 2018 edition coincided with a number of other features all coordinated around the theme of productivity . The majority of those features were backwards compatible and are now available on all editions; however, some of those changes required the edition mechanism (most notably the module system changes ).","breadcrumbs":"Rust 2018 » Rust 2018","id":"10","title":"Rust 2018"},"11":{"body":"Minimum Rust version: 1.31","breadcrumbs":"Rust 2018 » Path and module system changes » Path and module system changes","id":"11","title":"Path and module system changes"},"12":{"body":"Paths in use declarations now work the same as other paths. Paths starting with :: must now be followed with an external crate. Paths in pub(in path) visibility modifiers must now start with crate, self, or super.","breadcrumbs":"Rust 2018 » Path and module system changes » Summary","id":"12","title":"Summary"},"13":{"body":"The module system is often one of the hardest things for people new to Rust. Everyone has their own things that take time to master, of course, but there's a root cause for why it's so confusing to many: while there are simple and consistent rules defining the module system, their consequences can feel inconsistent, counterintuitive and mysterious. As such, the 2018 edition of Rust introduces a few new module system features, but they end up simplifying the module system, to make it more clear as to what is going on. Here's a brief summary: extern crate is no longer needed in 99% of circumstances. The crate keyword refers to the current crate. Paths may start with a crate name, even within submodules. Paths starting with :: must reference an external crate. A foo.rs and foo/ subdirectory may coexist; mod.rs is no longer needed when placing submodules in a subdirectory. Paths in use declarations work the same as other paths. These may seem like arbitrary new rules when put this way, but the mental model is now significantly simplified overall. Read on for more details!","breadcrumbs":"Rust 2018 » Path and module system changes » Motivation","id":"13","title":"Motivation"},"14":{"body":"Let's talk about each new feature in turn.","breadcrumbs":"Rust 2018 » Path and module system changes » More details","id":"14","title":"More details"},"15":{"body":"This one is quite straightforward: you no longer need to write extern crate to import a crate into your project. Before: // Rust 2015 extern crate futures; mod submodule { use futures::Future;\n} After: // Rust 2018 mod submodule { use futures::Future;\n} Now, to add a new crate to your project, you can add it to your Cargo.toml, and then there is no step two. If you're not using Cargo, you already had to pass --extern flags to give rustc the location of external crates, so you'd just keep doing what you were doing there as well. One small note here: cargo fix will not currently automate this change. We may have it do this for you in the future. An exception There's one exception to this rule, and that's the \"sysroot\" crates. These are the crates distributed with Rust itself. Usually these are only needed in very specialized situations. Starting in 1.41, rustc accepts the --extern=CRATE_NAME flag which automatically adds the given crate name in a way similar to extern crate. Build tools may use this to inject sysroot crates into the crate's prelude. Cargo does not have a general way to express this, though it uses it for proc_macro crates. Some examples of needing to explicitly import sysroot crates are: std : Usually this is not neccesary, because std is automatically imported unless the crate is marked with #![no_std] . core : Usually this is not necessary, because core is automatically imported, unless the crate is marked with #![no_core] . For example, some of the internal crates used by the standard library itself need this. proc_macro : This is automatically imported by Cargo if it is a proc-macro crate starting in 1.42. extern crate proc_macro; would be needed if you want to support older releases, or if using another build tool that does not pass the appropriate --extern flags to rustc. alloc : Items in the alloc crate are usually accessed via re-exports in the std crate. If you are working with a no_std crate that supports allocation, then you may need to explicitly import alloc. test : This is only available on the nightly channel , and is usually only used for the unstable benchmark support. Macros One other use for extern crate was to import macros; that's no longer needed. Macros may be imported with use like any other item. For example, the following use of extern crate: #[macro_use]\nextern crate bar; fn main() { baz!();\n} Can be changed to something like the following: use bar::baz; fn main() { baz!();\n} Renaming crates If you've been using as to rename your crate like this: extern crate futures as f; use f::Future; then removing the extern crate line on its own won't work. You'll need to do this: use futures as f; use self::f::Future; This change will need to happen in any module that uses f.","breadcrumbs":"Rust 2018 » Path and module system changes » No more extern crate","id":"15","title":"No more extern crate"},"16":{"body":"In use declarations and in other code, you can refer to the root of the current crate with the crate:: prefix. For instance, crate::foo::bar will always refer to the name bar inside the module foo, from anywhere else in the same crate. The prefix :: previously referred to either the crate root or an external crate; it now unambiguously refers to an external crate. For instance, ::foo::bar always refers to the name bar inside the external crate foo.","breadcrumbs":"Rust 2018 » Path and module system changes » The crate keyword refers to the current crate","id":"16","title":"The crate keyword refers to the current crate"},"17":{"body":"Previously, using an external crate in a module without a use import required a leading :: on the path. // Rust 2015 extern crate chrono; fn foo() { // this works in the crate root let x = chrono::Utc::now();\n} mod submodule { fn function() { // but in a submodule it requires a leading :: if not imported with `use` let x = ::chrono::Utc::now(); }\n} Now, extern crate names are in scope in the entire crate, including submodules. // Rust 2018 fn foo() { // this works in the crate root let x = chrono::Utc::now();\n} mod submodule { fn function() { // crates may be referenced directly, even in submodules let x = chrono::Utc::now(); }\n}","breadcrumbs":"Rust 2018 » Path and module system changes » Extern crate paths","id":"17","title":"Extern crate paths"},"18":{"body":"In Rust 2015, if you have a submodule: // This `mod` declaration looks for the `foo` module in\n// `foo.rs` or `foo/mod.rs`.\nmod foo; It can live in foo.rs or foo/mod.rs. If it has submodules of its own, it must be foo/mod.rs. So a bar submodule of foo would live at foo/bar.rs. In Rust 2018 the restriction that a module with submodules must be named mod.rs is lifted. foo.rs can just be foo.rs, and the submodule is still foo/bar.rs. This eliminates the special name, and if you have a bunch of files open in your editor, you can clearly see their names, instead of having a bunch of tabs named mod.rs. Rust 2015 Rust 2018 .\n├── lib.rs\n└── foo/ &nbsp;&nbsp; ├── mod.rs &nbsp;&nbsp; └── bar.rs .\n├── lib.rs\n├── foo.rs\n└── foo/ &nbsp;&nbsp; └── bar.rs","breadcrumbs":"Rust 2018 » Path and module system changes » No more mod.rs","id":"18","title":"No more mod.rs"},"19":{"body":"Minimum Rust version: 1.32 Rust 2018 simplifies and unifies path handling compared to Rust 2015. In Rust 2015, paths work differently in use declarations than they do elsewhere. In particular, paths in use declarations would always start from the crate root, while paths in other code implicitly started from the current scope. Those differences didn't have any effect in the top-level module, which meant that everything would seem straightforward until working on a project large enough to have submodules. In Rust 2018, paths in use declarations and in other code work the same way, both in the top-level module and in any submodule. You can use a relative path from the current scope, a path starting from an external crate name, or a path starting with crate, super, or self. Code that looked like this: // Rust 2015 extern crate futures; use futures::Future; mod foo { pub struct Bar;\n} use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String),\n} fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } }\n} will look exactly the same in Rust 2018, except that you can delete the extern crate line: // Rust 2018 use futures::Future; mod foo { pub struct Bar;\n} use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String),\n} fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } }\n} The same code will also work completely unmodified in a submodule: // Rust 2018 mod submodule { use futures::Future; mod foo { pub struct Bar; } use foo::Bar; fn my_poll() -> futures::Poll { ... } enum SomeEnum { V1(usize), V2(String), } fn func() { let five = std::sync::Arc::new(5); use SomeEnum::*; match ... { V1(i) => { ... } V2(s) => { ... } } }\n} This makes it easy to move code around in a project, and avoids introducing additional complexity to multi-module projects. If a path is ambiguous, such as if you have an external crate and a local module or item with the same name, you'll get an error, and you'll need to either rename one of the conflicting names or explicitly disambiguate the path. To explicitly disambiguate a path, use ::name for an external crate name, or self::name for a local module or item.","breadcrumbs":"Rust 2018 » Path and module system changes » use paths","id":"19","title":"use paths"},"2":{"body":"The most important rule for editions is that crates in one edition can interoperate seamlessly with crates compiled in other editions. This ensures that the decision to migrate to a newer edition is a \"private one\" that the crate can make without affecting others. The requirement for crate interoperability implies some limits on the kinds of changes that we can make in an edition. In general, changes that occur in an edition tend to be \"skin deep\". All Rust code, regardless of edition, is ultimately compiled to the same internal representation within the compiler.","breadcrumbs":"What are editions? » Editions do not split the ecosystem","id":"2","title":"Editions do not split the ecosystem"},"20":{"body":"Minimum Rust version: 1.31","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Anonymous trait function parameters deprecated","id":"20","title":"Anonymous trait function parameters deprecated"},"21":{"body":"Trait function parameters may use any irrefutable pattern when the function has a body.","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Summary","id":"21","title":"Summary"},"22":{"body":"In accordance with RFC #1685 , parameters in trait method declarations are no longer allowed to be anonymous. For example, in the 2015 edition, this was allowed: trait Foo { fn foo(&self, u8);\n} In the 2018 edition, all parameters must be given an argument name (even if it's just _): trait Foo { fn foo(&self, baz: u8);\n}","breadcrumbs":"Rust 2018 » Anonymous trait function parameters deprecated » Details","id":"22","title":"Details"},"23":{"body":"Minimum Rust version: 1.27","breadcrumbs":"Rust 2018 » New keywords » New keywords","id":"23","title":"New keywords"},"24":{"body":"dyn is a strict keyword , in 2015 it is a weak keyword . async and await are strict keywords . try is a reserved keyword .","breadcrumbs":"Rust 2018 » New keywords » Summary","id":"24","title":"Summary"},"25":{"body":"","breadcrumbs":"Rust 2018 » New keywords » Motivation","id":"25","title":"Motivation"},"26":{"body":"The dyn Trait feature is the new syntax for using trait objects. In short: Box<Trait> becomes Box<dyn Trait> &Trait and &mut Trait become &dyn Trait and &mut dyn Trait And so on. In code: trait Trait {} impl Trait for i32 {} // old\nfn function1() -> Box<Trait> {\n# unimplemented!()\n} // new\nfn function2() -> Box<dyn Trait> {\n# unimplemented!()\n} That's it! Why? Using just the trait name for trait objects turned out to be a bad decision. The current syntax is often ambiguous and confusing, even to veterans, and favors a feature that is not more frequently used than its alternatives, is sometimes slower, and often cannot be used at all when its alternatives can. Furthermore, with impl Trait arriving, \"impl Trait vs dyn Trait\" is much more symmetric, and therefore a bit nicer, than \"impl Trait vs Trait\". impl Trait is explained here . In the new edition, you should therefore prefer dyn Trait to just Trait where you need a trait object.","breadcrumbs":"Rust 2018 » New keywords » dyn Trait for trait objects","id":"26","title":"dyn Trait for trait objects"},"27":{"body":"These keywords are reserved to implement the async-await feature of Rust, which was ultimately released to stable in 1.39.0 .","breadcrumbs":"Rust 2018 » New keywords » async and await","id":"27","title":"async and await"},"28":{"body":"The try keyword is reserved for use in try blocks, which have not (as of this writing) been stabilized ( tracking issue )","breadcrumbs":"Rust 2018 » New keywords » try keyword","id":"28","title":"try keyword"},"29":{"body":"","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Method dispatch for raw pointers to inference variables","id":"29","title":"Method dispatch for raw pointers to inference variables"},"3":{"body":"Our goal is to make it easy for crates to upgrade to a new edition. When we release a new edition, we also provide tooling to automate the migration . It makes minor changes to your code necessary to make it compatible with the new edition. For example, when migrating to Rust 2018, it changes anything named async to use the equivalent raw identifier syntax : r#async. The automated migrations are not necessarily perfect: there might be some corner cases where manual changes are still required. The tooling tries hard to avoid changes to semantics that could affect the correctness or performance of the code. In addition to tooling, we also maintain this Edition Migration Guide that covers the changes that are part of an edition. This guide describes each change and gives pointers to where you can learn more about it. It also covers any corner cases or details you should be aware of. This guide serves both as an overview of the edition and as a quick troubleshooting reference if you encounter problems with the automated tooling.","breadcrumbs":"What are editions? » Edition migration is easy and largely automated","id":"3","title":"Edition migration is easy and largely automated"},"30":{"body":"The tyvar_behind_raw_pointer lint is now a hard error.","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Summary","id":"30","title":"Summary"},"31":{"body":"See Rust issue #46906 for details.","breadcrumbs":"Rust 2018 » Method dispatch for raw pointers to inference variables » Details","id":"31","title":"Details"},"32":{"body":"","breadcrumbs":"Rust 2018 » Cargo changes » Cargo changes","id":"32","title":"Cargo changes"},"33":{"body":"If there is a target definition in a Cargo.toml manifest, it no longer automatically disables automatic discovery of other targets. Target paths of the form src/{target_name}.rs are no longer inferred for targets where the path field is not set. cargo install for the current directory is no longer allowed, you must specify cargo install --path . to install the current package.","breadcrumbs":"Rust 2018 » Cargo changes » Summary","id":"33","title":"Summary"},"34":{"body":"🚧 The 2021 Edition has not yet been released and hence this section is still \"under construction\". You can read more about our plans in this blog post . Info RFC #3085 Release version 1.56.0 (anticipated) The Rust 2021 Edition is currently slated for release in Rust 1.56.0. Rust 1.56.0 will then be in beta for six weeks, after which it is released as stable on October 21st. However, note that Rust is a project run by volunteers. We prioritize the personal well-being of everyone working on Rust over any deadlines and expectations we might have set. This could mean delaying the edition a version if necessary, or dropping a feature that turns out to be too difficult or stressful to finish in time. That said, we are on schedule and many of the difficult problems are already tackled, thanks to all the people contributing to Rust 2021! 💛","breadcrumbs":"Rust 2021 🚧 » Rust 2021","id":"34","title":"Rust 2021"},"35":{"body":"","breadcrumbs":"Rust 2021 🚧 » Additions to the prelude » Additions to the prelude","id":"35","title":"Additions to the prelude"},"36":{"body":"","breadcrumbs":"Rust 2021 🚧 » Additions to the prelude » Summary","id":"36","title":"Summary"},"37":{"body":"The prelude of the standard library is the module containing everything that is automatically imported in every module. It contains commonly used items such as Option, Vec, drop, and Clone. The Rust compiler prioritizes any manually imported items over those from the prelude, to make sure additions to the prelude will not break any existing code. For example, if you have a crate or module called example containing a pub struct Option;, then use example::*; will make Option unambiguously refer to the one from example; not the one from the standard library. However, adding a trait to the prelude can break existing code in a subtle way. A call to x.try_into() using a MyTryInto trait might become ambiguous and fail to compile if std's TryInto is also imported, since it provides a method with the same name. This is the reason we haven't added TryInto to the prelude yet, since there is a lot of code that would break this way. As a solution, Rust 2021 will use a new prelude. It's identical to the current one, except for three new additions: std::convert::TryInto std::convert::TryFrom std::iter::FromIterator The library team still needs to formally approve these, which will likely happen soon.","breadcrumbs":"Rust 2021 🚧 » Additions to the prelude » Details","id":"37","title":"Details"},"38":{"body":"","breadcrumbs":"Rust 2021 🚧 » Default Cargo feature resolver » Default Cargo feature resolver","id":"38","title":"Default Cargo feature resolver"},"39":{"body":"","breadcrumbs":"Rust 2021 🚧 » Default Cargo feature resolver » Summary","id":"39","title":"Summary"},"4":{"body":"When you create a new project with Cargo, it will automatically add configuration for the latest edition: > cargo +nightly new foo Created binary (application) `foo` project\n> cat .\\foo\\Cargo.toml\n[package]\nname = \"foo\"\nversion = \"0.1.0\"\nauthors = [\"your name <you@example.com>\"]\nedition = \"2018\" [dependencies] That edition = \"2018\" setting will configure your package to use Rust 2018. No more configuration needed! If you'd prefer to use an older edition, you can change the value in that key, for example: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nauthors = [\"your name <you@example.com>\"]\nedition = \"2015\" [dependencies] This will build your package in Rust 2015.","breadcrumbs":"What are editions? » Creating a new project » Creating a new project","id":"4","title":"Creating a new project"},"40":{"body":"Since Rust 1.51.0, Cargo has opt-in support for a new feature resolver which can be activated with resolver = \"2\" in Cargo.toml. Starting in Rust 2021, this will be the default. That is, writing edition = \"2021\" in Cargo.toml will imply resolver = \"2\". The new feature resolver no longer merges all requested features for crates that are depended on in multiple ways. See the announcement of Rust 1.51 for details.","breadcrumbs":"Rust 2021 🚧 » Default Cargo feature resolver » Details","id":"40","title":"Details"},"41":{"body":"","breadcrumbs":"Rust 2021 🚧 » IntoIterator for arrays » IntoIterator for arrays","id":"41","title":"IntoIterator for arrays"},"42":{"body":"","breadcrumbs":"Rust 2021 🚧 » IntoIterator for arrays » Summary","id":"42","title":"Summary"},"43":{"body":"Until Rust 1.53, only references to arrays implement IntoIterator. This means you can iterate over &[1, 2, 3] and &mut [1, 2, 3], but not over [1, 2, 3] directly. for &e in &[1, 2, 3] {} // Ok :) for e in [1, 2, 3] {} // Error :( This has been a long-standing issue , but the solution is not as simple as it seems. Just adding the trait implementation would break existing code. array.into_iter() already compiles today because that implicitly calls (&array).into_iter() due to how method call syntax works . Adding the trait implementation would change the meaning. Usually we categorize this type of breakage (adding a trait implementation) 'minor' and acceptable. But in this case there is too much code that would be broken by it. It has been suggested many times to \"only implement IntoIterator for arrays in Rust 2021\". However, this is simply not possible. You can't have a trait implementation exist in one edition and not in another, since editions can be mixed. Instead, we decided to add the trait implementation in all editions (starting in Rust 1.53.0), but add a small hack to avoid breakage until Rust 2021. In Rust 2015 and 2018 code, the compiler will still resolve array.into_iter() to (&array).into_iter() like before, as if the trait implementation does not exist. This only applies to the .into_iter() method call syntax. It does not affect any other syntax such as for e in [1, 2, 3], iter.zip([1, 2, 3]) or IntoIterator::into_iter([1, 2, 3]). Those will start to work in all editions. While it's a shame that this required a small hack to avoid breakage, we're very happy with how this solution keeps the difference between the editions to an absolute minimum. Since the hack is only present in the older editions, there is no added complexity in the new edition.","breadcrumbs":"Rust 2021 🚧 » IntoIterator for arrays » Details","id":"43","title":"Details"},"44":{"body":"","breadcrumbs":"Rust 2021 🚧 » Disjoint capture in closures » Disjoint capture in closures","id":"44","title":"Disjoint capture in closures"},"45":{"body":"","breadcrumbs":"Rust 2021 🚧 » Disjoint capture in closures » Summary","id":"45","title":"Summary"},"46":{"body":"Closures automatically capture anything that you refer to from within their body. For example, || a + 1 automatically captures a reference to a from the surrounding context. Currently, this applies to whole structs, even when only using one field. For example, || a.x + 1 captures a reference to a and not just a.x. In some situations, this is a problem. When a field of the struct is already borrowed (mutably) or moved out of, the other fields can no longer be used in a closure, since that would capture the whole struct, which is no longer available. let a = SomeStruct::new(); drop(a.x); // Move out of one field of the struct println!(\"{}\", a.y); // Ok: Still use another field of the struct let c = || println!(\"{}\", a.y); // Error: Tries to capture all of `a`\nc(); Starting in Rust 2021, closures will only capture the fields that they use. So, the above example will compile fine in Rust 2021. This new behavior is only activated in the new edition, since it can change the order in which fields are dropped. As for all edition changes, an automatic migration is available, which will update your closures for which this matters. It can insert let _ = &a; inside the closure to force the entire struct to be captured as before.","breadcrumbs":"Rust 2021 🚧 » Disjoint capture in closures » Details","id":"46","title":"Details"},"47":{"body":"","breadcrumbs":"Rust 2021 🚧 » Panic macro consistency » Panic macro consistency","id":"47","title":"Panic macro consistency"},"48":{"body":"","breadcrumbs":"Rust 2021 🚧 » Panic macro consistency » Summary","id":"48","title":"Summary"},"49":{"body":"The panic!() macro is one of Rust's most well known macros. However, it has some subtle surprises that we can't just change due to backwards compatibility. panic!(\"{}\", 1); // Ok, panics with the message \"1\"\npanic!(\"{}\"); // Ok, panics with the message \"{}\" The panic!() macro only uses string formatting when it's invoked with more than one argument. When invoked with a single argument, it doesn't even look at that argument. let a = \"{\";\nprintln!(a); // Error: First argument must be a format string literal\npanic!(a); // Ok: The panic macro doesn't care (It even accepts non-strings such as panic!(123), which is uncommon and rarely useful.) This will especially be a problem once implicit format arguments are stabilized. That feature will make println!(\"hello {name}\") a short-hand for println!(\"hello {}\", name). However, panic!(\"hello {name}\") would not work as expected, since panic!() doesn't process a single argument as format string. To avoid that confusing situation, Rust 2021 features a more consistent panic!() macro. The new panic!() macro will no longer accept arbitrary expressions as the only argument. It will, just like println!(), always process the first argument as format string. Since panic!() will no longer accept arbitrary payloads, panic_any() will be the only way to panic with something other than a formatted string. In addition, core::panic!() and std::panic!() will be identical in Rust 2021. Currently, there are some historical differences between those two, which can be noticable when switching #![no_std] on or off.","breadcrumbs":"Rust 2021 🚧 » Panic macro consistency » Details","id":"49","title":"Details"},"5":{"body":"New editions might change the way you write Rust – they add new syntax, language, and library features, and also remove features. For example, try, async, and await are keywords in Rust 2018, but not Rust 2015. If you have a project that's using Rust 2015, and you'd like to use Rust 2018 for it instead, there's a few steps that you need to take. It's our intention that the migration to new editions is as smooth an experience as possible. If it's difficult for you to upgrade to the latest edition, we consider that a bug. If you run into problems with this process, please file a bug . Thank you! Here's an example. Imagine we have a crate that has this code in src/lib.rs: trait Foo { fn foo(&self, Box<Foo>);\n} This code uses an anonymous parameter, that Box<Foo>. This is not supported in Rust 2018 , and so this would fail to compile. Let's get this code up to date!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Transitioning an existing project to a new edition","id":"5","title":"Transitioning an existing project to a new edition"},"50":{"body":"","breadcrumbs":"Rust 2021 🚧 » Reserving syntax » Reserving syntax","id":"50","title":"Reserving syntax"},"51":{"body":"","breadcrumbs":"Rust 2021 🚧 » Reserving syntax » Summary","id":"51","title":"Summary"},"52":{"body":"To make space for some new syntax in the future, we've decided to reserve syntax for prefixed identifiers and literals: prefix#identifier, prefix\"string\", prefix'c', and prefix#123, where prefix can be any identifier. (Except those that already have a meaning, such as b'…' and r\"…\".) This is a breaking change, since macros can currently accept hello\"world\", which they will see as two separate tokens: hello and \"world\". The (automatic) fix is simple though. Just insert a space: hello \"world\". Other than turning these into a tokenization error, the RFC does not attach a meaning to any prefix yet. Assigning meaning to specific prefixes is left to future proposals, which will—thanks to reserving these prefixes now—not be breaking changes. These are some new prefixes you might see in the future: f\"\" as a short-hand for a format string. For example, f\"hello {name}\" as a short-hand for the equivalent format_args!() invocation. c\"\" or z\"\" for null-terminated C strings. k#keyword to allow writing keywords that don't exist yet in the current edition. For example, while async is not a keyword in edition 2015, this prefix would've allowed us to accept k#async in edition 2015 without having to wait for edition 2018 to reserve async as a keyword.","breadcrumbs":"Rust 2021 🚧 » Reserving syntax » Details","id":"52","title":"Details"},"53":{"body":"","breadcrumbs":"Rust 2021 🚧 » Warnings promoted to errors » Warnings promoted to errors","id":"53","title":"Warnings promoted to errors"},"54":{"body":"","breadcrumbs":"Rust 2021 🚧 » Warnings promoted to errors » Summary","id":"54","title":"Summary"},"55":{"body":"Two existing lints are becoming hard errors in Rust 2021. These lints will remain warnings in older editions. bare-trait-objects: The use of the dyn keyword to identify trait objects will be mandatory in Rust 2021. ellipsis-inclusive-range-patterns: The deprecated ... syntax for inclusive range patterns is no longer accepted in Rust 2021. It has been superseded by ..=, which is consistent with expressions.","breadcrumbs":"Rust 2021 🚧 » Warnings promoted to errors » Details","id":"55","title":"Details"},"56":{"body":"","breadcrumbs":"Rust 2021 🚧 » Or patterns in macro-rules » Or patterns in macro-rules","id":"56","title":"Or patterns in macro-rules"},"57":{"body":"","breadcrumbs":"Rust 2021 🚧 » Or patterns in macro-rules » Summary","id":"57","title":"Summary"},"58":{"body":"Starting in Rust 1.53.0, patterns are extended to support | nested anywhere in the pattern. This enables you to write Some(1 | 2) instead of Some(1) | Some(2). Since this was simply not allowed before, this is not a breaking change. However, this change also affects macro_rules macros . Such macros can accept patterns using the :pat fragment specifier. Currently, :pat does not match |, since before Rust 1.53, not all patterns (at all nested levels) could contain a |. Macros that accept patterns like A | B, such as matches!() use something like $($_:pat)|+. Because we don't want to break any existing macros, we did not change the meaning of :pat in Rust 1.53.0 to include |. Instead, we will make that change as part of Rust 2021. In the new edition, the :pat fragment specifier will match A | B. Since there are times that one still wishes to match a single pattern variant without |, the fragment specified :pat_param has been added to retain the older behavior. The name refers to its main use case: a pattern in a closure parameter.","breadcrumbs":"Rust 2021 🚧 » Or patterns in macro-rules » Details","id":"58","title":"Details"},"6":{"body":"Your code may or may not use features that are incompatible with the new edition. In order to help transition to Rust 2018, we've included a new subcommand with Cargo. To start, let's run it: > cargo fix --edition This will check your code, and automatically fix any issues that it can. Let's look at src/lib.rs again: trait Foo { fn foo(&self, _: Box<Foo>);\n} It's re-written our code to introduce a parameter name for that trait object. In this case, since it had no name, cargo fix will replace it with _, which is conventional for unused variables. cargo fix can't always fix your code automatically. If cargo fix can't fix something, it will print the warning that it cannot fix to the console. If you see one of these warnings, you'll have to update your code manually. See the corresponding section of this guide for help, and if you have problems, please seek help at the user's forums . Keep running cargo fix --edition until you have no more warnings. Congrats! Your code is now valid in both Rust 2015 and Rust 2018!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Updating your code to be compatible with the new edition","id":"6","title":"Updating your code to be compatible with the new edition"},"7":{"body":"In order to use some new features, you must explicitly opt in to the new edition. Once you're ready to commit, change your Cargo.toml to add the new edition key/value pair. For example: [package]\nname = \"foo\"\nversion = \"0.1.0\"\nauthors = [\"Your Name <you@example.com>\"]\nedition = \"2018\" If there's no edition key, Cargo will default to Rust 2015. But in this case, we've chosen 2018, and so our code is compiling with Rust 2018!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Enabling the new edition to use new features","id":"7","title":"Enabling the new edition to use new features"},"8":{"body":"Editions are not only about new features and removing old ones. In any programming language, idioms change over time, and Rust is no exception. While old code will continue to compile, it might be written with different idioms today. Our sample code contains an outdated idiom. Here it is again: trait Foo { fn foo(&self, _: Box<Foo>);\n} In Rust 2018, it's considered idiomatic to use the dyn keyword for trait objects. Eventually, we want cargo fix to fix all these idioms automatically in the same manner we did for upgrading to the 2018 edition. Currently, though, the \"idiom lints\" are not ready for widespread automatic fixing. The compiler isn't making cargo fix-compatible suggestions in many cases right now, and it is making incorrect suggestions in others. Enabling the idiom lints, even with cargo fix, is likely to leave your crate either broken or with many warnings still remaining. We have plans to make these idiom migrations a seamless part of the Rust 2018 experience, but we're not there yet. As a result the following instructions are recommended only for the intrepid who are willing to work through a few compiler/Cargo bugs! With that out of the way, we can instruct Cargo to fix our code snippet with: $ cargo fix --edition-idioms Afterwards, src/lib.rs looks like this: trait Foo { fn foo(&self, _: Box<dyn Foo>);\n} We're now more idiomatic, and we didn't have to fix our code manually! Note that cargo fix may still not be able to automatically update our code. If cargo fix can't fix something, it will print a warning to the console, and you'll have to fix it manually. As mentioned before, there are known bugs around the idiom lints which means they're not all ready for prime time yet. You may get a scary-looking warning to report a bug to Cargo, which happens whenever a fix proposed by rustc actually caused code to stop compiling by accident. If you'd like cargo fix to make as much progress as possible, even if it causes code to stop compiling, you can execute: $ cargo fix --edition-idioms --broken-code This will instruct cargo fix to apply automatic suggestions regardless of whether they work or not. Like usual, you'll see the compilation result after all fixes are applied. If you notice anything wrong or unusual, please feel free to report an issue to Cargo and we'll help prioritize and fix it. Enjoy the new edition!","breadcrumbs":"What are editions? » Transitioning an existing project to a new edition » Writing idiomatic code in a new edition","id":"8","title":"Writing idiomatic code in a new edition"},"9":{"body":"Rust 2015 has a theme of \"stability\". It commenced with the release of 1.0, and is the \"default edition\". The edition system was conceived in late 2017, but Rust 1.0 was released in May of 2015. As such, 2015 is the edition that you get when you don't specify any particular edition, for backwards compatibility reasons. \"Stability\" is the theme of Rust 2015 because 1.0 marked a huge change in Rust development. Previous to Rust 1.0, Rust was changing on a daily basis. This made it very difficult to write large software in Rust, and made it difficult to learn. With the release of Rust 1.0 and Rust 2015, we committed to backwards compatibility, ensuring a solid foundation for people to build projects on top of. Since it's the default edition, there's no way to port your code to Rust 2015; it just is . You'll be transitioning away from 2015, but never really to 2015. As such, there's not much else to say about it!","breadcrumbs":"Rust 2015 » Rust 2015","id":"9","title":"Rust 2015"}},"length":59,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"1":{".":{"0":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"9":{"tf":2.23606797749979}}},"2":{"7":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"3":{"1":{".":{"0":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.0}}},"2":{"df":1,"docs":{"19":{"tf":1.0}}},"9":{".":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"df":1,"docs":{"15":{"tf":1.0}}},"2":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"5":{"1":{".":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}},"3":{".":{"0":{"df":2,"docs":{"43":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"43":{"tf":1.0},"58":{"tf":1.0}}},"6":{".":{"0":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"5":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"1":{"tf":1.0},"43":{"tf":2.449489742783178},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951}}},"2":{"0":{"1":{"5":{"df":13,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"22":{"tf":1.0},"24":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":3.0}}},"7":{"df":1,"docs":{"9":{"tf":1.0}}},"8":{"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"22":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"43":{"tf":1.0},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"2":{"1":{"df":8,"docs":{"34":{"tf":2.0},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"58":{"tf":1.0}}},"df":0,"docs":{}},"5":{"2":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":3,"docs":{"40":{"tf":1.4142135623730951},"43":{"tf":2.8284271247461903},"58":{"tf":1.0}}},"3":{"0":{"8":{"5":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":2.8284271247461903}}},"4":{"6":{"9":{"0":{"6":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"9":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"_":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":4,"docs":{"22":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"a":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"46":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"58":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"40":{"tf":1.0},"46":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":5,"docs":{"15":{"tf":1.7320508075688772},"4":{"tf":1.0},"43":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}},"df":3,"docs":{"37":{"tf":1.4142135623730951},"43":{"tf":2.0},"58":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"15":{"tf":2.0}}},"df":0,"docs":{},"w":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"33":{"tf":1.0},"52":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":5,"docs":{"15":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"1":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"37":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":3,"docs":{"20":{"tf":1.0},"22":{"tf":1.0},"5":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"3":{"tf":1.0},"46":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"58":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":3,"docs":{"43":{"tf":1.0},"46":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"v":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"49":{"tf":2.8284271247461903}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":6,"docs":{"1":{"tf":1.7320508075688772},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"15":{"tf":2.0},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.7320508075688772},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":2.0}}}},"df":2,"docs":{"15":{"tf":1.0},"3":{"tf":2.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.4142135623730951},"49":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"5":{"tf":1.0}}}},"r":{"df":1,"docs":{"3":{"tf":1.0}}},"y":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"49":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.7320508075688772}},"e":{"df":1,"docs":{"55":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}},"z":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"22":{"tf":1.0}}}},"df":2,"docs":{"52":{"tf":1.0},"58":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"37":{"tf":1.0},"55":{"tf":1.0}}}}},"df":1,"docs":{"34":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"58":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"43":{"tf":1.0},"49":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0}}}},"x":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":3,"docs":{"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}}},"df":4,"docs":{"37":{"tf":1.7320508075688772},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"43":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"4":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"43":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"44":{"tf":1.0},"46":{"tf":2.6457513110645907}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"df":10,"docs":{"1":{"tf":1.0},"15":{"tf":2.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"6":{"tf":2.449489742783178},"7":{"tf":1.0},"8":{"tf":3.4641016151377544}}}}},"s":{"df":0,"docs":{},"e":{"df":6,"docs":{"3":{"tf":1.4142135623730951},"43":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":1,"docs":{"4":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"46":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":18,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"15":{"tf":1.7320508075688772},"2":{"tf":1.4142135623730951},"3":{"tf":2.449489742783178},"32":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"58":{"tf":2.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"17":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"44":{"tf":1.0},"46":{"tf":2.23606797749979},"58":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":14,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":2.23606797749979},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"43":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"6":{"tf":2.6457513110645907},"7":{"tf":1.0},"8":{"tf":3.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}},"t":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"2":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}},"x":{"df":2,"docs":{"19":{"tf":1.0},"43":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"13":{"tf":1.0},"26":{"tf":1.0},"49":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"13":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"37":{"tf":1.7320508075688772},"58":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"15":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"1":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"15":{"tf":5.291502622129181},"16":{"tf":3.0},"17":{"tf":2.8284271247461903},"19":{"tf":2.6457513110645907},"2":{"tf":2.0},"3":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"4":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"26":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"58":{"tf":1.0},"8":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"43":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"26":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"22":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"38":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"40":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"20":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":13,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.4142135623730951},"37":{"tf":1.0},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"34":{"tf":1.4142135623730951},"5":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"df":1,"docs":{"15":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"52":{"tf":1.0},"58":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"a":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"34":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"43":{"tf":1.0},"49":{"tf":1.0}}}},"y":{"df":0,"docs":{},"n":{"df":4,"docs":{"24":{"tf":1.0},"26":{"tf":2.449489742783178},"55":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":21,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":2.6457513110645907},"10":{"tf":2.23606797749979},"13":{"tf":1.0},"2":{"tf":2.8284271247461903},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":2.6457513110645907},"34":{"tf":1.7320508075688772},"4":{"tf":2.23606797749979},"40":{"tf":1.0},"43":{"tf":2.6457513110645907},"46":{"tf":1.4142135623730951},"5":{"tf":2.0},"52":{"tf":2.0},"55":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":2.23606797749979},"8":{"tf":2.449489742783178},"9":{"tf":2.23606797749979}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":1,"docs":{"43":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"58":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"46":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"34":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.0},"37":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"22":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":2.0},"4":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"37":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"37":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"5":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"15":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"=":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":3.605551275463989},"16":{"tf":1.7320508075688772},"17":{"tf":2.0},"19":{"tf":2.23606797749979}}}}}}}},"f":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.0},"5":{"tf":1.0}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":2,"docs":{"15":{"tf":1.7320508075688772},"52":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":3,"docs":{"13":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"33":{"tf":1.0},"46":{"tf":2.6457513110645907}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}},"x":{"df":4,"docs":{"15":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":3.0},"8":{"tf":4.242640687119285}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"n":{"df":8,"docs":{"15":{"tf":1.4142135623730951},"17":{"tf":2.0},"19":{"tf":2.449489742783178},"22":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":2.23606797749979}}}},"/":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"19":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"\\":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":11,"docs":{"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":2.23606797749979},"19":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"4":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"r":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"49":{"tf":2.449489742783178},"52":{"tf":1.0}}}},"df":1,"docs":{"33":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"19":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"1":{"df":1,"docs":{"26":{"tf":1.0}}},"2":{"df":1,"docs":{"26":{"tf":1.0}}},"df":3,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"15":{"tf":2.0},"19":{"tf":1.0},"52":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"2":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"3":{"tf":1.0}},"n":{"df":2,"docs":{"15":{"tf":1.0},"22":{"tf":1.0}}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":1,"docs":{"13":{"tf":1.0}}},"u":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"6":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"49":{"tf":1.0},"52":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"15":{"tf":1.0},"37":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"r":{"d":{"df":3,"docs":{"3":{"tf":1.0},"30":{"tf":1.0},"55":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"52":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"p":{"df":2,"docs":{"6":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}}},"df":3,"docs":{"15":{"tf":1.0},"26":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"i":{"3":{"2":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"49":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"3":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}},"df":1,"docs":{"8":{"tf":3.1622776601683795}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"43":{"tf":2.8284271247461903}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"43":{"tf":1.0}}}}}}},"df":2,"docs":{"2":{"tf":1.0},"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":2.8284271247461903},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"37":{"tf":1.7320508075688772}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"17":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}}},"o":{"df":2,"docs":{"10":{"tf":1.0},"34":{"tf":1.0}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"52":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"46":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"n":{"c":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":4,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"2":{"tf":1.0}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"[":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"6":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":5,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"'":{"df":9,"docs":{"13":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951}}},"r":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"[":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"43":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}}}}},"k":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":11,"docs":{"1":{"tf":2.0},"13":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"5":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"8":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}},"r":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"t":{"'":{"df":3,"docs":{"14":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"15":{"tf":1.0},"37":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"19":{"tf":1.0}}},"t":{"df":3,"docs":{"30":{"tf":1.0},"55":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"52":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.7320508075688772},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"49":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":6,"docs":{"15":{"tf":2.0},"47":{"tf":1.0},"49":{"tf":2.449489742783178},"52":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":2.0}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"1":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"58":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":10,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":2.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"8":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"3":{"tf":1.0},"37":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"58":{"tf":2.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"58":{"tf":1.0},"8":{"tf":1.0}},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"22":{"tf":1.0},"29":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.23606797749979},"46":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"11":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"43":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"43":{"tf":1.0}}}}},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":2.0}}}},"df":4,"docs":{"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":2.0}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"37":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":11,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"49":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"13":{"tf":1.0},"25":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"19":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"26":{"tf":1.0},"43":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"26":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":17,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":2.23606797749979},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":2.0},"49":{"tf":1.7320508075688772},"52":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{";":{"&":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":7,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":3.0},"19":{"tf":1.0},"26":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"w":{"df":19,"docs":{"1":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.7320508075688772},"3":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"49":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"34":{"tf":1.0},"8":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"49":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}},"—":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"26":{"tf":2.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"k":{"df":3,"docs":{"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.7320508075688772}}},"l":{"d":{"df":2,"docs":{"26":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"15":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":3,"docs":{"1":{"tf":1.0},"49":{"tf":1.0},"7":{"tf":1.0}}},"df":12,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"t":{"df":3,"docs":{"1":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"46":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"8":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":5,"docs":{"1":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.4142135623730951},"8":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"33":{"tf":1.0},"4":{"tf":2.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"1":{"2":{"3":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"47":{"tf":1.0},"49":{"tf":3.4641016151377544}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"5":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"58":{"tf":2.0}},"h":{"df":6,"docs":{"11":{"tf":1.0},"12":{"tf":2.23606797749979},"13":{"tf":2.0},"17":{"tf":1.4142135623730951},"19":{"tf":3.4641016151377544},"33":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"21":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"58":{"tf":2.6457513110645907}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"34":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"df":1,"docs":{"1":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"29":{"tf":1.0},"3":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"43":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"#":{"1":{"2":{"3":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"'":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"16":{"tf":1.4142135623730951},"52":{"tf":2.6457513110645907}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"15":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}},"s":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}}},"a":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"46":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"34":{"tf":1.0},"37":{"tf":1.0},"8":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":7,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"34":{"tf":1.0},"4":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"3":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":2,"docs":{"19":{"tf":1.7320508075688772},"37":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"r":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}},"w":{"df":2,"docs":{"29":{"tf":1.0},"3":{"tf":1.0}}}},"df":1,"docs":{"52":{"tf":1.0}},"e":{"a":{"d":{"df":2,"docs":{"13":{"tf":1.0},"34":{"tf":1.0}},"i":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"37":{"tf":1.0},"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"15":{"tf":1.0},"6":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":2.449489742783178},"3":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.7320508075688772},"58":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"19":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":7,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.7320508075688772},"15":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":2.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"55":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"15":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":5,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":3,"docs":{"38":{"tf":1.0},"40":{"tf":2.0},"43":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}}},"f":{"c":{"df":4,"docs":{"10":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"1":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"2":{"tf":1.0},"56":{"tf":1.0}}}},"n":{"df":3,"docs":{"34":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"0":{"tf":1.0},"49":{"tf":1.0}}},"c":{"df":2,"docs":{"15":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"df":29,"docs":{"0":{"tf":1.0},"1":{"tf":2.449489742783178},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"18":{"tf":2.0},"19":{"tf":3.0},"2":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":2.6457513110645907},"37":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"43":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"5":{"tf":2.449489742783178},"55":{"tf":1.7320508075688772},"58":{"tf":2.0},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":3.3166247903554}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":1.0},"37":{"tf":1.0},"8":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"6":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":7,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}},"k":{"df":1,"docs":{"6":{"tf":1.0}}},"m":{"df":3,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"43":{"tf":1.0}}}},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"12":{"tf":1.0},"19":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":3,"docs":{"33":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0}},"i":{"df":2,"docs":{"43":{"tf":1.0},"58":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"19":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"15":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"34":{"tf":1.0}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.4142135623730951}}}},"v":{"df":1,"docs":{"1":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"15":{"tf":1.0},"49":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}},"i":{"df":3,"docs":{"33":{"tf":1.0},"58":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"49":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"l":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"27":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"15":{"tf":1.0},"37":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"19":{"tf":2.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}}}}},"d":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"15":{"tf":1.0},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"15":{"tf":1.0},"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"49":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.7320508075688772},"37":{"tf":1.0},"46":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"18":{"tf":2.23606797749979},"19":{"tf":2.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.0},"49":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":14,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"19":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"15":{"tf":1.7320508075688772},"40":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":7,"docs":{"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"43":{"tf":1.7320508075688772},"5":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"13":{"tf":2.0},"9":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"18":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":2.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"34":{"tf":1.0},"5":{"tf":1.0}}}},"t":{"'":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"26":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":5,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"y":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":7,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"19":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"43":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"3":{"tf":2.0}}}},"p":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":10,"docs":{"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.7320508075688772},"26":{"tf":4.898979485566356},"37":{"tf":1.4142135623730951},"43":{"tf":2.449489742783178},"5":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":5,"docs":{"24":{"tf":1.0},"28":{"tf":1.7320508075688772},"3":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"14":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":4,"docs":{"15":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"8":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"27":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"37":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"43":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":21,"docs":{"1":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":4.123105625617661},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":3.872983346207417},"21":{"tf":1.0},"26":{"tf":2.0},"28":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":2.0},"4":{"tf":1.4142135623730951},"46":{"tf":2.0},"49":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"55":{"tf":1.0},"58":{"tf":1.7320508075688772},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":2.23606797749979},"43":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"1":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"2":{"(":{"df":1,"docs":{"19":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"29":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"9":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"11":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"53":{"tf":1.0},"55":{"tf":1.0},"6":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}}},"y":{"df":10,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"37":{"tf":1.4142135623730951},"40":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":2,"docs":{"43":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"v":{"df":3,"docs":{"52":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.0}}}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.0},"34":{"tf":1.0},"49":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}},"—":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"2":{"tf":1.0},"46":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":9,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":2.0},"34":{"tf":1.0},"43":{"tf":1.4142135623730951},"49":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"l":{"d":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"15":{"tf":1.0},"28":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"x":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":2.0}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":4,"docs":{"15":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"r":{"df":2,"docs":{"15":{"tf":1.0},"7":{"tf":1.0}}},"v":{"df":1,"docs":{"15":{"tf":1.0}}}},"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"z":{"df":1,"docs":{"52":{"tf":1.0}}}}},"breadcrumbs":{"root":{"0":{".":{"1":{".":{"0":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{".":{"0":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"9":{"tf":2.23606797749979}}},"2":{"7":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"3":{"1":{".":{"0":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.0}}},"2":{"df":1,"docs":{"19":{"tf":1.0}}},"9":{".":{"0":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"df":1,"docs":{"15":{"tf":1.0}}},"2":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"5":{"1":{".":{"0":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}}},"3":{".":{"0":{"df":2,"docs":{"43":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":2,"docs":{"43":{"tf":1.0},"58":{"tf":1.0}}},"6":{".":{"0":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"8":{"5":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"1":{"tf":1.0},"43":{"tf":2.449489742783178},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951}}},"2":{"0":{"1":{"5":{"df":13,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"22":{"tf":1.0},"24":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":3.3166247903554}}},"7":{"df":1,"docs":{"9":{"tf":1.0}}},"8":{"df":33,"docs":{"1":{"tf":1.0},"10":{"tf":2.23606797749979},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":2.449489742783178},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.7320508075688772},"43":{"tf":1.0},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"2":{"1":{"df":25,"docs":{"34":{"tf":2.449489742783178},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"5":{"2":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":3,"docs":{"40":{"tf":1.4142135623730951},"43":{"tf":2.8284271247461903},"58":{"tf":1.0}}},"3":{"0":{"8":{"5":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":2.8284271247461903}}},"4":{"6":{"9":{"0":{"6":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"9":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"_":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":4,"docs":{"22":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"a":{".":{"df":0,"docs":{},"i":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"46":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"55":{"tf":1.0},"58":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"40":{"tf":1.0},"46":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"d":{"df":5,"docs":{"15":{"tf":1.7320508075688772},"4":{"tf":1.0},"43":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"49":{"tf":1.0}}}}},"df":3,"docs":{"37":{"tf":1.4142135623730951},"43":{"tf":2.0},"58":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"15":{"tf":2.0}}},"df":0,"docs":{},"w":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"33":{"tf":1.0},"52":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":5,"docs":{"15":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":5,"docs":{"1":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":3,"docs":{"19":{"tf":1.0},"26":{"tf":1.0},"37":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":4,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"15":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"3":{"tf":1.0},"46":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"58":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":3,"docs":{"43":{"tf":1.0},"46":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"v":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"22":{"tf":1.0},"49":{"tf":2.8284271247461903}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"n":{"c":{"df":6,"docs":{"1":{"tf":1.7320508075688772},"24":{"tf":1.0},"27":{"tf":1.7320508075688772},"3":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"15":{"tf":2.0},"33":{"tf":1.4142135623730951},"37":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.7320508075688772},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":2.0}}}},"df":2,"docs":{"15":{"tf":1.0},"3":{"tf":2.23606797749979}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":4,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.4142135623730951},"49":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":1.7320508075688772},"5":{"tf":1.0}}}},"r":{"df":1,"docs":{"3":{"tf":1.0}}},"y":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.0},"49":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"18":{"tf":1.0},"19":{"tf":1.7320508075688772}},"e":{"df":1,"docs":{"55":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}},"z":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"22":{"tf":1.0}}}},"df":2,"docs":{"52":{"tf":1.0},"58":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"26":{"tf":1.4142135623730951},"37":{"tf":1.0},"55":{"tf":1.0}}}}},"df":1,"docs":{"34":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"58":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"43":{"tf":1.0},"49":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"46":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"19":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0}}}},"x":{"<":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":3,"docs":{"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}}},"df":4,"docs":{"37":{"tf":1.7320508075688772},"43":{"tf":1.0},"52":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"1":{"tf":1.0},"43":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"5":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"4":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":4,"docs":{"43":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":2.8284271247461903}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"33":{"tf":1.0},"40":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"df":11,"docs":{"1":{"tf":1.0},"15":{"tf":2.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"6":{"tf":2.449489742783178},"7":{"tf":1.0},"8":{"tf":3.4641016151377544}}}}},"s":{"df":0,"docs":{},"e":{"df":6,"docs":{"3":{"tf":1.4142135623730951},"43":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":1,"docs":{"4":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"df":2,"docs":{"46":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":26,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":2.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":2.449489742783178},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.4142135623730951},"58":{"tf":2.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"7":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"17":{"tf":2.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":2.449489742783178},"58":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":14,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":2.23606797749979},"2":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"43":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"6":{"tf":2.8284271247461903},"7":{"tf":1.0},"8":{"tf":3.1622776601683795},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}},"t":{"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.0},"3":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"2":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}},"x":{"df":2,"docs":{"19":{"tf":1.0},"43":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":3,"docs":{"13":{"tf":1.0},"26":{"tf":1.0},"49":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"13":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"13":{"tf":1.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"37":{"tf":1.7320508075688772},"58":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"15":{"tf":1.0}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"1":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"15":{"tf":5.385164807134504},"16":{"tf":3.3166247903554},"17":{"tf":3.0},"19":{"tf":2.6457513110645907},"2":{"tf":2.0},"3":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"4":{"tf":2.23606797749979}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"26":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951},"58":{"tf":1.0},"8":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"43":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"26":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"22":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"2":{"tf":1.0}}}},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":5,"docs":{"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"40":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":4,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.0},"55":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":13,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"31":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"i":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"34":{"tf":1.4142135623730951},"5":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"o":{"df":1,"docs":{"15":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"52":{"tf":1.0},"58":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"(":{"a":{".":{"df":0,"docs":{},"x":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"34":{"tf":1.0},"37":{"tf":1.0},"46":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"43":{"tf":1.0},"49":{"tf":1.0}}}},"y":{"df":0,"docs":{},"n":{"df":4,"docs":{"24":{"tf":1.0},"26":{"tf":2.6457513110645907},"55":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"3":{"tf":1.7320508075688772}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":21,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":3.0},"10":{"tf":2.23606797749979},"13":{"tf":1.0},"2":{"tf":3.1622776601683795},"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"3":{"tf":3.0},"34":{"tf":1.7320508075688772},"4":{"tf":2.449489742783178},"40":{"tf":1.0},"43":{"tf":2.6457513110645907},"46":{"tf":1.4142135623730951},"5":{"tf":2.6457513110645907},"52":{"tf":2.0},"55":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":2.6457513110645907},"7":{"tf":2.8284271247461903},"8":{"tf":3.0},"9":{"tf":2.23606797749979}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":1,"docs":{"43":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"58":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"46":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"3":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":9,"docs":{"19":{"tf":1.0},"30":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":8,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"34":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.0},"37":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"22":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":2.0},"4":{"tf":1.0},"46":{"tf":1.7320508075688772},"5":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"37":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"1":{"tf":1.0},"37":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"34":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"5":{"tf":1.0},"8":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"15":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"=":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":3.7416573867739413},"16":{"tf":1.7320508075688772},"17":{"tf":2.23606797749979},"19":{"tf":2.23606797749979}}}}}}}},"f":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.0},"5":{"tf":1.0}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":2,"docs":{"15":{"tf":1.7320508075688772},"52":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":15,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":2.0},"49":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":3,"docs":{"13":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"33":{"tf":1.0},"46":{"tf":2.6457513110645907}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}},"x":{"df":4,"docs":{"15":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":3.0},"8":{"tf":4.242640687119285}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"n":{"df":8,"docs":{"15":{"tf":1.4142135623730951},"17":{"tf":2.0},"19":{"tf":2.449489742783178},"22":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"12":{"tf":1.0},"15":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"o":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":4,"docs":{"22":{"tf":1.4142135623730951},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":2.23606797749979}}}},"/":{"b":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},":":{":":{"b":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"19":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"\\":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":11,"docs":{"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":2.23606797749979},"19":{"tf":1.7320508075688772},"22":{"tf":1.4142135623730951},"4":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772}}},"r":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}},"t":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"49":{"tf":2.449489742783178},"52":{"tf":1.0}}}},"df":1,"docs":{"33":{"tf":1.0}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"19":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"1":{"df":1,"docs":{"26":{"tf":1.0}}},"2":{"df":1,"docs":{"26":{"tf":1.0}}},"df":4,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772},"22":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"1":{"tf":1.0},"15":{"tf":2.0},"19":{"tf":1.0},"52":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"2":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"3":{"tf":1.0}},"n":{"df":2,"docs":{"15":{"tf":1.0},"22":{"tf":1.0}}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":1,"docs":{"13":{"tf":1.0}}},"u":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"6":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"49":{"tf":1.0},"52":{"tf":1.4142135623730951}},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"15":{"tf":1.0},"37":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"r":{"d":{"df":3,"docs":{"3":{"tf":1.0},"30":{"tf":1.0},"55":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"52":{"tf":1.0}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"p":{"df":2,"docs":{"6":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"n":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}}},"df":3,"docs":{"15":{"tf":1.0},"26":{"tf":1.0},"8":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"i":{"3":{"2":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"49":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"3":{"tf":1.0},"52":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":2.0}}}},"df":1,"docs":{"8":{"tf":3.1622776601683795}}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"43":{"tf":2.8284271247461903}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"43":{"tf":1.0}}}}}}},"df":2,"docs":{"2":{"tf":1.0},"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":2.8284271247461903},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"37":{"tf":1.7320508075688772}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"17":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0}}}},"o":{"df":2,"docs":{"10":{"tf":1.0},"34":{"tf":1.0}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"52":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"46":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"n":{"c":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":4,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"2":{"tf":1.0}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}}},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"[":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":3,"docs":{"41":{"tf":1.7320508075688772},"42":{"tf":1.0},"43":{"tf":1.7320508075688772}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"6":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":5,"docs":{"28":{"tf":1.0},"31":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"'":{"df":9,"docs":{"13":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951}}},"r":{".":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"(":{"[":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"43":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}}}}},"k":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"6":{"tf":1.0}}}},"y":{"/":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":13,"docs":{"1":{"tf":2.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":2.23606797749979},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.0},"5":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"8":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"19":{"tf":1.0},"3":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}},"r":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}}},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"t":{"'":{"df":3,"docs":{"14":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"15":{"tf":1.0},"37":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"19":{"tf":1.0}}},"t":{"df":3,"docs":{"30":{"tf":1.0},"55":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"52":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.7320508075688772},"40":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"55":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"49":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":8,"docs":{"15":{"tf":2.0},"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":2.6457513110645907},"52":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":2.23606797749979}}}}},"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"1":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"58":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":10,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"49":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":2.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"8":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"3":{"tf":1.0},"37":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"58":{"tf":2.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":6,"docs":{"1":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.4142135623730951},"52":{"tf":1.7320508075688772},"58":{"tf":1.0},"8":{"tf":1.0}},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"1":{"tf":1.0},"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":6,"docs":{"22":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":2.449489742783178},"46":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"11":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"43":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"43":{"tf":1.0}}}}},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":2.23606797749979}}}},"df":4,"docs":{"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"19":{"tf":2.0}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"19":{"tf":2.449489742783178},"37":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":11,"docs":{"13":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0},"49":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"19":{"tf":1.0},"46":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"26":{"tf":1.0},"43":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"26":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"y":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":17,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":2.0},"19":{"tf":2.23606797749979},"22":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":2.0},"49":{"tf":1.7320508075688772},"52":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}}}},"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{";":{"&":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":7,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":3.0},"19":{"tf":1.0},"26":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"w":{"df":23,"docs":{"1":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":2.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"40":{"tf":1.4142135623730951},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"5":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":2.23606797749979},"7":{"tf":2.8284271247461903},"8":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.0}}}}}}}},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"49":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"34":{"tf":1.0},"8":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"49":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"30":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.4142135623730951}},"—":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"26":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"k":{"df":3,"docs":{"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.7320508075688772}}},"l":{"d":{"df":2,"docs":{"26":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"15":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":3,"docs":{"1":{"tf":1.0},"49":{"tf":1.0},"7":{"tf":1.0}}},"df":12,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}},"t":{"df":3,"docs":{"1":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"46":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"2":{"tf":1.0},"8":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":5,"docs":{"1":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.4142135623730951},"8":{"tf":1.0}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"33":{"tf":1.0},"4":{"tf":2.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"1":{"2":{"3":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}},"df":3,"docs":{"47":{"tf":1.7320508075688772},"48":{"tf":1.0},"49":{"tf":3.605551275463989}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772},"5":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"3":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"58":{"tf":2.0}},"h":{"df":10,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":2.449489742783178},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":3.7416573867739413},"33":{"tf":1.7320508075688772}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"21":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":2.8284271247461903}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"34":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"df":1,"docs":{"1":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"29":{"tf":1.7320508075688772},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"43":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"#":{"1":{"2":{"3":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"'":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"16":{"tf":1.4142135623730951},"52":{"tf":2.6457513110645907}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":4,"docs":{"15":{"tf":1.0},"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":2.6457513110645907}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}},"s":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}}}}},"a":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"46":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"34":{"tf":1.0},"37":{"tf":1.0},"8":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":7,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}}}}},"c":{"_":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":9,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"34":{"tf":1.0},"4":{"tf":2.23606797749979},"5":{"tf":2.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":3,"docs":{"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"3":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":2,"docs":{"19":{"tf":1.7320508075688772},"37":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"r":{"#":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"55":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}},"w":{"df":4,"docs":{"29":{"tf":1.7320508075688772},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0}}}},"df":1,"docs":{"52":{"tf":1.0}},"e":{"a":{"d":{"df":2,"docs":{"13":{"tf":1.0},"34":{"tf":1.0}},"i":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"37":{"tf":1.0},"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"15":{"tf":1.0},"6":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":2.6457513110645907},"3":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.7320508075688772},"58":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"19":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":7,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.7320508075688772},"15":{"tf":1.0},"27":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":2.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"55":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"15":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":6,"docs":{"24":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":4,"docs":{"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":2.23606797749979},"43":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}}},"f":{"c":{"df":4,"docs":{"10":{"tf":1.0},"22":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":7,"docs":{"1":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"2":{"tf":1.0},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.0}}}},"n":{"df":3,"docs":{"34":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"0":{"tf":1.0},"49":{"tf":1.0}}},"c":{"df":2,"docs":{"15":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"df":59,"docs":{"0":{"tf":1.0},"1":{"tf":2.449489742783178},"10":{"tf":2.23606797749979},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":2.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":2.23606797749979},"19":{"tf":3.1622776601683795},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":3.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":2.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":2.449489742783178},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"5":{"tf":2.449489742783178},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":2.23606797749979},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":3.605551275463989}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":1.0},"37":{"tf":1.0},"8":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"6":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":7,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0},"52":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}},"k":{"df":1,"docs":{"6":{"tf":1.0}}},"m":{"df":3,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"43":{"tf":1.0}}}},"l":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"12":{"tf":1.0},"19":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"t":{"df":3,"docs":{"33":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0}},"i":{"df":2,"docs":{"43":{"tf":1.0},"58":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"19":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"58":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"15":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}},"x":{"df":1,"docs":{"34":{"tf":1.0}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"37":{"tf":1.0},"43":{"tf":1.4142135623730951}}}},"v":{"df":1,"docs":{"1":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"(":{"1":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}},"2":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":2.449489742783178}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"15":{"tf":1.0},"49":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":1,"docs":{"52":{"tf":1.0}},"i":{"df":3,"docs":{"33":{"tf":1.0},"58":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"{":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"}":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"49":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"l":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"27":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"15":{"tf":1.0},"37":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":9,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"19":{"tf":2.0},"40":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0}}}}},"d":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"a":{"df":0,"docs":{},"r":{"c":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"5":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":2,"docs":{"15":{"tf":1.0},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"1":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"15":{"tf":1.0},"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"49":{"tf":2.449489742783178},"52":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.7320508075688772},"37":{"tf":1.0},"46":{"tf":2.449489742783178}}}},"df":0,"docs":{}}}},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"18":{"tf":2.23606797749979},"19":{"tf":2.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.0},"49":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"h":{"df":8,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":14,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"21":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"12":{"tf":1.0},"19":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"15":{"tf":1.7320508075688772},"40":{"tf":1.0},"5":{"tf":1.0},"58":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":8,"docs":{"26":{"tf":1.4142135623730951},"3":{"tf":1.0},"43":{"tf":1.7320508075688772},"5":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"52":{"tf":1.7320508075688772},"55":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":11,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":1,"docs":{"18":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":2.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"34":{"tf":1.0},"5":{"tf":1.0}}}},"t":{"'":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"26":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":5,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}}},"y":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":7,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"19":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"15":{"tf":1.0},"52":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"43":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"3":{"tf":2.0}}}},"p":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":10,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":2.0},"26":{"tf":5.0990195135927845},"37":{"tf":1.4142135623730951},"43":{"tf":2.449489742783178},"5":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"5":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":5,"docs":{"24":{"tf":1.0},"28":{"tf":2.0},"3":{"tf":1.0},"46":{"tf":1.0},"5":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"14":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"52":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":4,"docs":{"15":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"43":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"u":{"8":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"2":{"tf":1.0},"27":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"16":{"tf":1.0},"37":{"tf":1.0}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"15":{"tf":1.4142135623730951}}}}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"19":{"tf":1.0},"43":{"tf":1.4142135623730951},"6":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}},"u":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"6":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":21,"docs":{"1":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":4.123105625617661},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":4.0},"21":{"tf":1.0},"26":{"tf":2.0},"28":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":2.0},"4":{"tf":1.4142135623730951},"46":{"tf":2.0},"49":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"55":{"tf":1.0},"58":{"tf":1.7320508075688772},"6":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":2.23606797749979},"43":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"1":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"2":{"(":{"df":1,"docs":{"19":{"tf":1.7320508075688772}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"1":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"58":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"9":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":9,"docs":{"1":{"tf":1.7320508075688772},"10":{"tf":1.0},"11":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"23":{"tf":1.0},"34":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"a":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"6":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}}},"y":{"df":10,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"37":{"tf":1.4142135623730951},"40":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":2,"docs":{"43":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"v":{"df":3,"docs":{"52":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}}},"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.0}}}},"l":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.0},"34":{"tf":1.0},"49":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}},"—":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"2":{"tf":1.0},"46":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":9,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":2.0},"34":{"tf":1.0},"43":{"tf":1.4142135623730951},"49":{"tf":1.0},"8":{"tf":1.4142135623730951}}},"l":{"d":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"'":{"df":0,"docs":{},"v":{"df":2,"docs":{"1":{"tf":1.0},"52":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"15":{"tf":1.0},"28":{"tf":1.0},"40":{"tf":1.0},"5":{"tf":1.0},"52":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"x":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":2.0}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":4,"docs":{"15":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"r":{"df":2,"docs":{"15":{"tf":1.0},"7":{"tf":1.0}}},"v":{"df":1,"docs":{"15":{"tf":1.0}}}},"@":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"7":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"z":{"df":1,"docs":{"52":{"tf":1.0}}}}},"title":{"root":{"2":{"0":{"1":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"8":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"2":{"1":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":2,"docs":{"32":{"tf":1.0},"38":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"11":{"tf":1.0},"32":{"tf":1.0}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"6":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":11,"docs":{"14":{"tf":1.0},"22":{"tf":1.0},"31":{"tf":1.0},"37":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"52":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"7":{"tf":1.0}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"16":{"tf":1.0},"23":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"47":{"tf":1.0},"56":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"13":{"tf":1.0},"25":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":6,"docs":{"23":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"56":{"tf":1.0}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"50":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"56":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"34":{"tf":1.0},"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0}}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"20":{"tf":1.0},"26":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});