/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import javax.swing.JFileChooser;
import org.fibs.geotag.util.JavaFileFilter;

public final class MissingLicenseFinder {
    private static boolean OVERWRITE = true;
    private static int filesChecked = 0;
    private static int filesFailed = 0;
    private static int filesCorrected = 0;
    private static final int YEAR = new GregorianCalendar().get(1);
    private static final String[] CORRECT_LINES = new String[]{"/**", " * Geotag", " * Copyright (C) 2007-" + YEAR + " Andreas Schneider", " *", " * This program is free software; you can redistribute it and/or", " * modify it under the terms of the GNU General Public License", " * as published by the Free Software Foundation; either version 2", " * of the License, or (at your option) any later version.", " *", " * This program is distributed in the hope that it will be useful,", " * but WITHOUT ANY WARRANTY; without even the implied warranty of", " * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the", " * GNU General Public License for more details.", " *", " * You should have received a copy of the GNU General Public License", " * along with this program.  If not, see <http://www.gnu.org/licenses/>.", " */"};

    private MissingLicenseFinder() {
    }

    public static void main(String[] args) {
        if (args.length == 1 && "OVERWRITE".equals(args[0])) {
            OVERWRITE = true;
        }
        JFileChooser chooser = new JFileChooser();
        String rootDirectoryName = System.getProperty("user.dir");
        File rootDirectory = new File(rootDirectoryName = String.valueOf(rootDirectoryName) + "/src/org/fibs");
        if (rootDirectory.exists() && rootDirectory.isDirectory()) {
            chooser.setSelectedFile(rootDirectory);
        }
        System.out.println(rootDirectoryName);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(null) == 0) {
            File directory = chooser.getSelectedFile();
            MissingLicenseFinder.processDirectory(directory);
            System.out.println("Failures: " + filesFailed + "/" + filesChecked);
            System.out.println("Corrected: " + filesCorrected + "/" + filesFailed);
            if (filesFailed > 0 && filesCorrected != filesFailed) {
                System.out.println("To fix all failed files re-run with OVERWRITE set to true");
            } else {
                System.out.println("All is well");
            }
        }
    }

    private static void processDirectory(File directory) {
        File[] files = directory.listFiles(new JavaFileFilter());
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                MissingLicenseFinder.processDirectory(file);
            } else {
                try {
                    MissingLicenseFinder.processFile(file);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            ++i;
        }
    }

    private static void processFile(File file) throws IOException {
        BufferedWriter tempFileWriter;
        block21: {
            boolean failed = false;
            File tempFile = File.createTempFile(file.getName(), null);
            tempFile.deleteOnExit();
            tempFileWriter = new BufferedWriter(new FileWriter(tempFile));
            ++filesChecked;
            BufferedReader bufferedReader = null;
            String lineFromFile = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    int i = 0;
                    while (i < CORRECT_LINES.length) {
                        tempFileWriter.write(CORRECT_LINES[i]);
                        tempFileWriter.newLine();
                        lineFromFile = bufferedReader.readLine();
                        if (!CORRECT_LINES[i].equals(lineFromFile)) {
                            ++filesFailed;
                            if (!failed) {
                                System.out.println(String.valueOf(file.getName()) + " line " + (i + 1) + " != '" + CORRECT_LINES[i] + '\'');
                            }
                            failed = true;
                        }
                        ++i;
                    }
                    while ((lineFromFile = bufferedReader.readLine()) != null) {
                        tempFileWriter.write(lineFromFile);
                        tempFileWriter.newLine();
                    }
                    bufferedReader.close();
                    bufferedReader = null;
                    tempFileWriter.close();
                    if (failed && OVERWRITE) {
                        MissingLicenseFinder.overwrite(tempFile, file);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block21;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            tempFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void overwrite(File from, File to) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(from));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(to));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            bufferedReader.close();
            bufferedWriter.close();
            ++filesCorrected;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

