/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import tim.prune.I18nManager;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.SiteNameUtils;

public class OsmMapSource
extends MapSource {
    private String _name = null;
    private String[] _baseUrls = null;
    private String[] _siteNames = null;
    private int _maxZoom = 0;
    private String _apiKey = null;

    public OsmMapSource(String string, String string2) {
        this(string, string2, "png", null, null, 18);
    }

    public OsmMapSource(String string, String string2, String string3, int n) {
        if (string3 != null && string3.length() == 3) {
            this.init(string, string2, string3, null, null, n);
        } else {
            this.init(string, string2, "png", string3, "png", n);
        }
    }

    public OsmMapSource(String string, String string2, String string3, String string4, String string5, int n) {
        this.init(string, string2, string3, string4, string5, n);
    }

    private void init(String string, String string2, String string3, String string4, String string5, int n) {
        this._name = string;
        if (this._name == null || this._name.trim().equals("")) {
            this._name = I18nManager.getText("mapsource.unknown");
        }
        this._baseUrls = new String[2];
        this._baseUrls[0] = OsmMapSource.fixBaseUrl(string2);
        this._baseUrls[1] = OsmMapSource.fixBaseUrl(string4);
        this._extensions = new String[2];
        this._extensions[0] = string3;
        this._extensions[1] = string5;
        this._siteNames = new String[2];
        this._siteNames[0] = SiteNameUtils.convertUrlToDirectory(this._baseUrls[0]);
        this._siteNames[1] = SiteNameUtils.convertUrlToDirectory(this._baseUrls[1]);
        if (this._baseUrls[0] == null && this._baseUrls[1] != null) {
            this._baseUrls[0] = this._baseUrls[1];
            this._siteNames[0] = this._siteNames[1];
            this._siteNames[1] = null;
            this._baseUrls[1] = null;
        }
        this._maxZoom = n;
    }

    public void setApiKey(String string) {
        this._apiKey = string;
    }

    public static OsmMapSource fromConfig(String string) {
        OsmMapSource osmMapSource = null;
        if (string.startsWith("o:")) {
            String[] stringArray = string.substring(2).split(";");
            try {
                if (stringArray.length == 3) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], null, Integer.parseInt(stringArray[2]));
                } else if (stringArray.length == 4) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], stringArray[2], Integer.parseInt(stringArray[3]));
                } else if (stringArray.length == 6) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], Integer.parseInt(stringArray[5]));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return osmMapSource;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getNumLayers() {
        return this._baseUrls[1] == null ? 1 : 2;
    }

    @Override
    public String getBaseUrl(int n) {
        return this._baseUrls[n];
    }

    @Override
    public String getSiteName(int n) {
        return this._siteNames[n];
    }

    @Override
    public String makeURL(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SiteNameUtils.pickServerUrl(this._baseUrls[n]));
        stringBuffer.append(n2).append('/').append(n3).append('/').append(n4);
        stringBuffer.append('.').append(this.getFileExtension(n));
        if (this._apiKey != null) {
            stringBuffer.append("?apikey=").append(this._apiKey);
        }
        return stringBuffer.toString();
    }

    @Override
    public final int getMaxZoomLevel() {
        return this._maxZoom;
    }

    @Override
    public String getConfigString() {
        return "o:" + this.getName() + ";" + this.getSiteStrings() + this.getMaxZoomLevel();
    }
}

