/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.history;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mediathek.config.StandardLocations;
import mediathek.controller.history.MVUsedUrl;
import mediathek.gui.messages.history.AboHistoryChangedEvent;
import mediathek.tool.FileUtils;
import mediathek.tool.MessageBus;
import okhttp3.HttpUrl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AboHistoryController {
    private static final String FILENAME = "downloadAbos.txt";
    private static final Logger logger = LogManager.getLogger(AboHistoryController.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private final Set<String> listeUrls = Collections.synchronizedSet(new HashSet());
    private final List<MVUsedUrl> listeUrlsSortDate = Collections.synchronizedList(new LinkedList());
    private Path urlPath;

    public AboHistoryController() {
        Path settingsDir = StandardLocations.getSettingsDirectory();
        try {
            this.urlPath = settingsDir.resolve(FILENAME);
        }
        catch (InvalidPathException e) {
            logger.error("Path resolve failed for {},{}", (Object)settingsDir, (Object)FILENAME);
            this.urlPath = null;
        }
        this.listeBauen();
    }

    public List<MVUsedUrl> getListeUrlsSortDate() {
        return this.listeUrlsSortDate;
    }

    private void sendChangeMessage() {
        MessageBus.getMessageBus().publishAsync(new AboHistoryChangedEvent());
    }

    public synchronized void removeAll() {
        this.listeUrls.clear();
        this.listeUrlsSortDate.clear();
        try {
            FileUtils.moveToTrash(this.urlPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sendChangeMessage();
    }

    public boolean urlPruefen(String urlFilm) {
        return this.listeUrls.contains(urlFilm);
    }

    public synchronized void urlAusLogfileLoeschen(String urlFilm) {
        boolean gefunden = false;
        this.checkUrlFilePath();
        ArrayList<String> liste = new ArrayList<String>();
        try (InputStream is = Files.newInputStream(this.urlPath, new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(is);
             LineNumberReader in = new LineNumberReader(isr);){
            String zeile;
            while ((zeile = in.readLine()) != null) {
                if (MVUsedUrl.getUrlAusZeile(zeile).getUrl().equals(urlFilm)) {
                    gefunden = true;
                    continue;
                }
                liste.add(zeile);
            }
        }
        catch (Exception ex) {
            logger.error("urlAusLogfileLoeschen(String)", (Throwable)ex);
        }
        if (gefunden) {
            try (OutputStream os = Files.newOutputStream(this.urlPath, new OpenOption[0]);
                 OutputStreamWriter osw = new OutputStreamWriter(os);
                 BufferedWriter bufferedWriter = new BufferedWriter(osw);){
                for (String entry : liste) {
                    bufferedWriter.write(entry + "\n");
                }
            }
            catch (Exception ex) {
                logger.error("urlAusLogfileLoeschen(String)", (Throwable)ex);
            }
        }
        this.listeUrls.clear();
        this.listeUrlsSortDate.clear();
        this.listeBauen();
        this.sendChangeMessage();
    }

    public synchronized void zeileSchreiben(String thema, String titel, String url) {
        String datum = DATE_TIME_FORMATTER.format(LocalDate.now());
        this.listeUrls.add(url);
        this.listeUrlsSortDate.add(new MVUsedUrl(datum, thema, titel, url));
        this.checkUrlFilePath();
        try (OutputStream os = Files.newOutputStream(this.urlPath, StandardOpenOption.APPEND);
             OutputStreamWriter osw = new OutputStreamWriter(os);
             BufferedWriter bufferedWriter = new BufferedWriter(osw);){
            MVUsedUrl usedUrl = new MVUsedUrl(datum, thema, titel, url);
            bufferedWriter.write(usedUrl.getUsedUrl());
        }
        catch (Exception ex) {
            logger.error("zeileSchreiben(...)", (Throwable)ex);
        }
        this.sendChangeMessage();
    }

    public synchronized void createLineWriterThread(LinkedList<MVUsedUrl> mvuuList) {
        LineWriterThread t = new LineWriterThread(mvuuList);
        t.start();
    }

    private void checkUrlFilePath() {
        try {
            if (Files.notExists(this.urlPath, new LinkOption[0])) {
                Files.createFile(this.urlPath, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            logger.error("checkUrlFilePath()", (Throwable)ex);
        }
    }

    private void listeBauen() {
        this.checkUrlFilePath();
        ArrayList<String> badEntriesList = new ArrayList<String>();
        try (InputStream is = Files.newInputStream(this.urlPath, new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(is);
             LineNumberReader in = new LineNumberReader(isr);){
            String zeile;
            while ((zeile = in.readLine()) != null) {
                MVUsedUrl mvuu = MVUsedUrl.getUrlAusZeile(zeile);
                String url = mvuu.getUrl();
                if (url.startsWith("rtmp:")) {
                    badEntriesList.add(zeile);
                    continue;
                }
                HttpUrl okHttpUrl = HttpUrl.parse(url);
                if (okHttpUrl == null) {
                    badEntriesList.add(zeile);
                    continue;
                }
                this.listeUrls.add(url);
                this.listeUrlsSortDate.add(mvuu);
            }
        }
        catch (Exception ex) {
            logger.error("listeBauen()", (Throwable)ex);
        }
        if (!badEntriesList.isEmpty()) {
            logger.warn("File {} contains {} invalid entries ", (Object)this.urlPath, (Object)badEntriesList.size());
            this.removeIllegalEntries(badEntriesList);
            badEntriesList.clear();
        }
        logger.debug("listeUrls size: {} for file {}", (Object)this.listeUrls.size(), (Object)this.urlPath);
        logger.debug("listeUrlsSortDate size: {} for file {}", (Object)this.listeUrlsSortDate.size(), (Object)this.urlPath);
    }

    private void removeIllegalEntries(List<String> badEntriesList) {
        logger.trace("Cleaning entries for {}", (Object)this.urlPath);
        ArrayList<String> cleanedEntriesList = new ArrayList<String>();
        try (InputStream is = Files.newInputStream(this.urlPath, new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(is);
             LineNumberReader in = new LineNumberReader(isr);){
            String zeile;
            while ((zeile = in.readLine()) != null) {
                if (badEntriesList.contains(zeile)) continue;
                cleanedEntriesList.add(zeile);
            }
        }
        catch (Exception ex) {
            logger.error("removeIllegalEntries()", (Throwable)ex);
        }
        try (OutputStream os = Files.newOutputStream(this.urlPath, new OpenOption[0]);
             OutputStreamWriter osw = new OutputStreamWriter(os);
             BufferedWriter bufferedWriter = new BufferedWriter(osw);){
            for (String entry : cleanedEntriesList) {
                bufferedWriter.write(entry + "\n");
            }
        }
        catch (Exception ex) {
            logger.error("removeIllegalEntries()", (Throwable)ex);
        }
        cleanedEntriesList.clear();
        logger.trace("Finished cleaning entries for {}", (Object)this.urlPath);
    }

    class LineWriterThread
    extends Thread {
        private final List<MVUsedUrl> mvuuList;

        public LineWriterThread(List<MVUsedUrl> mvuuList) {
            this.mvuuList = mvuuList;
            this.setName(LineWriterThread.class.getName());
        }

        @Override
        public void run() {
            this.zeilenSchreiben();
        }

        private void zeilenSchreiben() {
            AboHistoryController.this.checkUrlFilePath();
            try (OutputStream os = Files.newOutputStream(AboHistoryController.this.urlPath, StandardOpenOption.APPEND);
                 OutputStreamWriter osw = new OutputStreamWriter(os);
                 BufferedWriter bufferedWriter = new BufferedWriter(osw);){
                for (MVUsedUrl mvuu : this.mvuuList) {
                    AboHistoryController.this.listeUrls.add(mvuu.getUrl());
                    AboHistoryController.this.listeUrlsSortDate.add(mvuu);
                    bufferedWriter.write(mvuu.getUsedUrl());
                }
            }
            catch (Exception ex) {
                logger.error("zeilenSchreiben()", (Throwable)ex);
            }
            AboHistoryController.this.sendChangeMessage();
        }
    }
}

