/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapMode;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import tests.freemind.FreeMindMainMock;

public class IndependantMapViewCreator {
    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        if (args.length != 2) {
            System.out.println("Export map to png.\nUsage:\n java -jar lib/freemind.jar freemind.view.mindmapview.IndependantMapViewCreator <map_path>.mm <picture_path>.png");
            System.exit(0);
        }
        FreeMindMainMock freeMindMain = new FreeMindMainMock();
        IndependantMapViewCreator creator = new IndependantMapViewCreator();
        try {
            String outputFileName = args[1];
            creator.exportFileToPng(args[0], outputFileName, freeMindMain);
            System.out.println("Export to " + outputFileName + " done.");
            System.exit(0);
        }
        catch (FileNotFoundException e) {
            Resources.getInstance().logException(e);
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
        catch (URISyntaxException e) {
            Resources.getInstance().logException(e);
        }
        System.err.println("Error.");
        System.exit(1);
    }

    public MapView createMapViewForFile(String inputFileName, JPanel parent, FreeMindMain pFreeMindMain) throws FileNotFoundException, IOException, URISyntaxException {
        Controller controller = new Controller(pFreeMindMain);
        controller.initialization();
        MindMapMode mode = new MindMapMode(){

            @Override
            public ModeController createModeController() {
                return new MindMapController(this){

                    @Override
                    protected void init() {
                    }
                };
            }
        };
        mode.init(controller);
        MindMapController mc = (MindMapController)mode.createModeController();
        MindMapMapModel model = new MindMapMapModel(pFreeMindMain, mc);
        mc.setModel(model);
        model.load(new File(inputFileName));
        MapView mapView = this.createMapView(controller, model);
        parent.add((Component)mapView, "Center");
        mc.setView(mapView);
        mapView.setBounds(parent.getBounds());
        Tools.waitForEventQueue();
        mapView.addNotify();
        return mapView;
    }

    public void exportFileToPng(String inputFileName, String outputFileName, FreeMindMain pFreeMindMain) throws FileNotFoundException, IOException, URISyntaxException {
        JPanel parent = new JPanel();
        Rectangle bounds = new Rectangle(0, 0, 400, 600);
        parent.setBounds(bounds);
        MapView mapView = this.createMapViewForFile(inputFileName, parent, pFreeMindMain);
        mapView.getRoot().getMainView().doLayout();
        parent.setOpaque(true);
        parent.setDoubleBuffered(false);
        parent.doLayout();
        parent.validate();
        mapView.preparePrinting();
        Rectangle dim = mapView.getBounds();
        Rectangle dimI = mapView.getInnerBounds();
        parent.setBounds(dim);
        BufferedImage backBuffer = new BufferedImage(dim.width, dim.height, 2);
        Graphics2D g = backBuffer.createGraphics();
        ((Graphics)g).translate(-dim.x, -dim.y);
        g.clipRect(dim.x, dim.y, dim.width, dim.height);
        parent.print(g);
        backBuffer = backBuffer.getSubimage(dimI.x, dimI.y, dimI.width, dimI.height);
        FileOutputStream out1 = new FileOutputStream(outputFileName);
        ImageIO.write((RenderedImage)backBuffer, "png", out1);
        out1.close();
    }

    protected MapView createMapView(Controller controller, MindMapMapModel model) {
        MapView mapView = new MapView(model, controller){

            @Override
            DragGestureListener getNodeDragListener() {
                return null;
            }

            @Override
            DropTargetListener getNodeDropListener() {
                return null;
            }

            public void selectAsTheOnlyOneSelected(NodeView pNewSelected, boolean pRequestFocus) {
            }
        };
        return mapView;
    }
}

