# Test file by Wilf A. Wilson
#
gap> START_TEST("small-7-8-9.tst");

#
gap> type14 := [1536];;
gap> List(type14, NrSmallGroups);
[ 408641062 ]
gap> CodePcGroup(SmallGroup(1536, 1));
1117751710557260061763679300396937275243521
gap> CodePcGroup(SmallGroup(1536, NrSmallGroups(1536)));
6368966309566407273379632747023443871927727076481509622016
gap> for n in [1 .. 37] do
>   i := n * 11044353;
>   code := CodePcGroup(SmallGroup(1536, i));
>   Print(code, "\n");
> od;
11551449001802472944300510972540160019565801548680559087678979109889
3183443522745264358420017266718971358818328293114969094145
4962940782728998159520020676950178228923844126292605287300097
32363470428952159826961458933875785881666741962552321
7510758740954438006210351907096404195722596421333777379355032577
11536525352984193880881987849350344916598078767783667918315229576193
7510758765800803504682757522810342212936961131190082945588689921
76355006334409035768481767460923714330731952512025457357825
276873798683034370422686354986618574070368146198552604637389299153921
17720102942145535040821546508179788834849233830569992924733407019693057
180256379350966197509413380579564714649100368948626359506257345537
4889816888636944893466912296444781534692621229413173552512001
7510685569422629945781975288485102731273919813123116890003635201
76427482340207828124444014504994951691901525166423969123329
17720103113102888450082547763539417850534707056867060928720530115689473
11536525464259692985567491932658598756923456933014206223303740783617
7623188365428778822933304300817690957936273784651867935460572161
4905680217055126015930630721537172898878993487541759339211777
41806596448886054564023323820436589223636267006667861135951691075402539301889
27253252837435117881714299532357678858841383848546986009834502673072225281
3200013144652636574931424019282474748385446418713601965057
7520458693329618581399164363698473710656933773170849671743596545
11551424568850799598898901590435671578419368292527592808287483524097
31088307546614295314433516418272031969481287184877667329
2091432537469156563228151577512566931550081679936210945
27465730573893309893623935048225713317948871781879530664538657841848318977
27217813059420401470912975800772792887924027406863686687161806268353018881
41806808776784277964045266210839035664603367724997705501989785711073822309377
17720035458322820383457693396603043247190334014755023515922972425114625
7579113658498030081779078282864768323703831867026353014846315521
27465891978549561122260299034659643160700134471208638300227739885841734657
27217974358927115863615735235546096218357844030669227039752984318399020033
17881334940648800637160348716980772428763369656436580643974297545141249
41806808615379602121934347147222018680352028706385721793251984661233838644225
173046150413678224156618287761222731966691600576738994804860357499905
27571980937268161608085014850565258349826324472283347015938574888564481025
2634249416323345597468107839036164922019464872192

#
gap> type18 := [512];;
gap> List(type18, NrSmallGroups);
[ 10494213 ]
gap> G := SmallGroup(512, 1);
<pc group of size 512 with 9 generators>
gap> code := CodePcGroup(G);
162895587718739690298008513020159
gap> StructureDescription(G);
"C512"
gap> G := SmallGroup(512, NrSmallGroups(512));
<pc group of size 512 with 9 generators>
gap> code := CodePcGroup(G);
0
gap> H := Range(IsomorphismPermGroup(PcGroupCode(code, 512)));
<permutation group of size 512 with 9 generators>
gap> IsomorphismGroups(G, H) <> fail;
true
gap> for i in [552327, 2 * 552327 .. NrSmallGroups(512)] do
>   code := CodePcGroup(SmallGroup(1536, i));
>   Print(code, "\n");
> od;
32367859883513293615942509868015297679255666981108737
32383651639511992821507513360025040966068253845124097
76402627863876584977521850055527102431842474573831196933121
49757470207699687065039961335428701638866376840390933505
76402627863876584977521849439248495763183260829912646843393
49741315251598569993297040744927201509303166487110368257
117354461293822942192132531768762919480419876229759305806019585
49741294182209085752131419118216362790772819534068348929
76427482340207829984212520914039281203197759663593890536449
32394189760174011857924531174056438176773868447345665
117392612878604550922698078920829941001808666978750172510059521
34609238884316513320199497036244528940119983359226451599478635516929
22561395211693669457397941773901310367217685012382516549095357441
6217665724573057331722400549163910117186640469544193025
73346538286389398087286297139409133619299224603799541473926145
31088315457923045622728145272326224914131861071319312385
73346538286392030043830489168328461310319998517704846355231745
112660254175571760521488298552334293911324184770960072071406220289
1

#
gap> type19 := [14641, 28561, 83521, 130321, 279841, 707281, 923521];;
gap> List(type19, NrSmallGroups);
[ 15, 15, 15, 15, 15, 15, 15 ]
gap> AllSmallGroups(type19);;
gap> for size in type19 do
>   for i in [1 .. 15] do
>     code := CodePcGroup(SmallGroup(size, i));
>     if not IdSmallGroup(PcGroupCode(code, size)) = [size, i] then
>       Print("fail!\n");
>     fi;
>   od;
> od;

#
gap> type20 := [16807, 161051, 371293];;
gap> List(type20, NrSmallGroups);
[ 83, 87, 97 ]
gap> AllSmallGroups(Size, type20, IsAbelian, true);
[ <pc group of size 16807 with 5 generators>, 
  <pc group of size 16807 with 5 generators>, 
  <pc group of size 16807 with 5 generators>, 
  <pc group of size 16807 with 5 generators>, 
  <pc group of size 16807 with 5 generators>, 
  <pc group of size 16807 with 5 generators>, 
  <pc group of size 16807 with 5 generators>, 
  <pc group of size 161051 with 5 generators>, 
  <pc group of size 161051 with 5 generators>, 
  <pc group of size 161051 with 5 generators>, 
  <pc group of size 161051 with 5 generators>, 
  <pc group of size 161051 with 5 generators>, 
  <pc group of size 161051 with 5 generators>, 
  <pc group of size 161051 with 5 generators>, 
  <pc group of size 371293 with 5 generators>, 
  <pc group of size 371293 with 5 generators>, 
  <pc group of size 371293 with 5 generators>, 
  <pc group of size 371293 with 5 generators>, 
  <pc group of size 371293 with 5 generators>, 
  <pc group of size 371293 with 5 generators>, 
  <pc group of size 371293 with 5 generators> ]

# We avoid viewing the cyclic groups to avoid the grammatically incorrect output
# '1 generators' given by older versions of GAP
gap> type21 := [15625, 117649];;
gap> List(type21, NrSmallGroups);
[ 684, 860 ]
gap> AllSmallGroups(Size, type21, x -> IsAbelian(x) and not IsCyclic(x));
[ <pc group of size 15625 with 2 generators>, 
  <pc group of size 15625 with 2 generators>, 
  <pc group of size 15625 with 3 generators>, 
  <pc group of size 15625 with 2 generators>, 
  <pc group of size 15625 with 3 generators>, 
  <pc group of size 15625 with 4 generators>, 
  <pc group of size 15625 with 3 generators>, 
  <pc group of size 15625 with 4 generators>, 
  <pc group of size 15625 with 5 generators>, 
  <pc group of size 15625 with 6 generators>, 
  <pc group of size 117649 with 2 generators>, 
  <pc group of size 117649 with 2 generators>, 
  <pc group of size 117649 with 3 generators>, 
  <pc group of size 117649 with 2 generators>, 
  <pc group of size 117649 with 3 generators>, 
  <pc group of size 117649 with 4 generators>, 
  <pc group of size 117649 with 3 generators>, 
  <pc group of size 117649 with 4 generators>, 
  <pc group of size 117649 with 5 generators>, 
  <pc group of size 117649 with 6 generators> ]

#
gap> STOP_TEST("small-7-8-9.tst");
