"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const passport_strategy_1 = __importDefault(require("passport-strategy"));
const util_1 = __importDefault(require("util"));
const saml = __importStar(require("./saml"));
const url_1 = __importDefault(require("url"));
function Strategy(options, verify) {
    if (typeof options == 'function') {
        verify = options;
        options = {};
    }
    if (!verify) {
        throw new Error('SAML authentication strategy requires a verify function');
    }
    // Customizing the name can be useful to support multiple SAML configurations at the same time.
    // Unlike other options, this one gets deleted instead of passed along.
    if (options.name) {
        this.name = options.name;
    }
    else {
        this.name = 'saml';
    }
    passport_strategy_1.default.Strategy.call(this);
    this._verify = verify;
    this._saml = new saml.SAML(options);
    this._passReqToCallback = !!options.passReqToCallback;
    this._authnRequestBinding = options.authnRequestBinding || 'HTTP-Redirect';
}
util_1.default.inherits(Strategy, passport_strategy_1.default.Strategy);
Strategy.prototype.authenticate = function (req, options) {
    options.samlFallback = options.samlFallback || 'login-request';
    const validateCallback = (err, profile, loggedOut) => {
        if (err) {
            return this.error(err);
        }
        if (loggedOut) {
            req.logout();
            if (profile) {
                req.samlLogoutRequest = profile;
                return this._saml.getLogoutResponseUrl(req, options, redirectIfSuccess);
            }
            return this.pass();
        }
        const verified = (err, user, info) => {
            if (err) {
                return this.error(err);
            }
            if (!user) {
                return this.fail(info);
            }
            this.success(user, info);
        };
        if (this._passReqToCallback) {
            this._verify(req, profile, verified);
        }
        else {
            this._verify(profile, verified);
        }
    };
    const redirectIfSuccess = (err, url) => {
        if (err) {
            this.error(err);
        }
        else {
            this.redirect(url);
        }
    };
    if (req.query && (req.query.SAMLResponse || req.query.SAMLRequest)) {
        const originalQuery = url_1.default.parse(req.url).query;
        this._saml.validateRedirect(req.query, originalQuery, validateCallback);
    }
    else if (req.body && req.body.SAMLResponse) {
        this._saml.validatePostResponse(req.body, validateCallback);
    }
    else if (req.body && req.body.SAMLRequest) {
        this._saml.validatePostRequest(req.body, validateCallback);
    }
    else {
        const requestHandler = {
            'login-request': () => {
                if (this._authnRequestBinding === 'HTTP-POST') {
                    this._saml.getAuthorizeForm(req, (err, data) => {
                        if (err) {
                            this.error(err);
                        }
                        else {
                            const res = req.res;
                            res.send(data);
                        }
                    });
                }
                else { // Defaults to HTTP-Redirect
                    this._saml.getAuthorizeUrl(req, options, redirectIfSuccess);
                }
            },
            'logout-request': () => {
                this._saml.getLogoutUrl(req, options, redirectIfSuccess);
            }
        }[options.samlFallback];
        if (typeof requestHandler !== 'function') {
            return this.fail();
        }
        requestHandler();
    }
};
Strategy.prototype.logout = function (req, callback) {
    this._saml.getLogoutUrl(req, {}, callback);
};
Strategy.prototype.generateServiceProviderMetadata = function (decryptionCert, signingCert) {
    return this._saml.generateServiceProviderMetadata(decryptionCert, signingCert);
};
module.exports = Strategy;
//# sourceMappingURL=strategy.js.map