/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.Collator;
import net.osmand.CollatorStringMatcher;
import net.osmand.OsmAndCollator;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.GeocodingUtilities;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.data.Street;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.resources.RegionAddressRepository;
import net.osmand.plus.resources.ResourceManager;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class RegionAddressRepositoryBinary
implements RegionAddressRepository {
    private static final Log log = PlatformUtil.getLog(RegionAddressRepositoryBinary.class);
    private BinaryMapIndexReader file;
    private LinkedHashMap<Long, City> cities = new LinkedHashMap();
    private int ZOOM_QTREE = 10;
    private QuadTree<City> citiesQtree = new QuadTree(new QuadRect(0.0, 0.0, 1 << this.ZOOM_QTREE + 1, 1 << this.ZOOM_QTREE + 1), 8, 0.55f);
    private final Map<String, City> postCodes;
    private final Collator collator;
    private String fileName;
    private ResourceManager mgr;
    private OsmandSettings.OsmandPreference<String> langSetting;

    public RegionAddressRepositoryBinary(ResourceManager mgr, BinaryMapIndexReader file, String fileName) {
        this.mgr = mgr;
        this.langSetting = mgr.getContext().getSettings().MAP_PREFERRED_LOCALE;
        this.file = file;
        this.fileName = fileName;
        this.collator = OsmAndCollator.primaryCollator();
        this.postCodes = new TreeMap<Object, City>(OsmAndCollator.primaryCollator());
    }

    @Override
    public void close() {
        this.file = null;
    }

    @Override
    public BinaryMapIndexReader getFile() {
        return this.file;
    }

    @Override
    public synchronized List<GeocodingUtilities.GeocodingResult> justifyReverseGeocodingSearch(GeocodingUtilities.GeocodingResult r, double minBuildingDistance, ResultMatcher<GeocodingUtilities.GeocodingResult> result) {
        try {
            return new GeocodingUtilities().justifyReverseGeocodingSearch(r, this.file, minBuildingDistance, result);
        }
        catch (IOException e) {
            log.error((Object)"Disk operation failed", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public synchronized void preloadCities(ResultMatcher<City> resultMatcher) {
        if (this.cities.isEmpty()) {
            try {
                List<City> cs = this.file.getCities(BinaryMapIndexReader.buildAddressRequest(resultMatcher), 1);
                LinkedHashMap<Long, City> ncities = new LinkedHashMap<Long, City>();
                for (City c : cs) {
                    ncities.put(c.getId(), c);
                    LatLon loc = c.getLocation();
                    if (loc == null) continue;
                    int y31 = MapUtils.get31TileNumberY(loc.getLatitude());
                    int x31 = MapUtils.get31TileNumberX(loc.getLongitude());
                    int dz = 31 - this.ZOOM_QTREE;
                    this.citiesQtree.insert(c, new QuadRect((x31 >> dz) - 1, (y31 >> dz) - 1, (x31 >> dz) + 1, (y31 >> dz) + 1));
                }
                this.cities = ncities;
            }
            catch (IOException e) {
                log.error((Object)"Disk operation failed", (Throwable)e);
            }
        }
    }

    public City getClosestCity(LatLon l, List<City> cache) {
        City closest = null;
        if (l != null) {
            int y31 = MapUtils.get31TileNumberY(l.getLatitude());
            int x31 = MapUtils.get31TileNumberX(l.getLongitude());
            int dz = 31 - this.ZOOM_QTREE;
            if (cache == null) {
                cache = new ArrayList<City>();
            }
            cache.clear();
            this.citiesQtree.queryInBox(new QuadRect((x31 >> dz) - 1, (y31 >> dz) - 1, (x31 >> dz) + 1, (y31 >> dz) + 1), cache);
            int min = -1;
            for (City c : cache) {
                double d = MapUtils.getDistance(l, c.getLocation());
                if (min != -1 && !(d < (double)min)) continue;
                min = (int)d;
                closest = c;
            }
        }
        return closest;
    }

    @Override
    public synchronized void preloadBuildings(Street street, ResultMatcher<Building> resultMatcher) {
        if (street.getBuildings().isEmpty() && street.getIntersectedStreets().isEmpty()) {
            try {
                this.file.preloadBuildings(street, BinaryMapIndexReader.buildAddressRequest(resultMatcher));
                street.sortBuildings();
            }
            catch (IOException e) {
                log.error((Object)"Disk operation failed", (Throwable)e);
            }
        }
    }

    @Override
    public void addCityToPreloadedList(City city) {
        if (!this.cities.containsKey(city.getId())) {
            LinkedHashMap<Long, City> ncities = new LinkedHashMap<Long, City>(this.cities);
            ncities.put(city.getId(), city);
            this.cities = ncities;
        }
    }

    @Override
    public List<City> getLoadedCities() {
        return new ArrayList<City>(this.cities.values());
    }

    @Override
    public synchronized void preloadStreets(City o, ResultMatcher<Street> resultMatcher) {
        Collection<Street> streets = o.getStreets();
        if (!streets.isEmpty()) {
            return;
        }
        try {
            this.file.preloadStreets(o, BinaryMapIndexReader.buildAddressRequest(resultMatcher));
        }
        catch (IOException e) {
            log.error((Object)"Disk operation failed", (Throwable)e);
        }
    }

    @Override
    public synchronized List<MapObject> searchMapObjectsByName(String name, ResultMatcher<MapObject> resultMatcher) {
        BinaryMapIndexReader.SearchRequest<MapObject> req = BinaryMapIndexReader.buildAddressByNameRequest(resultMatcher, name);
        try {
            log.debug((Object)("file=" + this.file + "; req=" + req));
            this.file.searchAddressDataByName(req);
        }
        catch (IOException e) {
            log.error((Object)"Disk operation failed", (Throwable)e);
        }
        return req.getSearchResults();
    }

    @Override
    public synchronized List<City> fillWithSuggestedCities(String name, final ResultMatcher<City> resultMatcher, boolean searchVillages, LatLon currentLocation) {
        ArrayList<City> citiesToFill = new ArrayList<City>();
        if (this.cities.isEmpty()) {
            this.preloadCities(resultMatcher);
            citiesToFill.addAll(this.cities.values());
            return citiesToFill;
        }
        this.preloadCities(null);
        if (name.length() == 0) {
            citiesToFill.addAll(this.cities.values());
            return citiesToFill;
        }
        try {
            List<City> foundCities;
            String lang = this.getLang();
            if (searchVillages) {
                String uName = name.toUpperCase();
                foundCities = this.file.getCities(BinaryMapIndexReader.buildAddressRequest(resultMatcher), new CollatorStringMatcher(uName, CollatorStringMatcher.StringMatcherMode.CHECK_CONTAINS), lang, 2);
                for (City code : foundCities) {
                    citiesToFill.add(code);
                    if (!resultMatcher.isCancelled()) continue;
                    return citiesToFill;
                }
            }
            name = name.toLowerCase();
            for (City c : this.cities.values()) {
                String cName = c.getName(lang);
                if (CollatorStringMatcher.cmatches(this.collator, cName, name, CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE) && resultMatcher.publish(c)) {
                    citiesToFill.add(c);
                }
                if (!resultMatcher.isCancelled()) continue;
                return citiesToFill;
            }
            int initialsize = citiesToFill.size();
            if (searchVillages) {
                foundCities = this.file.getCities(BinaryMapIndexReader.buildAddressRequest(new ResultMatcher<City>(){
                    List<City> cache = new ArrayList<City>();

                    @Override
                    public boolean publish(City c) {
                        if (c.getLocation() != null) {
                            City ct = RegionAddressRepositoryBinary.this.getClosestCity(c.getLocation(), this.cache);
                            c.setClosestCity(ct);
                        }
                        return resultMatcher.publish(c);
                    }

                    @Override
                    public boolean isCancelled() {
                        return resultMatcher.isCancelled();
                    }
                }), new CollatorStringMatcher(name, CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE), lang, 3);
                for (City c : foundCities) {
                    citiesToFill.add(c);
                    if (!resultMatcher.isCancelled()) continue;
                    return citiesToFill;
                }
            }
            log.debug((Object)("Loaded citites " + (citiesToFill.size() - initialsize)));
        }
        catch (IOException e) {
            log.error((Object)"Disk operation failed", (Throwable)e);
        }
        return citiesToFill;
    }

    @Override
    public String getLang() {
        return this.langSetting.get();
    }

    @Override
    public List<Street> getStreetsIntersectStreets(Street st) {
        this.preloadBuildings(st, null);
        return st.getIntersectedStreets();
    }

    @Override
    public Building getBuildingByName(Street street, String name) {
        this.preloadBuildings(street, null);
        String lang = this.getLang();
        for (Building b : street.getBuildings()) {
            String bName = b.getName(lang);
            if (!bName.equals(name)) continue;
            return b;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.fileName.indexOf(46) != -1) {
            return this.fileName.substring(0, this.fileName.indexOf(46));
        }
        return this.fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return this.getName() + " repository";
    }

    @Override
    public City getCityById(final long id2, String name) {
        if (id2 == -1L) {
            return null;
        }
        if (id2 < -1L && name != null) {
            name = name.toUpperCase();
        }
        final String cmpName = name;
        this.preloadCities(null);
        if (!this.cities.containsKey(id2)) {
            try {
                this.file.getCities(BinaryMapIndexReader.buildAddressRequest(new ResultMatcher<City>(){
                    boolean canceled = false;

                    @Override
                    public boolean isCancelled() {
                        return this.canceled;
                    }

                    @Override
                    public boolean publish(City object) {
                        if (id2 < -1L) {
                            if (object.getName().toUpperCase().equals(cmpName)) {
                                RegionAddressRepositoryBinary.this.addCityToPreloadedList(object);
                                this.canceled = true;
                            }
                        } else if (object.getId() != null && object.getId() == id2) {
                            RegionAddressRepositoryBinary.this.addCityToPreloadedList(object);
                            this.canceled = true;
                        }
                        return false;
                    }
                }), id2 < -1L ? 2 : 3);
            }
            catch (IOException e) {
                log.error((Object)"Disk operation failed", (Throwable)e);
            }
        }
        return this.cities.get(id2);
    }

    @Override
    public Street getStreetByName(City o, String name) {
        name = name.toLowerCase();
        this.preloadStreets(o, null);
        Collection<Street> streets = o.getStreets();
        String lang = this.getLang();
        for (Street s : streets) {
            String sName = s.getName(lang).toLowerCase();
            if (!this.collator.equals(sName, name)) continue;
            return s;
        }
        return null;
    }

    @Override
    public void clearCache() {
        this.cities = new LinkedHashMap();
        this.citiesQtree.clear();
        this.postCodes.clear();
    }

    @Override
    public LatLon getEstimatedRegionCenter() {
        return this.file.getRegionCenter();
    }
}

