// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC178x_7x_v0.8.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,neom3

// Neo M3
//

package nxp

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "NeoM3"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Windowed Watchdog Timer (WWDT)
	IRQ_WWDT = 0

	// Timer0/1/2/3
	IRQ_TIMER0 = 1

	IRQ_TIMER1 = 2

	IRQ_TIMER2 = 3

	IRQ_TIMER3 = 4

	// UART0/2/3
	IRQ_UART0 = 5

	// UART1
	IRQ_UART1 = 6

	IRQ_UART2 = 7

	IRQ_UART3 = 8

	IRQ_PWM1 = 9

	// I2C bus interface
	IRQ_I2C0 = 10

	IRQ_I2C1 = 11

	IRQ_I2C2 = 12

	// SSP controller
	IRQ_SSP0 = 14

	// SSP1 controller
	IRQ_SSP1 = 15

	// Real Time Clock (RTC)
	IRQ_RTC = 17

	// System and clock control
	IRQ_EINT0 = 18

	// System and clock control
	IRQ_EINT1 = 19

	// System and clock control
	IRQ_EINT2 = 20

	// System and clock control
	IRQ_EINT3 = 21

	// Analog-to-Digital Converter (ADC)
	IRQ_ADC = 22

	// System and clock control
	IRQ_BOD = 23

	// USB device/host/OTG controller
	IRQ_USB = 24

	// CAN1 controller
	IRQ_CAN = 25

	// General purpose DMA controller
	IRQ_GPDMA = 26

	// I2S interface
	IRQ_I2S = 27

	// Ethernet
	IRQ_ETHERNET = 28

	// SD card interface
	IRQ_SDMMC = 29

	// Motor Control PWM
	IRQ_MCPWM = 30

	// Quadrature Encoder Interface (QEI)
	IRQ_QEI = 31

	// USB device/host/OTG controller
	IRQ_USB_NEED_CLK = 33

	// UART4
	IRQ_UART4 = 35

	IRQ_SSP2 = 36

	// LCD controller
	IRQ_LCD = 37

	// GPIO
	IRQ_GPIOINT = 38

	// Pulse Width Modulators (PWM0/1)
	IRQ_PWM0 = 39

	// Flash control block
	IRQ_EEPROM = 40

	// Highest interrupt number on this device.
	IRQ_max = 40
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDT, "WWDT_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER0, "TIMER0_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER1, "TIMER1_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER2, "TIMER2_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER3, "TIMER3_IRQHandler")
	_ = interrupt.Register(IRQ_UART0, "UART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_UART2, "UART2_IRQHandler")
	_ = interrupt.Register(IRQ_UART3, "UART3_IRQHandler")
	_ = interrupt.Register(IRQ_PWM1, "PWM1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C0, "I2C0_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1, "I2C1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2, "I2C2_IRQHandler")
	_ = interrupt.Register(IRQ_SSP0, "SSP0_IRQHandler")
	_ = interrupt.Register(IRQ_SSP1, "SSP1_IRQHandler")
	_ = interrupt.Register(IRQ_RTC, "RTC_IRQHandler")
	_ = interrupt.Register(IRQ_EINT0, "EINT0_IRQHandler")
	_ = interrupt.Register(IRQ_EINT1, "EINT1_IRQHandler")
	_ = interrupt.Register(IRQ_EINT2, "EINT2_IRQHandler")
	_ = interrupt.Register(IRQ_EINT3, "EINT3_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_BOD, "BOD_IRQHandler")
	_ = interrupt.Register(IRQ_USB, "USB_IRQHandler")
	_ = interrupt.Register(IRQ_CAN, "CAN_IRQHandler")
	_ = interrupt.Register(IRQ_GPDMA, "GPDMA_IRQHandler")
	_ = interrupt.Register(IRQ_I2S, "I2S_IRQHandler")
	_ = interrupt.Register(IRQ_ETHERNET, "ETHERNET_IRQHandler")
	_ = interrupt.Register(IRQ_SDMMC, "SDMMC_IRQHandler")
	_ = interrupt.Register(IRQ_MCPWM, "MCPWM_IRQHandler")
	_ = interrupt.Register(IRQ_QEI, "QEI_IRQHandler")
	_ = interrupt.Register(IRQ_USB_NEED_CLK, "USB_NEED_CLK_IRQHandler")
	_ = interrupt.Register(IRQ_UART4, "UART4_IRQHandler")
	_ = interrupt.Register(IRQ_SSP2, "SSP2_IRQHandler")
	_ = interrupt.Register(IRQ_LCD, "LCD_IRQHandler")
	_ = interrupt.Register(IRQ_GPIOINT, "GPIOINT_IRQHandler")
	_ = interrupt.Register(IRQ_PWM0, "PWM0_IRQHandler")
	_ = interrupt.Register(IRQ_EEPROM, "EEPROM_IRQHandler")
)

// Peripherals.
var (
	// Flash control block
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x200000)))

	// General purpose DMA controller
	GPDMA = (*GPDMA_Type)(unsafe.Pointer(uintptr(0x20080000)))

	// Ethernet
	ETHERNET = (*ETHERNET_Type)(unsafe.Pointer(uintptr(0x20084000)))

	// LCD controller
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x20088000)))

	// USB device/host/OTG controller
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x2008c000)))

	// CRC engine
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x20090000)))

	// General Purpose I/O
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x20098000)))

	// ExternalMemory Controller (EMC)
	EMC = (*EMC_Type)(unsafe.Pointer(uintptr(0x2009c000)))

	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Timer0/1/2/3
	TIMER0 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Timer0/1/2/3
	TIMER1 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// UART0/2/3
	UART0 = (*UART0_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// UART1
	UART1 = (*UART1_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Pulse Width Modulators (PWM0/1)
	PWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// I2C bus interface
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Real Time Clock (RTC)
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// GPIO
	GPIOINT = (*GPIOINT_Type)(unsafe.Pointer(uintptr(0x40028080)))

	// IOCON pin configuration
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// SSP1 controller
	SSP1 = (*SSP1_Type)(unsafe.Pointer(uintptr(0x40030000)))

	// Analog-to-Digital Converter (ADC)
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40034000)))

	// CAN acceptance filter RAM
	CANAFRAM = (*CANAFRAM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// CAN controller acceptance filter
	CANAF = (*CANAF_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// Central CAN controller
	CCAN = (*CCAN_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// CAN1 controller
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// SSP controller
	SSP0 = (*SSP1_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Digital-to-Analog Converter (DAC)
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// Timer0/1/2/3
	TIMER2 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// Timer0/1/2/3
	TIMER3 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40094000)))

	// UART0/2/3
	UART2 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40098000)))

	// UART0/2/3
	UART3 = (*UART0_Type)(unsafe.Pointer(uintptr(0x4009c000)))

	// UART4
	UART4 = (*UART4_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// I2S interface
	I2S = (*I2S_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Motor Control PWM
	MCPWM = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x400b8000)))

	// Quadrature Encoder Interface (QEI)
	QEI = (*QEI_Type)(unsafe.Pointer(uintptr(0x400bc000)))

	// SD card interface
	SDMMC = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// System and clock control
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x400fc000)))

	// Pulse Width Modulators (PWM0/1)
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// CAN1 controller
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// I2C bus interface
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// I2C bus interface
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// SSP controller
	SSP2 = (*SSP1_Type)(unsafe.Pointer(uintptr(0x400ac000)))
)

// Flash control block
type FLASHCTRL_Type struct {
	_        [32]byte
	FMSSTART volatile.Register32 // 0x20
	FMSSTOP  volatile.Register32 // 0x24
	_        [4]byte
	FMSW0    volatile.Register32 // 0x2C
	FMSW1    volatile.Register32 // 0x30
	FMSW2    volatile.Register32 // 0x34
	FMSW3    volatile.Register32 // 0x38
	_        [68]byte
	EECMD    volatile.Register32 // 0x80
	EEADDR   volatile.Register32 // 0x84
	EEWDATA  volatile.Register32 // 0x88
	EERDATA  volatile.Register32 // 0x8C
	EEWSTATE volatile.Register32 // 0x90
	EECLKDIV volatile.Register32 // 0x94
	EEPWRDWN volatile.Register32 // 0x98
	_        [3900]byte
	ENCLR    volatile.Register32 // 0xFD8
	ENSET    volatile.Register32 // 0xFDC
	STAT     volatile.Register32 // 0xFE0
	INTEN    volatile.Register32 // 0xFE4
	STATCLR  volatile.Register32 // 0xFE8
}

// General purpose DMA controller
type GPDMA_Type struct {
	INTSTAT       volatile.Register32 // 0x0
	INTTCSTAT     volatile.Register32 // 0x4
	INTTCCLEAR    volatile.Register32 // 0x8
	INTERRSTAT    volatile.Register32 // 0xC
	INTERRCLR     volatile.Register32 // 0x10
	RAWINTTCSTAT  volatile.Register32 // 0x14
	RAWINTERRSTAT volatile.Register32 // 0x18
	ENBLDCHNS     volatile.Register32 // 0x1C
	SOFTBREQ      volatile.Register32 // 0x20
	SOFTSREQ      volatile.Register32 // 0x24
	SOFTLBREQ     volatile.Register32 // 0x28
	SOFTLSREQ     volatile.Register32 // 0x2C
	CONFIG        volatile.Register32 // 0x30
	SYNC          volatile.Register32 // 0x34
	_             [200]byte
	SRCADDR0      volatile.Register32 // 0x100
	DESTADDR0     volatile.Register32 // 0x104
	LLI0          volatile.Register32 // 0x108
	CONTROL0      volatile.Register32 // 0x10C
	CONFIG0       volatile.Register32 // 0x110
	_             [12]byte
	SRCADDR1      volatile.Register32 // 0x120
	DESTADDR1     volatile.Register32 // 0x124
	LLI1          volatile.Register32 // 0x128
	CONTROL1      volatile.Register32 // 0x12C
	CONFIG1       volatile.Register32 // 0x130
	_             [12]byte
	SRCADDR2      volatile.Register32 // 0x140
	DESTADDR2     volatile.Register32 // 0x144
	LLI2          volatile.Register32 // 0x148
	CONTROL2      volatile.Register32 // 0x14C
	CONFIG2       volatile.Register32 // 0x150
	_             [12]byte
	SRCADDR3      volatile.Register32 // 0x160
	DESTADDR3     volatile.Register32 // 0x164
	LLI3          volatile.Register32 // 0x168
	CONTROL3      volatile.Register32 // 0x16C
	CONFIG3       volatile.Register32 // 0x170
	_             [12]byte
	SRCADDR4      volatile.Register32 // 0x180
	DESTADDR4     volatile.Register32 // 0x184
	LLI4          volatile.Register32 // 0x188
	CONTROL4      volatile.Register32 // 0x18C
	CONFIG4       volatile.Register32 // 0x190
	_             [12]byte
	SRCADDR5      volatile.Register32 // 0x1A0
	DESTADDR5     volatile.Register32 // 0x1A4
	LLI5          volatile.Register32 // 0x1A8
	CONTROL5      volatile.Register32 // 0x1AC
	CONFIG5       volatile.Register32 // 0x1B0
	_             [12]byte
	SRCADDR6      volatile.Register32 // 0x1C0
	DESTADDR6     volatile.Register32 // 0x1C4
	LLI6          volatile.Register32 // 0x1C8
	CONTROL6      volatile.Register32 // 0x1CC
	CONFIG6       volatile.Register32 // 0x1D0
	_             [12]byte
	SRCADDR7      volatile.Register32 // 0x1E0
	DESTADDR7     volatile.Register32 // 0x1E4
	LLI7          volatile.Register32 // 0x1E8
	CONTROL7      volatile.Register32 // 0x1EC
	CONFIG7       volatile.Register32 // 0x1F0
}

// Ethernet
type ETHERNET_Type struct {
	MAC1               volatile.Register32 // 0x0
	MAC2               volatile.Register32 // 0x4
	IPGT               volatile.Register32 // 0x8
	IPGR               volatile.Register32 // 0xC
	CLRT               volatile.Register32 // 0x10
	MAXF               volatile.Register32 // 0x14
	SUPP               volatile.Register32 // 0x18
	TEST               volatile.Register32 // 0x1C
	MCFG               volatile.Register32 // 0x20
	MCMD               volatile.Register32 // 0x24
	MADR               volatile.Register32 // 0x28
	MWTD               volatile.Register32 // 0x2C
	MRDD               volatile.Register32 // 0x30
	MIND               volatile.Register32 // 0x34
	_                  [8]byte
	SA0                volatile.Register32 // 0x40
	SA1                volatile.Register32 // 0x44
	SA2                volatile.Register32 // 0x48
	_                  [180]byte
	COMMAND            volatile.Register32 // 0x100
	STATUS             volatile.Register32 // 0x104
	RXDESCRIPTOR       volatile.Register32 // 0x108
	RXSTATUS           volatile.Register32 // 0x10C
	RXDESCRIPTORNUMBER volatile.Register32 // 0x110
	RXPRODUCEINDEX     volatile.Register32 // 0x114
	RXCONSUMEINDEX     volatile.Register32 // 0x118
	TXDESCRIPTOR       volatile.Register32 // 0x11C
	TXSTATUS           volatile.Register32 // 0x120
	TXDESCRIPTORNUMBER volatile.Register32 // 0x124
	TXPRODUCEINDEX     volatile.Register32 // 0x128
	TXCONSUMEINDEX     volatile.Register32 // 0x12C
	_                  [40]byte
	TSV0               volatile.Register32 // 0x158
	TSV1               volatile.Register32 // 0x15C
	RSV                volatile.Register32 // 0x160
	_                  [12]byte
	FLOWCONTROLCOUNTER volatile.Register32 // 0x170
	FLOWCONTROLSTATUS  volatile.Register32 // 0x174
	_                  [136]byte
	RXFILTERCTRL       volatile.Register32 // 0x200
	RXFILTERWOLSTATUS  volatile.Register32 // 0x204
	RXFILTERWOLCLEAR   volatile.Register32 // 0x208
	_                  [4]byte
	HASHFILTERL        volatile.Register32 // 0x210
	HASHFILTERH        volatile.Register32 // 0x214
	_                  [3528]byte
	INTSTATUS          volatile.Register32 // 0xFE0
	INTENABLE          volatile.Register32 // 0xFE4
	INTCLEAR           volatile.Register32 // 0xFE8
	INTSET             volatile.Register32 // 0xFEC
	_                  [4]byte
	POWERDOWN          volatile.Register32 // 0xFF4
}

// LCD controller
type LCD_Type struct {
	TIMH         volatile.Register32 // 0x0
	TIMV         volatile.Register32 // 0x4
	POL          volatile.Register32 // 0x8
	LE           volatile.Register32 // 0xC
	UPBASE       volatile.Register32 // 0x10
	LPBASE       volatile.Register32 // 0x14
	CTRL         volatile.Register32 // 0x18
	INTMSK       volatile.Register32 // 0x1C
	INTRAW       volatile.Register32 // 0x20
	INTSTAT      volatile.Register32 // 0x24
	INTCLR       volatile.Register32 // 0x28
	UPCURR       volatile.Register32 // 0x2C
	LPCURR       volatile.Register32 // 0x30
	_            [460]byte
	PAL          [128]volatile.Register32 // 0x200
	_            [1024]byte
	CRSR_IMG     [256]volatile.Register32 // 0x800
	CRSR_CTRL    volatile.Register32      // 0xC00
	CRSR_CFG     volatile.Register32      // 0xC04
	CRSR_PAL0    volatile.Register32      // 0xC08
	CRSR_PAL1    volatile.Register32      // 0xC0C
	CRSR_XY      volatile.Register32      // 0xC10
	CRSR_CLIP    volatile.Register32      // 0xC14
	_            [8]byte
	CRSR_INTMSK  volatile.Register32 // 0xC20
	CRSR_INTCLR  volatile.Register32 // 0xC24
	CRSR_INTRAW  volatile.Register32 // 0xC28
	CRSR_INTSTAT volatile.Register32 // 0xC2C
}

// USB device/host/OTG controller
type USB_Type struct {
	_            [220]byte
	RXPLEN       volatile.Register32 // 0xDC
	_            [32]byte
	INTST        volatile.Register32 // 0x100
	INTEN        volatile.Register32 // 0x104
	INTSET       volatile.Register32 // 0x108
	INTCLR       volatile.Register32 // 0x10C
	STCTRL       volatile.Register32 // 0x110
	TMR          volatile.Register32 // 0x114
	_            [232]byte
	DEVINTST     volatile.Register32 // 0x200
	DEVINTEN     volatile.Register32 // 0x204
	DEVINTCLR    volatile.Register32 // 0x208
	DEVINTSET    volatile.Register32 // 0x20C
	CMDCODE      volatile.Register32 // 0x210
	CMDDATA      volatile.Register32 // 0x214
	RXDATA       volatile.Register32 // 0x218
	TXDATA       volatile.Register32 // 0x21C
	_            [4]byte
	TXPLEN       volatile.Register32 // 0x224
	CTRL         volatile.Register32 // 0x228
	DEVINTPRI    volatile.Register32 // 0x22C
	EPINTST      volatile.Register32 // 0x230
	EPINTEN      volatile.Register32 // 0x234
	EPINTCLR     volatile.Register32 // 0x238
	EPINTSET     volatile.Register32 // 0x23C
	EPINTPRI     volatile.Register32 // 0x240
	REEP         volatile.Register32 // 0x244
	EPIND        volatile.Register32 // 0x248
	MAXPSIZE     volatile.Register32 // 0x24C
	DMARST       volatile.Register32 // 0x250
	DMARCLR      volatile.Register32 // 0x254
	DMARSET      volatile.Register32 // 0x258
	_            [36]byte
	UDCAH        volatile.Register32 // 0x280
	EPDMAST      volatile.Register32 // 0x284
	EPDMAEN      volatile.Register32 // 0x288
	EPDMADIS     volatile.Register32 // 0x28C
	DMAINTST     volatile.Register32 // 0x290
	DMAINTEN     volatile.Register32 // 0x294
	_            [8]byte
	EOTINTST     volatile.Register32 // 0x2A0
	EOTINTCLR    volatile.Register32 // 0x2A4
	EOTINTSET    volatile.Register32 // 0x2A8
	NDDRINTST    volatile.Register32 // 0x2AC
	NDDRINTCLR   volatile.Register32 // 0x2B0
	NDDRINTSET   volatile.Register32 // 0x2B4
	SYSERRINTST  volatile.Register32 // 0x2B8
	SYSERRINTCLR volatile.Register32 // 0x2BC
	SYSERRINTSET volatile.Register32 // 0x2C0
	_            [60]byte
	I2C_RX       volatile.Register32 // 0x300
	I2C_STS      volatile.Register32 // 0x304
	I2C_CTL      volatile.Register32 // 0x308
	I2C_CLKHI    volatile.Register32 // 0x30C
	I2C_CLKLO    volatile.Register32 // 0x310
	_            [3296]byte
	USBCLKCTRL   volatile.Register32 // 0xFF4
	USBCLKST     volatile.Register32 // 0xFF8
}

// CRC engine
type CRC_Type struct {
	MODE volatile.Register32 // 0x0
	SEED volatile.Register32 // 0x4
	SUM  volatile.Register32 // 0x8
}

// General Purpose I/O
type GPIO_Type struct {
	DIR0  volatile.Register32 // 0x0
	_     [12]byte
	MASK0 volatile.Register32 // 0x10
	PIN0  volatile.Register32 // 0x14
	SET0  volatile.Register32 // 0x18
	CLR0  volatile.Register32 // 0x1C
	DIR1  volatile.Register32 // 0x20
	_     [12]byte
	MASK1 volatile.Register32 // 0x30
	PIN1  volatile.Register32 // 0x34
	SET1  volatile.Register32 // 0x38
	CLR1  volatile.Register32 // 0x3C
	DIR2  volatile.Register32 // 0x40
	_     [12]byte
	MASK2 volatile.Register32 // 0x50
	PIN2  volatile.Register32 // 0x54
	SET2  volatile.Register32 // 0x58
	CLR2  volatile.Register32 // 0x5C
	DIR3  volatile.Register32 // 0x60
	_     [12]byte
	MASK3 volatile.Register32 // 0x70
	PIN3  volatile.Register32 // 0x74
	SET3  volatile.Register32 // 0x78
	CLR3  volatile.Register32 // 0x7C
	DIR4  volatile.Register32 // 0x80
	_     [12]byte
	MASK4 volatile.Register32 // 0x90
	PIN4  volatile.Register32 // 0x94
	SET4  volatile.Register32 // 0x98
	CLR4  volatile.Register32 // 0x9C
	DIR5  volatile.Register32 // 0xA0
	_     [12]byte
	MASK5 volatile.Register32 // 0xB0
	PIN5  volatile.Register32 // 0xB4
	SET5  volatile.Register32 // 0xB8
	CLR5  volatile.Register32 // 0xBC
}

// ExternalMemory Controller (EMC)
type EMC_Type struct {
	CONTROL            volatile.Register32 // 0x0
	STATUS             volatile.Register32 // 0x4
	CONFIG             volatile.Register32 // 0x8
	_                  [20]byte
	DYNAMICCONTROL     volatile.Register32 // 0x20
	DYNAMICREFRESH     volatile.Register32 // 0x24
	DYNAMICREADCONFIG  volatile.Register32 // 0x28
	_                  [4]byte
	DYNAMICRP          volatile.Register32 // 0x30
	DYNAMICRAS         volatile.Register32 // 0x34
	DYNAMICSREX        volatile.Register32 // 0x38
	DYNAMICAPR         volatile.Register32 // 0x3C
	DYNAMICDAL         volatile.Register32 // 0x40
	DYNAMICWR          volatile.Register32 // 0x44
	DYNAMICRC          volatile.Register32 // 0x48
	DYNAMICRFC         volatile.Register32 // 0x4C
	DYNAMICXSR         volatile.Register32 // 0x50
	DYNAMICRRD         volatile.Register32 // 0x54
	DYNAMICMRD         volatile.Register32 // 0x58
	_                  [36]byte
	STATICEXTENDEDWAIT volatile.Register32 // 0x80
	_                  [124]byte
	DYNAMICCONFIG0     volatile.Register32 // 0x100
	DYNAMICRASCAS0     volatile.Register32 // 0x104
	_                  [24]byte
	DYNAMICCONFIG1     volatile.Register32 // 0x120
	DYNAMICRASCAS1     volatile.Register32 // 0x124
	_                  [24]byte
	DYNAMICCONFIG2     volatile.Register32 // 0x140
	DYNAMICRASCAS2     volatile.Register32 // 0x144
	_                  [24]byte
	DYNAMICCONFIG3     volatile.Register32 // 0x160
	DYNAMICRASCAS3     volatile.Register32 // 0x164
	_                  [152]byte
	STATICCONFIG0      volatile.Register32 // 0x200
	STATICWAITWEN0     volatile.Register32 // 0x204
	STATICWAITOEN0     volatile.Register32 // 0x208
	STATICWAITRD0      volatile.Register32 // 0x20C
	STATICWAITPAGE0    volatile.Register32 // 0x210
	STATICWAITWR0      volatile.Register32 // 0x214
	STATICWAITTURN0    volatile.Register32 // 0x218
	_                  [4]byte
	STATICCONFIG1      volatile.Register32 // 0x220
	STATICWAITWEN1     volatile.Register32 // 0x224
	STATICWAITOEN1     volatile.Register32 // 0x228
	STATICWAITRD1      volatile.Register32 // 0x22C
	STATICWAITPAGE1    volatile.Register32 // 0x230
	STATICWAITWR1      volatile.Register32 // 0x234
	STATICWAITTURN1    volatile.Register32 // 0x238
	_                  [4]byte
	STATICCONFIG2      volatile.Register32 // 0x240
	STATICWAITWEN2     volatile.Register32 // 0x244
	STATICWAITOEN2     volatile.Register32 // 0x248
	STATICWAITRD2      volatile.Register32 // 0x24C
	STATICWAITPAGE2    volatile.Register32 // 0x250
	STATICWAITWR2      volatile.Register32 // 0x254
	STATICWAITTURN2    volatile.Register32 // 0x258
	_                  [4]byte
	STATICCONFIG3      volatile.Register32 // 0x260
	STATICWAITWEN3     volatile.Register32 // 0x264
	STATICWAITOEN3     volatile.Register32 // 0x268
	STATICWAITRD3      volatile.Register32 // 0x26C
	STATICWAITPAGE3    volatile.Register32 // 0x270
	STATICWAITWR3      volatile.Register32 // 0x274
	STATICWAITTURN3    volatile.Register32 // 0x278
}

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	_       [4]byte
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// Timer0/1/2/3
type TIMER0_Type struct {
	IR   volatile.Register32    // 0x0
	TCR  volatile.Register32    // 0x4
	TC   volatile.Register32    // 0x8
	PR   volatile.Register32    // 0xC
	PC   volatile.Register32    // 0x10
	MCR  volatile.Register32    // 0x14
	MR   [4]volatile.Register32 // 0x18
	CCR  volatile.Register32    // 0x28
	CR   [2]volatile.Register32 // 0x2C
	_    [8]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
}

// UART0/2/3
type UART0_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	_             [4]byte
	LSR           volatile.Register32 // 0x14
	_             [4]byte
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// UART1
type UART1_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// Pulse Width Modulators (PWM0/1)
type PWM_Type struct {
	IR   volatile.Register32    // 0x0
	TCR  volatile.Register32    // 0x4
	TC   volatile.Register32    // 0x8
	PR   volatile.Register32    // 0xC
	PC   volatile.Register32    // 0x10
	MCR  volatile.Register32    // 0x14
	MR0  volatile.Register32    // 0x18
	MR1  volatile.Register32    // 0x1C
	MR2  volatile.Register32    // 0x20
	MR3  volatile.Register32    // 0x24
	CCR  volatile.Register32    // 0x28
	CR   [2]volatile.Register32 // 0x2C
	_    [12]byte
	MR4  volatile.Register32 // 0x40
	MR5  volatile.Register32 // 0x44
	MR6  volatile.Register32 // 0x48
	PCR  volatile.Register32 // 0x4C
	LER  volatile.Register32 // 0x50
	_    [28]byte
	CTCR volatile.Register32 // 0x70
}

// I2C bus interface
type I2C_Type struct {
	CONSET      volatile.Register32    // 0x0
	STAT        volatile.Register32    // 0x4
	DAT         volatile.Register32    // 0x8
	ADR0        volatile.Register32    // 0xC
	SCLH        volatile.Register32    // 0x10
	SCLL        volatile.Register32    // 0x14
	CONCLR      volatile.Register32    // 0x18
	MMCTRL      volatile.Register32    // 0x1C
	ADR1        volatile.Register32    // 0x20
	ADR2        volatile.Register32    // 0x24
	ADR3        volatile.Register32    // 0x28
	DATA_BUFFER volatile.Register32    // 0x2C
	MASK        [4]volatile.Register32 // 0x30
}

// Real Time Clock (RTC)
type RTC_Type struct {
	ILR           volatile.Register32 // 0x0
	_             [4]byte
	CCR           volatile.Register32 // 0x8
	CIIR          volatile.Register32 // 0xC
	AMR           volatile.Register32 // 0x10
	CTIME0        volatile.Register32 // 0x14
	CTIME1        volatile.Register32 // 0x18
	CTIME2        volatile.Register32 // 0x1C
	SEC           volatile.Register32 // 0x20
	MIN           volatile.Register32 // 0x24
	HRS           volatile.Register32 // 0x28
	DOM           volatile.Register32 // 0x2C
	DOW           volatile.Register32 // 0x30
	DOY           volatile.Register32 // 0x34
	MONTH         volatile.Register32 // 0x38
	YEAR          volatile.Register32 // 0x3C
	CALIBRATION   volatile.Register32 // 0x40
	GPREG0        volatile.Register32 // 0x44
	GPREG1        volatile.Register32 // 0x48
	GPREG2        volatile.Register32 // 0x4C
	GPREG3        volatile.Register32 // 0x50
	GPREG4        volatile.Register32 // 0x54
	RTC_AUXEN     volatile.Register32 // 0x58
	RTC_AUX       volatile.Register32 // 0x5C
	ASEC          volatile.Register32 // 0x60
	AMIN          volatile.Register32 // 0x64
	AHRS          volatile.Register32 // 0x68
	ADOM          volatile.Register32 // 0x6C
	ADOW          volatile.Register32 // 0x70
	ADOY          volatile.Register32 // 0x74
	AMON          volatile.Register32 // 0x78
	AYRS          volatile.Register32 // 0x7C
	ERSTATUS      volatile.Register32 // 0x80
	ERCONTROL     volatile.Register32 // 0x84
	ERCOUNTERS    volatile.Register32 // 0x88
	_             [4]byte
	ERFIRSTSTAMP0 volatile.Register32 // 0x90
	ERFIRSTSTAMP1 volatile.Register32 // 0x94
	ERFIRSTSTAMP2 volatile.Register32 // 0x98
	_             [4]byte
	ERLASTSTAMP0  volatile.Register32 // 0xA0
	ERLASTSTAMP1  volatile.Register32 // 0xA4
	ERLASTSTAMP2  volatile.Register32 // 0xA8
}

// GPIO
type GPIOINT_Type struct {
	STATUS volatile.Register32 // 0x0
	STATR0 volatile.Register32 // 0x4
	STATF0 volatile.Register32 // 0x8
	CLR0   volatile.Register32 // 0xC
	ENR0   volatile.Register32 // 0x10
	ENF0   volatile.Register32 // 0x14
	_      [12]byte
	STATR2 volatile.Register32 // 0x24
	STATF2 volatile.Register32 // 0x28
	CLR2   volatile.Register32 // 0x2C
	ENR2   volatile.Register32 // 0x30
	ENF2   volatile.Register32 // 0x34
}

// IOCON pin configuration
type IOCON_Type struct {
	P0_0  volatile.Register32 // 0x0
	P0_1  volatile.Register32 // 0x4
	P0_2  volatile.Register32 // 0x8
	P0_3  volatile.Register32 // 0xC
	P0_4  volatile.Register32 // 0x10
	P0_5  volatile.Register32 // 0x14
	P0_6  volatile.Register32 // 0x18
	P0_7  volatile.Register32 // 0x1C
	P0_8  volatile.Register32 // 0x20
	P0_9  volatile.Register32 // 0x24
	P0_10 volatile.Register32 // 0x28
	P0_11 volatile.Register32 // 0x2C
	P0_12 volatile.Register32 // 0x30
	P0_13 volatile.Register32 // 0x34
	P0_14 volatile.Register32 // 0x38
	P0_15 volatile.Register32 // 0x3C
	P0_16 volatile.Register32 // 0x40
	P0_17 volatile.Register32 // 0x44
	P0_18 volatile.Register32 // 0x48
	P0_19 volatile.Register32 // 0x4C
	P0_20 volatile.Register32 // 0x50
	P0_21 volatile.Register32 // 0x54
	P0_22 volatile.Register32 // 0x58
	P0_23 volatile.Register32 // 0x5C
	P0_24 volatile.Register32 // 0x60
	P0_25 volatile.Register32 // 0x64
	P0_26 volatile.Register32 // 0x68
	P0_27 volatile.Register32 // 0x6C
	P0_28 volatile.Register32 // 0x70
	P0_29 volatile.Register32 // 0x74
	P0_30 volatile.Register32 // 0x78
	P0_31 volatile.Register32 // 0x7C
	P1_0  volatile.Register32 // 0x80
	P1_1  volatile.Register32 // 0x84
	P1_2  volatile.Register32 // 0x88
	P1_3  volatile.Register32 // 0x8C
	P1_4  volatile.Register32 // 0x90
	P1_5  volatile.Register32 // 0x94
	P1_6  volatile.Register32 // 0x98
	P1_7  volatile.Register32 // 0x9C
	P1_8  volatile.Register32 // 0xA0
	P1_9  volatile.Register32 // 0xA4
	P1_10 volatile.Register32 // 0xA8
	P1_11 volatile.Register32 // 0xAC
	P1_12 volatile.Register32 // 0xB0
	P1_13 volatile.Register32 // 0xB4
	P1_14 volatile.Register32 // 0xB8
	P1_15 volatile.Register32 // 0xBC
	P1_16 volatile.Register32 // 0xC0
	P1_17 volatile.Register32 // 0xC4
	P1_18 volatile.Register32 // 0xC8
	P1_19 volatile.Register32 // 0xCC
	P1_20 volatile.Register32 // 0xD0
	P1_21 volatile.Register32 // 0xD4
	P1_22 volatile.Register32 // 0xD8
	P1_23 volatile.Register32 // 0xDC
	P1_24 volatile.Register32 // 0xE0
	P1_25 volatile.Register32 // 0xE4
	P1_26 volatile.Register32 // 0xE8
	P1_27 volatile.Register32 // 0xEC
	P1_28 volatile.Register32 // 0xF0
	P1_29 volatile.Register32 // 0xF4
	P1_30 volatile.Register32 // 0xF8
	P1_31 volatile.Register32 // 0xFC
	P2_0  volatile.Register32 // 0x100
	P2_1  volatile.Register32 // 0x104
	P2_2  volatile.Register32 // 0x108
	P2_3  volatile.Register32 // 0x10C
	P2_4  volatile.Register32 // 0x110
	P2_5  volatile.Register32 // 0x114
	P2_6  volatile.Register32 // 0x118
	P2_7  volatile.Register32 // 0x11C
	P2_8  volatile.Register32 // 0x120
	P2_9  volatile.Register32 // 0x124
	P2_10 volatile.Register32 // 0x128
	P2_11 volatile.Register32 // 0x12C
	P2_12 volatile.Register32 // 0x130
	P2_13 volatile.Register32 // 0x134
	P2_14 volatile.Register32 // 0x138
	P2_15 volatile.Register32 // 0x13C
	P2_16 volatile.Register32 // 0x140
	P2_17 volatile.Register32 // 0x144
	P2_18 volatile.Register32 // 0x148
	P2_19 volatile.Register32 // 0x14C
	P2_20 volatile.Register32 // 0x150
	P2_21 volatile.Register32 // 0x154
	P2_22 volatile.Register32 // 0x158
	P2_23 volatile.Register32 // 0x15C
	P2_24 volatile.Register32 // 0x160
	P2_25 volatile.Register32 // 0x164
	P2_26 volatile.Register32 // 0x168
	P2_27 volatile.Register32 // 0x16C
	P2_28 volatile.Register32 // 0x170
	P2_29 volatile.Register32 // 0x174
	P2_30 volatile.Register32 // 0x178
	P2_31 volatile.Register32 // 0x17C
	P3_0  volatile.Register32 // 0x180
	P3_1  volatile.Register32 // 0x184
	P3_2  volatile.Register32 // 0x188
	P3_3  volatile.Register32 // 0x18C
	P3_4  volatile.Register32 // 0x190
	P3_5  volatile.Register32 // 0x194
	P3_6  volatile.Register32 // 0x198
	P3_7  volatile.Register32 // 0x19C
	P3_8  volatile.Register32 // 0x1A0
	P3_9  volatile.Register32 // 0x1A4
	P3_10 volatile.Register32 // 0x1A8
	P3_11 volatile.Register32 // 0x1AC
	P3_12 volatile.Register32 // 0x1B0
	P3_13 volatile.Register32 // 0x1B4
	P3_14 volatile.Register32 // 0x1B8
	P3_15 volatile.Register32 // 0x1BC
	P3_16 volatile.Register32 // 0x1C0
	P3_17 volatile.Register32 // 0x1C4
	P3_18 volatile.Register32 // 0x1C8
	P3_19 volatile.Register32 // 0x1CC
	P3_20 volatile.Register32 // 0x1D0
	P3_21 volatile.Register32 // 0x1D4
	P3_22 volatile.Register32 // 0x1D8
	P3_23 volatile.Register32 // 0x1DC
	P3_24 volatile.Register32 // 0x1E0
	P3_25 volatile.Register32 // 0x1E4
	P3_26 volatile.Register32 // 0x1E8
	P3_27 volatile.Register32 // 0x1EC
	P3_28 volatile.Register32 // 0x1F0
	P3_29 volatile.Register32 // 0x1F4
	P3_30 volatile.Register32 // 0x1F8
	P3_31 volatile.Register32 // 0x1FC
	P4_0  volatile.Register32 // 0x200
	P4_1  volatile.Register32 // 0x204
	P4_2  volatile.Register32 // 0x208
	P4_3  volatile.Register32 // 0x20C
	P4_4  volatile.Register32 // 0x210
	P4_5  volatile.Register32 // 0x214
	P4_6  volatile.Register32 // 0x218
	P4_7  volatile.Register32 // 0x21C
	P4_8  volatile.Register32 // 0x220
	P4_9  volatile.Register32 // 0x224
	P4_10 volatile.Register32 // 0x228
	P4_11 volatile.Register32 // 0x22C
	P4_12 volatile.Register32 // 0x230
	P4_13 volatile.Register32 // 0x234
	P4_14 volatile.Register32 // 0x238
	P4_15 volatile.Register32 // 0x23C
	P4_16 volatile.Register32 // 0x240
	P4_17 volatile.Register32 // 0x244
	P4_18 volatile.Register32 // 0x248
	P4_19 volatile.Register32 // 0x24C
	P4_20 volatile.Register32 // 0x250
	P4_21 volatile.Register32 // 0x254
	P4_22 volatile.Register32 // 0x258
	P4_23 volatile.Register32 // 0x25C
	P4_24 volatile.Register32 // 0x260
	P4_25 volatile.Register32 // 0x264
	P4_26 volatile.Register32 // 0x268
	P4_27 volatile.Register32 // 0x26C
	P4_28 volatile.Register32 // 0x270
	P4_29 volatile.Register32 // 0x274
	P4_30 volatile.Register32 // 0x278
	P4_31 volatile.Register32 // 0x27C
	P5_0  volatile.Register32 // 0x280
	P5_1  volatile.Register32 // 0x284
	P5_2  volatile.Register32 // 0x288
	P5_3  volatile.Register32 // 0x28C
	P5_4  volatile.Register32 // 0x290
}

// SSP1 controller
type SSP1_Type struct {
	CR0   volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	DR    volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	CPSR  volatile.Register32 // 0x10
	IMSC  volatile.Register32 // 0x14
	RIS   volatile.Register32 // 0x18
	MIS   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	DMACR volatile.Register32 // 0x24
}

// Analog-to-Digital Converter (ADC)
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	GDR   volatile.Register32 // 0x4
	_     [4]byte
	INTEN volatile.Register32    // 0xC
	DR    [8]volatile.Register32 // 0x10
	STAT  volatile.Register32    // 0x30
	TRM   volatile.Register32    // 0x34
}

// CAN acceptance filter RAM
type CANAFRAM_Type struct {
	MASK [512]volatile.Register32 // 0x0
}

// CAN controller acceptance filter
type CANAF_Type struct {
	AFMR       volatile.Register32 // 0x0
	SFF_SA     volatile.Register32 // 0x4
	SFF_GRP_SA volatile.Register32 // 0x8
	EFF_SA     volatile.Register32 // 0xC
	EFF_GRP_SA volatile.Register32 // 0x10
	ENDOFTABLE volatile.Register32 // 0x14
	LUTERRAD   volatile.Register32 // 0x18
	LUTERR     volatile.Register32 // 0x1C
	FCANIE     volatile.Register32 // 0x20
	FCANIC0    volatile.Register32 // 0x24
	FCANIC1    volatile.Register32 // 0x28
}

// Central CAN controller
type CCAN_Type struct {
	TXSR volatile.Register32 // 0x0
	RXSR volatile.Register32 // 0x4
	MSR  volatile.Register32 // 0x8
}

// CAN1 controller
type CAN_Type struct {
	MOD  volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	GSR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
	IER  volatile.Register32 // 0x10
	BTR  volatile.Register32 // 0x14
	EWL  volatile.Register32 // 0x18
	SR   volatile.Register32 // 0x1C
	RFS  volatile.Register32 // 0x20
	RID  volatile.Register32 // 0x24
	RDA  volatile.Register32 // 0x28
	RDB  volatile.Register32 // 0x2C
	TFI1 volatile.Register32 // 0x30
	TID1 volatile.Register32 // 0x34
	TDA1 volatile.Register32 // 0x38
	TDB1 volatile.Register32 // 0x3C
	TFI2 volatile.Register32 // 0x40
	TID2 volatile.Register32 // 0x44
	TDA2 volatile.Register32 // 0x48
	TDB2 volatile.Register32 // 0x4C
	TFI3 volatile.Register32 // 0x50
	TID3 volatile.Register32 // 0x54
	TDA3 volatile.Register32 // 0x58
	TDB3 volatile.Register32 // 0x5C
}

// Digital-to-Analog Converter (DAC)
type DAC_Type struct {
	CR     volatile.Register32 // 0x0
	CTRL   volatile.Register32 // 0x4
	CNTVAL volatile.Register32 // 0x8
}

// UART4
type UART4_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	_             [4]byte
	LSR           volatile.Register32 // 0x14
	_             [4]byte
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	ICR           volatile.Register32 // 0x24
	FDR           volatile.Register32 // 0x28
	OSR           volatile.Register32 // 0x2C
	_             [24]byte
	SCICTRL       volatile.Register32 // 0x48
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
	SYNCCTRL      volatile.Register32 // 0x58
}

// I2S interface
type I2S_Type struct {
	DAO       volatile.Register32 // 0x0
	DAI       volatile.Register32 // 0x4
	TXFIFO    volatile.Register32 // 0x8
	RXFIFO    volatile.Register32 // 0xC
	STATE     volatile.Register32 // 0x10
	DMA1      volatile.Register32 // 0x14
	DMA2      volatile.Register32 // 0x18
	IRQ       volatile.Register32 // 0x1C
	TXRATE    volatile.Register32 // 0x20
	RXRATE    volatile.Register32 // 0x24
	TXBITRATE volatile.Register32 // 0x28
	RXBITRATE volatile.Register32 // 0x2C
	TXMODE    volatile.Register32 // 0x30
	RXMODE    volatile.Register32 // 0x34
}

// Motor Control PWM
type MCPWM_Type struct {
	CON        volatile.Register32    // 0x0
	CON_SET    volatile.Register32    // 0x4
	CON_CLR    volatile.Register32    // 0x8
	CAPCON     volatile.Register32    // 0xC
	CAPCON_SET volatile.Register32    // 0x10
	CAPCON_CLR volatile.Register32    // 0x14
	TC         [3]volatile.Register32 // 0x18
	LIM        [3]volatile.Register32 // 0x24
	MAT        [3]volatile.Register32 // 0x30
	DT         volatile.Register32    // 0x3C
	CCP        volatile.Register32    // 0x40
	CAP        [3]volatile.Register32 // 0x44
	INTEN      volatile.Register32    // 0x50
	INTEN_SET  volatile.Register32    // 0x54
	INTEN_CLR  volatile.Register32    // 0x58
	CNTCON     volatile.Register32    // 0x5C
	CNTCON_SET volatile.Register32    // 0x60
	CNTCON_CLR volatile.Register32    // 0x64
	INTF       volatile.Register32    // 0x68
	INTF_SET   volatile.Register32    // 0x6C
	INTF_CLR   volatile.Register32    // 0x70
	CAP_CLR    volatile.Register32    // 0x74
}

// Quadrature Encoder Interface (QEI)
type QEI_Type struct {
	CON       volatile.Register32 // 0x0
	STAT      volatile.Register32 // 0x4
	CONF      volatile.Register32 // 0x8
	POS       volatile.Register32 // 0xC
	MAXPOS    volatile.Register32 // 0x10
	CMPOS0    volatile.Register32 // 0x14
	CMPOS1    volatile.Register32 // 0x18
	CMPOS2    volatile.Register32 // 0x1C
	INXCNT    volatile.Register32 // 0x20
	INXCMP0   volatile.Register32 // 0x24
	LOAD      volatile.Register32 // 0x28
	TIME      volatile.Register32 // 0x2C
	VEL       volatile.Register32 // 0x30
	CAP       volatile.Register32 // 0x34
	VELCOMP   volatile.Register32 // 0x38
	FILTERPHA volatile.Register32 // 0x3C
	FILTERPHB volatile.Register32 // 0x40
	FILTERINX volatile.Register32 // 0x44
	WINDOW    volatile.Register32 // 0x48
	INXCMP1   volatile.Register32 // 0x4C
	INXCMP2   volatile.Register32 // 0x50
	_         [3972]byte
	IEC       volatile.Register32 // 0xFD8
	IES       volatile.Register32 // 0xFDC
	INTSTAT   volatile.Register32 // 0xFE0
	IE        volatile.Register32 // 0xFE4
	CLR       volatile.Register32 // 0xFE8
	SET       volatile.Register32 // 0xFEC
}

// SD card interface
type SDMMC_Type struct {
	PWR        volatile.Register32 // 0x0
	CLOCK      volatile.Register32 // 0x4
	ARGUMENT   volatile.Register32 // 0x8
	COMMAND    volatile.Register32 // 0xC
	RESPCMD    volatile.Register32 // 0x10
	RESPONSE0  volatile.Register32 // 0x14
	RESPONSE1  volatile.Register32 // 0x18
	RESPONSE2  volatile.Register32 // 0x1C
	RESPONSE3  volatile.Register32 // 0x20
	DATATIMER  volatile.Register32 // 0x24
	DATALENGTH volatile.Register32 // 0x28
	DATACTRL   volatile.Register32 // 0x2C
	DATACNT    volatile.Register32 // 0x30
	STATUS     volatile.Register32 // 0x34
	CLEAR      volatile.Register32 // 0x38
	MASK0      volatile.Register32 // 0x3C
	_          [8]byte
	FIFOCNT    volatile.Register32 // 0x48
	_          [52]byte
	FIFO0      volatile.Register32 // 0x80
	FIFO1      volatile.Register32 // 0x84
	FIFO2      volatile.Register32 // 0x88
	FIFO3      volatile.Register32 // 0x8C
	FIFO4      volatile.Register32 // 0x90
	FIFO5      volatile.Register32 // 0x94
	FIFO6      volatile.Register32 // 0x98
	FIFO7      volatile.Register32 // 0x9C
	FIFO8      volatile.Register32 // 0xA0
	FIFO9      volatile.Register32 // 0xA4
	FIFO10     volatile.Register32 // 0xA8
	FIFO11     volatile.Register32 // 0xAC
	FIFO12     volatile.Register32 // 0xB0
	FIFO13     volatile.Register32 // 0xB4
	FIFO14     volatile.Register32 // 0xB8
	FIFO15     volatile.Register32 // 0xBC
}

// System and clock control
type SYSCON_Type struct {
	FLASHCFG     volatile.Register32 // 0x0
	_            [124]byte
	PLL0CON      volatile.Register32 // 0x80
	PLL0CFG      volatile.Register32 // 0x84
	PLL0STAT     volatile.Register32 // 0x88
	PLL0FEED     volatile.Register32 // 0x8C
	_            [16]byte
	PLL1CON      volatile.Register32 // 0xA0
	PLL1CFG      volatile.Register32 // 0xA4
	PLL1STAT     volatile.Register32 // 0xA8
	PLL1FEED     volatile.Register32 // 0xAC
	_            [16]byte
	PCON         volatile.Register32 // 0xC0
	PCONP        volatile.Register32 // 0xC4
	_            [56]byte
	EMCCLKSEL    volatile.Register32 // 0x100
	CCLKSEL      volatile.Register32 // 0x104
	USBCLKSEL    volatile.Register32 // 0x108
	CLKSRCSEL    volatile.Register32 // 0x10C
	CANSLEEPCLR  volatile.Register32 // 0x110
	CANWAKEFLAGS volatile.Register32 // 0x114
	_            [40]byte
	EXTINT       volatile.Register32 // 0x140
	_            [4]byte
	EXTMODE      volatile.Register32 // 0x148
	EXTPOLAR     volatile.Register32 // 0x14C
	_            [48]byte
	RSID         volatile.Register32 // 0x180
	_            [4]byte
	MATRIXARB    volatile.Register32 // 0x188
	_            [20]byte
	SCS          volatile.Register32 // 0x1A0
	_            [4]byte
	PCLKSEL      volatile.Register32 // 0x1A8
	_            [4]byte
	PBOOST       volatile.Register32 // 0x1B0
	SPIFICLKSEL  volatile.Register32 // 0x1B4
	LCD_CFG      volatile.Register32 // 0x1B8
	_            [4]byte
	USBINTST     volatile.Register32 // 0x1C0
	DMACREQSEL   volatile.Register32 // 0x1C4
	CLKOUTCFG    volatile.Register32 // 0x1C8
	RSTCON0      volatile.Register32 // 0x1CC
	RSTCON1      volatile.Register32 // 0x1D0
	_            [8]byte
	EMCDLYCTL    volatile.Register32 // 0x1DC
	EMCCAL       volatile.Register32 // 0x1E0
}

// Bitfields for FLASHCTRL: Flash control block
const (
	// FMSSTART: Signature start address register
	// Position of START field.
	FLASHCTRL_FMSSTART_START_Pos = 0x0
	// Bit mask of START field.
	FLASHCTRL_FMSSTART_START_Msk = 0x1ffff
	// Position of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTART_RESERVED_Msk = 0xfffe0000

	// FMSSTOP: Signature stop-address register
	// Position of STOP field.
	FLASHCTRL_FMSSTOP_STOP_Pos = 0x0
	// Bit mask of STOP field.
	FLASHCTRL_FMSSTOP_STOP_Msk = 0x1ffff
	// Position of SIG_START field.
	FLASHCTRL_FMSSTOP_SIG_START_Pos = 0x11
	// Bit mask of SIG_START field.
	FLASHCTRL_FMSSTOP_SIG_START_Msk = 0x20000
	// Bit SIG_START.
	FLASHCTRL_FMSSTOP_SIG_START = 0x20000
	// Signature generation is stopped
	FLASHCTRL_FMSSTOP_SIG_START_STOP = 0x0
	// Initiate signature generation
	FLASHCTRL_FMSSTOP_SIG_START_START = 0x1
	// Position of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	FLASHCTRL_FMSSTOP_RESERVED_Msk = 0xfffc0000

	// FMSW0: 128-bit signature Word 0
	// Position of SW0_31_0 field.
	FLASHCTRL_FMSW0_SW0_31_0_Pos = 0x0
	// Bit mask of SW0_31_0 field.
	FLASHCTRL_FMSW0_SW0_31_0_Msk = 0xffffffff

	// FMSW1: 128-bit signature Word 1
	// Position of SW1_63_32 field.
	FLASHCTRL_FMSW1_SW1_63_32_Pos = 0x0
	// Bit mask of SW1_63_32 field.
	FLASHCTRL_FMSW1_SW1_63_32_Msk = 0xffffffff

	// FMSW2: 128-bit signature Word 2
	// Position of SW2_95_64 field.
	FLASHCTRL_FMSW2_SW2_95_64_Pos = 0x0
	// Bit mask of SW2_95_64 field.
	FLASHCTRL_FMSW2_SW2_95_64_Msk = 0xffffffff

	// FMSW3: 128-bit signature Word 3
	// Position of SW3_127_96 field.
	FLASHCTRL_FMSW3_SW3_127_96_Pos = 0x0
	// Bit mask of SW3_127_96 field.
	FLASHCTRL_FMSW3_SW3_127_96_Msk = 0xffffffff

	// EECMD: EEPROM command register
	// Position of CMD field.
	FLASHCTRL_EECMD_CMD_Pos = 0x0
	// Bit mask of CMD field.
	FLASHCTRL_EECMD_CMD_Msk = 0x7
	// Position of RDPREFETCH field.
	FLASHCTRL_EECMD_RDPREFETCH_Pos = 0x3
	// Bit mask of RDPREFETCH field.
	FLASHCTRL_EECMD_RDPREFETCH_Msk = 0x8
	// Bit RDPREFETCH.
	FLASHCTRL_EECMD_RDPREFETCH = 0x8
	// Position of RESERVED field.
	FLASHCTRL_EECMD_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	FLASHCTRL_EECMD_RESERVED_Msk = 0xfffffff0

	// EEADDR: EEPROM address register
	// Position of ADDR field.
	FLASHCTRL_EEADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	FLASHCTRL_EEADDR_ADDR_Msk = 0xfff
	// Position of RESERVED field.
	FLASHCTRL_EEADDR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	FLASHCTRL_EEADDR_RESERVED_Msk = 0xfffff000

	// EEWDATA: EEPROM write data register
	// Position of WDATA field.
	FLASHCTRL_EEWDATA_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	FLASHCTRL_EEWDATA_WDATA_Msk = 0xffffffff

	// EERDATA: EEPROM read data register
	// Position of RDATA field.
	FLASHCTRL_EERDATA_RDATA_Pos = 0x0
	// Bit mask of RDATA field.
	FLASHCTRL_EERDATA_RDATA_Msk = 0xffffffff

	// EEWSTATE: EEPROM wait state register
	// Position of PHASE3 field.
	FLASHCTRL_EEWSTATE_PHASE3_Pos = 0x0
	// Bit mask of PHASE3 field.
	FLASHCTRL_EEWSTATE_PHASE3_Msk = 0xff
	// Position of PHASE2 field.
	FLASHCTRL_EEWSTATE_PHASE2_Pos = 0x8
	// Bit mask of PHASE2 field.
	FLASHCTRL_EEWSTATE_PHASE2_Msk = 0xff00
	// Position of PHASE1 field.
	FLASHCTRL_EEWSTATE_PHASE1_Pos = 0x10
	// Bit mask of PHASE1 field.
	FLASHCTRL_EEWSTATE_PHASE1_Msk = 0xff0000
	// Position of RESERVED field.
	FLASHCTRL_EEWSTATE_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	FLASHCTRL_EEWSTATE_RESERVED_Msk = 0xff000000

	// EECLKDIV: EEPROM clock divider register
	// Position of CLKDIV field.
	FLASHCTRL_EECLKDIV_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	FLASHCTRL_EECLKDIV_CLKDIV_Msk = 0xffff
	// Position of RESERVED field.
	FLASHCTRL_EECLKDIV_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	FLASHCTRL_EECLKDIV_RESERVED_Msk = 0xffff0000

	// EEPWRDWN: EEPROM power-down register
	// Position of PWRDWN field.
	FLASHCTRL_EEPWRDWN_PWRDWN_Pos = 0x0
	// Bit mask of PWRDWN field.
	FLASHCTRL_EEPWRDWN_PWRDWN_Msk = 0x1
	// Bit PWRDWN.
	FLASHCTRL_EEPWRDWN_PWRDWN = 0x1
	// Position of RESERVED field.
	FLASHCTRL_EEPWRDWN_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	FLASHCTRL_EEPWRDWN_RESERVED_Msk = 0xfffffffe

	// ENCLR: EEPROM interrupt enable clear
	// Position of RESERVED field.
	FLASHCTRL_ENCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_ENCLR_RESERVED_Msk = 0x3ffffff
	// Position of RDWR_CLR_EN field.
	FLASHCTRL_ENCLR_RDWR_CLR_EN_Pos = 0x1a
	// Bit mask of RDWR_CLR_EN field.
	FLASHCTRL_ENCLR_RDWR_CLR_EN_Msk = 0x4000000
	// Bit RDWR_CLR_EN.
	FLASHCTRL_ENCLR_RDWR_CLR_EN = 0x4000000
	// Position of RESERVED field.
	FLASHCTRL_ENCLR_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	FLASHCTRL_ENCLR_RESERVED_Msk = 0x8000000
	// Bit RESERVED.
	FLASHCTRL_ENCLR_RESERVED = 0x8000000
	// Position of PROG1_CLR_EN field.
	FLASHCTRL_ENCLR_PROG1_CLR_EN_Pos = 0x1c
	// Bit mask of PROG1_CLR_EN field.
	FLASHCTRL_ENCLR_PROG1_CLR_EN_Msk = 0x10000000
	// Bit PROG1_CLR_EN.
	FLASHCTRL_ENCLR_PROG1_CLR_EN = 0x10000000
	// Position of RESERVED field.
	FLASHCTRL_ENCLR_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	FLASHCTRL_ENCLR_RESERVED_Msk = 0xe0000000

	// ENSET: EEPROM interrupt enable set
	// Position of RESERVED field.
	FLASHCTRL_ENSET_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_ENSET_RESERVED_Msk = 0x3ffffff
	// Position of RDWR_SET_EN field.
	FLASHCTRL_ENSET_RDWR_SET_EN_Pos = 0x1a
	// Bit mask of RDWR_SET_EN field.
	FLASHCTRL_ENSET_RDWR_SET_EN_Msk = 0x4000000
	// Bit RDWR_SET_EN.
	FLASHCTRL_ENSET_RDWR_SET_EN = 0x4000000
	// Position of RESERVED field.
	FLASHCTRL_ENSET_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	FLASHCTRL_ENSET_RESERVED_Msk = 0x8000000
	// Bit RESERVED.
	FLASHCTRL_ENSET_RESERVED = 0x8000000
	// Position of PROG1_SET_EN field.
	FLASHCTRL_ENSET_PROG1_SET_EN_Pos = 0x1c
	// Bit mask of PROG1_SET_EN field.
	FLASHCTRL_ENSET_PROG1_SET_EN_Msk = 0x10000000
	// Bit PROG1_SET_EN.
	FLASHCTRL_ENSET_PROG1_SET_EN = 0x10000000
	// Position of RESERVED field.
	FLASHCTRL_ENSET_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	FLASHCTRL_ENSET_RESERVED_Msk = 0xe0000000

	// STAT: Signature generation status register
	// Position of RESERVED field.
	FLASHCTRL_STAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_STAT_RESERVED_Msk = 0x3
	// Position of SIG_DONE field.
	FLASHCTRL_STAT_SIG_DONE_Pos = 0x2
	// Bit mask of SIG_DONE field.
	FLASHCTRL_STAT_SIG_DONE_Msk = 0x4
	// Bit SIG_DONE.
	FLASHCTRL_STAT_SIG_DONE = 0x4
	// Position of RESERVED field.
	FLASHCTRL_STAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	FLASHCTRL_STAT_RESERVED_Msk = 0x3fffff8
	// Position of END_OF_RDWR field.
	FLASHCTRL_STAT_END_OF_RDWR_Pos = 0x1a
	// Bit mask of END_OF_RDWR field.
	FLASHCTRL_STAT_END_OF_RDWR_Msk = 0x4000000
	// Bit END_OF_RDWR.
	FLASHCTRL_STAT_END_OF_RDWR = 0x4000000
	// Position of RESERVED field.
	FLASHCTRL_STAT_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	FLASHCTRL_STAT_RESERVED_Msk = 0x8000000
	// Bit RESERVED.
	FLASHCTRL_STAT_RESERVED = 0x8000000
	// Position of END_OF_PROG1 field.
	FLASHCTRL_STAT_END_OF_PROG1_Pos = 0x1c
	// Bit mask of END_OF_PROG1 field.
	FLASHCTRL_STAT_END_OF_PROG1_Msk = 0x10000000
	// Bit END_OF_PROG1.
	FLASHCTRL_STAT_END_OF_PROG1 = 0x10000000
	// Position of RESERVED field.
	FLASHCTRL_STAT_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	FLASHCTRL_STAT_RESERVED_Msk = 0xe0000000

	// INTEN: EEPROM interrupt enable
	// Position of RESERVED field.
	FLASHCTRL_INTEN_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_INTEN_RESERVED_Msk = 0x3ffffff
	// Position of EE_RW_DONE field.
	FLASHCTRL_INTEN_EE_RW_DONE_Pos = 0x1a
	// Bit mask of EE_RW_DONE field.
	FLASHCTRL_INTEN_EE_RW_DONE_Msk = 0x4000000
	// Bit EE_RW_DONE.
	FLASHCTRL_INTEN_EE_RW_DONE = 0x4000000
	// Position of RESERVED field.
	FLASHCTRL_INTEN_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	FLASHCTRL_INTEN_RESERVED_Msk = 0x8000000
	// Bit RESERVED.
	FLASHCTRL_INTEN_RESERVED = 0x8000000
	// Position of EE_PROG_DONE field.
	FLASHCTRL_INTEN_EE_PROG_DONE_Pos = 0x1c
	// Bit mask of EE_PROG_DONE field.
	FLASHCTRL_INTEN_EE_PROG_DONE_Msk = 0x10000000
	// Bit EE_PROG_DONE.
	FLASHCTRL_INTEN_EE_PROG_DONE = 0x10000000
	// Position of RESERVED field.
	FLASHCTRL_INTEN_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	FLASHCTRL_INTEN_RESERVED_Msk = 0xe0000000

	// STATCLR: Signature generation status clear register
	// Position of RESERVED field.
	FLASHCTRL_STATCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	FLASHCTRL_STATCLR_RESERVED_Msk = 0x3
	// Position of SIG_DONE_CLR field.
	FLASHCTRL_STATCLR_SIG_DONE_CLR_Pos = 0x2
	// Bit mask of SIG_DONE_CLR field.
	FLASHCTRL_STATCLR_SIG_DONE_CLR_Msk = 0x4
	// Bit SIG_DONE_CLR.
	FLASHCTRL_STATCLR_SIG_DONE_CLR = 0x4
	// Position of RESERVED field.
	FLASHCTRL_STATCLR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	FLASHCTRL_STATCLR_RESERVED_Msk = 0x3fffff8
	// Position of RDWR_CLR_ST field.
	FLASHCTRL_STATCLR_RDWR_CLR_ST_Pos = 0x1a
	// Bit mask of RDWR_CLR_ST field.
	FLASHCTRL_STATCLR_RDWR_CLR_ST_Msk = 0x4000000
	// Bit RDWR_CLR_ST.
	FLASHCTRL_STATCLR_RDWR_CLR_ST = 0x4000000
	// Position of RESERVED field.
	FLASHCTRL_STATCLR_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	FLASHCTRL_STATCLR_RESERVED_Msk = 0x8000000
	// Bit RESERVED.
	FLASHCTRL_STATCLR_RESERVED = 0x8000000
	// Position of PROG1_CLR_ST field.
	FLASHCTRL_STATCLR_PROG1_CLR_ST_Pos = 0x1c
	// Bit mask of PROG1_CLR_ST field.
	FLASHCTRL_STATCLR_PROG1_CLR_ST_Msk = 0x10000000
	// Bit PROG1_CLR_ST.
	FLASHCTRL_STATCLR_PROG1_CLR_ST = 0x10000000
	// Position of RESERVED field.
	FLASHCTRL_STATCLR_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	FLASHCTRL_STATCLR_RESERVED_Msk = 0xe0000000
)

// Bitfields for GPDMA: General purpose DMA controller
const (
	// INTSTAT: DMA Interrupt Status Register
	// Position of INTSTAT0 field.
	GPDMA_INTSTAT_INTSTAT0_Pos = 0x0
	// Bit mask of INTSTAT0 field.
	GPDMA_INTSTAT_INTSTAT0_Msk = 0x1
	// Bit INTSTAT0.
	GPDMA_INTSTAT_INTSTAT0 = 0x1
	// Position of INTSTAT1 field.
	GPDMA_INTSTAT_INTSTAT1_Pos = 0x1
	// Bit mask of INTSTAT1 field.
	GPDMA_INTSTAT_INTSTAT1_Msk = 0x2
	// Bit INTSTAT1.
	GPDMA_INTSTAT_INTSTAT1 = 0x2
	// Position of INTSTAT2 field.
	GPDMA_INTSTAT_INTSTAT2_Pos = 0x2
	// Bit mask of INTSTAT2 field.
	GPDMA_INTSTAT_INTSTAT2_Msk = 0x4
	// Bit INTSTAT2.
	GPDMA_INTSTAT_INTSTAT2 = 0x4
	// Position of INTSTAT3 field.
	GPDMA_INTSTAT_INTSTAT3_Pos = 0x3
	// Bit mask of INTSTAT3 field.
	GPDMA_INTSTAT_INTSTAT3_Msk = 0x8
	// Bit INTSTAT3.
	GPDMA_INTSTAT_INTSTAT3 = 0x8
	// Position of INTSTAT4 field.
	GPDMA_INTSTAT_INTSTAT4_Pos = 0x4
	// Bit mask of INTSTAT4 field.
	GPDMA_INTSTAT_INTSTAT4_Msk = 0x10
	// Bit INTSTAT4.
	GPDMA_INTSTAT_INTSTAT4 = 0x10
	// Position of INTSTAT5 field.
	GPDMA_INTSTAT_INTSTAT5_Pos = 0x5
	// Bit mask of INTSTAT5 field.
	GPDMA_INTSTAT_INTSTAT5_Msk = 0x20
	// Bit INTSTAT5.
	GPDMA_INTSTAT_INTSTAT5 = 0x20
	// Position of INTSTAT6 field.
	GPDMA_INTSTAT_INTSTAT6_Pos = 0x6
	// Bit mask of INTSTAT6 field.
	GPDMA_INTSTAT_INTSTAT6_Msk = 0x40
	// Bit INTSTAT6.
	GPDMA_INTSTAT_INTSTAT6 = 0x40
	// Position of INTSTAT7 field.
	GPDMA_INTSTAT_INTSTAT7_Pos = 0x7
	// Bit mask of INTSTAT7 field.
	GPDMA_INTSTAT_INTSTAT7_Msk = 0x80
	// Bit INTSTAT7.
	GPDMA_INTSTAT_INTSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTSTAT_RESERVED_Msk = 0xffffff00

	// INTTCSTAT: DMA Interrupt Terminal Count Request Status Register
	// Position of INTTCSTAT0 field.
	GPDMA_INTTCSTAT_INTTCSTAT0_Pos = 0x0
	// Bit mask of INTTCSTAT0 field.
	GPDMA_INTTCSTAT_INTTCSTAT0_Msk = 0x1
	// Bit INTTCSTAT0.
	GPDMA_INTTCSTAT_INTTCSTAT0 = 0x1
	// Position of INTTCSTAT1 field.
	GPDMA_INTTCSTAT_INTTCSTAT1_Pos = 0x1
	// Bit mask of INTTCSTAT1 field.
	GPDMA_INTTCSTAT_INTTCSTAT1_Msk = 0x2
	// Bit INTTCSTAT1.
	GPDMA_INTTCSTAT_INTTCSTAT1 = 0x2
	// Position of INTTCSTAT2 field.
	GPDMA_INTTCSTAT_INTTCSTAT2_Pos = 0x2
	// Bit mask of INTTCSTAT2 field.
	GPDMA_INTTCSTAT_INTTCSTAT2_Msk = 0x4
	// Bit INTTCSTAT2.
	GPDMA_INTTCSTAT_INTTCSTAT2 = 0x4
	// Position of INTTCSTAT3 field.
	GPDMA_INTTCSTAT_INTTCSTAT3_Pos = 0x3
	// Bit mask of INTTCSTAT3 field.
	GPDMA_INTTCSTAT_INTTCSTAT3_Msk = 0x8
	// Bit INTTCSTAT3.
	GPDMA_INTTCSTAT_INTTCSTAT3 = 0x8
	// Position of INTTCSTAT4 field.
	GPDMA_INTTCSTAT_INTTCSTAT4_Pos = 0x4
	// Bit mask of INTTCSTAT4 field.
	GPDMA_INTTCSTAT_INTTCSTAT4_Msk = 0x10
	// Bit INTTCSTAT4.
	GPDMA_INTTCSTAT_INTTCSTAT4 = 0x10
	// Position of INTTCSTAT5 field.
	GPDMA_INTTCSTAT_INTTCSTAT5_Pos = 0x5
	// Bit mask of INTTCSTAT5 field.
	GPDMA_INTTCSTAT_INTTCSTAT5_Msk = 0x20
	// Bit INTTCSTAT5.
	GPDMA_INTTCSTAT_INTTCSTAT5 = 0x20
	// Position of INTTCSTAT6 field.
	GPDMA_INTTCSTAT_INTTCSTAT6_Pos = 0x6
	// Bit mask of INTTCSTAT6 field.
	GPDMA_INTTCSTAT_INTTCSTAT6_Msk = 0x40
	// Bit INTTCSTAT6.
	GPDMA_INTTCSTAT_INTTCSTAT6 = 0x40
	// Position of INTTCSTAT7 field.
	GPDMA_INTTCSTAT_INTTCSTAT7_Pos = 0x7
	// Bit mask of INTTCSTAT7 field.
	GPDMA_INTTCSTAT_INTTCSTAT7_Msk = 0x80
	// Bit INTTCSTAT7.
	GPDMA_INTTCSTAT_INTTCSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTTCSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTTCSTAT_RESERVED_Msk = 0xffffff00

	// INTTCCLEAR: DMA Interrupt Terminal Count Request Clear Register
	// Position of INTTCCLEAR0 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos = 0x0
	// Bit mask of INTTCCLEAR0 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR0_Msk = 0x1
	// Bit INTTCCLEAR0.
	GPDMA_INTTCCLEAR_INTTCCLEAR0 = 0x1
	// Position of INTTCCLEAR1 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos = 0x1
	// Bit mask of INTTCCLEAR1 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR1_Msk = 0x2
	// Bit INTTCCLEAR1.
	GPDMA_INTTCCLEAR_INTTCCLEAR1 = 0x2
	// Position of INTTCCLEAR2 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos = 0x2
	// Bit mask of INTTCCLEAR2 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR2_Msk = 0x4
	// Bit INTTCCLEAR2.
	GPDMA_INTTCCLEAR_INTTCCLEAR2 = 0x4
	// Position of INTTCCLEAR3 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos = 0x3
	// Bit mask of INTTCCLEAR3 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR3_Msk = 0x8
	// Bit INTTCCLEAR3.
	GPDMA_INTTCCLEAR_INTTCCLEAR3 = 0x8
	// Position of INTTCCLEAR4 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos = 0x4
	// Bit mask of INTTCCLEAR4 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR4_Msk = 0x10
	// Bit INTTCCLEAR4.
	GPDMA_INTTCCLEAR_INTTCCLEAR4 = 0x10
	// Position of INTTCCLEAR5 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos = 0x5
	// Bit mask of INTTCCLEAR5 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR5_Msk = 0x20
	// Bit INTTCCLEAR5.
	GPDMA_INTTCCLEAR_INTTCCLEAR5 = 0x20
	// Position of INTTCCLEAR6 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos = 0x6
	// Bit mask of INTTCCLEAR6 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR6_Msk = 0x40
	// Bit INTTCCLEAR6.
	GPDMA_INTTCCLEAR_INTTCCLEAR6 = 0x40
	// Position of INTTCCLEAR7 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos = 0x7
	// Bit mask of INTTCCLEAR7 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR7_Msk = 0x80
	// Bit INTTCCLEAR7.
	GPDMA_INTTCCLEAR_INTTCCLEAR7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTTCCLEAR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTTCCLEAR_RESERVED_Msk = 0xffffff00

	// INTERRSTAT: DMA Interrupt Error Status Register
	// Position of INTERRSTAT0 field.
	GPDMA_INTERRSTAT_INTERRSTAT0_Pos = 0x0
	// Bit mask of INTERRSTAT0 field.
	GPDMA_INTERRSTAT_INTERRSTAT0_Msk = 0x1
	// Bit INTERRSTAT0.
	GPDMA_INTERRSTAT_INTERRSTAT0 = 0x1
	// Position of INTERRSTAT1 field.
	GPDMA_INTERRSTAT_INTERRSTAT1_Pos = 0x1
	// Bit mask of INTERRSTAT1 field.
	GPDMA_INTERRSTAT_INTERRSTAT1_Msk = 0x2
	// Bit INTERRSTAT1.
	GPDMA_INTERRSTAT_INTERRSTAT1 = 0x2
	// Position of INTERRSTAT2 field.
	GPDMA_INTERRSTAT_INTERRSTAT2_Pos = 0x2
	// Bit mask of INTERRSTAT2 field.
	GPDMA_INTERRSTAT_INTERRSTAT2_Msk = 0x4
	// Bit INTERRSTAT2.
	GPDMA_INTERRSTAT_INTERRSTAT2 = 0x4
	// Position of INTERRSTAT3 field.
	GPDMA_INTERRSTAT_INTERRSTAT3_Pos = 0x3
	// Bit mask of INTERRSTAT3 field.
	GPDMA_INTERRSTAT_INTERRSTAT3_Msk = 0x8
	// Bit INTERRSTAT3.
	GPDMA_INTERRSTAT_INTERRSTAT3 = 0x8
	// Position of INTERRSTAT4 field.
	GPDMA_INTERRSTAT_INTERRSTAT4_Pos = 0x4
	// Bit mask of INTERRSTAT4 field.
	GPDMA_INTERRSTAT_INTERRSTAT4_Msk = 0x10
	// Bit INTERRSTAT4.
	GPDMA_INTERRSTAT_INTERRSTAT4 = 0x10
	// Position of INTERRSTAT5 field.
	GPDMA_INTERRSTAT_INTERRSTAT5_Pos = 0x5
	// Bit mask of INTERRSTAT5 field.
	GPDMA_INTERRSTAT_INTERRSTAT5_Msk = 0x20
	// Bit INTERRSTAT5.
	GPDMA_INTERRSTAT_INTERRSTAT5 = 0x20
	// Position of INTERRSTAT6 field.
	GPDMA_INTERRSTAT_INTERRSTAT6_Pos = 0x6
	// Bit mask of INTERRSTAT6 field.
	GPDMA_INTERRSTAT_INTERRSTAT6_Msk = 0x40
	// Bit INTERRSTAT6.
	GPDMA_INTERRSTAT_INTERRSTAT6 = 0x40
	// Position of INTERRSTAT7 field.
	GPDMA_INTERRSTAT_INTERRSTAT7_Pos = 0x7
	// Bit mask of INTERRSTAT7 field.
	GPDMA_INTERRSTAT_INTERRSTAT7_Msk = 0x80
	// Bit INTERRSTAT7.
	GPDMA_INTERRSTAT_INTERRSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTERRSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTERRSTAT_RESERVED_Msk = 0xffffff00

	// INTERRCLR: DMA Interrupt Error Clear Register
	// Position of INTERRCLR0 field.
	GPDMA_INTERRCLR_INTERRCLR0_Pos = 0x0
	// Bit mask of INTERRCLR0 field.
	GPDMA_INTERRCLR_INTERRCLR0_Msk = 0x1
	// Bit INTERRCLR0.
	GPDMA_INTERRCLR_INTERRCLR0 = 0x1
	// Position of INTERRCLR1 field.
	GPDMA_INTERRCLR_INTERRCLR1_Pos = 0x1
	// Bit mask of INTERRCLR1 field.
	GPDMA_INTERRCLR_INTERRCLR1_Msk = 0x2
	// Bit INTERRCLR1.
	GPDMA_INTERRCLR_INTERRCLR1 = 0x2
	// Position of INTERRCLR2 field.
	GPDMA_INTERRCLR_INTERRCLR2_Pos = 0x2
	// Bit mask of INTERRCLR2 field.
	GPDMA_INTERRCLR_INTERRCLR2_Msk = 0x4
	// Bit INTERRCLR2.
	GPDMA_INTERRCLR_INTERRCLR2 = 0x4
	// Position of INTERRCLR3 field.
	GPDMA_INTERRCLR_INTERRCLR3_Pos = 0x3
	// Bit mask of INTERRCLR3 field.
	GPDMA_INTERRCLR_INTERRCLR3_Msk = 0x8
	// Bit INTERRCLR3.
	GPDMA_INTERRCLR_INTERRCLR3 = 0x8
	// Position of INTERRCLR4 field.
	GPDMA_INTERRCLR_INTERRCLR4_Pos = 0x4
	// Bit mask of INTERRCLR4 field.
	GPDMA_INTERRCLR_INTERRCLR4_Msk = 0x10
	// Bit INTERRCLR4.
	GPDMA_INTERRCLR_INTERRCLR4 = 0x10
	// Position of INTERRCLR5 field.
	GPDMA_INTERRCLR_INTERRCLR5_Pos = 0x5
	// Bit mask of INTERRCLR5 field.
	GPDMA_INTERRCLR_INTERRCLR5_Msk = 0x20
	// Bit INTERRCLR5.
	GPDMA_INTERRCLR_INTERRCLR5 = 0x20
	// Position of INTERRCLR6 field.
	GPDMA_INTERRCLR_INTERRCLR6_Pos = 0x6
	// Bit mask of INTERRCLR6 field.
	GPDMA_INTERRCLR_INTERRCLR6_Msk = 0x40
	// Bit INTERRCLR6.
	GPDMA_INTERRCLR_INTERRCLR6 = 0x40
	// Position of INTERRCLR7 field.
	GPDMA_INTERRCLR_INTERRCLR7_Pos = 0x7
	// Bit mask of INTERRCLR7 field.
	GPDMA_INTERRCLR_INTERRCLR7_Msk = 0x80
	// Bit INTERRCLR7.
	GPDMA_INTERRCLR_INTERRCLR7 = 0x80
	// Position of RESERVED field.
	GPDMA_INTERRCLR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_INTERRCLR_RESERVED_Msk = 0xffffff00

	// RAWINTTCSTAT: DMA Raw Interrupt Terminal Count Status Register
	// Position of RAWINTTCSTAT0 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos = 0x0
	// Bit mask of RAWINTTCSTAT0 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Msk = 0x1
	// Bit RAWINTTCSTAT0.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0 = 0x1
	// Position of RAWINTTCSTAT1 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos = 0x1
	// Bit mask of RAWINTTCSTAT1 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Msk = 0x2
	// Bit RAWINTTCSTAT1.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1 = 0x2
	// Position of RAWINTTCSTAT2 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos = 0x2
	// Bit mask of RAWINTTCSTAT2 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Msk = 0x4
	// Bit RAWINTTCSTAT2.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2 = 0x4
	// Position of RAWINTTCSTAT3 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos = 0x3
	// Bit mask of RAWINTTCSTAT3 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Msk = 0x8
	// Bit RAWINTTCSTAT3.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3 = 0x8
	// Position of RAWINTTCSTAT4 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos = 0x4
	// Bit mask of RAWINTTCSTAT4 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Msk = 0x10
	// Bit RAWINTTCSTAT4.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4 = 0x10
	// Position of RAWINTTCSTAT5 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos = 0x5
	// Bit mask of RAWINTTCSTAT5 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Msk = 0x20
	// Bit RAWINTTCSTAT5.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5 = 0x20
	// Position of RAWINTTCSTAT6 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos = 0x6
	// Bit mask of RAWINTTCSTAT6 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Msk = 0x40
	// Bit RAWINTTCSTAT6.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6 = 0x40
	// Position of RAWINTTCSTAT7 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos = 0x7
	// Bit mask of RAWINTTCSTAT7 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Msk = 0x80
	// Bit RAWINTTCSTAT7.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_RAWINTTCSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_RAWINTTCSTAT_RESERVED_Msk = 0xffffff00

	// RAWINTERRSTAT: DMA Raw Error Interrupt Status Register
	// Position of RAWINTERRSTAT0 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos = 0x0
	// Bit mask of RAWINTERRSTAT0 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Msk = 0x1
	// Bit RAWINTERRSTAT0.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0 = 0x1
	// Position of RAWINTERRSTAT1 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos = 0x1
	// Bit mask of RAWINTERRSTAT1 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Msk = 0x2
	// Bit RAWINTERRSTAT1.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1 = 0x2
	// Position of RAWINTERRSTAT2 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos = 0x2
	// Bit mask of RAWINTERRSTAT2 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Msk = 0x4
	// Bit RAWINTERRSTAT2.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2 = 0x4
	// Position of RAWINTERRSTAT3 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos = 0x3
	// Bit mask of RAWINTERRSTAT3 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Msk = 0x8
	// Bit RAWINTERRSTAT3.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3 = 0x8
	// Position of RAWINTERRSTAT4 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos = 0x4
	// Bit mask of RAWINTERRSTAT4 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Msk = 0x10
	// Bit RAWINTERRSTAT4.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4 = 0x10
	// Position of RAWINTERRSTAT5 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos = 0x5
	// Bit mask of RAWINTERRSTAT5 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Msk = 0x20
	// Bit RAWINTERRSTAT5.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5 = 0x20
	// Position of RAWINTERRSTAT6 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos = 0x6
	// Bit mask of RAWINTERRSTAT6 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Msk = 0x40
	// Bit RAWINTERRSTAT6.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6 = 0x40
	// Position of RAWINTERRSTAT7 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos = 0x7
	// Bit mask of RAWINTERRSTAT7 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Msk = 0x80
	// Bit RAWINTERRSTAT7.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7 = 0x80
	// Position of RESERVED field.
	GPDMA_RAWINTERRSTAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_RAWINTERRSTAT_RESERVED_Msk = 0xffffff00

	// ENBLDCHNS: DMA Enabled Channel Register
	// Position of ENABLEDCHANNELS0 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos = 0x0
	// Bit mask of ENABLEDCHANNELS0 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Msk = 0x1
	// Bit ENABLEDCHANNELS0.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0 = 0x1
	// Position of ENABLEDCHANNELS1 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos = 0x1
	// Bit mask of ENABLEDCHANNELS1 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Msk = 0x2
	// Bit ENABLEDCHANNELS1.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1 = 0x2
	// Position of ENABLEDCHANNELS2 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos = 0x2
	// Bit mask of ENABLEDCHANNELS2 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Msk = 0x4
	// Bit ENABLEDCHANNELS2.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2 = 0x4
	// Position of ENABLEDCHANNELS3 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos = 0x3
	// Bit mask of ENABLEDCHANNELS3 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Msk = 0x8
	// Bit ENABLEDCHANNELS3.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3 = 0x8
	// Position of ENABLEDCHANNELS4 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos = 0x4
	// Bit mask of ENABLEDCHANNELS4 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Msk = 0x10
	// Bit ENABLEDCHANNELS4.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4 = 0x10
	// Position of ENABLEDCHANNELS5 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos = 0x5
	// Bit mask of ENABLEDCHANNELS5 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Msk = 0x20
	// Bit ENABLEDCHANNELS5.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5 = 0x20
	// Position of ENABLEDCHANNELS6 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos = 0x6
	// Bit mask of ENABLEDCHANNELS6 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Msk = 0x40
	// Bit ENABLEDCHANNELS6.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6 = 0x40
	// Position of ENABLEDCHANNELS7 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos = 0x7
	// Bit mask of ENABLEDCHANNELS7 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Msk = 0x80
	// Bit ENABLEDCHANNELS7.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7 = 0x80
	// Position of RESERVED field.
	GPDMA_ENBLDCHNS_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	GPDMA_ENBLDCHNS_RESERVED_Msk = 0xffffff00

	// SOFTBREQ: DMA Software Burst Request Register
	// Position of SOFTBREQ0 field.
	GPDMA_SOFTBREQ_SOFTBREQ0_Pos = 0x0
	// Bit mask of SOFTBREQ0 field.
	GPDMA_SOFTBREQ_SOFTBREQ0_Msk = 0x1
	// Bit SOFTBREQ0.
	GPDMA_SOFTBREQ_SOFTBREQ0 = 0x1
	// Position of SOFTBREQ1 field.
	GPDMA_SOFTBREQ_SOFTBREQ1_Pos = 0x1
	// Bit mask of SOFTBREQ1 field.
	GPDMA_SOFTBREQ_SOFTBREQ1_Msk = 0x2
	// Bit SOFTBREQ1.
	GPDMA_SOFTBREQ_SOFTBREQ1 = 0x2
	// Position of SOFTBREQ2 field.
	GPDMA_SOFTBREQ_SOFTBREQ2_Pos = 0x2
	// Bit mask of SOFTBREQ2 field.
	GPDMA_SOFTBREQ_SOFTBREQ2_Msk = 0x4
	// Bit SOFTBREQ2.
	GPDMA_SOFTBREQ_SOFTBREQ2 = 0x4
	// Position of SOFTBREQ3 field.
	GPDMA_SOFTBREQ_SOFTBREQ3_Pos = 0x3
	// Bit mask of SOFTBREQ3 field.
	GPDMA_SOFTBREQ_SOFTBREQ3_Msk = 0x8
	// Bit SOFTBREQ3.
	GPDMA_SOFTBREQ_SOFTBREQ3 = 0x8
	// Position of SOFTBREQ4 field.
	GPDMA_SOFTBREQ_SOFTBREQ4_Pos = 0x4
	// Bit mask of SOFTBREQ4 field.
	GPDMA_SOFTBREQ_SOFTBREQ4_Msk = 0x10
	// Bit SOFTBREQ4.
	GPDMA_SOFTBREQ_SOFTBREQ4 = 0x10
	// Position of SOFTBREQ5 field.
	GPDMA_SOFTBREQ_SOFTBREQ5_Pos = 0x5
	// Bit mask of SOFTBREQ5 field.
	GPDMA_SOFTBREQ_SOFTBREQ5_Msk = 0x20
	// Bit SOFTBREQ5.
	GPDMA_SOFTBREQ_SOFTBREQ5 = 0x20
	// Position of SOFTBREQ6 field.
	GPDMA_SOFTBREQ_SOFTBREQ6_Pos = 0x6
	// Bit mask of SOFTBREQ6 field.
	GPDMA_SOFTBREQ_SOFTBREQ6_Msk = 0x40
	// Bit SOFTBREQ6.
	GPDMA_SOFTBREQ_SOFTBREQ6 = 0x40
	// Position of SOFTBREQ7 field.
	GPDMA_SOFTBREQ_SOFTBREQ7_Pos = 0x7
	// Bit mask of SOFTBREQ7 field.
	GPDMA_SOFTBREQ_SOFTBREQ7_Msk = 0x80
	// Bit SOFTBREQ7.
	GPDMA_SOFTBREQ_SOFTBREQ7 = 0x80
	// Position of SOFTBREQ8 field.
	GPDMA_SOFTBREQ_SOFTBREQ8_Pos = 0x8
	// Bit mask of SOFTBREQ8 field.
	GPDMA_SOFTBREQ_SOFTBREQ8_Msk = 0x100
	// Bit SOFTBREQ8.
	GPDMA_SOFTBREQ_SOFTBREQ8 = 0x100
	// Position of SOFTBREQ9 field.
	GPDMA_SOFTBREQ_SOFTBREQ9_Pos = 0x9
	// Bit mask of SOFTBREQ9 field.
	GPDMA_SOFTBREQ_SOFTBREQ9_Msk = 0x200
	// Bit SOFTBREQ9.
	GPDMA_SOFTBREQ_SOFTBREQ9 = 0x200
	// Position of SOFTBREQ10 field.
	GPDMA_SOFTBREQ_SOFTBREQ10_Pos = 0xa
	// Bit mask of SOFTBREQ10 field.
	GPDMA_SOFTBREQ_SOFTBREQ10_Msk = 0x400
	// Bit SOFTBREQ10.
	GPDMA_SOFTBREQ_SOFTBREQ10 = 0x400
	// Position of SOFTBREQ11 field.
	GPDMA_SOFTBREQ_SOFTBREQ11_Pos = 0xb
	// Bit mask of SOFTBREQ11 field.
	GPDMA_SOFTBREQ_SOFTBREQ11_Msk = 0x800
	// Bit SOFTBREQ11.
	GPDMA_SOFTBREQ_SOFTBREQ11 = 0x800
	// Position of SOFTBREQ12 field.
	GPDMA_SOFTBREQ_SOFTBREQ12_Pos = 0xc
	// Bit mask of SOFTBREQ12 field.
	GPDMA_SOFTBREQ_SOFTBREQ12_Msk = 0x1000
	// Bit SOFTBREQ12.
	GPDMA_SOFTBREQ_SOFTBREQ12 = 0x1000
	// Position of SOFTBREQ13 field.
	GPDMA_SOFTBREQ_SOFTBREQ13_Pos = 0xd
	// Bit mask of SOFTBREQ13 field.
	GPDMA_SOFTBREQ_SOFTBREQ13_Msk = 0x2000
	// Bit SOFTBREQ13.
	GPDMA_SOFTBREQ_SOFTBREQ13 = 0x2000
	// Position of SOFTBREQ14 field.
	GPDMA_SOFTBREQ_SOFTBREQ14_Pos = 0xe
	// Bit mask of SOFTBREQ14 field.
	GPDMA_SOFTBREQ_SOFTBREQ14_Msk = 0x4000
	// Bit SOFTBREQ14.
	GPDMA_SOFTBREQ_SOFTBREQ14 = 0x4000
	// Position of SOFTBREQ15 field.
	GPDMA_SOFTBREQ_SOFTBREQ15_Pos = 0xf
	// Bit mask of SOFTBREQ15 field.
	GPDMA_SOFTBREQ_SOFTBREQ15_Msk = 0x8000
	// Bit SOFTBREQ15.
	GPDMA_SOFTBREQ_SOFTBREQ15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SOFTBREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SOFTBREQ_RESERVED_Msk = 0xffff0000

	// SOFTSREQ: DMA Software Single Request Register
	// Position of SOFTSREQ0 field.
	GPDMA_SOFTSREQ_SOFTSREQ0_Pos = 0x0
	// Bit mask of SOFTSREQ0 field.
	GPDMA_SOFTSREQ_SOFTSREQ0_Msk = 0x1
	// Bit SOFTSREQ0.
	GPDMA_SOFTSREQ_SOFTSREQ0 = 0x1
	// Position of SOFTSREQ1 field.
	GPDMA_SOFTSREQ_SOFTSREQ1_Pos = 0x1
	// Bit mask of SOFTSREQ1 field.
	GPDMA_SOFTSREQ_SOFTSREQ1_Msk = 0x2
	// Bit SOFTSREQ1.
	GPDMA_SOFTSREQ_SOFTSREQ1 = 0x2
	// Position of SOFTSREQ2 field.
	GPDMA_SOFTSREQ_SOFTSREQ2_Pos = 0x2
	// Bit mask of SOFTSREQ2 field.
	GPDMA_SOFTSREQ_SOFTSREQ2_Msk = 0x4
	// Bit SOFTSREQ2.
	GPDMA_SOFTSREQ_SOFTSREQ2 = 0x4
	// Position of SOFTSREQ3 field.
	GPDMA_SOFTSREQ_SOFTSREQ3_Pos = 0x3
	// Bit mask of SOFTSREQ3 field.
	GPDMA_SOFTSREQ_SOFTSREQ3_Msk = 0x8
	// Bit SOFTSREQ3.
	GPDMA_SOFTSREQ_SOFTSREQ3 = 0x8
	// Position of SOFTSREQ4 field.
	GPDMA_SOFTSREQ_SOFTSREQ4_Pos = 0x4
	// Bit mask of SOFTSREQ4 field.
	GPDMA_SOFTSREQ_SOFTSREQ4_Msk = 0x10
	// Bit SOFTSREQ4.
	GPDMA_SOFTSREQ_SOFTSREQ4 = 0x10
	// Position of SOFTSREQ5 field.
	GPDMA_SOFTSREQ_SOFTSREQ5_Pos = 0x5
	// Bit mask of SOFTSREQ5 field.
	GPDMA_SOFTSREQ_SOFTSREQ5_Msk = 0x20
	// Bit SOFTSREQ5.
	GPDMA_SOFTSREQ_SOFTSREQ5 = 0x20
	// Position of SOFTSREQ6 field.
	GPDMA_SOFTSREQ_SOFTSREQ6_Pos = 0x6
	// Bit mask of SOFTSREQ6 field.
	GPDMA_SOFTSREQ_SOFTSREQ6_Msk = 0x40
	// Bit SOFTSREQ6.
	GPDMA_SOFTSREQ_SOFTSREQ6 = 0x40
	// Position of SOFTSREQ7 field.
	GPDMA_SOFTSREQ_SOFTSREQ7_Pos = 0x7
	// Bit mask of SOFTSREQ7 field.
	GPDMA_SOFTSREQ_SOFTSREQ7_Msk = 0x80
	// Bit SOFTSREQ7.
	GPDMA_SOFTSREQ_SOFTSREQ7 = 0x80
	// Position of SOFTSREQ8 field.
	GPDMA_SOFTSREQ_SOFTSREQ8_Pos = 0x8
	// Bit mask of SOFTSREQ8 field.
	GPDMA_SOFTSREQ_SOFTSREQ8_Msk = 0x100
	// Bit SOFTSREQ8.
	GPDMA_SOFTSREQ_SOFTSREQ8 = 0x100
	// Position of SOFTSREQ9 field.
	GPDMA_SOFTSREQ_SOFTSREQ9_Pos = 0x9
	// Bit mask of SOFTSREQ9 field.
	GPDMA_SOFTSREQ_SOFTSREQ9_Msk = 0x200
	// Bit SOFTSREQ9.
	GPDMA_SOFTSREQ_SOFTSREQ9 = 0x200
	// Position of SOFTSREQ10 field.
	GPDMA_SOFTSREQ_SOFTSREQ10_Pos = 0xa
	// Bit mask of SOFTSREQ10 field.
	GPDMA_SOFTSREQ_SOFTSREQ10_Msk = 0x400
	// Bit SOFTSREQ10.
	GPDMA_SOFTSREQ_SOFTSREQ10 = 0x400
	// Position of SOFTSREQ11 field.
	GPDMA_SOFTSREQ_SOFTSREQ11_Pos = 0xb
	// Bit mask of SOFTSREQ11 field.
	GPDMA_SOFTSREQ_SOFTSREQ11_Msk = 0x800
	// Bit SOFTSREQ11.
	GPDMA_SOFTSREQ_SOFTSREQ11 = 0x800
	// Position of SOFTSREQ12 field.
	GPDMA_SOFTSREQ_SOFTSREQ12_Pos = 0xc
	// Bit mask of SOFTSREQ12 field.
	GPDMA_SOFTSREQ_SOFTSREQ12_Msk = 0x1000
	// Bit SOFTSREQ12.
	GPDMA_SOFTSREQ_SOFTSREQ12 = 0x1000
	// Position of SOFTSREQ13 field.
	GPDMA_SOFTSREQ_SOFTSREQ13_Pos = 0xd
	// Bit mask of SOFTSREQ13 field.
	GPDMA_SOFTSREQ_SOFTSREQ13_Msk = 0x2000
	// Bit SOFTSREQ13.
	GPDMA_SOFTSREQ_SOFTSREQ13 = 0x2000
	// Position of SOFTSREQ14 field.
	GPDMA_SOFTSREQ_SOFTSREQ14_Pos = 0xe
	// Bit mask of SOFTSREQ14 field.
	GPDMA_SOFTSREQ_SOFTSREQ14_Msk = 0x4000
	// Bit SOFTSREQ14.
	GPDMA_SOFTSREQ_SOFTSREQ14 = 0x4000
	// Position of SOFTSREQ15 field.
	GPDMA_SOFTSREQ_SOFTSREQ15_Pos = 0xf
	// Bit mask of SOFTSREQ15 field.
	GPDMA_SOFTSREQ_SOFTSREQ15_Msk = 0x8000
	// Bit SOFTSREQ15.
	GPDMA_SOFTSREQ_SOFTSREQ15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SOFTSREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SOFTSREQ_RESERVED_Msk = 0xffff0000

	// SOFTLBREQ: DMA Software Last Burst Request Register
	// Position of SOFTLBREQ0 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos = 0x0
	// Bit mask of SOFTLBREQ0 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ0_Msk = 0x1
	// Bit SOFTLBREQ0.
	GPDMA_SOFTLBREQ_SOFTLBREQ0 = 0x1
	// Position of SOFTLBREQ1 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos = 0x1
	// Bit mask of SOFTLBREQ1 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ1_Msk = 0x2
	// Bit SOFTLBREQ1.
	GPDMA_SOFTLBREQ_SOFTLBREQ1 = 0x2
	// Position of SOFTLBREQ2 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos = 0x2
	// Bit mask of SOFTLBREQ2 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ2_Msk = 0x4
	// Bit SOFTLBREQ2.
	GPDMA_SOFTLBREQ_SOFTLBREQ2 = 0x4
	// Position of SOFTLBREQ3 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos = 0x3
	// Bit mask of SOFTLBREQ3 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ3_Msk = 0x8
	// Bit SOFTLBREQ3.
	GPDMA_SOFTLBREQ_SOFTLBREQ3 = 0x8
	// Position of SOFTLBREQ4 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos = 0x4
	// Bit mask of SOFTLBREQ4 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ4_Msk = 0x10
	// Bit SOFTLBREQ4.
	GPDMA_SOFTLBREQ_SOFTLBREQ4 = 0x10
	// Position of SOFTLBREQ5 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos = 0x5
	// Bit mask of SOFTLBREQ5 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ5_Msk = 0x20
	// Bit SOFTLBREQ5.
	GPDMA_SOFTLBREQ_SOFTLBREQ5 = 0x20
	// Position of SOFTLBREQ6 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos = 0x6
	// Bit mask of SOFTLBREQ6 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ6_Msk = 0x40
	// Bit SOFTLBREQ6.
	GPDMA_SOFTLBREQ_SOFTLBREQ6 = 0x40
	// Position of SOFTLBREQ7 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos = 0x7
	// Bit mask of SOFTLBREQ7 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ7_Msk = 0x80
	// Bit SOFTLBREQ7.
	GPDMA_SOFTLBREQ_SOFTLBREQ7 = 0x80
	// Position of SOFTLBREQ8 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos = 0x8
	// Bit mask of SOFTLBREQ8 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ8_Msk = 0x100
	// Bit SOFTLBREQ8.
	GPDMA_SOFTLBREQ_SOFTLBREQ8 = 0x100
	// Position of SOFTLBREQ9 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos = 0x9
	// Bit mask of SOFTLBREQ9 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ9_Msk = 0x200
	// Bit SOFTLBREQ9.
	GPDMA_SOFTLBREQ_SOFTLBREQ9 = 0x200
	// Position of SOFTLBREQ10 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos = 0xa
	// Bit mask of SOFTLBREQ10 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ10_Msk = 0x400
	// Bit SOFTLBREQ10.
	GPDMA_SOFTLBREQ_SOFTLBREQ10 = 0x400
	// Position of SOFTLBREQ11 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos = 0xb
	// Bit mask of SOFTLBREQ11 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ11_Msk = 0x800
	// Bit SOFTLBREQ11.
	GPDMA_SOFTLBREQ_SOFTLBREQ11 = 0x800
	// Position of SOFTLBREQ12 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos = 0xc
	// Bit mask of SOFTLBREQ12 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ12_Msk = 0x1000
	// Bit SOFTLBREQ12.
	GPDMA_SOFTLBREQ_SOFTLBREQ12 = 0x1000
	// Position of SOFTLBREQ13 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos = 0xd
	// Bit mask of SOFTLBREQ13 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ13_Msk = 0x2000
	// Bit SOFTLBREQ13.
	GPDMA_SOFTLBREQ_SOFTLBREQ13 = 0x2000
	// Position of SOFTLBREQ14 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos = 0xe
	// Bit mask of SOFTLBREQ14 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ14_Msk = 0x4000
	// Bit SOFTLBREQ14.
	GPDMA_SOFTLBREQ_SOFTLBREQ14 = 0x4000
	// Position of SOFTLBREQ15 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos = 0xf
	// Bit mask of SOFTLBREQ15 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ15_Msk = 0x8000
	// Bit SOFTLBREQ15.
	GPDMA_SOFTLBREQ_SOFTLBREQ15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SOFTLBREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SOFTLBREQ_RESERVED_Msk = 0xffff0000

	// SOFTLSREQ: DMA Software Last Single Request Register
	// Position of SOFTLSREQ0 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos = 0x0
	// Bit mask of SOFTLSREQ0 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ0_Msk = 0x1
	// Bit SOFTLSREQ0.
	GPDMA_SOFTLSREQ_SOFTLSREQ0 = 0x1
	// Position of SOFTLSREQ1 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos = 0x1
	// Bit mask of SOFTLSREQ1 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ1_Msk = 0x2
	// Bit SOFTLSREQ1.
	GPDMA_SOFTLSREQ_SOFTLSREQ1 = 0x2
	// Position of SOFTLSREQ2 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos = 0x2
	// Bit mask of SOFTLSREQ2 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ2_Msk = 0x4
	// Bit SOFTLSREQ2.
	GPDMA_SOFTLSREQ_SOFTLSREQ2 = 0x4
	// Position of SOFTLSREQ3 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos = 0x3
	// Bit mask of SOFTLSREQ3 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ3_Msk = 0x8
	// Bit SOFTLSREQ3.
	GPDMA_SOFTLSREQ_SOFTLSREQ3 = 0x8
	// Position of SOFTLSREQ4 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos = 0x4
	// Bit mask of SOFTLSREQ4 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ4_Msk = 0x10
	// Bit SOFTLSREQ4.
	GPDMA_SOFTLSREQ_SOFTLSREQ4 = 0x10
	// Position of SOFTLSREQ5 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos = 0x5
	// Bit mask of SOFTLSREQ5 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ5_Msk = 0x20
	// Bit SOFTLSREQ5.
	GPDMA_SOFTLSREQ_SOFTLSREQ5 = 0x20
	// Position of SOFTLSREQ6 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos = 0x6
	// Bit mask of SOFTLSREQ6 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ6_Msk = 0x40
	// Bit SOFTLSREQ6.
	GPDMA_SOFTLSREQ_SOFTLSREQ6 = 0x40
	// Position of SOFTLSREQ7 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos = 0x7
	// Bit mask of SOFTLSREQ7 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ7_Msk = 0x80
	// Bit SOFTLSREQ7.
	GPDMA_SOFTLSREQ_SOFTLSREQ7 = 0x80
	// Position of SOFTLSREQ8 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos = 0x8
	// Bit mask of SOFTLSREQ8 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ8_Msk = 0x100
	// Bit SOFTLSREQ8.
	GPDMA_SOFTLSREQ_SOFTLSREQ8 = 0x100
	// Position of SOFTLSREQ9 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos = 0x9
	// Bit mask of SOFTLSREQ9 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ9_Msk = 0x200
	// Bit SOFTLSREQ9.
	GPDMA_SOFTLSREQ_SOFTLSREQ9 = 0x200
	// Position of SOFTLSREQ10 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos = 0xa
	// Bit mask of SOFTLSREQ10 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ10_Msk = 0x400
	// Bit SOFTLSREQ10.
	GPDMA_SOFTLSREQ_SOFTLSREQ10 = 0x400
	// Position of SOFTLSREQ11 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos = 0xb
	// Bit mask of SOFTLSREQ11 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ11_Msk = 0x800
	// Bit SOFTLSREQ11.
	GPDMA_SOFTLSREQ_SOFTLSREQ11 = 0x800
	// Position of SOFTLSREQ12 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos = 0xc
	// Bit mask of SOFTLSREQ12 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ12_Msk = 0x1000
	// Bit SOFTLSREQ12.
	GPDMA_SOFTLSREQ_SOFTLSREQ12 = 0x1000
	// Position of SOFTLSREQ13 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos = 0xd
	// Bit mask of SOFTLSREQ13 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ13_Msk = 0x2000
	// Bit SOFTLSREQ13.
	GPDMA_SOFTLSREQ_SOFTLSREQ13 = 0x2000
	// Position of SOFTLSREQ14 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos = 0xe
	// Bit mask of SOFTLSREQ14 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ14_Msk = 0x4000
	// Bit SOFTLSREQ14.
	GPDMA_SOFTLSREQ_SOFTLSREQ14 = 0x4000
	// Position of SOFTLSREQ15 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos = 0xf
	// Bit mask of SOFTLSREQ15 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ15_Msk = 0x8000
	// Bit SOFTLSREQ15.
	GPDMA_SOFTLSREQ_SOFTLSREQ15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SOFTLSREQ_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SOFTLSREQ_RESERVED_Msk = 0xffff0000

	// CONFIG: DMA Configuration Register
	// Position of E field.
	GPDMA_CONFIG_E_Pos = 0x0
	// Bit mask of E field.
	GPDMA_CONFIG_E_Msk = 0x1
	// Bit E.
	GPDMA_CONFIG_E = 0x1
	// Position of M field.
	GPDMA_CONFIG_M_Pos = 0x1
	// Bit mask of M field.
	GPDMA_CONFIG_M_Msk = 0x2
	// Bit M.
	GPDMA_CONFIG_M = 0x2
	// Position of RESERVED field.
	GPDMA_CONFIG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	GPDMA_CONFIG_RESERVED_Msk = 0xfffffffc

	// SYNC: DMA Synchronization Register
	// Position of DMACSYNC0 field.
	GPDMA_SYNC_DMACSYNC0_Pos = 0x0
	// Bit mask of DMACSYNC0 field.
	GPDMA_SYNC_DMACSYNC0_Msk = 0x1
	// Bit DMACSYNC0.
	GPDMA_SYNC_DMACSYNC0 = 0x1
	// Position of DMACSYNC1 field.
	GPDMA_SYNC_DMACSYNC1_Pos = 0x1
	// Bit mask of DMACSYNC1 field.
	GPDMA_SYNC_DMACSYNC1_Msk = 0x2
	// Bit DMACSYNC1.
	GPDMA_SYNC_DMACSYNC1 = 0x2
	// Position of DMACSYNC2 field.
	GPDMA_SYNC_DMACSYNC2_Pos = 0x2
	// Bit mask of DMACSYNC2 field.
	GPDMA_SYNC_DMACSYNC2_Msk = 0x4
	// Bit DMACSYNC2.
	GPDMA_SYNC_DMACSYNC2 = 0x4
	// Position of DMACSYNC3 field.
	GPDMA_SYNC_DMACSYNC3_Pos = 0x3
	// Bit mask of DMACSYNC3 field.
	GPDMA_SYNC_DMACSYNC3_Msk = 0x8
	// Bit DMACSYNC3.
	GPDMA_SYNC_DMACSYNC3 = 0x8
	// Position of DMACSYNC4 field.
	GPDMA_SYNC_DMACSYNC4_Pos = 0x4
	// Bit mask of DMACSYNC4 field.
	GPDMA_SYNC_DMACSYNC4_Msk = 0x10
	// Bit DMACSYNC4.
	GPDMA_SYNC_DMACSYNC4 = 0x10
	// Position of DMACSYNC5 field.
	GPDMA_SYNC_DMACSYNC5_Pos = 0x5
	// Bit mask of DMACSYNC5 field.
	GPDMA_SYNC_DMACSYNC5_Msk = 0x20
	// Bit DMACSYNC5.
	GPDMA_SYNC_DMACSYNC5 = 0x20
	// Position of DMACSYNC6 field.
	GPDMA_SYNC_DMACSYNC6_Pos = 0x6
	// Bit mask of DMACSYNC6 field.
	GPDMA_SYNC_DMACSYNC6_Msk = 0x40
	// Bit DMACSYNC6.
	GPDMA_SYNC_DMACSYNC6 = 0x40
	// Position of DMACSYNC7 field.
	GPDMA_SYNC_DMACSYNC7_Pos = 0x7
	// Bit mask of DMACSYNC7 field.
	GPDMA_SYNC_DMACSYNC7_Msk = 0x80
	// Bit DMACSYNC7.
	GPDMA_SYNC_DMACSYNC7 = 0x80
	// Position of DMACSYNC8 field.
	GPDMA_SYNC_DMACSYNC8_Pos = 0x8
	// Bit mask of DMACSYNC8 field.
	GPDMA_SYNC_DMACSYNC8_Msk = 0x100
	// Bit DMACSYNC8.
	GPDMA_SYNC_DMACSYNC8 = 0x100
	// Position of DMACSYNC9 field.
	GPDMA_SYNC_DMACSYNC9_Pos = 0x9
	// Bit mask of DMACSYNC9 field.
	GPDMA_SYNC_DMACSYNC9_Msk = 0x200
	// Bit DMACSYNC9.
	GPDMA_SYNC_DMACSYNC9 = 0x200
	// Position of DMACSYNC10 field.
	GPDMA_SYNC_DMACSYNC10_Pos = 0xa
	// Bit mask of DMACSYNC10 field.
	GPDMA_SYNC_DMACSYNC10_Msk = 0x400
	// Bit DMACSYNC10.
	GPDMA_SYNC_DMACSYNC10 = 0x400
	// Position of DMACSYNC11 field.
	GPDMA_SYNC_DMACSYNC11_Pos = 0xb
	// Bit mask of DMACSYNC11 field.
	GPDMA_SYNC_DMACSYNC11_Msk = 0x800
	// Bit DMACSYNC11.
	GPDMA_SYNC_DMACSYNC11 = 0x800
	// Position of DMACSYNC12 field.
	GPDMA_SYNC_DMACSYNC12_Pos = 0xc
	// Bit mask of DMACSYNC12 field.
	GPDMA_SYNC_DMACSYNC12_Msk = 0x1000
	// Bit DMACSYNC12.
	GPDMA_SYNC_DMACSYNC12 = 0x1000
	// Position of DMACSYNC13 field.
	GPDMA_SYNC_DMACSYNC13_Pos = 0xd
	// Bit mask of DMACSYNC13 field.
	GPDMA_SYNC_DMACSYNC13_Msk = 0x2000
	// Bit DMACSYNC13.
	GPDMA_SYNC_DMACSYNC13 = 0x2000
	// Position of DMACSYNC14 field.
	GPDMA_SYNC_DMACSYNC14_Pos = 0xe
	// Bit mask of DMACSYNC14 field.
	GPDMA_SYNC_DMACSYNC14_Msk = 0x4000
	// Bit DMACSYNC14.
	GPDMA_SYNC_DMACSYNC14 = 0x4000
	// Position of DMACSYNC15 field.
	GPDMA_SYNC_DMACSYNC15_Pos = 0xf
	// Bit mask of DMACSYNC15 field.
	GPDMA_SYNC_DMACSYNC15_Msk = 0x8000
	// Bit DMACSYNC15.
	GPDMA_SYNC_DMACSYNC15 = 0x8000
	// Position of RESERVED field.
	GPDMA_SYNC_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	GPDMA_SYNC_RESERVED_Msk = 0xffff0000

	// SRCADDR0: DMA Channel 0 Source Address Register
	// Position of SRCADDR field.
	GPDMA_SRCADDR_SRCADDR_Pos = 0x0
	// Bit mask of SRCADDR field.
	GPDMA_SRCADDR_SRCADDR_Msk = 0xffffffff

	// DESTADDR0: DMA Channel 0 Destination Address Register
	// Position of DESTADDR field.
	GPDMA_DESTADDR_DESTADDR_Pos = 0x0
	// Bit mask of DESTADDR field.
	GPDMA_DESTADDR_DESTADDR_Msk = 0xffffffff

	// LLI0: DMA Channel 0 Linked List Item Register
	// Position of RESERVED field.
	GPDMA_LLI_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	GPDMA_LLI_RESERVED_Msk = 0x3
	// Position of LLI field.
	GPDMA_LLI_LLI_Pos = 0x2
	// Bit mask of LLI field.
	GPDMA_LLI_LLI_Msk = 0xfffffffc

	// CONTROL0: DMA Channel 0 Control Register
	// Position of TRANSFERSIZE field.
	GPDMA_CONTROL_TRANSFERSIZE_Pos = 0x0
	// Bit mask of TRANSFERSIZE field.
	GPDMA_CONTROL_TRANSFERSIZE_Msk = 0xfff
	// Position of SBSIZE field.
	GPDMA_CONTROL_SBSIZE_Pos = 0xc
	// Bit mask of SBSIZE field.
	GPDMA_CONTROL_SBSIZE_Msk = 0x7000
	// Position of DBSIZE field.
	GPDMA_CONTROL_DBSIZE_Pos = 0xf
	// Bit mask of DBSIZE field.
	GPDMA_CONTROL_DBSIZE_Msk = 0x38000
	// Position of SWIDTH field.
	GPDMA_CONTROL_SWIDTH_Pos = 0x12
	// Bit mask of SWIDTH field.
	GPDMA_CONTROL_SWIDTH_Msk = 0x1c0000
	// Position of DWIDTH field.
	GPDMA_CONTROL_DWIDTH_Pos = 0x15
	// Bit mask of DWIDTH field.
	GPDMA_CONTROL_DWIDTH_Msk = 0xe00000
	// Position of RESERVED field.
	GPDMA_CONTROL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	GPDMA_CONTROL_RESERVED_Msk = 0x3000000
	// Position of SI field.
	GPDMA_CONTROL_SI_Pos = 0x1a
	// Bit mask of SI field.
	GPDMA_CONTROL_SI_Msk = 0x4000000
	// Bit SI.
	GPDMA_CONTROL_SI = 0x4000000
	// Position of DI field.
	GPDMA_CONTROL_DI_Pos = 0x1b
	// Bit mask of DI field.
	GPDMA_CONTROL_DI_Msk = 0x8000000
	// Bit DI.
	GPDMA_CONTROL_DI = 0x8000000
	// Position of PROT1 field.
	GPDMA_CONTROL_PROT1_Pos = 0x1c
	// Bit mask of PROT1 field.
	GPDMA_CONTROL_PROT1_Msk = 0x10000000
	// Bit PROT1.
	GPDMA_CONTROL_PROT1 = 0x10000000
	// Position of PROT2 field.
	GPDMA_CONTROL_PROT2_Pos = 0x1d
	// Bit mask of PROT2 field.
	GPDMA_CONTROL_PROT2_Msk = 0x20000000
	// Bit PROT2.
	GPDMA_CONTROL_PROT2 = 0x20000000
	// Position of PROT3 field.
	GPDMA_CONTROL_PROT3_Pos = 0x1e
	// Bit mask of PROT3 field.
	GPDMA_CONTROL_PROT3_Msk = 0x40000000
	// Bit PROT3.
	GPDMA_CONTROL_PROT3 = 0x40000000
	// Position of I field.
	GPDMA_CONTROL_I_Pos = 0x1f
	// Bit mask of I field.
	GPDMA_CONTROL_I_Msk = 0x80000000
	// Bit I.
	GPDMA_CONTROL_I = 0x80000000

	// CONFIG0: DMA Channel 0 Configuration Register[1]
	// Position of E field.
	GPDMA_CONFIG_E_Pos = 0x0
	// Bit mask of E field.
	GPDMA_CONFIG_E_Msk = 0x1
	// Bit E.
	GPDMA_CONFIG_E = 0x1
	// Position of SRCPERIPHERAL field.
	GPDMA_CONFIG_SRCPERIPHERAL_Pos = 0x1
	// Bit mask of SRCPERIPHERAL field.
	GPDMA_CONFIG_SRCPERIPHERAL_Msk = 0x3e
	// Position of DESTPERIPHERAL field.
	GPDMA_CONFIG_DESTPERIPHERAL_Pos = 0x6
	// Bit mask of DESTPERIPHERAL field.
	GPDMA_CONFIG_DESTPERIPHERAL_Msk = 0x7c0
	// Position of TRANSFERTYPE field.
	GPDMA_CONFIG_TRANSFERTYPE_Pos = 0xb
	// Bit mask of TRANSFERTYPE field.
	GPDMA_CONFIG_TRANSFERTYPE_Msk = 0x3800
	// Position of IE field.
	GPDMA_CONFIG_IE_Pos = 0xe
	// Bit mask of IE field.
	GPDMA_CONFIG_IE_Msk = 0x4000
	// Bit IE.
	GPDMA_CONFIG_IE = 0x4000
	// Position of ITC field.
	GPDMA_CONFIG_ITC_Pos = 0xf
	// Bit mask of ITC field.
	GPDMA_CONFIG_ITC_Msk = 0x8000
	// Bit ITC.
	GPDMA_CONFIG_ITC = 0x8000
	// Position of L field.
	GPDMA_CONFIG_L_Pos = 0x10
	// Bit mask of L field.
	GPDMA_CONFIG_L_Msk = 0x10000
	// Bit L.
	GPDMA_CONFIG_L = 0x10000
	// Position of A field.
	GPDMA_CONFIG_A_Pos = 0x11
	// Bit mask of A field.
	GPDMA_CONFIG_A_Msk = 0x20000
	// Bit A.
	GPDMA_CONFIG_A = 0x20000
	// Position of H field.
	GPDMA_CONFIG_H_Pos = 0x12
	// Bit mask of H field.
	GPDMA_CONFIG_H_Msk = 0x40000
	// Bit H.
	GPDMA_CONFIG_H = 0x40000
	// Position of RESERVED field.
	GPDMA_CONFIG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	GPDMA_CONFIG_RESERVED_Msk = 0xfff80000
)

// Bitfields for ETHERNET: Ethernet
const (
	// MAC1: MAC configuration register 1.
	// Position of RXENABLE field.
	ETHERNET_MAC1_RXENABLE_Pos = 0x0
	// Bit mask of RXENABLE field.
	ETHERNET_MAC1_RXENABLE_Msk = 0x1
	// Bit RXENABLE.
	ETHERNET_MAC1_RXENABLE = 0x1
	// Position of PARF field.
	ETHERNET_MAC1_PARF_Pos = 0x1
	// Bit mask of PARF field.
	ETHERNET_MAC1_PARF_Msk = 0x2
	// Bit PARF.
	ETHERNET_MAC1_PARF = 0x2
	// Position of RXFLOWCTRL field.
	ETHERNET_MAC1_RXFLOWCTRL_Pos = 0x2
	// Bit mask of RXFLOWCTRL field.
	ETHERNET_MAC1_RXFLOWCTRL_Msk = 0x4
	// Bit RXFLOWCTRL.
	ETHERNET_MAC1_RXFLOWCTRL = 0x4
	// Position of TXFLOWCTRL field.
	ETHERNET_MAC1_TXFLOWCTRL_Pos = 0x3
	// Bit mask of TXFLOWCTRL field.
	ETHERNET_MAC1_TXFLOWCTRL_Msk = 0x8
	// Bit TXFLOWCTRL.
	ETHERNET_MAC1_TXFLOWCTRL = 0x8
	// Position of LOOPBACK field.
	ETHERNET_MAC1_LOOPBACK_Pos = 0x4
	// Bit mask of LOOPBACK field.
	ETHERNET_MAC1_LOOPBACK_Msk = 0x10
	// Bit LOOPBACK.
	ETHERNET_MAC1_LOOPBACK = 0x10
	// Position of RESERVED field.
	ETHERNET_MAC1_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	ETHERNET_MAC1_RESERVED_Msk = 0xe0
	// Position of RESETTX field.
	ETHERNET_MAC1_RESETTX_Pos = 0x8
	// Bit mask of RESETTX field.
	ETHERNET_MAC1_RESETTX_Msk = 0x100
	// Bit RESETTX.
	ETHERNET_MAC1_RESETTX = 0x100
	// Position of RESETMCSTX field.
	ETHERNET_MAC1_RESETMCSTX_Pos = 0x9
	// Bit mask of RESETMCSTX field.
	ETHERNET_MAC1_RESETMCSTX_Msk = 0x200
	// Bit RESETMCSTX.
	ETHERNET_MAC1_RESETMCSTX = 0x200
	// Position of RESETRX field.
	ETHERNET_MAC1_RESETRX_Pos = 0xa
	// Bit mask of RESETRX field.
	ETHERNET_MAC1_RESETRX_Msk = 0x400
	// Bit RESETRX.
	ETHERNET_MAC1_RESETRX = 0x400
	// Position of RESETMCSRX field.
	ETHERNET_MAC1_RESETMCSRX_Pos = 0xb
	// Bit mask of RESETMCSRX field.
	ETHERNET_MAC1_RESETMCSRX_Msk = 0x800
	// Bit RESETMCSRX.
	ETHERNET_MAC1_RESETMCSRX = 0x800
	// Position of RESERVED field.
	ETHERNET_MAC1_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	ETHERNET_MAC1_RESERVED_Msk = 0x3000
	// Position of SIMRESET field.
	ETHERNET_MAC1_SIMRESET_Pos = 0xe
	// Bit mask of SIMRESET field.
	ETHERNET_MAC1_SIMRESET_Msk = 0x4000
	// Bit SIMRESET.
	ETHERNET_MAC1_SIMRESET = 0x4000
	// Position of SOFTRESET field.
	ETHERNET_MAC1_SOFTRESET_Pos = 0xf
	// Bit mask of SOFTRESET field.
	ETHERNET_MAC1_SOFTRESET_Msk = 0x8000
	// Bit SOFTRESET.
	ETHERNET_MAC1_SOFTRESET = 0x8000
	// Position of RESERVED field.
	ETHERNET_MAC1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_MAC1_RESERVED_Msk = 0xffff0000

	// MAC2: MAC configuration register 2.
	// Position of FULLDUPLEX field.
	ETHERNET_MAC2_FULLDUPLEX_Pos = 0x0
	// Bit mask of FULLDUPLEX field.
	ETHERNET_MAC2_FULLDUPLEX_Msk = 0x1
	// Bit FULLDUPLEX.
	ETHERNET_MAC2_FULLDUPLEX = 0x1
	// Position of FLC field.
	ETHERNET_MAC2_FLC_Pos = 0x1
	// Bit mask of FLC field.
	ETHERNET_MAC2_FLC_Msk = 0x2
	// Bit FLC.
	ETHERNET_MAC2_FLC = 0x2
	// Position of HFEN field.
	ETHERNET_MAC2_HFEN_Pos = 0x2
	// Bit mask of HFEN field.
	ETHERNET_MAC2_HFEN_Msk = 0x4
	// Bit HFEN.
	ETHERNET_MAC2_HFEN = 0x4
	// Position of DELAYEDCRC field.
	ETHERNET_MAC2_DELAYEDCRC_Pos = 0x3
	// Bit mask of DELAYEDCRC field.
	ETHERNET_MAC2_DELAYEDCRC_Msk = 0x8
	// Bit DELAYEDCRC.
	ETHERNET_MAC2_DELAYEDCRC = 0x8
	// Position of CRCEN field.
	ETHERNET_MAC2_CRCEN_Pos = 0x4
	// Bit mask of CRCEN field.
	ETHERNET_MAC2_CRCEN_Msk = 0x10
	// Bit CRCEN.
	ETHERNET_MAC2_CRCEN = 0x10
	// Position of PADCRCEN field.
	ETHERNET_MAC2_PADCRCEN_Pos = 0x5
	// Bit mask of PADCRCEN field.
	ETHERNET_MAC2_PADCRCEN_Msk = 0x20
	// Bit PADCRCEN.
	ETHERNET_MAC2_PADCRCEN = 0x20
	// Position of VLANPADEN field.
	ETHERNET_MAC2_VLANPADEN_Pos = 0x6
	// Bit mask of VLANPADEN field.
	ETHERNET_MAC2_VLANPADEN_Msk = 0x40
	// Bit VLANPADEN.
	ETHERNET_MAC2_VLANPADEN = 0x40
	// Position of AUTODETPADEN field.
	ETHERNET_MAC2_AUTODETPADEN_Pos = 0x7
	// Bit mask of AUTODETPADEN field.
	ETHERNET_MAC2_AUTODETPADEN_Msk = 0x80
	// Bit AUTODETPADEN.
	ETHERNET_MAC2_AUTODETPADEN = 0x80
	// Position of PPENF field.
	ETHERNET_MAC2_PPENF_Pos = 0x8
	// Bit mask of PPENF field.
	ETHERNET_MAC2_PPENF_Msk = 0x100
	// Bit PPENF.
	ETHERNET_MAC2_PPENF = 0x100
	// Position of LPENF field.
	ETHERNET_MAC2_LPENF_Pos = 0x9
	// Bit mask of LPENF field.
	ETHERNET_MAC2_LPENF_Msk = 0x200
	// Bit LPENF.
	ETHERNET_MAC2_LPENF = 0x200
	// Position of RESERVED field.
	ETHERNET_MAC2_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	ETHERNET_MAC2_RESERVED_Msk = 0xc00
	// Position of NOBACKOFF field.
	ETHERNET_MAC2_NOBACKOFF_Pos = 0xc
	// Bit mask of NOBACKOFF field.
	ETHERNET_MAC2_NOBACKOFF_Msk = 0x1000
	// Bit NOBACKOFF.
	ETHERNET_MAC2_NOBACKOFF = 0x1000
	// Position of BP_NOBACKOFF field.
	ETHERNET_MAC2_BP_NOBACKOFF_Pos = 0xd
	// Bit mask of BP_NOBACKOFF field.
	ETHERNET_MAC2_BP_NOBACKOFF_Msk = 0x2000
	// Bit BP_NOBACKOFF.
	ETHERNET_MAC2_BP_NOBACKOFF = 0x2000
	// Position of EXCESSDEFER field.
	ETHERNET_MAC2_EXCESSDEFER_Pos = 0xe
	// Bit mask of EXCESSDEFER field.
	ETHERNET_MAC2_EXCESSDEFER_Msk = 0x4000
	// Bit EXCESSDEFER.
	ETHERNET_MAC2_EXCESSDEFER = 0x4000
	// Position of RESERVED field.
	ETHERNET_MAC2_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	ETHERNET_MAC2_RESERVED_Msk = 0xffff8000

	// IPGT: Back-to-Back Inter-Packet-Gap register.
	// Position of BTOBINTEGAP field.
	ETHERNET_IPGT_BTOBINTEGAP_Pos = 0x0
	// Bit mask of BTOBINTEGAP field.
	ETHERNET_IPGT_BTOBINTEGAP_Msk = 0x7f
	// Position of RESERVED field.
	ETHERNET_IPGT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	ETHERNET_IPGT_RESERVED_Msk = 0xffffff80

	// IPGR: Non Back-to-Back Inter-Packet-Gap register.
	// Position of NBTOBINTEGAP2 field.
	ETHERNET_IPGR_NBTOBINTEGAP2_Pos = 0x0
	// Bit mask of NBTOBINTEGAP2 field.
	ETHERNET_IPGR_NBTOBINTEGAP2_Msk = 0x7f
	// Position of RESERVED field.
	ETHERNET_IPGR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	ETHERNET_IPGR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	ETHERNET_IPGR_RESERVED = 0x80
	// Position of NBTOBINTEGAP1 field.
	ETHERNET_IPGR_NBTOBINTEGAP1_Pos = 0x8
	// Bit mask of NBTOBINTEGAP1 field.
	ETHERNET_IPGR_NBTOBINTEGAP1_Msk = 0x7f00
	// Position of RESERVED field.
	ETHERNET_IPGR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	ETHERNET_IPGR_RESERVED_Msk = 0xffff8000

	// CLRT: Collision window / Retry register.
	// Position of RETRANSMAX field.
	ETHERNET_CLRT_RETRANSMAX_Pos = 0x0
	// Bit mask of RETRANSMAX field.
	ETHERNET_CLRT_RETRANSMAX_Msk = 0xf
	// Position of RESERVED field.
	ETHERNET_CLRT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	ETHERNET_CLRT_RESERVED_Msk = 0xf0
	// Position of COLLWIN field.
	ETHERNET_CLRT_COLLWIN_Pos = 0x8
	// Bit mask of COLLWIN field.
	ETHERNET_CLRT_COLLWIN_Msk = 0x3f00
	// Position of RESERVED field.
	ETHERNET_CLRT_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	ETHERNET_CLRT_RESERVED_Msk = 0xffffc000

	// MAXF: Maximum Frame register.
	// Position of MAXFLEN field.
	ETHERNET_MAXF_MAXFLEN_Pos = 0x0
	// Bit mask of MAXFLEN field.
	ETHERNET_MAXF_MAXFLEN_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_MAXF_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_MAXF_RESERVED_Msk = 0xffff0000

	// SUPP: PHY Support register.
	// Position of RESERVED field.
	ETHERNET_SUPP_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_SUPP_RESERVED_Msk = 0xff
	// Position of SPEED field.
	ETHERNET_SUPP_SPEED_Pos = 0x8
	// Bit mask of SPEED field.
	ETHERNET_SUPP_SPEED_Msk = 0x100
	// Bit SPEED.
	ETHERNET_SUPP_SPEED = 0x100
	// Position of RESERVED field.
	ETHERNET_SUPP_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ETHERNET_SUPP_RESERVED_Msk = 0xfffffe00

	// TEST: Test register.
	// Position of SCPQ field.
	ETHERNET_TEST_SCPQ_Pos = 0x0
	// Bit mask of SCPQ field.
	ETHERNET_TEST_SCPQ_Msk = 0x1
	// Bit SCPQ.
	ETHERNET_TEST_SCPQ = 0x1
	// Position of TESTPAUSE field.
	ETHERNET_TEST_TESTPAUSE_Pos = 0x1
	// Bit mask of TESTPAUSE field.
	ETHERNET_TEST_TESTPAUSE_Msk = 0x2
	// Bit TESTPAUSE.
	ETHERNET_TEST_TESTPAUSE = 0x2
	// Position of TESTBP field.
	ETHERNET_TEST_TESTBP_Pos = 0x2
	// Bit mask of TESTBP field.
	ETHERNET_TEST_TESTBP_Msk = 0x4
	// Bit TESTBP.
	ETHERNET_TEST_TESTBP = 0x4
	// Position of RESERVED field.
	ETHERNET_TEST_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	ETHERNET_TEST_RESERVED_Msk = 0xfffffff8

	// MCFG: MII Mgmt Configuration register.
	// Position of SCANINC field.
	ETHERNET_MCFG_SCANINC_Pos = 0x0
	// Bit mask of SCANINC field.
	ETHERNET_MCFG_SCANINC_Msk = 0x1
	// Bit SCANINC.
	ETHERNET_MCFG_SCANINC = 0x1
	// Position of SUPPPREAMBLE field.
	ETHERNET_MCFG_SUPPPREAMBLE_Pos = 0x1
	// Bit mask of SUPPPREAMBLE field.
	ETHERNET_MCFG_SUPPPREAMBLE_Msk = 0x2
	// Bit SUPPPREAMBLE.
	ETHERNET_MCFG_SUPPPREAMBLE = 0x2
	// Position of CLOCKSEL field.
	ETHERNET_MCFG_CLOCKSEL_Pos = 0x2
	// Bit mask of CLOCKSEL field.
	ETHERNET_MCFG_CLOCKSEL_Msk = 0x3c
	// Position of RESERVED field.
	ETHERNET_MCFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ETHERNET_MCFG_RESERVED_Msk = 0x7fc0
	// Position of RESETMIIMGMT field.
	ETHERNET_MCFG_RESETMIIMGMT_Pos = 0xf
	// Bit mask of RESETMIIMGMT field.
	ETHERNET_MCFG_RESETMIIMGMT_Msk = 0x8000
	// Bit RESETMIIMGMT.
	ETHERNET_MCFG_RESETMIIMGMT = 0x8000
	// Position of RESERVED field.
	ETHERNET_MCFG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_MCFG_RESERVED_Msk = 0xffff0000

	// MCMD: MII Mgmt Command register.
	// Position of READ field.
	ETHERNET_MCMD_READ_Pos = 0x0
	// Bit mask of READ field.
	ETHERNET_MCMD_READ_Msk = 0x1
	// Bit READ.
	ETHERNET_MCMD_READ = 0x1
	// Position of SCAN field.
	ETHERNET_MCMD_SCAN_Pos = 0x1
	// Bit mask of SCAN field.
	ETHERNET_MCMD_SCAN_Msk = 0x2
	// Bit SCAN.
	ETHERNET_MCMD_SCAN = 0x2
	// Position of RESERVED field.
	ETHERNET_MCMD_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	ETHERNET_MCMD_RESERVED_Msk = 0xfffffffc

	// MADR: MII Mgmt Address register.
	// Position of REGADDR field.
	ETHERNET_MADR_REGADDR_Pos = 0x0
	// Bit mask of REGADDR field.
	ETHERNET_MADR_REGADDR_Msk = 0x1f
	// Position of RESERVED field.
	ETHERNET_MADR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	ETHERNET_MADR_RESERVED_Msk = 0xe0
	// Position of PHYADDR field.
	ETHERNET_MADR_PHYADDR_Pos = 0x8
	// Bit mask of PHYADDR field.
	ETHERNET_MADR_PHYADDR_Msk = 0x1f00
	// Position of RESERVED field.
	ETHERNET_MADR_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	ETHERNET_MADR_RESERVED_Msk = 0xffffe000

	// MWTD: MII Mgmt Write Data register.
	// Position of WRITEDATA field.
	ETHERNET_MWTD_WRITEDATA_Pos = 0x0
	// Bit mask of WRITEDATA field.
	ETHERNET_MWTD_WRITEDATA_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_MWTD_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_MWTD_RESERVED_Msk = 0xffff0000

	// MRDD: MII Mgmt Read Data register.
	// Position of READDATA field.
	ETHERNET_MRDD_READDATA_Pos = 0x0
	// Bit mask of READDATA field.
	ETHERNET_MRDD_READDATA_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_MRDD_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_MRDD_RESERVED_Msk = 0xffff0000

	// MIND: MII Mgmt Indicators register.
	// Position of BUSY field.
	ETHERNET_MIND_BUSY_Pos = 0x0
	// Bit mask of BUSY field.
	ETHERNET_MIND_BUSY_Msk = 0x1
	// Bit BUSY.
	ETHERNET_MIND_BUSY = 0x1
	// Position of SCANNING field.
	ETHERNET_MIND_SCANNING_Pos = 0x1
	// Bit mask of SCANNING field.
	ETHERNET_MIND_SCANNING_Msk = 0x2
	// Bit SCANNING.
	ETHERNET_MIND_SCANNING = 0x2
	// Position of NOTVALID field.
	ETHERNET_MIND_NOTVALID_Pos = 0x2
	// Bit mask of NOTVALID field.
	ETHERNET_MIND_NOTVALID_Msk = 0x4
	// Bit NOTVALID.
	ETHERNET_MIND_NOTVALID = 0x4
	// Position of MIILINKFAIL field.
	ETHERNET_MIND_MIILINKFAIL_Pos = 0x3
	// Bit mask of MIILINKFAIL field.
	ETHERNET_MIND_MIILINKFAIL_Msk = 0x8
	// Bit MIILINKFAIL.
	ETHERNET_MIND_MIILINKFAIL = 0x8
	// Position of RESERVED field.
	ETHERNET_MIND_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	ETHERNET_MIND_RESERVED_Msk = 0xfffffff0

	// SA0: Station Address 0 register.
	// Position of SADDR2 field.
	ETHERNET_SA0_SADDR2_Pos = 0x0
	// Bit mask of SADDR2 field.
	ETHERNET_SA0_SADDR2_Msk = 0xff
	// Position of SADDR1 field.
	ETHERNET_SA0_SADDR1_Pos = 0x8
	// Bit mask of SADDR1 field.
	ETHERNET_SA0_SADDR1_Msk = 0xff00
	// Position of RESERVED field.
	ETHERNET_SA0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_SA0_RESERVED_Msk = 0xffff0000

	// SA1: Station Address 1 register.
	// Position of SADDR4 field.
	ETHERNET_SA1_SADDR4_Pos = 0x0
	// Bit mask of SADDR4 field.
	ETHERNET_SA1_SADDR4_Msk = 0xff
	// Position of SADDR3 field.
	ETHERNET_SA1_SADDR3_Pos = 0x8
	// Bit mask of SADDR3 field.
	ETHERNET_SA1_SADDR3_Msk = 0xff00
	// Position of RESERVED field.
	ETHERNET_SA1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_SA1_RESERVED_Msk = 0xffff0000

	// SA2: Station Address 2 register.
	// Position of SADDR6 field.
	ETHERNET_SA2_SADDR6_Pos = 0x0
	// Bit mask of SADDR6 field.
	ETHERNET_SA2_SADDR6_Msk = 0xff
	// Position of SADDR5 field.
	ETHERNET_SA2_SADDR5_Pos = 0x8
	// Bit mask of SADDR5 field.
	ETHERNET_SA2_SADDR5_Msk = 0xff00
	// Position of RESERVED field.
	ETHERNET_SA2_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_SA2_RESERVED_Msk = 0xffff0000

	// COMMAND: Command register.
	// Position of RXENABLE field.
	ETHERNET_COMMAND_RXENABLE_Pos = 0x0
	// Bit mask of RXENABLE field.
	ETHERNET_COMMAND_RXENABLE_Msk = 0x1
	// Bit RXENABLE.
	ETHERNET_COMMAND_RXENABLE = 0x1
	// Position of TXENABLE field.
	ETHERNET_COMMAND_TXENABLE_Pos = 0x1
	// Bit mask of TXENABLE field.
	ETHERNET_COMMAND_TXENABLE_Msk = 0x2
	// Bit TXENABLE.
	ETHERNET_COMMAND_TXENABLE = 0x2
	// Position of RESERVED field.
	ETHERNET_COMMAND_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	ETHERNET_COMMAND_RESERVED_Msk = 0x4
	// Bit RESERVED.
	ETHERNET_COMMAND_RESERVED = 0x4
	// Position of REGRESET field.
	ETHERNET_COMMAND_REGRESET_Pos = 0x3
	// Bit mask of REGRESET field.
	ETHERNET_COMMAND_REGRESET_Msk = 0x8
	// Bit REGRESET.
	ETHERNET_COMMAND_REGRESET = 0x8
	// Position of TXRESET field.
	ETHERNET_COMMAND_TXRESET_Pos = 0x4
	// Bit mask of TXRESET field.
	ETHERNET_COMMAND_TXRESET_Msk = 0x10
	// Bit TXRESET.
	ETHERNET_COMMAND_TXRESET = 0x10
	// Position of RXRESET field.
	ETHERNET_COMMAND_RXRESET_Pos = 0x5
	// Bit mask of RXRESET field.
	ETHERNET_COMMAND_RXRESET_Msk = 0x20
	// Bit RXRESET.
	ETHERNET_COMMAND_RXRESET = 0x20
	// Position of PASSRUNTFRAME field.
	ETHERNET_COMMAND_PASSRUNTFRAME_Pos = 0x6
	// Bit mask of PASSRUNTFRAME field.
	ETHERNET_COMMAND_PASSRUNTFRAME_Msk = 0x40
	// Bit PASSRUNTFRAME.
	ETHERNET_COMMAND_PASSRUNTFRAME = 0x40
	// Position of PASSRXFILTER field.
	ETHERNET_COMMAND_PASSRXFILTER_Pos = 0x7
	// Bit mask of PASSRXFILTER field.
	ETHERNET_COMMAND_PASSRXFILTER_Msk = 0x80
	// Bit PASSRXFILTER.
	ETHERNET_COMMAND_PASSRXFILTER = 0x80
	// Position of TXFLOWCONTROL field.
	ETHERNET_COMMAND_TXFLOWCONTROL_Pos = 0x8
	// Bit mask of TXFLOWCONTROL field.
	ETHERNET_COMMAND_TXFLOWCONTROL_Msk = 0x100
	// Bit TXFLOWCONTROL.
	ETHERNET_COMMAND_TXFLOWCONTROL = 0x100
	// Position of RMII field.
	ETHERNET_COMMAND_RMII_Pos = 0x9
	// Bit mask of RMII field.
	ETHERNET_COMMAND_RMII_Msk = 0x200
	// Bit RMII.
	ETHERNET_COMMAND_RMII = 0x200
	// Position of FULLDUPLEX field.
	ETHERNET_COMMAND_FULLDUPLEX_Pos = 0xa
	// Bit mask of FULLDUPLEX field.
	ETHERNET_COMMAND_FULLDUPLEX_Msk = 0x400
	// Bit FULLDUPLEX.
	ETHERNET_COMMAND_FULLDUPLEX = 0x400
	// Position of RESERVED field.
	ETHERNET_COMMAND_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ETHERNET_COMMAND_RESERVED_Msk = 0xfffff800

	// STATUS: Status register.
	// Position of RXSTATUS field.
	ETHERNET_STATUS_RXSTATUS_Pos = 0x0
	// Bit mask of RXSTATUS field.
	ETHERNET_STATUS_RXSTATUS_Msk = 0x1
	// Bit RXSTATUS.
	ETHERNET_STATUS_RXSTATUS = 0x1
	// Position of TXSTATUS field.
	ETHERNET_STATUS_TXSTATUS_Pos = 0x1
	// Bit mask of TXSTATUS field.
	ETHERNET_STATUS_TXSTATUS_Msk = 0x2
	// Bit TXSTATUS.
	ETHERNET_STATUS_TXSTATUS = 0x2
	// Position of RESERVED field.
	ETHERNET_STATUS_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	ETHERNET_STATUS_RESERVED_Msk = 0xfffffffc

	// RXDESCRIPTOR: Receive descriptor base address register.
	// Position of RESERVED field.
	ETHERNET_RXDESCRIPTOR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_RXDESCRIPTOR_RESERVED_Msk = 0x3
	// Position of RXDESCRIPTOR field.
	ETHERNET_RXDESCRIPTOR_RXDESCRIPTOR_Pos = 0x2
	// Bit mask of RXDESCRIPTOR field.
	ETHERNET_RXDESCRIPTOR_RXDESCRIPTOR_Msk = 0xfffffffc

	// RXSTATUS: Receive status base address register.
	// Position of RESERVED field.
	ETHERNET_RXSTATUS_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_RXSTATUS_RESERVED_Msk = 0x7
	// Position of RXSTATUS field.
	ETHERNET_RXSTATUS_RXSTATUS_Pos = 0x3
	// Bit mask of RXSTATUS field.
	ETHERNET_RXSTATUS_RXSTATUS_Msk = 0xfffffff8

	// RXDESCRIPTORNUMBER: Receive number of descriptors register.
	// Position of RXDESCRIPTORN field.
	ETHERNET_RXDESCRIPTORNUMBER_RXDESCRIPTORN_Pos = 0x0
	// Bit mask of RXDESCRIPTORN field.
	ETHERNET_RXDESCRIPTORNUMBER_RXDESCRIPTORN_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_RXDESCRIPTORNUMBER_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_RXDESCRIPTORNUMBER_RESERVED_Msk = 0xffff0000

	// RXPRODUCEINDEX: Receive produce index register.
	// Position of RXPRODUCEIX field.
	ETHERNET_RXPRODUCEINDEX_RXPRODUCEIX_Pos = 0x0
	// Bit mask of RXPRODUCEIX field.
	ETHERNET_RXPRODUCEINDEX_RXPRODUCEIX_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_RXPRODUCEINDEX_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_RXPRODUCEINDEX_RESERVED_Msk = 0xffff0000

	// RXCONSUMEINDEX: Receive consume index register.
	// Position of RXCONSUMEIX field.
	ETHERNET_RXCONSUMEINDEX_RXCONSUMEIX_Pos = 0x0
	// Bit mask of RXCONSUMEIX field.
	ETHERNET_RXCONSUMEINDEX_RXCONSUMEIX_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_RXCONSUMEINDEX_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_RXCONSUMEINDEX_RESERVED_Msk = 0xffff0000

	// TXDESCRIPTOR: Transmit descriptor base address register.
	// Position of RESERVED field.
	ETHERNET_TXDESCRIPTOR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_TXDESCRIPTOR_RESERVED_Msk = 0x3
	// Position of TXD field.
	ETHERNET_TXDESCRIPTOR_TXD_Pos = 0x2
	// Bit mask of TXD field.
	ETHERNET_TXDESCRIPTOR_TXD_Msk = 0xfffffffc

	// TXSTATUS: Transmit status base address register.
	// Position of RESERVED field.
	ETHERNET_TXSTATUS_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_TXSTATUS_RESERVED_Msk = 0x3
	// Position of TXSTAT field.
	ETHERNET_TXSTATUS_TXSTAT_Pos = 0x2
	// Bit mask of TXSTAT field.
	ETHERNET_TXSTATUS_TXSTAT_Msk = 0xfffffffc

	// TXDESCRIPTORNUMBER: Transmit number of descriptors register.
	// Position of TXDN field.
	ETHERNET_TXDESCRIPTORNUMBER_TXDN_Pos = 0x0
	// Bit mask of TXDN field.
	ETHERNET_TXDESCRIPTORNUMBER_TXDN_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_TXDESCRIPTORNUMBER_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_TXDESCRIPTORNUMBER_RESERVED_Msk = 0xffff0000

	// TXPRODUCEINDEX: Transmit produce index register.
	// Position of TXPI field.
	ETHERNET_TXPRODUCEINDEX_TXPI_Pos = 0x0
	// Bit mask of TXPI field.
	ETHERNET_TXPRODUCEINDEX_TXPI_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_TXPRODUCEINDEX_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_TXPRODUCEINDEX_RESERVED_Msk = 0xffff0000

	// TXCONSUMEINDEX: Transmit consume index register.
	// Position of TXCI field.
	ETHERNET_TXCONSUMEINDEX_TXCI_Pos = 0x0
	// Bit mask of TXCI field.
	ETHERNET_TXCONSUMEINDEX_TXCI_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_TXCONSUMEINDEX_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_TXCONSUMEINDEX_RESERVED_Msk = 0xffff0000

	// TSV0: Transmit status vector 0 register.
	// Position of CRCERR field.
	ETHERNET_TSV0_CRCERR_Pos = 0x0
	// Bit mask of CRCERR field.
	ETHERNET_TSV0_CRCERR_Msk = 0x1
	// Bit CRCERR.
	ETHERNET_TSV0_CRCERR = 0x1
	// Position of LCE field.
	ETHERNET_TSV0_LCE_Pos = 0x1
	// Bit mask of LCE field.
	ETHERNET_TSV0_LCE_Msk = 0x2
	// Bit LCE.
	ETHERNET_TSV0_LCE = 0x2
	// Position of LOR field.
	ETHERNET_TSV0_LOR_Pos = 0x2
	// Bit mask of LOR field.
	ETHERNET_TSV0_LOR_Msk = 0x4
	// Bit LOR.
	ETHERNET_TSV0_LOR = 0x4
	// Position of DONE field.
	ETHERNET_TSV0_DONE_Pos = 0x3
	// Bit mask of DONE field.
	ETHERNET_TSV0_DONE_Msk = 0x8
	// Bit DONE.
	ETHERNET_TSV0_DONE = 0x8
	// Position of MULTICAST field.
	ETHERNET_TSV0_MULTICAST_Pos = 0x4
	// Bit mask of MULTICAST field.
	ETHERNET_TSV0_MULTICAST_Msk = 0x10
	// Bit MULTICAST.
	ETHERNET_TSV0_MULTICAST = 0x10
	// Position of BROADCAST field.
	ETHERNET_TSV0_BROADCAST_Pos = 0x5
	// Bit mask of BROADCAST field.
	ETHERNET_TSV0_BROADCAST_Msk = 0x20
	// Bit BROADCAST.
	ETHERNET_TSV0_BROADCAST = 0x20
	// Position of PACKETDEFER field.
	ETHERNET_TSV0_PACKETDEFER_Pos = 0x6
	// Bit mask of PACKETDEFER field.
	ETHERNET_TSV0_PACKETDEFER_Msk = 0x40
	// Bit PACKETDEFER.
	ETHERNET_TSV0_PACKETDEFER = 0x40
	// Position of EXDF field.
	ETHERNET_TSV0_EXDF_Pos = 0x7
	// Bit mask of EXDF field.
	ETHERNET_TSV0_EXDF_Msk = 0x80
	// Bit EXDF.
	ETHERNET_TSV0_EXDF = 0x80
	// Position of EXCOL field.
	ETHERNET_TSV0_EXCOL_Pos = 0x8
	// Bit mask of EXCOL field.
	ETHERNET_TSV0_EXCOL_Msk = 0x100
	// Bit EXCOL.
	ETHERNET_TSV0_EXCOL = 0x100
	// Position of LCOL field.
	ETHERNET_TSV0_LCOL_Pos = 0x9
	// Bit mask of LCOL field.
	ETHERNET_TSV0_LCOL_Msk = 0x200
	// Bit LCOL.
	ETHERNET_TSV0_LCOL = 0x200
	// Position of GIANT field.
	ETHERNET_TSV0_GIANT_Pos = 0xa
	// Bit mask of GIANT field.
	ETHERNET_TSV0_GIANT_Msk = 0x400
	// Bit GIANT.
	ETHERNET_TSV0_GIANT = 0x400
	// Position of UNDERRUN field.
	ETHERNET_TSV0_UNDERRUN_Pos = 0xb
	// Bit mask of UNDERRUN field.
	ETHERNET_TSV0_UNDERRUN_Msk = 0x800
	// Bit UNDERRUN.
	ETHERNET_TSV0_UNDERRUN = 0x800
	// Position of TOTALBYTES field.
	ETHERNET_TSV0_TOTALBYTES_Pos = 0xc
	// Bit mask of TOTALBYTES field.
	ETHERNET_TSV0_TOTALBYTES_Msk = 0xffff000
	// Position of CONTROLFRAME field.
	ETHERNET_TSV0_CONTROLFRAME_Pos = 0x1c
	// Bit mask of CONTROLFRAME field.
	ETHERNET_TSV0_CONTROLFRAME_Msk = 0x10000000
	// Bit CONTROLFRAME.
	ETHERNET_TSV0_CONTROLFRAME = 0x10000000
	// Position of PAUSE field.
	ETHERNET_TSV0_PAUSE_Pos = 0x1d
	// Bit mask of PAUSE field.
	ETHERNET_TSV0_PAUSE_Msk = 0x20000000
	// Bit PAUSE.
	ETHERNET_TSV0_PAUSE = 0x20000000
	// Position of BACKPRESSURE field.
	ETHERNET_TSV0_BACKPRESSURE_Pos = 0x1e
	// Bit mask of BACKPRESSURE field.
	ETHERNET_TSV0_BACKPRESSURE_Msk = 0x40000000
	// Bit BACKPRESSURE.
	ETHERNET_TSV0_BACKPRESSURE = 0x40000000
	// Position of VLAN field.
	ETHERNET_TSV0_VLAN_Pos = 0x1f
	// Bit mask of VLAN field.
	ETHERNET_TSV0_VLAN_Msk = 0x80000000
	// Bit VLAN.
	ETHERNET_TSV0_VLAN = 0x80000000

	// TSV1: Transmit status vector 1 register.
	// Position of TBC field.
	ETHERNET_TSV1_TBC_Pos = 0x0
	// Bit mask of TBC field.
	ETHERNET_TSV1_TBC_Msk = 0xffff
	// Position of TCC field.
	ETHERNET_TSV1_TCC_Pos = 0x10
	// Bit mask of TCC field.
	ETHERNET_TSV1_TCC_Msk = 0xf0000
	// Position of RESERVED field.
	ETHERNET_TSV1_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ETHERNET_TSV1_RESERVED_Msk = 0xfff00000

	// RSV: Receive status vector register.
	// Position of RBC field.
	ETHERNET_RSV_RBC_Pos = 0x0
	// Bit mask of RBC field.
	ETHERNET_RSV_RBC_Msk = 0xffff
	// Position of PPI field.
	ETHERNET_RSV_PPI_Pos = 0x10
	// Bit mask of PPI field.
	ETHERNET_RSV_PPI_Msk = 0x10000
	// Bit PPI.
	ETHERNET_RSV_PPI = 0x10000
	// Position of RXDVSEEN field.
	ETHERNET_RSV_RXDVSEEN_Pos = 0x11
	// Bit mask of RXDVSEEN field.
	ETHERNET_RSV_RXDVSEEN_Msk = 0x20000
	// Bit RXDVSEEN.
	ETHERNET_RSV_RXDVSEEN = 0x20000
	// Position of CESEEN field.
	ETHERNET_RSV_CESEEN_Pos = 0x12
	// Bit mask of CESEEN field.
	ETHERNET_RSV_CESEEN_Msk = 0x40000
	// Bit CESEEN.
	ETHERNET_RSV_CESEEN = 0x40000
	// Position of RCV field.
	ETHERNET_RSV_RCV_Pos = 0x13
	// Bit mask of RCV field.
	ETHERNET_RSV_RCV_Msk = 0x80000
	// Bit RCV.
	ETHERNET_RSV_RCV = 0x80000
	// Position of CRCERR field.
	ETHERNET_RSV_CRCERR_Pos = 0x14
	// Bit mask of CRCERR field.
	ETHERNET_RSV_CRCERR_Msk = 0x100000
	// Bit CRCERR.
	ETHERNET_RSV_CRCERR = 0x100000
	// Position of LCERR field.
	ETHERNET_RSV_LCERR_Pos = 0x15
	// Bit mask of LCERR field.
	ETHERNET_RSV_LCERR_Msk = 0x200000
	// Bit LCERR.
	ETHERNET_RSV_LCERR = 0x200000
	// Position of LOR field.
	ETHERNET_RSV_LOR_Pos = 0x16
	// Bit mask of LOR field.
	ETHERNET_RSV_LOR_Msk = 0x400000
	// Bit LOR.
	ETHERNET_RSV_LOR = 0x400000
	// Position of ROK field.
	ETHERNET_RSV_ROK_Pos = 0x17
	// Bit mask of ROK field.
	ETHERNET_RSV_ROK_Msk = 0x800000
	// Bit ROK.
	ETHERNET_RSV_ROK = 0x800000
	// Position of MULTICAST field.
	ETHERNET_RSV_MULTICAST_Pos = 0x18
	// Bit mask of MULTICAST field.
	ETHERNET_RSV_MULTICAST_Msk = 0x1000000
	// Bit MULTICAST.
	ETHERNET_RSV_MULTICAST = 0x1000000
	// Position of BROADCAST field.
	ETHERNET_RSV_BROADCAST_Pos = 0x19
	// Bit mask of BROADCAST field.
	ETHERNET_RSV_BROADCAST_Msk = 0x2000000
	// Bit BROADCAST.
	ETHERNET_RSV_BROADCAST = 0x2000000
	// Position of DRIBBLENIBBLE field.
	ETHERNET_RSV_DRIBBLENIBBLE_Pos = 0x1a
	// Bit mask of DRIBBLENIBBLE field.
	ETHERNET_RSV_DRIBBLENIBBLE_Msk = 0x4000000
	// Bit DRIBBLENIBBLE.
	ETHERNET_RSV_DRIBBLENIBBLE = 0x4000000
	// Position of CONTROLFRAME field.
	ETHERNET_RSV_CONTROLFRAME_Pos = 0x1b
	// Bit mask of CONTROLFRAME field.
	ETHERNET_RSV_CONTROLFRAME_Msk = 0x8000000
	// Bit CONTROLFRAME.
	ETHERNET_RSV_CONTROLFRAME = 0x8000000
	// Position of PAUSE field.
	ETHERNET_RSV_PAUSE_Pos = 0x1c
	// Bit mask of PAUSE field.
	ETHERNET_RSV_PAUSE_Msk = 0x10000000
	// Bit PAUSE.
	ETHERNET_RSV_PAUSE = 0x10000000
	// Position of UO field.
	ETHERNET_RSV_UO_Pos = 0x1d
	// Bit mask of UO field.
	ETHERNET_RSV_UO_Msk = 0x20000000
	// Bit UO.
	ETHERNET_RSV_UO = 0x20000000
	// Position of VLAN field.
	ETHERNET_RSV_VLAN_Pos = 0x1e
	// Bit mask of VLAN field.
	ETHERNET_RSV_VLAN_Msk = 0x40000000
	// Bit VLAN.
	ETHERNET_RSV_VLAN = 0x40000000
	// Position of RESERVED field.
	ETHERNET_RSV_RESERVED_Pos = 0x1f
	// Bit mask of RESERVED field.
	ETHERNET_RSV_RESERVED_Msk = 0x80000000
	// Bit RESERVED.
	ETHERNET_RSV_RESERVED = 0x80000000

	// FLOWCONTROLCOUNTER: Flow control counter register.
	// Position of MC field.
	ETHERNET_FLOWCONTROLCOUNTER_MC_Pos = 0x0
	// Bit mask of MC field.
	ETHERNET_FLOWCONTROLCOUNTER_MC_Msk = 0xffff
	// Position of PT field.
	ETHERNET_FLOWCONTROLCOUNTER_PT_Pos = 0x10
	// Bit mask of PT field.
	ETHERNET_FLOWCONTROLCOUNTER_PT_Msk = 0xffff0000

	// FLOWCONTROLSTATUS: Flow control status register.
	// Position of MCC field.
	ETHERNET_FLOWCONTROLSTATUS_MCC_Pos = 0x0
	// Bit mask of MCC field.
	ETHERNET_FLOWCONTROLSTATUS_MCC_Msk = 0xffff
	// Position of RESERVED field.
	ETHERNET_FLOWCONTROLSTATUS_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ETHERNET_FLOWCONTROLSTATUS_RESERVED_Msk = 0xffff0000

	// RXFILTERCTRL: Receive filter control register.
	// Position of AUE field.
	ETHERNET_RXFILTERCTRL_AUE_Pos = 0x0
	// Bit mask of AUE field.
	ETHERNET_RXFILTERCTRL_AUE_Msk = 0x1
	// Bit AUE.
	ETHERNET_RXFILTERCTRL_AUE = 0x1
	// Position of ABE field.
	ETHERNET_RXFILTERCTRL_ABE_Pos = 0x1
	// Bit mask of ABE field.
	ETHERNET_RXFILTERCTRL_ABE_Msk = 0x2
	// Bit ABE.
	ETHERNET_RXFILTERCTRL_ABE = 0x2
	// Position of AME field.
	ETHERNET_RXFILTERCTRL_AME_Pos = 0x2
	// Bit mask of AME field.
	ETHERNET_RXFILTERCTRL_AME_Msk = 0x4
	// Bit AME.
	ETHERNET_RXFILTERCTRL_AME = 0x4
	// Position of AUHE field.
	ETHERNET_RXFILTERCTRL_AUHE_Pos = 0x3
	// Bit mask of AUHE field.
	ETHERNET_RXFILTERCTRL_AUHE_Msk = 0x8
	// Bit AUHE.
	ETHERNET_RXFILTERCTRL_AUHE = 0x8
	// Position of AMHE field.
	ETHERNET_RXFILTERCTRL_AMHE_Pos = 0x4
	// Bit mask of AMHE field.
	ETHERNET_RXFILTERCTRL_AMHE_Msk = 0x10
	// Bit AMHE.
	ETHERNET_RXFILTERCTRL_AMHE = 0x10
	// Position of APE field.
	ETHERNET_RXFILTERCTRL_APE_Pos = 0x5
	// Bit mask of APE field.
	ETHERNET_RXFILTERCTRL_APE_Msk = 0x20
	// Bit APE.
	ETHERNET_RXFILTERCTRL_APE = 0x20
	// Position of RESERVED field.
	ETHERNET_RXFILTERCTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ETHERNET_RXFILTERCTRL_RESERVED_Msk = 0xfc0
	// Position of MPEW field.
	ETHERNET_RXFILTERCTRL_MPEW_Pos = 0xc
	// Bit mask of MPEW field.
	ETHERNET_RXFILTERCTRL_MPEW_Msk = 0x1000
	// Bit MPEW.
	ETHERNET_RXFILTERCTRL_MPEW = 0x1000
	// Position of RFEW field.
	ETHERNET_RXFILTERCTRL_RFEW_Pos = 0xd
	// Bit mask of RFEW field.
	ETHERNET_RXFILTERCTRL_RFEW_Msk = 0x2000
	// Bit RFEW.
	ETHERNET_RXFILTERCTRL_RFEW = 0x2000
	// Position of RESERVED field.
	ETHERNET_RXFILTERCTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	ETHERNET_RXFILTERCTRL_RESERVED_Msk = 0xffffc000

	// RXFILTERWOLSTATUS: Receive filter WoL status register.
	// Position of AUW field.
	ETHERNET_RXFILTERWOLSTATUS_AUW_Pos = 0x0
	// Bit mask of AUW field.
	ETHERNET_RXFILTERWOLSTATUS_AUW_Msk = 0x1
	// Bit AUW.
	ETHERNET_RXFILTERWOLSTATUS_AUW = 0x1
	// Position of ABW field.
	ETHERNET_RXFILTERWOLSTATUS_ABW_Pos = 0x1
	// Bit mask of ABW field.
	ETHERNET_RXFILTERWOLSTATUS_ABW_Msk = 0x2
	// Bit ABW.
	ETHERNET_RXFILTERWOLSTATUS_ABW = 0x2
	// Position of AMW field.
	ETHERNET_RXFILTERWOLSTATUS_AMW_Pos = 0x2
	// Bit mask of AMW field.
	ETHERNET_RXFILTERWOLSTATUS_AMW_Msk = 0x4
	// Bit AMW.
	ETHERNET_RXFILTERWOLSTATUS_AMW = 0x4
	// Position of AUHW field.
	ETHERNET_RXFILTERWOLSTATUS_AUHW_Pos = 0x3
	// Bit mask of AUHW field.
	ETHERNET_RXFILTERWOLSTATUS_AUHW_Msk = 0x8
	// Bit AUHW.
	ETHERNET_RXFILTERWOLSTATUS_AUHW = 0x8
	// Position of AMHW field.
	ETHERNET_RXFILTERWOLSTATUS_AMHW_Pos = 0x4
	// Bit mask of AMHW field.
	ETHERNET_RXFILTERWOLSTATUS_AMHW_Msk = 0x10
	// Bit AMHW.
	ETHERNET_RXFILTERWOLSTATUS_AMHW = 0x10
	// Position of APW field.
	ETHERNET_RXFILTERWOLSTATUS_APW_Pos = 0x5
	// Bit mask of APW field.
	ETHERNET_RXFILTERWOLSTATUS_APW_Msk = 0x20
	// Bit APW.
	ETHERNET_RXFILTERWOLSTATUS_APW = 0x20
	// Position of RESERVED field.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED_Msk = 0x40
	// Bit RESERVED.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED = 0x40
	// Position of RFW field.
	ETHERNET_RXFILTERWOLSTATUS_RFW_Pos = 0x7
	// Bit mask of RFW field.
	ETHERNET_RXFILTERWOLSTATUS_RFW_Msk = 0x80
	// Bit RFW.
	ETHERNET_RXFILTERWOLSTATUS_RFW = 0x80
	// Position of MPW field.
	ETHERNET_RXFILTERWOLSTATUS_MPW_Pos = 0x8
	// Bit mask of MPW field.
	ETHERNET_RXFILTERWOLSTATUS_MPW_Msk = 0x100
	// Bit MPW.
	ETHERNET_RXFILTERWOLSTATUS_MPW = 0x100
	// Position of RESERVED field.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED_Msk = 0xfffffe00

	// RXFILTERWOLCLEAR: Receive filter WoL clear register.
	// Position of AUWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AUWCLR_Pos = 0x0
	// Bit mask of AUWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AUWCLR_Msk = 0x1
	// Bit AUWCLR.
	ETHERNET_RXFILTERWOLCLEAR_AUWCLR = 0x1
	// Position of ABWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_ABWCLR_Pos = 0x1
	// Bit mask of ABWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_ABWCLR_Msk = 0x2
	// Bit ABWCLR.
	ETHERNET_RXFILTERWOLCLEAR_ABWCLR = 0x2
	// Position of AMWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AMWCLR_Pos = 0x2
	// Bit mask of AMWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AMWCLR_Msk = 0x4
	// Bit AMWCLR.
	ETHERNET_RXFILTERWOLCLEAR_AMWCLR = 0x4
	// Position of AUHWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AUHWCLR_Pos = 0x3
	// Bit mask of AUHWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AUHWCLR_Msk = 0x8
	// Bit AUHWCLR.
	ETHERNET_RXFILTERWOLCLEAR_AUHWCLR = 0x8
	// Position of AMHWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AMHWCLR_Pos = 0x4
	// Bit mask of AMHWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AMHWCLR_Msk = 0x10
	// Bit AMHWCLR.
	ETHERNET_RXFILTERWOLCLEAR_AMHWCLR = 0x10
	// Position of APWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_APWCLR_Pos = 0x5
	// Bit mask of APWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_APWCLR_Msk = 0x20
	// Bit APWCLR.
	ETHERNET_RXFILTERWOLCLEAR_APWCLR = 0x20
	// Position of RESERVED field.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED_Msk = 0x40
	// Bit RESERVED.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED = 0x40
	// Position of RFWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_RFWCLR_Pos = 0x7
	// Bit mask of RFWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_RFWCLR_Msk = 0x80
	// Bit RFWCLR.
	ETHERNET_RXFILTERWOLCLEAR_RFWCLR = 0x80
	// Position of MPWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_MPWCLR_Pos = 0x8
	// Bit mask of MPWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_MPWCLR_Msk = 0x100
	// Bit MPWCLR.
	ETHERNET_RXFILTERWOLCLEAR_MPWCLR = 0x100
	// Position of RESERVED field.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED_Msk = 0xfffffe00

	// HASHFILTERL: Hash filter table LSBs register.
	// Position of HFL field.
	ETHERNET_HASHFILTERL_HFL_Pos = 0x0
	// Bit mask of HFL field.
	ETHERNET_HASHFILTERL_HFL_Msk = 0xffffffff

	// HASHFILTERH: Hash filter table MSBs register.
	// Position of HFH field.
	ETHERNET_HASHFILTERH_HFH_Pos = 0x0
	// Bit mask of HFH field.
	ETHERNET_HASHFILTERH_HFH_Msk = 0xffffffff

	// INTSTATUS: Interrupt status register.
	// Position of RXOVERRUNINT field.
	ETHERNET_INTSTATUS_RXOVERRUNINT_Pos = 0x0
	// Bit mask of RXOVERRUNINT field.
	ETHERNET_INTSTATUS_RXOVERRUNINT_Msk = 0x1
	// Bit RXOVERRUNINT.
	ETHERNET_INTSTATUS_RXOVERRUNINT = 0x1
	// Position of RXERRORINT field.
	ETHERNET_INTSTATUS_RXERRORINT_Pos = 0x1
	// Bit mask of RXERRORINT field.
	ETHERNET_INTSTATUS_RXERRORINT_Msk = 0x2
	// Bit RXERRORINT.
	ETHERNET_INTSTATUS_RXERRORINT = 0x2
	// Position of RXFINISHEDINT field.
	ETHERNET_INTSTATUS_RXFINISHEDINT_Pos = 0x2
	// Bit mask of RXFINISHEDINT field.
	ETHERNET_INTSTATUS_RXFINISHEDINT_Msk = 0x4
	// Bit RXFINISHEDINT.
	ETHERNET_INTSTATUS_RXFINISHEDINT = 0x4
	// Position of RXDONEINT field.
	ETHERNET_INTSTATUS_RXDONEINT_Pos = 0x3
	// Bit mask of RXDONEINT field.
	ETHERNET_INTSTATUS_RXDONEINT_Msk = 0x8
	// Bit RXDONEINT.
	ETHERNET_INTSTATUS_RXDONEINT = 0x8
	// Position of TXUNDERRUNINT field.
	ETHERNET_INTSTATUS_TXUNDERRUNINT_Pos = 0x4
	// Bit mask of TXUNDERRUNINT field.
	ETHERNET_INTSTATUS_TXUNDERRUNINT_Msk = 0x10
	// Bit TXUNDERRUNINT.
	ETHERNET_INTSTATUS_TXUNDERRUNINT = 0x10
	// Position of TXERRORINT field.
	ETHERNET_INTSTATUS_TXERRORINT_Pos = 0x5
	// Bit mask of TXERRORINT field.
	ETHERNET_INTSTATUS_TXERRORINT_Msk = 0x20
	// Bit TXERRORINT.
	ETHERNET_INTSTATUS_TXERRORINT = 0x20
	// Position of TXFINISHEDINT field.
	ETHERNET_INTSTATUS_TXFINISHEDINT_Pos = 0x6
	// Bit mask of TXFINISHEDINT field.
	ETHERNET_INTSTATUS_TXFINISHEDINT_Msk = 0x40
	// Bit TXFINISHEDINT.
	ETHERNET_INTSTATUS_TXFINISHEDINT = 0x40
	// Position of TXDONEINT field.
	ETHERNET_INTSTATUS_TXDONEINT_Pos = 0x7
	// Bit mask of TXDONEINT field.
	ETHERNET_INTSTATUS_TXDONEINT_Msk = 0x80
	// Bit TXDONEINT.
	ETHERNET_INTSTATUS_TXDONEINT = 0x80
	// Position of RESERVED field.
	ETHERNET_INTSTATUS_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_INTSTATUS_RESERVED_Msk = 0xf00
	// Position of SOFTINT field.
	ETHERNET_INTSTATUS_SOFTINT_Pos = 0xc
	// Bit mask of SOFTINT field.
	ETHERNET_INTSTATUS_SOFTINT_Msk = 0x1000
	// Bit SOFTINT.
	ETHERNET_INTSTATUS_SOFTINT = 0x1000
	// Position of WAKEUPINT field.
	ETHERNET_INTSTATUS_WAKEUPINT_Pos = 0xd
	// Bit mask of WAKEUPINT field.
	ETHERNET_INTSTATUS_WAKEUPINT_Msk = 0x2000
	// Bit WAKEUPINT.
	ETHERNET_INTSTATUS_WAKEUPINT = 0x2000
	// Position of RESERVED field.
	ETHERNET_INTSTATUS_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	ETHERNET_INTSTATUS_RESERVED_Msk = 0xffffc000

	// INTENABLE: Interrupt enable register.
	// Position of RXOVERRUNINTEN field.
	ETHERNET_INTENABLE_RXOVERRUNINTEN_Pos = 0x0
	// Bit mask of RXOVERRUNINTEN field.
	ETHERNET_INTENABLE_RXOVERRUNINTEN_Msk = 0x1
	// Bit RXOVERRUNINTEN.
	ETHERNET_INTENABLE_RXOVERRUNINTEN = 0x1
	// Position of RXERRORINTEN field.
	ETHERNET_INTENABLE_RXERRORINTEN_Pos = 0x1
	// Bit mask of RXERRORINTEN field.
	ETHERNET_INTENABLE_RXERRORINTEN_Msk = 0x2
	// Bit RXERRORINTEN.
	ETHERNET_INTENABLE_RXERRORINTEN = 0x2
	// Position of RXFINISHEDINTEN field.
	ETHERNET_INTENABLE_RXFINISHEDINTEN_Pos = 0x2
	// Bit mask of RXFINISHEDINTEN field.
	ETHERNET_INTENABLE_RXFINISHEDINTEN_Msk = 0x4
	// Bit RXFINISHEDINTEN.
	ETHERNET_INTENABLE_RXFINISHEDINTEN = 0x4
	// Position of RXDONEINTEN field.
	ETHERNET_INTENABLE_RXDONEINTEN_Pos = 0x3
	// Bit mask of RXDONEINTEN field.
	ETHERNET_INTENABLE_RXDONEINTEN_Msk = 0x8
	// Bit RXDONEINTEN.
	ETHERNET_INTENABLE_RXDONEINTEN = 0x8
	// Position of TXUNDERRUNINTEN field.
	ETHERNET_INTENABLE_TXUNDERRUNINTEN_Pos = 0x4
	// Bit mask of TXUNDERRUNINTEN field.
	ETHERNET_INTENABLE_TXUNDERRUNINTEN_Msk = 0x10
	// Bit TXUNDERRUNINTEN.
	ETHERNET_INTENABLE_TXUNDERRUNINTEN = 0x10
	// Position of TXERRORINTEN field.
	ETHERNET_INTENABLE_TXERRORINTEN_Pos = 0x5
	// Bit mask of TXERRORINTEN field.
	ETHERNET_INTENABLE_TXERRORINTEN_Msk = 0x20
	// Bit TXERRORINTEN.
	ETHERNET_INTENABLE_TXERRORINTEN = 0x20
	// Position of TXFINISHEDINTEN field.
	ETHERNET_INTENABLE_TXFINISHEDINTEN_Pos = 0x6
	// Bit mask of TXFINISHEDINTEN field.
	ETHERNET_INTENABLE_TXFINISHEDINTEN_Msk = 0x40
	// Bit TXFINISHEDINTEN.
	ETHERNET_INTENABLE_TXFINISHEDINTEN = 0x40
	// Position of TXDONEINTEN field.
	ETHERNET_INTENABLE_TXDONEINTEN_Pos = 0x7
	// Bit mask of TXDONEINTEN field.
	ETHERNET_INTENABLE_TXDONEINTEN_Msk = 0x80
	// Bit TXDONEINTEN.
	ETHERNET_INTENABLE_TXDONEINTEN = 0x80
	// Position of RESERVED field.
	ETHERNET_INTENABLE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_INTENABLE_RESERVED_Msk = 0xf00
	// Position of SOFTINTEN field.
	ETHERNET_INTENABLE_SOFTINTEN_Pos = 0xc
	// Bit mask of SOFTINTEN field.
	ETHERNET_INTENABLE_SOFTINTEN_Msk = 0x1000
	// Bit SOFTINTEN.
	ETHERNET_INTENABLE_SOFTINTEN = 0x1000
	// Position of WAKEUPINTEN field.
	ETHERNET_INTENABLE_WAKEUPINTEN_Pos = 0xd
	// Bit mask of WAKEUPINTEN field.
	ETHERNET_INTENABLE_WAKEUPINTEN_Msk = 0x2000
	// Bit WAKEUPINTEN.
	ETHERNET_INTENABLE_WAKEUPINTEN = 0x2000
	// Position of RESERVED field.
	ETHERNET_INTENABLE_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	ETHERNET_INTENABLE_RESERVED_Msk = 0xffffc000

	// INTCLEAR: Interrupt clear register.
	// Position of RXOVERRUNINTCLR field.
	ETHERNET_INTCLEAR_RXOVERRUNINTCLR_Pos = 0x0
	// Bit mask of RXOVERRUNINTCLR field.
	ETHERNET_INTCLEAR_RXOVERRUNINTCLR_Msk = 0x1
	// Bit RXOVERRUNINTCLR.
	ETHERNET_INTCLEAR_RXOVERRUNINTCLR = 0x1
	// Position of RXERRORINTCLR field.
	ETHERNET_INTCLEAR_RXERRORINTCLR_Pos = 0x1
	// Bit mask of RXERRORINTCLR field.
	ETHERNET_INTCLEAR_RXERRORINTCLR_Msk = 0x2
	// Bit RXERRORINTCLR.
	ETHERNET_INTCLEAR_RXERRORINTCLR = 0x2
	// Position of RXFINISHEDINTCLR field.
	ETHERNET_INTCLEAR_RXFINISHEDINTCLR_Pos = 0x2
	// Bit mask of RXFINISHEDINTCLR field.
	ETHERNET_INTCLEAR_RXFINISHEDINTCLR_Msk = 0x4
	// Bit RXFINISHEDINTCLR.
	ETHERNET_INTCLEAR_RXFINISHEDINTCLR = 0x4
	// Position of RXDONEINTCLR field.
	ETHERNET_INTCLEAR_RXDONEINTCLR_Pos = 0x3
	// Bit mask of RXDONEINTCLR field.
	ETHERNET_INTCLEAR_RXDONEINTCLR_Msk = 0x8
	// Bit RXDONEINTCLR.
	ETHERNET_INTCLEAR_RXDONEINTCLR = 0x8
	// Position of TXUNDERRUNINTCLR field.
	ETHERNET_INTCLEAR_TXUNDERRUNINTCLR_Pos = 0x4
	// Bit mask of TXUNDERRUNINTCLR field.
	ETHERNET_INTCLEAR_TXUNDERRUNINTCLR_Msk = 0x10
	// Bit TXUNDERRUNINTCLR.
	ETHERNET_INTCLEAR_TXUNDERRUNINTCLR = 0x10
	// Position of TXERRORINTCLR field.
	ETHERNET_INTCLEAR_TXERRORINTCLR_Pos = 0x5
	// Bit mask of TXERRORINTCLR field.
	ETHERNET_INTCLEAR_TXERRORINTCLR_Msk = 0x20
	// Bit TXERRORINTCLR.
	ETHERNET_INTCLEAR_TXERRORINTCLR = 0x20
	// Position of TXFINISHEDINTCLR field.
	ETHERNET_INTCLEAR_TXFINISHEDINTCLR_Pos = 0x6
	// Bit mask of TXFINISHEDINTCLR field.
	ETHERNET_INTCLEAR_TXFINISHEDINTCLR_Msk = 0x40
	// Bit TXFINISHEDINTCLR.
	ETHERNET_INTCLEAR_TXFINISHEDINTCLR = 0x40
	// Position of TXDONEINTCLR field.
	ETHERNET_INTCLEAR_TXDONEINTCLR_Pos = 0x7
	// Bit mask of TXDONEINTCLR field.
	ETHERNET_INTCLEAR_TXDONEINTCLR_Msk = 0x80
	// Bit TXDONEINTCLR.
	ETHERNET_INTCLEAR_TXDONEINTCLR = 0x80
	// Position of RESERVED field.
	ETHERNET_INTCLEAR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_INTCLEAR_RESERVED_Msk = 0xf00
	// Position of SOFTINTCLR field.
	ETHERNET_INTCLEAR_SOFTINTCLR_Pos = 0xc
	// Bit mask of SOFTINTCLR field.
	ETHERNET_INTCLEAR_SOFTINTCLR_Msk = 0x1000
	// Bit SOFTINTCLR.
	ETHERNET_INTCLEAR_SOFTINTCLR = 0x1000
	// Position of WAKEUPINTCLR field.
	ETHERNET_INTCLEAR_WAKEUPINTCLR_Pos = 0xd
	// Bit mask of WAKEUPINTCLR field.
	ETHERNET_INTCLEAR_WAKEUPINTCLR_Msk = 0x2000
	// Bit WAKEUPINTCLR.
	ETHERNET_INTCLEAR_WAKEUPINTCLR = 0x2000
	// Position of RESERVED field.
	ETHERNET_INTCLEAR_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	ETHERNET_INTCLEAR_RESERVED_Msk = 0xffffc000

	// INTSET: Interrupt set register.
	// Position of RXOVERRUNINTSET field.
	ETHERNET_INTSET_RXOVERRUNINTSET_Pos = 0x0
	// Bit mask of RXOVERRUNINTSET field.
	ETHERNET_INTSET_RXOVERRUNINTSET_Msk = 0x1
	// Bit RXOVERRUNINTSET.
	ETHERNET_INTSET_RXOVERRUNINTSET = 0x1
	// Position of RXERRORINTSET field.
	ETHERNET_INTSET_RXERRORINTSET_Pos = 0x1
	// Bit mask of RXERRORINTSET field.
	ETHERNET_INTSET_RXERRORINTSET_Msk = 0x2
	// Bit RXERRORINTSET.
	ETHERNET_INTSET_RXERRORINTSET = 0x2
	// Position of RXFINISHEDINTSET field.
	ETHERNET_INTSET_RXFINISHEDINTSET_Pos = 0x2
	// Bit mask of RXFINISHEDINTSET field.
	ETHERNET_INTSET_RXFINISHEDINTSET_Msk = 0x4
	// Bit RXFINISHEDINTSET.
	ETHERNET_INTSET_RXFINISHEDINTSET = 0x4
	// Position of RXDONEINTSET field.
	ETHERNET_INTSET_RXDONEINTSET_Pos = 0x3
	// Bit mask of RXDONEINTSET field.
	ETHERNET_INTSET_RXDONEINTSET_Msk = 0x8
	// Bit RXDONEINTSET.
	ETHERNET_INTSET_RXDONEINTSET = 0x8
	// Position of TXUNDERRUNINTSET field.
	ETHERNET_INTSET_TXUNDERRUNINTSET_Pos = 0x4
	// Bit mask of TXUNDERRUNINTSET field.
	ETHERNET_INTSET_TXUNDERRUNINTSET_Msk = 0x10
	// Bit TXUNDERRUNINTSET.
	ETHERNET_INTSET_TXUNDERRUNINTSET = 0x10
	// Position of TXERRORINTSET field.
	ETHERNET_INTSET_TXERRORINTSET_Pos = 0x5
	// Bit mask of TXERRORINTSET field.
	ETHERNET_INTSET_TXERRORINTSET_Msk = 0x20
	// Bit TXERRORINTSET.
	ETHERNET_INTSET_TXERRORINTSET = 0x20
	// Position of TXFINISHEDINTSET field.
	ETHERNET_INTSET_TXFINISHEDINTSET_Pos = 0x6
	// Bit mask of TXFINISHEDINTSET field.
	ETHERNET_INTSET_TXFINISHEDINTSET_Msk = 0x40
	// Bit TXFINISHEDINTSET.
	ETHERNET_INTSET_TXFINISHEDINTSET = 0x40
	// Position of TXDONEINTSET field.
	ETHERNET_INTSET_TXDONEINTSET_Pos = 0x7
	// Bit mask of TXDONEINTSET field.
	ETHERNET_INTSET_TXDONEINTSET_Msk = 0x80
	// Bit TXDONEINTSET.
	ETHERNET_INTSET_TXDONEINTSET = 0x80
	// Position of RESERVED field.
	ETHERNET_INTSET_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ETHERNET_INTSET_RESERVED_Msk = 0xf00
	// Position of SOFTINTSET field.
	ETHERNET_INTSET_SOFTINTSET_Pos = 0xc
	// Bit mask of SOFTINTSET field.
	ETHERNET_INTSET_SOFTINTSET_Msk = 0x1000
	// Bit SOFTINTSET.
	ETHERNET_INTSET_SOFTINTSET = 0x1000
	// Position of WAKEUPINTSET field.
	ETHERNET_INTSET_WAKEUPINTSET_Pos = 0xd
	// Bit mask of WAKEUPINTSET field.
	ETHERNET_INTSET_WAKEUPINTSET_Msk = 0x2000
	// Bit WAKEUPINTSET.
	ETHERNET_INTSET_WAKEUPINTSET = 0x2000
	// Position of RESERVED field.
	ETHERNET_INTSET_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	ETHERNET_INTSET_RESERVED_Msk = 0xffffc000

	// POWERDOWN: Power-down register.
	// Position of RESERVED field.
	ETHERNET_POWERDOWN_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ETHERNET_POWERDOWN_RESERVED_Msk = 0x7fffffff
	// Position of PD field.
	ETHERNET_POWERDOWN_PD_Pos = 0x1f
	// Bit mask of PD field.
	ETHERNET_POWERDOWN_PD_Msk = 0x80000000
	// Bit PD.
	ETHERNET_POWERDOWN_PD = 0x80000000
)

// Bitfields for LCD: LCD controller
const (
	// TIMH: Horizontal Timing Control register
	// Position of RESERVED field.
	LCD_TIMH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_TIMH_RESERVED_Msk = 0x3
	// Position of PPL field.
	LCD_TIMH_PPL_Pos = 0x2
	// Bit mask of PPL field.
	LCD_TIMH_PPL_Msk = 0xfc
	// Position of HSW field.
	LCD_TIMH_HSW_Pos = 0x8
	// Bit mask of HSW field.
	LCD_TIMH_HSW_Msk = 0xff00
	// Position of HFP field.
	LCD_TIMH_HFP_Pos = 0x10
	// Bit mask of HFP field.
	LCD_TIMH_HFP_Msk = 0xff0000
	// Position of HBP field.
	LCD_TIMH_HBP_Pos = 0x18
	// Bit mask of HBP field.
	LCD_TIMH_HBP_Msk = 0xff000000

	// TIMV: Vertical Timing Control register
	// Position of LPP field.
	LCD_TIMV_LPP_Pos = 0x0
	// Bit mask of LPP field.
	LCD_TIMV_LPP_Msk = 0x3ff
	// Position of VSW field.
	LCD_TIMV_VSW_Pos = 0xa
	// Bit mask of VSW field.
	LCD_TIMV_VSW_Msk = 0xfc00
	// Position of VFP field.
	LCD_TIMV_VFP_Pos = 0x10
	// Bit mask of VFP field.
	LCD_TIMV_VFP_Msk = 0xff0000
	// Position of VBP field.
	LCD_TIMV_VBP_Pos = 0x18
	// Bit mask of VBP field.
	LCD_TIMV_VBP_Msk = 0xff000000

	// POL: Clock and Signal Polarity Control register
	// Position of PCD_LO field.
	LCD_POL_PCD_LO_Pos = 0x0
	// Bit mask of PCD_LO field.
	LCD_POL_PCD_LO_Msk = 0x1f
	// Position of CLKSEL field.
	LCD_POL_CLKSEL_Pos = 0x5
	// Bit mask of CLKSEL field.
	LCD_POL_CLKSEL_Msk = 0x20
	// Bit CLKSEL.
	LCD_POL_CLKSEL = 0x20
	// Position of ACB field.
	LCD_POL_ACB_Pos = 0x6
	// Bit mask of ACB field.
	LCD_POL_ACB_Msk = 0x7c0
	// Position of IVS field.
	LCD_POL_IVS_Pos = 0xb
	// Bit mask of IVS field.
	LCD_POL_IVS_Msk = 0x800
	// Bit IVS.
	LCD_POL_IVS = 0x800
	// Position of IHS field.
	LCD_POL_IHS_Pos = 0xc
	// Bit mask of IHS field.
	LCD_POL_IHS_Msk = 0x1000
	// Bit IHS.
	LCD_POL_IHS = 0x1000
	// Position of IPC field.
	LCD_POL_IPC_Pos = 0xd
	// Bit mask of IPC field.
	LCD_POL_IPC_Msk = 0x2000
	// Bit IPC.
	LCD_POL_IPC = 0x2000
	// Position of IOE field.
	LCD_POL_IOE_Pos = 0xe
	// Bit mask of IOE field.
	LCD_POL_IOE_Msk = 0x4000
	// Bit IOE.
	LCD_POL_IOE = 0x4000
	// Position of RESERVED field.
	LCD_POL_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	LCD_POL_RESERVED_Msk = 0x8000
	// Bit RESERVED.
	LCD_POL_RESERVED = 0x8000
	// Position of CPL field.
	LCD_POL_CPL_Pos = 0x10
	// Bit mask of CPL field.
	LCD_POL_CPL_Msk = 0x3ff0000
	// Position of BCD field.
	LCD_POL_BCD_Pos = 0x1a
	// Bit mask of BCD field.
	LCD_POL_BCD_Msk = 0x4000000
	// Bit BCD.
	LCD_POL_BCD = 0x4000000
	// Position of PCD_HI field.
	LCD_POL_PCD_HI_Pos = 0x1b
	// Bit mask of PCD_HI field.
	LCD_POL_PCD_HI_Msk = 0xf8000000

	// LE: Line End Control register
	// Position of LED field.
	LCD_LE_LED_Pos = 0x0
	// Bit mask of LED field.
	LCD_LE_LED_Msk = 0x7f
	// Position of RESERVED field.
	LCD_LE_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	LCD_LE_RESERVED_Msk = 0xff80
	// Position of LEE field.
	LCD_LE_LEE_Pos = 0x10
	// Bit mask of LEE field.
	LCD_LE_LEE_Msk = 0x10000
	// Bit LEE.
	LCD_LE_LEE = 0x10000
	// Position of RESERVED field.
	LCD_LE_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	LCD_LE_RESERVED_Msk = 0xfffe0000

	// UPBASE: Upper Panel Frame Base Address register
	// Position of RESERVED field.
	LCD_UPBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_UPBASE_RESERVED_Msk = 0x7
	// Position of LCDUPBASE field.
	LCD_UPBASE_LCDUPBASE_Pos = 0x3
	// Bit mask of LCDUPBASE field.
	LCD_UPBASE_LCDUPBASE_Msk = 0xfffffff8

	// LPBASE: Lower Panel Frame Base Address register
	// Position of RESERVED field.
	LCD_LPBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_LPBASE_RESERVED_Msk = 0x7
	// Position of LCDLPBASE field.
	LCD_LPBASE_LCDLPBASE_Pos = 0x3
	// Bit mask of LCDLPBASE field.
	LCD_LPBASE_LCDLPBASE_Msk = 0xfffffff8

	// CTRL: LCD Control register
	// Position of LCDEN field.
	LCD_CTRL_LCDEN_Pos = 0x0
	// Bit mask of LCDEN field.
	LCD_CTRL_LCDEN_Msk = 0x1
	// Bit LCDEN.
	LCD_CTRL_LCDEN = 0x1
	// Position of LCDBPP field.
	LCD_CTRL_LCDBPP_Pos = 0x1
	// Bit mask of LCDBPP field.
	LCD_CTRL_LCDBPP_Msk = 0xe
	// Position of LCDBW field.
	LCD_CTRL_LCDBW_Pos = 0x4
	// Bit mask of LCDBW field.
	LCD_CTRL_LCDBW_Msk = 0x10
	// Bit LCDBW.
	LCD_CTRL_LCDBW = 0x10
	// Position of LCDTFT field.
	LCD_CTRL_LCDTFT_Pos = 0x5
	// Bit mask of LCDTFT field.
	LCD_CTRL_LCDTFT_Msk = 0x20
	// Bit LCDTFT.
	LCD_CTRL_LCDTFT = 0x20
	// Position of LCDMONO8 field.
	LCD_CTRL_LCDMONO8_Pos = 0x6
	// Bit mask of LCDMONO8 field.
	LCD_CTRL_LCDMONO8_Msk = 0x40
	// Bit LCDMONO8.
	LCD_CTRL_LCDMONO8 = 0x40
	// Position of LCDDUAL field.
	LCD_CTRL_LCDDUAL_Pos = 0x7
	// Bit mask of LCDDUAL field.
	LCD_CTRL_LCDDUAL_Msk = 0x80
	// Bit LCDDUAL.
	LCD_CTRL_LCDDUAL = 0x80
	// Position of BGR field.
	LCD_CTRL_BGR_Pos = 0x8
	// Bit mask of BGR field.
	LCD_CTRL_BGR_Msk = 0x100
	// Bit BGR.
	LCD_CTRL_BGR = 0x100
	// Position of BEBO field.
	LCD_CTRL_BEBO_Pos = 0x9
	// Bit mask of BEBO field.
	LCD_CTRL_BEBO_Msk = 0x200
	// Bit BEBO.
	LCD_CTRL_BEBO = 0x200
	// Position of BEPO field.
	LCD_CTRL_BEPO_Pos = 0xa
	// Bit mask of BEPO field.
	LCD_CTRL_BEPO_Msk = 0x400
	// Bit BEPO.
	LCD_CTRL_BEPO = 0x400
	// Position of LCDPWR field.
	LCD_CTRL_LCDPWR_Pos = 0xb
	// Bit mask of LCDPWR field.
	LCD_CTRL_LCDPWR_Msk = 0x800
	// Bit LCDPWR.
	LCD_CTRL_LCDPWR = 0x800
	// Position of LCDVCOMP field.
	LCD_CTRL_LCDVCOMP_Pos = 0xc
	// Bit mask of LCDVCOMP field.
	LCD_CTRL_LCDVCOMP_Msk = 0x3000
	// Position of RESERVED field.
	LCD_CTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	LCD_CTRL_RESERVED_Msk = 0xc000
	// Position of WATERMARK field.
	LCD_CTRL_WATERMARK_Pos = 0x10
	// Bit mask of WATERMARK field.
	LCD_CTRL_WATERMARK_Msk = 0x10000
	// Bit WATERMARK.
	LCD_CTRL_WATERMARK = 0x10000
	// Position of RESERVED field.
	LCD_CTRL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	LCD_CTRL_RESERVED_Msk = 0xfffe0000

	// INTMSK: Interrupt Mask register
	// Position of RESERVED field.
	LCD_INTMSK_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_INTMSK_RESERVED_Msk = 0x1
	// Bit RESERVED.
	LCD_INTMSK_RESERVED = 0x1
	// Position of FUFIM field.
	LCD_INTMSK_FUFIM_Pos = 0x1
	// Bit mask of FUFIM field.
	LCD_INTMSK_FUFIM_Msk = 0x2
	// Bit FUFIM.
	LCD_INTMSK_FUFIM = 0x2
	// Position of LNBUIM field.
	LCD_INTMSK_LNBUIM_Pos = 0x2
	// Bit mask of LNBUIM field.
	LCD_INTMSK_LNBUIM_Msk = 0x4
	// Bit LNBUIM.
	LCD_INTMSK_LNBUIM = 0x4
	// Position of VCOMPIM field.
	LCD_INTMSK_VCOMPIM_Pos = 0x3
	// Bit mask of VCOMPIM field.
	LCD_INTMSK_VCOMPIM_Msk = 0x8
	// Bit VCOMPIM.
	LCD_INTMSK_VCOMPIM = 0x8
	// Position of BERIM field.
	LCD_INTMSK_BERIM_Pos = 0x4
	// Bit mask of BERIM field.
	LCD_INTMSK_BERIM_Msk = 0x10
	// Bit BERIM.
	LCD_INTMSK_BERIM = 0x10
	// Position of RESERVED field.
	LCD_INTMSK_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	LCD_INTMSK_RESERVED_Msk = 0xffffffe0

	// INTRAW: Raw Interrupt Status register
	// Position of RESERVED field.
	LCD_INTRAW_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_INTRAW_RESERVED_Msk = 0x1
	// Bit RESERVED.
	LCD_INTRAW_RESERVED = 0x1
	// Position of FUFRIS field.
	LCD_INTRAW_FUFRIS_Pos = 0x1
	// Bit mask of FUFRIS field.
	LCD_INTRAW_FUFRIS_Msk = 0x2
	// Bit FUFRIS.
	LCD_INTRAW_FUFRIS = 0x2
	// Position of LNBURIS field.
	LCD_INTRAW_LNBURIS_Pos = 0x2
	// Bit mask of LNBURIS field.
	LCD_INTRAW_LNBURIS_Msk = 0x4
	// Bit LNBURIS.
	LCD_INTRAW_LNBURIS = 0x4
	// Position of VCOMPRIS field.
	LCD_INTRAW_VCOMPRIS_Pos = 0x3
	// Bit mask of VCOMPRIS field.
	LCD_INTRAW_VCOMPRIS_Msk = 0x8
	// Bit VCOMPRIS.
	LCD_INTRAW_VCOMPRIS = 0x8
	// Position of BERRAW field.
	LCD_INTRAW_BERRAW_Pos = 0x4
	// Bit mask of BERRAW field.
	LCD_INTRAW_BERRAW_Msk = 0x10
	// Bit BERRAW.
	LCD_INTRAW_BERRAW = 0x10
	// Position of RESERVED field.
	LCD_INTRAW_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	LCD_INTRAW_RESERVED_Msk = 0xffffffe0

	// INTSTAT: Masked Interrupt Status register
	// Position of RESERVED field.
	LCD_INTSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_INTSTAT_RESERVED_Msk = 0x1
	// Bit RESERVED.
	LCD_INTSTAT_RESERVED = 0x1
	// Position of FUFMIS field.
	LCD_INTSTAT_FUFMIS_Pos = 0x1
	// Bit mask of FUFMIS field.
	LCD_INTSTAT_FUFMIS_Msk = 0x2
	// Bit FUFMIS.
	LCD_INTSTAT_FUFMIS = 0x2
	// Position of LNBUMIS field.
	LCD_INTSTAT_LNBUMIS_Pos = 0x2
	// Bit mask of LNBUMIS field.
	LCD_INTSTAT_LNBUMIS_Msk = 0x4
	// Bit LNBUMIS.
	LCD_INTSTAT_LNBUMIS = 0x4
	// Position of VCOMPMIS field.
	LCD_INTSTAT_VCOMPMIS_Pos = 0x3
	// Bit mask of VCOMPMIS field.
	LCD_INTSTAT_VCOMPMIS_Msk = 0x8
	// Bit VCOMPMIS.
	LCD_INTSTAT_VCOMPMIS = 0x8
	// Position of BERMIS field.
	LCD_INTSTAT_BERMIS_Pos = 0x4
	// Bit mask of BERMIS field.
	LCD_INTSTAT_BERMIS_Msk = 0x10
	// Bit BERMIS.
	LCD_INTSTAT_BERMIS = 0x10
	// Position of RESERVED field.
	LCD_INTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	LCD_INTSTAT_RESERVED_Msk = 0xffffffe0

	// INTCLR: Interrupt Clear register
	// Position of RESERVED field.
	LCD_INTCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	LCD_INTCLR_RESERVED_Msk = 0x1
	// Bit RESERVED.
	LCD_INTCLR_RESERVED = 0x1
	// Position of FUFIC field.
	LCD_INTCLR_FUFIC_Pos = 0x1
	// Bit mask of FUFIC field.
	LCD_INTCLR_FUFIC_Msk = 0x2
	// Bit FUFIC.
	LCD_INTCLR_FUFIC = 0x2
	// Position of LNBUIC field.
	LCD_INTCLR_LNBUIC_Pos = 0x2
	// Bit mask of LNBUIC field.
	LCD_INTCLR_LNBUIC_Msk = 0x4
	// Bit LNBUIC.
	LCD_INTCLR_LNBUIC = 0x4
	// Position of VCOMPIC field.
	LCD_INTCLR_VCOMPIC_Pos = 0x3
	// Bit mask of VCOMPIC field.
	LCD_INTCLR_VCOMPIC_Msk = 0x8
	// Bit VCOMPIC.
	LCD_INTCLR_VCOMPIC = 0x8
	// Position of BERIC field.
	LCD_INTCLR_BERIC_Pos = 0x4
	// Bit mask of BERIC field.
	LCD_INTCLR_BERIC_Msk = 0x10
	// Bit BERIC.
	LCD_INTCLR_BERIC = 0x10
	// Position of RESERVED field.
	LCD_INTCLR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	LCD_INTCLR_RESERVED_Msk = 0xffffffe0

	// UPCURR: Upper Panel Current Address Value register
	// Position of LCDUPCURR field.
	LCD_UPCURR_LCDUPCURR_Pos = 0x0
	// Bit mask of LCDUPCURR field.
	LCD_UPCURR_LCDUPCURR_Msk = 0xffffffff

	// LPCURR: Lower Panel Current Address Value register
	// Position of LCDLPCURR field.
	LCD_LPCURR_LCDLPCURR_Pos = 0x0
	// Bit mask of LCDLPCURR field.
	LCD_LPCURR_LCDLPCURR_Msk = 0xffffffff

	// PAL: 256x16-bit Color Palette registers
	// Position of R04_0 field.
	LCD_PAL_R04_0_Pos = 0x0
	// Bit mask of R04_0 field.
	LCD_PAL_R04_0_Msk = 0x1f
	// Position of G04_0 field.
	LCD_PAL_G04_0_Pos = 0x5
	// Bit mask of G04_0 field.
	LCD_PAL_G04_0_Msk = 0x3e0
	// Position of B04_0 field.
	LCD_PAL_B04_0_Pos = 0xa
	// Bit mask of B04_0 field.
	LCD_PAL_B04_0_Msk = 0x7c00
	// Position of I0 field.
	LCD_PAL_I0_Pos = 0xf
	// Bit mask of I0 field.
	LCD_PAL_I0_Msk = 0x8000
	// Bit I0.
	LCD_PAL_I0 = 0x8000
	// Position of R14_0 field.
	LCD_PAL_R14_0_Pos = 0x10
	// Bit mask of R14_0 field.
	LCD_PAL_R14_0_Msk = 0x1f0000
	// Position of G14_0 field.
	LCD_PAL_G14_0_Pos = 0x15
	// Bit mask of G14_0 field.
	LCD_PAL_G14_0_Msk = 0x3e00000
	// Position of B14_0 field.
	LCD_PAL_B14_0_Pos = 0x1a
	// Bit mask of B14_0 field.
	LCD_PAL_B14_0_Msk = 0x7c000000
	// Position of I1 field.
	LCD_PAL_I1_Pos = 0x1f
	// Bit mask of I1 field.
	LCD_PAL_I1_Msk = 0x80000000
	// Bit I1.
	LCD_PAL_I1 = 0x80000000

	// CRSR_IMG: Cursor Image registers
	// Position of CRSR_IMG field.
	LCD_CRSR_IMG_CRSR_IMG_Pos = 0x0
	// Bit mask of CRSR_IMG field.
	LCD_CRSR_IMG_CRSR_IMG_Msk = 0xffffffff

	// CRSR_CTRL: Cursor Control register
	// Position of CRSRON field.
	LCD_CRSR_CTRL_CRSRON_Pos = 0x0
	// Bit mask of CRSRON field.
	LCD_CRSR_CTRL_CRSRON_Msk = 0x1
	// Bit CRSRON.
	LCD_CRSR_CTRL_CRSRON = 0x1
	// Position of RESERVED field.
	LCD_CRSR_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_CTRL_RESERVED_Msk = 0xe
	// Position of CRSRNUM1_0 field.
	LCD_CRSR_CTRL_CRSRNUM1_0_Pos = 0x4
	// Bit mask of CRSRNUM1_0 field.
	LCD_CRSR_CTRL_CRSRNUM1_0_Msk = 0x30
	// Position of RESERVED field.
	LCD_CRSR_CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	LCD_CRSR_CTRL_RESERVED_Msk = 0xffffffc0

	// CRSR_CFG: Cursor Configuration register
	// Position of CRSRSIZE field.
	LCD_CRSR_CFG_CRSRSIZE_Pos = 0x0
	// Bit mask of CRSRSIZE field.
	LCD_CRSR_CFG_CRSRSIZE_Msk = 0x1
	// Bit CRSRSIZE.
	LCD_CRSR_CFG_CRSRSIZE = 0x1
	// Position of FRAMESYNC field.
	LCD_CRSR_CFG_FRAMESYNC_Pos = 0x1
	// Bit mask of FRAMESYNC field.
	LCD_CRSR_CFG_FRAMESYNC_Msk = 0x2
	// Bit FRAMESYNC.
	LCD_CRSR_CFG_FRAMESYNC = 0x2
	// Position of RESERVED field.
	LCD_CRSR_CFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	LCD_CRSR_CFG_RESERVED_Msk = 0xfffffffc

	// CRSR_PAL0: Cursor Palette register 0
	// Position of RED field.
	LCD_CRSR_PAL0_RED_Pos = 0x0
	// Bit mask of RED field.
	LCD_CRSR_PAL0_RED_Msk = 0xff
	// Position of GREEN field.
	LCD_CRSR_PAL0_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	LCD_CRSR_PAL0_GREEN_Msk = 0xff00
	// Position of BLUE field.
	LCD_CRSR_PAL0_BLUE_Pos = 0x10
	// Bit mask of BLUE field.
	LCD_CRSR_PAL0_BLUE_Msk = 0xff0000
	// Position of RESERVED field.
	LCD_CRSR_PAL0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	LCD_CRSR_PAL0_RESERVED_Msk = 0xff000000

	// CRSR_PAL1: Cursor Palette register 1
	// Position of RED field.
	LCD_CRSR_PAL1_RED_Pos = 0x0
	// Bit mask of RED field.
	LCD_CRSR_PAL1_RED_Msk = 0xff
	// Position of GREEN field.
	LCD_CRSR_PAL1_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	LCD_CRSR_PAL1_GREEN_Msk = 0xff00
	// Position of BLUE field.
	LCD_CRSR_PAL1_BLUE_Pos = 0x10
	// Bit mask of BLUE field.
	LCD_CRSR_PAL1_BLUE_Msk = 0xff0000
	// Position of RESERVED field.
	LCD_CRSR_PAL1_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	LCD_CRSR_PAL1_RESERVED_Msk = 0xff000000

	// CRSR_XY: Cursor XY Position register
	// Position of CRSRX field.
	LCD_CRSR_XY_CRSRX_Pos = 0x0
	// Bit mask of CRSRX field.
	LCD_CRSR_XY_CRSRX_Msk = 0x3ff
	// Position of RESERVED field.
	LCD_CRSR_XY_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	LCD_CRSR_XY_RESERVED_Msk = 0xfc00
	// Position of CRSRY field.
	LCD_CRSR_XY_CRSRY_Pos = 0x10
	// Bit mask of CRSRY field.
	LCD_CRSR_XY_CRSRY_Msk = 0x3ff0000
	// Position of RESERVED field.
	LCD_CRSR_XY_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	LCD_CRSR_XY_RESERVED_Msk = 0xfc000000

	// CRSR_CLIP: Cursor Clip Position register
	// Position of CRSRCLIPX field.
	LCD_CRSR_CLIP_CRSRCLIPX_Pos = 0x0
	// Bit mask of CRSRCLIPX field.
	LCD_CRSR_CLIP_CRSRCLIPX_Msk = 0x3f
	// Position of RESERVED field.
	LCD_CRSR_CLIP_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	LCD_CRSR_CLIP_RESERVED_Msk = 0xc0
	// Position of CRSRCLIPY field.
	LCD_CRSR_CLIP_CRSRCLIPY_Pos = 0x8
	// Bit mask of CRSRCLIPY field.
	LCD_CRSR_CLIP_CRSRCLIPY_Msk = 0x3f00
	// Position of RESERVED field.
	LCD_CRSR_CLIP_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	LCD_CRSR_CLIP_RESERVED_Msk = 0xffffc000

	// CRSR_INTMSK: Cursor Interrupt Mask register
	// Position of CRSRIM field.
	LCD_CRSR_INTMSK_CRSRIM_Pos = 0x0
	// Bit mask of CRSRIM field.
	LCD_CRSR_INTMSK_CRSRIM_Msk = 0x1
	// Bit CRSRIM.
	LCD_CRSR_INTMSK_CRSRIM = 0x1
	// Position of RESERVED field.
	LCD_CRSR_INTMSK_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_INTMSK_RESERVED_Msk = 0xfffffffe

	// CRSR_INTCLR: Cursor Interrupt Clear register
	// Position of CRSRIC field.
	LCD_CRSR_INTCLR_CRSRIC_Pos = 0x0
	// Bit mask of CRSRIC field.
	LCD_CRSR_INTCLR_CRSRIC_Msk = 0x1
	// Bit CRSRIC.
	LCD_CRSR_INTCLR_CRSRIC = 0x1
	// Position of RESERVED field.
	LCD_CRSR_INTCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_INTCLR_RESERVED_Msk = 0xfffffffe

	// CRSR_INTRAW: Cursor Raw Interrupt Status register
	// Position of CRSRRIS field.
	LCD_CRSR_INTRAW_CRSRRIS_Pos = 0x0
	// Bit mask of CRSRRIS field.
	LCD_CRSR_INTRAW_CRSRRIS_Msk = 0x1
	// Bit CRSRRIS.
	LCD_CRSR_INTRAW_CRSRRIS = 0x1
	// Position of RESERVED field.
	LCD_CRSR_INTRAW_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_INTRAW_RESERVED_Msk = 0xfffffffe

	// CRSR_INTSTAT: Cursor Masked Interrupt Status register
	// Position of CRSRMIS field.
	LCD_CRSR_INTSTAT_CRSRMIS_Pos = 0x0
	// Bit mask of CRSRMIS field.
	LCD_CRSR_INTSTAT_CRSRMIS_Msk = 0x1
	// Bit CRSRMIS.
	LCD_CRSR_INTSTAT_CRSRMIS = 0x1
	// Position of RESERVED field.
	LCD_CRSR_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	LCD_CRSR_INTSTAT_RESERVED_Msk = 0xfffffffe
)

// Bitfields for USB: USB device/host/OTG controller
const (
	// RXPLEN: USB Receive Packet Length
	// Position of PKT_LNGTH field.
	USB_RXPLEN_PKT_LNGTH_Pos = 0x0
	// Bit mask of PKT_LNGTH field.
	USB_RXPLEN_PKT_LNGTH_Msk = 0x3ff
	// Position of DV field.
	USB_RXPLEN_DV_Pos = 0xa
	// Bit mask of DV field.
	USB_RXPLEN_DV_Msk = 0x400
	// Bit DV.
	USB_RXPLEN_DV = 0x400
	// Data is invalid.
	USB_RXPLEN_DV_DATA_IS_INVALID_ = 0x0
	// Data is valid.
	USB_RXPLEN_DV_DATA_IS_VALID_ = 0x1
	// Position of PKT_RDY field.
	USB_RXPLEN_PKT_RDY_Pos = 0xb
	// Bit mask of PKT_RDY field.
	USB_RXPLEN_PKT_RDY_Msk = 0x800
	// Bit PKT_RDY.
	USB_RXPLEN_PKT_RDY = 0x800
	// Position of RESERVED field.
	USB_RXPLEN_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB_RXPLEN_RESERVED_Msk = 0xfffff000

	// INTST: OTG Interrupt Status
	// Position of TMR field.
	USB_INTST_TMR_Pos = 0x0
	// Bit mask of TMR field.
	USB_INTST_TMR_Msk = 0x1
	// Bit TMR.
	USB_INTST_TMR = 0x1
	// Position of REMOVE_PU field.
	USB_INTST_REMOVE_PU_Pos = 0x1
	// Bit mask of REMOVE_PU field.
	USB_INTST_REMOVE_PU_Msk = 0x2
	// Bit REMOVE_PU.
	USB_INTST_REMOVE_PU = 0x2
	// Position of HNP_FAILURE field.
	USB_INTST_HNP_FAILURE_Pos = 0x2
	// Bit mask of HNP_FAILURE field.
	USB_INTST_HNP_FAILURE_Msk = 0x4
	// Bit HNP_FAILURE.
	USB_INTST_HNP_FAILURE = 0x4
	// Position of HNP_SUCCESS field.
	USB_INTST_HNP_SUCCESS_Pos = 0x3
	// Bit mask of HNP_SUCCESS field.
	USB_INTST_HNP_SUCCESS_Msk = 0x8
	// Bit HNP_SUCCESS.
	USB_INTST_HNP_SUCCESS = 0x8
	// Position of RESERVED field.
	USB_INTST_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB_INTST_RESERVED_Msk = 0xfffffff0

	// INTEN: OTG Interrupt Enable
	// Position of TMR_EN field.
	USB_INTEN_TMR_EN_Pos = 0x0
	// Bit mask of TMR_EN field.
	USB_INTEN_TMR_EN_Msk = 0x1
	// Bit TMR_EN.
	USB_INTEN_TMR_EN = 0x1
	// Position of REMOVE_PU_EN field.
	USB_INTEN_REMOVE_PU_EN_Pos = 0x1
	// Bit mask of REMOVE_PU_EN field.
	USB_INTEN_REMOVE_PU_EN_Msk = 0x2
	// Bit REMOVE_PU_EN.
	USB_INTEN_REMOVE_PU_EN = 0x2
	// Position of HNP_FAILURE_EN field.
	USB_INTEN_HNP_FAILURE_EN_Pos = 0x2
	// Bit mask of HNP_FAILURE_EN field.
	USB_INTEN_HNP_FAILURE_EN_Msk = 0x4
	// Bit HNP_FAILURE_EN.
	USB_INTEN_HNP_FAILURE_EN = 0x4
	// Position of HNP_SUCCES_EN field.
	USB_INTEN_HNP_SUCCES_EN_Pos = 0x3
	// Bit mask of HNP_SUCCES_EN field.
	USB_INTEN_HNP_SUCCES_EN_Msk = 0x8
	// Bit HNP_SUCCES_EN.
	USB_INTEN_HNP_SUCCES_EN = 0x8
	// Position of RESERVED field.
	USB_INTEN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB_INTEN_RESERVED_Msk = 0xfffffff0

	// INTSET: OTG Interrupt Set
	// Position of TMR_SET field.
	USB_INTSET_TMR_SET_Pos = 0x0
	// Bit mask of TMR_SET field.
	USB_INTSET_TMR_SET_Msk = 0x1
	// Bit TMR_SET.
	USB_INTSET_TMR_SET = 0x1
	// Position of REMOVE_PU_SET field.
	USB_INTSET_REMOVE_PU_SET_Pos = 0x1
	// Bit mask of REMOVE_PU_SET field.
	USB_INTSET_REMOVE_PU_SET_Msk = 0x2
	// Bit REMOVE_PU_SET.
	USB_INTSET_REMOVE_PU_SET = 0x2
	// Position of HNP_FAILURE_SET field.
	USB_INTSET_HNP_FAILURE_SET_Pos = 0x2
	// Bit mask of HNP_FAILURE_SET field.
	USB_INTSET_HNP_FAILURE_SET_Msk = 0x4
	// Bit HNP_FAILURE_SET.
	USB_INTSET_HNP_FAILURE_SET = 0x4
	// Position of HNP_SUCCES_SET field.
	USB_INTSET_HNP_SUCCES_SET_Pos = 0x3
	// Bit mask of HNP_SUCCES_SET field.
	USB_INTSET_HNP_SUCCES_SET_Msk = 0x8
	// Bit HNP_SUCCES_SET.
	USB_INTSET_HNP_SUCCES_SET = 0x8
	// Position of RESERVED field.
	USB_INTSET_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB_INTSET_RESERVED_Msk = 0xfffffff0

	// INTCLR: OTG Interrupt Clear
	// Position of TMR_CLR field.
	USB_INTCLR_TMR_CLR_Pos = 0x0
	// Bit mask of TMR_CLR field.
	USB_INTCLR_TMR_CLR_Msk = 0x1
	// Bit TMR_CLR.
	USB_INTCLR_TMR_CLR = 0x1
	// Position of REMOVE_PU_CLR field.
	USB_INTCLR_REMOVE_PU_CLR_Pos = 0x1
	// Bit mask of REMOVE_PU_CLR field.
	USB_INTCLR_REMOVE_PU_CLR_Msk = 0x2
	// Bit REMOVE_PU_CLR.
	USB_INTCLR_REMOVE_PU_CLR = 0x2
	// Position of HNP_FAILURE_CLR field.
	USB_INTCLR_HNP_FAILURE_CLR_Pos = 0x2
	// Bit mask of HNP_FAILURE_CLR field.
	USB_INTCLR_HNP_FAILURE_CLR_Msk = 0x4
	// Bit HNP_FAILURE_CLR.
	USB_INTCLR_HNP_FAILURE_CLR = 0x4
	// Position of HNP_SUCCES_CLR field.
	USB_INTCLR_HNP_SUCCES_CLR_Pos = 0x3
	// Bit mask of HNP_SUCCES_CLR field.
	USB_INTCLR_HNP_SUCCES_CLR_Msk = 0x8
	// Bit HNP_SUCCES_CLR.
	USB_INTCLR_HNP_SUCCES_CLR = 0x8
	// Position of RESERVED field.
	USB_INTCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USB_INTCLR_RESERVED_Msk = 0xfffffff0

	// STCTRL: OTG Status and Control and USB port select
	// Position of PORT_FUNC field.
	USB_STCTRL_PORT_FUNC_Pos = 0x0
	// Bit mask of PORT_FUNC field.
	USB_STCTRL_PORT_FUNC_Msk = 0x3
	// Position of TMR_SCALE field.
	USB_STCTRL_TMR_SCALE_Pos = 0x2
	// Bit mask of TMR_SCALE field.
	USB_STCTRL_TMR_SCALE_Msk = 0xc
	// Position of TMR_MODE field.
	USB_STCTRL_TMR_MODE_Pos = 0x4
	// Bit mask of TMR_MODE field.
	USB_STCTRL_TMR_MODE_Msk = 0x10
	// Bit TMR_MODE.
	USB_STCTRL_TMR_MODE = 0x10
	// Position of TMR_EN field.
	USB_STCTRL_TMR_EN_Pos = 0x5
	// Bit mask of TMR_EN field.
	USB_STCTRL_TMR_EN_Msk = 0x20
	// Bit TMR_EN.
	USB_STCTRL_TMR_EN = 0x20
	// Position of TMR_RST field.
	USB_STCTRL_TMR_RST_Pos = 0x6
	// Bit mask of TMR_RST field.
	USB_STCTRL_TMR_RST_Msk = 0x40
	// Bit TMR_RST.
	USB_STCTRL_TMR_RST = 0x40
	// Position of RESERVED field.
	USB_STCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USB_STCTRL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USB_STCTRL_RESERVED = 0x80
	// Position of B_HNP_TRACK field.
	USB_STCTRL_B_HNP_TRACK_Pos = 0x8
	// Bit mask of B_HNP_TRACK field.
	USB_STCTRL_B_HNP_TRACK_Msk = 0x100
	// Bit B_HNP_TRACK.
	USB_STCTRL_B_HNP_TRACK = 0x100
	// Position of A_HNP_TRACK field.
	USB_STCTRL_A_HNP_TRACK_Pos = 0x9
	// Bit mask of A_HNP_TRACK field.
	USB_STCTRL_A_HNP_TRACK_Msk = 0x200
	// Bit A_HNP_TRACK.
	USB_STCTRL_A_HNP_TRACK = 0x200
	// Position of PU_REMOVED field.
	USB_STCTRL_PU_REMOVED_Pos = 0xa
	// Bit mask of PU_REMOVED field.
	USB_STCTRL_PU_REMOVED_Msk = 0x400
	// Bit PU_REMOVED.
	USB_STCTRL_PU_REMOVED = 0x400
	// Position of RESERVED field.
	USB_STCTRL_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	USB_STCTRL_RESERVED_Msk = 0xf800
	// Position of TMR_CNT field.
	USB_STCTRL_TMR_CNT_Pos = 0x10
	// Bit mask of TMR_CNT field.
	USB_STCTRL_TMR_CNT_Msk = 0xffff0000

	// TMR: OTG Timer
	// Position of TIMEOUT_CNT field.
	USB_TMR_TIMEOUT_CNT_Pos = 0x0
	// Bit mask of TIMEOUT_CNT field.
	USB_TMR_TIMEOUT_CNT_Msk = 0xffff
	// Position of RESERVED field.
	USB_TMR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USB_TMR_RESERVED_Msk = 0xffff0000

	// DEVINTST: USB Device Interrupt Status
	// Position of FRAME field.
	USB_DEVINTST_FRAME_Pos = 0x0
	// Bit mask of FRAME field.
	USB_DEVINTST_FRAME_Msk = 0x1
	// Bit FRAME.
	USB_DEVINTST_FRAME = 0x1
	// Position of EP_FAST field.
	USB_DEVINTST_EP_FAST_Pos = 0x1
	// Bit mask of EP_FAST field.
	USB_DEVINTST_EP_FAST_Msk = 0x2
	// Bit EP_FAST.
	USB_DEVINTST_EP_FAST = 0x2
	// Position of EP_SLOW field.
	USB_DEVINTST_EP_SLOW_Pos = 0x2
	// Bit mask of EP_SLOW field.
	USB_DEVINTST_EP_SLOW_Msk = 0x4
	// Bit EP_SLOW.
	USB_DEVINTST_EP_SLOW = 0x4
	// Position of DEV_STAT field.
	USB_DEVINTST_DEV_STAT_Pos = 0x3
	// Bit mask of DEV_STAT field.
	USB_DEVINTST_DEV_STAT_Msk = 0x8
	// Bit DEV_STAT.
	USB_DEVINTST_DEV_STAT = 0x8
	// Position of CCEMPTY field.
	USB_DEVINTST_CCEMPTY_Pos = 0x4
	// Bit mask of CCEMPTY field.
	USB_DEVINTST_CCEMPTY_Msk = 0x10
	// Bit CCEMPTY.
	USB_DEVINTST_CCEMPTY = 0x10
	// Position of CDFULL field.
	USB_DEVINTST_CDFULL_Pos = 0x5
	// Bit mask of CDFULL field.
	USB_DEVINTST_CDFULL_Msk = 0x20
	// Bit CDFULL.
	USB_DEVINTST_CDFULL = 0x20
	// Position of RxENDPKT field.
	USB_DEVINTST_RxENDPKT_Pos = 0x6
	// Bit mask of RxENDPKT field.
	USB_DEVINTST_RxENDPKT_Msk = 0x40
	// Bit RxENDPKT.
	USB_DEVINTST_RxENDPKT = 0x40
	// Position of TxENDPKT field.
	USB_DEVINTST_TxENDPKT_Pos = 0x7
	// Bit mask of TxENDPKT field.
	USB_DEVINTST_TxENDPKT_Msk = 0x80
	// Bit TxENDPKT.
	USB_DEVINTST_TxENDPKT = 0x80
	// Position of EP_RLZED field.
	USB_DEVINTST_EP_RLZED_Pos = 0x8
	// Bit mask of EP_RLZED field.
	USB_DEVINTST_EP_RLZED_Msk = 0x100
	// Bit EP_RLZED.
	USB_DEVINTST_EP_RLZED = 0x100
	// Position of ERR_INT field.
	USB_DEVINTST_ERR_INT_Pos = 0x9
	// Bit mask of ERR_INT field.
	USB_DEVINTST_ERR_INT_Msk = 0x200
	// Bit ERR_INT.
	USB_DEVINTST_ERR_INT = 0x200
	// Position of RESERVED field.
	USB_DEVINTST_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_DEVINTST_RESERVED_Msk = 0xfffffc00

	// DEVINTEN: USB Device Interrupt Enable
	// Position of FRAMEEN field.
	USB_DEVINTEN_FRAMEEN_Pos = 0x0
	// Bit mask of FRAMEEN field.
	USB_DEVINTEN_FRAMEEN_Msk = 0x1
	// Bit FRAMEEN.
	USB_DEVINTEN_FRAMEEN = 0x1
	// Position of EP_FASTEN field.
	USB_DEVINTEN_EP_FASTEN_Pos = 0x1
	// Bit mask of EP_FASTEN field.
	USB_DEVINTEN_EP_FASTEN_Msk = 0x2
	// Bit EP_FASTEN.
	USB_DEVINTEN_EP_FASTEN = 0x2
	// Position of EP_SLOWEN field.
	USB_DEVINTEN_EP_SLOWEN_Pos = 0x2
	// Bit mask of EP_SLOWEN field.
	USB_DEVINTEN_EP_SLOWEN_Msk = 0x4
	// Bit EP_SLOWEN.
	USB_DEVINTEN_EP_SLOWEN = 0x4
	// Position of DEV_STATEN field.
	USB_DEVINTEN_DEV_STATEN_Pos = 0x3
	// Bit mask of DEV_STATEN field.
	USB_DEVINTEN_DEV_STATEN_Msk = 0x8
	// Bit DEV_STATEN.
	USB_DEVINTEN_DEV_STATEN = 0x8
	// Position of CCEMPTYEN field.
	USB_DEVINTEN_CCEMPTYEN_Pos = 0x4
	// Bit mask of CCEMPTYEN field.
	USB_DEVINTEN_CCEMPTYEN_Msk = 0x10
	// Bit CCEMPTYEN.
	USB_DEVINTEN_CCEMPTYEN = 0x10
	// Position of CDFULLEN field.
	USB_DEVINTEN_CDFULLEN_Pos = 0x5
	// Bit mask of CDFULLEN field.
	USB_DEVINTEN_CDFULLEN_Msk = 0x20
	// Bit CDFULLEN.
	USB_DEVINTEN_CDFULLEN = 0x20
	// Position of RxENDPKTEN field.
	USB_DEVINTEN_RxENDPKTEN_Pos = 0x6
	// Bit mask of RxENDPKTEN field.
	USB_DEVINTEN_RxENDPKTEN_Msk = 0x40
	// Bit RxENDPKTEN.
	USB_DEVINTEN_RxENDPKTEN = 0x40
	// Position of TxENDPKTEN field.
	USB_DEVINTEN_TxENDPKTEN_Pos = 0x7
	// Bit mask of TxENDPKTEN field.
	USB_DEVINTEN_TxENDPKTEN_Msk = 0x80
	// Bit TxENDPKTEN.
	USB_DEVINTEN_TxENDPKTEN = 0x80
	// Position of EP_RLZEDEN field.
	USB_DEVINTEN_EP_RLZEDEN_Pos = 0x8
	// Bit mask of EP_RLZEDEN field.
	USB_DEVINTEN_EP_RLZEDEN_Msk = 0x100
	// Bit EP_RLZEDEN.
	USB_DEVINTEN_EP_RLZEDEN = 0x100
	// Position of ERR_INTEN field.
	USB_DEVINTEN_ERR_INTEN_Pos = 0x9
	// Bit mask of ERR_INTEN field.
	USB_DEVINTEN_ERR_INTEN_Msk = 0x200
	// Bit ERR_INTEN.
	USB_DEVINTEN_ERR_INTEN = 0x200
	// Position of RESERVED field.
	USB_DEVINTEN_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_DEVINTEN_RESERVED_Msk = 0xfffffc00

	// DEVINTCLR: USB Device Interrupt Clear
	// Position of FRAMECLR field.
	USB_DEVINTCLR_FRAMECLR_Pos = 0x0
	// Bit mask of FRAMECLR field.
	USB_DEVINTCLR_FRAMECLR_Msk = 0x1
	// Bit FRAMECLR.
	USB_DEVINTCLR_FRAMECLR = 0x1
	// Position of EP_FASTCLR field.
	USB_DEVINTCLR_EP_FASTCLR_Pos = 0x1
	// Bit mask of EP_FASTCLR field.
	USB_DEVINTCLR_EP_FASTCLR_Msk = 0x2
	// Bit EP_FASTCLR.
	USB_DEVINTCLR_EP_FASTCLR = 0x2
	// Position of EP_SLOWCLR field.
	USB_DEVINTCLR_EP_SLOWCLR_Pos = 0x2
	// Bit mask of EP_SLOWCLR field.
	USB_DEVINTCLR_EP_SLOWCLR_Msk = 0x4
	// Bit EP_SLOWCLR.
	USB_DEVINTCLR_EP_SLOWCLR = 0x4
	// Position of DEV_STATCLR field.
	USB_DEVINTCLR_DEV_STATCLR_Pos = 0x3
	// Bit mask of DEV_STATCLR field.
	USB_DEVINTCLR_DEV_STATCLR_Msk = 0x8
	// Bit DEV_STATCLR.
	USB_DEVINTCLR_DEV_STATCLR = 0x8
	// Position of CCEMPTYCLR field.
	USB_DEVINTCLR_CCEMPTYCLR_Pos = 0x4
	// Bit mask of CCEMPTYCLR field.
	USB_DEVINTCLR_CCEMPTYCLR_Msk = 0x10
	// Bit CCEMPTYCLR.
	USB_DEVINTCLR_CCEMPTYCLR = 0x10
	// Position of CDFULLCLR field.
	USB_DEVINTCLR_CDFULLCLR_Pos = 0x5
	// Bit mask of CDFULLCLR field.
	USB_DEVINTCLR_CDFULLCLR_Msk = 0x20
	// Bit CDFULLCLR.
	USB_DEVINTCLR_CDFULLCLR = 0x20
	// Position of RxENDPKTCLR field.
	USB_DEVINTCLR_RxENDPKTCLR_Pos = 0x6
	// Bit mask of RxENDPKTCLR field.
	USB_DEVINTCLR_RxENDPKTCLR_Msk = 0x40
	// Bit RxENDPKTCLR.
	USB_DEVINTCLR_RxENDPKTCLR = 0x40
	// Position of TxENDPKTCLR field.
	USB_DEVINTCLR_TxENDPKTCLR_Pos = 0x7
	// Bit mask of TxENDPKTCLR field.
	USB_DEVINTCLR_TxENDPKTCLR_Msk = 0x80
	// Bit TxENDPKTCLR.
	USB_DEVINTCLR_TxENDPKTCLR = 0x80
	// Position of EP_RLZEDCLR field.
	USB_DEVINTCLR_EP_RLZEDCLR_Pos = 0x8
	// Bit mask of EP_RLZEDCLR field.
	USB_DEVINTCLR_EP_RLZEDCLR_Msk = 0x100
	// Bit EP_RLZEDCLR.
	USB_DEVINTCLR_EP_RLZEDCLR = 0x100
	// Position of ERR_INTCLR field.
	USB_DEVINTCLR_ERR_INTCLR_Pos = 0x9
	// Bit mask of ERR_INTCLR field.
	USB_DEVINTCLR_ERR_INTCLR_Msk = 0x200
	// Bit ERR_INTCLR.
	USB_DEVINTCLR_ERR_INTCLR = 0x200
	// Position of RESERVED field.
	USB_DEVINTCLR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_DEVINTCLR_RESERVED_Msk = 0xfffffc00

	// DEVINTSET: USB Device Interrupt Set
	// Position of FRAMESET field.
	USB_DEVINTSET_FRAMESET_Pos = 0x0
	// Bit mask of FRAMESET field.
	USB_DEVINTSET_FRAMESET_Msk = 0x1
	// Bit FRAMESET.
	USB_DEVINTSET_FRAMESET = 0x1
	// Position of EP_FASTSET field.
	USB_DEVINTSET_EP_FASTSET_Pos = 0x1
	// Bit mask of EP_FASTSET field.
	USB_DEVINTSET_EP_FASTSET_Msk = 0x2
	// Bit EP_FASTSET.
	USB_DEVINTSET_EP_FASTSET = 0x2
	// Position of EP_SLOWSET field.
	USB_DEVINTSET_EP_SLOWSET_Pos = 0x2
	// Bit mask of EP_SLOWSET field.
	USB_DEVINTSET_EP_SLOWSET_Msk = 0x4
	// Bit EP_SLOWSET.
	USB_DEVINTSET_EP_SLOWSET = 0x4
	// Position of DEV_STATSET field.
	USB_DEVINTSET_DEV_STATSET_Pos = 0x3
	// Bit mask of DEV_STATSET field.
	USB_DEVINTSET_DEV_STATSET_Msk = 0x8
	// Bit DEV_STATSET.
	USB_DEVINTSET_DEV_STATSET = 0x8
	// Position of CCEMPTYSET field.
	USB_DEVINTSET_CCEMPTYSET_Pos = 0x4
	// Bit mask of CCEMPTYSET field.
	USB_DEVINTSET_CCEMPTYSET_Msk = 0x10
	// Bit CCEMPTYSET.
	USB_DEVINTSET_CCEMPTYSET = 0x10
	// Position of CDFULLSET field.
	USB_DEVINTSET_CDFULLSET_Pos = 0x5
	// Bit mask of CDFULLSET field.
	USB_DEVINTSET_CDFULLSET_Msk = 0x20
	// Bit CDFULLSET.
	USB_DEVINTSET_CDFULLSET = 0x20
	// Position of RxENDPKTSET field.
	USB_DEVINTSET_RxENDPKTSET_Pos = 0x6
	// Bit mask of RxENDPKTSET field.
	USB_DEVINTSET_RxENDPKTSET_Msk = 0x40
	// Bit RxENDPKTSET.
	USB_DEVINTSET_RxENDPKTSET = 0x40
	// Position of TxENDPKTSET field.
	USB_DEVINTSET_TxENDPKTSET_Pos = 0x7
	// Bit mask of TxENDPKTSET field.
	USB_DEVINTSET_TxENDPKTSET_Msk = 0x80
	// Bit TxENDPKTSET.
	USB_DEVINTSET_TxENDPKTSET = 0x80
	// Position of EP_RLZEDSET field.
	USB_DEVINTSET_EP_RLZEDSET_Pos = 0x8
	// Bit mask of EP_RLZEDSET field.
	USB_DEVINTSET_EP_RLZEDSET_Msk = 0x100
	// Bit EP_RLZEDSET.
	USB_DEVINTSET_EP_RLZEDSET = 0x100
	// Position of ERR_INTSET field.
	USB_DEVINTSET_ERR_INTSET_Pos = 0x9
	// Bit mask of ERR_INTSET field.
	USB_DEVINTSET_ERR_INTSET_Msk = 0x200
	// Bit ERR_INTSET.
	USB_DEVINTSET_ERR_INTSET = 0x200
	// Position of RESERVED field.
	USB_DEVINTSET_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_DEVINTSET_RESERVED_Msk = 0xfffffc00

	// CMDCODE: USB Command Code
	// Position of RESERVED field.
	USB_CMDCODE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_CMDCODE_RESERVED_Msk = 0xff
	// Position of CMD_PHASE field.
	USB_CMDCODE_CMD_PHASE_Pos = 0x8
	// Bit mask of CMD_PHASE field.
	USB_CMDCODE_CMD_PHASE_Msk = 0xff00
	// Read
	USB_CMDCODE_CMD_PHASE_READ = 0x2
	// Write
	USB_CMDCODE_CMD_PHASE_WRITE = 0x1
	// Command
	USB_CMDCODE_CMD_PHASE_COMMAND = 0x5
	// Position of CMD_CODE_WDATA field.
	USB_CMDCODE_CMD_CODE_WDATA_Pos = 0x10
	// Bit mask of CMD_CODE_WDATA field.
	USB_CMDCODE_CMD_CODE_WDATA_Msk = 0xff0000
	// Position of RESERVED field.
	USB_CMDCODE_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USB_CMDCODE_RESERVED_Msk = 0xff000000

	// CMDDATA: USB Command Data
	// Position of CMD_RDATA field.
	USB_CMDDATA_CMD_RDATA_Pos = 0x0
	// Bit mask of CMD_RDATA field.
	USB_CMDDATA_CMD_RDATA_Msk = 0xff
	// Position of RESERVED field.
	USB_CMDDATA_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB_CMDDATA_RESERVED_Msk = 0xffffff00

	// RXDATA: USB Receive Data
	// Position of RX_DATA field.
	USB_RXDATA_RX_DATA_Pos = 0x0
	// Bit mask of RX_DATA field.
	USB_RXDATA_RX_DATA_Msk = 0xffffffff

	// TXDATA: USB Transmit Data
	// Position of TX_DATA field.
	USB_TXDATA_TX_DATA_Pos = 0x0
	// Bit mask of TX_DATA field.
	USB_TXDATA_TX_DATA_Msk = 0xffffffff

	// TXPLEN: USB Transmit Packet Length
	// Position of PKT_LNGTH field.
	USB_TXPLEN_PKT_LNGTH_Pos = 0x0
	// Bit mask of PKT_LNGTH field.
	USB_TXPLEN_PKT_LNGTH_Msk = 0x3ff
	// Position of RESERVED field.
	USB_TXPLEN_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_TXPLEN_RESERVED_Msk = 0xfffffc00

	// CTRL: USB Control
	// Position of RD_EN field.
	USB_CTRL_RD_EN_Pos = 0x0
	// Bit mask of RD_EN field.
	USB_CTRL_RD_EN_Msk = 0x1
	// Bit RD_EN.
	USB_CTRL_RD_EN = 0x1
	// Disabled.
	USB_CTRL_RD_EN_DISABLED_ = 0x0
	// Enabled.
	USB_CTRL_RD_EN_ENABLED_ = 0x1
	// Position of WR_EN field.
	USB_CTRL_WR_EN_Pos = 0x1
	// Bit mask of WR_EN field.
	USB_CTRL_WR_EN_Msk = 0x2
	// Bit WR_EN.
	USB_CTRL_WR_EN = 0x2
	// Disabled.
	USB_CTRL_WR_EN_DISABLED_ = 0x0
	// Enabled.
	USB_CTRL_WR_EN_ENABLED_ = 0x1
	// Position of LOG_ENDPOINT field.
	USB_CTRL_LOG_ENDPOINT_Pos = 0x2
	// Bit mask of LOG_ENDPOINT field.
	USB_CTRL_LOG_ENDPOINT_Msk = 0x3c
	// Position of RESERVED field.
	USB_CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	USB_CTRL_RESERVED_Msk = 0xffffffc0

	// DEVINTPRI: USB Device Interrupt Priority
	// Position of FRAME field.
	USB_DEVINTPRI_FRAME_Pos = 0x0
	// Bit mask of FRAME field.
	USB_DEVINTPRI_FRAME_Msk = 0x1
	// Bit FRAME.
	USB_DEVINTPRI_FRAME = 0x1
	// FRAME interrupt is routed to USB_INT_REQ_LP.
	USB_DEVINTPRI_FRAME_LP = 0x0
	// FRAME interrupt is routed to USB_INT_REQ_HP.
	USB_DEVINTPRI_FRAME_HP = 0x1
	// Position of EP_FAST field.
	USB_DEVINTPRI_EP_FAST_Pos = 0x1
	// Bit mask of EP_FAST field.
	USB_DEVINTPRI_EP_FAST_Msk = 0x2
	// Bit EP_FAST.
	USB_DEVINTPRI_EP_FAST = 0x2
	// EP_FAST interrupt is routed to USB_INT_REQ_LP.
	USB_DEVINTPRI_EP_FAST_LP = 0x0
	// EP_FAST interrupt is routed to USB_INT_REQ_HP.
	USB_DEVINTPRI_EP_FAST_HP = 0x1
	// Position of RESERVED field.
	USB_DEVINTPRI_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USB_DEVINTPRI_RESERVED_Msk = 0xfffffffc

	// EPINTST: USB Endpoint Interrupt Status
	// Position of EPST0 field.
	USB_EPINTST_EPST0_Pos = 0x0
	// Bit mask of EPST0 field.
	USB_EPINTST_EPST0_Msk = 0x1
	// Bit EPST0.
	USB_EPINTST_EPST0 = 0x1
	// Position of EPST1 field.
	USB_EPINTST_EPST1_Pos = 0x1
	// Bit mask of EPST1 field.
	USB_EPINTST_EPST1_Msk = 0x2
	// Bit EPST1.
	USB_EPINTST_EPST1 = 0x2
	// Position of EPST2 field.
	USB_EPINTST_EPST2_Pos = 0x2
	// Bit mask of EPST2 field.
	USB_EPINTST_EPST2_Msk = 0x4
	// Bit EPST2.
	USB_EPINTST_EPST2 = 0x4
	// Position of EPST3 field.
	USB_EPINTST_EPST3_Pos = 0x3
	// Bit mask of EPST3 field.
	USB_EPINTST_EPST3_Msk = 0x8
	// Bit EPST3.
	USB_EPINTST_EPST3 = 0x8
	// Position of EPST4 field.
	USB_EPINTST_EPST4_Pos = 0x4
	// Bit mask of EPST4 field.
	USB_EPINTST_EPST4_Msk = 0x10
	// Bit EPST4.
	USB_EPINTST_EPST4 = 0x10
	// Position of EPST5 field.
	USB_EPINTST_EPST5_Pos = 0x5
	// Bit mask of EPST5 field.
	USB_EPINTST_EPST5_Msk = 0x20
	// Bit EPST5.
	USB_EPINTST_EPST5 = 0x20
	// Position of EPST6 field.
	USB_EPINTST_EPST6_Pos = 0x6
	// Bit mask of EPST6 field.
	USB_EPINTST_EPST6_Msk = 0x40
	// Bit EPST6.
	USB_EPINTST_EPST6 = 0x40
	// Position of EPST7 field.
	USB_EPINTST_EPST7_Pos = 0x7
	// Bit mask of EPST7 field.
	USB_EPINTST_EPST7_Msk = 0x80
	// Bit EPST7.
	USB_EPINTST_EPST7 = 0x80
	// Position of EPST8 field.
	USB_EPINTST_EPST8_Pos = 0x8
	// Bit mask of EPST8 field.
	USB_EPINTST_EPST8_Msk = 0x100
	// Bit EPST8.
	USB_EPINTST_EPST8 = 0x100
	// Position of EPST9 field.
	USB_EPINTST_EPST9_Pos = 0x9
	// Bit mask of EPST9 field.
	USB_EPINTST_EPST9_Msk = 0x200
	// Bit EPST9.
	USB_EPINTST_EPST9 = 0x200
	// Position of EPST10 field.
	USB_EPINTST_EPST10_Pos = 0xa
	// Bit mask of EPST10 field.
	USB_EPINTST_EPST10_Msk = 0x400
	// Bit EPST10.
	USB_EPINTST_EPST10 = 0x400
	// Position of EPST11 field.
	USB_EPINTST_EPST11_Pos = 0xb
	// Bit mask of EPST11 field.
	USB_EPINTST_EPST11_Msk = 0x800
	// Bit EPST11.
	USB_EPINTST_EPST11 = 0x800
	// Position of EPST12 field.
	USB_EPINTST_EPST12_Pos = 0xc
	// Bit mask of EPST12 field.
	USB_EPINTST_EPST12_Msk = 0x1000
	// Bit EPST12.
	USB_EPINTST_EPST12 = 0x1000
	// Position of EPST13 field.
	USB_EPINTST_EPST13_Pos = 0xd
	// Bit mask of EPST13 field.
	USB_EPINTST_EPST13_Msk = 0x2000
	// Bit EPST13.
	USB_EPINTST_EPST13 = 0x2000
	// Position of EPST14 field.
	USB_EPINTST_EPST14_Pos = 0xe
	// Bit mask of EPST14 field.
	USB_EPINTST_EPST14_Msk = 0x4000
	// Bit EPST14.
	USB_EPINTST_EPST14 = 0x4000
	// Position of EPST15 field.
	USB_EPINTST_EPST15_Pos = 0xf
	// Bit mask of EPST15 field.
	USB_EPINTST_EPST15_Msk = 0x8000
	// Bit EPST15.
	USB_EPINTST_EPST15 = 0x8000
	// Position of EPST16 field.
	USB_EPINTST_EPST16_Pos = 0x10
	// Bit mask of EPST16 field.
	USB_EPINTST_EPST16_Msk = 0x10000
	// Bit EPST16.
	USB_EPINTST_EPST16 = 0x10000
	// Position of EPST17 field.
	USB_EPINTST_EPST17_Pos = 0x11
	// Bit mask of EPST17 field.
	USB_EPINTST_EPST17_Msk = 0x20000
	// Bit EPST17.
	USB_EPINTST_EPST17 = 0x20000
	// Position of EPST18 field.
	USB_EPINTST_EPST18_Pos = 0x12
	// Bit mask of EPST18 field.
	USB_EPINTST_EPST18_Msk = 0x40000
	// Bit EPST18.
	USB_EPINTST_EPST18 = 0x40000
	// Position of EPST19 field.
	USB_EPINTST_EPST19_Pos = 0x13
	// Bit mask of EPST19 field.
	USB_EPINTST_EPST19_Msk = 0x80000
	// Bit EPST19.
	USB_EPINTST_EPST19 = 0x80000
	// Position of EPST20 field.
	USB_EPINTST_EPST20_Pos = 0x14
	// Bit mask of EPST20 field.
	USB_EPINTST_EPST20_Msk = 0x100000
	// Bit EPST20.
	USB_EPINTST_EPST20 = 0x100000
	// Position of EPST21 field.
	USB_EPINTST_EPST21_Pos = 0x15
	// Bit mask of EPST21 field.
	USB_EPINTST_EPST21_Msk = 0x200000
	// Bit EPST21.
	USB_EPINTST_EPST21 = 0x200000
	// Position of EPST22 field.
	USB_EPINTST_EPST22_Pos = 0x16
	// Bit mask of EPST22 field.
	USB_EPINTST_EPST22_Msk = 0x400000
	// Bit EPST22.
	USB_EPINTST_EPST22 = 0x400000
	// Position of EPST23 field.
	USB_EPINTST_EPST23_Pos = 0x17
	// Bit mask of EPST23 field.
	USB_EPINTST_EPST23_Msk = 0x800000
	// Bit EPST23.
	USB_EPINTST_EPST23 = 0x800000
	// Position of EPST24 field.
	USB_EPINTST_EPST24_Pos = 0x18
	// Bit mask of EPST24 field.
	USB_EPINTST_EPST24_Msk = 0x1000000
	// Bit EPST24.
	USB_EPINTST_EPST24 = 0x1000000
	// Position of EPST25 field.
	USB_EPINTST_EPST25_Pos = 0x19
	// Bit mask of EPST25 field.
	USB_EPINTST_EPST25_Msk = 0x2000000
	// Bit EPST25.
	USB_EPINTST_EPST25 = 0x2000000
	// Position of EPST26 field.
	USB_EPINTST_EPST26_Pos = 0x1a
	// Bit mask of EPST26 field.
	USB_EPINTST_EPST26_Msk = 0x4000000
	// Bit EPST26.
	USB_EPINTST_EPST26 = 0x4000000
	// Position of EPST27 field.
	USB_EPINTST_EPST27_Pos = 0x1b
	// Bit mask of EPST27 field.
	USB_EPINTST_EPST27_Msk = 0x8000000
	// Bit EPST27.
	USB_EPINTST_EPST27 = 0x8000000
	// Position of EPST28 field.
	USB_EPINTST_EPST28_Pos = 0x1c
	// Bit mask of EPST28 field.
	USB_EPINTST_EPST28_Msk = 0x10000000
	// Bit EPST28.
	USB_EPINTST_EPST28 = 0x10000000
	// Position of EPST29 field.
	USB_EPINTST_EPST29_Pos = 0x1d
	// Bit mask of EPST29 field.
	USB_EPINTST_EPST29_Msk = 0x20000000
	// Bit EPST29.
	USB_EPINTST_EPST29 = 0x20000000
	// Position of EPST30 field.
	USB_EPINTST_EPST30_Pos = 0x1e
	// Bit mask of EPST30 field.
	USB_EPINTST_EPST30_Msk = 0x40000000
	// Bit EPST30.
	USB_EPINTST_EPST30 = 0x40000000
	// Position of EPST31 field.
	USB_EPINTST_EPST31_Pos = 0x1f
	// Bit mask of EPST31 field.
	USB_EPINTST_EPST31_Msk = 0x80000000
	// Bit EPST31.
	USB_EPINTST_EPST31 = 0x80000000

	// EPINTEN: USB Endpoint Interrupt Enable
	// Position of EPEN0 field.
	USB_EPINTEN_EPEN0_Pos = 0x0
	// Bit mask of EPEN0 field.
	USB_EPINTEN_EPEN0_Msk = 0x1
	// Bit EPEN0.
	USB_EPINTEN_EPEN0 = 0x1
	// Position of EPEN1 field.
	USB_EPINTEN_EPEN1_Pos = 0x1
	// Bit mask of EPEN1 field.
	USB_EPINTEN_EPEN1_Msk = 0x2
	// Bit EPEN1.
	USB_EPINTEN_EPEN1 = 0x2
	// Position of EPEN2 field.
	USB_EPINTEN_EPEN2_Pos = 0x2
	// Bit mask of EPEN2 field.
	USB_EPINTEN_EPEN2_Msk = 0x4
	// Bit EPEN2.
	USB_EPINTEN_EPEN2 = 0x4
	// Position of EPEN3 field.
	USB_EPINTEN_EPEN3_Pos = 0x3
	// Bit mask of EPEN3 field.
	USB_EPINTEN_EPEN3_Msk = 0x8
	// Bit EPEN3.
	USB_EPINTEN_EPEN3 = 0x8
	// Position of EPEN4 field.
	USB_EPINTEN_EPEN4_Pos = 0x4
	// Bit mask of EPEN4 field.
	USB_EPINTEN_EPEN4_Msk = 0x10
	// Bit EPEN4.
	USB_EPINTEN_EPEN4 = 0x10
	// Position of EPEN5 field.
	USB_EPINTEN_EPEN5_Pos = 0x5
	// Bit mask of EPEN5 field.
	USB_EPINTEN_EPEN5_Msk = 0x20
	// Bit EPEN5.
	USB_EPINTEN_EPEN5 = 0x20
	// Position of EPEN6 field.
	USB_EPINTEN_EPEN6_Pos = 0x6
	// Bit mask of EPEN6 field.
	USB_EPINTEN_EPEN6_Msk = 0x40
	// Bit EPEN6.
	USB_EPINTEN_EPEN6 = 0x40
	// Position of EPEN7 field.
	USB_EPINTEN_EPEN7_Pos = 0x7
	// Bit mask of EPEN7 field.
	USB_EPINTEN_EPEN7_Msk = 0x80
	// Bit EPEN7.
	USB_EPINTEN_EPEN7 = 0x80
	// Position of EPEN8 field.
	USB_EPINTEN_EPEN8_Pos = 0x8
	// Bit mask of EPEN8 field.
	USB_EPINTEN_EPEN8_Msk = 0x100
	// Bit EPEN8.
	USB_EPINTEN_EPEN8 = 0x100
	// Position of EPEN9 field.
	USB_EPINTEN_EPEN9_Pos = 0x9
	// Bit mask of EPEN9 field.
	USB_EPINTEN_EPEN9_Msk = 0x200
	// Bit EPEN9.
	USB_EPINTEN_EPEN9 = 0x200
	// Position of EPEN10 field.
	USB_EPINTEN_EPEN10_Pos = 0xa
	// Bit mask of EPEN10 field.
	USB_EPINTEN_EPEN10_Msk = 0x400
	// Bit EPEN10.
	USB_EPINTEN_EPEN10 = 0x400
	// Position of EPEN11 field.
	USB_EPINTEN_EPEN11_Pos = 0xb
	// Bit mask of EPEN11 field.
	USB_EPINTEN_EPEN11_Msk = 0x800
	// Bit EPEN11.
	USB_EPINTEN_EPEN11 = 0x800
	// Position of EPEN12 field.
	USB_EPINTEN_EPEN12_Pos = 0xc
	// Bit mask of EPEN12 field.
	USB_EPINTEN_EPEN12_Msk = 0x1000
	// Bit EPEN12.
	USB_EPINTEN_EPEN12 = 0x1000
	// Position of EPEN13 field.
	USB_EPINTEN_EPEN13_Pos = 0xd
	// Bit mask of EPEN13 field.
	USB_EPINTEN_EPEN13_Msk = 0x2000
	// Bit EPEN13.
	USB_EPINTEN_EPEN13 = 0x2000
	// Position of EPEN14 field.
	USB_EPINTEN_EPEN14_Pos = 0xe
	// Bit mask of EPEN14 field.
	USB_EPINTEN_EPEN14_Msk = 0x4000
	// Bit EPEN14.
	USB_EPINTEN_EPEN14 = 0x4000
	// Position of EPEN15 field.
	USB_EPINTEN_EPEN15_Pos = 0xf
	// Bit mask of EPEN15 field.
	USB_EPINTEN_EPEN15_Msk = 0x8000
	// Bit EPEN15.
	USB_EPINTEN_EPEN15 = 0x8000
	// Position of EPEN16 field.
	USB_EPINTEN_EPEN16_Pos = 0x10
	// Bit mask of EPEN16 field.
	USB_EPINTEN_EPEN16_Msk = 0x10000
	// Bit EPEN16.
	USB_EPINTEN_EPEN16 = 0x10000
	// Position of EPEN17 field.
	USB_EPINTEN_EPEN17_Pos = 0x11
	// Bit mask of EPEN17 field.
	USB_EPINTEN_EPEN17_Msk = 0x20000
	// Bit EPEN17.
	USB_EPINTEN_EPEN17 = 0x20000
	// Position of EPEN18 field.
	USB_EPINTEN_EPEN18_Pos = 0x12
	// Bit mask of EPEN18 field.
	USB_EPINTEN_EPEN18_Msk = 0x40000
	// Bit EPEN18.
	USB_EPINTEN_EPEN18 = 0x40000
	// Position of EPEN19 field.
	USB_EPINTEN_EPEN19_Pos = 0x13
	// Bit mask of EPEN19 field.
	USB_EPINTEN_EPEN19_Msk = 0x80000
	// Bit EPEN19.
	USB_EPINTEN_EPEN19 = 0x80000
	// Position of EPEN20 field.
	USB_EPINTEN_EPEN20_Pos = 0x14
	// Bit mask of EPEN20 field.
	USB_EPINTEN_EPEN20_Msk = 0x100000
	// Bit EPEN20.
	USB_EPINTEN_EPEN20 = 0x100000
	// Position of EPEN21 field.
	USB_EPINTEN_EPEN21_Pos = 0x15
	// Bit mask of EPEN21 field.
	USB_EPINTEN_EPEN21_Msk = 0x200000
	// Bit EPEN21.
	USB_EPINTEN_EPEN21 = 0x200000
	// Position of EPEN22 field.
	USB_EPINTEN_EPEN22_Pos = 0x16
	// Bit mask of EPEN22 field.
	USB_EPINTEN_EPEN22_Msk = 0x400000
	// Bit EPEN22.
	USB_EPINTEN_EPEN22 = 0x400000
	// Position of EPEN23 field.
	USB_EPINTEN_EPEN23_Pos = 0x17
	// Bit mask of EPEN23 field.
	USB_EPINTEN_EPEN23_Msk = 0x800000
	// Bit EPEN23.
	USB_EPINTEN_EPEN23 = 0x800000
	// Position of EPEN24 field.
	USB_EPINTEN_EPEN24_Pos = 0x18
	// Bit mask of EPEN24 field.
	USB_EPINTEN_EPEN24_Msk = 0x1000000
	// Bit EPEN24.
	USB_EPINTEN_EPEN24 = 0x1000000
	// Position of EPEN25 field.
	USB_EPINTEN_EPEN25_Pos = 0x19
	// Bit mask of EPEN25 field.
	USB_EPINTEN_EPEN25_Msk = 0x2000000
	// Bit EPEN25.
	USB_EPINTEN_EPEN25 = 0x2000000
	// Position of EPEN26 field.
	USB_EPINTEN_EPEN26_Pos = 0x1a
	// Bit mask of EPEN26 field.
	USB_EPINTEN_EPEN26_Msk = 0x4000000
	// Bit EPEN26.
	USB_EPINTEN_EPEN26 = 0x4000000
	// Position of EPEN27 field.
	USB_EPINTEN_EPEN27_Pos = 0x1b
	// Bit mask of EPEN27 field.
	USB_EPINTEN_EPEN27_Msk = 0x8000000
	// Bit EPEN27.
	USB_EPINTEN_EPEN27 = 0x8000000
	// Position of EPEN28 field.
	USB_EPINTEN_EPEN28_Pos = 0x1c
	// Bit mask of EPEN28 field.
	USB_EPINTEN_EPEN28_Msk = 0x10000000
	// Bit EPEN28.
	USB_EPINTEN_EPEN28 = 0x10000000
	// Position of EPEN29 field.
	USB_EPINTEN_EPEN29_Pos = 0x1d
	// Bit mask of EPEN29 field.
	USB_EPINTEN_EPEN29_Msk = 0x20000000
	// Bit EPEN29.
	USB_EPINTEN_EPEN29 = 0x20000000
	// Position of EPEN30 field.
	USB_EPINTEN_EPEN30_Pos = 0x1e
	// Bit mask of EPEN30 field.
	USB_EPINTEN_EPEN30_Msk = 0x40000000
	// Bit EPEN30.
	USB_EPINTEN_EPEN30 = 0x40000000
	// Position of EPEN31 field.
	USB_EPINTEN_EPEN31_Pos = 0x1f
	// Bit mask of EPEN31 field.
	USB_EPINTEN_EPEN31_Msk = 0x80000000
	// Bit EPEN31.
	USB_EPINTEN_EPEN31 = 0x80000000

	// EPINTCLR: USB Endpoint Interrupt Clear
	// Position of EPCLR0 field.
	USB_EPINTCLR_EPCLR0_Pos = 0x0
	// Bit mask of EPCLR0 field.
	USB_EPINTCLR_EPCLR0_Msk = 0x1
	// Bit EPCLR0.
	USB_EPINTCLR_EPCLR0 = 0x1
	// Position of EPCLR1 field.
	USB_EPINTCLR_EPCLR1_Pos = 0x1
	// Bit mask of EPCLR1 field.
	USB_EPINTCLR_EPCLR1_Msk = 0x2
	// Bit EPCLR1.
	USB_EPINTCLR_EPCLR1 = 0x2
	// Position of EPCLR2 field.
	USB_EPINTCLR_EPCLR2_Pos = 0x2
	// Bit mask of EPCLR2 field.
	USB_EPINTCLR_EPCLR2_Msk = 0x4
	// Bit EPCLR2.
	USB_EPINTCLR_EPCLR2 = 0x4
	// Position of EPCLR3 field.
	USB_EPINTCLR_EPCLR3_Pos = 0x3
	// Bit mask of EPCLR3 field.
	USB_EPINTCLR_EPCLR3_Msk = 0x8
	// Bit EPCLR3.
	USB_EPINTCLR_EPCLR3 = 0x8
	// Position of EPCLR4 field.
	USB_EPINTCLR_EPCLR4_Pos = 0x4
	// Bit mask of EPCLR4 field.
	USB_EPINTCLR_EPCLR4_Msk = 0x10
	// Bit EPCLR4.
	USB_EPINTCLR_EPCLR4 = 0x10
	// Position of EPCLR5 field.
	USB_EPINTCLR_EPCLR5_Pos = 0x5
	// Bit mask of EPCLR5 field.
	USB_EPINTCLR_EPCLR5_Msk = 0x20
	// Bit EPCLR5.
	USB_EPINTCLR_EPCLR5 = 0x20
	// Position of EPCLR6 field.
	USB_EPINTCLR_EPCLR6_Pos = 0x6
	// Bit mask of EPCLR6 field.
	USB_EPINTCLR_EPCLR6_Msk = 0x40
	// Bit EPCLR6.
	USB_EPINTCLR_EPCLR6 = 0x40
	// Position of EPCLR7 field.
	USB_EPINTCLR_EPCLR7_Pos = 0x7
	// Bit mask of EPCLR7 field.
	USB_EPINTCLR_EPCLR7_Msk = 0x80
	// Bit EPCLR7.
	USB_EPINTCLR_EPCLR7 = 0x80
	// Position of EPCLR8 field.
	USB_EPINTCLR_EPCLR8_Pos = 0x8
	// Bit mask of EPCLR8 field.
	USB_EPINTCLR_EPCLR8_Msk = 0x100
	// Bit EPCLR8.
	USB_EPINTCLR_EPCLR8 = 0x100
	// Position of EPCLR9 field.
	USB_EPINTCLR_EPCLR9_Pos = 0x9
	// Bit mask of EPCLR9 field.
	USB_EPINTCLR_EPCLR9_Msk = 0x200
	// Bit EPCLR9.
	USB_EPINTCLR_EPCLR9 = 0x200
	// Position of EPCLR10 field.
	USB_EPINTCLR_EPCLR10_Pos = 0xa
	// Bit mask of EPCLR10 field.
	USB_EPINTCLR_EPCLR10_Msk = 0x400
	// Bit EPCLR10.
	USB_EPINTCLR_EPCLR10 = 0x400
	// Position of EPCLR11 field.
	USB_EPINTCLR_EPCLR11_Pos = 0xb
	// Bit mask of EPCLR11 field.
	USB_EPINTCLR_EPCLR11_Msk = 0x800
	// Bit EPCLR11.
	USB_EPINTCLR_EPCLR11 = 0x800
	// Position of EPCLR12 field.
	USB_EPINTCLR_EPCLR12_Pos = 0xc
	// Bit mask of EPCLR12 field.
	USB_EPINTCLR_EPCLR12_Msk = 0x1000
	// Bit EPCLR12.
	USB_EPINTCLR_EPCLR12 = 0x1000
	// Position of EPCLR13 field.
	USB_EPINTCLR_EPCLR13_Pos = 0xd
	// Bit mask of EPCLR13 field.
	USB_EPINTCLR_EPCLR13_Msk = 0x2000
	// Bit EPCLR13.
	USB_EPINTCLR_EPCLR13 = 0x2000
	// Position of EPCLR14 field.
	USB_EPINTCLR_EPCLR14_Pos = 0xe
	// Bit mask of EPCLR14 field.
	USB_EPINTCLR_EPCLR14_Msk = 0x4000
	// Bit EPCLR14.
	USB_EPINTCLR_EPCLR14 = 0x4000
	// Position of EPCLR15 field.
	USB_EPINTCLR_EPCLR15_Pos = 0xf
	// Bit mask of EPCLR15 field.
	USB_EPINTCLR_EPCLR15_Msk = 0x8000
	// Bit EPCLR15.
	USB_EPINTCLR_EPCLR15 = 0x8000
	// Position of EPCLR16 field.
	USB_EPINTCLR_EPCLR16_Pos = 0x10
	// Bit mask of EPCLR16 field.
	USB_EPINTCLR_EPCLR16_Msk = 0x10000
	// Bit EPCLR16.
	USB_EPINTCLR_EPCLR16 = 0x10000
	// Position of EPCLR17 field.
	USB_EPINTCLR_EPCLR17_Pos = 0x11
	// Bit mask of EPCLR17 field.
	USB_EPINTCLR_EPCLR17_Msk = 0x20000
	// Bit EPCLR17.
	USB_EPINTCLR_EPCLR17 = 0x20000
	// Position of EPCLR18 field.
	USB_EPINTCLR_EPCLR18_Pos = 0x12
	// Bit mask of EPCLR18 field.
	USB_EPINTCLR_EPCLR18_Msk = 0x40000
	// Bit EPCLR18.
	USB_EPINTCLR_EPCLR18 = 0x40000
	// Position of EPCLR19 field.
	USB_EPINTCLR_EPCLR19_Pos = 0x13
	// Bit mask of EPCLR19 field.
	USB_EPINTCLR_EPCLR19_Msk = 0x80000
	// Bit EPCLR19.
	USB_EPINTCLR_EPCLR19 = 0x80000
	// Position of EPCLR20 field.
	USB_EPINTCLR_EPCLR20_Pos = 0x14
	// Bit mask of EPCLR20 field.
	USB_EPINTCLR_EPCLR20_Msk = 0x100000
	// Bit EPCLR20.
	USB_EPINTCLR_EPCLR20 = 0x100000
	// Position of EPCLR21 field.
	USB_EPINTCLR_EPCLR21_Pos = 0x15
	// Bit mask of EPCLR21 field.
	USB_EPINTCLR_EPCLR21_Msk = 0x200000
	// Bit EPCLR21.
	USB_EPINTCLR_EPCLR21 = 0x200000
	// Position of EPCLR22 field.
	USB_EPINTCLR_EPCLR22_Pos = 0x16
	// Bit mask of EPCLR22 field.
	USB_EPINTCLR_EPCLR22_Msk = 0x400000
	// Bit EPCLR22.
	USB_EPINTCLR_EPCLR22 = 0x400000
	// Position of EPCLR23 field.
	USB_EPINTCLR_EPCLR23_Pos = 0x17
	// Bit mask of EPCLR23 field.
	USB_EPINTCLR_EPCLR23_Msk = 0x800000
	// Bit EPCLR23.
	USB_EPINTCLR_EPCLR23 = 0x800000
	// Position of EPCLR24 field.
	USB_EPINTCLR_EPCLR24_Pos = 0x18
	// Bit mask of EPCLR24 field.
	USB_EPINTCLR_EPCLR24_Msk = 0x1000000
	// Bit EPCLR24.
	USB_EPINTCLR_EPCLR24 = 0x1000000
	// Position of EPCLR25 field.
	USB_EPINTCLR_EPCLR25_Pos = 0x19
	// Bit mask of EPCLR25 field.
	USB_EPINTCLR_EPCLR25_Msk = 0x2000000
	// Bit EPCLR25.
	USB_EPINTCLR_EPCLR25 = 0x2000000
	// Position of EPCLR26 field.
	USB_EPINTCLR_EPCLR26_Pos = 0x1a
	// Bit mask of EPCLR26 field.
	USB_EPINTCLR_EPCLR26_Msk = 0x4000000
	// Bit EPCLR26.
	USB_EPINTCLR_EPCLR26 = 0x4000000
	// Position of EPCLR27 field.
	USB_EPINTCLR_EPCLR27_Pos = 0x1b
	// Bit mask of EPCLR27 field.
	USB_EPINTCLR_EPCLR27_Msk = 0x8000000
	// Bit EPCLR27.
	USB_EPINTCLR_EPCLR27 = 0x8000000
	// Position of EPCLR28 field.
	USB_EPINTCLR_EPCLR28_Pos = 0x1c
	// Bit mask of EPCLR28 field.
	USB_EPINTCLR_EPCLR28_Msk = 0x10000000
	// Bit EPCLR28.
	USB_EPINTCLR_EPCLR28 = 0x10000000
	// Position of EPCLR29 field.
	USB_EPINTCLR_EPCLR29_Pos = 0x1d
	// Bit mask of EPCLR29 field.
	USB_EPINTCLR_EPCLR29_Msk = 0x20000000
	// Bit EPCLR29.
	USB_EPINTCLR_EPCLR29 = 0x20000000
	// Position of EPCLR30 field.
	USB_EPINTCLR_EPCLR30_Pos = 0x1e
	// Bit mask of EPCLR30 field.
	USB_EPINTCLR_EPCLR30_Msk = 0x40000000
	// Bit EPCLR30.
	USB_EPINTCLR_EPCLR30 = 0x40000000
	// Position of EPCLR31 field.
	USB_EPINTCLR_EPCLR31_Pos = 0x1f
	// Bit mask of EPCLR31 field.
	USB_EPINTCLR_EPCLR31_Msk = 0x80000000
	// Bit EPCLR31.
	USB_EPINTCLR_EPCLR31 = 0x80000000

	// EPINTSET: USB Endpoint Interrupt Set
	// Position of EPSET0 field.
	USB_EPINTSET_EPSET0_Pos = 0x0
	// Bit mask of EPSET0 field.
	USB_EPINTSET_EPSET0_Msk = 0x1
	// Bit EPSET0.
	USB_EPINTSET_EPSET0 = 0x1
	// Position of EPSET1 field.
	USB_EPINTSET_EPSET1_Pos = 0x1
	// Bit mask of EPSET1 field.
	USB_EPINTSET_EPSET1_Msk = 0x2
	// Bit EPSET1.
	USB_EPINTSET_EPSET1 = 0x2
	// Position of EPSET2 field.
	USB_EPINTSET_EPSET2_Pos = 0x2
	// Bit mask of EPSET2 field.
	USB_EPINTSET_EPSET2_Msk = 0x4
	// Bit EPSET2.
	USB_EPINTSET_EPSET2 = 0x4
	// Position of EPSET3 field.
	USB_EPINTSET_EPSET3_Pos = 0x3
	// Bit mask of EPSET3 field.
	USB_EPINTSET_EPSET3_Msk = 0x8
	// Bit EPSET3.
	USB_EPINTSET_EPSET3 = 0x8
	// Position of EPSET4 field.
	USB_EPINTSET_EPSET4_Pos = 0x4
	// Bit mask of EPSET4 field.
	USB_EPINTSET_EPSET4_Msk = 0x10
	// Bit EPSET4.
	USB_EPINTSET_EPSET4 = 0x10
	// Position of EPSET5 field.
	USB_EPINTSET_EPSET5_Pos = 0x5
	// Bit mask of EPSET5 field.
	USB_EPINTSET_EPSET5_Msk = 0x20
	// Bit EPSET5.
	USB_EPINTSET_EPSET5 = 0x20
	// Position of EPSET6 field.
	USB_EPINTSET_EPSET6_Pos = 0x6
	// Bit mask of EPSET6 field.
	USB_EPINTSET_EPSET6_Msk = 0x40
	// Bit EPSET6.
	USB_EPINTSET_EPSET6 = 0x40
	// Position of EPSET7 field.
	USB_EPINTSET_EPSET7_Pos = 0x7
	// Bit mask of EPSET7 field.
	USB_EPINTSET_EPSET7_Msk = 0x80
	// Bit EPSET7.
	USB_EPINTSET_EPSET7 = 0x80
	// Position of EPSET8 field.
	USB_EPINTSET_EPSET8_Pos = 0x8
	// Bit mask of EPSET8 field.
	USB_EPINTSET_EPSET8_Msk = 0x100
	// Bit EPSET8.
	USB_EPINTSET_EPSET8 = 0x100
	// Position of EPSET9 field.
	USB_EPINTSET_EPSET9_Pos = 0x9
	// Bit mask of EPSET9 field.
	USB_EPINTSET_EPSET9_Msk = 0x200
	// Bit EPSET9.
	USB_EPINTSET_EPSET9 = 0x200
	// Position of EPSET10 field.
	USB_EPINTSET_EPSET10_Pos = 0xa
	// Bit mask of EPSET10 field.
	USB_EPINTSET_EPSET10_Msk = 0x400
	// Bit EPSET10.
	USB_EPINTSET_EPSET10 = 0x400
	// Position of EPSET11 field.
	USB_EPINTSET_EPSET11_Pos = 0xb
	// Bit mask of EPSET11 field.
	USB_EPINTSET_EPSET11_Msk = 0x800
	// Bit EPSET11.
	USB_EPINTSET_EPSET11 = 0x800
	// Position of EPSET12 field.
	USB_EPINTSET_EPSET12_Pos = 0xc
	// Bit mask of EPSET12 field.
	USB_EPINTSET_EPSET12_Msk = 0x1000
	// Bit EPSET12.
	USB_EPINTSET_EPSET12 = 0x1000
	// Position of EPSET13 field.
	USB_EPINTSET_EPSET13_Pos = 0xd
	// Bit mask of EPSET13 field.
	USB_EPINTSET_EPSET13_Msk = 0x2000
	// Bit EPSET13.
	USB_EPINTSET_EPSET13 = 0x2000
	// Position of EPSET14 field.
	USB_EPINTSET_EPSET14_Pos = 0xe
	// Bit mask of EPSET14 field.
	USB_EPINTSET_EPSET14_Msk = 0x4000
	// Bit EPSET14.
	USB_EPINTSET_EPSET14 = 0x4000
	// Position of EPSET15 field.
	USB_EPINTSET_EPSET15_Pos = 0xf
	// Bit mask of EPSET15 field.
	USB_EPINTSET_EPSET15_Msk = 0x8000
	// Bit EPSET15.
	USB_EPINTSET_EPSET15 = 0x8000
	// Position of EPSET16 field.
	USB_EPINTSET_EPSET16_Pos = 0x10
	// Bit mask of EPSET16 field.
	USB_EPINTSET_EPSET16_Msk = 0x10000
	// Bit EPSET16.
	USB_EPINTSET_EPSET16 = 0x10000
	// Position of EPSET17 field.
	USB_EPINTSET_EPSET17_Pos = 0x11
	// Bit mask of EPSET17 field.
	USB_EPINTSET_EPSET17_Msk = 0x20000
	// Bit EPSET17.
	USB_EPINTSET_EPSET17 = 0x20000
	// Position of EPSET18 field.
	USB_EPINTSET_EPSET18_Pos = 0x12
	// Bit mask of EPSET18 field.
	USB_EPINTSET_EPSET18_Msk = 0x40000
	// Bit EPSET18.
	USB_EPINTSET_EPSET18 = 0x40000
	// Position of EPSET19 field.
	USB_EPINTSET_EPSET19_Pos = 0x13
	// Bit mask of EPSET19 field.
	USB_EPINTSET_EPSET19_Msk = 0x80000
	// Bit EPSET19.
	USB_EPINTSET_EPSET19 = 0x80000
	// Position of EPSET20 field.
	USB_EPINTSET_EPSET20_Pos = 0x14
	// Bit mask of EPSET20 field.
	USB_EPINTSET_EPSET20_Msk = 0x100000
	// Bit EPSET20.
	USB_EPINTSET_EPSET20 = 0x100000
	// Position of EPSET21 field.
	USB_EPINTSET_EPSET21_Pos = 0x15
	// Bit mask of EPSET21 field.
	USB_EPINTSET_EPSET21_Msk = 0x200000
	// Bit EPSET21.
	USB_EPINTSET_EPSET21 = 0x200000
	// Position of EPSET22 field.
	USB_EPINTSET_EPSET22_Pos = 0x16
	// Bit mask of EPSET22 field.
	USB_EPINTSET_EPSET22_Msk = 0x400000
	// Bit EPSET22.
	USB_EPINTSET_EPSET22 = 0x400000
	// Position of EPSET23 field.
	USB_EPINTSET_EPSET23_Pos = 0x17
	// Bit mask of EPSET23 field.
	USB_EPINTSET_EPSET23_Msk = 0x800000
	// Bit EPSET23.
	USB_EPINTSET_EPSET23 = 0x800000
	// Position of EPSET24 field.
	USB_EPINTSET_EPSET24_Pos = 0x18
	// Bit mask of EPSET24 field.
	USB_EPINTSET_EPSET24_Msk = 0x1000000
	// Bit EPSET24.
	USB_EPINTSET_EPSET24 = 0x1000000
	// Position of EPSET25 field.
	USB_EPINTSET_EPSET25_Pos = 0x19
	// Bit mask of EPSET25 field.
	USB_EPINTSET_EPSET25_Msk = 0x2000000
	// Bit EPSET25.
	USB_EPINTSET_EPSET25 = 0x2000000
	// Position of EPSET26 field.
	USB_EPINTSET_EPSET26_Pos = 0x1a
	// Bit mask of EPSET26 field.
	USB_EPINTSET_EPSET26_Msk = 0x4000000
	// Bit EPSET26.
	USB_EPINTSET_EPSET26 = 0x4000000
	// Position of EPSET27 field.
	USB_EPINTSET_EPSET27_Pos = 0x1b
	// Bit mask of EPSET27 field.
	USB_EPINTSET_EPSET27_Msk = 0x8000000
	// Bit EPSET27.
	USB_EPINTSET_EPSET27 = 0x8000000
	// Position of EPSET28 field.
	USB_EPINTSET_EPSET28_Pos = 0x1c
	// Bit mask of EPSET28 field.
	USB_EPINTSET_EPSET28_Msk = 0x10000000
	// Bit EPSET28.
	USB_EPINTSET_EPSET28 = 0x10000000
	// Position of EPSET29 field.
	USB_EPINTSET_EPSET29_Pos = 0x1d
	// Bit mask of EPSET29 field.
	USB_EPINTSET_EPSET29_Msk = 0x20000000
	// Bit EPSET29.
	USB_EPINTSET_EPSET29 = 0x20000000
	// Position of EPSET30 field.
	USB_EPINTSET_EPSET30_Pos = 0x1e
	// Bit mask of EPSET30 field.
	USB_EPINTSET_EPSET30_Msk = 0x40000000
	// Bit EPSET30.
	USB_EPINTSET_EPSET30 = 0x40000000
	// Position of EPSET31 field.
	USB_EPINTSET_EPSET31_Pos = 0x1f
	// Bit mask of EPSET31 field.
	USB_EPINTSET_EPSET31_Msk = 0x80000000
	// Bit EPSET31.
	USB_EPINTSET_EPSET31 = 0x80000000

	// EPINTPRI: USB Endpoint Priority
	// Position of EPPRI0 field.
	USB_EPINTPRI_EPPRI0_Pos = 0x0
	// Bit mask of EPPRI0 field.
	USB_EPINTPRI_EPPRI0_Msk = 0x1
	// Bit EPPRI0.
	USB_EPINTPRI_EPPRI0 = 0x1
	// Position of EPPRI1 field.
	USB_EPINTPRI_EPPRI1_Pos = 0x1
	// Bit mask of EPPRI1 field.
	USB_EPINTPRI_EPPRI1_Msk = 0x2
	// Bit EPPRI1.
	USB_EPINTPRI_EPPRI1 = 0x2
	// Position of EPPRI2 field.
	USB_EPINTPRI_EPPRI2_Pos = 0x2
	// Bit mask of EPPRI2 field.
	USB_EPINTPRI_EPPRI2_Msk = 0x4
	// Bit EPPRI2.
	USB_EPINTPRI_EPPRI2 = 0x4
	// Position of EPPRI3 field.
	USB_EPINTPRI_EPPRI3_Pos = 0x3
	// Bit mask of EPPRI3 field.
	USB_EPINTPRI_EPPRI3_Msk = 0x8
	// Bit EPPRI3.
	USB_EPINTPRI_EPPRI3 = 0x8
	// Position of EPPRI4 field.
	USB_EPINTPRI_EPPRI4_Pos = 0x4
	// Bit mask of EPPRI4 field.
	USB_EPINTPRI_EPPRI4_Msk = 0x10
	// Bit EPPRI4.
	USB_EPINTPRI_EPPRI4 = 0x10
	// Position of EPPRI5 field.
	USB_EPINTPRI_EPPRI5_Pos = 0x5
	// Bit mask of EPPRI5 field.
	USB_EPINTPRI_EPPRI5_Msk = 0x20
	// Bit EPPRI5.
	USB_EPINTPRI_EPPRI5 = 0x20
	// Position of EPPRI6 field.
	USB_EPINTPRI_EPPRI6_Pos = 0x6
	// Bit mask of EPPRI6 field.
	USB_EPINTPRI_EPPRI6_Msk = 0x40
	// Bit EPPRI6.
	USB_EPINTPRI_EPPRI6 = 0x40
	// Position of EPPRI7 field.
	USB_EPINTPRI_EPPRI7_Pos = 0x7
	// Bit mask of EPPRI7 field.
	USB_EPINTPRI_EPPRI7_Msk = 0x80
	// Bit EPPRI7.
	USB_EPINTPRI_EPPRI7 = 0x80
	// Position of EPPRI8 field.
	USB_EPINTPRI_EPPRI8_Pos = 0x8
	// Bit mask of EPPRI8 field.
	USB_EPINTPRI_EPPRI8_Msk = 0x100
	// Bit EPPRI8.
	USB_EPINTPRI_EPPRI8 = 0x100
	// Position of EPPRI9 field.
	USB_EPINTPRI_EPPRI9_Pos = 0x9
	// Bit mask of EPPRI9 field.
	USB_EPINTPRI_EPPRI9_Msk = 0x200
	// Bit EPPRI9.
	USB_EPINTPRI_EPPRI9 = 0x200
	// Position of EPPRI10 field.
	USB_EPINTPRI_EPPRI10_Pos = 0xa
	// Bit mask of EPPRI10 field.
	USB_EPINTPRI_EPPRI10_Msk = 0x400
	// Bit EPPRI10.
	USB_EPINTPRI_EPPRI10 = 0x400
	// Position of EPPRI11 field.
	USB_EPINTPRI_EPPRI11_Pos = 0xb
	// Bit mask of EPPRI11 field.
	USB_EPINTPRI_EPPRI11_Msk = 0x800
	// Bit EPPRI11.
	USB_EPINTPRI_EPPRI11 = 0x800
	// Position of EPPRI12 field.
	USB_EPINTPRI_EPPRI12_Pos = 0xc
	// Bit mask of EPPRI12 field.
	USB_EPINTPRI_EPPRI12_Msk = 0x1000
	// Bit EPPRI12.
	USB_EPINTPRI_EPPRI12 = 0x1000
	// Position of EPPRI13 field.
	USB_EPINTPRI_EPPRI13_Pos = 0xd
	// Bit mask of EPPRI13 field.
	USB_EPINTPRI_EPPRI13_Msk = 0x2000
	// Bit EPPRI13.
	USB_EPINTPRI_EPPRI13 = 0x2000
	// Position of EPPRI14 field.
	USB_EPINTPRI_EPPRI14_Pos = 0xe
	// Bit mask of EPPRI14 field.
	USB_EPINTPRI_EPPRI14_Msk = 0x4000
	// Bit EPPRI14.
	USB_EPINTPRI_EPPRI14 = 0x4000
	// Position of EPPRI15 field.
	USB_EPINTPRI_EPPRI15_Pos = 0xf
	// Bit mask of EPPRI15 field.
	USB_EPINTPRI_EPPRI15_Msk = 0x8000
	// Bit EPPRI15.
	USB_EPINTPRI_EPPRI15 = 0x8000
	// Position of EPPRI16 field.
	USB_EPINTPRI_EPPRI16_Pos = 0x10
	// Bit mask of EPPRI16 field.
	USB_EPINTPRI_EPPRI16_Msk = 0x10000
	// Bit EPPRI16.
	USB_EPINTPRI_EPPRI16 = 0x10000
	// Position of EPPRI17 field.
	USB_EPINTPRI_EPPRI17_Pos = 0x11
	// Bit mask of EPPRI17 field.
	USB_EPINTPRI_EPPRI17_Msk = 0x20000
	// Bit EPPRI17.
	USB_EPINTPRI_EPPRI17 = 0x20000
	// Position of EPPRI18 field.
	USB_EPINTPRI_EPPRI18_Pos = 0x12
	// Bit mask of EPPRI18 field.
	USB_EPINTPRI_EPPRI18_Msk = 0x40000
	// Bit EPPRI18.
	USB_EPINTPRI_EPPRI18 = 0x40000
	// Position of EPPRI19 field.
	USB_EPINTPRI_EPPRI19_Pos = 0x13
	// Bit mask of EPPRI19 field.
	USB_EPINTPRI_EPPRI19_Msk = 0x80000
	// Bit EPPRI19.
	USB_EPINTPRI_EPPRI19 = 0x80000
	// Position of EPPRI20 field.
	USB_EPINTPRI_EPPRI20_Pos = 0x14
	// Bit mask of EPPRI20 field.
	USB_EPINTPRI_EPPRI20_Msk = 0x100000
	// Bit EPPRI20.
	USB_EPINTPRI_EPPRI20 = 0x100000
	// Position of EPPRI21 field.
	USB_EPINTPRI_EPPRI21_Pos = 0x15
	// Bit mask of EPPRI21 field.
	USB_EPINTPRI_EPPRI21_Msk = 0x200000
	// Bit EPPRI21.
	USB_EPINTPRI_EPPRI21 = 0x200000
	// Position of EPPRI22 field.
	USB_EPINTPRI_EPPRI22_Pos = 0x16
	// Bit mask of EPPRI22 field.
	USB_EPINTPRI_EPPRI22_Msk = 0x400000
	// Bit EPPRI22.
	USB_EPINTPRI_EPPRI22 = 0x400000
	// Position of EPPRI23 field.
	USB_EPINTPRI_EPPRI23_Pos = 0x17
	// Bit mask of EPPRI23 field.
	USB_EPINTPRI_EPPRI23_Msk = 0x800000
	// Bit EPPRI23.
	USB_EPINTPRI_EPPRI23 = 0x800000
	// Position of EPPRI24 field.
	USB_EPINTPRI_EPPRI24_Pos = 0x18
	// Bit mask of EPPRI24 field.
	USB_EPINTPRI_EPPRI24_Msk = 0x1000000
	// Bit EPPRI24.
	USB_EPINTPRI_EPPRI24 = 0x1000000
	// Position of EPPRI25 field.
	USB_EPINTPRI_EPPRI25_Pos = 0x19
	// Bit mask of EPPRI25 field.
	USB_EPINTPRI_EPPRI25_Msk = 0x2000000
	// Bit EPPRI25.
	USB_EPINTPRI_EPPRI25 = 0x2000000
	// Position of EPPRI26 field.
	USB_EPINTPRI_EPPRI26_Pos = 0x1a
	// Bit mask of EPPRI26 field.
	USB_EPINTPRI_EPPRI26_Msk = 0x4000000
	// Bit EPPRI26.
	USB_EPINTPRI_EPPRI26 = 0x4000000
	// Position of EPPRI27 field.
	USB_EPINTPRI_EPPRI27_Pos = 0x1b
	// Bit mask of EPPRI27 field.
	USB_EPINTPRI_EPPRI27_Msk = 0x8000000
	// Bit EPPRI27.
	USB_EPINTPRI_EPPRI27 = 0x8000000
	// Position of EPPRI28 field.
	USB_EPINTPRI_EPPRI28_Pos = 0x1c
	// Bit mask of EPPRI28 field.
	USB_EPINTPRI_EPPRI28_Msk = 0x10000000
	// Bit EPPRI28.
	USB_EPINTPRI_EPPRI28 = 0x10000000
	// Position of EPPRI29 field.
	USB_EPINTPRI_EPPRI29_Pos = 0x1d
	// Bit mask of EPPRI29 field.
	USB_EPINTPRI_EPPRI29_Msk = 0x20000000
	// Bit EPPRI29.
	USB_EPINTPRI_EPPRI29 = 0x20000000
	// Position of EPPRI30 field.
	USB_EPINTPRI_EPPRI30_Pos = 0x1e
	// Bit mask of EPPRI30 field.
	USB_EPINTPRI_EPPRI30_Msk = 0x40000000
	// Bit EPPRI30.
	USB_EPINTPRI_EPPRI30 = 0x40000000
	// Position of EPPRI31 field.
	USB_EPINTPRI_EPPRI31_Pos = 0x1f
	// Bit mask of EPPRI31 field.
	USB_EPINTPRI_EPPRI31_Msk = 0x80000000
	// Bit EPPRI31.
	USB_EPINTPRI_EPPRI31 = 0x80000000

	// REEP: USB Realize Endpoint
	// Position of EPR0 field.
	USB_REEP_EPR0_Pos = 0x0
	// Bit mask of EPR0 field.
	USB_REEP_EPR0_Msk = 0x1
	// Bit EPR0.
	USB_REEP_EPR0 = 0x1
	// Position of EPR1 field.
	USB_REEP_EPR1_Pos = 0x1
	// Bit mask of EPR1 field.
	USB_REEP_EPR1_Msk = 0x2
	// Bit EPR1.
	USB_REEP_EPR1 = 0x2
	// Position of EPR2 field.
	USB_REEP_EPR2_Pos = 0x2
	// Bit mask of EPR2 field.
	USB_REEP_EPR2_Msk = 0x4
	// Bit EPR2.
	USB_REEP_EPR2 = 0x4
	// Position of EPR3 field.
	USB_REEP_EPR3_Pos = 0x3
	// Bit mask of EPR3 field.
	USB_REEP_EPR3_Msk = 0x8
	// Bit EPR3.
	USB_REEP_EPR3 = 0x8
	// Position of EPR4 field.
	USB_REEP_EPR4_Pos = 0x4
	// Bit mask of EPR4 field.
	USB_REEP_EPR4_Msk = 0x10
	// Bit EPR4.
	USB_REEP_EPR4 = 0x10
	// Position of EPR5 field.
	USB_REEP_EPR5_Pos = 0x5
	// Bit mask of EPR5 field.
	USB_REEP_EPR5_Msk = 0x20
	// Bit EPR5.
	USB_REEP_EPR5 = 0x20
	// Position of EPR6 field.
	USB_REEP_EPR6_Pos = 0x6
	// Bit mask of EPR6 field.
	USB_REEP_EPR6_Msk = 0x40
	// Bit EPR6.
	USB_REEP_EPR6 = 0x40
	// Position of EPR7 field.
	USB_REEP_EPR7_Pos = 0x7
	// Bit mask of EPR7 field.
	USB_REEP_EPR7_Msk = 0x80
	// Bit EPR7.
	USB_REEP_EPR7 = 0x80
	// Position of EPR8 field.
	USB_REEP_EPR8_Pos = 0x8
	// Bit mask of EPR8 field.
	USB_REEP_EPR8_Msk = 0x100
	// Bit EPR8.
	USB_REEP_EPR8 = 0x100
	// Position of EPR9 field.
	USB_REEP_EPR9_Pos = 0x9
	// Bit mask of EPR9 field.
	USB_REEP_EPR9_Msk = 0x200
	// Bit EPR9.
	USB_REEP_EPR9 = 0x200
	// Position of EPR10 field.
	USB_REEP_EPR10_Pos = 0xa
	// Bit mask of EPR10 field.
	USB_REEP_EPR10_Msk = 0x400
	// Bit EPR10.
	USB_REEP_EPR10 = 0x400
	// Position of EPR11 field.
	USB_REEP_EPR11_Pos = 0xb
	// Bit mask of EPR11 field.
	USB_REEP_EPR11_Msk = 0x800
	// Bit EPR11.
	USB_REEP_EPR11 = 0x800
	// Position of EPR12 field.
	USB_REEP_EPR12_Pos = 0xc
	// Bit mask of EPR12 field.
	USB_REEP_EPR12_Msk = 0x1000
	// Bit EPR12.
	USB_REEP_EPR12 = 0x1000
	// Position of EPR13 field.
	USB_REEP_EPR13_Pos = 0xd
	// Bit mask of EPR13 field.
	USB_REEP_EPR13_Msk = 0x2000
	// Bit EPR13.
	USB_REEP_EPR13 = 0x2000
	// Position of EPR14 field.
	USB_REEP_EPR14_Pos = 0xe
	// Bit mask of EPR14 field.
	USB_REEP_EPR14_Msk = 0x4000
	// Bit EPR14.
	USB_REEP_EPR14 = 0x4000
	// Position of EPR15 field.
	USB_REEP_EPR15_Pos = 0xf
	// Bit mask of EPR15 field.
	USB_REEP_EPR15_Msk = 0x8000
	// Bit EPR15.
	USB_REEP_EPR15 = 0x8000
	// Position of EPR16 field.
	USB_REEP_EPR16_Pos = 0x10
	// Bit mask of EPR16 field.
	USB_REEP_EPR16_Msk = 0x10000
	// Bit EPR16.
	USB_REEP_EPR16 = 0x10000
	// Position of EPR17 field.
	USB_REEP_EPR17_Pos = 0x11
	// Bit mask of EPR17 field.
	USB_REEP_EPR17_Msk = 0x20000
	// Bit EPR17.
	USB_REEP_EPR17 = 0x20000
	// Position of EPR18 field.
	USB_REEP_EPR18_Pos = 0x12
	// Bit mask of EPR18 field.
	USB_REEP_EPR18_Msk = 0x40000
	// Bit EPR18.
	USB_REEP_EPR18 = 0x40000
	// Position of EPR19 field.
	USB_REEP_EPR19_Pos = 0x13
	// Bit mask of EPR19 field.
	USB_REEP_EPR19_Msk = 0x80000
	// Bit EPR19.
	USB_REEP_EPR19 = 0x80000
	// Position of EPR20 field.
	USB_REEP_EPR20_Pos = 0x14
	// Bit mask of EPR20 field.
	USB_REEP_EPR20_Msk = 0x100000
	// Bit EPR20.
	USB_REEP_EPR20 = 0x100000
	// Position of EPR21 field.
	USB_REEP_EPR21_Pos = 0x15
	// Bit mask of EPR21 field.
	USB_REEP_EPR21_Msk = 0x200000
	// Bit EPR21.
	USB_REEP_EPR21 = 0x200000
	// Position of EPR22 field.
	USB_REEP_EPR22_Pos = 0x16
	// Bit mask of EPR22 field.
	USB_REEP_EPR22_Msk = 0x400000
	// Bit EPR22.
	USB_REEP_EPR22 = 0x400000
	// Position of EPR23 field.
	USB_REEP_EPR23_Pos = 0x17
	// Bit mask of EPR23 field.
	USB_REEP_EPR23_Msk = 0x800000
	// Bit EPR23.
	USB_REEP_EPR23 = 0x800000
	// Position of EPR24 field.
	USB_REEP_EPR24_Pos = 0x18
	// Bit mask of EPR24 field.
	USB_REEP_EPR24_Msk = 0x1000000
	// Bit EPR24.
	USB_REEP_EPR24 = 0x1000000
	// Position of EPR25 field.
	USB_REEP_EPR25_Pos = 0x19
	// Bit mask of EPR25 field.
	USB_REEP_EPR25_Msk = 0x2000000
	// Bit EPR25.
	USB_REEP_EPR25 = 0x2000000
	// Position of EPR26 field.
	USB_REEP_EPR26_Pos = 0x1a
	// Bit mask of EPR26 field.
	USB_REEP_EPR26_Msk = 0x4000000
	// Bit EPR26.
	USB_REEP_EPR26 = 0x4000000
	// Position of EPR27 field.
	USB_REEP_EPR27_Pos = 0x1b
	// Bit mask of EPR27 field.
	USB_REEP_EPR27_Msk = 0x8000000
	// Bit EPR27.
	USB_REEP_EPR27 = 0x8000000
	// Position of EPR28 field.
	USB_REEP_EPR28_Pos = 0x1c
	// Bit mask of EPR28 field.
	USB_REEP_EPR28_Msk = 0x10000000
	// Bit EPR28.
	USB_REEP_EPR28 = 0x10000000
	// Position of EPR29 field.
	USB_REEP_EPR29_Pos = 0x1d
	// Bit mask of EPR29 field.
	USB_REEP_EPR29_Msk = 0x20000000
	// Bit EPR29.
	USB_REEP_EPR29 = 0x20000000
	// Position of EPR30 field.
	USB_REEP_EPR30_Pos = 0x1e
	// Bit mask of EPR30 field.
	USB_REEP_EPR30_Msk = 0x40000000
	// Bit EPR30.
	USB_REEP_EPR30 = 0x40000000
	// Position of EPR31 field.
	USB_REEP_EPR31_Pos = 0x1f
	// Bit mask of EPR31 field.
	USB_REEP_EPR31_Msk = 0x80000000
	// Bit EPR31.
	USB_REEP_EPR31 = 0x80000000

	// EPIND: USB Endpoint Index
	// Position of PHY_EP field.
	USB_EPIND_PHY_EP_Pos = 0x0
	// Bit mask of PHY_EP field.
	USB_EPIND_PHY_EP_Msk = 0x1f
	// Position of RESERVED field.
	USB_EPIND_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB_EPIND_RESERVED_Msk = 0xffffffe0

	// MAXPSIZE: USB MaxPacketSize
	// Position of MPS field.
	USB_MAXPSIZE_MPS_Pos = 0x0
	// Bit mask of MPS field.
	USB_MAXPSIZE_MPS_Msk = 0x3ff
	// Position of RESERVED field.
	USB_MAXPSIZE_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_MAXPSIZE_RESERVED_Msk = 0xfffffc00

	// DMARST: USB DMA Request Status
	// Position of EPRST0 field.
	USB_DMARST_EPRST0_Pos = 0x0
	// Bit mask of EPRST0 field.
	USB_DMARST_EPRST0_Msk = 0x1
	// Bit EPRST0.
	USB_DMARST_EPRST0 = 0x1
	// Position of EPRST1 field.
	USB_DMARST_EPRST1_Pos = 0x1
	// Bit mask of EPRST1 field.
	USB_DMARST_EPRST1_Msk = 0x2
	// Bit EPRST1.
	USB_DMARST_EPRST1 = 0x2
	// Position of EPRST2 field.
	USB_DMARST_EPRST2_Pos = 0x2
	// Bit mask of EPRST2 field.
	USB_DMARST_EPRST2_Msk = 0x4
	// Bit EPRST2.
	USB_DMARST_EPRST2 = 0x4
	// Position of EPRST3 field.
	USB_DMARST_EPRST3_Pos = 0x3
	// Bit mask of EPRST3 field.
	USB_DMARST_EPRST3_Msk = 0x8
	// Bit EPRST3.
	USB_DMARST_EPRST3 = 0x8
	// Position of EPRST4 field.
	USB_DMARST_EPRST4_Pos = 0x4
	// Bit mask of EPRST4 field.
	USB_DMARST_EPRST4_Msk = 0x10
	// Bit EPRST4.
	USB_DMARST_EPRST4 = 0x10
	// Position of EPRST5 field.
	USB_DMARST_EPRST5_Pos = 0x5
	// Bit mask of EPRST5 field.
	USB_DMARST_EPRST5_Msk = 0x20
	// Bit EPRST5.
	USB_DMARST_EPRST5 = 0x20
	// Position of EPRST6 field.
	USB_DMARST_EPRST6_Pos = 0x6
	// Bit mask of EPRST6 field.
	USB_DMARST_EPRST6_Msk = 0x40
	// Bit EPRST6.
	USB_DMARST_EPRST6 = 0x40
	// Position of EPRST7 field.
	USB_DMARST_EPRST7_Pos = 0x7
	// Bit mask of EPRST7 field.
	USB_DMARST_EPRST7_Msk = 0x80
	// Bit EPRST7.
	USB_DMARST_EPRST7 = 0x80
	// Position of EPRST8 field.
	USB_DMARST_EPRST8_Pos = 0x8
	// Bit mask of EPRST8 field.
	USB_DMARST_EPRST8_Msk = 0x100
	// Bit EPRST8.
	USB_DMARST_EPRST8 = 0x100
	// Position of EPRST9 field.
	USB_DMARST_EPRST9_Pos = 0x9
	// Bit mask of EPRST9 field.
	USB_DMARST_EPRST9_Msk = 0x200
	// Bit EPRST9.
	USB_DMARST_EPRST9 = 0x200
	// Position of EPRST10 field.
	USB_DMARST_EPRST10_Pos = 0xa
	// Bit mask of EPRST10 field.
	USB_DMARST_EPRST10_Msk = 0x400
	// Bit EPRST10.
	USB_DMARST_EPRST10 = 0x400
	// Position of EPRST11 field.
	USB_DMARST_EPRST11_Pos = 0xb
	// Bit mask of EPRST11 field.
	USB_DMARST_EPRST11_Msk = 0x800
	// Bit EPRST11.
	USB_DMARST_EPRST11 = 0x800
	// Position of EPRST12 field.
	USB_DMARST_EPRST12_Pos = 0xc
	// Bit mask of EPRST12 field.
	USB_DMARST_EPRST12_Msk = 0x1000
	// Bit EPRST12.
	USB_DMARST_EPRST12 = 0x1000
	// Position of EPRST13 field.
	USB_DMARST_EPRST13_Pos = 0xd
	// Bit mask of EPRST13 field.
	USB_DMARST_EPRST13_Msk = 0x2000
	// Bit EPRST13.
	USB_DMARST_EPRST13 = 0x2000
	// Position of EPRST14 field.
	USB_DMARST_EPRST14_Pos = 0xe
	// Bit mask of EPRST14 field.
	USB_DMARST_EPRST14_Msk = 0x4000
	// Bit EPRST14.
	USB_DMARST_EPRST14 = 0x4000
	// Position of EPRST15 field.
	USB_DMARST_EPRST15_Pos = 0xf
	// Bit mask of EPRST15 field.
	USB_DMARST_EPRST15_Msk = 0x8000
	// Bit EPRST15.
	USB_DMARST_EPRST15 = 0x8000
	// Position of EPRST16 field.
	USB_DMARST_EPRST16_Pos = 0x10
	// Bit mask of EPRST16 field.
	USB_DMARST_EPRST16_Msk = 0x10000
	// Bit EPRST16.
	USB_DMARST_EPRST16 = 0x10000
	// Position of EPRST17 field.
	USB_DMARST_EPRST17_Pos = 0x11
	// Bit mask of EPRST17 field.
	USB_DMARST_EPRST17_Msk = 0x20000
	// Bit EPRST17.
	USB_DMARST_EPRST17 = 0x20000
	// Position of EPRST18 field.
	USB_DMARST_EPRST18_Pos = 0x12
	// Bit mask of EPRST18 field.
	USB_DMARST_EPRST18_Msk = 0x40000
	// Bit EPRST18.
	USB_DMARST_EPRST18 = 0x40000
	// Position of EPRST19 field.
	USB_DMARST_EPRST19_Pos = 0x13
	// Bit mask of EPRST19 field.
	USB_DMARST_EPRST19_Msk = 0x80000
	// Bit EPRST19.
	USB_DMARST_EPRST19 = 0x80000
	// Position of EPRST20 field.
	USB_DMARST_EPRST20_Pos = 0x14
	// Bit mask of EPRST20 field.
	USB_DMARST_EPRST20_Msk = 0x100000
	// Bit EPRST20.
	USB_DMARST_EPRST20 = 0x100000
	// Position of EPRST21 field.
	USB_DMARST_EPRST21_Pos = 0x15
	// Bit mask of EPRST21 field.
	USB_DMARST_EPRST21_Msk = 0x200000
	// Bit EPRST21.
	USB_DMARST_EPRST21 = 0x200000
	// Position of EPRST22 field.
	USB_DMARST_EPRST22_Pos = 0x16
	// Bit mask of EPRST22 field.
	USB_DMARST_EPRST22_Msk = 0x400000
	// Bit EPRST22.
	USB_DMARST_EPRST22 = 0x400000
	// Position of EPRST23 field.
	USB_DMARST_EPRST23_Pos = 0x17
	// Bit mask of EPRST23 field.
	USB_DMARST_EPRST23_Msk = 0x800000
	// Bit EPRST23.
	USB_DMARST_EPRST23 = 0x800000
	// Position of EPRST24 field.
	USB_DMARST_EPRST24_Pos = 0x18
	// Bit mask of EPRST24 field.
	USB_DMARST_EPRST24_Msk = 0x1000000
	// Bit EPRST24.
	USB_DMARST_EPRST24 = 0x1000000
	// Position of EPRST25 field.
	USB_DMARST_EPRST25_Pos = 0x19
	// Bit mask of EPRST25 field.
	USB_DMARST_EPRST25_Msk = 0x2000000
	// Bit EPRST25.
	USB_DMARST_EPRST25 = 0x2000000
	// Position of EPRST26 field.
	USB_DMARST_EPRST26_Pos = 0x1a
	// Bit mask of EPRST26 field.
	USB_DMARST_EPRST26_Msk = 0x4000000
	// Bit EPRST26.
	USB_DMARST_EPRST26 = 0x4000000
	// Position of EPRST27 field.
	USB_DMARST_EPRST27_Pos = 0x1b
	// Bit mask of EPRST27 field.
	USB_DMARST_EPRST27_Msk = 0x8000000
	// Bit EPRST27.
	USB_DMARST_EPRST27 = 0x8000000
	// Position of EPRST28 field.
	USB_DMARST_EPRST28_Pos = 0x1c
	// Bit mask of EPRST28 field.
	USB_DMARST_EPRST28_Msk = 0x10000000
	// Bit EPRST28.
	USB_DMARST_EPRST28 = 0x10000000
	// Position of EPRST29 field.
	USB_DMARST_EPRST29_Pos = 0x1d
	// Bit mask of EPRST29 field.
	USB_DMARST_EPRST29_Msk = 0x20000000
	// Bit EPRST29.
	USB_DMARST_EPRST29 = 0x20000000
	// Position of EPRST30 field.
	USB_DMARST_EPRST30_Pos = 0x1e
	// Bit mask of EPRST30 field.
	USB_DMARST_EPRST30_Msk = 0x40000000
	// Bit EPRST30.
	USB_DMARST_EPRST30 = 0x40000000
	// Position of EPRST31 field.
	USB_DMARST_EPRST31_Pos = 0x1f
	// Bit mask of EPRST31 field.
	USB_DMARST_EPRST31_Msk = 0x80000000
	// Bit EPRST31.
	USB_DMARST_EPRST31 = 0x80000000

	// DMARCLR: USB DMA Request Clear
	// Position of EPRCLR0 field.
	USB_DMARCLR_EPRCLR0_Pos = 0x0
	// Bit mask of EPRCLR0 field.
	USB_DMARCLR_EPRCLR0_Msk = 0x1
	// Bit EPRCLR0.
	USB_DMARCLR_EPRCLR0 = 0x1
	// Position of EPRCLR1 field.
	USB_DMARCLR_EPRCLR1_Pos = 0x1
	// Bit mask of EPRCLR1 field.
	USB_DMARCLR_EPRCLR1_Msk = 0x2
	// Bit EPRCLR1.
	USB_DMARCLR_EPRCLR1 = 0x2
	// Position of EPRCLR2 field.
	USB_DMARCLR_EPRCLR2_Pos = 0x2
	// Bit mask of EPRCLR2 field.
	USB_DMARCLR_EPRCLR2_Msk = 0x4
	// Bit EPRCLR2.
	USB_DMARCLR_EPRCLR2 = 0x4
	// Position of EPRCLR3 field.
	USB_DMARCLR_EPRCLR3_Pos = 0x3
	// Bit mask of EPRCLR3 field.
	USB_DMARCLR_EPRCLR3_Msk = 0x8
	// Bit EPRCLR3.
	USB_DMARCLR_EPRCLR3 = 0x8
	// Position of EPRCLR4 field.
	USB_DMARCLR_EPRCLR4_Pos = 0x4
	// Bit mask of EPRCLR4 field.
	USB_DMARCLR_EPRCLR4_Msk = 0x10
	// Bit EPRCLR4.
	USB_DMARCLR_EPRCLR4 = 0x10
	// Position of EPRCLR5 field.
	USB_DMARCLR_EPRCLR5_Pos = 0x5
	// Bit mask of EPRCLR5 field.
	USB_DMARCLR_EPRCLR5_Msk = 0x20
	// Bit EPRCLR5.
	USB_DMARCLR_EPRCLR5 = 0x20
	// Position of EPRCLR6 field.
	USB_DMARCLR_EPRCLR6_Pos = 0x6
	// Bit mask of EPRCLR6 field.
	USB_DMARCLR_EPRCLR6_Msk = 0x40
	// Bit EPRCLR6.
	USB_DMARCLR_EPRCLR6 = 0x40
	// Position of EPRCLR7 field.
	USB_DMARCLR_EPRCLR7_Pos = 0x7
	// Bit mask of EPRCLR7 field.
	USB_DMARCLR_EPRCLR7_Msk = 0x80
	// Bit EPRCLR7.
	USB_DMARCLR_EPRCLR7 = 0x80
	// Position of EPRCLR8 field.
	USB_DMARCLR_EPRCLR8_Pos = 0x8
	// Bit mask of EPRCLR8 field.
	USB_DMARCLR_EPRCLR8_Msk = 0x100
	// Bit EPRCLR8.
	USB_DMARCLR_EPRCLR8 = 0x100
	// Position of EPRCLR9 field.
	USB_DMARCLR_EPRCLR9_Pos = 0x9
	// Bit mask of EPRCLR9 field.
	USB_DMARCLR_EPRCLR9_Msk = 0x200
	// Bit EPRCLR9.
	USB_DMARCLR_EPRCLR9 = 0x200
	// Position of EPRCLR10 field.
	USB_DMARCLR_EPRCLR10_Pos = 0xa
	// Bit mask of EPRCLR10 field.
	USB_DMARCLR_EPRCLR10_Msk = 0x400
	// Bit EPRCLR10.
	USB_DMARCLR_EPRCLR10 = 0x400
	// Position of EPRCLR11 field.
	USB_DMARCLR_EPRCLR11_Pos = 0xb
	// Bit mask of EPRCLR11 field.
	USB_DMARCLR_EPRCLR11_Msk = 0x800
	// Bit EPRCLR11.
	USB_DMARCLR_EPRCLR11 = 0x800
	// Position of EPRCLR12 field.
	USB_DMARCLR_EPRCLR12_Pos = 0xc
	// Bit mask of EPRCLR12 field.
	USB_DMARCLR_EPRCLR12_Msk = 0x1000
	// Bit EPRCLR12.
	USB_DMARCLR_EPRCLR12 = 0x1000
	// Position of EPRCLR13 field.
	USB_DMARCLR_EPRCLR13_Pos = 0xd
	// Bit mask of EPRCLR13 field.
	USB_DMARCLR_EPRCLR13_Msk = 0x2000
	// Bit EPRCLR13.
	USB_DMARCLR_EPRCLR13 = 0x2000
	// Position of EPRCLR14 field.
	USB_DMARCLR_EPRCLR14_Pos = 0xe
	// Bit mask of EPRCLR14 field.
	USB_DMARCLR_EPRCLR14_Msk = 0x4000
	// Bit EPRCLR14.
	USB_DMARCLR_EPRCLR14 = 0x4000
	// Position of EPRCLR15 field.
	USB_DMARCLR_EPRCLR15_Pos = 0xf
	// Bit mask of EPRCLR15 field.
	USB_DMARCLR_EPRCLR15_Msk = 0x8000
	// Bit EPRCLR15.
	USB_DMARCLR_EPRCLR15 = 0x8000
	// Position of EPRCLR16 field.
	USB_DMARCLR_EPRCLR16_Pos = 0x10
	// Bit mask of EPRCLR16 field.
	USB_DMARCLR_EPRCLR16_Msk = 0x10000
	// Bit EPRCLR16.
	USB_DMARCLR_EPRCLR16 = 0x10000
	// Position of EPRCLR17 field.
	USB_DMARCLR_EPRCLR17_Pos = 0x11
	// Bit mask of EPRCLR17 field.
	USB_DMARCLR_EPRCLR17_Msk = 0x20000
	// Bit EPRCLR17.
	USB_DMARCLR_EPRCLR17 = 0x20000
	// Position of EPRCLR18 field.
	USB_DMARCLR_EPRCLR18_Pos = 0x12
	// Bit mask of EPRCLR18 field.
	USB_DMARCLR_EPRCLR18_Msk = 0x40000
	// Bit EPRCLR18.
	USB_DMARCLR_EPRCLR18 = 0x40000
	// Position of EPRCLR19 field.
	USB_DMARCLR_EPRCLR19_Pos = 0x13
	// Bit mask of EPRCLR19 field.
	USB_DMARCLR_EPRCLR19_Msk = 0x80000
	// Bit EPRCLR19.
	USB_DMARCLR_EPRCLR19 = 0x80000
	// Position of EPRCLR20 field.
	USB_DMARCLR_EPRCLR20_Pos = 0x14
	// Bit mask of EPRCLR20 field.
	USB_DMARCLR_EPRCLR20_Msk = 0x100000
	// Bit EPRCLR20.
	USB_DMARCLR_EPRCLR20 = 0x100000
	// Position of EPRCLR21 field.
	USB_DMARCLR_EPRCLR21_Pos = 0x15
	// Bit mask of EPRCLR21 field.
	USB_DMARCLR_EPRCLR21_Msk = 0x200000
	// Bit EPRCLR21.
	USB_DMARCLR_EPRCLR21 = 0x200000
	// Position of EPRCLR22 field.
	USB_DMARCLR_EPRCLR22_Pos = 0x16
	// Bit mask of EPRCLR22 field.
	USB_DMARCLR_EPRCLR22_Msk = 0x400000
	// Bit EPRCLR22.
	USB_DMARCLR_EPRCLR22 = 0x400000
	// Position of EPRCLR23 field.
	USB_DMARCLR_EPRCLR23_Pos = 0x17
	// Bit mask of EPRCLR23 field.
	USB_DMARCLR_EPRCLR23_Msk = 0x800000
	// Bit EPRCLR23.
	USB_DMARCLR_EPRCLR23 = 0x800000
	// Position of EPRCLR24 field.
	USB_DMARCLR_EPRCLR24_Pos = 0x18
	// Bit mask of EPRCLR24 field.
	USB_DMARCLR_EPRCLR24_Msk = 0x1000000
	// Bit EPRCLR24.
	USB_DMARCLR_EPRCLR24 = 0x1000000
	// Position of EPRCLR25 field.
	USB_DMARCLR_EPRCLR25_Pos = 0x19
	// Bit mask of EPRCLR25 field.
	USB_DMARCLR_EPRCLR25_Msk = 0x2000000
	// Bit EPRCLR25.
	USB_DMARCLR_EPRCLR25 = 0x2000000
	// Position of EPRCLR26 field.
	USB_DMARCLR_EPRCLR26_Pos = 0x1a
	// Bit mask of EPRCLR26 field.
	USB_DMARCLR_EPRCLR26_Msk = 0x4000000
	// Bit EPRCLR26.
	USB_DMARCLR_EPRCLR26 = 0x4000000
	// Position of EPRCLR27 field.
	USB_DMARCLR_EPRCLR27_Pos = 0x1b
	// Bit mask of EPRCLR27 field.
	USB_DMARCLR_EPRCLR27_Msk = 0x8000000
	// Bit EPRCLR27.
	USB_DMARCLR_EPRCLR27 = 0x8000000
	// Position of EPRCLR28 field.
	USB_DMARCLR_EPRCLR28_Pos = 0x1c
	// Bit mask of EPRCLR28 field.
	USB_DMARCLR_EPRCLR28_Msk = 0x10000000
	// Bit EPRCLR28.
	USB_DMARCLR_EPRCLR28 = 0x10000000
	// Position of EPRCLR29 field.
	USB_DMARCLR_EPRCLR29_Pos = 0x1d
	// Bit mask of EPRCLR29 field.
	USB_DMARCLR_EPRCLR29_Msk = 0x20000000
	// Bit EPRCLR29.
	USB_DMARCLR_EPRCLR29 = 0x20000000
	// Position of EPRCLR30 field.
	USB_DMARCLR_EPRCLR30_Pos = 0x1e
	// Bit mask of EPRCLR30 field.
	USB_DMARCLR_EPRCLR30_Msk = 0x40000000
	// Bit EPRCLR30.
	USB_DMARCLR_EPRCLR30 = 0x40000000
	// Position of EPRCLR31 field.
	USB_DMARCLR_EPRCLR31_Pos = 0x1f
	// Bit mask of EPRCLR31 field.
	USB_DMARCLR_EPRCLR31_Msk = 0x80000000
	// Bit EPRCLR31.
	USB_DMARCLR_EPRCLR31 = 0x80000000

	// DMARSET: USB DMA Request Set
	// Position of EPRSET0 field.
	USB_DMARSET_EPRSET0_Pos = 0x0
	// Bit mask of EPRSET0 field.
	USB_DMARSET_EPRSET0_Msk = 0x1
	// Bit EPRSET0.
	USB_DMARSET_EPRSET0 = 0x1
	// Position of EPRSET1 field.
	USB_DMARSET_EPRSET1_Pos = 0x1
	// Bit mask of EPRSET1 field.
	USB_DMARSET_EPRSET1_Msk = 0x2
	// Bit EPRSET1.
	USB_DMARSET_EPRSET1 = 0x2
	// Position of EPRSET2 field.
	USB_DMARSET_EPRSET2_Pos = 0x2
	// Bit mask of EPRSET2 field.
	USB_DMARSET_EPRSET2_Msk = 0x4
	// Bit EPRSET2.
	USB_DMARSET_EPRSET2 = 0x4
	// Position of EPRSET3 field.
	USB_DMARSET_EPRSET3_Pos = 0x3
	// Bit mask of EPRSET3 field.
	USB_DMARSET_EPRSET3_Msk = 0x8
	// Bit EPRSET3.
	USB_DMARSET_EPRSET3 = 0x8
	// Position of EPRSET4 field.
	USB_DMARSET_EPRSET4_Pos = 0x4
	// Bit mask of EPRSET4 field.
	USB_DMARSET_EPRSET4_Msk = 0x10
	// Bit EPRSET4.
	USB_DMARSET_EPRSET4 = 0x10
	// Position of EPRSET5 field.
	USB_DMARSET_EPRSET5_Pos = 0x5
	// Bit mask of EPRSET5 field.
	USB_DMARSET_EPRSET5_Msk = 0x20
	// Bit EPRSET5.
	USB_DMARSET_EPRSET5 = 0x20
	// Position of EPRSET6 field.
	USB_DMARSET_EPRSET6_Pos = 0x6
	// Bit mask of EPRSET6 field.
	USB_DMARSET_EPRSET6_Msk = 0x40
	// Bit EPRSET6.
	USB_DMARSET_EPRSET6 = 0x40
	// Position of EPRSET7 field.
	USB_DMARSET_EPRSET7_Pos = 0x7
	// Bit mask of EPRSET7 field.
	USB_DMARSET_EPRSET7_Msk = 0x80
	// Bit EPRSET7.
	USB_DMARSET_EPRSET7 = 0x80
	// Position of EPRSET8 field.
	USB_DMARSET_EPRSET8_Pos = 0x8
	// Bit mask of EPRSET8 field.
	USB_DMARSET_EPRSET8_Msk = 0x100
	// Bit EPRSET8.
	USB_DMARSET_EPRSET8 = 0x100
	// Position of EPRSET9 field.
	USB_DMARSET_EPRSET9_Pos = 0x9
	// Bit mask of EPRSET9 field.
	USB_DMARSET_EPRSET9_Msk = 0x200
	// Bit EPRSET9.
	USB_DMARSET_EPRSET9 = 0x200
	// Position of EPRSET10 field.
	USB_DMARSET_EPRSET10_Pos = 0xa
	// Bit mask of EPRSET10 field.
	USB_DMARSET_EPRSET10_Msk = 0x400
	// Bit EPRSET10.
	USB_DMARSET_EPRSET10 = 0x400
	// Position of EPRSET11 field.
	USB_DMARSET_EPRSET11_Pos = 0xb
	// Bit mask of EPRSET11 field.
	USB_DMARSET_EPRSET11_Msk = 0x800
	// Bit EPRSET11.
	USB_DMARSET_EPRSET11 = 0x800
	// Position of EPRSET12 field.
	USB_DMARSET_EPRSET12_Pos = 0xc
	// Bit mask of EPRSET12 field.
	USB_DMARSET_EPRSET12_Msk = 0x1000
	// Bit EPRSET12.
	USB_DMARSET_EPRSET12 = 0x1000
	// Position of EPRSET13 field.
	USB_DMARSET_EPRSET13_Pos = 0xd
	// Bit mask of EPRSET13 field.
	USB_DMARSET_EPRSET13_Msk = 0x2000
	// Bit EPRSET13.
	USB_DMARSET_EPRSET13 = 0x2000
	// Position of EPRSET14 field.
	USB_DMARSET_EPRSET14_Pos = 0xe
	// Bit mask of EPRSET14 field.
	USB_DMARSET_EPRSET14_Msk = 0x4000
	// Bit EPRSET14.
	USB_DMARSET_EPRSET14 = 0x4000
	// Position of EPRSET15 field.
	USB_DMARSET_EPRSET15_Pos = 0xf
	// Bit mask of EPRSET15 field.
	USB_DMARSET_EPRSET15_Msk = 0x8000
	// Bit EPRSET15.
	USB_DMARSET_EPRSET15 = 0x8000
	// Position of EPRSET16 field.
	USB_DMARSET_EPRSET16_Pos = 0x10
	// Bit mask of EPRSET16 field.
	USB_DMARSET_EPRSET16_Msk = 0x10000
	// Bit EPRSET16.
	USB_DMARSET_EPRSET16 = 0x10000
	// Position of EPRSET17 field.
	USB_DMARSET_EPRSET17_Pos = 0x11
	// Bit mask of EPRSET17 field.
	USB_DMARSET_EPRSET17_Msk = 0x20000
	// Bit EPRSET17.
	USB_DMARSET_EPRSET17 = 0x20000
	// Position of EPRSET18 field.
	USB_DMARSET_EPRSET18_Pos = 0x12
	// Bit mask of EPRSET18 field.
	USB_DMARSET_EPRSET18_Msk = 0x40000
	// Bit EPRSET18.
	USB_DMARSET_EPRSET18 = 0x40000
	// Position of EPRSET19 field.
	USB_DMARSET_EPRSET19_Pos = 0x13
	// Bit mask of EPRSET19 field.
	USB_DMARSET_EPRSET19_Msk = 0x80000
	// Bit EPRSET19.
	USB_DMARSET_EPRSET19 = 0x80000
	// Position of EPRSET20 field.
	USB_DMARSET_EPRSET20_Pos = 0x14
	// Bit mask of EPRSET20 field.
	USB_DMARSET_EPRSET20_Msk = 0x100000
	// Bit EPRSET20.
	USB_DMARSET_EPRSET20 = 0x100000
	// Position of EPRSET21 field.
	USB_DMARSET_EPRSET21_Pos = 0x15
	// Bit mask of EPRSET21 field.
	USB_DMARSET_EPRSET21_Msk = 0x200000
	// Bit EPRSET21.
	USB_DMARSET_EPRSET21 = 0x200000
	// Position of EPRSET22 field.
	USB_DMARSET_EPRSET22_Pos = 0x16
	// Bit mask of EPRSET22 field.
	USB_DMARSET_EPRSET22_Msk = 0x400000
	// Bit EPRSET22.
	USB_DMARSET_EPRSET22 = 0x400000
	// Position of EPRSET23 field.
	USB_DMARSET_EPRSET23_Pos = 0x17
	// Bit mask of EPRSET23 field.
	USB_DMARSET_EPRSET23_Msk = 0x800000
	// Bit EPRSET23.
	USB_DMARSET_EPRSET23 = 0x800000
	// Position of EPRSET24 field.
	USB_DMARSET_EPRSET24_Pos = 0x18
	// Bit mask of EPRSET24 field.
	USB_DMARSET_EPRSET24_Msk = 0x1000000
	// Bit EPRSET24.
	USB_DMARSET_EPRSET24 = 0x1000000
	// Position of EPRSET25 field.
	USB_DMARSET_EPRSET25_Pos = 0x19
	// Bit mask of EPRSET25 field.
	USB_DMARSET_EPRSET25_Msk = 0x2000000
	// Bit EPRSET25.
	USB_DMARSET_EPRSET25 = 0x2000000
	// Position of EPRSET26 field.
	USB_DMARSET_EPRSET26_Pos = 0x1a
	// Bit mask of EPRSET26 field.
	USB_DMARSET_EPRSET26_Msk = 0x4000000
	// Bit EPRSET26.
	USB_DMARSET_EPRSET26 = 0x4000000
	// Position of EPRSET27 field.
	USB_DMARSET_EPRSET27_Pos = 0x1b
	// Bit mask of EPRSET27 field.
	USB_DMARSET_EPRSET27_Msk = 0x8000000
	// Bit EPRSET27.
	USB_DMARSET_EPRSET27 = 0x8000000
	// Position of EPRSET28 field.
	USB_DMARSET_EPRSET28_Pos = 0x1c
	// Bit mask of EPRSET28 field.
	USB_DMARSET_EPRSET28_Msk = 0x10000000
	// Bit EPRSET28.
	USB_DMARSET_EPRSET28 = 0x10000000
	// Position of EPRSET29 field.
	USB_DMARSET_EPRSET29_Pos = 0x1d
	// Bit mask of EPRSET29 field.
	USB_DMARSET_EPRSET29_Msk = 0x20000000
	// Bit EPRSET29.
	USB_DMARSET_EPRSET29 = 0x20000000
	// Position of EPRSET30 field.
	USB_DMARSET_EPRSET30_Pos = 0x1e
	// Bit mask of EPRSET30 field.
	USB_DMARSET_EPRSET30_Msk = 0x40000000
	// Bit EPRSET30.
	USB_DMARSET_EPRSET30 = 0x40000000
	// Position of EPRSET31 field.
	USB_DMARSET_EPRSET31_Pos = 0x1f
	// Bit mask of EPRSET31 field.
	USB_DMARSET_EPRSET31_Msk = 0x80000000
	// Bit EPRSET31.
	USB_DMARSET_EPRSET31 = 0x80000000

	// UDCAH: USB UDCA Head
	// Position of RESERVED field.
	USB_UDCAH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_UDCAH_RESERVED_Msk = 0x7f
	// Position of UDCA_ADDR field.
	USB_UDCAH_UDCA_ADDR_Pos = 0x7
	// Bit mask of UDCA_ADDR field.
	USB_UDCAH_UDCA_ADDR_Msk = 0xffffff80

	// EPDMAST: USB Endpoint DMA Status
	// Position of EP_DMA_ST0 field.
	USB_EPDMAST_EP_DMA_ST0_Pos = 0x0
	// Bit mask of EP_DMA_ST0 field.
	USB_EPDMAST_EP_DMA_ST0_Msk = 0x1
	// Bit EP_DMA_ST0.
	USB_EPDMAST_EP_DMA_ST0 = 0x1
	// Position of EP_DMA_ST1 field.
	USB_EPDMAST_EP_DMA_ST1_Pos = 0x1
	// Bit mask of EP_DMA_ST1 field.
	USB_EPDMAST_EP_DMA_ST1_Msk = 0x2
	// Bit EP_DMA_ST1.
	USB_EPDMAST_EP_DMA_ST1 = 0x2
	// Position of EP_DMA_ST2 field.
	USB_EPDMAST_EP_DMA_ST2_Pos = 0x2
	// Bit mask of EP_DMA_ST2 field.
	USB_EPDMAST_EP_DMA_ST2_Msk = 0x4
	// Bit EP_DMA_ST2.
	USB_EPDMAST_EP_DMA_ST2 = 0x4
	// Position of EP_DMA_ST3 field.
	USB_EPDMAST_EP_DMA_ST3_Pos = 0x3
	// Bit mask of EP_DMA_ST3 field.
	USB_EPDMAST_EP_DMA_ST3_Msk = 0x8
	// Bit EP_DMA_ST3.
	USB_EPDMAST_EP_DMA_ST3 = 0x8
	// Position of EP_DMA_ST4 field.
	USB_EPDMAST_EP_DMA_ST4_Pos = 0x4
	// Bit mask of EP_DMA_ST4 field.
	USB_EPDMAST_EP_DMA_ST4_Msk = 0x10
	// Bit EP_DMA_ST4.
	USB_EPDMAST_EP_DMA_ST4 = 0x10
	// Position of EP_DMA_ST5 field.
	USB_EPDMAST_EP_DMA_ST5_Pos = 0x5
	// Bit mask of EP_DMA_ST5 field.
	USB_EPDMAST_EP_DMA_ST5_Msk = 0x20
	// Bit EP_DMA_ST5.
	USB_EPDMAST_EP_DMA_ST5 = 0x20
	// Position of EP_DMA_ST6 field.
	USB_EPDMAST_EP_DMA_ST6_Pos = 0x6
	// Bit mask of EP_DMA_ST6 field.
	USB_EPDMAST_EP_DMA_ST6_Msk = 0x40
	// Bit EP_DMA_ST6.
	USB_EPDMAST_EP_DMA_ST6 = 0x40
	// Position of EP_DMA_ST7 field.
	USB_EPDMAST_EP_DMA_ST7_Pos = 0x7
	// Bit mask of EP_DMA_ST7 field.
	USB_EPDMAST_EP_DMA_ST7_Msk = 0x80
	// Bit EP_DMA_ST7.
	USB_EPDMAST_EP_DMA_ST7 = 0x80
	// Position of EP_DMA_ST8 field.
	USB_EPDMAST_EP_DMA_ST8_Pos = 0x8
	// Bit mask of EP_DMA_ST8 field.
	USB_EPDMAST_EP_DMA_ST8_Msk = 0x100
	// Bit EP_DMA_ST8.
	USB_EPDMAST_EP_DMA_ST8 = 0x100
	// Position of EP_DMA_ST9 field.
	USB_EPDMAST_EP_DMA_ST9_Pos = 0x9
	// Bit mask of EP_DMA_ST9 field.
	USB_EPDMAST_EP_DMA_ST9_Msk = 0x200
	// Bit EP_DMA_ST9.
	USB_EPDMAST_EP_DMA_ST9 = 0x200
	// Position of EP_DMA_ST10 field.
	USB_EPDMAST_EP_DMA_ST10_Pos = 0xa
	// Bit mask of EP_DMA_ST10 field.
	USB_EPDMAST_EP_DMA_ST10_Msk = 0x400
	// Bit EP_DMA_ST10.
	USB_EPDMAST_EP_DMA_ST10 = 0x400
	// Position of EP_DMA_ST11 field.
	USB_EPDMAST_EP_DMA_ST11_Pos = 0xb
	// Bit mask of EP_DMA_ST11 field.
	USB_EPDMAST_EP_DMA_ST11_Msk = 0x800
	// Bit EP_DMA_ST11.
	USB_EPDMAST_EP_DMA_ST11 = 0x800
	// Position of EP_DMA_ST12 field.
	USB_EPDMAST_EP_DMA_ST12_Pos = 0xc
	// Bit mask of EP_DMA_ST12 field.
	USB_EPDMAST_EP_DMA_ST12_Msk = 0x1000
	// Bit EP_DMA_ST12.
	USB_EPDMAST_EP_DMA_ST12 = 0x1000
	// Position of EP_DMA_ST13 field.
	USB_EPDMAST_EP_DMA_ST13_Pos = 0xd
	// Bit mask of EP_DMA_ST13 field.
	USB_EPDMAST_EP_DMA_ST13_Msk = 0x2000
	// Bit EP_DMA_ST13.
	USB_EPDMAST_EP_DMA_ST13 = 0x2000
	// Position of EP_DMA_ST14 field.
	USB_EPDMAST_EP_DMA_ST14_Pos = 0xe
	// Bit mask of EP_DMA_ST14 field.
	USB_EPDMAST_EP_DMA_ST14_Msk = 0x4000
	// Bit EP_DMA_ST14.
	USB_EPDMAST_EP_DMA_ST14 = 0x4000
	// Position of EP_DMA_ST15 field.
	USB_EPDMAST_EP_DMA_ST15_Pos = 0xf
	// Bit mask of EP_DMA_ST15 field.
	USB_EPDMAST_EP_DMA_ST15_Msk = 0x8000
	// Bit EP_DMA_ST15.
	USB_EPDMAST_EP_DMA_ST15 = 0x8000
	// Position of EP_DMA_ST16 field.
	USB_EPDMAST_EP_DMA_ST16_Pos = 0x10
	// Bit mask of EP_DMA_ST16 field.
	USB_EPDMAST_EP_DMA_ST16_Msk = 0x10000
	// Bit EP_DMA_ST16.
	USB_EPDMAST_EP_DMA_ST16 = 0x10000
	// Position of EP_DMA_ST17 field.
	USB_EPDMAST_EP_DMA_ST17_Pos = 0x11
	// Bit mask of EP_DMA_ST17 field.
	USB_EPDMAST_EP_DMA_ST17_Msk = 0x20000
	// Bit EP_DMA_ST17.
	USB_EPDMAST_EP_DMA_ST17 = 0x20000
	// Position of EP_DMA_ST18 field.
	USB_EPDMAST_EP_DMA_ST18_Pos = 0x12
	// Bit mask of EP_DMA_ST18 field.
	USB_EPDMAST_EP_DMA_ST18_Msk = 0x40000
	// Bit EP_DMA_ST18.
	USB_EPDMAST_EP_DMA_ST18 = 0x40000
	// Position of EP_DMA_ST19 field.
	USB_EPDMAST_EP_DMA_ST19_Pos = 0x13
	// Bit mask of EP_DMA_ST19 field.
	USB_EPDMAST_EP_DMA_ST19_Msk = 0x80000
	// Bit EP_DMA_ST19.
	USB_EPDMAST_EP_DMA_ST19 = 0x80000
	// Position of EP_DMA_ST20 field.
	USB_EPDMAST_EP_DMA_ST20_Pos = 0x14
	// Bit mask of EP_DMA_ST20 field.
	USB_EPDMAST_EP_DMA_ST20_Msk = 0x100000
	// Bit EP_DMA_ST20.
	USB_EPDMAST_EP_DMA_ST20 = 0x100000
	// Position of EP_DMA_ST21 field.
	USB_EPDMAST_EP_DMA_ST21_Pos = 0x15
	// Bit mask of EP_DMA_ST21 field.
	USB_EPDMAST_EP_DMA_ST21_Msk = 0x200000
	// Bit EP_DMA_ST21.
	USB_EPDMAST_EP_DMA_ST21 = 0x200000
	// Position of EP_DMA_ST22 field.
	USB_EPDMAST_EP_DMA_ST22_Pos = 0x16
	// Bit mask of EP_DMA_ST22 field.
	USB_EPDMAST_EP_DMA_ST22_Msk = 0x400000
	// Bit EP_DMA_ST22.
	USB_EPDMAST_EP_DMA_ST22 = 0x400000
	// Position of EP_DMA_ST23 field.
	USB_EPDMAST_EP_DMA_ST23_Pos = 0x17
	// Bit mask of EP_DMA_ST23 field.
	USB_EPDMAST_EP_DMA_ST23_Msk = 0x800000
	// Bit EP_DMA_ST23.
	USB_EPDMAST_EP_DMA_ST23 = 0x800000
	// Position of EP_DMA_ST24 field.
	USB_EPDMAST_EP_DMA_ST24_Pos = 0x18
	// Bit mask of EP_DMA_ST24 field.
	USB_EPDMAST_EP_DMA_ST24_Msk = 0x1000000
	// Bit EP_DMA_ST24.
	USB_EPDMAST_EP_DMA_ST24 = 0x1000000
	// Position of EP_DMA_ST25 field.
	USB_EPDMAST_EP_DMA_ST25_Pos = 0x19
	// Bit mask of EP_DMA_ST25 field.
	USB_EPDMAST_EP_DMA_ST25_Msk = 0x2000000
	// Bit EP_DMA_ST25.
	USB_EPDMAST_EP_DMA_ST25 = 0x2000000
	// Position of EP_DMA_ST26 field.
	USB_EPDMAST_EP_DMA_ST26_Pos = 0x1a
	// Bit mask of EP_DMA_ST26 field.
	USB_EPDMAST_EP_DMA_ST26_Msk = 0x4000000
	// Bit EP_DMA_ST26.
	USB_EPDMAST_EP_DMA_ST26 = 0x4000000
	// Position of EP_DMA_ST27 field.
	USB_EPDMAST_EP_DMA_ST27_Pos = 0x1b
	// Bit mask of EP_DMA_ST27 field.
	USB_EPDMAST_EP_DMA_ST27_Msk = 0x8000000
	// Bit EP_DMA_ST27.
	USB_EPDMAST_EP_DMA_ST27 = 0x8000000
	// Position of EP_DMA_ST28 field.
	USB_EPDMAST_EP_DMA_ST28_Pos = 0x1c
	// Bit mask of EP_DMA_ST28 field.
	USB_EPDMAST_EP_DMA_ST28_Msk = 0x10000000
	// Bit EP_DMA_ST28.
	USB_EPDMAST_EP_DMA_ST28 = 0x10000000
	// Position of EP_DMA_ST29 field.
	USB_EPDMAST_EP_DMA_ST29_Pos = 0x1d
	// Bit mask of EP_DMA_ST29 field.
	USB_EPDMAST_EP_DMA_ST29_Msk = 0x20000000
	// Bit EP_DMA_ST29.
	USB_EPDMAST_EP_DMA_ST29 = 0x20000000
	// Position of EP_DMA_ST30 field.
	USB_EPDMAST_EP_DMA_ST30_Pos = 0x1e
	// Bit mask of EP_DMA_ST30 field.
	USB_EPDMAST_EP_DMA_ST30_Msk = 0x40000000
	// Bit EP_DMA_ST30.
	USB_EPDMAST_EP_DMA_ST30 = 0x40000000
	// Position of EP_DMA_ST31 field.
	USB_EPDMAST_EP_DMA_ST31_Pos = 0x1f
	// Bit mask of EP_DMA_ST31 field.
	USB_EPDMAST_EP_DMA_ST31_Msk = 0x80000000
	// Bit EP_DMA_ST31.
	USB_EPDMAST_EP_DMA_ST31 = 0x80000000

	// EPDMAEN: USB Endpoint DMA Enable
	// Position of EP_DMA_EN0 field.
	USB_EPDMAEN_EP_DMA_EN0_Pos = 0x0
	// Bit mask of EP_DMA_EN0 field.
	USB_EPDMAEN_EP_DMA_EN0_Msk = 0x1
	// Bit EP_DMA_EN0.
	USB_EPDMAEN_EP_DMA_EN0 = 0x1
	// Position of EP_DMA_EN1 field.
	USB_EPDMAEN_EP_DMA_EN1_Pos = 0x1
	// Bit mask of EP_DMA_EN1 field.
	USB_EPDMAEN_EP_DMA_EN1_Msk = 0x2
	// Bit EP_DMA_EN1.
	USB_EPDMAEN_EP_DMA_EN1 = 0x2
	// Position of EP_DMA_EN field.
	USB_EPDMAEN_EP_DMA_EN_Pos = 0x2
	// Bit mask of EP_DMA_EN field.
	USB_EPDMAEN_EP_DMA_EN_Msk = 0xfffffffc

	// EPDMADIS: USB Endpoint DMA Disable
	// Position of EP_DMA_DIS0 field.
	USB_EPDMADIS_EP_DMA_DIS0_Pos = 0x0
	// Bit mask of EP_DMA_DIS0 field.
	USB_EPDMADIS_EP_DMA_DIS0_Msk = 0x1
	// Bit EP_DMA_DIS0.
	USB_EPDMADIS_EP_DMA_DIS0 = 0x1
	// Position of EP_DMA_DIS1 field.
	USB_EPDMADIS_EP_DMA_DIS1_Pos = 0x1
	// Bit mask of EP_DMA_DIS1 field.
	USB_EPDMADIS_EP_DMA_DIS1_Msk = 0x2
	// Bit EP_DMA_DIS1.
	USB_EPDMADIS_EP_DMA_DIS1 = 0x2
	// Position of EP_DMA_DIS2 field.
	USB_EPDMADIS_EP_DMA_DIS2_Pos = 0x2
	// Bit mask of EP_DMA_DIS2 field.
	USB_EPDMADIS_EP_DMA_DIS2_Msk = 0x4
	// Bit EP_DMA_DIS2.
	USB_EPDMADIS_EP_DMA_DIS2 = 0x4
	// Position of EP_DMA_DIS3 field.
	USB_EPDMADIS_EP_DMA_DIS3_Pos = 0x3
	// Bit mask of EP_DMA_DIS3 field.
	USB_EPDMADIS_EP_DMA_DIS3_Msk = 0x8
	// Bit EP_DMA_DIS3.
	USB_EPDMADIS_EP_DMA_DIS3 = 0x8
	// Position of EP_DMA_DIS4 field.
	USB_EPDMADIS_EP_DMA_DIS4_Pos = 0x4
	// Bit mask of EP_DMA_DIS4 field.
	USB_EPDMADIS_EP_DMA_DIS4_Msk = 0x10
	// Bit EP_DMA_DIS4.
	USB_EPDMADIS_EP_DMA_DIS4 = 0x10
	// Position of EP_DMA_DIS5 field.
	USB_EPDMADIS_EP_DMA_DIS5_Pos = 0x5
	// Bit mask of EP_DMA_DIS5 field.
	USB_EPDMADIS_EP_DMA_DIS5_Msk = 0x20
	// Bit EP_DMA_DIS5.
	USB_EPDMADIS_EP_DMA_DIS5 = 0x20
	// Position of EP_DMA_DIS6 field.
	USB_EPDMADIS_EP_DMA_DIS6_Pos = 0x6
	// Bit mask of EP_DMA_DIS6 field.
	USB_EPDMADIS_EP_DMA_DIS6_Msk = 0x40
	// Bit EP_DMA_DIS6.
	USB_EPDMADIS_EP_DMA_DIS6 = 0x40
	// Position of EP_DMA_DIS7 field.
	USB_EPDMADIS_EP_DMA_DIS7_Pos = 0x7
	// Bit mask of EP_DMA_DIS7 field.
	USB_EPDMADIS_EP_DMA_DIS7_Msk = 0x80
	// Bit EP_DMA_DIS7.
	USB_EPDMADIS_EP_DMA_DIS7 = 0x80
	// Position of EP_DMA_DIS8 field.
	USB_EPDMADIS_EP_DMA_DIS8_Pos = 0x8
	// Bit mask of EP_DMA_DIS8 field.
	USB_EPDMADIS_EP_DMA_DIS8_Msk = 0x100
	// Bit EP_DMA_DIS8.
	USB_EPDMADIS_EP_DMA_DIS8 = 0x100
	// Position of EP_DMA_DIS9 field.
	USB_EPDMADIS_EP_DMA_DIS9_Pos = 0x9
	// Bit mask of EP_DMA_DIS9 field.
	USB_EPDMADIS_EP_DMA_DIS9_Msk = 0x200
	// Bit EP_DMA_DIS9.
	USB_EPDMADIS_EP_DMA_DIS9 = 0x200
	// Position of EP_DMA_DIS10 field.
	USB_EPDMADIS_EP_DMA_DIS10_Pos = 0xa
	// Bit mask of EP_DMA_DIS10 field.
	USB_EPDMADIS_EP_DMA_DIS10_Msk = 0x400
	// Bit EP_DMA_DIS10.
	USB_EPDMADIS_EP_DMA_DIS10 = 0x400
	// Position of EP_DMA_DIS11 field.
	USB_EPDMADIS_EP_DMA_DIS11_Pos = 0xb
	// Bit mask of EP_DMA_DIS11 field.
	USB_EPDMADIS_EP_DMA_DIS11_Msk = 0x800
	// Bit EP_DMA_DIS11.
	USB_EPDMADIS_EP_DMA_DIS11 = 0x800
	// Position of EP_DMA_DIS12 field.
	USB_EPDMADIS_EP_DMA_DIS12_Pos = 0xc
	// Bit mask of EP_DMA_DIS12 field.
	USB_EPDMADIS_EP_DMA_DIS12_Msk = 0x1000
	// Bit EP_DMA_DIS12.
	USB_EPDMADIS_EP_DMA_DIS12 = 0x1000
	// Position of EP_DMA_DIS13 field.
	USB_EPDMADIS_EP_DMA_DIS13_Pos = 0xd
	// Bit mask of EP_DMA_DIS13 field.
	USB_EPDMADIS_EP_DMA_DIS13_Msk = 0x2000
	// Bit EP_DMA_DIS13.
	USB_EPDMADIS_EP_DMA_DIS13 = 0x2000
	// Position of EP_DMA_DIS14 field.
	USB_EPDMADIS_EP_DMA_DIS14_Pos = 0xe
	// Bit mask of EP_DMA_DIS14 field.
	USB_EPDMADIS_EP_DMA_DIS14_Msk = 0x4000
	// Bit EP_DMA_DIS14.
	USB_EPDMADIS_EP_DMA_DIS14 = 0x4000
	// Position of EP_DMA_DIS15 field.
	USB_EPDMADIS_EP_DMA_DIS15_Pos = 0xf
	// Bit mask of EP_DMA_DIS15 field.
	USB_EPDMADIS_EP_DMA_DIS15_Msk = 0x8000
	// Bit EP_DMA_DIS15.
	USB_EPDMADIS_EP_DMA_DIS15 = 0x8000
	// Position of EP_DMA_DIS16 field.
	USB_EPDMADIS_EP_DMA_DIS16_Pos = 0x10
	// Bit mask of EP_DMA_DIS16 field.
	USB_EPDMADIS_EP_DMA_DIS16_Msk = 0x10000
	// Bit EP_DMA_DIS16.
	USB_EPDMADIS_EP_DMA_DIS16 = 0x10000
	// Position of EP_DMA_DIS17 field.
	USB_EPDMADIS_EP_DMA_DIS17_Pos = 0x11
	// Bit mask of EP_DMA_DIS17 field.
	USB_EPDMADIS_EP_DMA_DIS17_Msk = 0x20000
	// Bit EP_DMA_DIS17.
	USB_EPDMADIS_EP_DMA_DIS17 = 0x20000
	// Position of EP_DMA_DIS18 field.
	USB_EPDMADIS_EP_DMA_DIS18_Pos = 0x12
	// Bit mask of EP_DMA_DIS18 field.
	USB_EPDMADIS_EP_DMA_DIS18_Msk = 0x40000
	// Bit EP_DMA_DIS18.
	USB_EPDMADIS_EP_DMA_DIS18 = 0x40000
	// Position of EP_DMA_DIS19 field.
	USB_EPDMADIS_EP_DMA_DIS19_Pos = 0x13
	// Bit mask of EP_DMA_DIS19 field.
	USB_EPDMADIS_EP_DMA_DIS19_Msk = 0x80000
	// Bit EP_DMA_DIS19.
	USB_EPDMADIS_EP_DMA_DIS19 = 0x80000
	// Position of EP_DMA_DIS20 field.
	USB_EPDMADIS_EP_DMA_DIS20_Pos = 0x14
	// Bit mask of EP_DMA_DIS20 field.
	USB_EPDMADIS_EP_DMA_DIS20_Msk = 0x100000
	// Bit EP_DMA_DIS20.
	USB_EPDMADIS_EP_DMA_DIS20 = 0x100000
	// Position of EP_DMA_DIS21 field.
	USB_EPDMADIS_EP_DMA_DIS21_Pos = 0x15
	// Bit mask of EP_DMA_DIS21 field.
	USB_EPDMADIS_EP_DMA_DIS21_Msk = 0x200000
	// Bit EP_DMA_DIS21.
	USB_EPDMADIS_EP_DMA_DIS21 = 0x200000
	// Position of EP_DMA_DIS22 field.
	USB_EPDMADIS_EP_DMA_DIS22_Pos = 0x16
	// Bit mask of EP_DMA_DIS22 field.
	USB_EPDMADIS_EP_DMA_DIS22_Msk = 0x400000
	// Bit EP_DMA_DIS22.
	USB_EPDMADIS_EP_DMA_DIS22 = 0x400000
	// Position of EP_DMA_DIS23 field.
	USB_EPDMADIS_EP_DMA_DIS23_Pos = 0x17
	// Bit mask of EP_DMA_DIS23 field.
	USB_EPDMADIS_EP_DMA_DIS23_Msk = 0x800000
	// Bit EP_DMA_DIS23.
	USB_EPDMADIS_EP_DMA_DIS23 = 0x800000
	// Position of EP_DMA_DIS24 field.
	USB_EPDMADIS_EP_DMA_DIS24_Pos = 0x18
	// Bit mask of EP_DMA_DIS24 field.
	USB_EPDMADIS_EP_DMA_DIS24_Msk = 0x1000000
	// Bit EP_DMA_DIS24.
	USB_EPDMADIS_EP_DMA_DIS24 = 0x1000000
	// Position of EP_DMA_DIS25 field.
	USB_EPDMADIS_EP_DMA_DIS25_Pos = 0x19
	// Bit mask of EP_DMA_DIS25 field.
	USB_EPDMADIS_EP_DMA_DIS25_Msk = 0x2000000
	// Bit EP_DMA_DIS25.
	USB_EPDMADIS_EP_DMA_DIS25 = 0x2000000
	// Position of EP_DMA_DIS26 field.
	USB_EPDMADIS_EP_DMA_DIS26_Pos = 0x1a
	// Bit mask of EP_DMA_DIS26 field.
	USB_EPDMADIS_EP_DMA_DIS26_Msk = 0x4000000
	// Bit EP_DMA_DIS26.
	USB_EPDMADIS_EP_DMA_DIS26 = 0x4000000
	// Position of EP_DMA_DIS27 field.
	USB_EPDMADIS_EP_DMA_DIS27_Pos = 0x1b
	// Bit mask of EP_DMA_DIS27 field.
	USB_EPDMADIS_EP_DMA_DIS27_Msk = 0x8000000
	// Bit EP_DMA_DIS27.
	USB_EPDMADIS_EP_DMA_DIS27 = 0x8000000
	// Position of EP_DMA_DIS28 field.
	USB_EPDMADIS_EP_DMA_DIS28_Pos = 0x1c
	// Bit mask of EP_DMA_DIS28 field.
	USB_EPDMADIS_EP_DMA_DIS28_Msk = 0x10000000
	// Bit EP_DMA_DIS28.
	USB_EPDMADIS_EP_DMA_DIS28 = 0x10000000
	// Position of EP_DMA_DIS29 field.
	USB_EPDMADIS_EP_DMA_DIS29_Pos = 0x1d
	// Bit mask of EP_DMA_DIS29 field.
	USB_EPDMADIS_EP_DMA_DIS29_Msk = 0x20000000
	// Bit EP_DMA_DIS29.
	USB_EPDMADIS_EP_DMA_DIS29 = 0x20000000
	// Position of EP_DMA_DIS30 field.
	USB_EPDMADIS_EP_DMA_DIS30_Pos = 0x1e
	// Bit mask of EP_DMA_DIS30 field.
	USB_EPDMADIS_EP_DMA_DIS30_Msk = 0x40000000
	// Bit EP_DMA_DIS30.
	USB_EPDMADIS_EP_DMA_DIS30 = 0x40000000
	// Position of EP_DMA_DIS31 field.
	USB_EPDMADIS_EP_DMA_DIS31_Pos = 0x1f
	// Bit mask of EP_DMA_DIS31 field.
	USB_EPDMADIS_EP_DMA_DIS31_Msk = 0x80000000
	// Bit EP_DMA_DIS31.
	USB_EPDMADIS_EP_DMA_DIS31 = 0x80000000

	// DMAINTST: USB DMA Interrupt Status
	// Position of EOT field.
	USB_DMAINTST_EOT_Pos = 0x0
	// Bit mask of EOT field.
	USB_DMAINTST_EOT_Msk = 0x1
	// Bit EOT.
	USB_DMAINTST_EOT = 0x1
	// All bits in the USBEoTIntSt register are 0.
	USB_DMAINTST_EOT_ALL_BITS_IN_THE_USBE = 0x0
	// At least one bit in the USBEoTIntSt is set.
	USB_DMAINTST_EOT_AT_LEAST_ONE_BIT_IN_ = 0x1
	// Position of NDDR field.
	USB_DMAINTST_NDDR_Pos = 0x1
	// Bit mask of NDDR field.
	USB_DMAINTST_NDDR_Msk = 0x2
	// Bit NDDR.
	USB_DMAINTST_NDDR = 0x2
	// All bits in the USBNDDRIntSt register are 0.
	USB_DMAINTST_NDDR_ALL_BITS_IN_THE_USBN = 0x0
	// At least one bit in the USBNDDRIntSt is set.
	USB_DMAINTST_NDDR_AT_LEAST_ONE_BIT_IN_ = 0x1
	// Position of ERR field.
	USB_DMAINTST_ERR_Pos = 0x2
	// Bit mask of ERR field.
	USB_DMAINTST_ERR_Msk = 0x4
	// Bit ERR.
	USB_DMAINTST_ERR = 0x4
	// All bits in the USBSysErrIntSt register are 0.
	USB_DMAINTST_ERR_ALL_BITS_IN_THE_USBS = 0x0
	// At least one bit in the USBSysErrIntSt is set.
	USB_DMAINTST_ERR_AT_LEAST_ONE_BIT_IN_ = 0x1
	// Position of RESERVED field.
	USB_DMAINTST_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USB_DMAINTST_RESERVED_Msk = 0xfffffff8

	// DMAINTEN: USB DMA Interrupt Enable
	// Position of EOT field.
	USB_DMAINTEN_EOT_Pos = 0x0
	// Bit mask of EOT field.
	USB_DMAINTEN_EOT_Msk = 0x1
	// Bit EOT.
	USB_DMAINTEN_EOT = 0x1
	// Disabled.
	USB_DMAINTEN_EOT_DISABLED_ = 0x0
	// Enabled.
	USB_DMAINTEN_EOT_ENABLED_ = 0x1
	// Position of NDDR field.
	USB_DMAINTEN_NDDR_Pos = 0x1
	// Bit mask of NDDR field.
	USB_DMAINTEN_NDDR_Msk = 0x2
	// Bit NDDR.
	USB_DMAINTEN_NDDR = 0x2
	// Disabled.
	USB_DMAINTEN_NDDR_DISABLED_ = 0x0
	// Enabled.
	USB_DMAINTEN_NDDR_ENABLED_ = 0x1
	// Position of ERR field.
	USB_DMAINTEN_ERR_Pos = 0x2
	// Bit mask of ERR field.
	USB_DMAINTEN_ERR_Msk = 0x4
	// Bit ERR.
	USB_DMAINTEN_ERR = 0x4
	// Disabled.
	USB_DMAINTEN_ERR_DISABLED_ = 0x0
	// Enabled.
	USB_DMAINTEN_ERR_ENABLED_ = 0x1
	// Position of RESERVED field.
	USB_DMAINTEN_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USB_DMAINTEN_RESERVED_Msk = 0xfffffff8

	// EOTINTST: USB End of Transfer Interrupt Status
	// Position of EPTXINTST0 field.
	USB_EOTINTST_EPTXINTST0_Pos = 0x0
	// Bit mask of EPTXINTST0 field.
	USB_EOTINTST_EPTXINTST0_Msk = 0x1
	// Bit EPTXINTST0.
	USB_EOTINTST_EPTXINTST0 = 0x1
	// Position of EPTXINTST1 field.
	USB_EOTINTST_EPTXINTST1_Pos = 0x1
	// Bit mask of EPTXINTST1 field.
	USB_EOTINTST_EPTXINTST1_Msk = 0x2
	// Bit EPTXINTST1.
	USB_EOTINTST_EPTXINTST1 = 0x2
	// Position of EPTXINTST2 field.
	USB_EOTINTST_EPTXINTST2_Pos = 0x2
	// Bit mask of EPTXINTST2 field.
	USB_EOTINTST_EPTXINTST2_Msk = 0x4
	// Bit EPTXINTST2.
	USB_EOTINTST_EPTXINTST2 = 0x4
	// Position of EPTXINTST3 field.
	USB_EOTINTST_EPTXINTST3_Pos = 0x3
	// Bit mask of EPTXINTST3 field.
	USB_EOTINTST_EPTXINTST3_Msk = 0x8
	// Bit EPTXINTST3.
	USB_EOTINTST_EPTXINTST3 = 0x8
	// Position of EPTXINTST4 field.
	USB_EOTINTST_EPTXINTST4_Pos = 0x4
	// Bit mask of EPTXINTST4 field.
	USB_EOTINTST_EPTXINTST4_Msk = 0x10
	// Bit EPTXINTST4.
	USB_EOTINTST_EPTXINTST4 = 0x10
	// Position of EPTXINTST5 field.
	USB_EOTINTST_EPTXINTST5_Pos = 0x5
	// Bit mask of EPTXINTST5 field.
	USB_EOTINTST_EPTXINTST5_Msk = 0x20
	// Bit EPTXINTST5.
	USB_EOTINTST_EPTXINTST5 = 0x20
	// Position of EPTXINTST6 field.
	USB_EOTINTST_EPTXINTST6_Pos = 0x6
	// Bit mask of EPTXINTST6 field.
	USB_EOTINTST_EPTXINTST6_Msk = 0x40
	// Bit EPTXINTST6.
	USB_EOTINTST_EPTXINTST6 = 0x40
	// Position of EPTXINTST7 field.
	USB_EOTINTST_EPTXINTST7_Pos = 0x7
	// Bit mask of EPTXINTST7 field.
	USB_EOTINTST_EPTXINTST7_Msk = 0x80
	// Bit EPTXINTST7.
	USB_EOTINTST_EPTXINTST7 = 0x80
	// Position of EPTXINTST8 field.
	USB_EOTINTST_EPTXINTST8_Pos = 0x8
	// Bit mask of EPTXINTST8 field.
	USB_EOTINTST_EPTXINTST8_Msk = 0x100
	// Bit EPTXINTST8.
	USB_EOTINTST_EPTXINTST8 = 0x100
	// Position of EPTXINTST9 field.
	USB_EOTINTST_EPTXINTST9_Pos = 0x9
	// Bit mask of EPTXINTST9 field.
	USB_EOTINTST_EPTXINTST9_Msk = 0x200
	// Bit EPTXINTST9.
	USB_EOTINTST_EPTXINTST9 = 0x200
	// Position of EPTXINTST10 field.
	USB_EOTINTST_EPTXINTST10_Pos = 0xa
	// Bit mask of EPTXINTST10 field.
	USB_EOTINTST_EPTXINTST10_Msk = 0x400
	// Bit EPTXINTST10.
	USB_EOTINTST_EPTXINTST10 = 0x400
	// Position of EPTXINTST11 field.
	USB_EOTINTST_EPTXINTST11_Pos = 0xb
	// Bit mask of EPTXINTST11 field.
	USB_EOTINTST_EPTXINTST11_Msk = 0x800
	// Bit EPTXINTST11.
	USB_EOTINTST_EPTXINTST11 = 0x800
	// Position of EPTXINTST12 field.
	USB_EOTINTST_EPTXINTST12_Pos = 0xc
	// Bit mask of EPTXINTST12 field.
	USB_EOTINTST_EPTXINTST12_Msk = 0x1000
	// Bit EPTXINTST12.
	USB_EOTINTST_EPTXINTST12 = 0x1000
	// Position of EPTXINTST13 field.
	USB_EOTINTST_EPTXINTST13_Pos = 0xd
	// Bit mask of EPTXINTST13 field.
	USB_EOTINTST_EPTXINTST13_Msk = 0x2000
	// Bit EPTXINTST13.
	USB_EOTINTST_EPTXINTST13 = 0x2000
	// Position of EPTXINTST14 field.
	USB_EOTINTST_EPTXINTST14_Pos = 0xe
	// Bit mask of EPTXINTST14 field.
	USB_EOTINTST_EPTXINTST14_Msk = 0x4000
	// Bit EPTXINTST14.
	USB_EOTINTST_EPTXINTST14 = 0x4000
	// Position of EPTXINTST15 field.
	USB_EOTINTST_EPTXINTST15_Pos = 0xf
	// Bit mask of EPTXINTST15 field.
	USB_EOTINTST_EPTXINTST15_Msk = 0x8000
	// Bit EPTXINTST15.
	USB_EOTINTST_EPTXINTST15 = 0x8000
	// Position of EPTXINTST16 field.
	USB_EOTINTST_EPTXINTST16_Pos = 0x10
	// Bit mask of EPTXINTST16 field.
	USB_EOTINTST_EPTXINTST16_Msk = 0x10000
	// Bit EPTXINTST16.
	USB_EOTINTST_EPTXINTST16 = 0x10000
	// Position of EPTXINTST17 field.
	USB_EOTINTST_EPTXINTST17_Pos = 0x11
	// Bit mask of EPTXINTST17 field.
	USB_EOTINTST_EPTXINTST17_Msk = 0x20000
	// Bit EPTXINTST17.
	USB_EOTINTST_EPTXINTST17 = 0x20000
	// Position of EPTXINTST18 field.
	USB_EOTINTST_EPTXINTST18_Pos = 0x12
	// Bit mask of EPTXINTST18 field.
	USB_EOTINTST_EPTXINTST18_Msk = 0x40000
	// Bit EPTXINTST18.
	USB_EOTINTST_EPTXINTST18 = 0x40000
	// Position of EPTXINTST19 field.
	USB_EOTINTST_EPTXINTST19_Pos = 0x13
	// Bit mask of EPTXINTST19 field.
	USB_EOTINTST_EPTXINTST19_Msk = 0x80000
	// Bit EPTXINTST19.
	USB_EOTINTST_EPTXINTST19 = 0x80000
	// Position of EPTXINTST20 field.
	USB_EOTINTST_EPTXINTST20_Pos = 0x14
	// Bit mask of EPTXINTST20 field.
	USB_EOTINTST_EPTXINTST20_Msk = 0x100000
	// Bit EPTXINTST20.
	USB_EOTINTST_EPTXINTST20 = 0x100000
	// Position of EPTXINTST21 field.
	USB_EOTINTST_EPTXINTST21_Pos = 0x15
	// Bit mask of EPTXINTST21 field.
	USB_EOTINTST_EPTXINTST21_Msk = 0x200000
	// Bit EPTXINTST21.
	USB_EOTINTST_EPTXINTST21 = 0x200000
	// Position of EPTXINTST22 field.
	USB_EOTINTST_EPTXINTST22_Pos = 0x16
	// Bit mask of EPTXINTST22 field.
	USB_EOTINTST_EPTXINTST22_Msk = 0x400000
	// Bit EPTXINTST22.
	USB_EOTINTST_EPTXINTST22 = 0x400000
	// Position of EPTXINTST23 field.
	USB_EOTINTST_EPTXINTST23_Pos = 0x17
	// Bit mask of EPTXINTST23 field.
	USB_EOTINTST_EPTXINTST23_Msk = 0x800000
	// Bit EPTXINTST23.
	USB_EOTINTST_EPTXINTST23 = 0x800000
	// Position of EPTXINTST24 field.
	USB_EOTINTST_EPTXINTST24_Pos = 0x18
	// Bit mask of EPTXINTST24 field.
	USB_EOTINTST_EPTXINTST24_Msk = 0x1000000
	// Bit EPTXINTST24.
	USB_EOTINTST_EPTXINTST24 = 0x1000000
	// Position of EPTXINTST25 field.
	USB_EOTINTST_EPTXINTST25_Pos = 0x19
	// Bit mask of EPTXINTST25 field.
	USB_EOTINTST_EPTXINTST25_Msk = 0x2000000
	// Bit EPTXINTST25.
	USB_EOTINTST_EPTXINTST25 = 0x2000000
	// Position of EPTXINTST26 field.
	USB_EOTINTST_EPTXINTST26_Pos = 0x1a
	// Bit mask of EPTXINTST26 field.
	USB_EOTINTST_EPTXINTST26_Msk = 0x4000000
	// Bit EPTXINTST26.
	USB_EOTINTST_EPTXINTST26 = 0x4000000
	// Position of EPTXINTST27 field.
	USB_EOTINTST_EPTXINTST27_Pos = 0x1b
	// Bit mask of EPTXINTST27 field.
	USB_EOTINTST_EPTXINTST27_Msk = 0x8000000
	// Bit EPTXINTST27.
	USB_EOTINTST_EPTXINTST27 = 0x8000000
	// Position of EPTXINTST28 field.
	USB_EOTINTST_EPTXINTST28_Pos = 0x1c
	// Bit mask of EPTXINTST28 field.
	USB_EOTINTST_EPTXINTST28_Msk = 0x10000000
	// Bit EPTXINTST28.
	USB_EOTINTST_EPTXINTST28 = 0x10000000
	// Position of EPTXINTST29 field.
	USB_EOTINTST_EPTXINTST29_Pos = 0x1d
	// Bit mask of EPTXINTST29 field.
	USB_EOTINTST_EPTXINTST29_Msk = 0x20000000
	// Bit EPTXINTST29.
	USB_EOTINTST_EPTXINTST29 = 0x20000000
	// Position of EPTXINTST30 field.
	USB_EOTINTST_EPTXINTST30_Pos = 0x1e
	// Bit mask of EPTXINTST30 field.
	USB_EOTINTST_EPTXINTST30_Msk = 0x40000000
	// Bit EPTXINTST30.
	USB_EOTINTST_EPTXINTST30 = 0x40000000
	// Position of EPTXINTST31 field.
	USB_EOTINTST_EPTXINTST31_Pos = 0x1f
	// Bit mask of EPTXINTST31 field.
	USB_EOTINTST_EPTXINTST31_Msk = 0x80000000
	// Bit EPTXINTST31.
	USB_EOTINTST_EPTXINTST31 = 0x80000000

	// EOTINTCLR: USB End of Transfer Interrupt Clear
	// Position of EPTXINTCLR0 field.
	USB_EOTINTCLR_EPTXINTCLR0_Pos = 0x0
	// Bit mask of EPTXINTCLR0 field.
	USB_EOTINTCLR_EPTXINTCLR0_Msk = 0x1
	// Bit EPTXINTCLR0.
	USB_EOTINTCLR_EPTXINTCLR0 = 0x1
	// Position of EPTXINTCLR1 field.
	USB_EOTINTCLR_EPTXINTCLR1_Pos = 0x1
	// Bit mask of EPTXINTCLR1 field.
	USB_EOTINTCLR_EPTXINTCLR1_Msk = 0x2
	// Bit EPTXINTCLR1.
	USB_EOTINTCLR_EPTXINTCLR1 = 0x2
	// Position of EPTXINTCLR2 field.
	USB_EOTINTCLR_EPTXINTCLR2_Pos = 0x2
	// Bit mask of EPTXINTCLR2 field.
	USB_EOTINTCLR_EPTXINTCLR2_Msk = 0x4
	// Bit EPTXINTCLR2.
	USB_EOTINTCLR_EPTXINTCLR2 = 0x4
	// Position of EPTXINTCLR3 field.
	USB_EOTINTCLR_EPTXINTCLR3_Pos = 0x3
	// Bit mask of EPTXINTCLR3 field.
	USB_EOTINTCLR_EPTXINTCLR3_Msk = 0x8
	// Bit EPTXINTCLR3.
	USB_EOTINTCLR_EPTXINTCLR3 = 0x8
	// Position of EPTXINTCLR4 field.
	USB_EOTINTCLR_EPTXINTCLR4_Pos = 0x4
	// Bit mask of EPTXINTCLR4 field.
	USB_EOTINTCLR_EPTXINTCLR4_Msk = 0x10
	// Bit EPTXINTCLR4.
	USB_EOTINTCLR_EPTXINTCLR4 = 0x10
	// Position of EPTXINTCLR5 field.
	USB_EOTINTCLR_EPTXINTCLR5_Pos = 0x5
	// Bit mask of EPTXINTCLR5 field.
	USB_EOTINTCLR_EPTXINTCLR5_Msk = 0x20
	// Bit EPTXINTCLR5.
	USB_EOTINTCLR_EPTXINTCLR5 = 0x20
	// Position of EPTXINTCLR6 field.
	USB_EOTINTCLR_EPTXINTCLR6_Pos = 0x6
	// Bit mask of EPTXINTCLR6 field.
	USB_EOTINTCLR_EPTXINTCLR6_Msk = 0x40
	// Bit EPTXINTCLR6.
	USB_EOTINTCLR_EPTXINTCLR6 = 0x40
	// Position of EPTXINTCLR7 field.
	USB_EOTINTCLR_EPTXINTCLR7_Pos = 0x7
	// Bit mask of EPTXINTCLR7 field.
	USB_EOTINTCLR_EPTXINTCLR7_Msk = 0x80
	// Bit EPTXINTCLR7.
	USB_EOTINTCLR_EPTXINTCLR7 = 0x80
	// Position of EPTXINTCLR8 field.
	USB_EOTINTCLR_EPTXINTCLR8_Pos = 0x8
	// Bit mask of EPTXINTCLR8 field.
	USB_EOTINTCLR_EPTXINTCLR8_Msk = 0x100
	// Bit EPTXINTCLR8.
	USB_EOTINTCLR_EPTXINTCLR8 = 0x100
	// Position of EPTXINTCLR9 field.
	USB_EOTINTCLR_EPTXINTCLR9_Pos = 0x9
	// Bit mask of EPTXINTCLR9 field.
	USB_EOTINTCLR_EPTXINTCLR9_Msk = 0x200
	// Bit EPTXINTCLR9.
	USB_EOTINTCLR_EPTXINTCLR9 = 0x200
	// Position of EPTXINTCLR10 field.
	USB_EOTINTCLR_EPTXINTCLR10_Pos = 0xa
	// Bit mask of EPTXINTCLR10 field.
	USB_EOTINTCLR_EPTXINTCLR10_Msk = 0x400
	// Bit EPTXINTCLR10.
	USB_EOTINTCLR_EPTXINTCLR10 = 0x400
	// Position of EPTXINTCLR11 field.
	USB_EOTINTCLR_EPTXINTCLR11_Pos = 0xb
	// Bit mask of EPTXINTCLR11 field.
	USB_EOTINTCLR_EPTXINTCLR11_Msk = 0x800
	// Bit EPTXINTCLR11.
	USB_EOTINTCLR_EPTXINTCLR11 = 0x800
	// Position of EPTXINTCLR12 field.
	USB_EOTINTCLR_EPTXINTCLR12_Pos = 0xc
	// Bit mask of EPTXINTCLR12 field.
	USB_EOTINTCLR_EPTXINTCLR12_Msk = 0x1000
	// Bit EPTXINTCLR12.
	USB_EOTINTCLR_EPTXINTCLR12 = 0x1000
	// Position of EPTXINTCLR13 field.
	USB_EOTINTCLR_EPTXINTCLR13_Pos = 0xd
	// Bit mask of EPTXINTCLR13 field.
	USB_EOTINTCLR_EPTXINTCLR13_Msk = 0x2000
	// Bit EPTXINTCLR13.
	USB_EOTINTCLR_EPTXINTCLR13 = 0x2000
	// Position of EPTXINTCLR14 field.
	USB_EOTINTCLR_EPTXINTCLR14_Pos = 0xe
	// Bit mask of EPTXINTCLR14 field.
	USB_EOTINTCLR_EPTXINTCLR14_Msk = 0x4000
	// Bit EPTXINTCLR14.
	USB_EOTINTCLR_EPTXINTCLR14 = 0x4000
	// Position of EPTXINTCLR15 field.
	USB_EOTINTCLR_EPTXINTCLR15_Pos = 0xf
	// Bit mask of EPTXINTCLR15 field.
	USB_EOTINTCLR_EPTXINTCLR15_Msk = 0x8000
	// Bit EPTXINTCLR15.
	USB_EOTINTCLR_EPTXINTCLR15 = 0x8000
	// Position of EPTXINTCLR16 field.
	USB_EOTINTCLR_EPTXINTCLR16_Pos = 0x10
	// Bit mask of EPTXINTCLR16 field.
	USB_EOTINTCLR_EPTXINTCLR16_Msk = 0x10000
	// Bit EPTXINTCLR16.
	USB_EOTINTCLR_EPTXINTCLR16 = 0x10000
	// Position of EPTXINTCLR17 field.
	USB_EOTINTCLR_EPTXINTCLR17_Pos = 0x11
	// Bit mask of EPTXINTCLR17 field.
	USB_EOTINTCLR_EPTXINTCLR17_Msk = 0x20000
	// Bit EPTXINTCLR17.
	USB_EOTINTCLR_EPTXINTCLR17 = 0x20000
	// Position of EPTXINTCLR18 field.
	USB_EOTINTCLR_EPTXINTCLR18_Pos = 0x12
	// Bit mask of EPTXINTCLR18 field.
	USB_EOTINTCLR_EPTXINTCLR18_Msk = 0x40000
	// Bit EPTXINTCLR18.
	USB_EOTINTCLR_EPTXINTCLR18 = 0x40000
	// Position of EPTXINTCLR19 field.
	USB_EOTINTCLR_EPTXINTCLR19_Pos = 0x13
	// Bit mask of EPTXINTCLR19 field.
	USB_EOTINTCLR_EPTXINTCLR19_Msk = 0x80000
	// Bit EPTXINTCLR19.
	USB_EOTINTCLR_EPTXINTCLR19 = 0x80000
	// Position of EPTXINTCLR20 field.
	USB_EOTINTCLR_EPTXINTCLR20_Pos = 0x14
	// Bit mask of EPTXINTCLR20 field.
	USB_EOTINTCLR_EPTXINTCLR20_Msk = 0x100000
	// Bit EPTXINTCLR20.
	USB_EOTINTCLR_EPTXINTCLR20 = 0x100000
	// Position of EPTXINTCLR21 field.
	USB_EOTINTCLR_EPTXINTCLR21_Pos = 0x15
	// Bit mask of EPTXINTCLR21 field.
	USB_EOTINTCLR_EPTXINTCLR21_Msk = 0x200000
	// Bit EPTXINTCLR21.
	USB_EOTINTCLR_EPTXINTCLR21 = 0x200000
	// Position of EPTXINTCLR22 field.
	USB_EOTINTCLR_EPTXINTCLR22_Pos = 0x16
	// Bit mask of EPTXINTCLR22 field.
	USB_EOTINTCLR_EPTXINTCLR22_Msk = 0x400000
	// Bit EPTXINTCLR22.
	USB_EOTINTCLR_EPTXINTCLR22 = 0x400000
	// Position of EPTXINTCLR23 field.
	USB_EOTINTCLR_EPTXINTCLR23_Pos = 0x17
	// Bit mask of EPTXINTCLR23 field.
	USB_EOTINTCLR_EPTXINTCLR23_Msk = 0x800000
	// Bit EPTXINTCLR23.
	USB_EOTINTCLR_EPTXINTCLR23 = 0x800000
	// Position of EPTXINTCLR24 field.
	USB_EOTINTCLR_EPTXINTCLR24_Pos = 0x18
	// Bit mask of EPTXINTCLR24 field.
	USB_EOTINTCLR_EPTXINTCLR24_Msk = 0x1000000
	// Bit EPTXINTCLR24.
	USB_EOTINTCLR_EPTXINTCLR24 = 0x1000000
	// Position of EPTXINTCLR25 field.
	USB_EOTINTCLR_EPTXINTCLR25_Pos = 0x19
	// Bit mask of EPTXINTCLR25 field.
	USB_EOTINTCLR_EPTXINTCLR25_Msk = 0x2000000
	// Bit EPTXINTCLR25.
	USB_EOTINTCLR_EPTXINTCLR25 = 0x2000000
	// Position of EPTXINTCLR26 field.
	USB_EOTINTCLR_EPTXINTCLR26_Pos = 0x1a
	// Bit mask of EPTXINTCLR26 field.
	USB_EOTINTCLR_EPTXINTCLR26_Msk = 0x4000000
	// Bit EPTXINTCLR26.
	USB_EOTINTCLR_EPTXINTCLR26 = 0x4000000
	// Position of EPTXINTCLR27 field.
	USB_EOTINTCLR_EPTXINTCLR27_Pos = 0x1b
	// Bit mask of EPTXINTCLR27 field.
	USB_EOTINTCLR_EPTXINTCLR27_Msk = 0x8000000
	// Bit EPTXINTCLR27.
	USB_EOTINTCLR_EPTXINTCLR27 = 0x8000000
	// Position of EPTXINTCLR28 field.
	USB_EOTINTCLR_EPTXINTCLR28_Pos = 0x1c
	// Bit mask of EPTXINTCLR28 field.
	USB_EOTINTCLR_EPTXINTCLR28_Msk = 0x10000000
	// Bit EPTXINTCLR28.
	USB_EOTINTCLR_EPTXINTCLR28 = 0x10000000
	// Position of EPTXINTCLR29 field.
	USB_EOTINTCLR_EPTXINTCLR29_Pos = 0x1d
	// Bit mask of EPTXINTCLR29 field.
	USB_EOTINTCLR_EPTXINTCLR29_Msk = 0x20000000
	// Bit EPTXINTCLR29.
	USB_EOTINTCLR_EPTXINTCLR29 = 0x20000000
	// Position of EPTXINTCLR30 field.
	USB_EOTINTCLR_EPTXINTCLR30_Pos = 0x1e
	// Bit mask of EPTXINTCLR30 field.
	USB_EOTINTCLR_EPTXINTCLR30_Msk = 0x40000000
	// Bit EPTXINTCLR30.
	USB_EOTINTCLR_EPTXINTCLR30 = 0x40000000
	// Position of EPTXINTCLR31 field.
	USB_EOTINTCLR_EPTXINTCLR31_Pos = 0x1f
	// Bit mask of EPTXINTCLR31 field.
	USB_EOTINTCLR_EPTXINTCLR31_Msk = 0x80000000
	// Bit EPTXINTCLR31.
	USB_EOTINTCLR_EPTXINTCLR31 = 0x80000000

	// EOTINTSET: USB End of Transfer Interrupt Set
	// Position of EPTXINTSET0 field.
	USB_EOTINTSET_EPTXINTSET0_Pos = 0x0
	// Bit mask of EPTXINTSET0 field.
	USB_EOTINTSET_EPTXINTSET0_Msk = 0x1
	// Bit EPTXINTSET0.
	USB_EOTINTSET_EPTXINTSET0 = 0x1
	// Position of EPTXINTSET1 field.
	USB_EOTINTSET_EPTXINTSET1_Pos = 0x1
	// Bit mask of EPTXINTSET1 field.
	USB_EOTINTSET_EPTXINTSET1_Msk = 0x2
	// Bit EPTXINTSET1.
	USB_EOTINTSET_EPTXINTSET1 = 0x2
	// Position of EPTXINTSET2 field.
	USB_EOTINTSET_EPTXINTSET2_Pos = 0x2
	// Bit mask of EPTXINTSET2 field.
	USB_EOTINTSET_EPTXINTSET2_Msk = 0x4
	// Bit EPTXINTSET2.
	USB_EOTINTSET_EPTXINTSET2 = 0x4
	// Position of EPTXINTSET3 field.
	USB_EOTINTSET_EPTXINTSET3_Pos = 0x3
	// Bit mask of EPTXINTSET3 field.
	USB_EOTINTSET_EPTXINTSET3_Msk = 0x8
	// Bit EPTXINTSET3.
	USB_EOTINTSET_EPTXINTSET3 = 0x8
	// Position of EPTXINTSET4 field.
	USB_EOTINTSET_EPTXINTSET4_Pos = 0x4
	// Bit mask of EPTXINTSET4 field.
	USB_EOTINTSET_EPTXINTSET4_Msk = 0x10
	// Bit EPTXINTSET4.
	USB_EOTINTSET_EPTXINTSET4 = 0x10
	// Position of EPTXINTSET5 field.
	USB_EOTINTSET_EPTXINTSET5_Pos = 0x5
	// Bit mask of EPTXINTSET5 field.
	USB_EOTINTSET_EPTXINTSET5_Msk = 0x20
	// Bit EPTXINTSET5.
	USB_EOTINTSET_EPTXINTSET5 = 0x20
	// Position of EPTXINTSET6 field.
	USB_EOTINTSET_EPTXINTSET6_Pos = 0x6
	// Bit mask of EPTXINTSET6 field.
	USB_EOTINTSET_EPTXINTSET6_Msk = 0x40
	// Bit EPTXINTSET6.
	USB_EOTINTSET_EPTXINTSET6 = 0x40
	// Position of EPTXINTSET7 field.
	USB_EOTINTSET_EPTXINTSET7_Pos = 0x7
	// Bit mask of EPTXINTSET7 field.
	USB_EOTINTSET_EPTXINTSET7_Msk = 0x80
	// Bit EPTXINTSET7.
	USB_EOTINTSET_EPTXINTSET7 = 0x80
	// Position of EPTXINTSET8 field.
	USB_EOTINTSET_EPTXINTSET8_Pos = 0x8
	// Bit mask of EPTXINTSET8 field.
	USB_EOTINTSET_EPTXINTSET8_Msk = 0x100
	// Bit EPTXINTSET8.
	USB_EOTINTSET_EPTXINTSET8 = 0x100
	// Position of EPTXINTSET9 field.
	USB_EOTINTSET_EPTXINTSET9_Pos = 0x9
	// Bit mask of EPTXINTSET9 field.
	USB_EOTINTSET_EPTXINTSET9_Msk = 0x200
	// Bit EPTXINTSET9.
	USB_EOTINTSET_EPTXINTSET9 = 0x200
	// Position of EPTXINTSET10 field.
	USB_EOTINTSET_EPTXINTSET10_Pos = 0xa
	// Bit mask of EPTXINTSET10 field.
	USB_EOTINTSET_EPTXINTSET10_Msk = 0x400
	// Bit EPTXINTSET10.
	USB_EOTINTSET_EPTXINTSET10 = 0x400
	// Position of EPTXINTSET11 field.
	USB_EOTINTSET_EPTXINTSET11_Pos = 0xb
	// Bit mask of EPTXINTSET11 field.
	USB_EOTINTSET_EPTXINTSET11_Msk = 0x800
	// Bit EPTXINTSET11.
	USB_EOTINTSET_EPTXINTSET11 = 0x800
	// Position of EPTXINTSET12 field.
	USB_EOTINTSET_EPTXINTSET12_Pos = 0xc
	// Bit mask of EPTXINTSET12 field.
	USB_EOTINTSET_EPTXINTSET12_Msk = 0x1000
	// Bit EPTXINTSET12.
	USB_EOTINTSET_EPTXINTSET12 = 0x1000
	// Position of EPTXINTSET13 field.
	USB_EOTINTSET_EPTXINTSET13_Pos = 0xd
	// Bit mask of EPTXINTSET13 field.
	USB_EOTINTSET_EPTXINTSET13_Msk = 0x2000
	// Bit EPTXINTSET13.
	USB_EOTINTSET_EPTXINTSET13 = 0x2000
	// Position of EPTXINTSET14 field.
	USB_EOTINTSET_EPTXINTSET14_Pos = 0xe
	// Bit mask of EPTXINTSET14 field.
	USB_EOTINTSET_EPTXINTSET14_Msk = 0x4000
	// Bit EPTXINTSET14.
	USB_EOTINTSET_EPTXINTSET14 = 0x4000
	// Position of EPTXINTSET15 field.
	USB_EOTINTSET_EPTXINTSET15_Pos = 0xf
	// Bit mask of EPTXINTSET15 field.
	USB_EOTINTSET_EPTXINTSET15_Msk = 0x8000
	// Bit EPTXINTSET15.
	USB_EOTINTSET_EPTXINTSET15 = 0x8000
	// Position of EPTXINTSET16 field.
	USB_EOTINTSET_EPTXINTSET16_Pos = 0x10
	// Bit mask of EPTXINTSET16 field.
	USB_EOTINTSET_EPTXINTSET16_Msk = 0x10000
	// Bit EPTXINTSET16.
	USB_EOTINTSET_EPTXINTSET16 = 0x10000
	// Position of EPTXINTSET17 field.
	USB_EOTINTSET_EPTXINTSET17_Pos = 0x11
	// Bit mask of EPTXINTSET17 field.
	USB_EOTINTSET_EPTXINTSET17_Msk = 0x20000
	// Bit EPTXINTSET17.
	USB_EOTINTSET_EPTXINTSET17 = 0x20000
	// Position of EPTXINTSET18 field.
	USB_EOTINTSET_EPTXINTSET18_Pos = 0x12
	// Bit mask of EPTXINTSET18 field.
	USB_EOTINTSET_EPTXINTSET18_Msk = 0x40000
	// Bit EPTXINTSET18.
	USB_EOTINTSET_EPTXINTSET18 = 0x40000
	// Position of EPTXINTSET19 field.
	USB_EOTINTSET_EPTXINTSET19_Pos = 0x13
	// Bit mask of EPTXINTSET19 field.
	USB_EOTINTSET_EPTXINTSET19_Msk = 0x80000
	// Bit EPTXINTSET19.
	USB_EOTINTSET_EPTXINTSET19 = 0x80000
	// Position of EPTXINTSET20 field.
	USB_EOTINTSET_EPTXINTSET20_Pos = 0x14
	// Bit mask of EPTXINTSET20 field.
	USB_EOTINTSET_EPTXINTSET20_Msk = 0x100000
	// Bit EPTXINTSET20.
	USB_EOTINTSET_EPTXINTSET20 = 0x100000
	// Position of EPTXINTSET21 field.
	USB_EOTINTSET_EPTXINTSET21_Pos = 0x15
	// Bit mask of EPTXINTSET21 field.
	USB_EOTINTSET_EPTXINTSET21_Msk = 0x200000
	// Bit EPTXINTSET21.
	USB_EOTINTSET_EPTXINTSET21 = 0x200000
	// Position of EPTXINTSET22 field.
	USB_EOTINTSET_EPTXINTSET22_Pos = 0x16
	// Bit mask of EPTXINTSET22 field.
	USB_EOTINTSET_EPTXINTSET22_Msk = 0x400000
	// Bit EPTXINTSET22.
	USB_EOTINTSET_EPTXINTSET22 = 0x400000
	// Position of EPTXINTSET23 field.
	USB_EOTINTSET_EPTXINTSET23_Pos = 0x17
	// Bit mask of EPTXINTSET23 field.
	USB_EOTINTSET_EPTXINTSET23_Msk = 0x800000
	// Bit EPTXINTSET23.
	USB_EOTINTSET_EPTXINTSET23 = 0x800000
	// Position of EPTXINTSET24 field.
	USB_EOTINTSET_EPTXINTSET24_Pos = 0x18
	// Bit mask of EPTXINTSET24 field.
	USB_EOTINTSET_EPTXINTSET24_Msk = 0x1000000
	// Bit EPTXINTSET24.
	USB_EOTINTSET_EPTXINTSET24 = 0x1000000
	// Position of EPTXINTSET25 field.
	USB_EOTINTSET_EPTXINTSET25_Pos = 0x19
	// Bit mask of EPTXINTSET25 field.
	USB_EOTINTSET_EPTXINTSET25_Msk = 0x2000000
	// Bit EPTXINTSET25.
	USB_EOTINTSET_EPTXINTSET25 = 0x2000000
	// Position of EPTXINTSET26 field.
	USB_EOTINTSET_EPTXINTSET26_Pos = 0x1a
	// Bit mask of EPTXINTSET26 field.
	USB_EOTINTSET_EPTXINTSET26_Msk = 0x4000000
	// Bit EPTXINTSET26.
	USB_EOTINTSET_EPTXINTSET26 = 0x4000000
	// Position of EPTXINTSET27 field.
	USB_EOTINTSET_EPTXINTSET27_Pos = 0x1b
	// Bit mask of EPTXINTSET27 field.
	USB_EOTINTSET_EPTXINTSET27_Msk = 0x8000000
	// Bit EPTXINTSET27.
	USB_EOTINTSET_EPTXINTSET27 = 0x8000000
	// Position of EPTXINTSET28 field.
	USB_EOTINTSET_EPTXINTSET28_Pos = 0x1c
	// Bit mask of EPTXINTSET28 field.
	USB_EOTINTSET_EPTXINTSET28_Msk = 0x10000000
	// Bit EPTXINTSET28.
	USB_EOTINTSET_EPTXINTSET28 = 0x10000000
	// Position of EPTXINTSET29 field.
	USB_EOTINTSET_EPTXINTSET29_Pos = 0x1d
	// Bit mask of EPTXINTSET29 field.
	USB_EOTINTSET_EPTXINTSET29_Msk = 0x20000000
	// Bit EPTXINTSET29.
	USB_EOTINTSET_EPTXINTSET29 = 0x20000000
	// Position of EPTXINTSET30 field.
	USB_EOTINTSET_EPTXINTSET30_Pos = 0x1e
	// Bit mask of EPTXINTSET30 field.
	USB_EOTINTSET_EPTXINTSET30_Msk = 0x40000000
	// Bit EPTXINTSET30.
	USB_EOTINTSET_EPTXINTSET30 = 0x40000000
	// Position of EPTXINTSET31 field.
	USB_EOTINTSET_EPTXINTSET31_Pos = 0x1f
	// Bit mask of EPTXINTSET31 field.
	USB_EOTINTSET_EPTXINTSET31_Msk = 0x80000000
	// Bit EPTXINTSET31.
	USB_EOTINTSET_EPTXINTSET31 = 0x80000000

	// NDDRINTST: USB New DD Request Interrupt Status
	// Position of EPNDDINTST0 field.
	USB_NDDRINTST_EPNDDINTST0_Pos = 0x0
	// Bit mask of EPNDDINTST0 field.
	USB_NDDRINTST_EPNDDINTST0_Msk = 0x1
	// Bit EPNDDINTST0.
	USB_NDDRINTST_EPNDDINTST0 = 0x1
	// Position of EPNDDINTST1 field.
	USB_NDDRINTST_EPNDDINTST1_Pos = 0x1
	// Bit mask of EPNDDINTST1 field.
	USB_NDDRINTST_EPNDDINTST1_Msk = 0x2
	// Bit EPNDDINTST1.
	USB_NDDRINTST_EPNDDINTST1 = 0x2
	// Position of EPNDDINTST2 field.
	USB_NDDRINTST_EPNDDINTST2_Pos = 0x2
	// Bit mask of EPNDDINTST2 field.
	USB_NDDRINTST_EPNDDINTST2_Msk = 0x4
	// Bit EPNDDINTST2.
	USB_NDDRINTST_EPNDDINTST2 = 0x4
	// Position of EPNDDINTST3 field.
	USB_NDDRINTST_EPNDDINTST3_Pos = 0x3
	// Bit mask of EPNDDINTST3 field.
	USB_NDDRINTST_EPNDDINTST3_Msk = 0x8
	// Bit EPNDDINTST3.
	USB_NDDRINTST_EPNDDINTST3 = 0x8
	// Position of EPNDDINTST4 field.
	USB_NDDRINTST_EPNDDINTST4_Pos = 0x4
	// Bit mask of EPNDDINTST4 field.
	USB_NDDRINTST_EPNDDINTST4_Msk = 0x10
	// Bit EPNDDINTST4.
	USB_NDDRINTST_EPNDDINTST4 = 0x10
	// Position of EPNDDINTST5 field.
	USB_NDDRINTST_EPNDDINTST5_Pos = 0x5
	// Bit mask of EPNDDINTST5 field.
	USB_NDDRINTST_EPNDDINTST5_Msk = 0x20
	// Bit EPNDDINTST5.
	USB_NDDRINTST_EPNDDINTST5 = 0x20
	// Position of EPNDDINTST6 field.
	USB_NDDRINTST_EPNDDINTST6_Pos = 0x6
	// Bit mask of EPNDDINTST6 field.
	USB_NDDRINTST_EPNDDINTST6_Msk = 0x40
	// Bit EPNDDINTST6.
	USB_NDDRINTST_EPNDDINTST6 = 0x40
	// Position of EPNDDINTST7 field.
	USB_NDDRINTST_EPNDDINTST7_Pos = 0x7
	// Bit mask of EPNDDINTST7 field.
	USB_NDDRINTST_EPNDDINTST7_Msk = 0x80
	// Bit EPNDDINTST7.
	USB_NDDRINTST_EPNDDINTST7 = 0x80
	// Position of EPNDDINTST8 field.
	USB_NDDRINTST_EPNDDINTST8_Pos = 0x8
	// Bit mask of EPNDDINTST8 field.
	USB_NDDRINTST_EPNDDINTST8_Msk = 0x100
	// Bit EPNDDINTST8.
	USB_NDDRINTST_EPNDDINTST8 = 0x100
	// Position of EPNDDINTST9 field.
	USB_NDDRINTST_EPNDDINTST9_Pos = 0x9
	// Bit mask of EPNDDINTST9 field.
	USB_NDDRINTST_EPNDDINTST9_Msk = 0x200
	// Bit EPNDDINTST9.
	USB_NDDRINTST_EPNDDINTST9 = 0x200
	// Position of EPNDDINTST10 field.
	USB_NDDRINTST_EPNDDINTST10_Pos = 0xa
	// Bit mask of EPNDDINTST10 field.
	USB_NDDRINTST_EPNDDINTST10_Msk = 0x400
	// Bit EPNDDINTST10.
	USB_NDDRINTST_EPNDDINTST10 = 0x400
	// Position of EPNDDINTST11 field.
	USB_NDDRINTST_EPNDDINTST11_Pos = 0xb
	// Bit mask of EPNDDINTST11 field.
	USB_NDDRINTST_EPNDDINTST11_Msk = 0x800
	// Bit EPNDDINTST11.
	USB_NDDRINTST_EPNDDINTST11 = 0x800
	// Position of EPNDDINTST12 field.
	USB_NDDRINTST_EPNDDINTST12_Pos = 0xc
	// Bit mask of EPNDDINTST12 field.
	USB_NDDRINTST_EPNDDINTST12_Msk = 0x1000
	// Bit EPNDDINTST12.
	USB_NDDRINTST_EPNDDINTST12 = 0x1000
	// Position of EPNDDINTST13 field.
	USB_NDDRINTST_EPNDDINTST13_Pos = 0xd
	// Bit mask of EPNDDINTST13 field.
	USB_NDDRINTST_EPNDDINTST13_Msk = 0x2000
	// Bit EPNDDINTST13.
	USB_NDDRINTST_EPNDDINTST13 = 0x2000
	// Position of EPNDDINTST14 field.
	USB_NDDRINTST_EPNDDINTST14_Pos = 0xe
	// Bit mask of EPNDDINTST14 field.
	USB_NDDRINTST_EPNDDINTST14_Msk = 0x4000
	// Bit EPNDDINTST14.
	USB_NDDRINTST_EPNDDINTST14 = 0x4000
	// Position of EPNDDINTST15 field.
	USB_NDDRINTST_EPNDDINTST15_Pos = 0xf
	// Bit mask of EPNDDINTST15 field.
	USB_NDDRINTST_EPNDDINTST15_Msk = 0x8000
	// Bit EPNDDINTST15.
	USB_NDDRINTST_EPNDDINTST15 = 0x8000
	// Position of EPNDDINTST16 field.
	USB_NDDRINTST_EPNDDINTST16_Pos = 0x10
	// Bit mask of EPNDDINTST16 field.
	USB_NDDRINTST_EPNDDINTST16_Msk = 0x10000
	// Bit EPNDDINTST16.
	USB_NDDRINTST_EPNDDINTST16 = 0x10000
	// Position of EPNDDINTST17 field.
	USB_NDDRINTST_EPNDDINTST17_Pos = 0x11
	// Bit mask of EPNDDINTST17 field.
	USB_NDDRINTST_EPNDDINTST17_Msk = 0x20000
	// Bit EPNDDINTST17.
	USB_NDDRINTST_EPNDDINTST17 = 0x20000
	// Position of EPNDDINTST18 field.
	USB_NDDRINTST_EPNDDINTST18_Pos = 0x12
	// Bit mask of EPNDDINTST18 field.
	USB_NDDRINTST_EPNDDINTST18_Msk = 0x40000
	// Bit EPNDDINTST18.
	USB_NDDRINTST_EPNDDINTST18 = 0x40000
	// Position of EPNDDINTST19 field.
	USB_NDDRINTST_EPNDDINTST19_Pos = 0x13
	// Bit mask of EPNDDINTST19 field.
	USB_NDDRINTST_EPNDDINTST19_Msk = 0x80000
	// Bit EPNDDINTST19.
	USB_NDDRINTST_EPNDDINTST19 = 0x80000
	// Position of EPNDDINTST20 field.
	USB_NDDRINTST_EPNDDINTST20_Pos = 0x14
	// Bit mask of EPNDDINTST20 field.
	USB_NDDRINTST_EPNDDINTST20_Msk = 0x100000
	// Bit EPNDDINTST20.
	USB_NDDRINTST_EPNDDINTST20 = 0x100000
	// Position of EPNDDINTST21 field.
	USB_NDDRINTST_EPNDDINTST21_Pos = 0x15
	// Bit mask of EPNDDINTST21 field.
	USB_NDDRINTST_EPNDDINTST21_Msk = 0x200000
	// Bit EPNDDINTST21.
	USB_NDDRINTST_EPNDDINTST21 = 0x200000
	// Position of EPNDDINTST22 field.
	USB_NDDRINTST_EPNDDINTST22_Pos = 0x16
	// Bit mask of EPNDDINTST22 field.
	USB_NDDRINTST_EPNDDINTST22_Msk = 0x400000
	// Bit EPNDDINTST22.
	USB_NDDRINTST_EPNDDINTST22 = 0x400000
	// Position of EPNDDINTST23 field.
	USB_NDDRINTST_EPNDDINTST23_Pos = 0x17
	// Bit mask of EPNDDINTST23 field.
	USB_NDDRINTST_EPNDDINTST23_Msk = 0x800000
	// Bit EPNDDINTST23.
	USB_NDDRINTST_EPNDDINTST23 = 0x800000
	// Position of EPNDDINTST24 field.
	USB_NDDRINTST_EPNDDINTST24_Pos = 0x18
	// Bit mask of EPNDDINTST24 field.
	USB_NDDRINTST_EPNDDINTST24_Msk = 0x1000000
	// Bit EPNDDINTST24.
	USB_NDDRINTST_EPNDDINTST24 = 0x1000000
	// Position of EPNDDINTST25 field.
	USB_NDDRINTST_EPNDDINTST25_Pos = 0x19
	// Bit mask of EPNDDINTST25 field.
	USB_NDDRINTST_EPNDDINTST25_Msk = 0x2000000
	// Bit EPNDDINTST25.
	USB_NDDRINTST_EPNDDINTST25 = 0x2000000
	// Position of EPNDDINTST26 field.
	USB_NDDRINTST_EPNDDINTST26_Pos = 0x1a
	// Bit mask of EPNDDINTST26 field.
	USB_NDDRINTST_EPNDDINTST26_Msk = 0x4000000
	// Bit EPNDDINTST26.
	USB_NDDRINTST_EPNDDINTST26 = 0x4000000
	// Position of EPNDDINTST27 field.
	USB_NDDRINTST_EPNDDINTST27_Pos = 0x1b
	// Bit mask of EPNDDINTST27 field.
	USB_NDDRINTST_EPNDDINTST27_Msk = 0x8000000
	// Bit EPNDDINTST27.
	USB_NDDRINTST_EPNDDINTST27 = 0x8000000
	// Position of EPNDDINTST28 field.
	USB_NDDRINTST_EPNDDINTST28_Pos = 0x1c
	// Bit mask of EPNDDINTST28 field.
	USB_NDDRINTST_EPNDDINTST28_Msk = 0x10000000
	// Bit EPNDDINTST28.
	USB_NDDRINTST_EPNDDINTST28 = 0x10000000
	// Position of EPNDDINTST29 field.
	USB_NDDRINTST_EPNDDINTST29_Pos = 0x1d
	// Bit mask of EPNDDINTST29 field.
	USB_NDDRINTST_EPNDDINTST29_Msk = 0x20000000
	// Bit EPNDDINTST29.
	USB_NDDRINTST_EPNDDINTST29 = 0x20000000
	// Position of EPNDDINTST30 field.
	USB_NDDRINTST_EPNDDINTST30_Pos = 0x1e
	// Bit mask of EPNDDINTST30 field.
	USB_NDDRINTST_EPNDDINTST30_Msk = 0x40000000
	// Bit EPNDDINTST30.
	USB_NDDRINTST_EPNDDINTST30 = 0x40000000
	// Position of EPNDDINTST31 field.
	USB_NDDRINTST_EPNDDINTST31_Pos = 0x1f
	// Bit mask of EPNDDINTST31 field.
	USB_NDDRINTST_EPNDDINTST31_Msk = 0x80000000
	// Bit EPNDDINTST31.
	USB_NDDRINTST_EPNDDINTST31 = 0x80000000

	// NDDRINTCLR: USB New DD Request Interrupt Clear
	// Position of EPNDDINTCLR0 field.
	USB_NDDRINTCLR_EPNDDINTCLR0_Pos = 0x0
	// Bit mask of EPNDDINTCLR0 field.
	USB_NDDRINTCLR_EPNDDINTCLR0_Msk = 0x1
	// Bit EPNDDINTCLR0.
	USB_NDDRINTCLR_EPNDDINTCLR0 = 0x1
	// Position of EPNDDINTCLR1 field.
	USB_NDDRINTCLR_EPNDDINTCLR1_Pos = 0x1
	// Bit mask of EPNDDINTCLR1 field.
	USB_NDDRINTCLR_EPNDDINTCLR1_Msk = 0x2
	// Bit EPNDDINTCLR1.
	USB_NDDRINTCLR_EPNDDINTCLR1 = 0x2
	// Position of EPNDDINTCLR2 field.
	USB_NDDRINTCLR_EPNDDINTCLR2_Pos = 0x2
	// Bit mask of EPNDDINTCLR2 field.
	USB_NDDRINTCLR_EPNDDINTCLR2_Msk = 0x4
	// Bit EPNDDINTCLR2.
	USB_NDDRINTCLR_EPNDDINTCLR2 = 0x4
	// Position of EPNDDINTCLR3 field.
	USB_NDDRINTCLR_EPNDDINTCLR3_Pos = 0x3
	// Bit mask of EPNDDINTCLR3 field.
	USB_NDDRINTCLR_EPNDDINTCLR3_Msk = 0x8
	// Bit EPNDDINTCLR3.
	USB_NDDRINTCLR_EPNDDINTCLR3 = 0x8
	// Position of EPNDDINTCLR4 field.
	USB_NDDRINTCLR_EPNDDINTCLR4_Pos = 0x4
	// Bit mask of EPNDDINTCLR4 field.
	USB_NDDRINTCLR_EPNDDINTCLR4_Msk = 0x10
	// Bit EPNDDINTCLR4.
	USB_NDDRINTCLR_EPNDDINTCLR4 = 0x10
	// Position of EPNDDINTCLR5 field.
	USB_NDDRINTCLR_EPNDDINTCLR5_Pos = 0x5
	// Bit mask of EPNDDINTCLR5 field.
	USB_NDDRINTCLR_EPNDDINTCLR5_Msk = 0x20
	// Bit EPNDDINTCLR5.
	USB_NDDRINTCLR_EPNDDINTCLR5 = 0x20
	// Position of EPNDDINTCLR6 field.
	USB_NDDRINTCLR_EPNDDINTCLR6_Pos = 0x6
	// Bit mask of EPNDDINTCLR6 field.
	USB_NDDRINTCLR_EPNDDINTCLR6_Msk = 0x40
	// Bit EPNDDINTCLR6.
	USB_NDDRINTCLR_EPNDDINTCLR6 = 0x40
	// Position of EPNDDINTCLR7 field.
	USB_NDDRINTCLR_EPNDDINTCLR7_Pos = 0x7
	// Bit mask of EPNDDINTCLR7 field.
	USB_NDDRINTCLR_EPNDDINTCLR7_Msk = 0x80
	// Bit EPNDDINTCLR7.
	USB_NDDRINTCLR_EPNDDINTCLR7 = 0x80
	// Position of EPNDDINTCLR8 field.
	USB_NDDRINTCLR_EPNDDINTCLR8_Pos = 0x8
	// Bit mask of EPNDDINTCLR8 field.
	USB_NDDRINTCLR_EPNDDINTCLR8_Msk = 0x100
	// Bit EPNDDINTCLR8.
	USB_NDDRINTCLR_EPNDDINTCLR8 = 0x100
	// Position of EPNDDINTCLR9 field.
	USB_NDDRINTCLR_EPNDDINTCLR9_Pos = 0x9
	// Bit mask of EPNDDINTCLR9 field.
	USB_NDDRINTCLR_EPNDDINTCLR9_Msk = 0x200
	// Bit EPNDDINTCLR9.
	USB_NDDRINTCLR_EPNDDINTCLR9 = 0x200
	// Position of EPNDDINTCLR10 field.
	USB_NDDRINTCLR_EPNDDINTCLR10_Pos = 0xa
	// Bit mask of EPNDDINTCLR10 field.
	USB_NDDRINTCLR_EPNDDINTCLR10_Msk = 0x400
	// Bit EPNDDINTCLR10.
	USB_NDDRINTCLR_EPNDDINTCLR10 = 0x400
	// Position of EPNDDINTCLR11 field.
	USB_NDDRINTCLR_EPNDDINTCLR11_Pos = 0xb
	// Bit mask of EPNDDINTCLR11 field.
	USB_NDDRINTCLR_EPNDDINTCLR11_Msk = 0x800
	// Bit EPNDDINTCLR11.
	USB_NDDRINTCLR_EPNDDINTCLR11 = 0x800
	// Position of EPNDDINTCLR12 field.
	USB_NDDRINTCLR_EPNDDINTCLR12_Pos = 0xc
	// Bit mask of EPNDDINTCLR12 field.
	USB_NDDRINTCLR_EPNDDINTCLR12_Msk = 0x1000
	// Bit EPNDDINTCLR12.
	USB_NDDRINTCLR_EPNDDINTCLR12 = 0x1000
	// Position of EPNDDINTCLR13 field.
	USB_NDDRINTCLR_EPNDDINTCLR13_Pos = 0xd
	// Bit mask of EPNDDINTCLR13 field.
	USB_NDDRINTCLR_EPNDDINTCLR13_Msk = 0x2000
	// Bit EPNDDINTCLR13.
	USB_NDDRINTCLR_EPNDDINTCLR13 = 0x2000
	// Position of EPNDDINTCLR14 field.
	USB_NDDRINTCLR_EPNDDINTCLR14_Pos = 0xe
	// Bit mask of EPNDDINTCLR14 field.
	USB_NDDRINTCLR_EPNDDINTCLR14_Msk = 0x4000
	// Bit EPNDDINTCLR14.
	USB_NDDRINTCLR_EPNDDINTCLR14 = 0x4000
	// Position of EPNDDINTCLR15 field.
	USB_NDDRINTCLR_EPNDDINTCLR15_Pos = 0xf
	// Bit mask of EPNDDINTCLR15 field.
	USB_NDDRINTCLR_EPNDDINTCLR15_Msk = 0x8000
	// Bit EPNDDINTCLR15.
	USB_NDDRINTCLR_EPNDDINTCLR15 = 0x8000
	// Position of EPNDDINTCLR16 field.
	USB_NDDRINTCLR_EPNDDINTCLR16_Pos = 0x10
	// Bit mask of EPNDDINTCLR16 field.
	USB_NDDRINTCLR_EPNDDINTCLR16_Msk = 0x10000
	// Bit EPNDDINTCLR16.
	USB_NDDRINTCLR_EPNDDINTCLR16 = 0x10000
	// Position of EPNDDINTCLR17 field.
	USB_NDDRINTCLR_EPNDDINTCLR17_Pos = 0x11
	// Bit mask of EPNDDINTCLR17 field.
	USB_NDDRINTCLR_EPNDDINTCLR17_Msk = 0x20000
	// Bit EPNDDINTCLR17.
	USB_NDDRINTCLR_EPNDDINTCLR17 = 0x20000
	// Position of EPNDDINTCLR18 field.
	USB_NDDRINTCLR_EPNDDINTCLR18_Pos = 0x12
	// Bit mask of EPNDDINTCLR18 field.
	USB_NDDRINTCLR_EPNDDINTCLR18_Msk = 0x40000
	// Bit EPNDDINTCLR18.
	USB_NDDRINTCLR_EPNDDINTCLR18 = 0x40000
	// Position of EPNDDINTCLR19 field.
	USB_NDDRINTCLR_EPNDDINTCLR19_Pos = 0x13
	// Bit mask of EPNDDINTCLR19 field.
	USB_NDDRINTCLR_EPNDDINTCLR19_Msk = 0x80000
	// Bit EPNDDINTCLR19.
	USB_NDDRINTCLR_EPNDDINTCLR19 = 0x80000
	// Position of EPNDDINTCLR20 field.
	USB_NDDRINTCLR_EPNDDINTCLR20_Pos = 0x14
	// Bit mask of EPNDDINTCLR20 field.
	USB_NDDRINTCLR_EPNDDINTCLR20_Msk = 0x100000
	// Bit EPNDDINTCLR20.
	USB_NDDRINTCLR_EPNDDINTCLR20 = 0x100000
	// Position of EPNDDINTCLR21 field.
	USB_NDDRINTCLR_EPNDDINTCLR21_Pos = 0x15
	// Bit mask of EPNDDINTCLR21 field.
	USB_NDDRINTCLR_EPNDDINTCLR21_Msk = 0x200000
	// Bit EPNDDINTCLR21.
	USB_NDDRINTCLR_EPNDDINTCLR21 = 0x200000
	// Position of EPNDDINTCLR22 field.
	USB_NDDRINTCLR_EPNDDINTCLR22_Pos = 0x16
	// Bit mask of EPNDDINTCLR22 field.
	USB_NDDRINTCLR_EPNDDINTCLR22_Msk = 0x400000
	// Bit EPNDDINTCLR22.
	USB_NDDRINTCLR_EPNDDINTCLR22 = 0x400000
	// Position of EPNDDINTCLR23 field.
	USB_NDDRINTCLR_EPNDDINTCLR23_Pos = 0x17
	// Bit mask of EPNDDINTCLR23 field.
	USB_NDDRINTCLR_EPNDDINTCLR23_Msk = 0x800000
	// Bit EPNDDINTCLR23.
	USB_NDDRINTCLR_EPNDDINTCLR23 = 0x800000
	// Position of EPNDDINTCLR24 field.
	USB_NDDRINTCLR_EPNDDINTCLR24_Pos = 0x18
	// Bit mask of EPNDDINTCLR24 field.
	USB_NDDRINTCLR_EPNDDINTCLR24_Msk = 0x1000000
	// Bit EPNDDINTCLR24.
	USB_NDDRINTCLR_EPNDDINTCLR24 = 0x1000000
	// Position of EPNDDINTCLR25 field.
	USB_NDDRINTCLR_EPNDDINTCLR25_Pos = 0x19
	// Bit mask of EPNDDINTCLR25 field.
	USB_NDDRINTCLR_EPNDDINTCLR25_Msk = 0x2000000
	// Bit EPNDDINTCLR25.
	USB_NDDRINTCLR_EPNDDINTCLR25 = 0x2000000
	// Position of EPNDDINTCLR26 field.
	USB_NDDRINTCLR_EPNDDINTCLR26_Pos = 0x1a
	// Bit mask of EPNDDINTCLR26 field.
	USB_NDDRINTCLR_EPNDDINTCLR26_Msk = 0x4000000
	// Bit EPNDDINTCLR26.
	USB_NDDRINTCLR_EPNDDINTCLR26 = 0x4000000
	// Position of EPNDDINTCLR27 field.
	USB_NDDRINTCLR_EPNDDINTCLR27_Pos = 0x1b
	// Bit mask of EPNDDINTCLR27 field.
	USB_NDDRINTCLR_EPNDDINTCLR27_Msk = 0x8000000
	// Bit EPNDDINTCLR27.
	USB_NDDRINTCLR_EPNDDINTCLR27 = 0x8000000
	// Position of EPNDDINTCLR28 field.
	USB_NDDRINTCLR_EPNDDINTCLR28_Pos = 0x1c
	// Bit mask of EPNDDINTCLR28 field.
	USB_NDDRINTCLR_EPNDDINTCLR28_Msk = 0x10000000
	// Bit EPNDDINTCLR28.
	USB_NDDRINTCLR_EPNDDINTCLR28 = 0x10000000
	// Position of EPNDDINTCLR29 field.
	USB_NDDRINTCLR_EPNDDINTCLR29_Pos = 0x1d
	// Bit mask of EPNDDINTCLR29 field.
	USB_NDDRINTCLR_EPNDDINTCLR29_Msk = 0x20000000
	// Bit EPNDDINTCLR29.
	USB_NDDRINTCLR_EPNDDINTCLR29 = 0x20000000
	// Position of EPNDDINTCLR30 field.
	USB_NDDRINTCLR_EPNDDINTCLR30_Pos = 0x1e
	// Bit mask of EPNDDINTCLR30 field.
	USB_NDDRINTCLR_EPNDDINTCLR30_Msk = 0x40000000
	// Bit EPNDDINTCLR30.
	USB_NDDRINTCLR_EPNDDINTCLR30 = 0x40000000
	// Position of EPNDDINTCLR31 field.
	USB_NDDRINTCLR_EPNDDINTCLR31_Pos = 0x1f
	// Bit mask of EPNDDINTCLR31 field.
	USB_NDDRINTCLR_EPNDDINTCLR31_Msk = 0x80000000
	// Bit EPNDDINTCLR31.
	USB_NDDRINTCLR_EPNDDINTCLR31 = 0x80000000

	// NDDRINTSET: USB New DD Request Interrupt Set
	// Position of EPNDDINTSET0 field.
	USB_NDDRINTSET_EPNDDINTSET0_Pos = 0x0
	// Bit mask of EPNDDINTSET0 field.
	USB_NDDRINTSET_EPNDDINTSET0_Msk = 0x1
	// Bit EPNDDINTSET0.
	USB_NDDRINTSET_EPNDDINTSET0 = 0x1
	// Position of EPNDDINTSET1 field.
	USB_NDDRINTSET_EPNDDINTSET1_Pos = 0x1
	// Bit mask of EPNDDINTSET1 field.
	USB_NDDRINTSET_EPNDDINTSET1_Msk = 0x2
	// Bit EPNDDINTSET1.
	USB_NDDRINTSET_EPNDDINTSET1 = 0x2
	// Position of EPNDDINTSET2 field.
	USB_NDDRINTSET_EPNDDINTSET2_Pos = 0x2
	// Bit mask of EPNDDINTSET2 field.
	USB_NDDRINTSET_EPNDDINTSET2_Msk = 0x4
	// Bit EPNDDINTSET2.
	USB_NDDRINTSET_EPNDDINTSET2 = 0x4
	// Position of EPNDDINTSET3 field.
	USB_NDDRINTSET_EPNDDINTSET3_Pos = 0x3
	// Bit mask of EPNDDINTSET3 field.
	USB_NDDRINTSET_EPNDDINTSET3_Msk = 0x8
	// Bit EPNDDINTSET3.
	USB_NDDRINTSET_EPNDDINTSET3 = 0x8
	// Position of EPNDDINTSET4 field.
	USB_NDDRINTSET_EPNDDINTSET4_Pos = 0x4
	// Bit mask of EPNDDINTSET4 field.
	USB_NDDRINTSET_EPNDDINTSET4_Msk = 0x10
	// Bit EPNDDINTSET4.
	USB_NDDRINTSET_EPNDDINTSET4 = 0x10
	// Position of EPNDDINTSET5 field.
	USB_NDDRINTSET_EPNDDINTSET5_Pos = 0x5
	// Bit mask of EPNDDINTSET5 field.
	USB_NDDRINTSET_EPNDDINTSET5_Msk = 0x20
	// Bit EPNDDINTSET5.
	USB_NDDRINTSET_EPNDDINTSET5 = 0x20
	// Position of EPNDDINTSET6 field.
	USB_NDDRINTSET_EPNDDINTSET6_Pos = 0x6
	// Bit mask of EPNDDINTSET6 field.
	USB_NDDRINTSET_EPNDDINTSET6_Msk = 0x40
	// Bit EPNDDINTSET6.
	USB_NDDRINTSET_EPNDDINTSET6 = 0x40
	// Position of EPNDDINTSET7 field.
	USB_NDDRINTSET_EPNDDINTSET7_Pos = 0x7
	// Bit mask of EPNDDINTSET7 field.
	USB_NDDRINTSET_EPNDDINTSET7_Msk = 0x80
	// Bit EPNDDINTSET7.
	USB_NDDRINTSET_EPNDDINTSET7 = 0x80
	// Position of EPNDDINTSET8 field.
	USB_NDDRINTSET_EPNDDINTSET8_Pos = 0x8
	// Bit mask of EPNDDINTSET8 field.
	USB_NDDRINTSET_EPNDDINTSET8_Msk = 0x100
	// Bit EPNDDINTSET8.
	USB_NDDRINTSET_EPNDDINTSET8 = 0x100
	// Position of EPNDDINTSET9 field.
	USB_NDDRINTSET_EPNDDINTSET9_Pos = 0x9
	// Bit mask of EPNDDINTSET9 field.
	USB_NDDRINTSET_EPNDDINTSET9_Msk = 0x200
	// Bit EPNDDINTSET9.
	USB_NDDRINTSET_EPNDDINTSET9 = 0x200
	// Position of EPNDDINTSET10 field.
	USB_NDDRINTSET_EPNDDINTSET10_Pos = 0xa
	// Bit mask of EPNDDINTSET10 field.
	USB_NDDRINTSET_EPNDDINTSET10_Msk = 0x400
	// Bit EPNDDINTSET10.
	USB_NDDRINTSET_EPNDDINTSET10 = 0x400
	// Position of EPNDDINTSET11 field.
	USB_NDDRINTSET_EPNDDINTSET11_Pos = 0xb
	// Bit mask of EPNDDINTSET11 field.
	USB_NDDRINTSET_EPNDDINTSET11_Msk = 0x800
	// Bit EPNDDINTSET11.
	USB_NDDRINTSET_EPNDDINTSET11 = 0x800
	// Position of EPNDDINTSET12 field.
	USB_NDDRINTSET_EPNDDINTSET12_Pos = 0xc
	// Bit mask of EPNDDINTSET12 field.
	USB_NDDRINTSET_EPNDDINTSET12_Msk = 0x1000
	// Bit EPNDDINTSET12.
	USB_NDDRINTSET_EPNDDINTSET12 = 0x1000
	// Position of EPNDDINTSET13 field.
	USB_NDDRINTSET_EPNDDINTSET13_Pos = 0xd
	// Bit mask of EPNDDINTSET13 field.
	USB_NDDRINTSET_EPNDDINTSET13_Msk = 0x2000
	// Bit EPNDDINTSET13.
	USB_NDDRINTSET_EPNDDINTSET13 = 0x2000
	// Position of EPNDDINTSET14 field.
	USB_NDDRINTSET_EPNDDINTSET14_Pos = 0xe
	// Bit mask of EPNDDINTSET14 field.
	USB_NDDRINTSET_EPNDDINTSET14_Msk = 0x4000
	// Bit EPNDDINTSET14.
	USB_NDDRINTSET_EPNDDINTSET14 = 0x4000
	// Position of EPNDDINTSET15 field.
	USB_NDDRINTSET_EPNDDINTSET15_Pos = 0xf
	// Bit mask of EPNDDINTSET15 field.
	USB_NDDRINTSET_EPNDDINTSET15_Msk = 0x8000
	// Bit EPNDDINTSET15.
	USB_NDDRINTSET_EPNDDINTSET15 = 0x8000
	// Position of EPNDDINTSET16 field.
	USB_NDDRINTSET_EPNDDINTSET16_Pos = 0x10
	// Bit mask of EPNDDINTSET16 field.
	USB_NDDRINTSET_EPNDDINTSET16_Msk = 0x10000
	// Bit EPNDDINTSET16.
	USB_NDDRINTSET_EPNDDINTSET16 = 0x10000
	// Position of EPNDDINTSET17 field.
	USB_NDDRINTSET_EPNDDINTSET17_Pos = 0x11
	// Bit mask of EPNDDINTSET17 field.
	USB_NDDRINTSET_EPNDDINTSET17_Msk = 0x20000
	// Bit EPNDDINTSET17.
	USB_NDDRINTSET_EPNDDINTSET17 = 0x20000
	// Position of EPNDDINTSET18 field.
	USB_NDDRINTSET_EPNDDINTSET18_Pos = 0x12
	// Bit mask of EPNDDINTSET18 field.
	USB_NDDRINTSET_EPNDDINTSET18_Msk = 0x40000
	// Bit EPNDDINTSET18.
	USB_NDDRINTSET_EPNDDINTSET18 = 0x40000
	// Position of EPNDDINTSET19 field.
	USB_NDDRINTSET_EPNDDINTSET19_Pos = 0x13
	// Bit mask of EPNDDINTSET19 field.
	USB_NDDRINTSET_EPNDDINTSET19_Msk = 0x80000
	// Bit EPNDDINTSET19.
	USB_NDDRINTSET_EPNDDINTSET19 = 0x80000
	// Position of EPNDDINTSET20 field.
	USB_NDDRINTSET_EPNDDINTSET20_Pos = 0x14
	// Bit mask of EPNDDINTSET20 field.
	USB_NDDRINTSET_EPNDDINTSET20_Msk = 0x100000
	// Bit EPNDDINTSET20.
	USB_NDDRINTSET_EPNDDINTSET20 = 0x100000
	// Position of EPNDDINTSET21 field.
	USB_NDDRINTSET_EPNDDINTSET21_Pos = 0x15
	// Bit mask of EPNDDINTSET21 field.
	USB_NDDRINTSET_EPNDDINTSET21_Msk = 0x200000
	// Bit EPNDDINTSET21.
	USB_NDDRINTSET_EPNDDINTSET21 = 0x200000
	// Position of EPNDDINTSET22 field.
	USB_NDDRINTSET_EPNDDINTSET22_Pos = 0x16
	// Bit mask of EPNDDINTSET22 field.
	USB_NDDRINTSET_EPNDDINTSET22_Msk = 0x400000
	// Bit EPNDDINTSET22.
	USB_NDDRINTSET_EPNDDINTSET22 = 0x400000
	// Position of EPNDDINTSET23 field.
	USB_NDDRINTSET_EPNDDINTSET23_Pos = 0x17
	// Bit mask of EPNDDINTSET23 field.
	USB_NDDRINTSET_EPNDDINTSET23_Msk = 0x800000
	// Bit EPNDDINTSET23.
	USB_NDDRINTSET_EPNDDINTSET23 = 0x800000
	// Position of EPNDDINTSET24 field.
	USB_NDDRINTSET_EPNDDINTSET24_Pos = 0x18
	// Bit mask of EPNDDINTSET24 field.
	USB_NDDRINTSET_EPNDDINTSET24_Msk = 0x1000000
	// Bit EPNDDINTSET24.
	USB_NDDRINTSET_EPNDDINTSET24 = 0x1000000
	// Position of EPNDDINTSET25 field.
	USB_NDDRINTSET_EPNDDINTSET25_Pos = 0x19
	// Bit mask of EPNDDINTSET25 field.
	USB_NDDRINTSET_EPNDDINTSET25_Msk = 0x2000000
	// Bit EPNDDINTSET25.
	USB_NDDRINTSET_EPNDDINTSET25 = 0x2000000
	// Position of EPNDDINTSET26 field.
	USB_NDDRINTSET_EPNDDINTSET26_Pos = 0x1a
	// Bit mask of EPNDDINTSET26 field.
	USB_NDDRINTSET_EPNDDINTSET26_Msk = 0x4000000
	// Bit EPNDDINTSET26.
	USB_NDDRINTSET_EPNDDINTSET26 = 0x4000000
	// Position of EPNDDINTSET27 field.
	USB_NDDRINTSET_EPNDDINTSET27_Pos = 0x1b
	// Bit mask of EPNDDINTSET27 field.
	USB_NDDRINTSET_EPNDDINTSET27_Msk = 0x8000000
	// Bit EPNDDINTSET27.
	USB_NDDRINTSET_EPNDDINTSET27 = 0x8000000
	// Position of EPNDDINTSET28 field.
	USB_NDDRINTSET_EPNDDINTSET28_Pos = 0x1c
	// Bit mask of EPNDDINTSET28 field.
	USB_NDDRINTSET_EPNDDINTSET28_Msk = 0x10000000
	// Bit EPNDDINTSET28.
	USB_NDDRINTSET_EPNDDINTSET28 = 0x10000000
	// Position of EPNDDINTSET29 field.
	USB_NDDRINTSET_EPNDDINTSET29_Pos = 0x1d
	// Bit mask of EPNDDINTSET29 field.
	USB_NDDRINTSET_EPNDDINTSET29_Msk = 0x20000000
	// Bit EPNDDINTSET29.
	USB_NDDRINTSET_EPNDDINTSET29 = 0x20000000
	// Position of EPNDDINTSET30 field.
	USB_NDDRINTSET_EPNDDINTSET30_Pos = 0x1e
	// Bit mask of EPNDDINTSET30 field.
	USB_NDDRINTSET_EPNDDINTSET30_Msk = 0x40000000
	// Bit EPNDDINTSET30.
	USB_NDDRINTSET_EPNDDINTSET30 = 0x40000000
	// Position of EPNDDINTSET31 field.
	USB_NDDRINTSET_EPNDDINTSET31_Pos = 0x1f
	// Bit mask of EPNDDINTSET31 field.
	USB_NDDRINTSET_EPNDDINTSET31_Msk = 0x80000000
	// Bit EPNDDINTSET31.
	USB_NDDRINTSET_EPNDDINTSET31 = 0x80000000

	// SYSERRINTST: USB System Error Interrupt Status
	// Position of EPERRINTST0 field.
	USB_SYSERRINTST_EPERRINTST0_Pos = 0x0
	// Bit mask of EPERRINTST0 field.
	USB_SYSERRINTST_EPERRINTST0_Msk = 0x1
	// Bit EPERRINTST0.
	USB_SYSERRINTST_EPERRINTST0 = 0x1
	// Position of EPERRINTST1 field.
	USB_SYSERRINTST_EPERRINTST1_Pos = 0x1
	// Bit mask of EPERRINTST1 field.
	USB_SYSERRINTST_EPERRINTST1_Msk = 0x2
	// Bit EPERRINTST1.
	USB_SYSERRINTST_EPERRINTST1 = 0x2
	// Position of EPERRINTST2 field.
	USB_SYSERRINTST_EPERRINTST2_Pos = 0x2
	// Bit mask of EPERRINTST2 field.
	USB_SYSERRINTST_EPERRINTST2_Msk = 0x4
	// Bit EPERRINTST2.
	USB_SYSERRINTST_EPERRINTST2 = 0x4
	// Position of EPERRINTST3 field.
	USB_SYSERRINTST_EPERRINTST3_Pos = 0x3
	// Bit mask of EPERRINTST3 field.
	USB_SYSERRINTST_EPERRINTST3_Msk = 0x8
	// Bit EPERRINTST3.
	USB_SYSERRINTST_EPERRINTST3 = 0x8
	// Position of EPERRINTST4 field.
	USB_SYSERRINTST_EPERRINTST4_Pos = 0x4
	// Bit mask of EPERRINTST4 field.
	USB_SYSERRINTST_EPERRINTST4_Msk = 0x10
	// Bit EPERRINTST4.
	USB_SYSERRINTST_EPERRINTST4 = 0x10
	// Position of EPERRINTST5 field.
	USB_SYSERRINTST_EPERRINTST5_Pos = 0x5
	// Bit mask of EPERRINTST5 field.
	USB_SYSERRINTST_EPERRINTST5_Msk = 0x20
	// Bit EPERRINTST5.
	USB_SYSERRINTST_EPERRINTST5 = 0x20
	// Position of EPERRINTST6 field.
	USB_SYSERRINTST_EPERRINTST6_Pos = 0x6
	// Bit mask of EPERRINTST6 field.
	USB_SYSERRINTST_EPERRINTST6_Msk = 0x40
	// Bit EPERRINTST6.
	USB_SYSERRINTST_EPERRINTST6 = 0x40
	// Position of EPERRINTST7 field.
	USB_SYSERRINTST_EPERRINTST7_Pos = 0x7
	// Bit mask of EPERRINTST7 field.
	USB_SYSERRINTST_EPERRINTST7_Msk = 0x80
	// Bit EPERRINTST7.
	USB_SYSERRINTST_EPERRINTST7 = 0x80
	// Position of EPERRINTST8 field.
	USB_SYSERRINTST_EPERRINTST8_Pos = 0x8
	// Bit mask of EPERRINTST8 field.
	USB_SYSERRINTST_EPERRINTST8_Msk = 0x100
	// Bit EPERRINTST8.
	USB_SYSERRINTST_EPERRINTST8 = 0x100
	// Position of EPERRINTST9 field.
	USB_SYSERRINTST_EPERRINTST9_Pos = 0x9
	// Bit mask of EPERRINTST9 field.
	USB_SYSERRINTST_EPERRINTST9_Msk = 0x200
	// Bit EPERRINTST9.
	USB_SYSERRINTST_EPERRINTST9 = 0x200
	// Position of EPERRINTST10 field.
	USB_SYSERRINTST_EPERRINTST10_Pos = 0xa
	// Bit mask of EPERRINTST10 field.
	USB_SYSERRINTST_EPERRINTST10_Msk = 0x400
	// Bit EPERRINTST10.
	USB_SYSERRINTST_EPERRINTST10 = 0x400
	// Position of EPERRINTST11 field.
	USB_SYSERRINTST_EPERRINTST11_Pos = 0xb
	// Bit mask of EPERRINTST11 field.
	USB_SYSERRINTST_EPERRINTST11_Msk = 0x800
	// Bit EPERRINTST11.
	USB_SYSERRINTST_EPERRINTST11 = 0x800
	// Position of EPERRINTST12 field.
	USB_SYSERRINTST_EPERRINTST12_Pos = 0xc
	// Bit mask of EPERRINTST12 field.
	USB_SYSERRINTST_EPERRINTST12_Msk = 0x1000
	// Bit EPERRINTST12.
	USB_SYSERRINTST_EPERRINTST12 = 0x1000
	// Position of EPERRINTST13 field.
	USB_SYSERRINTST_EPERRINTST13_Pos = 0xd
	// Bit mask of EPERRINTST13 field.
	USB_SYSERRINTST_EPERRINTST13_Msk = 0x2000
	// Bit EPERRINTST13.
	USB_SYSERRINTST_EPERRINTST13 = 0x2000
	// Position of EPERRINTST14 field.
	USB_SYSERRINTST_EPERRINTST14_Pos = 0xe
	// Bit mask of EPERRINTST14 field.
	USB_SYSERRINTST_EPERRINTST14_Msk = 0x4000
	// Bit EPERRINTST14.
	USB_SYSERRINTST_EPERRINTST14 = 0x4000
	// Position of EPERRINTST15 field.
	USB_SYSERRINTST_EPERRINTST15_Pos = 0xf
	// Bit mask of EPERRINTST15 field.
	USB_SYSERRINTST_EPERRINTST15_Msk = 0x8000
	// Bit EPERRINTST15.
	USB_SYSERRINTST_EPERRINTST15 = 0x8000
	// Position of EPERRINTST16 field.
	USB_SYSERRINTST_EPERRINTST16_Pos = 0x10
	// Bit mask of EPERRINTST16 field.
	USB_SYSERRINTST_EPERRINTST16_Msk = 0x10000
	// Bit EPERRINTST16.
	USB_SYSERRINTST_EPERRINTST16 = 0x10000
	// Position of EPERRINTST17 field.
	USB_SYSERRINTST_EPERRINTST17_Pos = 0x11
	// Bit mask of EPERRINTST17 field.
	USB_SYSERRINTST_EPERRINTST17_Msk = 0x20000
	// Bit EPERRINTST17.
	USB_SYSERRINTST_EPERRINTST17 = 0x20000
	// Position of EPERRINTST18 field.
	USB_SYSERRINTST_EPERRINTST18_Pos = 0x12
	// Bit mask of EPERRINTST18 field.
	USB_SYSERRINTST_EPERRINTST18_Msk = 0x40000
	// Bit EPERRINTST18.
	USB_SYSERRINTST_EPERRINTST18 = 0x40000
	// Position of EPERRINTST19 field.
	USB_SYSERRINTST_EPERRINTST19_Pos = 0x13
	// Bit mask of EPERRINTST19 field.
	USB_SYSERRINTST_EPERRINTST19_Msk = 0x80000
	// Bit EPERRINTST19.
	USB_SYSERRINTST_EPERRINTST19 = 0x80000
	// Position of EPERRINTST20 field.
	USB_SYSERRINTST_EPERRINTST20_Pos = 0x14
	// Bit mask of EPERRINTST20 field.
	USB_SYSERRINTST_EPERRINTST20_Msk = 0x100000
	// Bit EPERRINTST20.
	USB_SYSERRINTST_EPERRINTST20 = 0x100000
	// Position of EPERRINTST21 field.
	USB_SYSERRINTST_EPERRINTST21_Pos = 0x15
	// Bit mask of EPERRINTST21 field.
	USB_SYSERRINTST_EPERRINTST21_Msk = 0x200000
	// Bit EPERRINTST21.
	USB_SYSERRINTST_EPERRINTST21 = 0x200000
	// Position of EPERRINTST22 field.
	USB_SYSERRINTST_EPERRINTST22_Pos = 0x16
	// Bit mask of EPERRINTST22 field.
	USB_SYSERRINTST_EPERRINTST22_Msk = 0x400000
	// Bit EPERRINTST22.
	USB_SYSERRINTST_EPERRINTST22 = 0x400000
	// Position of EPERRINTST23 field.
	USB_SYSERRINTST_EPERRINTST23_Pos = 0x17
	// Bit mask of EPERRINTST23 field.
	USB_SYSERRINTST_EPERRINTST23_Msk = 0x800000
	// Bit EPERRINTST23.
	USB_SYSERRINTST_EPERRINTST23 = 0x800000
	// Position of EPERRINTST24 field.
	USB_SYSERRINTST_EPERRINTST24_Pos = 0x18
	// Bit mask of EPERRINTST24 field.
	USB_SYSERRINTST_EPERRINTST24_Msk = 0x1000000
	// Bit EPERRINTST24.
	USB_SYSERRINTST_EPERRINTST24 = 0x1000000
	// Position of EPERRINTST25 field.
	USB_SYSERRINTST_EPERRINTST25_Pos = 0x19
	// Bit mask of EPERRINTST25 field.
	USB_SYSERRINTST_EPERRINTST25_Msk = 0x2000000
	// Bit EPERRINTST25.
	USB_SYSERRINTST_EPERRINTST25 = 0x2000000
	// Position of EPERRINTST26 field.
	USB_SYSERRINTST_EPERRINTST26_Pos = 0x1a
	// Bit mask of EPERRINTST26 field.
	USB_SYSERRINTST_EPERRINTST26_Msk = 0x4000000
	// Bit EPERRINTST26.
	USB_SYSERRINTST_EPERRINTST26 = 0x4000000
	// Position of EPERRINTST27 field.
	USB_SYSERRINTST_EPERRINTST27_Pos = 0x1b
	// Bit mask of EPERRINTST27 field.
	USB_SYSERRINTST_EPERRINTST27_Msk = 0x8000000
	// Bit EPERRINTST27.
	USB_SYSERRINTST_EPERRINTST27 = 0x8000000
	// Position of EPERRINTST28 field.
	USB_SYSERRINTST_EPERRINTST28_Pos = 0x1c
	// Bit mask of EPERRINTST28 field.
	USB_SYSERRINTST_EPERRINTST28_Msk = 0x10000000
	// Bit EPERRINTST28.
	USB_SYSERRINTST_EPERRINTST28 = 0x10000000
	// Position of EPERRINTST29 field.
	USB_SYSERRINTST_EPERRINTST29_Pos = 0x1d
	// Bit mask of EPERRINTST29 field.
	USB_SYSERRINTST_EPERRINTST29_Msk = 0x20000000
	// Bit EPERRINTST29.
	USB_SYSERRINTST_EPERRINTST29 = 0x20000000
	// Position of EPERRINTST30 field.
	USB_SYSERRINTST_EPERRINTST30_Pos = 0x1e
	// Bit mask of EPERRINTST30 field.
	USB_SYSERRINTST_EPERRINTST30_Msk = 0x40000000
	// Bit EPERRINTST30.
	USB_SYSERRINTST_EPERRINTST30 = 0x40000000
	// Position of EPERRINTST31 field.
	USB_SYSERRINTST_EPERRINTST31_Pos = 0x1f
	// Bit mask of EPERRINTST31 field.
	USB_SYSERRINTST_EPERRINTST31_Msk = 0x80000000
	// Bit EPERRINTST31.
	USB_SYSERRINTST_EPERRINTST31 = 0x80000000

	// SYSERRINTCLR: USB System Error Interrupt Clear
	// Position of EPERRINTCLR0 field.
	USB_SYSERRINTCLR_EPERRINTCLR0_Pos = 0x0
	// Bit mask of EPERRINTCLR0 field.
	USB_SYSERRINTCLR_EPERRINTCLR0_Msk = 0x1
	// Bit EPERRINTCLR0.
	USB_SYSERRINTCLR_EPERRINTCLR0 = 0x1
	// Position of EPERRINTCLR1 field.
	USB_SYSERRINTCLR_EPERRINTCLR1_Pos = 0x1
	// Bit mask of EPERRINTCLR1 field.
	USB_SYSERRINTCLR_EPERRINTCLR1_Msk = 0x2
	// Bit EPERRINTCLR1.
	USB_SYSERRINTCLR_EPERRINTCLR1 = 0x2
	// Position of EPERRINTCLR2 field.
	USB_SYSERRINTCLR_EPERRINTCLR2_Pos = 0x2
	// Bit mask of EPERRINTCLR2 field.
	USB_SYSERRINTCLR_EPERRINTCLR2_Msk = 0x4
	// Bit EPERRINTCLR2.
	USB_SYSERRINTCLR_EPERRINTCLR2 = 0x4
	// Position of EPERRINTCLR3 field.
	USB_SYSERRINTCLR_EPERRINTCLR3_Pos = 0x3
	// Bit mask of EPERRINTCLR3 field.
	USB_SYSERRINTCLR_EPERRINTCLR3_Msk = 0x8
	// Bit EPERRINTCLR3.
	USB_SYSERRINTCLR_EPERRINTCLR3 = 0x8
	// Position of EPERRINTCLR4 field.
	USB_SYSERRINTCLR_EPERRINTCLR4_Pos = 0x4
	// Bit mask of EPERRINTCLR4 field.
	USB_SYSERRINTCLR_EPERRINTCLR4_Msk = 0x10
	// Bit EPERRINTCLR4.
	USB_SYSERRINTCLR_EPERRINTCLR4 = 0x10
	// Position of EPERRINTCLR5 field.
	USB_SYSERRINTCLR_EPERRINTCLR5_Pos = 0x5
	// Bit mask of EPERRINTCLR5 field.
	USB_SYSERRINTCLR_EPERRINTCLR5_Msk = 0x20
	// Bit EPERRINTCLR5.
	USB_SYSERRINTCLR_EPERRINTCLR5 = 0x20
	// Position of EPERRINTCLR6 field.
	USB_SYSERRINTCLR_EPERRINTCLR6_Pos = 0x6
	// Bit mask of EPERRINTCLR6 field.
	USB_SYSERRINTCLR_EPERRINTCLR6_Msk = 0x40
	// Bit EPERRINTCLR6.
	USB_SYSERRINTCLR_EPERRINTCLR6 = 0x40
	// Position of EPERRINTCLR7 field.
	USB_SYSERRINTCLR_EPERRINTCLR7_Pos = 0x7
	// Bit mask of EPERRINTCLR7 field.
	USB_SYSERRINTCLR_EPERRINTCLR7_Msk = 0x80
	// Bit EPERRINTCLR7.
	USB_SYSERRINTCLR_EPERRINTCLR7 = 0x80
	// Position of EPERRINTCLR8 field.
	USB_SYSERRINTCLR_EPERRINTCLR8_Pos = 0x8
	// Bit mask of EPERRINTCLR8 field.
	USB_SYSERRINTCLR_EPERRINTCLR8_Msk = 0x100
	// Bit EPERRINTCLR8.
	USB_SYSERRINTCLR_EPERRINTCLR8 = 0x100
	// Position of EPERRINTCLR9 field.
	USB_SYSERRINTCLR_EPERRINTCLR9_Pos = 0x9
	// Bit mask of EPERRINTCLR9 field.
	USB_SYSERRINTCLR_EPERRINTCLR9_Msk = 0x200
	// Bit EPERRINTCLR9.
	USB_SYSERRINTCLR_EPERRINTCLR9 = 0x200
	// Position of EPERRINTCLR10 field.
	USB_SYSERRINTCLR_EPERRINTCLR10_Pos = 0xa
	// Bit mask of EPERRINTCLR10 field.
	USB_SYSERRINTCLR_EPERRINTCLR10_Msk = 0x400
	// Bit EPERRINTCLR10.
	USB_SYSERRINTCLR_EPERRINTCLR10 = 0x400
	// Position of EPERRINTCLR11 field.
	USB_SYSERRINTCLR_EPERRINTCLR11_Pos = 0xb
	// Bit mask of EPERRINTCLR11 field.
	USB_SYSERRINTCLR_EPERRINTCLR11_Msk = 0x800
	// Bit EPERRINTCLR11.
	USB_SYSERRINTCLR_EPERRINTCLR11 = 0x800
	// Position of EPERRINTCLR12 field.
	USB_SYSERRINTCLR_EPERRINTCLR12_Pos = 0xc
	// Bit mask of EPERRINTCLR12 field.
	USB_SYSERRINTCLR_EPERRINTCLR12_Msk = 0x1000
	// Bit EPERRINTCLR12.
	USB_SYSERRINTCLR_EPERRINTCLR12 = 0x1000
	// Position of EPERRINTCLR13 field.
	USB_SYSERRINTCLR_EPERRINTCLR13_Pos = 0xd
	// Bit mask of EPERRINTCLR13 field.
	USB_SYSERRINTCLR_EPERRINTCLR13_Msk = 0x2000
	// Bit EPERRINTCLR13.
	USB_SYSERRINTCLR_EPERRINTCLR13 = 0x2000
	// Position of EPERRINTCLR14 field.
	USB_SYSERRINTCLR_EPERRINTCLR14_Pos = 0xe
	// Bit mask of EPERRINTCLR14 field.
	USB_SYSERRINTCLR_EPERRINTCLR14_Msk = 0x4000
	// Bit EPERRINTCLR14.
	USB_SYSERRINTCLR_EPERRINTCLR14 = 0x4000
	// Position of EPERRINTCLR15 field.
	USB_SYSERRINTCLR_EPERRINTCLR15_Pos = 0xf
	// Bit mask of EPERRINTCLR15 field.
	USB_SYSERRINTCLR_EPERRINTCLR15_Msk = 0x8000
	// Bit EPERRINTCLR15.
	USB_SYSERRINTCLR_EPERRINTCLR15 = 0x8000
	// Position of EPERRINTCLR16 field.
	USB_SYSERRINTCLR_EPERRINTCLR16_Pos = 0x10
	// Bit mask of EPERRINTCLR16 field.
	USB_SYSERRINTCLR_EPERRINTCLR16_Msk = 0x10000
	// Bit EPERRINTCLR16.
	USB_SYSERRINTCLR_EPERRINTCLR16 = 0x10000
	// Position of EPERRINTCLR17 field.
	USB_SYSERRINTCLR_EPERRINTCLR17_Pos = 0x11
	// Bit mask of EPERRINTCLR17 field.
	USB_SYSERRINTCLR_EPERRINTCLR17_Msk = 0x20000
	// Bit EPERRINTCLR17.
	USB_SYSERRINTCLR_EPERRINTCLR17 = 0x20000
	// Position of EPERRINTCLR18 field.
	USB_SYSERRINTCLR_EPERRINTCLR18_Pos = 0x12
	// Bit mask of EPERRINTCLR18 field.
	USB_SYSERRINTCLR_EPERRINTCLR18_Msk = 0x40000
	// Bit EPERRINTCLR18.
	USB_SYSERRINTCLR_EPERRINTCLR18 = 0x40000
	// Position of EPERRINTCLR19 field.
	USB_SYSERRINTCLR_EPERRINTCLR19_Pos = 0x13
	// Bit mask of EPERRINTCLR19 field.
	USB_SYSERRINTCLR_EPERRINTCLR19_Msk = 0x80000
	// Bit EPERRINTCLR19.
	USB_SYSERRINTCLR_EPERRINTCLR19 = 0x80000
	// Position of EPERRINTCLR20 field.
	USB_SYSERRINTCLR_EPERRINTCLR20_Pos = 0x14
	// Bit mask of EPERRINTCLR20 field.
	USB_SYSERRINTCLR_EPERRINTCLR20_Msk = 0x100000
	// Bit EPERRINTCLR20.
	USB_SYSERRINTCLR_EPERRINTCLR20 = 0x100000
	// Position of EPERRINTCLR21 field.
	USB_SYSERRINTCLR_EPERRINTCLR21_Pos = 0x15
	// Bit mask of EPERRINTCLR21 field.
	USB_SYSERRINTCLR_EPERRINTCLR21_Msk = 0x200000
	// Bit EPERRINTCLR21.
	USB_SYSERRINTCLR_EPERRINTCLR21 = 0x200000
	// Position of EPERRINTCLR22 field.
	USB_SYSERRINTCLR_EPERRINTCLR22_Pos = 0x16
	// Bit mask of EPERRINTCLR22 field.
	USB_SYSERRINTCLR_EPERRINTCLR22_Msk = 0x400000
	// Bit EPERRINTCLR22.
	USB_SYSERRINTCLR_EPERRINTCLR22 = 0x400000
	// Position of EPERRINTCLR23 field.
	USB_SYSERRINTCLR_EPERRINTCLR23_Pos = 0x17
	// Bit mask of EPERRINTCLR23 field.
	USB_SYSERRINTCLR_EPERRINTCLR23_Msk = 0x800000
	// Bit EPERRINTCLR23.
	USB_SYSERRINTCLR_EPERRINTCLR23 = 0x800000
	// Position of EPERRINTCLR24 field.
	USB_SYSERRINTCLR_EPERRINTCLR24_Pos = 0x18
	// Bit mask of EPERRINTCLR24 field.
	USB_SYSERRINTCLR_EPERRINTCLR24_Msk = 0x1000000
	// Bit EPERRINTCLR24.
	USB_SYSERRINTCLR_EPERRINTCLR24 = 0x1000000
	// Position of EPERRINTCLR25 field.
	USB_SYSERRINTCLR_EPERRINTCLR25_Pos = 0x19
	// Bit mask of EPERRINTCLR25 field.
	USB_SYSERRINTCLR_EPERRINTCLR25_Msk = 0x2000000
	// Bit EPERRINTCLR25.
	USB_SYSERRINTCLR_EPERRINTCLR25 = 0x2000000
	// Position of EPERRINTCLR26 field.
	USB_SYSERRINTCLR_EPERRINTCLR26_Pos = 0x1a
	// Bit mask of EPERRINTCLR26 field.
	USB_SYSERRINTCLR_EPERRINTCLR26_Msk = 0x4000000
	// Bit EPERRINTCLR26.
	USB_SYSERRINTCLR_EPERRINTCLR26 = 0x4000000
	// Position of EPERRINTCLR27 field.
	USB_SYSERRINTCLR_EPERRINTCLR27_Pos = 0x1b
	// Bit mask of EPERRINTCLR27 field.
	USB_SYSERRINTCLR_EPERRINTCLR27_Msk = 0x8000000
	// Bit EPERRINTCLR27.
	USB_SYSERRINTCLR_EPERRINTCLR27 = 0x8000000
	// Position of EPERRINTCLR28 field.
	USB_SYSERRINTCLR_EPERRINTCLR28_Pos = 0x1c
	// Bit mask of EPERRINTCLR28 field.
	USB_SYSERRINTCLR_EPERRINTCLR28_Msk = 0x10000000
	// Bit EPERRINTCLR28.
	USB_SYSERRINTCLR_EPERRINTCLR28 = 0x10000000
	// Position of EPERRINTCLR29 field.
	USB_SYSERRINTCLR_EPERRINTCLR29_Pos = 0x1d
	// Bit mask of EPERRINTCLR29 field.
	USB_SYSERRINTCLR_EPERRINTCLR29_Msk = 0x20000000
	// Bit EPERRINTCLR29.
	USB_SYSERRINTCLR_EPERRINTCLR29 = 0x20000000
	// Position of EPERRINTCLR30 field.
	USB_SYSERRINTCLR_EPERRINTCLR30_Pos = 0x1e
	// Bit mask of EPERRINTCLR30 field.
	USB_SYSERRINTCLR_EPERRINTCLR30_Msk = 0x40000000
	// Bit EPERRINTCLR30.
	USB_SYSERRINTCLR_EPERRINTCLR30 = 0x40000000
	// Position of EPERRINTCLR31 field.
	USB_SYSERRINTCLR_EPERRINTCLR31_Pos = 0x1f
	// Bit mask of EPERRINTCLR31 field.
	USB_SYSERRINTCLR_EPERRINTCLR31_Msk = 0x80000000
	// Bit EPERRINTCLR31.
	USB_SYSERRINTCLR_EPERRINTCLR31 = 0x80000000

	// SYSERRINTSET: USB System Error Interrupt Set
	// Position of EPERRINTSET0 field.
	USB_SYSERRINTSET_EPERRINTSET0_Pos = 0x0
	// Bit mask of EPERRINTSET0 field.
	USB_SYSERRINTSET_EPERRINTSET0_Msk = 0x1
	// Bit EPERRINTSET0.
	USB_SYSERRINTSET_EPERRINTSET0 = 0x1
	// Position of EPERRINTSET1 field.
	USB_SYSERRINTSET_EPERRINTSET1_Pos = 0x1
	// Bit mask of EPERRINTSET1 field.
	USB_SYSERRINTSET_EPERRINTSET1_Msk = 0x2
	// Bit EPERRINTSET1.
	USB_SYSERRINTSET_EPERRINTSET1 = 0x2
	// Position of EPERRINTSET2 field.
	USB_SYSERRINTSET_EPERRINTSET2_Pos = 0x2
	// Bit mask of EPERRINTSET2 field.
	USB_SYSERRINTSET_EPERRINTSET2_Msk = 0x4
	// Bit EPERRINTSET2.
	USB_SYSERRINTSET_EPERRINTSET2 = 0x4
	// Position of EPERRINTSET3 field.
	USB_SYSERRINTSET_EPERRINTSET3_Pos = 0x3
	// Bit mask of EPERRINTSET3 field.
	USB_SYSERRINTSET_EPERRINTSET3_Msk = 0x8
	// Bit EPERRINTSET3.
	USB_SYSERRINTSET_EPERRINTSET3 = 0x8
	// Position of EPERRINTSET4 field.
	USB_SYSERRINTSET_EPERRINTSET4_Pos = 0x4
	// Bit mask of EPERRINTSET4 field.
	USB_SYSERRINTSET_EPERRINTSET4_Msk = 0x10
	// Bit EPERRINTSET4.
	USB_SYSERRINTSET_EPERRINTSET4 = 0x10
	// Position of EPERRINTSET5 field.
	USB_SYSERRINTSET_EPERRINTSET5_Pos = 0x5
	// Bit mask of EPERRINTSET5 field.
	USB_SYSERRINTSET_EPERRINTSET5_Msk = 0x20
	// Bit EPERRINTSET5.
	USB_SYSERRINTSET_EPERRINTSET5 = 0x20
	// Position of EPERRINTSET6 field.
	USB_SYSERRINTSET_EPERRINTSET6_Pos = 0x6
	// Bit mask of EPERRINTSET6 field.
	USB_SYSERRINTSET_EPERRINTSET6_Msk = 0x40
	// Bit EPERRINTSET6.
	USB_SYSERRINTSET_EPERRINTSET6 = 0x40
	// Position of EPERRINTSET7 field.
	USB_SYSERRINTSET_EPERRINTSET7_Pos = 0x7
	// Bit mask of EPERRINTSET7 field.
	USB_SYSERRINTSET_EPERRINTSET7_Msk = 0x80
	// Bit EPERRINTSET7.
	USB_SYSERRINTSET_EPERRINTSET7 = 0x80
	// Position of EPERRINTSET8 field.
	USB_SYSERRINTSET_EPERRINTSET8_Pos = 0x8
	// Bit mask of EPERRINTSET8 field.
	USB_SYSERRINTSET_EPERRINTSET8_Msk = 0x100
	// Bit EPERRINTSET8.
	USB_SYSERRINTSET_EPERRINTSET8 = 0x100
	// Position of EPERRINTSET9 field.
	USB_SYSERRINTSET_EPERRINTSET9_Pos = 0x9
	// Bit mask of EPERRINTSET9 field.
	USB_SYSERRINTSET_EPERRINTSET9_Msk = 0x200
	// Bit EPERRINTSET9.
	USB_SYSERRINTSET_EPERRINTSET9 = 0x200
	// Position of EPERRINTSET10 field.
	USB_SYSERRINTSET_EPERRINTSET10_Pos = 0xa
	// Bit mask of EPERRINTSET10 field.
	USB_SYSERRINTSET_EPERRINTSET10_Msk = 0x400
	// Bit EPERRINTSET10.
	USB_SYSERRINTSET_EPERRINTSET10 = 0x400
	// Position of EPERRINTSET11 field.
	USB_SYSERRINTSET_EPERRINTSET11_Pos = 0xb
	// Bit mask of EPERRINTSET11 field.
	USB_SYSERRINTSET_EPERRINTSET11_Msk = 0x800
	// Bit EPERRINTSET11.
	USB_SYSERRINTSET_EPERRINTSET11 = 0x800
	// Position of EPERRINTSET12 field.
	USB_SYSERRINTSET_EPERRINTSET12_Pos = 0xc
	// Bit mask of EPERRINTSET12 field.
	USB_SYSERRINTSET_EPERRINTSET12_Msk = 0x1000
	// Bit EPERRINTSET12.
	USB_SYSERRINTSET_EPERRINTSET12 = 0x1000
	// Position of EPERRINTSET13 field.
	USB_SYSERRINTSET_EPERRINTSET13_Pos = 0xd
	// Bit mask of EPERRINTSET13 field.
	USB_SYSERRINTSET_EPERRINTSET13_Msk = 0x2000
	// Bit EPERRINTSET13.
	USB_SYSERRINTSET_EPERRINTSET13 = 0x2000
	// Position of EPERRINTSET14 field.
	USB_SYSERRINTSET_EPERRINTSET14_Pos = 0xe
	// Bit mask of EPERRINTSET14 field.
	USB_SYSERRINTSET_EPERRINTSET14_Msk = 0x4000
	// Bit EPERRINTSET14.
	USB_SYSERRINTSET_EPERRINTSET14 = 0x4000
	// Position of EPERRINTSET15 field.
	USB_SYSERRINTSET_EPERRINTSET15_Pos = 0xf
	// Bit mask of EPERRINTSET15 field.
	USB_SYSERRINTSET_EPERRINTSET15_Msk = 0x8000
	// Bit EPERRINTSET15.
	USB_SYSERRINTSET_EPERRINTSET15 = 0x8000
	// Position of EPERRINTSET16 field.
	USB_SYSERRINTSET_EPERRINTSET16_Pos = 0x10
	// Bit mask of EPERRINTSET16 field.
	USB_SYSERRINTSET_EPERRINTSET16_Msk = 0x10000
	// Bit EPERRINTSET16.
	USB_SYSERRINTSET_EPERRINTSET16 = 0x10000
	// Position of EPERRINTSET17 field.
	USB_SYSERRINTSET_EPERRINTSET17_Pos = 0x11
	// Bit mask of EPERRINTSET17 field.
	USB_SYSERRINTSET_EPERRINTSET17_Msk = 0x20000
	// Bit EPERRINTSET17.
	USB_SYSERRINTSET_EPERRINTSET17 = 0x20000
	// Position of EPERRINTSET18 field.
	USB_SYSERRINTSET_EPERRINTSET18_Pos = 0x12
	// Bit mask of EPERRINTSET18 field.
	USB_SYSERRINTSET_EPERRINTSET18_Msk = 0x40000
	// Bit EPERRINTSET18.
	USB_SYSERRINTSET_EPERRINTSET18 = 0x40000
	// Position of EPERRINTSET19 field.
	USB_SYSERRINTSET_EPERRINTSET19_Pos = 0x13
	// Bit mask of EPERRINTSET19 field.
	USB_SYSERRINTSET_EPERRINTSET19_Msk = 0x80000
	// Bit EPERRINTSET19.
	USB_SYSERRINTSET_EPERRINTSET19 = 0x80000
	// Position of EPERRINTSET20 field.
	USB_SYSERRINTSET_EPERRINTSET20_Pos = 0x14
	// Bit mask of EPERRINTSET20 field.
	USB_SYSERRINTSET_EPERRINTSET20_Msk = 0x100000
	// Bit EPERRINTSET20.
	USB_SYSERRINTSET_EPERRINTSET20 = 0x100000
	// Position of EPERRINTSET21 field.
	USB_SYSERRINTSET_EPERRINTSET21_Pos = 0x15
	// Bit mask of EPERRINTSET21 field.
	USB_SYSERRINTSET_EPERRINTSET21_Msk = 0x200000
	// Bit EPERRINTSET21.
	USB_SYSERRINTSET_EPERRINTSET21 = 0x200000
	// Position of EPERRINTSET22 field.
	USB_SYSERRINTSET_EPERRINTSET22_Pos = 0x16
	// Bit mask of EPERRINTSET22 field.
	USB_SYSERRINTSET_EPERRINTSET22_Msk = 0x400000
	// Bit EPERRINTSET22.
	USB_SYSERRINTSET_EPERRINTSET22 = 0x400000
	// Position of EPERRINTSET23 field.
	USB_SYSERRINTSET_EPERRINTSET23_Pos = 0x17
	// Bit mask of EPERRINTSET23 field.
	USB_SYSERRINTSET_EPERRINTSET23_Msk = 0x800000
	// Bit EPERRINTSET23.
	USB_SYSERRINTSET_EPERRINTSET23 = 0x800000
	// Position of EPERRINTSET24 field.
	USB_SYSERRINTSET_EPERRINTSET24_Pos = 0x18
	// Bit mask of EPERRINTSET24 field.
	USB_SYSERRINTSET_EPERRINTSET24_Msk = 0x1000000
	// Bit EPERRINTSET24.
	USB_SYSERRINTSET_EPERRINTSET24 = 0x1000000
	// Position of EPERRINTSET25 field.
	USB_SYSERRINTSET_EPERRINTSET25_Pos = 0x19
	// Bit mask of EPERRINTSET25 field.
	USB_SYSERRINTSET_EPERRINTSET25_Msk = 0x2000000
	// Bit EPERRINTSET25.
	USB_SYSERRINTSET_EPERRINTSET25 = 0x2000000
	// Position of EPERRINTSET26 field.
	USB_SYSERRINTSET_EPERRINTSET26_Pos = 0x1a
	// Bit mask of EPERRINTSET26 field.
	USB_SYSERRINTSET_EPERRINTSET26_Msk = 0x4000000
	// Bit EPERRINTSET26.
	USB_SYSERRINTSET_EPERRINTSET26 = 0x4000000
	// Position of EPERRINTSET27 field.
	USB_SYSERRINTSET_EPERRINTSET27_Pos = 0x1b
	// Bit mask of EPERRINTSET27 field.
	USB_SYSERRINTSET_EPERRINTSET27_Msk = 0x8000000
	// Bit EPERRINTSET27.
	USB_SYSERRINTSET_EPERRINTSET27 = 0x8000000
	// Position of EPERRINTSET28 field.
	USB_SYSERRINTSET_EPERRINTSET28_Pos = 0x1c
	// Bit mask of EPERRINTSET28 field.
	USB_SYSERRINTSET_EPERRINTSET28_Msk = 0x10000000
	// Bit EPERRINTSET28.
	USB_SYSERRINTSET_EPERRINTSET28 = 0x10000000
	// Position of EPERRINTSET29 field.
	USB_SYSERRINTSET_EPERRINTSET29_Pos = 0x1d
	// Bit mask of EPERRINTSET29 field.
	USB_SYSERRINTSET_EPERRINTSET29_Msk = 0x20000000
	// Bit EPERRINTSET29.
	USB_SYSERRINTSET_EPERRINTSET29 = 0x20000000
	// Position of EPERRINTSET30 field.
	USB_SYSERRINTSET_EPERRINTSET30_Pos = 0x1e
	// Bit mask of EPERRINTSET30 field.
	USB_SYSERRINTSET_EPERRINTSET30_Msk = 0x40000000
	// Bit EPERRINTSET30.
	USB_SYSERRINTSET_EPERRINTSET30 = 0x40000000
	// Position of EPERRINTSET31 field.
	USB_SYSERRINTSET_EPERRINTSET31_Pos = 0x1f
	// Bit mask of EPERRINTSET31 field.
	USB_SYSERRINTSET_EPERRINTSET31_Msk = 0x80000000
	// Bit EPERRINTSET31.
	USB_SYSERRINTSET_EPERRINTSET31 = 0x80000000

	// I2C_RX: I2C Receive
	// Position of RXDATA field.
	USB_I2C_RX_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	USB_I2C_RX_RXDATA_Msk = 0xff

	// I2C_WO: I2C Transmit
	// Position of TXDATA field.
	USB_I2C_WO_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	USB_I2C_WO_TXDATA_Msk = 0xff
	// Position of START field.
	USB_I2C_WO_START_Pos = 0x8
	// Bit mask of START field.
	USB_I2C_WO_START_Msk = 0x100
	// Bit START.
	USB_I2C_WO_START = 0x100
	// Position of STOP field.
	USB_I2C_WO_STOP_Pos = 0x9
	// Bit mask of STOP field.
	USB_I2C_WO_STOP_Msk = 0x200
	// Bit STOP.
	USB_I2C_WO_STOP = 0x200
	// Position of RESERVED field.
	USB_I2C_WO_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USB_I2C_WO_RESERVED_Msk = 0xfffffc00

	// I2C_STS: I2C Status
	// Position of TDI field.
	USB_I2C_STS_TDI_Pos = 0x0
	// Bit mask of TDI field.
	USB_I2C_STS_TDI_Msk = 0x1
	// Bit TDI.
	USB_I2C_STS_TDI = 0x1
	// Transaction has not completed.
	USB_I2C_STS_TDI_NOT_COMPLETE = 0x0
	// Transaction completed.
	USB_I2C_STS_TDI_COMPLETE = 0x1
	// Position of AFI field.
	USB_I2C_STS_AFI_Pos = 0x1
	// Bit mask of AFI field.
	USB_I2C_STS_AFI_Msk = 0x2
	// Bit AFI.
	USB_I2C_STS_AFI = 0x2
	// No arbitration failure on last transmission.
	USB_I2C_STS_AFI_NO_ARBITRATION_FAILU = 0x0
	// Arbitration failure occurred on last transmission.
	USB_I2C_STS_AFI_ARBITRATION_FAILURE_ = 0x1
	// Position of NAI field.
	USB_I2C_STS_NAI_Pos = 0x2
	// Bit mask of NAI field.
	USB_I2C_STS_NAI_Msk = 0x4
	// Bit NAI.
	USB_I2C_STS_NAI = 0x4
	// Last transmission received an acknowledge.
	USB_I2C_STS_NAI_ACKNOWLEDGE_RCVD = 0x0
	// Last transmission did not receive an acknowledge.
	USB_I2C_STS_NAI_NO_ACKNOWLEDGE_RCVD = 0x1
	// Position of DRMI field.
	USB_I2C_STS_DRMI_Pos = 0x3
	// Bit mask of DRMI field.
	USB_I2C_STS_DRMI_Msk = 0x8
	// Bit DRMI.
	USB_I2C_STS_DRMI = 0x8
	// Master transmitter does not need data.
	USB_I2C_STS_DRMI_BUSY = 0x0
	// Master transmitter needs data.
	USB_I2C_STS_DRMI_NEED_DATA = 0x1
	// Position of DRSI field.
	USB_I2C_STS_DRSI_Pos = 0x4
	// Bit mask of DRSI field.
	USB_I2C_STS_DRSI_Msk = 0x10
	// Bit DRSI.
	USB_I2C_STS_DRSI = 0x10
	// Slave transmitter does not need data.
	USB_I2C_STS_DRSI_BUSY = 0x0
	// Slave transmitter needs data.
	USB_I2C_STS_DRSI_NEED_DATA = 0x1
	// Position of Active field.
	USB_I2C_STS_Active_Pos = 0x5
	// Bit mask of Active field.
	USB_I2C_STS_Active_Msk = 0x20
	// Bit Active.
	USB_I2C_STS_Active = 0x20
	// Position of SCL field.
	USB_I2C_STS_SCL_Pos = 0x6
	// Bit mask of SCL field.
	USB_I2C_STS_SCL_Msk = 0x40
	// Bit SCL.
	USB_I2C_STS_SCL = 0x40
	// Position of SDA field.
	USB_I2C_STS_SDA_Pos = 0x7
	// Bit mask of SDA field.
	USB_I2C_STS_SDA_Msk = 0x80
	// Bit SDA.
	USB_I2C_STS_SDA = 0x80
	// Position of RFF field.
	USB_I2C_STS_RFF_Pos = 0x8
	// Bit mask of RFF field.
	USB_I2C_STS_RFF_Msk = 0x100
	// Bit RFF.
	USB_I2C_STS_RFF = 0x100
	// RX FIFO is not full
	USB_I2C_STS_RFF_RX_FIFO_IS_NOT_FULL = 0x0
	// RX FIFO is full
	USB_I2C_STS_RFF_RX_FIFO_IS_FULL = 0x1
	// Position of RFE field.
	USB_I2C_STS_RFE_Pos = 0x9
	// Bit mask of RFE field.
	USB_I2C_STS_RFE_Msk = 0x200
	// Bit RFE.
	USB_I2C_STS_RFE = 0x200
	// RX FIFO contains data.
	USB_I2C_STS_RFE_DATA = 0x0
	// RX FIFO is empty
	USB_I2C_STS_RFE_EMPTY = 0x1
	// Position of TFF field.
	USB_I2C_STS_TFF_Pos = 0xa
	// Bit mask of TFF field.
	USB_I2C_STS_TFF_Msk = 0x400
	// Bit TFF.
	USB_I2C_STS_TFF = 0x400
	// TX FIFO is not full.
	USB_I2C_STS_TFF_TX_FIFO_IS_NOT_FULL_ = 0x0
	// TX FIFO is full
	USB_I2C_STS_TFF_TX_FIFO_IS_FULL = 0x1
	// Position of TFE field.
	USB_I2C_STS_TFE_Pos = 0xb
	// Bit mask of TFE field.
	USB_I2C_STS_TFE_Msk = 0x800
	// Bit TFE.
	USB_I2C_STS_TFE = 0x800
	// TX FIFO contains valid data.
	USB_I2C_STS_TFE_VALID_DATA = 0x0
	// TX FIFO is empty
	USB_I2C_STS_TFE_EMPTY = 0x1
	// Position of RESERVED field.
	USB_I2C_STS_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	USB_I2C_STS_RESERVED_Msk = 0xfffff000

	// I2C_CTL: I2C Control
	// Position of TDIE field.
	USB_I2C_CTL_TDIE_Pos = 0x0
	// Bit mask of TDIE field.
	USB_I2C_CTL_TDIE_Msk = 0x1
	// Bit TDIE.
	USB_I2C_CTL_TDIE = 0x1
	// Disable the TDI interrupt.
	USB_I2C_CTL_TDIE_DISABLE_THE_TDI_INTE = 0x0
	// Enable the TDI interrupt.
	USB_I2C_CTL_TDIE_ENABLE_THE_TDI_INTER = 0x1
	// Position of AFIE field.
	USB_I2C_CTL_AFIE_Pos = 0x1
	// Bit mask of AFIE field.
	USB_I2C_CTL_AFIE_Msk = 0x2
	// Bit AFIE.
	USB_I2C_CTL_AFIE = 0x2
	// Disable the AFI.
	USB_I2C_CTL_AFIE_DISABLE_THE_AFI_ = 0x0
	// Enable the AFI.
	USB_I2C_CTL_AFIE_ENABLE_THE_AFI_ = 0x1
	// Position of NAIE field.
	USB_I2C_CTL_NAIE_Pos = 0x2
	// Bit mask of NAIE field.
	USB_I2C_CTL_NAIE_Msk = 0x4
	// Bit NAIE.
	USB_I2C_CTL_NAIE = 0x4
	// Disable the NAI.
	USB_I2C_CTL_NAIE_DISABLE_THE_NAI_ = 0x0
	// Enable the NAI.
	USB_I2C_CTL_NAIE_ENABLE_THE_NAI_ = 0x1
	// Position of DRMIE field.
	USB_I2C_CTL_DRMIE_Pos = 0x3
	// Bit mask of DRMIE field.
	USB_I2C_CTL_DRMIE_Msk = 0x8
	// Bit DRMIE.
	USB_I2C_CTL_DRMIE = 0x8
	// Disable the DRMI interrupt.
	USB_I2C_CTL_DRMIE_DISABLE_THE_DRMI_INT = 0x0
	// Enable the DRMI interrupt.
	USB_I2C_CTL_DRMIE_ENABLE_THE_DRMI_INTE = 0x1
	// Position of DRSIE field.
	USB_I2C_CTL_DRSIE_Pos = 0x4
	// Bit mask of DRSIE field.
	USB_I2C_CTL_DRSIE_Msk = 0x10
	// Bit DRSIE.
	USB_I2C_CTL_DRSIE = 0x10
	// Disable the DRSI interrupt.
	USB_I2C_CTL_DRSIE_DISABLE_THE_DRSI_INT = 0x0
	// Enable the DRSI interrupt.
	USB_I2C_CTL_DRSIE_ENABLE_THE_DRSI_INTE = 0x1
	// Position of REFIE field.
	USB_I2C_CTL_REFIE_Pos = 0x5
	// Bit mask of REFIE field.
	USB_I2C_CTL_REFIE_Msk = 0x20
	// Bit REFIE.
	USB_I2C_CTL_REFIE = 0x20
	// Disable the RFFI.
	USB_I2C_CTL_REFIE_DISABLE_THE_RFFI_ = 0x0
	// Enable the RFFI.
	USB_I2C_CTL_REFIE_ENABLE_THE_RFFI_ = 0x1
	// Position of RFDAIE field.
	USB_I2C_CTL_RFDAIE_Pos = 0x6
	// Bit mask of RFDAIE field.
	USB_I2C_CTL_RFDAIE_Msk = 0x40
	// Bit RFDAIE.
	USB_I2C_CTL_RFDAIE = 0x40
	// Disable the DAI.
	USB_I2C_CTL_RFDAIE_DISABLE_THE_DAI_ = 0x0
	// Enable the DAI.
	USB_I2C_CTL_RFDAIE_ENABLE_THE_DAI_ = 0x1
	// Position of TFFIE field.
	USB_I2C_CTL_TFFIE_Pos = 0x7
	// Bit mask of TFFIE field.
	USB_I2C_CTL_TFFIE_Msk = 0x80
	// Bit TFFIE.
	USB_I2C_CTL_TFFIE = 0x80
	// Disable the TFFI.
	USB_I2C_CTL_TFFIE_DISABLE_THE_TFFI_ = 0x0
	// Enable the TFFI.
	USB_I2C_CTL_TFFIE_ENABLE_THE_TFFI_ = 0x1
	// Position of SRST field.
	USB_I2C_CTL_SRST_Pos = 0x8
	// Bit mask of SRST field.
	USB_I2C_CTL_SRST_Msk = 0x100
	// Bit SRST.
	USB_I2C_CTL_SRST = 0x100
	// No reset.
	USB_I2C_CTL_SRST_NO_RESET = 0x0
	// Reset the I2C to idle state. Self clearing.
	USB_I2C_CTL_SRST_RESET = 0x1
	// Position of RESERVED field.
	USB_I2C_CTL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USB_I2C_CTL_RESERVED_Msk = 0xfffffe00

	// I2C_CLKHI: I2C Clock High
	// Position of CDHI field.
	USB_I2C_CLKHI_CDHI_Pos = 0x0
	// Bit mask of CDHI field.
	USB_I2C_CLKHI_CDHI_Msk = 0xff
	// Position of RESERVED field.
	USB_I2C_CLKHI_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB_I2C_CLKHI_RESERVED_Msk = 0xffffff00

	// I2C_CLKLO: I2C Clock Low
	// Position of CDLO field.
	USB_I2C_CLKLO_CDLO_Pos = 0x0
	// Bit mask of CDLO field.
	USB_I2C_CLKLO_CDLO_Msk = 0xff
	// Position of RESERVED field.
	USB_I2C_CLKLO_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USB_I2C_CLKLO_RESERVED_Msk = 0xffffff00

	// USBCLKCTRL: USB Clock Control
	// Position of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USB_USBCLKCTRL_RESERVED = 0x1
	// Position of DEV_CLK_EN field.
	USB_USBCLKCTRL_DEV_CLK_EN_Pos = 0x1
	// Bit mask of DEV_CLK_EN field.
	USB_USBCLKCTRL_DEV_CLK_EN_Msk = 0x2
	// Bit DEV_CLK_EN.
	USB_USBCLKCTRL_DEV_CLK_EN = 0x2
	// Position of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Msk = 0x4
	// Bit RESERVED.
	USB_USBCLKCTRL_RESERVED = 0x4
	// Position of PORTSEL_CLK_EN field.
	USB_USBCLKCTRL_PORTSEL_CLK_EN_Pos = 0x3
	// Bit mask of PORTSEL_CLK_EN field.
	USB_USBCLKCTRL_PORTSEL_CLK_EN_Msk = 0x8
	// Bit PORTSEL_CLK_EN.
	USB_USBCLKCTRL_PORTSEL_CLK_EN = 0x8
	// Position of AHB_CLK_EN field.
	USB_USBCLKCTRL_AHB_CLK_EN_Pos = 0x4
	// Bit mask of AHB_CLK_EN field.
	USB_USBCLKCTRL_AHB_CLK_EN_Msk = 0x10
	// Bit AHB_CLK_EN.
	USB_USBCLKCTRL_AHB_CLK_EN = 0x10
	// Position of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Msk = 0xffffffe0

	// OTGCLKCTRL: OTG clock controller
	// Position of HOST_CLK_EN field.
	USB_OTGCLKCTRL_HOST_CLK_EN_Pos = 0x0
	// Bit mask of HOST_CLK_EN field.
	USB_OTGCLKCTRL_HOST_CLK_EN_Msk = 0x1
	// Bit HOST_CLK_EN.
	USB_OTGCLKCTRL_HOST_CLK_EN = 0x1
	// Disable the Host clock.
	USB_OTGCLKCTRL_HOST_CLK_EN_DISABLE_THE_HOST_CLO = 0x0
	// Enable the Host clock.
	USB_OTGCLKCTRL_HOST_CLK_EN_ENABLE_THE_HOST_CLOC = 0x1
	// Position of DEV_CLK_EN field.
	USB_OTGCLKCTRL_DEV_CLK_EN_Pos = 0x1
	// Bit mask of DEV_CLK_EN field.
	USB_OTGCLKCTRL_DEV_CLK_EN_Msk = 0x2
	// Bit DEV_CLK_EN.
	USB_OTGCLKCTRL_DEV_CLK_EN = 0x2
	// Disable the Device clock.
	USB_OTGCLKCTRL_DEV_CLK_EN_DISABLE_THE_DEVICE_C = 0x0
	// Enable the Device clock.
	USB_OTGCLKCTRL_DEV_CLK_EN_ENABLE_THE_DEVICE_CL = 0x1
	// Position of I2C_CLK_EN field.
	USB_OTGCLKCTRL_I2C_CLK_EN_Pos = 0x2
	// Bit mask of I2C_CLK_EN field.
	USB_OTGCLKCTRL_I2C_CLK_EN_Msk = 0x4
	// Bit I2C_CLK_EN.
	USB_OTGCLKCTRL_I2C_CLK_EN = 0x4
	// Disable the I2C clock.
	USB_OTGCLKCTRL_I2C_CLK_EN_DISABLE_THE_I2C_CLOC = 0x0
	// Enable the I2C clock.
	USB_OTGCLKCTRL_I2C_CLK_EN_ENABLE_THE_I2C_CLOCK = 0x1
	// Position of OTG_CLK_EN field.
	USB_OTGCLKCTRL_OTG_CLK_EN_Pos = 0x3
	// Bit mask of OTG_CLK_EN field.
	USB_OTGCLKCTRL_OTG_CLK_EN_Msk = 0x8
	// Bit OTG_CLK_EN.
	USB_OTGCLKCTRL_OTG_CLK_EN = 0x8
	// Disable the OTG clock.
	USB_OTGCLKCTRL_OTG_CLK_EN_DISABLE_THE_OTG_CLOC = 0x0
	// Enable the OTG clock.
	USB_OTGCLKCTRL_OTG_CLK_EN_ENABLE_THE_OTG_CLOCK = 0x1
	// Position of AHB_CLK_EN field.
	USB_OTGCLKCTRL_AHB_CLK_EN_Pos = 0x4
	// Bit mask of AHB_CLK_EN field.
	USB_OTGCLKCTRL_AHB_CLK_EN_Msk = 0x10
	// Bit AHB_CLK_EN.
	USB_OTGCLKCTRL_AHB_CLK_EN = 0x10
	// Disable the AHB clock.
	USB_OTGCLKCTRL_AHB_CLK_EN_DISABLE_THE_AHB_CLOC = 0x0
	// Enable the AHB clock.
	USB_OTGCLKCTRL_AHB_CLK_EN_ENABLE_THE_AHB_CLOCK = 0x1
	// Position of RESERVED field.
	USB_OTGCLKCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB_OTGCLKCTRL_RESERVED_Msk = 0xffffffe0

	// USBCLKST: USB Clock Status
	// Position of RESERVED field.
	USB_USBCLKST_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USB_USBCLKST_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USB_USBCLKST_RESERVED = 0x1
	// Position of DEV_CLK_ON field.
	USB_USBCLKST_DEV_CLK_ON_Pos = 0x1
	// Bit mask of DEV_CLK_ON field.
	USB_USBCLKST_DEV_CLK_ON_Msk = 0x2
	// Bit DEV_CLK_ON.
	USB_USBCLKST_DEV_CLK_ON = 0x2
	// Position of RESERVED field.
	USB_USBCLKST_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	USB_USBCLKST_RESERVED_Msk = 0x4
	// Bit RESERVED.
	USB_USBCLKST_RESERVED = 0x4
	// Position of PORTSEL_CLK_ON field.
	USB_USBCLKST_PORTSEL_CLK_ON_Pos = 0x3
	// Bit mask of PORTSEL_CLK_ON field.
	USB_USBCLKST_PORTSEL_CLK_ON_Msk = 0x8
	// Bit PORTSEL_CLK_ON.
	USB_USBCLKST_PORTSEL_CLK_ON = 0x8
	// Position of AHB_CLK_ON field.
	USB_USBCLKST_AHB_CLK_ON_Pos = 0x4
	// Bit mask of AHB_CLK_ON field.
	USB_USBCLKST_AHB_CLK_ON_Msk = 0x10
	// Bit AHB_CLK_ON.
	USB_USBCLKST_AHB_CLK_ON = 0x10
	// Position of RESERVED field.
	USB_USBCLKST_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB_USBCLKST_RESERVED_Msk = 0xffffffe0

	// OTGCLKST: OTG clock status
	// Position of HOST_CLK_ON field.
	USB_OTGCLKST_HOST_CLK_ON_Pos = 0x0
	// Bit mask of HOST_CLK_ON field.
	USB_OTGCLKST_HOST_CLK_ON_Msk = 0x1
	// Bit HOST_CLK_ON.
	USB_OTGCLKST_HOST_CLK_ON = 0x1
	// Host clock is not available.
	USB_OTGCLKST_HOST_CLK_ON_HOST_CLOCK_IS_NOT_AV = 0x0
	// Host clock is available.
	USB_OTGCLKST_HOST_CLK_ON_HOST_CLOCK_IS_AVAILA = 0x1
	// Position of DEV_CLK_ON field.
	USB_OTGCLKST_DEV_CLK_ON_Pos = 0x1
	// Bit mask of DEV_CLK_ON field.
	USB_OTGCLKST_DEV_CLK_ON_Msk = 0x2
	// Bit DEV_CLK_ON.
	USB_OTGCLKST_DEV_CLK_ON = 0x2
	// Device clock is not available.
	USB_OTGCLKST_DEV_CLK_ON_DEVICE_CLOCK_IS_NOT_ = 0x0
	// Device clock is available.
	USB_OTGCLKST_DEV_CLK_ON_DEVICE_CLOCK_IS_AVAI = 0x1
	// Position of I2C_CLK_ON field.
	USB_OTGCLKST_I2C_CLK_ON_Pos = 0x2
	// Bit mask of I2C_CLK_ON field.
	USB_OTGCLKST_I2C_CLK_ON_Msk = 0x4
	// Bit I2C_CLK_ON.
	USB_OTGCLKST_I2C_CLK_ON = 0x4
	// I2C clock is not available.
	USB_OTGCLKST_I2C_CLK_ON_I2C_CLOCK_IS_NOT_AVA = 0x0
	// I2C clock is available.
	USB_OTGCLKST_I2C_CLK_ON_I2C_CLOCK_IS_AVAILAB = 0x1
	// Position of OTG_CLK_ON field.
	USB_OTGCLKST_OTG_CLK_ON_Pos = 0x3
	// Bit mask of OTG_CLK_ON field.
	USB_OTGCLKST_OTG_CLK_ON_Msk = 0x8
	// Bit OTG_CLK_ON.
	USB_OTGCLKST_OTG_CLK_ON = 0x8
	// OTG clock is not available.
	USB_OTGCLKST_OTG_CLK_ON_OTG_CLOCK_IS_NOT_AVA = 0x0
	// OTG clock is available.
	USB_OTGCLKST_OTG_CLK_ON_OTG_CLOCK_IS_AVAILAB = 0x1
	// Position of AHB_CLK_ON field.
	USB_OTGCLKST_AHB_CLK_ON_Pos = 0x4
	// Bit mask of AHB_CLK_ON field.
	USB_OTGCLKST_AHB_CLK_ON_Msk = 0x10
	// Bit AHB_CLK_ON.
	USB_OTGCLKST_AHB_CLK_ON = 0x10
	// AHB clock is not available.
	USB_OTGCLKST_AHB_CLK_ON_AHB_CLOCK_IS_NOT_AVA = 0x0
	// AHB clock is available.
	USB_OTGCLKST_AHB_CLK_ON_AHB_CLOCK_IS_AVAILAB = 0x1
	// Position of RESERVED field.
	USB_OTGCLKST_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	USB_OTGCLKST_RESERVED_Msk = 0xffffffe0
)

// Bitfields for CRC: CRC engine
const (
	// MODE: CRC mode register
	// Position of CRC_POLY field.
	CRC_MODE_CRC_POLY_Pos = 0x0
	// Bit mask of CRC_POLY field.
	CRC_MODE_CRC_POLY_Msk = 0x3
	// CRC-CCITT polynomial
	CRC_MODE_CRC_POLY_CRC_CCITT_POLYNOMIAL = 0x0
	// CRC-16 polynomial
	CRC_MODE_CRC_POLY_CRC_16_POLYNOMIAL = 0x1
	// CRC-32 polynomial
	CRC_MODE_CRC_POLY_CRC_32_POLYNOMIAL = 0x2
	// Position of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Pos = 0x2
	// Bit mask of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Msk = 0x4
	// Bit BIT_RVS_WR.
	CRC_MODE_BIT_RVS_WR = 0x4
	// No bit order reverse for CRC_WR_DATA (per byte)
	CRC_MODE_BIT_RVS_WR_NO_BIT_ORDER_REVERSE = 0x0
	// Bit order reverse for CRC_WR_DATA (per byte)
	CRC_MODE_BIT_RVS_WR_BIT_ORDER_REVERSE_FO = 0x1
	// Position of CMPL_WR field.
	CRC_MODE_CMPL_WR_Pos = 0x3
	// Bit mask of CMPL_WR field.
	CRC_MODE_CMPL_WR_Msk = 0x8
	// Bit CMPL_WR.
	CRC_MODE_CMPL_WR = 0x8
	// No one's complement for CRC_WR_DATA
	CRC_MODE_CMPL_WR_NO_ONES_COMPLEMENT_ = 0x0
	// One's complement for CRC_WR_DATA
	CRC_MODE_CMPL_WR_ONES_COMPLEMENT_FOR = 0x1
	// Position of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Pos = 0x4
	// Bit mask of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Msk = 0x10
	// Bit BIT_RVS_SUM.
	CRC_MODE_BIT_RVS_SUM = 0x10
	// No bit order reverse for CRC_SUM
	CRC_MODE_BIT_RVS_SUM_NO_BIT_ORDER_REVERSE = 0x0
	// Bit order reverse for CRC_SUM
	CRC_MODE_BIT_RVS_SUM_BIT_ORDER_REVERSE_FO = 0x1
	// Position of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Pos = 0x5
	// Bit mask of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Msk = 0x20
	// Bit CMPL_SUM.
	CRC_MODE_CMPL_SUM = 0x20
	// No one's complement for CRC_SUM
	CRC_MODE_CMPL_SUM_NO_ONES_COMPLEMENT_ = 0x0
	// One's complement for CRC_SUM
	CRC_MODE_CMPL_SUM_ONES_COMPLEMENT_FOR = 0x1
	// Position of Reserved field.
	CRC_MODE_Reserved_Pos = 0x6
	// Bit mask of Reserved field.
	CRC_MODE_Reserved_Msk = 0xffffffc0

	// SEED: CRC seed register
	// Position of CRC_SEED field.
	CRC_SEED_CRC_SEED_Pos = 0x0
	// Bit mask of CRC_SEED field.
	CRC_SEED_CRC_SEED_Msk = 0xffffffff

	// SUM: CRC checksum register
	// Position of CRC_SUM field.
	CRC_SUM_CRC_SUM_Pos = 0x0
	// Bit mask of CRC_SUM field.
	CRC_SUM_CRC_SUM_Msk = 0xffffffff

	// DATA: CRC data register
	// Position of CRC_WR_DATA field.
	CRC_DATA_CRC_WR_DATA_Pos = 0x0
	// Bit mask of CRC_WR_DATA field.
	CRC_DATA_CRC_WR_DATA_Msk = 0xffffffff
)

// Bitfields for GPIO: General Purpose I/O
const (
	// DIR0: GPIO Port0 Direction control register.
	// Position of PINDIR0 field.
	GPIO_DIR_PINDIR0_Pos = 0x0
	// Bit mask of PINDIR0 field.
	GPIO_DIR_PINDIR0_Msk = 0x1
	// Bit PINDIR0.
	GPIO_DIR_PINDIR0 = 0x1
	// Position of PINDIR1 field.
	GPIO_DIR_PINDIR1_Pos = 0x1
	// Bit mask of PINDIR1 field.
	GPIO_DIR_PINDIR1_Msk = 0x2
	// Bit PINDIR1.
	GPIO_DIR_PINDIR1 = 0x2
	// Position of PINDIR2 field.
	GPIO_DIR_PINDIR2_Pos = 0x2
	// Bit mask of PINDIR2 field.
	GPIO_DIR_PINDIR2_Msk = 0x4
	// Bit PINDIR2.
	GPIO_DIR_PINDIR2 = 0x4
	// Position of PINDIR3 field.
	GPIO_DIR_PINDIR3_Pos = 0x3
	// Bit mask of PINDIR3 field.
	GPIO_DIR_PINDIR3_Msk = 0x8
	// Bit PINDIR3.
	GPIO_DIR_PINDIR3 = 0x8
	// Position of PINDIR4 field.
	GPIO_DIR_PINDIR4_Pos = 0x4
	// Bit mask of PINDIR4 field.
	GPIO_DIR_PINDIR4_Msk = 0x10
	// Bit PINDIR4.
	GPIO_DIR_PINDIR4 = 0x10
	// Position of PINDIR5 field.
	GPIO_DIR_PINDIR5_Pos = 0x5
	// Bit mask of PINDIR5 field.
	GPIO_DIR_PINDIR5_Msk = 0x20
	// Bit PINDIR5.
	GPIO_DIR_PINDIR5 = 0x20
	// Position of PINDIR6 field.
	GPIO_DIR_PINDIR6_Pos = 0x6
	// Bit mask of PINDIR6 field.
	GPIO_DIR_PINDIR6_Msk = 0x40
	// Bit PINDIR6.
	GPIO_DIR_PINDIR6 = 0x40
	// Position of PINDIR7 field.
	GPIO_DIR_PINDIR7_Pos = 0x7
	// Bit mask of PINDIR7 field.
	GPIO_DIR_PINDIR7_Msk = 0x80
	// Bit PINDIR7.
	GPIO_DIR_PINDIR7 = 0x80
	// Position of PINDIR8 field.
	GPIO_DIR_PINDIR8_Pos = 0x8
	// Bit mask of PINDIR8 field.
	GPIO_DIR_PINDIR8_Msk = 0x100
	// Bit PINDIR8.
	GPIO_DIR_PINDIR8 = 0x100
	// Position of PINDIR9 field.
	GPIO_DIR_PINDIR9_Pos = 0x9
	// Bit mask of PINDIR9 field.
	GPIO_DIR_PINDIR9_Msk = 0x200
	// Bit PINDIR9.
	GPIO_DIR_PINDIR9 = 0x200
	// Position of PINDIR10 field.
	GPIO_DIR_PINDIR10_Pos = 0xa
	// Bit mask of PINDIR10 field.
	GPIO_DIR_PINDIR10_Msk = 0x400
	// Bit PINDIR10.
	GPIO_DIR_PINDIR10 = 0x400
	// Position of PINDIR11 field.
	GPIO_DIR_PINDIR11_Pos = 0xb
	// Bit mask of PINDIR11 field.
	GPIO_DIR_PINDIR11_Msk = 0x800
	// Bit PINDIR11.
	GPIO_DIR_PINDIR11 = 0x800
	// Position of PINDIR12 field.
	GPIO_DIR_PINDIR12_Pos = 0xc
	// Bit mask of PINDIR12 field.
	GPIO_DIR_PINDIR12_Msk = 0x1000
	// Bit PINDIR12.
	GPIO_DIR_PINDIR12 = 0x1000
	// Position of PINDIR13 field.
	GPIO_DIR_PINDIR13_Pos = 0xd
	// Bit mask of PINDIR13 field.
	GPIO_DIR_PINDIR13_Msk = 0x2000
	// Bit PINDIR13.
	GPIO_DIR_PINDIR13 = 0x2000
	// Position of PINDIR14 field.
	GPIO_DIR_PINDIR14_Pos = 0xe
	// Bit mask of PINDIR14 field.
	GPIO_DIR_PINDIR14_Msk = 0x4000
	// Bit PINDIR14.
	GPIO_DIR_PINDIR14 = 0x4000
	// Position of PINDIR15 field.
	GPIO_DIR_PINDIR15_Pos = 0xf
	// Bit mask of PINDIR15 field.
	GPIO_DIR_PINDIR15_Msk = 0x8000
	// Bit PINDIR15.
	GPIO_DIR_PINDIR15 = 0x8000
	// Position of PINDIR16 field.
	GPIO_DIR_PINDIR16_Pos = 0x10
	// Bit mask of PINDIR16 field.
	GPIO_DIR_PINDIR16_Msk = 0x10000
	// Bit PINDIR16.
	GPIO_DIR_PINDIR16 = 0x10000
	// Position of PINDIR17 field.
	GPIO_DIR_PINDIR17_Pos = 0x11
	// Bit mask of PINDIR17 field.
	GPIO_DIR_PINDIR17_Msk = 0x20000
	// Bit PINDIR17.
	GPIO_DIR_PINDIR17 = 0x20000
	// Position of PINDIR18 field.
	GPIO_DIR_PINDIR18_Pos = 0x12
	// Bit mask of PINDIR18 field.
	GPIO_DIR_PINDIR18_Msk = 0x40000
	// Bit PINDIR18.
	GPIO_DIR_PINDIR18 = 0x40000
	// Position of PINDIR19 field.
	GPIO_DIR_PINDIR19_Pos = 0x13
	// Bit mask of PINDIR19 field.
	GPIO_DIR_PINDIR19_Msk = 0x80000
	// Bit PINDIR19.
	GPIO_DIR_PINDIR19 = 0x80000
	// Position of PINDIR20 field.
	GPIO_DIR_PINDIR20_Pos = 0x14
	// Bit mask of PINDIR20 field.
	GPIO_DIR_PINDIR20_Msk = 0x100000
	// Bit PINDIR20.
	GPIO_DIR_PINDIR20 = 0x100000
	// Position of PINDIR21 field.
	GPIO_DIR_PINDIR21_Pos = 0x15
	// Bit mask of PINDIR21 field.
	GPIO_DIR_PINDIR21_Msk = 0x200000
	// Bit PINDIR21.
	GPIO_DIR_PINDIR21 = 0x200000
	// Position of PINDIR22 field.
	GPIO_DIR_PINDIR22_Pos = 0x16
	// Bit mask of PINDIR22 field.
	GPIO_DIR_PINDIR22_Msk = 0x400000
	// Bit PINDIR22.
	GPIO_DIR_PINDIR22 = 0x400000
	// Position of PINDIR23 field.
	GPIO_DIR_PINDIR23_Pos = 0x17
	// Bit mask of PINDIR23 field.
	GPIO_DIR_PINDIR23_Msk = 0x800000
	// Bit PINDIR23.
	GPIO_DIR_PINDIR23 = 0x800000
	// Position of PINDIR24 field.
	GPIO_DIR_PINDIR24_Pos = 0x18
	// Bit mask of PINDIR24 field.
	GPIO_DIR_PINDIR24_Msk = 0x1000000
	// Bit PINDIR24.
	GPIO_DIR_PINDIR24 = 0x1000000
	// Position of PINDIR25 field.
	GPIO_DIR_PINDIR25_Pos = 0x19
	// Bit mask of PINDIR25 field.
	GPIO_DIR_PINDIR25_Msk = 0x2000000
	// Bit PINDIR25.
	GPIO_DIR_PINDIR25 = 0x2000000
	// Position of PINDIR26 field.
	GPIO_DIR_PINDIR26_Pos = 0x1a
	// Bit mask of PINDIR26 field.
	GPIO_DIR_PINDIR26_Msk = 0x4000000
	// Bit PINDIR26.
	GPIO_DIR_PINDIR26 = 0x4000000
	// Position of PINDIR27 field.
	GPIO_DIR_PINDIR27_Pos = 0x1b
	// Bit mask of PINDIR27 field.
	GPIO_DIR_PINDIR27_Msk = 0x8000000
	// Bit PINDIR27.
	GPIO_DIR_PINDIR27 = 0x8000000
	// Position of PINDIR28 field.
	GPIO_DIR_PINDIR28_Pos = 0x1c
	// Bit mask of PINDIR28 field.
	GPIO_DIR_PINDIR28_Msk = 0x10000000
	// Bit PINDIR28.
	GPIO_DIR_PINDIR28 = 0x10000000
	// Position of PINDIR29 field.
	GPIO_DIR_PINDIR29_Pos = 0x1d
	// Bit mask of PINDIR29 field.
	GPIO_DIR_PINDIR29_Msk = 0x20000000
	// Bit PINDIR29.
	GPIO_DIR_PINDIR29 = 0x20000000
	// Position of PINDIR30 field.
	GPIO_DIR_PINDIR30_Pos = 0x1e
	// Bit mask of PINDIR30 field.
	GPIO_DIR_PINDIR30_Msk = 0x40000000
	// Bit PINDIR30.
	GPIO_DIR_PINDIR30 = 0x40000000
	// Position of PINDIR31 field.
	GPIO_DIR_PINDIR31_Pos = 0x1f
	// Bit mask of PINDIR31 field.
	GPIO_DIR_PINDIR31_Msk = 0x80000000
	// Bit PINDIR31.
	GPIO_DIR_PINDIR31 = 0x80000000

	// MASK0: Mask register for Port0.
	// Position of PINMASK0 field.
	GPIO_MASK_PINMASK0_Pos = 0x0
	// Bit mask of PINMASK0 field.
	GPIO_MASK_PINMASK0_Msk = 0x1
	// Bit PINMASK0.
	GPIO_MASK_PINMASK0 = 0x1
	// Position of PINMASK1 field.
	GPIO_MASK_PINMASK1_Pos = 0x1
	// Bit mask of PINMASK1 field.
	GPIO_MASK_PINMASK1_Msk = 0x2
	// Bit PINMASK1.
	GPIO_MASK_PINMASK1 = 0x2
	// Position of PINMASK2 field.
	GPIO_MASK_PINMASK2_Pos = 0x2
	// Bit mask of PINMASK2 field.
	GPIO_MASK_PINMASK2_Msk = 0x4
	// Bit PINMASK2.
	GPIO_MASK_PINMASK2 = 0x4
	// Position of PINMASK3 field.
	GPIO_MASK_PINMASK3_Pos = 0x3
	// Bit mask of PINMASK3 field.
	GPIO_MASK_PINMASK3_Msk = 0x8
	// Bit PINMASK3.
	GPIO_MASK_PINMASK3 = 0x8
	// Position of PINMASK4 field.
	GPIO_MASK_PINMASK4_Pos = 0x4
	// Bit mask of PINMASK4 field.
	GPIO_MASK_PINMASK4_Msk = 0x10
	// Bit PINMASK4.
	GPIO_MASK_PINMASK4 = 0x10
	// Position of PINMASK5 field.
	GPIO_MASK_PINMASK5_Pos = 0x5
	// Bit mask of PINMASK5 field.
	GPIO_MASK_PINMASK5_Msk = 0x20
	// Bit PINMASK5.
	GPIO_MASK_PINMASK5 = 0x20
	// Position of PINMASK6 field.
	GPIO_MASK_PINMASK6_Pos = 0x6
	// Bit mask of PINMASK6 field.
	GPIO_MASK_PINMASK6_Msk = 0x40
	// Bit PINMASK6.
	GPIO_MASK_PINMASK6 = 0x40
	// Position of PINMASK7 field.
	GPIO_MASK_PINMASK7_Pos = 0x7
	// Bit mask of PINMASK7 field.
	GPIO_MASK_PINMASK7_Msk = 0x80
	// Bit PINMASK7.
	GPIO_MASK_PINMASK7 = 0x80
	// Position of PINMASK8 field.
	GPIO_MASK_PINMASK8_Pos = 0x8
	// Bit mask of PINMASK8 field.
	GPIO_MASK_PINMASK8_Msk = 0x100
	// Bit PINMASK8.
	GPIO_MASK_PINMASK8 = 0x100
	// Position of PINMASK9 field.
	GPIO_MASK_PINMASK9_Pos = 0x9
	// Bit mask of PINMASK9 field.
	GPIO_MASK_PINMASK9_Msk = 0x200
	// Bit PINMASK9.
	GPIO_MASK_PINMASK9 = 0x200
	// Position of PINMASK10 field.
	GPIO_MASK_PINMASK10_Pos = 0xa
	// Bit mask of PINMASK10 field.
	GPIO_MASK_PINMASK10_Msk = 0x400
	// Bit PINMASK10.
	GPIO_MASK_PINMASK10 = 0x400
	// Position of PINMASK11 field.
	GPIO_MASK_PINMASK11_Pos = 0xb
	// Bit mask of PINMASK11 field.
	GPIO_MASK_PINMASK11_Msk = 0x800
	// Bit PINMASK11.
	GPIO_MASK_PINMASK11 = 0x800
	// Position of PINMASK12 field.
	GPIO_MASK_PINMASK12_Pos = 0xc
	// Bit mask of PINMASK12 field.
	GPIO_MASK_PINMASK12_Msk = 0x1000
	// Bit PINMASK12.
	GPIO_MASK_PINMASK12 = 0x1000
	// Position of PINMASK13 field.
	GPIO_MASK_PINMASK13_Pos = 0xd
	// Bit mask of PINMASK13 field.
	GPIO_MASK_PINMASK13_Msk = 0x2000
	// Bit PINMASK13.
	GPIO_MASK_PINMASK13 = 0x2000
	// Position of PINMASK14 field.
	GPIO_MASK_PINMASK14_Pos = 0xe
	// Bit mask of PINMASK14 field.
	GPIO_MASK_PINMASK14_Msk = 0x4000
	// Bit PINMASK14.
	GPIO_MASK_PINMASK14 = 0x4000
	// Position of PINMASK15 field.
	GPIO_MASK_PINMASK15_Pos = 0xf
	// Bit mask of PINMASK15 field.
	GPIO_MASK_PINMASK15_Msk = 0x8000
	// Bit PINMASK15.
	GPIO_MASK_PINMASK15 = 0x8000
	// Position of PINMASK16 field.
	GPIO_MASK_PINMASK16_Pos = 0x10
	// Bit mask of PINMASK16 field.
	GPIO_MASK_PINMASK16_Msk = 0x10000
	// Bit PINMASK16.
	GPIO_MASK_PINMASK16 = 0x10000
	// Position of PINMASK17 field.
	GPIO_MASK_PINMASK17_Pos = 0x11
	// Bit mask of PINMASK17 field.
	GPIO_MASK_PINMASK17_Msk = 0x20000
	// Bit PINMASK17.
	GPIO_MASK_PINMASK17 = 0x20000
	// Position of PINMASK18 field.
	GPIO_MASK_PINMASK18_Pos = 0x12
	// Bit mask of PINMASK18 field.
	GPIO_MASK_PINMASK18_Msk = 0x40000
	// Bit PINMASK18.
	GPIO_MASK_PINMASK18 = 0x40000
	// Position of PINMASK19 field.
	GPIO_MASK_PINMASK19_Pos = 0x13
	// Bit mask of PINMASK19 field.
	GPIO_MASK_PINMASK19_Msk = 0x80000
	// Bit PINMASK19.
	GPIO_MASK_PINMASK19 = 0x80000
	// Position of PINMASK20 field.
	GPIO_MASK_PINMASK20_Pos = 0x14
	// Bit mask of PINMASK20 field.
	GPIO_MASK_PINMASK20_Msk = 0x100000
	// Bit PINMASK20.
	GPIO_MASK_PINMASK20 = 0x100000
	// Position of PINMASK21 field.
	GPIO_MASK_PINMASK21_Pos = 0x15
	// Bit mask of PINMASK21 field.
	GPIO_MASK_PINMASK21_Msk = 0x200000
	// Bit PINMASK21.
	GPIO_MASK_PINMASK21 = 0x200000
	// Position of PINMASK22 field.
	GPIO_MASK_PINMASK22_Pos = 0x16
	// Bit mask of PINMASK22 field.
	GPIO_MASK_PINMASK22_Msk = 0x400000
	// Bit PINMASK22.
	GPIO_MASK_PINMASK22 = 0x400000
	// Position of PINMASK23 field.
	GPIO_MASK_PINMASK23_Pos = 0x17
	// Bit mask of PINMASK23 field.
	GPIO_MASK_PINMASK23_Msk = 0x800000
	// Bit PINMASK23.
	GPIO_MASK_PINMASK23 = 0x800000
	// Position of PINMASK24 field.
	GPIO_MASK_PINMASK24_Pos = 0x18
	// Bit mask of PINMASK24 field.
	GPIO_MASK_PINMASK24_Msk = 0x1000000
	// Bit PINMASK24.
	GPIO_MASK_PINMASK24 = 0x1000000
	// Position of PINMASK25 field.
	GPIO_MASK_PINMASK25_Pos = 0x19
	// Bit mask of PINMASK25 field.
	GPIO_MASK_PINMASK25_Msk = 0x2000000
	// Bit PINMASK25.
	GPIO_MASK_PINMASK25 = 0x2000000
	// Position of PINMASK26 field.
	GPIO_MASK_PINMASK26_Pos = 0x1a
	// Bit mask of PINMASK26 field.
	GPIO_MASK_PINMASK26_Msk = 0x4000000
	// Bit PINMASK26.
	GPIO_MASK_PINMASK26 = 0x4000000
	// Position of PINMASK27 field.
	GPIO_MASK_PINMASK27_Pos = 0x1b
	// Bit mask of PINMASK27 field.
	GPIO_MASK_PINMASK27_Msk = 0x8000000
	// Bit PINMASK27.
	GPIO_MASK_PINMASK27 = 0x8000000
	// Position of PINMASK28 field.
	GPIO_MASK_PINMASK28_Pos = 0x1c
	// Bit mask of PINMASK28 field.
	GPIO_MASK_PINMASK28_Msk = 0x10000000
	// Bit PINMASK28.
	GPIO_MASK_PINMASK28 = 0x10000000
	// Position of PINMASK29 field.
	GPIO_MASK_PINMASK29_Pos = 0x1d
	// Bit mask of PINMASK29 field.
	GPIO_MASK_PINMASK29_Msk = 0x20000000
	// Bit PINMASK29.
	GPIO_MASK_PINMASK29 = 0x20000000
	// Position of PINMASK30 field.
	GPIO_MASK_PINMASK30_Pos = 0x1e
	// Bit mask of PINMASK30 field.
	GPIO_MASK_PINMASK30_Msk = 0x40000000
	// Bit PINMASK30.
	GPIO_MASK_PINMASK30 = 0x40000000
	// Position of PINMASK31 field.
	GPIO_MASK_PINMASK31_Pos = 0x1f
	// Bit mask of PINMASK31 field.
	GPIO_MASK_PINMASK31_Msk = 0x80000000
	// Bit PINMASK31.
	GPIO_MASK_PINMASK31 = 0x80000000

	// PIN0: Port0 Pin value register using FIOMASK.
	// Position of PINVAL0 field.
	GPIO_PIN_PINVAL0_Pos = 0x0
	// Bit mask of PINVAL0 field.
	GPIO_PIN_PINVAL0_Msk = 0x1
	// Bit PINVAL0.
	GPIO_PIN_PINVAL0 = 0x1
	// Position of PINVAL1 field.
	GPIO_PIN_PINVAL1_Pos = 0x1
	// Bit mask of PINVAL1 field.
	GPIO_PIN_PINVAL1_Msk = 0x2
	// Bit PINVAL1.
	GPIO_PIN_PINVAL1 = 0x2
	// Position of PINVAL2 field.
	GPIO_PIN_PINVAL2_Pos = 0x2
	// Bit mask of PINVAL2 field.
	GPIO_PIN_PINVAL2_Msk = 0x4
	// Bit PINVAL2.
	GPIO_PIN_PINVAL2 = 0x4
	// Position of PINVAL3 field.
	GPIO_PIN_PINVAL3_Pos = 0x3
	// Bit mask of PINVAL3 field.
	GPIO_PIN_PINVAL3_Msk = 0x8
	// Bit PINVAL3.
	GPIO_PIN_PINVAL3 = 0x8
	// Position of PINVAL4 field.
	GPIO_PIN_PINVAL4_Pos = 0x4
	// Bit mask of PINVAL4 field.
	GPIO_PIN_PINVAL4_Msk = 0x10
	// Bit PINVAL4.
	GPIO_PIN_PINVAL4 = 0x10
	// Position of PINVAL5 field.
	GPIO_PIN_PINVAL5_Pos = 0x5
	// Bit mask of PINVAL5 field.
	GPIO_PIN_PINVAL5_Msk = 0x20
	// Bit PINVAL5.
	GPIO_PIN_PINVAL5 = 0x20
	// Position of PINVAL6 field.
	GPIO_PIN_PINVAL6_Pos = 0x6
	// Bit mask of PINVAL6 field.
	GPIO_PIN_PINVAL6_Msk = 0x40
	// Bit PINVAL6.
	GPIO_PIN_PINVAL6 = 0x40
	// Position of PINVAL7 field.
	GPIO_PIN_PINVAL7_Pos = 0x7
	// Bit mask of PINVAL7 field.
	GPIO_PIN_PINVAL7_Msk = 0x80
	// Bit PINVAL7.
	GPIO_PIN_PINVAL7 = 0x80
	// Position of PINVAL8 field.
	GPIO_PIN_PINVAL8_Pos = 0x8
	// Bit mask of PINVAL8 field.
	GPIO_PIN_PINVAL8_Msk = 0x100
	// Bit PINVAL8.
	GPIO_PIN_PINVAL8 = 0x100
	// Position of PINVAL9 field.
	GPIO_PIN_PINVAL9_Pos = 0x9
	// Bit mask of PINVAL9 field.
	GPIO_PIN_PINVAL9_Msk = 0x200
	// Bit PINVAL9.
	GPIO_PIN_PINVAL9 = 0x200
	// Position of PINVAL10 field.
	GPIO_PIN_PINVAL10_Pos = 0xa
	// Bit mask of PINVAL10 field.
	GPIO_PIN_PINVAL10_Msk = 0x400
	// Bit PINVAL10.
	GPIO_PIN_PINVAL10 = 0x400
	// Position of PINVAL11 field.
	GPIO_PIN_PINVAL11_Pos = 0xb
	// Bit mask of PINVAL11 field.
	GPIO_PIN_PINVAL11_Msk = 0x800
	// Bit PINVAL11.
	GPIO_PIN_PINVAL11 = 0x800
	// Position of PINVAL12 field.
	GPIO_PIN_PINVAL12_Pos = 0xc
	// Bit mask of PINVAL12 field.
	GPIO_PIN_PINVAL12_Msk = 0x1000
	// Bit PINVAL12.
	GPIO_PIN_PINVAL12 = 0x1000
	// Position of PINVAL13 field.
	GPIO_PIN_PINVAL13_Pos = 0xd
	// Bit mask of PINVAL13 field.
	GPIO_PIN_PINVAL13_Msk = 0x2000
	// Bit PINVAL13.
	GPIO_PIN_PINVAL13 = 0x2000
	// Position of PINVAL14 field.
	GPIO_PIN_PINVAL14_Pos = 0xe
	// Bit mask of PINVAL14 field.
	GPIO_PIN_PINVAL14_Msk = 0x4000
	// Bit PINVAL14.
	GPIO_PIN_PINVAL14 = 0x4000
	// Position of PINVAL15 field.
	GPIO_PIN_PINVAL15_Pos = 0xf
	// Bit mask of PINVAL15 field.
	GPIO_PIN_PINVAL15_Msk = 0x8000
	// Bit PINVAL15.
	GPIO_PIN_PINVAL15 = 0x8000
	// Position of PINVAL16 field.
	GPIO_PIN_PINVAL16_Pos = 0x10
	// Bit mask of PINVAL16 field.
	GPIO_PIN_PINVAL16_Msk = 0x10000
	// Bit PINVAL16.
	GPIO_PIN_PINVAL16 = 0x10000
	// Position of PINVAL17 field.
	GPIO_PIN_PINVAL17_Pos = 0x11
	// Bit mask of PINVAL17 field.
	GPIO_PIN_PINVAL17_Msk = 0x20000
	// Bit PINVAL17.
	GPIO_PIN_PINVAL17 = 0x20000
	// Position of PINVAL18 field.
	GPIO_PIN_PINVAL18_Pos = 0x12
	// Bit mask of PINVAL18 field.
	GPIO_PIN_PINVAL18_Msk = 0x40000
	// Bit PINVAL18.
	GPIO_PIN_PINVAL18 = 0x40000
	// Position of PINVAL19 field.
	GPIO_PIN_PINVAL19_Pos = 0x13
	// Bit mask of PINVAL19 field.
	GPIO_PIN_PINVAL19_Msk = 0x80000
	// Bit PINVAL19.
	GPIO_PIN_PINVAL19 = 0x80000
	// Position of PINVAL20 field.
	GPIO_PIN_PINVAL20_Pos = 0x14
	// Bit mask of PINVAL20 field.
	GPIO_PIN_PINVAL20_Msk = 0x100000
	// Bit PINVAL20.
	GPIO_PIN_PINVAL20 = 0x100000
	// Position of PINVAL21 field.
	GPIO_PIN_PINVAL21_Pos = 0x15
	// Bit mask of PINVAL21 field.
	GPIO_PIN_PINVAL21_Msk = 0x200000
	// Bit PINVAL21.
	GPIO_PIN_PINVAL21 = 0x200000
	// Position of PINVAL22 field.
	GPIO_PIN_PINVAL22_Pos = 0x16
	// Bit mask of PINVAL22 field.
	GPIO_PIN_PINVAL22_Msk = 0x400000
	// Bit PINVAL22.
	GPIO_PIN_PINVAL22 = 0x400000
	// Position of PINVAL23 field.
	GPIO_PIN_PINVAL23_Pos = 0x17
	// Bit mask of PINVAL23 field.
	GPIO_PIN_PINVAL23_Msk = 0x800000
	// Bit PINVAL23.
	GPIO_PIN_PINVAL23 = 0x800000
	// Position of PINVAL24 field.
	GPIO_PIN_PINVAL24_Pos = 0x18
	// Bit mask of PINVAL24 field.
	GPIO_PIN_PINVAL24_Msk = 0x1000000
	// Bit PINVAL24.
	GPIO_PIN_PINVAL24 = 0x1000000
	// Position of PINVAL25 field.
	GPIO_PIN_PINVAL25_Pos = 0x19
	// Bit mask of PINVAL25 field.
	GPIO_PIN_PINVAL25_Msk = 0x2000000
	// Bit PINVAL25.
	GPIO_PIN_PINVAL25 = 0x2000000
	// Position of PINVAL26 field.
	GPIO_PIN_PINVAL26_Pos = 0x1a
	// Bit mask of PINVAL26 field.
	GPIO_PIN_PINVAL26_Msk = 0x4000000
	// Bit PINVAL26.
	GPIO_PIN_PINVAL26 = 0x4000000
	// Position of PINVAL27 field.
	GPIO_PIN_PINVAL27_Pos = 0x1b
	// Bit mask of PINVAL27 field.
	GPIO_PIN_PINVAL27_Msk = 0x8000000
	// Bit PINVAL27.
	GPIO_PIN_PINVAL27 = 0x8000000
	// Position of PINVAL28 field.
	GPIO_PIN_PINVAL28_Pos = 0x1c
	// Bit mask of PINVAL28 field.
	GPIO_PIN_PINVAL28_Msk = 0x10000000
	// Bit PINVAL28.
	GPIO_PIN_PINVAL28 = 0x10000000
	// Position of PINVAL29 field.
	GPIO_PIN_PINVAL29_Pos = 0x1d
	// Bit mask of PINVAL29 field.
	GPIO_PIN_PINVAL29_Msk = 0x20000000
	// Bit PINVAL29.
	GPIO_PIN_PINVAL29 = 0x20000000
	// Position of PINVAL30 field.
	GPIO_PIN_PINVAL30_Pos = 0x1e
	// Bit mask of PINVAL30 field.
	GPIO_PIN_PINVAL30_Msk = 0x40000000
	// Bit PINVAL30.
	GPIO_PIN_PINVAL30 = 0x40000000
	// Position of PINVAL31 field.
	GPIO_PIN_PINVAL31_Pos = 0x1f
	// Bit mask of PINVAL31 field.
	GPIO_PIN_PINVAL31_Msk = 0x80000000
	// Bit PINVAL31.
	GPIO_PIN_PINVAL31 = 0x80000000

	// SET0: Port0 Output Set register using FIOMASK.
	// Position of PINSET0 field.
	GPIO_SET_PINSET0_Pos = 0x0
	// Bit mask of PINSET0 field.
	GPIO_SET_PINSET0_Msk = 0x1
	// Bit PINSET0.
	GPIO_SET_PINSET0 = 0x1
	// Position of PINSET1 field.
	GPIO_SET_PINSET1_Pos = 0x1
	// Bit mask of PINSET1 field.
	GPIO_SET_PINSET1_Msk = 0x2
	// Bit PINSET1.
	GPIO_SET_PINSET1 = 0x2
	// Position of PINSET2 field.
	GPIO_SET_PINSET2_Pos = 0x2
	// Bit mask of PINSET2 field.
	GPIO_SET_PINSET2_Msk = 0x4
	// Bit PINSET2.
	GPIO_SET_PINSET2 = 0x4
	// Position of PINSET3 field.
	GPIO_SET_PINSET3_Pos = 0x3
	// Bit mask of PINSET3 field.
	GPIO_SET_PINSET3_Msk = 0x8
	// Bit PINSET3.
	GPIO_SET_PINSET3 = 0x8
	// Position of PINSET4 field.
	GPIO_SET_PINSET4_Pos = 0x4
	// Bit mask of PINSET4 field.
	GPIO_SET_PINSET4_Msk = 0x10
	// Bit PINSET4.
	GPIO_SET_PINSET4 = 0x10
	// Position of PINSET5 field.
	GPIO_SET_PINSET5_Pos = 0x5
	// Bit mask of PINSET5 field.
	GPIO_SET_PINSET5_Msk = 0x20
	// Bit PINSET5.
	GPIO_SET_PINSET5 = 0x20
	// Position of PINSET6 field.
	GPIO_SET_PINSET6_Pos = 0x6
	// Bit mask of PINSET6 field.
	GPIO_SET_PINSET6_Msk = 0x40
	// Bit PINSET6.
	GPIO_SET_PINSET6 = 0x40
	// Position of PINSET7 field.
	GPIO_SET_PINSET7_Pos = 0x7
	// Bit mask of PINSET7 field.
	GPIO_SET_PINSET7_Msk = 0x80
	// Bit PINSET7.
	GPIO_SET_PINSET7 = 0x80
	// Position of PINSET8 field.
	GPIO_SET_PINSET8_Pos = 0x8
	// Bit mask of PINSET8 field.
	GPIO_SET_PINSET8_Msk = 0x100
	// Bit PINSET8.
	GPIO_SET_PINSET8 = 0x100
	// Position of PINSET9 field.
	GPIO_SET_PINSET9_Pos = 0x9
	// Bit mask of PINSET9 field.
	GPIO_SET_PINSET9_Msk = 0x200
	// Bit PINSET9.
	GPIO_SET_PINSET9 = 0x200
	// Position of PINSET10 field.
	GPIO_SET_PINSET10_Pos = 0xa
	// Bit mask of PINSET10 field.
	GPIO_SET_PINSET10_Msk = 0x400
	// Bit PINSET10.
	GPIO_SET_PINSET10 = 0x400
	// Position of PINSET11 field.
	GPIO_SET_PINSET11_Pos = 0xb
	// Bit mask of PINSET11 field.
	GPIO_SET_PINSET11_Msk = 0x800
	// Bit PINSET11.
	GPIO_SET_PINSET11 = 0x800
	// Position of PINSET12 field.
	GPIO_SET_PINSET12_Pos = 0xc
	// Bit mask of PINSET12 field.
	GPIO_SET_PINSET12_Msk = 0x1000
	// Bit PINSET12.
	GPIO_SET_PINSET12 = 0x1000
	// Position of PINSET13 field.
	GPIO_SET_PINSET13_Pos = 0xd
	// Bit mask of PINSET13 field.
	GPIO_SET_PINSET13_Msk = 0x2000
	// Bit PINSET13.
	GPIO_SET_PINSET13 = 0x2000
	// Position of PINSET14 field.
	GPIO_SET_PINSET14_Pos = 0xe
	// Bit mask of PINSET14 field.
	GPIO_SET_PINSET14_Msk = 0x4000
	// Bit PINSET14.
	GPIO_SET_PINSET14 = 0x4000
	// Position of PINSET15 field.
	GPIO_SET_PINSET15_Pos = 0xf
	// Bit mask of PINSET15 field.
	GPIO_SET_PINSET15_Msk = 0x8000
	// Bit PINSET15.
	GPIO_SET_PINSET15 = 0x8000
	// Position of PINSET16 field.
	GPIO_SET_PINSET16_Pos = 0x10
	// Bit mask of PINSET16 field.
	GPIO_SET_PINSET16_Msk = 0x10000
	// Bit PINSET16.
	GPIO_SET_PINSET16 = 0x10000
	// Position of PINSET17 field.
	GPIO_SET_PINSET17_Pos = 0x11
	// Bit mask of PINSET17 field.
	GPIO_SET_PINSET17_Msk = 0x20000
	// Bit PINSET17.
	GPIO_SET_PINSET17 = 0x20000
	// Position of PINSET18 field.
	GPIO_SET_PINSET18_Pos = 0x12
	// Bit mask of PINSET18 field.
	GPIO_SET_PINSET18_Msk = 0x40000
	// Bit PINSET18.
	GPIO_SET_PINSET18 = 0x40000
	// Position of PINSET19 field.
	GPIO_SET_PINSET19_Pos = 0x13
	// Bit mask of PINSET19 field.
	GPIO_SET_PINSET19_Msk = 0x80000
	// Bit PINSET19.
	GPIO_SET_PINSET19 = 0x80000
	// Position of PINSET20 field.
	GPIO_SET_PINSET20_Pos = 0x14
	// Bit mask of PINSET20 field.
	GPIO_SET_PINSET20_Msk = 0x100000
	// Bit PINSET20.
	GPIO_SET_PINSET20 = 0x100000
	// Position of PINSET21 field.
	GPIO_SET_PINSET21_Pos = 0x15
	// Bit mask of PINSET21 field.
	GPIO_SET_PINSET21_Msk = 0x200000
	// Bit PINSET21.
	GPIO_SET_PINSET21 = 0x200000
	// Position of PINSET22 field.
	GPIO_SET_PINSET22_Pos = 0x16
	// Bit mask of PINSET22 field.
	GPIO_SET_PINSET22_Msk = 0x400000
	// Bit PINSET22.
	GPIO_SET_PINSET22 = 0x400000
	// Position of PINSET23 field.
	GPIO_SET_PINSET23_Pos = 0x17
	// Bit mask of PINSET23 field.
	GPIO_SET_PINSET23_Msk = 0x800000
	// Bit PINSET23.
	GPIO_SET_PINSET23 = 0x800000
	// Position of PINSET24 field.
	GPIO_SET_PINSET24_Pos = 0x18
	// Bit mask of PINSET24 field.
	GPIO_SET_PINSET24_Msk = 0x1000000
	// Bit PINSET24.
	GPIO_SET_PINSET24 = 0x1000000
	// Position of PINSET25 field.
	GPIO_SET_PINSET25_Pos = 0x19
	// Bit mask of PINSET25 field.
	GPIO_SET_PINSET25_Msk = 0x2000000
	// Bit PINSET25.
	GPIO_SET_PINSET25 = 0x2000000
	// Position of PINSET26 field.
	GPIO_SET_PINSET26_Pos = 0x1a
	// Bit mask of PINSET26 field.
	GPIO_SET_PINSET26_Msk = 0x4000000
	// Bit PINSET26.
	GPIO_SET_PINSET26 = 0x4000000
	// Position of PINSET27 field.
	GPIO_SET_PINSET27_Pos = 0x1b
	// Bit mask of PINSET27 field.
	GPIO_SET_PINSET27_Msk = 0x8000000
	// Bit PINSET27.
	GPIO_SET_PINSET27 = 0x8000000
	// Position of PINSET28 field.
	GPIO_SET_PINSET28_Pos = 0x1c
	// Bit mask of PINSET28 field.
	GPIO_SET_PINSET28_Msk = 0x10000000
	// Bit PINSET28.
	GPIO_SET_PINSET28 = 0x10000000
	// Position of PINSET29 field.
	GPIO_SET_PINSET29_Pos = 0x1d
	// Bit mask of PINSET29 field.
	GPIO_SET_PINSET29_Msk = 0x20000000
	// Bit PINSET29.
	GPIO_SET_PINSET29 = 0x20000000
	// Position of PINSET30 field.
	GPIO_SET_PINSET30_Pos = 0x1e
	// Bit mask of PINSET30 field.
	GPIO_SET_PINSET30_Msk = 0x40000000
	// Bit PINSET30.
	GPIO_SET_PINSET30 = 0x40000000
	// Position of PINSET31 field.
	GPIO_SET_PINSET31_Pos = 0x1f
	// Bit mask of PINSET31 field.
	GPIO_SET_PINSET31_Msk = 0x80000000
	// Bit PINSET31.
	GPIO_SET_PINSET31 = 0x80000000

	// CLR0: Port0 Output Clear register using FIOMASK.
	// Position of PINCLR0 field.
	GPIO_CLR_PINCLR0_Pos = 0x0
	// Bit mask of PINCLR0 field.
	GPIO_CLR_PINCLR0_Msk = 0x1
	// Bit PINCLR0.
	GPIO_CLR_PINCLR0 = 0x1
	// Position of PINCLR1 field.
	GPIO_CLR_PINCLR1_Pos = 0x1
	// Bit mask of PINCLR1 field.
	GPIO_CLR_PINCLR1_Msk = 0x2
	// Bit PINCLR1.
	GPIO_CLR_PINCLR1 = 0x2
	// Position of PINCLR2 field.
	GPIO_CLR_PINCLR2_Pos = 0x2
	// Bit mask of PINCLR2 field.
	GPIO_CLR_PINCLR2_Msk = 0x4
	// Bit PINCLR2.
	GPIO_CLR_PINCLR2 = 0x4
	// Position of PINCLR3 field.
	GPIO_CLR_PINCLR3_Pos = 0x3
	// Bit mask of PINCLR3 field.
	GPIO_CLR_PINCLR3_Msk = 0x8
	// Bit PINCLR3.
	GPIO_CLR_PINCLR3 = 0x8
	// Position of PINCLR4 field.
	GPIO_CLR_PINCLR4_Pos = 0x4
	// Bit mask of PINCLR4 field.
	GPIO_CLR_PINCLR4_Msk = 0x10
	// Bit PINCLR4.
	GPIO_CLR_PINCLR4 = 0x10
	// Position of PINCLR5 field.
	GPIO_CLR_PINCLR5_Pos = 0x5
	// Bit mask of PINCLR5 field.
	GPIO_CLR_PINCLR5_Msk = 0x20
	// Bit PINCLR5.
	GPIO_CLR_PINCLR5 = 0x20
	// Position of PINCLR6 field.
	GPIO_CLR_PINCLR6_Pos = 0x6
	// Bit mask of PINCLR6 field.
	GPIO_CLR_PINCLR6_Msk = 0x40
	// Bit PINCLR6.
	GPIO_CLR_PINCLR6 = 0x40
	// Position of PINCLR7 field.
	GPIO_CLR_PINCLR7_Pos = 0x7
	// Bit mask of PINCLR7 field.
	GPIO_CLR_PINCLR7_Msk = 0x80
	// Bit PINCLR7.
	GPIO_CLR_PINCLR7 = 0x80
	// Position of PINCLR8 field.
	GPIO_CLR_PINCLR8_Pos = 0x8
	// Bit mask of PINCLR8 field.
	GPIO_CLR_PINCLR8_Msk = 0x100
	// Bit PINCLR8.
	GPIO_CLR_PINCLR8 = 0x100
	// Position of PINCLR9 field.
	GPIO_CLR_PINCLR9_Pos = 0x9
	// Bit mask of PINCLR9 field.
	GPIO_CLR_PINCLR9_Msk = 0x200
	// Bit PINCLR9.
	GPIO_CLR_PINCLR9 = 0x200
	// Position of PINCLR10 field.
	GPIO_CLR_PINCLR10_Pos = 0xa
	// Bit mask of PINCLR10 field.
	GPIO_CLR_PINCLR10_Msk = 0x400
	// Bit PINCLR10.
	GPIO_CLR_PINCLR10 = 0x400
	// Position of PINCLR11 field.
	GPIO_CLR_PINCLR11_Pos = 0xb
	// Bit mask of PINCLR11 field.
	GPIO_CLR_PINCLR11_Msk = 0x800
	// Bit PINCLR11.
	GPIO_CLR_PINCLR11 = 0x800
	// Position of PINCLR12 field.
	GPIO_CLR_PINCLR12_Pos = 0xc
	// Bit mask of PINCLR12 field.
	GPIO_CLR_PINCLR12_Msk = 0x1000
	// Bit PINCLR12.
	GPIO_CLR_PINCLR12 = 0x1000
	// Position of PINCLR13 field.
	GPIO_CLR_PINCLR13_Pos = 0xd
	// Bit mask of PINCLR13 field.
	GPIO_CLR_PINCLR13_Msk = 0x2000
	// Bit PINCLR13.
	GPIO_CLR_PINCLR13 = 0x2000
	// Position of PINCLR14 field.
	GPIO_CLR_PINCLR14_Pos = 0xe
	// Bit mask of PINCLR14 field.
	GPIO_CLR_PINCLR14_Msk = 0x4000
	// Bit PINCLR14.
	GPIO_CLR_PINCLR14 = 0x4000
	// Position of PINCLR15 field.
	GPIO_CLR_PINCLR15_Pos = 0xf
	// Bit mask of PINCLR15 field.
	GPIO_CLR_PINCLR15_Msk = 0x8000
	// Bit PINCLR15.
	GPIO_CLR_PINCLR15 = 0x8000
	// Position of PINCLR16 field.
	GPIO_CLR_PINCLR16_Pos = 0x10
	// Bit mask of PINCLR16 field.
	GPIO_CLR_PINCLR16_Msk = 0x10000
	// Bit PINCLR16.
	GPIO_CLR_PINCLR16 = 0x10000
	// Position of PINCLR17 field.
	GPIO_CLR_PINCLR17_Pos = 0x11
	// Bit mask of PINCLR17 field.
	GPIO_CLR_PINCLR17_Msk = 0x20000
	// Bit PINCLR17.
	GPIO_CLR_PINCLR17 = 0x20000
	// Position of PINCLR18 field.
	GPIO_CLR_PINCLR18_Pos = 0x12
	// Bit mask of PINCLR18 field.
	GPIO_CLR_PINCLR18_Msk = 0x40000
	// Bit PINCLR18.
	GPIO_CLR_PINCLR18 = 0x40000
	// Position of PINCLR19 field.
	GPIO_CLR_PINCLR19_Pos = 0x13
	// Bit mask of PINCLR19 field.
	GPIO_CLR_PINCLR19_Msk = 0x80000
	// Bit PINCLR19.
	GPIO_CLR_PINCLR19 = 0x80000
	// Position of PINCLR20 field.
	GPIO_CLR_PINCLR20_Pos = 0x14
	// Bit mask of PINCLR20 field.
	GPIO_CLR_PINCLR20_Msk = 0x100000
	// Bit PINCLR20.
	GPIO_CLR_PINCLR20 = 0x100000
	// Position of PINCLR21 field.
	GPIO_CLR_PINCLR21_Pos = 0x15
	// Bit mask of PINCLR21 field.
	GPIO_CLR_PINCLR21_Msk = 0x200000
	// Bit PINCLR21.
	GPIO_CLR_PINCLR21 = 0x200000
	// Position of PINCLR22 field.
	GPIO_CLR_PINCLR22_Pos = 0x16
	// Bit mask of PINCLR22 field.
	GPIO_CLR_PINCLR22_Msk = 0x400000
	// Bit PINCLR22.
	GPIO_CLR_PINCLR22 = 0x400000
	// Position of PINCLR23 field.
	GPIO_CLR_PINCLR23_Pos = 0x17
	// Bit mask of PINCLR23 field.
	GPIO_CLR_PINCLR23_Msk = 0x800000
	// Bit PINCLR23.
	GPIO_CLR_PINCLR23 = 0x800000
	// Position of PINCLR24 field.
	GPIO_CLR_PINCLR24_Pos = 0x18
	// Bit mask of PINCLR24 field.
	GPIO_CLR_PINCLR24_Msk = 0x1000000
	// Bit PINCLR24.
	GPIO_CLR_PINCLR24 = 0x1000000
	// Position of PINCLR25 field.
	GPIO_CLR_PINCLR25_Pos = 0x19
	// Bit mask of PINCLR25 field.
	GPIO_CLR_PINCLR25_Msk = 0x2000000
	// Bit PINCLR25.
	GPIO_CLR_PINCLR25 = 0x2000000
	// Position of PINCLR26 field.
	GPIO_CLR_PINCLR26_Pos = 0x1a
	// Bit mask of PINCLR26 field.
	GPIO_CLR_PINCLR26_Msk = 0x4000000
	// Bit PINCLR26.
	GPIO_CLR_PINCLR26 = 0x4000000
	// Position of PINCLR27 field.
	GPIO_CLR_PINCLR27_Pos = 0x1b
	// Bit mask of PINCLR27 field.
	GPIO_CLR_PINCLR27_Msk = 0x8000000
	// Bit PINCLR27.
	GPIO_CLR_PINCLR27 = 0x8000000
	// Position of PINCLR28 field.
	GPIO_CLR_PINCLR28_Pos = 0x1c
	// Bit mask of PINCLR28 field.
	GPIO_CLR_PINCLR28_Msk = 0x10000000
	// Bit PINCLR28.
	GPIO_CLR_PINCLR28 = 0x10000000
	// Position of PINCLR29 field.
	GPIO_CLR_PINCLR29_Pos = 0x1d
	// Bit mask of PINCLR29 field.
	GPIO_CLR_PINCLR29_Msk = 0x20000000
	// Bit PINCLR29.
	GPIO_CLR_PINCLR29 = 0x20000000
	// Position of PINCLR30 field.
	GPIO_CLR_PINCLR30_Pos = 0x1e
	// Bit mask of PINCLR30 field.
	GPIO_CLR_PINCLR30_Msk = 0x40000000
	// Bit PINCLR30.
	GPIO_CLR_PINCLR30 = 0x40000000
	// Position of PINCLR31 field.
	GPIO_CLR_PINCLR31_Pos = 0x1f
	// Bit mask of PINCLR31 field.
	GPIO_CLR_PINCLR31_Msk = 0x80000000
	// Bit PINCLR31.
	GPIO_CLR_PINCLR31 = 0x80000000
)

// Bitfields for EMC: ExternalMemory Controller (EMC)
const (
	// CONTROL: Controls operation of the memory controller.
	// Position of E field.
	EMC_CONTROL_E_Pos = 0x0
	// Bit mask of E field.
	EMC_CONTROL_E_Msk = 0x1
	// Bit E.
	EMC_CONTROL_E = 0x1
	// Disabled
	EMC_CONTROL_E_DISABLED = 0x0
	// Enabled (POR and warm reset value).
	EMC_CONTROL_E_ENABLED = 0x1
	// Position of M field.
	EMC_CONTROL_M_Pos = 0x1
	// Bit mask of M field.
	EMC_CONTROL_M_Msk = 0x2
	// Bit M.
	EMC_CONTROL_M = 0x2
	// Normal memory map.
	EMC_CONTROL_M_NORMAL = 0x0
	// Reset memory map. Static memory EMC_CS1 is mirrored onto EMC_CS0 and EMC_DYCS0 (POR reset value).
	EMC_CONTROL_M_RESET = 0x1
	// Position of L field.
	EMC_CONTROL_L_Pos = 0x2
	// Bit mask of L field.
	EMC_CONTROL_L_Msk = 0x4
	// Bit L.
	EMC_CONTROL_L = 0x4
	// Normal mode (warm reset value).
	EMC_CONTROL_L_WARMRESET = 0x0
	// Low-power mode. Entering low-power mode reduces memory controller power consumption. Dynamic memory is refreshed as necessary. The memory controller returns to normal functional mode by clearing the low-power mode bit (L), or by POR. This bit must only be modified when the EMC is in idle state.[1]
	EMC_CONTROL_L_LOWPOWER = 0x1
	// Position of RESERVED field.
	EMC_CONTROL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EMC_CONTROL_RESERVED_Msk = 0xfffffff8

	// STATUS: Provides EMC status information.
	// Position of B field.
	EMC_STATUS_B_Pos = 0x0
	// Bit mask of B field.
	EMC_STATUS_B_Msk = 0x1
	// Bit B.
	EMC_STATUS_B = 0x1
	// EMC is idle (warm reset value).
	EMC_STATUS_B_IDLE = 0x0
	// EMC is busy performing memory transactions, commands, auto-refresh cycles, or is in self-refresh mode (POR reset value).
	EMC_STATUS_B_BUSY = 0x1
	// Position of S field.
	EMC_STATUS_S_Pos = 0x1
	// Bit mask of S field.
	EMC_STATUS_S_Msk = 0x2
	// Bit S.
	EMC_STATUS_S = 0x2
	// Write buffers empty (POR reset value)
	EMC_STATUS_S_EMPTY = 0x0
	// Write buffers contain data.
	EMC_STATUS_S_DATA = 0x1
	// Position of SA field.
	EMC_STATUS_SA_Pos = 0x2
	// Bit mask of SA field.
	EMC_STATUS_SA_Msk = 0x4
	// Bit SA.
	EMC_STATUS_SA = 0x4
	// Normal mode
	EMC_STATUS_SA_NORMAL = 0x0
	// Self-refresh mode (POR reset value).
	EMC_STATUS_SA_SELFREFRESH = 0x1
	// Position of RESERVED field.
	EMC_STATUS_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EMC_STATUS_RESERVED_Msk = 0xfffffff8

	// CONFIG: Configures operation of the memory controller
	// Position of EM field.
	EMC_CONFIG_EM_Pos = 0x0
	// Bit mask of EM field.
	EMC_CONFIG_EM_Msk = 0x1
	// Bit EM.
	EMC_CONFIG_EM = 0x1
	// Little-endian mode (POR reset value).
	EMC_CONFIG_EM_LITTLEENDIAN = 0x0
	// Big-endian mode.
	EMC_CONFIG_EM_BIGENDIAN = 0x1
	// Position of RESERVED field.
	EMC_CONFIG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	EMC_CONFIG_RESERVED_Msk = 0xfe
	// Position of CLKR field.
	EMC_CONFIG_CLKR_Pos = 0x8
	// Bit mask of CLKR field.
	EMC_CONFIG_CLKR_Msk = 0x100
	// Bit CLKR.
	EMC_CONFIG_CLKR = 0x100
	// 1:1(POR reset value)
	EMC_CONFIG_CLKR_PORRESET = 0x0
	// 1:2 (this option is not available on the LPC178x/177x)
	EMC_CONFIG_CLKR_DONOTUSE = 0x1
	// Position of RESERVED field.
	EMC_CONFIG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	EMC_CONFIG_RESERVED_Msk = 0xfffffe00

	// DYNAMICCONTROL: Controls dynamic memory operation.
	// Position of CE field.
	EMC_DYNAMICCONTROL_CE_Pos = 0x0
	// Bit mask of CE field.
	EMC_DYNAMICCONTROL_CE_Msk = 0x1
	// Bit CE.
	EMC_DYNAMICCONTROL_CE = 0x1
	// Clock enable of idle devices are deasserted to save power (POR reset value).
	EMC_DYNAMICCONTROL_CE_POWERSAVE = 0x0
	// All clock enables are driven HIGH continuously.[1]
	EMC_DYNAMICCONTROL_CE_HIGH = 0x1
	// Position of CS field.
	EMC_DYNAMICCONTROL_CS_Pos = 0x1
	// Bit mask of CS field.
	EMC_DYNAMICCONTROL_CS_Msk = 0x2
	// Bit CS.
	EMC_DYNAMICCONTROL_CS = 0x2
	// CLKOUT stops when all SDRAMs are idle and during self-refresh mode.
	EMC_DYNAMICCONTROL_CS_STOP = 0x0
	// CLKOUT runs continuously (POR reset value).
	EMC_DYNAMICCONTROL_CS_RUN = 0x1
	// Position of SR field.
	EMC_DYNAMICCONTROL_SR_Pos = 0x2
	// Bit mask of SR field.
	EMC_DYNAMICCONTROL_SR_Msk = 0x4
	// Bit SR.
	EMC_DYNAMICCONTROL_SR = 0x4
	// Normal mode.
	EMC_DYNAMICCONTROL_SR_NORMAL_MODE_ = 0x0
	// Enter self-refresh mode (POR reset value).
	EMC_DYNAMICCONTROL_SR_ENTER_SELF_REFRESH_M = 0x1
	// Position of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Msk = 0x18
	// Position of MMC field.
	EMC_DYNAMICCONTROL_MMC_Pos = 0x5
	// Bit mask of MMC field.
	EMC_DYNAMICCONTROL_MMC_Msk = 0x20
	// Bit MMC.
	EMC_DYNAMICCONTROL_MMC = 0x20
	// CLKOUT enabled (POR reset value).
	EMC_DYNAMICCONTROL_MMC_CLKOUT_ENABLED_POR_ = 0x0
	// CLKOUT disabled.[3]
	EMC_DYNAMICCONTROL_MMC_CLKOUT_DISABLED = 0x1
	// Position of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Msk = 0x40
	// Bit RESERVED.
	EMC_DYNAMICCONTROL_RESERVED = 0x40
	// Position of I field.
	EMC_DYNAMICCONTROL_I_Pos = 0x7
	// Bit mask of I field.
	EMC_DYNAMICCONTROL_I_Msk = 0x180
	// Issue SDRAM NORMAL operation command (POR reset value).
	EMC_DYNAMICCONTROL_I_NORMAL = 0x0
	// Issue SDRAM MODE command.
	EMC_DYNAMICCONTROL_I_MODE = 0x1
	// Issue SDRAM PALL (precharge all) command.
	EMC_DYNAMICCONTROL_I_PALL = 0x2
	// Issue SDRAM NOP (no operation) command)
	EMC_DYNAMICCONTROL_I_NOP = 0x3
	// Position of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Msk = 0x3e00
	// Position of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONTROL_RESERVED_Msk = 0xffffc000

	// DYNAMICREFRESH: Configures dynamic memory refresh.
	// Position of REFRESH field.
	EMC_DYNAMICREFRESH_REFRESH_Pos = 0x0
	// Bit mask of REFRESH field.
	EMC_DYNAMICREFRESH_REFRESH_Msk = 0x7ff
	// Position of RESERVED field.
	EMC_DYNAMICREFRESH_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	EMC_DYNAMICREFRESH_RESERVED_Msk = 0xfffff800

	// DYNAMICREADCONFIG: Configures dynamic memory read strategy.
	// Position of RD field.
	EMC_DYNAMICREADCONFIG_RD_Pos = 0x0
	// Bit mask of RD field.
	EMC_DYNAMICREADCONFIG_RD_Msk = 0x3
	// Clock out delayed strategy, using CLKOUT (command not delayed, clock out delayed). POR reset value.
	EMC_DYNAMICREADCONFIG_RD_CLOCK_OUT_DELAYED_ST = 0x0
	// Position of RESERVED field.
	EMC_DYNAMICREADCONFIG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	EMC_DYNAMICREADCONFIG_RESERVED_Msk = 0xfffffffc

	// DYNAMICRP: Precharge command period.
	// Position of TRP field.
	EMC_DYNAMICRP_TRP_Pos = 0x0
	// Bit mask of TRP field.
	EMC_DYNAMICRP_TRP_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICRP_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICRP_RESERVED_Msk = 0xfffffff0

	// DYNAMICRAS: Active to precharge command period.
	// Position of TRAS field.
	EMC_DYNAMICRAS_TRAS_Pos = 0x0
	// Bit mask of TRAS field.
	EMC_DYNAMICRAS_TRAS_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICRAS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICRAS_RESERVED_Msk = 0xfffffff0

	// DYNAMICSREX: Self-refresh exit time.
	// Position of TSREX field.
	EMC_DYNAMICSREX_TSREX_Pos = 0x0
	// Bit mask of TSREX field.
	EMC_DYNAMICSREX_TSREX_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICSREX_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICSREX_RESERVED_Msk = 0xfffffff0

	// DYNAMICAPR: Last-data-out to active command time.
	// Position of TAPR field.
	EMC_DYNAMICAPR_TAPR_Pos = 0x0
	// Bit mask of TAPR field.
	EMC_DYNAMICAPR_TAPR_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICAPR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICAPR_RESERVED_Msk = 0xfffffff0

	// DYNAMICDAL: Data-in to active command time.
	// Position of TDAL field.
	EMC_DYNAMICDAL_TDAL_Pos = 0x0
	// Bit mask of TDAL field.
	EMC_DYNAMICDAL_TDAL_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICDAL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICDAL_RESERVED_Msk = 0xfffffff0

	// DYNAMICWR: Write recovery time.
	// Position of TWR field.
	EMC_DYNAMICWR_TWR_Pos = 0x0
	// Bit mask of TWR field.
	EMC_DYNAMICWR_TWR_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICWR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICWR_RESERVED_Msk = 0xfffffff0

	// DYNAMICRC: Selects the active to active command period.
	// Position of TRC field.
	EMC_DYNAMICRC_TRC_Pos = 0x0
	// Bit mask of TRC field.
	EMC_DYNAMICRC_TRC_Msk = 0x1f
	// Position of RESERVED field.
	EMC_DYNAMICRC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_DYNAMICRC_RESERVED_Msk = 0xffffffe0

	// DYNAMICRFC: Selects the auto-refresh period.
	// Position of TRFC field.
	EMC_DYNAMICRFC_TRFC_Pos = 0x0
	// Bit mask of TRFC field.
	EMC_DYNAMICRFC_TRFC_Msk = 0x1f
	// Position of RESERVED field.
	EMC_DYNAMICRFC_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_DYNAMICRFC_RESERVED_Msk = 0xffffffe0

	// DYNAMICXSR: Time for exit self-refresh to active command.
	// Position of TXSR field.
	EMC_DYNAMICXSR_TXSR_Pos = 0x0
	// Bit mask of TXSR field.
	EMC_DYNAMICXSR_TXSR_Msk = 0x1f
	// Position of RESERVED field.
	EMC_DYNAMICXSR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_DYNAMICXSR_RESERVED_Msk = 0xffffffe0

	// DYNAMICRRD: Latency for active bank A to active bank B.
	// Position of TRRD field.
	EMC_DYNAMICRRD_TRRD_Pos = 0x0
	// Bit mask of TRRD field.
	EMC_DYNAMICRRD_TRRD_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICRRD_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICRRD_RESERVED_Msk = 0xfffffff0

	// DYNAMICMRD: Time for load mode register to active command.
	// Position of TMRD field.
	EMC_DYNAMICMRD_TMRD_Pos = 0x0
	// Bit mask of TMRD field.
	EMC_DYNAMICMRD_TMRD_Msk = 0xf
	// Position of RESERVED field.
	EMC_DYNAMICMRD_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_DYNAMICMRD_RESERVED_Msk = 0xfffffff0

	// STATICEXTENDEDWAIT: Time for long static memory read and write transfers.
	// Position of EXTENDEDWAIT field.
	EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Pos = 0x0
	// Bit mask of EXTENDEDWAIT field.
	EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Msk = 0x3ff
	// Position of RESERVED field.
	EMC_STATICEXTENDEDWAIT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	EMC_STATICEXTENDEDWAIT_RESERVED_Msk = 0xfffffc00

	// DYNAMICCONFIG0: Configuration information for EMC_DYCS0.
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0x7
	// Position of MD field.
	EMC_DYNAMICCONFIG_MD_Pos = 0x3
	// Bit mask of MD field.
	EMC_DYNAMICCONFIG_MD_Msk = 0x18
	// SDRAM (POR reset value).
	EMC_DYNAMICCONFIG_MD_SDRAM_POR_RESET_VAL = 0x0
	// Low-power SDRAM.
	EMC_DYNAMICCONFIG_MD_LOW_POWER_SDRAM_ = 0x1
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0x60
	// Position of AM0 field.
	EMC_DYNAMICCONFIG_AM0_Pos = 0x7
	// Bit mask of AM0 field.
	EMC_DYNAMICCONFIG_AM0_Msk = 0x1f80
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	EMC_DYNAMICCONFIG_RESERVED = 0x2000
	// Position of AM1 field.
	EMC_DYNAMICCONFIG_AM1_Pos = 0xe
	// Bit mask of AM1 field.
	EMC_DYNAMICCONFIG_AM1_Msk = 0x4000
	// Bit AM1.
	EMC_DYNAMICCONFIG_AM1 = 0x4000
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0x78000
	// Position of B field.
	EMC_DYNAMICCONFIG_B_Pos = 0x13
	// Bit mask of B field.
	EMC_DYNAMICCONFIG_B_Msk = 0x80000
	// Bit B.
	EMC_DYNAMICCONFIG_B = 0x80000
	// Buffer disabled for accesses to this chip select (POR reset value).
	EMC_DYNAMICCONFIG_B_BUFFER_DISABLED_FOR_ = 0x0
	// Buffer enabled for accesses to this chip select.[2]
	EMC_DYNAMICCONFIG_B_BUFFER_ENABLED_FOR_A = 0x1
	// Position of P field.
	EMC_DYNAMICCONFIG_P_Pos = 0x14
	// Bit mask of P field.
	EMC_DYNAMICCONFIG_P_Msk = 0x100000
	// Bit P.
	EMC_DYNAMICCONFIG_P = 0x100000
	// Writes not protected (POR reset value).
	EMC_DYNAMICCONFIG_P_WRITES_NOT_PROTECTED = 0x0
	// Writes protected.
	EMC_DYNAMICCONFIG_P_WRITES_PROTECTED_ = 0x1
	// Position of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	EMC_DYNAMICCONFIG_RESERVED_Msk = 0xffe00000

	// DYNAMICRASCAS0: RAS and CAS latencies for EMC_DYCS0.
	// Position of RAS field.
	EMC_DYNAMICRASCAS_RAS_Pos = 0x0
	// Bit mask of RAS field.
	EMC_DYNAMICRASCAS_RAS_Msk = 0x3
	// Reserved.
	EMC_DYNAMICRASCAS_RAS_RESERVED_ = 0x0
	// One CCLK cycle.
	EMC_DYNAMICRASCAS_RAS_ONE_CCLK_CYCLE_ = 0x1
	// Two CCLK cycles.
	EMC_DYNAMICRASCAS_RAS_TWO_CCLK_CYCLES_ = 0x2
	// Three CCLK cycles (POR reset value).
	EMC_DYNAMICRASCAS_RAS_THREE_CCLK_CYCLES_P = 0x3
	// Position of RESERVED field.
	EMC_DYNAMICRASCAS_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	EMC_DYNAMICRASCAS_RESERVED_Msk = 0xfc
	// Position of CAS field.
	EMC_DYNAMICRASCAS_CAS_Pos = 0x8
	// Bit mask of CAS field.
	EMC_DYNAMICRASCAS_CAS_Msk = 0x300
	// Reserved.
	EMC_DYNAMICRASCAS_CAS_RESERVED_ = 0x0
	// One CCLK cycle.
	EMC_DYNAMICRASCAS_CAS_ONE_CCLK_CYCLE_ = 0x1
	// Two CCLK cycles.
	EMC_DYNAMICRASCAS_CAS_TWO_CCLK_CYCLES_ = 0x2
	// Three CCLK cycles (POR reset value).
	EMC_DYNAMICRASCAS_CAS_THREE_CCLK_CYCLES_P = 0x3
	// Position of RESERVED field.
	EMC_DYNAMICRASCAS_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	EMC_DYNAMICRASCAS_RESERVED_Msk = 0xfffffc00

	// STATICCONFIG0: Configuration for EMC_CS0.
	// Position of MW field.
	EMC_STATICCONFIG_MW_Pos = 0x0
	// Bit mask of MW field.
	EMC_STATICCONFIG_MW_Msk = 0x3
	// 8 bit (POR reset value).
	EMC_STATICCONFIG_MW_8_BIT_POR_RESET_VAL = 0x0
	// 16 bit.
	EMC_STATICCONFIG_MW_16_BIT_ = 0x1
	// 32 bit.
	EMC_STATICCONFIG_MW_32_BIT_ = 0x2
	// Reserved.
	EMC_STATICCONFIG_MW_RESERVED_ = 0x3
	// Position of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Msk = 0x4
	// Bit RESERVED.
	EMC_STATICCONFIG_RESERVED = 0x4
	// Position of PM field.
	EMC_STATICCONFIG_PM_Pos = 0x3
	// Bit mask of PM field.
	EMC_STATICCONFIG_PM_Msk = 0x8
	// Bit PM.
	EMC_STATICCONFIG_PM = 0x8
	// Disabled (POR reset value).
	EMC_STATICCONFIG_PM_DISABLED_POR_RESET_ = 0x0
	// Asynchronous page mode enabled (page length four).
	EMC_STATICCONFIG_PM_ASYNCHRONOUS_PAGE_MO = 0x1
	// Position of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Msk = 0x30
	// Position of PC field.
	EMC_STATICCONFIG_PC_Pos = 0x6
	// Bit mask of PC field.
	EMC_STATICCONFIG_PC_Msk = 0x40
	// Bit PC.
	EMC_STATICCONFIG_PC = 0x40
	// Active LOW chip select.
	EMC_STATICCONFIG_PC_ACTIVE_LOW_CHIP_SELE = 0x0
	// Active HIGH chip select.
	EMC_STATICCONFIG_PC_ACTIVE_HIGH_CHIP_SEL = 0x1
	// Position of PB field.
	EMC_STATICCONFIG_PB_Pos = 0x7
	// Bit mask of PB field.
	EMC_STATICCONFIG_PB_Msk = 0x80
	// Bit PB.
	EMC_STATICCONFIG_PB = 0x80
	// For reads all the bits in BLS3:0 are HIGH. For writes the respective active bits in BLS3:0 are LOW (POR reset value).
	EMC_STATICCONFIG_PB_BLSHIGH = 0x0
	// For reads the respective active bits in BLS3:0 are LOW. For writes the respective active bits in BLS3:0 are LOW.
	EMC_STATICCONFIG_PB_BLSLOW = 0x1
	// Position of EW field.
	EMC_STATICCONFIG_EW_Pos = 0x8
	// Bit mask of EW field.
	EMC_STATICCONFIG_EW_Msk = 0x100
	// Bit EW.
	EMC_STATICCONFIG_EW = 0x100
	// Extended wait disabled (POR reset value).
	EMC_STATICCONFIG_EW_EXTENDED_WAIT_DISABL = 0x0
	// Extended wait enabled.
	EMC_STATICCONFIG_EW_EXTENDED_WAIT_ENABLE = 0x1
	// Position of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Msk = 0x7fe00
	// Position of B field.
	EMC_STATICCONFIG_B_Pos = 0x13
	// Bit mask of B field.
	EMC_STATICCONFIG_B_Msk = 0x80000
	// Bit B.
	EMC_STATICCONFIG_B = 0x80000
	// Buffer disabled (POR reset value).
	EMC_STATICCONFIG_B_BUFFER_DISABLED_POR = 0x0
	// Buffer enabled.
	EMC_STATICCONFIG_B_BUFFER_ENABLED_ = 0x1
	// Position of P field.
	EMC_STATICCONFIG_P_Pos = 0x14
	// Bit mask of P field.
	EMC_STATICCONFIG_P_Msk = 0x100000
	// Bit P.
	EMC_STATICCONFIG_P = 0x100000
	// Writes not protected (POR reset value).
	EMC_STATICCONFIG_P_WRITES_NOT_PROTECTED = 0x0
	// Write protected.
	EMC_STATICCONFIG_P_WRITE_PROTECTED_ = 0x1
	// Position of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	EMC_STATICCONFIG_RESERVED_Msk = 0xffe00000

	// STATICWAITWEN0: Delay from EMC_CS0 to write enable.
	// Position of WAITWEN field.
	EMC_STATICWAITWEN_WAITWEN_Pos = 0x0
	// Bit mask of WAITWEN field.
	EMC_STATICWAITWEN_WAITWEN_Msk = 0xf
	// Position of RESERVED field.
	EMC_STATICWAITWEN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_STATICWAITWEN_RESERVED_Msk = 0xfffffff0

	// STATICWAITOEN0: Delay from EMC_CS0 or address change, whichever is later, to output enable.
	// Position of WAITOEN field.
	EMC_STATICWAITOEN_WAITOEN_Pos = 0x0
	// Bit mask of WAITOEN field.
	EMC_STATICWAITOEN_WAITOEN_Msk = 0xf
	// Position of RESERVED field.
	EMC_STATICWAITOEN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_STATICWAITOEN_RESERVED_Msk = 0xfffffff0

	// STATICWAITRD0: Delay from EMC_CS0 to a read access.
	// Position of WAITRD field.
	EMC_STATICWAITRD_WAITRD_Pos = 0x0
	// Bit mask of WAITRD field.
	EMC_STATICWAITRD_WAITRD_Msk = 0x1f
	// Position of RESERVED field.
	EMC_STATICWAITRD_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_STATICWAITRD_RESERVED_Msk = 0xffffffe0

	// STATICWAITPAGE0: Delay for asynchronous page mode sequential accesses for EMC_CS0.
	// Position of WAITPAGE field.
	EMC_STATICWAITPAGE_WAITPAGE_Pos = 0x0
	// Bit mask of WAITPAGE field.
	EMC_STATICWAITPAGE_WAITPAGE_Msk = 0x1f
	// Position of RESERVED field.
	EMC_STATICWAITPAGE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_STATICWAITPAGE_RESERVED_Msk = 0xffffffe0

	// STATICWAITWR0: Delay from EMC_CS0 to a write access.
	// Position of WAITWR field.
	EMC_STATICWAITWR_WAITWR_Pos = 0x0
	// Bit mask of WAITWR field.
	EMC_STATICWAITWR_WAITWR_Msk = 0x1f
	// Position of RESERVED field.
	EMC_STATICWAITWR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	EMC_STATICWAITWR_RESERVED_Msk = 0xffffffe0

	// STATICWAITTURN0: Number of bus turnaround cycles EMC_CS0.
	// Position of WAITTURN field.
	EMC_STATICWAITTURN_WAITTURN_Pos = 0x0
	// Bit mask of WAITTURN field.
	EMC_STATICWAITTURN_WAITTURN_Msk = 0xf
	// Position of RESERVED field.
	EMC_STATICWAITTURN_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	EMC_STATICWAITTURN_RESERVED_Msk = 0xfffffff0
)

// Bitfields for WWDT: Windowed Watchdog Timer (WWDT)
const (
	// MOD: Watchdog mode register. This register determines the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// The watchdog timer is stopped.
	WWDT_MOD_WDEN_STOP = 0x0
	// The watchdog timer is running.
	WWDT_MOD_WDEN_RUN = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// A watchdog timeout will not cause a chip reset.
	WWDT_MOD_WDRESET_NORESET = 0x0
	// A watchdog timeout will cause a chip reset.
	WWDT_MOD_WDRESET_RESET = 0x1
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// The watchdog reload value (WDTC) can be changed at any time.
	WWDT_MOD_WDPROTECT_CHANGE = 0x0
	// The watchdog reload value (WDTC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW. Note: this mode is intended for use only when WDRESET =1.
	WWDT_MOD_WDPROTECT_CHANGE_W_CNT = 0x1
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xe0

	// TC: Watchdog timer constant register. The value in this register determines the time-out value.
	// Position of Count field.
	WWDT_TC_Count_Pos = 0x0
	// Bit mask of Count field.
	WWDT_TC_Count_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of Feed field.
	WWDT_FEED_Feed_Pos = 0x0
	// Bit mask of Feed field.
	WWDT_FEED_Feed_Msk = 0xff

	// TV: Watchdog timer value register. This register reads out the current value of the Watchdog timer.
	// Position of Count field.
	WWDT_TV_Count_Pos = 0x0
	// Bit mask of Count field.
	WWDT_TV_Count_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// WARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Bitfields for TIMER0: Timer0/1/2/3
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	TIMER0_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	TIMER0_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	TIMER0_IR_MR0INT = 0x1
	// Position of MR1INT field.
	TIMER0_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	TIMER0_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	TIMER0_IR_MR1INT = 0x2
	// Position of MR2INT field.
	TIMER0_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	TIMER0_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	TIMER0_IR_MR2INT = 0x4
	// Position of MR3INT field.
	TIMER0_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	TIMER0_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	TIMER0_IR_MR3INT = 0x8
	// Position of CR0INT field.
	TIMER0_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	TIMER0_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	TIMER0_IR_CR0INT = 0x10
	// Position of CR1INT field.
	TIMER0_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	TIMER0_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	TIMER0_IR_CR1INT = 0x20
	// Position of RESERVED field.
	TIMER0_IR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	TIMER0_IR_RESERVED_Msk = 0xffffffc0

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	TIMER0_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIMER0_TCR_CEN_Msk = 0x1
	// Bit CEN.
	TIMER0_TCR_CEN = 0x1
	// Position of CRST field.
	TIMER0_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	TIMER0_TCR_CRST_Msk = 0x2
	// Bit CRST.
	TIMER0_TCR_CRST = 0x2
	// Position of RESERVED field.
	TIMER0_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	TIMER0_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	TIMER0_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	TIMER0_TC_TC_Msk = 0xffffffff

	// PR: Prescale Register. When the Prescale Counter (PC) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PM field.
	TIMER0_PR_PM_Pos = 0x0
	// Bit mask of PM field.
	TIMER0_PR_PM_Msk = 0xffffffff

	// PC: Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PC field.
	TIMER0_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	TIMER0_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	TIMER0_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	TIMER0_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	TIMER0_MCR_MR0I = 0x1
	// Interrupt is generated when MR0 matches the value in the TC.
	TIMER0_MCR_MR0I_INTERRUPT_IS_GENERAT = 0x1
	// Interrupt is disabled
	TIMER0_MCR_MR0I_INTERRUPT_IS_DISABLE = 0x0
	// Position of MR0R field.
	TIMER0_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	TIMER0_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	TIMER0_MCR_MR0R = 0x2
	// TC will be reset if MR0 matches it.
	TIMER0_MCR_MR0R_TC_WILL_BE_RESET_IF_ = 0x1
	// Feature disabled.
	TIMER0_MCR_MR0R_FEATURE_DISABLED_ = 0x0
	// Position of MR0S field.
	TIMER0_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	TIMER0_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	TIMER0_MCR_MR0S = 0x4
	// TC and PC will be stopped and TCR[0] will be set to 0 if MR0 matches the TC.
	TIMER0_MCR_MR0S_TC_AND_PC_WILL_BE_ST = 0x1
	// Feature disabled.
	TIMER0_MCR_MR0S_FEATURE_DISABLED_ = 0x0
	// Position of MR1I field.
	TIMER0_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	TIMER0_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	TIMER0_MCR_MR1I = 0x8
	// Interrupt is generated when MR1 matches the value in the TC.
	TIMER0_MCR_MR1I_INTERRUPT_IS_GENERAT = 0x1
	// Interrupt is disabled.
	TIMER0_MCR_MR1I_INTERRUPT_IS_DISABLE = 0x0
	// Position of MR1R field.
	TIMER0_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	TIMER0_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	TIMER0_MCR_MR1R = 0x10
	// TC will be reset if MR1 matches it.
	TIMER0_MCR_MR1R_TC_WILL_BE_RESET_IF_ = 0x1
	// Feature disabled.
	TIMER0_MCR_MR1R_FEATURE_DISABLED_ = 0x0
	// Position of MR1S field.
	TIMER0_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	TIMER0_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	TIMER0_MCR_MR1S = 0x20
	// TC and PC will be stopped and TCR[0] will be set to 0 if MR1 matches the TC.
	TIMER0_MCR_MR1S_TC_AND_PC_WILL_BE_ST = 0x1
	// Feature disabled.
	TIMER0_MCR_MR1S_FEATURE_DISABLED_ = 0x0
	// Position of MR2I field.
	TIMER0_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	TIMER0_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	TIMER0_MCR_MR2I = 0x40
	// Interrupt is generated when MR2 matches the value in the TC.
	TIMER0_MCR_MR2I_INTERRUPT_IS_GENERAT = 0x1
	// Interrupt is disabled
	TIMER0_MCR_MR2I_INTERRUPT_IS_DISABLE = 0x0
	// Position of MR2R field.
	TIMER0_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	TIMER0_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	TIMER0_MCR_MR2R = 0x80
	// TC will be reset if MR2 matches it.
	TIMER0_MCR_MR2R_TC_WILL_BE_RESET_IF_ = 0x1
	// Feature disabled.
	TIMER0_MCR_MR2R_FEATURE_DISABLED_ = 0x0
	// Position of MR2S field.
	TIMER0_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	TIMER0_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	TIMER0_MCR_MR2S = 0x100
	// TC and PC will be stopped and TCR[0] will be set to 0 if MR2 matches the TC
	TIMER0_MCR_MR2S_TC_AND_PC_WILL_BE_ST = 0x1
	// Feature disabled.
	TIMER0_MCR_MR2S_FEATURE_DISABLED_ = 0x0
	// Position of MR3I field.
	TIMER0_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	TIMER0_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	TIMER0_MCR_MR3I = 0x200
	// Interrupt is generated when MR3 matches the value in the TC.
	TIMER0_MCR_MR3I_INTERRUPT_IS_GENERAT = 0x1
	// This interrupt is disabled
	TIMER0_MCR_MR3I_THIS_INTERRUPT_IS_DI = 0x0
	// Position of MR3R field.
	TIMER0_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	TIMER0_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	TIMER0_MCR_MR3R = 0x400
	// TC will be reset if MR3 matches it.
	TIMER0_MCR_MR3R_TC_WILL_BE_RESET_IF_ = 0x1
	// Feature disabled.
	TIMER0_MCR_MR3R_FEATURE_DISABLED_ = 0x0
	// Position of MR3S field.
	TIMER0_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	TIMER0_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	TIMER0_MCR_MR3S = 0x800
	// TC and PC will be stopped and TCR[0] will be set to 0 if MR3 matches the TC.
	TIMER0_MCR_MR3S_TC_AND_PC_WILL_BE_ST = 0x1
	// Feature disabled.
	TIMER0_MCR_MR3S_FEATURE_DISABLED_ = 0x0
	// Position of RESERVED field.
	TIMER0_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	TIMER0_MCR_RESERVED_Msk = 0xfffff000

	// MR: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	TIMER0_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	TIMER0_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	TIMER0_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	TIMER0_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	TIMER0_CCR_CAP0RE = 0x1
	// A sequence of 0 then 1 on CAPn.0 will cause CR0 to be loaded with the contents of TC.
	TIMER0_CCR_CAP0RE_ENABLE = 0x1
	// This feature is disabled.
	TIMER0_CCR_CAP0RE_DISABLE = 0x0
	// Position of CAP0FE field.
	TIMER0_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	TIMER0_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	TIMER0_CCR_CAP0FE = 0x2
	// A sequence of 1 then 0 on CAPn.0 will cause CR0 to be loaded with the contents of TC.
	TIMER0_CCR_CAP0FE_ENABLE = 0x1
	// This feature is disabled.
	TIMER0_CCR_CAP0FE_DISABLE = 0x0
	// Position of CAP0I field.
	TIMER0_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	TIMER0_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	TIMER0_CCR_CAP0I = 0x4
	// A CR0 load due to a CAPn.0 event will generate an interrupt.
	TIMER0_CCR_CAP0I_ENABLE = 0x1
	// This feature is disabled.
	TIMER0_CCR_CAP0I_DISABLE = 0x0
	// Position of CAP1RE field.
	TIMER0_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	TIMER0_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	TIMER0_CCR_CAP1RE = 0x8
	// A sequence of 0 then 1 on CAPn.1 will cause CR1 to be loaded with the contents of TC.
	TIMER0_CCR_CAP1RE_ENABLE = 0x1
	// This feature is disabled.
	TIMER0_CCR_CAP1RE_DISABLE = 0x0
	// Position of CAP1FE field.
	TIMER0_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	TIMER0_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	TIMER0_CCR_CAP1FE = 0x10
	// A sequence of 1 then 0 on CAPn.1 will cause CR1 to be loaded with the contents of TC.
	TIMER0_CCR_CAP1FE_ENABLE = 0x1
	// This feature is disabled.
	TIMER0_CCR_CAP1FE_DISABLE = 0x0
	// Position of CAP1I field.
	TIMER0_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	TIMER0_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	TIMER0_CCR_CAP1I = 0x20
	// A CR1 load due to a CAPn.1 event will generate an interrupt.
	TIMER0_CCR_CAP1I_ENABLE = 0x1
	// This feature is disabled.
	TIMER0_CCR_CAP1I_DISABLE = 0x0
	// Position of RESERVED field.
	TIMER0_CCR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	TIMER0_CCR_RESERVED_Msk = 0xffffffc0

	// CR: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CAPn.0 input.
	// Position of CAP field.
	TIMER0_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	TIMER0_CR_CAP_Msk = 0xffffffff

	// EMR: External Match Register. The EMR controls the external match pins.
	// Position of EM0 field.
	TIMER0_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	TIMER0_EMR_EM0_Msk = 0x1
	// Bit EM0.
	TIMER0_EMR_EM0 = 0x1
	// Position of EM1 field.
	TIMER0_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	TIMER0_EMR_EM1_Msk = 0x2
	// Bit EM1.
	TIMER0_EMR_EM1 = 0x2
	// Position of EM2 field.
	TIMER0_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	TIMER0_EMR_EM2_Msk = 0x4
	// Bit EM2.
	TIMER0_EMR_EM2 = 0x4
	// Position of EM3 field.
	TIMER0_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	TIMER0_EMR_EM3_Msk = 0x8
	// Bit EM3.
	TIMER0_EMR_EM3 = 0x8
	// Position of EMC0 field.
	TIMER0_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	TIMER0_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	TIMER0_EMR_EMC0_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER0_EMR_EMC0_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER0_EMR_EMC0_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	TIMER0_EMR_EMC0_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC1 field.
	TIMER0_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	TIMER0_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	TIMER0_EMR_EMC1_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER0_EMR_EMC1_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER0_EMR_EMC1_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	TIMER0_EMR_EMC1_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC2 field.
	TIMER0_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	TIMER0_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	TIMER0_EMR_EMC2_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER0_EMR_EMC2_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER0_EMR_EMC2_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	TIMER0_EMR_EMC2_TOGGLE_THE_CORRESPON = 0x3
	// Position of EMC3 field.
	TIMER0_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	TIMER0_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	TIMER0_EMR_EMC3_DO_NOTHING_ = 0x0
	// Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER0_EMR_EMC3_CLEAR_THE_CORRESPOND = 0x1
	// Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER0_EMR_EMC3_SET_THE_CORRESPONDIN = 0x2
	// Toggle the corresponding External Match bit/output.
	TIMER0_EMR_EMC3_TOGGLE_THE_CORRESPON = 0x3
	// Position of RESERVED field.
	TIMER0_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	TIMER0_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTMODE field.
	TIMER0_CTCR_CTMODE_Pos = 0x0
	// Bit mask of CTMODE field.
	TIMER0_CTCR_CTMODE_Msk = 0x3
	// Timer Mode: every rising PCLK edge
	TIMER0_CTCR_CTMODE_TIMER_MODE_EVERY_RI = 0x0
	// Counter Mode: TC is incremented on rising edges on the CAP input selected by bits 3:2.
	TIMER0_CTCR_CTMODE_RISING = 0x1
	// Counter Mode: TC is incremented on falling edges on the CAP input selected by bits 3:2.
	TIMER0_CTCR_CTMODE_FALLING = 0x2
	// Counter Mode: TC is incremented on both edges on the CAP input selected by bits 3:2.
	TIMER0_CTCR_CTMODE_DUALEDGE = 0x3
	// Position of CINSEL field.
	TIMER0_CTCR_CINSEL_Pos = 0x2
	// Bit mask of CINSEL field.
	TIMER0_CTCR_CINSEL_Msk = 0xc
	// CAPn.0 for TIMERn
	TIMER0_CTCR_CINSEL_CAPN_0_FOR_TIMERN = 0x0
	// CAPn.1 for TIMERn
	TIMER0_CTCR_CINSEL_CAPN_1_FOR_TIMERN = 0x1
	// Position of RESERVED field.
	TIMER0_CTCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	TIMER0_CTCR_RESERVED_Msk = 0xfffffff0
)

// Bitfields for UART0: UART0/2/3
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read (DLAB =0).
	// Position of RBR field.
	UART0_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	UART0_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	UART0_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Regiter. The next character to be transmitted is written here (DLAB =0).
	// Position of THR field.
	UART0_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	UART0_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	UART0_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB =1).
	// Position of DLLSB field.
	UART0_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	UART0_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	UART0_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB =1).
	// Position of DLMSB field.
	UART0_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	UART0_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	UART0_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART interrupts (DLAB =0).
	// Position of RBRIE field.
	UART0_IER_RBRIE_Pos = 0x0
	// Bit mask of RBRIE field.
	UART0_IER_RBRIE_Msk = 0x1
	// Bit RBRIE.
	UART0_IER_RBRIE = 0x1
	// Disable the RDA interrupts.
	UART0_IER_RBRIE_DISABLE_THE_RDA_INTE = 0x0
	// Enable the RDA interrupts.
	UART0_IER_RBRIE_ENABLE_THE_RDA_INTER = 0x1
	// Position of THREIE field.
	UART0_IER_THREIE_Pos = 0x1
	// Bit mask of THREIE field.
	UART0_IER_THREIE_Msk = 0x2
	// Bit THREIE.
	UART0_IER_THREIE = 0x2
	// Disable the THRE interrupts.
	UART0_IER_THREIE_DISABLE_THE_THRE_INT = 0x0
	// Enable the THRE interrupts.
	UART0_IER_THREIE_ENABLE_THE_THRE_INTE = 0x1
	// Position of RXIE field.
	UART0_IER_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	UART0_IER_RXIE_Msk = 0x4
	// Bit RXIE.
	UART0_IER_RXIE = 0x4
	// Disable the RX line status interrupts.
	UART0_IER_RXIE_DISABLE_THE_RX_LINE_ = 0x0
	// Enable the RX line status interrupts.
	UART0_IER_RXIE_ENABLE_THE_RX_LINE_S = 0x1
	// Position of RESERVED field.
	UART0_IER_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART0_IER_RESERVED_Msk = 0xf8
	// Position of ABEOINTEN field.
	UART0_IER_ABEOINTEN_Pos = 0x8
	// Bit mask of ABEOINTEN field.
	UART0_IER_ABEOINTEN_Msk = 0x100
	// Bit ABEOINTEN.
	UART0_IER_ABEOINTEN = 0x100
	// Disable end of auto-baud Interrupt.
	UART0_IER_ABEOINTEN_DISABLE_END_OF_AUTO_ = 0x0
	// Enable end of auto-baud Interrupt.
	UART0_IER_ABEOINTEN_ENABLE_END_OF_AUTO_B = 0x1
	// Position of ABTOINTEN field.
	UART0_IER_ABTOINTEN_Pos = 0x9
	// Bit mask of ABTOINTEN field.
	UART0_IER_ABTOINTEN_Msk = 0x200
	// Bit ABTOINTEN.
	UART0_IER_ABTOINTEN = 0x200
	// Disable auto-baud time-out Interrupt.
	UART0_IER_ABTOINTEN_DISABLE_AUTO_BAUD_TI = 0x0
	// Enable auto-baud time-out Interrupt.
	UART0_IER_ABTOINTEN_ENABLE_AUTO_BAUD_TIM = 0x1
	// Position of RESERVED field.
	UART0_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART0_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	UART0_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	UART0_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	UART0_IIR_INTSTATUS = 0x1
	// At least one interrupt is pending.
	UART0_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0
	// No interrupt is pending.
	UART0_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1
	// Position of INTID field.
	UART0_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	UART0_IIR_INTID_Msk = 0xe
	// 1 - Receive Line Status (RLS).
	UART0_IIR_INTID_1_RECEIVE_LINE_S = 0x3
	// 2a - Receive Data Available (RDA).
	UART0_IIR_INTID_2A__RECEIVE_DATA_AV = 0x2
	// 2b - Character Time-out Indicator (CTI).
	UART0_IIR_INTID_2B__CHARACTER_TIME_ = 0x6
	// 3 - THRE Interrupt
	UART0_IIR_INTID_3_THRE_INTERRUPT = 0x1
	// Position of RESERVED field.
	UART0_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART0_IIR_RESERVED_Msk = 0x30
	// Position of FIFOENABLE field.
	UART0_IIR_FIFOENABLE_Pos = 0x6
	// Bit mask of FIFOENABLE field.
	UART0_IIR_FIFOENABLE_Msk = 0xc0
	// Position of ABEOINT field.
	UART0_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	UART0_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	UART0_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	UART0_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	UART0_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	UART0_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	UART0_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART0_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls UART FIFO usage and modes.
	// Position of FIFOEN field.
	UART0_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	UART0_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	UART0_FCR_FIFOEN = 0x1
	// UARTn FIFOs are disabled. Must not be used in the application.
	UART0_FCR_FIFOEN_UARTN_FIFOS_ARE_DISA = 0x0
	// Active high enable for both UARTn Rx and TX FIFOs and UnFCR[7:1] access. This bit must be set for proper UART operation. Any transition on this bit will automatically clear the related UART FIFOs.
	UART0_FCR_FIFOEN_ACTIVE_HIGH_ENABLE_F = 0x1
	// Position of RXFIFORES field.
	UART0_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	UART0_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	UART0_FCR_RXFIFORES = 0x2
	// No impact on either of UARTn FIFOs.
	UART0_FCR_RXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0
	// Writing a logic 1 to UnFCR[1] will clear all bytes in UARTn Rx FIFO, reset the pointer logic. This bit is self-clearing.
	UART0_FCR_RXFIFORES_WRITING_A_LOGIC_1_TO = 0x1
	// Position of TXFIFORES field.
	UART0_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	UART0_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	UART0_FCR_TXFIFORES = 0x4
	// No impact on either of UARTn FIFOs.
	UART0_FCR_TXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0
	// Writing a logic 1 to UnFCR[2] will clear all bytes in UARTn TX FIFO, reset the pointer logic. This bit is self-clearing.
	UART0_FCR_TXFIFORES_WRITING_A_LOGIC_1_TO = 0x1
	// Position of DMAMODE field.
	UART0_FCR_DMAMODE_Pos = 0x3
	// Bit mask of DMAMODE field.
	UART0_FCR_DMAMODE_Msk = 0x8
	// Bit DMAMODE.
	UART0_FCR_DMAMODE = 0x8
	// Position of RESERVED field.
	UART0_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART0_FCR_RESERVED_Msk = 0x30
	// Position of RXTRIGLVL field.
	UART0_FCR_RXTRIGLVL_Pos = 0x6
	// Bit mask of RXTRIGLVL field.
	UART0_FCR_RXTRIGLVL_Msk = 0xc0
	// Trigger level 0 (1 character or 0x01).
	UART0_FCR_RXTRIGLVL_TRIGGER_LEVEL_0_1_C = 0x0
	// Trigger level 1 (4 characters or 0x04).
	UART0_FCR_RXTRIGLVL_TRIGGER_LEVEL_1_4_C = 0x1
	// Trigger level 2 (8 characters or 0x08).
	UART0_FCR_RXTRIGLVL_TRIGGER_LEVEL_2_8_C = 0x2
	// Trigger level 3 (14 characters or 0x0E).
	UART0_FCR_RXTRIGLVL_TRIGGER_LEVEL_3_14_ = 0x3
	// Position of RESERVED field.
	UART0_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	UART0_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	UART0_LCR_WLS_Msk = 0x3
	// 5-bit character length
	UART0_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length
	UART0_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length
	UART0_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length
	UART0_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	UART0_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	UART0_LCR_SBS_Msk = 0x4
	// Bit SBS.
	UART0_LCR_SBS = 0x4
	// 1 stop bit.
	UART0_LCR_SBS_1_STOP_BIT_ = 0x0
	// 2 stop bits (1.5 if UnLCR[1:0]=00).
	UART0_LCR_SBS_2_STOP_BITS_1_5_IF_ = 0x1
	// Position of PE field.
	UART0_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	UART0_LCR_PE_Msk = 0x8
	// Bit PE.
	UART0_LCR_PE = 0x8
	// Disable parity generation and checking.
	UART0_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	UART0_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	UART0_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	UART0_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	UART0_LCR_PS_ODD_PARITY_NUMBER_O = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	UART0_LCR_PS_EVEN_PARITY_NUMBER_ = 0x1
	// Forced 1 stick parity.
	UART0_LCR_PS_FORCED_1_STICK_PARIT = 0x2
	// Forced 0 stick parity.
	UART0_LCR_PS_FORCED_0_STICK_PARIT = 0x3
	// Position of BC field.
	UART0_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	UART0_LCR_BC_Msk = 0x40
	// Bit BC.
	UART0_LCR_BC = 0x40
	// Disable break transmission.
	UART0_LCR_BC_DISABLE_BREAK_TRANSM = 0x0
	// Enable break transmission. Output pin UARTn TXD is forced to logic 0 when UnLCR[6] is active high.
	UART0_LCR_BC_ENABLE_BREAK_TRANSMI = 0x1
	// Position of DLAB field.
	UART0_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	UART0_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	UART0_LCR_DLAB = 0x80
	// Disable access to Divisor Latches.
	UART0_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0
	// Enable access to Divisor Latches.
	UART0_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1
	// Position of RESERVED field.
	UART0_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_LCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	UART0_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	UART0_LSR_RDR_Msk = 0x1
	// Bit RDR.
	UART0_LSR_RDR = 0x1
	// The UARTn receiver FIFO is empty.
	UART0_LSR_RDR_EMPTY = 0x0
	// The UARTn receiver FIFO is not empty.
	UART0_LSR_RDR_NOTEMPTY = 0x1
	// Position of OE field.
	UART0_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	UART0_LSR_OE_Msk = 0x2
	// Bit OE.
	UART0_LSR_OE = 0x2
	// Overrun error status is inactive.
	UART0_LSR_OE_INACTIVE = 0x0
	// Overrun error status is active.
	UART0_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	UART0_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	UART0_LSR_PE_Msk = 0x4
	// Bit PE.
	UART0_LSR_PE = 0x4
	// Parity error status is inactive.
	UART0_LSR_PE_INACTIVE = 0x0
	// Parity error status is active.
	UART0_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	UART0_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	UART0_LSR_FE_Msk = 0x8
	// Bit FE.
	UART0_LSR_FE = 0x8
	// Framing error status is inactive.
	UART0_LSR_FE_INACTIVE = 0x0
	// Framing error status is active.
	UART0_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	UART0_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	UART0_LSR_BI_Msk = 0x10
	// Bit BI.
	UART0_LSR_BI = 0x10
	// Break interrupt status is inactive.
	UART0_LSR_BI_INACTIVE = 0x0
	// Break interrupt status is active.
	UART0_LSR_BI_ACTIVE = 0x1
	// Position of THRE field.
	UART0_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	UART0_LSR_THRE_Msk = 0x20
	// Bit THRE.
	UART0_LSR_THRE = 0x20
	// UnTHR contains valid data.
	UART0_LSR_THRE_VALIDDATA = 0x0
	// UnTHR is empty.
	UART0_LSR_THRE_EMPTY = 0x1
	// Position of TEMT field.
	UART0_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	UART0_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	UART0_LSR_TEMT = 0x40
	// UnTHR and/or the UnTSR contains valid data.
	UART0_LSR_TEMT_VALIDDATA = 0x0
	// UnTHR and the UnTSR are empty.
	UART0_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	UART0_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	UART0_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	UART0_LSR_RXFE = 0x80
	// UnRBR contains no UARTn RX errors or UnFCR[0]=0.
	UART0_LSR_RXFE_NOERROR = 0x0
	// UARTn RBR contains at least one UARTn RX error.
	UART0_LSR_RXFE_ERRORS = 0x1
	// Position of RESERVED field.
	UART0_LSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_LSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. 8-bit temporary storage for software.
	// Position of PAD field.
	UART0_SCR_PAD_Pos = 0x0
	// Bit mask of PAD field.
	UART0_SCR_PAD_Msk = 0xff
	// Position of RESERVED field.
	UART0_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	UART0_ACR_START_Pos = 0x0
	// Bit mask of START field.
	UART0_ACR_START_Msk = 0x1
	// Bit START.
	UART0_ACR_START = 0x1
	// Auto-baud stop (auto-baud is not running).
	UART0_ACR_START_AUTO_BAUD_STOP_AUTO = 0x0
	// Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	UART0_ACR_START_AUTO_BAUD_START_AUT = 0x1
	// Position of MODE field.
	UART0_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	UART0_ACR_MODE_Msk = 0x2
	// Bit MODE.
	UART0_ACR_MODE = 0x2
	// Mode 0.
	UART0_ACR_MODE_MODE_0_ = 0x0
	// Mode 1.
	UART0_ACR_MODE_MODE_1_ = 0x1
	// Position of AUTORESTART field.
	UART0_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	UART0_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	UART0_ACR_AUTORESTART = 0x4
	// No restart.
	UART0_ACR_AUTORESTART_NO_RESTART_ = 0x0
	// Restart in case of time-out (counter restarts at next UARTn Rx falling edge)
	UART0_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1
	// Position of RESERVED field.
	UART0_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART0_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	UART0_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	UART0_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	UART0_ACR_ABEOINTCLR = 0x100
	// No impact.
	UART0_ACR_ABEOINTCLR_NO_IMPACT_ = 0x0
	// Clear the corresponding interrupt in the IIR.
	UART0_ACR_ABEOINTCLR_CLEAR_THE_CORRESPOND = 0x1
	// Position of ABTOINTCLR field.
	UART0_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	UART0_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	UART0_ACR_ABTOINTCLR = 0x200
	// No impact.
	UART0_ACR_ABTOINTCLR_NO_IMPACT_ = 0x0
	// Clear the corresponding interrupt in the IIR.
	UART0_ACR_ABTOINTCLR_CLEAR_THE_CORRESPOND = 0x1
	// Position of RESERVED field.
	UART0_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART0_ACR_RESERVED_Msk = 0xfffffc00

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	UART0_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	UART0_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	UART0_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	UART0_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	UART0_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_FDR_RESERVED_Msk = 0xffffff00

	// TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
	// Position of RESERVED field.
	UART0_TER_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	UART0_TER_RESERVED_Msk = 0x7f
	// Position of TXEN field.
	UART0_TER_TXEN_Pos = 0x7
	// Bit mask of TXEN field.
	UART0_TER_TXEN_Msk = 0x80
	// Bit TXEN.
	UART0_TER_TXEN = 0x80
	// Position of RESERVED field.
	UART0_TER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_TER_RESERVED_Msk = 0xffffff00

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	UART0_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	UART0_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	UART0_RS485CTRL_NMMEN = 0x1
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	UART0_RS485CTRL_NMMEN_DISABLED = 0x0
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte has the parity bit = 1, generating a received data interrupt. See Section 18.6.16 RS-485/EIA-485 modes of operation.
	UART0_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	UART0_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	UART0_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	UART0_RS485CTRL_RXDIS = 0x2
	// The receiver is enabled.
	UART0_RS485CTRL_RXDIS_ENABLED = 0x0
	// The receiver is disabled.
	UART0_RS485CTRL_RXDIS_DISABLED = 0x1
	// Position of AADEN field.
	UART0_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	UART0_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	UART0_RS485CTRL_AADEN = 0x4
	// Auto Address Detect (AAD) is disabled.
	UART0_RS485CTRL_AADEN_DISABLED = 0x0
	// Auto Address Detect (AAD) is enabled.
	UART0_RS485CTRL_AADEN_ENABLED = 0x1
	// Position of RESERVED field.
	UART0_RS485CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART0_RS485CTRL_RESERVED_Msk = 0x8
	// Bit RESERVED.
	UART0_RS485CTRL_RESERVED = 0x8
	// Position of DCTRL field.
	UART0_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	UART0_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	UART0_RS485CTRL_DCTRL = 0x10
	// Disable Auto Direction Control.
	UART0_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0
	// Enable Auto Direction Control.
	UART0_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1
	// Position of OINV field.
	UART0_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	UART0_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	UART0_RS485CTRL_OINV = 0x20
	// The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	UART0_RS485CTRL_OINV_DIRLOW = 0x0
	// The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	UART0_RS485CTRL_OINV_DIRHIGH = 0x1
	// Position of RESERVED field.
	UART0_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	UART0_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	UART0_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	UART0_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	UART0_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	UART0_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	UART0_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	UART0_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART0_RS485DLY_RESERVED_Msk = 0xffffff00
)

// Bitfields for UART1: UART1
const (
	// RBR: DLAB =0 Receiver Buffer Register. Contains the next received character to be read.
	// Position of RBR field.
	UART1_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	UART1_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	UART1_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_RBR_RESERVED_Msk = 0xffffff00

	// THR: DLAB =0. Transmit Holding Register. The next character to be transmitted is written here.
	// Position of THR field.
	UART1_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	UART1_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	UART1_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_THR_RESERVED_Msk = 0xffffff00

	// DLL: DLAB =1. Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider.
	// Position of DLLSB field.
	UART1_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	UART1_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	UART1_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_DLL_RESERVED_Msk = 0xffffff00

	// DLM: DLAB =1. Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider.
	// Position of DLMSB field.
	UART1_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	UART1_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	UART1_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_DLM_RESERVED_Msk = 0xffffff00

	// IER: DLAB =0. Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART1 interrupts.
	// Position of RBRIE field.
	UART1_IER_RBRIE_Pos = 0x0
	// Bit mask of RBRIE field.
	UART1_IER_RBRIE_Msk = 0x1
	// Bit RBRIE.
	UART1_IER_RBRIE = 0x1
	// Disable the RDA interrupts.
	UART1_IER_RBRIE_DISABLE_THE_RDA_INTE = 0x0
	// Enable the RDA interrupts.
	UART1_IER_RBRIE_ENABLE_THE_RDA_INTER = 0x1
	// Position of THREIE field.
	UART1_IER_THREIE_Pos = 0x1
	// Bit mask of THREIE field.
	UART1_IER_THREIE_Msk = 0x2
	// Bit THREIE.
	UART1_IER_THREIE = 0x2
	// Disable the THRE interrupts.
	UART1_IER_THREIE_DISABLE_THE_THRE_INT = 0x0
	// Enable the THRE interrupts.
	UART1_IER_THREIE_ENABLE_THE_THRE_INTE = 0x1
	// Position of RXIE field.
	UART1_IER_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	UART1_IER_RXIE_Msk = 0x4
	// Bit RXIE.
	UART1_IER_RXIE = 0x4
	// Disable the RX line status interrupts.
	UART1_IER_RXIE_DISABLE_THE_RX_LINE_ = 0x0
	// Enable the RX line status interrupts.
	UART1_IER_RXIE_ENABLE_THE_RX_LINE_S = 0x1
	// Position of MSIE field.
	UART1_IER_MSIE_Pos = 0x3
	// Bit mask of MSIE field.
	UART1_IER_MSIE_Msk = 0x8
	// Bit MSIE.
	UART1_IER_MSIE = 0x8
	// Disable the modem interrupt.
	UART1_IER_MSIE_DISABLE_THE_MODEM_IN = 0x0
	// Enable the modem interrupt.
	UART1_IER_MSIE_ENABLE_THE_MODEM_INT = 0x1
	// Position of RESERVED field.
	UART1_IER_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART1_IER_RESERVED_Msk = 0x70
	// Position of CTSIE field.
	UART1_IER_CTSIE_Pos = 0x7
	// Bit mask of CTSIE field.
	UART1_IER_CTSIE_Msk = 0x80
	// Bit CTSIE.
	UART1_IER_CTSIE = 0x80
	// Disable the CTS interrupt.
	UART1_IER_CTSIE_DISABLE_THE_CTS_INTE = 0x0
	// Enable the CTS interrupt.
	UART1_IER_CTSIE_ENABLE_THE_CTS_INTER = 0x1
	// Position of ABEOIE field.
	UART1_IER_ABEOIE_Pos = 0x8
	// Bit mask of ABEOIE field.
	UART1_IER_ABEOIE_Msk = 0x100
	// Bit ABEOIE.
	UART1_IER_ABEOIE = 0x100
	// Disable end of auto-baud Interrupt.
	UART1_IER_ABEOIE_DISABLE_END_OF_AUTO_ = 0x0
	// Enable end of auto-baud Interrupt.
	UART1_IER_ABEOIE_ENABLE_END_OF_AUTO_B = 0x1
	// Position of ABTOIE field.
	UART1_IER_ABTOIE_Pos = 0x9
	// Bit mask of ABTOIE field.
	UART1_IER_ABTOIE_Msk = 0x200
	// Bit ABTOIE.
	UART1_IER_ABTOIE = 0x200
	// Disable auto-baud time-out Interrupt.
	UART1_IER_ABTOIE_DISABLE_AUTO_BAUD_TI = 0x0
	// Enable auto-baud time-out Interrupt.
	UART1_IER_ABTOIE_ENABLE_AUTO_BAUD_TIM = 0x1
	// Position of RESERVED field.
	UART1_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART1_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	UART1_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	UART1_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	UART1_IIR_INTSTATUS = 0x1
	// At least one interrupt is pending.
	UART1_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0
	// No interrupt is pending.
	UART1_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1
	// Position of INTID field.
	UART1_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	UART1_IIR_INTID_Msk = 0xe
	// 1 - Receive Line Status (RLS).
	UART1_IIR_INTID_RLS = 0x3
	// 2a - Receive Data Available (RDA).
	UART1_IIR_INTID_RDA = 0x2
	// 2b - Character Time-out Indicator (CTI).
	UART1_IIR_INTID_CTI = 0x6
	// 3 - THRE Interrupt.
	UART1_IIR_INTID_THRE = 0x1
	// 4 - Modem Interrupt.
	UART1_IIR_INTID_MODEM = 0x0
	// Position of RESERVED field.
	UART1_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART1_IIR_RESERVED_Msk = 0x30
	// Position of FIFOENABLE field.
	UART1_IIR_FIFOENABLE_Pos = 0x6
	// Bit mask of FIFOENABLE field.
	UART1_IIR_FIFOENABLE_Msk = 0xc0
	// Position of ABEOINT field.
	UART1_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	UART1_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	UART1_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	UART1_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	UART1_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	UART1_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	UART1_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART1_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls UART1 FIFO usage and modes.
	// Position of FIFOEN field.
	UART1_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	UART1_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	UART1_FCR_FIFOEN = 0x1
	// Must not be used in the application.
	UART1_FCR_FIFOEN_MUST_NOT_BE_USED_IN_ = 0x0
	// Active high enable for both UART1 Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper UART1 operation. Any transition on this bit will automatically clear the UART1 FIFOs.
	UART1_FCR_FIFOEN_ACTIVE_HIGH_ENABLE_F = 0x1
	// Position of RXFIFORES field.
	UART1_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	UART1_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	UART1_FCR_RXFIFORES = 0x2
	// No impact on either of UART1 FIFOs.
	UART1_FCR_RXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0
	// Writing a logic 1 to FCR[1] will clear all bytes in UART1 Rx FIFO, reset the pointer logic. This bit is self-clearing.
	UART1_FCR_RXFIFORES_WRITING_A_LOGIC_1_TO = 0x1
	// Position of TXFIFORES field.
	UART1_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	UART1_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	UART1_FCR_TXFIFORES = 0x4
	// No impact on either of UART1 FIFOs.
	UART1_FCR_TXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0
	// Writing a logic 1 to FCR[2] will clear all bytes in UART1 TX FIFO, reset the pointer logic. This bit is self-clearing.
	UART1_FCR_TXFIFORES_WRITING_A_LOGIC_1_TO = 0x1
	// Position of DMAMODE field.
	UART1_FCR_DMAMODE_Pos = 0x3
	// Bit mask of DMAMODE field.
	UART1_FCR_DMAMODE_Msk = 0x8
	// Bit DMAMODE.
	UART1_FCR_DMAMODE = 0x8
	// Position of RESERVED field.
	UART1_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART1_FCR_RESERVED_Msk = 0x30
	// Position of RXTRIGLVL field.
	UART1_FCR_RXTRIGLVL_Pos = 0x6
	// Bit mask of RXTRIGLVL field.
	UART1_FCR_RXTRIGLVL_Msk = 0xc0
	// Trigger level 0 (1 character or 0x01).
	UART1_FCR_RXTRIGLVL_TRIGGER_LEVEL_0_1_C = 0x0
	// Trigger level 1 (4 characters or 0x04).
	UART1_FCR_RXTRIGLVL_TRIGGER_LEVEL_1_4_C = 0x1
	// Trigger level 2 (8 characters or 0x08).
	UART1_FCR_RXTRIGLVL_TRIGGER_LEVEL_2_8_C = 0x2
	// Trigger level 3 (14 characters or 0x0E).
	UART1_FCR_RXTRIGLVL_TRIGGER_LEVEL_3_14_ = 0x3
	// Position of RESERVED field.
	UART1_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	UART1_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	UART1_LCR_WLS_Msk = 0x3
	// 5-bit character length.
	UART1_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length.
	UART1_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length.
	UART1_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length.
	UART1_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	UART1_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	UART1_LCR_SBS_Msk = 0x4
	// Bit SBS.
	UART1_LCR_SBS = 0x4
	// 1 stop bit.
	UART1_LCR_SBS_1_STOP_BIT_ = 0x0
	// 2 stop bits (1.5 if LCR[1:0]=00).
	UART1_LCR_SBS_2_STOP_BITS_1_5_IF_ = 0x1
	// Position of PE field.
	UART1_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	UART1_LCR_PE_Msk = 0x8
	// Bit PE.
	UART1_LCR_PE = 0x8
	// Disable parity generation and checking.
	UART1_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	UART1_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	UART1_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	UART1_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	UART1_LCR_PS_ODD_PARITY_NUMBER_O = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	UART1_LCR_PS_EVEN_PARITY_NUMBER_ = 0x1
	// Forced 1 stick parity.
	UART1_LCR_PS_FORCED1STICK_PAR = 0x2
	// Forced 0 stick parity.
	UART1_LCR_PS_FORCED0STICK_PAR = 0x3
	// Position of BC field.
	UART1_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	UART1_LCR_BC_Msk = 0x40
	// Bit BC.
	UART1_LCR_BC = 0x40
	// Disable break transmission.
	UART1_LCR_BC_DISABLE_BREAK_TRANSM = 0x0
	// Enable break transmission. Output pin UART1 TXD is forced to logic 0 when LCR[6] is active high.
	UART1_LCR_BC_ENABLE_BREAK_TRANSMI = 0x1
	// Position of DLAB field.
	UART1_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	UART1_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	UART1_LCR_DLAB = 0x80
	// Disable access to Divisor Latches.
	UART1_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0
	// Enable access to Divisor Latches.
	UART1_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1
	// Position of RESERVED field.
	UART1_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_LCR_RESERVED_Msk = 0xffffff00

	// MCR: Modem Control Register. Contains controls for flow control handshaking and loopback mode.
	// Position of DTRCTRL field.
	UART1_MCR_DTRCTRL_Pos = 0x0
	// Bit mask of DTRCTRL field.
	UART1_MCR_DTRCTRL_Msk = 0x1
	// Bit DTRCTRL.
	UART1_MCR_DTRCTRL = 0x1
	// Position of RTSCTRL field.
	UART1_MCR_RTSCTRL_Pos = 0x1
	// Bit mask of RTSCTRL field.
	UART1_MCR_RTSCTRL_Msk = 0x2
	// Bit RTSCTRL.
	UART1_MCR_RTSCTRL = 0x2
	// Position of RESERVED field.
	UART1_MCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	UART1_MCR_RESERVED_Msk = 0xc
	// Position of LMS field.
	UART1_MCR_LMS_Pos = 0x4
	// Bit mask of LMS field.
	UART1_MCR_LMS_Msk = 0x10
	// Bit LMS.
	UART1_MCR_LMS = 0x10
	// Disable modem loopback mode.
	UART1_MCR_LMS_DISABLE_MODEM_LOOPBA = 0x0
	// Enable modem loopback mode.
	UART1_MCR_LMS_ENABLE_MODEM_LOOPBAC = 0x1
	// Position of RESERVED field.
	UART1_MCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	UART1_MCR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	UART1_MCR_RESERVED = 0x20
	// Position of RTSEN field.
	UART1_MCR_RTSEN_Pos = 0x6
	// Bit mask of RTSEN field.
	UART1_MCR_RTSEN_Msk = 0x40
	// Bit RTSEN.
	UART1_MCR_RTSEN = 0x40
	// Disable auto-rts flow control.
	UART1_MCR_RTSEN_DISABLE_AUTO_RTS_FLO = 0x0
	// Enable auto-rts flow control.
	UART1_MCR_RTSEN_ENABLE_AUTO_RTS_FLOW = 0x1
	// Position of CTSEN field.
	UART1_MCR_CTSEN_Pos = 0x7
	// Bit mask of CTSEN field.
	UART1_MCR_CTSEN_Msk = 0x80
	// Bit CTSEN.
	UART1_MCR_CTSEN = 0x80
	// Disable auto-cts flow control.
	UART1_MCR_CTSEN_DISABLE_AUTO_CTS_FLO = 0x0
	// Enable auto-cts flow control.
	UART1_MCR_CTSEN_ENABLE_AUTO_CTS_FLOW = 0x1
	// Position of RESERVED field.
	UART1_MCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_MCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	UART1_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	UART1_LSR_RDR_Msk = 0x1
	// Bit RDR.
	UART1_LSR_RDR = 0x1
	// The UART1 receiver FIFO is empty.
	UART1_LSR_RDR_EMPTY = 0x0
	// The UART1 receiver FIFO is not empty.
	UART1_LSR_RDR_NOTEMPTY = 0x1
	// Position of OE field.
	UART1_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	UART1_LSR_OE_Msk = 0x2
	// Bit OE.
	UART1_LSR_OE = 0x2
	// Overrun error status is inactive.
	UART1_LSR_OE_INACTIVE = 0x0
	// Overrun error status is active.
	UART1_LSR_OE_ACTIVE = 0x1
	// Position of PE field.
	UART1_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	UART1_LSR_PE_Msk = 0x4
	// Bit PE.
	UART1_LSR_PE = 0x4
	// Parity error status is inactive.
	UART1_LSR_PE_INACTIVE = 0x0
	// Parity error status is active.
	UART1_LSR_PE_ACTIVE = 0x1
	// Position of FE field.
	UART1_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	UART1_LSR_FE_Msk = 0x8
	// Bit FE.
	UART1_LSR_FE = 0x8
	// Framing error status is inactive.
	UART1_LSR_FE_INACTIVE = 0x0
	// Framing error status is active.
	UART1_LSR_FE_ACTIVE = 0x1
	// Position of BI field.
	UART1_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	UART1_LSR_BI_Msk = 0x10
	// Bit BI.
	UART1_LSR_BI = 0x10
	// Break interrupt status is inactive.
	UART1_LSR_BI_INACTIVE = 0x0
	// Break interrupt status is active.
	UART1_LSR_BI_ACTIVE = 0x1
	// Position of THRE field.
	UART1_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	UART1_LSR_THRE_Msk = 0x20
	// Bit THRE.
	UART1_LSR_THRE = 0x20
	// THR contains valid data.
	UART1_LSR_THRE_VALID = 0x0
	// THR is empty.
	UART1_LSR_THRE_THR_IS_EMPTY_ = 0x1
	// Position of TEMT field.
	UART1_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	UART1_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	UART1_LSR_TEMT = 0x40
	// THR and/or the TSR contains valid data.
	UART1_LSR_TEMT_VALID = 0x0
	// THR and the TSR are empty.
	UART1_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	UART1_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	UART1_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	UART1_LSR_RXFE = 0x80
	// RBR contains no UART1 RX errors or FCR[0]=0.
	UART1_LSR_RXFE_NOERROR = 0x0
	// UART1 RBR contains at least one UART1 RX error.
	UART1_LSR_RXFE_ERRORS = 0x1
	// Position of RESERVED field.
	UART1_LSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_LSR_RESERVED_Msk = 0xffffff00

	// MSR: Modem Status Register. Contains handshake signal status flags.
	// Position of DCTS field.
	UART1_MSR_DCTS_Pos = 0x0
	// Bit mask of DCTS field.
	UART1_MSR_DCTS_Msk = 0x1
	// Bit DCTS.
	UART1_MSR_DCTS = 0x1
	// No change detected on modem input, CTS.
	UART1_MSR_DCTS_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, CTS.
	UART1_MSR_DCTS_STATE_CHANGE_DETECTE = 0x1
	// Position of DDSR field.
	UART1_MSR_DDSR_Pos = 0x1
	// Bit mask of DDSR field.
	UART1_MSR_DDSR_Msk = 0x2
	// Bit DDSR.
	UART1_MSR_DDSR = 0x2
	// No change detected on modem input, DSR.
	UART1_MSR_DDSR_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DSR.
	UART1_MSR_DDSR_STATE_CHANGE_DETECTE = 0x1
	// Position of TERI field.
	UART1_MSR_TERI_Pos = 0x2
	// Bit mask of TERI field.
	UART1_MSR_TERI_Msk = 0x4
	// Bit TERI.
	UART1_MSR_TERI = 0x4
	// No change detected on modem input, RI.
	UART1_MSR_TERI_NO_CHANGE_DETECTED_O = 0x0
	// Low-to-high transition detected on RI.
	UART1_MSR_TERI_LOW_TO_HIGH_TRANSITI = 0x1
	// Position of DDCD field.
	UART1_MSR_DDCD_Pos = 0x3
	// Bit mask of DDCD field.
	UART1_MSR_DDCD_Msk = 0x8
	// Bit DDCD.
	UART1_MSR_DDCD = 0x8
	// No change detected on modem input, DCD.
	UART1_MSR_DDCD_NO_CHANGE_DETECTED_O = 0x0
	// State change detected on modem input, DCD.
	UART1_MSR_DDCD_STATE_CHANGE_DETECTE = 0x1
	// Position of CTS field.
	UART1_MSR_CTS_Pos = 0x4
	// Bit mask of CTS field.
	UART1_MSR_CTS_Msk = 0x10
	// Bit CTS.
	UART1_MSR_CTS = 0x10
	// Position of DSR field.
	UART1_MSR_DSR_Pos = 0x5
	// Bit mask of DSR field.
	UART1_MSR_DSR_Msk = 0x20
	// Bit DSR.
	UART1_MSR_DSR = 0x20
	// Position of RI field.
	UART1_MSR_RI_Pos = 0x6
	// Bit mask of RI field.
	UART1_MSR_RI_Msk = 0x40
	// Bit RI.
	UART1_MSR_RI = 0x40
	// Position of DCD field.
	UART1_MSR_DCD_Pos = 0x7
	// Bit mask of DCD field.
	UART1_MSR_DCD_Msk = 0x80
	// Bit DCD.
	UART1_MSR_DCD = 0x80
	// Position of RESERVED field.
	UART1_MSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_MSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. 8-bit temporary storage for software.
	// Position of Pad field.
	UART1_SCR_Pad_Pos = 0x0
	// Bit mask of Pad field.
	UART1_SCR_Pad_Msk = 0xff
	// Position of RESERVED field.
	UART1_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	UART1_ACR_START_Pos = 0x0
	// Bit mask of START field.
	UART1_ACR_START_Msk = 0x1
	// Bit START.
	UART1_ACR_START = 0x1
	// Auto-baud stop (auto-baud is not running).
	UART1_ACR_START_STOP = 0x0
	// Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	UART1_ACR_START_START = 0x1
	// Position of MODE field.
	UART1_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	UART1_ACR_MODE_Msk = 0x2
	// Bit MODE.
	UART1_ACR_MODE = 0x2
	// Mode 0.
	UART1_ACR_MODE_MODE_0_ = 0x0
	// Mode 1.
	UART1_ACR_MODE_MODE_1_ = 0x1
	// Position of AUTORESTART field.
	UART1_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	UART1_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	UART1_ACR_AUTORESTART = 0x4
	// No restart
	UART1_ACR_AUTORESTART_NO_RESTART = 0x0
	// Restart in case of time-out (counter restarts at next UART1 Rx falling edge)
	UART1_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1
	// Position of RESERVED field.
	UART1_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART1_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	UART1_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	UART1_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	UART1_ACR_ABEOINTCLR = 0x100
	// Writing a 0 has no impact.
	UART1_ACR_ABEOINTCLR_WRITING_A_0_HAS_NO_I = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	UART1_ACR_ABEOINTCLR_WRITING_A_1_WILL_CLE = 0x1
	// Position of ABTOINTCLR field.
	UART1_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	UART1_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	UART1_ACR_ABTOINTCLR = 0x200
	// Writing a 0 has no impact.
	UART1_ACR_ABTOINTCLR_WRITING_A_0_HAS_NO_I = 0x0
	// Writing a 1 will clear the corresponding interrupt in the IIR.
	UART1_ACR_ABTOINTCLR_WRITING_A_1_WILL_CLE = 0x1
	// Position of RESERVED field.
	UART1_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART1_ACR_RESERVED_Msk = 0xfffffc00

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	UART1_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	UART1_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	UART1_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	UART1_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	UART1_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_FDR_RESERVED_Msk = 0xffffff00

	// TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
	// Position of RESERVED field.
	UART1_TER_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	UART1_TER_RESERVED_Msk = 0x7f
	// Position of TXEN field.
	UART1_TER_TXEN_Pos = 0x7
	// Bit mask of TXEN field.
	UART1_TER_TXEN_Msk = 0x80
	// Bit TXEN.
	UART1_TER_TXEN = 0x80
	// Position of RESERVED field.
	UART1_TER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_TER_RESERVED_Msk = 0xffffff00

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	UART1_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	UART1_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	UART1_RS485CTRL_NMMEN = 0x1
	// Disabled.
	UART1_RS485CTRL_NMMEN_DISABLED_ = 0x0
	// Enabled. In this mode, an address is detected when a received byte causes the UART to set the parity error and generate an interrupt.
	UART1_RS485CTRL_NMMEN_ENABLED_IN_THIS_MOD = 0x1
	// Position of RXDIS field.
	UART1_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	UART1_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	UART1_RS485CTRL_RXDIS = 0x2
	// Enabled.
	UART1_RS485CTRL_RXDIS_ENABLED_ = 0x0
	// Disabled.
	UART1_RS485CTRL_RXDIS_DISABLED_ = 0x1
	// Position of AADEN field.
	UART1_RS485CTRL_AADEN_Pos = 0x2
	// Bit mask of AADEN field.
	UART1_RS485CTRL_AADEN_Msk = 0x4
	// Bit AADEN.
	UART1_RS485CTRL_AADEN = 0x4
	// Disabled.
	UART1_RS485CTRL_AADEN_DISABLED_ = 0x0
	// Enabled.
	UART1_RS485CTRL_AADEN_ENABLED_ = 0x1
	// Position of SEL field.
	UART1_RS485CTRL_SEL_Pos = 0x3
	// Bit mask of SEL field.
	UART1_RS485CTRL_SEL_Msk = 0x8
	// Bit SEL.
	UART1_RS485CTRL_SEL = 0x8
	// RTS. If direction control is enabled (bit DCTRL = 1), pin RTS is used for direction control.
	UART1_RS485CTRL_SEL_RTS_IF_DIRECTION_CO = 0x0
	// DTR. If direction control is enabled (bit DCTRL = 1), pin DTR is used for direction control.
	UART1_RS485CTRL_SEL_DTR_IF_DIRECTION_CO = 0x1
	// Position of DCTRL field.
	UART1_RS485CTRL_DCTRL_Pos = 0x4
	// Bit mask of DCTRL field.
	UART1_RS485CTRL_DCTRL_Msk = 0x10
	// Bit DCTRL.
	UART1_RS485CTRL_DCTRL = 0x10
	// Disable Auto Direction Control.
	UART1_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0
	// Enable Auto Direction Control.
	UART1_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1
	// Position of OINV field.
	UART1_RS485CTRL_OINV_Pos = 0x5
	// Bit mask of OINV field.
	UART1_RS485CTRL_OINV_Msk = 0x20
	// Bit OINV.
	UART1_RS485CTRL_OINV = 0x20
	// LOW. The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	UART1_RS485CTRL_OINV_LOW_THE_DIRECTION_C = 0x0
	// HIGH. The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	UART1_RS485CTRL_OINV_HIGH_THE_DIRECTION_ = 0x1
	// Position of RESERVED field.
	UART1_RS485CTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	UART1_RS485CTRL_RESERVED_Msk = 0xffffffc0

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	// Position of ADRMATCH field.
	UART1_RS485ADRMATCH_ADRMATCH_Pos = 0x0
	// Bit mask of ADRMATCH field.
	UART1_RS485ADRMATCH_ADRMATCH_Msk = 0xff
	// Position of RESERVED field.
	UART1_RS485ADRMATCH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_RS485ADRMATCH_RESERVED_Msk = 0xffffff00

	// RS485DLY: RS-485/EIA-485 direction control delay.
	// Position of DLY field.
	UART1_RS485DLY_DLY_Pos = 0x0
	// Bit mask of DLY field.
	UART1_RS485DLY_DLY_Msk = 0xff
	// Position of RESERVED field.
	UART1_RS485DLY_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART1_RS485DLY_RESERVED_Msk = 0xffffff00
)

// Bitfields for PWM0: Pulse Width Modulators (PWM0/1)
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts, or read to identify which PWM interrupt sources are pending.
	// Position of PWMMR0INT field.
	PWM_IR_PWMMR0INT_Pos = 0x0
	// Bit mask of PWMMR0INT field.
	PWM_IR_PWMMR0INT_Msk = 0x1
	// Bit PWMMR0INT.
	PWM_IR_PWMMR0INT = 0x1
	// Position of PWMMR1INT field.
	PWM_IR_PWMMR1INT_Pos = 0x1
	// Bit mask of PWMMR1INT field.
	PWM_IR_PWMMR1INT_Msk = 0x2
	// Bit PWMMR1INT.
	PWM_IR_PWMMR1INT = 0x2
	// Position of PWMMR2INT field.
	PWM_IR_PWMMR2INT_Pos = 0x2
	// Bit mask of PWMMR2INT field.
	PWM_IR_PWMMR2INT_Msk = 0x4
	// Bit PWMMR2INT.
	PWM_IR_PWMMR2INT = 0x4
	// Position of PWMMR3INT field.
	PWM_IR_PWMMR3INT_Pos = 0x3
	// Bit mask of PWMMR3INT field.
	PWM_IR_PWMMR3INT_Msk = 0x8
	// Bit PWMMR3INT.
	PWM_IR_PWMMR3INT = 0x8
	// Position of PWMCAP0INT field.
	PWM_IR_PWMCAP0INT_Pos = 0x4
	// Bit mask of PWMCAP0INT field.
	PWM_IR_PWMCAP0INT_Msk = 0x10
	// Bit PWMCAP0INT.
	PWM_IR_PWMCAP0INT = 0x10
	// Position of PWMCAP1INT field.
	PWM_IR_PWMCAP1INT_Pos = 0x5
	// Bit mask of PWMCAP1INT field.
	PWM_IR_PWMCAP1INT_Msk = 0x20
	// Bit PWMCAP1INT.
	PWM_IR_PWMCAP1INT = 0x20
	// Position of RESERVED field.
	PWM_IR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	PWM_IR_RESERVED_Msk = 0xc0
	// Position of PWMMR4INT field.
	PWM_IR_PWMMR4INT_Pos = 0x8
	// Bit mask of PWMMR4INT field.
	PWM_IR_PWMMR4INT_Msk = 0x100
	// Bit PWMMR4INT.
	PWM_IR_PWMMR4INT = 0x100
	// Position of PWMMR5INT field.
	PWM_IR_PWMMR5INT_Pos = 0x9
	// Bit mask of PWMMR5INT field.
	PWM_IR_PWMMR5INT_Msk = 0x200
	// Bit PWMMR5INT.
	PWM_IR_PWMMR5INT = 0x200
	// Position of PWMMR6INT field.
	PWM_IR_PWMMR6INT_Pos = 0xa
	// Bit mask of PWMMR6INT field.
	PWM_IR_PWMMR6INT_Msk = 0x400
	// Bit PWMMR6INT.
	PWM_IR_PWMMR6INT = 0x400
	// Position of RESERVED field.
	PWM_IR_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	PWM_IR_RESERVED_Msk = 0xfffff800

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions.
	// Position of CE field.
	PWM_TCR_CE_Pos = 0x0
	// Bit mask of CE field.
	PWM_TCR_CE_Msk = 0x1
	// Bit CE.
	PWM_TCR_CE = 0x1
	// The PWM Timer Counter and PWM Prescale Counter are enabled for counting.
	PWM_TCR_CE_THE_PWM_TIMER_COUNTE = 0x1
	// The counters are disabled.
	PWM_TCR_CE_THE_COUNTERS_ARE_DIS = 0x0
	// Position of CR field.
	PWM_TCR_CR_Pos = 0x1
	// Bit mask of CR field.
	PWM_TCR_CR_Msk = 0x2
	// Bit CR.
	PWM_TCR_CR = 0x2
	// The PWM Timer Counter and the PWM Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until this bit is returned to zero.
	PWM_TCR_CR_THE_PWM_TIMER_COUNTE = 0x1
	// Clear reset.
	PWM_TCR_CR_CLEAR_RESET_ = 0x0
	// Position of RESERVED field.
	PWM_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	PWM_TCR_RESERVED_Msk = 0x4
	// Bit RESERVED.
	PWM_TCR_RESERVED = 0x4
	// Position of PWMEN field.
	PWM_TCR_PWMEN_Pos = 0x3
	// Bit mask of PWMEN field.
	PWM_TCR_PWMEN_Msk = 0x8
	// Bit PWMEN.
	PWM_TCR_PWMEN = 0x8
	// PWM mode is enabled (counter resets to 1). PWM mode causes the shadow registers to operate in connection with the Match registers. A program write to a Match register will not have an effect on the Match result until the corresponding bit in PWMLER has been set, followed by the occurrence of a PWM Match 0 event. Note that the PWM Match register that determines the PWM rate (PWM Match Register 0 - MR0) must be set up prior to the PWM being enabled. Otherwise a Match event will not occur to cause shadow register contents to become effective.
	PWM_TCR_PWMEN_PWM_MODE_IS_ENABLED_ = 0x1
	// Timer mode is enabled (counter resets to 0).
	PWM_TCR_PWMEN_TIMER_MODE_IS_ENABLE = 0x0
	// Position of MDIS field.
	PWM_TCR_MDIS_Pos = 0x4
	// Bit mask of MDIS field.
	PWM_TCR_MDIS_Msk = 0x10
	// Bit MDIS.
	PWM_TCR_MDIS = 0x10
	// Master use. PWM0 is the master, and both PWMs are enabled for counting.
	PWM_TCR_MDIS_MASTER_USE_PWM0_IS_ = 0x1
	// Individual use. The PWMs are used independently, and the individual Counter Enable bits are used to control the PWMs.
	PWM_TCR_MDIS_INDIVIDUAL_USE_THE_ = 0x0
	// Position of RESERVED field.
	PWM_TCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	PWM_TCR_RESERVED_Msk = 0xffffffe0

	// TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TC field.
	PWM_TC_TC_Pos = 0x0
	// Bit mask of TC field.
	PWM_TC_TC_Msk = 0xffffffff

	// PR: Prescale Register. Determines how often the PWM counter is incremented.
	// Position of PM field.
	PWM_PR_PM_Pos = 0x0
	// Bit mask of PM field.
	PWM_PR_PM_Msk = 0xffffffff

	// PC: Prescale Counter. Prescaler for the main PWM counter.
	// Position of PC field.
	PWM_PC_PC_Pos = 0x0
	// Bit mask of PC field.
	PWM_PC_PC_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control whether an interrupt is generated and if the PWM counter is reset when a Match occurs.
	// Position of PWMMR0I field.
	PWM_MCR_PWMMR0I_Pos = 0x0
	// Bit mask of PWMMR0I field.
	PWM_MCR_PWMMR0I_Msk = 0x1
	// Bit PWMMR0I.
	PWM_MCR_PWMMR0I = 0x1
	// Disabled.
	PWM_MCR_PWMMR0I_DISABLED_ = 0x0
	// Interrupt on PWMMR0: an interrupt is generated when PWMMR0 matches the value in the PWMTC.
	PWM_MCR_PWMMR0I_INTERRUPT_ON_PWMMR0 = 0x1
	// Position of PWMMR0R field.
	PWM_MCR_PWMMR0R_Pos = 0x1
	// Bit mask of PWMMR0R field.
	PWM_MCR_PWMMR0R_Msk = 0x2
	// Bit PWMMR0R.
	PWM_MCR_PWMMR0R = 0x2
	// Disabled.
	PWM_MCR_PWMMR0R_DISABLED_ = 0x0
	// Reset on PWMMR0: the PWMTC will be reset if PWMMR0 matches it.
	PWM_MCR_PWMMR0R_RESET_ON_PWMMR0_THE = 0x1
	// Position of PWMMR0S field.
	PWM_MCR_PWMMR0S_Pos = 0x2
	// Bit mask of PWMMR0S field.
	PWM_MCR_PWMMR0S_Msk = 0x4
	// Bit PWMMR0S.
	PWM_MCR_PWMMR0S = 0x4
	// Disabled
	PWM_MCR_PWMMR0S_DISABLED = 0x0
	// Stop on PWMMR0: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR0 matches the PWMTC.
	PWM_MCR_PWMMR0S_STOP_ON_PWMMR0_THE_ = 0x1
	// Position of PWMMR1I field.
	PWM_MCR_PWMMR1I_Pos = 0x3
	// Bit mask of PWMMR1I field.
	PWM_MCR_PWMMR1I_Msk = 0x8
	// Bit PWMMR1I.
	PWM_MCR_PWMMR1I = 0x8
	// Disabled.
	PWM_MCR_PWMMR1I_DISABLED_ = 0x0
	// Interrupt on PWMMR1: an interrupt is generated when PWMMR1 matches the value in the PWMTC.
	PWM_MCR_PWMMR1I_INTERRUPT_ON_PWMMR1 = 0x1
	// Position of PWMMR1R field.
	PWM_MCR_PWMMR1R_Pos = 0x4
	// Bit mask of PWMMR1R field.
	PWM_MCR_PWMMR1R_Msk = 0x10
	// Bit PWMMR1R.
	PWM_MCR_PWMMR1R = 0x10
	// Disabled.
	PWM_MCR_PWMMR1R_DISABLED_ = 0x0
	// Reset on PWMMR1: the PWMTC will be reset if PWMMR1 matches it.
	PWM_MCR_PWMMR1R_RESET_ON_PWMMR1_THE = 0x1
	// Position of PWMMR1S field.
	PWM_MCR_PWMMR1S_Pos = 0x5
	// Bit mask of PWMMR1S field.
	PWM_MCR_PWMMR1S_Msk = 0x20
	// Bit PWMMR1S.
	PWM_MCR_PWMMR1S = 0x20
	// Disabled
	PWM_MCR_PWMMR1S_DISABLED = 0x0
	// Stop on PWMMR1: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR1 matches the PWMTC.
	PWM_MCR_PWMMR1S_STOP_ON_PWMMR1_THE_ = 0x1
	// Position of PWMMR2I field.
	PWM_MCR_PWMMR2I_Pos = 0x6
	// Bit mask of PWMMR2I field.
	PWM_MCR_PWMMR2I_Msk = 0x40
	// Bit PWMMR2I.
	PWM_MCR_PWMMR2I = 0x40
	// Disabled.
	PWM_MCR_PWMMR2I_DISABLED_ = 0x0
	// Interrupt on PWMMR2: an interrupt is generated when PWMMR2 matches the value in the PWMTC.
	PWM_MCR_PWMMR2I_INTERRUPT_ON_PWMMR2 = 0x1
	// Position of PWMMR2R field.
	PWM_MCR_PWMMR2R_Pos = 0x7
	// Bit mask of PWMMR2R field.
	PWM_MCR_PWMMR2R_Msk = 0x80
	// Bit PWMMR2R.
	PWM_MCR_PWMMR2R = 0x80
	// Disabled.
	PWM_MCR_PWMMR2R_DISABLED_ = 0x0
	// Reset on PWMMR2: the PWMTC will be reset if PWMMR2 matches it.
	PWM_MCR_PWMMR2R_RESET_ON_PWMMR2_THE = 0x1
	// Position of PWMMR2S field.
	PWM_MCR_PWMMR2S_Pos = 0x8
	// Bit mask of PWMMR2S field.
	PWM_MCR_PWMMR2S_Msk = 0x100
	// Bit PWMMR2S.
	PWM_MCR_PWMMR2S = 0x100
	// Disabled
	PWM_MCR_PWMMR2S_DISABLED = 0x0
	// Stop on PWMMR2: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR0 matches the PWMTC.
	PWM_MCR_PWMMR2S_STOP_ON_PWMMR2_THE_ = 0x1
	// Position of PWMMR3I field.
	PWM_MCR_PWMMR3I_Pos = 0x9
	// Bit mask of PWMMR3I field.
	PWM_MCR_PWMMR3I_Msk = 0x200
	// Bit PWMMR3I.
	PWM_MCR_PWMMR3I = 0x200
	// Disabled.
	PWM_MCR_PWMMR3I_DISABLED_ = 0x0
	// Interrupt on PWMMR3: an interrupt is generated when PWMMR3 matches the value in the PWMTC.
	PWM_MCR_PWMMR3I_INTERRUPT_ON_PWMMR3 = 0x1
	// Position of PWMMR3R field.
	PWM_MCR_PWMMR3R_Pos = 0xa
	// Bit mask of PWMMR3R field.
	PWM_MCR_PWMMR3R_Msk = 0x400
	// Bit PWMMR3R.
	PWM_MCR_PWMMR3R = 0x400
	// Disabled.
	PWM_MCR_PWMMR3R_DISABLED_ = 0x0
	// Reset on PWMMR3: the PWMTC will be reset if PWMMR3 matches it.
	PWM_MCR_PWMMR3R_RESET_ON_PWMMR3_THE = 0x1
	// Position of PWMMR3S field.
	PWM_MCR_PWMMR3S_Pos = 0xb
	// Bit mask of PWMMR3S field.
	PWM_MCR_PWMMR3S_Msk = 0x800
	// Bit PWMMR3S.
	PWM_MCR_PWMMR3S = 0x800
	// Disabled
	PWM_MCR_PWMMR3S_DISABLED = 0x0
	// Stop on PWMMR3: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR0 matches the PWMTC.
	PWM_MCR_PWMMR3S_STOP_ON_PWMMR3_THE_ = 0x1
	// Position of PWMMR4I field.
	PWM_MCR_PWMMR4I_Pos = 0xc
	// Bit mask of PWMMR4I field.
	PWM_MCR_PWMMR4I_Msk = 0x1000
	// Bit PWMMR4I.
	PWM_MCR_PWMMR4I = 0x1000
	// Disabled.
	PWM_MCR_PWMMR4I_DISABLED_ = 0x0
	// Interrupt on PWMMR4: an interrupt is generated when PWMMR4 matches the value in the PWMTC.
	PWM_MCR_PWMMR4I_INTERRUPT_ON_PWMMR4 = 0x1
	// Position of PWMMR4R field.
	PWM_MCR_PWMMR4R_Pos = 0xd
	// Bit mask of PWMMR4R field.
	PWM_MCR_PWMMR4R_Msk = 0x2000
	// Bit PWMMR4R.
	PWM_MCR_PWMMR4R = 0x2000
	// Disabled.
	PWM_MCR_PWMMR4R_DISABLED_ = 0x0
	// Reset on PWMMR4: the PWMTC will be reset if PWMMR4 matches it.
	PWM_MCR_PWMMR4R_RESET_ON_PWMMR4_THE = 0x1
	// Position of PWMMR4S field.
	PWM_MCR_PWMMR4S_Pos = 0xe
	// Bit mask of PWMMR4S field.
	PWM_MCR_PWMMR4S_Msk = 0x4000
	// Bit PWMMR4S.
	PWM_MCR_PWMMR4S = 0x4000
	// Disabled
	PWM_MCR_PWMMR4S_DISABLED = 0x0
	// Stop on PWMMR4: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR4 matches the PWMTC.
	PWM_MCR_PWMMR4S_STOP_ON_PWMMR4_THE_ = 0x1
	// Position of PWMMR5I field.
	PWM_MCR_PWMMR5I_Pos = 0xf
	// Bit mask of PWMMR5I field.
	PWM_MCR_PWMMR5I_Msk = 0x8000
	// Bit PWMMR5I.
	PWM_MCR_PWMMR5I = 0x8000
	// Disabled.
	PWM_MCR_PWMMR5I_DISABLED_ = 0x0
	// Interrupt on PWMMR5: an interrupt is generated when PWMMR5 matches the value in the PWMTC.
	PWM_MCR_PWMMR5I_INTERRUPT_ON_PWMMR5 = 0x1
	// Position of PWMMR5R field.
	PWM_MCR_PWMMR5R_Pos = 0x10
	// Bit mask of PWMMR5R field.
	PWM_MCR_PWMMR5R_Msk = 0x10000
	// Bit PWMMR5R.
	PWM_MCR_PWMMR5R = 0x10000
	// Disabled.
	PWM_MCR_PWMMR5R_DISABLED_ = 0x0
	// Reset on PWMMR5: the PWMTC will be reset if PWMMR5 matches it.
	PWM_MCR_PWMMR5R_RESET_ON_PWMMR5_THE = 0x1
	// Position of PWMMR5S field.
	PWM_MCR_PWMMR5S_Pos = 0x11
	// Bit mask of PWMMR5S field.
	PWM_MCR_PWMMR5S_Msk = 0x20000
	// Bit PWMMR5S.
	PWM_MCR_PWMMR5S = 0x20000
	// Disabled
	PWM_MCR_PWMMR5S_DISABLED = 0x0
	// Stop on PWMMR5: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR5 matches the PWMTC.
	PWM_MCR_PWMMR5S_STOP_ON_PWMMR5_THE_ = 0x1
	// Position of PWMMR6I field.
	PWM_MCR_PWMMR6I_Pos = 0x12
	// Bit mask of PWMMR6I field.
	PWM_MCR_PWMMR6I_Msk = 0x40000
	// Bit PWMMR6I.
	PWM_MCR_PWMMR6I = 0x40000
	// Disabled.
	PWM_MCR_PWMMR6I_DISABLED_ = 0x0
	// Interrupt on PWMMR6: an interrupt is generated when PWMMR6 matches the value in the PWMTC.
	PWM_MCR_PWMMR6I_INTERRUPT_ON_PWMMR6 = 0x1
	// Position of PWMMR6R field.
	PWM_MCR_PWMMR6R_Pos = 0x13
	// Bit mask of PWMMR6R field.
	PWM_MCR_PWMMR6R_Msk = 0x80000
	// Bit PWMMR6R.
	PWM_MCR_PWMMR6R = 0x80000
	// Disabled.
	PWM_MCR_PWMMR6R_DISABLED_ = 0x0
	// Reset on PWMMR6: the PWMTC will be reset if PWMMR6 matches it.
	PWM_MCR_PWMMR6R_RESET_ON_PWMMR6_THE = 0x1
	// Position of PWMMR6S field.
	PWM_MCR_PWMMR6S_Pos = 0x14
	// Bit mask of PWMMR6S field.
	PWM_MCR_PWMMR6S_Msk = 0x100000
	// Bit PWMMR6S.
	PWM_MCR_PWMMR6S = 0x100000
	// Disabled
	PWM_MCR_PWMMR6S_DISABLED = 0x0
	// Stop on PWMMR6: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR6 matches the PWMTC.
	PWM_MCR_PWMMR6S_STOP_ON_PWMMR6_THE_ = 0x1
	// Position of RESERVED field.
	PWM_MCR_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	PWM_MCR_RESERVED_Msk = 0xffe00000

	// MR0: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
	// Position of MATCH field.
	PWM_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	PWM_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated for a capture event.
	// Position of CAP0_R field.
	PWM_CCR_CAP0_R_Pos = 0x0
	// Bit mask of CAP0_R field.
	PWM_CCR_CAP0_R_Msk = 0x1
	// Bit CAP0_R.
	PWM_CCR_CAP0_R = 0x1
	// Disabled. This feature is disabled.
	PWM_CCR_CAP0_R_DISABLED_THIS_FEATU = 0x0
	// Rising edge. A synchronously sampled rising edge on PWMn_CAP0 will cause CR0 to be loaded with the contents of the TC.
	PWM_CCR_CAP0_R_RISING_EDGE_A_SYNCH = 0x1
	// Position of CAP0_F field.
	PWM_CCR_CAP0_F_Pos = 0x1
	// Bit mask of CAP0_F field.
	PWM_CCR_CAP0_F_Msk = 0x2
	// Bit CAP0_F.
	PWM_CCR_CAP0_F = 0x2
	// Disabled. This feature is disabled.
	PWM_CCR_CAP0_F_DISABLED_THIS_FEATU = 0x0
	// Falling edge. A synchronously sampled falling edge on PWMn_CAP0 will cause CR0 to be loaded with the contents of TC.
	PWM_CCR_CAP0_F_FALLING_EDGE_A_SYNC = 0x1
	// Position of CAP0_I field.
	PWM_CCR_CAP0_I_Pos = 0x2
	// Bit mask of CAP0_I field.
	PWM_CCR_CAP0_I_Msk = 0x4
	// Bit CAP0_I.
	PWM_CCR_CAP0_I = 0x4
	// Disabled. This feature is disabled.
	PWM_CCR_CAP0_I_DISABLED_THIS_FEATU = 0x0
	// Interrupt. A CR0 load due to a PWMn_CAP0 event will generate an interrupt.
	PWM_CCR_CAP0_I_INTERRUPT_A_CR0_LOA = 0x1
	// Position of CAP1_R field.
	PWM_CCR_CAP1_R_Pos = 0x3
	// Bit mask of CAP1_R field.
	PWM_CCR_CAP1_R_Msk = 0x8
	// Bit CAP1_R.
	PWM_CCR_CAP1_R = 0x8
	// Disabled. This feature is disabled.
	PWM_CCR_CAP1_R_DISABLED_THIS_FEATU = 0x0
	// Rising edge. A synchronously sampled rising edge on PWMn_CAP1 will cause CR1 to be loaded with the contents of the TC.
	PWM_CCR_CAP1_R_RISING_EDGE_A_SYNCH = 0x1
	// Position of CAP1_F field.
	PWM_CCR_CAP1_F_Pos = 0x4
	// Bit mask of CAP1_F field.
	PWM_CCR_CAP1_F_Msk = 0x10
	// Bit CAP1_F.
	PWM_CCR_CAP1_F = 0x10
	// Disabled. This feature is disabled.
	PWM_CCR_CAP1_F_DISABLED_THIS_FEATU = 0x0
	// Falling edge. A synchronously sampled falling edge on PWMn_CAP1 will cause CR1 to be loaded with the contents of TC.
	PWM_CCR_CAP1_F_FALLING_EDGE_A_SYNC = 0x1
	// Position of CAP1_I field.
	PWM_CCR_CAP1_I_Pos = 0x5
	// Bit mask of CAP1_I field.
	PWM_CCR_CAP1_I_Msk = 0x20
	// Bit CAP1_I.
	PWM_CCR_CAP1_I = 0x20
	// Disabled. This feature is disabled.
	PWM_CCR_CAP1_I_DISABLED_THIS_FEATU = 0x0
	// Interrupt. A CR1 load due to a PWMn_CAP1 event will generate an interrupt.
	PWM_CCR_CAP1_I_INTERRUPT_A_CR1_LOA = 0x1
	// Position of RESERVED field.
	PWM_CCR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	PWM_CCR_RESERVED_Msk = 0xffffffc0

	// CR: PWM Control Register. Enables PWM outputs and selects either single edge or double edge controlled PWM outputs.
	// Position of RESERVED field.
	PWM_CR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	PWM_CR_RESERVED_Msk = 0x3
	// Position of PWMSEL2 field.
	PWM_CR_PWMSEL2_Pos = 0x2
	// Bit mask of PWMSEL2 field.
	PWM_CR_PWMSEL2_Msk = 0x4
	// Bit PWMSEL2.
	PWM_CR_PWMSEL2 = 0x4
	// Single edge controlled mode is selected.
	PWM_CR_PWMSEL2_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_CR_PWMSEL2_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of PWMSEL3 field.
	PWM_CR_PWMSEL3_Pos = 0x3
	// Bit mask of PWMSEL3 field.
	PWM_CR_PWMSEL3_Msk = 0x8
	// Bit PWMSEL3.
	PWM_CR_PWMSEL3 = 0x8
	// Single edge controlled mode is selected.
	PWM_CR_PWMSEL3_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_CR_PWMSEL3_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of PWMSEL4 field.
	PWM_CR_PWMSEL4_Pos = 0x4
	// Bit mask of PWMSEL4 field.
	PWM_CR_PWMSEL4_Msk = 0x10
	// Bit PWMSEL4.
	PWM_CR_PWMSEL4 = 0x10
	// Single edge controlled mode is selected.
	PWM_CR_PWMSEL4_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_CR_PWMSEL4_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of PWMSEL5 field.
	PWM_CR_PWMSEL5_Pos = 0x5
	// Bit mask of PWMSEL5 field.
	PWM_CR_PWMSEL5_Msk = 0x20
	// Bit PWMSEL5.
	PWM_CR_PWMSEL5 = 0x20
	// Single edge controlled mode is selected.
	PWM_CR_PWMSEL5_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_CR_PWMSEL5_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of PWMSEL6 field.
	PWM_CR_PWMSEL6_Pos = 0x6
	// Bit mask of PWMSEL6 field.
	PWM_CR_PWMSEL6_Msk = 0x40
	// Bit PWMSEL6.
	PWM_CR_PWMSEL6 = 0x40
	// Single edge controlled mode is selected.
	PWM_CR_PWMSEL6_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_CR_PWMSEL6_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of RESERVED field.
	PWM_CR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	PWM_CR_RESERVED_Msk = 0x180
	// Position of PWMENA1 field.
	PWM_CR_PWMENA1_Pos = 0x9
	// Bit mask of PWMENA1 field.
	PWM_CR_PWMENA1_Msk = 0x200
	// Bit PWMENA1.
	PWM_CR_PWMENA1 = 0x200
	// The PWM output is disabled.
	PWM_CR_PWMENA1_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_CR_PWMENA1_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA2 field.
	PWM_CR_PWMENA2_Pos = 0xa
	// Bit mask of PWMENA2 field.
	PWM_CR_PWMENA2_Msk = 0x400
	// Bit PWMENA2.
	PWM_CR_PWMENA2 = 0x400
	// The PWM output is disabled.
	PWM_CR_PWMENA2_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_CR_PWMENA2_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA3 field.
	PWM_CR_PWMENA3_Pos = 0xb
	// Bit mask of PWMENA3 field.
	PWM_CR_PWMENA3_Msk = 0x800
	// Bit PWMENA3.
	PWM_CR_PWMENA3 = 0x800
	// The PWM output is disabled.
	PWM_CR_PWMENA3_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_CR_PWMENA3_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA4 field.
	PWM_CR_PWMENA4_Pos = 0xc
	// Bit mask of PWMENA4 field.
	PWM_CR_PWMENA4_Msk = 0x1000
	// Bit PWMENA4.
	PWM_CR_PWMENA4 = 0x1000
	// The PWM output is disabled.
	PWM_CR_PWMENA4_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_CR_PWMENA4_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA5 field.
	PWM_CR_PWMENA5_Pos = 0xd
	// Bit mask of PWMENA5 field.
	PWM_CR_PWMENA5_Msk = 0x2000
	// Bit PWMENA5.
	PWM_CR_PWMENA5 = 0x2000
	// The PWM output is disabled.
	PWM_CR_PWMENA5_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_CR_PWMENA5_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA6 field.
	PWM_CR_PWMENA6_Pos = 0xe
	// Bit mask of PWMENA6 field.
	PWM_CR_PWMENA6_Msk = 0x4000
	// Bit PWMENA6.
	PWM_CR_PWMENA6 = 0x4000
	// The PWM output is disabled.
	PWM_CR_PWMENA6_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_CR_PWMENA6_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of RESERVED field.
	PWM_CR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	PWM_CR_RESERVED_Msk = 0xffff8000

	// MR4: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
	// Position of MATCH field.
	PWM_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	PWM_MR_MATCH_Msk = 0xffffffff

	// PCR: PWM Control Register. Enables PWM outputs and selects either single edge or double edge controlled PWM outputs.
	// Position of RESERVED field.
	PWM_PCR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	PWM_PCR_RESERVED_Msk = 0x3
	// Position of PWMSEL2 field.
	PWM_PCR_PWMSEL2_Pos = 0x2
	// Bit mask of PWMSEL2 field.
	PWM_PCR_PWMSEL2_Msk = 0x4
	// Bit PWMSEL2.
	PWM_PCR_PWMSEL2 = 0x4
	// Single edge controlled mode is selected.
	PWM_PCR_PWMSEL2_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_PCR_PWMSEL2_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of PWMSEL3 field.
	PWM_PCR_PWMSEL3_Pos = 0x3
	// Bit mask of PWMSEL3 field.
	PWM_PCR_PWMSEL3_Msk = 0x8
	// Bit PWMSEL3.
	PWM_PCR_PWMSEL3 = 0x8
	// Single edge controlled mode is selected.
	PWM_PCR_PWMSEL3_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_PCR_PWMSEL3_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of PWMSEL4 field.
	PWM_PCR_PWMSEL4_Pos = 0x4
	// Bit mask of PWMSEL4 field.
	PWM_PCR_PWMSEL4_Msk = 0x10
	// Bit PWMSEL4.
	PWM_PCR_PWMSEL4 = 0x10
	// Single edge controlled mode is selected.
	PWM_PCR_PWMSEL4_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_PCR_PWMSEL4_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of PWMSEL5 field.
	PWM_PCR_PWMSEL5_Pos = 0x5
	// Bit mask of PWMSEL5 field.
	PWM_PCR_PWMSEL5_Msk = 0x20
	// Bit PWMSEL5.
	PWM_PCR_PWMSEL5 = 0x20
	// Single edge controlled mode is selected.
	PWM_PCR_PWMSEL5_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_PCR_PWMSEL5_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of PWMSEL6 field.
	PWM_PCR_PWMSEL6_Pos = 0x6
	// Bit mask of PWMSEL6 field.
	PWM_PCR_PWMSEL6_Msk = 0x40
	// Bit PWMSEL6.
	PWM_PCR_PWMSEL6 = 0x40
	// Single edge controlled mode is selected.
	PWM_PCR_PWMSEL6_SINGLE_EDGE_CONTROLL = 0x0
	// Double edge controlled mode is selected.
	PWM_PCR_PWMSEL6_DOUBLE_EDGE_CONTROLL = 0x1
	// Position of RESERVED field.
	PWM_PCR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	PWM_PCR_RESERVED_Msk = 0x180
	// Position of PWMENA1 field.
	PWM_PCR_PWMENA1_Pos = 0x9
	// Bit mask of PWMENA1 field.
	PWM_PCR_PWMENA1_Msk = 0x200
	// Bit PWMENA1.
	PWM_PCR_PWMENA1 = 0x200
	// The PWM output is disabled.
	PWM_PCR_PWMENA1_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_PCR_PWMENA1_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA2 field.
	PWM_PCR_PWMENA2_Pos = 0xa
	// Bit mask of PWMENA2 field.
	PWM_PCR_PWMENA2_Msk = 0x400
	// Bit PWMENA2.
	PWM_PCR_PWMENA2 = 0x400
	// The PWM output is disabled.
	PWM_PCR_PWMENA2_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_PCR_PWMENA2_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA3 field.
	PWM_PCR_PWMENA3_Pos = 0xb
	// Bit mask of PWMENA3 field.
	PWM_PCR_PWMENA3_Msk = 0x800
	// Bit PWMENA3.
	PWM_PCR_PWMENA3 = 0x800
	// The PWM output is disabled.
	PWM_PCR_PWMENA3_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_PCR_PWMENA3_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA4 field.
	PWM_PCR_PWMENA4_Pos = 0xc
	// Bit mask of PWMENA4 field.
	PWM_PCR_PWMENA4_Msk = 0x1000
	// Bit PWMENA4.
	PWM_PCR_PWMENA4 = 0x1000
	// The PWM output is disabled.
	PWM_PCR_PWMENA4_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_PCR_PWMENA4_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA5 field.
	PWM_PCR_PWMENA5_Pos = 0xd
	// Bit mask of PWMENA5 field.
	PWM_PCR_PWMENA5_Msk = 0x2000
	// Bit PWMENA5.
	PWM_PCR_PWMENA5 = 0x2000
	// The PWM output is disabled.
	PWM_PCR_PWMENA5_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_PCR_PWMENA5_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of PWMENA6 field.
	PWM_PCR_PWMENA6_Pos = 0xe
	// Bit mask of PWMENA6 field.
	PWM_PCR_PWMENA6_Msk = 0x4000
	// Bit PWMENA6.
	PWM_PCR_PWMENA6 = 0x4000
	// The PWM output is disabled.
	PWM_PCR_PWMENA6_THE_PWM_OUTPUT_IS_DI = 0x0
	// The PWM output is enabled.
	PWM_PCR_PWMENA6_THE_PWM_OUTPUT_IS_EN = 0x1
	// Position of RESERVED field.
	PWM_PCR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	PWM_PCR_RESERVED_Msk = 0xffff8000

	// LER: Load Enable Register. Enables use of updated PWM match values.
	// Position of MAT0LATCHEN field.
	PWM_LER_MAT0LATCHEN_Pos = 0x0
	// Bit mask of MAT0LATCHEN field.
	PWM_LER_MAT0LATCHEN_Msk = 0x1
	// Bit MAT0LATCHEN.
	PWM_LER_MAT0LATCHEN = 0x1
	// Position of MAT1LATCHEN field.
	PWM_LER_MAT1LATCHEN_Pos = 0x1
	// Bit mask of MAT1LATCHEN field.
	PWM_LER_MAT1LATCHEN_Msk = 0x2
	// Bit MAT1LATCHEN.
	PWM_LER_MAT1LATCHEN = 0x2
	// Position of MAT2LATCHEN field.
	PWM_LER_MAT2LATCHEN_Pos = 0x2
	// Bit mask of MAT2LATCHEN field.
	PWM_LER_MAT2LATCHEN_Msk = 0x4
	// Bit MAT2LATCHEN.
	PWM_LER_MAT2LATCHEN = 0x4
	// Position of MAT3LATCHEN field.
	PWM_LER_MAT3LATCHEN_Pos = 0x3
	// Bit mask of MAT3LATCHEN field.
	PWM_LER_MAT3LATCHEN_Msk = 0x8
	// Bit MAT3LATCHEN.
	PWM_LER_MAT3LATCHEN = 0x8
	// Position of MAT4LATCHEN field.
	PWM_LER_MAT4LATCHEN_Pos = 0x4
	// Bit mask of MAT4LATCHEN field.
	PWM_LER_MAT4LATCHEN_Msk = 0x10
	// Bit MAT4LATCHEN.
	PWM_LER_MAT4LATCHEN = 0x10
	// Position of MAT5LATCHEN field.
	PWM_LER_MAT5LATCHEN_Pos = 0x5
	// Bit mask of MAT5LATCHEN field.
	PWM_LER_MAT5LATCHEN_Msk = 0x20
	// Bit MAT5LATCHEN.
	PWM_LER_MAT5LATCHEN = 0x20
	// Position of MAT6LATCHEN field.
	PWM_LER_MAT6LATCHEN_Pos = 0x6
	// Bit mask of MAT6LATCHEN field.
	PWM_LER_MAT6LATCHEN_Msk = 0x40
	// Bit MAT6LATCHEN.
	PWM_LER_MAT6LATCHEN = 0x40
	// Position of RESERVED field.
	PWM_LER_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	PWM_LER_RESERVED_Msk = 0xffffff80

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of MOD field.
	PWM_CTCR_MOD_Pos = 0x0
	// Bit mask of MOD field.
	PWM_CTCR_MOD_Msk = 0x3
	// Timer Mode: the TC is incremented when the Prescale Counter matches the Prescale register.
	PWM_CTCR_MOD_TIMER_MODE_THE_TC_I = 0x0
	// Rising edge counter Mode: the TC is incremented on rising edges of the PWM_CAP input selected by bits 3:2.
	PWM_CTCR_MOD_RISING_EDGE_COUNTER_ = 0x1
	// Falling edge counter Mode: the TC is incremented on falling edges of the PWM_CAP input selected by bits 3:2.
	PWM_CTCR_MOD_FALLING_EDGE_COUNTER = 0x2
	// Dual edge counter Mode: the TC is incremented on both edges of the PWM_CAP input selected by bits 3:2.
	PWM_CTCR_MOD_DUAL_EDGE_COUNTER_MO = 0x3
	// Position of CIS field.
	PWM_CTCR_CIS_Pos = 0x2
	// Bit mask of CIS field.
	PWM_CTCR_CIS_Msk = 0xc
	// For PWM0: 00 = PWM0_CAP0 (Other combinations are reserved) For PWM1: 00 = PWM1_CAP0, 01 = PWM1_CAP1 (Other combinations are reserved)
	PWM_CTCR_CIS_FOR_PWM0_00_EQ_PWM0_ = 0x0
	// Position of RESERVED field.
	PWM_CTCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	PWM_CTCR_RESERVED_Msk = 0xfffffff0
)

// Bitfields for I2C0: I2C bus interface
const (
	// CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C_CONSET_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_CONSET_RESERVED_Msk = 0x3
	// Position of AA field.
	I2C_CONSET_AA_Pos = 0x2
	// Bit mask of AA field.
	I2C_CONSET_AA_Msk = 0x4
	// Bit AA.
	I2C_CONSET_AA = 0x4
	// Position of SI field.
	I2C_CONSET_SI_Pos = 0x3
	// Bit mask of SI field.
	I2C_CONSET_SI_Msk = 0x8
	// Bit SI.
	I2C_CONSET_SI = 0x8
	// Position of STO field.
	I2C_CONSET_STO_Pos = 0x4
	// Bit mask of STO field.
	I2C_CONSET_STO_Msk = 0x10
	// Bit STO.
	I2C_CONSET_STO = 0x10
	// Position of STA field.
	I2C_CONSET_STA_Pos = 0x5
	// Bit mask of STA field.
	I2C_CONSET_STA_Msk = 0x20
	// Bit STA.
	I2C_CONSET_STA = 0x20
	// Position of I2EN field.
	I2C_CONSET_I2EN_Pos = 0x6
	// Bit mask of I2EN field.
	I2C_CONSET_I2EN_Msk = 0x40
	// Bit I2EN.
	I2C_CONSET_I2EN = 0x40
	// Position of RESERVED field.
	I2C_CONSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_CONSET_RESERVED_Msk = 0xffffff80

	// STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0x7
	// Position of Status field.
	I2C_STAT_Status_Pos = 0x3
	// Bit mask of Status field.
	I2C_STAT_Status_Msk = 0xf8
	// Position of RESERVED field.
	I2C_STAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0xffffff00

	// DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
	// Position of Data field.
	I2C_DAT_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C_DAT_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C_DAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_DAT_RESERVED_Msk = 0xffffff00

	// ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C_ADR0_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C_ADR0_GC_Msk = 0x1
	// Bit GC.
	I2C_ADR0_GC = 0x1
	// Position of Address field.
	I2C_ADR0_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C_ADR0_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C_ADR0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_ADR0_RESERVED_Msk = 0xffffff00

	// SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
	// Position of SCLH field.
	I2C_SCLH_SCLH_Pos = 0x0
	// Bit mask of SCLH field.
	I2C_SCLH_SCLH_Msk = 0xffff
	// Position of RESERVED field.
	I2C_SCLH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C_SCLH_RESERVED_Msk = 0xffff0000

	// SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. SCLL and SCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
	// Position of SCLL field.
	I2C_SCLL_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_SCLL_SCLL_Msk = 0xffff
	// Position of RESERVED field.
	I2C_SCLL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C_SCLL_RESERVED_Msk = 0xffff0000

	// CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x3
	// Position of AAC field.
	I2C_CONCLR_AAC_Pos = 0x2
	// Bit mask of AAC field.
	I2C_CONCLR_AAC_Msk = 0x4
	// Bit AAC.
	I2C_CONCLR_AAC = 0x4
	// Position of SIC field.
	I2C_CONCLR_SIC_Pos = 0x3
	// Bit mask of SIC field.
	I2C_CONCLR_SIC_Msk = 0x8
	// Bit SIC.
	I2C_CONCLR_SIC = 0x8
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	I2C_CONCLR_RESERVED = 0x10
	// Position of STAC field.
	I2C_CONCLR_STAC_Pos = 0x5
	// Bit mask of STAC field.
	I2C_CONCLR_STAC_Msk = 0x20
	// Bit STAC.
	I2C_CONCLR_STAC = 0x20
	// Position of I2ENC field.
	I2C_CONCLR_I2ENC_Pos = 0x6
	// Bit mask of I2ENC field.
	I2C_CONCLR_I2ENC_Msk = 0x40
	// Bit I2ENC.
	I2C_CONCLR_I2ENC = 0x40
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C_CONCLR_RESERVED = 0x80
	// Position of RESERVED field.
	I2C_CONCLR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0xffffff00

	// MMCTRL: Monitor mode control register.
	// Position of MM_ENA field.
	I2C_MMCTRL_MM_ENA_Pos = 0x0
	// Bit mask of MM_ENA field.
	I2C_MMCTRL_MM_ENA_Msk = 0x1
	// Bit MM_ENA.
	I2C_MMCTRL_MM_ENA = 0x1
	// Monitor mode disabled.
	I2C_MMCTRL_MM_ENA_MONITOR_MODE_DISABLE = 0x0
	// The I 2C module will enter monitor mode. In this mode the SDA output will be forced high. This will prevent the I2C module from outputting data of any kind (including ACK) onto the I2C data bus. Depending on the state of the ENA_SCL bit, the output may be also forced high, preventing the module from having control over the I2C clock line.
	I2C_MMCTRL_MM_ENA_THE_I_2C_MODULE_WILL = 0x1
	// Position of ENA_SCL field.
	I2C_MMCTRL_ENA_SCL_Pos = 0x1
	// Bit mask of ENA_SCL field.
	I2C_MMCTRL_ENA_SCL_Msk = 0x2
	// Bit ENA_SCL.
	I2C_MMCTRL_ENA_SCL = 0x2
	// When this bit is cleared to 0, the SCL output will be forced high when the module is in monitor mode. As described above, this will prevent the module from having any control over the I2C clock line.
	I2C_MMCTRL_ENA_SCL_WHEN_THIS_BIT_IS_CLE = 0x0
	// When this bit is set, the I2C module may exercise the same control over the clock line that it would in normal operation. This means that, acting as a slave peripheral, the I2C module can stretch the clock line (hold it low) until it has had time to respond to an I2C interrupt.[1]
	I2C_MMCTRL_ENA_SCL_WHEN_THIS_BIT_IS_SET = 0x1
	// Position of MATCH_ALL field.
	I2C_MMCTRL_MATCH_ALL_Pos = 0x2
	// Bit mask of MATCH_ALL field.
	I2C_MMCTRL_MATCH_ALL_Msk = 0x4
	// Bit MATCH_ALL.
	I2C_MMCTRL_MATCH_ALL = 0x4
	// When this bit is cleared, an interrupt will only be generated when a match occurs to one of the (up-to) four address registers described above. That is, the module will respond as a normal slave as far as address-recognition is concerned.
	I2C_MMCTRL_MATCH_ALL_WHEN_THIS_BIT_IS_CLE = 0x0
	// When this bit is set to 1 and the I2C is in monitor mode, an interrupt will be generated on ANY address received. This will enable the part to monitor all traffic on the bus.
	I2C_MMCTRL_MATCH_ALL_WHEN_THIS_BIT_IS_SET = 0x1
	// Position of RESERVED field.
	I2C_MMCTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	I2C_MMCTRL_RESERVED_Msk = 0xfffffff8

	// ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	// Position of GC field.
	I2C_ADR_GC_Pos = 0x0
	// Bit mask of GC field.
	I2C_ADR_GC_Msk = 0x1
	// Bit GC.
	I2C_ADR_GC = 0x1
	// Position of Address field.
	I2C_ADR_Address_Pos = 0x1
	// Bit mask of Address field.
	I2C_ADR_Address_Msk = 0xfe
	// Position of RESERVED field.
	I2C_ADR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_ADR_RESERVED_Msk = 0xffffff00

	// DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
	// Position of Data field.
	I2C_DATA_BUFFER_Data_Pos = 0x0
	// Bit mask of Data field.
	I2C_DATA_BUFFER_Data_Msk = 0xff
	// Position of RESERVED field.
	I2C_DATA_BUFFER_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_DATA_BUFFER_RESERVED_Msk = 0xffffff00

	// MASK: I2C Slave address mask register
	// Position of RESERVED field.
	I2C_MASK_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	I2C_MASK_RESERVED_Msk = 0x1
	// Bit RESERVED.
	I2C_MASK_RESERVED = 0x1
	// Position of MASK field.
	I2C_MASK_MASK_Pos = 0x1
	// Bit mask of MASK field.
	I2C_MASK_MASK_Msk = 0xfe
	// Position of RESERVED field.
	I2C_MASK_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C_MASK_RESERVED_Msk = 0xffffff00
)

// Bitfields for RTC: Real Time Clock (RTC)
const (
	// ILR: Interrupt Location Register
	// Position of RTCCIF field.
	RTC_ILR_RTCCIF_Pos = 0x0
	// Bit mask of RTCCIF field.
	RTC_ILR_RTCCIF_Msk = 0x1
	// Bit RTCCIF.
	RTC_ILR_RTCCIF = 0x1
	// Position of RTCALF field.
	RTC_ILR_RTCALF_Pos = 0x1
	// Bit mask of RTCALF field.
	RTC_ILR_RTCALF_Msk = 0x2
	// Bit RTCALF.
	RTC_ILR_RTCALF = 0x2
	// Position of RESERVED field.
	RTC_ILR_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	RTC_ILR_RESERVED_Msk = 0xffe00000

	// CCR: Clock Control Register
	// Position of CLKEN field.
	RTC_CCR_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	RTC_CCR_CLKEN_Msk = 0x1
	// Bit CLKEN.
	RTC_CCR_CLKEN = 0x1
	// Position of CTCRST field.
	RTC_CCR_CTCRST_Pos = 0x1
	// Bit mask of CTCRST field.
	RTC_CCR_CTCRST_Msk = 0x2
	// Bit CTCRST.
	RTC_CCR_CTCRST = 0x2
	// When one, the elements in the internal oscillator divider are reset, and remain reset until CCR[1] is changed to zero. This is the divider that generates the 1 Hz clock from the 32.768 kHz crystal. The state of the divider is not visible to software.
	RTC_CCR_CTCRST_RESET = 0x1
	// No effect.
	RTC_CCR_CTCRST_NO_EFFECT_ = 0x0
	// Position of RESERVED field.
	RTC_CCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	RTC_CCR_RESERVED_Msk = 0xc
	// Position of CCALEN field.
	RTC_CCR_CCALEN_Pos = 0x4
	// Bit mask of CCALEN field.
	RTC_CCR_CCALEN_Msk = 0x10
	// Bit CCALEN.
	RTC_CCR_CCALEN = 0x10
	// Position of RESERVED field.
	RTC_CCR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_CCR_RESERVED_Msk = 0xffffffe0

	// CIIR: Counter Increment Interrupt Register
	// Position of IMSEC field.
	RTC_CIIR_IMSEC_Pos = 0x0
	// Bit mask of IMSEC field.
	RTC_CIIR_IMSEC_Msk = 0x1
	// Bit IMSEC.
	RTC_CIIR_IMSEC = 0x1
	// Position of IMMIN field.
	RTC_CIIR_IMMIN_Pos = 0x1
	// Bit mask of IMMIN field.
	RTC_CIIR_IMMIN_Msk = 0x2
	// Bit IMMIN.
	RTC_CIIR_IMMIN = 0x2
	// Position of IMHOUR field.
	RTC_CIIR_IMHOUR_Pos = 0x2
	// Bit mask of IMHOUR field.
	RTC_CIIR_IMHOUR_Msk = 0x4
	// Bit IMHOUR.
	RTC_CIIR_IMHOUR = 0x4
	// Position of IMDOM field.
	RTC_CIIR_IMDOM_Pos = 0x3
	// Bit mask of IMDOM field.
	RTC_CIIR_IMDOM_Msk = 0x8
	// Bit IMDOM.
	RTC_CIIR_IMDOM = 0x8
	// Position of IMDOW field.
	RTC_CIIR_IMDOW_Pos = 0x4
	// Bit mask of IMDOW field.
	RTC_CIIR_IMDOW_Msk = 0x10
	// Bit IMDOW.
	RTC_CIIR_IMDOW = 0x10
	// Position of IMDOY field.
	RTC_CIIR_IMDOY_Pos = 0x5
	// Bit mask of IMDOY field.
	RTC_CIIR_IMDOY_Msk = 0x20
	// Bit IMDOY.
	RTC_CIIR_IMDOY = 0x20
	// Position of IMMON field.
	RTC_CIIR_IMMON_Pos = 0x6
	// Bit mask of IMMON field.
	RTC_CIIR_IMMON_Msk = 0x40
	// Bit IMMON.
	RTC_CIIR_IMMON = 0x40
	// Position of IMYEAR field.
	RTC_CIIR_IMYEAR_Pos = 0x7
	// Bit mask of IMYEAR field.
	RTC_CIIR_IMYEAR_Msk = 0x80
	// Bit IMYEAR.
	RTC_CIIR_IMYEAR = 0x80
	// Position of RESERVED field.
	RTC_CIIR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	RTC_CIIR_RESERVED_Msk = 0xffffff00

	// AMR: Alarm Mask Register
	// Position of AMRSEC field.
	RTC_AMR_AMRSEC_Pos = 0x0
	// Bit mask of AMRSEC field.
	RTC_AMR_AMRSEC_Msk = 0x1
	// Bit AMRSEC.
	RTC_AMR_AMRSEC = 0x1
	// Position of AMRMIN field.
	RTC_AMR_AMRMIN_Pos = 0x1
	// Bit mask of AMRMIN field.
	RTC_AMR_AMRMIN_Msk = 0x2
	// Bit AMRMIN.
	RTC_AMR_AMRMIN = 0x2
	// Position of AMRHOUR field.
	RTC_AMR_AMRHOUR_Pos = 0x2
	// Bit mask of AMRHOUR field.
	RTC_AMR_AMRHOUR_Msk = 0x4
	// Bit AMRHOUR.
	RTC_AMR_AMRHOUR = 0x4
	// Position of AMRDOM field.
	RTC_AMR_AMRDOM_Pos = 0x3
	// Bit mask of AMRDOM field.
	RTC_AMR_AMRDOM_Msk = 0x8
	// Bit AMRDOM.
	RTC_AMR_AMRDOM = 0x8
	// Position of AMRDOW field.
	RTC_AMR_AMRDOW_Pos = 0x4
	// Bit mask of AMRDOW field.
	RTC_AMR_AMRDOW_Msk = 0x10
	// Bit AMRDOW.
	RTC_AMR_AMRDOW = 0x10
	// Position of AMRDOY field.
	RTC_AMR_AMRDOY_Pos = 0x5
	// Bit mask of AMRDOY field.
	RTC_AMR_AMRDOY_Msk = 0x20
	// Bit AMRDOY.
	RTC_AMR_AMRDOY = 0x20
	// Position of AMRMON field.
	RTC_AMR_AMRMON_Pos = 0x6
	// Bit mask of AMRMON field.
	RTC_AMR_AMRMON_Msk = 0x40
	// Bit AMRMON.
	RTC_AMR_AMRMON = 0x40
	// Position of AMRYEAR field.
	RTC_AMR_AMRYEAR_Pos = 0x7
	// Bit mask of AMRYEAR field.
	RTC_AMR_AMRYEAR_Msk = 0x80
	// Bit AMRYEAR.
	RTC_AMR_AMRYEAR = 0x80
	// Position of RESERVED field.
	RTC_AMR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	RTC_AMR_RESERVED_Msk = 0xffffff00

	// CTIME0: Consolidated Time Register 0
	// Position of SECONDS field.
	RTC_CTIME0_SECONDS_Pos = 0x0
	// Bit mask of SECONDS field.
	RTC_CTIME0_SECONDS_Msk = 0x3f
	// Position of RESERVED field.
	RTC_CTIME0_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xc0
	// Position of MINUTES field.
	RTC_CTIME0_MINUTES_Pos = 0x8
	// Bit mask of MINUTES field.
	RTC_CTIME0_MINUTES_Msk = 0x3f00
	// Position of RESERVED field.
	RTC_CTIME0_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xc000
	// Position of HOURS field.
	RTC_CTIME0_HOURS_Pos = 0x10
	// Bit mask of HOURS field.
	RTC_CTIME0_HOURS_Msk = 0x1f0000
	// Position of RESERVED field.
	RTC_CTIME0_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xe00000
	// Position of DOW field.
	RTC_CTIME0_DOW_Pos = 0x18
	// Bit mask of DOW field.
	RTC_CTIME0_DOW_Msk = 0x7000000
	// Position of RESERVED field.
	RTC_CTIME0_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xf8000000

	// CTIME1: Consolidated Time Register 1
	// Position of DOM field.
	RTC_CTIME1_DOM_Pos = 0x0
	// Bit mask of DOM field.
	RTC_CTIME1_DOM_Msk = 0x1f
	// Position of RESERVED field.
	RTC_CTIME1_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xe0
	// Position of MONTH field.
	RTC_CTIME1_MONTH_Pos = 0x8
	// Bit mask of MONTH field.
	RTC_CTIME1_MONTH_Msk = 0xf00
	// Position of RESERVED field.
	RTC_CTIME1_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xf000
	// Position of YEAR field.
	RTC_CTIME1_YEAR_Pos = 0x10
	// Bit mask of YEAR field.
	RTC_CTIME1_YEAR_Msk = 0xfff0000
	// Position of RESERVED field.
	RTC_CTIME1_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xf0000000

	// CTIME2: Consolidated Time Register 2
	// Position of DOY field.
	RTC_CTIME2_DOY_Pos = 0x0
	// Bit mask of DOY field.
	RTC_CTIME2_DOY_Msk = 0xfff
	// Position of RESERVED field.
	RTC_CTIME2_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RTC_CTIME2_RESERVED_Msk = 0xfffff000

	// SEC: Seconds Counter
	// Position of SECONDS field.
	RTC_SEC_SECONDS_Pos = 0x0
	// Bit mask of SECONDS field.
	RTC_SEC_SECONDS_Msk = 0x3f
	// Position of RESERVED field.
	RTC_SEC_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_SEC_RESERVED_Msk = 0xffffffc0

	// MIN: Minutes Register
	// Position of MINUTES field.
	RTC_MIN_MINUTES_Pos = 0x0
	// Bit mask of MINUTES field.
	RTC_MIN_MINUTES_Msk = 0x3f
	// Position of RESERVED field.
	RTC_MIN_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_MIN_RESERVED_Msk = 0xffffffc0

	// HRS: Hours Register
	// Position of HOURS field.
	RTC_HRS_HOURS_Pos = 0x0
	// Bit mask of HOURS field.
	RTC_HRS_HOURS_Msk = 0x1f
	// Position of RESERVED field.
	RTC_HRS_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_HRS_RESERVED_Msk = 0xffffffe0

	// DOM: Day of Month Register
	// Position of DOM field.
	RTC_DOM_DOM_Pos = 0x0
	// Bit mask of DOM field.
	RTC_DOM_DOM_Msk = 0x1f
	// Position of RESERVED field.
	RTC_DOM_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_DOM_RESERVED_Msk = 0xffffffe0

	// DOW: Day of Week Register
	// Position of DOW field.
	RTC_DOW_DOW_Pos = 0x0
	// Bit mask of DOW field.
	RTC_DOW_DOW_Msk = 0x7
	// Position of RESERVED field.
	RTC_DOW_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RTC_DOW_RESERVED_Msk = 0xfffffff8

	// DOY: Day of Year Register
	// Position of DOY field.
	RTC_DOY_DOY_Pos = 0x0
	// Bit mask of DOY field.
	RTC_DOY_DOY_Msk = 0x1ff
	// Position of RESERVED field.
	RTC_DOY_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	RTC_DOY_RESERVED_Msk = 0xfffffe00

	// MONTH: Months Register
	// Position of MONTH field.
	RTC_MONTH_MONTH_Pos = 0x0
	// Bit mask of MONTH field.
	RTC_MONTH_MONTH_Msk = 0xf
	// Position of RESERVED field.
	RTC_MONTH_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RTC_MONTH_RESERVED_Msk = 0xfffffff0

	// YEAR: Years Register
	// Position of YEAR field.
	RTC_YEAR_YEAR_Pos = 0x0
	// Bit mask of YEAR field.
	RTC_YEAR_YEAR_Msk = 0xfff
	// Position of RESERVED field.
	RTC_YEAR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RTC_YEAR_RESERVED_Msk = 0xfffff000

	// CALIBRATION: Calibration Value Register
	// Position of CALVAL field.
	RTC_CALIBRATION_CALVAL_Pos = 0x0
	// Bit mask of CALVAL field.
	RTC_CALIBRATION_CALVAL_Msk = 0x1ffff
	// Position of CALDIR field.
	RTC_CALIBRATION_CALDIR_Pos = 0x11
	// Bit mask of CALDIR field.
	RTC_CALIBRATION_CALDIR_Msk = 0x20000
	// Bit CALDIR.
	RTC_CALIBRATION_CALDIR = 0x20000
	// Backward calibration. When CALVAL is equal to the calibration counter, the RTC timers will stop incrementing for 1 second.
	RTC_CALIBRATION_CALDIR_BACKWARD_CALIBRATION = 0x1
	// Forward calibration. When CALVAL is equal to the calibration counter, the RTC timers will jump by 2 seconds.
	RTC_CALIBRATION_CALDIR_FORWARD_CALIBRATION_ = 0x0

	// GPREG0: General Purpose Register 0
	// Position of GP field.
	RTC_GPREG_GP_Pos = 0x0
	// Bit mask of GP field.
	RTC_GPREG_GP_Msk = 0xffffffff

	// RTC_AUXEN: RTC Auxiliary Enable register
	// Position of RESERVED field.
	RTC_RTC_AUXEN_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RTC_RTC_AUXEN_RESERVED_Msk = 0xf
	// Position of RTC_OSCFEN field.
	RTC_RTC_AUXEN_RTC_OSCFEN_Pos = 0x4
	// Bit mask of RTC_OSCFEN field.
	RTC_RTC_AUXEN_RTC_OSCFEN_Msk = 0x10
	// Bit RTC_OSCFEN.
	RTC_RTC_AUXEN_RTC_OSCFEN = 0x10
	// Position of RESERVED field.
	RTC_RTC_AUXEN_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_RTC_AUXEN_RESERVED_Msk = 0xffffffe0

	// RTC_AUX: RTC Auxiliary control register
	// Position of RESERVED field.
	RTC_RTC_AUX_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	RTC_RTC_AUX_RESERVED_Msk = 0xf
	// Position of RTC_OSCF field.
	RTC_RTC_AUX_RTC_OSCF_Pos = 0x4
	// Bit mask of RTC_OSCF field.
	RTC_RTC_AUX_RTC_OSCF_Msk = 0x10
	// Bit RTC_OSCF.
	RTC_RTC_AUX_RTC_OSCF = 0x10
	// Position of RESERVED field.
	RTC_RTC_AUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_RTC_AUX_RESERVED_Msk = 0x20
	// Bit RESERVED.
	RTC_RTC_AUX_RESERVED = 0x20
	// Position of RTC_PDOUT field.
	RTC_RTC_AUX_RTC_PDOUT_Pos = 0x6
	// Bit mask of RTC_PDOUT field.
	RTC_RTC_AUX_RTC_PDOUT_Msk = 0x40
	// Bit RTC_PDOUT.
	RTC_RTC_AUX_RTC_PDOUT = 0x40
	// Position of RESERVED field.
	RTC_RTC_AUX_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	RTC_RTC_AUX_RESERVED_Msk = 0xffffff80

	// ASEC: Alarm value for Seconds
	// Position of SECONDS field.
	RTC_ASEC_SECONDS_Pos = 0x0
	// Bit mask of SECONDS field.
	RTC_ASEC_SECONDS_Msk = 0x3f
	// Position of RESERVED field.
	RTC_ASEC_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_ASEC_RESERVED_Msk = 0xffffffc0

	// AMIN: Alarm value for Minutes
	// Position of MINUTES field.
	RTC_AMIN_MINUTES_Pos = 0x0
	// Bit mask of MINUTES field.
	RTC_AMIN_MINUTES_Msk = 0x3f
	// Position of RESERVED field.
	RTC_AMIN_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	RTC_AMIN_RESERVED_Msk = 0xffffffc0

	// AHRS: Alarm value for Hours
	// Position of HOURS field.
	RTC_AHRS_HOURS_Pos = 0x0
	// Bit mask of HOURS field.
	RTC_AHRS_HOURS_Msk = 0x1f
	// Position of RESERVED field.
	RTC_AHRS_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_AHRS_RESERVED_Msk = 0xffffffe0

	// ADOM: Alarm value for Day of Month
	// Position of DOM field.
	RTC_ADOM_DOM_Pos = 0x0
	// Bit mask of DOM field.
	RTC_ADOM_DOM_Msk = 0x1f
	// Position of RESERVED field.
	RTC_ADOM_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	RTC_ADOM_RESERVED_Msk = 0xffffffe0

	// ADOW: Alarm value for Day of Week
	// Position of DOW field.
	RTC_ADOW_DOW_Pos = 0x0
	// Bit mask of DOW field.
	RTC_ADOW_DOW_Msk = 0x7
	// Position of RESERVED field.
	RTC_ADOW_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RTC_ADOW_RESERVED_Msk = 0xfffffff8

	// ADOY: Alarm value for Day of Year
	// Position of DOY field.
	RTC_ADOY_DOY_Pos = 0x0
	// Bit mask of DOY field.
	RTC_ADOY_DOY_Msk = 0x1ff
	// Position of RESERVED field.
	RTC_ADOY_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	RTC_ADOY_RESERVED_Msk = 0xfffffe00

	// AMON: Alarm value for Months
	// Position of MONTH field.
	RTC_AMON_MONTH_Pos = 0x0
	// Bit mask of MONTH field.
	RTC_AMON_MONTH_Msk = 0xf
	// Position of RESERVED field.
	RTC_AMON_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RTC_AMON_RESERVED_Msk = 0xfffffff0

	// AYRS: Alarm value for Year
	// Position of YEAR field.
	RTC_AYRS_YEAR_Pos = 0x0
	// Bit mask of YEAR field.
	RTC_AYRS_YEAR_Msk = 0xfff
	// Position of RESERVED field.
	RTC_AYRS_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	RTC_AYRS_RESERVED_Msk = 0xfffff000

	// ERSTATUS: Event Monitor/Recorder Status register. Contains status flags for event channels and other Event Monitor/Recorder conditions.
	// Position of EV0 field.
	RTC_ERSTATUS_EV0_Pos = 0x0
	// Bit mask of EV0 field.
	RTC_ERSTATUS_EV0_Msk = 0x1
	// Bit EV0.
	RTC_ERSTATUS_EV0 = 0x1
	// No event change on channel 0.
	RTC_ERSTATUS_EV0_NO_EVENT_CHANGE_ON_C = 0x0
	// At least one event has occurred on channel 0.
	RTC_ERSTATUS_EV0_AT_LEAST_ONE_EVENT_H = 0x1
	// Position of EV1 field.
	RTC_ERSTATUS_EV1_Pos = 0x1
	// Bit mask of EV1 field.
	RTC_ERSTATUS_EV1_Msk = 0x2
	// Bit EV1.
	RTC_ERSTATUS_EV1 = 0x2
	// No event change on channel 1.
	RTC_ERSTATUS_EV1_NO_EVENT_CHANGE_ON_C = 0x0
	// At least one event has occurred on channel 1.
	RTC_ERSTATUS_EV1_AT_LEAST_ONE_EVENT_H = 0x1
	// Position of EV2 field.
	RTC_ERSTATUS_EV2_Pos = 0x2
	// Bit mask of EV2 field.
	RTC_ERSTATUS_EV2_Msk = 0x4
	// Bit EV2.
	RTC_ERSTATUS_EV2 = 0x4
	// No event change on channel 2.
	RTC_ERSTATUS_EV2_NO_EVENT_CHANGE_ON_C = 0x0
	// At least one event has occurred on channel 2.
	RTC_ERSTATUS_EV2_AT_LEAST_ONE_EVENT_H = 0x1
	// Position of GP_CLEARED field.
	RTC_ERSTATUS_GP_CLEARED_Pos = 0x3
	// Bit mask of GP_CLEARED field.
	RTC_ERSTATUS_GP_CLEARED_Msk = 0x8
	// Bit GP_CLEARED.
	RTC_ERSTATUS_GP_CLEARED = 0x8
	// General purpose registers have not been asynchronous cleared.
	RTC_ERSTATUS_GP_CLEARED_NOGPCLR = 0x0
	// General purpose registers have been asynchronous cleared.
	RTC_ERSTATUS_GP_CLEARED_GPCLR = 0x1
	// Position of RESERVED field.
	RTC_ERSTATUS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RTC_ERSTATUS_RESERVED_Msk = 0x7ffffff0
	// Position of WAKEUP field.
	RTC_ERSTATUS_WAKEUP_Pos = 0x1f
	// Bit mask of WAKEUP field.
	RTC_ERSTATUS_WAKEUP_Msk = 0x80000000
	// Bit WAKEUP.
	RTC_ERSTATUS_WAKEUP = 0x80000000
	// No interrupt/wakeup request is pending
	RTC_ERSTATUS_WAKEUP_NO_INTERRUPTWAKEUP_ = 0x0
	// An interrupt/wakeup request is pending.
	RTC_ERSTATUS_WAKEUP_INTWAKEUP_PEND = 0x1

	// ERCONTROL: Event Monitor/Recorder Control register. Contains bits that control actions for the event channels as well as for Event Monitor/Recorder setup.
	// Position of INTWAKE_EN0 field.
	RTC_ERCONTROL_INTWAKE_EN0_Pos = 0x0
	// Bit mask of INTWAKE_EN0 field.
	RTC_ERCONTROL_INTWAKE_EN0_Msk = 0x1
	// Bit INTWAKE_EN0.
	RTC_ERCONTROL_INTWAKE_EN0 = 0x1
	// No interrupt or wakeup will be generated by event channel 0.
	RTC_ERCONTROL_INTWAKE_EN0_NO_INTERRUPT_OR_WAKE = 0x0
	// An event in channel 0 will trigger an (RTC) interrupt and a wake-up request.
	RTC_ERCONTROL_INTWAKE_EN0_AN_EVENT_IN_CHANNEL_ = 0x1
	// Position of GPCLEAR_EN0 field.
	RTC_ERCONTROL_GPCLEAR_EN0_Pos = 0x1
	// Bit mask of GPCLEAR_EN0 field.
	RTC_ERCONTROL_GPCLEAR_EN0_Msk = 0x2
	// Bit GPCLEAR_EN0.
	RTC_ERCONTROL_GPCLEAR_EN0 = 0x2
	// Channel 0 has no influence on the general purpose registers.
	RTC_ERCONTROL_GPCLEAR_EN0_NOGPREG = 0x0
	// An event in channel 0 will clear the general purpose registers asynchronously.
	RTC_ERCONTROL_GPCLEAR_EN0_CLRGPREG = 0x1
	// Position of POL0 field.
	RTC_ERCONTROL_POL0_Pos = 0x2
	// Bit mask of POL0 field.
	RTC_ERCONTROL_POL0_Msk = 0x4
	// Bit POL0.
	RTC_ERCONTROL_POL0 = 0x4
	// A channel 0 event is defined as a negative edge on RTC_EV0.
	RTC_ERCONTROL_POL0_NEG = 0x0
	// A channel 0 event is defined as a positive edge on RTC_EV0.
	RTC_ERCONTROL_POL0_POS = 0x1
	// Position of EV0_INPUT_EN field.
	RTC_ERCONTROL_EV0_INPUT_EN_Pos = 0x3
	// Bit mask of EV0_INPUT_EN field.
	RTC_ERCONTROL_EV0_INPUT_EN_Msk = 0x8
	// Bit EV0_INPUT_EN.
	RTC_ERCONTROL_EV0_INPUT_EN = 0x8
	// Event 0 input is disabled and forced high internally.
	RTC_ERCONTROL_EV0_INPUT_EN_DISABLED = 0x0
	// Event 0 input is enabled.
	RTC_ERCONTROL_EV0_INPUT_EN_ENABLED = 0x1
	// Position of RESERVED field.
	RTC_ERCONTROL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RTC_ERCONTROL_RESERVED_Msk = 0x3f0
	// Position of INTWAKE_EN1 field.
	RTC_ERCONTROL_INTWAKE_EN1_Pos = 0xa
	// Bit mask of INTWAKE_EN1 field.
	RTC_ERCONTROL_INTWAKE_EN1_Msk = 0x400
	// Bit INTWAKE_EN1.
	RTC_ERCONTROL_INTWAKE_EN1 = 0x400
	// No interrupt or wakeup will be generated by event channel 1.
	RTC_ERCONTROL_INTWAKE_EN1_NO_INTERRUPT_OR_WAKE = 0x0
	// An event in channel 1 will trigger an (RTC) interrupt and a wake-up request.
	RTC_ERCONTROL_INTWAKE_EN1_WAKEUP = 0x1
	// Position of GPCLEAR_EN1 field.
	RTC_ERCONTROL_GPCLEAR_EN1_Pos = 0xb
	// Bit mask of GPCLEAR_EN1 field.
	RTC_ERCONTROL_GPCLEAR_EN1_Msk = 0x800
	// Bit GPCLEAR_EN1.
	RTC_ERCONTROL_GPCLEAR_EN1 = 0x800
	// Channel 1 has no influence on the general purpose registers.
	RTC_ERCONTROL_GPCLEAR_EN1_NOGPREG = 0x0
	// A n event in channel 1 will clear the general purpose registers asynchronously.
	RTC_ERCONTROL_GPCLEAR_EN1_CLRGPREG = 0x1
	// Position of POL1 field.
	RTC_ERCONTROL_POL1_Pos = 0xc
	// Bit mask of POL1 field.
	RTC_ERCONTROL_POL1_Msk = 0x1000
	// Bit POL1.
	RTC_ERCONTROL_POL1 = 0x1000
	// A channel 1 event is defined as a negative edge on RTC_EV1.
	RTC_ERCONTROL_POL1_NEG = 0x0
	// A channel 1 event is defined as a positive edge on RTC_EV1.
	RTC_ERCONTROL_POL1_POS = 0x1
	// Position of EV1_INPUT_EN field.
	RTC_ERCONTROL_EV1_INPUT_EN_Pos = 0xd
	// Bit mask of EV1_INPUT_EN field.
	RTC_ERCONTROL_EV1_INPUT_EN_Msk = 0x2000
	// Bit EV1_INPUT_EN.
	RTC_ERCONTROL_EV1_INPUT_EN = 0x2000
	// Event 1 input is disabled and forced high internally.
	RTC_ERCONTROL_EV1_INPUT_EN_DISABLED = 0x0
	// Event 1 input is enabled.
	RTC_ERCONTROL_EV1_INPUT_EN_ENABLED = 0x1
	// Position of RESERVED field.
	RTC_ERCONTROL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	RTC_ERCONTROL_RESERVED_Msk = 0xfc000
	// Position of INTWAKE_EN2 field.
	RTC_ERCONTROL_INTWAKE_EN2_Pos = 0x14
	// Bit mask of INTWAKE_EN2 field.
	RTC_ERCONTROL_INTWAKE_EN2_Msk = 0x100000
	// Bit INTWAKE_EN2.
	RTC_ERCONTROL_INTWAKE_EN2 = 0x100000
	// No interrupt or wakeup will be generated by event channel 2.
	RTC_ERCONTROL_INTWAKE_EN2_NO_INTERRUPT_OR_WAKE = 0x0
	// An event in channel 2 will trigger an (RTC) interrupt and a wake-up request.
	RTC_ERCONTROL_INTWAKE_EN2_WAKEUP = 0x1
	// Position of GPCLEAR_EN2 field.
	RTC_ERCONTROL_GPCLEAR_EN2_Pos = 0x15
	// Bit mask of GPCLEAR_EN2 field.
	RTC_ERCONTROL_GPCLEAR_EN2_Msk = 0x200000
	// Bit GPCLEAR_EN2.
	RTC_ERCONTROL_GPCLEAR_EN2 = 0x200000
	// Channel 2 has no influence on the general purpose registers.
	RTC_ERCONTROL_GPCLEAR_EN2_NOGPREG = 0x0
	// An event in channel 2 will clear the general purpose registers asynchronously.
	RTC_ERCONTROL_GPCLEAR_EN2_CLRGPREG = 0x1
	// Position of POL2 field.
	RTC_ERCONTROL_POL2_Pos = 0x16
	// Bit mask of POL2 field.
	RTC_ERCONTROL_POL2_Msk = 0x400000
	// Bit POL2.
	RTC_ERCONTROL_POL2 = 0x400000
	// A channel 2 event is defined as a negative edge on RTC_EV2.
	RTC_ERCONTROL_POL2_NEG = 0x0
	// A channel 2 event is defined as a positive edge on RTC_EV2.
	RTC_ERCONTROL_POL2_POS = 0x1
	// Position of EV2_INPUT_EN field.
	RTC_ERCONTROL_EV2_INPUT_EN_Pos = 0x17
	// Bit mask of EV2_INPUT_EN field.
	RTC_ERCONTROL_EV2_INPUT_EN_Msk = 0x800000
	// Bit EV2_INPUT_EN.
	RTC_ERCONTROL_EV2_INPUT_EN = 0x800000
	// Event 2 input is disabled and forced high internally.
	RTC_ERCONTROL_EV2_INPUT_EN_DISABLED = 0x0
	// Event 2 input is enabled.
	RTC_ERCONTROL_EV2_INPUT_EN_ENABLED = 0x1
	// Position of RESERVED field.
	RTC_ERCONTROL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	RTC_ERCONTROL_RESERVED_Msk = 0x3f000000
	// Position of ERMODE field.
	RTC_ERCONTROL_ERMODE_Pos = 0x1e
	// Bit mask of ERMODE field.
	RTC_ERCONTROL_ERMODE_Msk = 0xc0000000
	// Event Monitor/Recorder clocks are disabled. Operation of the Event Monitor/Recorder is disabled except for asynchronous clearing of GP registers if selected.
	RTC_ERCONTROL_ERMODE_DISABLED = 0x0
	// Enable Event Monitor/Recorder and select a 16 Hz sample clock for event input edge detection and glitch suppression. Pulses (in either direction) shorter than 62.5 ms to 125 ms will be filtered out.
	RTC_ERCONTROL_ERMODE_ENABLE_EVENT_MONITOR16HZ = 0x1
	// Enable Event Monitor/Recorder and select a 64 Hz sample clock for event input edge detection and glitch suppression. Pulses (in either direction) shorter than 15.6 ms to 31.2 ms will be filtered out.
	RTC_ERCONTROL_ERMODE_ENABLE_EVENT_MONITOR64HZ = 0x2
	// Enable Event Monitor/Recorder and select a 1 kHz sample clock for event input edge detection and glitch suppression. Pulses (in either direction) shorter than 1 ms to 2 ms will be filtered out.
	RTC_ERCONTROL_ERMODE_ENABLE_EVENT_MONITOR1KHZ = 0x3

	// ERCOUNTERS: Event Monitor/Recorder Counters register. Allows reading the counters associated with the event channels.
	// Position of COUNTER0 field.
	RTC_ERCOUNTERS_COUNTER0_Pos = 0x0
	// Bit mask of COUNTER0 field.
	RTC_ERCOUNTERS_COUNTER0_Msk = 0x7
	// Position of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Msk = 0xf8
	// Position of COUNTER1 field.
	RTC_ERCOUNTERS_COUNTER1_Pos = 0x8
	// Bit mask of COUNTER1 field.
	RTC_ERCOUNTERS_COUNTER1_Msk = 0x700
	// Position of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Msk = 0xf800
	// Position of COUNTER2 field.
	RTC_ERCOUNTERS_COUNTER2_Pos = 0x10
	// Bit mask of COUNTER2 field.
	RTC_ERCOUNTERS_COUNTER2_Msk = 0x70000
	// Position of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	RTC_ERCOUNTERS_RESERVED_Msk = 0xfff80000

	// ERFIRSTSTAMP0: Event Monitor/Recorder First Stamp register for channel 0. Retains the time stamp for the first event on channel 0.
	// Position of SEC field.
	RTC_ERFIRSTSTAMP_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_ERFIRSTSTAMP_SEC_Msk = 0x3f
	// Position of MIN field.
	RTC_ERFIRSTSTAMP_MIN_Pos = 0x6
	// Bit mask of MIN field.
	RTC_ERFIRSTSTAMP_MIN_Msk = 0xfc0
	// Position of HOUR field.
	RTC_ERFIRSTSTAMP_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	RTC_ERFIRSTSTAMP_HOUR_Msk = 0x1f000
	// Position of DOY field.
	RTC_ERFIRSTSTAMP_DOY_Pos = 0x11
	// Bit mask of DOY field.
	RTC_ERFIRSTSTAMP_DOY_Msk = 0x3fe0000
	// Position of RESERVED field.
	RTC_ERFIRSTSTAMP_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	RTC_ERFIRSTSTAMP_RESERVED_Msk = 0xfc000000

	// ERLASTSTAMP0: Event Monitor/Recorder Last Stamp register for channel 0. Retains the time stamp for the last (i.e. most recent) event on channel 0.
	// Position of SEC field.
	RTC_ERLASTSTAMP_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_ERLASTSTAMP_SEC_Msk = 0x3f
	// Position of MIN field.
	RTC_ERLASTSTAMP_MIN_Pos = 0x6
	// Bit mask of MIN field.
	RTC_ERLASTSTAMP_MIN_Msk = 0xfc0
	// Position of HOUR field.
	RTC_ERLASTSTAMP_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	RTC_ERLASTSTAMP_HOUR_Msk = 0x1f000
	// Position of DOY field.
	RTC_ERLASTSTAMP_DOY_Pos = 0x11
	// Bit mask of DOY field.
	RTC_ERLASTSTAMP_DOY_Msk = 0x3fe0000
	// Position of RESERVED field.
	RTC_ERLASTSTAMP_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	RTC_ERLASTSTAMP_RESERVED_Msk = 0xfc000000
)

// Bitfields for GPIOINT: GPIO
const (
	// STATUS: GPIO overall Interrupt Status.
	// Position of P0Int field.
	GPIOINT_STATUS_P0Int_Pos = 0x0
	// Bit mask of P0Int field.
	GPIOINT_STATUS_P0Int_Msk = 0x1
	// Bit P0Int.
	GPIOINT_STATUS_P0Int = 0x1
	// No pending interrupts on Port 0.
	GPIOINT_STATUS_P0Int_NO_PENDING_INTERRUPT = 0x0
	// At least one pending interrupt on Port 0.
	GPIOINT_STATUS_P0Int_AT_LEAST_ONE_PENDING = 0x1
	// Position of RESERVED field.
	GPIOINT_STATUS_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	GPIOINT_STATUS_RESERVED_Msk = 0x2
	// Bit RESERVED.
	GPIOINT_STATUS_RESERVED = 0x2
	// Position of P2Int field.
	GPIOINT_STATUS_P2Int_Pos = 0x2
	// Bit mask of P2Int field.
	GPIOINT_STATUS_P2Int_Msk = 0x4
	// Bit P2Int.
	GPIOINT_STATUS_P2Int = 0x4
	// No pending interrupts on Port 2.
	GPIOINT_STATUS_P2Int_NO_PENDING_INTERRUPT = 0x0
	// At least one pending interrupt on Port 2.
	GPIOINT_STATUS_P2Int_AT_LEAST_ONE_PENDING = 0x1
	// Position of RESERVED field.
	GPIOINT_STATUS_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	GPIOINT_STATUS_RESERVED_Msk = 0xfffffffc

	// STATR0: GPIO Interrupt Status for Rising edge for Port 0.
	// Position of P0_0REI field.
	GPIOINT_STATR0_P0_0REI_Pos = 0x0
	// Bit mask of P0_0REI field.
	GPIOINT_STATR0_P0_0REI_Msk = 0x1
	// Bit P0_0REI.
	GPIOINT_STATR0_P0_0REI = 0x1
	// Position of P0_1REI field.
	GPIOINT_STATR0_P0_1REI_Pos = 0x1
	// Bit mask of P0_1REI field.
	GPIOINT_STATR0_P0_1REI_Msk = 0x2
	// Bit P0_1REI.
	GPIOINT_STATR0_P0_1REI = 0x2
	// Position of P0_2REI field.
	GPIOINT_STATR0_P0_2REI_Pos = 0x2
	// Bit mask of P0_2REI field.
	GPIOINT_STATR0_P0_2REI_Msk = 0x4
	// Bit P0_2REI.
	GPIOINT_STATR0_P0_2REI = 0x4
	// Position of P0_3REI field.
	GPIOINT_STATR0_P0_3REI_Pos = 0x3
	// Bit mask of P0_3REI field.
	GPIOINT_STATR0_P0_3REI_Msk = 0x8
	// Bit P0_3REI.
	GPIOINT_STATR0_P0_3REI = 0x8
	// Position of P0_4REI field.
	GPIOINT_STATR0_P0_4REI_Pos = 0x4
	// Bit mask of P0_4REI field.
	GPIOINT_STATR0_P0_4REI_Msk = 0x10
	// Bit P0_4REI.
	GPIOINT_STATR0_P0_4REI = 0x10
	// Position of P0_5REI field.
	GPIOINT_STATR0_P0_5REI_Pos = 0x5
	// Bit mask of P0_5REI field.
	GPIOINT_STATR0_P0_5REI_Msk = 0x20
	// Bit P0_5REI.
	GPIOINT_STATR0_P0_5REI = 0x20
	// Position of P0_6REI field.
	GPIOINT_STATR0_P0_6REI_Pos = 0x6
	// Bit mask of P0_6REI field.
	GPIOINT_STATR0_P0_6REI_Msk = 0x40
	// Bit P0_6REI.
	GPIOINT_STATR0_P0_6REI = 0x40
	// Position of P0_7REI field.
	GPIOINT_STATR0_P0_7REI_Pos = 0x7
	// Bit mask of P0_7REI field.
	GPIOINT_STATR0_P0_7REI_Msk = 0x80
	// Bit P0_7REI.
	GPIOINT_STATR0_P0_7REI = 0x80
	// Position of P0_8REI field.
	GPIOINT_STATR0_P0_8REI_Pos = 0x8
	// Bit mask of P0_8REI field.
	GPIOINT_STATR0_P0_8REI_Msk = 0x100
	// Bit P0_8REI.
	GPIOINT_STATR0_P0_8REI = 0x100
	// Position of P0_9REI field.
	GPIOINT_STATR0_P0_9REI_Pos = 0x9
	// Bit mask of P0_9REI field.
	GPIOINT_STATR0_P0_9REI_Msk = 0x200
	// Bit P0_9REI.
	GPIOINT_STATR0_P0_9REI = 0x200
	// Position of P0_10REI field.
	GPIOINT_STATR0_P0_10REI_Pos = 0xa
	// Bit mask of P0_10REI field.
	GPIOINT_STATR0_P0_10REI_Msk = 0x400
	// Bit P0_10REI.
	GPIOINT_STATR0_P0_10REI = 0x400
	// Position of P0_11REI field.
	GPIOINT_STATR0_P0_11REI_Pos = 0xb
	// Bit mask of P0_11REI field.
	GPIOINT_STATR0_P0_11REI_Msk = 0x800
	// Bit P0_11REI.
	GPIOINT_STATR0_P0_11REI = 0x800
	// Position of P0_12REI field.
	GPIOINT_STATR0_P0_12REI_Pos = 0xc
	// Bit mask of P0_12REI field.
	GPIOINT_STATR0_P0_12REI_Msk = 0x1000
	// Bit P0_12REI.
	GPIOINT_STATR0_P0_12REI = 0x1000
	// Position of P0_13REI field.
	GPIOINT_STATR0_P0_13REI_Pos = 0xd
	// Bit mask of P0_13REI field.
	GPIOINT_STATR0_P0_13REI_Msk = 0x2000
	// Bit P0_13REI.
	GPIOINT_STATR0_P0_13REI = 0x2000
	// Position of P0_14REI field.
	GPIOINT_STATR0_P0_14REI_Pos = 0xe
	// Bit mask of P0_14REI field.
	GPIOINT_STATR0_P0_14REI_Msk = 0x4000
	// Bit P0_14REI.
	GPIOINT_STATR0_P0_14REI = 0x4000
	// Position of P0_15REI field.
	GPIOINT_STATR0_P0_15REI_Pos = 0xf
	// Bit mask of P0_15REI field.
	GPIOINT_STATR0_P0_15REI_Msk = 0x8000
	// Bit P0_15REI.
	GPIOINT_STATR0_P0_15REI = 0x8000
	// Position of P0_16REI field.
	GPIOINT_STATR0_P0_16REI_Pos = 0x10
	// Bit mask of P0_16REI field.
	GPIOINT_STATR0_P0_16REI_Msk = 0x10000
	// Bit P0_16REI.
	GPIOINT_STATR0_P0_16REI = 0x10000
	// Position of P0_17REI field.
	GPIOINT_STATR0_P0_17REI_Pos = 0x11
	// Bit mask of P0_17REI field.
	GPIOINT_STATR0_P0_17REI_Msk = 0x20000
	// Bit P0_17REI.
	GPIOINT_STATR0_P0_17REI = 0x20000
	// Position of P0_18REI field.
	GPIOINT_STATR0_P0_18REI_Pos = 0x12
	// Bit mask of P0_18REI field.
	GPIOINT_STATR0_P0_18REI_Msk = 0x40000
	// Bit P0_18REI.
	GPIOINT_STATR0_P0_18REI = 0x40000
	// Position of P0_19REI field.
	GPIOINT_STATR0_P0_19REI_Pos = 0x13
	// Bit mask of P0_19REI field.
	GPIOINT_STATR0_P0_19REI_Msk = 0x80000
	// Bit P0_19REI.
	GPIOINT_STATR0_P0_19REI = 0x80000
	// Position of P0_20REI field.
	GPIOINT_STATR0_P0_20REI_Pos = 0x14
	// Bit mask of P0_20REI field.
	GPIOINT_STATR0_P0_20REI_Msk = 0x100000
	// Bit P0_20REI.
	GPIOINT_STATR0_P0_20REI = 0x100000
	// Position of P0_21REI field.
	GPIOINT_STATR0_P0_21REI_Pos = 0x15
	// Bit mask of P0_21REI field.
	GPIOINT_STATR0_P0_21REI_Msk = 0x200000
	// Bit P0_21REI.
	GPIOINT_STATR0_P0_21REI = 0x200000
	// Position of P0_22REI field.
	GPIOINT_STATR0_P0_22REI_Pos = 0x16
	// Bit mask of P0_22REI field.
	GPIOINT_STATR0_P0_22REI_Msk = 0x400000
	// Bit P0_22REI.
	GPIOINT_STATR0_P0_22REI = 0x400000
	// Position of P0_23REI field.
	GPIOINT_STATR0_P0_23REI_Pos = 0x17
	// Bit mask of P0_23REI field.
	GPIOINT_STATR0_P0_23REI_Msk = 0x800000
	// Bit P0_23REI.
	GPIOINT_STATR0_P0_23REI = 0x800000
	// Position of P0_24REI field.
	GPIOINT_STATR0_P0_24REI_Pos = 0x18
	// Bit mask of P0_24REI field.
	GPIOINT_STATR0_P0_24REI_Msk = 0x1000000
	// Bit P0_24REI.
	GPIOINT_STATR0_P0_24REI = 0x1000000
	// Position of P0_25REI field.
	GPIOINT_STATR0_P0_25REI_Pos = 0x19
	// Bit mask of P0_25REI field.
	GPIOINT_STATR0_P0_25REI_Msk = 0x2000000
	// Bit P0_25REI.
	GPIOINT_STATR0_P0_25REI = 0x2000000
	// Position of P0_26REI field.
	GPIOINT_STATR0_P0_26REI_Pos = 0x1a
	// Bit mask of P0_26REI field.
	GPIOINT_STATR0_P0_26REI_Msk = 0x4000000
	// Bit P0_26REI.
	GPIOINT_STATR0_P0_26REI = 0x4000000
	// Position of P0_27REI field.
	GPIOINT_STATR0_P0_27REI_Pos = 0x1b
	// Bit mask of P0_27REI field.
	GPIOINT_STATR0_P0_27REI_Msk = 0x8000000
	// Bit P0_27REI.
	GPIOINT_STATR0_P0_27REI = 0x8000000
	// Position of P0_28REI field.
	GPIOINT_STATR0_P0_28REI_Pos = 0x1c
	// Bit mask of P0_28REI field.
	GPIOINT_STATR0_P0_28REI_Msk = 0x10000000
	// Bit P0_28REI.
	GPIOINT_STATR0_P0_28REI = 0x10000000
	// Position of P0_29REI field.
	GPIOINT_STATR0_P0_29REI_Pos = 0x1d
	// Bit mask of P0_29REI field.
	GPIOINT_STATR0_P0_29REI_Msk = 0x20000000
	// Bit P0_29REI.
	GPIOINT_STATR0_P0_29REI = 0x20000000
	// Position of P0_30REI field.
	GPIOINT_STATR0_P0_30REI_Pos = 0x1e
	// Bit mask of P0_30REI field.
	GPIOINT_STATR0_P0_30REI_Msk = 0x40000000
	// Bit P0_30REI.
	GPIOINT_STATR0_P0_30REI = 0x40000000
	// Position of P0_31REI field.
	GPIOINT_STATR0_P0_31REI_Pos = 0x1f
	// Bit mask of P0_31REI field.
	GPIOINT_STATR0_P0_31REI_Msk = 0x80000000
	// Bit P0_31REI.
	GPIOINT_STATR0_P0_31REI = 0x80000000

	// STATF0: GPIO Interrupt Status for Falling edge for Port 0.
	// Position of P0_0FEI field.
	GPIOINT_STATF0_P0_0FEI_Pos = 0x0
	// Bit mask of P0_0FEI field.
	GPIOINT_STATF0_P0_0FEI_Msk = 0x1
	// Bit P0_0FEI.
	GPIOINT_STATF0_P0_0FEI = 0x1
	// Position of P0_1FEI field.
	GPIOINT_STATF0_P0_1FEI_Pos = 0x1
	// Bit mask of P0_1FEI field.
	GPIOINT_STATF0_P0_1FEI_Msk = 0x2
	// Bit P0_1FEI.
	GPIOINT_STATF0_P0_1FEI = 0x2
	// Position of P0_2FEI field.
	GPIOINT_STATF0_P0_2FEI_Pos = 0x2
	// Bit mask of P0_2FEI field.
	GPIOINT_STATF0_P0_2FEI_Msk = 0x4
	// Bit P0_2FEI.
	GPIOINT_STATF0_P0_2FEI = 0x4
	// Position of P0_3FEI field.
	GPIOINT_STATF0_P0_3FEI_Pos = 0x3
	// Bit mask of P0_3FEI field.
	GPIOINT_STATF0_P0_3FEI_Msk = 0x8
	// Bit P0_3FEI.
	GPIOINT_STATF0_P0_3FEI = 0x8
	// Position of P0_4FEI field.
	GPIOINT_STATF0_P0_4FEI_Pos = 0x4
	// Bit mask of P0_4FEI field.
	GPIOINT_STATF0_P0_4FEI_Msk = 0x10
	// Bit P0_4FEI.
	GPIOINT_STATF0_P0_4FEI = 0x10
	// Position of P0_5FEI field.
	GPIOINT_STATF0_P0_5FEI_Pos = 0x5
	// Bit mask of P0_5FEI field.
	GPIOINT_STATF0_P0_5FEI_Msk = 0x20
	// Bit P0_5FEI.
	GPIOINT_STATF0_P0_5FEI = 0x20
	// Position of P0_6FEI field.
	GPIOINT_STATF0_P0_6FEI_Pos = 0x6
	// Bit mask of P0_6FEI field.
	GPIOINT_STATF0_P0_6FEI_Msk = 0x40
	// Bit P0_6FEI.
	GPIOINT_STATF0_P0_6FEI = 0x40
	// Position of P0_7FEI field.
	GPIOINT_STATF0_P0_7FEI_Pos = 0x7
	// Bit mask of P0_7FEI field.
	GPIOINT_STATF0_P0_7FEI_Msk = 0x80
	// Bit P0_7FEI.
	GPIOINT_STATF0_P0_7FEI = 0x80
	// Position of P0_8FEI field.
	GPIOINT_STATF0_P0_8FEI_Pos = 0x8
	// Bit mask of P0_8FEI field.
	GPIOINT_STATF0_P0_8FEI_Msk = 0x100
	// Bit P0_8FEI.
	GPIOINT_STATF0_P0_8FEI = 0x100
	// Position of P0_9FEI field.
	GPIOINT_STATF0_P0_9FEI_Pos = 0x9
	// Bit mask of P0_9FEI field.
	GPIOINT_STATF0_P0_9FEI_Msk = 0x200
	// Bit P0_9FEI.
	GPIOINT_STATF0_P0_9FEI = 0x200
	// Position of P0_10FEI field.
	GPIOINT_STATF0_P0_10FEI_Pos = 0xa
	// Bit mask of P0_10FEI field.
	GPIOINT_STATF0_P0_10FEI_Msk = 0x400
	// Bit P0_10FEI.
	GPIOINT_STATF0_P0_10FEI = 0x400
	// Position of P0_11FEI field.
	GPIOINT_STATF0_P0_11FEI_Pos = 0xb
	// Bit mask of P0_11FEI field.
	GPIOINT_STATF0_P0_11FEI_Msk = 0x800
	// Bit P0_11FEI.
	GPIOINT_STATF0_P0_11FEI = 0x800
	// Position of P0_12FEI field.
	GPIOINT_STATF0_P0_12FEI_Pos = 0xc
	// Bit mask of P0_12FEI field.
	GPIOINT_STATF0_P0_12FEI_Msk = 0x1000
	// Bit P0_12FEI.
	GPIOINT_STATF0_P0_12FEI = 0x1000
	// Position of P0_13FEI field.
	GPIOINT_STATF0_P0_13FEI_Pos = 0xd
	// Bit mask of P0_13FEI field.
	GPIOINT_STATF0_P0_13FEI_Msk = 0x2000
	// Bit P0_13FEI.
	GPIOINT_STATF0_P0_13FEI = 0x2000
	// Position of P0_14FEI field.
	GPIOINT_STATF0_P0_14FEI_Pos = 0xe
	// Bit mask of P0_14FEI field.
	GPIOINT_STATF0_P0_14FEI_Msk = 0x4000
	// Bit P0_14FEI.
	GPIOINT_STATF0_P0_14FEI = 0x4000
	// Position of P0_15FEI field.
	GPIOINT_STATF0_P0_15FEI_Pos = 0xf
	// Bit mask of P0_15FEI field.
	GPIOINT_STATF0_P0_15FEI_Msk = 0x8000
	// Bit P0_15FEI.
	GPIOINT_STATF0_P0_15FEI = 0x8000
	// Position of P0_16FEI field.
	GPIOINT_STATF0_P0_16FEI_Pos = 0x10
	// Bit mask of P0_16FEI field.
	GPIOINT_STATF0_P0_16FEI_Msk = 0x10000
	// Bit P0_16FEI.
	GPIOINT_STATF0_P0_16FEI = 0x10000
	// Position of P0_17FEI field.
	GPIOINT_STATF0_P0_17FEI_Pos = 0x11
	// Bit mask of P0_17FEI field.
	GPIOINT_STATF0_P0_17FEI_Msk = 0x20000
	// Bit P0_17FEI.
	GPIOINT_STATF0_P0_17FEI = 0x20000
	// Position of P0_18FEI field.
	GPIOINT_STATF0_P0_18FEI_Pos = 0x12
	// Bit mask of P0_18FEI field.
	GPIOINT_STATF0_P0_18FEI_Msk = 0x40000
	// Bit P0_18FEI.
	GPIOINT_STATF0_P0_18FEI = 0x40000
	// Position of P0_19FEI field.
	GPIOINT_STATF0_P0_19FEI_Pos = 0x13
	// Bit mask of P0_19FEI field.
	GPIOINT_STATF0_P0_19FEI_Msk = 0x80000
	// Bit P0_19FEI.
	GPIOINT_STATF0_P0_19FEI = 0x80000
	// Position of P0_20FEI field.
	GPIOINT_STATF0_P0_20FEI_Pos = 0x14
	// Bit mask of P0_20FEI field.
	GPIOINT_STATF0_P0_20FEI_Msk = 0x100000
	// Bit P0_20FEI.
	GPIOINT_STATF0_P0_20FEI = 0x100000
	// Position of P0_21FEI field.
	GPIOINT_STATF0_P0_21FEI_Pos = 0x15
	// Bit mask of P0_21FEI field.
	GPIOINT_STATF0_P0_21FEI_Msk = 0x200000
	// Bit P0_21FEI.
	GPIOINT_STATF0_P0_21FEI = 0x200000
	// Position of P0_22FEI field.
	GPIOINT_STATF0_P0_22FEI_Pos = 0x16
	// Bit mask of P0_22FEI field.
	GPIOINT_STATF0_P0_22FEI_Msk = 0x400000
	// Bit P0_22FEI.
	GPIOINT_STATF0_P0_22FEI = 0x400000
	// Position of P0_23FEI field.
	GPIOINT_STATF0_P0_23FEI_Pos = 0x17
	// Bit mask of P0_23FEI field.
	GPIOINT_STATF0_P0_23FEI_Msk = 0x800000
	// Bit P0_23FEI.
	GPIOINT_STATF0_P0_23FEI = 0x800000
	// Position of P0_24FEI field.
	GPIOINT_STATF0_P0_24FEI_Pos = 0x18
	// Bit mask of P0_24FEI field.
	GPIOINT_STATF0_P0_24FEI_Msk = 0x1000000
	// Bit P0_24FEI.
	GPIOINT_STATF0_P0_24FEI = 0x1000000
	// Position of P0_25FEI field.
	GPIOINT_STATF0_P0_25FEI_Pos = 0x19
	// Bit mask of P0_25FEI field.
	GPIOINT_STATF0_P0_25FEI_Msk = 0x2000000
	// Bit P0_25FEI.
	GPIOINT_STATF0_P0_25FEI = 0x2000000
	// Position of P0_26FEI field.
	GPIOINT_STATF0_P0_26FEI_Pos = 0x1a
	// Bit mask of P0_26FEI field.
	GPIOINT_STATF0_P0_26FEI_Msk = 0x4000000
	// Bit P0_26FEI.
	GPIOINT_STATF0_P0_26FEI = 0x4000000
	// Position of P0_27FEI field.
	GPIOINT_STATF0_P0_27FEI_Pos = 0x1b
	// Bit mask of P0_27FEI field.
	GPIOINT_STATF0_P0_27FEI_Msk = 0x8000000
	// Bit P0_27FEI.
	GPIOINT_STATF0_P0_27FEI = 0x8000000
	// Position of P0_28FEI field.
	GPIOINT_STATF0_P0_28FEI_Pos = 0x1c
	// Bit mask of P0_28FEI field.
	GPIOINT_STATF0_P0_28FEI_Msk = 0x10000000
	// Bit P0_28FEI.
	GPIOINT_STATF0_P0_28FEI = 0x10000000
	// Position of P0_29FEI field.
	GPIOINT_STATF0_P0_29FEI_Pos = 0x1d
	// Bit mask of P0_29FEI field.
	GPIOINT_STATF0_P0_29FEI_Msk = 0x20000000
	// Bit P0_29FEI.
	GPIOINT_STATF0_P0_29FEI = 0x20000000
	// Position of P0_30FEI field.
	GPIOINT_STATF0_P0_30FEI_Pos = 0x1e
	// Bit mask of P0_30FEI field.
	GPIOINT_STATF0_P0_30FEI_Msk = 0x40000000
	// Bit P0_30FEI.
	GPIOINT_STATF0_P0_30FEI = 0x40000000
	// Position of P0_31FEI field.
	GPIOINT_STATF0_P0_31FEI_Pos = 0x1f
	// Bit mask of P0_31FEI field.
	GPIOINT_STATF0_P0_31FEI_Msk = 0x80000000
	// Bit P0_31FEI.
	GPIOINT_STATF0_P0_31FEI = 0x80000000

	// CLR0: GPIO Interrupt Clear.
	// Position of P0_0CI field.
	GPIOINT_CLR0_P0_0CI_Pos = 0x0
	// Bit mask of P0_0CI field.
	GPIOINT_CLR0_P0_0CI_Msk = 0x1
	// Bit P0_0CI.
	GPIOINT_CLR0_P0_0CI = 0x1
	// Position of P0_1CI field.
	GPIOINT_CLR0_P0_1CI_Pos = 0x1
	// Bit mask of P0_1CI field.
	GPIOINT_CLR0_P0_1CI_Msk = 0x2
	// Bit P0_1CI.
	GPIOINT_CLR0_P0_1CI = 0x2
	// Position of P0_2CI field.
	GPIOINT_CLR0_P0_2CI_Pos = 0x2
	// Bit mask of P0_2CI field.
	GPIOINT_CLR0_P0_2CI_Msk = 0x4
	// Bit P0_2CI.
	GPIOINT_CLR0_P0_2CI = 0x4
	// Position of P0_3CI field.
	GPIOINT_CLR0_P0_3CI_Pos = 0x3
	// Bit mask of P0_3CI field.
	GPIOINT_CLR0_P0_3CI_Msk = 0x8
	// Bit P0_3CI.
	GPIOINT_CLR0_P0_3CI = 0x8
	// Position of P0_4CI field.
	GPIOINT_CLR0_P0_4CI_Pos = 0x4
	// Bit mask of P0_4CI field.
	GPIOINT_CLR0_P0_4CI_Msk = 0x10
	// Bit P0_4CI.
	GPIOINT_CLR0_P0_4CI = 0x10
	// Position of P0_5CI field.
	GPIOINT_CLR0_P0_5CI_Pos = 0x5
	// Bit mask of P0_5CI field.
	GPIOINT_CLR0_P0_5CI_Msk = 0x20
	// Bit P0_5CI.
	GPIOINT_CLR0_P0_5CI = 0x20
	// Position of P0_6CI field.
	GPIOINT_CLR0_P0_6CI_Pos = 0x6
	// Bit mask of P0_6CI field.
	GPIOINT_CLR0_P0_6CI_Msk = 0x40
	// Bit P0_6CI.
	GPIOINT_CLR0_P0_6CI = 0x40
	// Position of P0_7CI field.
	GPIOINT_CLR0_P0_7CI_Pos = 0x7
	// Bit mask of P0_7CI field.
	GPIOINT_CLR0_P0_7CI_Msk = 0x80
	// Bit P0_7CI.
	GPIOINT_CLR0_P0_7CI = 0x80
	// Position of P0_8CI field.
	GPIOINT_CLR0_P0_8CI_Pos = 0x8
	// Bit mask of P0_8CI field.
	GPIOINT_CLR0_P0_8CI_Msk = 0x100
	// Bit P0_8CI.
	GPIOINT_CLR0_P0_8CI = 0x100
	// Position of P0_9CI field.
	GPIOINT_CLR0_P0_9CI_Pos = 0x9
	// Bit mask of P0_9CI field.
	GPIOINT_CLR0_P0_9CI_Msk = 0x200
	// Bit P0_9CI.
	GPIOINT_CLR0_P0_9CI = 0x200
	// Position of P0_10CI field.
	GPIOINT_CLR0_P0_10CI_Pos = 0xa
	// Bit mask of P0_10CI field.
	GPIOINT_CLR0_P0_10CI_Msk = 0x400
	// Bit P0_10CI.
	GPIOINT_CLR0_P0_10CI = 0x400
	// Position of P0_11CI field.
	GPIOINT_CLR0_P0_11CI_Pos = 0xb
	// Bit mask of P0_11CI field.
	GPIOINT_CLR0_P0_11CI_Msk = 0x800
	// Bit P0_11CI.
	GPIOINT_CLR0_P0_11CI = 0x800
	// Position of P0_12CI field.
	GPIOINT_CLR0_P0_12CI_Pos = 0xc
	// Bit mask of P0_12CI field.
	GPIOINT_CLR0_P0_12CI_Msk = 0x1000
	// Bit P0_12CI.
	GPIOINT_CLR0_P0_12CI = 0x1000
	// Position of P0_13CI field.
	GPIOINT_CLR0_P0_13CI_Pos = 0xd
	// Bit mask of P0_13CI field.
	GPIOINT_CLR0_P0_13CI_Msk = 0x2000
	// Bit P0_13CI.
	GPIOINT_CLR0_P0_13CI = 0x2000
	// Position of P0_14CI field.
	GPIOINT_CLR0_P0_14CI_Pos = 0xe
	// Bit mask of P0_14CI field.
	GPIOINT_CLR0_P0_14CI_Msk = 0x4000
	// Bit P0_14CI.
	GPIOINT_CLR0_P0_14CI = 0x4000
	// Position of P0_15CI field.
	GPIOINT_CLR0_P0_15CI_Pos = 0xf
	// Bit mask of P0_15CI field.
	GPIOINT_CLR0_P0_15CI_Msk = 0x8000
	// Bit P0_15CI.
	GPIOINT_CLR0_P0_15CI = 0x8000
	// Position of P0_16CI field.
	GPIOINT_CLR0_P0_16CI_Pos = 0x10
	// Bit mask of P0_16CI field.
	GPIOINT_CLR0_P0_16CI_Msk = 0x10000
	// Bit P0_16CI.
	GPIOINT_CLR0_P0_16CI = 0x10000
	// Position of P0_17CI field.
	GPIOINT_CLR0_P0_17CI_Pos = 0x11
	// Bit mask of P0_17CI field.
	GPIOINT_CLR0_P0_17CI_Msk = 0x20000
	// Bit P0_17CI.
	GPIOINT_CLR0_P0_17CI = 0x20000
	// Position of P0_18CI field.
	GPIOINT_CLR0_P0_18CI_Pos = 0x12
	// Bit mask of P0_18CI field.
	GPIOINT_CLR0_P0_18CI_Msk = 0x40000
	// Bit P0_18CI.
	GPIOINT_CLR0_P0_18CI = 0x40000
	// Position of P0_19CI field.
	GPIOINT_CLR0_P0_19CI_Pos = 0x13
	// Bit mask of P0_19CI field.
	GPIOINT_CLR0_P0_19CI_Msk = 0x80000
	// Bit P0_19CI.
	GPIOINT_CLR0_P0_19CI = 0x80000
	// Position of P0_20CI field.
	GPIOINT_CLR0_P0_20CI_Pos = 0x14
	// Bit mask of P0_20CI field.
	GPIOINT_CLR0_P0_20CI_Msk = 0x100000
	// Bit P0_20CI.
	GPIOINT_CLR0_P0_20CI = 0x100000
	// Position of P0_21CI field.
	GPIOINT_CLR0_P0_21CI_Pos = 0x15
	// Bit mask of P0_21CI field.
	GPIOINT_CLR0_P0_21CI_Msk = 0x200000
	// Bit P0_21CI.
	GPIOINT_CLR0_P0_21CI = 0x200000
	// Position of P0_22CI field.
	GPIOINT_CLR0_P0_22CI_Pos = 0x16
	// Bit mask of P0_22CI field.
	GPIOINT_CLR0_P0_22CI_Msk = 0x400000
	// Bit P0_22CI.
	GPIOINT_CLR0_P0_22CI = 0x400000
	// Position of P0_23CI field.
	GPIOINT_CLR0_P0_23CI_Pos = 0x17
	// Bit mask of P0_23CI field.
	GPIOINT_CLR0_P0_23CI_Msk = 0x800000
	// Bit P0_23CI.
	GPIOINT_CLR0_P0_23CI = 0x800000
	// Position of P0_24CI field.
	GPIOINT_CLR0_P0_24CI_Pos = 0x18
	// Bit mask of P0_24CI field.
	GPIOINT_CLR0_P0_24CI_Msk = 0x1000000
	// Bit P0_24CI.
	GPIOINT_CLR0_P0_24CI = 0x1000000
	// Position of P0_25CI field.
	GPIOINT_CLR0_P0_25CI_Pos = 0x19
	// Bit mask of P0_25CI field.
	GPIOINT_CLR0_P0_25CI_Msk = 0x2000000
	// Bit P0_25CI.
	GPIOINT_CLR0_P0_25CI = 0x2000000
	// Position of P0_26CI field.
	GPIOINT_CLR0_P0_26CI_Pos = 0x1a
	// Bit mask of P0_26CI field.
	GPIOINT_CLR0_P0_26CI_Msk = 0x4000000
	// Bit P0_26CI.
	GPIOINT_CLR0_P0_26CI = 0x4000000
	// Position of P0_27CI field.
	GPIOINT_CLR0_P0_27CI_Pos = 0x1b
	// Bit mask of P0_27CI field.
	GPIOINT_CLR0_P0_27CI_Msk = 0x8000000
	// Bit P0_27CI.
	GPIOINT_CLR0_P0_27CI = 0x8000000
	// Position of P0_28CI field.
	GPIOINT_CLR0_P0_28CI_Pos = 0x1c
	// Bit mask of P0_28CI field.
	GPIOINT_CLR0_P0_28CI_Msk = 0x10000000
	// Bit P0_28CI.
	GPIOINT_CLR0_P0_28CI = 0x10000000
	// Position of P0_29CI field.
	GPIOINT_CLR0_P0_29CI_Pos = 0x1d
	// Bit mask of P0_29CI field.
	GPIOINT_CLR0_P0_29CI_Msk = 0x20000000
	// Bit P0_29CI.
	GPIOINT_CLR0_P0_29CI = 0x20000000
	// Position of P0_30CI field.
	GPIOINT_CLR0_P0_30CI_Pos = 0x1e
	// Bit mask of P0_30CI field.
	GPIOINT_CLR0_P0_30CI_Msk = 0x40000000
	// Bit P0_30CI.
	GPIOINT_CLR0_P0_30CI = 0x40000000
	// Position of P0_31CI field.
	GPIOINT_CLR0_P0_31CI_Pos = 0x1f
	// Bit mask of P0_31CI field.
	GPIOINT_CLR0_P0_31CI_Msk = 0x80000000
	// Bit P0_31CI.
	GPIOINT_CLR0_P0_31CI = 0x80000000

	// ENR0: GPIO Interrupt Enable for Rising edge for Port 0.
	// Position of P0_0ER field.
	GPIOINT_ENR0_P0_0ER_Pos = 0x0
	// Bit mask of P0_0ER field.
	GPIOINT_ENR0_P0_0ER_Msk = 0x1
	// Bit P0_0ER.
	GPIOINT_ENR0_P0_0ER = 0x1
	// Position of P0_1ER field.
	GPIOINT_ENR0_P0_1ER_Pos = 0x1
	// Bit mask of P0_1ER field.
	GPIOINT_ENR0_P0_1ER_Msk = 0x2
	// Bit P0_1ER.
	GPIOINT_ENR0_P0_1ER = 0x2
	// Position of P0_2ER field.
	GPIOINT_ENR0_P0_2ER_Pos = 0x2
	// Bit mask of P0_2ER field.
	GPIOINT_ENR0_P0_2ER_Msk = 0x4
	// Bit P0_2ER.
	GPIOINT_ENR0_P0_2ER = 0x4
	// Position of P0_3ER field.
	GPIOINT_ENR0_P0_3ER_Pos = 0x3
	// Bit mask of P0_3ER field.
	GPIOINT_ENR0_P0_3ER_Msk = 0x8
	// Bit P0_3ER.
	GPIOINT_ENR0_P0_3ER = 0x8
	// Position of P0_4ER field.
	GPIOINT_ENR0_P0_4ER_Pos = 0x4
	// Bit mask of P0_4ER field.
	GPIOINT_ENR0_P0_4ER_Msk = 0x10
	// Bit P0_4ER.
	GPIOINT_ENR0_P0_4ER = 0x10
	// Position of P0_5ER field.
	GPIOINT_ENR0_P0_5ER_Pos = 0x5
	// Bit mask of P0_5ER field.
	GPIOINT_ENR0_P0_5ER_Msk = 0x20
	// Bit P0_5ER.
	GPIOINT_ENR0_P0_5ER = 0x20
	// Position of P0_6ER field.
	GPIOINT_ENR0_P0_6ER_Pos = 0x6
	// Bit mask of P0_6ER field.
	GPIOINT_ENR0_P0_6ER_Msk = 0x40
	// Bit P0_6ER.
	GPIOINT_ENR0_P0_6ER = 0x40
	// Position of P0_7ER field.
	GPIOINT_ENR0_P0_7ER_Pos = 0x7
	// Bit mask of P0_7ER field.
	GPIOINT_ENR0_P0_7ER_Msk = 0x80
	// Bit P0_7ER.
	GPIOINT_ENR0_P0_7ER = 0x80
	// Position of P0_8ER field.
	GPIOINT_ENR0_P0_8ER_Pos = 0x8
	// Bit mask of P0_8ER field.
	GPIOINT_ENR0_P0_8ER_Msk = 0x100
	// Bit P0_8ER.
	GPIOINT_ENR0_P0_8ER = 0x100
	// Position of P0_9ER field.
	GPIOINT_ENR0_P0_9ER_Pos = 0x9
	// Bit mask of P0_9ER field.
	GPIOINT_ENR0_P0_9ER_Msk = 0x200
	// Bit P0_9ER.
	GPIOINT_ENR0_P0_9ER = 0x200
	// Position of P0_10ER field.
	GPIOINT_ENR0_P0_10ER_Pos = 0xa
	// Bit mask of P0_10ER field.
	GPIOINT_ENR0_P0_10ER_Msk = 0x400
	// Bit P0_10ER.
	GPIOINT_ENR0_P0_10ER = 0x400
	// Position of P0_11ER field.
	GPIOINT_ENR0_P0_11ER_Pos = 0xb
	// Bit mask of P0_11ER field.
	GPIOINT_ENR0_P0_11ER_Msk = 0x800
	// Bit P0_11ER.
	GPIOINT_ENR0_P0_11ER = 0x800
	// Position of P0_12ER field.
	GPIOINT_ENR0_P0_12ER_Pos = 0xc
	// Bit mask of P0_12ER field.
	GPIOINT_ENR0_P0_12ER_Msk = 0x1000
	// Bit P0_12ER.
	GPIOINT_ENR0_P0_12ER = 0x1000
	// Position of P0_13ER field.
	GPIOINT_ENR0_P0_13ER_Pos = 0xd
	// Bit mask of P0_13ER field.
	GPIOINT_ENR0_P0_13ER_Msk = 0x2000
	// Bit P0_13ER.
	GPIOINT_ENR0_P0_13ER = 0x2000
	// Position of P0_14ER field.
	GPIOINT_ENR0_P0_14ER_Pos = 0xe
	// Bit mask of P0_14ER field.
	GPIOINT_ENR0_P0_14ER_Msk = 0x4000
	// Bit P0_14ER.
	GPIOINT_ENR0_P0_14ER = 0x4000
	// Position of P0_15ER field.
	GPIOINT_ENR0_P0_15ER_Pos = 0xf
	// Bit mask of P0_15ER field.
	GPIOINT_ENR0_P0_15ER_Msk = 0x8000
	// Bit P0_15ER.
	GPIOINT_ENR0_P0_15ER = 0x8000
	// Position of P0_16ER field.
	GPIOINT_ENR0_P0_16ER_Pos = 0x10
	// Bit mask of P0_16ER field.
	GPIOINT_ENR0_P0_16ER_Msk = 0x10000
	// Bit P0_16ER.
	GPIOINT_ENR0_P0_16ER = 0x10000
	// Position of P0_17ER field.
	GPIOINT_ENR0_P0_17ER_Pos = 0x11
	// Bit mask of P0_17ER field.
	GPIOINT_ENR0_P0_17ER_Msk = 0x20000
	// Bit P0_17ER.
	GPIOINT_ENR0_P0_17ER = 0x20000
	// Position of P0_18ER field.
	GPIOINT_ENR0_P0_18ER_Pos = 0x12
	// Bit mask of P0_18ER field.
	GPIOINT_ENR0_P0_18ER_Msk = 0x40000
	// Bit P0_18ER.
	GPIOINT_ENR0_P0_18ER = 0x40000
	// Position of P0_19ER field.
	GPIOINT_ENR0_P0_19ER_Pos = 0x13
	// Bit mask of P0_19ER field.
	GPIOINT_ENR0_P0_19ER_Msk = 0x80000
	// Bit P0_19ER.
	GPIOINT_ENR0_P0_19ER = 0x80000
	// Position of P0_20ER field.
	GPIOINT_ENR0_P0_20ER_Pos = 0x14
	// Bit mask of P0_20ER field.
	GPIOINT_ENR0_P0_20ER_Msk = 0x100000
	// Bit P0_20ER.
	GPIOINT_ENR0_P0_20ER = 0x100000
	// Position of P0_21ER field.
	GPIOINT_ENR0_P0_21ER_Pos = 0x15
	// Bit mask of P0_21ER field.
	GPIOINT_ENR0_P0_21ER_Msk = 0x200000
	// Bit P0_21ER.
	GPIOINT_ENR0_P0_21ER = 0x200000
	// Position of P0_22ER field.
	GPIOINT_ENR0_P0_22ER_Pos = 0x16
	// Bit mask of P0_22ER field.
	GPIOINT_ENR0_P0_22ER_Msk = 0x400000
	// Bit P0_22ER.
	GPIOINT_ENR0_P0_22ER = 0x400000
	// Position of P0_23ER field.
	GPIOINT_ENR0_P0_23ER_Pos = 0x17
	// Bit mask of P0_23ER field.
	GPIOINT_ENR0_P0_23ER_Msk = 0x800000
	// Bit P0_23ER.
	GPIOINT_ENR0_P0_23ER = 0x800000
	// Position of P0_24ER field.
	GPIOINT_ENR0_P0_24ER_Pos = 0x18
	// Bit mask of P0_24ER field.
	GPIOINT_ENR0_P0_24ER_Msk = 0x1000000
	// Bit P0_24ER.
	GPIOINT_ENR0_P0_24ER = 0x1000000
	// Position of P0_25ER field.
	GPIOINT_ENR0_P0_25ER_Pos = 0x19
	// Bit mask of P0_25ER field.
	GPIOINT_ENR0_P0_25ER_Msk = 0x2000000
	// Bit P0_25ER.
	GPIOINT_ENR0_P0_25ER = 0x2000000
	// Position of P0_26ER field.
	GPIOINT_ENR0_P0_26ER_Pos = 0x1a
	// Bit mask of P0_26ER field.
	GPIOINT_ENR0_P0_26ER_Msk = 0x4000000
	// Bit P0_26ER.
	GPIOINT_ENR0_P0_26ER = 0x4000000
	// Position of P0_27ER field.
	GPIOINT_ENR0_P0_27ER_Pos = 0x1b
	// Bit mask of P0_27ER field.
	GPIOINT_ENR0_P0_27ER_Msk = 0x8000000
	// Bit P0_27ER.
	GPIOINT_ENR0_P0_27ER = 0x8000000
	// Position of P0_28ER field.
	GPIOINT_ENR0_P0_28ER_Pos = 0x1c
	// Bit mask of P0_28ER field.
	GPIOINT_ENR0_P0_28ER_Msk = 0x10000000
	// Bit P0_28ER.
	GPIOINT_ENR0_P0_28ER = 0x10000000
	// Position of P0_29ER field.
	GPIOINT_ENR0_P0_29ER_Pos = 0x1d
	// Bit mask of P0_29ER field.
	GPIOINT_ENR0_P0_29ER_Msk = 0x20000000
	// Bit P0_29ER.
	GPIOINT_ENR0_P0_29ER = 0x20000000
	// Position of P0_30ER field.
	GPIOINT_ENR0_P0_30ER_Pos = 0x1e
	// Bit mask of P0_30ER field.
	GPIOINT_ENR0_P0_30ER_Msk = 0x40000000
	// Bit P0_30ER.
	GPIOINT_ENR0_P0_30ER = 0x40000000
	// Position of P0_31ER field.
	GPIOINT_ENR0_P0_31ER_Pos = 0x1f
	// Bit mask of P0_31ER field.
	GPIOINT_ENR0_P0_31ER_Msk = 0x80000000
	// Bit P0_31ER.
	GPIOINT_ENR0_P0_31ER = 0x80000000

	// ENF0: GPIO Interrupt Enable for Falling edge for Port 0.
	// Position of P0_0EF field.
	GPIOINT_ENF0_P0_0EF_Pos = 0x0
	// Bit mask of P0_0EF field.
	GPIOINT_ENF0_P0_0EF_Msk = 0x1
	// Bit P0_0EF.
	GPIOINT_ENF0_P0_0EF = 0x1
	// Position of P0_1EF field.
	GPIOINT_ENF0_P0_1EF_Pos = 0x1
	// Bit mask of P0_1EF field.
	GPIOINT_ENF0_P0_1EF_Msk = 0x2
	// Bit P0_1EF.
	GPIOINT_ENF0_P0_1EF = 0x2
	// Position of P0_2EF field.
	GPIOINT_ENF0_P0_2EF_Pos = 0x2
	// Bit mask of P0_2EF field.
	GPIOINT_ENF0_P0_2EF_Msk = 0x4
	// Bit P0_2EF.
	GPIOINT_ENF0_P0_2EF = 0x4
	// Position of P0_3EF field.
	GPIOINT_ENF0_P0_3EF_Pos = 0x3
	// Bit mask of P0_3EF field.
	GPIOINT_ENF0_P0_3EF_Msk = 0x8
	// Bit P0_3EF.
	GPIOINT_ENF0_P0_3EF = 0x8
	// Position of P0_4EF field.
	GPIOINT_ENF0_P0_4EF_Pos = 0x4
	// Bit mask of P0_4EF field.
	GPIOINT_ENF0_P0_4EF_Msk = 0x10
	// Bit P0_4EF.
	GPIOINT_ENF0_P0_4EF = 0x10
	// Position of P0_5EF field.
	GPIOINT_ENF0_P0_5EF_Pos = 0x5
	// Bit mask of P0_5EF field.
	GPIOINT_ENF0_P0_5EF_Msk = 0x20
	// Bit P0_5EF.
	GPIOINT_ENF0_P0_5EF = 0x20
	// Position of P0_6EF field.
	GPIOINT_ENF0_P0_6EF_Pos = 0x6
	// Bit mask of P0_6EF field.
	GPIOINT_ENF0_P0_6EF_Msk = 0x40
	// Bit P0_6EF.
	GPIOINT_ENF0_P0_6EF = 0x40
	// Position of P0_7EF field.
	GPIOINT_ENF0_P0_7EF_Pos = 0x7
	// Bit mask of P0_7EF field.
	GPIOINT_ENF0_P0_7EF_Msk = 0x80
	// Bit P0_7EF.
	GPIOINT_ENF0_P0_7EF = 0x80
	// Position of P0_8EF field.
	GPIOINT_ENF0_P0_8EF_Pos = 0x8
	// Bit mask of P0_8EF field.
	GPIOINT_ENF0_P0_8EF_Msk = 0x100
	// Bit P0_8EF.
	GPIOINT_ENF0_P0_8EF = 0x100
	// Position of P0_9EF field.
	GPIOINT_ENF0_P0_9EF_Pos = 0x9
	// Bit mask of P0_9EF field.
	GPIOINT_ENF0_P0_9EF_Msk = 0x200
	// Bit P0_9EF.
	GPIOINT_ENF0_P0_9EF = 0x200
	// Position of P0_10EF field.
	GPIOINT_ENF0_P0_10EF_Pos = 0xa
	// Bit mask of P0_10EF field.
	GPIOINT_ENF0_P0_10EF_Msk = 0x400
	// Bit P0_10EF.
	GPIOINT_ENF0_P0_10EF = 0x400
	// Position of P0_11EF field.
	GPIOINT_ENF0_P0_11EF_Pos = 0xb
	// Bit mask of P0_11EF field.
	GPIOINT_ENF0_P0_11EF_Msk = 0x800
	// Bit P0_11EF.
	GPIOINT_ENF0_P0_11EF = 0x800
	// Position of P0_12EF field.
	GPIOINT_ENF0_P0_12EF_Pos = 0xc
	// Bit mask of P0_12EF field.
	GPIOINT_ENF0_P0_12EF_Msk = 0x1000
	// Bit P0_12EF.
	GPIOINT_ENF0_P0_12EF = 0x1000
	// Position of P0_13EF field.
	GPIOINT_ENF0_P0_13EF_Pos = 0xd
	// Bit mask of P0_13EF field.
	GPIOINT_ENF0_P0_13EF_Msk = 0x2000
	// Bit P0_13EF.
	GPIOINT_ENF0_P0_13EF = 0x2000
	// Position of P0_14EF field.
	GPIOINT_ENF0_P0_14EF_Pos = 0xe
	// Bit mask of P0_14EF field.
	GPIOINT_ENF0_P0_14EF_Msk = 0x4000
	// Bit P0_14EF.
	GPIOINT_ENF0_P0_14EF = 0x4000
	// Position of P0_15EF field.
	GPIOINT_ENF0_P0_15EF_Pos = 0xf
	// Bit mask of P0_15EF field.
	GPIOINT_ENF0_P0_15EF_Msk = 0x8000
	// Bit P0_15EF.
	GPIOINT_ENF0_P0_15EF = 0x8000
	// Position of P0_16EF field.
	GPIOINT_ENF0_P0_16EF_Pos = 0x10
	// Bit mask of P0_16EF field.
	GPIOINT_ENF0_P0_16EF_Msk = 0x10000
	// Bit P0_16EF.
	GPIOINT_ENF0_P0_16EF = 0x10000
	// Position of P0_17EF field.
	GPIOINT_ENF0_P0_17EF_Pos = 0x11
	// Bit mask of P0_17EF field.
	GPIOINT_ENF0_P0_17EF_Msk = 0x20000
	// Bit P0_17EF.
	GPIOINT_ENF0_P0_17EF = 0x20000
	// Position of P0_18EF field.
	GPIOINT_ENF0_P0_18EF_Pos = 0x12
	// Bit mask of P0_18EF field.
	GPIOINT_ENF0_P0_18EF_Msk = 0x40000
	// Bit P0_18EF.
	GPIOINT_ENF0_P0_18EF = 0x40000
	// Position of P0_19EF field.
	GPIOINT_ENF0_P0_19EF_Pos = 0x13
	// Bit mask of P0_19EF field.
	GPIOINT_ENF0_P0_19EF_Msk = 0x80000
	// Bit P0_19EF.
	GPIOINT_ENF0_P0_19EF = 0x80000
	// Position of P0_20EF field.
	GPIOINT_ENF0_P0_20EF_Pos = 0x14
	// Bit mask of P0_20EF field.
	GPIOINT_ENF0_P0_20EF_Msk = 0x100000
	// Bit P0_20EF.
	GPIOINT_ENF0_P0_20EF = 0x100000
	// Position of P0_21EF field.
	GPIOINT_ENF0_P0_21EF_Pos = 0x15
	// Bit mask of P0_21EF field.
	GPIOINT_ENF0_P0_21EF_Msk = 0x200000
	// Bit P0_21EF.
	GPIOINT_ENF0_P0_21EF = 0x200000
	// Position of P0_22EF field.
	GPIOINT_ENF0_P0_22EF_Pos = 0x16
	// Bit mask of P0_22EF field.
	GPIOINT_ENF0_P0_22EF_Msk = 0x400000
	// Bit P0_22EF.
	GPIOINT_ENF0_P0_22EF = 0x400000
	// Position of P0_23EF field.
	GPIOINT_ENF0_P0_23EF_Pos = 0x17
	// Bit mask of P0_23EF field.
	GPIOINT_ENF0_P0_23EF_Msk = 0x800000
	// Bit P0_23EF.
	GPIOINT_ENF0_P0_23EF = 0x800000
	// Position of P0_24EF field.
	GPIOINT_ENF0_P0_24EF_Pos = 0x18
	// Bit mask of P0_24EF field.
	GPIOINT_ENF0_P0_24EF_Msk = 0x1000000
	// Bit P0_24EF.
	GPIOINT_ENF0_P0_24EF = 0x1000000
	// Position of P0_25EF field.
	GPIOINT_ENF0_P0_25EF_Pos = 0x19
	// Bit mask of P0_25EF field.
	GPIOINT_ENF0_P0_25EF_Msk = 0x2000000
	// Bit P0_25EF.
	GPIOINT_ENF0_P0_25EF = 0x2000000
	// Position of P0_26EF field.
	GPIOINT_ENF0_P0_26EF_Pos = 0x1a
	// Bit mask of P0_26EF field.
	GPIOINT_ENF0_P0_26EF_Msk = 0x4000000
	// Bit P0_26EF.
	GPIOINT_ENF0_P0_26EF = 0x4000000
	// Position of P0_27EF field.
	GPIOINT_ENF0_P0_27EF_Pos = 0x1b
	// Bit mask of P0_27EF field.
	GPIOINT_ENF0_P0_27EF_Msk = 0x8000000
	// Bit P0_27EF.
	GPIOINT_ENF0_P0_27EF = 0x8000000
	// Position of P0_28EF field.
	GPIOINT_ENF0_P0_28EF_Pos = 0x1c
	// Bit mask of P0_28EF field.
	GPIOINT_ENF0_P0_28EF_Msk = 0x10000000
	// Bit P0_28EF.
	GPIOINT_ENF0_P0_28EF = 0x10000000
	// Position of P0_29EF field.
	GPIOINT_ENF0_P0_29EF_Pos = 0x1d
	// Bit mask of P0_29EF field.
	GPIOINT_ENF0_P0_29EF_Msk = 0x20000000
	// Bit P0_29EF.
	GPIOINT_ENF0_P0_29EF = 0x20000000
	// Position of P0_30EF field.
	GPIOINT_ENF0_P0_30EF_Pos = 0x1e
	// Bit mask of P0_30EF field.
	GPIOINT_ENF0_P0_30EF_Msk = 0x40000000
	// Bit P0_30EF.
	GPIOINT_ENF0_P0_30EF = 0x40000000
	// Position of P0_31EF field.
	GPIOINT_ENF0_P0_31EF_Pos = 0x1f
	// Bit mask of P0_31EF field.
	GPIOINT_ENF0_P0_31EF_Msk = 0x80000000
	// Bit P0_31EF.
	GPIOINT_ENF0_P0_31EF = 0x80000000

	// STATR2: GPIO Interrupt Status for Rising edge for Port 0.
	// Position of P2_0REI field.
	GPIOINT_STATR2_P2_0REI_Pos = 0x0
	// Bit mask of P2_0REI field.
	GPIOINT_STATR2_P2_0REI_Msk = 0x1
	// Bit P2_0REI.
	GPIOINT_STATR2_P2_0REI = 0x1
	// Position of P2_1REI field.
	GPIOINT_STATR2_P2_1REI_Pos = 0x1
	// Bit mask of P2_1REI field.
	GPIOINT_STATR2_P2_1REI_Msk = 0x2
	// Bit P2_1REI.
	GPIOINT_STATR2_P2_1REI = 0x2
	// Position of P2_2REI field.
	GPIOINT_STATR2_P2_2REI_Pos = 0x2
	// Bit mask of P2_2REI field.
	GPIOINT_STATR2_P2_2REI_Msk = 0x4
	// Bit P2_2REI.
	GPIOINT_STATR2_P2_2REI = 0x4
	// Position of P2_3REI field.
	GPIOINT_STATR2_P2_3REI_Pos = 0x3
	// Bit mask of P2_3REI field.
	GPIOINT_STATR2_P2_3REI_Msk = 0x8
	// Bit P2_3REI.
	GPIOINT_STATR2_P2_3REI = 0x8
	// Position of P2_4REI field.
	GPIOINT_STATR2_P2_4REI_Pos = 0x4
	// Bit mask of P2_4REI field.
	GPIOINT_STATR2_P2_4REI_Msk = 0x10
	// Bit P2_4REI.
	GPIOINT_STATR2_P2_4REI = 0x10
	// Position of P2_5REI field.
	GPIOINT_STATR2_P2_5REI_Pos = 0x5
	// Bit mask of P2_5REI field.
	GPIOINT_STATR2_P2_5REI_Msk = 0x20
	// Bit P2_5REI.
	GPIOINT_STATR2_P2_5REI = 0x20
	// Position of P2_6REI field.
	GPIOINT_STATR2_P2_6REI_Pos = 0x6
	// Bit mask of P2_6REI field.
	GPIOINT_STATR2_P2_6REI_Msk = 0x40
	// Bit P2_6REI.
	GPIOINT_STATR2_P2_6REI = 0x40
	// Position of P2_7REI field.
	GPIOINT_STATR2_P2_7REI_Pos = 0x7
	// Bit mask of P2_7REI field.
	GPIOINT_STATR2_P2_7REI_Msk = 0x80
	// Bit P2_7REI.
	GPIOINT_STATR2_P2_7REI = 0x80
	// Position of P2_8REI field.
	GPIOINT_STATR2_P2_8REI_Pos = 0x8
	// Bit mask of P2_8REI field.
	GPIOINT_STATR2_P2_8REI_Msk = 0x100
	// Bit P2_8REI.
	GPIOINT_STATR2_P2_8REI = 0x100
	// Position of P2_9REI field.
	GPIOINT_STATR2_P2_9REI_Pos = 0x9
	// Bit mask of P2_9REI field.
	GPIOINT_STATR2_P2_9REI_Msk = 0x200
	// Bit P2_9REI.
	GPIOINT_STATR2_P2_9REI = 0x200
	// Position of P2_10REI field.
	GPIOINT_STATR2_P2_10REI_Pos = 0xa
	// Bit mask of P2_10REI field.
	GPIOINT_STATR2_P2_10REI_Msk = 0x400
	// Bit P2_10REI.
	GPIOINT_STATR2_P2_10REI = 0x400
	// Position of P2_11REI field.
	GPIOINT_STATR2_P2_11REI_Pos = 0xb
	// Bit mask of P2_11REI field.
	GPIOINT_STATR2_P2_11REI_Msk = 0x800
	// Bit P2_11REI.
	GPIOINT_STATR2_P2_11REI = 0x800
	// Position of P2_12REI field.
	GPIOINT_STATR2_P2_12REI_Pos = 0xc
	// Bit mask of P2_12REI field.
	GPIOINT_STATR2_P2_12REI_Msk = 0x1000
	// Bit P2_12REI.
	GPIOINT_STATR2_P2_12REI = 0x1000
	// Position of P2_13REI field.
	GPIOINT_STATR2_P2_13REI_Pos = 0xd
	// Bit mask of P2_13REI field.
	GPIOINT_STATR2_P2_13REI_Msk = 0x2000
	// Bit P2_13REI.
	GPIOINT_STATR2_P2_13REI = 0x2000
	// Position of P2_14REI field.
	GPIOINT_STATR2_P2_14REI_Pos = 0xe
	// Bit mask of P2_14REI field.
	GPIOINT_STATR2_P2_14REI_Msk = 0x4000
	// Bit P2_14REI.
	GPIOINT_STATR2_P2_14REI = 0x4000
	// Position of P2_15REI field.
	GPIOINT_STATR2_P2_15REI_Pos = 0xf
	// Bit mask of P2_15REI field.
	GPIOINT_STATR2_P2_15REI_Msk = 0x8000
	// Bit P2_15REI.
	GPIOINT_STATR2_P2_15REI = 0x8000
	// Position of P2_16REI field.
	GPIOINT_STATR2_P2_16REI_Pos = 0x10
	// Bit mask of P2_16REI field.
	GPIOINT_STATR2_P2_16REI_Msk = 0x10000
	// Bit P2_16REI.
	GPIOINT_STATR2_P2_16REI = 0x10000
	// Position of P2_17REI field.
	GPIOINT_STATR2_P2_17REI_Pos = 0x11
	// Bit mask of P2_17REI field.
	GPIOINT_STATR2_P2_17REI_Msk = 0x20000
	// Bit P2_17REI.
	GPIOINT_STATR2_P2_17REI = 0x20000
	// Position of P2_18REI field.
	GPIOINT_STATR2_P2_18REI_Pos = 0x12
	// Bit mask of P2_18REI field.
	GPIOINT_STATR2_P2_18REI_Msk = 0x40000
	// Bit P2_18REI.
	GPIOINT_STATR2_P2_18REI = 0x40000
	// Position of P2_19REI field.
	GPIOINT_STATR2_P2_19REI_Pos = 0x13
	// Bit mask of P2_19REI field.
	GPIOINT_STATR2_P2_19REI_Msk = 0x80000
	// Bit P2_19REI.
	GPIOINT_STATR2_P2_19REI = 0x80000
	// Position of P2_20REI field.
	GPIOINT_STATR2_P2_20REI_Pos = 0x14
	// Bit mask of P2_20REI field.
	GPIOINT_STATR2_P2_20REI_Msk = 0x100000
	// Bit P2_20REI.
	GPIOINT_STATR2_P2_20REI = 0x100000
	// Position of P2_21REI field.
	GPIOINT_STATR2_P2_21REI_Pos = 0x15
	// Bit mask of P2_21REI field.
	GPIOINT_STATR2_P2_21REI_Msk = 0x200000
	// Bit P2_21REI.
	GPIOINT_STATR2_P2_21REI = 0x200000
	// Position of P2_22REI field.
	GPIOINT_STATR2_P2_22REI_Pos = 0x16
	// Bit mask of P2_22REI field.
	GPIOINT_STATR2_P2_22REI_Msk = 0x400000
	// Bit P2_22REI.
	GPIOINT_STATR2_P2_22REI = 0x400000
	// Position of P2_23REI field.
	GPIOINT_STATR2_P2_23REI_Pos = 0x17
	// Bit mask of P2_23REI field.
	GPIOINT_STATR2_P2_23REI_Msk = 0x800000
	// Bit P2_23REI.
	GPIOINT_STATR2_P2_23REI = 0x800000
	// Position of P2_24REI field.
	GPIOINT_STATR2_P2_24REI_Pos = 0x18
	// Bit mask of P2_24REI field.
	GPIOINT_STATR2_P2_24REI_Msk = 0x1000000
	// Bit P2_24REI.
	GPIOINT_STATR2_P2_24REI = 0x1000000
	// Position of P2_25REI field.
	GPIOINT_STATR2_P2_25REI_Pos = 0x19
	// Bit mask of P2_25REI field.
	GPIOINT_STATR2_P2_25REI_Msk = 0x2000000
	// Bit P2_25REI.
	GPIOINT_STATR2_P2_25REI = 0x2000000
	// Position of P2_26REI field.
	GPIOINT_STATR2_P2_26REI_Pos = 0x1a
	// Bit mask of P2_26REI field.
	GPIOINT_STATR2_P2_26REI_Msk = 0x4000000
	// Bit P2_26REI.
	GPIOINT_STATR2_P2_26REI = 0x4000000
	// Position of P2_27REI field.
	GPIOINT_STATR2_P2_27REI_Pos = 0x1b
	// Bit mask of P2_27REI field.
	GPIOINT_STATR2_P2_27REI_Msk = 0x8000000
	// Bit P2_27REI.
	GPIOINT_STATR2_P2_27REI = 0x8000000
	// Position of P2_28REI field.
	GPIOINT_STATR2_P2_28REI_Pos = 0x1c
	// Bit mask of P2_28REI field.
	GPIOINT_STATR2_P2_28REI_Msk = 0x10000000
	// Bit P2_28REI.
	GPIOINT_STATR2_P2_28REI = 0x10000000
	// Position of P2_29REI field.
	GPIOINT_STATR2_P2_29REI_Pos = 0x1d
	// Bit mask of P2_29REI field.
	GPIOINT_STATR2_P2_29REI_Msk = 0x20000000
	// Bit P2_29REI.
	GPIOINT_STATR2_P2_29REI = 0x20000000
	// Position of P2_30REI field.
	GPIOINT_STATR2_P2_30REI_Pos = 0x1e
	// Bit mask of P2_30REI field.
	GPIOINT_STATR2_P2_30REI_Msk = 0x40000000
	// Bit P2_30REI.
	GPIOINT_STATR2_P2_30REI = 0x40000000
	// Position of P2_31REI field.
	GPIOINT_STATR2_P2_31REI_Pos = 0x1f
	// Bit mask of P2_31REI field.
	GPIOINT_STATR2_P2_31REI_Msk = 0x80000000
	// Bit P2_31REI.
	GPIOINT_STATR2_P2_31REI = 0x80000000

	// STATF2: GPIO Interrupt Status for Falling edge for Port 0.
	// Position of P2_0FEI field.
	GPIOINT_STATF2_P2_0FEI_Pos = 0x0
	// Bit mask of P2_0FEI field.
	GPIOINT_STATF2_P2_0FEI_Msk = 0x1
	// Bit P2_0FEI.
	GPIOINT_STATF2_P2_0FEI = 0x1
	// Position of P2_1FEI field.
	GPIOINT_STATF2_P2_1FEI_Pos = 0x1
	// Bit mask of P2_1FEI field.
	GPIOINT_STATF2_P2_1FEI_Msk = 0x2
	// Bit P2_1FEI.
	GPIOINT_STATF2_P2_1FEI = 0x2
	// Position of P2_2FEI field.
	GPIOINT_STATF2_P2_2FEI_Pos = 0x2
	// Bit mask of P2_2FEI field.
	GPIOINT_STATF2_P2_2FEI_Msk = 0x4
	// Bit P2_2FEI.
	GPIOINT_STATF2_P2_2FEI = 0x4
	// Position of P2_3FEI field.
	GPIOINT_STATF2_P2_3FEI_Pos = 0x3
	// Bit mask of P2_3FEI field.
	GPIOINT_STATF2_P2_3FEI_Msk = 0x8
	// Bit P2_3FEI.
	GPIOINT_STATF2_P2_3FEI = 0x8
	// Position of P2_4FEI field.
	GPIOINT_STATF2_P2_4FEI_Pos = 0x4
	// Bit mask of P2_4FEI field.
	GPIOINT_STATF2_P2_4FEI_Msk = 0x10
	// Bit P2_4FEI.
	GPIOINT_STATF2_P2_4FEI = 0x10
	// Position of P2_5FEI field.
	GPIOINT_STATF2_P2_5FEI_Pos = 0x5
	// Bit mask of P2_5FEI field.
	GPIOINT_STATF2_P2_5FEI_Msk = 0x20
	// Bit P2_5FEI.
	GPIOINT_STATF2_P2_5FEI = 0x20
	// Position of P2_6FEI field.
	GPIOINT_STATF2_P2_6FEI_Pos = 0x6
	// Bit mask of P2_6FEI field.
	GPIOINT_STATF2_P2_6FEI_Msk = 0x40
	// Bit P2_6FEI.
	GPIOINT_STATF2_P2_6FEI = 0x40
	// Position of P2_7FEI field.
	GPIOINT_STATF2_P2_7FEI_Pos = 0x7
	// Bit mask of P2_7FEI field.
	GPIOINT_STATF2_P2_7FEI_Msk = 0x80
	// Bit P2_7FEI.
	GPIOINT_STATF2_P2_7FEI = 0x80
	// Position of P2_8FEI field.
	GPIOINT_STATF2_P2_8FEI_Pos = 0x8
	// Bit mask of P2_8FEI field.
	GPIOINT_STATF2_P2_8FEI_Msk = 0x100
	// Bit P2_8FEI.
	GPIOINT_STATF2_P2_8FEI = 0x100
	// Position of P2_9FEI field.
	GPIOINT_STATF2_P2_9FEI_Pos = 0x9
	// Bit mask of P2_9FEI field.
	GPIOINT_STATF2_P2_9FEI_Msk = 0x200
	// Bit P2_9FEI.
	GPIOINT_STATF2_P2_9FEI = 0x200
	// Position of P2_10FEI field.
	GPIOINT_STATF2_P2_10FEI_Pos = 0xa
	// Bit mask of P2_10FEI field.
	GPIOINT_STATF2_P2_10FEI_Msk = 0x400
	// Bit P2_10FEI.
	GPIOINT_STATF2_P2_10FEI = 0x400
	// Position of P2_11FEI field.
	GPIOINT_STATF2_P2_11FEI_Pos = 0xb
	// Bit mask of P2_11FEI field.
	GPIOINT_STATF2_P2_11FEI_Msk = 0x800
	// Bit P2_11FEI.
	GPIOINT_STATF2_P2_11FEI = 0x800
	// Position of P2_12FEI field.
	GPIOINT_STATF2_P2_12FEI_Pos = 0xc
	// Bit mask of P2_12FEI field.
	GPIOINT_STATF2_P2_12FEI_Msk = 0x1000
	// Bit P2_12FEI.
	GPIOINT_STATF2_P2_12FEI = 0x1000
	// Position of P2_13FEI field.
	GPIOINT_STATF2_P2_13FEI_Pos = 0xd
	// Bit mask of P2_13FEI field.
	GPIOINT_STATF2_P2_13FEI_Msk = 0x2000
	// Bit P2_13FEI.
	GPIOINT_STATF2_P2_13FEI = 0x2000
	// Position of P2_14FEI field.
	GPIOINT_STATF2_P2_14FEI_Pos = 0xe
	// Bit mask of P2_14FEI field.
	GPIOINT_STATF2_P2_14FEI_Msk = 0x4000
	// Bit P2_14FEI.
	GPIOINT_STATF2_P2_14FEI = 0x4000
	// Position of P2_15FEI field.
	GPIOINT_STATF2_P2_15FEI_Pos = 0xf
	// Bit mask of P2_15FEI field.
	GPIOINT_STATF2_P2_15FEI_Msk = 0x8000
	// Bit P2_15FEI.
	GPIOINT_STATF2_P2_15FEI = 0x8000
	// Position of P2_16FEI field.
	GPIOINT_STATF2_P2_16FEI_Pos = 0x10
	// Bit mask of P2_16FEI field.
	GPIOINT_STATF2_P2_16FEI_Msk = 0x10000
	// Bit P2_16FEI.
	GPIOINT_STATF2_P2_16FEI = 0x10000
	// Position of P2_17FEI field.
	GPIOINT_STATF2_P2_17FEI_Pos = 0x11
	// Bit mask of P2_17FEI field.
	GPIOINT_STATF2_P2_17FEI_Msk = 0x20000
	// Bit P2_17FEI.
	GPIOINT_STATF2_P2_17FEI = 0x20000
	// Position of P2_18FEI field.
	GPIOINT_STATF2_P2_18FEI_Pos = 0x12
	// Bit mask of P2_18FEI field.
	GPIOINT_STATF2_P2_18FEI_Msk = 0x40000
	// Bit P2_18FEI.
	GPIOINT_STATF2_P2_18FEI = 0x40000
	// Position of P2_19FEI field.
	GPIOINT_STATF2_P2_19FEI_Pos = 0x13
	// Bit mask of P2_19FEI field.
	GPIOINT_STATF2_P2_19FEI_Msk = 0x80000
	// Bit P2_19FEI.
	GPIOINT_STATF2_P2_19FEI = 0x80000
	// Position of P2_20FEI field.
	GPIOINT_STATF2_P2_20FEI_Pos = 0x14
	// Bit mask of P2_20FEI field.
	GPIOINT_STATF2_P2_20FEI_Msk = 0x100000
	// Bit P2_20FEI.
	GPIOINT_STATF2_P2_20FEI = 0x100000
	// Position of P2_21FEI field.
	GPIOINT_STATF2_P2_21FEI_Pos = 0x15
	// Bit mask of P2_21FEI field.
	GPIOINT_STATF2_P2_21FEI_Msk = 0x200000
	// Bit P2_21FEI.
	GPIOINT_STATF2_P2_21FEI = 0x200000
	// Position of P2_22FEI field.
	GPIOINT_STATF2_P2_22FEI_Pos = 0x16
	// Bit mask of P2_22FEI field.
	GPIOINT_STATF2_P2_22FEI_Msk = 0x400000
	// Bit P2_22FEI.
	GPIOINT_STATF2_P2_22FEI = 0x400000
	// Position of P2_23FEI field.
	GPIOINT_STATF2_P2_23FEI_Pos = 0x17
	// Bit mask of P2_23FEI field.
	GPIOINT_STATF2_P2_23FEI_Msk = 0x800000
	// Bit P2_23FEI.
	GPIOINT_STATF2_P2_23FEI = 0x800000
	// Position of P2_24FEI field.
	GPIOINT_STATF2_P2_24FEI_Pos = 0x18
	// Bit mask of P2_24FEI field.
	GPIOINT_STATF2_P2_24FEI_Msk = 0x1000000
	// Bit P2_24FEI.
	GPIOINT_STATF2_P2_24FEI = 0x1000000
	// Position of P2_25FEI field.
	GPIOINT_STATF2_P2_25FEI_Pos = 0x19
	// Bit mask of P2_25FEI field.
	GPIOINT_STATF2_P2_25FEI_Msk = 0x2000000
	// Bit P2_25FEI.
	GPIOINT_STATF2_P2_25FEI = 0x2000000
	// Position of P2_26FEI field.
	GPIOINT_STATF2_P2_26FEI_Pos = 0x1a
	// Bit mask of P2_26FEI field.
	GPIOINT_STATF2_P2_26FEI_Msk = 0x4000000
	// Bit P2_26FEI.
	GPIOINT_STATF2_P2_26FEI = 0x4000000
	// Position of P2_27FEI field.
	GPIOINT_STATF2_P2_27FEI_Pos = 0x1b
	// Bit mask of P2_27FEI field.
	GPIOINT_STATF2_P2_27FEI_Msk = 0x8000000
	// Bit P2_27FEI.
	GPIOINT_STATF2_P2_27FEI = 0x8000000
	// Position of P2_28FEI field.
	GPIOINT_STATF2_P2_28FEI_Pos = 0x1c
	// Bit mask of P2_28FEI field.
	GPIOINT_STATF2_P2_28FEI_Msk = 0x10000000
	// Bit P2_28FEI.
	GPIOINT_STATF2_P2_28FEI = 0x10000000
	// Position of P2_29FEI field.
	GPIOINT_STATF2_P2_29FEI_Pos = 0x1d
	// Bit mask of P2_29FEI field.
	GPIOINT_STATF2_P2_29FEI_Msk = 0x20000000
	// Bit P2_29FEI.
	GPIOINT_STATF2_P2_29FEI = 0x20000000
	// Position of P2_30FEI field.
	GPIOINT_STATF2_P2_30FEI_Pos = 0x1e
	// Bit mask of P2_30FEI field.
	GPIOINT_STATF2_P2_30FEI_Msk = 0x40000000
	// Bit P2_30FEI.
	GPIOINT_STATF2_P2_30FEI = 0x40000000
	// Position of P2_31FEI field.
	GPIOINT_STATF2_P2_31FEI_Pos = 0x1f
	// Bit mask of P2_31FEI field.
	GPIOINT_STATF2_P2_31FEI_Msk = 0x80000000
	// Bit P2_31FEI.
	GPIOINT_STATF2_P2_31FEI = 0x80000000

	// CLR2: GPIO Interrupt Clear.
	// Position of P2_0CI field.
	GPIOINT_CLR2_P2_0CI_Pos = 0x0
	// Bit mask of P2_0CI field.
	GPIOINT_CLR2_P2_0CI_Msk = 0x1
	// Bit P2_0CI.
	GPIOINT_CLR2_P2_0CI = 0x1
	// Position of P2_1CI field.
	GPIOINT_CLR2_P2_1CI_Pos = 0x1
	// Bit mask of P2_1CI field.
	GPIOINT_CLR2_P2_1CI_Msk = 0x2
	// Bit P2_1CI.
	GPIOINT_CLR2_P2_1CI = 0x2
	// Position of P2_2CI field.
	GPIOINT_CLR2_P2_2CI_Pos = 0x2
	// Bit mask of P2_2CI field.
	GPIOINT_CLR2_P2_2CI_Msk = 0x4
	// Bit P2_2CI.
	GPIOINT_CLR2_P2_2CI = 0x4
	// Position of P2_3CI field.
	GPIOINT_CLR2_P2_3CI_Pos = 0x3
	// Bit mask of P2_3CI field.
	GPIOINT_CLR2_P2_3CI_Msk = 0x8
	// Bit P2_3CI.
	GPIOINT_CLR2_P2_3CI = 0x8
	// Position of P2_4CI field.
	GPIOINT_CLR2_P2_4CI_Pos = 0x4
	// Bit mask of P2_4CI field.
	GPIOINT_CLR2_P2_4CI_Msk = 0x10
	// Bit P2_4CI.
	GPIOINT_CLR2_P2_4CI = 0x10
	// Position of P2_5CI field.
	GPIOINT_CLR2_P2_5CI_Pos = 0x5
	// Bit mask of P2_5CI field.
	GPIOINT_CLR2_P2_5CI_Msk = 0x20
	// Bit P2_5CI.
	GPIOINT_CLR2_P2_5CI = 0x20
	// Position of P2_6CI field.
	GPIOINT_CLR2_P2_6CI_Pos = 0x6
	// Bit mask of P2_6CI field.
	GPIOINT_CLR2_P2_6CI_Msk = 0x40
	// Bit P2_6CI.
	GPIOINT_CLR2_P2_6CI = 0x40
	// Position of P2_7CI field.
	GPIOINT_CLR2_P2_7CI_Pos = 0x7
	// Bit mask of P2_7CI field.
	GPIOINT_CLR2_P2_7CI_Msk = 0x80
	// Bit P2_7CI.
	GPIOINT_CLR2_P2_7CI = 0x80
	// Position of P2_8CI field.
	GPIOINT_CLR2_P2_8CI_Pos = 0x8
	// Bit mask of P2_8CI field.
	GPIOINT_CLR2_P2_8CI_Msk = 0x100
	// Bit P2_8CI.
	GPIOINT_CLR2_P2_8CI = 0x100
	// Position of P2_9CI field.
	GPIOINT_CLR2_P2_9CI_Pos = 0x9
	// Bit mask of P2_9CI field.
	GPIOINT_CLR2_P2_9CI_Msk = 0x200
	// Bit P2_9CI.
	GPIOINT_CLR2_P2_9CI = 0x200
	// Position of P2_10CI field.
	GPIOINT_CLR2_P2_10CI_Pos = 0xa
	// Bit mask of P2_10CI field.
	GPIOINT_CLR2_P2_10CI_Msk = 0x400
	// Bit P2_10CI.
	GPIOINT_CLR2_P2_10CI = 0x400
	// Position of P2_11CI field.
	GPIOINT_CLR2_P2_11CI_Pos = 0xb
	// Bit mask of P2_11CI field.
	GPIOINT_CLR2_P2_11CI_Msk = 0x800
	// Bit P2_11CI.
	GPIOINT_CLR2_P2_11CI = 0x800
	// Position of P2_12CI field.
	GPIOINT_CLR2_P2_12CI_Pos = 0xc
	// Bit mask of P2_12CI field.
	GPIOINT_CLR2_P2_12CI_Msk = 0x1000
	// Bit P2_12CI.
	GPIOINT_CLR2_P2_12CI = 0x1000
	// Position of P2_13CI field.
	GPIOINT_CLR2_P2_13CI_Pos = 0xd
	// Bit mask of P2_13CI field.
	GPIOINT_CLR2_P2_13CI_Msk = 0x2000
	// Bit P2_13CI.
	GPIOINT_CLR2_P2_13CI = 0x2000
	// Position of P2_14CI field.
	GPIOINT_CLR2_P2_14CI_Pos = 0xe
	// Bit mask of P2_14CI field.
	GPIOINT_CLR2_P2_14CI_Msk = 0x4000
	// Bit P2_14CI.
	GPIOINT_CLR2_P2_14CI = 0x4000
	// Position of P2_15CI field.
	GPIOINT_CLR2_P2_15CI_Pos = 0xf
	// Bit mask of P2_15CI field.
	GPIOINT_CLR2_P2_15CI_Msk = 0x8000
	// Bit P2_15CI.
	GPIOINT_CLR2_P2_15CI = 0x8000
	// Position of P2_16CI field.
	GPIOINT_CLR2_P2_16CI_Pos = 0x10
	// Bit mask of P2_16CI field.
	GPIOINT_CLR2_P2_16CI_Msk = 0x10000
	// Bit P2_16CI.
	GPIOINT_CLR2_P2_16CI = 0x10000
	// Position of P2_17CI field.
	GPIOINT_CLR2_P2_17CI_Pos = 0x11
	// Bit mask of P2_17CI field.
	GPIOINT_CLR2_P2_17CI_Msk = 0x20000
	// Bit P2_17CI.
	GPIOINT_CLR2_P2_17CI = 0x20000
	// Position of P2_18CI field.
	GPIOINT_CLR2_P2_18CI_Pos = 0x12
	// Bit mask of P2_18CI field.
	GPIOINT_CLR2_P2_18CI_Msk = 0x40000
	// Bit P2_18CI.
	GPIOINT_CLR2_P2_18CI = 0x40000
	// Position of P2_19CI field.
	GPIOINT_CLR2_P2_19CI_Pos = 0x13
	// Bit mask of P2_19CI field.
	GPIOINT_CLR2_P2_19CI_Msk = 0x80000
	// Bit P2_19CI.
	GPIOINT_CLR2_P2_19CI = 0x80000
	// Position of P2_20CI field.
	GPIOINT_CLR2_P2_20CI_Pos = 0x14
	// Bit mask of P2_20CI field.
	GPIOINT_CLR2_P2_20CI_Msk = 0x100000
	// Bit P2_20CI.
	GPIOINT_CLR2_P2_20CI = 0x100000
	// Position of P2_21CI field.
	GPIOINT_CLR2_P2_21CI_Pos = 0x15
	// Bit mask of P2_21CI field.
	GPIOINT_CLR2_P2_21CI_Msk = 0x200000
	// Bit P2_21CI.
	GPIOINT_CLR2_P2_21CI = 0x200000
	// Position of P2_22CI field.
	GPIOINT_CLR2_P2_22CI_Pos = 0x16
	// Bit mask of P2_22CI field.
	GPIOINT_CLR2_P2_22CI_Msk = 0x400000
	// Bit P2_22CI.
	GPIOINT_CLR2_P2_22CI = 0x400000
	// Position of P2_23CI field.
	GPIOINT_CLR2_P2_23CI_Pos = 0x17
	// Bit mask of P2_23CI field.
	GPIOINT_CLR2_P2_23CI_Msk = 0x800000
	// Bit P2_23CI.
	GPIOINT_CLR2_P2_23CI = 0x800000
	// Position of P2_24CI field.
	GPIOINT_CLR2_P2_24CI_Pos = 0x18
	// Bit mask of P2_24CI field.
	GPIOINT_CLR2_P2_24CI_Msk = 0x1000000
	// Bit P2_24CI.
	GPIOINT_CLR2_P2_24CI = 0x1000000
	// Position of P2_25CI field.
	GPIOINT_CLR2_P2_25CI_Pos = 0x19
	// Bit mask of P2_25CI field.
	GPIOINT_CLR2_P2_25CI_Msk = 0x2000000
	// Bit P2_25CI.
	GPIOINT_CLR2_P2_25CI = 0x2000000
	// Position of P2_26CI field.
	GPIOINT_CLR2_P2_26CI_Pos = 0x1a
	// Bit mask of P2_26CI field.
	GPIOINT_CLR2_P2_26CI_Msk = 0x4000000
	// Bit P2_26CI.
	GPIOINT_CLR2_P2_26CI = 0x4000000
	// Position of P2_27CI field.
	GPIOINT_CLR2_P2_27CI_Pos = 0x1b
	// Bit mask of P2_27CI field.
	GPIOINT_CLR2_P2_27CI_Msk = 0x8000000
	// Bit P2_27CI.
	GPIOINT_CLR2_P2_27CI = 0x8000000
	// Position of P2_28CI field.
	GPIOINT_CLR2_P2_28CI_Pos = 0x1c
	// Bit mask of P2_28CI field.
	GPIOINT_CLR2_P2_28CI_Msk = 0x10000000
	// Bit P2_28CI.
	GPIOINT_CLR2_P2_28CI = 0x10000000
	// Position of P2_29CI field.
	GPIOINT_CLR2_P2_29CI_Pos = 0x1d
	// Bit mask of P2_29CI field.
	GPIOINT_CLR2_P2_29CI_Msk = 0x20000000
	// Bit P2_29CI.
	GPIOINT_CLR2_P2_29CI = 0x20000000
	// Position of P2_30CI field.
	GPIOINT_CLR2_P2_30CI_Pos = 0x1e
	// Bit mask of P2_30CI field.
	GPIOINT_CLR2_P2_30CI_Msk = 0x40000000
	// Bit P2_30CI.
	GPIOINT_CLR2_P2_30CI = 0x40000000
	// Position of P2_31CI field.
	GPIOINT_CLR2_P2_31CI_Pos = 0x1f
	// Bit mask of P2_31CI field.
	GPIOINT_CLR2_P2_31CI_Msk = 0x80000000
	// Bit P2_31CI.
	GPIOINT_CLR2_P2_31CI = 0x80000000

	// ENR2: GPIO Interrupt Enable for Rising edge for Port 0.
	// Position of P2_0ER field.
	GPIOINT_ENR2_P2_0ER_Pos = 0x0
	// Bit mask of P2_0ER field.
	GPIOINT_ENR2_P2_0ER_Msk = 0x1
	// Bit P2_0ER.
	GPIOINT_ENR2_P2_0ER = 0x1
	// Position of P2_1ER field.
	GPIOINT_ENR2_P2_1ER_Pos = 0x1
	// Bit mask of P2_1ER field.
	GPIOINT_ENR2_P2_1ER_Msk = 0x2
	// Bit P2_1ER.
	GPIOINT_ENR2_P2_1ER = 0x2
	// Position of P2_2ER field.
	GPIOINT_ENR2_P2_2ER_Pos = 0x2
	// Bit mask of P2_2ER field.
	GPIOINT_ENR2_P2_2ER_Msk = 0x4
	// Bit P2_2ER.
	GPIOINT_ENR2_P2_2ER = 0x4
	// Position of P2_3ER field.
	GPIOINT_ENR2_P2_3ER_Pos = 0x3
	// Bit mask of P2_3ER field.
	GPIOINT_ENR2_P2_3ER_Msk = 0x8
	// Bit P2_3ER.
	GPIOINT_ENR2_P2_3ER = 0x8
	// Position of P2_4ER field.
	GPIOINT_ENR2_P2_4ER_Pos = 0x4
	// Bit mask of P2_4ER field.
	GPIOINT_ENR2_P2_4ER_Msk = 0x10
	// Bit P2_4ER.
	GPIOINT_ENR2_P2_4ER = 0x10
	// Position of P2_5ER field.
	GPIOINT_ENR2_P2_5ER_Pos = 0x5
	// Bit mask of P2_5ER field.
	GPIOINT_ENR2_P2_5ER_Msk = 0x20
	// Bit P2_5ER.
	GPIOINT_ENR2_P2_5ER = 0x20
	// Position of P2_6ER field.
	GPIOINT_ENR2_P2_6ER_Pos = 0x6
	// Bit mask of P2_6ER field.
	GPIOINT_ENR2_P2_6ER_Msk = 0x40
	// Bit P2_6ER.
	GPIOINT_ENR2_P2_6ER = 0x40
	// Position of P2_7ER field.
	GPIOINT_ENR2_P2_7ER_Pos = 0x7
	// Bit mask of P2_7ER field.
	GPIOINT_ENR2_P2_7ER_Msk = 0x80
	// Bit P2_7ER.
	GPIOINT_ENR2_P2_7ER = 0x80
	// Position of P2_8ER field.
	GPIOINT_ENR2_P2_8ER_Pos = 0x8
	// Bit mask of P2_8ER field.
	GPIOINT_ENR2_P2_8ER_Msk = 0x100
	// Bit P2_8ER.
	GPIOINT_ENR2_P2_8ER = 0x100
	// Position of P2_9ER field.
	GPIOINT_ENR2_P2_9ER_Pos = 0x9
	// Bit mask of P2_9ER field.
	GPIOINT_ENR2_P2_9ER_Msk = 0x200
	// Bit P2_9ER.
	GPIOINT_ENR2_P2_9ER = 0x200
	// Position of P2_10ER field.
	GPIOINT_ENR2_P2_10ER_Pos = 0xa
	// Bit mask of P2_10ER field.
	GPIOINT_ENR2_P2_10ER_Msk = 0x400
	// Bit P2_10ER.
	GPIOINT_ENR2_P2_10ER = 0x400
	// Position of P2_11ER field.
	GPIOINT_ENR2_P2_11ER_Pos = 0xb
	// Bit mask of P2_11ER field.
	GPIOINT_ENR2_P2_11ER_Msk = 0x800
	// Bit P2_11ER.
	GPIOINT_ENR2_P2_11ER = 0x800
	// Position of P2_12ER field.
	GPIOINT_ENR2_P2_12ER_Pos = 0xc
	// Bit mask of P2_12ER field.
	GPIOINT_ENR2_P2_12ER_Msk = 0x1000
	// Bit P2_12ER.
	GPIOINT_ENR2_P2_12ER = 0x1000
	// Position of P2_13ER field.
	GPIOINT_ENR2_P2_13ER_Pos = 0xd
	// Bit mask of P2_13ER field.
	GPIOINT_ENR2_P2_13ER_Msk = 0x2000
	// Bit P2_13ER.
	GPIOINT_ENR2_P2_13ER = 0x2000
	// Position of P2_14ER field.
	GPIOINT_ENR2_P2_14ER_Pos = 0xe
	// Bit mask of P2_14ER field.
	GPIOINT_ENR2_P2_14ER_Msk = 0x4000
	// Bit P2_14ER.
	GPIOINT_ENR2_P2_14ER = 0x4000
	// Position of P2_15ER field.
	GPIOINT_ENR2_P2_15ER_Pos = 0xf
	// Bit mask of P2_15ER field.
	GPIOINT_ENR2_P2_15ER_Msk = 0x8000
	// Bit P2_15ER.
	GPIOINT_ENR2_P2_15ER = 0x8000
	// Position of P2_16ER field.
	GPIOINT_ENR2_P2_16ER_Pos = 0x10
	// Bit mask of P2_16ER field.
	GPIOINT_ENR2_P2_16ER_Msk = 0x10000
	// Bit P2_16ER.
	GPIOINT_ENR2_P2_16ER = 0x10000
	// Position of P2_17ER field.
	GPIOINT_ENR2_P2_17ER_Pos = 0x11
	// Bit mask of P2_17ER field.
	GPIOINT_ENR2_P2_17ER_Msk = 0x20000
	// Bit P2_17ER.
	GPIOINT_ENR2_P2_17ER = 0x20000
	// Position of P2_18ER field.
	GPIOINT_ENR2_P2_18ER_Pos = 0x12
	// Bit mask of P2_18ER field.
	GPIOINT_ENR2_P2_18ER_Msk = 0x40000
	// Bit P2_18ER.
	GPIOINT_ENR2_P2_18ER = 0x40000
	// Position of P2_19ER field.
	GPIOINT_ENR2_P2_19ER_Pos = 0x13
	// Bit mask of P2_19ER field.
	GPIOINT_ENR2_P2_19ER_Msk = 0x80000
	// Bit P2_19ER.
	GPIOINT_ENR2_P2_19ER = 0x80000
	// Position of P2_20ER field.
	GPIOINT_ENR2_P2_20ER_Pos = 0x14
	// Bit mask of P2_20ER field.
	GPIOINT_ENR2_P2_20ER_Msk = 0x100000
	// Bit P2_20ER.
	GPIOINT_ENR2_P2_20ER = 0x100000
	// Position of P2_21ER field.
	GPIOINT_ENR2_P2_21ER_Pos = 0x15
	// Bit mask of P2_21ER field.
	GPIOINT_ENR2_P2_21ER_Msk = 0x200000
	// Bit P2_21ER.
	GPIOINT_ENR2_P2_21ER = 0x200000
	// Position of P2_22ER field.
	GPIOINT_ENR2_P2_22ER_Pos = 0x16
	// Bit mask of P2_22ER field.
	GPIOINT_ENR2_P2_22ER_Msk = 0x400000
	// Bit P2_22ER.
	GPIOINT_ENR2_P2_22ER = 0x400000
	// Position of P2_23ER field.
	GPIOINT_ENR2_P2_23ER_Pos = 0x17
	// Bit mask of P2_23ER field.
	GPIOINT_ENR2_P2_23ER_Msk = 0x800000
	// Bit P2_23ER.
	GPIOINT_ENR2_P2_23ER = 0x800000
	// Position of P2_24ER field.
	GPIOINT_ENR2_P2_24ER_Pos = 0x18
	// Bit mask of P2_24ER field.
	GPIOINT_ENR2_P2_24ER_Msk = 0x1000000
	// Bit P2_24ER.
	GPIOINT_ENR2_P2_24ER = 0x1000000
	// Position of P2_25ER field.
	GPIOINT_ENR2_P2_25ER_Pos = 0x19
	// Bit mask of P2_25ER field.
	GPIOINT_ENR2_P2_25ER_Msk = 0x2000000
	// Bit P2_25ER.
	GPIOINT_ENR2_P2_25ER = 0x2000000
	// Position of P2_26ER field.
	GPIOINT_ENR2_P2_26ER_Pos = 0x1a
	// Bit mask of P2_26ER field.
	GPIOINT_ENR2_P2_26ER_Msk = 0x4000000
	// Bit P2_26ER.
	GPIOINT_ENR2_P2_26ER = 0x4000000
	// Position of P2_27ER field.
	GPIOINT_ENR2_P2_27ER_Pos = 0x1b
	// Bit mask of P2_27ER field.
	GPIOINT_ENR2_P2_27ER_Msk = 0x8000000
	// Bit P2_27ER.
	GPIOINT_ENR2_P2_27ER = 0x8000000
	// Position of P2_28ER field.
	GPIOINT_ENR2_P2_28ER_Pos = 0x1c
	// Bit mask of P2_28ER field.
	GPIOINT_ENR2_P2_28ER_Msk = 0x10000000
	// Bit P2_28ER.
	GPIOINT_ENR2_P2_28ER = 0x10000000
	// Position of P2_29ER field.
	GPIOINT_ENR2_P2_29ER_Pos = 0x1d
	// Bit mask of P2_29ER field.
	GPIOINT_ENR2_P2_29ER_Msk = 0x20000000
	// Bit P2_29ER.
	GPIOINT_ENR2_P2_29ER = 0x20000000
	// Position of P2_30ER field.
	GPIOINT_ENR2_P2_30ER_Pos = 0x1e
	// Bit mask of P2_30ER field.
	GPIOINT_ENR2_P2_30ER_Msk = 0x40000000
	// Bit P2_30ER.
	GPIOINT_ENR2_P2_30ER = 0x40000000
	// Position of P2_31ER field.
	GPIOINT_ENR2_P2_31ER_Pos = 0x1f
	// Bit mask of P2_31ER field.
	GPIOINT_ENR2_P2_31ER_Msk = 0x80000000
	// Bit P2_31ER.
	GPIOINT_ENR2_P2_31ER = 0x80000000

	// ENF2: GPIO Interrupt Enable for Falling edge for Port 0.
	// Position of P2_0EF field.
	GPIOINT_ENF2_P2_0EF_Pos = 0x0
	// Bit mask of P2_0EF field.
	GPIOINT_ENF2_P2_0EF_Msk = 0x1
	// Bit P2_0EF.
	GPIOINT_ENF2_P2_0EF = 0x1
	// Position of P2_1EF field.
	GPIOINT_ENF2_P2_1EF_Pos = 0x1
	// Bit mask of P2_1EF field.
	GPIOINT_ENF2_P2_1EF_Msk = 0x2
	// Bit P2_1EF.
	GPIOINT_ENF2_P2_1EF = 0x2
	// Position of P2_2EF field.
	GPIOINT_ENF2_P2_2EF_Pos = 0x2
	// Bit mask of P2_2EF field.
	GPIOINT_ENF2_P2_2EF_Msk = 0x4
	// Bit P2_2EF.
	GPIOINT_ENF2_P2_2EF = 0x4
	// Position of P2_3EF field.
	GPIOINT_ENF2_P2_3EF_Pos = 0x3
	// Bit mask of P2_3EF field.
	GPIOINT_ENF2_P2_3EF_Msk = 0x8
	// Bit P2_3EF.
	GPIOINT_ENF2_P2_3EF = 0x8
	// Position of P2_4EF field.
	GPIOINT_ENF2_P2_4EF_Pos = 0x4
	// Bit mask of P2_4EF field.
	GPIOINT_ENF2_P2_4EF_Msk = 0x10
	// Bit P2_4EF.
	GPIOINT_ENF2_P2_4EF = 0x10
	// Position of P2_5EF field.
	GPIOINT_ENF2_P2_5EF_Pos = 0x5
	// Bit mask of P2_5EF field.
	GPIOINT_ENF2_P2_5EF_Msk = 0x20
	// Bit P2_5EF.
	GPIOINT_ENF2_P2_5EF = 0x20
	// Position of P2_6EF field.
	GPIOINT_ENF2_P2_6EF_Pos = 0x6
	// Bit mask of P2_6EF field.
	GPIOINT_ENF2_P2_6EF_Msk = 0x40
	// Bit P2_6EF.
	GPIOINT_ENF2_P2_6EF = 0x40
	// Position of P2_7EF field.
	GPIOINT_ENF2_P2_7EF_Pos = 0x7
	// Bit mask of P2_7EF field.
	GPIOINT_ENF2_P2_7EF_Msk = 0x80
	// Bit P2_7EF.
	GPIOINT_ENF2_P2_7EF = 0x80
	// Position of P2_8EF field.
	GPIOINT_ENF2_P2_8EF_Pos = 0x8
	// Bit mask of P2_8EF field.
	GPIOINT_ENF2_P2_8EF_Msk = 0x100
	// Bit P2_8EF.
	GPIOINT_ENF2_P2_8EF = 0x100
	// Position of P2_9EF field.
	GPIOINT_ENF2_P2_9EF_Pos = 0x9
	// Bit mask of P2_9EF field.
	GPIOINT_ENF2_P2_9EF_Msk = 0x200
	// Bit P2_9EF.
	GPIOINT_ENF2_P2_9EF = 0x200
	// Position of P2_10EF field.
	GPIOINT_ENF2_P2_10EF_Pos = 0xa
	// Bit mask of P2_10EF field.
	GPIOINT_ENF2_P2_10EF_Msk = 0x400
	// Bit P2_10EF.
	GPIOINT_ENF2_P2_10EF = 0x400
	// Position of P2_11EF field.
	GPIOINT_ENF2_P2_11EF_Pos = 0xb
	// Bit mask of P2_11EF field.
	GPIOINT_ENF2_P2_11EF_Msk = 0x800
	// Bit P2_11EF.
	GPIOINT_ENF2_P2_11EF = 0x800
	// Position of P2_12EF field.
	GPIOINT_ENF2_P2_12EF_Pos = 0xc
	// Bit mask of P2_12EF field.
	GPIOINT_ENF2_P2_12EF_Msk = 0x1000
	// Bit P2_12EF.
	GPIOINT_ENF2_P2_12EF = 0x1000
	// Position of P2_13EF field.
	GPIOINT_ENF2_P2_13EF_Pos = 0xd
	// Bit mask of P2_13EF field.
	GPIOINT_ENF2_P2_13EF_Msk = 0x2000
	// Bit P2_13EF.
	GPIOINT_ENF2_P2_13EF = 0x2000
	// Position of P2_14EF field.
	GPIOINT_ENF2_P2_14EF_Pos = 0xe
	// Bit mask of P2_14EF field.
	GPIOINT_ENF2_P2_14EF_Msk = 0x4000
	// Bit P2_14EF.
	GPIOINT_ENF2_P2_14EF = 0x4000
	// Position of P2_15EF field.
	GPIOINT_ENF2_P2_15EF_Pos = 0xf
	// Bit mask of P2_15EF field.
	GPIOINT_ENF2_P2_15EF_Msk = 0x8000
	// Bit P2_15EF.
	GPIOINT_ENF2_P2_15EF = 0x8000
	// Position of P2_16EF field.
	GPIOINT_ENF2_P2_16EF_Pos = 0x10
	// Bit mask of P2_16EF field.
	GPIOINT_ENF2_P2_16EF_Msk = 0x10000
	// Bit P2_16EF.
	GPIOINT_ENF2_P2_16EF = 0x10000
	// Position of P2_17EF field.
	GPIOINT_ENF2_P2_17EF_Pos = 0x11
	// Bit mask of P2_17EF field.
	GPIOINT_ENF2_P2_17EF_Msk = 0x20000
	// Bit P2_17EF.
	GPIOINT_ENF2_P2_17EF = 0x20000
	// Position of P2_18EF field.
	GPIOINT_ENF2_P2_18EF_Pos = 0x12
	// Bit mask of P2_18EF field.
	GPIOINT_ENF2_P2_18EF_Msk = 0x40000
	// Bit P2_18EF.
	GPIOINT_ENF2_P2_18EF = 0x40000
	// Position of P2_19EF field.
	GPIOINT_ENF2_P2_19EF_Pos = 0x13
	// Bit mask of P2_19EF field.
	GPIOINT_ENF2_P2_19EF_Msk = 0x80000
	// Bit P2_19EF.
	GPIOINT_ENF2_P2_19EF = 0x80000
	// Position of P2_20EF field.
	GPIOINT_ENF2_P2_20EF_Pos = 0x14
	// Bit mask of P2_20EF field.
	GPIOINT_ENF2_P2_20EF_Msk = 0x100000
	// Bit P2_20EF.
	GPIOINT_ENF2_P2_20EF = 0x100000
	// Position of P2_21EF field.
	GPIOINT_ENF2_P2_21EF_Pos = 0x15
	// Bit mask of P2_21EF field.
	GPIOINT_ENF2_P2_21EF_Msk = 0x200000
	// Bit P2_21EF.
	GPIOINT_ENF2_P2_21EF = 0x200000
	// Position of P2_22EF field.
	GPIOINT_ENF2_P2_22EF_Pos = 0x16
	// Bit mask of P2_22EF field.
	GPIOINT_ENF2_P2_22EF_Msk = 0x400000
	// Bit P2_22EF.
	GPIOINT_ENF2_P2_22EF = 0x400000
	// Position of P2_23EF field.
	GPIOINT_ENF2_P2_23EF_Pos = 0x17
	// Bit mask of P2_23EF field.
	GPIOINT_ENF2_P2_23EF_Msk = 0x800000
	// Bit P2_23EF.
	GPIOINT_ENF2_P2_23EF = 0x800000
	// Position of P2_24EF field.
	GPIOINT_ENF2_P2_24EF_Pos = 0x18
	// Bit mask of P2_24EF field.
	GPIOINT_ENF2_P2_24EF_Msk = 0x1000000
	// Bit P2_24EF.
	GPIOINT_ENF2_P2_24EF = 0x1000000
	// Position of P2_25EF field.
	GPIOINT_ENF2_P2_25EF_Pos = 0x19
	// Bit mask of P2_25EF field.
	GPIOINT_ENF2_P2_25EF_Msk = 0x2000000
	// Bit P2_25EF.
	GPIOINT_ENF2_P2_25EF = 0x2000000
	// Position of P2_26EF field.
	GPIOINT_ENF2_P2_26EF_Pos = 0x1a
	// Bit mask of P2_26EF field.
	GPIOINT_ENF2_P2_26EF_Msk = 0x4000000
	// Bit P2_26EF.
	GPIOINT_ENF2_P2_26EF = 0x4000000
	// Position of P2_27EF field.
	GPIOINT_ENF2_P2_27EF_Pos = 0x1b
	// Bit mask of P2_27EF field.
	GPIOINT_ENF2_P2_27EF_Msk = 0x8000000
	// Bit P2_27EF.
	GPIOINT_ENF2_P2_27EF = 0x8000000
	// Position of P2_28EF field.
	GPIOINT_ENF2_P2_28EF_Pos = 0x1c
	// Bit mask of P2_28EF field.
	GPIOINT_ENF2_P2_28EF_Msk = 0x10000000
	// Bit P2_28EF.
	GPIOINT_ENF2_P2_28EF = 0x10000000
	// Position of P2_29EF field.
	GPIOINT_ENF2_P2_29EF_Pos = 0x1d
	// Bit mask of P2_29EF field.
	GPIOINT_ENF2_P2_29EF_Msk = 0x20000000
	// Bit P2_29EF.
	GPIOINT_ENF2_P2_29EF = 0x20000000
	// Position of P2_30EF field.
	GPIOINT_ENF2_P2_30EF_Pos = 0x1e
	// Bit mask of P2_30EF field.
	GPIOINT_ENF2_P2_30EF_Msk = 0x40000000
	// Bit P2_30EF.
	GPIOINT_ENF2_P2_30EF = 0x40000000
	// Position of P2_31EF field.
	GPIOINT_ENF2_P2_31EF_Pos = 0x1f
	// Bit mask of P2_31EF field.
	GPIOINT_ENF2_P2_31EF_Msk = 0x80000000
	// Bit P2_31EF.
	GPIOINT_ENF2_P2_31EF = 0x80000000
)

// Bitfields for IOCON: IOCON pin configuration
const (
	// P0_0: I/O configuration register for pin P0[0]
	// Position of FUNC field.
	IOCON_P0_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_0_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_0_FUNC_P0_0 = 0x0
	// CAN1 receiver input.
	IOCON_P0_0_FUNC_CAN_RD1 = 0x1
	// Transmitter output for UART3.
	IOCON_P0_0_FUNC_U3_TXD = 0x2
	// I2C1 data input/output(this pin does not use a specialized I2C pad).
	IOCON_P0_0_FUNC_I2C1_SDA = 0x3
	// Transmitter output for UART0.
	IOCON_P0_0_FUNC_U0_TXD = 0x4
	// Position of MODE field.
	IOCON_P0_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_0_HYS = 0x20
	// Disable.
	IOCON_P0_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_0_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_0_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_0_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_0_OD = 0x400
	// Disable.
	IOCON_P0_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_0_RESERVED_Msk = 0xfffff800

	// P0_1: I/O configuration register for pin P0[1]
	// Position of FUNC field.
	IOCON_P0_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_1_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_1_FUNC_P0_1 = 0x0
	// CAN1 transmitter output.
	IOCON_P0_1_FUNC_CAN_TD1 = 0x1
	// Receiver input for UART3.
	IOCON_P0_1_FUNC_U3_RXD = 0x2
	// I2C1 clock input/output (this pin does not use a specialized I2C pad).
	IOCON_P0_1_FUNC_I2C1_SCL = 0x3
	// Receiver input for UART0.
	IOCON_P0_1_FUNC_U0_RXD = 0x4
	// Position of MODE field.
	IOCON_P0_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_1_HYS = 0x20
	// Disable.
	IOCON_P0_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_1_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_1_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_1_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_1_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_1_OD = 0x400
	// Disable.
	IOCON_P0_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_1_RESERVED_Msk = 0xfffff800

	// P0_2: I/O configuration register for pin P0[2]
	// Position of FUNC field.
	IOCON_P0_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_2_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_2_FUNC_P0_2 = 0x0
	// Transmitter output for UART0.
	IOCON_P0_2_FUNC_U0_TXD = 0x1
	// Transmitter output for UART3.
	IOCON_P0_2_FUNC_U3_TXD = 0x2
	// Position of MODE field.
	IOCON_P0_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_2_HYS = 0x20
	// Disable.
	IOCON_P0_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_2_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_2_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_2_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_2_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_2_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_2_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_2_OD = 0x400
	// Disable.
	IOCON_P0_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_2_RESERVED_Msk = 0xfffff800

	// P0_3: I/O configuration register for pin P0[3]
	// Position of FUNC field.
	IOCON_P0_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_3_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_3_FUNC_P0_3 = 0x0
	// Receiver input for UART0.
	IOCON_P0_3_FUNC_U0_RXD = 0x1
	// Receiver input for UART3.
	IOCON_P0_3_FUNC_U3_RXD = 0x2
	// Position of MODE field.
	IOCON_P0_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_3_HYS = 0x20
	// Disable.
	IOCON_P0_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_3_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_3_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_3_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_3_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_3_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_3_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_3_OD = 0x400
	// Disable.
	IOCON_P0_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_3_RESERVED_Msk = 0xfffff800

	// P0_4: I/O configuration register for pin P0[4]
	// Position of FUNC field.
	IOCON_P0_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_4_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_4_FUNC_P0_4 = 0x0
	// I2S Receive clock. It is driven by the master and received by the slave. Corresponds to the signal SCK in the I2S-bus specification.
	IOCON_P0_4_FUNC_I2S_RX_SCK = 0x1
	// CAN2 receiver input.
	IOCON_P0_4_FUNC_CAN_RD2 = 0x2
	// Capture input for Timer 2, channel 0.
	IOCON_P0_4_FUNC_T2_CAP0 = 0x3
	// LCD data.
	IOCON_P0_4_FUNC_LCD_VD_0 = 0x7
	// Position of MODE field.
	IOCON_P0_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_4_HYS = 0x20
	// Disable.
	IOCON_P0_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_4_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_4_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_4_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_4_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_4_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_4_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_4_OD = 0x400
	// Disable.
	IOCON_P0_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_4_RESERVED_Msk = 0xfffff800

	// P0_5: I/O configuration register for pin P0[5]
	// Position of FUNC field.
	IOCON_P0_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_5_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_5_FUNC_P0_5 = 0x0
	// I2S Receive word select. It is driven by the master and received by the slave. Corresponds to the signal WS in the I2S-bus specification.
	IOCON_P0_5_FUNC_I2S_RX_WS = 0x1
	// CAN2 transmitter output.
	IOCON_P0_5_FUNC_CAN_TD2 = 0x2
	// Capture input for Timer 2, channel 1.
	IOCON_P0_5_FUNC_T2_CAP1 = 0x3
	// LCD data.
	IOCON_P0_5_FUNC_LCD_VD_1 = 0x7
	// Position of MODE field.
	IOCON_P0_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_5_HYS = 0x20
	// Disable.
	IOCON_P0_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_5_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_5_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_5_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_5_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_5_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_5_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_5_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_5_OD = 0x400
	// Disable.
	IOCON_P0_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_5_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_5_RESERVED_Msk = 0xfffff800

	// P0_6: I/O configuration register for pin P0[6]
	// Position of FUNC field.
	IOCON_P0_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_6_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_6_FUNC_P0_6 = 0x0
	// I2S Receive data. It is driven by the transmitter and read by the receiver. Corresponds to the signal SD in the I2S-bus specification.
	IOCON_P0_6_FUNC_I2S_RX_SDA = 0x1
	// Slave Select for SSP1.
	IOCON_P0_6_FUNC_SSP1_SSEL = 0x2
	// Match output for Timer 2, channel 0.
	IOCON_P0_6_FUNC_T2_MAT0 = 0x3
	// Request to Send output for UART1. Can also be configured to be an RS-485/EIA-485 output enable signal for UART1.
	IOCON_P0_6_FUNC_U1_RTS = 0x4
	// LCD data.
	IOCON_P0_6_FUNC_LCD_VD_8 = 0x7
	// Position of MODE field.
	IOCON_P0_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_6_HYS = 0x20
	// Disable.
	IOCON_P0_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_6_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_6_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_6_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_6_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_6_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_6_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_6_OD = 0x400
	// Disable.
	IOCON_P0_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_6_RESERVED_Msk = 0xfffff800

	// P0_7: I/O configuration register for pin P0[7]
	// Position of FUNC field.
	IOCON_P0_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_7_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_7_FUNC_P0_7 = 0x0
	// I2S transmit clock. It is driven by the master and received by the slave. Corresponds to the signal SCK in the I2S-bus specification.
	IOCON_P0_7_FUNC_I2S_TX_SCK = 0x1
	// Serial Clock for SSP1.
	IOCON_P0_7_FUNC_SSP1_SCK = 0x2
	// Match output for Timer 2, channel 1.
	IOCON_P0_7_FUNC_T2_MAT1 = 0x3
	// Event input 0 to Event Monitor/Recorder.
	IOCON_P0_7_FUNC_RTC_EV0 = 0x4
	// LCD data.
	IOCON_P0_7_FUNC_LCD_VD_9 = 0x7
	// Position of MODE field.
	IOCON_P0_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_7_HYS = 0x20
	// Disable.
	IOCON_P0_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_7_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_P0_7_RESERVED = 0x80
	// Position of FILTER field.
	IOCON_P0_7_FILTER_Pos = 0x8
	// Bit mask of FILTER field.
	IOCON_P0_7_FILTER_Msk = 0x100
	// Bit FILTER.
	IOCON_P0_7_FILTER = 0x100
	// Noise pulses below approximately 10 ns are filtered out.
	IOCON_P0_7_FILTER_ENABLED = 0x0
	// No input filtering is done.
	IOCON_P0_7_FILTER_DISABLED = 0x1
	// Position of SLEW field.
	IOCON_P0_7_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_7_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_7_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_7_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_7_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_7_OD = 0x400
	// Disable.
	IOCON_P0_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_7_RESERVED_Msk = 0xfffff800

	// P0_8: I/O configuration register for pin P0[8]
	// Position of FUNC field.
	IOCON_P0_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_8_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_8_FUNC_P0_8 = 0x0
	// I2S Transmit word select. It is driven by the master and received by the slave. Corresponds to the signal WS in the I2S-bus specification.
	IOCON_P0_8_FUNC_I2S_TX_WS = 0x1
	// Master In Slave Out for SSP1.
	IOCON_P0_8_FUNC_SSP1_MISO = 0x2
	// Match output for Timer 2, channel 2.
	IOCON_P0_8_FUNC_T2_MAT2 = 0x3
	// Event input 1 to Event Monitor/Recorder.
	IOCON_P0_8_FUNC_RTC_EV1 = 0x4
	// LCD data.
	IOCON_P0_8_FUNC_LCD_VD_16 = 0x7
	// Position of MODE field.
	IOCON_P0_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_8_HYS = 0x20
	// Disable.
	IOCON_P0_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_8_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_P0_8_RESERVED = 0x80
	// Position of FILTER field.
	IOCON_P0_8_FILTER_Pos = 0x8
	// Bit mask of FILTER field.
	IOCON_P0_8_FILTER_Msk = 0x100
	// Bit FILTER.
	IOCON_P0_8_FILTER = 0x100
	// Noise pulses below approximately 10 ns are filtered out.
	IOCON_P0_8_FILTER_ENABLED = 0x0
	// No input filtering is done.
	IOCON_P0_8_FILTER_DISABLED = 0x1
	// Position of SLEW field.
	IOCON_P0_8_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_8_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_8_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_8_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_8_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_8_OD = 0x400
	// Disable.
	IOCON_P0_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_8_RESERVED_Msk = 0xfffff800

	// P0_9: I/O configuration register for pin P0[9]
	// Position of FUNC field.
	IOCON_P0_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_9_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_9_FUNC_P0_9 = 0x0
	// I2S transmit data. It is driven by the transmitter and read by the receiver. Corresponds to the signal SD in the I2S-bus specification.
	IOCON_P0_9_FUNC_I2S_TX_SDA = 0x1
	// Master Out Slave In for SSP1.
	IOCON_P0_9_FUNC_SSP1_MOSI = 0x2
	// Match output for Timer 2, channel 3.
	IOCON_P0_9_FUNC_T2_MAT3 = 0x3
	// Event input 2 to Event Monitor/Recorder.
	IOCON_P0_9_FUNC_RTC_EV2 = 0x4
	// LCD data.
	IOCON_P0_9_FUNC_LCD_VD_17 = 0x7
	// Position of MODE field.
	IOCON_P0_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_9_HYS = 0x20
	// Disable.
	IOCON_P0_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_9_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_P0_9_RESERVED = 0x80
	// Position of FILTER field.
	IOCON_P0_9_FILTER_Pos = 0x8
	// Bit mask of FILTER field.
	IOCON_P0_9_FILTER_Msk = 0x100
	// Bit FILTER.
	IOCON_P0_9_FILTER = 0x100
	// Noise pulses below approximately 10 ns are filtered out.
	IOCON_P0_9_FILTER_ENABLED = 0x0
	// No input filtering is done.
	IOCON_P0_9_FILTER_DISABLED = 0x1
	// Position of SLEW field.
	IOCON_P0_9_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_9_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_9_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_9_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_9_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_9_OD = 0x400
	// Disable.
	IOCON_P0_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_9_RESERVED_Msk = 0xfffff800

	// P0_10: I/O configuration register for pin P0[10]
	// Position of FUNC field.
	IOCON_P0_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_10_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_10_FUNC_P0_10 = 0x0
	// Transmitter output for UART2.
	IOCON_P0_10_FUNC_U2_TXD = 0x1
	// I2C2 data input/output (this pin does not use a specialized I2C pad).
	IOCON_P0_10_FUNC_I2C2_SDA = 0x2
	// Match output for Timer 3, channel 0.
	IOCON_P0_10_FUNC_T3_MAT0 = 0x3
	// Position of MODE field.
	IOCON_P0_10_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_10_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_10_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_10_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_10_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_10_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_10_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_10_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_10_HYS = 0x20
	// Disable.
	IOCON_P0_10_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_10_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_10_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_10_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_10_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_10_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_10_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_10_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_10_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_10_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_10_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_10_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_10_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_10_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_10_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_10_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_10_OD = 0x400
	// Disable.
	IOCON_P0_10_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_10_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_10_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_10_RESERVED_Msk = 0xfffff800

	// P0_11: I/O configuration register for pin P0[11]
	// Position of FUNC field.
	IOCON_P0_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_11_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_11_FUNC_P0_11 = 0x0
	// Receiver input for UART2.
	IOCON_P0_11_FUNC_U2_RXD = 0x1
	// I2C2 clock input/output (this pin does not use a specialized I2C pad).
	IOCON_P0_11_FUNC_I2C2_SCL = 0x2
	// Match output for Timer 3, channel 1.
	IOCON_P0_11_FUNC_T3_MAT1 = 0x3
	// Position of MODE field.
	IOCON_P0_11_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_11_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_11_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_11_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_11_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_11_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_11_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_11_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_11_HYS = 0x20
	// Disable.
	IOCON_P0_11_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_11_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_11_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_11_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_11_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_11_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_11_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_11_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_11_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_11_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_11_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_11_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_11_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_11_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_11_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_11_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_11_OD = 0x400
	// Disable.
	IOCON_P0_11_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_11_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_11_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_11_RESERVED_Msk = 0xfffff800

	// P0_12: I/O configuration register for pin P0[12]
	// Position of FUNC field.
	IOCON_P0_12_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_12_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_12_FUNC_P0_12 = 0x0
	// Port Power enable signal for USB port 2.
	IOCON_P0_12_FUNC_USB_PPWR2 = 0x1
	// Master In Slave Out for SSP1.
	IOCON_P0_12_FUNC_SSP1_MISO = 0x2
	// A/D converter 0, input 6. When configured as an ADC input, the digital function of the pin must be disabled.
	IOCON_P0_12_FUNC_ADC0_IN_6 = 0x3

	// P0_13: I/O configuration register for pin P0[13]
	// Position of FUNC field.
	IOCON_P0_13_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_13_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_13_FUNC_P0_13 = 0x0
	// USB port 2 GoodLink LED indicator. It is LOW when the device is configured (non-control endpoints enabled), or when the host is enabled and has detected a device on the bus. It is HIGH when the device is not configured, or when host is enabled and has not detected a device on the bus, or during global suspend. It transitions between LOW and HIGH (flashes) when the host is enabled and detects activity on the bus.
	IOCON_P0_13_FUNC_USB_UP_LED2 = 0x1
	// Master Out Slave In for SSP1.
	IOCON_P0_13_FUNC_SSP1_MOSI = 0x2
	// A/D converter 0, input 7. When configured as an ADC input, the digital function of the pin must be disabled.
	IOCON_P0_13_FUNC_ADC0_IN_7 = 0x3

	// P0_14: I/O configuration register for pin P0[14]
	// Position of FUNC field.
	IOCON_P0_14_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_14_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_14_FUNC_P0_14 = 0x0
	// Host Enabled status for USB port 2.
	IOCON_P0_14_FUNC_USB_HSTEN2 = 0x1
	// Slave Select for SSP1.
	IOCON_P0_14_FUNC_SSP1_SSEL = 0x2
	// SoftConnect control for USB port 2. Signal used to switch an external 1.5 kW resistor under software control. Used with the SoftConnect USB feature.
	IOCON_P0_14_FUNC_USB_CONNECT2 = 0x3
	// Position of MODE field.
	IOCON_P0_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_14_HYS = 0x20
	// Disable.
	IOCON_P0_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_14_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_14_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_14_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_14_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_14_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_14_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_14_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_14_OD = 0x400
	// Disable.
	IOCON_P0_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_14_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_14_RESERVED_Msk = 0xfffff800

	// P0_15: I/O configuration register for pin P0[15]
	// Position of FUNC field.
	IOCON_P0_15_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_15_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_15_FUNC_P0_15 = 0x0
	// Transmitter output for UART1.
	IOCON_P0_15_FUNC_U1_TXD = 0x1
	// Serial clock for SSP0.
	IOCON_P0_15_FUNC_SSP0_SCK = 0x2
	// Position of MODE field.
	IOCON_P0_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_15_HYS = 0x20
	// Disable.
	IOCON_P0_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_15_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_15_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_15_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_15_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_15_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_15_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_15_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_15_OD = 0x400
	// Disable.
	IOCON_P0_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_15_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_15_RESERVED_Msk = 0xfffff800

	// P0_16: I/O configuration register for pin P0[16]
	// Position of FUNC field.
	IOCON_P0_16_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_16_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_16_FUNC_P0_16 = 0x0
	// Receiver input for UART1.
	IOCON_P0_16_FUNC_U1_RXD = 0x1
	// Slave Select for SSP0.
	IOCON_P0_16_FUNC_SSP0_SSEL = 0x2
	// Position of MODE field.
	IOCON_P0_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_16_HYS = 0x20
	// Disable.
	IOCON_P0_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_16_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_16_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_16_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_16_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_16_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_16_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_16_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_16_OD = 0x400
	// Disable.
	IOCON_P0_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_16_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_16_RESERVED_Msk = 0xfffff800

	// P0_17: I/O configuration register for pin P0[17]
	// Position of FUNC field.
	IOCON_P0_17_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_17_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_17_FUNC_P0_17 = 0x0
	// Clear to Send input for UART1.
	IOCON_P0_17_FUNC_U1_CTS = 0x1
	// Master In Slave Out for SSP0.
	IOCON_P0_17_FUNC_SSP0_MISO = 0x2
	// Position of MODE field.
	IOCON_P0_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_17_HYS = 0x20
	// Disable.
	IOCON_P0_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_17_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_17_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_17_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_17_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_17_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_17_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_17_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_17_OD = 0x400
	// Disable.
	IOCON_P0_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_17_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_17_RESERVED_Msk = 0xfffff800

	// P0_18: I/O configuration register for pin P0[18]
	// Position of FUNC field.
	IOCON_P0_18_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_18_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_18_FUNC_P0_18 = 0x0
	// Data Carrier Detect input for UART1.
	IOCON_P0_18_FUNC_U1_DCD = 0x1
	// Master Out Slave In for SSP0.
	IOCON_P0_18_FUNC_SSP0_MOSI = 0x2
	// Position of MODE field.
	IOCON_P0_18_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_18_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_18_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_18_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_18_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_18_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_18_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_18_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_18_HYS = 0x20
	// Disable.
	IOCON_P0_18_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_18_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_18_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_18_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_18_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_18_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_18_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_18_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_18_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_18_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_18_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_18_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_18_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_18_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_18_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_18_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_18_OD = 0x400
	// Disable.
	IOCON_P0_18_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_18_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_18_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_18_RESERVED_Msk = 0xfffff800

	// P0_19: I/O configuration register for pin P0[19]
	// Position of FUNC field.
	IOCON_P0_19_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_19_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_19_FUNC_P0_19 = 0x0
	// Data Set Ready input for UART1.
	IOCON_P0_19_FUNC_U1_DSR = 0x1
	// Clock output line for SD card interface.
	IOCON_P0_19_FUNC_SD_CLK = 0x2
	// I2C1 data input/output (this pin does not use a specialized I2C pad).
	IOCON_P0_19_FUNC_I2C1_SDA = 0x3
	// Position of MODE field.
	IOCON_P0_19_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_19_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_19_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_19_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_19_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_19_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_19_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_19_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_19_HYS = 0x20
	// Disable.
	IOCON_P0_19_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_19_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_19_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_19_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_19_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_19_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_19_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_19_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_19_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_19_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_19_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_19_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_19_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_19_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_19_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_19_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_19_OD = 0x400
	// Disable.
	IOCON_P0_19_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_19_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_19_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_19_RESERVED_Msk = 0xfffff800

	// P0_20: I/O configuration register for pin P0[20]
	// Position of FUNC field.
	IOCON_P0_20_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_20_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_20_FUNC_P0_20 = 0x0
	// Data Terminal Ready output for UART1. Can also be configured to be an RS-485/EIA-485 output enable signal for UART1.
	IOCON_P0_20_FUNC_U1_DTR = 0x1
	// Command line for SD card interface.
	IOCON_P0_20_FUNC_SD_CMD = 0x2
	// I2C1 clock input/output (this pin does not use a specialized I2C pad).
	IOCON_P0_20_FUNC_I2C1_SCL = 0x3
	// Position of MODE field.
	IOCON_P0_20_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_20_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_20_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_20_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_20_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_20_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_20_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_20_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_20_HYS = 0x20
	// Disable.
	IOCON_P0_20_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_20_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_20_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_20_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_20_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_20_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_20_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_20_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_20_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_20_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_20_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_20_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_20_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_20_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_20_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_20_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_20_OD = 0x400
	// Disable.
	IOCON_P0_20_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_20_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_20_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_20_RESERVED_Msk = 0xfffff800

	// P0_21: I/O configuration register for pin P0[21]
	// Position of FUNC field.
	IOCON_P0_21_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_21_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_21_FUNC_P0_21 = 0x0
	// Ring Indicator input for UART1.
	IOCON_P0_21_FUNC_U1_RI = 0x1
	// Power Supply Enable for external SD card power supply.
	IOCON_P0_21_FUNC_SD_PWR = 0x2
	// RS-485/EIA-485 output enable signal for UART4.
	IOCON_P0_21_FUNC_U4_OE = 0x3
	// CAN1 receiver input.
	IOCON_P0_21_FUNC_CAN_RD1 = 0x4
	// USART 4 clock input or output in synchronous mode.
	IOCON_P0_21_FUNC_U4_SCLK = 0x5
	// Position of MODE field.
	IOCON_P0_21_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_21_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_21_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_21_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_21_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_21_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_21_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_21_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_21_HYS = 0x20
	// Disable.
	IOCON_P0_21_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_21_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_21_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_21_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_21_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_21_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_21_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_21_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_21_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P0_21_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P0_21_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P0_21_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P0_21_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_21_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P0_21_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_21_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_21_OD = 0x400
	// Disable.
	IOCON_P0_21_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P0_21_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_21_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_21_RESERVED_Msk = 0xfffff800

	// P0_22: I/O configuration register for pin P0[22]
	// Position of FUNC field.
	IOCON_P0_22_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_22_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_22_FUNC_P0_22 = 0x0
	// Request to Send output for UART1. Can also be configured to be an RS-485/EIA-485 output enable signal for UART1.
	IOCON_P0_22_FUNC_U1_RTS = 0x1
	// Data line 0 for SD card interface.
	IOCON_P0_22_FUNC_SD_DAT_0 = 0x2
	// Transmitter output for USART4 (input/output in smart card mode).
	IOCON_P0_22_FUNC_U4_TXD = 0x3
	// CAN1 transmitter output.
	IOCON_P0_22_FUNC_CAN_TD1 = 0x4
	// Position of MODE field.
	IOCON_P0_22_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_22_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_22_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_22_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_22_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_22_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_22_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_22_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_22_HYS = 0x20
	// Disable.
	IOCON_P0_22_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_22_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_22_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_22_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_22_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_22_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_22_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_P0_22_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_P0_22_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_P0_22_ADMODE = 0x80
	// Analog input mode.
	IOCON_P0_22_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_P0_22_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_P0_22_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_P0_22_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_P0_22_FILTR = 0x100
	// Filter disabled.
	IOCON_P0_22_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_P0_22_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_P0_22_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_P0_22_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_P0_22_RESERVED = 0x200
	// Position of OD field.
	IOCON_P0_22_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_22_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_22_OD = 0x400
	// Disable.
	IOCON_P0_22_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_P0_22_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_22_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_22_RESERVED_Msk = 0xfffff800

	// P0_23: I/O configuration register for pin P0[23]
	// Position of FUNC field.
	IOCON_P0_23_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_23_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_23_FUNC_P0_23 = 0x0
	// A/D converter 0, input 0. When configured as an ADC input, the digital function of the pin must be disabled.
	IOCON_P0_23_FUNC_ADC0_IN_0 = 0x1
	// Receive Clock. It is driven by the master and received by the slave. Corresponds to the signal SCK in the I2S-bus specification.
	IOCON_P0_23_FUNC_I2S_RX_SCK = 0x2
	// Capture input for Timer 3, channel 0.
	IOCON_P0_23_FUNC_T3_CAP0 = 0x3

	// P0_24: I/O configuration register for pin P0[24]
	// Position of FUNC field.
	IOCON_P0_24_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_24_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_24_FUNC_P0_24 = 0x0
	// A/D converter 0, input 1. When configured as an ADC input, the digital function of the pin must be disabled.
	IOCON_P0_24_FUNC_ADC0_IN_1 = 0x1
	// Receive Word Select. It is driven by the master and received by the slave. Corresponds to the signal WS in the I2S-bus specification.
	IOCON_P0_24_FUNC_I2S_RX_WS = 0x2
	// Capture input for Timer 3, channel 1.
	IOCON_P0_24_FUNC_T3_CAP1 = 0x3

	// P0_25: I/O configuration register for pin P0[25]
	// Position of FUNC field.
	IOCON_P0_25_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_25_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_25_FUNC_P0_25 = 0x0
	// A/D converter 0, input 2. When configured as an ADC input, the digital function of the pin must be disabled.
	IOCON_P0_25_FUNC_ADC0_IN_2 = 0x1
	// Receive data. It is driven by the transmitter and read by the receiver. Corresponds to the signal SD in the I2S-bus specification.
	IOCON_P0_25_FUNC_I2S_RX_SDA = 0x2
	// Transmitter output for UART3.
	IOCON_P0_25_FUNC_U3_TXD = 0x3

	// P0_26: I/O configuration register for pin P0[26]
	// Position of FUNC field.
	IOCON_P0_26_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_26_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_26_FUNC_P0_26 = 0x0
	// A/D converter 0, input 3. When configured as an ADC input, the digital function of the pin must be disabled.
	IOCON_P0_26_FUNC_ADC0_IN_3 = 0x1
	// D/A converter output. When configured as the DAC output, the digital function of the pin must be disabled.
	IOCON_P0_26_FUNC_DAC_OUT = 0x2
	// Receiver input for UART3.
	IOCON_P0_26_FUNC_U3_RXD = 0x3
	// Position of MODE field.
	IOCON_P0_26_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P0_26_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P0_26_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P0_26_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P0_26_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P0_26_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P0_26_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P0_26_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P0_26_HYS = 0x20
	// Disable.
	IOCON_P0_26_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P0_26_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P0_26_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_26_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_26_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_26_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_26_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_P0_26_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_P0_26_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_P0_26_ADMODE = 0x80
	// Analog input mode.
	IOCON_P0_26_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_P0_26_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_P0_26_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_P0_26_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_P0_26_FILTR = 0x100
	// Filter disabled.
	IOCON_P0_26_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_P0_26_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_P0_26_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_P0_26_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_P0_26_RESERVED = 0x200
	// Position of OD field.
	IOCON_P0_26_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P0_26_OD_Msk = 0x400
	// Bit OD.
	IOCON_P0_26_OD = 0x400
	// Disable.
	IOCON_P0_26_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_P0_26_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P0_26_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P0_26_RESERVED_Msk = 0xf800
	// Position of DACEN field.
	IOCON_P0_26_DACEN_Pos = 0x10
	// Bit mask of DACEN field.
	IOCON_P0_26_DACEN_Msk = 0x10000
	// Bit DACEN.
	IOCON_P0_26_DACEN = 0x10000
	// DAC disable.
	IOCON_P0_26_DACEN_DISABLE = 0x0
	// DAC enable.
	IOCON_P0_26_DACEN_ENABLE = 0x1
	// Position of RESERVED field.
	IOCON_P0_26_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	IOCON_P0_26_RESERVED_Msk = 0xfffe0000

	// P0_27: I/O configuration register for pin P0[27]
	// Position of FUNC field.
	IOCON_P0_27_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_27_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_27_FUNC_P0_27 = 0x0
	// I2C0 data input/output. (This pin uses a specialized I2C pad).
	IOCON_P0_27_FUNC_I2C0_SDA = 0x1
	// I2C serial data for communication with an external USB transceiver.
	IOCON_P0_27_FUNC_USB_SDA1 = 0x2
	// Position of RESERVED field.
	IOCON_P0_27_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_P0_27_RESERVED_Msk = 0x38
	// Position of INV field.
	IOCON_P0_27_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_27_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_27_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_27_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_27_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_27_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_27_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_P0_27_RESERVED = 0x80
	// Position of HS field.
	IOCON_P0_27_HS_Pos = 0x8
	// Bit mask of HS field.
	IOCON_P0_27_HS_Msk = 0x100
	// Bit HS.
	IOCON_P0_27_HS = 0x100
	// I2C 50ns glitch filter and slew rate control enabled.
	IOCON_P0_27_HS_ENABLED = 0x0
	// I2C 50ns glitch filter and slew rate control disabled.
	IOCON_P0_27_HS_DISABLED = 0x1
	// Position of HIDRIVE field.
	IOCON_P0_27_HIDRIVE_Pos = 0x9
	// Bit mask of HIDRIVE field.
	IOCON_P0_27_HIDRIVE_Msk = 0x200
	// Bit HIDRIVE.
	IOCON_P0_27_HIDRIVE = 0x200
	// Output drive sink is 4 mA. This is sufficient for standard and fast mode I2C.
	IOCON_P0_27_HIDRIVE_LOWDRIVE = 0x0
	// Output drive sink is 20 mA. This is needed for Fast Mode Plus I2C. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_27_HIDRIVE_HIGHDRIVE = 0x1
	// Position of RESERVED field.
	IOCON_P0_27_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_P0_27_RESERVED_Msk = 0xfffffc00

	// P0_28: I/O configuration register for pin P0[28]
	// Position of FUNC field.
	IOCON_P0_28_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_28_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_28_FUNC_P0_28 = 0x0
	// I2C0 clock input/output (this pin uses a specialized I2C pad.
	IOCON_P0_28_FUNC_I2C0_SCL = 0x1
	// I2C serial clock for communication with an external USB transceiver.
	IOCON_P0_28_FUNC_USB_SCL1 = 0x2
	// Position of RESERVED field.
	IOCON_P0_28_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_P0_28_RESERVED_Msk = 0x38
	// Position of INV field.
	IOCON_P0_28_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P0_28_INV_Msk = 0x40
	// Bit INV.
	IOCON_P0_28_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P0_28_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P0_28_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P0_28_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P0_28_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_P0_28_RESERVED = 0x80
	// Position of HS field.
	IOCON_P0_28_HS_Pos = 0x8
	// Bit mask of HS field.
	IOCON_P0_28_HS_Msk = 0x100
	// Bit HS.
	IOCON_P0_28_HS = 0x100
	// I2C 50ns glitch filter and slew rate control enabled.
	IOCON_P0_28_HS_ENABLED = 0x0
	// I2C 50ns glitch filter and slew rate control disabled.
	IOCON_P0_28_HS_DISABLED = 0x1
	// Position of HIDRIVE field.
	IOCON_P0_28_HIDRIVE_Pos = 0x9
	// Bit mask of HIDRIVE field.
	IOCON_P0_28_HIDRIVE_Msk = 0x200
	// Bit HIDRIVE.
	IOCON_P0_28_HIDRIVE = 0x200
	// Output drive sink is 4 mA. This is sufficient for standard and fast mode I2C.
	IOCON_P0_28_HIDRIVE_LOWDRIVE = 0x0
	// Output drive sink is 20 mA. This is needed for Fast Mode Plus I2C. Refer to the appropriate specific device data sheet for details.
	IOCON_P0_28_HIDRIVE_HIGHDRIVE = 0x1
	// Position of RESERVED field.
	IOCON_P0_28_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_P0_28_RESERVED_Msk = 0xfffffc00

	// P0_29: I/O configuration register for pin P0[29]
	// Position of FUNC field.
	IOCON_P0_29_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_29_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_29_FUNC_P0_29 = 0x0
	// USB port 1 bidirectional D+ line.
	IOCON_P0_29_FUNC_USB_DP1 = 0x1
	// External interrupt 0 input.
	IOCON_P0_29_FUNC_EINT0 = 0x2
	// Position of RESERVED field.
	IOCON_P0_29_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_P0_29_RESERVED_Msk = 0xfffffff8

	// P0_30: I/O configuration register for pin P0[30]
	// Position of FUNC field.
	IOCON_P0_30_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_30_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_30_FUNC_P0_30 = 0x0
	// USB port 1 bidirectional D- line.
	IOCON_P0_30_FUNC_USB_DM1 = 0x1
	// External interrupt 1 input.
	IOCON_P0_30_FUNC_EINT1 = 0x2
	// Position of RESERVED field.
	IOCON_P0_30_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_P0_30_RESERVED_Msk = 0xfffffff8

	// P0_31: I/O configuration register for pin P0[31]
	// Position of FUNC field.
	IOCON_P0_31_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P0_31_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P0_31_FUNC_P0_31 = 0x0
	// USB port 2 bidirectional D+ line.
	IOCON_P0_31_FUNC_USB_DP2 = 0x1
	// Position of RESERVED field.
	IOCON_P0_31_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_P0_31_RESERVED_Msk = 0xfffffff8

	// P1_0: I/O configuration register for pin P1[0]
	// Position of FUNC field.
	IOCON_P1_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_0_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_0_FUNC_P1_0 = 0x0
	// Ethernet transmit data 0 (RMII/MII interface).
	IOCON_P1_0_FUNC_ENET_TXD0 = 0x1
	// Capture input for Timer 3, channel 1.
	IOCON_P1_0_FUNC_T3_CAP1 = 0x3
	// Serial clock for SSP2.
	IOCON_P1_0_FUNC_SSP2_SCK = 0x4
	// Position of MODE field.
	IOCON_P1_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_0_HYS = 0x20
	// Disable.
	IOCON_P1_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_0_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_0_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_0_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_0_OD = 0x400
	// Disable.
	IOCON_P1_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_0_RESERVED_Msk = 0xfffff800

	// P1_1: I/O configuration register for pin P1[1]
	// Position of FUNC field.
	IOCON_P1_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_1_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_1_FUNC_P1_1 = 0x0
	// Ethernet transmit data 1 (RMII/MII interface).
	IOCON_P1_1_FUNC_ENET_TXD1 = 0x1
	// Match output for Timer 3, channel 3.
	IOCON_P1_1_FUNC_T3_MAT3 = 0x3
	// Master Out Slave In for SSP2.
	IOCON_P1_1_FUNC_SSP2_MOSI = 0x4
	// Position of MODE field.
	IOCON_P1_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_1_HYS = 0x20
	// Disable.
	IOCON_P1_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_1_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_1_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_1_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_1_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_1_OD = 0x400
	// Disable.
	IOCON_P1_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_1_RESERVED_Msk = 0xfffff800

	// P1_2: I/O configuration register for pin P1[2]
	// Position of FUNC field.
	IOCON_P1_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_2_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_2_FUNC_P1_2 = 0x0
	// Ethernet transmit data 2 (MII interface).
	IOCON_P1_2_FUNC_ENET_TXD2 = 0x1
	// Clock output line for SD card interface.
	IOCON_P1_2_FUNC_SD_CLK = 0x2
	// Pulse Width Modulator 0, output 1.
	IOCON_P1_2_FUNC_PWM0_1 = 0x3
	// Position of MODE field.
	IOCON_P1_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_2_HYS = 0x20
	// Disable.
	IOCON_P1_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_2_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_2_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_2_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_2_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_2_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_2_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_2_OD = 0x400
	// Disable.
	IOCON_P1_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_2_RESERVED_Msk = 0xfffff800

	// P1_3: I/O configuration register for pin P1[3]
	// Position of FUNC field.
	IOCON_P1_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_3_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_3_FUNC_P1_3 = 0x0
	// Ethernet transmit data 3 (MII interface).
	IOCON_P1_3_FUNC_ENET_TXD3 = 0x1
	// Command line for SD card interface.
	IOCON_P1_3_FUNC_SD_CMD = 0x2
	// Pulse Width Modulator 0, output 2.
	IOCON_P1_3_FUNC_PWM0_2 = 0x3
	// Position of MODE field.
	IOCON_P1_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_3_HYS = 0x20
	// Disable.
	IOCON_P1_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_3_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_3_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_3_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_3_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_3_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_3_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_3_OD = 0x400
	// Disable.
	IOCON_P1_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_3_RESERVED_Msk = 0xfffff800

	// P1_4: I/O configuration register for pin P1[4]
	// Position of FUNC field.
	IOCON_P1_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_4_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_4_FUNC_P1_4 = 0x0
	// Ethernet transmit data enable (RMII/MII interface).
	IOCON_P1_4_FUNC_ENET_TX_EN = 0x1
	// Match output for Timer 3, channel 2.
	IOCON_P1_4_FUNC_T3_MAT2 = 0x3
	// Master In Slave Out for SSP2.
	IOCON_P1_4_FUNC_SSP2_MISO = 0x4
	// Position of MODE field.
	IOCON_P1_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_4_HYS = 0x20
	// Disable.
	IOCON_P1_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_4_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_4_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_4_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_4_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_4_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_4_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_4_OD = 0x400
	// Disable.
	IOCON_P1_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_4_RESERVED_Msk = 0xfffff800

	// P1_5: I/O configuration register for pin P1[5]
	// Position of FUNC field.
	IOCON_P1_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_5_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_5_FUNC_P1_5 = 0x0
	// Ethernet Transmit Error (MII interface).
	IOCON_P1_5_FUNC_ENET_TX_ER = 0x1
	// Power Supply Enable for external SD card power supply.
	IOCON_P1_5_FUNC_SD_PWR = 0x2
	// Pulse Width Modulator 0, output 3.
	IOCON_P1_5_FUNC_PWM0_3 = 0x3
	// Position of MODE field.
	IOCON_P1_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_5_HYS = 0x20
	// Disable.
	IOCON_P1_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_5_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_5_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_5_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_5_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_5_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_5_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_5_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_5_OD = 0x400
	// Disable.
	IOCON_P1_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_5_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_5_RESERVED_Msk = 0xfffff800

	// P1_6: I/O configuration register for pin P1[6]
	// Position of FUNC field.
	IOCON_P1_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_6_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_6_FUNC_P1_6 = 0x0
	// Ethernet Transmit Clock (MII interface).
	IOCON_P1_6_FUNC_ENET_TX_CLK = 0x1
	// Data line 0 for SD card interface.
	IOCON_P1_6_FUNC_SD_DAT_0 = 0x2
	// Pulse Width Modulator 0, output 4.
	IOCON_P1_6_FUNC_PWM0_4 = 0x3
	// Position of MODE field.
	IOCON_P1_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_6_HYS = 0x20
	// Disable.
	IOCON_P1_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_6_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_6_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_6_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_6_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_6_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_6_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_6_OD = 0x400
	// Disable.
	IOCON_P1_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_6_RESERVED_Msk = 0xfffff800

	// P1_7: I/O configuration register for pin P1[7]
	// Position of FUNC field.
	IOCON_P1_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_7_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_7_FUNC_P1_7 = 0x0
	// Ethernet Collision detect (MII interface).
	IOCON_P1_7_FUNC_ENET_COL = 0x1
	// Data line 1 for SD card interface.
	IOCON_P1_7_FUNC_SD_DAT_1 = 0x2
	// Pulse Width Modulator 0, output 5.
	IOCON_P1_7_FUNC_PWM0_5 = 0x3
	// Position of MODE field.
	IOCON_P1_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_7_HYS = 0x20
	// Disable.
	IOCON_P1_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_7_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_7_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_7_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_7_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_7_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_7_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_7_OD = 0x400
	// Disable.
	IOCON_P1_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_7_RESERVED_Msk = 0xfffff800

	// P1_8: I/O configuration register for pin P1[8]
	// Position of FUNC field.
	IOCON_P1_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_8_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_8_FUNC_P1_8 = 0x0
	// Ethernet Carrier Sense (MII interface) or Ethernet Carrier Sense/Data Valid (RMII interface).
	IOCON_P1_8_FUNC_ENET_CRS_CRS_DV = 0x1
	// Match output for Timer 3, channel 1.
	IOCON_P1_8_FUNC_T3_MAT1 = 0x3
	// Slave Select for SSP2.
	IOCON_P1_8_FUNC_SSP2_SSEL = 0x4
	// Position of MODE field.
	IOCON_P1_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_8_HYS = 0x20
	// Disable.
	IOCON_P1_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_8_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_8_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_8_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_8_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_8_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_8_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_8_OD = 0x400
	// Disable.
	IOCON_P1_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_8_RESERVED_Msk = 0xfffff800

	// P1_9: I/O configuration register for pin P1[9]
	// Position of FUNC field.
	IOCON_P1_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_9_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_9_FUNC_P1_9 = 0x0
	// Ethernet receive data 0 (RMII/MII interface).
	IOCON_P1_9_FUNC_ENET_RXD0 = 0x1
	// Match output for Timer 3, channel 0.
	IOCON_P1_9_FUNC_T3_MAT0 = 0x3
	// Position of MODE field.
	IOCON_P1_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_9_HYS = 0x20
	// Disable.
	IOCON_P1_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_9_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_9_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_9_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_9_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_9_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_9_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_9_OD = 0x400
	// Disable.
	IOCON_P1_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_9_RESERVED_Msk = 0xfffff800

	// P1_10: I/O configuration register for pin P1[10]
	// Position of FUNC field.
	IOCON_P1_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_10_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_10_FUNC_P1_10 = 0x0
	// Ethernet receive data 1 (RMII/MII interface).
	IOCON_P1_10_FUNC_ENET_RXD1 = 0x1
	// Capture input for Timer 3, channel 0.
	IOCON_P1_10_FUNC_T3_CAP0 = 0x3
	// Position of MODE field.
	IOCON_P1_10_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_10_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_10_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_10_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_10_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_10_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_10_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_10_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_10_HYS = 0x20
	// Disable.
	IOCON_P1_10_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_10_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_10_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_10_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_10_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_10_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_10_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_10_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_10_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_10_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_10_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_10_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_10_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_10_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_10_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_10_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_10_OD = 0x400
	// Disable.
	IOCON_P1_10_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_10_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_10_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_10_RESERVED_Msk = 0xfffff800

	// P1_11: I/O configuration register for pin P1[11]
	// Position of FUNC field.
	IOCON_P1_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_11_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_11_FUNC_P1_11 = 0x0
	// Ethernet Receive Data 2 (MII interface).
	IOCON_P1_11_FUNC_ENET_RXD2 = 0x1
	// Data line 2 for SD card interface.
	IOCON_P1_11_FUNC_SD_DAT_2 = 0x2
	// Pulse Width Modulator 0, output 6.
	IOCON_P1_11_FUNC_PWM0_6 = 0x3
	// Position of MODE field.
	IOCON_P1_11_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_11_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_11_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_11_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_11_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_11_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_11_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_11_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_11_HYS = 0x20
	// Disable.
	IOCON_P1_11_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_11_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_11_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_11_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_11_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_11_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_11_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_11_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_11_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_11_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_11_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_11_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_11_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_11_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_11_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_11_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_11_OD = 0x400
	// Disable.
	IOCON_P1_11_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_11_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_11_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_11_RESERVED_Msk = 0xfffff800

	// P1_12: I/O configuration register for pin P1[12]
	// Position of FUNC field.
	IOCON_P1_12_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_12_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_12_FUNC_P1_12 = 0x0
	// Ethernet Receive Data (MII interface).
	IOCON_P1_12_FUNC_ENET_RXD3 = 0x1
	// Data line 3 for SD card interface.
	IOCON_P1_12_FUNC_SD_DAT_3 = 0x2
	// Capture input for PWM0, channel 0.
	IOCON_P1_12_FUNC_PWM0_CAP0 = 0x3
	// Position of MODE field.
	IOCON_P1_12_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_12_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_12_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_12_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_12_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_12_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_12_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_12_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_12_HYS = 0x20
	// Disable.
	IOCON_P1_12_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_12_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_12_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_12_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_12_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_12_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_12_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_12_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_12_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_12_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_12_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_12_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_12_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_12_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_12_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_12_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_12_OD = 0x400
	// Disable.
	IOCON_P1_12_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_12_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_12_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_12_RESERVED_Msk = 0xfffff800

	// P1_13: I/O configuration register for pin P1[13]
	// Position of FUNC field.
	IOCON_P1_13_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_13_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_13_FUNC_P1_13 = 0x0
	// Ethernet Receive Data Valid (MII interface).
	IOCON_P1_13_FUNC_ENET_RX_DV = 0x1
	// Position of MODE field.
	IOCON_P1_13_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_13_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_13_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_13_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_13_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_13_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_13_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_13_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_13_HYS = 0x20
	// Disable.
	IOCON_P1_13_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_13_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_13_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_13_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_13_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_13_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_13_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_13_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_13_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_13_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_13_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_13_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_13_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_13_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_13_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_13_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_13_OD = 0x400
	// Disable.
	IOCON_P1_13_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_13_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_13_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_13_RESERVED_Msk = 0xfffff800

	// P1_14: I/O configuration register for pin P1[14]
	// Position of FUNC field.
	IOCON_P1_14_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_14_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_14_FUNC_P1_14 = 0x0
	// Ethernet receive error (RMII/MII interface).
	IOCON_P1_14_FUNC_ENET_RX_ER = 0x1
	// Capture input for Timer 2, channel 0.
	IOCON_P1_14_FUNC_T2_CAP0 = 0x3
	// Position of MODE field.
	IOCON_P1_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_14_HYS = 0x20
	// Disable.
	IOCON_P1_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_14_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_14_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_14_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_14_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_14_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_14_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_14_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_14_OD = 0x400
	// Disable.
	IOCON_P1_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_14_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_14_RESERVED_Msk = 0xfffff800

	// P1_15: I/O configuration register for pin P1[15]
	// Position of FUNC field.
	IOCON_P1_15_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_15_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_15_FUNC_P1_15 = 0x0
	// Ethernet Receive Clock (MII interface) or Ethernet Reference Clock (RMII interface).
	IOCON_P1_15_FUNC_ENET_RX_CLK_REF_CLK = 0x1
	// I2C2 data input/output (this pin does not use a specialized I2C pad).
	IOCON_P1_15_FUNC_I2C2_SDA = 0x3
	// Position of MODE field.
	IOCON_P1_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_15_HYS = 0x20
	// Disable.
	IOCON_P1_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_15_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_15_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_15_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_15_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_15_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_15_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_15_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_15_OD = 0x400
	// Disable.
	IOCON_P1_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_15_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_15_RESERVED_Msk = 0xfffff800

	// P1_16: I/O configuration register for pin P1[16]
	// Position of FUNC field.
	IOCON_P1_16_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_16_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_16_FUNC_P1_16 = 0x0
	// Ethernet MIIM clock.
	IOCON_P1_16_FUNC_ENET_MDC = 0x1
	// I2S transmit master clock.
	IOCON_P1_16_FUNC_I2S_TX_MCLK = 0x2
	// Position of MODE field.
	IOCON_P1_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_16_HYS = 0x20
	// Disable.
	IOCON_P1_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_16_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_16_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_16_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_16_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_16_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_16_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_16_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_16_OD = 0x400
	// Disable.
	IOCON_P1_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_16_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_16_RESERVED_Msk = 0xfffff800

	// P1_17: I/O configuration register for pin P1[17]
	// Position of FUNC field.
	IOCON_P1_17_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_17_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_17_FUNC_P1_17 = 0x0
	// Ethernet MIIM data input and output.
	IOCON_P1_17_FUNC_ENET_MDIO = 0x1
	// I2S receive master clock.
	IOCON_P1_17_FUNC_I2S_RX_MCLK = 0x2
	// Position of MODE field.
	IOCON_P1_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_17_HYS = 0x20
	// Disable.
	IOCON_P1_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_17_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_17_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_17_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_17_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_17_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_17_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_17_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_17_OD = 0x400
	// Disable.
	IOCON_P1_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_17_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_17_RESERVED_Msk = 0xfffff800

	// P1_18: I/O configuration register for pin P1[18]
	// Position of FUNC field.
	IOCON_P1_18_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_18_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_18_FUNC_P1_18 = 0x0
	// It is LOW when the device is configured (non-control endpoints enabled), or when the host is enabled and has detected a device on the bus. It is HIGH when the device is not configured, or when host is enabled and has not detected a device on the bus, or during global suspend. It transitions between LOW and HIGH (flashes) when the host is enabled and detects activity on the bus.
	IOCON_P1_18_FUNC_USB_UP_LED1 = 0x1
	// Pulse Width Modulator 1, channel 1 output.
	IOCON_P1_18_FUNC_PWM1_1 = 0x2
	// Capture input for Timer 1, channel 0.
	IOCON_P1_18_FUNC_T1_CAP0 = 0x3
	// Master In Slave Out for SSP1.
	IOCON_P1_18_FUNC_SSP1_MISO = 0x5
	// Position of MODE field.
	IOCON_P1_18_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_18_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_18_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_18_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_18_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_18_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_18_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_18_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_18_HYS = 0x20
	// Disable.
	IOCON_P1_18_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_18_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_18_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_18_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_18_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_18_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_18_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_18_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_18_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_18_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_18_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_18_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_18_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_18_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_18_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_18_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_18_OD = 0x400
	// Disable.
	IOCON_P1_18_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_18_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_18_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_18_RESERVED_Msk = 0xfffff800

	// P1_19: I/O configuration register for pin P1[19]
	// Position of FUNC field.
	IOCON_P1_19_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_19_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_19_FUNC_P1_19 = 0x0
	// Transmit Enable signal for USB port 1 (OTG transceiver).
	IOCON_P1_19_FUNC_USB_TX_E1 = 0x1
	// Port Power enable signal for USB port 1.
	IOCON_P1_19_FUNC_USB_PPWR1 = 0x2
	// Capture input for Timer 1, channel 1.
	IOCON_P1_19_FUNC_T1_CAP1 = 0x3
	// Motor control PWM channel 0, output A.
	IOCON_P1_19_FUNC_MC_0A = 0x4
	// Serial clock for SSP1.
	IOCON_P1_19_FUNC_SSP1_SCK = 0x5
	// RS-485/EIA-485 output enable signal for UART2.
	IOCON_P1_19_FUNC_U2_OE = 0x6
	// Position of MODE field.
	IOCON_P1_19_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_19_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_19_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_19_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_19_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_19_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_19_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_19_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_19_HYS = 0x20
	// Disable.
	IOCON_P1_19_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_19_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_19_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_19_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_19_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_19_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_19_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_19_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_19_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_19_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_19_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_19_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_19_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_19_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_19_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_19_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_19_OD = 0x400
	// Disable.
	IOCON_P1_19_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_19_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_19_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_19_RESERVED_Msk = 0xfffff800

	// P1_20: I/O configuration register for pin P1[20]
	// Position of FUNC field.
	IOCON_P1_20_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_20_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_20_FUNC_P1_20 = 0x0
	// D+ transmit data for USB port 1 (OTG transceiver).
	IOCON_P1_20_FUNC_USB_TX_DP1 = 0x1
	// Pulse Width Modulator 1, channel 2 output.
	IOCON_P1_20_FUNC_PWM1_2 = 0x2
	// Quadrature Encoder Interface PHA input.
	IOCON_P1_20_FUNC_QEI_PHA = 0x3
	// Motor control PWM channel 0 feedback input.
	IOCON_P1_20_FUNC_MC_FB0 = 0x4
	// Serial clock for SSP0.
	IOCON_P1_20_FUNC_SSP0_SCK = 0x5
	// LCD data.
	IOCON_P1_20_FUNC_LCD_VD_6 = 0x6
	// LCD data.
	IOCON_P1_20_FUNC_LCD_VD_10 = 0x7
	// Position of MODE field.
	IOCON_P1_20_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_20_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_20_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_20_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_20_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_20_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_20_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_20_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_20_HYS = 0x20
	// Disable.
	IOCON_P1_20_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_20_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_20_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_20_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_20_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_20_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_20_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_20_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_20_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_20_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_20_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_20_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_20_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_20_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_20_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_20_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_20_OD = 0x400
	// Disable.
	IOCON_P1_20_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_20_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_20_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_20_RESERVED_Msk = 0xfffff800

	// P1_21: I/O configuration register for pin P1[21]
	// Position of FUNC field.
	IOCON_P1_21_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_21_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_21_FUNC_P1_21 = 0x0
	// D- transmit data for USB port 1 (OTG transceiver).
	IOCON_P1_21_FUNC_USB_TX_DM1 = 0x1
	// Pulse Width Modulator 1, channel 3 output.
	IOCON_P1_21_FUNC_PWM1_3 = 0x2
	// Slave Select for SSP0.
	IOCON_P1_21_FUNC_SSP0_SSEL = 0x3
	// Motor control PWM, active low fast abort.
	IOCON_P1_21_FUNC_MC_ABORT = 0x4
	// LCD data.
	IOCON_P1_21_FUNC_LCD_VD_7 = 0x6
	// LCD data.
	IOCON_P1_21_FUNC_LCD_VD_11 = 0x7
	// Position of MODE field.
	IOCON_P1_21_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_21_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_21_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_21_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_21_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_21_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_21_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_21_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_21_HYS = 0x20
	// Disable.
	IOCON_P1_21_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_21_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_21_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_21_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_21_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_21_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_21_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_21_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_21_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_21_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_21_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_21_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_21_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_21_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_21_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_21_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_21_OD = 0x400
	// Disable.
	IOCON_P1_21_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_21_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_21_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_21_RESERVED_Msk = 0xfffff800

	// P1_22: I/O configuration register for pin P1[22]
	// Position of FUNC field.
	IOCON_P1_22_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_22_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_22_FUNC_P1_22 = 0x0
	// Differential receive data for USB port 1 (OTG transceiver).
	IOCON_P1_22_FUNC_USB_RCV1 = 0x1
	// Power Status for USB port 1 (host power switch).
	IOCON_P1_22_FUNC_USB_PWRD1 = 0x2
	// Match output for Timer 1, channel 0.
	IOCON_P1_22_FUNC_T1_MAT0 = 0x3
	// Motor control PWM channel 0, output B.
	IOCON_P1_22_FUNC_MC_0B = 0x4
	// Master Out Slave In for SSP1.
	IOCON_P1_22_FUNC_SSP1_MOSI = 0x5
	// LCD data.
	IOCON_P1_22_FUNC_LCD_VD_8 = 0x6
	// LCD data.
	IOCON_P1_22_FUNC_LCD_VD_12 = 0x7
	// Position of MODE field.
	IOCON_P1_22_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_22_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_22_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_22_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_22_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_22_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_22_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_22_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_22_HYS = 0x20
	// Disable.
	IOCON_P1_22_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_22_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_22_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_22_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_22_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_22_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_22_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_22_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_22_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_22_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_22_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_22_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_22_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_22_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_22_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_22_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_22_OD = 0x400
	// Disable.
	IOCON_P1_22_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_22_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_22_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_22_RESERVED_Msk = 0xfffff800

	// P1_23: I/O configuration register for pin P1[23]
	// Position of FUNC field.
	IOCON_P1_23_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_23_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_23_FUNC_P1_23 = 0x0
	// D+ receive data for USB port 1 (OTG transceiver).
	IOCON_P1_23_FUNC_USB_RX_DP1 = 0x1
	// Pulse Width Modulator 1, channel 4 output.
	IOCON_P1_23_FUNC_PWM1_4 = 0x2
	// Quadrature Encoder Interface PHB input.
	IOCON_P1_23_FUNC_QEI_PHB = 0x3
	// Motor control PWM channel 1 feedback input.
	IOCON_P1_23_FUNC_MC_FB1 = 0x4
	// Master In Slave Out for SSP0.
	IOCON_P1_23_FUNC_SSP0_MISO = 0x5
	// LCD data.
	IOCON_P1_23_FUNC_LCD_VD_9 = 0x6
	// LCD data.
	IOCON_P1_23_FUNC_LCD_VD_13 = 0x7
	// Position of MODE field.
	IOCON_P1_23_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_23_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_23_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_23_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_23_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_23_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_23_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_23_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_23_HYS = 0x20
	// Disable.
	IOCON_P1_23_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_23_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_23_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_23_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_23_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_23_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_23_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_23_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_23_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_23_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_23_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_23_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_23_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_23_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_23_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_23_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_23_OD = 0x400
	// Disable.
	IOCON_P1_23_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_23_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_23_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_23_RESERVED_Msk = 0xfffff800

	// P1_24: I/O configuration register for pin P1[24]
	// Position of FUNC field.
	IOCON_P1_24_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_24_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_24_FUNC_P1_24 = 0x0
	// D- receive data for USB port 1 (OTG transceiver).
	IOCON_P1_24_FUNC_USB_RX_DM1 = 0x1
	// Pulse Width Modulator 1, channel 5 output.
	IOCON_P1_24_FUNC_PWM1_5 = 0x2
	// Quadrature Encoder Interface INDEX input.
	IOCON_P1_24_FUNC_QEI_IDX = 0x3
	// Motor control PWM channel 2 feedback input.
	IOCON_P1_24_FUNC_MC_FB2 = 0x4
	// Master Out Slave in for SSP0.
	IOCON_P1_24_FUNC_SSP0_MOSI = 0x5
	// LCD data.
	IOCON_P1_24_FUNC_LCD_VD_10 = 0x6
	// LCD data.
	IOCON_P1_24_FUNC_LCD_VD_14 = 0x7
	// Position of MODE field.
	IOCON_P1_24_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_24_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_24_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_24_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_24_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_24_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_24_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_24_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_24_HYS = 0x20
	// Disable.
	IOCON_P1_24_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_24_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_24_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_24_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_24_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_24_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_24_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_24_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_24_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_24_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_24_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_24_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_24_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_24_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_24_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_24_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_24_OD = 0x400
	// Disable.
	IOCON_P1_24_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_24_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_24_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_24_RESERVED_Msk = 0xfffff800

	// P1_25: I/O configuration register for pin P1[25]
	// Position of FUNC field.
	IOCON_P1_25_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_25_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_25_FUNC_P1_25 = 0x0
	// Low Speed status for USB port 1 (OTG transceiver).
	IOCON_P1_25_FUNC_USB_LS1 = 0x1
	// Host Enabled status for USB port 1.
	IOCON_P1_25_FUNC_USB_HSTEN1 = 0x2
	// Match output for Timer 1, channel 1.
	IOCON_P1_25_FUNC_T1_MAT1 = 0x3
	// Motor control PWM channel 1, output A.
	IOCON_P1_25_FUNC_MC_1A = 0x4
	// Selectable clock output.
	IOCON_P1_25_FUNC_CLKOUT = 0x5
	// LCD data.
	IOCON_P1_25_FUNC_LCD_VD_11 = 0x6
	// LCD data.
	IOCON_P1_25_FUNC_LCD_VD_15 = 0x7
	// Position of MODE field.
	IOCON_P1_25_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_25_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_25_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_25_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_25_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_25_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_25_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_25_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_25_HYS = 0x20
	// Disable.
	IOCON_P1_25_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_25_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_25_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_25_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_25_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_25_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_25_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_25_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_25_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_25_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_25_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_25_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_25_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_25_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_25_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_25_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_25_OD = 0x400
	// Disable.
	IOCON_P1_25_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_25_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_25_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_25_RESERVED_Msk = 0xfffff800

	// P1_26: I/O configuration register for pin P1[26]
	// Position of FUNC field.
	IOCON_P1_26_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_26_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_26_FUNC_P1_26 = 0x0
	// USB port 1 Bus Suspend status (OTG transceiver).
	IOCON_P1_26_FUNC_USB_SSPND1 = 0x1
	// Pulse Width Modulator 1, channel 6 output.
	IOCON_P1_26_FUNC_PWM1_6 = 0x2
	// Capture input for Timer 0, channel 0.
	IOCON_P1_26_FUNC_T0_CAP0 = 0x3
	// Motor control PWM channel 1, output B.
	IOCON_P1_26_FUNC_MC_1B = 0x4
	// Slave Select for SSP1.
	IOCON_P1_26_FUNC_SSP1_SSEL = 0x5
	// LCD data.
	IOCON_P1_26_FUNC_LCD_VD_12 = 0x6
	// LCD data.
	IOCON_P1_26_FUNC_LCD_VD_20 = 0x7
	// Position of MODE field.
	IOCON_P1_26_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_26_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_26_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_26_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_26_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_26_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_26_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_26_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_26_HYS = 0x20
	// Disable.
	IOCON_P1_26_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_26_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_26_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_26_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_26_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_26_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_26_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_26_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_26_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_26_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_26_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_26_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_26_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_26_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_26_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_26_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_26_OD = 0x400
	// Disable.
	IOCON_P1_26_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_26_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_26_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_26_RESERVED_Msk = 0xfffff800

	// P1_27: I/O configuration register for pin P1[27]
	// Position of FUNC field.
	IOCON_P1_27_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_27_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_27_FUNC_P1_27 = 0x0
	// USB port 1 OTG transceiver interrupt (OTG transceiver).
	IOCON_P1_27_FUNC_USB_INT1 = 0x1
	// USB port 1 Over-Current status.
	IOCON_P1_27_FUNC_USB_OVRCR1 = 0x2
	// Capture input for Timer 0, channel 1.
	IOCON_P1_27_FUNC_T0_CAP1 = 0x3
	// Selectable clock output.
	IOCON_P1_27_FUNC_CLKOUT = 0x4
	// LCD data.
	IOCON_P1_27_FUNC_LCD_VD_13 = 0x6
	// LCD data.
	IOCON_P1_27_FUNC_LCD_VD_21 = 0x7
	// Position of MODE field.
	IOCON_P1_27_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_27_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_27_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_27_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_27_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_27_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_27_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_27_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_27_HYS = 0x20
	// Disable.
	IOCON_P1_27_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_27_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_27_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_27_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_27_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_27_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_27_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_27_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_27_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_27_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_27_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_27_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_27_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_27_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_27_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_27_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_27_OD = 0x400
	// Disable.
	IOCON_P1_27_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_27_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_27_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_27_RESERVED_Msk = 0xfffff800

	// P1_28: I/O configuration register for pin P1[28]
	// Position of FUNC field.
	IOCON_P1_28_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_28_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_28_FUNC_P1_28 = 0x0
	// USB port 1 I2C serial clock (OTG transceiver).
	IOCON_P1_28_FUNC_USB_SCL1 = 0x1
	// Capture input for PWM1, channel 0.
	IOCON_P1_28_FUNC_PWM1_CAP0 = 0x2
	// Match output for Timer 0, channel 0.
	IOCON_P1_28_FUNC_T0_MAT0 = 0x3
	// Motor control PWM channel 2, output A.
	IOCON_P1_28_FUNC_MC_2A = 0x4
	// Slave Select for SSP0.
	IOCON_P1_28_FUNC_SSP0_SSEL = 0x5
	// LCD data.
	IOCON_P1_28_FUNC_LCD_VD_14 = 0x6
	// LCD data.
	IOCON_P1_28_FUNC_LCD_VD_22 = 0x7
	// Position of MODE field.
	IOCON_P1_28_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_28_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_28_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_28_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_28_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_28_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_28_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_28_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_28_HYS = 0x20
	// Disable.
	IOCON_P1_28_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_28_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_28_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_28_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_28_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_28_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_28_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_28_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_28_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_28_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_28_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_28_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_28_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_28_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_28_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_28_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_28_OD = 0x400
	// Disable.
	IOCON_P1_28_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_28_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_28_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_28_RESERVED_Msk = 0xfffff800

	// P1_29: I/O configuration register for pin P1[29]
	// Position of FUNC field.
	IOCON_P1_29_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_29_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_29_FUNC_P1_29 = 0x0
	// USB port 1 I2C serial data (OTG transceiver).
	IOCON_P1_29_FUNC_USB_SDA1 = 0x1
	// Capture input for PWM1, channel 1.
	IOCON_P1_29_FUNC_PWM1_CAP1 = 0x2
	// Match output for Timer 0, channel 1.
	IOCON_P1_29_FUNC_T0_MAT1 = 0x3
	// Motor control PWM channel 2, output B.
	IOCON_P1_29_FUNC_MC_2B = 0x4
	// Transmitter output for USART4 (input/output in smart card mode).
	IOCON_P1_29_FUNC_U4_TXD = 0x5
	// LCD data.
	IOCON_P1_29_FUNC_LCD_VD_15 = 0x6
	// LCD data.
	IOCON_P1_29_FUNC_LCD_VD_23 = 0x7
	// Position of MODE field.
	IOCON_P1_29_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P1_29_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P1_29_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P1_29_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P1_29_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P1_29_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P1_29_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P1_29_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P1_29_HYS = 0x20
	// Disable.
	IOCON_P1_29_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P1_29_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P1_29_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P1_29_INV_Msk = 0x40
	// Bit INV.
	IOCON_P1_29_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P1_29_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P1_29_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P1_29_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P1_29_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P1_29_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P1_29_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P1_29_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P1_29_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P1_29_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P1_29_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P1_29_OD_Msk = 0x400
	// Bit OD.
	IOCON_P1_29_OD = 0x400
	// Disable.
	IOCON_P1_29_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P1_29_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P1_29_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P1_29_RESERVED_Msk = 0xfffff800

	// P1_30: I/O configuration register for pin P1[30]
	// Position of FUNC field.
	IOCON_P1_30_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_30_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_30_FUNC_P1_30 = 0x0
	// Power Status for USB port 2.
	IOCON_P1_30_FUNC_USB_PWRD2 = 0x1
	// Monitors the presence of USB bus power.This signal must be HIGH for USB reset to occur.
	IOCON_P1_30_FUNC_USB_VBUS = 0x2
	// A/D converter 0, input 4. When configured as an ADC input, the digital function of the pin must be disabled.
	IOCON_P1_30_FUNC_ADC0_IN_4 = 0x3
	// I2C0 data input/output (this pin does not use a specialized I2C pad.
	IOCON_P1_30_FUNC_I2C0_SDA = 0x4
	// RS-485/EIA-485 output enable signal for UART3.
	IOCON_P1_30_FUNC_U3_OE = 0x5

	// P1_31: I/O configuration register for pin P1[31]
	// Position of FUNC field.
	IOCON_P1_31_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P1_31_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P1_31_FUNC_P1_31 = 0x0
	// Over-Current status for USB port 2.
	IOCON_P1_31_FUNC_USB_OVRCR2 = 0x1
	// Serial Clock for SSP1.
	IOCON_P1_31_FUNC_SSP1_SCK = 0x2
	// A/D converter 0, input 5. When configured as an ADC input, the digital function of the pin must be disabled.
	IOCON_P1_31_FUNC_ADC0_IN_5 = 0x3
	// I2C0 clock input/output (this pin does not use a specialized I2C pad.
	IOCON_P1_31_FUNC_I2C0_SCL = 0x4

	// P2_0: I/O configuration register for pin P2[0]
	// Position of FUNC field.
	IOCON_P2_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_0_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_0_FUNC_P2_0 = 0x0
	// Pulse Width Modulator 1, channel 1 output.
	IOCON_P2_0_FUNC_PWM1_1 = 0x1
	// Transmitter output for UART1.
	IOCON_P2_0_FUNC_U1_TXD = 0x2
	// LCD panel power enable.
	IOCON_P2_0_FUNC_LCD_PWR = 0x7
	// Position of MODE field.
	IOCON_P2_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_0_HYS = 0x20
	// Disable.
	IOCON_P2_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_0_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_0_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_0_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_0_OD = 0x400
	// Disable.
	IOCON_P2_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_0_RESERVED_Msk = 0xfffff800

	// P2_1: I/O configuration register for pin P2[1]
	// Position of FUNC field.
	IOCON_P2_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_1_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_1_FUNC_P2_1 = 0x0
	// Pulse Width Modulator 1, channel 2 output.
	IOCON_P2_1_FUNC_PWM1_2 = 0x1
	// Receiver input for UART1.
	IOCON_P2_1_FUNC_U1_RXD = 0x2
	// Line end signal.
	IOCON_P2_1_FUNC_LCD_LE = 0x7
	// Position of MODE field.
	IOCON_P2_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_1_HYS = 0x20
	// Disable.
	IOCON_P2_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_1_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_1_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_1_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_1_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_1_OD = 0x400
	// Disable.
	IOCON_P2_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_1_RESERVED_Msk = 0xfffff800

	// P2_2: I/O configuration register for pin P2[2]
	// Position of FUNC field.
	IOCON_P2_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_2_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_2_FUNC_P2_2 = 0x0
	// Pulse Width Modulator 1, channel 3 output.
	IOCON_P2_2_FUNC_PWM1_3 = 0x1
	// Clear to Send input for UART1.
	IOCON_P2_2_FUNC_U1_CTS = 0x2
	// Match output for Timer 2, channel 3.
	IOCON_P2_2_FUNC_T2_MAT3 = 0x3
	// Trace data, bit 3.
	IOCON_P2_2_FUNC_TRACEDATA_3 = 0x5
	// LCD panel clock.
	IOCON_P2_2_FUNC_LCD_DCLK = 0x7
	// Position of MODE field.
	IOCON_P2_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_2_HYS = 0x20
	// Disable.
	IOCON_P2_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_2_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_2_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_2_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_2_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_2_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_2_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_2_OD = 0x400
	// Disable.
	IOCON_P2_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_2_RESERVED_Msk = 0xfffff800

	// P2_3: I/O configuration register for pin P2[3]
	// Position of FUNC field.
	IOCON_P2_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_3_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_3_FUNC_P2_3 = 0x0
	// Pulse Width Modulator 1, channel 4 output.
	IOCON_P2_3_FUNC_PWM1_4 = 0x1
	// Data Carrier Detect input for UART1.
	IOCON_P2_3_FUNC_U1_DCD = 0x2
	// Match output for Timer 2, channel 2.
	IOCON_P2_3_FUNC_T2_MAT2 = 0x3
	// Trace data, bit 2.
	IOCON_P2_3_FUNC_TRACEDATA_2 = 0x5
	// Frame pulse (STN). Vertical synchronization pulse (TFT).
	IOCON_P2_3_FUNC_LCD_FP = 0x7
	// Position of MODE field.
	IOCON_P2_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_3_HYS = 0x20
	// Disable.
	IOCON_P2_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_3_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_3_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_3_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_3_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_3_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_3_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_3_OD = 0x400
	// Disable.
	IOCON_P2_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_3_RESERVED_Msk = 0xfffff800

	// P2_4: I/O configuration register for pin P2[4]
	// Position of FUNC field.
	IOCON_P2_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_4_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_4_FUNC_P2_4 = 0x0
	// Pulse Width Modulator 1, channel 5 output.
	IOCON_P2_4_FUNC_PWM1_5 = 0x1
	// Data Set Ready input for UART1.
	IOCON_P2_4_FUNC_U1_DSR = 0x2
	// Match output for Timer 2, channel 1.
	IOCON_P2_4_FUNC_T2_MAT1 = 0x3
	// Trace data, bit 1.
	IOCON_P2_4_FUNC_TRACEDATA_1 = 0x5
	// STN AC bias drive or TFT data enable output.
	IOCON_P2_4_FUNC_LCD_ENAB_M = 0x7
	// Position of MODE field.
	IOCON_P2_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_4_HYS = 0x20
	// Disable.
	IOCON_P2_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_4_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_4_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_4_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_4_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_4_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_4_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_4_OD = 0x400
	// Disable.
	IOCON_P2_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_4_RESERVED_Msk = 0xfffff800

	// P2_5: I/O configuration register for pin P2[5]
	// Position of FUNC field.
	IOCON_P2_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_5_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_5_FUNC_P2_5 = 0x0
	// Pulse Width Modulator 1, channel 6 output.
	IOCON_P2_5_FUNC_PWM1_6 = 0x1
	// Data Terminal Ready output for UART1. Can also be configured to be an RS-485/EIA-485 output enable signal for UART1.
	IOCON_P2_5_FUNC_U1_DTR = 0x2
	// Match output for Timer 2, channel 0.
	IOCON_P2_5_FUNC_T2_MAT0 = 0x3
	// Trace data, bit 0.
	IOCON_P2_5_FUNC_TRACEDATA_0 = 0x5
	// Line synchronization pulse (STN). Horizontal synchronization pulse (TFT).
	IOCON_P2_5_FUNC_LCD_LP = 0x7
	// Position of MODE field.
	IOCON_P2_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_5_HYS = 0x20
	// Disable.
	IOCON_P2_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_5_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_5_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_5_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_5_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_5_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_5_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_5_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_5_OD = 0x400
	// Disable.
	IOCON_P2_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_5_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_5_RESERVED_Msk = 0xfffff800

	// P2_6: I/O configuration register for pin P2[6]
	// Position of FUNC field.
	IOCON_P2_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_6_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_6_FUNC_P2_6 = 0x0
	// Capture input for PWM1, channel 0.
	IOCON_P2_6_FUNC_PWM1_CAP0 = 0x1
	// Ring Indicator input for UART1.
	IOCON_P2_6_FUNC_U1_RI = 0x2
	// Capture input for Timer 2, channel 0.
	IOCON_P2_6_FUNC_T2_CAP0 = 0x3
	// RS-485/EIA-485 output enable signal for UART2.
	IOCON_P2_6_FUNC_U2_OE = 0x4
	// Trace clock.
	IOCON_P2_6_FUNC_TRACECLK = 0x5
	// LCD data.
	IOCON_P2_6_FUNC_LCD_VD_0 = 0x6
	// LCD data.
	IOCON_P2_6_FUNC_LCD_VD_4 = 0x7
	// Position of MODE field.
	IOCON_P2_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_6_HYS = 0x20
	// Disable.
	IOCON_P2_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_6_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_6_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_6_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_6_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_6_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_6_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_6_OD = 0x400
	// Disable.
	IOCON_P2_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_6_RESERVED_Msk = 0xfffff800

	// P2_7: I/O configuration register for pin P2[7]
	// Position of FUNC field.
	IOCON_P2_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_7_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_7_FUNC_P2_7 = 0x0
	// CAN2 receiver input.
	IOCON_P2_7_FUNC_CAN_RD2 = 0x1
	// Request to Send output for UART1. Can also be configured to be an RS-485/EIA-485 output enable signal for UART1.
	IOCON_P2_7_FUNC_U1_RTS = 0x2
	// LCD data.
	IOCON_P2_7_FUNC_LCD_VD_1 = 0x6
	// LCD data.
	IOCON_P2_7_FUNC_LCD_VD_5 = 0x7
	// Position of MODE field.
	IOCON_P2_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_7_HYS = 0x20
	// Disable.
	IOCON_P2_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_7_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_7_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_7_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_7_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_7_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_7_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_7_OD = 0x400
	// Disable.
	IOCON_P2_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_7_RESERVED_Msk = 0xfffff800

	// P2_8: I/O configuration register for pin P2[8]
	// Position of FUNC field.
	IOCON_P2_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_8_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_8_FUNC_P2_8 = 0x0
	// CAN2 transmitter output.
	IOCON_P2_8_FUNC_CAN_TD2 = 0x1
	// Transmitter output for UART2.
	IOCON_P2_8_FUNC_U2_TXD = 0x2
	// Clear to Send input for UART1.
	IOCON_P2_8_FUNC_U1_CTS = 0x3
	// Ethernet MIIM clock.
	IOCON_P2_8_FUNC_ENET_MDC = 0x4
	// LCD data.
	IOCON_P2_8_FUNC_LCD_VD_2 = 0x6
	// LCD data.
	IOCON_P2_8_FUNC_LCD_VD_6 = 0x7
	// Position of MODE field.
	IOCON_P2_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_8_HYS = 0x20
	// Disable.
	IOCON_P2_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_8_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_8_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_8_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_8_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_8_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_8_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_8_OD = 0x400
	// Disable.
	IOCON_P2_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_8_RESERVED_Msk = 0xfffff800

	// P2_9: I/O configuration register for pin P2[9]
	// Position of FUNC field.
	IOCON_P2_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_9_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_9_FUNC_P2_9 = 0x0
	// USB1 SoftConnect control. Signal used to switch an external 1.5 kW resistor under the software control. Used with the SoftConnect USB feature.
	IOCON_P2_9_FUNC_USB_CONNECT1 = 0x1
	// Receiver input for UART2.
	IOCON_P2_9_FUNC_U2_RXD = 0x2
	// Receiver input for USART4.
	IOCON_P2_9_FUNC_U4_RXD = 0x3
	// Ethernet MIIM data input and output.
	IOCON_P2_9_FUNC_ENET_MDIO = 0x4
	// LCD data.
	IOCON_P2_9_FUNC_LCD_VD_3 = 0x6
	// LCD data.
	IOCON_P2_9_FUNC_LCD_VD_7 = 0x7
	// Position of MODE field.
	IOCON_P2_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_9_HYS = 0x20
	// Disable.
	IOCON_P2_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_9_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_9_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_9_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_9_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_9_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_9_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_9_OD = 0x400
	// Disable.
	IOCON_P2_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_9_RESERVED_Msk = 0xfffff800

	// P2_10: I/O configuration register for pin P2[10]
	// Position of FUNC field.
	IOCON_P2_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_10_FUNC_Msk = 0x7
	// General purpose digital input/output pin. This pin includes a 5 ns input glitch filter.A LOW on this pin while RESET is LOW forces the on-chip boot loader to take over control of the part after a reset and go into ISP mode.
	IOCON_P2_10_FUNC_P2_10 = 0x0
	// External interrupt 0 input.
	IOCON_P2_10_FUNC_EINT0 = 0x1
	// Non-maskable interrupt input.
	IOCON_P2_10_FUNC_NMI = 0x2

	// P2_11: I/O configuration register for pin P2[11]
	// Position of FUNC field.
	IOCON_P2_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_11_FUNC_Msk = 0x7
	// General purpose digital input/output pin. This pin includes a 5 ns input glitch filter.
	IOCON_P2_11_FUNC_P2_11 = 0x0
	// External interrupt 1 input.
	IOCON_P2_11_FUNC_EINT1 = 0x1
	// Data line 1 for SD card interface.
	IOCON_P2_11_FUNC_SD_DAT_1 = 0x2
	// Transmit Clock. It is driven by the master and received by the slave. Corresponds to the signal SCK in the I2S-bus specification.
	IOCON_P2_11_FUNC_I2S_TX_SCK = 0x3
	// LCD clock.
	IOCON_P2_11_FUNC_LCD_CLKIN = 0x7

	// P2_12: I/O configuration register for pin P2[12]
	// Position of FUNC field.
	IOCON_P2_12_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_12_FUNC_Msk = 0x7
	// General purpose digital input/output pin. This pin includes a 5 ns input glitch filter.
	IOCON_P2_12_FUNC_P2_12 = 0x0
	// External interrupt 2 input.
	IOCON_P2_12_FUNC_EINT2 = 0x1
	// Data line 2 for SD card interface.
	IOCON_P2_12_FUNC_SD_DAT_2 = 0x2
	// Transmit Word Select. It is driven by the master and received by the slave. Corresponds to the signal WS in the I2S-bus specification.
	IOCON_P2_12_FUNC_I2S_TX_WS = 0x3
	// LCD data.
	IOCON_P2_12_FUNC_LCD_VD_4 = 0x4
	// LCD data.
	IOCON_P2_12_FUNC_LCD_VD_3 = 0x5
	// LCD data.
	IOCON_P2_12_FUNC_LCD_VD_8 = 0x6
	// LCD data.
	IOCON_P2_12_FUNC_LCD_VD_18 = 0x7

	// P2_13: I/O configuration register for pin P2[13]
	// Position of FUNC field.
	IOCON_P2_13_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_13_FUNC_Msk = 0x7
	// General purpose digital input/output pin. This pin includes a 5 ns input glitch filter.
	IOCON_P2_13_FUNC_P2_13 = 0x0
	// External interrupt 3 input.
	IOCON_P2_13_FUNC_EINT3 = 0x1
	// Data line 3 for SD card interface.
	IOCON_P2_13_FUNC_SD_DAT_3 = 0x2
	// Transmit data. It is driven by the transmitter and read by the receiver. Corresponds to the signal SD in the I2S-bus specification.
	IOCON_P2_13_FUNC_I2S_TX_SDA = 0x3
	// LCD data.
	IOCON_P2_13_FUNC_LCD_VD_5 = 0x5
	// LCD data.
	IOCON_P2_13_FUNC_LCD_VD_9 = 0x6
	// LCD data.
	IOCON_P2_13_FUNC_LCD_VD_19 = 0x7

	// P2_14: I/O configuration register for pin P2[14]
	// Position of FUNC field.
	IOCON_P2_14_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_14_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_14_FUNC_P2_14 = 0x0
	// LOW active Chip Select 2 signal.
	IOCON_P2_14_FUNC_EMC_CS2 = 0x1
	// I2C1 data input/output (this pin does not use a specialized I2C pad).
	IOCON_P2_14_FUNC_I2C1_SDA = 0x2
	// Capture input for Timer 2, channel 0.
	IOCON_P2_14_FUNC_T2_CAP0 = 0x3
	// Position of MODE field.
	IOCON_P2_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_14_HYS = 0x20
	// Disable.
	IOCON_P2_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_14_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_14_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_14_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_14_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_14_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_14_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_14_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_14_OD = 0x400
	// Disable.
	IOCON_P2_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_14_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_14_RESERVED_Msk = 0xfffff800

	// P2_15: I/O configuration register for pin P2[15]
	// Position of FUNC field.
	IOCON_P2_15_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_15_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_15_FUNC_P2_15 = 0x0
	// LOW active Chip Select 3 signal.
	IOCON_P2_15_FUNC_EMC_CS3 = 0x1
	// I2C1 clock input/output (this pin does not use a specialized I2C pad).
	IOCON_P2_15_FUNC_I2C1_SCL = 0x2
	// Capture input for Timer 2, channel 1.
	IOCON_P2_15_FUNC_T2_CAP1 = 0x3
	// Position of MODE field.
	IOCON_P2_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_15_HYS = 0x20
	// Disable.
	IOCON_P2_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_15_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_15_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_15_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_15_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_15_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_15_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_15_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_15_OD = 0x400
	// Disable.
	IOCON_P2_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_15_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_15_RESERVED_Msk = 0xfffff800

	// P2_16: I/O configuration register for pin P2[16]
	// Position of FUNC field.
	IOCON_P2_16_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_16_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_16_FUNC_P2_16 = 0x0
	// LOW active SDRAM Column Address Strobe.
	IOCON_P2_16_FUNC_EMC_CAS = 0x1
	// Position of MODE field.
	IOCON_P2_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_16_HYS = 0x20
	// Disable.
	IOCON_P2_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_16_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_16_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_16_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_16_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_16_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_16_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_16_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_16_OD = 0x400
	// Disable.
	IOCON_P2_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_16_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_16_RESERVED_Msk = 0xfffff800

	// P2_17: I/O configuration register for pin P2[17]
	// Position of FUNC field.
	IOCON_P2_17_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_17_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_17_FUNC_P2_17 = 0x0
	// LOW active SDRAM Row Address Strobe.
	IOCON_P2_17_FUNC_EMC_RAS = 0x1
	// Position of MODE field.
	IOCON_P2_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_17_HYS = 0x20
	// Disable.
	IOCON_P2_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_17_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_17_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_17_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_17_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_17_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_17_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_17_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_17_OD = 0x400
	// Disable.
	IOCON_P2_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_17_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_17_RESERVED_Msk = 0xfffff800

	// P2_18: I/O configuration register for pin P2[18]
	// Position of FUNC field.
	IOCON_P2_18_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_18_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_18_FUNC_P2_18 = 0x0
	// SDRAM clock 0.
	IOCON_P2_18_FUNC_EMC_CLK_0 = 0x1
	// Position of MODE field.
	IOCON_P2_18_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_18_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_18_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_18_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_18_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_18_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_18_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_18_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_18_HYS = 0x20
	// Disable.
	IOCON_P2_18_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_18_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_18_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_18_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_18_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_18_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_18_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_P2_18_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_P2_18_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_P2_18_ADMODE = 0x80
	// Analog input mode.
	IOCON_P2_18_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_P2_18_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_P2_18_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_P2_18_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_P2_18_FILTR = 0x100
	// Filter disabled.
	IOCON_P2_18_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_P2_18_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_P2_18_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_P2_18_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_P2_18_RESERVED = 0x200
	// Position of OD field.
	IOCON_P2_18_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_18_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_18_OD = 0x400
	// Disable.
	IOCON_P2_18_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_P2_18_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_18_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_18_RESERVED_Msk = 0xfffff800

	// P2_19: I/O configuration register for pin P2[19]
	// Position of FUNC field.
	IOCON_P2_19_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_19_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_19_FUNC_P2_19 = 0x0
	// SDRAM clock 1.
	IOCON_P2_19_FUNC_EMC_CLK_1 = 0x1
	// Position of MODE field.
	IOCON_P2_19_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_19_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_19_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_19_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_19_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_19_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_19_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_19_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_19_HYS = 0x20
	// Disable.
	IOCON_P2_19_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_19_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_19_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_19_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_19_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_19_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_19_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of ADMODE field.
	IOCON_P2_19_ADMODE_Pos = 0x7
	// Bit mask of ADMODE field.
	IOCON_P2_19_ADMODE_Msk = 0x80
	// Bit ADMODE.
	IOCON_P2_19_ADMODE = 0x80
	// Analog input mode.
	IOCON_P2_19_ADMODE_ANALOG_INPUT_MODE_ = 0x0
	// Digital functional mode.
	IOCON_P2_19_ADMODE_DIGITAL_FUNCTIONAL_M = 0x1
	// Position of FILTR field.
	IOCON_P2_19_FILTR_Pos = 0x8
	// Bit mask of FILTR field.
	IOCON_P2_19_FILTR_Msk = 0x100
	// Bit FILTR.
	IOCON_P2_19_FILTR = 0x100
	// Filter disabled.
	IOCON_P2_19_FILTR_FILTER_DISABLED_ = 0x0
	// Filter enabled.
	IOCON_P2_19_FILTR_FILTER_ENABLED_ = 0x1
	// Position of RESERVED field.
	IOCON_P2_19_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_P2_19_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_P2_19_RESERVED = 0x200
	// Position of OD field.
	IOCON_P2_19_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_19_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_19_OD = 0x400
	// Disable.
	IOCON_P2_19_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode.
	IOCON_P2_19_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_19_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_19_RESERVED_Msk = 0xfffff800

	// P2_20: I/O configuration register for pin P2[20]
	// Position of FUNC field.
	IOCON_P2_20_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_20_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_20_FUNC_P2_20 = 0x0
	// SDRAM chip select 0.
	IOCON_P2_20_FUNC_EMC_DYCS0 = 0x1
	// Position of MODE field.
	IOCON_P2_20_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_20_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_20_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_20_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_20_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_20_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_20_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_20_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_20_HYS = 0x20
	// Disable.
	IOCON_P2_20_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_20_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_20_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_20_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_20_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_20_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_20_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_20_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_20_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_20_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_20_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_20_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_20_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_20_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_20_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_20_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_20_OD = 0x400
	// Disable.
	IOCON_P2_20_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_20_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_20_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_20_RESERVED_Msk = 0xfffff800

	// P2_21: I/O configuration register for pin P2[21]
	// Position of FUNC field.
	IOCON_P2_21_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_21_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_21_FUNC_P2_21 = 0x0
	// SDRAM chip select 1.
	IOCON_P2_21_FUNC_EMC_DYCS1 = 0x1
	// Position of MODE field.
	IOCON_P2_21_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_21_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_21_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_21_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_21_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_21_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_21_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_21_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_21_HYS = 0x20
	// Disable.
	IOCON_P2_21_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_21_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_21_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_21_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_21_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_21_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_21_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_21_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_21_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_21_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_21_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_21_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_21_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_21_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_21_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_21_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_21_OD = 0x400
	// Disable.
	IOCON_P2_21_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_21_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_21_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_21_RESERVED_Msk = 0xfffff800

	// P2_22: I/O configuration register for pin P2[22]
	// Position of FUNC field.
	IOCON_P2_22_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_22_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_22_FUNC_P2_22 = 0x0
	// SDRAM chip select 2.
	IOCON_P2_22_FUNC_EMC_DYCS2 = 0x1
	// Serial clock for SSP0.
	IOCON_P2_22_FUNC_SSP0_SCK = 0x2
	// Capture input for Timer 3, channel 0.
	IOCON_P2_22_FUNC_T3_CAP0 = 0x3
	// Position of MODE field.
	IOCON_P2_22_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_22_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_22_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_22_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_22_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_22_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_22_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_22_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_22_HYS = 0x20
	// Disable.
	IOCON_P2_22_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_22_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_22_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_22_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_22_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_22_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_22_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_22_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_22_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_22_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_22_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_22_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_22_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_22_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_22_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_22_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_22_OD = 0x400
	// Disable.
	IOCON_P2_22_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_22_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_22_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_22_RESERVED_Msk = 0xfffff800

	// P2_23: I/O configuration register for pin P2[23]
	// Position of FUNC field.
	IOCON_P2_23_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_23_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_23_FUNC_P2_23 = 0x0
	// SDRAM chip select 3.
	IOCON_P2_23_FUNC_EMC_DYCS3 = 0x1
	// Slave Select for SSP0.
	IOCON_P2_23_FUNC_SSP0_SSEL = 0x2
	// Capture input for Timer 3, channel 1.
	IOCON_P2_23_FUNC_T3_CAP1 = 0x3
	// Position of MODE field.
	IOCON_P2_23_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_23_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_23_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_23_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_23_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_23_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_23_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_23_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_23_HYS = 0x20
	// Disable.
	IOCON_P2_23_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_23_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_23_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_23_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_23_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_23_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_23_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_23_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_23_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_23_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_23_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_23_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_23_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_23_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_23_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_23_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_23_OD = 0x400
	// Disable.
	IOCON_P2_23_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_23_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_23_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_23_RESERVED_Msk = 0xfffff800

	// P2_24: I/O configuration register for pin P2[24]
	// Position of FUNC field.
	IOCON_P2_24_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_24_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_24_FUNC_P2_24 = 0x0
	// SDRAM clock enable 0.
	IOCON_P2_24_FUNC_EMC_CKE0 = 0x1
	// Position of MODE field.
	IOCON_P2_24_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_24_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_24_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_24_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_24_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_24_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_24_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_24_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_24_HYS = 0x20
	// Disable.
	IOCON_P2_24_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_24_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_24_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_24_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_24_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_24_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_24_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_24_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_24_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_24_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_24_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_24_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_24_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_24_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_24_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_24_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_24_OD = 0x400
	// Disable.
	IOCON_P2_24_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_24_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_24_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_24_RESERVED_Msk = 0xfffff800

	// P2_25: I/O configuration register for pin P2[25]
	// Position of FUNC field.
	IOCON_P2_25_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_25_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_25_FUNC_P2_25 = 0x0
	// SDRAM clock enable 1.
	IOCON_P2_25_FUNC_EMC_CKE1 = 0x1
	// Position of MODE field.
	IOCON_P2_25_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_25_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_25_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_25_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_25_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_25_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_25_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_25_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_25_HYS = 0x20
	// Disable.
	IOCON_P2_25_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_25_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_25_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_25_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_25_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_25_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_25_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_25_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_25_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_25_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_25_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_25_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_25_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_25_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_25_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_25_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_25_OD = 0x400
	// Disable.
	IOCON_P2_25_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_25_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_25_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_25_RESERVED_Msk = 0xfffff800

	// P2_26: I/O configuration register for pin P2[26]
	// Position of FUNC field.
	IOCON_P2_26_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_26_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_26_FUNC_P2_26 = 0x0
	// SDRAM clock enable 2.
	IOCON_P2_26_FUNC_EMC_CKE2 = 0x1
	// Master In Slave Out for SSP0.
	IOCON_P2_26_FUNC_SSP0_MISO = 0x2
	// Match output for Timer 3, channel 0.
	IOCON_P2_26_FUNC_T3_MAT0 = 0x3
	// Position of MODE field.
	IOCON_P2_26_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_26_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_26_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_26_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_26_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_26_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_26_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_26_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_26_HYS = 0x20
	// Disable.
	IOCON_P2_26_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_26_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_26_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_26_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_26_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_26_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_26_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_26_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_26_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_26_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_26_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_26_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_26_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_26_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_26_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_26_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_26_OD = 0x400
	// Disable.
	IOCON_P2_26_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_26_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_26_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_26_RESERVED_Msk = 0xfffff800

	// P2_27: I/O configuration register for pin P2[27]
	// Position of FUNC field.
	IOCON_P2_27_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_27_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_27_FUNC_P2_27 = 0x0
	// SDRAM clock enable 3.
	IOCON_P2_27_FUNC_EMC_CKE3 = 0x1
	// Master Out Slave In for SSP0.
	IOCON_P2_27_FUNC_SSP0_MOSI = 0x2
	// Match output for Timer 3, channel 1.
	IOCON_P2_27_FUNC_T3_MAT1 = 0x3
	// Position of MODE field.
	IOCON_P2_27_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_27_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_27_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_27_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_27_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_27_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_27_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_27_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_27_HYS = 0x20
	// Disable.
	IOCON_P2_27_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_27_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_27_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_27_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_27_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_27_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_27_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_27_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_27_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_27_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_27_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_27_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_27_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_27_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_27_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_27_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_27_OD = 0x400
	// Disable.
	IOCON_P2_27_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_27_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_27_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_27_RESERVED_Msk = 0xfffff800

	// P2_28: I/O configuration register for pin P2[28]
	// Position of FUNC field.
	IOCON_P2_28_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_28_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_28_FUNC_P2_28 = 0x0
	// Data mask 0 used with SDRAM and static devices.
	IOCON_P2_28_FUNC_EMC_DQM0 = 0x1
	// Position of MODE field.
	IOCON_P2_28_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_28_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_28_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_28_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_28_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_28_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_28_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_28_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_28_HYS = 0x20
	// Disable.
	IOCON_P2_28_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_28_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_28_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_28_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_28_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_28_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_28_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_28_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_28_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_28_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_28_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_28_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_28_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_28_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_28_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_28_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_28_OD = 0x400
	// Disable.
	IOCON_P2_28_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_28_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_28_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_28_RESERVED_Msk = 0xfffff800

	// P2_29: I/O configuration register for pin P2[29]
	// Position of FUNC field.
	IOCON_P2_29_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_29_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_29_FUNC_P2_29 = 0x0
	// Data mask 1 used with SDRAM and static devices.
	IOCON_P2_29_FUNC_EMC_DQM1 = 0x1
	// Position of MODE field.
	IOCON_P2_29_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_29_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_29_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_29_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_29_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_29_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_29_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_29_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_29_HYS = 0x20
	// Disable.
	IOCON_P2_29_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_29_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_29_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_29_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_29_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_29_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_29_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_29_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_29_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_29_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_29_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_29_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_29_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_29_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_29_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_29_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_29_OD = 0x400
	// Disable.
	IOCON_P2_29_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_29_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_29_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_29_RESERVED_Msk = 0xfffff800

	// P2_30: I/O configuration register for pin P2[30]
	// Position of FUNC field.
	IOCON_P2_30_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_30_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_30_FUNC_P2_30 = 0x0
	// Data mask 2 used with SDRAM and static devices.
	IOCON_P2_30_FUNC_EMC_DQM2 = 0x1
	// I2C2 data input/output (this pin does not use a specialized I2C pad).
	IOCON_P2_30_FUNC_I2C2_SDA = 0x2
	// Match output for Timer 3, channel 2.
	IOCON_P2_30_FUNC_T3_MAT2 = 0x3
	// Position of MODE field.
	IOCON_P2_30_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_30_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_30_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_30_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_30_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_30_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_30_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_30_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_30_HYS = 0x20
	// Disable.
	IOCON_P2_30_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_30_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_30_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_30_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_30_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_30_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_30_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_30_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_30_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_30_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_30_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_30_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_30_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_30_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_30_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_30_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_30_OD = 0x400
	// Disable.
	IOCON_P2_30_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_30_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_30_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_30_RESERVED_Msk = 0xfffff800

	// P2_31: I/O configuration register for pin P2[31]
	// Position of FUNC field.
	IOCON_P2_31_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P2_31_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P2_31_FUNC_P2_31 = 0x0
	// Data mask 3 used with SDRAM and static devices.
	IOCON_P2_31_FUNC_EMC_DQM3 = 0x1
	// I2C2 clock input/output (this pin does not use a specialized I2C pad).
	IOCON_P2_31_FUNC_I2C2_SCL = 0x2
	// Match output for Timer 3, channel 3.
	IOCON_P2_31_FUNC_T3_MAT3 = 0x3
	// Position of MODE field.
	IOCON_P2_31_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P2_31_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P2_31_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P2_31_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P2_31_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P2_31_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P2_31_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P2_31_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P2_31_HYS = 0x20
	// Disable.
	IOCON_P2_31_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P2_31_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P2_31_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P2_31_INV_Msk = 0x40
	// Bit INV.
	IOCON_P2_31_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P2_31_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P2_31_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P2_31_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P2_31_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P2_31_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P2_31_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P2_31_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P2_31_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P2_31_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P2_31_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P2_31_OD_Msk = 0x400
	// Bit OD.
	IOCON_P2_31_OD = 0x400
	// Disable.
	IOCON_P2_31_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P2_31_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P2_31_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P2_31_RESERVED_Msk = 0xfffff800

	// P3_0: I/O configuration register for pin P3[0]
	// Position of FUNC field.
	IOCON_P3_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_0_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_0_FUNC_P3_0 = 0x0
	// External memory data line 0.
	IOCON_P3_0_FUNC_EMC_D_0 = 0x1
	// Position of MODE field.
	IOCON_P3_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_0_HYS = 0x20
	// Disable.
	IOCON_P3_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_0_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_0_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_0_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_0_OD = 0x400
	// Disable.
	IOCON_P3_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_0_RESERVED_Msk = 0xfffff800

	// P3_1: I/O configuration register for pin P3[1]
	// Position of FUNC field.
	IOCON_P3_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_1_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_1_FUNC_P3_1 = 0x0
	// External memory data line 1.
	IOCON_P3_1_FUNC_EMC_D_1 = 0x1
	// Position of MODE field.
	IOCON_P3_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_1_HYS = 0x20
	// Disable.
	IOCON_P3_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_1_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_1_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_1_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_1_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_1_OD = 0x400
	// Disable.
	IOCON_P3_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_1_RESERVED_Msk = 0xfffff800

	// P3_2: I/O configuration register for pin P3[2]
	// Position of FUNC field.
	IOCON_P3_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_2_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_2_FUNC_P3_2 = 0x0
	// External memory data line 2.
	IOCON_P3_2_FUNC_EMC_D_2 = 0x1
	// Position of MODE field.
	IOCON_P3_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_2_HYS = 0x20
	// Disable.
	IOCON_P3_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_2_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_2_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_2_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_2_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_2_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_2_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_2_OD = 0x400
	// Disable.
	IOCON_P3_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_2_RESERVED_Msk = 0xfffff800

	// P3_3: I/O configuration register for pin P3[3]
	// Position of FUNC field.
	IOCON_P3_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_3_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_3_FUNC_P3_3 = 0x0
	// External memory data line 3.
	IOCON_P3_3_FUNC_EMC_D_3 = 0x1
	// Position of MODE field.
	IOCON_P3_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_3_HYS = 0x20
	// Disable.
	IOCON_P3_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_3_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_3_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_3_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_3_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_3_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_3_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_3_OD = 0x400
	// Disable.
	IOCON_P3_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_3_RESERVED_Msk = 0xfffff800

	// P3_4: I/O configuration register for pin P3[4]
	// Position of FUNC field.
	IOCON_P3_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_4_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_4_FUNC_P3_4 = 0x0
	// External memory data line 4.
	IOCON_P3_4_FUNC_EMC_D_4 = 0x1
	// Position of MODE field.
	IOCON_P3_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_4_HYS = 0x20
	// Disable.
	IOCON_P3_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_4_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_4_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_4_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_4_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_4_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_4_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_4_OD = 0x400
	// Disable.
	IOCON_P3_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_4_RESERVED_Msk = 0xfffff800

	// P3_5: I/O configuration register for pin P3[5]
	// Position of FUNC field.
	IOCON_P3_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_5_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_5_FUNC_P3_5 = 0x0
	// External memory data line 5.
	IOCON_P3_5_FUNC_EMC_D_5 = 0x1
	// Position of MODE field.
	IOCON_P3_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_5_HYS = 0x20
	// Disable.
	IOCON_P3_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_5_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_5_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_5_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_5_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_5_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_5_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_5_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_5_OD = 0x400
	// Disable.
	IOCON_P3_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_5_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_5_RESERVED_Msk = 0xfffff800

	// P3_6: I/O configuration register for pin P3[6]
	// Position of FUNC field.
	IOCON_P3_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_6_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_6_FUNC_P3_6 = 0x0
	// External memory data line 6.
	IOCON_P3_6_FUNC_EMC_D_6 = 0x1
	// Position of MODE field.
	IOCON_P3_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_6_HYS = 0x20
	// Disable.
	IOCON_P3_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_6_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_6_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_6_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_6_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_6_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_6_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_6_OD = 0x400
	// Disable.
	IOCON_P3_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_6_RESERVED_Msk = 0xfffff800

	// P3_7: I/O configuration register for pin P3[7]
	// Position of FUNC field.
	IOCON_P3_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_7_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_7_FUNC_P3_7 = 0x0
	// External memory data line 7.
	IOCON_P3_7_FUNC_EMC_D_7 = 0x1
	// Position of MODE field.
	IOCON_P3_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_7_HYS = 0x20
	// Disable.
	IOCON_P3_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_7_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_7_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_7_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_7_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_7_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_7_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_7_OD = 0x400
	// Disable.
	IOCON_P3_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_7_RESERVED_Msk = 0xfffff800

	// P3_8: I/O configuration register for pin P3[8]
	// Position of FUNC field.
	IOCON_P3_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_8_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_8_FUNC_P3_8 = 0x0
	// External memory data line 8.
	IOCON_P3_8_FUNC_EMC_D_8 = 0x1
	// Position of MODE field.
	IOCON_P3_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_8_HYS = 0x20
	// Disable.
	IOCON_P3_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_8_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_8_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_8_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_8_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_8_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_8_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_8_OD = 0x400
	// Disable.
	IOCON_P3_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_8_RESERVED_Msk = 0xfffff800

	// P3_9: I/O configuration register for pin P3[9]
	// Position of FUNC field.
	IOCON_P3_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_9_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_9_FUNC_P3_9 = 0x0
	// External memory data line 9.
	IOCON_P3_9_FUNC_EMC_D_9 = 0x1
	// Position of MODE field.
	IOCON_P3_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_9_HYS = 0x20
	// Disable.
	IOCON_P3_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_9_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_9_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_9_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_9_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_9_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_9_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_9_OD = 0x400
	// Disable.
	IOCON_P3_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_9_RESERVED_Msk = 0xfffff800

	// P3_10: I/O configuration register for pin P3[10]
	// Position of FUNC field.
	IOCON_P3_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_10_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_10_FUNC_P3_10 = 0x0
	// External memory data line 10.
	IOCON_P3_10_FUNC_EMC_D_10 = 0x1
	// Position of MODE field.
	IOCON_P3_10_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_10_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_10_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_10_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_10_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_10_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_10_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_10_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_10_HYS = 0x20
	// Disable.
	IOCON_P3_10_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_10_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_10_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_10_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_10_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_10_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_10_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_10_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_10_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_10_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_10_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_10_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_10_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_10_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_10_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_10_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_10_OD = 0x400
	// Disable.
	IOCON_P3_10_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_10_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_10_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_10_RESERVED_Msk = 0xfffff800

	// P3_11: I/O configuration register for pin P3[11]
	// Position of FUNC field.
	IOCON_P3_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_11_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_11_FUNC_P3_11 = 0x0
	// External memory data line 11.
	IOCON_P3_11_FUNC_EMC_D_11 = 0x1
	// Position of MODE field.
	IOCON_P3_11_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_11_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_11_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_11_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_11_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_11_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_11_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_11_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_11_HYS = 0x20
	// Disable.
	IOCON_P3_11_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_11_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_11_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_11_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_11_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_11_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_11_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_11_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_11_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_11_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_11_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_11_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_11_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_11_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_11_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_11_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_11_OD = 0x400
	// Disable.
	IOCON_P3_11_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_11_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_11_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_11_RESERVED_Msk = 0xfffff800

	// P3_12: I/O configuration register for pin P3[12]
	// Position of FUNC field.
	IOCON_P3_12_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_12_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_12_FUNC_P3_12 = 0x0
	// External memory data line 12.
	IOCON_P3_12_FUNC_EMC_D_12 = 0x1
	// Position of MODE field.
	IOCON_P3_12_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_12_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_12_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_12_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_12_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_12_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_12_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_12_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_12_HYS = 0x20
	// Disable.
	IOCON_P3_12_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_12_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_12_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_12_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_12_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_12_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_12_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_12_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_12_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_12_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_12_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_12_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_12_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_12_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_12_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_12_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_12_OD = 0x400
	// Disable.
	IOCON_P3_12_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_12_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_12_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_12_RESERVED_Msk = 0xfffff800

	// P3_13: I/O configuration register for pin P3[13]
	// Position of FUNC field.
	IOCON_P3_13_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_13_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_13_FUNC_P3_13 = 0x0
	// External memory data line 13.
	IOCON_P3_13_FUNC_EMC_D_13 = 0x1
	// Position of MODE field.
	IOCON_P3_13_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_13_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_13_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_13_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_13_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_13_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_13_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_13_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_13_HYS = 0x20
	// Disable.
	IOCON_P3_13_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_13_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_13_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_13_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_13_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_13_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_13_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_13_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_13_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_13_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_13_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_13_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_13_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_13_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_13_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_13_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_13_OD = 0x400
	// Disable.
	IOCON_P3_13_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_13_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_13_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_13_RESERVED_Msk = 0xfffff800

	// P3_14: I/O configuration register for pin P3[14]
	// Position of FUNC field.
	IOCON_P3_14_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_14_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_14_FUNC_P3_14 = 0x0
	// External memory data line 14.
	IOCON_P3_14_FUNC_EMC_D_14 = 0x1
	// Position of MODE field.
	IOCON_P3_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_14_HYS = 0x20
	// Disable.
	IOCON_P3_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_14_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_14_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_14_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_14_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_14_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_14_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_14_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_14_OD = 0x400
	// Disable.
	IOCON_P3_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_14_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_14_RESERVED_Msk = 0xfffff800

	// P3_15: I/O configuration register for pin P3[15]
	// Position of FUNC field.
	IOCON_P3_15_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_15_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_15_FUNC_P3_15 = 0x0
	// External memory data line 15.
	IOCON_P3_15_FUNC_EMC_D_15 = 0x1
	// Position of MODE field.
	IOCON_P3_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_15_HYS = 0x20
	// Disable.
	IOCON_P3_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_15_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_15_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_15_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_15_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_15_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_15_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_15_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_15_OD = 0x400
	// Disable.
	IOCON_P3_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_15_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_15_RESERVED_Msk = 0xfffff800

	// P3_16: I/O configuration register for pin P3[16]
	// Position of FUNC field.
	IOCON_P3_16_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_16_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_16_FUNC_P3_16 = 0x0
	// External memory data line 16.
	IOCON_P3_16_FUNC_EMC_D_16 = 0x1
	// Pulse Width Modulator 0, output 1.
	IOCON_P3_16_FUNC_PWM0_1 = 0x2
	// Transmitter output for UART1.
	IOCON_P3_16_FUNC_U1_TXD = 0x3
	// Position of MODE field.
	IOCON_P3_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_16_HYS = 0x20
	// Disable.
	IOCON_P3_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_16_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_16_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_16_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_16_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_16_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_16_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_16_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_16_OD = 0x400
	// Disable.
	IOCON_P3_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_16_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_16_RESERVED_Msk = 0xfffff800

	// P3_17: I/O configuration register for pin P3[17]
	// Position of FUNC field.
	IOCON_P3_17_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_17_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_17_FUNC_P3_17 = 0x0
	// External memory data line 17.
	IOCON_P3_17_FUNC_EMC_D_17 = 0x1
	// Pulse Width Modulator 0, output 2.
	IOCON_P3_17_FUNC_PWM0_2 = 0x2
	// Receiver input for UART1.
	IOCON_P3_17_FUNC_U1_RXD = 0x3
	// Position of MODE field.
	IOCON_P3_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_17_HYS = 0x20
	// Disable.
	IOCON_P3_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_17_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_17_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_17_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_17_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_17_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_17_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_17_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_17_OD = 0x400
	// Disable.
	IOCON_P3_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_17_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_17_RESERVED_Msk = 0xfffff800

	// P3_18: I/O configuration register for pin P3[18]
	// Position of FUNC field.
	IOCON_P3_18_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_18_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_18_FUNC_P3_18 = 0x0
	// External memory data line 18.
	IOCON_P3_18_FUNC_EMC_D_18 = 0x1
	// Pulse Width Modulator 0, output 3.
	IOCON_P3_18_FUNC_PWM0_3 = 0x2
	// Clear to Send input for UART1.
	IOCON_P3_18_FUNC_U1_CTS = 0x3
	// Position of MODE field.
	IOCON_P3_18_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_18_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_18_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_18_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_18_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_18_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_18_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_18_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_18_HYS = 0x20
	// Disable.
	IOCON_P3_18_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_18_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_18_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_18_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_18_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_18_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_18_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_18_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_18_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_18_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_18_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_18_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_18_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_18_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_18_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_18_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_18_OD = 0x400
	// Disable.
	IOCON_P3_18_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_18_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_18_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_18_RESERVED_Msk = 0xfffff800

	// P3_19: I/O configuration register for pin P3[19]
	// Position of FUNC field.
	IOCON_P3_19_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_19_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_19_FUNC_P3_19 = 0x0
	// External memory data line 19.
	IOCON_P3_19_FUNC_EMC_D_19 = 0x1
	// Pulse Width Modulator 0, output 4.
	IOCON_P3_19_FUNC_PWM0_4 = 0x2
	// Data Carrier Detect input for UART1.
	IOCON_P3_19_FUNC_U1_DCD = 0x3
	// Position of MODE field.
	IOCON_P3_19_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_19_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_19_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_19_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_19_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_19_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_19_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_19_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_19_HYS = 0x20
	// Disable.
	IOCON_P3_19_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_19_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_19_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_19_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_19_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_19_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_19_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_19_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_19_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_19_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_19_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_19_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_19_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_19_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_19_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_19_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_19_OD = 0x400
	// Disable.
	IOCON_P3_19_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_19_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_19_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_19_RESERVED_Msk = 0xfffff800

	// P3_20: I/O configuration register for pin P3[20]
	// Position of FUNC field.
	IOCON_P3_20_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_20_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_20_FUNC_P3_20 = 0x0
	// External memory data line 20.
	IOCON_P3_20_FUNC_EMC_D_20 = 0x1
	// Pulse Width Modulator 0, output 5.
	IOCON_P3_20_FUNC_PWM0_5 = 0x2
	// Data Set Ready input for UART1.
	IOCON_P3_20_FUNC_U1_DSR = 0x3
	// Position of MODE field.
	IOCON_P3_20_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_20_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_20_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_20_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_20_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_20_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_20_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_20_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_20_HYS = 0x20
	// Disable.
	IOCON_P3_20_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_20_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_20_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_20_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_20_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_20_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_20_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_20_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_20_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_20_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_20_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_20_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_20_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_20_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_20_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_20_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_20_OD = 0x400
	// Disable.
	IOCON_P3_20_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_20_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_20_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_20_RESERVED_Msk = 0xfffff800

	// P3_21: I/O configuration register for pin P3[21]
	// Position of FUNC field.
	IOCON_P3_21_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_21_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_21_FUNC_P3_21 = 0x0
	// External memory data line 21.
	IOCON_P3_21_FUNC_EMC_D_21 = 0x1
	// Pulse Width Modulator 0, output 6.
	IOCON_P3_21_FUNC_PWM0_6 = 0x2
	// Data Terminal Ready output for UART1. Can also be configured to be an RS-485/EIA-485 output enable signal for UART1.
	IOCON_P3_21_FUNC_U1_DTR = 0x3
	// Position of MODE field.
	IOCON_P3_21_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_21_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_21_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_21_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_21_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_21_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_21_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_21_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_21_HYS = 0x20
	// Disable.
	IOCON_P3_21_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_21_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_21_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_21_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_21_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_21_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_21_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_21_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_21_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_21_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_21_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_21_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_21_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_21_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_21_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_21_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_21_OD = 0x400
	// Disable.
	IOCON_P3_21_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_21_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_21_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_21_RESERVED_Msk = 0xfffff800

	// P3_22: I/O configuration register for pin P3[22]
	// Position of FUNC field.
	IOCON_P3_22_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_22_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_22_FUNC_P3_22 = 0x0
	// External memory data line 22.
	IOCON_P3_22_FUNC_EMC_D_22 = 0x1
	// Capture input for PWM0, channel 0.
	IOCON_P3_22_FUNC_PWM0_CAP0 = 0x2
	// Ring Indicator input for UART1.
	IOCON_P3_22_FUNC_U1_RI = 0x3
	// Position of MODE field.
	IOCON_P3_22_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_22_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_22_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_22_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_22_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_22_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_22_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_22_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_22_HYS = 0x20
	// Disable.
	IOCON_P3_22_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_22_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_22_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_22_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_22_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_22_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_22_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_22_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_22_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_22_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_22_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_22_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_22_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_22_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_22_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_22_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_22_OD = 0x400
	// Disable.
	IOCON_P3_22_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_22_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_22_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_22_RESERVED_Msk = 0xfffff800

	// P3_23: I/O configuration register for pin P3[23]
	// Position of FUNC field.
	IOCON_P3_23_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_23_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_23_FUNC_P3_23 = 0x0
	// External memory data line 23.
	IOCON_P3_23_FUNC_EMC_D_23 = 0x1
	// Capture input for PWM1, channel 0.
	IOCON_P3_23_FUNC_PWM1_CAP0 = 0x2
	// Capture input for Timer 0, channel 0.
	IOCON_P3_23_FUNC_T0_CAP0 = 0x3
	// Position of MODE field.
	IOCON_P3_23_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_23_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_23_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_23_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_23_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_23_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_23_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_23_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_23_HYS = 0x20
	// Disable.
	IOCON_P3_23_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_23_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_23_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_23_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_23_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_23_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_23_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_23_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_23_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_23_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_23_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_23_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_23_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_23_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_23_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_23_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_23_OD = 0x400
	// Disable.
	IOCON_P3_23_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_23_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_23_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_23_RESERVED_Msk = 0xfffff800

	// P3_24: I/O configuration register for pin P3[24]
	// Position of FUNC field.
	IOCON_P3_24_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_24_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_24_FUNC_P3_24 = 0x0
	// External memory data line 24.
	IOCON_P3_24_FUNC_EMC_D_24 = 0x1
	// Pulse Width Modulator 1, output 1.
	IOCON_P3_24_FUNC_PWM1_1 = 0x2
	// Capture input for Timer 0, channel 1.
	IOCON_P3_24_FUNC_T0_CAP1 = 0x3
	// Position of MODE field.
	IOCON_P3_24_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_24_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_24_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_24_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_24_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_24_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_24_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_24_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_24_HYS = 0x20
	// Disable.
	IOCON_P3_24_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_24_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_24_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_24_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_24_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_24_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_24_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_24_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_24_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_24_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_24_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_24_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_24_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_24_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_24_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_24_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_24_OD = 0x400
	// Disable.
	IOCON_P3_24_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_24_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_24_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_24_RESERVED_Msk = 0xfffff800

	// P3_25: I/O configuration register for pin P3[25]
	// Position of FUNC field.
	IOCON_P3_25_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_25_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_25_FUNC_P3_25 = 0x0
	// External memory data line 25.
	IOCON_P3_25_FUNC_EMC_D_25 = 0x1
	// Pulse Width Modulator 1, output 2.
	IOCON_P3_25_FUNC_PWM1_2 = 0x2
	// Match output for Timer 0, channel 0.
	IOCON_P3_25_FUNC_T0_MAT0 = 0x3
	// Position of MODE field.
	IOCON_P3_25_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_25_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_25_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_25_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_25_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_25_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_25_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_25_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_25_HYS = 0x20
	// Disable.
	IOCON_P3_25_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_25_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_25_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_25_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_25_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_25_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_25_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_25_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_25_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_25_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_25_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_25_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_25_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_25_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_25_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_25_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_25_OD = 0x400
	// Disable.
	IOCON_P3_25_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_25_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_25_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_25_RESERVED_Msk = 0xfffff800

	// P3_26: I/O configuration register for pin P3[26]
	// Position of FUNC field.
	IOCON_P3_26_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_26_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_26_FUNC_P3_26 = 0x0
	// External memory data line 26.
	IOCON_P3_26_FUNC_EMC_D_26 = 0x1
	// Pulse Width Modulator 1, output 3.
	IOCON_P3_26_FUNC_PWM1_3 = 0x2
	// Match output for Timer 0, channel 1.
	IOCON_P3_26_FUNC_T0_MAT1 = 0x3
	// System tick timer clock input.
	IOCON_P3_26_FUNC_STCLK = 0x4
	// Position of MODE field.
	IOCON_P3_26_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_26_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_26_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_26_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_26_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_26_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_26_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_26_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_26_HYS = 0x20
	// Disable.
	IOCON_P3_26_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_26_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_26_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_26_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_26_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_26_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_26_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_26_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_26_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_26_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_26_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_26_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_26_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_26_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_26_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_26_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_26_OD = 0x400
	// Disable.
	IOCON_P3_26_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_26_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_26_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_26_RESERVED_Msk = 0xfffff800

	// P3_27: I/O configuration register for pin P3[27]
	// Position of FUNC field.
	IOCON_P3_27_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_27_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_27_FUNC_P3_27 = 0x0
	// External memory data line 27.
	IOCON_P3_27_FUNC_EMC_D_27 = 0x1
	// Pulse Width Modulator 1, output 4.
	IOCON_P3_27_FUNC_PWM1_4 = 0x2
	// Capture input for Timer 1, channel 0.
	IOCON_P3_27_FUNC_T1_CAP0 = 0x3
	// Position of MODE field.
	IOCON_P3_27_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_27_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_27_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_27_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_27_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_27_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_27_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_27_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_27_HYS = 0x20
	// Disable.
	IOCON_P3_27_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_27_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_27_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_27_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_27_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_27_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_27_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_27_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_27_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_27_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_27_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_27_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_27_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_27_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_27_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_27_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_27_OD = 0x400
	// Disable.
	IOCON_P3_27_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_27_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_27_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_27_RESERVED_Msk = 0xfffff800

	// P3_28: I/O configuration register for pin P3[28]
	// Position of FUNC field.
	IOCON_P3_28_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_28_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_28_FUNC_P3_28 = 0x0
	// External memory data line 28.
	IOCON_P3_28_FUNC_EMC_D_28 = 0x1
	// Pulse Width Modulator 1, output 5.
	IOCON_P3_28_FUNC_PWM1_5 = 0x2
	// Capture input for Timer 1, channel 1.
	IOCON_P3_28_FUNC_T1_CAP1 = 0x3
	// Position of MODE field.
	IOCON_P3_28_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_28_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_28_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_28_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_28_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_28_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_28_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_28_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_28_HYS = 0x20
	// Disable.
	IOCON_P3_28_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_28_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_28_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_28_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_28_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_28_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_28_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_28_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_28_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_28_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_28_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_28_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_28_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_28_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_28_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_28_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_28_OD = 0x400
	// Disable.
	IOCON_P3_28_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_28_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_28_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_28_RESERVED_Msk = 0xfffff800

	// P3_29: I/O configuration register for pin P3[29]
	// Position of FUNC field.
	IOCON_P3_29_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_29_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_29_FUNC_P3_29 = 0x0
	// External memory data line 29.
	IOCON_P3_29_FUNC_EMC_D_29 = 0x1
	// Pulse Width Modulator 1, output 6.
	IOCON_P3_29_FUNC_PWM1_6 = 0x2
	// Match output for Timer 1, channel 0.
	IOCON_P3_29_FUNC_T1_MAT0 = 0x3
	// Position of MODE field.
	IOCON_P3_29_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_29_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_29_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_29_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_29_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_29_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_29_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_29_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_29_HYS = 0x20
	// Disable.
	IOCON_P3_29_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_29_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_29_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_29_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_29_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_29_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_29_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_29_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_29_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_29_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_29_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_29_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_29_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_29_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_29_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_29_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_29_OD = 0x400
	// Disable.
	IOCON_P3_29_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_29_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_29_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_29_RESERVED_Msk = 0xfffff800

	// P3_30: I/O configuration register for pin P3[30]
	// Position of FUNC field.
	IOCON_P3_30_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_30_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_30_FUNC_P3_30 = 0x0
	// External memory data line 30.
	IOCON_P3_30_FUNC_EMC_D_30 = 0x1
	// Request to Send output for UART1. Can also be configured to be an RS-485/EIA-485 output enable signal for UART1.
	IOCON_P3_30_FUNC_U1_RTS = 0x2
	// Match output for Timer 1, channel 1.
	IOCON_P3_30_FUNC_T1_MAT1 = 0x3
	// Position of MODE field.
	IOCON_P3_30_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_30_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_30_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_30_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_30_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_30_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_30_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_30_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_30_HYS = 0x20
	// Disable.
	IOCON_P3_30_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_30_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_30_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_30_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_30_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_30_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_30_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_30_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_30_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_30_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_30_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_30_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_30_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_30_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_30_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_30_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_30_OD = 0x400
	// Disable.
	IOCON_P3_30_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_30_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_30_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_30_RESERVED_Msk = 0xfffff800

	// P3_31: I/O configuration register for pin P3[31]
	// Position of FUNC field.
	IOCON_P3_31_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P3_31_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P3_31_FUNC_P3_31 = 0x0
	// External memory data line 31.
	IOCON_P3_31_FUNC_EMC_D_31 = 0x1
	// Match output for Timer 1, channel 2.
	IOCON_P3_31_FUNC_T1_MAT2 = 0x3
	// Position of MODE field.
	IOCON_P3_31_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P3_31_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P3_31_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P3_31_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P3_31_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P3_31_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P3_31_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P3_31_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P3_31_HYS = 0x20
	// Disable.
	IOCON_P3_31_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P3_31_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P3_31_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P3_31_INV_Msk = 0x40
	// Bit INV.
	IOCON_P3_31_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P3_31_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P3_31_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P3_31_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P3_31_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P3_31_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P3_31_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P3_31_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P3_31_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P3_31_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P3_31_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P3_31_OD_Msk = 0x400
	// Bit OD.
	IOCON_P3_31_OD = 0x400
	// Disable.
	IOCON_P3_31_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P3_31_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P3_31_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P3_31_RESERVED_Msk = 0xfffff800

	// P4_0: I/O configuration register for pin P4[0]
	// Position of FUNC field.
	IOCON_P4_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_0_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_0_FUNC_P4_0 = 0x0
	// External memory address line 0.
	IOCON_P4_0_FUNC_EMC_A_0 = 0x1
	// Position of MODE field.
	IOCON_P4_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_0_HYS = 0x20
	// Disable.
	IOCON_P4_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_0_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_0_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_0_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_0_OD = 0x400
	// Disable.
	IOCON_P4_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_0_RESERVED_Msk = 0xfffff800

	// P4_1: I/O configuration register for pin P4[1]
	// Position of FUNC field.
	IOCON_P4_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_1_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_1_FUNC_P4_1 = 0x0
	// External memory address line 1.
	IOCON_P4_1_FUNC_EMC_A_1 = 0x1
	// Position of MODE field.
	IOCON_P4_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_1_HYS = 0x20
	// Disable.
	IOCON_P4_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_1_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_1_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_1_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_1_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_1_OD = 0x400
	// Disable.
	IOCON_P4_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_1_RESERVED_Msk = 0xfffff800

	// P4_2: I/O configuration register for pin P4[2]
	// Position of FUNC field.
	IOCON_P4_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_2_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_2_FUNC_P4_2 = 0x0
	// External memory address line 2.
	IOCON_P4_2_FUNC_EMC_A_2 = 0x1
	// Position of MODE field.
	IOCON_P4_2_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_2_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_2_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_2_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_2_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_2_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_2_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_2_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_2_HYS = 0x20
	// Disable.
	IOCON_P4_2_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_2_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_2_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_2_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_2_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_2_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_2_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_2_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_2_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_2_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_2_OD = 0x400
	// Disable.
	IOCON_P4_2_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_2_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_2_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_2_RESERVED_Msk = 0xfffff800

	// P4_3: I/O configuration register for pin P4[3]
	// Position of FUNC field.
	IOCON_P4_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_3_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_3_FUNC_P4_3 = 0x0
	// External memory address line 3.
	IOCON_P4_3_FUNC_EMC_A_3 = 0x1
	// Position of MODE field.
	IOCON_P4_3_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_3_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_3_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_3_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_3_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_3_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_3_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_3_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_3_HYS = 0x20
	// Disable.
	IOCON_P4_3_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_3_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_3_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_3_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_3_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_3_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_3_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_3_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_3_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_3_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_3_OD = 0x400
	// Disable.
	IOCON_P4_3_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_3_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_3_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_3_RESERVED_Msk = 0xfffff800

	// P4_4: I/O configuration register for pin P4[4]
	// Position of FUNC field.
	IOCON_P4_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_4_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_4_FUNC_P4_4 = 0x0
	// External memory address line 4.
	IOCON_P4_4_FUNC_EMC_A_4 = 0x1
	// Position of MODE field.
	IOCON_P4_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_4_HYS = 0x20
	// Disable.
	IOCON_P4_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_4_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_4_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_4_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_4_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_4_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_4_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_4_OD = 0x400
	// Disable.
	IOCON_P4_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_4_RESERVED_Msk = 0xfffff800

	// P4_5: I/O configuration register for pin P4[5]
	// Position of FUNC field.
	IOCON_P4_5_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_5_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_5_FUNC_P4_5 = 0x0
	// External memory address line 5.
	IOCON_P4_5_FUNC_EMC_A_5 = 0x1
	// Position of MODE field.
	IOCON_P4_5_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_5_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_5_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_5_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_5_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_5_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_5_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_5_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_5_HYS = 0x20
	// Disable.
	IOCON_P4_5_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_5_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_5_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_5_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_5_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_5_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_5_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_5_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_5_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_5_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_5_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_5_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_5_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_5_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_5_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_5_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_5_OD = 0x400
	// Disable.
	IOCON_P4_5_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_5_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_5_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_5_RESERVED_Msk = 0xfffff800

	// P4_6: I/O configuration register for pin P4[6]
	// Position of FUNC field.
	IOCON_P4_6_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_6_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_6_FUNC_P4_6 = 0x0
	// External memory address line 6.
	IOCON_P4_6_FUNC_EMC_A_6 = 0x1
	// Position of MODE field.
	IOCON_P4_6_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_6_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_6_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_6_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_6_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_6_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_6_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_6_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_6_HYS = 0x20
	// Disable.
	IOCON_P4_6_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_6_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_6_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_6_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_6_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_6_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_6_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_6_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_6_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_6_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_6_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_6_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_6_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_6_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_6_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_6_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_6_OD = 0x400
	// Disable.
	IOCON_P4_6_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_6_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_6_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_6_RESERVED_Msk = 0xfffff800

	// P4_7: I/O configuration register for pin P4[7]
	// Position of FUNC field.
	IOCON_P4_7_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_7_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_7_FUNC_P4_7 = 0x0
	// External memory address line 7.
	IOCON_P4_7_FUNC_EMC_A_7 = 0x1
	// Position of MODE field.
	IOCON_P4_7_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_7_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_7_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_7_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_7_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_7_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_7_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_7_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_7_HYS = 0x20
	// Disable.
	IOCON_P4_7_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_7_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_7_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_7_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_7_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_7_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_7_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_7_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_7_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_7_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_7_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_7_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_7_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_7_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_7_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_7_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_7_OD = 0x400
	// Disable.
	IOCON_P4_7_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_7_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_7_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_7_RESERVED_Msk = 0xfffff800

	// P4_8: I/O configuration register for pin P4[8]
	// Position of FUNC field.
	IOCON_P4_8_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_8_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_8_FUNC_P4_8 = 0x0
	// External memory address line 8.
	IOCON_P4_8_FUNC_EMC_A_8 = 0x1
	// Position of MODE field.
	IOCON_P4_8_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_8_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_8_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_8_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_8_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_8_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_8_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_8_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_8_HYS = 0x20
	// Disable.
	IOCON_P4_8_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_8_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_8_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_8_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_8_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_8_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_8_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_8_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_8_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_8_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_8_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_8_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_8_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_8_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_8_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_8_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_8_OD = 0x400
	// Disable.
	IOCON_P4_8_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_8_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_8_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_8_RESERVED_Msk = 0xfffff800

	// P4_9: I/O configuration register for pin P4[9]
	// Position of FUNC field.
	IOCON_P4_9_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_9_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_9_FUNC_P4_9 = 0x0
	// External memory address line 9.
	IOCON_P4_9_FUNC_EMC_A_9 = 0x1
	// Position of MODE field.
	IOCON_P4_9_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_9_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_9_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_9_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_9_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_9_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_9_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_9_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_9_HYS = 0x20
	// Disable.
	IOCON_P4_9_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_9_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_9_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_9_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_9_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_9_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_9_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_9_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_9_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_9_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_9_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_9_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_9_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_9_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_9_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_9_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_9_OD = 0x400
	// Disable.
	IOCON_P4_9_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_9_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_9_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_9_RESERVED_Msk = 0xfffff800

	// P4_10: I/O configuration register for pin P4[10]
	// Position of FUNC field.
	IOCON_P4_10_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_10_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_10_FUNC_P4_10 = 0x0
	// External memory address line 10.
	IOCON_P4_10_FUNC_EMC_A_10 = 0x1
	// Position of MODE field.
	IOCON_P4_10_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_10_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_10_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_10_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_10_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_10_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_10_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_10_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_10_HYS = 0x20
	// Disable.
	IOCON_P4_10_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_10_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_10_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_10_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_10_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_10_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_10_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_10_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_10_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_10_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_10_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_10_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_10_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_10_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_10_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_10_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_10_OD = 0x400
	// Disable.
	IOCON_P4_10_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_10_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_10_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_10_RESERVED_Msk = 0xfffff800

	// P4_11: I/O configuration register for pin P4[11]
	// Position of FUNC field.
	IOCON_P4_11_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_11_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_11_FUNC_P4_11 = 0x0
	// External memory address line 11.
	IOCON_P4_11_FUNC_EMC_A_11 = 0x1
	// Position of MODE field.
	IOCON_P4_11_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_11_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_11_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_11_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_11_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_11_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_11_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_11_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_11_HYS = 0x20
	// Disable.
	IOCON_P4_11_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_11_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_11_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_11_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_11_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_11_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_11_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_11_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_11_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_11_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_11_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_11_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_11_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_11_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_11_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_11_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_11_OD = 0x400
	// Disable.
	IOCON_P4_11_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_11_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_11_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_11_RESERVED_Msk = 0xfffff800

	// P4_12: I/O configuration register for pin P4[12]
	// Position of FUNC field.
	IOCON_P4_12_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_12_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_12_FUNC_P4_12 = 0x0
	// External memory address line 12.
	IOCON_P4_12_FUNC_EMC_A_12 = 0x1
	// Position of MODE field.
	IOCON_P4_12_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_12_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_12_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_12_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_12_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_12_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_12_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_12_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_12_HYS = 0x20
	// Disable.
	IOCON_P4_12_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_12_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_12_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_12_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_12_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_12_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_12_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_12_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_12_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_12_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_12_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_12_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_12_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_12_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_12_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_12_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_12_OD = 0x400
	// Disable.
	IOCON_P4_12_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_12_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_12_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_12_RESERVED_Msk = 0xfffff800

	// P4_13: I/O configuration register for pin P4[13]
	// Position of FUNC field.
	IOCON_P4_13_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_13_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_13_FUNC_P4_13 = 0x0
	// External memory address line 13.
	IOCON_P4_13_FUNC_EMC_A_13 = 0x1
	// Position of MODE field.
	IOCON_P4_13_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_13_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_13_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_13_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_13_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_13_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_13_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_13_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_13_HYS = 0x20
	// Disable.
	IOCON_P4_13_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_13_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_13_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_13_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_13_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_13_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_13_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_13_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_13_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_13_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_13_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_13_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_13_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_13_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_13_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_13_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_13_OD = 0x400
	// Disable.
	IOCON_P4_13_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_13_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_13_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_13_RESERVED_Msk = 0xfffff800

	// P4_14: I/O configuration register for pin P4[14]
	// Position of FUNC field.
	IOCON_P4_14_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_14_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_14_FUNC_P4_14 = 0x0
	// External memory address line 14.
	IOCON_P4_14_FUNC_EMC_A_14 = 0x1
	// Position of MODE field.
	IOCON_P4_14_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_14_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_14_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_14_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_14_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_14_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_14_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_14_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_14_HYS = 0x20
	// Disable.
	IOCON_P4_14_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_14_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_14_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_14_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_14_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_14_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_14_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_14_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_14_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_14_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_14_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_14_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_14_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_14_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_14_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_14_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_14_OD = 0x400
	// Disable.
	IOCON_P4_14_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_14_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_14_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_14_RESERVED_Msk = 0xfffff800

	// P4_15: I/O configuration register for pin P4[15]
	// Position of FUNC field.
	IOCON_P4_15_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_15_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_15_FUNC_P4_15 = 0x0
	// External memory address line 15.
	IOCON_P4_15_FUNC_EMC_A_15 = 0x1
	// Position of MODE field.
	IOCON_P4_15_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_15_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_15_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_15_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_15_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_15_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_15_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_15_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_15_HYS = 0x20
	// Disable.
	IOCON_P4_15_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_15_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_15_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_15_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_15_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_15_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_15_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_15_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_15_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_15_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_15_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_15_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_15_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_15_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_15_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_15_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_15_OD = 0x400
	// Disable.
	IOCON_P4_15_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_15_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_15_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_15_RESERVED_Msk = 0xfffff800

	// P4_16: I/O configuration register for pin P4[16]
	// Position of FUNC field.
	IOCON_P4_16_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_16_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_16_FUNC_P4_16 = 0x0
	// External memory address line 16.
	IOCON_P4_16_FUNC_EMC_A_16 = 0x1
	// Position of MODE field.
	IOCON_P4_16_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_16_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_16_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_16_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_16_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_16_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_16_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_16_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_16_HYS = 0x20
	// Disable.
	IOCON_P4_16_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_16_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_16_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_16_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_16_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_16_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_16_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_16_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_16_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_16_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_16_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_16_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_16_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_16_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_16_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_16_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_16_OD = 0x400
	// Disable.
	IOCON_P4_16_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_16_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_16_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_16_RESERVED_Msk = 0xfffff800

	// P4_17: I/O configuration register for pin P4[17]
	// Position of FUNC field.
	IOCON_P4_17_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_17_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_17_FUNC_P4_17 = 0x0
	// External memory address line 17.
	IOCON_P4_17_FUNC_EMC_A_17 = 0x1
	// Position of MODE field.
	IOCON_P4_17_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_17_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_17_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_17_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_17_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_17_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_17_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_17_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_17_HYS = 0x20
	// Disable.
	IOCON_P4_17_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_17_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_17_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_17_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_17_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_17_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_17_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_17_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_17_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_17_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_17_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_17_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_17_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_17_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_17_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_17_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_17_OD = 0x400
	// Disable.
	IOCON_P4_17_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_17_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_17_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_17_RESERVED_Msk = 0xfffff800

	// P4_18: I/O configuration register for pin P4[18]
	// Position of FUNC field.
	IOCON_P4_18_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_18_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_18_FUNC_P4_18 = 0x0
	// External memory address line 18.
	IOCON_P4_18_FUNC_EMC_A_18 = 0x1
	// Position of MODE field.
	IOCON_P4_18_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_18_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_18_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_18_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_18_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_18_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_18_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_18_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_18_HYS = 0x20
	// Disable.
	IOCON_P4_18_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_18_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_18_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_18_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_18_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_18_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_18_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_18_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_18_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_18_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_18_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_18_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_18_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_18_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_18_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_18_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_18_OD = 0x400
	// Disable.
	IOCON_P4_18_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_18_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_18_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_18_RESERVED_Msk = 0xfffff800

	// P4_19: I/O configuration register for pin P4[19]
	// Position of FUNC field.
	IOCON_P4_19_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_19_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_19_FUNC_P4_19 = 0x0
	// External memory address line 19.
	IOCON_P4_19_FUNC_EMC_A_19 = 0x1
	// Position of MODE field.
	IOCON_P4_19_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_19_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_19_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_19_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_19_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_19_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_19_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_19_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_19_HYS = 0x20
	// Disable.
	IOCON_P4_19_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_19_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_19_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_19_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_19_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_19_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_19_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_19_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_19_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_19_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_19_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_19_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_19_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_19_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_19_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_19_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_19_OD = 0x400
	// Disable.
	IOCON_P4_19_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_19_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_19_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_19_RESERVED_Msk = 0xfffff800

	// P4_20: I/O configuration register for pin P4[20]
	// Position of FUNC field.
	IOCON_P4_20_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_20_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_20_FUNC_P4_20 = 0x0
	// External memory address line 20.
	IOCON_P4_20_FUNC_EMC_A_20 = 0x1
	// I2C2 data input/output (this pin does not use a specialized I2C pad).
	IOCON_P4_20_FUNC_I2C2_SDA = 0x2
	// Serial Clock for SSP1.
	IOCON_P4_20_FUNC_SSP1_SCK = 0x3
	// Position of MODE field.
	IOCON_P4_20_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_20_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_20_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_20_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_20_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_20_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_20_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_20_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_20_HYS = 0x20
	// Disable.
	IOCON_P4_20_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_20_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_20_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_20_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_20_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_20_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_20_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_20_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_20_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_20_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_20_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_20_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_20_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_20_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_20_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_20_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_20_OD = 0x400
	// Disable.
	IOCON_P4_20_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_20_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_20_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_20_RESERVED_Msk = 0xfffff800

	// P4_21: I/O configuration register for pin P4[21]
	// Position of FUNC field.
	IOCON_P4_21_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_21_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_21_FUNC_P4_21 = 0x0
	// External memory address line 21.
	IOCON_P4_21_FUNC_EMC_A_21 = 0x1
	// I2C2 clock input/output (this pin does not use a specialized I2C pad).
	IOCON_P4_21_FUNC_I2C2_SCL = 0x2
	// Slave Select for SSP1.
	IOCON_P4_21_FUNC_SSP1_SSEL = 0x3
	// Position of MODE field.
	IOCON_P4_21_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_21_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_21_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_21_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_21_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_21_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_21_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_21_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_21_HYS = 0x20
	// Disable.
	IOCON_P4_21_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_21_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_21_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_21_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_21_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_21_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_21_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_21_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_21_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_21_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_21_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_21_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_21_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_21_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_21_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_21_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_21_OD = 0x400
	// Disable.
	IOCON_P4_21_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_21_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_21_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_21_RESERVED_Msk = 0xfffff800

	// P4_22: I/O configuration register for pin P4[22]
	// Position of FUNC field.
	IOCON_P4_22_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_22_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_22_FUNC_P4_22 = 0x0
	// External memory address line 22.
	IOCON_P4_22_FUNC_EMC_A_22 = 0x1
	// Transmitter output for UART2.
	IOCON_P4_22_FUNC_U2_TXD = 0x2
	// Master In Slave Out for SSP1.
	IOCON_P4_22_FUNC_SSP1_MISO = 0x3
	// Position of MODE field.
	IOCON_P4_22_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_22_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_22_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_22_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_22_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_22_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_22_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_22_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_22_HYS = 0x20
	// Disable.
	IOCON_P4_22_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_22_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_22_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_22_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_22_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_22_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_22_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_22_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_22_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_22_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_22_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_22_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_22_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_22_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_22_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_22_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_22_OD = 0x400
	// Disable.
	IOCON_P4_22_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_22_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_22_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_22_RESERVED_Msk = 0xfffff800

	// P4_23: I/O configuration register for pin P4[23]
	// Position of FUNC field.
	IOCON_P4_23_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_23_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_23_FUNC_P4_23 = 0x0
	// External memory address line 23.
	IOCON_P4_23_FUNC_EMC_A_23 = 0x1
	// Receiver input for UART2.
	IOCON_P4_23_FUNC_U2_RXD = 0x2
	// Master Out Slave In for SSP1.
	IOCON_P4_23_FUNC_SSP1_MOSI = 0x3
	// Position of MODE field.
	IOCON_P4_23_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_23_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_23_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_23_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_23_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_23_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_23_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_23_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_23_HYS = 0x20
	// Disable.
	IOCON_P4_23_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_23_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_23_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_23_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_23_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_23_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_23_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_23_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_23_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_23_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_23_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_23_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_23_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_23_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_23_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_23_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_23_OD = 0x400
	// Disable.
	IOCON_P4_23_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_23_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_23_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_23_RESERVED_Msk = 0xfffff800

	// P4_24: I/O configuration register for pin P4[24]
	// Position of FUNC field.
	IOCON_P4_24_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_24_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_24_FUNC_P4_24 = 0x0
	// LOW active Output Enable signal.
	IOCON_P4_24_FUNC_EMC_OE = 0x1
	// Position of MODE field.
	IOCON_P4_24_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_24_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_24_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_24_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_24_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_24_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_24_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_24_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_24_HYS = 0x20
	// Disable.
	IOCON_P4_24_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_24_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_24_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_24_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_24_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_24_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_24_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_24_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_24_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_24_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_24_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_24_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_24_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_24_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_24_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_24_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_24_OD = 0x400
	// Disable.
	IOCON_P4_24_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_24_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_24_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_24_RESERVED_Msk = 0xfffff800

	// P4_25: I/O configuration register for pin P4[25]
	// Position of FUNC field.
	IOCON_P4_25_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_25_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_25_FUNC_P4_25 = 0x0
	// LOW active Write Enable signal.
	IOCON_P4_25_FUNC_EMC_WE = 0x1
	// Position of MODE field.
	IOCON_P4_25_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_25_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_25_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_25_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_25_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_25_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_25_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_25_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_25_HYS = 0x20
	// Disable.
	IOCON_P4_25_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_25_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_25_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_25_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_25_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_25_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_25_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_25_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_25_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_25_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_25_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_25_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_25_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_25_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_25_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_25_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_25_OD = 0x400
	// Disable.
	IOCON_P4_25_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_25_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_25_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_25_RESERVED_Msk = 0xfffff800

	// P4_26: I/O configuration register for pin P4[26]
	// Position of FUNC field.
	IOCON_P4_26_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_26_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_26_FUNC_P4_26 = 0x0
	// LOW active Byte Lane select signal 0.
	IOCON_P4_26_FUNC_EMC_BLS0 = 0x1
	// Position of MODE field.
	IOCON_P4_26_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_26_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_26_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_26_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_26_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_26_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_26_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_26_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_26_HYS = 0x20
	// Disable.
	IOCON_P4_26_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_26_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_26_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_26_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_26_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_26_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_26_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_26_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_26_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_26_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_26_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_26_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_26_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_26_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_26_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_26_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_26_OD = 0x400
	// Disable.
	IOCON_P4_26_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_26_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_26_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_26_RESERVED_Msk = 0xfffff800

	// P4_27: I/O configuration register for pin P4[27]
	// Position of FUNC field.
	IOCON_P4_27_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_27_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_27_FUNC_P4_27 = 0x0
	// LOW active Byte Lane select signal 1.
	IOCON_P4_27_FUNC_EMC_BLS1 = 0x1
	// Position of MODE field.
	IOCON_P4_27_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_27_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_27_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_27_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_27_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_27_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_27_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_27_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_27_HYS = 0x20
	// Disable.
	IOCON_P4_27_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_27_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_27_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_27_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_27_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_27_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_27_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_27_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_27_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_27_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_27_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_27_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_27_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_27_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_27_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_27_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_27_OD = 0x400
	// Disable.
	IOCON_P4_27_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_27_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_27_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_27_RESERVED_Msk = 0xfffff800

	// P4_28: I/O configuration register for pin P4[28]
	// Position of FUNC field.
	IOCON_P4_28_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_28_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_28_FUNC_P4_28 = 0x0
	// LOW active Byte Lane select signal 2.
	IOCON_P4_28_FUNC_EMC_BLS2 = 0x1
	// Transmitter output for UART3.
	IOCON_P4_28_FUNC_U3_TXD = 0x2
	// Match output for Timer 2, channel 0.
	IOCON_P4_28_FUNC_T2_MAT0 = 0x3
	// LCD data.
	IOCON_P4_28_FUNC_LCD_VD_6 = 0x5
	// LCD data.
	IOCON_P4_28_FUNC_LCD_VD_10 = 0x6
	// LCD data.
	IOCON_P4_28_FUNC_LCD_VD_2 = 0x7
	// Position of MODE field.
	IOCON_P4_28_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_28_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_28_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_28_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_28_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_28_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_28_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_28_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_28_HYS = 0x20
	// Disable.
	IOCON_P4_28_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_28_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_28_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_28_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_28_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_28_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_28_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_28_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_28_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_28_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_28_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_28_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_28_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_28_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_28_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_28_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_28_OD = 0x400
	// Disable.
	IOCON_P4_28_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_28_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_28_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_28_RESERVED_Msk = 0xfffff800

	// P4_29: I/O configuration register for pin P4[29]
	// Position of FUNC field.
	IOCON_P4_29_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_29_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_29_FUNC_P4_29 = 0x0
	// LOW active Byte Lane select signal 3.
	IOCON_P4_29_FUNC_EMC_BLS3 = 0x1
	// Receiver input for UART3.
	IOCON_P4_29_FUNC_U3_RXD = 0x2
	// Match output for Timer 2, channel 1.
	IOCON_P4_29_FUNC_T2_MAT1 = 0x3
	// I2C2 clock input/output (this pin does not use a specialized I2C pad).
	IOCON_P4_29_FUNC_I2C2_SCL = 0x4
	// LCD data.
	IOCON_P4_29_FUNC_LCD_VD_7 = 0x5
	// LCD data.
	IOCON_P4_29_FUNC_LCD_VD_11 = 0x6
	// LCD data.
	IOCON_P4_29_FUNC_LCD_VD_3 = 0x7
	// Position of MODE field.
	IOCON_P4_29_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_29_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_29_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_29_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_29_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_29_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_29_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_29_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_29_HYS = 0x20
	// Disable.
	IOCON_P4_29_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_29_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_29_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_29_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_29_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_29_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_29_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_29_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_29_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_29_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_29_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_29_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_29_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_29_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_29_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_29_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_29_OD = 0x400
	// Disable.
	IOCON_P4_29_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_29_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_29_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_29_RESERVED_Msk = 0xfffff800

	// P4_30: I/O configuration register for pin P4[30]
	// Position of FUNC field.
	IOCON_P4_30_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_30_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_30_FUNC_P4_30 = 0x0
	// LOW active Chip Select 0 signal.
	IOCON_P4_30_FUNC_EMC_CS0 = 0x1
	// Position of MODE field.
	IOCON_P4_30_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_30_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_30_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_30_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_30_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_30_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_30_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_30_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_30_HYS = 0x20
	// Disable.
	IOCON_P4_30_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_30_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_30_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_30_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_30_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_30_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_30_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_30_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_30_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_30_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_30_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_30_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_30_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_30_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_30_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_30_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_30_OD = 0x400
	// Disable.
	IOCON_P4_30_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_30_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_30_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_30_RESERVED_Msk = 0xfffff800

	// P4_31: I/O configuration register for pin P4[31]
	// Position of FUNC field.
	IOCON_P4_31_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P4_31_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P4_31_FUNC_P4_31 = 0x0
	// LOW active Chip Select 1 signal.
	IOCON_P4_31_FUNC_EMC_CS1 = 0x1
	// Position of MODE field.
	IOCON_P4_31_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P4_31_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P4_31_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P4_31_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P4_31_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P4_31_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P4_31_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P4_31_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P4_31_HYS = 0x20
	// Disable.
	IOCON_P4_31_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P4_31_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P4_31_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P4_31_INV_Msk = 0x40
	// Bit INV.
	IOCON_P4_31_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P4_31_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P4_31_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P4_31_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P4_31_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P4_31_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P4_31_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P4_31_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P4_31_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P4_31_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P4_31_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P4_31_OD_Msk = 0x400
	// Bit OD.
	IOCON_P4_31_OD = 0x400
	// Disable.
	IOCON_P4_31_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P4_31_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P4_31_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P4_31_RESERVED_Msk = 0xfffff800

	// P5_0: I/O configuration register for pin P5[0]
	// Position of FUNC field.
	IOCON_P5_0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P5_0_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P5_0_FUNC_P5_0 = 0x0
	// External memory address line 24.
	IOCON_P5_0_FUNC_EMC_A_24 = 0x1
	// Master Out Slave In for SSP2.
	IOCON_P5_0_FUNC_SSP2_MOSI = 0x2
	// Match output for Timer 2, channel 2.
	IOCON_P5_0_FUNC_T2_MAT2 = 0x3
	// Position of MODE field.
	IOCON_P5_0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P5_0_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P5_0_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P5_0_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P5_0_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P5_0_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P5_0_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P5_0_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P5_0_HYS = 0x20
	// Disable.
	IOCON_P5_0_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P5_0_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P5_0_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P5_0_INV_Msk = 0x40
	// Bit INV.
	IOCON_P5_0_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P5_0_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P5_0_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P5_0_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P5_0_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P5_0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P5_0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P5_0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P5_0_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P5_0_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P5_0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P5_0_OD_Msk = 0x400
	// Bit OD.
	IOCON_P5_0_OD = 0x400
	// Disable.
	IOCON_P5_0_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P5_0_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P5_0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P5_0_RESERVED_Msk = 0xfffff800

	// P5_1: I/O configuration register for pin P5[1]
	// Position of FUNC field.
	IOCON_P5_1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P5_1_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P5_1_FUNC_P5_1 = 0x0
	// External memory address line 25.
	IOCON_P5_1_FUNC_EMC_A_25 = 0x1
	// Master In Slave Out for SSP2.
	IOCON_P5_1_FUNC_SSP2_MISO = 0x2
	// Match output for Timer 2, channel 3.
	IOCON_P5_1_FUNC_T2_MAT3 = 0x3
	// Position of MODE field.
	IOCON_P5_1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P5_1_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P5_1_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P5_1_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P5_1_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P5_1_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P5_1_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P5_1_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P5_1_HYS = 0x20
	// Disable.
	IOCON_P5_1_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P5_1_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P5_1_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P5_1_INV_Msk = 0x40
	// Bit INV.
	IOCON_P5_1_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P5_1_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P5_1_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P5_1_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P5_1_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P5_1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P5_1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P5_1_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P5_1_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P5_1_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P5_1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P5_1_OD_Msk = 0x400
	// Bit OD.
	IOCON_P5_1_OD = 0x400
	// Disable.
	IOCON_P5_1_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P5_1_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P5_1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P5_1_RESERVED_Msk = 0xfffff800

	// P5_2: I/O configuration register for pin P5[2]
	// Position of FUNC field.
	IOCON_P5_2_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P5_2_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P5_2_FUNC_P5_2 = 0x0
	// Match output for Timer 3, channel 2.
	IOCON_P5_2_FUNC_T3_MAT2 = 0x3
	// I2C0 data input/output (this pin uses a specialized I2C pad that supports I2C Fast Mode Plus).
	IOCON_P5_2_FUNC_I2C0_SDA = 0x5
	// Position of RESERVED field.
	IOCON_P5_2_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_P5_2_RESERVED_Msk = 0x38
	// Position of INV field.
	IOCON_P5_2_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P5_2_INV_Msk = 0x40
	// Bit INV.
	IOCON_P5_2_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P5_2_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P5_2_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P5_2_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P5_2_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_P5_2_RESERVED = 0x80
	// Position of HS field.
	IOCON_P5_2_HS_Pos = 0x8
	// Bit mask of HS field.
	IOCON_P5_2_HS_Msk = 0x100
	// Bit HS.
	IOCON_P5_2_HS = 0x100
	// I2C 50ns glitch filter and slew rate control enabled.
	IOCON_P5_2_HS_ENABLED = 0x0
	// I2C 50ns glitch filter and slew rate control disabled.
	IOCON_P5_2_HS_DISABLED = 0x1
	// Position of HIDRIVE field.
	IOCON_P5_2_HIDRIVE_Pos = 0x9
	// Bit mask of HIDRIVE field.
	IOCON_P5_2_HIDRIVE_Msk = 0x200
	// Bit HIDRIVE.
	IOCON_P5_2_HIDRIVE = 0x200
	// Output drive sink is 4 mA. This is sufficient for standard and fast mode I2C.
	IOCON_P5_2_HIDRIVE_LOWDRIVE = 0x0
	// Output drive sink is 20 mA. This is needed for Fast Mode Plus I2C. Refer to the appropriate specific device data sheet for details.
	IOCON_P5_2_HIDRIVE_HIGHDRIVE = 0x1
	// Position of RESERVED field.
	IOCON_P5_2_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_P5_2_RESERVED_Msk = 0xfffffc00

	// P5_3: I/O configuration register for pin P5[3]
	// Position of FUNC field.
	IOCON_P5_3_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P5_3_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P5_3_FUNC_P5_3 = 0x0
	// Receiver input for USART4.
	IOCON_P5_3_FUNC_U4_RXD = 0x4
	// I2C0 clock input/output (this pin uses a specialized I2C pad that supports I2C Fast Mode Plus.
	IOCON_P5_3_FUNC_I2C0_SCL = 0x5
	// Position of RESERVED field.
	IOCON_P5_3_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_P5_3_RESERVED_Msk = 0x38
	// Position of INV field.
	IOCON_P5_3_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P5_3_INV_Msk = 0x40
	// Bit INV.
	IOCON_P5_3_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P5_3_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P5_3_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P5_3_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P5_3_RESERVED_Msk = 0x80
	// Bit RESERVED.
	IOCON_P5_3_RESERVED = 0x80
	// Position of HS field.
	IOCON_P5_3_HS_Pos = 0x8
	// Bit mask of HS field.
	IOCON_P5_3_HS_Msk = 0x100
	// Bit HS.
	IOCON_P5_3_HS = 0x100
	// I2C 50ns glitch filter and slew rate control enabled.
	IOCON_P5_3_HS_ENABLED = 0x0
	// I2C 50ns glitch filter and slew rate control disabled.
	IOCON_P5_3_HS_DISABLED = 0x1
	// Position of HIDRIVE field.
	IOCON_P5_3_HIDRIVE_Pos = 0x9
	// Bit mask of HIDRIVE field.
	IOCON_P5_3_HIDRIVE_Msk = 0x200
	// Bit HIDRIVE.
	IOCON_P5_3_HIDRIVE = 0x200
	// Output drive sink is 4 mA. This is sufficient for standard and fast mode I2C.
	IOCON_P5_3_HIDRIVE_LOWDRIVE = 0x0
	// Output drive sink is 20 mA. This is needed for Fast Mode Plus I2C. Refer to the appropriate specific device data sheet for details.
	IOCON_P5_3_HIDRIVE_HIGHDRIVE = 0x1
	// Position of RESERVED field.
	IOCON_P5_3_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	IOCON_P5_3_RESERVED_Msk = 0xfffffc00

	// P5_4: I/O configuration register for pin P5[4]
	// Position of FUNC field.
	IOCON_P5_4_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_P5_4_FUNC_Msk = 0x7
	// General purpose digital input/output pin.
	IOCON_P5_4_FUNC_P5_4 = 0x0
	// RS-485/EIA-485 output enable signal for UART0.
	IOCON_P5_4_FUNC_U0_OE = 0x1
	// Match output for Timer 3, channel 3.
	IOCON_P5_4_FUNC_T3_MAT3 = 0x3
	// Transmitter output for USART4 (input/output in smart card mode).
	IOCON_P5_4_FUNC_U4_TXD = 0x4
	// Position of MODE field.
	IOCON_P5_4_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_P5_4_MODE_Msk = 0x18
	// Inactive (no pull-down/pull-up resistor enabled).
	IOCON_P5_4_MODE_INACTIVE_NO_PULL_DO = 0x0
	// Pull-down resistor enabled.
	IOCON_P5_4_MODE_PULL_DOWN_RESISTOR_E = 0x1
	// Pull-up resistor enabled.
	IOCON_P5_4_MODE_PULL_UP_RESISTOR_ENA = 0x2
	// Repeater mode.
	IOCON_P5_4_MODE_REPEATER_MODE_ = 0x3
	// Position of HYS field.
	IOCON_P5_4_HYS_Pos = 0x5
	// Bit mask of HYS field.
	IOCON_P5_4_HYS_Msk = 0x20
	// Bit HYS.
	IOCON_P5_4_HYS = 0x20
	// Disable.
	IOCON_P5_4_HYS_DISABLE_ = 0x0
	// Enable.
	IOCON_P5_4_HYS_ENABLE_ = 0x1
	// Position of INV field.
	IOCON_P5_4_INV_Pos = 0x6
	// Bit mask of INV field.
	IOCON_P5_4_INV_Msk = 0x40
	// Bit INV.
	IOCON_P5_4_INV = 0x40
	// Input not inverted (HIGH on pin reads as 1, LOW on pin reads as 0).
	IOCON_P5_4_INV_INPUT_NOT_INVERTED_ = 0x0
	// Input inverted (HIGH on pin reads as 0, LOW on pin reads as 1).
	IOCON_P5_4_INV_INPUT_INVERTED_HIGH = 0x1
	// Position of RESERVED field.
	IOCON_P5_4_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	IOCON_P5_4_RESERVED_Msk = 0x180
	// Position of SLEW field.
	IOCON_P5_4_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_P5_4_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_P5_4_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_P5_4_SLEW_STANDARD = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_P5_4_SLEW_FAST = 0x1
	// Position of OD field.
	IOCON_P5_4_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_P5_4_OD_Msk = 0x400
	// Bit OD.
	IOCON_P5_4_OD = 0x400
	// Disable.
	IOCON_P5_4_OD_DISABLE_ = 0x0
	// Open-drain mode enabled. This is not a true open-drain mode. Input cannot be pulled up above VDD.
	IOCON_P5_4_OD_OPEN_DRAIN_MODE_ENAB = 0x1
	// Position of RESERVED field.
	IOCON_P5_4_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_P5_4_RESERVED_Msk = 0xfffff800
)

// Bitfields for SSP1: SSP1 controller
const (
	// CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
	// Position of DSS field.
	SSP1_CR0_DSS_Pos = 0x0
	// Bit mask of DSS field.
	SSP1_CR0_DSS_Msk = 0xf
	// 4-bit transfer
	SSP1_CR0_DSS_4_BIT_TRANSFER = 0x3
	// 5-bit transfer
	SSP1_CR0_DSS_5_BIT_TRANSFER = 0x4
	// 6-bit transfer
	SSP1_CR0_DSS_6_BIT_TRANSFER = 0x5
	// 7-bit transfer
	SSP1_CR0_DSS_7_BIT_TRANSFER = 0x6
	// 8-bit transfer
	SSP1_CR0_DSS_8_BIT_TRANSFER = 0x7
	// 9-bit transfer
	SSP1_CR0_DSS_9_BIT_TRANSFER = 0x8
	// 10-bit transfer
	SSP1_CR0_DSS_10_BIT_TRANSFER = 0x9
	// 11-bit transfer
	SSP1_CR0_DSS_11_BIT_TRANSFER = 0xa
	// 12-bit transfer
	SSP1_CR0_DSS_12_BIT_TRANSFER = 0xb
	// 13-bit transfer
	SSP1_CR0_DSS_13_BIT_TRANSFER = 0xc
	// 14-bit transfer
	SSP1_CR0_DSS_14_BIT_TRANSFER = 0xd
	// 15-bit transfer
	SSP1_CR0_DSS_15_BIT_TRANSFER = 0xe
	// 16-bit transfer
	SSP1_CR0_DSS_16_BIT_TRANSFER = 0xf
	// Position of FRF field.
	SSP1_CR0_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SSP1_CR0_FRF_Msk = 0x30
	// SPI
	SSP1_CR0_FRF_SPI = 0x0
	// TI
	SSP1_CR0_FRF_TI = 0x1
	// Microwire
	SSP1_CR0_FRF_MICROWIRE = 0x2
	// This combination is not supported and should not be used.
	SSP1_CR0_FRF_THIS_COMBINATION_IS_ = 0x3
	// Position of CPOL field.
	SSP1_CR0_CPOL_Pos = 0x6
	// Bit mask of CPOL field.
	SSP1_CR0_CPOL_Msk = 0x40
	// Bit CPOL.
	SSP1_CR0_CPOL = 0x40
	// SSP controller maintains the bus clock low between frames.
	SSP1_CR0_CPOL_BUS_LOW = 0x0
	// SSP controller maintains the bus clock high between frames.
	SSP1_CR0_CPOL_BUS_HIGH = 0x1
	// Position of CPHA field.
	SSP1_CR0_CPHA_Pos = 0x7
	// Bit mask of CPHA field.
	SSP1_CR0_CPHA_Msk = 0x80
	// Bit CPHA.
	SSP1_CR0_CPHA = 0x80
	// SSP controller captures serial data on the first clock transition of the frame, that is, the transition away from the inter-frame state of the clock line.
	SSP1_CR0_CPHA_FIRST_CLOCK = 0x0
	// SSP controller captures serial data on the second clock transition of the frame, that is, the transition back to the inter-frame state of the clock line.
	SSP1_CR0_CPHA_SECOND_CLOCK = 0x1
	// Position of SCR field.
	SSP1_CR0_SCR_Pos = 0x8
	// Bit mask of SCR field.
	SSP1_CR0_SCR_Msk = 0xff00
	// Position of RESERVED field.
	SSP1_CR0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP1_CR0_RESERVED_Msk = 0xffff0000

	// CR1: Control Register 1. Selects master/slave and other modes.
	// Position of LBM field.
	SSP1_CR1_LBM_Pos = 0x0
	// Bit mask of LBM field.
	SSP1_CR1_LBM_Msk = 0x1
	// Bit LBM.
	SSP1_CR1_LBM = 0x1
	// During normal operation.
	SSP1_CR1_LBM_NORMAL = 0x0
	// Serial input is taken from the serial output (MOSI or MISO) rather than the serial input pin (MISO or MOSI respectively).
	SSP1_CR1_LBM_OUPTU = 0x1
	// Position of SSE field.
	SSP1_CR1_SSE_Pos = 0x1
	// Bit mask of SSE field.
	SSP1_CR1_SSE_Msk = 0x2
	// Bit SSE.
	SSP1_CR1_SSE = 0x2
	// The SSP controller is disabled.
	SSP1_CR1_SSE_DISABLED = 0x0
	// The SSP controller will interact with other devices on the serial bus. Software should write the appropriate control information to the other SSP registers and interrupt controller registers, before setting this bit.
	SSP1_CR1_SSE_ENABLED = 0x1
	// Position of MS field.
	SSP1_CR1_MS_Pos = 0x2
	// Bit mask of MS field.
	SSP1_CR1_MS_Msk = 0x4
	// Bit MS.
	SSP1_CR1_MS = 0x4
	// The SSP controller acts as a master on the bus, driving the SCLK, MOSI, and SSEL lines and receiving the MISO line.
	SSP1_CR1_MS_MASTER = 0x0
	// The SSP controller acts as a slave on the bus, driving MISO line and receiving SCLK, MOSI, and SSEL lines.
	SSP1_CR1_MS_SLAVE = 0x1
	// Position of SOD field.
	SSP1_CR1_SOD_Pos = 0x3
	// Bit mask of SOD field.
	SSP1_CR1_SOD_Msk = 0x8
	// Bit SOD.
	SSP1_CR1_SOD = 0x8
	// Position of RESERVED field.
	SSP1_CR1_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP1_CR1_RESERVED_Msk = 0xfffffff0

	// DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
	// Position of DATA field.
	SSP1_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SSP1_DR_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SSP1_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SSP1_DR_RESERVED_Msk = 0xffff0000

	// SR: Status Register
	// Position of TFE field.
	SSP1_SR_TFE_Pos = 0x0
	// Bit mask of TFE field.
	SSP1_SR_TFE_Msk = 0x1
	// Bit TFE.
	SSP1_SR_TFE = 0x1
	// Position of TNF field.
	SSP1_SR_TNF_Pos = 0x1
	// Bit mask of TNF field.
	SSP1_SR_TNF_Msk = 0x2
	// Bit TNF.
	SSP1_SR_TNF = 0x2
	// Position of RNE field.
	SSP1_SR_RNE_Pos = 0x2
	// Bit mask of RNE field.
	SSP1_SR_RNE_Msk = 0x4
	// Bit RNE.
	SSP1_SR_RNE = 0x4
	// Position of RFF field.
	SSP1_SR_RFF_Pos = 0x3
	// Bit mask of RFF field.
	SSP1_SR_RFF_Msk = 0x8
	// Bit RFF.
	SSP1_SR_RFF = 0x8
	// Position of BSY field.
	SSP1_SR_BSY_Pos = 0x4
	// Bit mask of BSY field.
	SSP1_SR_BSY_Msk = 0x10
	// Bit BSY.
	SSP1_SR_BSY = 0x10
	// Position of RESERVED field.
	SSP1_SR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SSP1_SR_RESERVED_Msk = 0xffffffe0

	// CPSR: Clock Prescale Register
	// Position of CPSDVSR field.
	SSP1_CPSR_CPSDVSR_Pos = 0x0
	// Bit mask of CPSDVSR field.
	SSP1_CPSR_CPSDVSR_Msk = 0xff
	// Position of RESERVED field.
	SSP1_CPSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SSP1_CPSR_RESERVED_Msk = 0xffffff00

	// IMSC: Interrupt Mask Set and Clear Register
	// Position of RORIM field.
	SSP1_IMSC_RORIM_Pos = 0x0
	// Bit mask of RORIM field.
	SSP1_IMSC_RORIM_Msk = 0x1
	// Bit RORIM.
	SSP1_IMSC_RORIM = 0x1
	// Position of RTIM field.
	SSP1_IMSC_RTIM_Pos = 0x1
	// Bit mask of RTIM field.
	SSP1_IMSC_RTIM_Msk = 0x2
	// Bit RTIM.
	SSP1_IMSC_RTIM = 0x2
	// Position of RXIM field.
	SSP1_IMSC_RXIM_Pos = 0x2
	// Bit mask of RXIM field.
	SSP1_IMSC_RXIM_Msk = 0x4
	// Bit RXIM.
	SSP1_IMSC_RXIM = 0x4
	// Position of TXIM field.
	SSP1_IMSC_TXIM_Pos = 0x3
	// Bit mask of TXIM field.
	SSP1_IMSC_TXIM_Msk = 0x8
	// Bit TXIM.
	SSP1_IMSC_TXIM = 0x8
	// Position of RESERVED field.
	SSP1_IMSC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP1_IMSC_RESERVED_Msk = 0xfffffff0

	// RIS: Raw Interrupt Status Register
	// Position of RORRIS field.
	SSP1_RIS_RORRIS_Pos = 0x0
	// Bit mask of RORRIS field.
	SSP1_RIS_RORRIS_Msk = 0x1
	// Bit RORRIS.
	SSP1_RIS_RORRIS = 0x1
	// Position of RTRIS field.
	SSP1_RIS_RTRIS_Pos = 0x1
	// Bit mask of RTRIS field.
	SSP1_RIS_RTRIS_Msk = 0x2
	// Bit RTRIS.
	SSP1_RIS_RTRIS = 0x2
	// Position of RXRIS field.
	SSP1_RIS_RXRIS_Pos = 0x2
	// Bit mask of RXRIS field.
	SSP1_RIS_RXRIS_Msk = 0x4
	// Bit RXRIS.
	SSP1_RIS_RXRIS = 0x4
	// Position of TXRIS field.
	SSP1_RIS_TXRIS_Pos = 0x3
	// Bit mask of TXRIS field.
	SSP1_RIS_TXRIS_Msk = 0x8
	// Bit TXRIS.
	SSP1_RIS_TXRIS = 0x8
	// Position of RESERVED field.
	SSP1_RIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP1_RIS_RESERVED_Msk = 0xfffffff0

	// MIS: Masked Interrupt Status Register
	// Position of RORMIS field.
	SSP1_MIS_RORMIS_Pos = 0x0
	// Bit mask of RORMIS field.
	SSP1_MIS_RORMIS_Msk = 0x1
	// Bit RORMIS.
	SSP1_MIS_RORMIS = 0x1
	// Position of RTMIS field.
	SSP1_MIS_RTMIS_Pos = 0x1
	// Bit mask of RTMIS field.
	SSP1_MIS_RTMIS_Msk = 0x2
	// Bit RTMIS.
	SSP1_MIS_RTMIS = 0x2
	// Position of RXMIS field.
	SSP1_MIS_RXMIS_Pos = 0x2
	// Bit mask of RXMIS field.
	SSP1_MIS_RXMIS_Msk = 0x4
	// Bit RXMIS.
	SSP1_MIS_RXMIS = 0x4
	// Position of TXMIS field.
	SSP1_MIS_TXMIS_Pos = 0x3
	// Bit mask of TXMIS field.
	SSP1_MIS_TXMIS_Msk = 0x8
	// Bit TXMIS.
	SSP1_MIS_TXMIS = 0x8
	// Position of RESERVED field.
	SSP1_MIS_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	SSP1_MIS_RESERVED_Msk = 0xfffffff0

	// ICR: SSPICR Interrupt Clear Register
	// Position of RORIC field.
	SSP1_ICR_RORIC_Pos = 0x0
	// Bit mask of RORIC field.
	SSP1_ICR_RORIC_Msk = 0x1
	// Bit RORIC.
	SSP1_ICR_RORIC = 0x1
	// Position of RTIC field.
	SSP1_ICR_RTIC_Pos = 0x1
	// Bit mask of RTIC field.
	SSP1_ICR_RTIC_Msk = 0x2
	// Bit RTIC.
	SSP1_ICR_RTIC = 0x2
	// Position of RESERVED field.
	SSP1_ICR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SSP1_ICR_RESERVED_Msk = 0xfffffffc

	// DMACR: SSP0 DMA control register
	// Position of RXDMAE field.
	SSP1_DMACR_RXDMAE_Pos = 0x0
	// Bit mask of RXDMAE field.
	SSP1_DMACR_RXDMAE_Msk = 0x1
	// Bit RXDMAE.
	SSP1_DMACR_RXDMAE = 0x1
	// Position of TXDMAE field.
	SSP1_DMACR_TXDMAE_Pos = 0x1
	// Bit mask of TXDMAE field.
	SSP1_DMACR_TXDMAE_Msk = 0x2
	// Bit TXDMAE.
	SSP1_DMACR_TXDMAE = 0x2
	// Position of RESERVED field.
	SSP1_DMACR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SSP1_DMACR_RESERVED_Msk = 0xfffffffc
)

// Bitfields for ADC: Analog-to-Digital Converter (ADC)
const (
	// CR: A/D Control Register. The ADCR register must be written to select the operating mode before A/D conversion can occur.
	// Position of SEL field.
	ADC_CR_SEL_Pos = 0x0
	// Bit mask of SEL field.
	ADC_CR_SEL_Msk = 0xff
	// Position of CLKDIV field.
	ADC_CR_CLKDIV_Pos = 0x8
	// Bit mask of CLKDIV field.
	ADC_CR_CLKDIV_Msk = 0xff00
	// Position of BURST field.
	ADC_CR_BURST_Pos = 0x10
	// Bit mask of BURST field.
	ADC_CR_BURST_Msk = 0x10000
	// Bit BURST.
	ADC_CR_BURST = 0x10000
	// The AD converter does repeated conversions at up to 400 kHz, scanning (if necessary) through the pins selected by bits set to ones in the SEL field. The first conversion after the start corresponds to the least-significant 1 in the SEL field, then higher numbered 1-bits (pins) if applicable. Repeated conversions can be terminated by clearing this bit, but the conversion that's in progress when this bit is cleared will be completed. START bits must be 000 when BURST = 1 or conversions will not start.
	ADC_CR_BURST_BURST = 0x1
	// Conversions are software controlled and require 31 clocks.
	ADC_CR_BURST_SW = 0x0
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0x1e0000
	// Position of PDN field.
	ADC_CR_PDN_Pos = 0x15
	// Bit mask of PDN field.
	ADC_CR_PDN_Msk = 0x200000
	// Bit PDN.
	ADC_CR_PDN = 0x200000
	// The A/D converter is operational.
	ADC_CR_PDN_POWERED = 0x1
	// The A/D converter is in power-down mode.
	ADC_CR_PDN_POWERDOWN = 0x0
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0xc00000
	// Position of START field.
	ADC_CR_START_Pos = 0x18
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x7000000
	// No start (this value should be used when clearing PDN to 0).
	ADC_CR_START_NO_START_THIS_VALUE = 0x0
	// Start conversion now.
	ADC_CR_START_START_CONVERSION_NOW = 0x1
	// Start conversion when the edge selected by bit 27 occurs on the P2[10] pin.
	ADC_CR_START_P2_10 = 0x2
	// Start conversion when the edge selected by bit 27 occurs on the P1[27] pin.
	ADC_CR_START_P1_27 = 0x3
	// Start conversion when the edge selected by bit 27 occurs on MAT0.1. Note that this does not require that the MAT0.1 function appear on a device pin.
	ADC_CR_START_MAT0_1 = 0x4
	// Start conversion when the edge selected by bit 27 occurs on MAT0.3. Note that it is not possible to cause the MAT0.3 function to appear on a device pin.
	ADC_CR_START_MAT0_3 = 0x5
	// Start conversion when the edge selected by bit 27 occurs on MAT1.0. Note that this does not require that the MAT1.0 function appear on a device pin.
	ADC_CR_START_MAT1_0 = 0x6
	// Start conversion when the edge selected by bit 27 occurs on MAT1.1. Note that this does not require that the MAT1.1 function appear on a device pin.
	ADC_CR_START_MAT1_1 = 0x7
	// Position of EDGE field.
	ADC_CR_EDGE_Pos = 0x1b
	// Bit mask of EDGE field.
	ADC_CR_EDGE_Msk = 0x8000000
	// Bit EDGE.
	ADC_CR_EDGE = 0x8000000
	// Start conversion on a falling edge on the selected CAP/MAT signal.
	ADC_CR_EDGE_FALLLING = 0x1
	// Start conversion on a rising edge on the selected CAP/MAT signal.
	ADC_CR_EDGE_RISING = 0x0
	// Position of RESERVED field.
	ADC_CR_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	ADC_CR_RESERVED_Msk = 0xf0000000

	// GDR: A/D Global Data Register. This register contains the ADC's DONE bit and the result of the most recent A/D conversion.
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_GDR_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_GDR_RESULT_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0xff0000
	// Position of CHN field.
	ADC_GDR_CHN_Pos = 0x18
	// Bit mask of CHN field.
	ADC_GDR_CHN_Msk = 0x7000000
	// Position of RESERVED field.
	ADC_GDR_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0x38000000
	// Position of OVERRUN field.
	ADC_GDR_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_GDR_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_GDR_OVERRUN = 0x40000000
	// Position of DONE field.
	ADC_GDR_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	ADC_GDR_DONE_Msk = 0x80000000
	// Bit DONE.
	ADC_GDR_DONE = 0x80000000

	// INTEN: A/D Interrupt Enable Register. This register contains enable bits that allow the DONE flag of each A/D channel to be included or excluded from contributing to the generation of an A/D interrupt.
	// Position of ADINTEN0 field.
	ADC_INTEN_ADINTEN0_Pos = 0x0
	// Bit mask of ADINTEN0 field.
	ADC_INTEN_ADINTEN0_Msk = 0x1
	// Bit ADINTEN0.
	ADC_INTEN_ADINTEN0 = 0x1
	// Completion of a conversion on ADC channel 0 will not generate an interrupt.
	ADC_INTEN_ADINTEN0_DISABLE = 0x0
	// Completion of a conversion on ADC channel 0 will generate an interrupt.
	ADC_INTEN_ADINTEN0_ENABLE = 0x1
	// Position of ADINTEN1 field.
	ADC_INTEN_ADINTEN1_Pos = 0x1
	// Bit mask of ADINTEN1 field.
	ADC_INTEN_ADINTEN1_Msk = 0x2
	// Bit ADINTEN1.
	ADC_INTEN_ADINTEN1 = 0x2
	// Completion of a conversion on ADC channel 1 will not generate an interrupt.
	ADC_INTEN_ADINTEN1_DISABLE = 0x0
	// Completion of a conversion on ADC channel 1 will generate an interrupt.
	ADC_INTEN_ADINTEN1_ENABLE = 0x1
	// Position of ADINTEN2 field.
	ADC_INTEN_ADINTEN2_Pos = 0x2
	// Bit mask of ADINTEN2 field.
	ADC_INTEN_ADINTEN2_Msk = 0x4
	// Bit ADINTEN2.
	ADC_INTEN_ADINTEN2 = 0x4
	// Completion of a conversion on ADC channel 2 will not generate an interrupt.
	ADC_INTEN_ADINTEN2_DISABLE = 0x0
	// Completion of a conversion on ADC channel 2 will generate an interrupt.
	ADC_INTEN_ADINTEN2_ENABLE = 0x1
	// Position of ADINTEN3 field.
	ADC_INTEN_ADINTEN3_Pos = 0x3
	// Bit mask of ADINTEN3 field.
	ADC_INTEN_ADINTEN3_Msk = 0x8
	// Bit ADINTEN3.
	ADC_INTEN_ADINTEN3 = 0x8
	// Completion of a conversion on ADC channel 3 will not generate an interrupt.
	ADC_INTEN_ADINTEN3_DISABLE = 0x0
	// Completion of a conversion on ADC channel 3 will generate an interrupt.
	ADC_INTEN_ADINTEN3_ENABLE = 0x1
	// Position of ADINTEN4 field.
	ADC_INTEN_ADINTEN4_Pos = 0x4
	// Bit mask of ADINTEN4 field.
	ADC_INTEN_ADINTEN4_Msk = 0x10
	// Bit ADINTEN4.
	ADC_INTEN_ADINTEN4 = 0x10
	// Completion of a conversion on ADC channel 4 will not generate an interrupt.
	ADC_INTEN_ADINTEN4_DISABLE = 0x0
	// Completion of a conversion on ADC channel 4 will generate an interrupt.
	ADC_INTEN_ADINTEN4_ENABLE = 0x1
	// Position of ADINTEN5 field.
	ADC_INTEN_ADINTEN5_Pos = 0x5
	// Bit mask of ADINTEN5 field.
	ADC_INTEN_ADINTEN5_Msk = 0x20
	// Bit ADINTEN5.
	ADC_INTEN_ADINTEN5 = 0x20
	// Completion of a conversion on ADC channel 5 will not generate an interrupt.
	ADC_INTEN_ADINTEN5_DISABLE = 0x0
	// Completion of a conversion on ADC channel 5 will generate an interrupt.
	ADC_INTEN_ADINTEN5_ENABLE = 0x1
	// Position of ADINTEN6 field.
	ADC_INTEN_ADINTEN6_Pos = 0x6
	// Bit mask of ADINTEN6 field.
	ADC_INTEN_ADINTEN6_Msk = 0x40
	// Bit ADINTEN6.
	ADC_INTEN_ADINTEN6 = 0x40
	// Completion of a conversion on ADC channel 6 will not generate an interrupt.
	ADC_INTEN_ADINTEN6_DISABLE = 0x0
	// Completion of a conversion on ADC channel 6 will generate an interrupt.
	ADC_INTEN_ADINTEN6_ENABLE = 0x1
	// Position of ADINTEN7 field.
	ADC_INTEN_ADINTEN7_Pos = 0x7
	// Bit mask of ADINTEN7 field.
	ADC_INTEN_ADINTEN7_Msk = 0x80
	// Bit ADINTEN7.
	ADC_INTEN_ADINTEN7 = 0x80
	// Completion of a conversion on ADC channel 7 will not generate an interrupt.
	ADC_INTEN_ADINTEN7_DISABLE = 0x0
	// Completion of a conversion on ADC channel 7 will generate an interrupt.
	ADC_INTEN_ADINTEN7_ENABLE = 0x1
	// Position of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Pos = 0x8
	// Bit mask of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Msk = 0x100
	// Bit ADGINTEN.
	ADC_INTEN_ADGINTEN = 0x100
	// Only the individual ADC channels enabled by ADINTEN7:0 will generate interrupts.
	ADC_INTEN_ADGINTEN_CHANNELS = 0x0
	// The global DONE flag in ADDR is enabled to generate an interrupt in addition to any individual ADC channels that are enabled to generate interrupts.
	ADC_INTEN_ADGINTEN_GLOBAL = 0x1
	// Position of RESERVED field.
	ADC_INTEN_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ADC_INTEN_RESERVED_Msk = 0xfffffe00

	// DR: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
	// Position of RESERVED field.
	ADC_DR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_DR_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC_DR_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC_DR_RESULT_Msk = 0xfff0
	// Position of RESERVED field.
	ADC_DR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC_DR_RESERVED_Msk = 0x3fff0000
	// Position of OVERRUN field.
	ADC_DR_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC_DR_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC_DR_OVERRUN = 0x40000000
	// Position of DONE field.
	ADC_DR_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	ADC_DR_DONE_Msk = 0x80000000
	// Bit DONE.
	ADC_DR_DONE = 0x80000000

	// STAT: A/D Status Register. This register contains DONE and OVERRUN flags for all of the A/D channels, as well as the A/D interrupt/DMA flag.
	// Position of DONE0 field.
	ADC_STAT_DONE0_Pos = 0x0
	// Bit mask of DONE0 field.
	ADC_STAT_DONE0_Msk = 0x1
	// Bit DONE0.
	ADC_STAT_DONE0 = 0x1
	// Position of DONE1 field.
	ADC_STAT_DONE1_Pos = 0x1
	// Bit mask of DONE1 field.
	ADC_STAT_DONE1_Msk = 0x2
	// Bit DONE1.
	ADC_STAT_DONE1 = 0x2
	// Position of DONE2 field.
	ADC_STAT_DONE2_Pos = 0x2
	// Bit mask of DONE2 field.
	ADC_STAT_DONE2_Msk = 0x4
	// Bit DONE2.
	ADC_STAT_DONE2 = 0x4
	// Position of DONE3 field.
	ADC_STAT_DONE3_Pos = 0x3
	// Bit mask of DONE3 field.
	ADC_STAT_DONE3_Msk = 0x8
	// Bit DONE3.
	ADC_STAT_DONE3 = 0x8
	// Position of DONE4 field.
	ADC_STAT_DONE4_Pos = 0x4
	// Bit mask of DONE4 field.
	ADC_STAT_DONE4_Msk = 0x10
	// Bit DONE4.
	ADC_STAT_DONE4 = 0x10
	// Position of DONE5 field.
	ADC_STAT_DONE5_Pos = 0x5
	// Bit mask of DONE5 field.
	ADC_STAT_DONE5_Msk = 0x20
	// Bit DONE5.
	ADC_STAT_DONE5 = 0x20
	// Position of DONE6 field.
	ADC_STAT_DONE6_Pos = 0x6
	// Bit mask of DONE6 field.
	ADC_STAT_DONE6_Msk = 0x40
	// Bit DONE6.
	ADC_STAT_DONE6 = 0x40
	// Position of DONE7 field.
	ADC_STAT_DONE7_Pos = 0x7
	// Bit mask of DONE7 field.
	ADC_STAT_DONE7_Msk = 0x80
	// Bit DONE7.
	ADC_STAT_DONE7 = 0x80
	// Position of OVERRUN0 field.
	ADC_STAT_OVERRUN0_Pos = 0x8
	// Bit mask of OVERRUN0 field.
	ADC_STAT_OVERRUN0_Msk = 0x100
	// Bit OVERRUN0.
	ADC_STAT_OVERRUN0 = 0x100
	// Position of OVERRUN1 field.
	ADC_STAT_OVERRUN1_Pos = 0x9
	// Bit mask of OVERRUN1 field.
	ADC_STAT_OVERRUN1_Msk = 0x200
	// Bit OVERRUN1.
	ADC_STAT_OVERRUN1 = 0x200
	// Position of OVERRUN2 field.
	ADC_STAT_OVERRUN2_Pos = 0xa
	// Bit mask of OVERRUN2 field.
	ADC_STAT_OVERRUN2_Msk = 0x400
	// Bit OVERRUN2.
	ADC_STAT_OVERRUN2 = 0x400
	// Position of OVERRUN3 field.
	ADC_STAT_OVERRUN3_Pos = 0xb
	// Bit mask of OVERRUN3 field.
	ADC_STAT_OVERRUN3_Msk = 0x800
	// Bit OVERRUN3.
	ADC_STAT_OVERRUN3 = 0x800
	// Position of OVERRUN4 field.
	ADC_STAT_OVERRUN4_Pos = 0xc
	// Bit mask of OVERRUN4 field.
	ADC_STAT_OVERRUN4_Msk = 0x1000
	// Bit OVERRUN4.
	ADC_STAT_OVERRUN4 = 0x1000
	// Position of OVERRUN5 field.
	ADC_STAT_OVERRUN5_Pos = 0xd
	// Bit mask of OVERRUN5 field.
	ADC_STAT_OVERRUN5_Msk = 0x2000
	// Bit OVERRUN5.
	ADC_STAT_OVERRUN5 = 0x2000
	// Position of OVERRUN6 field.
	ADC_STAT_OVERRUN6_Pos = 0xe
	// Bit mask of OVERRUN6 field.
	ADC_STAT_OVERRUN6_Msk = 0x4000
	// Bit OVERRUN6.
	ADC_STAT_OVERRUN6 = 0x4000
	// Position of OVERRUN7 field.
	ADC_STAT_OVERRUN7_Pos = 0xf
	// Bit mask of OVERRUN7 field.
	ADC_STAT_OVERRUN7_Msk = 0x8000
	// Bit OVERRUN7.
	ADC_STAT_OVERRUN7 = 0x8000
	// Position of ADINT field.
	ADC_STAT_ADINT_Pos = 0x10
	// Bit mask of ADINT field.
	ADC_STAT_ADINT_Msk = 0x10000
	// Bit ADINT.
	ADC_STAT_ADINT = 0x10000
	// Position of RESERVED field.
	ADC_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	ADC_STAT_RESERVED_Msk = 0xfffe0000

	// TRM: ADC trim register.
	// Position of RESERVED field.
	ADC_TRM_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0xf
	// Position of ADCOFFS field.
	ADC_TRM_ADCOFFS_Pos = 0x4
	// Bit mask of ADCOFFS field.
	ADC_TRM_ADCOFFS_Msk = 0xf0
	// Position of TRIM field.
	ADC_TRM_TRIM_Pos = 0x8
	// Bit mask of TRIM field.
	ADC_TRM_TRIM_Msk = 0xf00
	// Position of RESERVED field.
	ADC_TRM_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0xfffff000
)

// Bitfields for CANAFRAM: CAN acceptance filter RAM
const (
	// MASK: CAN AF ram access register
	// Position of MASK field.
	CANAFRAM_MASK_MASK_Pos = 0x0
	// Bit mask of MASK field.
	CANAFRAM_MASK_MASK_Msk = 0xffffffff
)

// Bitfields for CANAF: CAN controller acceptance filter
const (
	// AFMR: Acceptance Filter Register
	// Position of ACCOFF field.
	CANAF_AFMR_ACCOFF_Pos = 0x0
	// Bit mask of ACCOFF field.
	CANAF_AFMR_ACCOFF_Msk = 0x1
	// Bit ACCOFF.
	CANAF_AFMR_ACCOFF = 0x1
	// Position of ACCBP field.
	CANAF_AFMR_ACCBP_Pos = 0x1
	// Bit mask of ACCBP field.
	CANAF_AFMR_ACCBP_Msk = 0x2
	// Bit ACCBP.
	CANAF_AFMR_ACCBP = 0x2
	// Position of EFCAN field.
	CANAF_AFMR_EFCAN_Pos = 0x2
	// Bit mask of EFCAN field.
	CANAF_AFMR_EFCAN_Msk = 0x4
	// Bit EFCAN.
	CANAF_AFMR_EFCAN = 0x4
	// Software must read all messages for all enabled IDs on all enabled CAN buses, from the receiving CAN controllers.
	CANAF_AFMR_EFCAN_SOFTWARE_MUST_READ_A = 0x0
	// The Acceptance Filter itself will take care of receiving and storing messages for selected Standard ID values on selected CAN buses. See Section 21.16 FullCAN mode on page 576.
	CANAF_AFMR_EFCAN_THE_ACCEPTANCE_FILTE = 0x1
	// Position of RESERVED field.
	CANAF_AFMR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	CANAF_AFMR_RESERVED_Msk = 0xfffffff8

	// SFF_SA: Standard Frame Individual Start Address Register
	// Position of RESERVED field.
	CANAF_SFF_SA_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CANAF_SFF_SA_RESERVED_Msk = 0x3
	// Position of SFF_SA field.
	CANAF_SFF_SA_SFF_SA_Pos = 0x2
	// Bit mask of SFF_SA field.
	CANAF_SFF_SA_SFF_SA_Msk = 0x7fc
	// Position of RESERVED field.
	CANAF_SFF_SA_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	CANAF_SFF_SA_RESERVED_Msk = 0xfffff800

	// SFF_GRP_SA: Standard Frame Group Start Address Register
	// Position of RESERVED field.
	CANAF_SFF_GRP_SA_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CANAF_SFF_GRP_SA_RESERVED_Msk = 0x3
	// Position of SFF_GRP_SA field.
	CANAF_SFF_GRP_SA_SFF_GRP_SA_Pos = 0x2
	// Bit mask of SFF_GRP_SA field.
	CANAF_SFF_GRP_SA_SFF_GRP_SA_Msk = 0xffc
	// Position of RESERVED field.
	CANAF_SFF_GRP_SA_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CANAF_SFF_GRP_SA_RESERVED_Msk = 0xfffff000

	// EFF_SA: Extended Frame Start Address Register
	// Position of RESERVED field.
	CANAF_EFF_SA_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CANAF_EFF_SA_RESERVED_Msk = 0x3
	// Position of EFF_SA field.
	CANAF_EFF_SA_EFF_SA_Pos = 0x2
	// Bit mask of EFF_SA field.
	CANAF_EFF_SA_EFF_SA_Msk = 0x7fc
	// Position of RESERVED field.
	CANAF_EFF_SA_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	CANAF_EFF_SA_RESERVED_Msk = 0xfffff800

	// EFF_GRP_SA: Extended Frame Group Start Address Register
	// Position of RESERVED field.
	CANAF_EFF_GRP_SA_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CANAF_EFF_GRP_SA_RESERVED_Msk = 0x3
	// Position of EFF_GRP_SA field.
	CANAF_EFF_GRP_SA_EFF_GRP_SA_Pos = 0x2
	// Bit mask of EFF_GRP_SA field.
	CANAF_EFF_GRP_SA_EFF_GRP_SA_Msk = 0xffc
	// Position of RESERVED field.
	CANAF_EFF_GRP_SA_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CANAF_EFF_GRP_SA_RESERVED_Msk = 0xfffff000

	// ENDOFTABLE: End of AF Tables register
	// Position of RESERVED field.
	CANAF_ENDOFTABLE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CANAF_ENDOFTABLE_RESERVED_Msk = 0x3
	// Position of ENDOFTABLE field.
	CANAF_ENDOFTABLE_ENDOFTABLE_Pos = 0x2
	// Bit mask of ENDOFTABLE field.
	CANAF_ENDOFTABLE_ENDOFTABLE_Msk = 0xffc
	// Position of RESERVED field.
	CANAF_ENDOFTABLE_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CANAF_ENDOFTABLE_RESERVED_Msk = 0xfffff000

	// LUTERRAD: LUT Error Address register
	// Position of RESERVED field.
	CANAF_LUTERRAD_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	CANAF_LUTERRAD_RESERVED_Msk = 0x3
	// Position of LUTERRAD field.
	CANAF_LUTERRAD_LUTERRAD_Pos = 0x2
	// Bit mask of LUTERRAD field.
	CANAF_LUTERRAD_LUTERRAD_Msk = 0x7fc
	// Position of RESERVED field.
	CANAF_LUTERRAD_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	CANAF_LUTERRAD_RESERVED_Msk = 0xfffff800

	// LUTERR: LUT Error Register
	// Position of LUTERR field.
	CANAF_LUTERR_LUTERR_Pos = 0x0
	// Bit mask of LUTERR field.
	CANAF_LUTERR_LUTERR_Msk = 0x1
	// Bit LUTERR.
	CANAF_LUTERR_LUTERR = 0x1
	// Position of RESERVED field.
	CANAF_LUTERR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CANAF_LUTERR_RESERVED_Msk = 0xfffffffe

	// FCANIE: FullCAN interrupt enable register
	// Position of FCANIE field.
	CANAF_FCANIE_FCANIE_Pos = 0x0
	// Bit mask of FCANIE field.
	CANAF_FCANIE_FCANIE_Msk = 0x1
	// Bit FCANIE.
	CANAF_FCANIE_FCANIE = 0x1
	// Position of RESERVED field.
	CANAF_FCANIE_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	CANAF_FCANIE_RESERVED_Msk = 0xfffffffe

	// FCANIC0: FullCAN interrupt and capture register0
	// Position of INTPND field.
	CANAF_FCANIC0_INTPND_Pos = 0x0
	// Bit mask of INTPND field.
	CANAF_FCANIC0_INTPND_Msk = 0xffffffff

	// FCANIC1: FullCAN interrupt and capture register1
	// Position of IntPnd32 field.
	CANAF_FCANIC1_IntPnd32_Pos = 0x0
	// Bit mask of IntPnd32 field.
	CANAF_FCANIC1_IntPnd32_Msk = 0xffffffff
)

// Bitfields for CCAN: Central CAN controller
const (
	// TXSR: CAN Central Transmit Status Register
	// Position of TS1 field.
	CCAN_TXSR_TS1_Pos = 0x0
	// Bit mask of TS1 field.
	CCAN_TXSR_TS1_Msk = 0x1
	// Bit TS1.
	CCAN_TXSR_TS1 = 0x1
	// Position of TS2 field.
	CCAN_TXSR_TS2_Pos = 0x1
	// Bit mask of TS2 field.
	CCAN_TXSR_TS2_Msk = 0x2
	// Bit TS2.
	CCAN_TXSR_TS2 = 0x2
	// Position of RESERVED field.
	CCAN_TXSR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CCAN_TXSR_RESERVED_Msk = 0xfc
	// Position of TBS1 field.
	CCAN_TXSR_TBS1_Pos = 0x8
	// Bit mask of TBS1 field.
	CCAN_TXSR_TBS1_Msk = 0x100
	// Bit TBS1.
	CCAN_TXSR_TBS1 = 0x100
	// Position of TBS2 field.
	CCAN_TXSR_TBS2_Pos = 0x9
	// Bit mask of TBS2 field.
	CCAN_TXSR_TBS2_Msk = 0x200
	// Bit TBS2.
	CCAN_TXSR_TBS2 = 0x200
	// Position of RESERVED field.
	CCAN_TXSR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	CCAN_TXSR_RESERVED_Msk = 0xfc00
	// Position of TCS1 field.
	CCAN_TXSR_TCS1_Pos = 0x10
	// Bit mask of TCS1 field.
	CCAN_TXSR_TCS1_Msk = 0x10000
	// Bit TCS1.
	CCAN_TXSR_TCS1 = 0x10000
	// Position of TCS2 field.
	CCAN_TXSR_TCS2_Pos = 0x11
	// Bit mask of TCS2 field.
	CCAN_TXSR_TCS2_Msk = 0x20000
	// Bit TCS2.
	CCAN_TXSR_TCS2 = 0x20000
	// Position of RESERVED field.
	CCAN_TXSR_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	CCAN_TXSR_RESERVED_Msk = 0xfffc0000

	// RXSR: CAN Central Receive Status Register
	// Position of RS1 field.
	CCAN_RXSR_RS1_Pos = 0x0
	// Bit mask of RS1 field.
	CCAN_RXSR_RS1_Msk = 0x1
	// Bit RS1.
	CCAN_RXSR_RS1 = 0x1
	// Position of RS2 field.
	CCAN_RXSR_RS2_Pos = 0x1
	// Bit mask of RS2 field.
	CCAN_RXSR_RS2_Msk = 0x2
	// Bit RS2.
	CCAN_RXSR_RS2 = 0x2
	// Position of RESERVED field.
	CCAN_RXSR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CCAN_RXSR_RESERVED_Msk = 0xfc
	// Position of RB1 field.
	CCAN_RXSR_RB1_Pos = 0x8
	// Bit mask of RB1 field.
	CCAN_RXSR_RB1_Msk = 0x100
	// Bit RB1.
	CCAN_RXSR_RB1 = 0x100
	// Position of RB2 field.
	CCAN_RXSR_RB2_Pos = 0x9
	// Bit mask of RB2 field.
	CCAN_RXSR_RB2_Msk = 0x200
	// Bit RB2.
	CCAN_RXSR_RB2 = 0x200
	// Position of RESERVED field.
	CCAN_RXSR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	CCAN_RXSR_RESERVED_Msk = 0xfc00
	// Position of DOS1 field.
	CCAN_RXSR_DOS1_Pos = 0x10
	// Bit mask of DOS1 field.
	CCAN_RXSR_DOS1_Msk = 0x10000
	// Bit DOS1.
	CCAN_RXSR_DOS1 = 0x10000
	// Position of DOS2 field.
	CCAN_RXSR_DOS2_Pos = 0x11
	// Bit mask of DOS2 field.
	CCAN_RXSR_DOS2_Msk = 0x20000
	// Bit DOS2.
	CCAN_RXSR_DOS2 = 0x20000
	// Position of RESERVED field.
	CCAN_RXSR_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	CCAN_RXSR_RESERVED_Msk = 0xfffc0000

	// MSR: CAN Central Miscellaneous Register
	// Position of E1 field.
	CCAN_MSR_E1_Pos = 0x0
	// Bit mask of E1 field.
	CCAN_MSR_E1_Msk = 0x1
	// Bit E1.
	CCAN_MSR_E1 = 0x1
	// Position of E2 field.
	CCAN_MSR_E2_Pos = 0x1
	// Bit mask of E2 field.
	CCAN_MSR_E2_Msk = 0x2
	// Bit E2.
	CCAN_MSR_E2 = 0x2
	// Position of RESERVED field.
	CCAN_MSR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CCAN_MSR_RESERVED_Msk = 0xfc
	// Position of BS1 field.
	CCAN_MSR_BS1_Pos = 0x8
	// Bit mask of BS1 field.
	CCAN_MSR_BS1_Msk = 0x100
	// Bit BS1.
	CCAN_MSR_BS1 = 0x100
	// Position of BS2 field.
	CCAN_MSR_BS2_Pos = 0x9
	// Bit mask of BS2 field.
	CCAN_MSR_BS2_Msk = 0x200
	// Bit BS2.
	CCAN_MSR_BS2 = 0x200
	// Position of RESERVED field.
	CCAN_MSR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	CCAN_MSR_RESERVED_Msk = 0xfffffc00
)

// Bitfields for CAN1: CAN1 controller
const (
	// MOD: Controls the operating mode of the CAN Controller.
	// Position of RM field.
	CAN_MOD_RM_Pos = 0x0
	// Bit mask of RM field.
	CAN_MOD_RM_Msk = 0x1
	// Bit RM.
	CAN_MOD_RM = 0x1
	// Normal.The CAN Controller is in the Operating Mode, and certain registers can not be written.
	CAN_MOD_RM_NORMAL_THE_CAN_CONTR = 0x0
	// Reset. CAN operation is disabled, writable registers can be written and the current transmission/reception of a message is aborted.
	CAN_MOD_RM_RESET_CAN_OPERATION = 0x1
	// Position of LOM field.
	CAN_MOD_LOM_Pos = 0x1
	// Bit mask of LOM field.
	CAN_MOD_LOM_Msk = 0x2
	// Bit LOM.
	CAN_MOD_LOM = 0x2
	// Normal. The CAN controller acknowledges a successfully received message on the CAN bus. The error counters are stopped at the current value.
	CAN_MOD_LOM_NORMAL_THE_CAN_CONT = 0x0
	// Listen only. The controller gives no acknowledgment, even if a message is successfully received. Messages cannot be sent, and the controller operates in error passive mode. This mode is intended for software bit rate detection and hot plugging.
	CAN_MOD_LOM_LISTEN_ONLY_THE_CON = 0x1
	// Position of STM field.
	CAN_MOD_STM_Pos = 0x2
	// Bit mask of STM field.
	CAN_MOD_STM_Msk = 0x4
	// Bit STM.
	CAN_MOD_STM = 0x4
	// Normal. A transmitted message must be acknowledged to be considered successful.
	CAN_MOD_STM_NORMAL_A_TRANSMITTE = 0x0
	// Self test. The controller will consider a Tx message successful even if there is no acknowledgment received. In this mode a full node test is possible without any other active node on the bus using the SRR bit in CANxCMR.
	CAN_MOD_STM_SELF_TEST_THE_CONTR = 0x1
	// Position of TPM field.
	CAN_MOD_TPM_Pos = 0x3
	// Bit mask of TPM field.
	CAN_MOD_TPM_Msk = 0x8
	// Bit TPM.
	CAN_MOD_TPM = 0x8
	// CAN ID. The transmit priority for 3 Transmit Buffers depends on the CAN Identifier.
	CAN_MOD_TPM_CAN_ID_THE_TRANSMIT = 0x0
	// Local priority. The transmit priority for 3 Transmit Buffers depends on the contents of the Tx Priority register within the Transmit Buffer.
	CAN_MOD_TPM_LOCAL_PRIORITY_THE_ = 0x1
	// Position of SM field.
	CAN_MOD_SM_Pos = 0x4
	// Bit mask of SM field.
	CAN_MOD_SM_Msk = 0x10
	// Bit SM.
	CAN_MOD_SM = 0x10
	// Wake-up. Normal operation.
	CAN_MOD_SM_WAKE_UP_NORMAL_OPER = 0x0
	// Sleep. The CAN controller enters Sleep Mode if no CAN interrupt is pending and there is no bus activity. See the Sleep Mode description Section 21.8.2 on page 565.
	CAN_MOD_SM_SLEEP_THE_CAN_CONTR = 0x1
	// Position of RPM field.
	CAN_MOD_RPM_Pos = 0x5
	// Bit mask of RPM field.
	CAN_MOD_RPM_Msk = 0x20
	// Bit RPM.
	CAN_MOD_RPM = 0x20
	// Low active. RD input is active Low (dominant bit = 0).
	CAN_MOD_RPM_LOW_ACTIVE_RD_INPUT = 0x0
	// High active. RD input is active High (dominant bit = 1) -- reverse polarity.
	CAN_MOD_RPM_HIGH_ACTIVE_RD_INPU = 0x1
	// Position of RESERVED field.
	CAN_MOD_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CAN_MOD_RESERVED_Msk = 0x40
	// Bit RESERVED.
	CAN_MOD_RESERVED = 0x40
	// Position of TM field.
	CAN_MOD_TM_Pos = 0x7
	// Bit mask of TM field.
	CAN_MOD_TM_Msk = 0x80
	// Bit TM.
	CAN_MOD_TM = 0x80
	// Disabled. Normal operation.
	CAN_MOD_TM_DISABLED_NORMAL_OPE = 0x0
	// Enabled. The TD pin will reflect the bit, detected on RD pin, with the next positive edge of the system clock.
	CAN_MOD_TM_ENABLED_THE_TD_PIN_ = 0x1
	// Position of RESERVED field.
	CAN_MOD_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CAN_MOD_RESERVED_Msk = 0xffffff00

	// CMR: Command bits that affect the state of the CAN Controller
	// Position of TR field.
	CAN_CMR_TR_Pos = 0x0
	// Bit mask of TR field.
	CAN_CMR_TR_Msk = 0x1
	// Bit TR.
	CAN_CMR_TR = 0x1
	// Absent.No transmission request.
	CAN_CMR_TR_ABSENT_NO_TRANSMISSI = 0x0
	// Present. The message, previously written to the CANxTFI, CANxTID, and optionally the CANxTDA and CANxTDB registers, is queued for transmission from the selected Transmit Buffer. If at two or all three of STB1, STB2 and STB3 bits are selected when TR=1 is written, Transmit Buffer will be selected based on the chosen priority scheme (for details see Section 21.5.3 Transmit Buffers (TXB))
	CAN_CMR_TR_PRESENT_THE_MESSAGE = 0x1
	// Position of AT field.
	CAN_CMR_AT_Pos = 0x1
	// Bit mask of AT field.
	CAN_CMR_AT_Msk = 0x2
	// Bit AT.
	CAN_CMR_AT = 0x2
	// No action. Do not abort the transmission.
	CAN_CMR_AT_NO_ACTION_DO_NOT_AB = 0x0
	// Present. if not already in progress, a pending Transmission Request for the selected Transmit Buffer is cancelled.
	CAN_CMR_AT_PRESENT_IF_NOT_ALRE = 0x1
	// Position of RRB field.
	CAN_CMR_RRB_Pos = 0x2
	// Bit mask of RRB field.
	CAN_CMR_RRB_Msk = 0x4
	// Bit RRB.
	CAN_CMR_RRB = 0x4
	// No action. Do not release the receive buffer.
	CAN_CMR_RRB_NO_ACTION_DO_NOT_RE = 0x0
	// Released. The information in the Receive Buffer (consisting of CANxRFS, CANxRID, and if applicable the CANxRDA and CANxRDB registers) is released, and becomes eligible for replacement by the next received frame. If the next received frame is not available, writing this command clears the RBS bit in the Status Register(s).
	CAN_CMR_RRB_RELEASED_THE_INFORM = 0x1
	// Position of CDO field.
	CAN_CMR_CDO_Pos = 0x3
	// Bit mask of CDO field.
	CAN_CMR_CDO_Msk = 0x8
	// Bit CDO.
	CAN_CMR_CDO = 0x8
	// No action. Do not clear the data overrun bit.
	CAN_CMR_CDO_NO_ACTION_DO_NOT_CL = 0x0
	// Clear. The Data Overrun bit in Status Register(s) is cleared.
	CAN_CMR_CDO_CLEAR_THE_DATA_OVER = 0x1
	// Position of SRR field.
	CAN_CMR_SRR_Pos = 0x4
	// Bit mask of SRR field.
	CAN_CMR_SRR_Msk = 0x10
	// Bit SRR.
	CAN_CMR_SRR = 0x10
	// Absent. No self reception request.
	CAN_CMR_SRR_ABSENT_NO_SELF_RECE = 0x0
	// Present. The message, previously written to the CANxTFS, CANxTID, and optionally the CANxTDA and CANxTDB registers, is queued for transmission from the selected Transmit Buffer and received simultaneously. This differs from the TR bit above in that the receiver is not disabled during the transmission, so that it receives the message if its Identifier is recognized by the Acceptance Filter.
	CAN_CMR_SRR_PRESENT_THE_MESSAGE = 0x1
	// Position of STB1 field.
	CAN_CMR_STB1_Pos = 0x5
	// Bit mask of STB1 field.
	CAN_CMR_STB1_Msk = 0x20
	// Bit STB1.
	CAN_CMR_STB1 = 0x20
	// Not selected. Tx Buffer 1 is not selected for transmission.
	CAN_CMR_STB1_NOT_SELECTED_TX_BUF = 0x0
	// Selected. Tx Buffer 1 is selected for transmission.
	CAN_CMR_STB1_SELECTED_TX_BUFFER_ = 0x1
	// Position of STB2 field.
	CAN_CMR_STB2_Pos = 0x6
	// Bit mask of STB2 field.
	CAN_CMR_STB2_Msk = 0x40
	// Bit STB2.
	CAN_CMR_STB2 = 0x40
	// Not selected. Tx Buffer 2 is not selected for transmission.
	CAN_CMR_STB2_NOT_SELECTED_TX_BUF = 0x0
	// Selected. Tx Buffer 2 is selected for transmission.
	CAN_CMR_STB2_SELECTED_TX_BUFFER_ = 0x1
	// Position of STB3 field.
	CAN_CMR_STB3_Pos = 0x7
	// Bit mask of STB3 field.
	CAN_CMR_STB3_Msk = 0x80
	// Bit STB3.
	CAN_CMR_STB3 = 0x80
	// Not selected. Tx Buffer 3 is not selected for transmission.
	CAN_CMR_STB3_NOT_SELECTED_TX_BUF = 0x0
	// Selected. Tx Buffer 3 is selected for transmission.
	CAN_CMR_STB3_SELECTED_TX_BUFFER_ = 0x1
	// Position of RESERVED field.
	CAN_CMR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CAN_CMR_RESERVED_Msk = 0xffffff00

	// GSR: Global Controller Status and Error Counters. The error counters can only be written when RM in CANMOD is 1.
	// Position of RBS field.
	CAN_GSR_RBS_Pos = 0x0
	// Bit mask of RBS field.
	CAN_GSR_RBS_Msk = 0x1
	// Bit RBS.
	CAN_GSR_RBS = 0x1
	// Empty. No message is available.
	CAN_GSR_RBS_EMPTY_NO_MESSAGE_IS = 0x0
	// Full. At least one complete message is received by the Double Receive Buffer and available in the CANxRFS, CANxRID, and if applicable the CANxRDA and CANxRDB registers. This bit is cleared by the Release Receive Buffer command in CANxCMR, if no subsequent received message is available.
	CAN_GSR_RBS_FULL_AT_LEAST_ONE_C = 0x1
	// Position of DOS field.
	CAN_GSR_DOS_Pos = 0x1
	// Bit mask of DOS field.
	CAN_GSR_DOS_Msk = 0x2
	// Bit DOS.
	CAN_GSR_DOS = 0x2
	// Absent. No data overrun has occurred since the last Clear Data Overrun command was given/written to CANxCMR (or since Reset).
	CAN_GSR_DOS_ABSENT_NO_DATA_OVER = 0x0
	// Overrun. A message was lost because the preceding message to this CAN controller was not read and released quickly enough (there was not enough space for a new message in the Double Receive Buffer).
	CAN_GSR_DOS_OVERRUN_A_MESSAGE_W = 0x1
	// Position of TBS field.
	CAN_GSR_TBS_Pos = 0x2
	// Bit mask of TBS field.
	CAN_GSR_TBS_Msk = 0x4
	// Bit TBS.
	CAN_GSR_TBS = 0x4
	// Locked. At least one of the Transmit Buffers is not available for the CPU, i.e. at least one previously queued message for this CAN controller has not yet been sent, and therefore software should not write to the CANxTFI, CANxTID, CANxTDA, nor CANxTDB registers of that (those) Tx buffer(s).
	CAN_GSR_TBS_LOCKED_AT_LEAST_ONE = 0x0
	// Released. All three Transmit Buffers are available for the CPU. No transmit message is pending for this CAN controller (in any of the 3 Tx buffers), and software may write to any of the CANxTFI, CANxTID, CANxTDA, and CANxTDB registers.
	CAN_GSR_TBS_RELEASED_ALL_THREE_ = 0x1
	// Position of TCS field.
	CAN_GSR_TCS_Pos = 0x3
	// Bit mask of TCS field.
	CAN_GSR_TCS_Msk = 0x8
	// Bit TCS.
	CAN_GSR_TCS = 0x8
	// Incomplete. At least one requested transmission has not been successfully completed yet.
	CAN_GSR_TCS_INCOMPLETE_AT_LEAST = 0x0
	// Complete. All requested transmission(s) has (have) been successfully completed.
	CAN_GSR_TCS_COMPLETE_ALL_REQUES = 0x1
	// Position of RS field.
	CAN_GSR_RS_Pos = 0x4
	// Bit mask of RS field.
	CAN_GSR_RS_Msk = 0x10
	// Bit RS.
	CAN_GSR_RS = 0x10
	// Idle. The CAN controller is idle.
	CAN_GSR_RS_IDLE_THE_CAN_CONTRO = 0x0
	// Receive. The CAN controller is receiving a message.
	CAN_GSR_RS_RECEIVE_THE_CAN_CON = 0x1
	// Position of TS field.
	CAN_GSR_TS_Pos = 0x5
	// Bit mask of TS field.
	CAN_GSR_TS_Msk = 0x20
	// Bit TS.
	CAN_GSR_TS = 0x20
	// Idle. The CAN controller is idle.
	CAN_GSR_TS_IDLE_THE_CAN_CONTRO = 0x0
	// Transmit. The CAN controller is sending a message.
	CAN_GSR_TS_TRANSMIT_THE_CAN_CO = 0x1
	// Position of ES field.
	CAN_GSR_ES_Pos = 0x6
	// Bit mask of ES field.
	CAN_GSR_ES_Msk = 0x40
	// Bit ES.
	CAN_GSR_ES = 0x40
	// OK. Both error counters are below the Error Warning Limit.
	CAN_GSR_ES_OK_BOTH_ERROR_COUNT = 0x0
	// Error. One or both of the Transmit and Receive Error Counters has reached the limit set in the Error Warning Limit register.
	CAN_GSR_ES_ERROR_ONE_OR_BOTH_O = 0x1
	// Position of BS field.
	CAN_GSR_BS_Pos = 0x7
	// Bit mask of BS field.
	CAN_GSR_BS_Msk = 0x80
	// Bit BS.
	CAN_GSR_BS = 0x80
	// Bus-on. The CAN Controller is involved in bus activities
	CAN_GSR_BS_BUS_ON_THE_CAN_CONT = 0x0
	// Bus-off. The CAN controller is currently not involved/prohibited from bus activity because the Transmit Error Counter reached its limiting value of 255.
	CAN_GSR_BS_BUS_OFF_THE_CAN_CON = 0x1
	// Position of RESERVED field.
	CAN_GSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CAN_GSR_RESERVED_Msk = 0xff00
	// Position of RXERR field.
	CAN_GSR_RXERR_Pos = 0x10
	// Bit mask of RXERR field.
	CAN_GSR_RXERR_Msk = 0xff0000
	// Position of TXERR field.
	CAN_GSR_TXERR_Pos = 0x18
	// Bit mask of TXERR field.
	CAN_GSR_TXERR_Msk = 0xff000000

	// ICR: Interrupt status, Arbitration Lost Capture, Error Code Capture
	// Position of RI field.
	CAN_ICR_RI_Pos = 0x0
	// Bit mask of RI field.
	CAN_ICR_RI_Msk = 0x1
	// Bit RI.
	CAN_ICR_RI = 0x1
	// Reset
	CAN_ICR_RI_RESET = 0x0
	// Set
	CAN_ICR_RI_SET = 0x1
	// Position of TI1 field.
	CAN_ICR_TI1_Pos = 0x1
	// Bit mask of TI1 field.
	CAN_ICR_TI1_Msk = 0x2
	// Bit TI1.
	CAN_ICR_TI1 = 0x2
	// Reset
	CAN_ICR_TI1_RESET = 0x0
	// Set
	CAN_ICR_TI1_SET = 0x1
	// Position of EI field.
	CAN_ICR_EI_Pos = 0x2
	// Bit mask of EI field.
	CAN_ICR_EI_Msk = 0x4
	// Bit EI.
	CAN_ICR_EI = 0x4
	// Reset
	CAN_ICR_EI_RESET = 0x0
	// Set
	CAN_ICR_EI_SET = 0x1
	// Position of DOI field.
	CAN_ICR_DOI_Pos = 0x3
	// Bit mask of DOI field.
	CAN_ICR_DOI_Msk = 0x8
	// Bit DOI.
	CAN_ICR_DOI = 0x8
	// Reset
	CAN_ICR_DOI_RESET = 0x0
	// Set
	CAN_ICR_DOI_SET = 0x1
	// Position of WUI field.
	CAN_ICR_WUI_Pos = 0x4
	// Bit mask of WUI field.
	CAN_ICR_WUI_Msk = 0x10
	// Bit WUI.
	CAN_ICR_WUI = 0x10
	// Reset
	CAN_ICR_WUI_RESET = 0x0
	// Set
	CAN_ICR_WUI_SET = 0x1
	// Position of EPI field.
	CAN_ICR_EPI_Pos = 0x5
	// Bit mask of EPI field.
	CAN_ICR_EPI_Msk = 0x20
	// Bit EPI.
	CAN_ICR_EPI = 0x20
	// Reset
	CAN_ICR_EPI_RESET = 0x0
	// Set
	CAN_ICR_EPI_SET = 0x1
	// Position of ALI field.
	CAN_ICR_ALI_Pos = 0x6
	// Bit mask of ALI field.
	CAN_ICR_ALI_Msk = 0x40
	// Bit ALI.
	CAN_ICR_ALI = 0x40
	// Reset
	CAN_ICR_ALI_RESET = 0x0
	// Set
	CAN_ICR_ALI_SET = 0x1
	// Position of BEI field.
	CAN_ICR_BEI_Pos = 0x7
	// Bit mask of BEI field.
	CAN_ICR_BEI_Msk = 0x80
	// Bit BEI.
	CAN_ICR_BEI = 0x80
	// Reset
	CAN_ICR_BEI_RESET = 0x0
	// Set
	CAN_ICR_BEI_SET = 0x1
	// Position of IDI field.
	CAN_ICR_IDI_Pos = 0x8
	// Bit mask of IDI field.
	CAN_ICR_IDI_Msk = 0x100
	// Bit IDI.
	CAN_ICR_IDI = 0x100
	// Reset
	CAN_ICR_IDI_RESET = 0x0
	// Set
	CAN_ICR_IDI_SET = 0x1
	// Position of TI2 field.
	CAN_ICR_TI2_Pos = 0x9
	// Bit mask of TI2 field.
	CAN_ICR_TI2_Msk = 0x200
	// Bit TI2.
	CAN_ICR_TI2 = 0x200
	// Reset
	CAN_ICR_TI2_RESET = 0x0
	// Set
	CAN_ICR_TI2_SET = 0x1
	// Position of TI3 field.
	CAN_ICR_TI3_Pos = 0xa
	// Bit mask of TI3 field.
	CAN_ICR_TI3_Msk = 0x400
	// Bit TI3.
	CAN_ICR_TI3 = 0x400
	// Reset
	CAN_ICR_TI3_RESET = 0x0
	// Set
	CAN_ICR_TI3_SET = 0x1
	// Position of RESERVED field.
	CAN_ICR_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	CAN_ICR_RESERVED_Msk = 0xf800
	// Position of ERRBIT4_0 field.
	CAN_ICR_ERRBIT4_0_Pos = 0x10
	// Bit mask of ERRBIT4_0 field.
	CAN_ICR_ERRBIT4_0_Msk = 0x1f0000
	// Position of ERRDIR field.
	CAN_ICR_ERRDIR_Pos = 0x15
	// Bit mask of ERRDIR field.
	CAN_ICR_ERRDIR_Msk = 0x200000
	// Bit ERRDIR.
	CAN_ICR_ERRDIR = 0x200000
	// Position of ERRC1_0 field.
	CAN_ICR_ERRC1_0_Pos = 0x16
	// Bit mask of ERRC1_0 field.
	CAN_ICR_ERRC1_0_Msk = 0xc00000
	// Bit error
	CAN_ICR_ERRC1_0_BIT_ERROR = 0x0
	// Form error
	CAN_ICR_ERRC1_0_FORM_ERROR = 0x1
	// Stuff error
	CAN_ICR_ERRC1_0_STUFF_ERROR = 0x2
	// Other error
	CAN_ICR_ERRC1_0_OTHER_ERROR = 0x3
	// Position of ALCBIT field.
	CAN_ICR_ALCBIT_Pos = 0x18
	// Bit mask of ALCBIT field.
	CAN_ICR_ALCBIT_Msk = 0xff000000

	// IER: Interrupt Enable
	// Position of RIE field.
	CAN_IER_RIE_Pos = 0x0
	// Bit mask of RIE field.
	CAN_IER_RIE_Msk = 0x1
	// Bit RIE.
	CAN_IER_RIE = 0x1
	// Position of TIE1 field.
	CAN_IER_TIE1_Pos = 0x1
	// Bit mask of TIE1 field.
	CAN_IER_TIE1_Msk = 0x2
	// Bit TIE1.
	CAN_IER_TIE1 = 0x2
	// Position of EIE field.
	CAN_IER_EIE_Pos = 0x2
	// Bit mask of EIE field.
	CAN_IER_EIE_Msk = 0x4
	// Bit EIE.
	CAN_IER_EIE = 0x4
	// Position of DOIE field.
	CAN_IER_DOIE_Pos = 0x3
	// Bit mask of DOIE field.
	CAN_IER_DOIE_Msk = 0x8
	// Bit DOIE.
	CAN_IER_DOIE = 0x8
	// Position of WUIE field.
	CAN_IER_WUIE_Pos = 0x4
	// Bit mask of WUIE field.
	CAN_IER_WUIE_Msk = 0x10
	// Bit WUIE.
	CAN_IER_WUIE = 0x10
	// Position of EPIE field.
	CAN_IER_EPIE_Pos = 0x5
	// Bit mask of EPIE field.
	CAN_IER_EPIE_Msk = 0x20
	// Bit EPIE.
	CAN_IER_EPIE = 0x20
	// Position of ALIE field.
	CAN_IER_ALIE_Pos = 0x6
	// Bit mask of ALIE field.
	CAN_IER_ALIE_Msk = 0x40
	// Bit ALIE.
	CAN_IER_ALIE = 0x40
	// Position of BEIE field.
	CAN_IER_BEIE_Pos = 0x7
	// Bit mask of BEIE field.
	CAN_IER_BEIE_Msk = 0x80
	// Bit BEIE.
	CAN_IER_BEIE = 0x80
	// Position of IDIE field.
	CAN_IER_IDIE_Pos = 0x8
	// Bit mask of IDIE field.
	CAN_IER_IDIE_Msk = 0x100
	// Bit IDIE.
	CAN_IER_IDIE = 0x100
	// Position of TIE2 field.
	CAN_IER_TIE2_Pos = 0x9
	// Bit mask of TIE2 field.
	CAN_IER_TIE2_Msk = 0x200
	// Bit TIE2.
	CAN_IER_TIE2 = 0x200
	// Position of TIE3 field.
	CAN_IER_TIE3_Pos = 0xa
	// Bit mask of TIE3 field.
	CAN_IER_TIE3_Msk = 0x400
	// Bit TIE3.
	CAN_IER_TIE3 = 0x400
	// Position of RESERVED field.
	CAN_IER_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	CAN_IER_RESERVED_Msk = 0xfffff800

	// BTR: Bus Timing. Can only be written when RM in CANMOD is 1.
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff
	// Position of RESERVED field.
	CAN_BTR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	CAN_BTR_RESERVED_Msk = 0x3c00
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0xe
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0xc000
	// Position of TESG1 field.
	CAN_BTR_TESG1_Pos = 0x10
	// Bit mask of TESG1 field.
	CAN_BTR_TESG1_Msk = 0xf0000
	// Position of TESG2 field.
	CAN_BTR_TESG2_Pos = 0x14
	// Bit mask of TESG2 field.
	CAN_BTR_TESG2_Msk = 0x700000
	// Position of SAM field.
	CAN_BTR_SAM_Pos = 0x17
	// Bit mask of SAM field.
	CAN_BTR_SAM_Msk = 0x800000
	// Bit SAM.
	CAN_BTR_SAM = 0x800000
	// The bus is sampled once (recommended for high speed buses)
	CAN_BTR_SAM_THE_BUS_IS_SAMPLED_O = 0x0
	// The bus is sampled 3 times (recommended for low to medium speed buses to filter spikes on the bus-line)
	CAN_BTR_SAM_THE_BUS_IS_SAMPLED_3 = 0x1
	// Position of RESERVED field.
	CAN_BTR_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	CAN_BTR_RESERVED_Msk = 0xff000000

	// EWL: Error Warning Limit. Can only be written when RM in CANMOD is 1.
	// Position of EWL field.
	CAN_EWL_EWL_Pos = 0x0
	// Bit mask of EWL field.
	CAN_EWL_EWL_Msk = 0xff
	// Position of RESERVED field.
	CAN_EWL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CAN_EWL_RESERVED_Msk = 0xffffff00

	// SR: Status Register
	// Position of RBS_1 field.
	CAN_SR_RBS_1_Pos = 0x0
	// Bit mask of RBS_1 field.
	CAN_SR_RBS_1_Msk = 0x1
	// Bit RBS_1.
	CAN_SR_RBS_1 = 0x1
	// Position of DOS_1 field.
	CAN_SR_DOS_1_Pos = 0x1
	// Bit mask of DOS_1 field.
	CAN_SR_DOS_1_Msk = 0x2
	// Bit DOS_1.
	CAN_SR_DOS_1 = 0x2
	// Position of TBS1_1 field.
	CAN_SR_TBS1_1_Pos = 0x2
	// Bit mask of TBS1_1 field.
	CAN_SR_TBS1_1_Msk = 0x4
	// Bit TBS1_1.
	CAN_SR_TBS1_1 = 0x4
	// Locked. Software cannot access the Tx Buffer 1 nor write to the corresponding CANxTFI, CANxTID, CANxTDA, and CANxTDB registers because a message is either waiting for transmission or is in transmitting process.
	CAN_SR_TBS1_1_LOCKED_SOFTWARE_CAN = 0x0
	// Released. Software may write a message into the Transmit Buffer 1 and its CANxTFI, CANxTID, CANxTDA, and CANxTDB registers.
	CAN_SR_TBS1_1_RELEASED_SOFTWARE_M = 0x1
	// Position of TCS1_1 field.
	CAN_SR_TCS1_1_Pos = 0x3
	// Bit mask of TCS1_1 field.
	CAN_SR_TCS1_1_Msk = 0x8
	// Bit TCS1_1.
	CAN_SR_TCS1_1 = 0x8
	// Incomplete. The previously requested transmission for Tx Buffer 1 is not complete.
	CAN_SR_TCS1_1_INCOMPLETE_THE_PREV = 0x0
	// Complete. The previously requested transmission for Tx Buffer 1 has been successfully completed.
	CAN_SR_TCS1_1_COMPLETE_THE_PREVIO = 0x1
	// Position of RS_1 field.
	CAN_SR_RS_1_Pos = 0x4
	// Bit mask of RS_1 field.
	CAN_SR_RS_1_Msk = 0x10
	// Bit RS_1.
	CAN_SR_RS_1 = 0x10
	// Position of TS1_1 field.
	CAN_SR_TS1_1_Pos = 0x5
	// Bit mask of TS1_1 field.
	CAN_SR_TS1_1_Msk = 0x20
	// Bit TS1_1.
	CAN_SR_TS1_1 = 0x20
	// Idle. There is no transmission from Tx Buffer 1.
	CAN_SR_TS1_1_IDLE_THERE_IS_NO_TR = 0x0
	// Transmit. The CAN Controller is transmitting a message from Tx Buffer 1.
	CAN_SR_TS1_1_TRANSMIT_THE_CAN_CO = 0x1
	// Position of ES_1 field.
	CAN_SR_ES_1_Pos = 0x6
	// Bit mask of ES_1 field.
	CAN_SR_ES_1_Msk = 0x40
	// Bit ES_1.
	CAN_SR_ES_1 = 0x40
	// Position of BS_1 field.
	CAN_SR_BS_1_Pos = 0x7
	// Bit mask of BS_1 field.
	CAN_SR_BS_1_Msk = 0x80
	// Bit BS_1.
	CAN_SR_BS_1 = 0x80
	// Position of RBS_2 field.
	CAN_SR_RBS_2_Pos = 0x8
	// Bit mask of RBS_2 field.
	CAN_SR_RBS_2_Msk = 0x100
	// Bit RBS_2.
	CAN_SR_RBS_2 = 0x100
	// Position of DOS_2 field.
	CAN_SR_DOS_2_Pos = 0x9
	// Bit mask of DOS_2 field.
	CAN_SR_DOS_2_Msk = 0x200
	// Bit DOS_2.
	CAN_SR_DOS_2 = 0x200
	// Position of TBS2_2 field.
	CAN_SR_TBS2_2_Pos = 0xa
	// Bit mask of TBS2_2 field.
	CAN_SR_TBS2_2_Msk = 0x400
	// Bit TBS2_2.
	CAN_SR_TBS2_2 = 0x400
	// Locked. Software cannot access the Tx Buffer 2 nor write to the corresponding CANxTFI, CANxTID, CANxTDA, and CANxTDB registers because a message is either waiting for transmission or is in transmitting process.
	CAN_SR_TBS2_2_LOCKED_SOFTWARE_CAN = 0x0
	// Released. Software may write a message into the Transmit Buffer 2 and its CANxTFI, CANxTID, CANxTDA, and CANxTDB registers.
	CAN_SR_TBS2_2_RELEASED_SOFTWARE_M = 0x1
	// Position of TCS2_2 field.
	CAN_SR_TCS2_2_Pos = 0xb
	// Bit mask of TCS2_2 field.
	CAN_SR_TCS2_2_Msk = 0x800
	// Bit TCS2_2.
	CAN_SR_TCS2_2 = 0x800
	// Incomplete. The previously requested transmission for Tx Buffer 2 is not complete.
	CAN_SR_TCS2_2_INCOMPLETE_THE_PREV = 0x0
	// Complete. The previously requested transmission for Tx Buffer 2 has been successfully completed.
	CAN_SR_TCS2_2_COMPLETE_THE_PREVIO = 0x1
	// Position of RS_2 field.
	CAN_SR_RS_2_Pos = 0xc
	// Bit mask of RS_2 field.
	CAN_SR_RS_2_Msk = 0x1000
	// Bit RS_2.
	CAN_SR_RS_2 = 0x1000
	// Position of TS2_2 field.
	CAN_SR_TS2_2_Pos = 0xd
	// Bit mask of TS2_2 field.
	CAN_SR_TS2_2_Msk = 0x2000
	// Bit TS2_2.
	CAN_SR_TS2_2 = 0x2000
	// Idle. There is no transmission from Tx Buffer 2.
	CAN_SR_TS2_2_IDLE_THERE_IS_NO_TR = 0x0
	// Transmit. The CAN Controller is transmitting a message from Tx Buffer 2.
	CAN_SR_TS2_2_TRANSMIT_THE_CAN_CO = 0x1
	// Position of ES_2 field.
	CAN_SR_ES_2_Pos = 0xe
	// Bit mask of ES_2 field.
	CAN_SR_ES_2_Msk = 0x4000
	// Bit ES_2.
	CAN_SR_ES_2 = 0x4000
	// Position of BS_2 field.
	CAN_SR_BS_2_Pos = 0xf
	// Bit mask of BS_2 field.
	CAN_SR_BS_2_Msk = 0x8000
	// Bit BS_2.
	CAN_SR_BS_2 = 0x8000
	// Position of RBS_3 field.
	CAN_SR_RBS_3_Pos = 0x10
	// Bit mask of RBS_3 field.
	CAN_SR_RBS_3_Msk = 0x10000
	// Bit RBS_3.
	CAN_SR_RBS_3 = 0x10000
	// Position of DOS_3 field.
	CAN_SR_DOS_3_Pos = 0x11
	// Bit mask of DOS_3 field.
	CAN_SR_DOS_3_Msk = 0x20000
	// Bit DOS_3.
	CAN_SR_DOS_3 = 0x20000
	// Position of TBS3_3 field.
	CAN_SR_TBS3_3_Pos = 0x12
	// Bit mask of TBS3_3 field.
	CAN_SR_TBS3_3_Msk = 0x40000
	// Bit TBS3_3.
	CAN_SR_TBS3_3 = 0x40000
	// Locked. Software cannot access the Tx Buffer 3 nor write to the corresponding CANxTFI, CANxTID, CANxTDA, and CANxTDB registers because a message is either waiting for transmission or is in transmitting process.
	CAN_SR_TBS3_3_LOCKED_SOFTWARE_CAN = 0x0
	// Released. Software may write a message into the Transmit Buffer 3 and its CANxTFI, CANxTID, CANxTDA, and CANxTDB registers.
	CAN_SR_TBS3_3_RELEASED_SOFTWARE_M = 0x1
	// Position of TCS3_3 field.
	CAN_SR_TCS3_3_Pos = 0x13
	// Bit mask of TCS3_3 field.
	CAN_SR_TCS3_3_Msk = 0x80000
	// Bit TCS3_3.
	CAN_SR_TCS3_3 = 0x80000
	// Incomplete. The previously requested transmission for Tx Buffer 3 is not complete.
	CAN_SR_TCS3_3_INCOMPLETE_THE_PREV = 0x0
	// Complete. The previously requested transmission for Tx Buffer 3 has been successfully completed.
	CAN_SR_TCS3_3_COMPLETE_THE_PREVIO = 0x1
	// Position of RS_3 field.
	CAN_SR_RS_3_Pos = 0x14
	// Bit mask of RS_3 field.
	CAN_SR_RS_3_Msk = 0x100000
	// Bit RS_3.
	CAN_SR_RS_3 = 0x100000
	// Position of TS3_3 field.
	CAN_SR_TS3_3_Pos = 0x15
	// Bit mask of TS3_3 field.
	CAN_SR_TS3_3_Msk = 0x200000
	// Bit TS3_3.
	CAN_SR_TS3_3 = 0x200000
	// Idle. There is no transmission from Tx Buffer 3.
	CAN_SR_TS3_3_IDLE_THERE_IS_NO_TR = 0x0
	// Transmit. The CAN Controller is transmitting a message from Tx Buffer 3.
	CAN_SR_TS3_3_TRANSMIT_THE_CAN_CO = 0x1
	// Position of ES_3 field.
	CAN_SR_ES_3_Pos = 0x16
	// Bit mask of ES_3 field.
	CAN_SR_ES_3_Msk = 0x400000
	// Bit ES_3.
	CAN_SR_ES_3 = 0x400000
	// Position of BS_3 field.
	CAN_SR_BS_3_Pos = 0x17
	// Bit mask of BS_3 field.
	CAN_SR_BS_3_Msk = 0x800000
	// Bit BS_3.
	CAN_SR_BS_3 = 0x800000
	// Position of RESERVED field.
	CAN_SR_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	CAN_SR_RESERVED_Msk = 0xff000000

	// RFS: Receive frame status. Can only be written when RM in CANMOD is 1.
	// Position of IDINDEX field.
	CAN_RFS_IDINDEX_Pos = 0x0
	// Bit mask of IDINDEX field.
	CAN_RFS_IDINDEX_Msk = 0x3ff
	// Position of BP field.
	CAN_RFS_BP_Pos = 0xa
	// Bit mask of BP field.
	CAN_RFS_BP_Msk = 0x400
	// Bit BP.
	CAN_RFS_BP = 0x400
	// Position of RESERVED field.
	CAN_RFS_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	CAN_RFS_RESERVED_Msk = 0xf800
	// Position of DLC field.
	CAN_RFS_DLC_Pos = 0x10
	// Bit mask of DLC field.
	CAN_RFS_DLC_Msk = 0xf0000
	// Position of RESERVED field.
	CAN_RFS_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	CAN_RFS_RESERVED_Msk = 0x3ff00000
	// Position of RTR field.
	CAN_RFS_RTR_Pos = 0x1e
	// Bit mask of RTR field.
	CAN_RFS_RTR_Msk = 0x40000000
	// Bit RTR.
	CAN_RFS_RTR = 0x40000000
	// Position of FF field.
	CAN_RFS_FF_Pos = 0x1f
	// Bit mask of FF field.
	CAN_RFS_FF_Msk = 0x80000000
	// Bit FF.
	CAN_RFS_FF = 0x80000000

	// RID: Received Identifier. Can only be written when RM in CANMOD is 1.
	// Position of ID field.
	CAN_RID_ID_Pos = 0x0
	// Bit mask of ID field.
	CAN_RID_ID_Msk = 0x7ff
	// Position of RESERVED field.
	CAN_RID_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	CAN_RID_RESERVED_Msk = 0xfffff800

	// RDA: Received data bytes 1-4. Can only be written when RM in CANMOD is 1.
	// Position of DATA1 field.
	CAN_RDA_DATA1_Pos = 0x0
	// Bit mask of DATA1 field.
	CAN_RDA_DATA1_Msk = 0xff
	// Position of DATA2 field.
	CAN_RDA_DATA2_Pos = 0x8
	// Bit mask of DATA2 field.
	CAN_RDA_DATA2_Msk = 0xff00
	// Position of DATA3 field.
	CAN_RDA_DATA3_Pos = 0x10
	// Bit mask of DATA3 field.
	CAN_RDA_DATA3_Msk = 0xff0000
	// Position of DATA4 field.
	CAN_RDA_DATA4_Pos = 0x18
	// Bit mask of DATA4 field.
	CAN_RDA_DATA4_Msk = 0xff000000

	// RDB: Received data bytes 5-8. Can only be written when RM in CANMOD is 1.
	// Position of DATA5 field.
	CAN_RDB_DATA5_Pos = 0x0
	// Bit mask of DATA5 field.
	CAN_RDB_DATA5_Msk = 0xff
	// Position of DATA6 field.
	CAN_RDB_DATA6_Pos = 0x8
	// Bit mask of DATA6 field.
	CAN_RDB_DATA6_Msk = 0xff00
	// Position of DATA7 field.
	CAN_RDB_DATA7_Pos = 0x10
	// Bit mask of DATA7 field.
	CAN_RDB_DATA7_Msk = 0xff0000
	// Position of DATA8 field.
	CAN_RDB_DATA8_Pos = 0x18
	// Bit mask of DATA8 field.
	CAN_RDB_DATA8_Msk = 0xff000000

	// TFI1: Transmit frame info (Tx Buffer )
	// Position of PRIO field.
	CAN_TFI_PRIO_Pos = 0x0
	// Bit mask of PRIO field.
	CAN_TFI_PRIO_Msk = 0xff
	// Position of RESERVED field.
	CAN_TFI_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CAN_TFI_RESERVED_Msk = 0xff00
	// Position of DLC field.
	CAN_TFI_DLC_Pos = 0x10
	// Bit mask of DLC field.
	CAN_TFI_DLC_Msk = 0xf0000
	// Position of RESERVED field.
	CAN_TFI_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	CAN_TFI_RESERVED_Msk = 0x3ff00000
	// Position of RTR field.
	CAN_TFI_RTR_Pos = 0x1e
	// Bit mask of RTR field.
	CAN_TFI_RTR_Msk = 0x40000000
	// Bit RTR.
	CAN_TFI_RTR = 0x40000000
	// Position of FF field.
	CAN_TFI_FF_Pos = 0x1f
	// Bit mask of FF field.
	CAN_TFI_FF_Msk = 0x80000000
	// Bit FF.
	CAN_TFI_FF = 0x80000000

	// TID1: Transmit Identifier (Tx Buffer)
	// Position of ID field.
	CAN_TID_ID_Pos = 0x0
	// Bit mask of ID field.
	CAN_TID_ID_Msk = 0x7ff
	// Position of RESERVED field.
	CAN_TID_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	CAN_TID_RESERVED_Msk = 0xfffff800

	// TDA1: Transmit data bytes 1-4 (Tx Buffer)
	// Position of DATA1 field.
	CAN_TDA_DATA1_Pos = 0x0
	// Bit mask of DATA1 field.
	CAN_TDA_DATA1_Msk = 0xff
	// Position of DATA2 field.
	CAN_TDA_DATA2_Pos = 0x8
	// Bit mask of DATA2 field.
	CAN_TDA_DATA2_Msk = 0xff00
	// Position of DATA3 field.
	CAN_TDA_DATA3_Pos = 0x10
	// Bit mask of DATA3 field.
	CAN_TDA_DATA3_Msk = 0xff0000
	// Position of DATA4 field.
	CAN_TDA_DATA4_Pos = 0x18
	// Bit mask of DATA4 field.
	CAN_TDA_DATA4_Msk = 0xff000000

	// TDB1: Transmit data bytes 5-8 (Tx Buffer )
	// Position of DATA5 field.
	CAN_TDB_DATA5_Pos = 0x0
	// Bit mask of DATA5 field.
	CAN_TDB_DATA5_Msk = 0xff
	// Position of DATA6 field.
	CAN_TDB_DATA6_Pos = 0x8
	// Bit mask of DATA6 field.
	CAN_TDB_DATA6_Msk = 0xff00
	// Position of DATA7 field.
	CAN_TDB_DATA7_Pos = 0x10
	// Bit mask of DATA7 field.
	CAN_TDB_DATA7_Msk = 0xff0000
	// Position of DATA8 field.
	CAN_TDB_DATA8_Pos = 0x18
	// Bit mask of DATA8 field.
	CAN_TDB_DATA8_Msk = 0xff000000
)

// Bitfields for DAC: Digital-to-Analog Converter (DAC)
const (
	// CR: D/A Converter Register. This register contains the digital value to be converted to analog and a power control bit.
	// Position of RESERVED field.
	DAC_CR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DAC_CR_RESERVED_Msk = 0x3f
	// Position of VALUE field.
	DAC_CR_VALUE_Pos = 0x6
	// Bit mask of VALUE field.
	DAC_CR_VALUE_Msk = 0xffc0
	// Position of BIAS field.
	DAC_CR_BIAS_Pos = 0x10
	// Bit mask of BIAS field.
	DAC_CR_BIAS_Msk = 0x10000
	// Bit BIAS.
	DAC_CR_BIAS = 0x10000
	// The settling time of the DAC is 1 us max, and the maximum current is 700 uA. This allows a maximum update rate of 1 MHz.
	DAC_CR_BIAS_FAST = 0x0
	// The settling time of the DAC is 2.5 us and the maximum current is 350 uA. This allows a maximum update rate of 400 kHz.
	DAC_CR_BIAS_SLOW = 0x1
	// Position of RESERVED field.
	DAC_CR_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	DAC_CR_RESERVED_Msk = 0xfffe0000

	// CTRL: DAC Control register. This register controls DMA and timer operation.
	// Position of INT_DMA_REQ field.
	DAC_CTRL_INT_DMA_REQ_Pos = 0x0
	// Bit mask of INT_DMA_REQ field.
	DAC_CTRL_INT_DMA_REQ_Msk = 0x1
	// Bit INT_DMA_REQ.
	DAC_CTRL_INT_DMA_REQ = 0x1
	// Clear on any write to the DACR register.
	DAC_CTRL_INT_DMA_REQ_CLEAR_ON_ANY_WRITE_T = 0x0
	// Set by hardware when the timer times out.
	DAC_CTRL_INT_DMA_REQ_SET_BY_HARDWARE_WHEN = 0x1
	// Position of DBLBUF_ENA field.
	DAC_CTRL_DBLBUF_ENA_Pos = 0x1
	// Bit mask of DBLBUF_ENA field.
	DAC_CTRL_DBLBUF_ENA_Msk = 0x2
	// Bit DBLBUF_ENA.
	DAC_CTRL_DBLBUF_ENA = 0x2
	// Disable
	DAC_CTRL_DBLBUF_ENA_DISABLE = 0x0
	// Enable. When this bit and the CNT_ENA bit are both set, the double-buffering feature in the DACR register will be enabled. Writes to the DACR register are written to a pre-buffer and then transferred to the DACR on the next time-out of the counter.
	DAC_CTRL_DBLBUF_ENA_ENABLE_WHEN_THIS_BI = 0x1
	// Position of CNT_ENA field.
	DAC_CTRL_CNT_ENA_Pos = 0x2
	// Bit mask of CNT_ENA field.
	DAC_CTRL_CNT_ENA_Msk = 0x4
	// Bit CNT_ENA.
	DAC_CTRL_CNT_ENA = 0x4
	// Disable
	DAC_CTRL_CNT_ENA_DISABLE = 0x0
	// Enable
	DAC_CTRL_CNT_ENA_ENABLE = 0x1
	// Position of DMA_ENA field.
	DAC_CTRL_DMA_ENA_Pos = 0x3
	// Bit mask of DMA_ENA field.
	DAC_CTRL_DMA_ENA_Msk = 0x8
	// Bit DMA_ENA.
	DAC_CTRL_DMA_ENA = 0x8
	// Disable
	DAC_CTRL_DMA_ENA_DISABLE = 0x0
	// Enable. DMA Burst Request Input 7 is enabled for the DAC (see Table 672).
	DAC_CTRL_DMA_ENA_ENABLE_DMA_BURST_RE = 0x1
	// Position of RESERVED field.
	DAC_CTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	DAC_CTRL_RESERVED_Msk = 0xfffffff0

	// CNTVAL: DAC Counter Value register. This register contains the reload value for the DAC DMA/Interrupt timer.
	// Position of VALUE field.
	DAC_CNTVAL_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	DAC_CNTVAL_VALUE_Msk = 0xffff
	// Position of RESERVED field.
	DAC_CNTVAL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	DAC_CNTVAL_RESERVED_Msk = 0xffff0000
)

// Bitfields for UART4: UART4
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read (DLAB =0).
	// Position of RBR field.
	UART4_RBR_RBR_Pos = 0x0
	// Bit mask of RBR field.
	UART4_RBR_RBR_Msk = 0xff
	// Position of RESERVED field.
	UART4_RBR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_RBR_RESERVED_Msk = 0xffffff00

	// THR: Transmit Holding Register. The next character to be transmitted is written here (DLAB =0).
	// Position of THR field.
	UART4_THR_THR_Pos = 0x0
	// Bit mask of THR field.
	UART4_THR_THR_Msk = 0xff
	// Position of RESERVED field.
	UART4_THR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_THR_RESERVED_Msk = 0xffffff00

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB =1).
	// Position of DLLSB field.
	UART4_DLL_DLLSB_Pos = 0x0
	// Bit mask of DLLSB field.
	UART4_DLL_DLLSB_Msk = 0xff
	// Position of RESERVED field.
	UART4_DLL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_DLL_RESERVED_Msk = 0xffffff00

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB =1).
	// Position of DLMSB field.
	UART4_DLM_DLMSB_Pos = 0x0
	// Bit mask of DLMSB field.
	UART4_DLM_DLMSB_Msk = 0xff
	// Position of RESERVED field.
	UART4_DLM_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_DLM_RESERVED_Msk = 0xffffff00

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART interrupts (DLAB =0).
	// Position of RBRIE field.
	UART4_IER_RBRIE_Pos = 0x0
	// Bit mask of RBRIE field.
	UART4_IER_RBRIE_Msk = 0x1
	// Bit RBRIE.
	UART4_IER_RBRIE = 0x1
	// Disable the RDA interrupts.
	UART4_IER_RBRIE_DISABLE_THE_RDA_INTE = 0x0
	// Enable the RDA interrupts.
	UART4_IER_RBRIE_ENABLE_THE_RDA_INTER = 0x1
	// Position of THREIE field.
	UART4_IER_THREIE_Pos = 0x1
	// Bit mask of THREIE field.
	UART4_IER_THREIE_Msk = 0x2
	// Bit THREIE.
	UART4_IER_THREIE = 0x2
	// Disable the THRE interrupts.
	UART4_IER_THREIE_DISABLE_THE_THRE_INT = 0x0
	// Enable the THRE interrupts.
	UART4_IER_THREIE_ENABLE_THE_THRE_INTE = 0x1
	// Position of RXIE field.
	UART4_IER_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	UART4_IER_RXIE_Msk = 0x4
	// Bit RXIE.
	UART4_IER_RXIE = 0x4
	// Disable the RX line status interrupts.
	UART4_IER_RXIE_DISABLE_THE_RX_LINE_ = 0x0
	// Enable the RX line status interrupts.
	UART4_IER_RXIE_ENABLE_THE_RX_LINE_S = 0x1
	// Position of RESERVED field.
	UART4_IER_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART4_IER_RESERVED_Msk = 0xf8
	// Position of ABEOINTEN field.
	UART4_IER_ABEOINTEN_Pos = 0x8
	// Bit mask of ABEOINTEN field.
	UART4_IER_ABEOINTEN_Msk = 0x100
	// Bit ABEOINTEN.
	UART4_IER_ABEOINTEN = 0x100
	// Disable end of auto-baud Interrupt.
	UART4_IER_ABEOINTEN_DISABLE_END_OF_AUTO_ = 0x0
	// Enable end of auto-baud Interrupt.
	UART4_IER_ABEOINTEN_ENABLE_END_OF_AUTO_B = 0x1
	// Position of ABTOINTEN field.
	UART4_IER_ABTOINTEN_Pos = 0x9
	// Bit mask of ABTOINTEN field.
	UART4_IER_ABTOINTEN_Msk = 0x200
	// Bit ABTOINTEN.
	UART4_IER_ABTOINTEN = 0x200
	// Disable auto-baud time-out Interrupt.
	UART4_IER_ABTOINTEN_DISABLE_AUTO_BAUD_TI = 0x0
	// Enable auto-baud time-out Interrupt.
	UART4_IER_ABTOINTEN_ENABLE_AUTO_BAUD_TIM = 0x1
	// Position of RESERVED field.
	UART4_IER_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART4_IER_RESERVED_Msk = 0xfffffc00

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	// Position of INTSTATUS field.
	UART4_IIR_INTSTATUS_Pos = 0x0
	// Bit mask of INTSTATUS field.
	UART4_IIR_INTSTATUS_Msk = 0x1
	// Bit INTSTATUS.
	UART4_IIR_INTSTATUS = 0x1
	// At least one interrupt is pending.
	UART4_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0
	// No interrupt is pending.
	UART4_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1
	// Position of INTID field.
	UART4_IIR_INTID_Pos = 0x1
	// Bit mask of INTID field.
	UART4_IIR_INTID_Msk = 0xe
	// 1 - Receive Line Status (RLS).
	UART4_IIR_INTID_1_RECEIVE_LINE_S = 0x3
	// 2a - Receive Data Available (RDA).
	UART4_IIR_INTID_2A__RECEIVE_DATA_AV = 0x2
	// 2b - Character Time-out Indicator (CTI).
	UART4_IIR_INTID_2B__CHARACTER_TIME_ = 0x6
	// 3 - THRE Interrupt
	UART4_IIR_INTID_3_THRE_INTERRUPT = 0x1
	// Position of RESERVED field.
	UART4_IIR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART4_IIR_RESERVED_Msk = 0x30
	// Position of FIFOENABLE field.
	UART4_IIR_FIFOENABLE_Pos = 0x6
	// Bit mask of FIFOENABLE field.
	UART4_IIR_FIFOENABLE_Msk = 0xc0
	// Position of ABEOINT field.
	UART4_IIR_ABEOINT_Pos = 0x8
	// Bit mask of ABEOINT field.
	UART4_IIR_ABEOINT_Msk = 0x100
	// Bit ABEOINT.
	UART4_IIR_ABEOINT = 0x100
	// Position of ABTOINT field.
	UART4_IIR_ABTOINT_Pos = 0x9
	// Bit mask of ABTOINT field.
	UART4_IIR_ABTOINT_Msk = 0x200
	// Bit ABTOINT.
	UART4_IIR_ABTOINT = 0x200
	// Position of RESERVED field.
	UART4_IIR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART4_IIR_RESERVED_Msk = 0xfffffc00

	// FCR: FIFO Control Register. Controls UART FIFO usage and modes.
	// Position of FIFOEN field.
	UART4_FCR_FIFOEN_Pos = 0x0
	// Bit mask of FIFOEN field.
	UART4_FCR_FIFOEN_Msk = 0x1
	// Bit FIFOEN.
	UART4_FCR_FIFOEN = 0x1
	// UARTn FIFOs are disabled. Must not be used in the application.
	UART4_FCR_FIFOEN_UARTN_FIFOS_ARE_DISA = 0x0
	// Active high enable for both UARTn Rx and TX FIFOs and UnFCR[7:1] access. This bit must be set for proper UART operation. Any transition on this bit will automatically clear the related UART FIFOs.
	UART4_FCR_FIFOEN_ACTIVE_HIGH_ENABLE_F = 0x1
	// Position of RXFIFORES field.
	UART4_FCR_RXFIFORES_Pos = 0x1
	// Bit mask of RXFIFORES field.
	UART4_FCR_RXFIFORES_Msk = 0x2
	// Bit RXFIFORES.
	UART4_FCR_RXFIFORES = 0x2
	// No impact on either of UARTn FIFOs.
	UART4_FCR_RXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0
	// Writing a logic 1 to UnFCR[1] will clear all bytes in UARTn Rx FIFO, reset the pointer logic. This bit is self-clearing.
	UART4_FCR_RXFIFORES_WRITING_A_LOGIC_1_TO = 0x1
	// Position of TXFIFORES field.
	UART4_FCR_TXFIFORES_Pos = 0x2
	// Bit mask of TXFIFORES field.
	UART4_FCR_TXFIFORES_Msk = 0x4
	// Bit TXFIFORES.
	UART4_FCR_TXFIFORES = 0x4
	// No impact on either of UARTn FIFOs.
	UART4_FCR_TXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0
	// Writing a logic 1 to UnFCR[2] will clear all bytes in UARTn TX FIFO, reset the pointer logic. This bit is self-clearing.
	UART4_FCR_TXFIFORES_WRITING_A_LOGIC_1_TO = 0x1
	// Position of DMAMODE field.
	UART4_FCR_DMAMODE_Pos = 0x3
	// Bit mask of DMAMODE field.
	UART4_FCR_DMAMODE_Msk = 0x8
	// Bit DMAMODE.
	UART4_FCR_DMAMODE = 0x8
	// Position of RESERVED field.
	UART4_FCR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	UART4_FCR_RESERVED_Msk = 0x30
	// Position of RXTRIGLVL field.
	UART4_FCR_RXTRIGLVL_Pos = 0x6
	// Bit mask of RXTRIGLVL field.
	UART4_FCR_RXTRIGLVL_Msk = 0xc0
	// Trigger level 0 (1 character or 0x01).
	UART4_FCR_RXTRIGLVL_TRIGGER_LEVEL_0_1_C = 0x0
	// Trigger level 1 (4 characters or 0x04).
	UART4_FCR_RXTRIGLVL_TRIGGER_LEVEL_1_4_C = 0x1
	// Trigger level 2 (8 characters or 0x08).
	UART4_FCR_RXTRIGLVL_TRIGGER_LEVEL_2_8_C = 0x2
	// Trigger level 3 (14 characters or 0x0E).
	UART4_FCR_RXTRIGLVL_TRIGGER_LEVEL_3_14_ = 0x3
	// Position of RESERVED field.
	UART4_FCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_FCR_RESERVED_Msk = 0xffffff00

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	// Position of WLS field.
	UART4_LCR_WLS_Pos = 0x0
	// Bit mask of WLS field.
	UART4_LCR_WLS_Msk = 0x3
	// 5-bit character length
	UART4_LCR_WLS_5_BIT_CHARACTER_LENG = 0x0
	// 6-bit character length
	UART4_LCR_WLS_6_BIT_CHARACTER_LENG = 0x1
	// 7-bit character length
	UART4_LCR_WLS_7_BIT_CHARACTER_LENG = 0x2
	// 8-bit character length
	UART4_LCR_WLS_8_BIT_CHARACTER_LENG = 0x3
	// Position of SBS field.
	UART4_LCR_SBS_Pos = 0x2
	// Bit mask of SBS field.
	UART4_LCR_SBS_Msk = 0x4
	// Bit SBS.
	UART4_LCR_SBS = 0x4
	// 1 stop bit.
	UART4_LCR_SBS_1_STOP_BIT_ = 0x0
	// 2 stop bits (1.5 if UnLCR[1:0]=00).
	UART4_LCR_SBS_2_STOP_BITS_1_5_IF_ = 0x1
	// Position of PE field.
	UART4_LCR_PE_Pos = 0x3
	// Bit mask of PE field.
	UART4_LCR_PE_Msk = 0x8
	// Bit PE.
	UART4_LCR_PE = 0x8
	// Disable parity generation and checking.
	UART4_LCR_PE_DISABLE_PARITY_GENER = 0x0
	// Enable parity generation and checking.
	UART4_LCR_PE_ENABLE_PARITY_GENERA = 0x1
	// Position of PS field.
	UART4_LCR_PS_Pos = 0x4
	// Bit mask of PS field.
	UART4_LCR_PS_Msk = 0x30
	// Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	UART4_LCR_PS_ODD_PARITY_NUMBER_O = 0x0
	// Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	UART4_LCR_PS_EVEN_PARITY_NUMBER_ = 0x1
	// Forced 1 stick parity.
	UART4_LCR_PS_FORCED_1_STICK_PARIT = 0x2
	// Forced 0 stick parity.
	UART4_LCR_PS_FORCED_0_STICK_PARIT = 0x3
	// Position of BC field.
	UART4_LCR_BC_Pos = 0x6
	// Bit mask of BC field.
	UART4_LCR_BC_Msk = 0x40
	// Bit BC.
	UART4_LCR_BC = 0x40
	// Disable break transmission.
	UART4_LCR_BC_DISABLE_BREAK_TRANSM = 0x0
	// Enable break transmission. Output pin UARTn TXD is forced to logic 0 when UnLCR[6] is active high.
	UART4_LCR_BC_ENABLE_BREAK_TRANSMI = 0x1
	// Position of DLAB field.
	UART4_LCR_DLAB_Pos = 0x7
	// Bit mask of DLAB field.
	UART4_LCR_DLAB_Msk = 0x80
	// Bit DLAB.
	UART4_LCR_DLAB = 0x80
	// Disable access to Divisor Latches.
	UART4_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0
	// Enable access to Divisor Latches.
	UART4_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1
	// Position of RESERVED field.
	UART4_LCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_LCR_RESERVED_Msk = 0xffffff00

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	// Position of RDR field.
	UART4_LSR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	UART4_LSR_RDR_Msk = 0x1
	// Bit RDR.
	UART4_LSR_RDR = 0x1
	// Position of OE field.
	UART4_LSR_OE_Pos = 0x1
	// Bit mask of OE field.
	UART4_LSR_OE_Msk = 0x2
	// Bit OE.
	UART4_LSR_OE = 0x2
	// Position of PE field.
	UART4_LSR_PE_Pos = 0x2
	// Bit mask of PE field.
	UART4_LSR_PE_Msk = 0x4
	// Bit PE.
	UART4_LSR_PE = 0x4
	// Position of FE field.
	UART4_LSR_FE_Pos = 0x3
	// Bit mask of FE field.
	UART4_LSR_FE_Msk = 0x8
	// Bit FE.
	UART4_LSR_FE = 0x8
	// Position of BI field.
	UART4_LSR_BI_Pos = 0x4
	// Bit mask of BI field.
	UART4_LSR_BI_Msk = 0x10
	// Bit BI.
	UART4_LSR_BI = 0x10
	// Position of THRE field.
	UART4_LSR_THRE_Pos = 0x5
	// Bit mask of THRE field.
	UART4_LSR_THRE_Msk = 0x20
	// Bit THRE.
	UART4_LSR_THRE = 0x20
	// UnTHR contains valid data.
	UART4_LSR_THRE_UNTHR_CONTAINS_VALID = 0x0
	// UnTHR is empty.
	UART4_LSR_THRE_UNTHR_IS_EMPTY_ = 0x1
	// Position of TEMT field.
	UART4_LSR_TEMT_Pos = 0x6
	// Bit mask of TEMT field.
	UART4_LSR_TEMT_Msk = 0x40
	// Bit TEMT.
	UART4_LSR_TEMT = 0x40
	// UnTHR and/or the UnTSR contains valid data.
	UART4_LSR_TEMT_VALID_DATA = 0x0
	// UnTHR and the UnTSR are empty.
	UART4_LSR_TEMT_EMPTY = 0x1
	// Position of RXFE field.
	UART4_LSR_RXFE_Pos = 0x7
	// Bit mask of RXFE field.
	UART4_LSR_RXFE_Msk = 0x80
	// Bit RXFE.
	UART4_LSR_RXFE = 0x80
	// UnRBR contains no UARTn RX errors or UnFCR[0]=0.
	UART4_LSR_RXFE_UNRBR_CONTAINS_NO_UA = 0x0
	// UARTn RBR contains at least one UARTn RX error.
	UART4_LSR_RXFE_UARTN_RBR_CONTAINS_A = 0x1
	// Position of RESERVED field.
	UART4_LSR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_LSR_RESERVED_Msk = 0xffffff00

	// SCR: Scratch Pad Register. 8-bit temporary storage for software.
	// Position of Pad field.
	UART4_SCR_Pad_Pos = 0x0
	// Bit mask of Pad field.
	UART4_SCR_Pad_Msk = 0xff
	// Position of RESERVED field.
	UART4_SCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_SCR_RESERVED_Msk = 0xffffff00

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	// Position of START field.
	UART4_ACR_START_Pos = 0x0
	// Bit mask of START field.
	UART4_ACR_START_Msk = 0x1
	// Bit START.
	UART4_ACR_START = 0x1
	// Auto-baud stop (auto-baud is not running).
	UART4_ACR_START_AUTO_BAUD_STOP_AUTO = 0x0
	// Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	UART4_ACR_START_AUTO_BAUD_START_AUT = 0x1
	// Position of MODE field.
	UART4_ACR_MODE_Pos = 0x1
	// Bit mask of MODE field.
	UART4_ACR_MODE_Msk = 0x2
	// Bit MODE.
	UART4_ACR_MODE = 0x2
	// Mode 0.
	UART4_ACR_MODE_MODE_0_ = 0x0
	// Mode 1.
	UART4_ACR_MODE_MODE_1_ = 0x1
	// Position of AUTORESTART field.
	UART4_ACR_AUTORESTART_Pos = 0x2
	// Bit mask of AUTORESTART field.
	UART4_ACR_AUTORESTART_Msk = 0x4
	// Bit AUTORESTART.
	UART4_ACR_AUTORESTART = 0x4
	// No restart.
	UART4_ACR_AUTORESTART_NO_RESTART_ = 0x0
	// Restart in case of time-out (counter restarts at next UARTn Rx falling edge)
	UART4_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1
	// Position of RESERVED field.
	UART4_ACR_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	UART4_ACR_RESERVED_Msk = 0xf8
	// Position of ABEOINTCLR field.
	UART4_ACR_ABEOINTCLR_Pos = 0x8
	// Bit mask of ABEOINTCLR field.
	UART4_ACR_ABEOINTCLR_Msk = 0x100
	// Bit ABEOINTCLR.
	UART4_ACR_ABEOINTCLR = 0x100
	// No impact.
	UART4_ACR_ABEOINTCLR_NO_IMPACT_ = 0x0
	// Clear the corresponding interrupt in the IIR.
	UART4_ACR_ABEOINTCLR_CLEAR_THE_CORRESPOND = 0x1
	// Position of ABTOINTCLR field.
	UART4_ACR_ABTOINTCLR_Pos = 0x9
	// Bit mask of ABTOINTCLR field.
	UART4_ACR_ABTOINTCLR_Msk = 0x200
	// Bit ABTOINTCLR.
	UART4_ACR_ABTOINTCLR = 0x200
	// No impact.
	UART4_ACR_ABTOINTCLR_NO_IMPACT_ = 0x0
	// Clear the corresponding interrupt in the IIR.
	UART4_ACR_ABTOINTCLR_CLEAR_THE_CORRESPOND = 0x1
	// Position of RESERVED field.
	UART4_ACR_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	UART4_ACR_RESERVED_Msk = 0xfffffc00

	// ICR: IrDA Control Register. Enables and configures the IrDA mode.
	// Position of IRDAEN field.
	UART4_ICR_IRDAEN_Pos = 0x0
	// Bit mask of IRDAEN field.
	UART4_ICR_IRDAEN_Msk = 0x1
	// Bit IRDAEN.
	UART4_ICR_IRDAEN = 0x1
	// Disabled. IrDA mode on UART4 is disabled, UART4 acts as a standard UART.
	UART4_ICR_IRDAEN_DISABLED_IRDA_MODE_ = 0x0
	// Enabled. IrDA mode on UART4 is enabled.
	UART4_ICR_IRDAEN_ENABLED_IRDA_MODE_O = 0x1
	// Position of IRDAINV field.
	UART4_ICR_IRDAINV_Pos = 0x1
	// Bit mask of IRDAINV field.
	UART4_ICR_IRDAINV_Msk = 0x2
	// Bit IRDAINV.
	UART4_ICR_IRDAINV = 0x2
	// Not inverted.
	UART4_ICR_IRDAINV_NOT_INVERTED_ = 0x0
	// Inverted. This has no effect on the serial output.
	UART4_ICR_IRDAINV_INVERTED_THIS_HAS_N = 0x1
	// Position of FIXPULSEEN field.
	UART4_ICR_FIXPULSEEN_Pos = 0x2
	// Bit mask of FIXPULSEEN field.
	UART4_ICR_FIXPULSEEN_Msk = 0x4
	// Bit FIXPULSEEN.
	UART4_ICR_FIXPULSEEN = 0x4
	// Disabled.
	UART4_ICR_FIXPULSEEN_DISABLED_ = 0x0
	// Enabled.
	UART4_ICR_FIXPULSEEN_ENABLED_ = 0x1
	// Position of PULSEDIV field.
	UART4_ICR_PULSEDIV_Pos = 0x3
	// Bit mask of PULSEDIV field.
	UART4_ICR_PULSEDIV_Msk = 0x38
	// 2xTPCLK
	UART4_ICR_PULSEDIV_2XTPCLK = 0x0
	// 4xTPCLK
	UART4_ICR_PULSEDIV_4XTPCLK = 0x1
	// 8xTPCLK
	UART4_ICR_PULSEDIV_8XTPCLK = 0x2
	// 16xTPCLK
	UART4_ICR_PULSEDIV_16XTPCLK = 0x3
	// 32xTPCLK
	UART4_ICR_PULSEDIV_32XTPCLK = 0x4
	// 64xTPCLK
	UART4_ICR_PULSEDIV_64XTPCLK = 0x5
	// 128xTPCLK
	UART4_ICR_PULSEDIV_128XTPCLK = 0x6
	// 256xTPCLK
	UART4_ICR_PULSEDIV_256XTPCLK = 0x7
	// Position of RESERVED field.
	UART4_ICR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	UART4_ICR_RESERVED_Msk = 0xffffffc0

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	// Position of DIVADDVAL field.
	UART4_FDR_DIVADDVAL_Pos = 0x0
	// Bit mask of DIVADDVAL field.
	UART4_FDR_DIVADDVAL_Msk = 0xf
	// Position of MULVAL field.
	UART4_FDR_MULVAL_Pos = 0x4
	// Bit mask of MULVAL field.
	UART4_FDR_MULVAL_Msk = 0xf0
	// Position of RESERVED field.
	UART4_FDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	UART4_FDR_RESERVED_Msk = 0xffffff00

	// OSR: Oversampling register. Controls the degree of oversampling during each bit time.
	// Position of RESERVED field.
	UART4_OSR_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	UART4_OSR_RESERVED_Msk = 0x1
	// Bit RESERVED.
	UART4_OSR_RESERVED = 0x1
	// Position of OSFRAC field.
	UART4_OSR_OSFRAC_Pos = 0x1
	// Bit mask of OSFRAC field.
	UART4_OSR_OSFRAC_Msk = 0xe
	// Position of OSINT field.
	UART4_OSR_OSINT_Pos = 0x4
	// Bit mask of OSINT field.
	UART4_OSR_OSINT_Msk = 0xf0
	// Position of FDINT field.
	UART4_OSR_FDINT_Pos = 0x8
	// Bit mask of FDINT field.
	UART4_OSR_FDINT_Msk = 0x7f00
	// Position of RESERVED field.
	UART4_OSR_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	UART4_OSR_RESERVED_Msk = 0xffff8000

	// SCICTRL: Smart Card Interface control register. Enables and configures the smartcard Interface feature.
	// Position of SCIEN field.
	UART4_SCICTRL_SCIEN_Pos = 0x0
	// Bit mask of SCIEN field.
	UART4_SCICTRL_SCIEN_Msk = 0x1
	// Bit SCIEN.
	UART4_SCICTRL_SCIEN = 0x1
	// Smart card interface disabled.
	UART4_SCICTRL_SCIEN_SMART_CARD_INTERFACE = 0x0
	// Asynchronous half duplex smart card interface is enabled.
	UART4_SCICTRL_SCIEN_ASYNCHRONOUS_HALF_DU = 0x1
	// Position of NACKDIS field.
	UART4_SCICTRL_NACKDIS_Pos = 0x1
	// Bit mask of NACKDIS field.
	UART4_SCICTRL_NACKDIS_Msk = 0x2
	// Bit NACKDIS.
	UART4_SCICTRL_NACKDIS = 0x2
	// A NACK response is enabled.
	UART4_SCICTRL_NACKDIS_A_NACK_RESPONSE_IS_E = 0x0
	// A NACK response is inhibited.
	UART4_SCICTRL_NACKDIS_A_NACK_RESPONSE_IS_I = 0x1
	// Position of PROTSEL field.
	UART4_SCICTRL_PROTSEL_Pos = 0x2
	// Bit mask of PROTSEL field.
	UART4_SCICTRL_PROTSEL_Msk = 0x4
	// Bit PROTSEL.
	UART4_SCICTRL_PROTSEL = 0x4
	// T = 0
	UART4_SCICTRL_PROTSEL_T_EQ_0 = 0x0
	// T = 1
	UART4_SCICTRL_PROTSEL_T_EQ_1 = 0x1
	// Position of TXRETRY field.
	UART4_SCICTRL_TXRETRY_Pos = 0x5
	// Bit mask of TXRETRY field.
	UART4_SCICTRL_TXRETRY_Msk = 0xe0
	// Position of GUARDTIME field.
	UART4_SCICTRL_GUARDTIME_Pos = 0x8
	// Bit mask of GUARDTIME field.
	UART4_SCICTRL_GUARDTIME_Msk = 0xff00
	// Position of RESERVED field.
	UART4_SCICTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	UART4_SCICTRL_RESERVED_Msk = 0xffff0000

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	// Position of NMMEN field.
	UART4_RS485CTRL_NMMEN_Pos = 0x0
	// Bit mask of NMMEN field.
	UART4_RS485CTRL_NMMEN_Msk = 0x1
	// Bit NMMEN.
	UART4_RS485CTRL_NMMEN = 0x1
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	UART4_RS485CTRL_NMMEN_DISABLED = 0x0
	// RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte causes the USART to set the parity error and generate an interrupt. See Section 20.6.18 RS-485/EIA-485 modes of operation.
	UART4_RS485CTRL_NMMEN_ENABLED = 0x1
	// Position of RXDIS field.
	UART4_RS485CTRL_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	UART4_RS485CTRL_RXDIS_Msk = 0x2
	// Bit RXDIS.
	UART4_RS485CTRL_RXDIS = 0x2
	// Enabled.
	UART4_RS485CTRL_RXDIS_ENABLED_ = 0x0
	// Disabled.
	UART4_RS485CTRL_RXDIS_DISABLED_ = 0x1
	// Position of AADEN field.
	UART4