// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f7x7.svd, see https://github.com/tinygo-org/stm32-svd

// +build stm32,stm32f7x7

// STM32F7x7
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F7x7"
	CPU          = "CM7"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG = 0

	// Power control // External interrupt/event controller
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMP_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// FLASH
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	IRQ_DMA1_Stream0 = 11

	IRQ_DMA1_Stream1 = 12

	IRQ_DMA1_Stream2 = 13

	IRQ_DMA1_Stream3 = 14

	IRQ_DMA1_Stream4 = 15

	IRQ_DMA1_Stream5 = 16

	IRQ_DMA1_Stream6 = 17

	// Analog-to-digital converter
	IRQ_ADC = 18

	// Controller area network
	IRQ_CAN1_TX = 19

	// Controller area network
	IRQ_CAN1_RX0 = 20

	// Controller area network
	IRQ_CAN1_RX1 = 21

	// Controller area network
	IRQ_CAN1_SCE = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers
	IRQ_TIM1_BRK_TIM9 = 24

	// Advanced-timers
	IRQ_TIM1_UP_TIM10 = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM_TIM11 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General purpose timers
	IRQ_TIM2 = 28

	// General purpose timers
	IRQ_TIM3 = 29

	// General purpose timers
	IRQ_TIM4 = 30

	// Inter-integrated circuit
	IRQ_I2C1_EV = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	// Inter-integrated circuit //
	IRQ_I2C2_EV = 33

	// Inter-integrated circuit //
	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// External interrupt/event controller
	IRQ_RTC_ALARM = 41

	// External interrupt/event controller
	IRQ_OTG_FS_WKUP = 42

	IRQ_TIM8_BRK_TIM12 = 43

	IRQ_TIM8_UP_TIM13 = 44

	IRQ_TIM8_TRG_COM_TIM14 = 45

	IRQ_TIM8_CC = 46

	IRQ_DMA1_Stream7 = 47

	// Flexible memory controller
	IRQ_FMC = 48

	// Secure digital input/output interface
	IRQ_SDMMC1 = 49

	// General-purpose-timers
	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	// Universal synchronous asynchronous receiver transmitter //
	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic timers
	IRQ_TIM6_DAC = 54

	IRQ_TIM7 = 55

	// DMA controller
	IRQ_DMA2_Stream0 = 56

	// DMA controller
	IRQ_DMA2_Stream1 = 57

	// DMA controller
	IRQ_DMA2_Stream2 = 58

	// DMA controller
	IRQ_DMA2_Stream3 = 59

	// DMA controller
	IRQ_DMA2_Stream4 = 60

	// Ethernet: media access control (MAC)
	IRQ_ETH = 61

	// Ethernet: media access control (MAC)
	IRQ_ETH_WKUP = 62

	IRQ_CAN2_TX = 63

	IRQ_CAN2_RX0 = 64

	IRQ_CAN2_RX1 = 65

	IRQ_CAN2_SCE = 66

	// USB on the go full speed
	IRQ_OTG_FS = 67

	// DMA controller
	IRQ_DMA2_Stream5 = 68

	// DMA controller
	IRQ_DMA2_Stream6 = 69

	// DMA controller
	IRQ_DMA2_Stream7 = 70

	// Universal synchronous asynchronous receiver transmitter //
	IRQ_USART6 = 71

	// Inter-integrated circuit //
	IRQ_I2C3_EV = 72

	// Inter-integrated circuit //
	IRQ_I2C3_ER = 73

	// USB on the go high speed
	IRQ_OTG_HS_EP1_OUT = 74

	// USB on the go high speed
	IRQ_OTG_HS_EP1_IN = 75

	// USB on the go high speed
	IRQ_OTG_HS_WKUP = 76

	// USB on the go high speed
	IRQ_OTG_HS = 77

	// Digital camera interface
	IRQ_DCMI = 78

	// Cryptographic processor
	IRQ_CRYP = 79

	// Random number generator
	IRQ_HASH_RNG = 80

	// Floting point unit
	IRQ_FPU = 81

	// Universal synchronous asynchronous receiver transmitter //
	IRQ_UART7 = 82

	IRQ_UART8 = 83

	IRQ_SPI4 = 84

	IRQ_SPI5 = 85

	IRQ_SPI6 = 86

	// Serial audio interface
	IRQ_SAI1 = 87

	// LCD-TFT Controller
	IRQ_LTDC = 88

	// LCD-TFT Controller
	IRQ_LTDC_ER = 89

	// DMA2D controller
	IRQ_DMA2D = 90

	// Serial audio interface //
	IRQ_SAI2 = 91

	// QuadSPI interface
	IRQ_QuadSPI = 92

	// Low power timer
	IRQ_LP_Timer1 = 93

	// Cryptographic processor
	IRQ_HDMI_CEC = 94

	// Inter-integrated circuit //
	IRQ_I2C4_EV = 95

	// Inter-integrated circuit //
	IRQ_I2C4_ER = 96

	// Receiver Interface
	IRQ_SPDIFRX = 97

	// DSI Host
	IRQ_DSIHOST = 98

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT0 = 99

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT1 = 100

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT2 = 101

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT3 = 102

	IRQ_SDMMC2 = 103

	IRQ_CAN3_TX = 104

	IRQ_CAN3_RX0 = 105

	IRQ_CAN3_RX1 = 106

	IRQ_CAN3_SCE = 107

	// JPEG codec
	IRQ_JPEG = 108

	// Management data input/output slave
	IRQ_MDIOS = 109

	// Highest interrupt number on this device.
	IRQ_max = 109
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_TAMP_STAMP, "TAMP_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream0, "DMA1_Stream0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream1, "DMA1_Stream1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream2, "DMA1_Stream2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream3, "DMA1_Stream3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream4, "DMA1_Stream4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream5, "DMA1_Stream5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream6, "DMA1_Stream6_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_TX, "CAN1_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX0, "CAN1_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX1, "CAN1_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_SCE, "CAN1_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM9, "TIM1_BRK_TIM9_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM10, "TIM1_UP_TIM10_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM11, "TIM1_TRG_COM_TIM11_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4, "TIM4_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV, "I2C2_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_ALARM, "RTC_ALARM_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS_WKUP, "OTG_FS_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_BRK_TIM12, "TIM8_BRK_TIM12_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_UP_TIM13, "TIM8_UP_TIM13_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_TRG_COM_TIM14, "TIM8_TRG_COM_TIM14_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_CC, "TIM8_CC_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Stream7, "DMA1_Stream7_IRQHandler")
	_ = interrupt.Register(IRQ_FMC, "FMC_IRQHandler")
	_ = interrupt.Register(IRQ_SDMMC1, "SDMMC1_IRQHandler")
	_ = interrupt.Register(IRQ_TIM5, "TIM5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_UART4, "UART4_IRQHandler")
	_ = interrupt.Register(IRQ_UART5, "UART5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC, "TIM6_DAC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream0, "DMA2_Stream0_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream1, "DMA2_Stream1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream2, "DMA2_Stream2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream3, "DMA2_Stream3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream4, "DMA2_Stream4_IRQHandler")
	_ = interrupt.Register(IRQ_ETH, "ETH_IRQHandler")
	_ = interrupt.Register(IRQ_ETH_WKUP, "ETH_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_TX, "CAN2_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_RX0, "CAN2_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_RX1, "CAN2_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN2_SCE, "CAN2_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS, "OTG_FS_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream5, "DMA2_Stream5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream6, "DMA2_Stream6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Stream7, "DMA2_Stream7_IRQHandler")
	_ = interrupt.Register(IRQ_USART6, "USART6_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_EV, "I2C3_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_ER, "I2C3_ER_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_HS_EP1_OUT, "OTG_HS_EP1_OUT_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_HS_EP1_IN, "OTG_HS_EP1_IN_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_HS_WKUP, "OTG_HS_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_HS, "OTG_HS_IRQHandler")
	_ = interrupt.Register(IRQ_DCMI, "DCMI_IRQHandler")
	_ = interrupt.Register(IRQ_CRYP, "CRYP_IRQHandler")
	_ = interrupt.Register(IRQ_HASH_RNG, "HASH_RNG_IRQHandler")
	_ = interrupt.Register(IRQ_FPU, "FPU_IRQHandler")
	_ = interrupt.Register(IRQ_UART7, "UART7_IRQHandler")
	_ = interrupt.Register(IRQ_UART8, "UART8_IRQHandler")
	_ = interrupt.Register(IRQ_SPI4, "SPI4_IRQHandler")
	_ = interrupt.Register(IRQ_SPI5, "SPI5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI6, "SPI6_IRQHandler")
	_ = interrupt.Register(IRQ_SAI1, "SAI1_IRQHandler")
	_ = interrupt.Register(IRQ_LTDC, "LTDC_IRQHandler")
	_ = interrupt.Register(IRQ_LTDC_ER, "LTDC_ER_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2D, "DMA2D_IRQHandler")
	_ = interrupt.Register(IRQ_SAI2, "SAI2_IRQHandler")
	_ = interrupt.Register(IRQ_QuadSPI, "QuadSPI_IRQHandler")
	_ = interrupt.Register(IRQ_LP_Timer1, "LP_Timer1_IRQHandler")
	_ = interrupt.Register(IRQ_HDMI_CEC, "HDMI_CEC_IRQHandler")
	_ = interrupt.Register(IRQ_I2C4_EV, "I2C4_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C4_ER, "I2C4_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPDIFRX, "SPDIFRX_IRQHandler")
	_ = interrupt.Register(IRQ_DSIHOST, "DSIHOST_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT0, "DFSDM1_FLT0_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT1, "DFSDM1_FLT1_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT2, "DFSDM1_FLT2_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT3, "DFSDM1_FLT3_IRQHandler")
	_ = interrupt.Register(IRQ_SDMMC2, "SDMMC2_IRQHandler")
	_ = interrupt.Register(IRQ_CAN3_TX, "CAN3_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN3_RX0, "CAN3_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN3_RX1, "CAN3_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN3_SCE, "CAN3_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_JPEG, "JPEG_IRQHandler")
	_ = interrupt.Register(IRQ_MDIOS, "MDIOS_IRQHandler")
)

// Peripherals.
var (
	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))

	// Hash processor
	HASH = (*HASH_Type)(unsafe.Pointer(uintptr(0x50060400)))

	// Cryptographic processor
	CRYP = (*CRYP_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// Digital camera interface
	DCMI = (*DCMI_Type)(unsafe.Pointer(uintptr(0x50050000)))

	// Flexible memory controller
	FMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Analog-to-digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General purpose timers
	TIM9 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General-purpose-timers
	TIM10 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Ethernet: media access control (MAC)
	Ethernet_MAC = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Cryptographic processor
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Controller area network
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// FLASH
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))

	// LCD-TFT Controller
	LTDC = (*LTDC_Type)(unsafe.Pointer(uintptr(0x40016800)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// DMA2D controller
	DMA2D = (*DMA2D_Type)(unsafe.Pointer(uintptr(0x4002b000)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// HDMI-CEC controller
	CEC = (*CEC_Type)(unsafe.Pointer(uintptr(0x40006c00)))

	// Receiver Interface
	SPDIFRX = (*SPDIF_RX_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Secure digital input/output interface
	SDMMC1 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB on the go high speed
	OTG_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Management data input/output slave
	MDIOS = (*MDIOS_Type)(unsafe.Pointer(uintptr(0x40017800)))

	// Digital filter for sigma delta modulators
	DFSDM = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40017400)))

	// JPEG codec
	JPEG = (*JPEG_Type)(unsafe.Pointer(uintptr(0x50051000)))

	// Ethernet: MAC management counters
	Ethernet_MMC = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028100)))

	// Ethernet: Precision time protocol
	Ethernet_PTP = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40028700)))

	// Ethernet: DMA controller operation
	Ethernet_DMA = (*Ethernet_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// USB on the go full speed
	OTG_FS_HOST = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00)))

	// USB on the go high speed
	OTG_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400)))

	// USB on the go high speed
	OTG_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// USB on the go high speed
	OTG_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00)))

	// DSI Host
	DSI = (*DSI_Type)(unsafe.Pointer(uintptr(0x40016c00)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Processor features
	PF = (*PF_Type)(unsafe.Pointer(uintptr(0xe000ed78)))

	// Access control
	AC = (*AC_Type)(unsafe.Pointer(uintptr(0xe000ef90)))

	// ADC common registers
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))

	// Debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// General-purpose I/Os
	GPIOK = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022800)))

	// General-purpose I/Os
	GPIOJ = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022400)))

	// General-purpose I/Os
	GPIOI = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Serial peripheral interface
	SPI5 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface
	SPI6 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// Analog-to-digital converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012100)))

	// Analog-to-digital converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012200)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// General purpose timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General purpose timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General-purpose-timers
	TIM11 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// General-purpose-timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// General-purpose-timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Controller area network
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006800)))

	// Controller area network
	CAN3 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40003400)))

	// Serial audio interface
	SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015c00)))

	// Secure digital input/output interface
	SDMMC2 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40011c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C4 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART8 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART7 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007800)))
)

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// Hash processor
type HASH_Type struct {
	CR       volatile.Register32 // 0x0
	DIN      volatile.Register32 // 0x4
	STR      volatile.Register32 // 0x8
	HR0      volatile.Register32 // 0xC
	HR1      volatile.Register32 // 0x10
	HR2      volatile.Register32 // 0x14
	HR3      volatile.Register32 // 0x18
	HR4      volatile.Register32 // 0x1C
	IMR      volatile.Register32 // 0x20
	SR       volatile.Register32 // 0x24
	_        [208]byte
	CSR0     volatile.Register32 // 0xF8
	CSR1     volatile.Register32 // 0xFC
	CSR2     volatile.Register32 // 0x100
	CSR3     volatile.Register32 // 0x104
	CSR4     volatile.Register32 // 0x108
	CSR5     volatile.Register32 // 0x10C
	CSR6     volatile.Register32 // 0x110
	CSR7     volatile.Register32 // 0x114
	CSR8     volatile.Register32 // 0x118
	CSR9     volatile.Register32 // 0x11C
	CSR10    volatile.Register32 // 0x120
	CSR11    volatile.Register32 // 0x124
	CSR12    volatile.Register32 // 0x128
	CSR13    volatile.Register32 // 0x12C
	CSR14    volatile.Register32 // 0x130
	CSR15    volatile.Register32 // 0x134
	CSR16    volatile.Register32 // 0x138
	CSR17    volatile.Register32 // 0x13C
	CSR18    volatile.Register32 // 0x140
	CSR19    volatile.Register32 // 0x144
	CSR20    volatile.Register32 // 0x148
	CSR21    volatile.Register32 // 0x14C
	CSR22    volatile.Register32 // 0x150
	CSR23    volatile.Register32 // 0x154
	CSR24    volatile.Register32 // 0x158
	CSR25    volatile.Register32 // 0x15C
	CSR26    volatile.Register32 // 0x160
	CSR27    volatile.Register32 // 0x164
	CSR28    volatile.Register32 // 0x168
	CSR29    volatile.Register32 // 0x16C
	CSR30    volatile.Register32 // 0x170
	CSR31    volatile.Register32 // 0x174
	CSR32    volatile.Register32 // 0x178
	CSR33    volatile.Register32 // 0x17C
	CSR34    volatile.Register32 // 0x180
	CSR35    volatile.Register32 // 0x184
	CSR36    volatile.Register32 // 0x188
	CSR37    volatile.Register32 // 0x18C
	CSR38    volatile.Register32 // 0x190
	CSR39    volatile.Register32 // 0x194
	CSR40    volatile.Register32 // 0x198
	CSR41    volatile.Register32 // 0x19C
	CSR42    volatile.Register32 // 0x1A0
	CSR43    volatile.Register32 // 0x1A4
	CSR44    volatile.Register32 // 0x1A8
	CSR45    volatile.Register32 // 0x1AC
	CSR46    volatile.Register32 // 0x1B0
	CSR47    volatile.Register32 // 0x1B4
	CSR48    volatile.Register32 // 0x1B8
	CSR49    volatile.Register32 // 0x1BC
	CSR50    volatile.Register32 // 0x1C0
	CSR51    volatile.Register32 // 0x1C4
	CSR52    volatile.Register32 // 0x1C8
	CSR53    volatile.Register32 // 0x1CC
	_        [320]byte
	HASH_HR0 volatile.Register32 // 0x310
	HASH_HR1 volatile.Register32 // 0x314
	HASH_HR2 volatile.Register32 // 0x318
	HASH_HR3 volatile.Register32 // 0x31C
	HASH_HR4 volatile.Register32 // 0x320
	HASH_HR5 volatile.Register32 // 0x324
	HASH_HR6 volatile.Register32 // 0x328
	HASH_HR7 volatile.Register32 // 0x32C
}

// Cryptographic processor
type CRYP_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DIN   volatile.Register32 // 0x8
	DOUT  volatile.Register32 // 0xC
	DMACR volatile.Register32 // 0x10
	IMSCR volatile.Register32 // 0x14
	RISR  volatile.Register32 // 0x18
	MISR  volatile.Register32 // 0x1C
	KEY   [4]struct {
		KLR volatile.Register32
		KRR volatile.Register32
	} // 0x20
	INIT [2]struct {
		IVLR volatile.Register32
		IVRR volatile.Register32
	} // 0x40
	CSGCMCCM0R volatile.Register32 // 0x50
	CSGCMCCM1R volatile.Register32 // 0x54
	CSGCMCCM2R volatile.Register32 // 0x58
	CSGCMCCM3R volatile.Register32 // 0x5C
	CSGCMCCM4R volatile.Register32 // 0x60
	CSGCMCCM5R volatile.Register32 // 0x64
	CSGCMCCM6R volatile.Register32 // 0x68
	CSGCMCCM7R volatile.Register32 // 0x6C
	CSGCM0R    volatile.Register32 // 0x70
	CSGCM1R    volatile.Register32 // 0x74
	CSGCM2R    volatile.Register32 // 0x78
	CSGCM3R    volatile.Register32 // 0x7C
	CSGCM4R    volatile.Register32 // 0x80
	CSGCM5R    volatile.Register32 // 0x84
	CSGCM6R    volatile.Register32 // 0x88
	CSGCM7R    volatile.Register32 // 0x8C
}

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// Flexible memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [96]byte
	PCR   volatile.Register32 // 0x80
	SR    volatile.Register32 // 0x84
	PMEM  volatile.Register32 // 0x88
	PATT  volatile.Register32 // 0x8C
	_     [4]byte
	ECCR  volatile.Register32 // 0x94
	_     [108]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
	_     [32]byte
	SDCR1 volatile.Register32 // 0x140
	SDCR2 volatile.Register32 // 0x144
	SDTR1 volatile.Register32 // 0x148
	SDTR2 volatile.Register32 // 0x14C
	SDCMR volatile.Register32 // 0x150
	SDRTR volatile.Register32 // 0x154
	SDSR  volatile.Register32 // 0x158
}

// DMA controller
type DMA_Type struct {
	LISR  volatile.Register32 // 0x0
	HISR  volatile.Register32 // 0x4
	LIFCR volatile.Register32 // 0x8
	HIFCR volatile.Register32 // 0xC
	ST    [8]struct {
		CR   volatile.Register32
		NDTR volatile.Register32
		PAR  volatile.Register32
		M0AR volatile.Register32
		M1AR volatile.Register32
		FCR  volatile.Register32
	} // 0x10
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	AHB3RSTR   volatile.Register32 // 0x18
	_          [4]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	AHB3ENR    volatile.Register32 // 0x38
	_          [4]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	AHB3LPENR  volatile.Register32 // 0x58
	_          [4]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
	PLLSAICFGR volatile.Register32 // 0x88
	DCKCFGR1   volatile.Register32 // 0x8C
	DCKCFGR2   volatile.Register32 // 0x90
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRM   volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Power control
type PWR_Type struct {
	CR1  volatile.Register32 // 0x0
	CSR1 volatile.Register32 // 0x4
	CR2  volatile.Register32 // 0x8
	CSR2 volatile.Register32 // 0xC
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	_            [4]byte
	CCMR3_Output volatile.Register32 // 0x54
	CCR5         volatile.Register32 // 0x58
	CRR6         volatile.Register32 // 0x5C
	AF1          volatile.Register32 // 0x60
	AF2          volatile.Register32 // 0x64
}

// Ethernet: media access control (MAC)
type Ethernet_Type struct {
	MACCR      volatile.Register32 // 0x0
	MACFFR     volatile.Register32 // 0x4
	MACHTHR    volatile.Register32 // 0x8
	MACHTLR    volatile.Register32 // 0xC
	MACMIIAR   volatile.Register32 // 0x10
	MACMIIDR   volatile.Register32 // 0x14
	MACFCR     volatile.Register32 // 0x18
	MACVLANTR  volatile.Register32 // 0x1C
	_          [12]byte
	MACPMTCSR  volatile.Register32 // 0x2C
	_          [4]byte
	MACDBGR    volatile.Register32 // 0x34
	MACSR      volatile.Register32 // 0x38
	MACIMR     volatile.Register32 // 0x3C
	MACA0HR    volatile.Register32 // 0x40
	MACA0LR    volatile.Register32 // 0x44
	MACA1HR    volatile.Register32 // 0x48
	MACA1LR    volatile.Register32 // 0x4C
	MACA2HR    volatile.Register32 // 0x50
	MACA2LR    volatile.Register32 // 0x54
	MACA3HR    volatile.Register32 // 0x58
	MACA3LR    volatile.Register32 // 0x5C
	MACRWUFFER volatile.Register32 // 0x60
}

// Cryptographic processor
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	INIT volatile.Register32 // 0xC
	POL  volatile.Register32 // 0x10
}

// Controller area network
type CAN_Type struct {
	MCR  volatile.Register32 // 0x0
	MSR  volatile.Register32 // 0x4
	TSR  volatile.Register32 // 0x8
	RF0R volatile.Register32 // 0xC
	RF1R volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	ESR  volatile.Register32 // 0x18
	BTR  volatile.Register32 // 0x1C
	_    [352]byte
	TX   [3]struct {
		TIR  volatile.Register32
		TDTR volatile.Register32
		TDLR volatile.Register32
		TDHR volatile.Register32
	} // 0x180
	RX [2]struct {
		RIR  volatile.Register32
		RDTR volatile.Register32
		RDLR volatile.Register32
		RDHR volatile.Register32
	} // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]struct {
		FR1 volatile.Register32
		FR2 volatile.Register32
	} // 0x240
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
	OPTCR1  volatile.Register32 // 0x18
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// LCD-TFT Controller
type LTDC_Type struct {
	_     [8]byte
	SSCR  volatile.Register32 // 0x8
	BPCR  volatile.Register32 // 0xC
	AWCR  volatile.Register32 // 0x10
	TWCR  volatile.Register32 // 0x14
	GCR   volatile.Register32 // 0x18
	_     [8]byte
	SRCR  volatile.Register32 // 0x24
	_     [4]byte
	BCCR  volatile.Register32 // 0x2C
	_     [4]byte
	IER   volatile.Register32 // 0x34
	ISR   volatile.Register32 // 0x38
	ICR   volatile.Register32 // 0x3C
	LIPCR volatile.Register32 // 0x40
	CPSR  volatile.Register32 // 0x44
	CDSR  volatile.Register32 // 0x48
	_     [56]byte
	LAYER [2]struct {
		CR     volatile.Register32
		WHPCR  volatile.Register32
		WVPCR  volatile.Register32
		CKCR   volatile.Register32
		PFCR   volatile.Register32
		CACR   volatile.Register32
		DCCR   volatile.Register32
		BFCR   volatile.Register32
		_      [8]byte
		CFBAR  volatile.Register32
		CFBLR  volatile.Register32
		CFBLNR volatile.Register32
		_      [12]byte
		CLUTWR volatile.Register32
		_      [60]byte
	} // 0x84
}

// Serial audio interface
type SAI_Type struct {
	GCR volatile.Register32 // 0x0
	CH  [2]struct {
		CR1   volatile.Register32
		CR2   volatile.Register32
		FRCR  volatile.Register32
		SLOTR volatile.Register32
		IM    volatile.Register32
		SR    volatile.Register32
		CLRFR volatile.Register32
		DR    volatile.Register32
	} // 0x4
}

// DMA2D controller
type DMA2D_Type struct {
	CR      volatile.Register32 // 0x0
	ISR     volatile.Register32 // 0x4
	IFCR    volatile.Register32 // 0x8
	FGMAR   volatile.Register32 // 0xC
	FGOR    volatile.Register32 // 0x10
	BGMAR   volatile.Register32 // 0x14
	BGOR    volatile.Register32 // 0x18
	FGPFCCR volatile.Register32 // 0x1C
	FGCOLR  volatile.Register32 // 0x20
	BGPFCCR volatile.Register32 // 0x24
	BGCOLR  volatile.Register32 // 0x28
	FGCMAR  volatile.Register32 // 0x2C
	BGCMAR  volatile.Register32 // 0x30
	OPFCCR  volatile.Register32 // 0x34
	OCOLR   volatile.Register32 // 0x38
	OMAR    volatile.Register32 // 0x3C
	OOR     volatile.Register32 // 0x40
	NLR     volatile.Register32 // 0x44
	LWR     volatile.Register32 // 0x48
	AMTCR   volatile.Register32 // 0x4C
	_       [944]byte
	FGCLUT  volatile.Register32 // 0x400
	_       [1020]byte
	BGCLUT  volatile.Register32 // 0x800
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// HDMI-CEC controller
type CEC_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	TXDR volatile.Register32 // 0x8
	RXDR volatile.Register32 // 0xC
	ISR  volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
}

// Receiver Interface
type SPDIF_RX_Type struct {
	CR   volatile.Register32 // 0x0
	IMR  volatile.Register32 // 0x4
	SR   volatile.Register32 // 0x8
	IFCR volatile.Register32 // 0xC
	DR   volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	DIR  volatile.Register32 // 0x18
}

// Secure digital input/output interface
type SDMMC_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	OTG_FS_GOTGCTL         volatile.Register32 // 0x0
	OTG_FS_GOTGINT         volatile.Register32 // 0x4
	OTG_FS_GAHBCFG         volatile.Register32 // 0x8
	OTG_FS_GUSBCFG         volatile.Register32 // 0xC
	OTG_FS_GRSTCTL         volatile.Register32 // 0x10
	OTG_FS_GINTSTS         volatile.Register32 // 0x14
	OTG_FS_GINTMSK         volatile.Register32 // 0x18
	OTG_FS_GRXSTSR_Device  volatile.Register32 // 0x1C
	OTG_FS_GRXSTSP_Device  volatile.Register32 // 0x20
	OTG_FS_GRXFSIZ         volatile.Register32 // 0x24
	OTG_FS_DIEPTXF0_Device volatile.Register32 // 0x28
	OTG_FS_HNPTXSTS        volatile.Register32 // 0x2C
	OTG_FS_GI2CCTL         volatile.Register32 // 0x30
	_                      [4]byte
	OTG_FS_GCCFG           volatile.Register32 // 0x38
	OTG_FS_CID             volatile.Register32 // 0x3C
	_                      [20]byte
	OTG_FS_GLPMCFG         volatile.Register32 // 0x54
	OTG_FS_GPWRDN          volatile.Register32 // 0x58
	_                      [4]byte
	OTG_FS_GADPCTL         volatile.Register32 // 0x60
	_                      [156]byte
	OTG_FS_HPTXFSIZ        volatile.Register32 // 0x100
	OTG_FS_DIEPTXF1        volatile.Register32 // 0x104
	OTG_FS_DIEPTXF2        volatile.Register32 // 0x108
	OTG_FS_DIEPTXF3        volatile.Register32 // 0x10C
	OTG_FS_DIEPTXF4        volatile.Register32 // 0x110
	OTG_FS_DIEPTXF5        volatile.Register32 // 0x114
}

// USB on the go high speed
type USB_OTG_HS_Type struct {
	OTG_HS_GOTGCTL        volatile.Register32 // 0x0
	OTG_HS_GOTGINT        volatile.Register32 // 0x4
	OTG_HS_GAHBCFG        volatile.Register32 // 0x8
	OTG_HS_GUSBCFG        volatile.Register32 // 0xC
	OTG_HS_GRSTCTL        volatile.Register32 // 0x10
	OTG_HS_GINTSTS        volatile.Register32 // 0x14
	OTG_HS_GINTMSK        volatile.Register32 // 0x18
	OTG_HS_GRXSTSR_Host   volatile.Register32 // 0x1C
	OTG_HS_GRXSTSP_Host   volatile.Register32 // 0x20
	OTG_HS_GRXFSIZ        volatile.Register32 // 0x24
	OTG_HS_HNPTXFSIZ_Host volatile.Register32 // 0x28
	OTG_HS_GNPTXSTS       volatile.Register32 // 0x2C
	_                     [8]byte
	OTG_HS_GCCFG          volatile.Register32 // 0x38
	OTG_HS_CID            volatile.Register32 // 0x3C
	_                     [20]byte
	OTG_HS_GLPMCFG        volatile.Register32 // 0x54
	_                     [168]byte
	OTG_HS_HPTXFSIZ       volatile.Register32 // 0x100
	OTG_HS_DIEPTXF1       volatile.Register32 // 0x104
	OTG_HS_DIEPTXF2       volatile.Register32 // 0x108
	_                     [16]byte
	OTG_HS_DIEPTXF3       volatile.Register32 // 0x11C
	OTG_HS_DIEPTXF4       volatile.Register32 // 0x120
	OTG_HS_DIEPTXF5       volatile.Register32 // 0x124
	OTG_HS_DIEPTXF6       volatile.Register32 // 0x128
	OTG_HS_DIEPTXF7       volatile.Register32 // 0x12C
}

// Management data input/output slave
type MDIOS_Type struct {
	CR      volatile.Register32 // 0x0
	WRFR    volatile.Register32 // 0x4
	CWRFR   volatile.Register32 // 0x8
	RDFR    volatile.Register32 // 0xC
	CRDFR   volatile.Register32 // 0x10
	SR      volatile.Register32 // 0x14
	CLRFR   volatile.Register32 // 0x18
	DINR0   volatile.Register32 // 0x1C
	DINR1   volatile.Register32 // 0x20
	DINR2   volatile.Register32 // 0x24
	DINR3   volatile.Register32 // 0x28
	DINR4   volatile.Register32 // 0x2C
	DINR5   volatile.Register32 // 0x30
	DINR6   volatile.Register32 // 0x34
	DINR7   volatile.Register32 // 0x38
	DINR8   volatile.Register32 // 0x3C
	DINR9   volatile.Register32 // 0x40
	DINR10  volatile.Register32 // 0x44
	DINR11  volatile.Register32 // 0x48
	DINR12  volatile.Register32 // 0x4C
	DINR13  volatile.Register32 // 0x50
	DINR14  volatile.Register32 // 0x54
	DINR15  volatile.Register32 // 0x58
	DINR16  volatile.Register32 // 0x5C
	DINR17  volatile.Register32 // 0x60
	DINR18  volatile.Register32 // 0x64
	DINR19  volatile.Register32 // 0x68
	DINR20  volatile.Register32 // 0x6C
	DINR21  volatile.Register32 // 0x70
	DINR22  volatile.Register32 // 0x74
	DINR23  volatile.Register32 // 0x78
	DINR24  volatile.Register32 // 0x7C
	DINR25  volatile.Register32 // 0x80
	DINR26  volatile.Register32 // 0x84
	DINR27  volatile.Register32 // 0x88
	DINR28  volatile.Register32 // 0x8C
	DINR29  volatile.Register32 // 0x90
	DINR30  volatile.Register32 // 0x94
	DINR31  volatile.Register32 // 0x98
	DOUTR0  volatile.Register32 // 0x9C
	DOUTR1  volatile.Register32 // 0xA0
	DOUTR2  volatile.Register32 // 0xA4
	DOUTR3  volatile.Register32 // 0xA8
	DOUTR4  volatile.Register32 // 0xAC
	DOUTR5  volatile.Register32 // 0xB0
	DOUTR6  volatile.Register32 // 0xB4
	DOUTR7  volatile.Register32 // 0xB8
	DOUTR8  volatile.Register32 // 0xBC
	DOUTR9  volatile.Register32 // 0xC0
	DOUTR10 volatile.Register32 // 0xC4
	DOUTR11 volatile.Register32 // 0xC8
	DOUTR12 volatile.Register32 // 0xCC
	DOUTR13 volatile.Register32 // 0xD0
	DOUTR14 volatile.Register32 // 0xD4
	DOUTR15 volatile.Register32 // 0xD8
	DOUTR16 volatile.Register32 // 0xDC
	DOUTR17 volatile.Register32 // 0xE0
	DOUTR18 volatile.Register32 // 0xE4
	DOUTR19 volatile.Register32 // 0xE8
	DOUTR20 volatile.Register32 // 0xEC
	DOUTR21 volatile.Register32 // 0xF0
	DOUTR22 volatile.Register32 // 0xF4
	DOUTR23 volatile.Register32 // 0xF8
	DOUTR24 volatile.Register32 // 0xFC
	DOUTR25 volatile.Register32 // 0x100
	DOUTR26 volatile.Register32 // 0x104
	DOUTR27 volatile.Register32 // 0x108
	DOUTR28 volatile.Register32 // 0x10C
	DOUTR29 volatile.Register32 // 0x110
	DOUTR30 volatile.Register32 // 0x114
	DOUTR31 volatile.Register32 // 0x118
}

// Digital filter for sigma delta modulators
type DFSDM_Type struct {
	DFSDM_CHCFG0R1  volatile.Register32 // 0x0
	DFSDM_CHCFG0R2  volatile.Register32 // 0x4
	DFSDM_AWSCD0R   volatile.Register32 // 0x8
	DFSDM_CHWDAT0R  volatile.Register32 // 0xC
	DFSDM_CHDATIN0R volatile.Register32 // 0x10
	_               [12]byte
	DFSDM_CHCFG1R1  volatile.Register32 // 0x20
	DFSDM_CHCFG1R2  volatile.Register32 // 0x24
	DFSDM_AWSCD1R   volatile.Register32 // 0x28
	DFSDM_CHWDAT1R  volatile.Register32 // 0x2C
	DFSDM_CHDATIN1R volatile.Register32 // 0x30
	_               [12]byte
	DFSDM_CHCFG2R1  volatile.Register32 // 0x40
	DFSDM_CHCFG2R2  volatile.Register32 // 0x44
	DFSDM_AWSCD2R   volatile.Register32 // 0x48
	DFSDM_CHWDAT2R  volatile.Register32 // 0x4C
	DFSDM_CHDATIN2R volatile.Register32 // 0x50
	_               [12]byte
	DFSDM_CHCFG3R1  volatile.Register32 // 0x60
	DFSDM_CHCFG3R2  volatile.Register32 // 0x64
	DFSDM_AWSCD3R   volatile.Register32 // 0x68
	DFSDM_CHWDAT3R  volatile.Register32 // 0x6C
	DFSDM_CHDATIN3R volatile.Register32 // 0x70
	_               [12]byte
	DFSDM_CHCFG4R1  volatile.Register32 // 0x80
	DFSDM_CHCFG4R2  volatile.Register32 // 0x84
	DFSDM_AWSCD4R   volatile.Register32 // 0x88
	DFSDM_CHWDAT4R  volatile.Register32 // 0x8C
	DFSDM_CHDATIN4R volatile.Register32 // 0x90
	_               [12]byte
	DFSDM_CHCFG5R1  volatile.Register32 // 0xA0
	DFSDM_CHCFG5R2  volatile.Register32 // 0xA4
	DFSDM_AWSCD5R   volatile.Register32 // 0xA8
	DFSDM_CHWDAT5R  volatile.Register32 // 0xAC
	DFSDM_CHDATIN5R volatile.Register32 // 0xB0
	_               [12]byte
	DFSDM_CHCFG6R1  volatile.Register32 // 0xC0
	DFSDM_CHCFG6R2  volatile.Register32 // 0xC4
	DFSDM_AWSCD6R   volatile.Register32 // 0xC8
	DFSDM_CHWDAT6R  volatile.Register32 // 0xCC
	DFSDM_CHDATIN6R volatile.Register32 // 0xD0
	_               [12]byte
	DFSDM_CHCFG7R1  volatile.Register32 // 0xE0
	DFSDM_CHCFG7R2  volatile.Register32 // 0xE4
	DFSDM_AWSCD7R   volatile.Register32 // 0xE8
	DFSDM_CHWDAT7R  volatile.Register32 // 0xEC
	DFSDM_CHDATIN7R volatile.Register32 // 0xF0
	_               [12]byte
	DFSDM0_CR1      volatile.Register32 // 0x100
	DFSDM0_CR2      volatile.Register32 // 0x104
	DFSDM0_ISR      volatile.Register32 // 0x108
	DFSDM0_ICR      volatile.Register32 // 0x10C
	DFSDM0_JCHGR    volatile.Register32 // 0x110
	DFSDM0_FCR      volatile.Register32 // 0x114
	DFSDM0_JDATAR   volatile.Register32 // 0x118
	DFSDM0_RDATAR   volatile.Register32 // 0x11C
	DFSDM0_AWHTR    volatile.Register32 // 0x120
	DFSDM0_AWLTR    volatile.Register32 // 0x124
	DFSDM0_AWSR     volatile.Register32 // 0x128
	DFSDM0_AWCFR    volatile.Register32 // 0x12C
	DFSDM0_EXMAX    volatile.Register32 // 0x130
	DFSDM0_EXMIN    volatile.Register32 // 0x134
	DFSDM0_CNVTIMR  volatile.Register32 // 0x138
	_               [68]byte
	DFSDM1_CR1      volatile.Register32 // 0x180
	DFSDM1_CR2      volatile.Register32 // 0x184
	DFSDM1_ISR      volatile.Register32 // 0x188
	DFSDM1_ICR      volatile.Register32 // 0x18C
	DFSDM1_JCHGR    volatile.Register32 // 0x190
	DFSDM1_FCR      volatile.Register32 // 0x194
	DFSDM1_JDATAR   volatile.Register32 // 0x198
	_               [4]byte
	DFSDM1_AWHTR    volatile.Register32 // 0x1A0
	DFSDM1_AWLTR    volatile.Register32 // 0x1A4
	DFSDM1_AWSR     volatile.Register32 // 0x1A8
	DFSDM1_AWCFR    volatile.Register32 // 0x1AC
	DFSDM1_EXMAX    volatile.Register32 // 0x1B0
	DFSDM1_EXMIN    volatile.Register32 // 0x1B4
	DFSDM1_CNVTIMR  volatile.Register32 // 0x1B8
	_               [68]byte
	DFSDM2_CR1      volatile.Register32 // 0x200
	DFSDM2_CR2      volatile.Register32 // 0x204
	DFSDM2_ISR      volatile.Register32 // 0x208
	DFSDM2_ICR      volatile.Register32 // 0x20C
	DFSDM2_JCHGR    volatile.Register32 // 0x210
	DFSDM2_FCR      volatile.Register32 // 0x214
	DFSDM2_JDATAR   volatile.Register32 // 0x218
	_               [4]byte
	DFSDM2_AWHTR    volatile.Register32 // 0x220
	DFSDM2_AWLTR    volatile.Register32 // 0x224
	DFSDM2_AWSR     volatile.Register32 // 0x228
	DFSDM2_AWCFR    volatile.Register32 // 0x22C
	DFSDM2_EXMAX    volatile.Register32 // 0x230
	DFSDM2_EXMIN    volatile.Register32 // 0x234
	DFSDM2_CNVTIMR  volatile.Register32 // 0x238
	_               [100]byte
	DFSDM3_AWHTR    volatile.Register32 // 0x2A0
	DFSDM3_AWLTR    volatile.Register32 // 0x2A4
	DFSDM3_AWSR     volatile.Register32 // 0x2A8
	DFSDM3_AWCFR    volatile.Register32 // 0x2AC
	DFSDM3_EXMAX    volatile.Register32 // 0x2B0
	DFSDM3_EXMIN    volatile.Register32 // 0x2B4
	DFSDM3_CNVTIMR  volatile.Register32 // 0x2B8
	_               [84]byte
	DFSDM3_JCHGR    volatile.Register32 // 0x310
	DFSDM3_FCR      volatile.Register32 // 0x314
	DFSDM3_JDATAR   volatile.Register32 // 0x318
	_               [100]byte
	DFSDM3_CR1      volatile.Register32 // 0x380
	DFSDM3_CR2      volatile.Register32 // 0x384
	DFSDM3_ISR      volatile.Register32 // 0x388
	DFSDM3_ICR      volatile.Register32 // 0x38C
}

// JPEG codec
type JPEG_Type struct {
	JPEG_CONFR0    volatile.Register32 // 0x0
	JPEG_CONFR1    volatile.Register32 // 0x4
	JPEG_CONFR2    volatile.Register32 // 0x8
	JPEG_CONFR3    volatile.Register32 // 0xC
	JPEG_CONFR4    volatile.Register32 // 0x10
	JPEG_CONFR5    volatile.Register32 // 0x14
	JPEG_CONFR6    volatile.Register32 // 0x18
	JPEG_CONFR7    volatile.Register32 // 0x1C
	_              [16]byte
	JPEG_CR        volatile.Register32 // 0x30
	JPEG_SR        volatile.Register32 // 0x34
	JPEG_CFR       volatile.Register32 // 0x38
	_              [4]byte
	JPEG_DIR       volatile.Register32 // 0x40
	JPEG_DOR       volatile.Register32 // 0x44
	_              [8]byte
	QMEM0_0        volatile.Register32 // 0x50
	QMEM0_1        volatile.Register32 // 0x54
	QMEM0_2        volatile.Register32 // 0x58
	QMEM0_3        volatile.Register32 // 0x5C
	QMEM0_4        volatile.Register32 // 0x60
	QMEM0_5        volatile.Register32 // 0x64
	QMEM0_6        volatile.Register32 // 0x68
	QMEM0_7        volatile.Register32 // 0x6C
	QMEM0_8        volatile.Register32 // 0x70
	QMEM0_9        volatile.Register32 // 0x74
	QMEM0_10       volatile.Register32 // 0x78
	QMEM0_11       volatile.Register32 // 0x7C
	QMEM0_12       volatile.Register32 // 0x80
	QMEM0_13       volatile.Register32 // 0x84
	QMEM0_14       volatile.Register32 // 0x88
	QMEM0_15       volatile.Register32 // 0x8C
	QMEM1_0        volatile.Register32 // 0x90
	QMEM1_1        volatile.Register32 // 0x94
	QMEM1_2        volatile.Register32 // 0x98
	QMEM1_3        volatile.Register32 // 0x9C
	QMEM1_4        volatile.Register32 // 0xA0
	QMEM1_5        volatile.Register32 // 0xA4
	QMEM1_6        volatile.Register32 // 0xA8
	QMEM1_7        volatile.Register32 // 0xAC
	QMEM1_8        volatile.Register32 // 0xB0
	QMEM1_9        volatile.Register32 // 0xB4
	QMEM1_10       volatile.Register32 // 0xB8
	QMEM1_11       volatile.Register32 // 0xBC
	QMEM1_12       volatile.Register32 // 0xC0
	QMEM1_13       volatile.Register32 // 0xC4
	QMEM1_14       volatile.Register32 // 0xC8
	QMEM1_15       volatile.Register32 // 0xCC
	QMEM2_0        volatile.Register32 // 0xD0
	QMEM2_1        volatile.Register32 // 0xD4
	QMEM2_2        volatile.Register32 // 0xD8
	QMEM2_3        volatile.Register32 // 0xDC
	QMEM2_4        volatile.Register32 // 0xE0
	QMEM2_5        volatile.Register32 // 0xE4
	QMEM2_6        volatile.Register32 // 0xE8
	QMEM2_7        volatile.Register32 // 0xEC
	QMEM2_8        volatile.Register32 // 0xF0
	QMEM2_9        volatile.Register32 // 0xF4
	QMEM2_10       volatile.Register32 // 0xF8
	QMEM2_11       volatile.Register32 // 0xFC
	QMEM2_12       volatile.Register32 // 0x100
	QMEM2_13       volatile.Register32 // 0x104
	QMEM2_14       volatile.Register32 // 0x108
	QMEM2_15       volatile.Register32 // 0x10C
	QMEM3_0        volatile.Register32 // 0x110
	QMEM3_1        volatile.Register32 // 0x114
	QMEM3_2        volatile.Register32 // 0x118
	QMEM3_3        volatile.Register32 // 0x11C
	QMEM3_4        volatile.Register32 // 0x120
	QMEM3_5        volatile.Register32 // 0x124
	QMEM3_6        volatile.Register32 // 0x128
	QMEM3_7        volatile.Register32 // 0x12C
	QMEM3_8        volatile.Register32 // 0x130
	QMEM3_9        volatile.Register32 // 0x134
	QMEM3_10       volatile.Register32 // 0x138
	QMEM3_11       volatile.Register32 // 0x13C
	QMEM3_12       volatile.Register32 // 0x140
	QMEM3_13       volatile.Register32 // 0x144
	QMEM3_14       volatile.Register32 // 0x148
	QMEM3_15       volatile.Register32 // 0x14C
	HUFFMIN_0      volatile.Register32 // 0x150
	HUFFMIN_1      volatile.Register32 // 0x154
	HUFFMIN_2      volatile.Register32 // 0x158
	HUFFMIN_3      volatile.Register32 // 0x15C
	HUFFMIN_4      volatile.Register32 // 0x160
	HUFFMIN_5      volatile.Register32 // 0x164
	HUFFMIN_6      volatile.Register32 // 0x168
	HUFFMIN_7      volatile.Register32 // 0x16C
	HUFFMIN_8      volatile.Register32 // 0x170
	HUFFMIN_9      volatile.Register32 // 0x174
	HUFFMIN_10     volatile.Register32 // 0x178
	HUFFMIN_11     volatile.Register32 // 0x17C
	HUFFMIN_12     volatile.Register32 // 0x180
	HUFFMIN_13     volatile.Register32 // 0x184
	HUFFMIN_14     volatile.Register32 // 0x188
	HUFFMIN_15     volatile.Register32 // 0x18C
	HUFFBASE0      volatile.Register32 // 0x190
	HUFFBASE1      volatile.Register32 // 0x194
	HUFFBASE2      volatile.Register32 // 0x198
	HUFFBASE3      volatile.Register32 // 0x19C
	HUFFBASE4      volatile.Register32 // 0x1A0
	HUFFBASE5      volatile.Register32 // 0x1A4
	HUFFBASE6      volatile.Register32 // 0x1A8
	HUFFBASE7      volatile.Register32 // 0x1AC
	HUFFBASE8      volatile.Register32 // 0x1B0
	HUFFBASE9      volatile.Register32 // 0x1B4
	HUFFBASE10     volatile.Register32 // 0x1B8
	HUFFBASE11     volatile.Register32 // 0x1BC
	HUFFBASE12     volatile.Register32 // 0x1C0
	HUFFBASE13     volatile.Register32 // 0x1C4
	HUFFBASE14     volatile.Register32 // 0x1C8
	HUFFBASE15     volatile.Register32 // 0x1CC
	HUFFBASE16     volatile.Register32 // 0x1D0
	HUFFBASE17     volatile.Register32 // 0x1D4
	HUFFBASE18     volatile.Register32 // 0x1D8
	HUFFBASE19     volatile.Register32 // 0x1DC
	HUFFBASE20     volatile.Register32 // 0x1E0
	HUFFBASE21     volatile.Register32 // 0x1E4
	HUFFBASE22     volatile.Register32 // 0x1E8
	HUFFBASE23     volatile.Register32 // 0x1EC
	HUFFBASE24     volatile.Register32 // 0x1F0
	HUFFBASE25     volatile.Register32 // 0x1F4
	HUFFBASE26     volatile.Register32 // 0x1F8
	HUFFBASE27     volatile.Register32 // 0x1FC
	HUFFBASE28     volatile.Register32 // 0x200
	HUFFBASE29     volatile.Register32 // 0x204
	HUFFBASE30     volatile.Register32 // 0x208
	HUFFBASE31     volatile.Register32 // 0x20C
	HUFFSYMB0      volatile.Register32 // 0x210
	HUFFSYMB1      volatile.Register32 // 0x214
	HUFFSYMB2      volatile.Register32 // 0x218
	HUFFSYMB3      volatile.Register32 // 0x21C
	HUFFSYMB4      volatile.Register32 // 0x220
	HUFFSYMB5      volatile.Register32 // 0x224
	HUFFSYMB6      volatile.Register32 // 0x228
	HUFFSYMB7      volatile.Register32 // 0x22C
	HUFFSYMB8      volatile.Register32 // 0x230
	HUFFSYMB9      volatile.Register32 // 0x234
	HUFFSYMB10     volatile.Register32 // 0x238
	HUFFSYMB11     volatile.Register32 // 0x23C
	HUFFSYMB12     volatile.Register32 // 0x240
	HUFFSYMB13     volatile.Register32 // 0x244
	HUFFSYMB14     volatile.Register32 // 0x248
	HUFFSYMB15     volatile.Register32 // 0x24C
	HUFFSYMB16     volatile.Register32 // 0x250
	HUFFSYMB17     volatile.Register32 // 0x254
	HUFFSYMB18     volatile.Register32 // 0x258
	HUFFSYMB19     volatile.Register32 // 0x25C
	HUFFSYMB20     volatile.Register32 // 0x260
	HUFFSYMB21     volatile.Register32 // 0x264
	HUFFSYMB22     volatile.Register32 // 0x268
	HUFFSYMB23     volatile.Register32 // 0x26C
	HUFFSYMB24     volatile.Register32 // 0x270
	HUFFSYMB25     volatile.Register32 // 0x274
	HUFFSYMB26     volatile.Register32 // 0x278
	HUFFSYMB27     volatile.Register32 // 0x27C
	HUFFSYMB28     volatile.Register32 // 0x280
	HUFFSYMB29     volatile.Register32 // 0x284
	HUFFSYMB30     volatile.Register32 // 0x288
	HUFFSYMB31     volatile.Register32 // 0x28C
	HUFFSYMB32     volatile.Register32 // 0x290
	HUFFSYMB33     volatile.Register32 // 0x294
	HUFFSYMB34     volatile.Register32 // 0x298
	HUFFSYMB35     volatile.Register32 // 0x29C
	HUFFSYMB36     volatile.Register32 // 0x2A0
	HUFFSYMB37     volatile.Register32 // 0x2A4
	HUFFSYMB38     volatile.Register32 // 0x2A8
	HUFFSYMB39     volatile.Register32 // 0x2AC
	HUFFSYMB40     volatile.Register32 // 0x2B0
	HUFFSYMB41     volatile.Register32 // 0x2B4
	HUFFSYMB42     volatile.Register32 // 0x2B8
	HUFFSYMB43     volatile.Register32 // 0x2BC
	HUFFSYMB44     volatile.Register32 // 0x2C0
	HUFFSYMB45     volatile.Register32 // 0x2C4
	HUFFSYMB46     volatile.Register32 // 0x2C8
	HUFFSYMB47     volatile.Register32 // 0x2CC
	HUFFSYMB48     volatile.Register32 // 0x2D0
	HUFFSYMB49     volatile.Register32 // 0x2D4
	HUFFSYMB50     volatile.Register32 // 0x2D8
	HUFFSYMB51     volatile.Register32 // 0x2DC
	HUFFSYMB52     volatile.Register32 // 0x2E0
	HUFFSYMB53     volatile.Register32 // 0x2E4
	HUFFSYMB54     volatile.Register32 // 0x2E8
	HUFFSYMB55     volatile.Register32 // 0x2EC
	HUFFSYMB56     volatile.Register32 // 0x2F0
	HUFFSYMB57     volatile.Register32 // 0x2F4
	HUFFSYMB58     volatile.Register32 // 0x2F8
	HUFFSYMB59     volatile.Register32 // 0x2FC
	HUFFSYMB60     volatile.Register32 // 0x300
	HUFFSYMB61     volatile.Register32 // 0x304
	HUFFSYMB62     volatile.Register32 // 0x308
	HUFFSYMB63     volatile.Register32 // 0x30C
	HUFFSYMB64     volatile.Register32 // 0x310
	HUFFSYMB65     volatile.Register32 // 0x314
	HUFFSYMB66     volatile.Register32 // 0x318
	HUFFSYMB67     volatile.Register32 // 0x31C
	HUFFSYMB68     volatile.Register32 // 0x320
	HUFFSYMB69     volatile.Register32 // 0x324
	HUFFSYMB70     volatile.Register32 // 0x328
	HUFFSYMB71     volatile.Register32 // 0x32C
	HUFFSYMB72     volatile.Register32 // 0x330
	HUFFSYMB73     volatile.Register32 // 0x334
	HUFFSYMB74     volatile.Register32 // 0x338
	HUFFSYMB75     volatile.Register32 // 0x33C
	HUFFSYMB76     volatile.Register32 // 0x340
	HUFFSYMB77     volatile.Register32 // 0x344
	HUFFSYMB78     volatile.Register32 // 0x348
	HUFFSYMB79     volatile.Register32 // 0x34C
	HUFFSYMB80     volatile.Register32 // 0x350
	HUFFSYMB81     volatile.Register32 // 0x354
	HUFFSYMB82     volatile.Register32 // 0x358
	HUFFSYMB83     volatile.Register32 // 0x35C
	DHTMEM0        volatile.Register32 // 0x360
	DHTMEM2        volatile.Register32 // 0x364
	DHTMEM3        volatile.Register32 // 0x368
	DHTMEM4        volatile.Register32 // 0x36C
	DHTMEM5        volatile.Register32 // 0x370
	DHTMEM6        volatile.Register32 // 0x374
	DHTMEM7        volatile.Register32 // 0x378
	DHTMEM8        volatile.Register32 // 0x37C
	DHTMEM9        volatile.Register32 // 0x380
	DHTMEM10       volatile.Register32 // 0x384
	DHTMEM11       volatile.Register32 // 0x388
	DHTMEM12       volatile.Register32 // 0x38C
	DHTMEM13       volatile.Register32 // 0x390
	DHTMEM14       volatile.Register32 // 0x394
	DHTMEM15       volatile.Register32 // 0x398
	DHTMEM16       volatile.Register32 // 0x39C
	DHTMEM17       volatile.Register32 // 0x3A0
	DHTMEM18       volatile.Register32 // 0x3A4
	DHTMEM19       volatile.Register32 // 0x3A8
	DHTMEM20       volatile.Register32 // 0x3AC
	DHTMEM21       volatile.Register32 // 0x3B0
	DHTMEM22       volatile.Register32 // 0x3B4
	DHTMEM23       volatile.Register32 // 0x3B8
	DHTMEM24       volatile.Register32 // 0x3BC
	DHTMEM25       volatile.Register32 // 0x3C0
	DHTMEM26       volatile.Register32 // 0x3C4
	DHTMEM27       volatile.Register32 // 0x3C8
	DHTMEM28       volatile.Register32 // 0x3CC
	DHTMEM29       volatile.Register32 // 0x3D0
	DHTMEM30       volatile.Register32 // 0x3D4
	DHTMEM31       volatile.Register32 // 0x3D8
	DHTMEM32       volatile.Register32 // 0x3DC
	DHTMEM33       volatile.Register32 // 0x3E0
	DHTMEM34       volatile.Register32 // 0x3E4
	DHTMEM35       volatile.Register32 // 0x3E8
	DHTMEM36       volatile.Register32 // 0x3EC
	DHTMEM37       volatile.Register32 // 0x3F0
	DHTMEM38       volatile.Register32 // 0x3F4
	DHTMEM39       volatile.Register32 // 0x3F8
	DHTMEM40       volatile.Register32 // 0x3FC
	DHTMEM41       volatile.Register32 // 0x400
	DHTMEM42       volatile.Register32 // 0x404
	DHTMEM43       volatile.Register32 // 0x408
	DHTMEM44       volatile.Register32 // 0x40C
	DHTMEM45       volatile.Register32 // 0x410
	DHTMEM46       volatile.Register32 // 0x414
	DHTMEM47       volatile.Register32 // 0x418
	DHTMEM48       volatile.Register32 // 0x41C
	DHTMEM49       volatile.Register32 // 0x420
	DHTMEM50       volatile.Register32 // 0x424
	DHTMEM51       volatile.Register32 // 0x428
	DHTMEM52       volatile.Register32 // 0x42C
	DHTMEM53       volatile.Register32 // 0x430
	DHTMEM54       volatile.Register32 // 0x434
	DHTMEM55       volatile.Register32 // 0x438
	DHTMEM56       volatile.Register32 // 0x43C
	DHTMEM57       volatile.Register32 // 0x440
	DHTMEM58       volatile.Register32 // 0x444
	DHTMEM59       volatile.Register32 // 0x448
	DHTMEM60       volatile.Register32 // 0x44C
	DHTMEM61       volatile.Register32 // 0x450
	DHTMEM62       volatile.Register32 // 0x454
	DHTMEM63       volatile.Register32 // 0x458
	DHTMEM64       volatile.Register32 // 0x45C
	DHTMEM65       volatile.Register32 // 0x460
	DHTMEM66       volatile.Register32 // 0x464
	DHTMEM67       volatile.Register32 // 0x468
	DHTMEM68       volatile.Register32 // 0x46C
	DHTMEM69       volatile.Register32 // 0x470
	DHTMEM70       volatile.Register32 // 0x474
	DHTMEM71       volatile.Register32 // 0x478
	DHTMEM72       volatile.Register32 // 0x47C
	DHTMEM73       volatile.Register32 // 0x480
	DHTMEM74       volatile.Register32 // 0x484
	DHTMEM75       volatile.Register32 // 0x488
	DHTMEM76       volatile.Register32 // 0x48C
	DHTMEM77       volatile.Register32 // 0x490
	DHTMEM78       volatile.Register32 // 0x494
	DHTMEM79       volatile.Register32 // 0x498
	DHTMEM80       volatile.Register32 // 0x49C
	DHTMEM81       volatile.Register32 // 0x4A0
	DHTMEM82       volatile.Register32 // 0x4A4
	DHTMEM83       volatile.Register32 // 0x4A8
	DHTMEM84       volatile.Register32 // 0x4AC
	DHTMEM85       volatile.Register32 // 0x4B0
	DHTMEM86       volatile.Register32 // 0x4B4
	DHTMEM87       volatile.Register32 // 0x4B8
	DHTMEM88       volatile.Register32 // 0x4BC
	DHTMEM89       volatile.Register32 // 0x4C0
	DHTMEM90       volatile.Register32 // 0x4C4
	DHTMEM91       volatile.Register32 // 0x4C8
	DHTMEM92       volatile.Register32 // 0x4CC
	DHTMEM93       volatile.Register32 // 0x4D0
	DHTMEM94       volatile.Register32 // 0x4D4
	DHTMEM95       volatile.Register32 // 0x4D8
	DHTMEM96       volatile.Register32 // 0x4DC
	DHTMEM97       volatile.Register32 // 0x4E0
	DHTMEM98       volatile.Register32 // 0x4E4
	DHTMEM99       volatile.Register32 // 0x4E8
	DHTMEM100      volatile.Register32 // 0x4EC
	DHTMEM101      volatile.Register32 // 0x4F0
	DHTMEM102      volatile.Register32 // 0x4F4
	DHTMEM103      volatile.Register32 // 0x4F8
	_              [4]byte
	HUFFENC_AC0_0  volatile.Register32 // 0x500
	HUFFENC_AC0_1  volatile.Register32 // 0x504
	HUFFENC_AC0_2  volatile.Register32 // 0x508
	HUFFENC_AC0_3  volatile.Register32 // 0x50C
	HUFFENC_AC0_4  volatile.Register32 // 0x510
	HUFFENC_AC0_5  volatile.Register32 // 0x514
	HUFFENC_AC0_6  volatile.Register32 // 0x518
	HUFFENC_AC0_7  volatile.Register32 // 0x51C
	HUFFENC_AC0_8  volatile.Register32 // 0x520
	HUFFENC_AC0_9  volatile.Register32 // 0x524
	HUFFENC_AC0_10 volatile.Register32 // 0x528
	HUFFENC_AC0_11 volatile.Register32 // 0x52C
	HUFFENC_AC0_12 volatile.Register32 // 0x530
	HUFFENC_AC0_13 volatile.Register32 // 0x534
	HUFFENC_AC0_14 volatile.Register32 // 0x538
	HUFFENC_AC0_15 volatile.Register32 // 0x53C
	HUFFENC_AC0_16 volatile.Register32 // 0x540
	HUFFENC_AC0_17 volatile.Register32 // 0x544
	HUFFENC_AC0_18 volatile.Register32 // 0x548
	HUFFENC_AC0_19 volatile.Register32 // 0x54C
	HUFFENC_AC0_20 volatile.Register32 // 0x550
	HUFFENC_AC0_21 volatile.Register32 // 0x554
	HUFFENC_AC0_22 volatile.Register32 // 0x558
	HUFFENC_AC0_23 volatile.Register32 // 0x55C
	HUFFENC_AC0_24 volatile.Register32 // 0x560
	HUFFENC_AC0_25 volatile.Register32 // 0x564
	HUFFENC_AC0_26 volatile.Register32 // 0x568
	HUFFENC_AC0_27 volatile.Register32 // 0x56C
	HUFFENC_AC0_28 volatile.Register32 // 0x570
	HUFFENC_AC0_29 volatile.Register32 // 0x574
	HUFFENC_AC0_30 volatile.Register32 // 0x578
	HUFFENC_AC0_31 volatile.Register32 // 0x57C
	HUFFENC_AC0_32 volatile.Register32 // 0x580
	HUFFENC_AC0_33 volatile.Register32 // 0x584
	HUFFENC_AC0_34 volatile.Register32 // 0x588
	HUFFENC_AC0_35 volatile.Register32 // 0x58C
	HUFFENC_AC0_36 volatile.Register32 // 0x590
	HUFFENC_AC0_37 volatile.Register32 // 0x594
	HUFFENC_AC0_38 volatile.Register32 // 0x598
	HUFFENC_AC0_39 volatile.Register32 // 0x59C
	HUFFENC_AC0_40 volatile.Register32 // 0x5A0
	HUFFENC_AC0_41 volatile.Register32 // 0x5A4
	HUFFENC_AC0_42 volatile.Register32 // 0x5A8
	HUFFENC_AC0_43 volatile.Register32 // 0x5AC
	HUFFENC_AC0_44 volatile.Register32 // 0x5B0
	HUFFENC_AC0_45 volatile.Register32 // 0x5B4
	HUFFENC_AC0_46 volatile.Register32 // 0x5B8
	HUFFENC_AC0_47 volatile.Register32 // 0x5BC
	HUFFENC_AC0_48 volatile.Register32 // 0x5C0
	HUFFENC_AC0_49 volatile.Register32 // 0x5C4
	HUFFENC_AC0_50 volatile.Register32 // 0x5C8
	HUFFENC_AC0_51 volatile.Register32 // 0x5CC
	HUFFENC_AC0_52 volatile.Register32 // 0x5D0
	HUFFENC_AC0_53 volatile.Register32 // 0x5D4
	HUFFENC_AC0_54 volatile.Register32 // 0x5D8
	HUFFENC_AC0_55 volatile.Register32 // 0x5DC
	HUFFENC_AC0_56 volatile.Register32 // 0x5E0
	HUFFENC_AC0_57 volatile.Register32 // 0x5E4
	HUFFENC_AC0_58 volatile.Register32 // 0x5E8
	HUFFENC_AC0_59 volatile.Register32 // 0x5EC
	HUFFENC_AC0_60 volatile.Register32 // 0x5F0
	HUFFENC_AC0_61 volatile.Register32 // 0x5F4
	HUFFENC_AC0_62 volatile.Register32 // 0x5F8
	HUFFENC_AC0_63 volatile.Register32 // 0x5FC
	HUFFENC_AC0_64 volatile.Register32 // 0x600
	HUFFENC_AC0_65 volatile.Register32 // 0x604
	HUFFENC_AC0_66 volatile.Register32 // 0x608
	HUFFENC_AC0_67 volatile.Register32 // 0x60C
	HUFFENC_AC0_68 volatile.Register32 // 0x610
	HUFFENC_AC0_69 volatile.Register32 // 0x614
	HUFFENC_AC0_70 volatile.Register32 // 0x618
	HUFFENC_AC0_71 volatile.Register32 // 0x61C
	HUFFENC_AC0_72 volatile.Register32 // 0x620
	HUFFENC_AC0_73 volatile.Register32 // 0x624
	HUFFENC_AC0_74 volatile.Register32 // 0x628
	HUFFENC_AC0_75 volatile.Register32 // 0x62C
	HUFFENC_AC0_76 volatile.Register32 // 0x630
	HUFFENC_AC0_77 volatile.Register32 // 0x634
	HUFFENC_AC0_78 volatile.Register32 // 0x638
	HUFFENC_AC0_79 volatile.Register32 // 0x63C
	HUFFENC_AC0_80 volatile.Register32 // 0x640
	HUFFENC_AC0_81 volatile.Register32 // 0x644
	HUFFENC_AC0_82 volatile.Register32 // 0x648
	HUFFENC_AC0_83 volatile.Register32 // 0x64C
	HUFFENC_AC0_84 volatile.Register32 // 0x650
	HUFFENC_AC0_85 volatile.Register32 // 0x654
	HUFFENC_AC0_86 volatile.Register32 // 0x658
	HUFFENC_AC0_87 volatile.Register32 // 0x65C
	HUFFENC_AC1_0  volatile.Register32 // 0x660
	HUFFENC_AC1_1  volatile.Register32 // 0x664
	HUFFENC_AC1_2  volatile.Register32 // 0x668
	HUFFENC_AC1_3  volatile.Register32 // 0x66C
	HUFFENC_AC1_4  volatile.Register32 // 0x670
	HUFFENC_AC1_5  volatile.Register32 // 0x674
	HUFFENC_AC1_6  volatile.Register32 // 0x678
	HUFFENC_AC1_7  volatile.Register32 // 0x67C
	HUFFENC_AC1_8  volatile.Register32 // 0x680
	HUFFENC_AC1_9  volatile.Register32 // 0x684
	HUFFENC_AC1_10 volatile.Register32 // 0x688
	HUFFENC_AC1_11 volatile.Register32 // 0x68C
	HUFFENC_AC1_12 volatile.Register32 // 0x690
	HUFFENC_AC1_13 volatile.Register32 // 0x694
	HUFFENC_AC1_14 volatile.Register32 // 0x698
	HUFFENC_AC1_15 volatile.Register32 // 0x69C
	HUFFENC_AC1_16 volatile.Register32 // 0x6A0
	HUFFENC_AC1_17 volatile.Register32 // 0x6A4
	HUFFENC_AC1_18 volatile.Register32 // 0x6A8
	HUFFENC_AC1_19 volatile.Register32 // 0x6AC
	HUFFENC_AC1_20 volatile.Register32 // 0x6B0
	HUFFENC_AC1_21 volatile.Register32 // 0x6B4
	HUFFENC_AC1_22 volatile.Register32 // 0x6B8
	HUFFENC_AC1_23 volatile.Register32 // 0x6BC
	HUFFENC_AC1_24 volatile.Register32 // 0x6C0
	HUFFENC_AC1_25 volatile.Register32 // 0x6C4
	HUFFENC_AC1_26 volatile.Register32 // 0x6C8
	HUFFENC_AC1_27 volatile.Register32 // 0x6CC
	HUFFENC_AC1_28 volatile.Register32 // 0x6D0
	HUFFENC_AC1_29 volatile.Register32 // 0x6D4
	HUFFENC_AC1_30 volatile.Register32 // 0x6D8
	HUFFENC_AC1_31 volatile.Register32 // 0x6DC
	HUFFENC_AC1_32 volatile.Register32 // 0x6E0
	HUFFENC_AC1_33 volatile.Register32 // 0x6E4
	HUFFENC_AC1_34 volatile.Register32 // 0x6E8
	HUFFENC_AC1_35 volatile.Register32 // 0x6EC
	HUFFENC_AC1_36 volatile.Register32 // 0x6F0
	HUFFENC_AC1_37 volatile.Register32 // 0x6F4
	HUFFENC_AC1_38 volatile.Register32 // 0x6F8
	HUFFENC_AC1_39 volatile.Register32 // 0x6FC
	HUFFENC_AC1_40 volatile.Register32 // 0x700
	HUFFENC_AC1_41 volatile.Register32 // 0x704
	HUFFENC_AC1_42 volatile.Register32 // 0x708
	HUFFENC_AC1_43 volatile.Register32 // 0x70C
	HUFFENC_AC1_44 volatile.Register32 // 0x710
	HUFFENC_AC1_45 volatile.Register32 // 0x714
	HUFFENC_AC1_46 volatile.Register32 // 0x718
	HUFFENC_AC1_47 volatile.Register32 // 0x71C
	HUFFENC_AC1_48 volatile.Register32 // 0x720
	HUFFENC_AC1_49 volatile.Register32 // 0x724
	HUFFENC_AC1_50 volatile.Register32 // 0x728
	HUFFENC_AC1_51 volatile.Register32 // 0x72C
	HUFFENC_AC1_52 volatile.Register32 // 0x730
	HUFFENC_AC1_53 volatile.Register32 // 0x734
	HUFFENC_AC1_54 volatile.Register32 // 0x738
	HUFFENC_AC1_55 volatile.Register32 // 0x73C
	HUFFENC_AC1_56 volatile.Register32 // 0x740
	HUFFENC_AC1_57 volatile.Register32 // 0x744
	HUFFENC_AC1_58 volatile.Register32 // 0x748
	HUFFENC_AC1_59 volatile.Register32 // 0x74C
	HUFFENC_AC1_60 volatile.Register32 // 0x750
	HUFFENC_AC1_61 volatile.Register32 // 0x754
	HUFFENC_AC1_62 volatile.Register32 // 0x758
	HUFFENC_AC1_63 volatile.Register32 // 0x75C
	HUFFENC_AC1_64 volatile.Register32 // 0x760
	HUFFENC_AC1_65 volatile.Register32 // 0x764
	HUFFENC_AC1_66 volatile.Register32 // 0x768
	HUFFENC_AC1_67 volatile.Register32 // 0x76C
	HUFFENC_AC1_68 volatile.Register32 // 0x770
	HUFFENC_AC1_69 volatile.Register32 // 0x774
	HUFFENC_AC1_70 volatile.Register32 // 0x778
	HUFFENC_AC1_71 volatile.Register32 // 0x77C
	HUFFENC_AC1_72 volatile.Register32 // 0x780
	HUFFENC_AC1_73 volatile.Register32 // 0x784
	HUFFENC_AC1_74 volatile.Register32 // 0x788
	HUFFENC_AC1_75 volatile.Register32 // 0x78C
	HUFFENC_AC1_76 volatile.Register32 // 0x790
	HUFFENC_AC1_77 volatile.Register32 // 0x794
	HUFFENC_AC1_78 volatile.Register32 // 0x798
	HUFFENC_AC1_79 volatile.Register32 // 0x79C
	HUFFENC_AC1_80 volatile.Register32 // 0x7A0
	HUFFENC_AC1_81 volatile.Register32 // 0x7A4
	HUFFENC_AC1_82 volatile.Register32 // 0x7A8
	HUFFENC_AC1_83 volatile.Register32 // 0x7AC
	HUFFENC_AC1_84 volatile.Register32 // 0x7B0
	HUFFENC_AC1_85 volatile.Register32 // 0x7B4
	HUFFENC_AC1_86 volatile.Register32 // 0x7B8
	HUFFENC_AC1_87 volatile.Register32 // 0x7BC
	HUFFENC_DC0_0  volatile.Register32 // 0x7C0
	HUFFENC_DC0_1  volatile.Register32 // 0x7C4
	HUFFENC_DC0_2  volatile.Register32 // 0x7C8
	HUFFENC_DC0_3  volatile.Register32 // 0x7CC
	HUFFENC_DC0_4  volatile.Register32 // 0x7D0
	HUFFENC_DC0_5  volatile.Register32 // 0x7D4
	HUFFENC_DC0_6  volatile.Register32 // 0x7D8
	HUFFENC_DC0_7  volatile.Register32 // 0x7DC
	HUFFENC_DC1_0  volatile.Register32 // 0x7E0
	HUFFENC_DC1_1  volatile.Register32 // 0x7E4
	HUFFENC_DC1_2  volatile.Register32 // 0x7E8
	HUFFENC_DC1_3  volatile.Register32 // 0x7EC
	HUFFENC_DC1_4  volatile.Register32 // 0x7F0
	HUFFENC_DC1_5  volatile.Register32 // 0x7F4
	HUFFENC_DC1_6  volatile.Register32 // 0x7F8
	HUFFENC_DC1_7  volatile.Register32 // 0x7FC
}

// DSI Host
type DSI_Type struct {
	DSI_VR      volatile.Register32 // 0x0
	DSI_CR      volatile.Register32 // 0x4
	DSI_CCR     volatile.Register32 // 0x8
	DSI_LVCIDR  volatile.Register32 // 0xC
	DSI_LCOLCR  volatile.Register32 // 0x10
	DSI_LPCR    volatile.Register32 // 0x14
	DSI_LPMCR   volatile.Register32 // 0x18
	_           [16]byte
	DSI_PCR     volatile.Register32 // 0x2C
	DSI_GVCIDR  volatile.Register32 // 0x30
	DSI_MCR     volatile.Register32 // 0x34
	DSI_VMCR    volatile.Register32 // 0x38
	DSI_VPCR    volatile.Register32 // 0x3C
	DSI_VCCR    volatile.Register32 // 0x40
	DSI_VNPCR   volatile.Register32 // 0x44
	DSI_VHSACR  volatile.Register32 // 0x48
	DSI_VHBPCR  volatile.Register32 // 0x4C
	DSI_VLCR    volatile.Register32 // 0x50
	DSI_VVSACR  volatile.Register32 // 0x54
	DSI_VVBPCR  volatile.Register32 // 0x58
	DSI_VVFPCR  volatile.Register32 // 0x5C
	DSI_VVACR   volatile.Register32 // 0x60
	DSI_LCCR    volatile.Register32 // 0x64
	DSI_CMCR    volatile.Register32 // 0x68
	DSI_GHCR    volatile.Register32 // 0x6C
	DSI_GPDR    volatile.Register32 // 0x70
	DSI_GPSR    volatile.Register32 // 0x74
	DSI_TCCR0   volatile.Register32 // 0x78
	DSI_TCCR1   volatile.Register32 // 0x7C
	DSI_TCCR2   volatile.Register32 // 0x80
	DSI_TCCR3   volatile.Register32 // 0x84
	DSI_TCCR4   volatile.Register32 // 0x88
	DSI_TCCR5   volatile.Register32 // 0x8C
	_           [4]byte
	DSI_CLCR    volatile.Register32 // 0x94
	DSI_CLTCR   volatile.Register32 // 0x98
	DSI_DLTCR   volatile.Register32 // 0x9C
	DSI_PCTLR   volatile.Register32 // 0xA0
	DSI_PCONFR  volatile.Register32 // 0xA4
	DSI_PUCR    volatile.Register32 // 0xA8
	DSI_PTTCR   volatile.Register32 // 0xAC
	DSI_PSR     volatile.Register32 // 0xB0
	_           [8]byte
	DSI_ISR0    volatile.Register32 // 0xBC
	DSI_ISR1    volatile.Register32 // 0xC0
	DSI_IER0    volatile.Register32 // 0xC4
	DSI_IER1    volatile.Register32 // 0xC8
	_           [12]byte
	DSI_FIR0    volatile.Register32 // 0xD8
	DSI_FIR1    volatile.Register32 // 0xDC
	_           [32]byte
	DSI_VSCR    volatile.Register32 // 0x100
	_           [8]byte
	DSI_LCVCIDR volatile.Register32 // 0x10C
	DSI_LCCCR   volatile.Register32 // 0x110
	_           [4]byte
	DSI_LPMCCR  volatile.Register32 // 0x118
	_           [28]byte
	DSI_VMCCR   volatile.Register32 // 0x138
	DSI_VPCCR   volatile.Register32 // 0x13C
	DSI_VCCCR   volatile.Register32 // 0x140
	DSI_VNPCCR  volatile.Register32 // 0x144
	DSI_VHSACCR volatile.Register32 // 0x148
	DSI_VHBPCCR volatile.Register32 // 0x14C
	DSI_VLCCR   volatile.Register32 // 0x150
	DSI_VVSACCR volatile.Register32 // 0x154
	DSI_VVBPCCR volatile.Register32 // 0x158
	DSI_VVFPCCR volatile.Register32 // 0x15C
	DSI_VVACCR  volatile.Register32 // 0x160
	_           [668]byte
	DSI_WCFGR   volatile.Register32 // 0x400
	DSI_WCR     volatile.Register32 // 0x404
	DSI_WIER    volatile.Register32 // 0x408
	DSI_WISR    volatile.Register32 // 0x40C
	DSI_WIFCR   volatile.Register32 // 0x410
	_           [4]byte
	DSI_WPCR1   volatile.Register32 // 0x418
	DSI_WPCR2   volatile.Register32 // 0x41C
	DSI_WPCR3   volatile.Register32 // 0x420
	DSI_WPCR4   volatile.Register32 // 0x424
	DSI_WPCR5   volatile.Register32 // 0x428
	_           [4]byte
	DSI_WRPCR   volatile.Register32 // 0x430
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
	IPR21 volatile.Register32 // 0x354
	IPR22 volatile.Register32 // 0x358
	IPR23 volatile.Register32 // 0x35C
	IPR24 volatile.Register32 // 0x360
	IPR25 volatile.Register32 // 0x364
	IPR26 volatile.Register32 // 0x368
	IPR27 volatile.Register32 // 0x36C
	IPR28 volatile.Register32 // 0x370
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// Floating point unit CPACR
type FPU_Type struct {
	CPACR volatile.Register32 // 0x0
}

// System control block ACTLR
type SCB_Type struct {
	ACTRL volatile.Register32 // 0x0
}

// Processor features
type PF_Type struct {
	CLIDR  volatile.Register32 // 0x0
	CTR    volatile.Register32 // 0x4
	CCSIDR volatile.Register32 // 0x8
}

// Access control
type AC_Type struct {
	ITCMCR volatile.Register32 // 0x0
	DTCMCR volatile.Register32 // 0x4
	AHBPCR volatile.Register32 // 0x8
	CACR   volatile.Register32 // 0xC
	AHBSCR volatile.Register32 // 0x10
	_      [4]byte
	ABFSR  volatile.Register32 // 0x18
}

// Debug support
type DBGMCU_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// Bitfields for RNG: Random number generator
const (
	// CR: control register
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff
)

// Bitfields for HASH: Hash processor
const (
	// CR: control register
	// Position of INIT field.
	HASH_CR_INIT_Pos = 0x2
	// Bit mask of INIT field.
	HASH_CR_INIT_Msk = 0x4
	// Bit INIT.
	HASH_CR_INIT = 0x4
	// Position of DMAE field.
	HASH_CR_DMAE_Pos = 0x3
	// Bit mask of DMAE field.
	HASH_CR_DMAE_Msk = 0x8
	// Bit DMAE.
	HASH_CR_DMAE = 0x8
	// Position of DATATYPE field.
	HASH_CR_DATATYPE_Pos = 0x4
	// Bit mask of DATATYPE field.
	HASH_CR_DATATYPE_Msk = 0x30
	// Position of MODE field.
	HASH_CR_MODE_Pos = 0x6
	// Bit mask of MODE field.
	HASH_CR_MODE_Msk = 0x40
	// Bit MODE.
	HASH_CR_MODE = 0x40
	// Position of ALGO0 field.
	HASH_CR_ALGO0_Pos = 0x7
	// Bit mask of ALGO0 field.
	HASH_CR_ALGO0_Msk = 0x80
	// Bit ALGO0.
	HASH_CR_ALGO0 = 0x80
	// Position of NBW field.
	HASH_CR_NBW_Pos = 0x8
	// Bit mask of NBW field.
	HASH_CR_NBW_Msk = 0xf00
	// Position of DINNE field.
	HASH_CR_DINNE_Pos = 0xc
	// Bit mask of DINNE field.
	HASH_CR_DINNE_Msk = 0x1000
	// Bit DINNE.
	HASH_CR_DINNE = 0x1000
	// Position of MDMAT field.
	HASH_CR_MDMAT_Pos = 0xd
	// Bit mask of MDMAT field.
	HASH_CR_MDMAT_Msk = 0x2000
	// Bit MDMAT.
	HASH_CR_MDMAT = 0x2000
	// Position of LKEY field.
	HASH_CR_LKEY_Pos = 0x10
	// Bit mask of LKEY field.
	HASH_CR_LKEY_Msk = 0x10000
	// Bit LKEY.
	HASH_CR_LKEY = 0x10000
	// Position of ALGO1 field.
	HASH_CR_ALGO1_Pos = 0x12
	// Bit mask of ALGO1 field.
	HASH_CR_ALGO1_Msk = 0x40000
	// Bit ALGO1.
	HASH_CR_ALGO1 = 0x40000

	// DIN: data input register
	// Position of DATAIN field.
	HASH_DIN_DATAIN_Pos = 0x0
	// Bit mask of DATAIN field.
	HASH_DIN_DATAIN_Msk = 0xffffffff

	// STR: start register
	// Position of DCAL field.
	HASH_STR_DCAL_Pos = 0x8
	// Bit mask of DCAL field.
	HASH_STR_DCAL_Msk = 0x100
	// Bit DCAL.
	HASH_STR_DCAL = 0x100
	// Position of NBLW field.
	HASH_STR_NBLW_Pos = 0x0
	// Bit mask of NBLW field.
	HASH_STR_NBLW_Msk = 0x1f

	// HR0: digest registers
	// Position of H field.
	HASH_HR_H_Pos = 0x0
	// Bit mask of H field.
	HASH_HR_H_Msk = 0xffffffff

	// IMR: interrupt enable register
	// Position of DCIE field.
	HASH_IMR_DCIE_Pos = 0x1
	// Bit mask of DCIE field.
	HASH_IMR_DCIE_Msk = 0x2
	// Bit DCIE.
	HASH_IMR_DCIE = 0x2
	// Position of DINIE field.
	HASH_IMR_DINIE_Pos = 0x0
	// Bit mask of DINIE field.
	HASH_IMR_DINIE_Msk = 0x1
	// Bit DINIE.
	HASH_IMR_DINIE = 0x1

	// SR: status register
	// Position of BUSY field.
	HASH_SR_BUSY_Pos = 0x3
	// Bit mask of BUSY field.
	HASH_SR_BUSY_Msk = 0x8
	// Bit BUSY.
	HASH_SR_BUSY = 0x8
	// Position of DMAS field.
	HASH_SR_DMAS_Pos = 0x2
	// Bit mask of DMAS field.
	HASH_SR_DMAS_Msk = 0x4
	// Bit DMAS.
	HASH_SR_DMAS = 0x4
	// Position of DCIS field.
	HASH_SR_DCIS_Pos = 0x1
	// Bit mask of DCIS field.
	HASH_SR_DCIS_Msk = 0x2
	// Bit DCIS.
	HASH_SR_DCIS = 0x2
	// Position of DINIS field.
	HASH_SR_DINIS_Pos = 0x0
	// Bit mask of DINIS field.
	HASH_SR_DINIS_Msk = 0x1
	// Bit DINIS.
	HASH_SR_DINIS = 0x1

	// CSR0: context swap registers
	// Position of CSR field.
	HASH_CSR_CSR_Pos = 0x0
	// Bit mask of CSR field.
	HASH_CSR_CSR_Msk = 0xffffffff

	// HASH_HR0: HASH digest register
	// Position of H field.
	HASH_HASH_HR_H_Pos = 0x0
	// Bit mask of H field.
	HASH_HASH_HR_H_Msk = 0xffffffff
)

// Bitfields for CRYP: Cryptographic processor
const (
	// CR: control register
	// Position of ALGODIR field.
	CRYP_CR_ALGODIR_Pos = 0x2
	// Bit mask of ALGODIR field.
	CRYP_CR_ALGODIR_Msk = 0x4
	// Bit ALGODIR.
	CRYP_CR_ALGODIR = 0x4
	// Position of ALGOMODE0 field.
	CRYP_CR_ALGOMODE0_Pos = 0x3
	// Bit mask of ALGOMODE0 field.
	CRYP_CR_ALGOMODE0_Msk = 0x38
	// Position of DATATYPE field.
	CRYP_CR_DATATYPE_Pos = 0x6
	// Bit mask of DATATYPE field.
	CRYP_CR_DATATYPE_Msk = 0xc0
	// Position of KEYSIZE field.
	CRYP_CR_KEYSIZE_Pos = 0x8
	// Bit mask of KEYSIZE field.
	CRYP_CR_KEYSIZE_Msk = 0x300
	// Position of FFLUSH field.
	CRYP_CR_FFLUSH_Pos = 0xe
	// Bit mask of FFLUSH field.
	CRYP_CR_FFLUSH_Msk = 0x4000
	// Bit FFLUSH.
	CRYP_CR_FFLUSH = 0x4000
	// Position of CRYPEN field.
	CRYP_CR_CRYPEN_Pos = 0xf
	// Bit mask of CRYPEN field.
	CRYP_CR_CRYPEN_Msk = 0x8000
	// Bit CRYPEN.
	CRYP_CR_CRYPEN = 0x8000
	// Position of GCM_CCMPH field.
	CRYP_CR_GCM_CCMPH_Pos = 0x10
	// Bit mask of GCM_CCMPH field.
	CRYP_CR_GCM_CCMPH_Msk = 0x30000
	// Position of ALGOMODE3 field.
	CRYP_CR_ALGOMODE3_Pos = 0x13
	// Bit mask of ALGOMODE3 field.
	CRYP_CR_ALGOMODE3_Msk = 0x80000
	// Bit ALGOMODE3.
	CRYP_CR_ALGOMODE3 = 0x80000

	// SR: status register
	// Position of BUSY field.
	CRYP_SR_BUSY_Pos = 0x4
	// Bit mask of BUSY field.
	CRYP_SR_BUSY_Msk = 0x10
	// Bit BUSY.
	CRYP_SR_BUSY = 0x10
	// Position of OFFU field.
	CRYP_SR_OFFU_Pos = 0x3
	// Bit mask of OFFU field.
	CRYP_SR_OFFU_Msk = 0x8
	// Bit OFFU.
	CRYP_SR_OFFU = 0x8
	// Position of OFNE field.
	CRYP_SR_OFNE_Pos = 0x2
	// Bit mask of OFNE field.
	CRYP_SR_OFNE_Msk = 0x4
	// Bit OFNE.
	CRYP_SR_OFNE = 0x4
	// Position of IFNF field.
	CRYP_SR_IFNF_Pos = 0x1
	// Bit mask of IFNF field.
	CRYP_SR_IFNF_Msk = 0x2
	// Bit IFNF.
	CRYP_SR_IFNF = 0x2
	// Position of IFEM field.
	CRYP_SR_IFEM_Pos = 0x0
	// Bit mask of IFEM field.
	CRYP_SR_IFEM_Msk = 0x1
	// Bit IFEM.
	CRYP_SR_IFEM = 0x1

	// DIN: data input register
	// Position of DATAIN field.
	CRYP_DIN_DATAIN_Pos = 0x0
	// Bit mask of DATAIN field.
	CRYP_DIN_DATAIN_Msk = 0xffffffff

	// DOUT: data output register
	// Position of DATAOUT field.
	CRYP_DOUT_DATAOUT_Pos = 0x0
	// Bit mask of DATAOUT field.
	CRYP_DOUT_DATAOUT_Msk = 0xffffffff

	// DMACR: DMA control register
	// Position of DOEN field.
	CRYP_DMACR_DOEN_Pos = 0x1
	// Bit mask of DOEN field.
	CRYP_DMACR_DOEN_Msk = 0x2
	// Bit DOEN.
	CRYP_DMACR_DOEN = 0x2
	// Position of DIEN field.
	CRYP_DMACR_DIEN_Pos = 0x0
	// Bit mask of DIEN field.
	CRYP_DMACR_DIEN_Msk = 0x1
	// Bit DIEN.
	CRYP_DMACR_DIEN = 0x1

	// IMSCR: interrupt mask set/clear register
	// Position of OUTIM field.
	CRYP_IMSCR_OUTIM_Pos = 0x1
	// Bit mask of OUTIM field.
	CRYP_IMSCR_OUTIM_Msk = 0x2
	// Bit OUTIM.
	CRYP_IMSCR_OUTIM = 0x2
	// Position of INIM field.
	CRYP_IMSCR_INIM_Pos = 0x0
	// Bit mask of INIM field.
	CRYP_IMSCR_INIM_Msk = 0x1
	// Bit INIM.
	CRYP_IMSCR_INIM = 0x1

	// RISR: raw interrupt status register
	// Position of OUTRIS field.
	CRYP_RISR_OUTRIS_Pos = 0x1
	// Bit mask of OUTRIS field.
	CRYP_RISR_OUTRIS_Msk = 0x2
	// Bit OUTRIS.
	CRYP_RISR_OUTRIS = 0x2
	// Position of INRIS field.
	CRYP_RISR_INRIS_Pos = 0x0
	// Bit mask of INRIS field.
	CRYP_RISR_INRIS_Msk = 0x1
	// Bit INRIS.
	CRYP_RISR_INRIS = 0x1

	// MISR: masked interrupt status register
	// Position of OUTMIS field.
	CRYP_MISR_OUTMIS_Pos = 0x1
	// Bit mask of OUTMIS field.
	CRYP_MISR_OUTMIS_Msk = 0x2
	// Bit OUTMIS.
	CRYP_MISR_OUTMIS = 0x2
	// Position of INMIS field.
	CRYP_MISR_INMIS_Pos = 0x0
	// Bit mask of INMIS field.
	CRYP_MISR_INMIS_Msk = 0x1
	// Bit INMIS.
	CRYP_MISR_INMIS = 0x1

	// KEY.KLR: key registers
	// Position of B2 field.
	CRYP_KEY_KLR_B2_Pos = 0x0
	// Bit mask of B2 field.
	CRYP_KEY_KLR_B2_Msk = 0xffffffff

	// KEY.KRR: key registers
	// Position of B field.
	CRYP_KEY_KRR_B_Pos = 0x0
	// Bit mask of B field.
	CRYP_KEY_KRR_B_Msk = 0xffffffff

	// INIT.IVLR: initialization vector registers
	// Position of IV field.
	CRYP_INIT_IVLR_IV_Pos = 0x0
	// Bit mask of IV field.
	CRYP_INIT_IVLR_IV_Msk = 0xffffffff

	// INIT.IVRR: initialization vector registers
	// Position of IV field.
	CRYP_INIT_IVRR_IV_Pos = 0x0
	// Bit mask of IV field.
	CRYP_INIT_IVRR_IV_Msk = 0xffffffff

	// CSGCMCCM0R: context swap register
	// Position of CSGCMCCM0R field.
	CRYP_CSGCMCCMR_CSGCMCCM0R_Pos = 0x0
	// Bit mask of CSGCMCCM0R field.
	CRYP_CSGCMCCMR_CSGCMCCM0R_Msk = 0xffffffff

	// CSGCM0R: context swap register
	// Position of CSGCMR field.
	CRYP_CSGCMR_CSGCMR_Pos = 0x0
	// Bit mask of CSGCMR field.
	CRYP_CSGCMR_CSGCMR_Msk = 0xffffffff
)

// Bitfields for DCMI: Digital camera interface
const (
	// CR: control register 1
	// Position of ENABLE field.
	DCMI_CR_ENABLE_Pos = 0xe
	// Bit mask of ENABLE field.
	DCMI_CR_ENABLE_Msk = 0x4000
	// Bit ENABLE.
	DCMI_CR_ENABLE = 0x4000
	// Position of EDM field.
	DCMI_CR_EDM_Pos = 0xa
	// Bit mask of EDM field.
	DCMI_CR_EDM_Msk = 0xc00
	// Position of FCRC field.
	DCMI_CR_FCRC_Pos = 0x8
	// Bit mask of FCRC field.
	DCMI_CR_FCRC_Msk = 0x300
	// Position of VSPOL field.
	DCMI_CR_VSPOL_Pos = 0x7
	// Bit mask of VSPOL field.
	DCMI_CR_VSPOL_Msk = 0x80
	// Bit VSPOL.
	DCMI_CR_VSPOL = 0x80
	// Position of HSPOL field.
	DCMI_CR_HSPOL_Pos = 0x6
	// Bit mask of HSPOL field.
	DCMI_CR_HSPOL_Msk = 0x40
	// Bit HSPOL.
	DCMI_CR_HSPOL = 0x40
	// Position of PCKPOL field.
	DCMI_CR_PCKPOL_Pos = 0x5
	// Bit mask of PCKPOL field.
	DCMI_CR_PCKPOL_Msk = 0x20
	// Bit PCKPOL.
	DCMI_CR_PCKPOL = 0x20
	// Position of ESS field.
	DCMI_CR_ESS_Pos = 0x4
	// Bit mask of ESS field.
	DCMI_CR_ESS_Msk = 0x10
	// Bit ESS.
	DCMI_CR_ESS = 0x10
	// Position of JPEG field.
	DCMI_CR_JPEG_Pos = 0x3
	// Bit mask of JPEG field.
	DCMI_CR_JPEG_Msk = 0x8
	// Bit JPEG.
	DCMI_CR_JPEG = 0x8
	// Position of CROP field.
	DCMI_CR_CROP_Pos = 0x2
	// Bit mask of CROP field.
	DCMI_CR_CROP_Msk = 0x4
	// Bit CROP.
	DCMI_CR_CROP = 0x4
	// Position of CM field.
	DCMI_CR_CM_Pos = 0x1
	// Bit mask of CM field.
	DCMI_CR_CM_Msk = 0x2
	// Bit CM.
	DCMI_CR_CM = 0x2
	// Position of CAPTURE field.
	DCMI_CR_CAPTURE_Pos = 0x0
	// Bit mask of CAPTURE field.
	DCMI_CR_CAPTURE_Msk = 0x1
	// Bit CAPTURE.
	DCMI_CR_CAPTURE = 0x1

	// SR: status register
	// Position of FNE field.
	DCMI_SR_FNE_Pos = 0x2
	// Bit mask of FNE field.
	DCMI_SR_FNE_Msk = 0x4
	// Bit FNE.
	DCMI_SR_FNE = 0x4
	// Position of VSYNC field.
	DCMI_SR_VSYNC_Pos = 0x1
	// Bit mask of VSYNC field.
	DCMI_SR_VSYNC_Msk = 0x2
	// Bit VSYNC.
	DCMI_SR_VSYNC = 0x2
	// Position of HSYNC field.
	DCMI_SR_HSYNC_Pos = 0x0
	// Bit mask of HSYNC field.
	DCMI_SR_HSYNC_Msk = 0x1
	// Bit HSYNC.
	DCMI_SR_HSYNC = 0x1

	// RIS: raw interrupt status register
	// Position of LINE_RIS field.
	DCMI_RIS_LINE_RIS_Pos = 0x4
	// Bit mask of LINE_RIS field.
	DCMI_RIS_LINE_RIS_Msk = 0x10
	// Bit LINE_RIS.
	DCMI_RIS_LINE_RIS = 0x10
	// Position of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS_Pos = 0x3
	// Bit mask of VSYNC_RIS field.
	DCMI_RIS_VSYNC_RIS_Msk = 0x8
	// Bit VSYNC_RIS.
	DCMI_RIS_VSYNC_RIS = 0x8
	// Position of ERR_RIS field.
	DCMI_RIS_ERR_RIS_Pos = 0x2
	// Bit mask of ERR_RIS field.
	DCMI_RIS_ERR_RIS_Msk = 0x4
	// Bit ERR_RIS.
	DCMI_RIS_ERR_RIS = 0x4
	// Position of OVR_RIS field.
	DCMI_RIS_OVR_RIS_Pos = 0x1
	// Bit mask of OVR_RIS field.
	DCMI_RIS_OVR_RIS_Msk = 0x2
	// Bit OVR_RIS.
	DCMI_RIS_OVR_RIS = 0x2
	// Position of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS_Pos = 0x0
	// Bit mask of FRAME_RIS field.
	DCMI_RIS_FRAME_RIS_Msk = 0x1
	// Bit FRAME_RIS.
	DCMI_RIS_FRAME_RIS = 0x1

	// IER: interrupt enable register
	// Position of LINE_IE field.
	DCMI_IER_LINE_IE_Pos = 0x4
	// Bit mask of LINE_IE field.
	DCMI_IER_LINE_IE_Msk = 0x10
	// Bit LINE_IE.
	DCMI_IER_LINE_IE = 0x10
	// Position of VSYNC_IE field.
	DCMI_IER_VSYNC_IE_Pos = 0x3
	// Bit mask of VSYNC_IE field.
	DCMI_IER_VSYNC_IE_Msk = 0x8
	// Bit VSYNC_IE.
	DCMI_IER_VSYNC_IE = 0x8
	// Position of ERR_IE field.
	DCMI_IER_ERR_IE_Pos = 0x2
	// Bit mask of ERR_IE field.
	DCMI_IER_ERR_IE_Msk = 0x4
	// Bit ERR_IE.
	DCMI_IER_ERR_IE = 0x4
	// Position of OVR_IE field.
	DCMI_IER_OVR_IE_Pos = 0x1
	// Bit mask of OVR_IE field.
	DCMI_IER_OVR_IE_Msk = 0x2
	// Bit OVR_IE.
	DCMI_IER_OVR_IE = 0x2
	// Position of FRAME_IE field.
	DCMI_IER_FRAME_IE_Pos = 0x0
	// Bit mask of FRAME_IE field.
	DCMI_IER_FRAME_IE_Msk = 0x1
	// Bit FRAME_IE.
	DCMI_IER_FRAME_IE = 0x1

	// MIS: masked interrupt status register
	// Position of LINE_MIS field.
	DCMI_MIS_LINE_MIS_Pos = 0x4
	// Bit mask of LINE_MIS field.
	DCMI_MIS_LINE_MIS_Msk = 0x10
	// Bit LINE_MIS.
	DCMI_MIS_LINE_MIS = 0x10
	// Position of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS_Pos = 0x3
	// Bit mask of VSYNC_MIS field.
	DCMI_MIS_VSYNC_MIS_Msk = 0x8
	// Bit VSYNC_MIS.
	DCMI_MIS_VSYNC_MIS = 0x8
	// Position of ERR_MIS field.
	DCMI_MIS_ERR_MIS_Pos = 0x2
	// Bit mask of ERR_MIS field.
	DCMI_MIS_ERR_MIS_Msk = 0x4
	// Bit ERR_MIS.
	DCMI_MIS_ERR_MIS = 0x4
	// Position of OVR_MIS field.
	DCMI_MIS_OVR_MIS_Pos = 0x1
	// Bit mask of OVR_MIS field.
	DCMI_MIS_OVR_MIS_Msk = 0x2
	// Bit OVR_MIS.
	DCMI_MIS_OVR_MIS = 0x2
	// Position of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS_Pos = 0x0
	// Bit mask of FRAME_MIS field.
	DCMI_MIS_FRAME_MIS_Msk = 0x1
	// Bit FRAME_MIS.
	DCMI_MIS_FRAME_MIS = 0x1

	// ICR: interrupt clear register
	// Position of LINE_ISC field.
	DCMI_ICR_LINE_ISC_Pos = 0x4
	// Bit mask of LINE_ISC field.
	DCMI_ICR_LINE_ISC_Msk = 0x10
	// Bit LINE_ISC.
	DCMI_ICR_LINE_ISC = 0x10
	// Position of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC_Pos = 0x3
	// Bit mask of VSYNC_ISC field.
	DCMI_ICR_VSYNC_ISC_Msk = 0x8
	// Bit VSYNC_ISC.
	DCMI_ICR_VSYNC_ISC = 0x8
	// Position of ERR_ISC field.
	DCMI_ICR_ERR_ISC_Pos = 0x2
	// Bit mask of ERR_ISC field.
	DCMI_ICR_ERR_ISC_Msk = 0x4
	// Bit ERR_ISC.
	DCMI_ICR_ERR_ISC = 0x4
	// Position of OVR_ISC field.
	DCMI_ICR_OVR_ISC_Pos = 0x1
	// Bit mask of OVR_ISC field.
	DCMI_ICR_OVR_ISC_Msk = 0x2
	// Bit OVR_ISC.
	DCMI_ICR_OVR_ISC = 0x2
	// Position of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC_Pos = 0x0
	// Bit mask of FRAME_ISC field.
	DCMI_ICR_FRAME_ISC_Msk = 0x1
	// Bit FRAME_ISC.
	DCMI_ICR_FRAME_ISC = 0x1

	// ESCR: embedded synchronization code register
	// Position of FEC field.
	DCMI_ESCR_FEC_Pos = 0x18
	// Bit mask of FEC field.
	DCMI_ESCR_FEC_Msk = 0xff000000
	// Position of LEC field.
	DCMI_ESCR_LEC_Pos = 0x10
	// Bit mask of LEC field.
	DCMI_ESCR_LEC_Msk = 0xff0000
	// Position of LSC field.
	DCMI_ESCR_LSC_Pos = 0x8
	// Bit mask of LSC field.
	DCMI_ESCR_LSC_Msk = 0xff00
	// Position of FSC field.
	DCMI_ESCR_FSC_Pos = 0x0
	// Bit mask of FSC field.
	DCMI_ESCR_FSC_Msk = 0xff

	// ESUR: embedded synchronization unmask register
	// Position of FEU field.
	DCMI_ESUR_FEU_Pos = 0x18
	// Bit mask of FEU field.
	DCMI_ESUR_FEU_Msk = 0xff000000
	// Position of LEU field.
	DCMI_ESUR_LEU_Pos = 0x10
	// Bit mask of LEU field.
	DCMI_ESUR_LEU_Msk = 0xff0000
	// Position of LSU field.
	DCMI_ESUR_LSU_Pos = 0x8
	// Bit mask of LSU field.
	DCMI_ESUR_LSU_Msk = 0xff00
	// Position of FSU field.
	DCMI_ESUR_FSU_Pos = 0x0
	// Bit mask of FSU field.
	DCMI_ESUR_FSU_Msk = 0xff

	// CWSTRT: crop window start
	// Position of VST field.
	DCMI_CWSTRT_VST_Pos = 0x10
	// Bit mask of VST field.
	DCMI_CWSTRT_VST_Msk = 0x1fff0000
	// Position of HOFFCNT field.
	DCMI_CWSTRT_HOFFCNT_Pos = 0x0
	// Bit mask of HOFFCNT field.
	DCMI_CWSTRT_HOFFCNT_Msk = 0x3fff

	// CWSIZE: crop window size
	// Position of VLINE field.
	DCMI_CWSIZE_VLINE_Pos = 0x10
	// Bit mask of VLINE field.
	DCMI_CWSIZE_VLINE_Msk = 0x3fff0000
	// Position of CAPCNT field.
	DCMI_CWSIZE_CAPCNT_Pos = 0x0
	// Bit mask of CAPCNT field.
	DCMI_CWSIZE_CAPCNT_Msk = 0x3fff

	// DR: data register
	// Position of Byte3 field.
	DCMI_DR_Byte3_Pos = 0x18
	// Bit mask of Byte3 field.
	DCMI_DR_Byte3_Msk = 0xff000000
	// Position of Byte2 field.
	DCMI_DR_Byte2_Pos = 0x10
	// Bit mask of Byte2 field.
	DCMI_DR_Byte2_Msk = 0xff0000
	// Position of Byte1 field.
	DCMI_DR_Byte1_Pos = 0x8
	// Bit mask of Byte1 field.
	DCMI_DR_Byte1_Msk = 0xff00
	// Position of Byte0 field.
	DCMI_DR_Byte0_Pos = 0x0
	// Bit mask of Byte0 field.
	DCMI_DR_Byte0_Msk = 0xff
)

// Bitfields for FMC: Flexible memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register 1
	// Position of CCLKEN field.
	FSMC_BCR1_CCLKEN_Pos = 0x14
	// Bit mask of CCLKEN field.
	FSMC_BCR1_CCLKEN_Msk = 0x100000
	// Bit CCLKEN.
	FSMC_BCR1_CCLKEN = 0x100000
	// The FMC_CLK is only generated during the synchronous memory access (read/write transaction)
	FSMC_BCR1_CCLKEN_Enabled = 0x1
	// The FMC_CLK is generated continuously during asynchronous and synchronous access. The FMC_CLK clock is activated when the CCLKEN is set
	FSMC_BCR1_CCLKEN_Disabled = 0x0
	// Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR1_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR1_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR1_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR1_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR1_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR1_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR1_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR1_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR1_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR1_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR1_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR1_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR1_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR1_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR1_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR1_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR1_WAITCFG_DuringWaitState = 0x1
	// Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR1_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR1_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR1_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR1_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR1_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR1_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR1_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR1_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR1_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR1_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR1_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR1_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR1_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR1_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR1_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR1_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR1_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR1_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR1_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR1_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR1_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR1_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR1_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR1_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR1_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR1_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR1_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR1_MBKEN_Enabled = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR1_WRAPMOD = 0x400
	// Position of WFDIS field.
	FSMC_BCR1_WFDIS_Pos = 0x15
	// Bit mask of WFDIS field.
	FSMC_BCR1_WFDIS_Msk = 0x200000
	// Bit WFDIS.
	FSMC_BCR1_WFDIS = 0x200000
	// Write FIFO enabled
	FSMC_BCR1_WFDIS_Enabled = 0x0
	// Write FIFO disabled
	FSMC_BCR1_WFDIS_Disabled = 0x1
	// Position of CPSIZE field.
	FSMC_BCR1_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR1_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR1_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes1024 = 0x4

	// BTR1: SRAM/NOR-Flash chip-select timing register 1
	// Position of ACCMOD field.
	FSMC_BTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BTR_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FSMC_BTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BTR_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FSMC_BTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BTR_ADDSET_Msk = 0xf

	// BCR2: SRAM/NOR-Flash chip-select control register 2
	// Position of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR_WAITCFG_DuringWaitState = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FSMC_BCR_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR_MBKEN_Enabled = 0x1
	// Position of CPSIZE field.
	FSMC_BCR_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes1024 = 0x4

	// PCR: PC Card/NAND Flash control register
	// Position of ECCPS field.
	FSMC_PCR_ECCPS_Pos = 0x11
	// Bit mask of ECCPS field.
	FSMC_PCR_ECCPS_Msk = 0xe0000
	// ECC page size 256 bytes
	FSMC_PCR_ECCPS_Bytes256 = 0x0
	// ECC page size 512 bytes
	FSMC_PCR_ECCPS_Bytes512 = 0x1
	// ECC page size 1024 bytes
	FSMC_PCR_ECCPS_Bytes1024 = 0x2
	// ECC page size 2048 bytes
	FSMC_PCR_ECCPS_Bytes2048 = 0x3
	// ECC page size 4096 bytes
	FSMC_PCR_ECCPS_Bytes4096 = 0x4
	// ECC page size 8192 bytes
	FSMC_PCR_ECCPS_Bytes8192 = 0x5
	// Position of TAR field.
	FSMC_PCR_TAR_Pos = 0xd
	// Bit mask of TAR field.
	FSMC_PCR_TAR_Msk = 0x1e000
	// Position of TCLR field.
	FSMC_PCR_TCLR_Pos = 0x9
	// Bit mask of TCLR field.
	FSMC_PCR_TCLR_Msk = 0x1e00
	// Position of ECCEN field.
	FSMC_PCR_ECCEN_Pos = 0x6
	// Bit mask of ECCEN field.
	FSMC_PCR_ECCEN_Msk = 0x40
	// Bit ECCEN.
	FSMC_PCR_ECCEN = 0x40
	// ECC logic is disabled and reset
	FSMC_PCR_ECCEN_Disabled = 0x0
	// ECC logic is enabled
	FSMC_PCR_ECCEN_Enabled = 0x1
	// Position of PWID field.
	FSMC_PCR_PWID_Pos = 0x4
	// Bit mask of PWID field.
	FSMC_PCR_PWID_Msk = 0x30
	// External memory device width 8 bits
	FSMC_PCR_PWID_Bits8 = 0x0
	// External memory device width 16 bits
	FSMC_PCR_PWID_Bits16 = 0x1
	// Position of PTYP field.
	FSMC_PCR_PTYP_Pos = 0x3
	// Bit mask of PTYP field.
	FSMC_PCR_PTYP_Msk = 0x8
	// Bit PTYP.
	FSMC_PCR_PTYP = 0x8
	// NAND Flash
	FSMC_PCR_PTYP_NANDFlash = 0x1
	// Position of PBKEN field.
	FSMC_PCR_PBKEN_Pos = 0x2
	// Bit mask of PBKEN field.
	FSMC_PCR_PBKEN_Msk = 0x4
	// Bit PBKEN.
	FSMC_PCR_PBKEN = 0x4
	// Corresponding memory bank is disabled
	FSMC_PCR_PBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_PCR_PBKEN_Enabled = 0x1
	// Position of PWAITEN field.
	FSMC_PCR_PWAITEN_Pos = 0x1
	// Bit mask of PWAITEN field.
	FSMC_PCR_PWAITEN_Msk = 0x2
	// Bit PWAITEN.
	FSMC_PCR_PWAITEN = 0x2
	// Wait feature disabled
	FSMC_PCR_PWAITEN_Disabled = 0x0
	// Wait feature enabled
	FSMC_PCR_PWAITEN_Enabled = 0x1

	// SR: FIFO status and interrupt register
	// Position of FEMPT field.
	FSMC_SR_FEMPT_Pos = 0x6
	// Bit mask of FEMPT field.
	FSMC_SR_FEMPT_Msk = 0x40
	// Bit FEMPT.
	FSMC_SR_FEMPT = 0x40
	// FIFO not empty
	FSMC_SR_FEMPT_NotEmpty = 0x0
	// FIFO empty
	FSMC_SR_FEMPT_Empty = 0x1
	// Position of IFEN field.
	FSMC_SR_IFEN_Pos = 0x5
	// Bit mask of IFEN field.
	FSMC_SR_IFEN_Msk = 0x20
	// Bit IFEN.
	FSMC_SR_IFEN = 0x20
	// Interrupt falling edge detection request disabled
	FSMC_SR_IFEN_Disabled = 0x0
	// Interrupt falling edge detection request enabled
	FSMC_SR_IFEN_Enabled = 0x1
	// Position of ILEN field.
	FSMC_SR_ILEN_Pos = 0x4
	// Bit mask of ILEN field.
	FSMC_SR_ILEN_Msk = 0x10
	// Bit ILEN.
	FSMC_SR_ILEN = 0x10
	// Interrupt high-level detection request disabled
	FSMC_SR_ILEN_Disabled = 0x0
	// Interrupt high-level detection request enabled
	FSMC_SR_ILEN_Enabled = 0x1
	// Position of IREN field.
	FSMC_SR_IREN_Pos = 0x3
	// Bit mask of IREN field.
	FSMC_SR_IREN_Msk = 0x8
	// Bit IREN.
	FSMC_SR_IREN = 0x8
	// Interrupt rising edge detection request disabled
	FSMC_SR_IREN_Disabled = 0x0
	// Interrupt rising edge detection request enabled
	FSMC_SR_IREN_Enabled = 0x1
	// Position of IFS field.
	FSMC_SR_IFS_Pos = 0x2
	// Bit mask of IFS field.
	FSMC_SR_IFS_Msk = 0x4
	// Bit IFS.
	FSMC_SR_IFS = 0x4
	// Interrupt falling edge did not occur
	FSMC_SR_IFS_DidNotOccur = 0x0
	// Interrupt falling edge occurred
	FSMC_SR_IFS_Occurred = 0x1
	// Position of ILS field.
	FSMC_SR_ILS_Pos = 0x1
	// Bit mask of ILS field.
	FSMC_SR_ILS_Msk = 0x2
	// Bit ILS.
	FSMC_SR_ILS = 0x2
	// Interrupt high-level did not occur
	FSMC_SR_ILS_DidNotOccur = 0x0
	// Interrupt high-level occurred
	FSMC_SR_ILS_Occurred = 0x1
	// Position of IRS field.
	FSMC_SR_IRS_Pos = 0x0
	// Bit mask of IRS field.
	FSMC_SR_IRS_Msk = 0x1
	// Bit IRS.
	FSMC_SR_IRS = 0x1
	// Interrupt rising edge did not occur
	FSMC_SR_IRS_DidNotOccur = 0x0
	// Interrupt rising edge occurred
	FSMC_SR_IRS_Occurred = 0x1

	// PMEM: Common memory space timing register
	// Position of MEMHIZ field.
	FSMC_PMEM_MEMHIZ_Pos = 0x18
	// Bit mask of MEMHIZ field.
	FSMC_PMEM_MEMHIZ_Msk = 0xff000000
	// Position of MEMHOLD field.
	FSMC_PMEM_MEMHOLD_Pos = 0x10
	// Bit mask of MEMHOLD field.
	FSMC_PMEM_MEMHOLD_Msk = 0xff0000
	// Position of MEMWAIT field.
	FSMC_PMEM_MEMWAIT_Pos = 0x8
	// Bit mask of MEMWAIT field.
	FSMC_PMEM_MEMWAIT_Msk = 0xff00
	// Position of MEMSET field.
	FSMC_PMEM_MEMSET_Pos = 0x0
	// Bit mask of MEMSET field.
	FSMC_PMEM_MEMSET_Msk = 0xff

	// PATT: Attribute memory space timing register
	// Position of ATTHIZ field.
	FSMC_PATT_ATTHIZ_Pos = 0x18
	// Bit mask of ATTHIZ field.
	FSMC_PATT_ATTHIZ_Msk = 0xff000000
	// Position of ATTHOLD field.
	FSMC_PATT_ATTHOLD_Pos = 0x10
	// Bit mask of ATTHOLD field.
	FSMC_PATT_ATTHOLD_Msk = 0xff0000
	// Position of ATTWAIT field.
	FSMC_PATT_ATTWAIT_Pos = 0x8
	// Bit mask of ATTWAIT field.
	FSMC_PATT_ATTWAIT_Msk = 0xff00
	// Position of ATTSET field.
	FSMC_PATT_ATTSET_Pos = 0x0
	// Bit mask of ATTSET field.
	FSMC_PATT_ATTSET_Msk = 0xff

	// ECCR: ECC result register
	// Position of ECC field.
	FSMC_ECCR_ECC_Pos = 0x0
	// Bit mask of ECC field.
	FSMC_ECCR_ECC_Msk = 0xffffffff

	// BWTR1: SRAM/NOR-Flash write timing registers 1
	// Position of ACCMOD field.
	FSMC_BWTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BWTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BWTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BWTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BWTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BWTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BWTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BWTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BWTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BWTR_CLKDIV_Msk = 0xf00000
	// Position of DATAST field.
	FSMC_BWTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BWTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BWTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BWTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BWTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BWTR_ADDSET_Msk = 0xf
	// Position of BUSTURN field.
	FSMC_BWTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BWTR_BUSTURN_Msk = 0xf0000

	// SDCR1: SDRAM Control Register 1
	// Position of NC field.
	FSMC_SDCR_NC_Pos = 0x0
	// Bit mask of NC field.
	FSMC_SDCR_NC_Msk = 0x3
	// 8 bits
	FSMC_SDCR_NC_Bits8 = 0x0
	// 9 bits
	FSMC_SDCR_NC_Bits9 = 0x1
	// 10 bits
	FSMC_SDCR_NC_Bits10 = 0x2
	// 11 bits
	FSMC_SDCR_NC_Bits11 = 0x3
	// Position of NR field.
	FSMC_SDCR_NR_Pos = 0x2
	// Bit mask of NR field.
	FSMC_SDCR_NR_Msk = 0xc
	// 11 bits
	FSMC_SDCR_NR_Bits11 = 0x0
	// 12 bits
	FSMC_SDCR_NR_Bits12 = 0x1
	// 13 bits
	FSMC_SDCR_NR_Bits13 = 0x2
	// Position of MWID field.
	FSMC_SDCR_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_SDCR_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_SDCR_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_SDCR_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_SDCR_MWID_Bits32 = 0x2
	// Position of NB field.
	FSMC_SDCR_NB_Pos = 0x6
	// Bit mask of NB field.
	FSMC_SDCR_NB_Msk = 0x40
	// Bit NB.
	FSMC_SDCR_NB = 0x40
	// Two internal Banks
	FSMC_SDCR_NB_NB2 = 0x0
	// Four internal Banks
	FSMC_SDCR_NB_NB4 = 0x1
	// Position of CAS field.
	FSMC_SDCR_CAS_Pos = 0x7
	// Bit mask of CAS field.
	FSMC_SDCR_CAS_Msk = 0x180
	// 1 cycle
	FSMC_SDCR_CAS_Clocks1 = 0x1
	// 2 cycles
	FSMC_SDCR_CAS_Clocks2 = 0x2
	// 3 cycles
	FSMC_SDCR_CAS_Clocks3 = 0x3
	// Position of WP field.
	FSMC_SDCR_WP_Pos = 0x9
	// Bit mask of WP field.
	FSMC_SDCR_WP_Msk = 0x200
	// Bit WP.
	FSMC_SDCR_WP = 0x200
	// Write accesses allowed
	FSMC_SDCR_WP_Disabled = 0x0
	// Write accesses ignored
	FSMC_SDCR_WP_Enabled = 0x1
	// Position of SDCLK field.
	FSMC_SDCR_SDCLK_Pos = 0xa
	// Bit mask of SDCLK field.
	FSMC_SDCR_SDCLK_Msk = 0xc00
	// SDCLK clock disabled
	FSMC_SDCR_SDCLK_Disabled = 0x0
	// SDCLK period = 2 x HCLK period
	FSMC_SDCR_SDCLK_Div2 = 0x2
	// SDCLK period = 3 x HCLK period
	FSMC_SDCR_SDCLK_Div3 = 0x3
	// Position of RBURST field.
	FSMC_SDCR_RBURST_Pos = 0xc
	// Bit mask of RBURST field.
	FSMC_SDCR_RBURST_Msk = 0x1000
	// Bit RBURST.
	FSMC_SDCR_RBURST = 0x1000
	// Single read requests are not managed as bursts
	FSMC_SDCR_RBURST_Disabled = 0x0
	// Single read requests are always managed as bursts
	FSMC_SDCR_RBURST_Enabled = 0x1
	// Position of RPIPE field.
	FSMC_SDCR_RPIPE_Pos = 0xd
	// Bit mask of RPIPE field.
	FSMC_SDCR_RPIPE_Msk = 0x6000
	// No clock cycle delay
	FSMC_SDCR_RPIPE_NoDelay = 0x0
	// One clock cycle delay
	FSMC_SDCR_RPIPE_Clocks1 = 0x1
	// Two clock cycles delay
	FSMC_SDCR_RPIPE_Clocks2 = 0x2

	// SDTR1: SDRAM Timing register 1
	// Position of TMRD field.
	FSMC_SDTR_TMRD_Pos = 0x0
	// Bit mask of TMRD field.
	FSMC_SDTR_TMRD_Msk = 0xf
	// Position of TXSR field.
	FSMC_SDTR_TXSR_Pos = 0x4
	// Bit mask of TXSR field.
	FSMC_SDTR_TXSR_Msk = 0xf0
	// Position of TRAS field.
	FSMC_SDTR_TRAS_Pos = 0x8
	// Bit mask of TRAS field.
	FSMC_SDTR_TRAS_Msk = 0xf00
	// Position of TRC field.
	FSMC_SDTR_TRC_Pos = 0xc
	// Bit mask of TRC field.
	FSMC_SDTR_TRC_Msk = 0xf000
	// Position of TWR field.
	FSMC_SDTR_TWR_Pos = 0x10
	// Bit mask of TWR field.
	FSMC_SDTR_TWR_Msk = 0xf0000
	// Position of TRP field.
	FSMC_SDTR_TRP_Pos = 0x14
	// Bit mask of TRP field.
	FSMC_SDTR_TRP_Msk = 0xf00000
	// Position of TRCD field.
	FSMC_SDTR_TRCD_Pos = 0x18
	// Bit mask of TRCD field.
	FSMC_SDTR_TRCD_Msk = 0xf000000

	// SDCMR: SDRAM Command Mode register
	// Position of MODE field.
	FSMC_SDCMR_MODE_Pos = 0x0
	// Bit mask of MODE field.
	FSMC_SDCMR_MODE_Msk = 0x7
	// Normal Mode
	FSMC_SDCMR_MODE_Normal = 0x0
	// Clock Configuration Enable
	FSMC_SDCMR_MODE_ClockConfigurationEnable = 0x1
	// PALL (All Bank Precharge) command
	FSMC_SDCMR_MODE_PALL = 0x2
	// Auto-refresh command
	FSMC_SDCMR_MODE_AutoRefreshCommand = 0x3
	// Load Mode Resgier
	FSMC_SDCMR_MODE_LoadModeRegister = 0x4
	// Self-refresh command
	FSMC_SDCMR_MODE_SelfRefreshCommand = 0x5
	// Power-down command
	FSMC_SDCMR_MODE_PowerDownCommand = 0x6
	// Position of CTB2 field.
	FSMC_SDCMR_CTB2_Pos = 0x3
	// Bit mask of CTB2 field.
	FSMC_SDCMR_CTB2_Msk = 0x8
	// Bit CTB2.
	FSMC_SDCMR_CTB2 = 0x8
	// Command not issued to SDRAM Bank 1
	FSMC_SDCMR_CTB2_NotIssued = 0x0
	// Command issued to SDRAM Bank 1
	FSMC_SDCMR_CTB2_Issued = 0x1
	// Position of CTB1 field.
	FSMC_SDCMR_CTB1_Pos = 0x4
	// Bit mask of CTB1 field.
	FSMC_SDCMR_CTB1_Msk = 0x10
	// Bit CTB1.
	FSMC_SDCMR_CTB1 = 0x10
	// Command not issued to SDRAM Bank 1
	FSMC_SDCMR_CTB1_NotIssued = 0x0
	// Command issued to SDRAM Bank 1
	FSMC_SDCMR_CTB1_Issued = 0x1
	// Position of NRFS field.
	FSMC_SDCMR_NRFS_Pos = 0x5
	// Bit mask of NRFS field.
	FSMC_SDCMR_NRFS_Msk = 0x1e0
	// Position of MRD field.
	FSMC_SDCMR_MRD_Pos = 0x9
	// Bit mask of MRD field.
	FSMC_SDCMR_MRD_Msk = 0x3ffe00

	// SDRTR: SDRAM Refresh Timer register
	// Position of CRE field.
	FSMC_SDRTR_CRE_Pos = 0x0
	// Bit mask of CRE field.
	FSMC_SDRTR_CRE_Msk = 0x1
	// Bit CRE.
	FSMC_SDRTR_CRE = 0x1
	// Refresh Error Flag is cleared
	FSMC_SDRTR_CRE_Clear = 0x1
	// Position of COUNT field.
	FSMC_SDRTR_COUNT_Pos = 0x1
	// Bit mask of COUNT field.
	FSMC_SDRTR_COUNT_Msk = 0x3ffe
	// Position of REIE field.
	FSMC_SDRTR_REIE_Pos = 0xe
	// Bit mask of REIE field.
	FSMC_SDRTR_REIE_Msk = 0x4000
	// Bit REIE.
	FSMC_SDRTR_REIE = 0x4000
	// Interrupt is disabled
	FSMC_SDRTR_REIE_Disabled = 0x0
	// Interrupt is generated if RE = 1
	FSMC_SDRTR_REIE_Enabled = 0x1

	// SDSR: SDRAM Status register
	// Position of RE field.
	FSMC_SDSR_RE_Pos = 0x0
	// Bit mask of RE field.
	FSMC_SDSR_RE_Msk = 0x1
	// Bit RE.
	FSMC_SDSR_RE = 0x1
	// No refresh error has been detected
	FSMC_SDSR_RE_NoError = 0x0
	// A refresh error has been detected
	FSMC_SDSR_RE_Error = 0x1
	// Position of MODES1 field.
	FSMC_SDSR_MODES1_Pos = 0x1
	// Bit mask of MODES1 field.
	FSMC_SDSR_MODES1_Msk = 0x6
	// Normal Mode
	FSMC_SDSR_MODES1_Normal = 0x0
	// Self-refresh mode
	FSMC_SDSR_MODES1_SelfRefresh = 0x1
	// Power-down mode
	FSMC_SDSR_MODES1_PowerDown = 0x2
	// Position of MODES2 field.
	FSMC_SDSR_MODES2_Pos = 0x3
	// Bit mask of MODES2 field.
	FSMC_SDSR_MODES2_Msk = 0x18
	// Normal Mode
	FSMC_SDSR_MODES2_Normal = 0x0
	// Self-refresh mode
	FSMC_SDSR_MODES2_SelfRefresh = 0x1
	// Power-down mode
	FSMC_SDSR_MODES2_PowerDown = 0x2
	// Position of BUSY field.
	FSMC_SDSR_BUSY_Pos = 0x5
	// Bit mask of BUSY field.
	FSMC_SDSR_BUSY_Msk = 0x20
	// Bit BUSY.
	FSMC_SDSR_BUSY = 0x20
	// SDRAM Controller is ready to accept a new request
	FSMC_SDSR_BUSY_NotBusy = 0x0
	// SDRAM Controller is not ready to accept a new request
	FSMC_SDSR_BUSY_Busy = 0x1
)

// Bitfields for DMA2: DMA controller
const (
	// LISR: low interrupt status register
	// Position of TCIF3 field.
	DMA_LISR_TCIF3_Pos = 0x1b
	// Bit mask of TCIF3 field.
	DMA_LISR_TCIF3_Msk = 0x8000000
	// Bit TCIF3.
	DMA_LISR_TCIF3 = 0x8000000
	// No transfer complete event on stream x
	DMA_LISR_TCIF3_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF3_Complete = 0x1
	// Position of HTIF3 field.
	DMA_LISR_HTIF3_Pos = 0x1a
	// Bit mask of HTIF3 field.
	DMA_LISR_HTIF3_Msk = 0x4000000
	// Bit HTIF3.
	DMA_LISR_HTIF3 = 0x4000000
	// No half transfer event on stream x
	DMA_LISR_HTIF3_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF3_Half = 0x1
	// Position of TEIF3 field.
	DMA_LISR_TEIF3_Pos = 0x19
	// Bit mask of TEIF3 field.
	DMA_LISR_TEIF3_Msk = 0x2000000
	// Bit TEIF3.
	DMA_LISR_TEIF3 = 0x2000000
	// No transfer error on stream x
	DMA_LISR_TEIF3_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF3_Error = 0x1
	// Position of DMEIF3 field.
	DMA_LISR_DMEIF3_Pos = 0x18
	// Bit mask of DMEIF3 field.
	DMA_LISR_DMEIF3_Msk = 0x1000000
	// Bit DMEIF3.
	DMA_LISR_DMEIF3 = 0x1000000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF3_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF3_Error = 0x1
	// Position of FEIF3 field.
	DMA_LISR_FEIF3_Pos = 0x16
	// Bit mask of FEIF3 field.
	DMA_LISR_FEIF3_Msk = 0x400000
	// Bit FEIF3.
	DMA_LISR_FEIF3 = 0x400000
	// No FIFO error event on stream x
	DMA_LISR_FEIF3_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF3_Error = 0x1
	// Position of TCIF2 field.
	DMA_LISR_TCIF2_Pos = 0x15
	// Bit mask of TCIF2 field.
	DMA_LISR_TCIF2_Msk = 0x200000
	// Bit TCIF2.
	DMA_LISR_TCIF2 = 0x200000
	// No transfer complete event on stream x
	DMA_LISR_TCIF2_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF2_Complete = 0x1
	// Position of HTIF2 field.
	DMA_LISR_HTIF2_Pos = 0x14
	// Bit mask of HTIF2 field.
	DMA_LISR_HTIF2_Msk = 0x100000
	// Bit HTIF2.
	DMA_LISR_HTIF2 = 0x100000
	// No half transfer event on stream x
	DMA_LISR_HTIF2_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF2_Half = 0x1
	// Position of TEIF2 field.
	DMA_LISR_TEIF2_Pos = 0x13
	// Bit mask of TEIF2 field.
	DMA_LISR_TEIF2_Msk = 0x80000
	// Bit TEIF2.
	DMA_LISR_TEIF2 = 0x80000
	// No transfer error on stream x
	DMA_LISR_TEIF2_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF2_Error = 0x1
	// Position of DMEIF2 field.
	DMA_LISR_DMEIF2_Pos = 0x12
	// Bit mask of DMEIF2 field.
	DMA_LISR_DMEIF2_Msk = 0x40000
	// Bit DMEIF2.
	DMA_LISR_DMEIF2 = 0x40000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF2_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF2_Error = 0x1
	// Position of FEIF2 field.
	DMA_LISR_FEIF2_Pos = 0x10
	// Bit mask of FEIF2 field.
	DMA_LISR_FEIF2_Msk = 0x10000
	// Bit FEIF2.
	DMA_LISR_FEIF2 = 0x10000
	// No FIFO error event on stream x
	DMA_LISR_FEIF2_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF2_Error = 0x1
	// Position of TCIF1 field.
	DMA_LISR_TCIF1_Pos = 0xb
	// Bit mask of TCIF1 field.
	DMA_LISR_TCIF1_Msk = 0x800
	// Bit TCIF1.
	DMA_LISR_TCIF1 = 0x800
	// No transfer complete event on stream x
	DMA_LISR_TCIF1_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF1_Complete = 0x1
	// Position of HTIF1 field.
	DMA_LISR_HTIF1_Pos = 0xa
	// Bit mask of HTIF1 field.
	DMA_LISR_HTIF1_Msk = 0x400
	// Bit HTIF1.
	DMA_LISR_HTIF1 = 0x400
	// No half transfer event on stream x
	DMA_LISR_HTIF1_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF1_Half = 0x1
	// Position of TEIF1 field.
	DMA_LISR_TEIF1_Pos = 0x9
	// Bit mask of TEIF1 field.
	DMA_LISR_TEIF1_Msk = 0x200
	// Bit TEIF1.
	DMA_LISR_TEIF1 = 0x200
	// No transfer error on stream x
	DMA_LISR_TEIF1_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF1_Error = 0x1
	// Position of DMEIF1 field.
	DMA_LISR_DMEIF1_Pos = 0x8
	// Bit mask of DMEIF1 field.
	DMA_LISR_DMEIF1_Msk = 0x100
	// Bit DMEIF1.
	DMA_LISR_DMEIF1 = 0x100
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF1_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF1_Error = 0x1
	// Position of FEIF1 field.
	DMA_LISR_FEIF1_Pos = 0x6
	// Bit mask of FEIF1 field.
	DMA_LISR_FEIF1_Msk = 0x40
	// Bit FEIF1.
	DMA_LISR_FEIF1 = 0x40
	// No FIFO error event on stream x
	DMA_LISR_FEIF1_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF1_Error = 0x1
	// Position of TCIF0 field.
	DMA_LISR_TCIF0_Pos = 0x5
	// Bit mask of TCIF0 field.
	DMA_LISR_TCIF0_Msk = 0x20
	// Bit TCIF0.
	DMA_LISR_TCIF0 = 0x20
	// No transfer complete event on stream x
	DMA_LISR_TCIF0_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF0_Complete = 0x1
	// Position of HTIF0 field.
	DMA_LISR_HTIF0_Pos = 0x4
	// Bit mask of HTIF0 field.
	DMA_LISR_HTIF0_Msk = 0x10
	// Bit HTIF0.
	DMA_LISR_HTIF0 = 0x10
	// No half transfer event on stream x
	DMA_LISR_HTIF0_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF0_Half = 0x1
	// Position of TEIF0 field.
	DMA_LISR_TEIF0_Pos = 0x3
	// Bit mask of TEIF0 field.
	DMA_LISR_TEIF0_Msk = 0x8
	// Bit TEIF0.
	DMA_LISR_TEIF0 = 0x8
	// No transfer error on stream x
	DMA_LISR_TEIF0_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF0_Error = 0x1
	// Position of DMEIF0 field.
	DMA_LISR_DMEIF0_Pos = 0x2
	// Bit mask of DMEIF0 field.
	DMA_LISR_DMEIF0_Msk = 0x4
	// Bit DMEIF0.
	DMA_LISR_DMEIF0 = 0x4
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF0_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF0_Error = 0x1
	// Position of FEIF0 field.
	DMA_LISR_FEIF0_Pos = 0x0
	// Bit mask of FEIF0 field.
	DMA_LISR_FEIF0_Msk = 0x1
	// Bit FEIF0.
	DMA_LISR_FEIF0 = 0x1
	// No FIFO error event on stream x
	DMA_LISR_FEIF0_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF0_Error = 0x1

	// HISR: high interrupt status register
	// Position of TCIF7 field.
	DMA_HISR_TCIF7_Pos = 0x1b
	// Bit mask of TCIF7 field.
	DMA_HISR_TCIF7_Msk = 0x8000000
	// Bit TCIF7.
	DMA_HISR_TCIF7 = 0x8000000
	// No transfer complete event on stream x
	DMA_HISR_TCIF7_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF7_Complete = 0x1
	// Position of HTIF7 field.
	DMA_HISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_HISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_HISR_HTIF7 = 0x4000000
	// No half transfer event on stream x
	DMA_HISR_HTIF7_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF7_Half = 0x1
	// Position of TEIF7 field.
	DMA_HISR_TEIF7_Pos = 0x19
	// Bit mask of TEIF7 field.
	DMA_HISR_TEIF7_Msk = 0x2000000
	// Bit TEIF7.
	DMA_HISR_TEIF7 = 0x2000000
	// No transfer error on stream x
	DMA_HISR_TEIF7_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF7_Error = 0x1
	// Position of DMEIF7 field.
	DMA_HISR_DMEIF7_Pos = 0x18
	// Bit mask of DMEIF7 field.
	DMA_HISR_DMEIF7_Msk = 0x1000000
	// Bit DMEIF7.
	DMA_HISR_DMEIF7 = 0x1000000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF7_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF7_Error = 0x1
	// Position of FEIF7 field.
	DMA_HISR_FEIF7_Pos = 0x16
	// Bit mask of FEIF7 field.
	DMA_HISR_FEIF7_Msk = 0x400000
	// Bit FEIF7.
	DMA_HISR_FEIF7 = 0x400000
	// No FIFO error event on stream x
	DMA_HISR_FEIF7_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF7_Error = 0x1
	// Position of TCIF6 field.
	DMA_HISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_HISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_HISR_TCIF6 = 0x200000
	// No transfer complete event on stream x
	DMA_HISR_TCIF6_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF6_Complete = 0x1
	// Position of HTIF6 field.
	DMA_HISR_HTIF6_Pos = 0x14
	// Bit mask of HTIF6 field.
	DMA_HISR_HTIF6_Msk = 0x100000
	// Bit HTIF6.
	DMA_HISR_HTIF6 = 0x100000
	// No half transfer event on stream x
	DMA_HISR_HTIF6_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF6_Half = 0x1
	// Position of TEIF6 field.
	DMA_HISR_TEIF6_Pos = 0x13
	// Bit mask of TEIF6 field.
	DMA_HISR_TEIF6_Msk = 0x80000
	// Bit TEIF6.
	DMA_HISR_TEIF6 = 0x80000
	// No transfer error on stream x
	DMA_HISR_TEIF6_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF6_Error = 0x1
	// Position of DMEIF6 field.
	DMA_HISR_DMEIF6_Pos = 0x12
	// Bit mask of DMEIF6 field.
	DMA_HISR_DMEIF6_Msk = 0x40000
	// Bit DMEIF6.
	DMA_HISR_DMEIF6 = 0x40000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF6_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF6_Error = 0x1
	// Position of FEIF6 field.
	DMA_HISR_FEIF6_Pos = 0x10
	// Bit mask of FEIF6 field.
	DMA_HISR_FEIF6_Msk = 0x10000
	// Bit FEIF6.
	DMA_HISR_FEIF6 = 0x10000
	// No FIFO error event on stream x
	DMA_HISR_FEIF6_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF6_Error = 0x1
	// Position of TCIF5 field.
	DMA_HISR_TCIF5_Pos = 0xb
	// Bit mask of TCIF5 field.
	DMA_HISR_TCIF5_Msk = 0x800
	// Bit TCIF5.
	DMA_HISR_TCIF5 = 0x800
	// No transfer complete event on stream x
	DMA_HISR_TCIF5_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF5_Complete = 0x1
	// Position of HTIF5 field.
	DMA_HISR_HTIF5_Pos = 0xa
	// Bit mask of HTIF5 field.
	DMA_HISR_HTIF5_Msk = 0x400
	// Bit HTIF5.
	DMA_HISR_HTIF5 = 0x400
	// No half transfer event on stream x
	DMA_HISR_HTIF5_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF5_Half = 0x1
	// Position of TEIF5 field.
	DMA_HISR_TEIF5_Pos = 0x9
	// Bit mask of TEIF5 field.
	DMA_HISR_TEIF5_Msk = 0x200
	// Bit TEIF5.
	DMA_HISR_TEIF5 = 0x200
	// No transfer error on stream x
	DMA_HISR_TEIF5_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF5_Error = 0x1
	// Position of DMEIF5 field.
	DMA_HISR_DMEIF5_Pos = 0x8
	// Bit mask of DMEIF5 field.
	DMA_HISR_DMEIF5_Msk = 0x100
	// Bit DMEIF5.
	DMA_HISR_DMEIF5 = 0x100
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF5_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF5_Error = 0x1
	// Position of FEIF5 field.
	DMA_HISR_FEIF5_Pos = 0x6
	// Bit mask of FEIF5 field.
	DMA_HISR_FEIF5_Msk = 0x40
	// Bit FEIF5.
	DMA_HISR_FEIF5 = 0x40
	// No FIFO error event on stream x
	DMA_HISR_FEIF5_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF5_Error = 0x1
	// Position of TCIF4 field.
	DMA_HISR_TCIF4_Pos = 0x5
	// Bit mask of TCIF4 field.
	DMA_HISR_TCIF4_Msk = 0x20
	// Bit TCIF4.
	DMA_HISR_TCIF4 = 0x20
	// No transfer complete event on stream x
	DMA_HISR_TCIF4_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF4_Complete = 0x1
	// Position of HTIF4 field.
	DMA_HISR_HTIF4_Pos = 0x4
	// Bit mask of HTIF4 field.
	DMA_HISR_HTIF4_Msk = 0x10
	// Bit HTIF4.
	DMA_HISR_HTIF4 = 0x10
	// No half transfer event on stream x
	DMA_HISR_HTIF4_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF4_Half = 0x1
	// Position of TEIF4 field.
	DMA_HISR_TEIF4_Pos = 0x3
	// Bit mask of TEIF4 field.
	DMA_HISR_TEIF4_Msk = 0x8
	// Bit TEIF4.
	DMA_HISR_TEIF4 = 0x8
	// No transfer error on stream x
	DMA_HISR_TEIF4_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF4_Error = 0x1
	// Position of DMEIF4 field.
	DMA_HISR_DMEIF4_Pos = 0x2
	// Bit mask of DMEIF4 field.
	DMA_HISR_DMEIF4_Msk = 0x4
	// Bit DMEIF4.
	DMA_HISR_DMEIF4 = 0x4
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF4_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF4_Error = 0x1
	// Position of FEIF4 field.
	DMA_HISR_FEIF4_Pos = 0x0
	// Bit mask of FEIF4 field.
	DMA_HISR_FEIF4_Msk = 0x1
	// Bit FEIF4.
	DMA_HISR_FEIF4 = 0x1
	// No FIFO error event on stream x
	DMA_HISR_FEIF4_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF4_Error = 0x1

	// LIFCR: low interrupt flag clear register
	// Position of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Pos = 0x1b
	// Bit mask of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Msk = 0x8000000
	// Bit CTCIF3.
	DMA_LIFCR_CTCIF3 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Pos = 0x1a
	// Bit mask of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Msk = 0x4000000
	// Bit CHTIF3.
	DMA_LIFCR_CHTIF3 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF3_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Pos = 0x19
	// Bit mask of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Msk = 0x2000000
	// Bit CTEIF3.
	DMA_LIFCR_CTEIF3 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF3_Clear = 0x1
	// Position of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Pos = 0x18
	// Bit mask of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Msk = 0x1000000
	// Bit CDMEIF3.
	DMA_LIFCR_CDMEIF3 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF3_Clear = 0x1
	// Position of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Pos = 0x16
	// Bit mask of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Msk = 0x400000
	// Bit CFEIF3.
	DMA_LIFCR_CFEIF3 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF3_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Pos = 0x15
	// Bit mask of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Msk = 0x200000
	// Bit CTCIF2.
	DMA_LIFCR_CTCIF2 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Pos = 0x14
	// Bit mask of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Msk = 0x100000
	// Bit CHTIF2.
	DMA_LIFCR_CHTIF2 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF2_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Pos = 0x13
	// Bit mask of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Msk = 0x80000
	// Bit CTEIF2.
	DMA_LIFCR_CTEIF2 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF2_Clear = 0x1
	// Position of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Pos = 0x12
	// Bit mask of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Msk = 0x40000
	// Bit CDMEIF2.
	DMA_LIFCR_CDMEIF2 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF2_Clear = 0x1
	// Position of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Pos = 0x10
	// Bit mask of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Msk = 0x10000
	// Bit CFEIF2.
	DMA_LIFCR_CFEIF2 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF2_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Pos = 0xb
	// Bit mask of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Msk = 0x800
	// Bit CTCIF1.
	DMA_LIFCR_CTCIF1 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Pos = 0xa
	// Bit mask of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Msk = 0x400
	// Bit CHTIF1.
	DMA_LIFCR_CHTIF1 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF1_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Pos = 0x9
	// Bit mask of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Msk = 0x200
	// Bit CTEIF1.
	DMA_LIFCR_CTEIF1 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF1_Clear = 0x1
	// Position of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Pos = 0x8
	// Bit mask of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Msk = 0x100
	// Bit CDMEIF1.
	DMA_LIFCR_CDMEIF1 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF1_Clear = 0x1
	// Position of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Pos = 0x6
	// Bit mask of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Msk = 0x40
	// Bit CFEIF1.
	DMA_LIFCR_CFEIF1 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF1_Clear = 0x1
	// Position of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Pos = 0x5
	// Bit mask of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Msk = 0x20
	// Bit CTCIF0.
	DMA_LIFCR_CTCIF0 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF0_Clear = 0x1
	// Position of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Pos = 0x4
	// Bit mask of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Msk = 0x10
	// Bit CHTIF0.
	DMA_LIFCR_CHTIF0 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF0_Clear = 0x1
	// Position of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Pos = 0x3
	// Bit mask of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Msk = 0x8
	// Bit CTEIF0.
	DMA_LIFCR_CTEIF0 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF0_Clear = 0x1
	// Position of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Pos = 0x2
	// Bit mask of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Msk = 0x4
	// Bit CDMEIF0.
	DMA_LIFCR_CDMEIF0 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF0_Clear = 0x1
	// Position of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Pos = 0x0
	// Bit mask of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Msk = 0x1
	// Bit CFEIF0.
	DMA_LIFCR_CFEIF0 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF0_Clear = 0x1

	// HIFCR: high interrupt flag clear register
	// Position of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Pos = 0x1b
	// Bit mask of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Msk = 0x8000000
	// Bit CTCIF7.
	DMA_HIFCR_CTCIF7 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_HIFCR_CHTIF7 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF7_Clear = 0x1
	// Position of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Pos = 0x19
	// Bit mask of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Msk = 0x2000000
	// Bit CTEIF7.
	DMA_HIFCR_CTEIF7 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF7_Clear = 0x1
	// Position of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Pos = 0x18
	// Bit mask of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Msk = 0x1000000
	// Bit CDMEIF7.
	DMA_HIFCR_CDMEIF7 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF7_Clear = 0x1
	// Position of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Pos = 0x16
	// Bit mask of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Msk = 0x400000
	// Bit CFEIF7.
	DMA_HIFCR_CFEIF7 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF7_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_HIFCR_CTCIF6 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Pos = 0x14
	// Bit mask of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Msk = 0x100000
	// Bit CHTIF6.
	DMA_HIFCR_CHTIF6 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF6_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Pos = 0x13
	// Bit mask of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Msk = 0x80000
	// Bit CTEIF6.
	DMA_HIFCR_CTEIF6 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF6_Clear = 0x1
	// Position of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Pos = 0x12
	// Bit mask of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Msk = 0x40000
	// Bit CDMEIF6.
	DMA_HIFCR_CDMEIF6 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF6_Clear = 0x1
	// Position of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Pos = 0x10
	// Bit mask of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Msk = 0x10000
	// Bit CFEIF6.
	DMA_HIFCR_CFEIF6 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF6_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Pos = 0xb
	// Bit mask of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Msk = 0x800
	// Bit CTCIF5.
	DMA_HIFCR_CTCIF5 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Pos = 0xa
	// Bit mask of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Msk = 0x400
	// Bit CHTIF5.
	DMA_HIFCR_CHTIF5 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF5_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Pos = 0x9
	// Bit mask of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Msk = 0x200
	// Bit CTEIF5.
	DMA_HIFCR_CTEIF5 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF5_Clear = 0x1
	// Position of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Pos = 0x8
	// Bit mask of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Msk = 0x100
	// Bit CDMEIF5.
	DMA_HIFCR_CDMEIF5 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF5_Clear = 0x1
	// Position of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Pos = 0x6
	// Bit mask of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Msk = 0x40
	// Bit CFEIF5.
	DMA_HIFCR_CFEIF5 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF5_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Pos = 0x5
	// Bit mask of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Msk = 0x20
	// Bit CTCIF4.
	DMA_HIFCR_CTCIF4 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Pos = 0x4
	// Bit mask of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Msk = 0x10
	// Bit CHTIF4.
	DMA_HIFCR_CHTIF4 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF4_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Pos = 0x3
	// Bit mask of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Msk = 0x8
	// Bit CTEIF4.
	DMA_HIFCR_CTEIF4 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF4_Clear = 0x1
	// Position of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Pos = 0x2
	// Bit mask of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Msk = 0x4
	// Bit CDMEIF4.
	DMA_HIFCR_CDMEIF4 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF4_Clear = 0x1
	// Position of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Pos = 0x0
	// Bit mask of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Msk = 0x1
	// Bit CFEIF4.
	DMA_HIFCR_CFEIF4 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF4_Clear = 0x1

	// ST.CR: stream x configuration register
	// Position of CHSEL field.
	DMA_ST_CR_CHSEL_Pos = 0x19
	// Bit mask of CHSEL field.
	DMA_ST_CR_CHSEL_Msk = 0x1e000000
	// Position of MBURST field.
	DMA_ST_CR_MBURST_Pos = 0x17
	// Bit mask of MBURST field.
	DMA_ST_CR_MBURST_Msk = 0x1800000
	// Single transfer
	DMA_ST_CR_MBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_MBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_MBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_MBURST_INCR16 = 0x3
	// Position of PBURST field.
	DMA_ST_CR_PBURST_Pos = 0x15
	// Bit mask of PBURST field.
	DMA_ST_CR_PBURST_Msk = 0x600000
	// Single transfer
	DMA_ST_CR_PBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_PBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_PBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_PBURST_INCR16 = 0x3
	// Position of CT field.
	DMA_ST_CR_CT_Pos = 0x13
	// Bit mask of CT field.
	DMA_ST_CR_CT_Msk = 0x80000
	// Bit CT.
	DMA_ST_CR_CT = 0x80000
	// The current target memory is Memory 0
	DMA_ST_CR_CT_Memory0 = 0x0
	// The current target memory is Memory 1
	DMA_ST_CR_CT_Memory1 = 0x1
	// Position of DBM field.
	DMA_ST_CR_DBM_Pos = 0x12
	// Bit mask of DBM field.
	DMA_ST_CR_DBM_Msk = 0x40000
	// Bit DBM.
	DMA_ST_CR_DBM = 0x40000
	// No buffer switching at the end of transfer
	DMA_ST_CR_DBM_Disabled = 0x0
	// Memory target switched at the end of the DMA transfer
	DMA_ST_CR_DBM_Enabled = 0x1
	// Position of PL field.
	DMA_ST_CR_PL_Pos = 0x10
	// Bit mask of PL field.
	DMA_ST_CR_PL_Msk = 0x30000
	// Low
	DMA_ST_CR_PL_Low = 0x0
	// Medium
	DMA_ST_CR_PL_Medium = 0x1
	// High
	DMA_ST_CR_PL_High = 0x2
	// Very high
	DMA_ST_CR_PL_VeryHigh = 0x3
	// Position of PINCOS field.
	DMA_ST_CR_PINCOS_Pos = 0xf
	// Bit mask of PINCOS field.
	DMA_ST_CR_PINCOS_Msk = 0x8000
	// Bit PINCOS.
	DMA_ST_CR_PINCOS = 0x8000
	// The offset size for the peripheral address calculation is linked to the PSIZE
	DMA_ST_CR_PINCOS_PSIZE = 0x0
	// The offset size for the peripheral address calculation is fixed to 4 (32-bit alignment)
	DMA_ST_CR_PINCOS_Fixed4 = 0x1
	// Position of MSIZE field.
	DMA_ST_CR_MSIZE_Pos = 0xd
	// Bit mask of MSIZE field.
	DMA_ST_CR_MSIZE_Msk = 0x6000
	// Byte (8-bit)
	DMA_ST_CR_MSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_MSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_ST_CR_PSIZE_Pos = 0xb
	// Bit mask of PSIZE field.
	DMA_ST_CR_PSIZE_Msk = 0x1800
	// Byte (8-bit)
	DMA_ST_CR_PSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_PSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_ST_CR_MINC_Pos = 0xa
	// Bit mask of MINC field.
	DMA_ST_CR_MINC_Msk = 0x400
	// Bit MINC.
	DMA_ST_CR_MINC = 0x400
	// Address pointer is fixed
	DMA_ST_CR_MINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_MINC_Incremented = 0x1
	// Position of PINC field.
	DMA_ST_CR_PINC_Pos = 0x9
	// Bit mask of PINC field.
	DMA_ST_CR_PINC_Msk = 0x200
	// Bit PINC.
	DMA_ST_CR_PINC = 0x200
	// Address pointer is fixed
	DMA_ST_CR_PINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_PINC_Incremented = 0x1
	// Position of CIRC field.
	DMA_ST_CR_CIRC_Pos = 0x8
	// Bit mask of CIRC field.
	DMA_ST_CR_CIRC_Msk = 0x100
	// Bit CIRC.
	DMA_ST_CR_CIRC = 0x100
	// Circular mode disabled
	DMA_ST_CR_CIRC_Disabled = 0x0
	// Circular mode enabled
	DMA_ST_CR_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_ST_CR_DIR_Pos = 0x6
	// Bit mask of DIR field.
	DMA_ST_CR_DIR_Msk = 0xc0
	// Peripheral-to-memory
	DMA_ST_CR_DIR_PeripheralToMemory = 0x0
	// Memory-to-peripheral
	DMA_ST_CR_DIR_MemoryToPeripheral = 0x1
	// Memory-to-memory
	DMA_ST_CR_DIR_MemoryToMemory = 0x2
	// Position of PFCTRL field.
	DMA_ST_CR_PFCTRL_Pos = 0x5
	// Bit mask of PFCTRL field.
	DMA_ST_CR_PFCTRL_Msk = 0x20
	// Bit PFCTRL.
	DMA_ST_CR_PFCTRL = 0x20
	// The DMA is the flow controller
	DMA_ST_CR_PFCTRL_DMA = 0x0
	// The peripheral is the flow controller
	DMA_ST_CR_PFCTRL_Peripheral = 0x1
	// Position of TCIE field.
	DMA_ST_CR_TCIE_Pos = 0x4
	// Bit mask of TCIE field.
	DMA_ST_CR_TCIE_Msk = 0x10
	// Bit TCIE.
	DMA_ST_CR_TCIE = 0x10
	// TC interrupt disabled
	DMA_ST_CR_TCIE_Disabled = 0x0
	// TC interrupt enabled
	DMA_ST_CR_TCIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_ST_CR_HTIE_Pos = 0x3
	// Bit mask of HTIE field.
	DMA_ST_CR_HTIE_Msk = 0x8
	// Bit HTIE.
	DMA_ST_CR_HTIE = 0x8
	// HT interrupt disabled
	DMA_ST_CR_HTIE_Disabled = 0x0
	// HT interrupt enabled
	DMA_ST_CR_HTIE_Enabled = 0x1
	// Position of TEIE field.
	DMA_ST_CR_TEIE_Pos = 0x2
	// Bit mask of TEIE field.
	DMA_ST_CR_TEIE_Msk = 0x4
	// Bit TEIE.
	DMA_ST_CR_TEIE = 0x4
	// TE interrupt disabled
	DMA_ST_CR_TEIE_Disabled = 0x0
	// TE interrupt enabled
	DMA_ST_CR_TEIE_Enabled = 0x1
	// Position of DMEIE field.
	DMA_ST_CR_DMEIE_Pos = 0x1
	// Bit mask of DMEIE field.
	DMA_ST_CR_DMEIE_Msk = 0x2
	// Bit DMEIE.
	DMA_ST_CR_DMEIE = 0x2
	// DME interrupt disabled
	DMA_ST_CR_DMEIE_Disabled = 0x0
	// DME interrupt enabled
	DMA_ST_CR_DMEIE_Enabled = 0x1
	// Position of EN field.
	DMA_ST_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_ST_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_ST_CR_EN = 0x1
	// Stream disabled
	DMA_ST_CR_EN_Disabled = 0x0
	// Stream enabled
	DMA_ST_CR_EN_Enabled = 0x1

	// ST.NDTR: stream x number of data register
	// Position of NDT field.
	DMA_ST_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_ST_NDTR_NDT_Msk = 0xffff

	// ST.PAR: stream x peripheral address register
	// Position of PA field.
	DMA_ST_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_ST_PAR_PA_Msk = 0xffffffff

	// ST.M0AR: stream x memory 0 address register
	// Position of M0A field.
	DMA_ST_M0AR_M0A_Pos = 0x0
	// Bit mask of M0A field.
	DMA_ST_M0AR_M0A_Msk = 0xffffffff

	// ST.M1AR: stream x memory 1 address register
	// Position of M1A field.
	DMA_ST_M1AR_M1A_Pos = 0x0
	// Bit mask of M1A field.
	DMA_ST_M1AR_M1A_Msk = 0xffffffff

	// ST.FCR: stream x FIFO control register
	// Position of FEIE field.
	DMA_ST_FCR_FEIE_Pos = 0x7
	// Bit mask of FEIE field.
	DMA_ST_FCR_FEIE_Msk = 0x80
	// Bit FEIE.
	DMA_ST_FCR_FEIE = 0x80
	// FE interrupt disabled
	DMA_ST_FCR_FEIE_Disabled = 0x0
	// FE interrupt enabled
	DMA_ST_FCR_FEIE_Enabled = 0x1
	// Position of FS field.
	DMA_ST_FCR_FS_Pos = 0x3
	// Bit mask of FS field.
	DMA_ST_FCR_FS_Msk = 0x38
	// 0 < fifo_level < 1/4
	DMA_ST_FCR_FS_Quarter1 = 0x0
	// 1/4 <= fifo_level < 1/2
	DMA_ST_FCR_FS_Quarter2 = 0x1
	// 1/2 <= fifo_level < 3/4
	DMA_ST_FCR_FS_Quarter3 = 0x2
	// 3/4 <= fifo_level < full
	DMA_ST_FCR_FS_Quarter4 = 0x3
	// FIFO is empty
	DMA_ST_FCR_FS_Empty = 0x4
	// FIFO is full
	DMA_ST_FCR_FS_Full = 0x5
	// Position of DMDIS field.
	DMA_ST_FCR_DMDIS_Pos = 0x2
	// Bit mask of DMDIS field.
	DMA_ST_FCR_DMDIS_Msk = 0x4
	// Bit DMDIS.
	DMA_ST_FCR_DMDIS = 0x4
	// Direct mode is enabled
	DMA_ST_FCR_DMDIS_Enabled = 0x0
	// Direct mode is disabled
	DMA_ST_FCR_DMDIS_Disabled = 0x1
	// Position of FTH field.
	DMA_ST_FCR_FTH_Pos = 0x0
	// Bit mask of FTH field.
	DMA_ST_FCR_FTH_Msk = 0x3
	// 1/4 full FIFO
	DMA_ST_FCR_FTH_Quarter = 0x0
	// 1/2 full FIFO
	DMA_ST_FCR_FTH_Half = 0x1
	// 3/4 full FIFO
	DMA_ST_FCR_FTH_ThreeQuarters = 0x2
	// Full FIFO
	DMA_ST_FCR_FTH_Full = 0x3
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: clock control register
	// Position of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Pos = 0x1b
	// Bit mask of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Msk = 0x8000000
	// Bit PLLI2SRDY.
	RCC_CR_PLLI2SRDY = 0x8000000
	// Clock not ready
	RCC_CR_PLLI2SRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLI2SRDY_Ready = 0x1
	// Position of PLLI2SON field.
	RCC_CR_PLLI2SON_Pos = 0x1a
	// Bit mask of PLLI2SON field.
	RCC_CR_PLLI2SON_Msk = 0x4000000
	// Bit PLLI2SON.
	RCC_CR_PLLI2SON = 0x4000000
	// Clock Off
	RCC_CR_PLLI2SON_Off = 0x0
	// Clock On
	RCC_CR_PLLI2SON_On = 0x1
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSICAL field.
	RCC_CR_HSICAL_Pos = 0x8
	// Bit mask of HSICAL field.
	RCC_CR_HSICAL_Msk = 0xff00
	// Position of HSITRIM field.
	RCC_CR_HSITRIM_Pos = 0x3
	// Bit mask of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1
	// Position of PLLSAIRDY field.
	RCC_CR_PLLSAIRDY_Pos = 0x1d
	// Bit mask of PLLSAIRDY field.
	RCC_CR_PLLSAIRDY_Msk = 0x20000000
	// Bit PLLSAIRDY.
	RCC_CR_PLLSAIRDY = 0x20000000
	// Clock not ready
	RCC_CR_PLLSAIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLSAIRDY_Ready = 0x1
	// Position of PLLSAION field.
	RCC_CR_PLLSAION_Pos = 0x1c
	// Bit mask of PLLSAION field.
	RCC_CR_PLLSAION_Msk = 0x10000000
	// Bit PLLSAION.
	RCC_CR_PLLSAION = 0x10000000
	// Clock Off
	RCC_CR_PLLSAION_Off = 0x0
	// Clock On
	RCC_CR_PLLSAION_On = 0x1

	// PLLCFGR: PLL configuration register
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x16
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x400000
	// Bit PLLSRC.
	RCC_PLLCFGR_PLLSRC = 0x400000
	// HSI clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSI = 0x0
	// HSE oscillator clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSE = 0x1
	// Position of PLLR field.
	RCC_PLLCFGR_PLLR_Pos = 0x1c
	// Bit mask of PLLR field.
	RCC_PLLCFGR_PLLR_Msk = 0x70000000
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x0
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0x3f
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x6
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7fc0
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x10
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x30000
	// PLLP=2
	RCC_PLLCFGR_PLLP_Div2 = 0x0
	// PLLP=4
	RCC_PLLCFGR_PLLP_Div4 = 0x1
	// PLLP=6
	RCC_PLLCFGR_PLLP_Div6 = 0x2
	// PLLP=8
	RCC_PLLCFGR_PLLP_Div8 = 0x3
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x18
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0xf000000

	// CFGR: clock configuration register
	// Position of MCO2 field.
	RCC_CFGR_MCO2_Pos = 0x1e
	// Bit mask of MCO2 field.
	RCC_CFGR_MCO2_Msk = 0xc0000000
	// System clock (SYSCLK) selected
	RCC_CFGR_MCO2_SYSCLK = 0x0
	// PLLI2S clock selected
	RCC_CFGR_MCO2_PLLI2S = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO2_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO2_PLL = 0x3
	// Position of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Pos = 0x1b
	// Bit mask of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Msk = 0x38000000
	// No division
	RCC_CFGR_MCO2PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO2PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO2PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO2PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO2PRE_Div5 = 0x7
	// Position of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Pos = 0x18
	// Bit mask of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Msk = 0x7000000
	// No division
	RCC_CFGR_MCO1PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO1PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO1PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO1PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO1PRE_Div5 = 0x7
	// Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Pos = 0x17
	// Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk = 0x800000
	// Bit I2SSRC.
	RCC_CFGR_I2SSRC = 0x800000
	// PLLI2S clock used as I2S clock source
	RCC_CFGR_I2SSRC_PLLI2S = 0x0
	// External clock mapped on the I2S_CKIN pin used as I2S clock source
	RCC_CFGR_I2SSRC_CKIN = 0x1
	// Position of MCO1 field.
	RCC_CFGR_MCO1_Pos = 0x15
	// Bit mask of MCO1 field.
	RCC_CFGR_MCO1_Msk = 0x600000
	// HSI clock selected
	RCC_CFGR_MCO1_HSI = 0x0
	// LSE oscillator selected
	RCC_CFGR_MCO1_LSE = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO1_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO1_PLL = 0x3
	// Position of RTCPRE field.
	RCC_CFGR_RTCPRE_Pos = 0x10
	// Bit mask of RTCPRE field.
	RCC_CFGR_RTCPRE_Msk = 0x1f0000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xd
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0xe000
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0xa
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x1c00
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x0
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x1
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x2
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x0
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x1
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x2

	// CIR: clock interrupt register
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Clear CSSF flag
	RCC_CIR_CSSC_Clear = 0x1
	// Position of PLLSAIRDYC field.
	RCC_CIR_PLLSAIRDYC_Pos = 0x16
	// Bit mask of PLLSAIRDYC field.
	RCC_CIR_PLLSAIRDYC_Msk = 0x400000
	// Bit PLLSAIRDYC.
	RCC_CIR_PLLSAIRDYC = 0x400000
	// Clear interrupt flag
	RCC_CIR_PLLSAIRDYC_Clear = 0x1
	// Position of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Pos = 0x15
	// Bit mask of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Msk = 0x200000
	// Bit PLLI2SRDYC.
	RCC_CIR_PLLI2SRDYC = 0x200000
	// Clear interrupt flag
	RCC_CIR_PLLI2SRDYC_Clear = 0x1
	// Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Pos = 0x14
	// Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk = 0x100000
	// Bit PLLRDYC.
	RCC_CIR_PLLRDYC = 0x100000
	// Clear interrupt flag
	RCC_CIR_PLLRDYC_Clear = 0x1
	// Position of HSERDYC field.
	RCC_CIR_HSERDYC_Pos = 0x13
	// Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC_Msk = 0x80000
	// Bit HSERDYC.
	RCC_CIR_HSERDYC = 0x80000
	// Clear interrupt flag
	RCC_CIR_HSERDYC_Clear = 0x1
	// Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Pos = 0x12
	// Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk = 0x40000
	// Bit HSIRDYC.
	RCC_CIR_HSIRDYC = 0x40000
	// Clear interrupt flag
	RCC_CIR_HSIRDYC_Clear = 0x1
	// Position of LSERDYC field.
	RCC_CIR_LSERDYC_Pos = 0x11
	// Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC_Msk = 0x20000
	// Bit LSERDYC.
	RCC_CIR_LSERDYC = 0x20000
	// Clear interrupt flag
	RCC_CIR_LSERDYC_Clear = 0x1
	// Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Pos = 0x10
	// Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk = 0x10000
	// Bit LSIRDYC.
	RCC_CIR_LSIRDYC = 0x10000
	// Clear interrupt flag
	RCC_CIR_LSIRDYC_Clear = 0x1
	// Position of PLLSAIRDYIE field.
	RCC_CIR_PLLSAIRDYIE_Pos = 0xe
	// Bit mask of PLLSAIRDYIE field.
	RCC_CIR_PLLSAIRDYIE_Msk = 0x4000
	// Bit PLLSAIRDYIE.
	RCC_CIR_PLLSAIRDYIE = 0x4000
	// Interrupt disabled
	RCC_CIR_PLLSAIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLSAIRDYIE_Enabled = 0x1
	// Position of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Pos = 0xd
	// Bit mask of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Msk = 0x2000
	// Bit PLLI2SRDYIE.
	RCC_CIR_PLLI2SRDYIE = 0x2000
	// Interrupt disabled
	RCC_CIR_PLLI2SRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLI2SRDYIE_Enabled = 0x1
	// Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Pos = 0xc
	// Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000
	// Bit PLLRDYIE.
	RCC_CIR_PLLRDYIE = 0x1000
	// Interrupt disabled
	RCC_CIR_PLLRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLRDYIE_Enabled = 0x1
	// Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Pos = 0xb
	// Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800
	// Bit HSERDYIE.
	RCC_CIR_HSERDYIE = 0x800
	// Interrupt disabled
	RCC_CIR_HSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSERDYIE_Enabled = 0x1
	// Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Pos = 0xa
	// Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400
	// Bit HSIRDYIE.
	RCC_CIR_HSIRDYIE = 0x400
	// Interrupt disabled
	RCC_CIR_HSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSIRDYIE_Enabled = 0x1
	// Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Pos = 0x9
	// Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200
	// Bit LSERDYIE.
	RCC_CIR_LSERDYIE = 0x200
	// Interrupt disabled
	RCC_CIR_LSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSERDYIE_Enabled = 0x1
	// Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Pos = 0x8
	// Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100
	// Bit LSIRDYIE.
	RCC_CIR_LSIRDYIE = 0x100
	// Interrupt disabled
	RCC_CIR_LSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSIRDYIE_Enabled = 0x1
	// Position of CSSF field.
	RCC_CIR_CSSF_Pos = 0x7
	// Bit mask of CSSF field.
	RCC_CIR_CSSF_Msk = 0x80
	// Bit CSSF.
	RCC_CIR_CSSF = 0x80
	// No clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_NotInterrupted = 0x0
	// Clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_Interrupted = 0x1
	// Position of PLLSAIRDYF field.
	RCC_CIR_PLLSAIRDYF_Pos = 0x6
	// Bit mask of PLLSAIRDYF field.
	RCC_CIR_PLLSAIRDYF_Msk = 0x40
	// Bit PLLSAIRDYF.
	RCC_CIR_PLLSAIRDYF = 0x40
	// No clock ready interrupt
	RCC_CIR_PLLSAIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLSAIRDYF_Interrupted = 0x1
	// Position of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Pos = 0x5
	// Bit mask of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Msk = 0x20
	// Bit PLLI2SRDYF.
	RCC_CIR_PLLI2SRDYF = 0x20
	// No clock ready interrupt
	RCC_CIR_PLLI2SRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLI2SRDYF_Interrupted = 0x1
	// Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIR_PLLRDYF = 0x10
	// No clock ready interrupt
	RCC_CIR_PLLRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLRDYF_Interrupted = 0x1
	// Position of HSERDYF field.
	RCC_CIR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIR_HSERDYF = 0x8
	// No clock ready interrupt
	RCC_CIR_HSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSERDYF_Interrupted = 0x1
	// Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Pos = 0x2
	// Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk = 0x4
	// Bit HSIRDYF.
	RCC_CIR_HSIRDYF = 0x4
	// No clock ready interrupt
	RCC_CIR_HSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSIRDYF_Interrupted = 0x1
	// Position of LSERDYF field.
	RCC_CIR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIR_LSERDYF = 0x2
	// No clock ready interrupt
	RCC_CIR_LSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSERDYF_Interrupted = 0x1
	// Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIR_LSIRDYF = 0x1
	// No clock ready interrupt
	RCC_CIR_LSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSIRDYF_Interrupted = 0x1

	// AHB1RSTR: AHB1 peripheral reset register
	// Position of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST_Pos = 0x1d
	// Bit mask of OTGHSRST field.
	RCC_AHB1RSTR_OTGHSRST_Msk = 0x20000000
	// Bit OTGHSRST.
	RCC_AHB1RSTR_OTGHSRST = 0x20000000
	// Reset the selected module
	RCC_AHB1RSTR_OTGHSRST_Reset = 0x1
	// Position of ETHMACRST field.
	RCC_AHB1RSTR_ETHMACRST_Pos = 0x19
	// Bit mask of ETHMACRST field.
	RCC_AHB1RSTR_ETHMACRST_Msk = 0x2000000
	// Bit ETHMACRST.
	RCC_AHB1RSTR_ETHMACRST = 0x2000000
	// Reset the selected module
	RCC_AHB1RSTR_ETHMACRST_Reset = 0x1
	// Position of DMA2DRST field.
	RCC_AHB1RSTR_DMA2DRST_Pos = 0x17
	// Bit mask of DMA2DRST field.
	RCC_AHB1RSTR_DMA2DRST_Msk = 0x800000
	// Bit DMA2DRST.
	RCC_AHB1RSTR_DMA2DRST = 0x800000
	// Reset the selected module
	RCC_AHB1RSTR_DMA2DRST_Reset = 0x1
	// Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Pos = 0x16
	// Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk = 0x400000
	// Bit DMA2RST.
	RCC_AHB1RSTR_DMA2RST = 0x400000
	// Reset the selected module
	RCC_AHB1RSTR_DMA2RST_Reset = 0x1
	// Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Pos = 0x15
	// Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk = 0x200000
	// Bit DMA1RST.
	RCC_AHB1RSTR_DMA1RST = 0x200000
	// Reset the selected module
	RCC_AHB1RSTR_DMA1RST_Reset = 0x1
	// Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHB1RSTR_CRCRST = 0x1000
	// Reset the selected module
	RCC_AHB1RSTR_CRCRST_Reset = 0x1
	// Position of GPIOKRST field.
	RCC_AHB1RSTR_GPIOKRST_Pos = 0xa
	// Bit mask of GPIOKRST field.
	RCC_AHB1RSTR_GPIOKRST_Msk = 0x400
	// Bit GPIOKRST.
	RCC_AHB1RSTR_GPIOKRST = 0x400
	// Reset the selected module
	RCC_AHB1RSTR_GPIOKRST_Reset = 0x1
	// Position of GPIOJRST field.
	RCC_AHB1RSTR_GPIOJRST_Pos = 0x9
	// Bit mask of GPIOJRST field.
	RCC_AHB1RSTR_GPIOJRST_Msk = 0x200
	// Bit GPIOJRST.
	RCC_AHB1RSTR_GPIOJRST = 0x200
	// Reset the selected module
	RCC_AHB1RSTR_GPIOJRST_Reset = 0x1
	// Position of GPIOIRST field.
	RCC_AHB1RSTR_GPIOIRST_Pos = 0x8
	// Bit mask of GPIOIRST field.
	RCC_AHB1RSTR_GPIOIRST_Msk = 0x100
	// Bit GPIOIRST.
	RCC_AHB1RSTR_GPIOIRST = 0x100
	// Reset the selected module
	RCC_AHB1RSTR_GPIOIRST_Reset = 0x1
	// Position of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Pos = 0x7
	// Bit mask of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Msk = 0x80
	// Bit GPIOHRST.
	RCC_AHB1RSTR_GPIOHRST = 0x80
	// Reset the selected module
	RCC_AHB1RSTR_GPIOHRST_Reset = 0x1
	// Position of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST_Pos = 0x6
	// Bit mask of GPIOGRST field.
	RCC_AHB1RSTR_GPIOGRST_Msk = 0x40
	// Bit GPIOGRST.
	RCC_AHB1RSTR_GPIOGRST = 0x40
	// Reset the selected module
	RCC_AHB1RSTR_GPIOGRST_Reset = 0x1
	// Position of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST_Pos = 0x5
	// Bit mask of GPIOFRST field.
	RCC_AHB1RSTR_GPIOFRST_Msk = 0x20
	// Bit GPIOFRST.
	RCC_AHB1RSTR_GPIOFRST = 0x20
	// Reset the selected module
	RCC_AHB1RSTR_GPIOFRST_Reset = 0x1
	// Position of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Pos = 0x4
	// Bit mask of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Msk = 0x10
	// Bit GPIOERST.
	RCC_AHB1RSTR_GPIOERST = 0x10
	// Reset the selected module
	RCC_AHB1RSTR_GPIOERST_Reset = 0x1
	// Position of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Pos = 0x3
	// Bit mask of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Msk = 0x8
	// Bit GPIODRST.
	RCC_AHB1RSTR_GPIODRST = 0x8
	// Reset the selected module
	RCC_AHB1RSTR_GPIODRST_Reset = 0x1
	// Position of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHB1RSTR_GPIOCRST = 0x4
	// Reset the selected module
	RCC_AHB1RSTR_GPIOCRST_Reset = 0x1
	// Position of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHB1RSTR_GPIOBRST = 0x2
	// Reset the selected module
	RCC_AHB1RSTR_GPIOBRST_Reset = 0x1
	// Position of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHB1RSTR_GPIOARST = 0x1
	// Reset the selected module
	RCC_AHB1RSTR_GPIOARST_Reset = 0x1

	// AHB2RSTR: AHB2 peripheral reset register
	// Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Pos = 0x7
	// Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk = 0x80
	// Bit OTGFSRST.
	RCC_AHB2RSTR_OTGFSRST = 0x80
	// Reset the selected module
	RCC_AHB2RSTR_OTGFSRST_Reset = 0x1
	// Position of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Pos = 0x6
	// Bit mask of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Msk = 0x40
	// Bit RNGRST.
	RCC_AHB2RSTR_RNGRST = 0x40
	// Reset the selected module
	RCC_AHB2RSTR_RNGRST_Reset = 0x1
	// Position of HSAHRST field.
	RCC_AHB2RSTR_HSAHRST_Pos = 0x5
	// Bit mask of HSAHRST field.
	RCC_AHB2RSTR_HSAHRST_Msk = 0x20
	// Bit HSAHRST.
	RCC_AHB2RSTR_HSAHRST = 0x20
	// Reset the selected module
	RCC_AHB2RSTR_HSAHRST_Reset = 0x1
	// Position of CRYPRST field.
	RCC_AHB2RSTR_CRYPRST_Pos = 0x4
	// Bit mask of CRYPRST field.
	RCC_AHB2RSTR_CRYPRST_Msk = 0x10
	// Bit CRYPRST.
	RCC_AHB2RSTR_CRYPRST = 0x10
	// Reset the selected module
	RCC_AHB2RSTR_CRYPRST_Reset = 0x1
	// Position of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Pos = 0x0
	// Bit mask of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Msk = 0x1
	// Bit DCMIRST.
	RCC_AHB2RSTR_DCMIRST = 0x1
	// Reset the selected module
	RCC_AHB2RSTR_DCMIRST_Reset = 0x1

	// AHB3RSTR: AHB3 peripheral reset register
	// Position of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Pos = 0x0
	// Bit mask of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Msk = 0x1
	// Bit FMCRST.
	RCC_AHB3RSTR_FMCRST = 0x1
	// Reset the selected module
	RCC_AHB3RSTR_FMCRST_Reset = 0x1
	// Position of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Pos = 0x1
	// Bit mask of QSPIRST field.
	RCC_AHB3RSTR_QSPIRST_Msk = 0x2
	// Bit QSPIRST.
	RCC_AHB3RSTR_QSPIRST = 0x2
	// Reset the selected module
	RCC_AHB3RSTR_QSPIRST_Reset = 0x1

	// APB1RSTR: APB1 peripheral reset register
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR_TIM2RST_Reset = 0x1
	// Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR_TIM3RST = 0x2
	// Reset the selected module
	RCC_APB1RSTR_TIM3RST_Reset = 0x1
	// Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR_TIM4RST = 0x4
	// Reset the selected module
	RCC_APB1RSTR_TIM4RST_Reset = 0x1
	// Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Pos = 0x3
	// Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk = 0x8
	// Bit TIM5RST.
	RCC_APB1RSTR_TIM5RST = 0x8
	// Reset the selected module
	RCC_APB1RSTR_TIM5RST_Reset = 0x1
	// Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR_TIM6RST = 0x10
	// Reset the selected module
	RCC_APB1RSTR_TIM6RST_Reset = 0x1
	// Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Pos = 0x5
	// Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk = 0x20
	// Bit TIM7RST.
	RCC_APB1RSTR_TIM7RST = 0x20
	// Reset the selected module
	RCC_APB1RSTR_TIM7RST_Reset = 0x1
	// Position of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Pos = 0x6
	// Bit mask of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Msk = 0x40
	// Bit TIM12RST.
	RCC_APB1RSTR_TIM12RST = 0x40
	// Reset the selected module
	RCC_APB1RSTR_TIM12RST_Reset = 0x1
	// Position of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Pos = 0x7
	// Bit mask of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Msk = 0x80
	// Bit TIM13RST.
	RCC_APB1RSTR_TIM13RST = 0x80
	// Reset the selected module
	RCC_APB1RSTR_TIM13RST_Reset = 0x1
	// Position of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Pos = 0x8
	// Bit mask of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Msk = 0x100
	// Bit TIM14RST.
	RCC_APB1RSTR_TIM14RST = 0x100
	// Reset the selected module
	RCC_APB1RSTR_TIM14RST_Reset = 0x1
	// Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Pos = 0xb
	// Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk = 0x800
	// Bit WWDGRST.
	RCC_APB1RSTR_WWDGRST = 0x800
	// Reset the selected module
	RCC_APB1RSTR_WWDGRST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Reset the selected module
	RCC_APB1RSTR_SPI2RST_Reset = 0x1
	// Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR_SPI3RST = 0x8000
	// Reset the selected module
	RCC_APB1RSTR_SPI3RST_Reset = 0x1
	// Position of UART2RST field.
	RCC_APB1RSTR_UART2RST_Pos = 0x11
	// Bit mask of UART2RST field.
	RCC_APB1RSTR_UART2RST_Msk = 0x20000
	// Bit UART2RST.
	RCC_APB1RSTR_UART2RST = 0x20000
	// Reset the selected module
	RCC_APB1RSTR_UART2RST_Reset = 0x1
	// Position of UART3RST field.
	RCC_APB1RSTR_UART3RST_Pos = 0x12
	// Bit mask of UART3RST field.
	RCC_APB1RSTR_UART3RST_Msk = 0x40000
	// Bit UART3RST.
	RCC_APB1RSTR_UART3RST = 0x40000
	// Reset the selected module
	RCC_APB1RSTR_UART3RST_Reset = 0x1
	// Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Pos = 0x13
	// Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk = 0x80000
	// Bit UART4RST.
	RCC_APB1RSTR_UART4RST = 0x80000
	// Reset the selected module
	RCC_APB1RSTR_UART4RST_Reset = 0x1
	// Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Pos = 0x14
	// Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk = 0x100000
	// Bit UART5RST.
	RCC_APB1RSTR_UART5RST = 0x100000
	// Reset the selected module
	RCC_APB1RSTR_UART5RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Reset the selected module
	RCC_APB1RSTR_I2C1RST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Reset the selected module
	RCC_APB1RSTR_I2C2RST_Reset = 0x1
	// Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Pos = 0x17
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk = 0x800000
	// Bit I2C3RST.
	RCC_APB1RSTR_I2C3RST = 0x800000
	// Reset the selected module
	RCC_APB1RSTR_I2C3RST_Reset = 0x1
	// Position of CAN1RST field.
	RCC_APB1RSTR_CAN1RST_Pos = 0x19
	// Bit mask of CAN1RST field.
	RCC_APB1RSTR_CAN1RST_Msk = 0x2000000
	// Bit CAN1RST.
	RCC_APB1RSTR_CAN1RST = 0x2000000
	// Reset the selected module
	RCC_APB1RSTR_CAN1RST_Reset = 0x1
	// Position of CAN2RST field.
	RCC_APB1RSTR_CAN2RST_Pos = 0x1a
	// Bit mask of CAN2RST field.
	RCC_APB1RSTR_CAN2RST_Msk = 0x4000000
	// Bit CAN2RST.
	RCC_APB1RSTR_CAN2RST = 0x4000000
	// Reset the selected module
	RCC_APB1RSTR_CAN2RST_Reset = 0x1
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Reset the selected module
	RCC_APB1RSTR_PWRRST_Reset = 0x1
	// Position of DACRST field.
	RCC_APB1RSTR_DACRST_Pos = 0x1d
	// Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST_Msk = 0x20000000
	// Bit DACRST.
	RCC_APB1RSTR_DACRST = 0x20000000
	// Reset the selected module
	RCC_APB1RSTR_DACRST_Reset = 0x1
	// Position of UART7RST field.
	RCC_APB1RSTR_UART7RST_Pos = 0x1e
	// Bit mask of UART7RST field.
	RCC_APB1RSTR_UART7RST_Msk = 0x40000000
	// Bit UART7RST.
	RCC_APB1RSTR_UART7RST = 0x40000000
	// Reset the selected module
	RCC_APB1RSTR_UART7RST_Reset = 0x1
	// Position of UART8RST field.
	RCC_APB1RSTR_UART8RST_Pos = 0x1f
	// Bit mask of UART8RST field.
	RCC_APB1RSTR_UART8RST_Msk = 0x80000000
	// Bit UART8RST.
	RCC_APB1RSTR_UART8RST = 0x80000000
	// Reset the selected module
	RCC_APB1RSTR_UART8RST_Reset = 0x1
	// Position of SPDIFRXRST field.
	RCC_APB1RSTR_SPDIFRXRST_Pos = 0x10
	// Bit mask of SPDIFRXRST field.
	RCC_APB1RSTR_SPDIFRXRST_Msk = 0x10000
	// Bit SPDIFRXRST.
	RCC_APB1RSTR_SPDIFRXRST = 0x10000
	// Reset the selected module
	RCC_APB1RSTR_SPDIFRXRST_Reset = 0x1
	// Position of CECRST field.
	RCC_APB1RSTR_CECRST_Pos = 0x1b
	// Bit mask of CECRST field.
	RCC_APB1RSTR_CECRST_Msk = 0x8000000
	// Bit CECRST.
	RCC_APB1RSTR_CECRST = 0x8000000
	// Reset the selected module
	RCC_APB1RSTR_CECRST_Reset = 0x1
	// Position of LPTIM1RST field.
	RCC_APB1RSTR_LPTIM1RST_Pos = 0x9
	// Bit mask of LPTIM1RST field.
	RCC_APB1RSTR_LPTIM1RST_Msk = 0x200
	// Bit LPTIM1RST.
	RCC_APB1RSTR_LPTIM1RST = 0x200
	// Reset the selected module
	RCC_APB1RSTR_LPTIM1RST_Reset = 0x1
	// Position of I2C4RST field.
	RCC_APB1RSTR_I2C4RST_Pos = 0x18
	// Bit mask of I2C4RST field.
	RCC_APB1RSTR_I2C4RST_Msk = 0x1000000
	// Bit I2C4RST.
	RCC_APB1RSTR_I2C4RST = 0x1000000
	// Reset the selected module
	RCC_APB1RSTR_I2C4RST_Reset = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0x0
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x1
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x1
	// Reset the selected module
	RCC_APB2RSTR_TIM1RST_Reset = 0x1
	// Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Pos = 0x1
	// Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk = 0x2
	// Bit TIM8RST.
	RCC_APB2RSTR_TIM8RST = 0x2
	// Reset the selected module
	RCC_APB2RSTR_TIM8RST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0x4
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x10
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x10
	// Reset the selected module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of USART6RST field.
	RCC_APB2RSTR_USART6RST_Pos = 0x5
	// Bit mask of USART6RST field.
	RCC_APB2RSTR_USART6RST_Msk = 0x20
	// Bit USART6RST.
	RCC_APB2RSTR_USART6RST = 0x20
	// Reset the selected module
	RCC_APB2RSTR_USART6RST_Reset = 0x1
	// Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Pos = 0x8
	// Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk = 0x100
	// Bit ADCRST.
	RCC_APB2RSTR_ADCRST = 0x100
	// Reset the selected module
	RCC_APB2RSTR_ADCRST_Reset = 0x1
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Reset the selected module
	RCC_APB2RSTR_SPI1RST_Reset = 0x1
	// Position of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Pos = 0xd
	// Bit mask of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Msk = 0x2000
	// Bit SPI4RST.
	RCC_APB2RSTR_SPI4RST = 0x2000
	// Reset the selected module
	RCC_APB2RSTR_SPI4RST_Reset = 0x1
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0xe
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x4000
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x4000
	// Reset the selected module
	RCC_APB2RSTR_SYSCFGRST_Reset = 0x1
	// Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Pos = 0x10
	// Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk = 0x10000
	// Bit TIM9RST.
	RCC_APB2RSTR_TIM9RST = 0x10000
	// Reset the selected module
	RCC_APB2RSTR_TIM9RST_Reset = 0x1
	// Position of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Pos = 0x11
	// Bit mask of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Msk = 0x20000
	// Bit TIM10RST.
	RCC_APB2RSTR_TIM10RST = 0x20000
	// Reset the selected module
	RCC_APB2RSTR_TIM10RST_Reset = 0x1
	// Position of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Pos = 0x12
	// Bit mask of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Msk = 0x40000
	// Bit TIM11RST.
	RCC_APB2RSTR_TIM11RST = 0x40000
	// Reset the selected module
	RCC_APB2RSTR_TIM11RST_Reset = 0x1
	// Position of SPI5RST field.
	RCC_APB2RSTR_SPI5RST_Pos = 0x14
	// Bit mask of SPI5RST field.
	RCC_APB2RSTR_SPI5RST_Msk = 0x100000
	// Bit SPI5RST.
	RCC_APB2RSTR_SPI5RST = 0x100000
	// Reset the selected module
	RCC_APB2RSTR_SPI5RST_Reset = 0x1
	// Position of SPI6RST field.
	RCC_APB2RSTR_SPI6RST_Pos = 0x15
	// Bit mask of SPI6RST field.
	RCC_APB2RSTR_SPI6RST_Msk = 0x200000
	// Bit SPI6RST.
	RCC_APB2RSTR_SPI6RST = 0x200000
	// Reset the selected module
	RCC_APB2RSTR_SPI6RST_Reset = 0x1
	// Position of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Pos = 0x16
	// Bit mask of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Msk = 0x400000
	// Bit SAI1RST.
	RCC_APB2RSTR_SAI1RST = 0x400000
	// Reset the selected module
	RCC_APB2RSTR_SAI1RST_Reset = 0x1
	// Position of LTDCRST field.
	RCC_APB2RSTR_LTDCRST_Pos = 0x1a
	// Bit mask of LTDCRST field.
	RCC_APB2RSTR_LTDCRST_Msk = 0x4000000
	// Bit LTDCRST.
	RCC_APB2RSTR_LTDCRST = 0x4000000
	// Reset the selected module
	RCC_APB2RSTR_LTDCRST_Reset = 0x1
	// Position of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Pos = 0x17
	// Bit mask of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Msk = 0x800000
	// Bit SAI2RST.
	RCC_APB2RSTR_SAI2RST = 0x800000
	// Reset the selected module
	RCC_APB2RSTR_SAI2RST_Reset = 0x1
	// Position of SDMMC1RST field.
	RCC_APB2RSTR_SDMMC1RST_Pos = 0xb
	// Bit mask of SDMMC1RST field.
	RCC_APB2RSTR_SDMMC1RST_Msk = 0x800
	// Bit SDMMC1RST.
	RCC_APB2RSTR_SDMMC1RST = 0x800
	// Reset the selected module
	RCC_APB2RSTR_SDMMC1RST_Reset = 0x1

	// AHB1ENR: AHB1 peripheral clock register
	// Position of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN_Pos = 0x1e
	// Bit mask of OTGHSULPIEN field.
	RCC_AHB1ENR_OTGHSULPIEN_Msk = 0x40000000
	// Bit OTGHSULPIEN.
	RCC_AHB1ENR_OTGHSULPIEN = 0x40000000
	// The selected clock is disabled
	RCC_AHB1ENR_OTGHSULPIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_OTGHSULPIEN_Enabled = 0x1
	// Position of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN_Pos = 0x1d
	// Bit mask of OTGHSEN field.
	RCC_AHB1ENR_OTGHSEN_Msk = 0x20000000
	// Bit OTGHSEN.
	RCC_AHB1ENR_OTGHSEN = 0x20000000
	// The selected clock is disabled
	RCC_AHB1ENR_OTGHSEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_OTGHSEN_Enabled = 0x1
	// Position of ETHMACPTPEN field.
	RCC_AHB1ENR_ETHMACPTPEN_Pos = 0x1c
	// Bit mask of ETHMACPTPEN field.
	RCC_AHB1ENR_ETHMACPTPEN_Msk = 0x10000000
	// Bit ETHMACPTPEN.
	RCC_AHB1ENR_ETHMACPTPEN = 0x10000000
	// The selected clock is disabled
	RCC_AHB1ENR_ETHMACPTPEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_ETHMACPTPEN_Enabled = 0x1
	// Position of ETHMACRXEN field.
	RCC_AHB1ENR_ETHMACRXEN_Pos = 0x1b
	// Bit mask of ETHMACRXEN field.
	RCC_AHB1ENR_ETHMACRXEN_Msk = 0x8000000
	// Bit ETHMACRXEN.
	RCC_AHB1ENR_ETHMACRXEN = 0x8000000
	// The selected clock is disabled
	RCC_AHB1ENR_ETHMACRXEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_ETHMACRXEN_Enabled = 0x1
	// Position of ETHMACTXEN field.
	RCC_AHB1ENR_ETHMACTXEN_Pos = 0x1a
	// Bit mask of ETHMACTXEN field.
	RCC_AHB1ENR_ETHMACTXEN_Msk = 0x4000000
	// Bit ETHMACTXEN.
	RCC_AHB1ENR_ETHMACTXEN = 0x4000000
	// The selected clock is disabled
	RCC_AHB1ENR_ETHMACTXEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_ETHMACTXEN_Enabled = 0x1
	// Position of ETHMACEN field.
	RCC_AHB1ENR_ETHMACEN_Pos = 0x19
	// Bit mask of ETHMACEN field.
	RCC_AHB1ENR_ETHMACEN_Msk = 0x2000000
	// Bit ETHMACEN.
	RCC_AHB1ENR_ETHMACEN = 0x2000000
	// The selected clock is disabled
	RCC_AHB1ENR_ETHMACEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_ETHMACEN_Enabled = 0x1
	// Position of DMA2DEN field.
	RCC_AHB1ENR_DMA2DEN_Pos = 0x17
	// Bit mask of DMA2DEN field.
	RCC_AHB1ENR_DMA2DEN_Msk = 0x800000
	// Bit DMA2DEN.
	RCC_AHB1ENR_DMA2DEN = 0x800000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA2DEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA2DEN_Enabled = 0x1
	// Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Pos = 0x16
	// Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk = 0x400000
	// Bit DMA2EN.
	RCC_AHB1ENR_DMA2EN = 0x400000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA2EN_Enabled = 0x1
	// Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Pos = 0x15
	// Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk = 0x200000
	// Bit DMA1EN.
	RCC_AHB1ENR_DMA1EN = 0x200000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA1EN_Enabled = 0x1
	// Position of CCMDATARAMEN field.
	RCC_AHB1ENR_CCMDATARAMEN_Pos = 0x14
	// Bit mask of CCMDATARAMEN field.
	RCC_AHB1ENR_CCMDATARAMEN_Msk = 0x100000
	// Bit CCMDATARAMEN.
	RCC_AHB1ENR_CCMDATARAMEN = 0x100000
	// The selected clock is disabled
	RCC_AHB1ENR_CCMDATARAMEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_CCMDATARAMEN_Enabled = 0x1
	// Position of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN_Pos = 0x12
	// Bit mask of BKPSRAMEN field.
	RCC_AHB1ENR_BKPSRAMEN_Msk = 0x40000
	// Bit BKPSRAMEN.
	RCC_AHB1ENR_BKPSRAMEN = 0x40000
	// The selected clock is disabled
	RCC_AHB1ENR_BKPSRAMEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_BKPSRAMEN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHB1ENR_CRCEN = 0x1000
	// The selected clock is disabled
	RCC_AHB1ENR_CRCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_CRCEN_Enabled = 0x1
	// Position of GPIOKEN field.
	RCC_AHB1ENR_GPIOKEN_Pos = 0xa
	// Bit mask of GPIOKEN field.
	RCC_AHB1ENR_GPIOKEN_Msk = 0x400
	// Bit GPIOKEN.
	RCC_AHB1ENR_GPIOKEN = 0x400
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOKEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOKEN_Enabled = 0x1
	// Position of GPIOJEN field.
	RCC_AHB1ENR_GPIOJEN_Pos = 0x9
	// Bit mask of GPIOJEN field.
	RCC_AHB1ENR_GPIOJEN_Msk = 0x200
	// Bit GPIOJEN.
	RCC_AHB1ENR_GPIOJEN = 0x200
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOJEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOJEN_Enabled = 0x1
	// Position of GPIOIEN field.
	RCC_AHB1ENR_GPIOIEN_Pos = 0x8
	// Bit mask of GPIOIEN field.
	RCC_AHB1ENR_GPIOIEN_Msk = 0x100
	// Bit GPIOIEN.
	RCC_AHB1ENR_GPIOIEN = 0x100
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOIEN_Enabled = 0x1
	// Position of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_AHB1ENR_GPIOHEN = 0x80
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOHEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOHEN_Enabled = 0x1
	// Position of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN_Pos = 0x6
	// Bit mask of GPIOGEN field.
	RCC_AHB1ENR_GPIOGEN_Msk = 0x40
	// Bit GPIOGEN.
	RCC_AHB1ENR_GPIOGEN = 0x40
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOGEN_Enabled = 0x1
	// Position of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN_Pos = 0x5
	// Bit mask of GPIOFEN field.
	RCC_AHB1ENR_GPIOFEN_Msk = 0x20
	// Bit GPIOFEN.
	RCC_AHB1ENR_GPIOFEN = 0x20
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOFEN_Enabled = 0x1
	// Position of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Pos = 0x4
	// Bit mask of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Msk = 0x10
	// Bit GPIOEEN.
	RCC_AHB1ENR_GPIOEEN = 0x10
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOEEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOEEN_Enabled = 0x1
	// Position of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Pos = 0x3
	// Bit mask of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Msk = 0x8
	// Bit GPIODEN.
	RCC_AHB1ENR_GPIODEN = 0x8
	// The selected clock is disabled
	RCC_AHB1ENR_GPIODEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIODEN_Enabled = 0x1
	// Position of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_AHB1ENR_GPIOCEN = 0x4
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOCEN_Enabled = 0x1
	// Position of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_AHB1ENR_GPIOBEN = 0x2
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOBEN_Enabled = 0x1
	// Position of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_AHB1ENR_GPIOAEN = 0x1
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOAEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOAEN_Enabled = 0x1
	// Position of DTCMRAMEN field.
	RCC_AHB1ENR_DTCMRAMEN_Pos = 0x14
	// Bit mask of DTCMRAMEN field.
	RCC_AHB1ENR_DTCMRAMEN_Msk = 0x100000
	// Bit DTCMRAMEN.
	RCC_AHB1ENR_DTCMRAMEN = 0x100000
	// The selected clock is disabled
	RCC_AHB1ENR_DTCMRAMEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DTCMRAMEN_Enabled = 0x1

	// AHB2ENR: AHB2 peripheral clock enable register
	// Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Pos = 0x7
	// Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk = 0x80
	// Bit OTGFSEN.
	RCC_AHB2ENR_OTGFSEN = 0x80
	// The selected clock is disabled
	RCC_AHB2ENR_OTGFSEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_OTGFSEN_Enabled = 0x1
	// Position of RNGEN field.
	RCC_AHB2ENR_RNGEN_Pos = 0x6
	// Bit mask of RNGEN field.
	RCC_AHB2ENR_RNGEN_Msk = 0x40
	// Bit RNGEN.
	RCC_AHB2ENR_RNGEN = 0x40
	// The selected clock is disabled
	RCC_AHB2ENR_RNGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_RNGEN_Enabled = 0x1
	// Position of HASHEN field.
	RCC_AHB2ENR_HASHEN_Pos = 0x5
	// Bit mask of HASHEN field.
	RCC_AHB2ENR_HASHEN_Msk = 0x20
	// Bit HASHEN.
	RCC_AHB2ENR_HASHEN = 0x20
	// The selected clock is disabled
	RCC_AHB2ENR_HASHEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_HASHEN_Enabled = 0x1
	// Position of CRYPEN field.
	RCC_AHB2ENR_CRYPEN_Pos = 0x4
	// Bit mask of CRYPEN field.
	RCC_AHB2ENR_CRYPEN_Msk = 0x10
	// Bit CRYPEN.
	RCC_AHB2ENR_CRYPEN = 0x10
	// The selected clock is disabled
	RCC_AHB2ENR_CRYPEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_CRYPEN_Enabled = 0x1
	// Position of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Pos = 0x0
	// Bit mask of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Msk = 0x1
	// Bit DCMIEN.
	RCC_AHB2ENR_DCMIEN = 0x1
	// The selected clock is disabled
	RCC_AHB2ENR_DCMIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_DCMIEN_Enabled = 0x1

	// AHB3ENR: AHB3 peripheral clock enable register
	// Position of FMCEN field.
	RCC_AHB3ENR_FMCEN_Pos = 0x0
	// Bit mask of FMCEN field.
	RCC_AHB3ENR_FMCEN_Msk = 0x1
	// Bit FMCEN.
	RCC_AHB3ENR_FMCEN = 0x1
	// The selected clock is disabled
	RCC_AHB3ENR_FMCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB3ENR_FMCEN_Enabled = 0x1
	// Position of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Pos = 0x1
	// Bit mask of QSPIEN field.
	RCC_AHB3ENR_QSPIEN_Msk = 0x2
	// Bit QSPIEN.
	RCC_AHB3ENR_QSPIEN = 0x2
	// The selected clock is disabled
	RCC_AHB3ENR_QSPIEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB3ENR_QSPIEN_Enabled = 0x1

	// APB1ENR: APB1 peripheral clock enable register
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR_TIM2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM2EN_Enabled = 0x1
	// Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR_TIM3EN = 0x2
	// The selected clock is disabled
	RCC_APB1ENR_TIM3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM3EN_Enabled = 0x1
	// Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR_TIM4EN = 0x4
	// The selected clock is disabled
	RCC_APB1ENR_TIM4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM4EN_Enabled = 0x1
	// Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Pos = 0x3
	// Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk = 0x8
	// Bit TIM5EN.
	RCC_APB1ENR_TIM5EN = 0x8
	// The selected clock is disabled
	RCC_APB1ENR_TIM5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM5EN_Enabled = 0x1
	// Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR_TIM6EN = 0x10
	// The selected clock is disabled
	RCC_APB1ENR_TIM6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM6EN_Enabled = 0x1
	// Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Pos = 0x5
	// Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk = 0x20
	// Bit TIM7EN.
	RCC_APB1ENR_TIM7EN = 0x20
	// The selected clock is disabled
	RCC_APB1ENR_TIM7EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM7EN_Enabled = 0x1
	// Position of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Pos = 0x6
	// Bit mask of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Msk = 0x40
	// Bit TIM12EN.
	RCC_APB1ENR_TIM12EN = 0x40
	// The selected clock is disabled
	RCC_APB1ENR_TIM12EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM12EN_Enabled = 0x1
	// Position of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Pos = 0x7
	// Bit mask of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Msk = 0x80
	// Bit TIM13EN.
	RCC_APB1ENR_TIM13EN = 0x80
	// The selected clock is disabled
	RCC_APB1ENR_TIM13EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM13EN_Enabled = 0x1
	// Position of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Pos = 0x8
	// Bit mask of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Msk = 0x100
	// Bit TIM14EN.
	RCC_APB1ENR_TIM14EN = 0x100
	// The selected clock is disabled
	RCC_APB1ENR_TIM14EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM14EN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// The selected clock is disabled
	RCC_APB1ENR_WWDGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_WWDGEN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// The selected clock is disabled
	RCC_APB1ENR_SPI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI2EN_Enabled = 0x1
	// Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR_SPI3EN = 0x8000
	// The selected clock is disabled
	RCC_APB1ENR_SPI3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI3EN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// The selected clock is disabled
	RCC_APB1ENR_USART2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART2EN_Enabled = 0x1
	// Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR_USART3EN = 0x40000
	// The selected clock is disabled
	RCC_APB1ENR_USART3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART3EN_Enabled = 0x1
	// Position of UART4EN field.
	RCC_APB1ENR_UART4EN_Pos = 0x13
	// Bit mask of UART4EN field.
	RCC_APB1ENR_UART4EN_Msk = 0x80000
	// Bit UART4EN.
	RCC_APB1ENR_UART4EN = 0x80000
	// The selected clock is disabled
	RCC_APB1ENR_UART4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART4EN_Enabled = 0x1
	// Position of UART5EN field.
	RCC_APB1ENR_UART5EN_Pos = 0x14
	// Bit mask of UART5EN field.
	RCC_APB1ENR_UART5EN_Msk = 0x100000
	// Bit UART5EN.
	RCC_APB1ENR_UART5EN = 0x100000
	// The selected clock is disabled
	RCC_APB1ENR_UART5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART5EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// The selected clock is disabled
	RCC_APB1ENR_I2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C1EN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// The selected clock is disabled
	RCC_APB1ENR_I2C2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C2EN_Enabled = 0x1
	// Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_APB1ENR_I2C3EN = 0x800000
	// The selected clock is disabled
	RCC_APB1ENR_I2C3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C3EN_Enabled = 0x1
	// Position of CAN1EN field.
	RCC_APB1ENR_CAN1EN_Pos = 0x19
	// Bit mask of CAN1EN field.
	RCC_APB1ENR_CAN1EN_Msk = 0x2000000
	// Bit CAN1EN.
	RCC_APB1ENR_CAN1EN = 0x2000000
	// The selected clock is disabled
	RCC_APB1ENR_CAN1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CAN1EN_Enabled = 0x1
	// Position of CAN2EN field.
	RCC_APB1ENR_CAN2EN_Pos = 0x1a
	// Bit mask of CAN2EN field.
	RCC_APB1ENR_CAN2EN_Msk = 0x4000000
	// Bit CAN2EN.
	RCC_APB1ENR_CAN2EN = 0x4000000
	// The selected clock is disabled
	RCC_APB1ENR_CAN2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CAN2EN_Enabled = 0x1
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// The selected clock is disabled
	RCC_APB1ENR_PWREN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_PWREN_Enabled = 0x1
	// Position of DACEN field.
	RCC_APB1ENR_DACEN_Pos = 0x1d
	// Bit mask of DACEN field.
	RCC_APB1ENR_DACEN_Msk = 0x20000000
	// Bit DACEN.
	RCC_APB1ENR_DACEN = 0x20000000
	// The selected clock is disabled
	RCC_APB1ENR_DACEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_DACEN_Enabled = 0x1
	// Position of UART7EN field.
	RCC_APB1ENR_UART7EN_Pos = 0x1e
	// Bit mask of UART7EN field.
	RCC_APB1ENR_UART7EN_Msk = 0x40000000
	// Bit UART7EN.
	RCC_APB1ENR_UART7EN = 0x40000000
	// The selected clock is disabled
	RCC_APB1ENR_UART7EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART7EN_Enabled = 0x1
	// Position of UART8EN field.
	RCC_APB1ENR_UART8EN_Pos = 0x1f
	// Bit mask of UART8EN field.
	RCC_APB1ENR_UART8EN_Msk = 0x80000000
	// Bit UART8EN.
	RCC_APB1ENR_UART8EN = 0x80000000
	// The selected clock is disabled
	RCC_APB1ENR_UART8EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART8EN_Enabled = 0x1
	// Position of SPDIFRXEN field.
	RCC_APB1ENR_SPDIFRXEN_Pos = 0x10
	// Bit mask of SPDIFRXEN field.
	RCC_APB1ENR_SPDIFRXEN_Msk = 0x10000
	// Bit SPDIFRXEN.
	RCC_APB1ENR_SPDIFRXEN = 0x10000
	// The selected clock is disabled
	RCC_APB1ENR_SPDIFRXEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPDIFRXEN_Enabled = 0x1
	// Position of CECEN field.
	RCC_APB1ENR_CECEN_Pos = 0x1b
	// Bit mask of CECEN field.
	RCC_APB1ENR_CECEN_Msk = 0x8000000
	// Bit CECEN.
	RCC_APB1ENR_CECEN = 0x8000000
	// The selected clock is disabled
	RCC_APB1ENR_CECEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CECEN_Enabled = 0x1
	// Position of LPTMI1EN field.
	RCC_APB1ENR_LPTMI1EN_Pos = 0x9
	// Bit mask of LPTMI1EN field.
	RCC_APB1ENR_LPTMI1EN_Msk = 0x200
	// Bit LPTMI1EN.
	RCC_APB1ENR_LPTMI1EN = 0x200
	// The selected clock is disabled
	RCC_APB1ENR_LPTMI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_LPTMI1EN_Enabled = 0x1
	// Position of I2C4EN field.
	RCC_APB1ENR_I2C4EN_Pos = 0x18
	// Bit mask of I2C4EN field.
	RCC_APB1ENR_I2C4EN_Msk = 0x1000000
	// Bit I2C4EN.
	RCC_APB1ENR_I2C4EN = 0x1000000
	// The selected clock is disabled
	RCC_APB1ENR_I2C4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C4EN_Enabled = 0x1

	// APB2ENR: APB2 peripheral clock enable register
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0x0
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x1
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x1
	// The selected clock is disabled
	RCC_APB2ENR_TIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM1EN_Enabled = 0x1
	// Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Pos = 0x1
	// Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk = 0x2
	// Bit TIM8EN.
	RCC_APB2ENR_TIM8EN = 0x2
	// The selected clock is disabled
	RCC_APB2ENR_TIM8EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM8EN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0x4
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x10
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x10
	// The selected clock is disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of USART6EN field.
	RCC_APB2ENR_USART6EN_Pos = 0x5
	// Bit mask of USART6EN field.
	RCC_APB2ENR_USART6EN_Msk = 0x20
	// Bit USART6EN.
	RCC_APB2ENR_USART6EN = 0x20
	// The selected clock is disabled
	RCC_APB2ENR_USART6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART6EN_Enabled = 0x1
	// Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Pos = 0x8
	// Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk = 0x100
	// Bit ADC1EN.
	RCC_APB2ENR_ADC1EN = 0x100
	// The selected clock is disabled
	RCC_APB2ENR_ADC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC1EN_Enabled = 0x1
	// Position of ADC2EN field.
	RCC_APB2ENR_ADC2EN_Pos = 0x9
	// Bit mask of ADC2EN field.
	RCC_APB2ENR_ADC2EN_Msk = 0x200
	// Bit ADC2EN.
	RCC_APB2ENR_ADC2EN = 0x200
	// The selected clock is disabled
	RCC_APB2ENR_ADC2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC2EN_Enabled = 0x1
	// Position of ADC3EN field.
	RCC_APB2ENR_ADC3EN_Pos = 0xa
	// Bit mask of ADC3EN field.
	RCC_APB2ENR_ADC3EN_Msk = 0x400
	// Bit ADC3EN.
	RCC_APB2ENR_ADC3EN = 0x400
	// The selected clock is disabled
	RCC_APB2ENR_ADC3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC3EN_Enabled = 0x1
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// The selected clock is disabled
	RCC_APB2ENR_SPI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI1EN_Enabled = 0x1
	// Position of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Pos = 0xd
	// Bit mask of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Msk = 0x2000
	// Bit SPI4EN.
	RCC_APB2ENR_SPI4EN = 0x2000
	// The selected clock is disabled
	RCC_APB2ENR_SPI4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI4EN_Enabled = 0x1
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0xe
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x4000
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x4000
	// The selected clock is disabled
	RCC_APB2ENR_SYSCFGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SYSCFGEN_Enabled = 0x1
	// Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Pos = 0x10
	// Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk = 0x10000
	// Bit TIM9EN.
	RCC_APB2ENR_TIM9EN = 0x10000
	// The selected clock is disabled
	RCC_APB2ENR_TIM9EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM9EN_Enabled = 0x1
	// Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Pos = 0x11
	// Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk = 0x20000
	// Bit TIM10EN.
	RCC_APB2ENR_TIM10EN = 0x20000
	// The selected clock is disabled
	RCC_APB2ENR_TIM10EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM10EN_Enabled = 0x1
	// Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Pos = 0x12
	// Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk = 0x40000
	// Bit TIM11EN.
	RCC_APB2ENR_TIM11EN = 0x40000
	// The selected clock is disabled
	RCC_APB2ENR_TIM11EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM11EN_Enabled = 0x1
	// Position of SPI5EN field.
	RCC_APB2ENR_SPI5EN_Pos = 0x14
	// Bit mask of SPI5EN field.
	RCC_APB2ENR_SPI5EN_Msk = 0x100000
	// Bit SPI5EN.
	RCC_APB2ENR_SPI5EN = 0x100000
	// The selected clock is disabled
	RCC_APB2ENR_SPI5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI5EN_Enabled = 0x1
	// Position of SPI6EN field.
	RCC_APB2ENR_SPI6EN_Pos = 0x15
	// Bit mask of SPI6EN field.
	RCC_APB2ENR_SPI6EN_Msk = 0x200000
	// Bit SPI6EN.
	RCC_APB2ENR_SPI6EN = 0x200000
	// The selected clock is disabled
	RCC_APB2ENR_SPI6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI6EN_Enabled = 0x1
	// Position of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Pos = 0x16
	// Bit mask of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Msk = 0x400000
	// Bit SAI1EN.
	RCC_APB2ENR_SAI1EN = 0x400000
	// The selected clock is disabled
	RCC_APB2ENR_SAI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SAI1EN_Enabled = 0x1
	// Position of LTDCEN field.
	RCC_APB2ENR_LTDCEN_Pos = 0x1a
	// Bit mask of LTDCEN field.
	RCC_APB2ENR_LTDCEN_Msk = 0x4000000
	// Bit LTDCEN.
	RCC_APB2ENR_LTDCEN = 0x4000000
	// The selected clock is disabled
	RCC_APB2ENR_LTDCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_LTDCEN_Enabled = 0x1
	// Position of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Pos = 0x17
	// Bit mask of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Msk = 0x800000
	// Bit SAI2EN.
	RCC_APB2ENR_SAI2EN = 0x800000
	// The selected clock is disabled
	RCC_APB2ENR_SAI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SAI2EN_Enabled = 0x1
	// Position of SDMMC1EN field.
	RCC_APB2ENR_SDMMC1EN_Pos = 0xb
	// Bit mask of SDMMC1EN field.
	RCC_APB2ENR_SDMMC1EN_Msk = 0x800
	// Bit SDMMC1EN.
	RCC_APB2ENR_SDMMC1EN = 0x800
	// The selected clock is disabled
	RCC_APB2ENR_SDMMC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SDMMC1EN_Enabled = 0x1
	// Position of MDIOEN field.
	RCC_APB2ENR_MDIOEN_Pos = 0x1e
	// Bit mask of MDIOEN field.
	RCC_APB2ENR_MDIOEN_Msk = 0x40000000
	// Bit MDIOEN.
	RCC_APB2ENR_MDIOEN = 0x40000000
	// The selected clock is disabled
	RCC_APB2ENR_MDIOEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_MDIOEN_Enabled = 0x1

	// AHB1LPENR: AHB1 peripheral clock enable in low power mode register
	// Position of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Pos = 0x0
	// Bit mask of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Msk = 0x1
	// Bit GPIOALPEN.
	RCC_AHB1LPENR_GPIOALPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOALPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOALPEN_EnabledInSleep = 0x1
	// Position of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Pos = 0x1
	// Bit mask of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Msk = 0x2
	// Bit GPIOBLPEN.
	RCC_AHB1LPENR_GPIOBLPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOBLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOBLPEN_EnabledInSleep = 0x1
	// Position of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Pos = 0x2
	// Bit mask of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Msk = 0x4
	// Bit GPIOCLPEN.
	RCC_AHB1LPENR_GPIOCLPEN = 0x4
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOCLPEN_EnabledInSleep = 0x1
	// Position of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Pos = 0x3
	// Bit mask of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Msk = 0x8
	// Bit GPIODLPEN.
	RCC_AHB1LPENR_GPIODLPEN = 0x8
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIODLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIODLPEN_EnabledInSleep = 0x1
	// Position of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Pos = 0x4
	// Bit mask of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Msk = 0x10
	// Bit GPIOELPEN.
	RCC_AHB1LPENR_GPIOELPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOELPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOELPEN_EnabledInSleep = 0x1
	// Position of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN_Pos = 0x5
	// Bit mask of GPIOFLPEN field.
	RCC_AHB1LPENR_GPIOFLPEN_Msk = 0x20
	// Bit GPIOFLPEN.
	RCC_AHB1LPENR_GPIOFLPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOFLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOFLPEN_EnabledInSleep = 0x1
	// Position of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN_Pos = 0x6
	// Bit mask of GPIOGLPEN field.
	RCC_AHB1LPENR_GPIOGLPEN_Msk = 0x40
	// Bit GPIOGLPEN.
	RCC_AHB1LPENR_GPIOGLPEN = 0x40
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOGLPEN_EnabledInSleep = 0x1
	// Position of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Pos = 0x7
	// Bit mask of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Msk = 0x80
	// Bit GPIOHLPEN.
	RCC_AHB1LPENR_GPIOHLPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOHLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOHLPEN_EnabledInSleep = 0x1
	// Position of GPIOILPEN field.
	RCC_AHB1LPENR_GPIOILPEN_Pos = 0x8
	// Bit mask of GPIOILPEN field.
	RCC_AHB1LPENR_GPIOILPEN_Msk = 0x100
	// Bit GPIOILPEN.
	RCC_AHB1LPENR_GPIOILPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOILPEN_EnabledInSleep = 0x1
	// Position of GPIOJLPEN field.
	RCC_AHB1LPENR_GPIOJLPEN_Pos = 0x9
	// Bit mask of GPIOJLPEN field.
	RCC_AHB1LPENR_GPIOJLPEN_Msk = 0x200
	// Bit GPIOJLPEN.
	RCC_AHB1LPENR_GPIOJLPEN = 0x200
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOJLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOJLPEN_EnabledInSleep = 0x1
	// Position of GPIOKLPEN field.
	RCC_AHB1LPENR_GPIOKLPEN_Pos = 0xa
	// Bit mask of GPIOKLPEN field.
	RCC_AHB1LPENR_GPIOKLPEN_Msk = 0x400
	// Bit GPIOKLPEN.
	RCC_AHB1LPENR_GPIOKLPEN = 0x400
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOKLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOKLPEN_EnabledInSleep = 0x1
	// Position of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Pos = 0xc
	// Bit mask of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Msk = 0x1000
	// Bit CRCLPEN.
	RCC_AHB1LPENR_CRCLPEN = 0x1000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_CRCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_CRCLPEN_EnabledInSleep = 0x1
	// Position of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Pos = 0xf
	// Bit mask of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Msk = 0x8000
	// Bit FLITFLPEN.
	RCC_AHB1LPENR_FLITFLPEN = 0x8000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_FLITFLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_FLITFLPEN_EnabledInSleep = 0x1
	// Position of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Pos = 0x10
	// Bit mask of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Msk = 0x10000
	// Bit SRAM1LPEN.
	RCC_AHB1LPENR_SRAM1LPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_SRAM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_SRAM1LPEN_EnabledInSleep = 0x1
	// Position of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN_Pos = 0x11
	// Bit mask of SRAM2LPEN field.
	RCC_AHB1LPENR_SRAM2LPEN_Msk = 0x20000
	// Bit SRAM2LPEN.
	RCC_AHB1LPENR_SRAM2LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_SRAM2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_SRAM2LPEN_EnabledInSleep = 0x1
	// Position of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN_Pos = 0x12
	// Bit mask of BKPSRAMLPEN field.
	RCC_AHB1LPENR_BKPSRAMLPEN_Msk = 0x40000
	// Bit BKPSRAMLPEN.
	RCC_AHB1LPENR_BKPSRAMLPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_BKPSRAMLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_BKPSRAMLPEN_EnabledInSleep = 0x1
	// Position of SRAM3LPEN field.
	RCC_AHB1LPENR_SRAM3LPEN_Pos = 0x13
	// Bit mask of SRAM3LPEN field.
	RCC_AHB1LPENR_SRAM3LPEN_Msk = 0x80000
	// Bit SRAM3LPEN.
	RCC_AHB1LPENR_SRAM3LPEN = 0x80000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_SRAM3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_SRAM3LPEN_EnabledInSleep = 0x1
	// Position of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Pos = 0x15
	// Bit mask of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Msk = 0x200000
	// Bit DMA1LPEN.
	RCC_AHB1LPENR_DMA1LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA1LPEN_EnabledInSleep = 0x1
	// Position of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Pos = 0x16
	// Bit mask of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Msk = 0x400000
	// Bit DMA2LPEN.
	RCC_AHB1LPENR_DMA2LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA2LPEN_EnabledInSleep = 0x1
	// Position of DMA2DLPEN field.
	RCC_AHB1LPENR_DMA2DLPEN_Pos = 0x17
	// Bit mask of DMA2DLPEN field.
	RCC_AHB1LPENR_DMA2DLPEN_Msk = 0x800000
	// Bit DMA2DLPEN.
	RCC_AHB1LPENR_DMA2DLPEN = 0x800000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA2DLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA2DLPEN_EnabledInSleep = 0x1
	// Position of ETHMACLPEN field.
	RCC_AHB1LPENR_ETHMACLPEN_Pos = 0x19
	// Bit mask of ETHMACLPEN field.
	RCC_AHB1LPENR_ETHMACLPEN_Msk = 0x2000000
	// Bit ETHMACLPEN.
	RCC_AHB1LPENR_ETHMACLPEN = 0x2000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_ETHMACLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_ETHMACLPEN_EnabledInSleep = 0x1
	// Position of ETHMACTXLPEN field.
	RCC_AHB1LPENR_ETHMACTXLPEN_Pos = 0x1a
	// Bit mask of ETHMACTXLPEN field.
	RCC_AHB1LPENR_ETHMACTXLPEN_Msk = 0x4000000
	// Bit ETHMACTXLPEN.
	RCC_AHB1LPENR_ETHMACTXLPEN = 0x4000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_ETHMACTXLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_ETHMACTXLPEN_EnabledInSleep = 0x1
	// Position of ETHMACRXLPEN field.
	RCC_AHB1LPENR_ETHMACRXLPEN_Pos = 0x1b
	// Bit mask of ETHMACRXLPEN field.
	RCC_AHB1LPENR_ETHMACRXLPEN_Msk = 0x8000000
	// Bit ETHMACRXLPEN.
	RCC_AHB1LPENR_ETHMACRXLPEN = 0x8000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_ETHMACRXLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_ETHMACRXLPEN_EnabledInSleep = 0x1
	// Position of ETHMACPTPLPEN field.
	RCC_AHB1LPENR_ETHMACPTPLPEN_Pos = 0x1c
	// Bit mask of ETHMACPTPLPEN field.
	RCC_AHB1LPENR_ETHMACPTPLPEN_Msk = 0x10000000
	// Bit ETHMACPTPLPEN.
	RCC_AHB1LPENR_ETHMACPTPLPEN = 0x10000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_ETHMACPTPLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_ETHMACPTPLPEN_EnabledInSleep = 0x1
	// Position of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN_Pos = 0x1d
	// Bit mask of OTGHSLPEN field.
	RCC_AHB1LPENR_OTGHSLPEN_Msk = 0x20000000
	// Bit OTGHSLPEN.
	RCC_AHB1LPENR_OTGHSLPEN = 0x20000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_OTGHSLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_OTGHSLPEN_EnabledInSleep = 0x1
	// Position of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN_Pos = 0x1e
	// Bit mask of OTGHSULPILPEN field.
	RCC_AHB1LPENR_OTGHSULPILPEN_Msk = 0x40000000
	// Bit OTGHSULPILPEN.
	RCC_AHB1LPENR_OTGHSULPILPEN = 0x40000000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_OTGHSULPILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_OTGHSULPILPEN_EnabledInSleep = 0x1

	// AHB2LPENR: AHB2 peripheral clock enable in low power mode register
	// Position of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Pos = 0x7
	// Bit mask of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Msk = 0x80
	// Bit OTGFSLPEN.
	RCC_AHB2LPENR_OTGFSLPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_OTGFSLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_OTGFSLPEN_EnabledInSleep = 0x1
	// Position of RNGLPEN field.
	RCC_AHB2LPENR_RNGLPEN_Pos = 0x6
	// Bit mask of RNGLPEN field.
	RCC_AHB2LPENR_RNGLPEN_Msk = 0x40
	// Bit RNGLPEN.
	RCC_AHB2LPENR_RNGLPEN = 0x40
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_RNGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_RNGLPEN_EnabledInSleep = 0x1
	// Position of HASHLPEN field.
	RCC_AHB2LPENR_HASHLPEN_Pos = 0x5
	// Bit mask of HASHLPEN field.
	RCC_AHB2LPENR_HASHLPEN_Msk = 0x20
	// Bit HASHLPEN.
	RCC_AHB2LPENR_HASHLPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_HASHLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_HASHLPEN_EnabledInSleep = 0x1
	// Position of CRYPLPEN field.
	RCC_AHB2LPENR_CRYPLPEN_Pos = 0x4
	// Bit mask of CRYPLPEN field.
	RCC_AHB2LPENR_CRYPLPEN_Msk = 0x10
	// Bit CRYPLPEN.
	RCC_AHB2LPENR_CRYPLPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_CRYPLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_CRYPLPEN_EnabledInSleep = 0x1
	// Position of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN_Pos = 0x0
	// Bit mask of DCMILPEN field.
	RCC_AHB2LPENR_DCMILPEN_Msk = 0x1
	// Bit DCMILPEN.
	RCC_AHB2LPENR_DCMILPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_DCMILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_DCMILPEN_EnabledInSleep = 0x1

	// AHB3LPENR: AHB3 peripheral clock enable in low power mode register
	// Position of FMCLPEN field.
	RCC_AHB3LPENR_FMCLPEN_Pos = 0x0
	// Bit mask of FMCLPEN field.
	RCC_AHB3LPENR_FMCLPEN_Msk = 0x1
	// Bit FMCLPEN.
	RCC_AHB3LPENR_FMCLPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB3LPENR_FMCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB3LPENR_FMCLPEN_EnabledInSleep = 0x1
	// Position of QSPILPEN field.
	RCC_AHB3LPENR_QSPILPEN_Pos = 0x1
	// Bit mask of QSPILPEN field.
	RCC_AHB3LPENR_QSPILPEN_Msk = 0x2
	// Bit QSPILPEN.
	RCC_AHB3LPENR_QSPILPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_AHB3LPENR_QSPILPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB3LPENR_QSPILPEN_EnabledInSleep = 0x1

	// APB1LPENR: APB1 peripheral clock enable in low power mode register
	// Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Pos = 0x0
	// Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk = 0x1
	// Bit TIM2LPEN.
	RCC_APB1LPENR_TIM2LPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM2LPEN_EnabledInSleep = 0x1
	// Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Pos = 0x1
	// Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk = 0x2
	// Bit TIM3LPEN.
	RCC_APB1LPENR_TIM3LPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM3LPEN_EnabledInSleep = 0x1
	// Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Pos = 0x2
	// Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk = 0x4
	// Bit TIM4LPEN.
	RCC_APB1LPENR_TIM4LPEN = 0x4
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM4LPEN_EnabledInSleep = 0x1
	// Position of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Pos = 0x3
	// Bit mask of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Msk = 0x8
	// Bit TIM5LPEN.
	RCC_APB1LPENR_TIM5LPEN = 0x8
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM5LPEN_EnabledInSleep = 0x1
	// Position of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Pos = 0x4
	// Bit mask of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Msk = 0x10
	// Bit TIM6LPEN.
	RCC_APB1LPENR_TIM6LPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM6LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM6LPEN_EnabledInSleep = 0x1
	// Position of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Pos = 0x5
	// Bit mask of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Msk = 0x20
	// Bit TIM7LPEN.
	RCC_APB1LPENR_TIM7LPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM7LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM7LPEN_EnabledInSleep = 0x1
	// Position of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN_Pos = 0x6
	// Bit mask of TIM12LPEN field.
	RCC_APB1LPENR_TIM12LPEN_Msk = 0x40
	// Bit TIM12LPEN.
	RCC_APB1LPENR_TIM12LPEN = 0x40
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM12LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM12LPEN_EnabledInSleep = 0x1
	// Position of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN_Pos = 0x7
	// Bit mask of TIM13LPEN field.
	RCC_APB1LPENR_TIM13LPEN_Msk = 0x80
	// Bit TIM13LPEN.
	RCC_APB1LPENR_TIM13LPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM13LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM13LPEN_EnabledInSleep = 0x1
	// Position of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN_Pos = 0x8
	// Bit mask of TIM14LPEN field.
	RCC_APB1LPENR_TIM14LPEN_Msk = 0x100
	// Bit TIM14LPEN.
	RCC_APB1LPENR_TIM14LPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM14LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM14LPEN_EnabledInSleep = 0x1
	// Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Pos = 0xb
	// Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk = 0x800
	// Bit WWDGLPEN.
	RCC_APB1LPENR_WWDGLPEN = 0x800
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_WWDGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_WWDGLPEN_EnabledInSleep = 0x1
	// Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Pos = 0xe
	// Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk = 0x4000
	// Bit SPI2LPEN.
	RCC_APB1LPENR_SPI2LPEN = 0x4000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPI2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPI2LPEN_EnabledInSleep = 0x1
	// Position of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Pos = 0xf
	// Bit mask of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Msk = 0x8000
	// Bit SPI3LPEN.
	RCC_APB1LPENR_SPI3LPEN = 0x8000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPI3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPI3LPEN_EnabledInSleep = 0x1
	// Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Pos = 0x11
	// Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk = 0x20000
	// Bit USART2LPEN.
	RCC_APB1LPENR_USART2LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_USART2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_USART2LPEN_EnabledInSleep = 0x1
	// Position of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Pos = 0x12
	// Bit mask of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Msk = 0x40000
	// Bit USART3LPEN.
	RCC_APB1LPENR_USART3LPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_USART3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_USART3LPEN_EnabledInSleep = 0x1
	// Position of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN_Pos = 0x13
	// Bit mask of UART4LPEN field.
	RCC_APB1LPENR_UART4LPEN_Msk = 0x80000
	// Bit UART4LPEN.
	RCC_APB1LPENR_UART4LPEN = 0x80000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_UART4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_UART4LPEN_EnabledInSleep = 0x1
	// Position of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN_Pos = 0x14
	// Bit mask of UART5LPEN field.
	RCC_APB1LPENR_UART5LPEN_Msk = 0x100000
	// Bit UART5LPEN.
	RCC_APB1LPENR_UART5LPEN = 0x100000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_UART5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_UART5LPEN_EnabledInSleep = 0x1
	// Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Pos = 0x15
	// Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk = 0x200000
	// Bit I2C1LPEN.
	RCC_APB1LPENR_I2C1LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C1LPEN_EnabledInSleep = 0x1
	// Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Pos = 0x16
	// Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk = 0x400000
	// Bit I2C2LPEN.
	RCC_APB1LPENR_I2C2LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C2LPEN_EnabledInSleep = 0x1
	// Position of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Pos = 0x17
	// Bit mask of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Msk = 0x800000
	// Bit I2C3LPEN.
	RCC_APB1LPENR_I2C3LPEN = 0x800000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C3LPEN_EnabledInSleep = 0x1
	// Position of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN_Pos = 0x19
	// Bit mask of CAN1LPEN field.
	RCC_APB1LPENR_CAN1LPEN_Msk = 0x2000000
	// Bit CAN1LPEN.
	RCC_APB1LPENR_CAN1LPEN = 0x2000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_CAN1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_CAN1LPEN_EnabledInSleep = 0x1
	// Position of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN_Pos = 0x1a
	// Bit mask of CAN2LPEN field.
	RCC_APB1LPENR_CAN2LPEN_Msk = 0x4000000
	// Bit CAN2LPEN.
	RCC_APB1LPENR_CAN2LPEN = 0x4000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_CAN2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_CAN2LPEN_EnabledInSleep = 0x1
	// Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Pos = 0x1c
	// Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk = 0x10000000
	// Bit PWRLPEN.
	RCC_APB1LPENR_PWRLPEN = 0x10000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_PWRLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_PWRLPEN_EnabledInSleep = 0x1
	// Position of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Pos = 0x1d
	// Bit mask of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Msk = 0x20000000
	// Bit DACLPEN.
	RCC_APB1LPENR_DACLPEN = 0x20000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_DACLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_DACLPEN_EnabledInSleep = 0x1
	// Position of UART7LPEN field.
	RCC_APB1LPENR_UART7LPEN_Pos = 0x1e
	// Bit mask of UART7LPEN field.
	RCC_APB1LPENR_UART7LPEN_Msk = 0x40000000
	// Bit UART7LPEN.
	RCC_APB1LPENR_UART7LPEN = 0x40000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_UART7LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_UART7LPEN_EnabledInSleep = 0x1
	// Position of UART8LPEN field.
	RCC_APB1LPENR_UART8LPEN_Pos = 0x1f
	// Bit mask of UART8LPEN field.
	RCC_APB1LPENR_UART8LPEN_Msk = 0x80000000
	// Bit UART8LPEN.
	RCC_APB1LPENR_UART8LPEN = 0x80000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_UART8LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_UART8LPEN_EnabledInSleep = 0x1
	// Position of SPDIFRXLPEN field.
	RCC_APB1LPENR_SPDIFRXLPEN_Pos = 0x10
	// Bit mask of SPDIFRXLPEN field.
	RCC_APB1LPENR_SPDIFRXLPEN_Msk = 0x10000
	// Bit SPDIFRXLPEN.
	RCC_APB1LPENR_SPDIFRXLPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPDIFRXLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPDIFRXLPEN_EnabledInSleep = 0x1
	// Position of CECLPEN field.
	RCC_APB1LPENR_CECLPEN_Pos = 0x1b
	// Bit mask of CECLPEN field.
	RCC_APB1LPENR_CECLPEN_Msk = 0x8000000
	// Bit CECLPEN.
	RCC_APB1LPENR_CECLPEN = 0x8000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_CECLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_CECLPEN_EnabledInSleep = 0x1
	// Position of LPTIM1LPEN field.
	RCC_APB1LPENR_LPTIM1LPEN_Pos = 0x9
	// Bit mask of LPTIM1LPEN field.
	RCC_APB1LPENR_LPTIM1LPEN_Msk = 0x200
	// Bit LPTIM1LPEN.
	RCC_APB1LPENR_LPTIM1LPEN = 0x200
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_LPTIM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_LPTIM1LPEN_EnabledInSleep = 0x1
	// Position of I2C4LPEN field.
	RCC_APB1LPENR_I2C4LPEN_Pos = 0x18
	// Bit mask of I2C4LPEN field.
	RCC_APB1LPENR_I2C4LPEN_Msk = 0x1000000
	// Bit I2C4LPEN.
	RCC_APB1LPENR_I2C4LPEN = 0x1000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C4LPEN_EnabledInSleep = 0x1

	// APB2LPENR: APB2 peripheral clock enabled in low power mode register
	// Position of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Pos = 0x0
	// Bit mask of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Msk = 0x1
	// Bit TIM1LPEN.
	RCC_APB2LPENR_TIM1LPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM1LPEN_EnabledInSleep = 0x1
	// Position of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN_Pos = 0x1
	// Bit mask of TIM8LPEN field.
	RCC_APB2LPENR_TIM8LPEN_Msk = 0x2
	// Bit TIM8LPEN.
	RCC_APB2LPENR_TIM8LPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM8LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM8LPEN_EnabledInSleep = 0x1
	// Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Pos = 0x4
	// Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x10
	// Bit USART1LPEN.
	RCC_APB2LPENR_USART1LPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_USART1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_USART1LPEN_EnabledInSleep = 0x1
	// Position of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Pos = 0x5
	// Bit mask of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Msk = 0x20
	// Bit USART6LPEN.
	RCC_APB2LPENR_USART6LPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_USART6LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_USART6LPEN_EnabledInSleep = 0x1
	// Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Pos = 0x8
	// Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk = 0x100
	// Bit ADC1LPEN.
	RCC_APB2LPENR_ADC1LPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC1LPEN_EnabledInSleep = 0x1
	// Position of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN_Pos = 0x9
	// Bit mask of ADC2LPEN field.
	RCC_APB2LPENR_ADC2LPEN_Msk = 0x200
	// Bit ADC2LPEN.
	RCC_APB2LPENR_ADC2LPEN = 0x200
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC2LPEN_EnabledInSleep = 0x1
	// Position of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN_Pos = 0xa
	// Bit mask of ADC3LPEN field.
	RCC_APB2LPENR_ADC3LPEN_Msk = 0x400
	// Bit ADC3LPEN.
	RCC_APB2LPENR_ADC3LPEN = 0x400
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC3LPEN_EnabledInSleep = 0x1
	// Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Pos = 0xc
	// Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk = 0x1000
	// Bit SPI1LPEN.
	RCC_APB2LPENR_SPI1LPEN = 0x1000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI1LPEN_EnabledInSleep = 0x1
	// Position of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Pos = 0xd
	// Bit mask of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Msk = 0x2000
	// Bit SPI4LPEN.
	RCC_APB2LPENR_SPI4LPEN = 0x2000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI4LPEN_EnabledInSleep = 0x1
	// Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0xe
	// Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x4000
	// Bit SYSCFGLPEN.
	RCC_APB2LPENR_SYSCFGLPEN = 0x4000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SYSCFGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SYSCFGLPEN_EnabledInSleep = 0x1
	// Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Pos = 0x10
	// Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk = 0x10000
	// Bit TIM9LPEN.
	RCC_APB2LPENR_TIM9LPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM9LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM9LPEN_EnabledInSleep = 0x1
	// Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Pos = 0x11
	// Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk = 0x20000
	// Bit TIM10LPEN.
	RCC_APB2LPENR_TIM10LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM10LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM10LPEN_EnabledInSleep = 0x1
	// Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Pos = 0x12
	// Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk = 0x40000
	// Bit TIM11LPEN.
	RCC_APB2LPENR_TIM11LPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM11LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM11LPEN_EnabledInSleep = 0x1
	// Position of SPI5LPEN field.
	RCC_APB2LPENR_SPI5LPEN_Pos = 0x14
	// Bit mask of SPI5LPEN field.
	RCC_APB2LPENR_SPI5LPEN_Msk = 0x100000
	// Bit SPI5LPEN.
	RCC_APB2LPENR_SPI5LPEN = 0x100000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI5LPEN_EnabledInSleep = 0x1
	// Position of SPI6LPEN field.
	RCC_APB2LPENR_SPI6LPEN_Pos = 0x15
	// Bit mask of SPI6LPEN field.
	RCC_APB2LPENR_SPI6LPEN_Msk = 0x200000
	// Bit SPI6LPEN.
	RCC_APB2LPENR_SPI6LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI6LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI6LPEN_EnabledInSleep = 0x1
	// Position of SAI1LPEN field.
	RCC_APB2LPENR_SAI1LPEN_Pos = 0x16
	// Bit mask of SAI1LPEN field.
	RCC_APB2LPENR_SAI1LPEN_Msk = 0x400000
	// Bit SAI1LPEN.
	RCC_APB2LPENR_SAI1LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SAI1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SAI1LPEN_EnabledInSleep = 0x1
	// Position of LTDCLPEN field.
	RCC_APB2LPENR_LTDCLPEN_Pos = 0x1a
	// Bit mask of LTDCLPEN field.
	RCC_APB2LPENR_LTDCLPEN_Msk = 0x4000000
	// Bit LTDCLPEN.
	RCC_APB2LPENR_LTDCLPEN = 0x4000000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_LTDCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_LTDCLPEN_EnabledInSleep = 0x1
	// Position of SAI2LPEN field.
	RCC_APB2LPENR_SAI2LPEN_Pos = 0x17
	// Bit mask of SAI2LPEN field.
	RCC_APB2LPENR_SAI2LPEN_Msk = 0x800000
	// Bit SAI2LPEN.
	RCC_APB2LPENR_SAI2LPEN = 0x800000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SAI2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SAI2LPEN_EnabledInSleep = 0x1
	// Position of SDMMC1LPEN field.
	RCC_APB2LPENR_SDMMC1LPEN_Pos = 0xb
	// Bit mask of SDMMC1LPEN field.
	RCC_APB2LPENR_SDMMC1LPEN_Msk = 0x800
	// Bit SDMMC1LPEN.
	RCC_APB2LPENR_SDMMC1LPEN = 0x800
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SDMMC1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SDMMC1LPEN_EnabledInSleep = 0x1

	// BDCR: Backup domain control register
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Reset not activated
	RCC_BDCR_BDRST_Disabled = 0x0
	// Reset the entire RTC domain
	RCC_BDCR_BDRST_Enabled = 0x1
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// RTC clock disabled
	RCC_BDCR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_BDCR_RTCEN_Enabled = 0x1
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// LSE crystal oscillator not bypassed
	RCC_BDCR_LSEBYP_NotBypassed = 0x0
	// LSE crystal oscillator bypassed with external clock
	RCC_BDCR_LSEBYP_Bypassed = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// LSE oscillator not ready
	RCC_BDCR_LSERDY_NotReady = 0x0
	// LSE oscillator ready
	RCC_BDCR_LSERDY_Ready = 0x1
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// LSE oscillator Off
	RCC_BDCR_LSEON_Off = 0x0
	// LSE oscillator On
	RCC_BDCR_LSEON_On = 0x1
	// Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Pos = 0x3
	// Bit mask of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18
	// Low drive capacity
	RCC_BDCR_LSEDRV_Low = 0x0
	// Medium-high drive capacity
	RCC_BDCR_LSEDRV_MediumHigh = 0x1
	// Medium-low drive capacity
	RCC_BDCR_LSEDRV_MediumLow = 0x2
	// High drive capacity
	RCC_BDCR_LSEDRV_High = 0x3
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// No clock
	RCC_BDCR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a prescaler used as RTC clock
	RCC_BDCR_RTCSEL_HSE = 0x3

	// CSR: clock control & status register
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of WDGRSTF field.
	RCC_CSR_WDGRSTF_Pos = 0x1d
	// Bit mask of WDGRSTF field.
	RCC_CSR_WDGRSTF_Msk = 0x20000000
	// Bit WDGRSTF.
	RCC_CSR_WDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_WDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WDGRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_PORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PORRSTF_Reset = 0x1
	// Position of PADRSTF field.
	RCC_CSR_PADRSTF_Pos = 0x1a
	// Bit mask of PADRSTF field.
	RCC_CSR_PADRSTF_Msk = 0x4000000
	// Bit PADRSTF.
	RCC_CSR_PADRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PADRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PADRSTF_Reset = 0x1
	// Position of BORRSTF field.
	RCC_CSR_BORRSTF_Pos = 0x19
	// Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF_Msk = 0x2000000
	// Bit BORRSTF.
	RCC_CSR_BORRSTF = 0x2000000
	// No reset has occured
	RCC_CSR_BORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_BORRSTF_Reset = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// LSI oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// LSI oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// LSI oscillator Off
	RCC_CSR_LSION_Off = 0x0
	// LSI oscillator On
	RCC_CSR_LSION_On = 0x1

	// SSCGR: spread spectrum clock generation register
	// Position of SSCGEN field.
	RCC_SSCGR_SSCGEN_Pos = 0x1f
	// Bit mask of SSCGEN field.
	RCC_SSCGR_SSCGEN_Msk = 0x80000000
	// Bit SSCGEN.
	RCC_SSCGR_SSCGEN = 0x80000000
	// Spread spectrum modulation disabled
	RCC_SSCGR_SSCGEN_Disabled = 0x0
	// Spread spectrum modulation enabled
	RCC_SSCGR_SSCGEN_Enabled = 0x1
	// Position of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Pos = 0x1e
	// Bit mask of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Msk = 0x40000000
	// Bit SPREADSEL.
	RCC_SSCGR_SPREADSEL = 0x40000000
	// Center spread
	RCC_SSCGR_SPREADSEL_Center = 0x0
	// Down spread
	RCC_SSCGR_SPREADSEL_Down = 0x1
	// Position of INCSTEP field.
	RCC_SSCGR_INCSTEP_Pos = 0xd
	// Bit mask of INCSTEP field.
	RCC_SSCGR_INCSTEP_Msk = 0xfffe000
	// Position of MODPER field.
	RCC_SSCGR_MODPER_Pos = 0x0
	// Bit mask of MODPER field.
	RCC_SSCGR_MODPER_Msk = 0x1fff

	// PLLI2SCFGR: PLLI2S configuration register
	// Position of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Pos = 0x1c
	// Bit mask of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Msk = 0x70000000
	// Position of PLLI2SQ field.
	RCC_PLLI2SCFGR_PLLI2SQ_Pos = 0x18
	// Bit mask of PLLI2SQ field.
	RCC_PLLI2SCFGR_PLLI2SQ_Msk = 0xf000000
	// Position of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Pos = 0x6
	// Bit mask of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Msk = 0x7fc0
	// Position of PLLI2SP field.
	RCC_PLLI2SCFGR_PLLI2SP_Pos = 0x10
	// Bit mask of PLLI2SP field.
	RCC_PLLI2SCFGR_PLLI2SP_Msk = 0x30000
	// PLL*P=2
	RCC_PLLI2SCFGR_PLLI2SP_Div2 = 0x0
	// PLL*P=4
	RCC_PLLI2SCFGR_PLLI2SP_Div4 = 0x1
	// PLL*P=6
	RCC_PLLI2SCFGR_PLLI2SP_Div6 = 0x2
	// PLL*P=8
	RCC_PLLI2SCFGR_PLLI2SP_Div8 = 0x3

	// PLLSAICFGR: PLL configuration register
	// Position of PLLSAIN field.
	RCC_PLLSAICFGR_PLLSAIN_Pos = 0x6
	// Bit mask of PLLSAIN field.
	RCC_PLLSAICFGR_PLLSAIN_Msk = 0x7fc0
	// Position of PLLSAIP field.
	RCC_PLLSAICFGR_PLLSAIP_Pos = 0x10
	// Bit mask of PLLSAIP field.
	RCC_PLLSAICFGR_PLLSAIP_Msk = 0x30000
	// PLL*P=2
	RCC_PLLSAICFGR_PLLSAIP_Div2 = 0x0
	// PLL*P=4
	RCC_PLLSAICFGR_PLLSAIP_Div4 = 0x1
	// PLL*P=6
	RCC_PLLSAICFGR_PLLSAIP_Div6 = 0x2
	// PLL*P=8
	RCC_PLLSAICFGR_PLLSAIP_Div8 = 0x3
	// Position of PLLSAIQ field.
	RCC_PLLSAICFGR_PLLSAIQ_Pos = 0x18
	// Bit mask of PLLSAIQ field.
	RCC_PLLSAICFGR_PLLSAIQ_Msk = 0xf000000
	// Position of PLLSAIR field.
	RCC_PLLSAICFGR_PLLSAIR_Pos = 0x1c
	// Bit mask of PLLSAIR field.
	RCC_PLLSAICFGR_PLLSAIR_Msk = 0x70000000

	// DCKCFGR1: dedicated clocks configuration register
	// Position of PLLI2SDIVQ field.
	RCC_DCKCFGR1_PLLI2SDIVQ_Pos = 0x0
	// Bit mask of PLLI2SDIVQ field.
	RCC_DCKCFGR1_PLLI2SDIVQ_Msk = 0x1f
	// PLLI2SDIVQ = /1
	RCC_DCKCFGR1_PLLI2SDIVQ_Div1 = 0x0
	// PLLI2SDIVQ = /2
	RCC_DCKCFGR1_PLLI2SDIVQ_Div2 = 0x1
	// PLLI2SDIVQ = /3
	RCC_DCKCFGR1_PLLI2SDIVQ_Div3 = 0x2
	// PLLI2SDIVQ = /4
	RCC_DCKCFGR1_PLLI2SDIVQ_Div4 = 0x3
	// PLLI2SDIVQ = /5
	RCC_DCKCFGR1_PLLI2SDIVQ_Div5 = 0x4
	// PLLI2SDIVQ = /6
	RCC_DCKCFGR1_PLLI2SDIVQ_Div6 = 0x5
	// PLLI2SDIVQ = /7
	RCC_DCKCFGR1_PLLI2SDIVQ_Div7 = 0x6
	// PLLI2SDIVQ = /8
	RCC_DCKCFGR1_PLLI2SDIVQ_Div8 = 0x7
	// PLLI2SDIVQ = /9
	RCC_DCKCFGR1_PLLI2SDIVQ_Div9 = 0x8
	// PLLI2SDIVQ = /10
	RCC_DCKCFGR1_PLLI2SDIVQ_Div10 = 0x9
	// PLLI2SDIVQ = /11
	RCC_DCKCFGR1_PLLI2SDIVQ_Div11 = 0xa
	// PLLI2SDIVQ = /12
	RCC_DCKCFGR1_PLLI2SDIVQ_Div12 = 0xb
	// PLLI2SDIVQ = /13
	RCC_DCKCFGR1_PLLI2SDIVQ_Div13 = 0xc
	// PLLI2SDIVQ = /14
	RCC_DCKCFGR1_PLLI2SDIVQ_Div14 = 0xd
	// PLLI2SDIVQ = /15
	RCC_DCKCFGR1_PLLI2SDIVQ_Div15 = 0xe
	// PLLI2SDIVQ = /16
	RCC_DCKCFGR1_PLLI2SDIVQ_Div16 = 0xf
	// PLLI2SDIVQ = /17
	RCC_DCKCFGR1_PLLI2SDIVQ_Div17 = 0x10
	// PLLI2SDIVQ = /18
	RCC_DCKCFGR1_PLLI2SDIVQ_Div18 = 0x11
	// PLLI2SDIVQ = /19
	RCC_DCKCFGR1_PLLI2SDIVQ_Div19 = 0x12
	// PLLI2SDIVQ = /20
	RCC_DCKCFGR1_PLLI2SDIVQ_Div20 = 0x13
	// PLLI2SDIVQ = /21
	RCC_DCKCFGR1_PLLI2SDIVQ_Div21 = 0x14
	// PLLI2SDIVQ = /22
	RCC_DCKCFGR1_PLLI2SDIVQ_Div22 = 0x15
	// PLLI2SDIVQ = /23
	RCC_DCKCFGR1_PLLI2SDIVQ_Div23 = 0x16
	// PLLI2SDIVQ = /24
	RCC_DCKCFGR1_PLLI2SDIVQ_Div24 = 0x17
	// PLLI2SDIVQ = /25
	RCC_DCKCFGR1_PLLI2SDIVQ_Div25 = 0x18
	// PLLI2SDIVQ = /26
	RCC_DCKCFGR1_PLLI2SDIVQ_Div26 = 0x19
	// PLLI2SDIVQ = /27
	RCC_DCKCFGR1_PLLI2SDIVQ_Div27 = 0x1a
	// PLLI2SDIVQ = /28
	RCC_DCKCFGR1_PLLI2SDIVQ_Div28 = 0x1b
	// PLLI2SDIVQ = /29
	RCC_DCKCFGR1_PLLI2SDIVQ_Div29 = 0x1c
	// PLLI2SDIVQ = /30
	RCC_DCKCFGR1_PLLI2SDIVQ_Div30 = 0x1d
	// PLLI2SDIVQ = /31
	RCC_DCKCFGR1_PLLI2SDIVQ_Div31 = 0x1e
	// PLLI2SDIVQ = /32
	RCC_DCKCFGR1_PLLI2SDIVQ_Div32 = 0x1f
	// Position of PLLSAIDIVQ field.
	RCC_DCKCFGR1_PLLSAIDIVQ_Pos = 0x8
	// Bit mask of PLLSAIDIVQ field.
	RCC_DCKCFGR1_PLLSAIDIVQ_Msk = 0x1f00
	// PLLSAIDIVQ = /1
	RCC_DCKCFGR1_PLLSAIDIVQ_Div1 = 0x0
	// PLLSAIDIVQ = /2
	RCC_DCKCFGR1_PLLSAIDIVQ_Div2 = 0x1
	// PLLSAIDIVQ = /3
	RCC_DCKCFGR1_PLLSAIDIVQ_Div3 = 0x2
	// PLLSAIDIVQ = /4
	RCC_DCKCFGR1_PLLSAIDIVQ_Div4 = 0x3
	// PLLSAIDIVQ = /5
	RCC_DCKCFGR1_PLLSAIDIVQ_Div5 = 0x4
	// PLLSAIDIVQ = /6
	RCC_DCKCFGR1_PLLSAIDIVQ_Div6 = 0x5
	// PLLSAIDIVQ = /7
	RCC_DCKCFGR1_PLLSAIDIVQ_Div7 = 0x6
	// PLLSAIDIVQ = /8
	RCC_DCKCFGR1_PLLSAIDIVQ_Div8 = 0x7
	// PLLSAIDIVQ = /9
	RCC_DCKCFGR1_PLLSAIDIVQ_Div9 = 0x8
	// PLLSAIDIVQ = /10
	RCC_DCKCFGR1_PLLSAIDIVQ_Div10 = 0x9
	// PLLSAIDIVQ = /11
	RCC_DCKCFGR1_PLLSAIDIVQ_Div11 = 0xa
	// PLLSAIDIVQ = /12
	RCC_DCKCFGR1_PLLSAIDIVQ_Div12 = 0xb
	// PLLSAIDIVQ = /13
	RCC_DCKCFGR1_PLLSAIDIVQ_Div13 = 0xc
	// PLLSAIDIVQ = /14
	RCC_DCKCFGR1_PLLSAIDIVQ_Div14 = 0xd
	// PLLSAIDIVQ = /15
	RCC_DCKCFGR1_PLLSAIDIVQ_Div15 = 0xe
	// PLLSAIDIVQ = /16
	RCC_DCKCFGR1_PLLSAIDIVQ_Div16 = 0xf
	// PLLSAIDIVQ = /17
	RCC_DCKCFGR1_PLLSAIDIVQ_Div17 = 0x10
	// PLLSAIDIVQ = /18
	RCC_DCKCFGR1_PLLSAIDIVQ_Div18 = 0x11
	// PLLSAIDIVQ = /19
	RCC_DCKCFGR1_PLLSAIDIVQ_Div19 = 0x12
	// PLLSAIDIVQ = /20
	RCC_DCKCFGR1_PLLSAIDIVQ_Div20 = 0x13
	// PLLSAIDIVQ = /21
	RCC_DCKCFGR1_PLLSAIDIVQ_Div21 = 0x14
	// PLLSAIDIVQ = /22
	RCC_DCKCFGR1_PLLSAIDIVQ_Div22 = 0x15
	// PLLSAIDIVQ = /23
	RCC_DCKCFGR1_PLLSAIDIVQ_Div23 = 0x16
	// PLLSAIDIVQ = /24
	RCC_DCKCFGR1_PLLSAIDIVQ_Div24 = 0x17
	// PLLSAIDIVQ = /25
	RCC_DCKCFGR1_PLLSAIDIVQ_Div25 = 0x18
	// PLLSAIDIVQ = /26
	RCC_DCKCFGR1_PLLSAIDIVQ_Div26 = 0x19
	// PLLSAIDIVQ = /27
	RCC_DCKCFGR1_PLLSAIDIVQ_Div27 = 0x1a
	// PLLSAIDIVQ = /28
	RCC_DCKCFGR1_PLLSAIDIVQ_Div28 = 0x1b
	// PLLSAIDIVQ = /29
	RCC_DCKCFGR1_PLLSAIDIVQ_Div29 = 0x1c
	// PLLSAIDIVQ = /30
	RCC_DCKCFGR1_PLLSAIDIVQ_Div30 = 0x1d
	// PLLSAIDIVQ = /31
	RCC_DCKCFGR1_PLLSAIDIVQ_Div31 = 0x1e
	// PLLSAIDIVQ = /32
	RCC_DCKCFGR1_PLLSAIDIVQ_Div32 = 0x1f
	// Position of PLLSAIDIVR field.
	RCC_DCKCFGR1_PLLSAIDIVR_Pos = 0x10
	// Bit mask of PLLSAIDIVR field.
	RCC_DCKCFGR1_PLLSAIDIVR_Msk = 0x30000
	// PLLSAIDIVR = /2
	RCC_DCKCFGR1_PLLSAIDIVR_Div2 = 0x0
	// PLLSAIDIVR = /4
	RCC_DCKCFGR1_PLLSAIDIVR_Div4 = 0x1
	// PLLSAIDIVR = /8
	RCC_DCKCFGR1_PLLSAIDIVR_Div8 = 0x2
	// PLLSAIDIVR = /16
	RCC_DCKCFGR1_PLLSAIDIVR_Div16 = 0x3
	// Position of SAI1SEL field.
	RCC_DCKCFGR1_SAI1SEL_Pos = 0x14
	// Bit mask of SAI1SEL field.
	RCC_DCKCFGR1_SAI1SEL_Msk = 0x300000
	// SAI1 clock frequency = f(PLLSAI_Q) / PLLSAIDIVQ
	RCC_DCKCFGR1_SAI1SEL_PLLSAI = 0x0
	// SAI1 clock frequency = f(PLLI2S_Q) / PLLI2SDIVQ
	RCC_DCKCFGR1_SAI1SEL_PLLI2S = 0x1
	// SAI1 clock frequency = Alternate function input frequency
	RCC_DCKCFGR1_SAI1SEL_AFIF = 0x2
	// SAI1 clock frequency = HSI or HSE
	RCC_DCKCFGR1_SAI1SEL_HSI_HSE = 0x3
	// Position of SAI2SEL field.
	RCC_DCKCFGR1_SAI2SEL_Pos = 0x16
	// Bit mask of SAI2SEL field.
	RCC_DCKCFGR1_SAI2SEL_Msk = 0xc00000
	// SAI2 clock frequency = f(PLLSAI_Q) / PLLSAIDIVQ
	RCC_DCKCFGR1_SAI2SEL_PLLSAI = 0x0
	// SAI2 clock frequency = f(PLLI2S_Q) / PLLI2SDIVQ
	RCC_DCKCFGR1_SAI2SEL_PLLI2S = 0x1
	// SAI2 clock frequency = Alternate function input frequency
	RCC_DCKCFGR1_SAI2SEL_AFIF = 0x2
	// SAI2 clock frequency = HSI or HSE
	RCC_DCKCFGR1_SAI2SEL_HSI_HSE = 0x3
	// Position of TIMPRE field.
	RCC_DCKCFGR1_TIMPRE_Pos = 0x18
	// Bit mask of TIMPRE field.
	RCC_DCKCFGR1_TIMPRE_Msk = 0x1000000
	// Bit TIMPRE.
	RCC_DCKCFGR1_TIMPRE = 0x1000000
	// If the APB prescaler is configured 1, TIMxCLK = PCLKx. Otherwise, TIMxCLK = 2xPCLKx
	RCC_DCKCFGR1_TIMPRE_Mul2 = 0x0
	// If the APB prescaler is configured 1, 2 or 4, TIMxCLK = HCLK. Otherwise, TIMxCLK = 4xPCLKx
	RCC_DCKCFGR1_TIMPRE_Mul4 = 0x1
	// Position of DFSDM1SEL field.
	RCC_DCKCFGR1_DFSDM1SEL_Pos = 0x19
	// Bit mask of DFSDM1SEL field.
	RCC_DCKCFGR1_DFSDM1SEL_Msk = 0x2000000
	// Bit DFSDM1SEL.
	RCC_DCKCFGR1_DFSDM1SEL = 0x2000000
	// APB2 clock (PCLK2) selected as DFSDM1 Kernel clock source
	RCC_DCKCFGR1_DFSDM1SEL_APB2 = 0x0
	// System clock (SYSCLK) clock selected as DFSDM1 Kernel clock source
	RCC_DCKCFGR1_DFSDM1SEL_SYSCLK = 0x1
	// Position of ADFSDM1SEL field.
	RCC_DCKCFGR1_ADFSDM1SEL_Pos = 0x1a
	// Bit mask of ADFSDM1SEL field.
	RCC_DCKCFGR1_ADFSDM1SEL_Msk = 0x4000000
	// Bit ADFSDM1SEL.
	RCC_DCKCFGR1_ADFSDM1SEL = 0x4000000
	// SAI1 clock selected as DFSDM1 Audio clock source
	RCC_DCKCFGR1_ADFSDM1SEL_SAI1 = 0x0
	// SAI2 clock selected as DFSDM1 Audio clock source
	RCC_DCKCFGR1_ADFSDM1SEL_SAI2 = 0x1

	// DCKCFGR2: dedicated clocks configuration register
	// Position of USART1SEL field.
	RCC_DCKCFGR2_USART1SEL_Pos = 0x0
	// Bit mask of USART1SEL field.
	RCC_DCKCFGR2_USART1SEL_Msk = 0x3
	// APB2 clock (PCLK2) is selected as USART clock
	RCC_DCKCFGR2_USART1SEL_APB2 = 0x0
	// System clock is selected as USART clock
	RCC_DCKCFGR2_USART1SEL_SYSCLK = 0x1
	// HSI clock is selected as USART clock
	RCC_DCKCFGR2_USART1SEL_HSI = 0x2
	// LSE clock is selected as USART clock
	RCC_DCKCFGR2_USART1SEL_LSE = 0x3
	// Position of USART2SEL field.
	RCC_DCKCFGR2_USART2SEL_Pos = 0x2
	// Bit mask of USART2SEL field.
	RCC_DCKCFGR2_USART2SEL_Msk = 0xc
	// APB1 clock (PCLK1) is selected as USART clock
	RCC_DCKCFGR2_USART2SEL_APB1 = 0x0
	// System clock is selected as USART clock
	RCC_DCKCFGR2_USART2SEL_SYSCLK = 0x1
	// HSI clock is selected as USART clock
	RCC_DCKCFGR2_USART2SEL_HSI = 0x2
	// LSE clock is selected as USART clock
	RCC_DCKCFGR2_USART2SEL_LSE = 0x3
	// Position of USART3SEL field.
	RCC_DCKCFGR2_USART3SEL_Pos = 0x4
	// Bit mask of USART3SEL field.
	RCC_DCKCFGR2_USART3SEL_Msk = 0x30
	// APB1 clock (PCLK1) is selected as USART clock
	RCC_DCKCFGR2_USART3SEL_APB1 = 0x0
	// System clock is selected as USART clock
	RCC_DCKCFGR2_USART3SEL_SYSCLK = 0x1
	// HSI clock is selected as USART clock
	RCC_DCKCFGR2_USART3SEL_HSI = 0x2
	// LSE clock is selected as USART clock
	RCC_DCKCFGR2_USART3SEL_LSE = 0x3
	// Position of UART4SEL field.
	RCC_DCKCFGR2_UART4SEL_Pos = 0x6
	// Bit mask of UART4SEL field.
	RCC_DCKCFGR2_UART4SEL_Msk = 0xc0
	// APB1 clock (PCLK1) is selected as USART clock
	RCC_DCKCFGR2_UART4SEL_APB1 = 0x0
	// System clock is selected as USART clock
	RCC_DCKCFGR2_UART4SEL_SYSCLK = 0x1
	// HSI clock is selected as USART clock
	RCC_DCKCFGR2_UART4SEL_HSI = 0x2
	// LSE clock is selected as USART clock
	RCC_DCKCFGR2_UART4SEL_LSE = 0x3
	// Position of UART5SEL field.
	RCC_DCKCFGR2_UART5SEL_Pos = 0x8
	// Bit mask of UART5SEL field.
	RCC_DCKCFGR2_UART5SEL_Msk = 0x300
	// APB1 clock (PCLK1) is selected as USART clock
	RCC_DCKCFGR2_UART5SEL_APB1 = 0x0
	// System clock is selected as USART clock
	RCC_DCKCFGR2_UART5SEL_SYSCLK = 0x1
	// HSI clock is selected as USART clock
	RCC_DCKCFGR2_UART5SEL_HSI = 0x2
	// LSE clock is selected as USART clock
	RCC_DCKCFGR2_UART5SEL_LSE = 0x3
	// Position of USART6SEL field.
	RCC_DCKCFGR2_USART6SEL_Pos = 0xa
	// Bit mask of USART6SEL field.
	RCC_DCKCFGR2_USART6SEL_Msk = 0xc00
	// APB2 clock (PCLK2) is selected as USART clock
	RCC_DCKCFGR2_USART6SEL_APB2 = 0x0
	// System clock is selected as USART clock
	RCC_DCKCFGR2_USART6SEL_SYSCLK = 0x1
	// HSI clock is selected as USART clock
	RCC_DCKCFGR2_USART6SEL_HSI = 0x2
	// LSE clock is selected as USART clock
	RCC_DCKCFGR2_USART6SEL_LSE = 0x3
	// Position of UART7SEL field.
	RCC_DCKCFGR2_UART7SEL_Pos = 0xc
	// Bit mask of UART7SEL field.
	RCC_DCKCFGR2_UART7SEL_Msk = 0x3000
	// APB1 clock (PCLK1) is selected as USART clock
	RCC_DCKCFGR2_UART7SEL_APB1 = 0x0
	// System clock is selected as USART clock
	RCC_DCKCFGR2_UART7SEL_SYSCLK = 0x1
	// HSI clock is selected as USART clock
	RCC_DCKCFGR2_UART7SEL_HSI = 0x2
	// LSE clock is selected as USART clock
	RCC_DCKCFGR2_UART7SEL_LSE = 0x3
	// Position of UART8SEL field.
	RCC_DCKCFGR2_UART8SEL_Pos = 0xe
	// Bit mask of UART8SEL field.
	RCC_DCKCFGR2_UART8SEL_Msk = 0xc000
	// APB1 clock (PCLK1) is selected as USART clock
	RCC_DCKCFGR2_UART8SEL_APB1 = 0x0
	// System clock is selected as USART clock
	RCC_DCKCFGR2_UART8SEL_SYSCLK = 0x1
	// HSI clock is selected as USART clock
	RCC_DCKCFGR2_UART8SEL_HSI = 0x2
	// LSE clock is selected as USART clock
	RCC_DCKCFGR2_UART8SEL_LSE = 0x3
	// Position of I2C1SEL field.
	RCC_DCKCFGR2_I2C1SEL_Pos = 0x10
	// Bit mask of I2C1SEL field.
	RCC_DCKCFGR2_I2C1SEL_Msk = 0x30000
	// APB clock selected as I2C clock
	RCC_DCKCFGR2_I2C1SEL_APB = 0x0
	// System clock selected as I2C clock
	RCC_DCKCFGR2_I2C1SEL_SYSCLK = 0x1
	// HSI clock selected as I2C clock
	RCC_DCKCFGR2_I2C1SEL_HSI = 0x2
	// Position of I2C2SEL field.
	RCC_DCKCFGR2_I2C2SEL_Pos = 0x12
	// Bit mask of I2C2SEL field.
	RCC_DCKCFGR2_I2C2SEL_Msk = 0xc0000
	// APB clock selected as I2C clock
	RCC_DCKCFGR2_I2C2SEL_APB = 0x0
	// System clock selected as I2C clock
	RCC_DCKCFGR2_I2C2SEL_SYSCLK = 0x1
	// HSI clock selected as I2C clock
	RCC_DCKCFGR2_I2C2SEL_HSI = 0x2
	// Position of I2C3SEL field.
	RCC_DCKCFGR2_I2C3SEL_Pos = 0x14
	// Bit mask of I2C3SEL field.
	RCC_DCKCFGR2_I2C3SEL_Msk = 0x300000
	// APB clock selected as I2C clock
	RCC_DCKCFGR2_I2C3SEL_APB = 0x0
	// System clock selected as I2C clock
	RCC_DCKCFGR2_I2C3SEL_SYSCLK = 0x1
	// HSI clock selected as I2C clock
	RCC_DCKCFGR2_I2C3SEL_HSI = 0x2
	// Position of I2C4SEL field.
	RCC_DCKCFGR2_I2C4SEL_Pos = 0x16
	// Bit mask of I2C4SEL field.
	RCC_DCKCFGR2_I2C4SEL_Msk = 0xc00000
	// APB clock selected as I2C clock
	RCC_DCKCFGR2_I2C4SEL_APB = 0x0
	// System clock selected as I2C clock
	RCC_DCKCFGR2_I2C4SEL_SYSCLK = 0x1
	// HSI clock selected as I2C clock
	RCC_DCKCFGR2_I2C4SEL_HSI = 0x2
	// Position of LPTIM1SEL field.
	RCC_DCKCFGR2_LPTIM1SEL_Pos = 0x18
	// Bit mask of LPTIM1SEL field.
	RCC_DCKCFGR2_LPTIM1SEL_Msk = 0x3000000
	// APB1 clock (PCLK1) selected as LPTILM1 clock
	RCC_DCKCFGR2_LPTIM1SEL_APB1 = 0x0
	// LSI clock is selected as LPTILM1 clock
	RCC_DCKCFGR2_LPTIM1SEL_LSI = 0x1
	// HSI clock is selected as LPTILM1 clock
	RCC_DCKCFGR2_LPTIM1SEL_HSI = 0x2
	// LSE clock is selected as LPTILM1 clock
	RCC_DCKCFGR2_LPTIM1SEL_LSE = 0x3
	// Position of CECSEL field.
	RCC_DCKCFGR2_CECSEL_Pos = 0x1a
	// Bit mask of CECSEL field.
	RCC_DCKCFGR2_CECSEL_Msk = 0x4000000
	// Bit CECSEL.
	RCC_DCKCFGR2_CECSEL = 0x4000000
	// LSE clock is selected as HDMI-CEC clock
	RCC_DCKCFGR2_CECSEL_LSE = 0x0
	// HSI divided by 488 clock is selected as HDMI-CEC clock
	RCC_DCKCFGR2_CECSEL_HSI_Div488 = 0x1
	// Position of CK48MSEL field.
	RCC_DCKCFGR2_CK48MSEL_Pos = 0x1b
	// Bit mask of CK48MSEL field.
	RCC_DCKCFGR2_CK48MSEL_Msk = 0x8000000
	// Bit CK48MSEL.
	RCC_DCKCFGR2_CK48MSEL = 0x8000000
	// 48MHz clock from PLL is selected
	RCC_DCKCFGR2_CK48MSEL_PLL = 0x0
	// 48MHz clock from PLLSAI is selected
	RCC_DCKCFGR2_CK48MSEL_PLLSAI = 0x1
	// Position of SDMMC1SEL field.
	RCC_DCKCFGR2_SDMMC1SEL_Pos = 0x1c
	// Bit mask of SDMMC1SEL field.
	RCC_DCKCFGR2_SDMMC1SEL_Msk = 0x10000000
	// Bit SDMMC1SEL.
	RCC_DCKCFGR2_SDMMC1SEL = 0x10000000
	// 48 MHz clock is selected as SD clock
	RCC_DCKCFGR2_SDMMC1SEL_CK48M = 0x0
	// System clock is selected as SD clock
	RCC_DCKCFGR2_SDMMC1SEL_SYSCLK = 0x1
	// Position of SDMMC2SEL field.
	RCC_DCKCFGR2_SDMMC2SEL_Pos = 0x1d
	// Bit mask of SDMMC2SEL field.
	RCC_DCKCFGR2_SDMMC2SEL_Msk = 0x20000000
	// Bit SDMMC2SEL.
	RCC_DCKCFGR2_SDMMC2SEL = 0x20000000
	// 48 MHz clock is selected as SD clock
	RCC_DCKCFGR2_SDMMC2SEL_CK48M = 0x0
	// System clock is selected as SD clock
	RCC_DCKCFGR2_SDMMC2SEL_SYSCLK = 0x1
	// Position of DSISEL field.
	RCC_DCKCFGR2_DSISEL_Pos = 0x1e
	// Bit mask of DSISEL field.
	RCC_DCKCFGR2_DSISEL_Msk = 0x40000000
	// Bit DSISEL.
	RCC_DCKCFGR2_DSISEL = 0x40000000
	// DSI-PHY used as DSI byte lane clock source (usual case)
	RCC_DCKCFGR2_DSISEL_DSI_PHY = 0x0
	// PLLR used as DSI byte lane clock source, used in case DSI PLL and DSI-PHY are off (low power mode)
	RCC_DCKCFGR2_DSISEL_PLLR = 0x1
)

// Bitfields for GPIOD: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR15_VeryHighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR14_VeryHighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR13_VeryHighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR12_VeryHighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR11_VeryHighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR10_VeryHighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR9_VeryHighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR8_VeryHighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR7_VeryHighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR6_VeryHighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR5_VeryHighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR4_VeryHighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR3_VeryHighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR2_VeryHighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR1_VeryHighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR0_VeryHighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function lowregister
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf

	// BRR: GPIO port bit reset register
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRM: memory remap register
	// Position of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Msk = 0x7
	// Position of FB_MODE field.
	SYSCFG_MEMRM_FB_MODE_Pos = 0x8
	// Bit mask of FB_MODE field.
	SYSCFG_MEMRM_FB_MODE_Msk = 0x100
	// Bit FB_MODE.
	SYSCFG_MEMRM_FB_MODE = 0x100
	// Position of SWP_FMC field.
	SYSCFG_MEMRM_SWP_FMC_Pos = 0xa
	// Bit mask of SWP_FMC field.
	SYSCFG_MEMRM_SWP_FMC_Msk = 0xc00

	// PMC: peripheral mode configuration register
	// Position of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL_Pos = 0x17
	// Bit mask of MII_RMII_SEL field.
	SYSCFG_PMC_MII_RMII_SEL_Msk = 0x800000
	// Bit MII_RMII_SEL.
	SYSCFG_PMC_MII_RMII_SEL = 0x800000
	// Position of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Pos = 0x10
	// Bit mask of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Msk = 0x10000
	// Bit ADC1DC2.
	SYSCFG_PMC_ADC1DC2 = 0x10000
	// Position of ADC2DC2 field.
	SYSCFG_PMC_ADC2DC2_Pos = 0x11
	// Bit mask of ADC2DC2 field.
	SYSCFG_PMC_ADC2DC2_Msk = 0x20000
	// Bit ADC2DC2.
	SYSCFG_PMC_ADC2DC2 = 0x20000
	// Position of ADC3DC2 field.
	SYSCFG_PMC_ADC3DC2_Pos = 0x12
	// Bit mask of ADC3DC2 field.
	SYSCFG_PMC_ADC3DC2_Msk = 0x40000
	// Bit ADC3DC2.
	SYSCFG_PMC_ADC3DC2 = 0x40000

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0xf0
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0xf

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf

	// CMPCR: Compensation cell control register
	// Position of READY field.
	SYSCFG_CMPCR_READY_Pos = 0x8
	// Bit mask of READY field.
	SYSCFG_CMPCR_READY_Msk = 0x100
	// Bit READY.
	SYSCFG_CMPCR_READY = 0x100
	// Position of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Pos = 0x0
	// Bit mask of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Msk = 0x1
	// Bit CMP_PD.
	SYSCFG_CMPCR_CMP_PD = 0x1
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of CRCL field.
	SPI_CR1_CRCL_Pos = 0xb
	// Bit mask of CRCL field.
	SPI_CR1_CRCL_Msk = 0x800
	// Bit CRCL.
	SPI_CR1_CRCL = 0x800
	// 8-bit CRC length
	SPI_CR1_CRCL_EightBit = 0x0
	// 16-bit CRC length
	SPI_CR1_CRCL_SixteenBit = 0x1
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of NSSP field.
	SPI_CR2_NSSP_Pos = 0x3
	// Bit mask of NSSP field.
	SPI_CR2_NSSP_Msk = 0x8
	// Bit NSSP.
	SPI_CR2_NSSP = 0x8
	// No NSS pulse
	SPI_CR2_NSSP_NoPulse = 0x0
	// NSS pulse generated
	SPI_CR2_NSSP_PulseGenerated = 0x1
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// SPI Motorola mode
	SPI_CR2_FRF_Motorola = 0x0
	// SPI TI mode
	SPI_CR2_FRF_TI = 0x1
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1
	// Position of DS field.
	SPI_CR2_DS_Pos = 0x8
	// Bit mask of DS field.
	SPI_CR2_DS_Msk = 0xf00
	// 4-bit
	SPI_CR2_DS_FourBit = 0x3
	// 5-bit
	SPI_CR2_DS_FiveBit = 0x4
	// 6-bit
	SPI_CR2_DS_SixBit = 0x5
	// 7-bit
	SPI_CR2_DS_SevenBit = 0x6
	// 8-bit
	SPI_CR2_DS_EightBit = 0x7
	// 9-bit
	SPI_CR2_DS_NineBit = 0x8
	// 10-bit
	SPI_CR2_DS_TenBit = 0x9
	// 11-bit
	SPI_CR2_DS_ElevenBit = 0xa
	// 12-bit
	SPI_CR2_DS_TwelveBit = 0xb
	// 13-bit
	SPI_CR2_DS_ThirteenBit = 0xc
	// 14-bit
	SPI_CR2_DS_FourteenBit = 0xd
	// 15-bit
	SPI_CR2_DS_FifteenBit = 0xe
	// 16-bit
	SPI_CR2_DS_SixteenBit = 0xf
	// Position of FRXTH field.
	SPI_CR2_FRXTH_Pos = 0xc
	// Bit mask of FRXTH field.
	SPI_CR2_FRXTH_Msk = 0x1000
	// Bit FRXTH.
	SPI_CR2_FRXTH = 0x1000
	// RXNE event is generated if the FIFO level is greater than or equal to 1/2 (16-bit)
	SPI_CR2_FRXTH_Half = 0x0
	// RXNE event is generated if the FIFO level is greater than or equal to 1/4 (8-bit)
	SPI_CR2_FRXTH_Quarter = 0x1
	// Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Pos = 0xd
	// Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000
	// Bit LDMA_RX.
	SPI_CR2_LDMA_RX = 0x2000
	// Number of data to transfer for receive is even
	SPI_CR2_LDMA_RX_Even = 0x0
	// Number of data to transfer for receive is odd
	SPI_CR2_LDMA_RX_Odd = 0x1
	// Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Pos = 0xe
	// Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000
	// Bit LDMA_TX.
	SPI_CR2_LDMA_TX = 0x4000
	// Number of data to transfer for transmit is even
	SPI_CR2_LDMA_TX_Even = 0x0
	// Number of data to transfer for transmit is odd
	SPI_CR2_LDMA_TX_Odd = 0x1

	// SR: status register
	// Position of FRE field.
	SPI_SR_FRE_Pos = 0x8
	// Bit mask of FRE field.
	SPI_SR_FRE_Msk = 0x100
	// Bit FRE.
	SPI_SR_FRE = 0x100
	// No frame format error
	SPI_SR_FRE_NoError = 0x0
	// A frame format error occurred
	SPI_SR_FRE_Error = 0x1
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// No underrun occurred
	SPI_SR_UDR_NoUnderrun = 0x0
	// Underrun occurred
	SPI_SR_UDR_Underrun = 0x1
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Channel left has to be transmitted or has been received
	SPI_SR_CHSIDE_Left = 0x0
	// Channel right has to be transmitted or has been received
	SPI_SR_CHSIDE_Right = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1
	// Position of FRLVL field.
	SPI_SR_FRLVL_Pos = 0x9
	// Bit mask of FRLVL field.
	SPI_SR_FRLVL_Msk = 0x600
	// Rx FIFO Empty
	SPI_SR_FRLVL_Empty = 0x0
	// Rx 1/4 FIFO
	SPI_SR_FRLVL_Quarter = 0x1
	// Rx 1/2 FIFO
	SPI_SR_FRLVL_Half = 0x2
	// Rx FIFO full
	SPI_SR_FRLVL_Full = 0x3
	// Position of FTLVL field.
	SPI_SR_FTLVL_Pos = 0xb
	// Bit mask of FTLVL field.
	SPI_SR_FTLVL_Msk = 0x1800
	// Tx FIFO Empty
	SPI_SR_FTLVL_Empty = 0x0
	// Tx 1/4 FIFO
	SPI_SR_FTLVL_Quarter = 0x1
	// Tx 1/2 FIFO
	SPI_SR_FTLVL_Half = 0x2
	// Tx FIFO full
	SPI_SR_FTLVL_Full = 0x3

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: I2S configuration register
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// SPI mode is selected
	SPI_I2SCFGR_I2SMOD_SPIMode = 0x0
	// I2S mode is selected
	SPI_I2SCFGR_I2SMOD_I2SMode = 0x1
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// I2S peripheral is disabled
	SPI_I2SCFGR_I2SE_Disabled = 0x0
	// I2S peripheral is enabled
	SPI_I2SCFGR_I2SE_Enabled = 0x1
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Slave - transmit
	SPI_I2SCFGR_I2SCFG_SlaveTx = 0x0
	// Slave - receive
	SPI_I2SCFGR_I2SCFG_SlaveRx = 0x1
	// Master - transmit
	SPI_I2SCFGR_I2SCFG_MasterTx = 0x2
	// Master - receive
	SPI_I2SCFGR_I2SCFG_MasterRx = 0x3
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Short frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Short = 0x0
	// Long frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Long = 0x1
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// I2S Philips standard
	SPI_I2SCFGR_I2SSTD_Philips = 0x0
	// MSB justified standard
	SPI_I2SCFGR_I2SSTD_MSB = 0x1
	// LSB justified standard
	SPI_I2SCFGR_I2SSTD_LSB = 0x2
	// PCM standard
	SPI_I2SCFGR_I2SSTD_PCM = 0x3
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// I2S clock inactive state is low level
	SPI_I2SCFGR_CKPOL_IdleLow = 0x0
	// I2S clock inactive state is high level
	SPI_I2SCFGR_CKPOL_IdleHigh = 0x1
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// 16-bit data length
	SPI_I2SCFGR_DATLEN_SixteenBit = 0x0
	// 24-bit data length
	SPI_I2SCFGR_DATLEN_TwentyFourBit = 0x1
	// 32-bit data length
	SPI_I2SCFGR_DATLEN_ThirtyTwoBit = 0x2
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1
	// 16-bit wide
	SPI_I2SCFGR_CHLEN_SixteenBit = 0x0
	// 32-bit wide
	SPI_I2SCFGR_CHLEN_ThirtyTwoBit = 0x1
	// Position of ASTRTEN field.
	SPI_I2SCFGR_ASTRTEN_Pos = 0xc
	// Bit mask of ASTRTEN field.
	SPI_I2SCFGR_ASTRTEN_Msk = 0x1000
	// Bit ASTRTEN.
	SPI_I2SCFGR_ASTRTEN = 0x1000

	// I2SPR: I2S prescaler register
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
	// Master clock output is disabled
	SPI_I2SPR_MCKOE_Disabled = 0x0
	// Master clock output is enabled
	SPI_I2SPR_MCKOE_Enabled = 0x1
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Real divider value is I2SDIV * 2
	SPI_I2SPR_ODD_Even = 0x0
	// Real divider value is (I2SDIV * 2) + 1
	SPI_I2SPR_ODD_Odd = 0x1
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
)

// Bitfields for ADC1: Analog-to-digital converter
const (
	// SR: status register
	// Position of OVR field.
	ADC_SR_OVR_Pos = 0x5
	// Bit mask of OVR field.
	ADC_SR_OVR_Msk = 0x20
	// Bit OVR.
	ADC_SR_OVR = 0x20
	// No overrun occurred
	ADC_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	ADC_SR_OVR_Overrun = 0x1
	// Position of STRT field.
	ADC_SR_STRT_Pos = 0x4
	// Bit mask of STRT field.
	ADC_SR_STRT_Msk = 0x10
	// Bit STRT.
	ADC_SR_STRT = 0x10
	// No regular channel conversion started
	ADC_SR_STRT_NotStarted = 0x0
	// Regular channel conversion has started
	ADC_SR_STRT_Started = 0x1
	// Position of JSTRT field.
	ADC_SR_JSTRT_Pos = 0x3
	// Bit mask of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8
	// Bit JSTRT.
	ADC_SR_JSTRT = 0x8
	// No injected channel conversion started
	ADC_SR_JSTRT_NotStarted = 0x0
	// Injected channel conversion has started
	ADC_SR_JSTRT_Started = 0x1
	// Position of JEOC field.
	ADC_SR_JEOC_Pos = 0x2
	// Bit mask of JEOC field.
	ADC_SR_JEOC_Msk = 0x4
	// Bit JEOC.
	ADC_SR_JEOC = 0x4
	// Conversion is not complete
	ADC_SR_JEOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_JEOC_Complete = 0x1
	// Position of EOC field.
	ADC_SR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	ADC_SR_EOC_Msk = 0x2
	// Bit EOC.
	ADC_SR_EOC = 0x2
	// Conversion is not complete
	ADC_SR_EOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_EOC_Complete = 0x1
	// Position of AWD field.
	ADC_SR_AWD_Pos = 0x0
	// Bit mask of AWD field.
	ADC_SR_AWD_Msk = 0x1
	// Bit AWD.
	ADC_SR_AWD = 0x1
	// No analog watchdog event occurred
	ADC_SR_AWD_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_SR_AWD_Event = 0x1

	// CR1: control register 1
	// Position of OVRIE field.
	ADC_CR1_OVRIE_Pos = 0x1a
	// Bit mask of OVRIE field.
	ADC_CR1_OVRIE_Msk = 0x4000000
	// Bit OVRIE.
	ADC_CR1_OVRIE = 0x4000000
	// Overrun interrupt disabled
	ADC_CR1_OVRIE_Disabled = 0x0
	// Overrun interrupt enabled
	ADC_CR1_OVRIE_Enabled = 0x1
	// Position of RES field.
	ADC_CR1_RES_Pos = 0x18
	// Bit mask of RES field.
	ADC_CR1_RES_Msk = 0x3000000
	// 12-bit (15 ADCCLK cycles)
	ADC_CR1_RES_TwelveBit = 0x0
	// 10-bit (13 ADCCLK cycles)
	ADC_CR1_RES_TenBit = 0x1
	// 8-bit (11 ADCCLK cycles)
	ADC_CR1_RES_EightBit = 0x2
	// 6-bit (9 ADCCLK cycles)
	ADC_CR1_RES_SixBit = 0x3
	// Position of AWDEN field.
	ADC_CR1_AWDEN_Pos = 0x17
	// Bit mask of AWDEN field.
	ADC_CR1_AWDEN_Msk = 0x800000
	// Bit AWDEN.
	ADC_CR1_AWDEN = 0x800000
	// Analog watchdog disabled on regular channels
	ADC_CR1_AWDEN_Disabled = 0x0
	// Analog watchdog enabled on regular channels
	ADC_CR1_AWDEN_Enabled = 0x1
	// Position of JAWDEN field.
	ADC_CR1_JAWDEN_Pos = 0x16
	// Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN_Msk = 0x400000
	// Bit JAWDEN.
	ADC_CR1_JAWDEN = 0x400000
	// Analog watchdog disabled on injected channels
	ADC_CR1_JAWDEN_Disabled = 0x0
	// Analog watchdog enabled on injected channels
	ADC_CR1_JAWDEN_Enabled = 0x1
	// Position of DISCNUM field.
	ADC_CR1_DISCNUM_Pos = 0xd
	// Bit mask of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000
	// Position of JDISCEN field.
	ADC_CR1_JDISCEN_Pos = 0xc
	// Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000
	// Bit JDISCEN.
	ADC_CR1_JDISCEN = 0x1000
	// Discontinuous mode on injected channels disabled
	ADC_CR1_JDISCEN_Disabled = 0x0
	// Discontinuous mode on injected channels enabled
	ADC_CR1_JDISCEN_Enabled = 0x1
	// Position of DISCEN field.
	ADC_CR1_DISCEN_Pos = 0xb
	// Bit mask of DISCEN field.
	ADC_CR1_DISCEN_Msk = 0x800
	// Bit DISCEN.
	ADC_CR1_DISCEN = 0x800
	// Discontinuous mode on regular channels disabled
	ADC_CR1_DISCEN_Disabled = 0x0
	// Discontinuous mode on regular channels enabled
	ADC_CR1_DISCEN_Enabled = 0x1
	// Position of JAUTO field.
	ADC_CR1_JAUTO_Pos = 0xa
	// Bit mask of JAUTO field.
	ADC_CR1_JAUTO_Msk = 0x400
	// Bit JAUTO.
	ADC_CR1_JAUTO = 0x400
	// Automatic injected group conversion disabled
	ADC_CR1_JAUTO_Disabled = 0x0
	// Automatic injected group conversion enabled
	ADC_CR1_JAUTO_Enabled = 0x1
	// Position of AWDSGL field.
	ADC_CR1_AWDSGL_Pos = 0x9
	// Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL_Msk = 0x200
	// Bit AWDSGL.
	ADC_CR1_AWDSGL = 0x200
	// Analog watchdog enabled on all channels
	ADC_CR1_AWDSGL_AllChannels = 0x0
	// Analog watchdog enabled on a single channel
	ADC_CR1_AWDSGL_SingleChannel = 0x1
	// Position of SCAN field.
	ADC_CR1_SCAN_Pos = 0x8
	// Bit mask of SCAN field.
	ADC_CR1_SCAN_Msk = 0x100
	// Bit SCAN.
	ADC_CR1_SCAN = 0x100
	// Scan mode disabled
	ADC_CR1_SCAN_Disabled = 0x0
	// Scan mode enabled
	ADC_CR1_SCAN_Enabled = 0x1
	// Position of JEOCIE field.
	ADC_CR1_JEOCIE_Pos = 0x7
	// Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE_Msk = 0x80
	// Bit JEOCIE.
	ADC_CR1_JEOCIE = 0x80
	// JEOC interrupt disabled
	ADC_CR1_JEOCIE_Disabled = 0x0
	// JEOC interrupt enabled
	ADC_CR1_JEOCIE_Enabled = 0x1
	// Position of AWDIE field.
	ADC_CR1_AWDIE_Pos = 0x6
	// Bit mask of AWDIE field.
	ADC_CR1_AWDIE_Msk = 0x40
	// Bit AWDIE.
	ADC_CR1_AWDIE = 0x40
	// Analogue watchdog interrupt disabled
	ADC_CR1_AWDIE_Disabled = 0x0
	// Analogue watchdog interrupt enabled
	ADC_CR1_AWDIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_CR1_EOCIE_Pos = 0x5
	// Bit mask of EOCIE field.
	ADC_CR1_EOCIE_Msk = 0x20
	// Bit EOCIE.
	ADC_CR1_EOCIE = 0x20
	// EOC interrupt disabled
	ADC_CR1_EOCIE_Disabled = 0x0
	// EOC interrupt enabled
	ADC_CR1_EOCIE_Enabled = 0x1
	// Position of AWDCH field.
	ADC_CR1_AWDCH_Pos = 0x0
	// Bit mask of AWDCH field.
	ADC_CR1_AWDCH_Msk = 0x1f

	// CR2: control register 2
	// Position of SWSTART field.
	ADC_CR2_SWSTART_Pos = 0x1e
	// Bit mask of SWSTART field.
	ADC_CR2_SWSTART_Msk = 0x40000000
	// Bit SWSTART.
	ADC_CR2_SWSTART = 0x40000000
	// Starts conversion of regular channels
	ADC_CR2_SWSTART_Start = 0x1
	// Position of EXTEN field.
	ADC_CR2_EXTEN_Pos = 0x1c
	// Bit mask of EXTEN field.
	ADC_CR2_EXTEN_Msk = 0x30000000
	// Trigger detection disabled
	ADC_CR2_EXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_EXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_EXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_EXTEN_BothEdges = 0x3
	// Position of EXTSEL field.
	ADC_CR2_EXTSEL_Pos = 0x18
	// Bit mask of EXTSEL field.
	ADC_CR2_EXTSEL_Msk = 0xf000000
	// Timer 1 CC1 event
	ADC_CR2_EXTSEL_TIM1CC1 = 0x0
	// Timer 1 CC2 event
	ADC_CR2_EXTSEL_TIM1CC2 = 0x1
	// Timer 1 CC3 event
	ADC_CR2_EXTSEL_TIM1CC3 = 0x2
	// Timer 2 CC2 event
	ADC_CR2_EXTSEL_TIM2CC2 = 0x3
	// Timer 2 CC3 event
	ADC_CR2_EXTSEL_TIM2CC3 = 0x4
	// Timer 2 CC4 event
	ADC_CR2_EXTSEL_TIM2CC4 = 0x5
	// Timer 2 TRGO event
	ADC_CR2_EXTSEL_TIM2TRGO = 0x6
	// Position of JSWSTART field.
	ADC_CR2_JSWSTART_Pos = 0x16
	// Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000
	// Bit JSWSTART.
	ADC_CR2_JSWSTART = 0x400000
	// Starts conversion of injected channels
	ADC_CR2_JSWSTART_Start = 0x1
	// Position of JEXTEN field.
	ADC_CR2_JEXTEN_Pos = 0x14
	// Bit mask of JEXTEN field.
	ADC_CR2_JEXTEN_Msk = 0x300000
	// Trigger detection disabled
	ADC_CR2_JEXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_JEXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_JEXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_JEXTEN_BothEdges = 0x3
	// Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Pos = 0x10
	// Bit mask of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk = 0xf0000
	// Timer 1 TRGO event
	ADC_CR2_JEXTSEL_TIM1TRGO = 0x0
	// Timer 1 CC4 event
	ADC_CR2_JEXTSEL_TIM1CC4 = 0x1
	// Timer 2 TRGO event
	ADC_CR2_JEXTSEL_TIM2TRGO = 0x2
	// Timer 2 CC1 event
	ADC_CR2_JEXTSEL_TIM2CC1 = 0x3
	// Timer 3 CC4 event
	ADC_CR2_JEXTSEL_TIM3CC4 = 0x4
	// Timer 4 TRGO event
	ADC_CR2_JEXTSEL_TIM4TRGO = 0x5
	// Timer 8 CC4 event
	ADC_CR2_JEXTSEL_TIM8CC4 = 0x7
	// Timer 1 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM1TRGO2 = 0x8
	// Timer 8 TRGO event
	ADC_CR2_JEXTSEL_TIM8TRGO = 0x9
	// Timer 8 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM8TRGO2 = 0xa
	// Timer 3 CC3 event
	ADC_CR2_JEXTSEL_TIM3CC3 = 0xb
	// Timer 5 TRGO event
	ADC_CR2_JEXTSEL_TIM5TRGO = 0xc
	// Timer 3 CC1 event
	ADC_CR2_JEXTSEL_TIM3CC1 = 0xd
	// Timer 6 TRGO event
	ADC_CR2_JEXTSEL_TIM6TRGO = 0xe
	// Position of ALIGN field.
	ADC_CR2_ALIGN_Pos = 0xb
	// Bit mask of ALIGN field.
	ADC_CR2_ALIGN_Msk = 0x800
	// Bit ALIGN.
	ADC_CR2_ALIGN = 0x800
	// Right alignment
	ADC_CR2_ALIGN_Right = 0x0
	// Left alignment
	ADC_CR2_ALIGN_Left = 0x1
	// Position of EOCS field.
	ADC_CR2_EOCS_Pos = 0xa
	// Bit mask of EOCS field.
	ADC_CR2_EOCS_Msk = 0x400
	// Bit EOCS.
	ADC_CR2_EOCS = 0x400
	// The EOC bit is set at the end of each sequence of regular conversions
	ADC_CR2_EOCS_EachSequence = 0x0
	// The EOC bit is set at the end of each regular conversion
	ADC_CR2_EOCS_EachConversion = 0x1
	// Position of DDS field.
	ADC_CR2_DDS_Pos = 0x9
	// Bit mask of DDS field.
	ADC_CR2_DDS_Msk = 0x200
	// Bit DDS.
	ADC_CR2_DDS = 0x200
	// No new DMA request is issued after the last transfer
	ADC_CR2_DDS_Single = 0x0
	// DMA requests are issued as long as data are converted and DMA=1
	ADC_CR2_DDS_Continuous = 0x1
	// Position of DMA field.
	ADC_CR2_DMA_Pos = 0x8
	// Bit mask of DMA field.
	ADC_CR2_DMA_Msk = 0x100
	// Bit DMA.
	ADC_CR2_DMA = 0x100
	// DMA mode disabled
	ADC_CR2_DMA_Disabled = 0x0
	// DMA mode enabled
	ADC_CR2_DMA_Enabled = 0x1
	// Position of CONT field.
	ADC_CR2_CONT_Pos = 0x1
	// Bit mask of CONT field.
	ADC_CR2_CONT_Msk = 0x2
	// Bit CONT.
	ADC_CR2_CONT = 0x2
	// Single conversion mode
	ADC_CR2_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CR2_CONT_Continuous = 0x1
	// Position of ADON field.
	ADC_CR2_ADON_Pos = 0x0
	// Bit mask of ADON field.
	ADC_CR2_ADON_Msk = 0x1
	// Bit ADON.
	ADC_CR2_ADON = 0x1
	// Disable ADC conversion and go to power down mode
	ADC_CR2_ADON_Disabled = 0x0
	// Enable ADC
	ADC_CR2_ADON_Enabled = 0x1

	// SMPR1: sample time register 1
	// Position of SMP18 field.
	ADC_SMPR1_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR1_SMP18_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR1_SMP18_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP18_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP18_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP18_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP18_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP18_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP18_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP18_Cycles480 = 0x7
	// Position of SMP17 field.
	ADC_SMPR1_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR1_SMP17_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR1_SMP17_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP17_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP17_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP17_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP17_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP17_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP17_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP17_Cycles480 = 0x7
	// Position of SMP16 field.
	ADC_SMPR1_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR1_SMP16_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR1_SMP16_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP16_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP16_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP16_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP16_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP16_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP16_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP16_Cycles480 = 0x7
	// Position of SMP15 field.
	ADC_SMPR1_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR1_SMP15_Msk = 0x38000
	// 3 cycles
	ADC_SMPR1_SMP15_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP15_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP15_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP15_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP15_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP15_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP15_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP15_Cycles480 = 0x7
	// Position of SMP14 field.
	ADC_SMPR1_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR1_SMP14_Msk = 0x7000
	// 3 cycles
	ADC_SMPR1_SMP14_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP14_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP14_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP14_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP14_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP14_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP14_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP14_Cycles480 = 0x7
	// Position of SMP13 field.
	ADC_SMPR1_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR1_SMP13_Msk = 0xe00
	// 3 cycles
	ADC_SMPR1_SMP13_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP13_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP13_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP13_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP13_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP13_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP13_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP13_Cycles480 = 0x7
	// Position of SMP12 field.
	ADC_SMPR1_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR1_SMP12_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR1_SMP12_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP12_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP12_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP12_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP12_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP12_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP12_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP12_Cycles480 = 0x7
	// Position of SMP11 field.
	ADC_SMPR1_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR1_SMP11_Msk = 0x38
	// 3 cycles
	ADC_SMPR1_SMP11_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP11_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP11_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP11_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP11_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP11_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP11_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP11_Cycles480 = 0x7
	// Position of SMP10 field.
	ADC_SMPR1_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR1_SMP10_Msk = 0x7
	// 3 cycles
	ADC_SMPR1_SMP10_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP10_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP10_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP10_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP10_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP10_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP10_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP10_Cycles480 = 0x7

	// SMPR2: sample time register 2
	// Position of SMP9 field.
	ADC_SMPR2_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR2_SMP9_Msk = 0x38000000
	// 3 cycles
	ADC_SMPR2_SMP9_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP9_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP9_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP9_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP9_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP9_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP9_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP9_Cycles480 = 0x7
	// Position of SMP8 field.
	ADC_SMPR2_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR2_SMP8_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR2_SMP8_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP8_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP8_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP8_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP8_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP8_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP8_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP8_Cycles480 = 0x7
	// Position of SMP7 field.
	ADC_SMPR2_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR2_SMP7_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR2_SMP7_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP7_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP7_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP7_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP7_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP7_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP7_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP7_Cycles480 = 0x7
	// Position of SMP6 field.
	ADC_SMPR2_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR2_SMP6_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR2_SMP6_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP6_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP6_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP6_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP6_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP6_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP6_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP6_Cycles480 = 0x7
	// Position of SMP5 field.
	ADC_SMPR2_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR2_SMP5_Msk = 0x38000
	// 3 cycles
	ADC_SMPR2_SMP5_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP5_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP5_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP5_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP5_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP5_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP5_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP5_Cycles480 = 0x7
	// Position of SMP4 field.
	ADC_SMPR2_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR2_SMP4_Msk = 0x7000
	// 3 cycles
	ADC_SMPR2_SMP4_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP4_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP4_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP4_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP4_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP4_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP4_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP4_Cycles480 = 0x7
	// Position of SMP3 field.
	ADC_SMPR2_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR2_SMP3_Msk = 0xe00
	// 3 cycles
	ADC_SMPR2_SMP3_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP3_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP3_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP3_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP3_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP3_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP3_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP3_Cycles480 = 0x7
	// Position of SMP2 field.
	ADC_SMPR2_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR2_SMP2_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR2_SMP2_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP2_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP2_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP2_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP2_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP2_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP2_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP2_Cycles480 = 0x7
	// Position of SMP1 field.
	ADC_SMPR2_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR2_SMP1_Msk = 0x38
	// 3 cycles
	ADC_SMPR2_SMP1_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP1_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP1_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP1_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP1_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP1_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP1_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP1_Cycles480 = 0x7
	// Position of SMP0 field.
	ADC_SMPR2_SMP0_Pos = 0x0
	// Bit mask of SMP0 field.
	ADC_SMPR2_SMP0_Msk = 0x7
	// 3 cycles
	ADC_SMPR2_SMP0_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP0_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP0_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP0_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP0_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP0_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP0_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP0_Cycles480 = 0x7

	// JOFR1: injected channel data offset register x
	// Position of JOFFSET field.
	ADC_JOFR_JOFFSET_Pos = 0x0
	// Bit mask of JOFFSET field.
	ADC_JOFR_JOFFSET_Msk = 0xfff

	// HTR: watchdog higher threshold register
	// Position of HT field.
	ADC_HTR_HT_Pos = 0x0
	// Bit mask of HT field.
	ADC_HTR_HT_Msk = 0xfff

	// LTR: watchdog lower threshold register
	// Position of LT field.
	ADC_LTR_LT_Pos = 0x0
	// Bit mask of LT field.
	ADC_LTR_LT_Msk = 0xfff

	// SQR1: regular sequence register 1
	// Position of L field.
	ADC_SQR1_L_Pos = 0x14
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf00000
	// Position of SQ16 field.
	ADC_SQR1_SQ16_Pos = 0xf
	// Bit mask of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000
	// Position of SQ15 field.
	ADC_SQR1_SQ15_Pos = 0xa
	// Bit mask of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00
	// Position of SQ14 field.
	ADC_SQR1_SQ14_Pos = 0x5
	// Bit mask of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0
	// Position of SQ13 field.
	ADC_SQR1_SQ13_Pos = 0x0
	// Bit mask of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f

	// SQR2: regular sequence register 2
	// Position of SQ12 field.
	ADC_SQR2_SQ12_Pos = 0x19
	// Bit mask of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000
	// Position of SQ11 field.
	ADC_SQR2_SQ11_Pos = 0x14
	// Bit mask of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000
	// Position of SQ10 field.
	ADC_SQR2_SQ10_Pos = 0xf
	// Bit mask of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0xa
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x7c00
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x5
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x3e0
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0x0
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ6 field.
	ADC_SQR3_SQ6_Pos = 0x19
	// Bit mask of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000
	// Position of SQ5 field.
	ADC_SQR3_SQ5_Pos = 0x14
	// Bit mask of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000
	// Position of SQ4 field.
	ADC_SQR3_SQ4_Pos = 0xf
	// Bit mask of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000
	// Position of SQ3 field.
	ADC_SQR3_SQ3_Pos = 0xa
	// Bit mask of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00
	// Position of SQ2 field.
	ADC_SQR3_SQ2_Pos = 0x5
	// Bit mask of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0
	// Position of SQ1 field.
	ADC_SQR3_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f

	// JSQR: injected sequence register
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x14
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x300000
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0xf
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0xa
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0x5
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x0
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f

	// JDR1: injected data register x
	// Position of JDATA field.
	ADC_JDR_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR_JDATA_Msk = 0xffff

	// DR: regular data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE2_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE2_Enabled = 0x1
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN2_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN2_Enabled = 0x1
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// Wave generation disabled
	DAC_CR_WAVE2_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE2_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE2_Triangle = 0x2
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x13
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x380000
	// Timer 6 TRGO event
	DAC_CR_TSEL2_TIM6_TRGO = 0x0
	// Timer 8 TRGO event
	DAC_CR_TSEL2_TIM8_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL2_TIM7_TRGO = 0x2
	// Timer 5 TRGO event
	DAC_CR_TSEL2_TIM5_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL2_TIM2_TRGO = 0x4
	// Timer 4 TRGO event
	DAC_CR_TSEL2_TIM4_TRGO = 0x5
	// EXTI line9
	DAC_CR_TSEL2_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL2_SOFTWARE = 0x7
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x12
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x40000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x40000
	// DAC channel X trigger disabled
	DAC_CR_TEN2_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN2_Enabled = 0x1
	// Position of BOFF2 field.
	DAC_CR_BOFF2_Pos = 0x11
	// Bit mask of BOFF2 field.
	DAC_CR_BOFF2_Msk = 0x20000
	// Bit BOFF2.
	DAC_CR_BOFF2 = 0x20000
	// DAC channel X output buffer enabled
	DAC_CR_BOFF2_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF2_Disabled = 0x1
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// DAC channel X disabled
	DAC_CR_EN2_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN2_Enabled = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Wave generation disabled
	DAC_CR_WAVE1_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE1_Triangle = 0x2
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Timer 6 TRGO event
	DAC_CR_TSEL1_TIM6_TRGO = 0x0
	// Timer 3 TRGO event
	DAC_CR_TSEL1_TIM3_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL1_TIM7_TRGO = 0x2
	// Timer 15 TRGO event
	DAC_CR_TSEL1_TIM15_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL1_TIM2_TRGO = 0x4
	// EXTI line9
	DAC_CR_TSEL1_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL1_SOFTWARE = 0x7
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// DAC channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of BOFF1 field.
	DAC_CR_BOFF1_Pos = 0x1
	// Bit mask of BOFF1 field.
	DAC_CR_BOFF1_Msk = 0x2
	// Bit BOFF1.
	DAC_CR_BOFF1 = 0x2
	// DAC channel X output buffer enabled
	DAC_CR_BOFF1_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF1_Disabled = 0x1
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN1_Enabled = 0x1

	// SWTRIGR: software trigger register
	// Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG2 = 0x2
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG2_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG2_Enabled = 0x1
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG1_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG1_Enabled = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff

	// DOR1: channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: status register
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_Underrun = 0x1
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_Underrun = 0x1
)

// Bitfields for PWR: Power control
const (
	// CR1: power control register
	// Position of LPDS field.
	PWR_CR1_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR1_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR1_LPDS = 0x1
	// Position of PDDS field.
	PWR_CR1_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR1_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR1_PDDS = 0x2
	// Enter Stop mode when the CPU enters deepsleep
	PWR_CR1_PDDS_STOP_MODE = 0x0
	// Enter Standby mode when the CPU enters deepsleep
	PWR_CR1_PDDS_STANDBY_MODE = 0x1
	// Position of CSBF field.
	PWR_CR1_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR1_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR1_CSBF = 0x8
	// Position of PVDE field.
	PWR_CR1_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR1_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR1_PVDE = 0x10
	// Position of PLS field.
	PWR_CR1_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR1_PLS_Msk = 0xe0
	// Position of DBP field.
	PWR_CR1_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR1_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR1_DBP = 0x100
	// Position of FPDS field.
	PWR_CR1_FPDS_Pos = 0x9
	// Bit mask of FPDS field.
	PWR_CR1_FPDS_Msk = 0x200
	// Bit FPDS.
	PWR_CR1_FPDS = 0x200
	// Position of LPUDS field.
	PWR_CR1_LPUDS_Pos = 0xa
	// Bit mask of LPUDS field.
	PWR_CR1_LPUDS_Msk = 0x400
	// Bit LPUDS.
	PWR_CR1_LPUDS = 0x400
	// Position of MRUDS field.
	PWR_CR1_MRUDS_Pos = 0xb
	// Bit mask of MRUDS field.
	PWR_CR1_MRUDS_Msk = 0x800
	// Bit MRUDS.
	PWR_CR1_MRUDS = 0x800
	// Position of ADCDC1 field.
	PWR_CR1_ADCDC1_Pos = 0xd
	// Bit mask of ADCDC1 field.
	PWR_CR1_ADCDC1_Msk = 0x2000
	// Bit ADCDC1.
	PWR_CR1_ADCDC1 = 0x2000
	// Position of VOS field.
	PWR_CR1_VOS_Pos = 0xe
	// Bit mask of VOS field.
	PWR_CR1_VOS_Msk = 0xc000
	// Scale 1 mode (reset value)
	PWR_CR1_VOS_SCALE1 = 0x3
	// Scale 2 mode
	PWR_CR1_VOS_SCALE2 = 0x2
	// Scale 3 mode
	PWR_CR1_VOS_SCALE3 = 0x1
	// Position of ODEN field.
	PWR_CR1_ODEN_Pos = 0x10
	// Bit mask of ODEN field.
	PWR_CR1_ODEN_Msk = 0x10000
	// Bit ODEN.
	PWR_CR1_ODEN = 0x10000
	// Position of ODSWEN field.
	PWR_CR1_ODSWEN_Pos = 0x11
	// Bit mask of ODSWEN field.
	PWR_CR1_ODSWEN_Msk = 0x20000
	// Bit ODSWEN.
	PWR_CR1_ODSWEN = 0x20000
	// Position of UDEN field.
	PWR_CR1_UDEN_Pos = 0x12
	// Bit mask of UDEN field.
	PWR_CR1_UDEN_Msk = 0xc0000

	// CSR1: power control/status register
	// Position of WUIF field.
	PWR_CSR1_WUIF_Pos = 0x0
	// Bit mask of WUIF field.
	PWR_CSR1_WUIF_Msk = 0x1
	// Bit WUIF.
	PWR_CSR1_WUIF = 0x1
	// Position of SBF field.
	PWR_CSR1_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR1_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR1_SBF = 0x2
	// Position of PVDO field.
	PWR_CSR1_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR1_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR1_PVDO = 0x4
	// Position of BRR field.
	PWR_CSR1_BRR_Pos = 0x3
	// Bit mask of BRR field.
	PWR_CSR1_BRR_Msk = 0x8
	// Bit BRR.
	PWR_CSR1_BRR = 0x8
	// Position of BRE field.
	PWR_CSR1_BRE_Pos = 0x9
	// Bit mask of BRE field.
	PWR_CSR1_BRE_Msk = 0x200
	// Bit BRE.
	PWR_CSR1_BRE = 0x200
	// Position of VOSRDY field.
	PWR_CSR1_VOSRDY_Pos = 0xe
	// Bit mask of VOSRDY field.
	PWR_CSR1_VOSRDY_Msk = 0x4000
	// Bit VOSRDY.
	PWR_CSR1_VOSRDY = 0x4000
	// Position of ODRDY field.
	PWR_CSR1_ODRDY_Pos = 0x10
	// Bit mask of ODRDY field.
	PWR_CSR1_ODRDY_Msk = 0x10000
	// Bit ODRDY.
	PWR_CSR1_ODRDY = 0x10000
	// Position of ODSWRDY field.
	PWR_CSR1_ODSWRDY_Pos = 0x11
	// Bit mask of ODSWRDY field.
	PWR_CSR1_ODSWRDY_Msk = 0x20000
	// Bit ODSWRDY.
	PWR_CSR1_ODSWRDY = 0x20000
	// Position of UDRDY field.
	PWR_CSR1_UDRDY_Pos = 0x12
	// Bit mask of UDRDY field.
	PWR_CSR1_UDRDY_Msk = 0xc0000

	// CR2: power control register
	// Position of CWUPF1 field.
	PWR_CR2_CWUPF1_Pos = 0x0
	// Bit mask of CWUPF1 field.
	PWR_CR2_CWUPF1_Msk = 0x1
	// Bit CWUPF1.
	PWR_CR2_CWUPF1 = 0x1
	// Position of CWUPF2 field.
	PWR_CR2_CWUPF2_Pos = 0x1
	// Bit mask of CWUPF2 field.
	PWR_CR2_CWUPF2_Msk = 0x2
	// Bit CWUPF2.
	PWR_CR2_CWUPF2 = 0x2
	// Position of CWUPF3 field.
	PWR_CR2_CWUPF3_Pos = 0x2
	// Bit mask of CWUPF3 field.
	PWR_CR2_CWUPF3_Msk = 0x4
	// Bit CWUPF3.
	PWR_CR2_CWUPF3 = 0x4
	// Position of CWUPF4 field.
	PWR_CR2_CWUPF4_Pos = 0x3
	// Bit mask of CWUPF4 field.
	PWR_CR2_CWUPF4_Msk = 0x8
	// Bit CWUPF4.
	PWR_CR2_CWUPF4 = 0x8
	// Position of CWUPF5 field.
	PWR_CR2_CWUPF5_Pos = 0x4
	// Bit mask of CWUPF5 field.
	PWR_CR2_CWUPF5_Msk = 0x10
	// Bit CWUPF5.
	PWR_CR2_CWUPF5 = 0x10
	// Position of CWUPF6 field.
	PWR_CR2_CWUPF6_Pos = 0x5
	// Bit mask of CWUPF6 field.
	PWR_CR2_CWUPF6_Msk = 0x20
	// Bit CWUPF6.
	PWR_CR2_CWUPF6 = 0x20
	// Position of WUPP1 field.
	PWR_CR2_WUPP1_Pos = 0x8
	// Bit mask of WUPP1 field.
	PWR_CR2_WUPP1_Msk = 0x100
	// Bit WUPP1.
	PWR_CR2_WUPP1 = 0x100
	// Position of WUPP2 field.
	PWR_CR2_WUPP2_Pos = 0x9
	// Bit mask of WUPP2 field.
	PWR_CR2_WUPP2_Msk = 0x200
	// Bit WUPP2.
	PWR_CR2_WUPP2 = 0x200
	// Position of WUPP3 field.
	PWR_CR2_WUPP3_Pos = 0xa
	// Bit mask of WUPP3 field.
	PWR_CR2_WUPP3_Msk = 0x400
	// Bit WUPP3.
	PWR_CR2_WUPP3 = 0x400
	// Position of WUPP4 field.
	PWR_CR2_WUPP4_Pos = 0xb
	// Bit mask of WUPP4 field.
	PWR_CR2_WUPP4_Msk = 0x800
	// Bit WUPP4.
	PWR_CR2_WUPP4 = 0x800
	// Position of WUPP5 field.
	PWR_CR2_WUPP5_Pos = 0xc
	// Bit mask of WUPP5 field.
	PWR_CR2_WUPP5_Msk = 0x1000
	// Bit WUPP5.
	PWR_CR2_WUPP5 = 0x1000
	// Position of WUPP6 field.
	PWR_CR2_WUPP6_Pos = 0xd
	// Bit mask of WUPP6 field.
	PWR_CR2_WUPP6_Msk = 0x2000
	// Bit WUPP6.
	PWR_CR2_WUPP6 = 0x2000

	// CSR2: power control/status register
	// Position of WUPF1 field.
	PWR_CSR2_WUPF1_Pos = 0x0
	// Bit mask of WUPF1 field.
	PWR_CSR2_WUPF1_Msk = 0x1
	// Bit WUPF1.
	PWR_CSR2_WUPF1 = 0x1
	// Position of WUPF2 field.
	PWR_CSR2_WUPF2_Pos = 0x1
	// Bit mask of WUPF2 field.
	PWR_CSR2_WUPF2_Msk = 0x2
	// Bit WUPF2.
	PWR_CSR2_WUPF2 = 0x2
	// Position of WUPF3 field.
	PWR_CSR2_WUPF3_Pos = 0x2
	// Bit mask of WUPF3 field.
	PWR_CSR2_WUPF3_Msk = 0x4
	// Bit WUPF3.
	PWR_CSR2_WUPF3 = 0x4
	// Position of WUPF4 field.
	PWR_CSR2_WUPF4_Pos = 0x3
	// Bit mask of WUPF4 field.
	PWR_CSR2_WUPF4_Msk = 0x8
	// Bit WUPF4.
	PWR_CSR2_WUPF4 = 0x8
	// Position of WUPF5 field.
	PWR_CSR2_WUPF5_Pos = 0x4
	// Bit mask of WUPF5 field.
	PWR_CSR2_WUPF5_Msk = 0x10
	// Bit WUPF5.
	PWR_CSR2_WUPF5 = 0x10
	// Position of WUPF6 field.
	PWR_CSR2_WUPF6_Pos = 0x5
	// Bit mask of WUPF6 field.
	PWR_CSR2_WUPF6_Msk = 0x20
	// Bit WUPF6.
	PWR_CSR2_WUPF6 = 0x20
	// Position of EWUP1 field.
	PWR_CSR2_EWUP1_Pos = 0x8
	// Bit mask of EWUP1 field.
	PWR_CSR2_EWUP1_Msk = 0x100
	// Bit EWUP1.
	PWR_CSR2_EWUP1 = 0x100
	// Position of EWUP2 field.
	PWR_CSR2_EWUP2_Pos = 0x9
	// Bit mask of EWUP2 field.
	PWR_CSR2_EWUP2_Msk = 0x200
	// Bit EWUP2.
	PWR_CSR2_EWUP2 = 0x200
	// Position of EWUP3 field.
	PWR_CSR2_EWUP3_Pos = 0xa
	// Bit mask of EWUP3 field.
	PWR_CSR2_EWUP3_Msk = 0x400
	// Bit EWUP3.
	PWR_CSR2_EWUP3 = 0x400
	// Position of EWUP4 field.
	PWR_CSR2_EWUP4_Pos = 0xb
	// Bit mask of EWUP4 field.
	PWR_CSR2_EWUP4_Msk = 0x800
	// Bit EWUP4.
	PWR_CSR2_EWUP4 = 0x800
	// Position of EWUP5 field.
	PWR_CSR2_EWUP5_Pos = 0xc
	// Bit mask of EWUP5 field.
	PWR_CSR2_EWUP5_Msk = 0x1000
	// Bit EWUP5.
	PWR_CSR2_EWUP5 = 0x1000
	// Position of EWUP6 field.
	PWR_CSR2_EWUP6_Pos = 0xd
	// Bit mask of EWUP6 field.
	PWR_CSR2_EWUP6_Msk = 0x2000
	// Bit EWUP6.
	PWR_CSR2_EWUP6 = 0x2000
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Bitfields for TIM1: Advanced-timers
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of OIS4 field.
	TIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_CR2_OIS4 = 0x4000
	// Position of OIS3N field.
	TIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_CR2_OIS3N = 0x2000
	// Position of OIS3 field.
	TIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_CR2_OIS3 = 0x1000
	// Position of OIS2N field.
	TIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_CR2_OIS2N = 0x800
	// Position of OIS2 field.
	TIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_CR2_OIS2 = 0x400
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1

	// SMCR: slave mode control register
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC2M_OpmMode1 = 0x8
	// Inversely to OpmMode1
	TIM_CCMR1_Output_OC2M_OpmMode2 = 0x9
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_CombinedPwmMode1 = 0xc
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_CombinedPwmMode2 = 0xd
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC2M_AsymmetricPwmMode1 = 0xe
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC2M_AsymmetricPwmMode2 = 0xf
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC1M_OpmMode1 = 0x8
	// Inversely to OpmMode1
	TIM_CCMR1_Output_OC1M_OpmMode2 = 0x9
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC1M_CombinedPwmMode1 = 0xc
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC1M_CombinedPwmMode2 = 0xd
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC1M_AsymmetricPwmMode1 = 0xe
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC1M_AsymmetricPwmMode2 = 0xf
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC4M_OpmMode1 = 0x8
	// Inversely to OpmMode1
	TIM_CCMR2_Output_OC4M_OpmMode2 = 0x9
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_CombinedPwmMode1 = 0xc
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_CombinedPwmMode2 = 0xd
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC4M_AsymmetricPwmMode1 = 0xe
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC4M_AsymmetricPwmMode2 = 0xf
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC3M_OpmMode1 = 0x8
	// Inversely to OpmMode1
	TIM_CCMR2_Output_OC3M_OpmMode2 = 0x9
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_CombinedPwmMode1 = 0xc
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_CombinedPwmMode2 = 0xd
	// OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC3M_AsymmetricPwmMode1 = 0xe
	// OCyREF has the same behavior as in PWM mode 2. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC3M_AsymmetricPwmMode2 = 0xf
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC3NE field.
	TIM_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	TIM_CCER_CC3NE = 0x400
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC2NE field.
	TIM_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	TIM_CCER_CC2NE = 0x40
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1NE field.
	TIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_CCER_CC1NE = 0x4
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	TIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_RCR_REP_Msk = 0xff

	// CCR1: capture/compare register 1
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of DTG field.
	TIM_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_BDTR_DTG_Msk = 0xff
	// Position of LOCK field.
	TIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300
	// Position of OSSI field.
	TIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_BDTR_OSSI = 0x400
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSI_Disabled = 0x0
	// When inactive, OC/OCN outputs are forced to idle level
	TIM_BDTR_OSSI_IdleLevel = 0x1
	// Position of OSSR field.
	TIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_BDTR_OSSR = 0x800
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSR_Disabled = 0x0
	// When inactive, OC/OCN outputs are enabled with their inactive level
	TIM_BDTR_OSSR_IdleLevel = 0x1
	// Position of BKE field.
	TIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_BDTR_BKE = 0x1000
	// Position of BKP field.
	TIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_BDTR_BKP = 0x2000
	// Position of AOE field.
	TIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_BDTR_AOE = 0x4000
	// Position of MOE field.
	TIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_BDTR_MOE = 0x8000
	// OC/OCN are disabled or forced idle depending on OSSI
	TIM_BDTR_MOE_DisabledIdle = 0x0
	// OC/OCN are enabled if CCxE/CCxNE are set
	TIM_BDTR_MOE_Enabled = 0x1
	// Position of BKF field.
	TIM_BDTR_BKF_Pos = 0x10
	// Bit mask of BKF field.
	TIM_BDTR_BKF_Msk = 0xf0000
	// Position of BK2F field.
	TIM_BDTR_BK2F_Pos = 0x14
	// Bit mask of BK2F field.
	TIM_BDTR_BK2F_Msk = 0xf00000
	// Position of BK2E field.
	TIM_BDTR_BK2E_Pos = 0x18
	// Bit mask of BK2E field.
	TIM_BDTR_BK2E_Msk = 0x1000000
	// Bit BK2E.
	TIM_BDTR_BK2E = 0x1000000
	// Position of BK2P field.
	TIM_BDTR_BK2P_Pos = 0x19
	// Bit mask of BK2P field.
	TIM_BDTR_BK2P_Msk = 0x2000000
	// Bit BK2P.
	TIM_BDTR_BK2P = 0x2000000

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff

	// CCMR3_Output: capture/compare mode register 3 (output mode)
	// Position of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Pos = 0x2
	// Bit mask of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Msk = 0x4
	// Bit OC5FE.
	TIM_CCMR3_Output_OC5FE = 0x4
	// Position of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Pos = 0x3
	// Bit mask of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Msk = 0x8
	// Bit OC5PE.
	TIM_CCMR3_Output_OC5PE = 0x8
	// Position of OC5M field.
	TIM_CCMR3_Output_OC5M_Pos = 0x4
	// Bit mask of OC5M field.
	TIM_CCMR3_Output_OC5M_Msk = 0x70
	// Position of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Pos = 0x7
	// Bit mask of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Msk = 0x80
	// Bit OC5CE.
	TIM_CCMR3_Output_OC5CE = 0x80
	// Position of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Pos = 0xa
	// Bit mask of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Msk = 0x400
	// Bit OC6FE.
	TIM_CCMR3_Output_OC6FE = 0x400
	// Position of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Pos = 0xb
	// Bit mask of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Msk = 0x800
	// Bit OC6PE.
	TIM_CCMR3_Output_OC6PE = 0x800
	// Position of OC6M field.
	TIM_CCMR3_Output_OC6M_Pos = 0xc
	// Bit mask of OC6M field.
	TIM_CCMR3_Output_OC6M_Msk = 0x7000
	// Position of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Pos = 0xf
	// Bit mask of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Msk = 0x8000
	// Bit OC6CE.
	TIM_CCMR3_Output_OC6CE = 0x8000
	// Position of OC5M3 field.
	TIM_CCMR3_Output_OC5M3_Pos = 0x10
	// Bit mask of OC5M3 field.
	TIM_CCMR3_Output_OC5M3_Msk = 0x10000
	// Bit OC5M3.
	TIM_CCMR3_Output_OC5M3 = 0x10000
	// Position of OC6M3 field.
	TIM_CCMR3_Output_OC6M3_Pos = 0x18
	// Bit mask of OC6M3 field.
	TIM_CCMR3_Output_OC6M3_Msk = 0x1000000
	// Bit OC6M3.
	TIM_CCMR3_Output_OC6M3 = 0x1000000

	// CCR5: capture/compare register 5
	// Position of CCR field.
	TIM_CCR5_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR5_CCR_Msk = 0xffff
	// Position of GC5C1 field.
	TIM_CCR5_GC5C1_Pos = 0x1d
	// Bit mask of GC5C1 field.
	TIM_CCR5_GC5C1_Msk = 0x20000000
	// Bit GC5C1.
	TIM_CCR5_GC5C1 = 0x20000000
	// Position of GC5C2 field.
	TIM_CCR5_GC5C2_Pos = 0x1e
	// Bit mask of GC5C2 field.
	TIM_CCR5_GC5C2_Msk = 0x40000000
	// Bit GC5C2.
	TIM_CCR5_GC5C2 = 0x40000000
	// Position of GC5C3 field.
	TIM_CCR5_GC5C3_Pos = 0x1f
	// Bit mask of GC5C3 field.
	TIM_CCR5_GC5C3_Msk = 0x80000000
	// Bit GC5C3.
	TIM_CCR5_GC5C3 = 0x80000000

	// CRR6: capture/compare register 6
	// Position of CCR6 field.
	TIM_CRR6_CCR6_Pos = 0x0
	// Bit mask of CCR6 field.
	TIM_CRR6_CCR6_Msk = 0xffff

	// AF1: alternate function option register 1
	// Position of BKINE field.
	TIM_AF1_BKINE_Pos = 0x0
	// Bit mask of BKINE field.
	TIM_AF1_BKINE_Msk = 0x1
	// Bit BKINE.
	TIM_AF1_BKINE = 0x1
	// Position of BKDFBKE field.
	TIM_AF1_BKDFBKE_Pos = 0x8
	// Bit mask of BKDFBKE field.
	TIM_AF1_BKDFBKE_Msk = 0x100
	// Bit BKDFBKE.
	TIM_AF1_BKDFBKE = 0x100
	// Position of BKINP field.
	TIM_AF1_BKINP_Pos = 0x9
	// Bit mask of BKINP field.
	TIM_AF1_BKINP_Msk = 0x200
	// Bit BKINP.
	TIM_AF1_BKINP = 0x200

	// AF2: alternate function option register 2
	// Position of BK2INE field.
	TIM_AF2_BK2INE_Pos = 0x0
	// Bit mask of BK2INE field.
	TIM_AF2_BK2INE_Msk = 0x1
	// Bit BK2INE.
	TIM_AF2_BK2INE = 0x1
	// Position of BK2DFBKE field.
	TIM_AF2_BK2DFBKE_Pos = 0x8
	// Bit mask of BK2DFBKE field.
	TIM_AF2_BK2DFBKE_Msk = 0x100
	// Bit BK2DFBKE.
	TIM_AF2_BK2DFBKE = 0x100
	// Position of BK2INP field.
	TIM_AF2_BK2INP_Pos = 0x9
	// Bit mask of BK2INP field.
	TIM_AF2_BK2INP_Msk = 0x200
	// Bit BK2INP.
	TIM_AF2_BK2INP = 0x200
)

// Bitfields for Ethernet_MAC: Ethernet: media access control (MAC)
const (
	// MACCR: Ethernet MAC configuration register
	// Position of RE field.
	Ethernet_MACCR_RE_Pos = 0x2
	// Bit mask of RE field.
	Ethernet_MACCR_RE_Msk = 0x4
	// Bit RE.
	Ethernet_MACCR_RE = 0x4
	// MAC receive state machine is disabled after the completion of the reception of the current frame
	Ethernet_MACCR_RE_Disabled = 0x0
	// MAC receive state machine is enabled
	Ethernet_MACCR_RE_Enabled = 0x1
	// Position of TE field.
	Ethernet_MACCR_TE_Pos = 0x3
	// Bit mask of TE field.
	Ethernet_MACCR_TE_Msk = 0x8
	// Bit TE.
	Ethernet_MACCR_TE = 0x8
	// MAC transmit state machine is disabled after completion of the transmission of the current frame
	Ethernet_MACCR_TE_Disabled = 0x0
	// MAC transmit state machine is enabled
	Ethernet_MACCR_TE_Enabled = 0x1
	// Position of DC field.
	Ethernet_MACCR_DC_Pos = 0x4
	// Bit mask of DC field.
	Ethernet_MACCR_DC_Msk = 0x10
	// Bit DC.
	Ethernet_MACCR_DC = 0x10
	// MAC defers until CRS signal goes inactive
	Ethernet_MACCR_DC_Disabled = 0x0
	// Deferral check function enabled
	Ethernet_MACCR_DC_Enabled = 0x1
	// Position of BL field.
	Ethernet_MACCR_BL_Pos = 0x5
	// Bit mask of BL field.
	Ethernet_MACCR_BL_Msk = 0x60
	// For retransmission n, wait up to 2^min(n, 10) time slots
	Ethernet_MACCR_BL_BL10 = 0x0
	// For retransmission n, wait up to 2^min(n, 8) time slots
	Ethernet_MACCR_BL_BL8 = 0x1
	// For retransmission n, wait up to 2^min(n, 4) time slots
	Ethernet_MACCR_BL_BL4 = 0x2
	// For retransmission n, wait up to 2^min(n, 1) time slots
	Ethernet_MACCR_BL_BL1 = 0x3
	// Position of APCS field.
	Ethernet_MACCR_APCS_Pos = 0x7
	// Bit mask of APCS field.
	Ethernet_MACCR_APCS_Msk = 0x80
	// Bit APCS.
	Ethernet_MACCR_APCS = 0x80
	// MAC passes all incoming frames unmodified
	Ethernet_MACCR_APCS_Disabled = 0x0
	// MAC strips the Pad/FCS field on incoming frames only for lengths less than or equal to 1500 bytes
	Ethernet_MACCR_APCS_Strip = 0x1
	// Position of RD field.
	Ethernet_MACCR_RD_Pos = 0x9
	// Bit mask of RD field.
	Ethernet_MACCR_RD_Msk = 0x200
	// Bit RD.
	Ethernet_MACCR_RD = 0x200
	// MAC attempts retries based on the settings of BL
	Ethernet_MACCR_RD_Enabled = 0x0
	// MAC attempts only 1 transmission
	Ethernet_MACCR_RD_Disabled = 0x1
	// Position of IPCO field.
	Ethernet_MACCR_IPCO_Pos = 0xa
	// Bit mask of IPCO field.
	Ethernet_MACCR_IPCO_Msk = 0x400
	// Bit IPCO.
	Ethernet_MACCR_IPCO = 0x400
	// IPv4 checksum offload disabled
	Ethernet_MACCR_IPCO_Disabled = 0x0
	// IPv4 checksums are checked in received frames
	Ethernet_MACCR_IPCO_Offload = 0x1
	// Position of DM field.
	Ethernet_MACCR_DM_Pos = 0xb
	// Bit mask of DM field.
	Ethernet_MACCR_DM_Msk = 0x800
	// Bit DM.
	Ethernet_MACCR_DM = 0x800
	// MAC operates in half-duplex mode
	Ethernet_MACCR_DM_HalfDuplex = 0x0
	// MAC operates in full-duplex mode
	Ethernet_MACCR_DM_FullDuplex = 0x1
	// Position of LM field.
	Ethernet_MACCR_LM_Pos = 0xc
	// Bit mask of LM field.
	Ethernet_MACCR_LM_Msk = 0x1000
	// Bit LM.
	Ethernet_MACCR_LM = 0x1000
	// Normal mode
	Ethernet_MACCR_LM_Normal = 0x0
	// MAC operates in loopback mode at the MII
	Ethernet_MACCR_LM_Loopback = 0x1
	// Position of ROD field.
	Ethernet_MACCR_ROD_Pos = 0xd
	// Bit mask of ROD field.
	Ethernet_MACCR_ROD_Msk = 0x2000
	// Bit ROD.
	Ethernet_MACCR_ROD = 0x2000
	// MAC receives all packets from PHY while transmitting
	Ethernet_MACCR_ROD_Enabled = 0x0
	// MAC disables reception of frames in half-duplex mode
	Ethernet_MACCR_ROD_Disabled = 0x1
	// Position of FES field.
	Ethernet_MACCR_FES_Pos = 0xe
	// Bit mask of FES field.
	Ethernet_MACCR_FES_Msk = 0x4000
	// Bit FES.
	Ethernet_MACCR_FES = 0x4000
	// 10 Mbit/s
	Ethernet_MACCR_FES_FES10 = 0x0
	// 100 Mbit/s
	Ethernet_MACCR_FES_FES100 = 0x1
	// Position of CSD field.
	Ethernet_MACCR_CSD_Pos = 0x10
	// Bit mask of CSD field.
	Ethernet_MACCR_CSD_Msk = 0x10000
	// Bit CSD.
	Ethernet_MACCR_CSD = 0x10000
	// Errors generated due to loss of carrier
	Ethernet_MACCR_CSD_Enabled = 0x0
	// No error generated due to loss of carrier
	Ethernet_MACCR_CSD_Disabled = 0x1
	// Position of IFG field.
	Ethernet_MACCR_IFG_Pos = 0x11
	// Bit mask of IFG field.
	Ethernet_MACCR_IFG_Msk = 0xe0000
	// 96 bit times
	Ethernet_MACCR_IFG_IFG96 = 0x0
	// 88 bit times
	Ethernet_MACCR_IFG_IFG88 = 0x1
	// 48 bit times
	Ethernet_MACCR_IFG_IFG80 = 0x6
	// 40 bit times
	Ethernet_MACCR_IFG_IFG40 = 0x7
	// Position of JD field.
	Ethernet_MACCR_JD_Pos = 0x16
	// Bit mask of JD field.
	Ethernet_MACCR_JD_Msk = 0x400000
	// Bit JD.
	Ethernet_MACCR_JD = 0x400000
	// Jabber enabled, transmit frames up to 2048 bytes
	Ethernet_MACCR_JD_Enabled = 0x0
	// Jabber disabled, transmit frames up to 16384 bytes
	Ethernet_MACCR_JD_Disabled = 0x1
	// Position of WD field.
	Ethernet_MACCR_WD_Pos = 0x17
	// Bit mask of WD field.
	Ethernet_MACCR_WD_Msk = 0x800000
	// Bit WD.
	Ethernet_MACCR_WD = 0x800000
	// Watchdog enabled, receive frames limited to 2048 bytes
	Ethernet_MACCR_WD_Enabled = 0x0
	// Watchdog disabled, receive frames may be up to to 16384 bytes
	Ethernet_MACCR_WD_Disabled = 0x1
	// Position of CSTF field.
	Ethernet_MACCR_CSTF_Pos = 0x19
	// Bit mask of CSTF field.
	Ethernet_MACCR_CSTF_Msk = 0x2000000
	// Bit CSTF.
	Ethernet_MACCR_CSTF = 0x2000000
	// CRC not stripped
	Ethernet_MACCR_CSTF_Disabled = 0x0
	// CRC stripped
	Ethernet_MACCR_CSTF_Enabled = 0x1

	// MACFFR: Ethernet MAC frame filter register
	// Position of PM field.
	Ethernet_MACFFR_PM_Pos = 0x0
	// Bit mask of PM field.
	Ethernet_MACFFR_PM_Msk = 0x1
	// Bit PM.
	Ethernet_MACFFR_PM = 0x1
	// Normal address filtering
	Ethernet_MACFFR_PM_Disabled = 0x0
	// Address filters pass all incoming frames regardless of their destination or source address
	Ethernet_MACFFR_PM_Enabled = 0x1
	// Position of HU field.
	Ethernet_MACFFR_HU_Pos = 0x1
	// Bit mask of HU field.
	Ethernet_MACFFR_HU_Msk = 0x2
	// Bit HU.
	Ethernet_MACFFR_HU = 0x2
	// MAC performs a perfect destination address filtering for unicast frames
	Ethernet_MACFFR_HU_Perfect = 0x0
	// MAC performs destination address filtering of received unicast frames according to the hash table
	Ethernet_MACFFR_HU_Hash = 0x1
	// Position of HM field.
	Ethernet_MACFFR_HM_Pos = 0x2
	// Bit mask of HM field.
	Ethernet_MACFFR_HM_Msk = 0x4
	// Bit HM.
	Ethernet_MACFFR_HM = 0x4
	// MAC performs a perfect destination address filtering for multicast frames
	Ethernet_MACFFR_HM_Perfect = 0x0
	// MAC performs destination address filtering of received multicast frames according to the hash table
	Ethernet_MACFFR_HM_Hash = 0x1
	// Position of DAIF field.
	Ethernet_MACFFR_DAIF_Pos = 0x3
	// Bit mask of DAIF field.
	Ethernet_MACFFR_DAIF_Msk = 0x8
	// Bit DAIF.
	Ethernet_MACFFR_DAIF = 0x8
	// Normal filtering of frames
	Ethernet_MACFFR_DAIF_Normal = 0x0
	// Address check block operates in inverse filtering mode for the DA address comparison
	Ethernet_MACFFR_DAIF_Invert = 0x1
	// Position of PAM field.
	Ethernet_MACFFR_PAM_Pos = 0x4
	// Bit mask of PAM field.
	Ethernet_MACFFR_PAM_Msk = 0x10
	// Bit PAM.
	Ethernet_MACFFR_PAM = 0x10
	// Filtering of multicast frames depends on HM
	Ethernet_MACFFR_PAM_Disabled = 0x0
	// All received frames with a multicast destination address are passed
	Ethernet_MACFFR_PAM_Enabled = 0x1
	// Position of BFD field.
	Ethernet_MACFFR_BFD_Pos = 0x5
	// Bit mask of BFD field.
	Ethernet_MACFFR_BFD_Msk = 0x20
	// Bit BFD.
	Ethernet_MACFFR_BFD = 0x20
	// Address filters pass all received broadcast frames
	Ethernet_MACFFR_BFD_Enabled = 0x0
	// Address filters filter all incoming broadcast frames
	Ethernet_MACFFR_BFD_Disabled = 0x1
	// Position of PCF field.
	Ethernet_MACFFR_PCF_Pos = 0x6
	// Bit mask of PCF field.
	Ethernet_MACFFR_PCF_Msk = 0xc0
	// MAC prevents all control frames from reaching the application
	Ethernet_MACFFR_PCF_PreventAll = 0x0
	// MAC forwards all control frames to application except Pause
	Ethernet_MACFFR_PCF_ForwardAllExceptPause = 0x1
	// MAC forwards all control frames to application even if they fail the address filter
	Ethernet_MACFFR_PCF_ForwardAll = 0x2
	// MAC forwards control frames that pass the address filter
	Ethernet_MACFFR_PCF_ForwardAllFiltered = 0x3
	// Position of SAIF field.
	Ethernet_MACFFR_SAIF_Pos = 0x7
	// Bit mask of SAIF field.
	Ethernet_MACFFR_SAIF_Msk = 0x80
	// Bit SAIF.
	Ethernet_MACFFR_SAIF = 0x80
	// Source address filter operates normally
	Ethernet_MACFFR_SAIF_Normal = 0x0
	// Source address filter operation inverted
	Ethernet_MACFFR_SAIF_Invert = 0x1
	// Position of SAF field.
	Ethernet_MACFFR_SAF_Pos = 0x8
	// Bit mask of SAF field.
	Ethernet_MACFFR_SAF_Msk = 0x100
	// Bit SAF.
	Ethernet_MACFFR_SAF = 0x100
	// Source address ignored
	Ethernet_MACFFR_SAF_Disabled = 0x0
	// MAC drops frames that fail the source address filter
	Ethernet_MACFFR_SAF_Enabled = 0x1
	// Position of HPF field.
	Ethernet_MACFFR_HPF_Pos = 0x9
	// Bit mask of HPF field.
	Ethernet_MACFFR_HPF_Msk = 0x200
	// Bit HPF.
	Ethernet_MACFFR_HPF = 0x200
	// If HM or HU is set, only frames that match the Hash filter are passed
	Ethernet_MACFFR_HPF_HashOnly = 0x0
	// If HM or HU is set, frames that match either the perfect filter or the hash filter are passed
	Ethernet_MACFFR_HPF_HashOrPerfect = 0x1
	// Position of RA field.
	Ethernet_MACFFR_RA_Pos = 0x1f
	// Bit mask of RA field.
	Ethernet_MACFFR_RA_Msk = 0x80000000
	// Bit RA.
	Ethernet_MACFFR_RA = 0x80000000
	// MAC receiver passes on to the application only those frames that have passed the SA/DA address file
	Ethernet_MACFFR_RA_Disabled = 0x0
	// MAC receiver passes oll received frames on to the application
	Ethernet_MACFFR_RA_Enabled = 0x1

	// MACHTHR: Ethernet MAC hash table high register
	// Position of HTH field.
	Ethernet_MACHTHR_HTH_Pos = 0x0
	// Bit mask of HTH field.
	Ethernet_MACHTHR_HTH_Msk = 0xffffffff

	// MACHTLR: Ethernet MAC hash table low register
	// Position of HTL field.
	Ethernet_MACHTLR_HTL_Pos = 0x0
	// Bit mask of HTL field.
	Ethernet_MACHTLR_HTL_Msk = 0xffffffff

	// MACMIIAR: Ethernet MAC MII address register
	// Position of MB field.
	Ethernet_MACMIIAR_MB_Pos = 0x0
	// Bit mask of MB field.
	Ethernet_MACMIIAR_MB_Msk = 0x1
	// Bit MB.
	Ethernet_MACMIIAR_MB = 0x1
	// This bit is set to 1 by the application to indicate that a read or write access is in progress
	Ethernet_MACMIIAR_MB_Busy = 0x1
	// Position of MW field.
	Ethernet_MACMIIAR_MW_Pos = 0x1
	// Bit mask of MW field.
	Ethernet_MACMIIAR_MW_Msk = 0x2
	// Bit MW.
	Ethernet_MACMIIAR_MW = 0x2
	// Read operation
	Ethernet_MACMIIAR_MW_Read = 0x0
	// Write operation
	Ethernet_MACMIIAR_MW_Write = 0x1
	// Position of CR field.
	Ethernet_MACMIIAR_CR_Pos = 0x2
	// Bit mask of CR field.
	Ethernet_MACMIIAR_CR_Msk = 0x1c
	// 60-100MHz HCLK/42
	Ethernet_MACMIIAR_CR_CR_60_100 = 0x0
	// 100-150 MHz HCLK/62
	Ethernet_MACMIIAR_CR_CR_100_150 = 0x1
	// 20-35MHz HCLK/16
	Ethernet_MACMIIAR_CR_CR_20_35 = 0x2
	// 35-60MHz HCLK/16
	Ethernet_MACMIIAR_CR_CR_35_60 = 0x3
	// 150-168MHz HCLK/102
	Ethernet_MACMIIAR_CR_CR_150_168 = 0x4
	// Position of MR field.
	Ethernet_MACMIIAR_MR_Pos = 0x6
	// Bit mask of MR field.
	Ethernet_MACMIIAR_MR_Msk = 0x7c0
	// Position of PA field.
	Ethernet_MACMIIAR_PA_Pos = 0xb
	// Bit mask of PA field.
	Ethernet_MACMIIAR_PA_Msk = 0xf800

	// MACMIIDR: Ethernet MAC MII data register
	// Position of MD field.
	Ethernet_MACMIIDR_MD_Pos = 0x0
	// Bit mask of MD field.
	Ethernet_MACMIIDR_MD_Msk = 0xffff

	// MACFCR: Ethernet MAC flow control register
	// Position of FCB field.
	Ethernet_MACFCR_FCB_Pos = 0x0
	// Bit mask of FCB field.
	Ethernet_MACFCR_FCB_Msk = 0x1
	// Bit FCB.
	Ethernet_MACFCR_FCB = 0x1
	// In full duplex, initiate a Pause control frame. In half duplex, assert back pressure
	Ethernet_MACFCR_FCB_PauseOrBackPressure = 0x1
	// In half duplex only, deasserts back pressure
	Ethernet_MACFCR_FCB_DisableBackPressure = 0x0
	// Position of TFCE field.
	Ethernet_MACFCR_TFCE_Pos = 0x1
	// Bit mask of TFCE field.
	Ethernet_MACFCR_TFCE_Msk = 0x2
	// Bit TFCE.
	Ethernet_MACFCR_TFCE = 0x2
	// In full duplex, flow control is disabled. In half duplex, back pressure is disabled
	Ethernet_MACFCR_TFCE_Disabled = 0x0
	// In full duplex, flow control is enabled. In half duplex, back pressure is enabled
	Ethernet_MACFCR_TFCE_Enabled = 0x1
	// Position of RFCE field.
	Ethernet_MACFCR_RFCE_Pos = 0x2
	// Bit mask of RFCE field.
	Ethernet_MACFCR_RFCE_Msk = 0x4
	// Bit RFCE.
	Ethernet_MACFCR_RFCE = 0x4
	// Pause frames are not decoded
	Ethernet_MACFCR_RFCE_Disabled = 0x0
	// MAC decodes received Pause frames and disables its transmitted for a specified time
	Ethernet_MACFCR_RFCE_Enabled = 0x1
	// Position of UPFD field.
	Ethernet_MACFCR_UPFD_Pos = 0x3
	// Bit mask of UPFD field.
	Ethernet_MACFCR_UPFD_Msk = 0x8
	// Bit UPFD.
	Ethernet_MACFCR_UPFD = 0x8
	// MAC detects only a Pause frame with the multicast address specified in the 802.3x standard
	Ethernet_MACFCR_UPFD_Disabled = 0x0
	// MAC additionally detects Pause frames with the station's unicast address
	Ethernet_MACFCR_UPFD_Enabled = 0x1
	// Position of PLT field.
	Ethernet_MACFCR_PLT_Pos = 0x4
	// Bit mask of PLT field.
	Ethernet_MACFCR_PLT_Msk = 0x30
	// Pause time minus 4 slot times
	Ethernet_MACFCR_PLT_PLT4 = 0x0
	// Pause time minus 28 slot times
	Ethernet_MACFCR_PLT_PLT28 = 0x1
	// Pause time minus 144 slot times
	Ethernet_MACFCR_PLT_PLT144 = 0x2
	// Pause time minus 256 slot times
	Ethernet_MACFCR_PLT_PLT256 = 0x3
	// Position of ZQPD field.
	Ethernet_MACFCR_ZQPD_Pos = 0x7
	// Bit mask of ZQPD field.
	Ethernet_MACFCR_ZQPD_Msk = 0x80
	// Bit ZQPD.
	Ethernet_MACFCR_ZQPD = 0x80
	// Normal operation with automatic zero-quanta pause control frame generation
	Ethernet_MACFCR_ZQPD_Enabled = 0x0
	// Automatic generation of zero-quanta pause control frames is disabled
	Ethernet_MACFCR_ZQPD_Disabled = 0x1
	// Position of PT field.
	Ethernet_MACFCR_PT_Pos = 0x10
	// Bit mask of PT field.
	Ethernet_MACFCR_PT_Msk = 0xffff0000

	// MACVLANTR: Ethernet MAC VLAN tag register
	// Position of VLANTI field.
	Ethernet_MACVLANTR_VLANTI_Pos = 0x0
	// Bit mask of VLANTI field.
	Ethernet_MACVLANTR_VLANTI_Msk = 0xffff
	// Position of VLANTC field.
	Ethernet_MACVLANTR_VLANTC_Pos = 0x10
	// Bit mask of VLANTC field.
	Ethernet_MACVLANTR_VLANTC_Msk = 0x10000
	// Bit VLANTC.
	Ethernet_MACVLANTR_VLANTC = 0x10000
	// Full 16 bit VLAN identifiers are used for comparison and filtering
	Ethernet_MACVLANTR_VLANTC_VLANTC16 = 0x0
	// 12 bit VLAN identifies are used for comparison and filtering
	Ethernet_MACVLANTR_VLANTC_VLANTC12 = 0x1

	// MACPMTCSR: Ethernet MAC PMT control and status register
	// Position of PD field.
	Ethernet_MACPMTCSR_PD_Pos = 0x0
	// Bit mask of PD field.
	Ethernet_MACPMTCSR_PD_Msk = 0x1
	// Bit PD.
	Ethernet_MACPMTCSR_PD = 0x1
	// All received frames will be dropped. Cleared automatically when a magic packet or wakeup frame is received
	Ethernet_MACPMTCSR_PD_Enabled = 0x1
	// Position of MPE field.
	Ethernet_MACPMTCSR_MPE_Pos = 0x1
	// Bit mask of MPE field.
	Ethernet_MACPMTCSR_MPE_Msk = 0x2
	// Bit MPE.
	Ethernet_MACPMTCSR_MPE = 0x2
	// No power management event generated due to Magic Packet reception
	Ethernet_MACPMTCSR_MPE_Disabled = 0x0
	// Enable generation of a power management event due to Magic Packet reception
	Ethernet_MACPMTCSR_MPE_Enabled = 0x1
	// Position of WFE field.
	Ethernet_MACPMTCSR_WFE_Pos = 0x2
	// Bit mask of WFE field.
	Ethernet_MACPMTCSR_WFE_Msk = 0x4
	// Bit WFE.
	Ethernet_MACPMTCSR_WFE = 0x4
	// No power management event generated due to wakeup frame reception
	Ethernet_MACPMTCSR_WFE_Disabled = 0x0
	// Enable generation of a power management event due to wakeup frame reception
	Ethernet_MACPMTCSR_WFE_Enabled = 0x1
	// Position of MPR field.
	Ethernet_MACPMTCSR_MPR_Pos = 0x5
	// Bit mask of MPR field.
	Ethernet_MACPMTCSR_MPR_Msk = 0x20
	// Bit MPR.
	Ethernet_MACPMTCSR_MPR = 0x20
	// Position of WFR field.
	Ethernet_MACPMTCSR_WFR_Pos = 0x6
	// Bit mask of WFR field.
	Ethernet_MACPMTCSR_WFR_Msk = 0x40
	// Bit WFR.
	Ethernet_MACPMTCSR_WFR = 0x40
	// Position of GU field.
	Ethernet_MACPMTCSR_GU_Pos = 0x9
	// Bit mask of GU field.
	Ethernet_MACPMTCSR_GU_Msk = 0x200
	// Bit GU.
	Ethernet_MACPMTCSR_GU = 0x200
	// Normal operation
	Ethernet_MACPMTCSR_GU_Disabled = 0x0
	// Any unicast packet filtered by the MAC address recognition may be a wakeup frame
	Ethernet_MACPMTCSR_GU_Enabled = 0x1
	// Position of WFFRPR field.
	Ethernet_MACPMTCSR_WFFRPR_Pos = 0x1f
	// Bit mask of WFFRPR field.
	Ethernet_MACPMTCSR_WFFRPR_Msk = 0x80000000
	// Bit WFFRPR.
	Ethernet_MACPMTCSR_WFFRPR = 0x80000000
	// Reset wakeup frame filter register point to 0b000. Automatically cleared
	Ethernet_MACPMTCSR_WFFRPR_Reset = 0x1

	// MACDBGR: Ethernet MAC debug register
	// Position of TFF field.
	Ethernet_MACDBGR_TFF_Pos = 0x19
	// Bit mask of TFF field.
	Ethernet_MACDBGR_TFF_Msk = 0x2000000
	// Bit TFF.
	Ethernet_MACDBGR_TFF = 0x2000000
	// Position of TFNE field.
	Ethernet_MACDBGR_TFNE_Pos = 0x18
	// Bit mask of TFNE field.
	Ethernet_MACDBGR_TFNE_Msk = 0x1000000
	// Bit TFNE.
	Ethernet_MACDBGR_TFNE = 0x1000000
	// Position of TFWA field.
	Ethernet_MACDBGR_TFWA_Pos = 0x16
	// Bit mask of TFWA field.
	Ethernet_MACDBGR_TFWA_Msk = 0x400000
	// Bit TFWA.
	Ethernet_MACDBGR_TFWA = 0x400000
	// Position of TFRS field.
	Ethernet_MACDBGR_TFRS_Pos = 0x14
	// Bit mask of TFRS field.
	Ethernet_MACDBGR_TFRS_Msk = 0x300000
	// Position of MTP field.
	Ethernet_MACDBGR_MTP_Pos = 0x13
	// Bit mask of MTP field.
	Ethernet_MACDBGR_MTP_Msk = 0x80000
	// Bit MTP.
	Ethernet_MACDBGR_MTP = 0x80000
	// Position of MTFCS field.
	Ethernet_MACDBGR_MTFCS_Pos = 0x11
	// Bit mask of MTFCS field.
	Ethernet_MACDBGR_MTFCS_Msk = 0x60000
	// Position of MMTEA field.
	Ethernet_MACDBGR_MMTEA_Pos = 0x10
	// Bit mask of MMTEA field.
	Ethernet_MACDBGR_MMTEA_Msk = 0x10000
	// Bit MMTEA.
	Ethernet_MACDBGR_MMTEA = 0x10000
	// Position of RFFL field.
	Ethernet_MACDBGR_RFFL_Pos = 0x8
	// Bit mask of RFFL field.
	Ethernet_MACDBGR_RFFL_Msk = 0x300
	// Position of RFRCS field.
	Ethernet_MACDBGR_RFRCS_Pos = 0x5
	// Bit mask of RFRCS field.
	Ethernet_MACDBGR_RFRCS_Msk = 0x60
	// Position of RFWRA field.
	Ethernet_MACDBGR_RFWRA_Pos = 0x4
	// Bit mask of RFWRA field.
	Ethernet_MACDBGR_RFWRA_Msk = 0x10
	// Bit RFWRA.
	Ethernet_MACDBGR_RFWRA = 0x10
	// Position of MSFRWCS field.
	Ethernet_MACDBGR_MSFRWCS_Pos = 0x1
	// Bit mask of MSFRWCS field.
	Ethernet_MACDBGR_MSFRWCS_Msk = 0x6
	// Position of MMRPEA field.
	Ethernet_MACDBGR_MMRPEA_Pos = 0x0
	// Bit mask of MMRPEA field.
	Ethernet_MACDBGR_MMRPEA_Msk = 0x1
	// Bit MMRPEA.
	Ethernet_MACDBGR_MMRPEA = 0x1

	// MACSR: Ethernet MAC interrupt status register
	// Position of PMTS field.
	Ethernet_MACSR_PMTS_Pos = 0x3
	// Bit mask of PMTS field.
	Ethernet_MACSR_PMTS_Msk = 0x8
	// Bit PMTS.
	Ethernet_MACSR_PMTS = 0x8
	// Position of MMCS field.
	Ethernet_MACSR_MMCS_Pos = 0x4
	// Bit mask of MMCS field.
	Ethernet_MACSR_MMCS_Msk = 0x10
	// Bit MMCS.
	Ethernet_MACSR_MMCS = 0x10
	// Position of MMCRS field.
	Ethernet_MACSR_MMCRS_Pos = 0x5
	// Bit mask of MMCRS field.
	Ethernet_MACSR_MMCRS_Msk = 0x20
	// Bit MMCRS.
	Ethernet_MACSR_MMCRS = 0x20
	// Position of MMCTS field.
	Ethernet_MACSR_MMCTS_Pos = 0x6
	// Bit mask of MMCTS field.
	Ethernet_MACSR_MMCTS_Msk = 0x40
	// Bit MMCTS.
	Ethernet_MACSR_MMCTS = 0x40
	// Position of TSTS field.
	Ethernet_MACSR_TSTS_Pos = 0x9
	// Bit mask of TSTS field.
	Ethernet_MACSR_TSTS_Msk = 0x200
	// Bit TSTS.
	Ethernet_MACSR_TSTS = 0x200

	// MACIMR: Ethernet MAC interrupt mask register
	// Position of PMTIM field.
	Ethernet_MACIMR_PMTIM_Pos = 0x3
	// Bit mask of PMTIM field.
	Ethernet_MACIMR_PMTIM_Msk = 0x8
	// Bit PMTIM.
	Ethernet_MACIMR_PMTIM = 0x8
	// PMT Status interrupt generation enabled
	Ethernet_MACIMR_PMTIM_Unmasked = 0x0
	// PMT Status interrupt generation disabled
	Ethernet_MACIMR_PMTIM_Masked = 0x1
	// Position of TSTIM field.
	Ethernet_MACIMR_TSTIM_Pos = 0x9
	// Bit mask of TSTIM field.
	Ethernet_MACIMR_TSTIM_Msk = 0x200
	// Bit TSTIM.
	Ethernet_MACIMR_TSTIM = 0x200
	// Time stamp interrupt generation enabled
	Ethernet_MACIMR_TSTIM_Unmasked = 0x0
	// Time stamp interrupt generation disabled
	Ethernet_MACIMR_TSTIM_Masked = 0x1

	// MACA0HR: Ethernet MAC address 0 high register
	// Position of MACA0H field.
	Ethernet_MACA0HR_MACA0H_Pos = 0x0
	// Bit mask of MACA0H field.
	Ethernet_MACA0HR_MACA0H_Msk = 0xffff
	// Position of MO field.
	Ethernet_MACA0HR_MO_Pos = 0x1f
	// Bit mask of MO field.
	Ethernet_MACA0HR_MO_Msk = 0x80000000
	// Bit MO.
	Ethernet_MACA0HR_MO = 0x80000000

	// MACA0LR: Ethernet MAC address 0 low register
	// Position of MACA0L field.
	Ethernet_MACA0LR_MACA0L_Pos = 0x0
	// Bit mask of MACA0L field.
	Ethernet_MACA0LR_MACA0L_Msk = 0xffffffff

	// MACA1HR: Ethernet MAC address 1 high register
	// Position of MACA1H field.
	Ethernet_MACA1HR_MACA1H_Pos = 0x0
	// Bit mask of MACA1H field.
	Ethernet_MACA1HR_MACA1H_Msk = 0xffff
	// Position of MBC field.
	Ethernet_MACA1HR_MBC_Pos = 0x18
	// Bit mask of MBC field.
	Ethernet_MACA1HR_MBC_Msk = 0x3f000000
	// Position of SA field.
	Ethernet_MACA1HR_SA_Pos = 0x1e
	// Bit mask of SA field.
	Ethernet_MACA1HR_SA_Msk = 0x40000000
	// Bit SA.
	Ethernet_MACA1HR_SA = 0x40000000
	// This address is used for comparison with DA fields of the received frame
	Ethernet_MACA1HR_SA_Destination = 0x0
	// This address is used for comparison with SA fields of received frames
	Ethernet_MACA1HR_SA_Source = 0x1
	// Position of AE field.
	Ethernet_MACA1HR_AE_Pos = 0x1f
	// Bit mask of AE field.
	Ethernet_MACA1HR_AE_Msk = 0x80000000
	// Bit AE.
	Ethernet_MACA1HR_AE = 0x80000000
	// Address filters ignore this address
	Ethernet_MACA1HR_AE_Disabled = 0x0
	// Address filters use this address
	Ethernet_MACA1HR_AE_Enabled = 0x1

	// MACA1LR: Ethernet MAC address1 low register
	// Position of MACA1L field.
	Ethernet_MACA1LR_MACA1L_Pos = 0x0
	// Bit mask of MACA1L field.
	Ethernet_MACA1LR_MACA1L_Msk = 0xffffffff

	// MACA2HR: Ethernet MAC address 2 high register
	// Position of MACA2H field.
	Ethernet_MACA2HR_MACA2H_Pos = 0x0
	// Bit mask of MACA2H field.
	Ethernet_MACA2HR_MACA2H_Msk = 0xffff
	// Position of MBC field.
	Ethernet_MACA2HR_MBC_Pos = 0x18
	// Bit mask of MBC field.
	Ethernet_MACA2HR_MBC_Msk = 0x3f000000
	// Position of SA field.
	Ethernet_MACA2HR_SA_Pos = 0x1e
	// Bit mask of SA field.
	Ethernet_MACA2HR_SA_Msk = 0x40000000
	// Bit SA.
	Ethernet_MACA2HR_SA = 0x40000000
	// This address is used for comparison with DA fields of the received frame
	Ethernet_MACA2HR_SA_Destination = 0x0
	// This address is used for comparison with SA fields of received frames
	Ethernet_MACA2HR_SA_Source = 0x1
	// Position of AE field.
	Ethernet_MACA2HR_AE_Pos = 0x1f
	// Bit mask of AE field.
	Ethernet_MACA2HR_AE_Msk = 0x80000000
	// Bit AE.
	Ethernet_MACA2HR_AE = 0x80000000
	// Address filters ignore this address
	Ethernet_MACA2HR_AE_Disabled = 0x0
	// Address filters use this address
	Ethernet_MACA2HR_AE_Enabled = 0x1

	// MACA2LR: Ethernet MAC address 2 low register
	// Position of MACA2L field.
	Ethernet_MACA2LR_MACA2L_Pos = 0x0
	// Bit mask of MACA2L field.
	Ethernet_MACA2LR_MACA2L_Msk = 0xffffffff

	// MACA3HR: Ethernet MAC address 3 high register
	// Position of MACA3H field.
	Ethernet_MACA3HR_MACA3H_Pos = 0x0
	// Bit mask of MACA3H field.
	Ethernet_MACA3HR_MACA3H_Msk = 0xffff
	// Position of MBC field.
	Ethernet_MACA3HR_MBC_Pos = 0x18
	// Bit mask of MBC field.
	Ethernet_MACA3HR_MBC_Msk = 0x3f000000
	// Position of SA field.
	Ethernet_MACA3HR_SA_Pos = 0x1e
	// Bit mask of SA field.
	Ethernet_MACA3HR_SA_Msk = 0x40000000
	// Bit SA.
	Ethernet_MACA3HR_SA = 0x40000000
	// This address is used for comparison with DA fields of the received frame
	Ethernet_MACA3HR_SA_Destination = 0x0
	// This address is used for comparison with SA fields of received frames
	Ethernet_MACA3HR_SA_Source = 0x1
	// Position of AE field.
	Ethernet_MACA3HR_AE_Pos = 0x1f
	// Bit mask of AE field.
	Ethernet_MACA3HR_AE_Msk = 0x80000000
	// Bit AE.
	Ethernet_MACA3HR_AE = 0x80000000
	// Address filters ignore this address
	Ethernet_MACA3HR_AE_Disabled = 0x0
	// Address filters use this address
	Ethernet_MACA3HR_AE_Enabled = 0x1

	// MACA3LR: Ethernet MAC address 3 low register
	// Position of MACA3L field.
	Ethernet_MACA3LR_MACA3L_Pos = 0x0
	// Bit mask of MACA3L field.
	Ethernet_MACA3LR_MACA3L_Msk = 0xffffffff
)

// Bitfields for CRC: Cryptographic processor
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// DR8: Data register - byte sized
	// Position of DR8 field.
	CRC_DR8_DR8_Pos = 0x0
	// Bit mask of DR8 field.
	CRC_DR8_DR8_Msk = 0xff

	// DR16: Data register - half-word sized
	// Position of DR16 field.
	CRC_DR16_DR16_Pos = 0x0
	// Bit mask of DR16 field.
	CRC_DR16_DR16_Msk = 0xffff

	// IDR: Independent Data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CR_REV_OUT_Normal = 0x0
	// Bit reversed output
	CRC_CR_REV_OUT_Reversed = 0x1
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CR_REV_IN_Normal = 0x0
	// Bit reversal done by byte
	CRC_CR_REV_IN_Byte = 0x1
	// Bit reversal done by half-word
	CRC_CR_REV_IN_HalfWord = 0x2
	// Bit reversal done by word
	CRC_CR_REV_IN_Word = 0x3
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// 32-bit polynomial
	CRC_CR_POLYSIZE_Polysize32 = 0x0
	// 16-bit polynomial
	CRC_CR_POLYSIZE_Polysize16 = 0x1
	// 8-bit polynomial
	CRC_CR_POLYSIZE_Polysize8 = 0x2
	// 7-bit polynomial
	CRC_CR_POLYSIZE_Polysize7 = 0x3

	// INIT: Initial CRC value
	// Position of INIT field.
	CRC_INIT_INIT_Pos = 0x0
	// Bit mask of INIT field.
	CRC_INIT_INIT_Msk = 0xffffffff

	// POL: CRC polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Bitfields for CAN1: Controller area network
const (
	// MCR: master control register
	// Position of DBF field.
	CAN_MCR_DBF_Pos = 0x10
	// Bit mask of DBF field.
	CAN_MCR_DBF_Msk = 0x10000
	// Bit DBF.
	CAN_MCR_DBF = 0x10000
	// Position of RESET field.
	CAN_MCR_RESET_Pos = 0xf
	// Bit mask of RESET field.
	CAN_MCR_RESET_Msk = 0x8000
	// Bit RESET.
	CAN_MCR_RESET = 0x8000
	// Position of TTCM field.
	CAN_MCR_TTCM_Pos = 0x7
	// Bit mask of TTCM field.
	CAN_MCR_TTCM_Msk = 0x80
	// Bit TTCM.
	CAN_MCR_TTCM = 0x80
	// Position of ABOM field.
	CAN_MCR_ABOM_Pos = 0x6
	// Bit mask of ABOM field.
	CAN_MCR_ABOM_Msk = 0x40
	// Bit ABOM.
	CAN_MCR_ABOM = 0x40
	// Position of AWUM field.
	CAN_MCR_AWUM_Pos = 0x5
	// Bit mask of AWUM field.
	CAN_MCR_AWUM_Msk = 0x20
	// Bit AWUM.
	CAN_MCR_AWUM = 0x20
	// Position of NART field.
	CAN_MCR_NART_Pos = 0x4
	// Bit mask of NART field.
	CAN_MCR_NART_Msk = 0x10
	// Bit NART.
	CAN_MCR_NART = 0x10
	// Position of RFLM field.
	CAN_MCR_RFLM_Pos = 0x3
	// Bit mask of RFLM field.
	CAN_MCR_RFLM_Msk = 0x8
	// Bit RFLM.
	CAN_MCR_RFLM = 0x8
	// Position of TXFP field.
	CAN_MCR_TXFP_Pos = 0x2
	// Bit mask of TXFP field.
	CAN_MCR_TXFP_Msk = 0x4
	// Bit TXFP.
	CAN_MCR_TXFP = 0x4
	// Position of SLEEP field.
	CAN_MCR_SLEEP_Pos = 0x1
	// Bit mask of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2
	// Bit SLEEP.
	CAN_MCR_SLEEP = 0x2
	// Position of INRQ field.
	CAN_MCR_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	CAN_MCR_INRQ_Msk = 0x1
	// Bit INRQ.
	CAN_MCR_INRQ = 0x1

	// MSR: master status register
	// Position of RX field.
	CAN_MSR_RX_Pos = 0xb
	// Bit mask of RX field.
	CAN_MSR_RX_Msk = 0x800
	// Bit RX.
	CAN_MSR_RX = 0x800
	// Position of SAMP field.
	CAN_MSR_SAMP_Pos = 0xa
	// Bit mask of SAMP field.
	CAN_MSR_SAMP_Msk = 0x400
	// Bit SAMP.
	CAN_MSR_SAMP = 0x400
	// Position of RXM field.
	CAN_MSR_RXM_Pos = 0x9
	// Bit mask of RXM field.
	CAN_MSR_RXM_Msk = 0x200
	// Bit RXM.
	CAN_MSR_RXM = 0x200
	// Position of TXM field.
	CAN_MSR_TXM_Pos = 0x8
	// Bit mask of TXM field.
	CAN_MSR_TXM_Msk = 0x100
	// Bit TXM.
	CAN_MSR_TXM = 0x100
	// Position of SLAKI field.
	CAN_MSR_SLAKI_Pos = 0x4
	// Bit mask of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10
	// Bit SLAKI.
	CAN_MSR_SLAKI = 0x10
	// Position of WKUI field.
	CAN_MSR_WKUI_Pos = 0x3
	// Bit mask of WKUI field.
	CAN_MSR_WKUI_Msk = 0x8
	// Bit WKUI.
	CAN_MSR_WKUI = 0x8
	// Position of ERRI field.
	CAN_MSR_ERRI_Pos = 0x2
	// Bit mask of ERRI field.
	CAN_MSR_ERRI_Msk = 0x4
	// Bit ERRI.
	CAN_MSR_ERRI = 0x4
	// Position of SLAK field.
	CAN_MSR_SLAK_Pos = 0x1
	// Bit mask of SLAK field.
	CAN_MSR_SLAK_Msk = 0x2
	// Bit SLAK.
	CAN_MSR_SLAK = 0x2
	// Position of INAK field.
	CAN_MSR_INAK_Pos = 0x0
	// Bit mask of INAK field.
	CAN_MSR_INAK_Msk = 0x1
	// Bit INAK.
	CAN_MSR_INAK = 0x1

	// TSR: transmit status register
	// Position of LOW2 field.
	CAN_TSR_LOW2_Pos = 0x1f
	// Bit mask of LOW2 field.
	CAN_TSR_LOW2_Msk = 0x80000000
	// Bit LOW2.
	CAN_TSR_LOW2 = 0x80000000
	// Position of LOW1 field.
	CAN_TSR_LOW1_Pos = 0x1e
	// Bit mask of LOW1 field.
	CAN_TSR_LOW1_Msk = 0x40000000
	// Bit LOW1.
	CAN_TSR_LOW1 = 0x40000000
	// Position of LOW0 field.
	CAN_TSR_LOW0_Pos = 0x1d
	// Bit mask of LOW0 field.
	CAN_TSR_LOW0_Msk = 0x20000000
	// Bit LOW0.
	CAN_TSR_LOW0 = 0x20000000
	// Position of TME2 field.
	CAN_TSR_TME2_Pos = 0x1c
	// Bit mask of TME2 field.
	CAN_TSR_TME2_Msk = 0x10000000
	// Bit TME2.
	CAN_TSR_TME2 = 0x10000000
	// Position of TME1 field.
	CAN_TSR_TME1_Pos = 0x1b
	// Bit mask of TME1 field.
	CAN_TSR_TME1_Msk = 0x8000000
	// Bit TME1.
	CAN_TSR_TME1 = 0x8000000
	// Position of TME0 field.
	CAN_TSR_TME0_Pos = 0x1a
	// Bit mask of TME0 field.
	CAN_TSR_TME0_Msk = 0x4000000
	// Bit TME0.
	CAN_TSR_TME0 = 0x4000000
	// Position of CODE field.
	CAN_TSR_CODE_Pos = 0x18
	// Bit mask of CODE field.
	CAN_TSR_CODE_Msk = 0x3000000
	// Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Pos = 0x17
	// Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000
	// Bit ABRQ2.
	CAN_TSR_ABRQ2 = 0x800000
	// Position of TERR2 field.
	CAN_TSR_TERR2_Pos = 0x13
	// Bit mask of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000
	// Bit TERR2.
	CAN_TSR_TERR2 = 0x80000
	// Position of ALST2 field.
	CAN_TSR_ALST2_Pos = 0x12
	// Bit mask of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000
	// Bit ALST2.
	CAN_TSR_ALST2 = 0x40000
	// Position of TXOK2 field.
	CAN_TSR_TXOK2_Pos = 0x11
	// Bit mask of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000
	// Bit TXOK2.
	CAN_TSR_TXOK2 = 0x20000
	// Position of RQCP2 field.
	CAN_TSR_RQCP2_Pos = 0x10
	// Bit mask of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000
	// Bit RQCP2.
	CAN_TSR_RQCP2 = 0x10000
	// Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Pos = 0xf
	// Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000
	// Bit ABRQ1.
	CAN_TSR_ABRQ1 = 0x8000
	// Position of TERR1 field.
	CAN_TSR_TERR1_Pos = 0xb
	// Bit mask of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800
	// Bit TERR1.
	CAN_TSR_TERR1 = 0x800
	// Position of ALST1 field.
	CAN_TSR_ALST1_Pos = 0xa
	// Bit mask of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400
	// Bit ALST1.
	CAN_TSR_ALST1 = 0x400
	// Position of TXOK1 field.
	CAN_TSR_TXOK1_Pos = 0x9
	// Bit mask of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200
	// Bit TXOK1.
	CAN_TSR_TXOK1 = 0x200
	// Position of RQCP1 field.
	CAN_TSR_RQCP1_Pos = 0x8
	// Bit mask of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100
	// Bit RQCP1.
	CAN_TSR_RQCP1 = 0x100
	// Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Pos = 0x7
	// Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80
	// Bit ABRQ0.
	CAN_TSR_ABRQ0 = 0x80
	// Position of TERR0 field.
	CAN_TSR_TERR0_Pos = 0x3
	// Bit mask of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8
	// Bit TERR0.
	CAN_TSR_TERR0 = 0x8
	// Position of ALST0 field.
	CAN_TSR_ALST0_Pos = 0x2
	// Bit mask of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4
	// Bit ALST0.
	CAN_TSR_ALST0 = 0x4
	// Position of TXOK0 field.
	CAN_TSR_TXOK0_Pos = 0x1
	// Bit mask of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2
	// Bit TXOK0.
	CAN_TSR_TXOK0 = 0x2
	// Position of RQCP0 field.
	CAN_TSR_RQCP0_Pos = 0x0
	// Bit mask of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1
	// Bit RQCP0.
	CAN_TSR_RQCP0 = 0x1

	// RF0R: receive FIFO 0 register
	// Position of RFOM field.
	CAN_RFR_RFOM_Pos = 0x5
	// Bit mask of RFOM field.
	CAN_RFR_RFOM_Msk = 0x20
	// Bit RFOM.
	CAN_RFR_RFOM = 0x20
	// Set by software to release the output mailbox of the FIFO
	CAN_RFR_RFOM_Release = 0x1
	// Position of FOVR field.
	CAN_RFR_FOVR_Pos = 0x4
	// Bit mask of FOVR field.
	CAN_RFR_FOVR_Msk = 0x10
	// Bit FOVR.
	CAN_RFR_FOVR = 0x10
	// No FIFO x overrun
	CAN_RFR_FOVR_NoOverrun = 0x0
	// FIFO x overrun
	CAN_RFR_FOVR_Overrun = 0x1
	// Clear flag
	CAN_RFR_FOVR_Clear = 0x1
	// Position of FULL field.
	CAN_RFR_FULL_Pos = 0x3
	// Bit mask of FULL field.
	CAN_RFR_FULL_Msk = 0x8
	// Bit FULL.
	CAN_RFR_FULL = 0x8
	// FIFO x is not full
	CAN_RFR_FULL_NotFull = 0x0
	// FIFO x is full
	CAN_RFR_FULL_Full = 0x1
	// Clear flag
	CAN_RFR_FULL_Clear = 0x1
	// Position of FMP field.
	CAN_RFR_FMP_Pos = 0x0
	// Bit mask of FMP field.
	CAN_RFR_FMP_Msk = 0x3

	// IER: interrupt enable register
	// Position of SLKIE field.
	CAN_IER_SLKIE_Pos = 0x11
	// Bit mask of SLKIE field.
	CAN_IER_SLKIE_Msk = 0x20000
	// Bit SLKIE.
	CAN_IER_SLKIE = 0x20000
	// No interrupt when SLAKI bit is set
	CAN_IER_SLKIE_Disabled = 0x0
	// Interrupt generated when SLAKI bit is set
	CAN_IER_SLKIE_Enabled = 0x1
	// Position of WKUIE field.
	CAN_IER_WKUIE_Pos = 0x10
	// Bit mask of WKUIE field.
	CAN_IER_WKUIE_Msk = 0x10000
	// Bit WKUIE.
	CAN_IER_WKUIE = 0x10000
	// No interrupt when WKUI is set
	CAN_IER_WKUIE_Disabled = 0x0
	// Interrupt generated when WKUI bit is set
	CAN_IER_WKUIE_Enabled = 0x1
	// Position of ERRIE field.
	CAN_IER_ERRIE_Pos = 0xf
	// Bit mask of ERRIE field.
	CAN_IER_ERRIE_Msk = 0x8000
	// Bit ERRIE.
	CAN_IER_ERRIE = 0x8000
	// No interrupt will be generated when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Disabled = 0x0
	// An interrupt will be generation when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Enabled = 0x1
	// Position of LECIE field.
	CAN_IER_LECIE_Pos = 0xb
	// Bit mask of LECIE field.
	CAN_IER_LECIE_Msk = 0x800
	// Bit LECIE.
	CAN_IER_LECIE = 0x800
	// ERRI bit will not be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Disabled = 0x0
	// ERRI bit will be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Enabled = 0x1
	// Position of BOFIE field.
	CAN_IER_BOFIE_Pos = 0xa
	// Bit mask of BOFIE field.
	CAN_IER_BOFIE_Msk = 0x400
	// Bit BOFIE.
	CAN_IER_BOFIE = 0x400
	// ERRI bit will not be set when BOFF is set
	CAN_IER_BOFIE_Disabled = 0x0
	// ERRI bit will be set when BOFF is set
	CAN_IER_BOFIE_Enabled = 0x1
	// Position of EPVIE field.
	CAN_IER_EPVIE_Pos = 0x9
	// Bit mask of EPVIE field.
	CAN_IER_EPVIE_Msk = 0x200
	// Bit EPVIE.
	CAN_IER_EPVIE = 0x200
	// ERRI bit will not be set when EPVF is set
	CAN_IER_EPVIE_Disabled = 0x0
	// ERRI bit will be set when EPVF is set
	CAN_IER_EPVIE_Enabled = 0x1
	// Position of EWGIE field.
	CAN_IER_EWGIE_Pos = 0x8
	// Bit mask of EWGIE field.
	CAN_IER_EWGIE_Msk = 0x100
	// Bit EWGIE.
	CAN_IER_EWGIE = 0x100
	// ERRI bit will not be set when EWGF is set
	CAN_IER_EWGIE_Disabled = 0x0
	// ERRI bit will be set when EWGF is set
	CAN_IER_EWGIE_Enabled = 0x1
	// Position of FOVIE1 field.
	CAN_IER_FOVIE1_Pos = 0x6
	// Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40
	// Bit FOVIE1.
	CAN_IER_FOVIE1 = 0x40
	// No interrupt when FOVR is set
	CAN_IER_FOVIE1_Disabled = 0x0
	// Interrupt generation when FOVR is set
	CAN_IER_FOVIE1_Enabled = 0x1
	// Position of FFIE1 field.
	CAN_IER_FFIE1_Pos = 0x5
	// Bit mask of FFIE1 field.
	CAN_IER_FFIE1_Msk = 0x20
	// Bit FFIE1.
	CAN_IER_FFIE1 = 0x20
	// No interrupt when FULL bit is set
	CAN_IER_FFIE1_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE1_Enabled = 0x1
	// Position of FMPIE1 field.
	CAN_IER_FMPIE1_Pos = 0x4
	// Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10
	// Bit FMPIE1.
	CAN_IER_FMPIE1 = 0x10
	// No interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Enabled = 0x1
	// Position of FOVIE0 field.
	CAN_IER_FOVIE0_Pos = 0x3
	// Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8
	// Bit FOVIE0.
	CAN_IER_FOVIE0 = 0x8
	// No interrupt when FOVR bit is set
	CAN_IER_FOVIE0_Disabled = 0x0
	// Interrupt generated when FOVR bit is set
	CAN_IER_FOVIE0_Enabled = 0x1
	// Position of FFIE0 field.
	CAN_IER_FFIE0_Pos = 0x2
	// Bit mask of FFIE0 field.
	CAN_IER_FFIE0_Msk = 0x4
	// Bit FFIE0.
	CAN_IER_FFIE0 = 0x4
	// No interrupt when FULL bit is set
	CAN_IER_FFIE0_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE0_Enabled = 0x1
	// Position of FMPIE0 field.
	CAN_IER_FMPIE0_Pos = 0x1
	// Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2
	// Bit FMPIE0.
	CAN_IER_FMPIE0 = 0x2
	// No interrupt generated when state of FMP[1:0] bits are not 00
	CAN_IER_FMPIE0_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE0_Enabled = 0x1
	// Position of TMEIE field.
	CAN_IER_TMEIE_Pos = 0x0
	// Bit mask of TMEIE field.
	CAN_IER_TMEIE_Msk = 0x1
	// Bit TMEIE.
	CAN_IER_TMEIE = 0x1
	// No interrupt when RQCPx bit is set
	CAN_IER_TMEIE_Disabled = 0x0
	// Interrupt generated when RQCPx bit is set
	CAN_IER_TMEIE_Enabled = 0x1

	// ESR: interrupt enable register
	// Position of REC field.
	CAN_ESR_REC_Pos = 0x18
	// Bit mask of REC field.
	CAN_ESR_REC_Msk = 0xff000000
	// Position of TEC field.
	CAN_ESR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ESR_TEC_Msk = 0xff0000
	// Position of LEC field.
	CAN_ESR_LEC_Pos = 0x4
	// Bit mask of LEC field.
	CAN_ESR_LEC_Msk = 0x70
	// No Error
	CAN_ESR_LEC_NoError = 0x0
	// Stuff Error
	CAN_ESR_LEC_Stuff = 0x1
	// Form Error
	CAN_ESR_LEC_Form = 0x2
	// Acknowledgment Error
	CAN_ESR_LEC_Ack = 0x3
	// Bit recessive Error
	CAN_ESR_LEC_BitRecessive = 0x4
	// Bit dominant Error
	CAN_ESR_LEC_BitDominant = 0x5
	// CRC Error
	CAN_ESR_LEC_Crc = 0x6
	// Set by software
	CAN_ESR_LEC_Custom = 0x7
	// Position of BOFF field.
	CAN_ESR_BOFF_Pos = 0x2
	// Bit mask of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4
	// Bit BOFF.
	CAN_ESR_BOFF = 0x4
	// Position of EPVF field.
	CAN_ESR_EPVF_Pos = 0x1
	// Bit mask of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2
	// Bit EPVF.
	CAN_ESR_EPVF = 0x2
	// Position of EWGF field.
	CAN_ESR_EWGF_Pos = 0x0
	// Bit mask of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1
	// Bit EWGF.
	CAN_ESR_EWGF = 0x1

	// BTR: bit timing register
	// Position of SILM field.
	CAN_BTR_SILM_Pos = 0x1f
	// Bit mask of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000
	// Bit SILM.
	CAN_BTR_SILM = 0x80000000
	// Normal operation
	CAN_BTR_SILM_Normal = 0x0
	// Silent Mode
	CAN_BTR_SILM_Silent = 0x1
	// Position of LBKM field.
	CAN_BTR_LBKM_Pos = 0x1e
	// Bit mask of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000
	// Bit LBKM.
	CAN_BTR_LBKM = 0x40000000
	// Loop Back Mode disabled
	CAN_BTR_LBKM_Disabled = 0x0
	// Loop Back Mode enabled
	CAN_BTR_LBKM_Enabled = 0x1
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0x18
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0x3000000
	// Position of TS2 field.
	CAN_BTR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	CAN_BTR_TS2_Msk = 0x700000
	// Position of TS1 field.
	CAN_BTR_TS1_Pos = 0x10
	// Bit mask of TS1 field.
	CAN_BTR_TS1_Msk = 0xf0000
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff

	// TX.TIR: TX mailbox identifier register
	// Position of STID field.
	CAN_TX_TIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_TX_TIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_TX_TIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_TX_TIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_TX_TIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_TX_TIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_TX_TIR_IDE = 0x4
	// Standard identifier
	CAN_TX_TIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_TX_TIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_TX_TIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_TX_TIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_TX_TIR_RTR = 0x2
	// Data frame
	CAN_TX_TIR_RTR_Data = 0x0
	// Remote frame
	CAN_TX_TIR_RTR_Remote = 0x1
	// Position of TXRQ field.
	CAN_TX_TIR_TXRQ_Pos = 0x0
	// Bit mask of TXRQ field.
	CAN_TX_TIR_TXRQ_Msk = 0x1
	// Bit TXRQ.
	CAN_TX_TIR_TXRQ = 0x1

	// TX.TDTR: mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_TX_TDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_TX_TDTR_TIME_Msk = 0xffff0000
	// Position of TGT field.
	CAN_TX_TDTR_TGT_Pos = 0x8
	// Bit mask of TGT field.
	CAN_TX_TDTR_TGT_Msk = 0x100
	// Bit TGT.
	CAN_TX_TDTR_TGT = 0x100
	// Position of DLC field.
	CAN_TX_TDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_TX_TDTR_DLC_Msk = 0xf

	// TX.TDLR: mailbox data low register
	// Position of DATA3 field.
	CAN_TX_TDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_TX_TDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_TX_TDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_TX_TDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_TX_TDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_TX_TDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_TX_TDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_TX_TDLR_DATA0_Msk = 0xff

	// TX.TDHR: mailbox data high register
	// Position of DATA7 field.
	CAN_TX_TDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_TX_TDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_TX_TDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_TX_TDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_TX_TDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_TX_TDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_TX_TDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_TX_TDHR_DATA4_Msk = 0xff

	// RX.RIR: receive FIFO mailbox identifier register
	// Position of STID field.
	CAN_RX_RIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_RX_RIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_RX_RIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_RX_RIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_RX_RIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_RX_RIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_RX_RIR_IDE = 0x4
	// Standard identifier
	CAN_RX_RIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_RX_RIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_RX_RIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_RX_RIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_RX_RIR_RTR = 0x2
	// Data frame
	CAN_RX_RIR_RTR_Data = 0x0
	// Remote frame
	CAN_RX_RIR_RTR_Remote = 0x1

	// RX.RDTR: mailbox data high register
	// Position of TIME field.
	CAN_RX_RDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_RX_RDTR_TIME_Msk = 0xffff0000
	// Position of FMI field.
	CAN_RX_RDTR_FMI_Pos = 0x8
	// Bit mask of FMI field.
	CAN_RX_RDTR_FMI_Msk = 0xff00
	// Position of DLC field.
	CAN_RX_RDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_RX_RDTR_DLC_Msk = 0xf

	// RX.RDLR: mailbox data high register
	// Position of DATA3 field.
	CAN_RX_RDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_RX_RDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_RX_RDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_RX_RDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_RX_RDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_RX_RDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_RX_RDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_RX_RDLR_DATA0_Msk = 0xff

	// RX.RDHR: receive FIFO mailbox data high register
	// Position of DATA7 field.
	CAN_RX_RDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_RX_RDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_RX_RDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_RX_RDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_RX_RDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_RX_RDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_RX_RDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_RX_RDHR_DATA4_Msk = 0xff

	// FMR: filter master register
	// Position of CAN2SB field.
	CAN_FMR_CAN2SB_Pos = 0x8
	// Bit mask of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00
	// Position of FINIT field.
	CAN_FMR_FINIT_Pos = 0x0
	// Bit mask of FINIT field.
	CAN_FMR_FINIT_Msk = 0x1
	// Bit FINIT.
	CAN_FMR_FINIT = 0x1

	// FM1R: filter mode register
	// Position of FBM0 field.
	CAN_FM1R_FBM0_Pos = 0x0
	// Bit mask of FBM0 field.
	CAN_FM1R_FBM0_Msk = 0x1
	// Bit FBM0.
	CAN_FM1R_FBM0 = 0x1
	// Position of FBM1 field.
	CAN_FM1R_FBM1_Pos = 0x1
	// Bit mask of FBM1 field.
	CAN_FM1R_FBM1_Msk = 0x2
	// Bit FBM1.
	CAN_FM1R_FBM1 = 0x2
	// Position of FBM2 field.
	CAN_FM1R_FBM2_Pos = 0x2
	// Bit mask of FBM2 field.
	CAN_FM1R_FBM2_Msk = 0x4
	// Bit FBM2.
	CAN_FM1R_FBM2 = 0x4
	// Position of FBM3 field.
	CAN_FM1R_FBM3_Pos = 0x3
	// Bit mask of FBM3 field.
	CAN_FM1R_FBM3_Msk = 0x8
	// Bit FBM3.
	CAN_FM1R_FBM3 = 0x8
	// Position of FBM4 field.
	CAN_FM1R_FBM4_Pos = 0x4
	// Bit mask of FBM4 field.
	CAN_FM1R_FBM4_Msk = 0x10
	// Bit FBM4.
	CAN_FM1R_FBM4 = 0x10
	// Position of FBM5 field.
	CAN_FM1R_FBM5_Pos = 0x5
	// Bit mask of FBM5 field.
	CAN_FM1R_FBM5_Msk = 0x20
	// Bit FBM5.
	CAN_FM1R_FBM5 = 0x20
	// Position of FBM6 field.
	CAN_FM1R_FBM6_Pos = 0x6
	// Bit mask of FBM6 field.
	CAN_FM1R_FBM6_Msk = 0x40
	// Bit FBM6.
	CAN_FM1R_FBM6 = 0x40
	// Position of FBM7 field.
	CAN_FM1R_FBM7_Pos = 0x7
	// Bit mask of FBM7 field.
	CAN_FM1R_FBM7_Msk = 0x80
	// Bit FBM7.
	CAN_FM1R_FBM7 = 0x80
	// Position of FBM8 field.
	CAN_FM1R_FBM8_Pos = 0x8
	// Bit mask of FBM8 field.
	CAN_FM1R_FBM8_Msk = 0x100
	// Bit FBM8.
	CAN_FM1R_FBM8 = 0x100
	// Position of FBM9 field.
	CAN_FM1R_FBM9_Pos = 0x9
	// Bit mask of FBM9 field.
	CAN_FM1R_FBM9_Msk = 0x200
	// Bit FBM9.
	CAN_FM1R_FBM9 = 0x200
	// Position of FBM10 field.
	CAN_FM1R_FBM10_Pos = 0xa
	// Bit mask of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400
	// Bit FBM10.
	CAN_FM1R_FBM10 = 0x400
	// Position of FBM11 field.
	CAN_FM1R_FBM11_Pos = 0xb
	// Bit mask of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800
	// Bit FBM11.
	CAN_FM1R_FBM11 = 0x800
	// Position of FBM12 field.
	CAN_FM1R_FBM12_Pos = 0xc
	// Bit mask of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000
	// Bit FBM12.
	CAN_FM1R_FBM12 = 0x1000
	// Position of FBM13 field.
	CAN_FM1R_FBM13_Pos = 0xd
	// Bit mask of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000
	// Bit FBM13.
	CAN_FM1R_FBM13 = 0x2000
	// Position of FBM14 field.
	CAN_FM1R_FBM14_Pos = 0xe
	// Bit mask of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000
	// Bit FBM14.
	CAN_FM1R_FBM14 = 0x4000
	// Position of FBM15 field.
	CAN_FM1R_FBM15_Pos = 0xf
	// Bit mask of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000
	// Bit FBM15.
	CAN_FM1R_FBM15 = 0x8000
	// Position of FBM16 field.
	CAN_FM1R_FBM16_Pos = 0x10
	// Bit mask of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000
	// Bit FBM16.
	CAN_FM1R_FBM16 = 0x10000
	// Position of FBM17 field.
	CAN_FM1R_FBM17_Pos = 0x11
	// Bit mask of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000
	// Bit FBM17.
	CAN_FM1R_FBM17 = 0x20000
	// Position of FBM18 field.
	CAN_FM1R_FBM18_Pos = 0x12
	// Bit mask of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000
	// Bit FBM18.
	CAN_FM1R_FBM18 = 0x40000
	// Position of FBM19 field.
	CAN_FM1R_FBM19_Pos = 0x13
	// Bit mask of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000
	// Bit FBM19.
	CAN_FM1R_FBM19 = 0x80000
	// Position of FBM20 field.
	CAN_FM1R_FBM20_Pos = 0x14
	// Bit mask of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000
	// Bit FBM20.
	CAN_FM1R_FBM20 = 0x100000
	// Position of FBM21 field.
	CAN_FM1R_FBM21_Pos = 0x15
	// Bit mask of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000
	// Bit FBM21.
	CAN_FM1R_FBM21 = 0x200000
	// Position of FBM22 field.
	CAN_FM1R_FBM22_Pos = 0x16
	// Bit mask of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000
	// Bit FBM22.
	CAN_FM1R_FBM22 = 0x400000
	// Position of FBM23 field.
	CAN_FM1R_FBM23_Pos = 0x17
	// Bit mask of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000
	// Bit FBM23.
	CAN_FM1R_FBM23 = 0x800000
	// Position of FBM24 field.
	CAN_FM1R_FBM24_Pos = 0x18
	// Bit mask of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000
	// Bit FBM24.
	CAN_FM1R_FBM24 = 0x1000000
	// Position of FBM25 field.
	CAN_FM1R_FBM25_Pos = 0x19
	// Bit mask of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000
	// Bit FBM25.
	CAN_FM1R_FBM25 = 0x2000000
	// Position of FBM26 field.
	CAN_FM1R_FBM26_Pos = 0x1a
	// Bit mask of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000
	// Bit FBM26.
	CAN_FM1R_FBM26 = 0x4000000
	// Position of FBM27 field.
	CAN_FM1R_FBM27_Pos = 0x1b
	// Bit mask of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000
	// Bit FBM27.
	CAN_FM1R_FBM27 = 0x8000000

	// FS1R: filter scale register
	// Position of FSC0 field.
	CAN_FS1R_FSC0_Pos = 0x0
	// Bit mask of FSC0 field.
	CAN_FS1R_FSC0_Msk = 0x1
	// Bit FSC0.
	CAN_FS1R_FSC0 = 0x1
	// Position of FSC1 field.
	CAN_FS1R_FSC1_Pos = 0x1
	// Bit mask of FSC1 field.
	CAN_FS1R_FSC1_Msk = 0x2
	// Bit FSC1.
	CAN_FS1R_FSC1 = 0x2
	// Position of FSC2 field.
	CAN_FS1R_FSC2_Pos = 0x2
	// Bit mask of FSC2 field.
	CAN_FS1R_FSC2_Msk = 0x4
	// Bit FSC2.
	CAN_FS1R_FSC2 = 0x4
	// Position of FSC3 field.
	CAN_FS1R_FSC3_Pos = 0x3
	// Bit mask of FSC3 field.
	CAN_FS1R_FSC3_Msk = 0x8
	// Bit FSC3.
	CAN_FS1R_FSC3 = 0x8
	// Position of FSC4 field.
	CAN_FS1R_FSC4_Pos = 0x4
	// Bit mask of FSC4 field.
	CAN_FS1R_FSC4_Msk = 0x10
	// Bit FSC4.
	CAN_FS1R_FSC4 = 0x10
	// Position of FSC5 field.
	CAN_FS1R_FSC5_Pos = 0x5
	// Bit mask of FSC5 field.
	CAN_FS1R_FSC5_Msk = 0x20
	// Bit FSC5.
	CAN_FS1R_FSC5 = 0x20
	// Position of FSC6 field.
	CAN_FS1R_FSC6_Pos = 0x6
	// Bit mask of FSC6 field.
	CAN_FS1R_FSC6_Msk = 0x40
	// Bit FSC6.
	CAN_FS1R_FSC6 = 0x40
	// Position of FSC7 field.
	CAN_FS1R_FSC7_Pos = 0x7
	// Bit mask of FSC7 field.
	CAN_FS1R_FSC7_Msk = 0x80
	// Bit FSC7.
	CAN_FS1R_FSC7 = 0x80
	// Position of FSC8 field.
	CAN_FS1R_FSC8_Pos = 0x8
	// Bit mask of FSC8 field.
	CAN_FS1R_FSC8_Msk = 0x100
	// Bit FSC8.
	CAN_FS1R_FSC8 = 0x100
	// Position of FSC9 field.
	CAN_FS1R_FSC9_Pos = 0x9
	// Bit mask of FSC9 field.
	CAN_FS1R_FSC9_Msk = 0x200
	// Bit FSC9.
	CAN_FS1R_FSC9 = 0x200
	// Position of FSC10 field.
	CAN_FS1R_FSC10_Pos = 0xa
	// Bit mask of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400
	// Bit FSC10.
	CAN_FS1R_FSC10 = 0x400
	// Position of FSC11 field.
	CAN_FS1R_FSC11_Pos = 0xb
	// Bit mask of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800
	// Bit FSC11.
	CAN_FS1R_FSC11 = 0x800
	// Position of FSC12 field.
	CAN_FS1R_FSC12_Pos = 0xc
	// Bit mask of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000
	// Bit FSC12.
	CAN_FS1R_FSC12 = 0x1000
	// Position of FSC13 field.
	CAN_FS1R_FSC13_Pos = 0xd
	// Bit mask of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000
	// Bit FSC13.
	CAN_FS1R_FSC13 = 0x2000
	// Position of FSC14 field.
	CAN_FS1R_FSC14_Pos = 0xe
	// Bit mask of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000
	// Bit FSC14.
	CAN_FS1R_FSC14 = 0x4000
	// Position of FSC15 field.
	CAN_FS1R_FSC15_Pos = 0xf
	// Bit mask of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000
	// Bit FSC15.
	CAN_FS1R_FSC15 = 0x8000
	// Position of FSC16 field.
	CAN_FS1R_FSC16_Pos = 0x10
	// Bit mask of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000
	// Bit FSC16.
	CAN_FS1R_FSC16 = 0x10000
	// Position of FSC17 field.
	CAN_FS1R_FSC17_Pos = 0x11
	// Bit mask of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000
	// Bit FSC17.
	CAN_FS1R_FSC17 = 0x20000
	// Position of FSC18 field.
	CAN_FS1R_FSC18_Pos = 0x12
	// Bit mask of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000
	// Bit FSC18.
	CAN_FS1R_FSC18 = 0x40000
	// Position of FSC19 field.
	CAN_FS1R_FSC19_Pos = 0x13
	// Bit mask of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000
	// Bit FSC19.
	CAN_FS1R_FSC19 = 0x80000
	// Position of FSC20 field.
	CAN_FS1R_FSC20_Pos = 0x14
	// Bit mask of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000
	// Bit FSC20.
	CAN_FS1R_FSC20 = 0x100000
	// Position of FSC21 field.
	CAN_FS1R_FSC21_Pos = 0x15
	// Bit mask of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000
	// Bit FSC21.
	CAN_FS1R_FSC21 = 0x200000
	// Position of FSC22 field.
	CAN_FS1R_FSC22_Pos = 0x16
	// Bit mask of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000
	// Bit FSC22.
	CAN_FS1R_FSC22 = 0x400000
	// Position of FSC23 field.
	CAN_FS1R_FSC23_Pos = 0x17
	// Bit mask of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000
	// Bit FSC23.
	CAN_FS1R_FSC23 = 0x800000
	// Position of FSC24 field.
	CAN_FS1R_FSC24_Pos = 0x18
	// Bit mask of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000
	// Bit FSC24.
	CAN_FS1R_FSC24 = 0x1000000
	// Position of FSC25 field.
	CAN_FS1R_FSC25_Pos = 0x19
	// Bit mask of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000
	// Bit FSC25.
	CAN_FS1R_FSC25 = 0x2000000
	// Position of FSC26 field.
	CAN_FS1R_FSC26_Pos = 0x1a
	// Bit mask of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000
	// Bit FSC26.
	CAN_FS1R_FSC26 = 0x4000000
	// Position of FSC27 field.
	CAN_FS1R_FSC27_Pos = 0x1b
	// Bit mask of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000
	// Bit FSC27.
	CAN_FS1R_FSC27 = 0x8000000

	// FFA1R: filter FIFO assignment register
	// Position of FFA0 field.
	CAN_FFA1R_FFA0_Pos = 0x0
	// Bit mask of FFA0 field.
	CAN_FFA1R_FFA0_Msk = 0x1
	// Bit FFA0.
	CAN_FFA1R_FFA0 = 0x1
	// Position of FFA1 field.
	CAN_FFA1R_FFA1_Pos = 0x1
	// Bit mask of FFA1 field.
	CAN_FFA1R_FFA1_Msk = 0x2
	// Bit FFA1.
	CAN_FFA1R_FFA1 = 0x2
	// Position of FFA2 field.
	CAN_FFA1R_FFA2_Pos = 0x2
	// Bit mask of FFA2 field.
	CAN_FFA1R_FFA2_Msk = 0x4
	// Bit FFA2.
	CAN_FFA1R_FFA2 = 0x4
	// Position of FFA3 field.
	CAN_FFA1R_FFA3_Pos = 0x3
	// Bit mask of FFA3 field.
	CAN_FFA1R_FFA3_Msk = 0x8
	// Bit FFA3.
	CAN_FFA1R_FFA3 = 0x8
	// Position of FFA4 field.
	CAN_FFA1R_FFA4_Pos = 0x4
	// Bit mask of FFA4 field.
	CAN_FFA1R_FFA4_Msk = 0x10
	// Bit FFA4.
	CAN_FFA1R_FFA4 = 0x10
	// Position of FFA5 field.
	CAN_FFA1R_FFA5_Pos = 0x5
	// Bit mask of FFA5 field.
	CAN_FFA1R_FFA5_Msk = 0x20
	// Bit FFA5.
	CAN_FFA1R_FFA5 = 0x20
	// Position of FFA6 field.
	CAN_FFA1R_FFA6_Pos = 0x6
	// Bit mask of FFA6 field.
	CAN_FFA1R_FFA6_Msk = 0x40
	// Bit FFA6.
	CAN_FFA1R_FFA6 = 0x40
	// Position of FFA7 field.
	CAN_FFA1R_FFA7_Pos = 0x7
	// Bit mask of FFA7 field.
	CAN_FFA1R_FFA7_Msk = 0x80
	// Bit FFA7.
	CAN_FFA1R_FFA7 = 0x80
	// Position of FFA8 field.
	CAN_FFA1R_FFA8_Pos = 0x8
	// Bit mask of FFA8 field.
	CAN_FFA1R_FFA8_Msk = 0x100
	// Bit FFA8.
	CAN_FFA1R_FFA8 = 0x100
	// Position of FFA9 field.
	CAN_FFA1R_FFA9_Pos = 0x9
	// Bit mask of FFA9 field.
	CAN_FFA1R_FFA9_Msk = 0x200
	// Bit FFA9.
	CAN_FFA1R_FFA9 = 0x200
	// Position of FFA10 field.
	CAN_FFA1R_FFA10_Pos = 0xa
	// Bit mask of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400
	// Bit FFA10.
	CAN_FFA1R_FFA10 = 0x400
	// Position of FFA11 field.
	CAN_FFA1R_FFA11_Pos = 0xb
	// Bit mask of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800
	// Bit FFA11.
	CAN_FFA1R_FFA11 = 0x800
	// Position of FFA12 field.
	CAN_FFA1R_FFA12_Pos = 0xc
	// Bit mask of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000
	// Bit FFA12.
	CAN_FFA1R_FFA12 = 0x1000
	// Position of FFA13 field.
	CAN_FFA1R_FFA13_Pos = 0xd
	// Bit mask of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000
	// Bit FFA13.
	CAN_FFA1R_FFA13 = 0x2000
	// Position of FFA14 field.
	CAN_FFA1R_FFA14_Pos = 0xe
	// Bit mask of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000
	// Bit FFA14.
	CAN_FFA1R_FFA14 = 0x4000
	// Position of FFA15 field.
	CAN_FFA1R_FFA15_Pos = 0xf
	// Bit mask of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000
	// Bit FFA15.
	CAN_FFA1R_FFA15 = 0x8000
	// Position of FFA16 field.
	CAN_FFA1R_FFA16_Pos = 0x10
	// Bit mask of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000
	// Bit FFA16.
	CAN_FFA1R_FFA16 = 0x10000
	// Position of FFA17 field.
	CAN_FFA1R_FFA17_Pos = 0x11
	// Bit mask of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000
	// Bit FFA17.
	CAN_FFA1R_FFA17 = 0x20000
	// Position of FFA18 field.
	CAN_FFA1R_FFA18_Pos = 0x12
	// Bit mask of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000
	// Bit FFA18.
	CAN_FFA1R_FFA18 = 0x40000
	// Position of FFA19 field.
	CAN_FFA1R_FFA19_Pos = 0x13
	// Bit mask of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000
	// Bit FFA19.
	CAN_FFA1R_FFA19 = 0x80000
	// Position of FFA20 field.
	CAN_FFA1R_FFA20_Pos = 0x14
	// Bit mask of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000
	// Bit FFA20.
	CAN_FFA1R_FFA20 = 0x100000
	// Position of FFA21 field.
	CAN_FFA1R_FFA21_Pos = 0x15
	// Bit mask of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000
	// Bit FFA21.
	CAN_FFA1R_FFA21 = 0x200000
	// Position of FFA22 field.
	CAN_FFA1R_FFA22_Pos = 0x16
	// Bit mask of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000
	// Bit FFA22.
	CAN_FFA1R_FFA22 = 0x400000
	// Position of FFA23 field.
	CAN_FFA1R_FFA23_Pos = 0x17
	// Bit mask of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000
	// Bit FFA23.
	CAN_FFA1R_FFA23 = 0x800000
	// Position of FFA24 field.
	CAN_FFA1R_FFA24_Pos = 0x18
	// Bit mask of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000
	// Bit FFA24.
	CAN_FFA1R_FFA24 = 0x1000000
	// Position of FFA25 field.
	CAN_FFA1R_FFA25_Pos = 0x19
	// Bit mask of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000
	// Bit FFA25.
	CAN_FFA1R_FFA25 = 0x2000000
	// Position of FFA26 field.
	CAN_FFA1R_FFA26_Pos = 0x1a
	// Bit mask of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000
	// Bit FFA26.
	CAN_FFA1R_FFA26 = 0x4000000
	// Position of FFA27 field.
	CAN_FFA1R_FFA27_Pos = 0x1b
	// Bit mask of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000
	// Bit FFA27.
	CAN_FFA1R_FFA27 = 0x8000000

	// FA1R: filter activation register
	// Position of FACT0 field.
	CAN_FA1R_FACT0_Pos = 0x0
	// Bit mask of FACT0 field.
	CAN_FA1R_FACT0_Msk = 0x1
	// Bit FACT0.
	CAN_FA1R_FACT0 = 0x1
	// Position of FACT1 field.
	CAN_FA1R_FACT1_Pos = 0x1
	// Bit mask of FACT1 field.
	CAN_FA1R_FACT1_Msk = 0x2
	// Bit FACT1.
	CAN_FA1R_FACT1 = 0x2
	// Position of FACT2 field.
	CAN_FA1R_FACT2_Pos = 0x2
	// Bit mask of FACT2 field.
	CAN_FA1R_FACT2_Msk = 0x4
	// Bit FACT2.
	CAN_FA1R_FACT2 = 0x4
	// Position of FACT3 field.
	CAN_FA1R_FACT3_Pos = 0x3
	// Bit mask of FACT3 field.
	CAN_FA1R_FACT3_Msk = 0x8
	// Bit FACT3.
	CAN_FA1R_FACT3 = 0x8
	// Position of FACT4 field.
	CAN_FA1R_FACT4_Pos = 0x4
	// Bit mask of FACT4 field.
	CAN_FA1R_FACT4_Msk = 0x10
	// Bit FACT4.
	CAN_FA1R_FACT4 = 0x10
	// Position of FACT5 field.
	CAN_FA1R_FACT5_Pos = 0x5
	// Bit mask of FACT5 field.
	CAN_FA1R_FACT5_Msk = 0x20
	// Bit FACT5.
	CAN_FA1R_FACT5 = 0x20
	// Position of FACT6 field.
	CAN_FA1R_FACT6_Pos = 0x6
	// Bit mask of FACT6 field.
	CAN_FA1R_FACT6_Msk = 0x40
	// Bit FACT6.
	CAN_FA1R_FACT6 = 0x40
	// Position of FACT7 field.
	CAN_FA1R_FACT7_Pos = 0x7
	// Bit mask of FACT7 field.
	CAN_FA1R_FACT7_Msk = 0x80
	// Bit FACT7.
	CAN_FA1R_FACT7 = 0x80
	// Position of FACT8 field.
	CAN_FA1R_FACT8_Pos = 0x8
	// Bit mask of FACT8 field.
	CAN_FA1R_FACT8_Msk = 0x100
	// Bit FACT8.
	CAN_FA1R_FACT8 = 0x100
	// Position of FACT9 field.
	CAN_FA1R_FACT9_Pos = 0x9
	// Bit mask of FACT9 field.
	CAN_FA1R_FACT9_Msk = 0x200
	// Bit FACT9.
	CAN_FA1R_FACT9 = 0x200
	// Position of FACT10 field.
	CAN_FA1R_FACT10_Pos = 0xa
	// Bit mask of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400
	// Bit FACT10.
	CAN_FA1R_FACT10 = 0x400
	// Position of FACT11 field.
	CAN_FA1R_FACT11_Pos = 0xb
	// Bit mask of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800
	// Bit FACT11.
	CAN_FA1R_FACT11 = 0x800
	// Position of FACT12 field.
	CAN_FA1R_FACT12_Pos = 0xc
	// Bit mask of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000
	// Bit FACT12.
	CAN_FA1R_FACT12 = 0x1000
	// Position of FACT13 field.
	CAN_FA1R_FACT13_Pos = 0xd
	// Bit mask of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000
	// Bit FACT13.
	CAN_FA1R_FACT13 = 0x2000
	// Position of FACT14 field.
	CAN_FA1R_FACT14_Pos = 0xe
	// Bit mask of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000
	// Bit FACT14.
	CAN_FA1R_FACT14 = 0x4000
	// Position of FACT15 field.
	CAN_FA1R_FACT15_Pos = 0xf
	// Bit mask of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000
	// Bit FACT15.
	CAN_FA1R_FACT15 = 0x8000
	// Position of FACT16 field.
	CAN_FA1R_FACT16_Pos = 0x10
	// Bit mask of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000
	// Bit FACT16.
	CAN_FA1R_FACT16 = 0x10000
	// Position of FACT17 field.
	CAN_FA1R_FACT17_Pos = 0x11
	// Bit mask of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000
	// Bit FACT17.
	CAN_FA1R_FACT17 = 0x20000
	// Position of FACT18 field.
	CAN_FA1R_FACT18_Pos = 0x12
	// Bit mask of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000
	// Bit FACT18.
	CAN_FA1R_FACT18 = 0x40000
	// Position of FACT19 field.
	CAN_FA1R_FACT19_Pos = 0x13
	// Bit mask of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000
	// Bit FACT19.
	CAN_FA1R_FACT19 = 0x80000
	// Position of FACT20 field.
	CAN_FA1R_FACT20_Pos = 0x14
	// Bit mask of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000
	// Bit FACT20.
	CAN_FA1R_FACT20 = 0x100000
	// Position of FACT21 field.
	CAN_FA1R_FACT21_Pos = 0x15
	// Bit mask of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000
	// Bit FACT21.
	CAN_FA1R_FACT21 = 0x200000
	// Position of FACT22 field.
	CAN_FA1R_FACT22_Pos = 0x16
	// Bit mask of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000
	// Bit FACT22.
	CAN_FA1R_FACT22 = 0x400000
	// Position of FACT23 field.
	CAN_FA1R_FACT23_Pos = 0x17
	// Bit mask of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000
	// Bit FACT23.
	CAN_FA1R_FACT23 = 0x800000
	// Position of FACT24 field.
	CAN_FA1R_FACT24_Pos = 0x18
	// Bit mask of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000
	// Bit FACT24.
	CAN_FA1R_FACT24 = 0x1000000
	// Position of FACT25 field.
	CAN_FA1R_FACT25_Pos = 0x19
	// Bit mask of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000
	// Bit FACT25.
	CAN_FA1R_FACT25 = 0x2000000
	// Position of FACT26 field.
	CAN_FA1R_FACT26_Pos = 0x1a
	// Bit mask of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000
	// Bit FACT26.
	CAN_FA1R_FACT26 = 0x4000000
	// Position of FACT27 field.
	CAN_FA1R_FACT27_Pos = 0x1b
	// Bit mask of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000
	// Bit FACT27.
	CAN_FA1R_FACT27 = 0x8000000

	// FB.FR1: Filter bank 0 register 1
	// Position of FB field.
	CAN_FB_FR1_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR1_FB_Msk = 0xffffffff

	// FB.FR2: Filter bank 0 register 2
	// Position of FB field.
	CAN_FB_FR2_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR2_FB_Msk = 0xffffffff
)

// Bitfields for FLASH: FLASH
const (
	// ACR: Flash access control register
	// Position of LATENCY field.
	FLASH_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	FLASH_ACR_LATENCY_Msk = 0xf
	// 0 wait states
	FLASH_ACR_LATENCY_WS0 = 0x0
	// 1 wait states
	FLASH_ACR_LATENCY_WS1 = 0x1
	// 2 wait states
	FLASH_ACR_LATENCY_WS2 = 0x2
	// 3 wait states
	FLASH_ACR_LATENCY_WS3 = 0x3
	// 4 wait states
	FLASH_ACR_LATENCY_WS4 = 0x4
	// 5 wait states
	FLASH_ACR_LATENCY_WS5 = 0x5
	// 6 wait states
	FLASH_ACR_LATENCY_WS6 = 0x6
	// 7 wait states
	FLASH_ACR_LATENCY_WS7 = 0x7
	// 8 wait states
	FLASH_ACR_LATENCY_WS8 = 0x8
	// 9 wait states
	FLASH_ACR_LATENCY_WS9 = 0x9
	// 10 wait states
	FLASH_ACR_LATENCY_WS10 = 0xa
	// 11 wait states
	FLASH_ACR_LATENCY_WS11 = 0xb
	// 12 wait states
	FLASH_ACR_LATENCY_WS12 = 0xc
	// 13 wait states
	FLASH_ACR_LATENCY_WS13 = 0xd
	// 14 wait states
	FLASH_ACR_LATENCY_WS14 = 0xe
	// 15 wait states
	FLASH_ACR_LATENCY_WS15 = 0xf
	// Position of PRFTEN field.
	FLASH_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	FLASH_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	FLASH_ACR_PRFTEN = 0x100
	// Prefetch is disabled
	FLASH_ACR_PRFTEN_Disabled = 0x0
	// Prefetch is enabled
	FLASH_ACR_PRFTEN_Enabled = 0x1
	// Position of ARTEN field.
	FLASH_ACR_ARTEN_Pos = 0x9
	// Bit mask of ARTEN field.
	FLASH_ACR_ARTEN_Msk = 0x200
	// Bit ARTEN.
	FLASH_ACR_ARTEN = 0x200
	// ART Accelerator is disabled
	FLASH_ACR_ARTEN_Disabled = 0x0
	// ART Accelerator is enabled
	FLASH_ACR_ARTEN_Enabled = 0x1
	// Position of ARTRST field.
	FLASH_ACR_ARTRST_Pos = 0xb
	// Bit mask of ARTRST field.
	FLASH_ACR_ARTRST_Msk = 0x800
	// Bit ARTRST.
	FLASH_ACR_ARTRST = 0x800
	// Accelerator is not reset
	FLASH_ACR_ARTRST_NotReset = 0x0
	// Accelerator is reset
	FLASH_ACR_ARTRST_Reset = 0x1

	// KEYR: Flash key register
	// Position of KEY field.
	FLASH_KEYR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff

	// OPTKEYR: Flash option key register
	// Position of OPTKEYR field.
	FLASH_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	FLASH_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	FLASH_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	FLASH_SR_EOP_Msk = 0x1
	// Bit EOP.
	FLASH_SR_EOP = 0x1
	// Position of OPERR field.
	FLASH_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	FLASH_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	FLASH_SR_OPERR = 0x2
	// Position of WRPERR field.
	FLASH_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	FLASH_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	FLASH_SR_WRPERR = 0x10
	// Position of PGAERR field.
	FLASH_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	FLASH_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	FLASH_SR_PGAERR = 0x20
	// Position of PGPERR field.
	FLASH_SR_PGPERR_Pos = 0x6
	// Bit mask of PGPERR field.
	FLASH_SR_PGPERR_Msk = 0x40
	// Bit PGPERR.
	FLASH_SR_PGPERR = 0x40
	// Position of ERSERR field.
	FLASH_SR_ERSERR_Pos = 0x7
	// Bit mask of ERSERR field.
	FLASH_SR_ERSERR_Msk = 0x80
	// Bit ERSERR.
	FLASH_SR_ERSERR = 0x80
	// Position of BSY field.
	FLASH_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	FLASH_SR_BSY_Msk = 0x10000
	// Bit BSY.
	FLASH_SR_BSY = 0x10000

	// CR: Control register
	// Position of PG field.
	FLASH_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	FLASH_CR_PG_Msk = 0x1
	// Bit PG.
	FLASH_CR_PG = 0x1
	// Flash programming activated
	FLASH_CR_PG_Program = 0x1
	// Position of SER field.
	FLASH_CR_SER_Pos = 0x1
	// Bit mask of SER field.
	FLASH_CR_SER_Msk = 0x2
	// Bit SER.
	FLASH_CR_SER = 0x2
	// Erase activated for selected sector
	FLASH_CR_SER_SectorErase = 0x1
	// Position of MER1 field.
	FLASH_CR_MER1_Pos = 0x2
	// Bit mask of MER1 field.
	FLASH_CR_MER1_Msk = 0x4
	// Bit MER1.
	FLASH_CR_MER1 = 0x4
	// Erase activated for all user sectors or bank 1 in dual bank mode
	FLASH_CR_MER1_MassErase = 0x1
	// Position of SNB field.
	FLASH_CR_SNB_Pos = 0x3
	// Bit mask of SNB field.
	FLASH_CR_SNB_Msk = 0xf8
	// Position of PSIZE field.
	FLASH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	FLASH_CR_PSIZE_Msk = 0x300
	// Program x8
	FLASH_CR_PSIZE_PSIZE8 = 0x0
	// Program x16
	FLASH_CR_PSIZE_PSIZE16 = 0x1
	// Program x32
	FLASH_CR_PSIZE_PSIZE32 = 0x2
	// Program x64
	FLASH_CR_PSIZE_PSIZE64 = 0x3
	// Position of MER2 field.
	FLASH_CR_MER2_Pos = 0xf
	// Bit mask of MER2 field.
	FLASH_CR_MER2_Msk = 0x8000
	// Bit MER2.
	FLASH_CR_MER2 = 0x8000
	// Erase activated for bank 2 in dual bank mode
	FLASH_CR_MER2_MassErase = 0x1
	// Position of STRT field.
	FLASH_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	FLASH_CR_STRT_Msk = 0x10000
	// Bit STRT.
	FLASH_CR_STRT = 0x10000
	// Trigger an erase operation
	FLASH_CR_STRT_Start = 0x1
	// Position of EOPIE field.
	FLASH_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	FLASH_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	FLASH_CR_EOPIE = 0x1000000
	// End of operation interrupt disabled
	FLASH_CR_EOPIE_Disabled = 0x0
	// End of operation interrupt enabled
	FLASH_CR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	FLASH_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	FLASH_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	FLASH_CR_ERRIE = 0x2000000
	// Error interrupt generation disabled
	FLASH_CR_ERRIE_Disabled = 0x0
	// Error interrupt generation enabled
	FLASH_CR_ERRIE_Enabled = 0x1
	// Position of LOCK field.
	FLASH_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	FLASH_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	FLASH_CR_LOCK = 0x80000000
	// FLASH_CR register is unlocked
	FLASH_CR_LOCK_Unlocked = 0x0
	// FLASH_CR register is locked
	FLASH_CR_LOCK_Locked = 0x1

	// OPTCR: Flash option control register
	// Position of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Pos = 0x0
	// Bit mask of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Msk = 0x1
	// Bit OPTLOCK.
	FLASH_OPTCR_OPTLOCK = 0x1
	// Position of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Pos = 0x1
	// Bit mask of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Msk = 0x2
	// Bit OPTSTRT.
	FLASH_OPTCR_OPTSTRT = 0x2
	// Position of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Pos = 0x2
	// Bit mask of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Msk = 0xc
	// Position of WWDG_SW field.
	FLASH_OPTCR_WWDG_SW_Pos = 0x4
	// Bit mask of WWDG_SW field.
	FLASH_OPTCR_WWDG_SW_Msk = 0x10
	// Bit WWDG_SW.
	FLASH_OPTCR_WWDG_SW = 0x10
	// Position of IWDG_SW field.
	FLASH_OPTCR_IWDG_SW_Pos = 0x5
	// Bit mask of IWDG_SW field.
	FLASH_OPTCR_IWDG_SW_Msk = 0x20
	// Bit IWDG_SW.
	FLASH_OPTCR_IWDG_SW = 0x20
	// Position of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Pos = 0x6
	// Bit mask of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Msk = 0x40
	// Bit NRST_STOP.
	FLASH_OPTCR_NRST_STOP = 0x40
	// Position of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Pos = 0x7
	// Bit mask of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Msk = 0x80
	// Bit NRST_STDBY.
	FLASH_OPTCR_NRST_STDBY = 0x80
	// Position of RDP field.
	FLASH_OPTCR_RDP_Pos = 0x8
	// Bit mask of RDP field.
	FLASH_OPTCR_RDP_Msk = 0xff00
	// Position of NWRP field.
	FLASH_OPTCR_NWRP_Pos = 0x10
	// Bit mask of NWRP field.
	FLASH_OPTCR_NWRP_Msk = 0xfff0000
	// Position of NDBOOT field.
	FLASH_OPTCR_NDBOOT_Pos = 0x1c
	// Bit mask of NDBOOT field.
	FLASH_OPTCR_NDBOOT_Msk = 0x10000000
	// Bit NDBOOT.
	FLASH_OPTCR_NDBOOT = 0x10000000
	// Position of NDBANK field.
	FLASH_OPTCR_NDBANK_Pos = 0x1d
	// Bit mask of NDBANK field.
	FLASH_OPTCR_NDBANK_Msk = 0x20000000
	// Bit NDBANK.
	FLASH_OPTCR_NDBANK = 0x20000000
	// Position of IWDG_STDBY field.
	FLASH_OPTCR_IWDG_STDBY_Pos = 0x1e
	// Bit mask of IWDG_STDBY field.
	FLASH_OPTCR_IWDG_STDBY_Msk = 0x40000000
	// Bit IWDG_STDBY.
	FLASH_OPTCR_IWDG_STDBY = 0x40000000
	// Position of IWDG_STOP field.
	FLASH_OPTCR_IWDG_STOP_Pos = 0x1f
	// Bit mask of IWDG_STOP field.
	FLASH_OPTCR_IWDG_STOP_Msk = 0x80000000
	// Bit IWDG_STOP.
	FLASH_OPTCR_IWDG_STOP = 0x80000000

	// OPTCR1: Flash option control register 1
	// Position of BOOT_ADD0 field.
	FLASH_OPTCR1_BOOT_ADD0_Pos = 0x0
	// Bit mask of BOOT_ADD0 field.
	FLASH_OPTCR1_BOOT_ADD0_Msk = 0xffff
	// Position of BOOT_ADD1 field.
	FLASH_OPTCR1_BOOT_ADD1_Pos = 0x10
	// Bit mask of BOOT_ADD1 field.
	FLASH_OPTCR1_BOOT_ADD1_Msk = 0xffff0000
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register (EXTI_IMR)
	// Position of MR0 field.
	EXTI_IMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_IMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_IMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_IMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_IMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_IMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_IMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_IMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_IMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_IMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_IMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_IMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_IMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_IMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_IMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_IMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_IMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_IMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_IMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_IMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_IMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_IMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_IMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_IMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_IMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_IMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_IMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_IMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_IMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_IMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_IMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_IMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_IMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_IMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_IMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_IMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_IMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_IMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_IMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_IMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_IMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_IMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_IMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_IMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_IMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_IMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_IMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_IMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_IMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_IMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_IMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_IMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_IMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_IMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_IMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_IMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR22_Unmasked = 0x1

	// EMR: Event mask register (EXTI_EMR)
	// Position of MR0 field.
	EXTI_EMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_EMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_EMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_EMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_EMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_EMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_EMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_EMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_EMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_EMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_EMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_EMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_EMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_EMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_EMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_EMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_EMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_EMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_EMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_EMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_EMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_EMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_EMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_EMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_EMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_EMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_EMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_EMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_EMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_EMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_EMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_EMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_EMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_EMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_EMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_EMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_EMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_EMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_EMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_EMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_EMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_EMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_EMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_EMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_EMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_EMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_EMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_EMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_EMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_EMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_EMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_EMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_EMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_EMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_EMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_EMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_EMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_EMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR22_Unmasked = 0x1

	// RTSR: Rising Trigger selection register (EXTI_RTSR)
	// Position of TR0 field.
	EXTI_RTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_RTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_RTSR_TR17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_RTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_RTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_RTSR_TR18 = 0x40000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR18_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_RTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_RTSR_TR19 = 0x80000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR19_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_RTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_RTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_RTSR_TR20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_RTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_RTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_RTSR_TR21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_RTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_RTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_RTSR_TR22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR22_Enabled = 0x1

	// FTSR: Falling Trigger selection register (EXTI_FTSR)
	// Position of TR0 field.
	EXTI_FTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_FTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_FTSR_TR17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_FTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_FTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_FTSR_TR18 = 0x40000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR18_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_FTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_FTSR_TR19 = 0x80000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR19_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_FTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_FTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_FTSR_TR20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_FTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_FTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_FTSR_TR21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_FTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_FTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_FTSR_TR22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR22_Enabled = 0x1

	// SWIER: Software interrupt event register (EXTI_SWIER)
	// Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER_SWIER16_Pend = 0x1
	// Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Pos = 0x11
	// Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000
	// Bit SWIER17.
	EXTI_SWIER_SWIER17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER_SWIER17_Pend = 0x1
	// Position of SWIER18 field.
	EXTI_SWIER_SWIER18_Pos = 0x12
	// Bit mask of SWIER18 field.
	EXTI_SWIER_SWIER18_Msk = 0x40000
	// Bit SWIER18.
	EXTI_SWIER_SWIER18 = 0x40000
	// Generates an interrupt request
	EXTI_SWIER_SWIER18_Pend = 0x1
	// Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Pos = 0x13
	// Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000
	// Bit SWIER19.
	EXTI_SWIER_SWIER19 = 0x80000
	// Generates an interrupt request
	EXTI_SWIER_SWIER19_Pend = 0x1
	// Position of SWIER20 field.
	EXTI_SWIER_SWIER20_Pos = 0x14
	// Bit mask of SWIER20 field.
	EXTI_SWIER_SWIER20_Msk = 0x100000
	// Bit SWIER20.
	EXTI_SWIER_SWIER20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER_SWIER20_Pend = 0x1
	// Position of SWIER21 field.
	EXTI_SWIER_SWIER21_Pos = 0x15
	// Bit mask of SWIER21 field.
	EXTI_SWIER_SWIER21_Msk = 0x200000
	// Bit SWIER21.
	EXTI_SWIER_SWIER21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER_SWIER21_Pend = 0x1
	// Position of SWIER22 field.
	EXTI_SWIER_SWIER22_Pos = 0x16
	// Bit mask of SWIER22 field.
	EXTI_SWIER_SWIER22_Msk = 0x400000
	// Bit SWIER22.
	EXTI_SWIER_SWIER22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER_SWIER22_Pend = 0x1

	// PR: Pending register (EXTI_PR)
	// Position of PR0 field.
	EXTI_PR_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	EXTI_PR_PR0_Msk = 0x1
	// Bit PR0.
	EXTI_PR_PR0 = 0x1
	// No trigger request occurred
	EXTI_PR_PR0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR0_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR0_Clear = 0x1
	// Position of PR1 field.
	EXTI_PR_PR1_Pos = 0x1
	// Bit mask of PR1 field.
	EXTI_PR_PR1_Msk = 0x2
	// Bit PR1.
	EXTI_PR_PR1 = 0x2
	// No trigger request occurred
	EXTI_PR_PR1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR1_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR1_Clear = 0x1
	// Position of PR2 field.
	EXTI_PR_PR2_Pos = 0x2
	// Bit mask of PR2 field.
	EXTI_PR_PR2_Msk = 0x4
	// Bit PR2.
	EXTI_PR_PR2 = 0x4
	// No trigger request occurred
	EXTI_PR_PR2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR2_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR2_Clear = 0x1
	// Position of PR3 field.
	EXTI_PR_PR3_Pos = 0x3
	// Bit mask of PR3 field.
	EXTI_PR_PR3_Msk = 0x8
	// Bit PR3.
	EXTI_PR_PR3 = 0x8
	// No trigger request occurred
	EXTI_PR_PR3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR3_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR3_Clear = 0x1
	// Position of PR4 field.
	EXTI_PR_PR4_Pos = 0x4
	// Bit mask of PR4 field.
	EXTI_PR_PR4_Msk = 0x10
	// Bit PR4.
	EXTI_PR_PR4 = 0x10
	// No trigger request occurred
	EXTI_PR_PR4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR4_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR4_Clear = 0x1
	// Position of PR5 field.
	EXTI_PR_PR5_Pos = 0x5
	// Bit mask of PR5 field.
	EXTI_PR_PR5_Msk = 0x20
	// Bit PR5.
	EXTI_PR_PR5 = 0x20
	// No trigger request occurred
	EXTI_PR_PR5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR5_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR5_Clear = 0x1
	// Position of PR6 field.
	EXTI_PR_PR6_Pos = 0x6
	// Bit mask of PR6 field.
	EXTI_PR_PR6_Msk = 0x40
	// Bit PR6.
	EXTI_PR_PR6 = 0x40
	// No trigger request occurred
	EXTI_PR_PR6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR6_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR6_Clear = 0x1
	// Position of PR7 field.
	EXTI_PR_PR7_Pos = 0x7
	// Bit mask of PR7 field.
	EXTI_PR_PR7_Msk = 0x80
	// Bit PR7.
	EXTI_PR_PR7 = 0x80
	// No trigger request occurred
	EXTI_PR_PR7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR7_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR7_Clear = 0x1
	// Position of PR8 field.
	EXTI_PR_PR8_Pos = 0x8
	// Bit mask of PR8 field.
	EXTI_PR_PR8_Msk = 0x100
	// Bit PR8.
	EXTI_PR_PR8 = 0x100
	// No trigger request occurred
	EXTI_PR_PR8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR8_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR8_Clear = 0x1
	// Position of PR9 field.
	EXTI_PR_PR9_Pos = 0x9
	// Bit mask of PR9 field.
	EXTI_PR_PR9_Msk = 0x200
	// Bit PR9.
	EXTI_PR_PR9 = 0x200
	// No trigger request occurred
	EXTI_PR_PR9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR9_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR9_Clear = 0x1
	// Position of PR10 field.
	EXTI_PR_PR10_Pos = 0xa
	// Bit mask of PR10 field.
	EXTI_PR_PR10_Msk = 0x400
	// Bit PR10.
	EXTI_PR_PR10 = 0x400
	// No trigger request occurred
	EXTI_PR_PR10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR10_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR10_Clear = 0x1
	// Position of PR11 field.
	EXTI_PR_PR11_Pos = 0xb
	// Bit mask of PR11 field.
	EXTI_PR_PR11_Msk = 0x800
	// Bit PR11.
	EXTI_PR_PR11 = 0x800
	// No trigger request occurred
	EXTI_PR_PR11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR11_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR11_Clear = 0x1
	// Position of PR12 field.
	EXTI_PR_PR12_Pos = 0xc
	// Bit mask of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000
	// Bit PR12.
	EXTI_PR_PR12 = 0x1000
	// No trigger request occurred
	EXTI_PR_PR12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR12_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR12_Clear = 0x1
	// Position of PR13 field.
	EXTI_PR_PR13_Pos = 0xd
	// Bit mask of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000
	// Bit PR13.
	EXTI_PR_PR13 = 0x2000
	// No trigger request occurred
	EXTI_PR_PR13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR13_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR13_Clear = 0x1
	// Position of PR14 field.
	EXTI_PR_PR14_Pos = 0xe
	// Bit mask of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000
	// Bit PR14.
	EXTI_PR_PR14 = 0x4000
	// No trigger request occurred
	EXTI_PR_PR14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR14_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR14_Clear = 0x1
	// Position of PR15 field.
	EXTI_PR_PR15_Pos = 0xf
	// Bit mask of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000
	// Bit PR15.
	EXTI_PR_PR15 = 0x8000
	// No trigger request occurred
	EXTI_PR_PR15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR15_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR15_Clear = 0x1
	// Position of PR16 field.
	EXTI_PR_PR16_Pos = 0x10
	// Bit mask of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000
	// Bit PR16.
	EXTI_PR_PR16 = 0x10000
	// No trigger request occurred
	EXTI_PR_PR16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR16_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR16_Clear = 0x1
	// Position of PR17 field.
	EXTI_PR_PR17_Pos = 0x11
	// Bit mask of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000
	// Bit PR17.
	EXTI_PR_PR17 = 0x20000
	// No trigger request occurred
	EXTI_PR_PR17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR17_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR17_Clear = 0x1
	// Position of PR18 field.
	EXTI_PR_PR18_Pos = 0x12
	// Bit mask of PR18 field.
	EXTI_PR_PR18_Msk = 0x40000
	// Bit PR18.
	EXTI_PR_PR18 = 0x40000
	// No trigger request occurred
	EXTI_PR_PR18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR18_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR18_Clear = 0x1
	// Position of PR19 field.
	EXTI_PR_PR19_Pos = 0x13
	// Bit mask of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000
	// Bit PR19.
	EXTI_PR_PR19 = 0x80000
	// No trigger request occurred
	EXTI_PR_PR19_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR19_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR19_Clear = 0x1
	// Position of PR20 field.
	EXTI_PR_PR20_Pos = 0x14
	// Bit mask of PR20 field.
	EXTI_PR_PR20_Msk = 0x100000
	// Bit PR20.
	EXTI_PR_PR20 = 0x100000
	// No trigger request occurred
	EXTI_PR_PR20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR20_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR20_Clear = 0x1
	// Position of PR21 field.
	EXTI_PR_PR21_Pos = 0x15
	// Bit mask of PR21 field.
	EXTI_PR_PR21_Msk = 0x200000
	// Bit PR21.
	EXTI_PR_PR21 = 0x200000
	// No trigger request occurred
	EXTI_PR_PR21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR21_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR21_Clear = 0x1
	// Position of PR22 field.
	EXTI_PR_PR22_Pos = 0x16
	// Bit mask of PR22 field.
	EXTI_PR_PR22_Msk = 0x400000
	// Bit PR22.
	EXTI_PR_PR22 = 0x400000
	// No trigger request occurred
	EXTI_PR_PR22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR22_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR22_Clear = 0x1
)

// Bitfields for LTDC: LCD-TFT Controller
const (
	// SSCR: Synchronization Size Configuration Register
	// Position of HSW field.
	LTDC_SSCR_HSW_Pos = 0x10
	// Bit mask of HSW field.
	LTDC_SSCR_HSW_Msk = 0xfff0000
	// Position of VSH field.
	LTDC_SSCR_VSH_Pos = 0x0
	// Bit mask of VSH field.
	LTDC_SSCR_VSH_Msk = 0x7ff

	// BPCR: Back Porch Configuration Register
	// Position of AHBP field.
	LTDC_BPCR_AHBP_Pos = 0x10
	// Bit mask of AHBP field.
	LTDC_BPCR_AHBP_Msk = 0xfff0000
	// Position of AVBP field.
	LTDC_BPCR_AVBP_Pos = 0x0
	// Bit mask of AVBP field.
	LTDC_BPCR_AVBP_Msk = 0x7ff

	// AWCR: Active Width Configuration Register
	// Position of AAW field.
	LTDC_AWCR_AAW_Pos = 0x10
	// Bit mask of AAW field.
	LTDC_AWCR_AAW_Msk = 0xfff0000
	// Position of AAH field.
	LTDC_AWCR_AAH_Pos = 0x0
	// Bit mask of AAH field.
	LTDC_AWCR_AAH_Msk = 0x7ff

	// TWCR: Total Width Configuration Register
	// Position of TOTALW field.
	LTDC_TWCR_TOTALW_Pos = 0x10
	// Bit mask of TOTALW field.
	LTDC_TWCR_TOTALW_Msk = 0xfff0000
	// Position of TOTALH field.
	LTDC_TWCR_TOTALH_Pos = 0x0
	// Bit mask of TOTALH field.
	LTDC_TWCR_TOTALH_Msk = 0x7ff

	// GCR: Global Control Register
	// Position of HSPOL field.
	LTDC_GCR_HSPOL_Pos = 0x1f
	// Bit mask of HSPOL field.
	LTDC_GCR_HSPOL_Msk = 0x80000000
	// Bit HSPOL.
	LTDC_GCR_HSPOL = 0x80000000
	// Horizontal synchronization polarity is active low
	LTDC_GCR_HSPOL_ActiveLow = 0x0
	// Horizontal synchronization polarity is active high
	LTDC_GCR_HSPOL_ActiveHigh = 0x1
	// Position of VSPOL field.
	LTDC_GCR_VSPOL_Pos = 0x1e
	// Bit mask of VSPOL field.
	LTDC_GCR_VSPOL_Msk = 0x40000000
	// Bit VSPOL.
	LTDC_GCR_VSPOL = 0x40000000
	// Vertical synchronization polarity is active low
	LTDC_GCR_VSPOL_ActiveLow = 0x0
	// Vertical synchronization polarity is active high
	LTDC_GCR_VSPOL_ActiveHigh = 0x1
	// Position of DEPOL field.
	LTDC_GCR_DEPOL_Pos = 0x1d
	// Bit mask of DEPOL field.
	LTDC_GCR_DEPOL_Msk = 0x20000000
	// Bit DEPOL.
	LTDC_GCR_DEPOL = 0x20000000
	// Data enable polarity is active low
	LTDC_GCR_DEPOL_ActiveLow = 0x0
	// Data enable polarity is active high
	LTDC_GCR_DEPOL_ActiveHigh = 0x1
	// Position of PCPOL field.
	LTDC_GCR_PCPOL_Pos = 0x1c
	// Bit mask of PCPOL field.
	LTDC_GCR_PCPOL_Msk = 0x10000000
	// Bit PCPOL.
	LTDC_GCR_PCPOL = 0x10000000
	// Pixel clock on rising edge
	LTDC_GCR_PCPOL_RisingEdge = 0x0
	// Pixel clock on falling edge
	LTDC_GCR_PCPOL_FallingEdge = 0x1
	// Position of DEN field.
	LTDC_GCR_DEN_Pos = 0x10
	// Bit mask of DEN field.
	LTDC_GCR_DEN_Msk = 0x10000
	// Bit DEN.
	LTDC_GCR_DEN = 0x10000
	// Dither disabled
	LTDC_GCR_DEN_Disabled = 0x0
	// Dither enabled
	LTDC_GCR_DEN_Enabled = 0x1
	// Position of DRW field.
	LTDC_GCR_DRW_Pos = 0xc
	// Bit mask of DRW field.
	LTDC_GCR_DRW_Msk = 0x7000
	// Position of DGW field.
	LTDC_GCR_DGW_Pos = 0x8
	// Bit mask of DGW field.
	LTDC_GCR_DGW_Msk = 0x700
	// Position of DBW field.
	LTDC_GCR_DBW_Pos = 0x4
	// Bit mask of DBW field.
	LTDC_GCR_DBW_Msk = 0x70
	// Position of LTDCEN field.
	LTDC_GCR_LTDCEN_Pos = 0x0
	// Bit mask of LTDCEN field.
	LTDC_GCR_LTDCEN_Msk = 0x1
	// Bit LTDCEN.
	LTDC_GCR_LTDCEN = 0x1
	// LCD-TFT controller disabled
	LTDC_GCR_LTDCEN_Disabled = 0x0
	// LCD-TFT controller enabled
	LTDC_GCR_LTDCEN_Enabled = 0x1

	// SRCR: Shadow Reload Configuration Register
	// Position of VBR field.
	LTDC_SRCR_VBR_Pos = 0x1
	// Bit mask of VBR field.
	LTDC_SRCR_VBR_Msk = 0x2
	// Bit VBR.
	LTDC_SRCR_VBR = 0x2
	// The shadow registers are reloaded during the vertical blanking period (at the beginning of the first line after the active display area).
	LTDC_SRCR_VBR_Reload = 0x1
	// This bit is set by software and cleared only by hardware after reload (it cannot be cleared through register write once it is set)
	LTDC_SRCR_VBR_NoEffect = 0x0
	// Position of IMR field.
	LTDC_SRCR_IMR_Pos = 0x0
	// Bit mask of IMR field.
	LTDC_SRCR_IMR_Msk = 0x1
	// Bit IMR.
	LTDC_SRCR_IMR = 0x1
	// The shadow registers are reloaded immediately. This bit is set by software and cleared only by hardware after reload
	LTDC_SRCR_IMR_Reload = 0x1
	// This bit is set by software and cleared only by hardware after reload (it cannot be cleared through register write once it is set)
	LTDC_SRCR_IMR_NoEffect = 0x0

	// BCCR: Background Color Configuration Register
	// Position of BCBLUE field.
	LTDC_BCCR_BCBLUE_Pos = 0x0
	// Bit mask of BCBLUE field.
	LTDC_BCCR_BCBLUE_Msk = 0xff
	// Position of BCGREEN field.
	LTDC_BCCR_BCGREEN_Pos = 0x8
	// Bit mask of BCGREEN field.
	LTDC_BCCR_BCGREEN_Msk = 0xff00
	// Position of BCRED field.
	LTDC_BCCR_BCRED_Pos = 0x10
	// Bit mask of BCRED field.
	LTDC_BCCR_BCRED_Msk = 0xff0000

	// IER: Interrupt Enable Register
	// Position of RRIE field.
	LTDC_IER_RRIE_Pos = 0x3
	// Bit mask of RRIE field.
	LTDC_IER_RRIE_Msk = 0x8
	// Bit RRIE.
	LTDC_IER_RRIE = 0x8
	// Register reload interrupt disabled
	LTDC_IER_RRIE_Disabled = 0x0
	// Register reload interrupt enabled
	LTDC_IER_RRIE_Enabled = 0x1
	// Position of TERRIE field.
	LTDC_IER_TERRIE_Pos = 0x2
	// Bit mask of TERRIE field.
	LTDC_IER_TERRIE_Msk = 0x4
	// Bit TERRIE.
	LTDC_IER_TERRIE = 0x4
	// Transfer error interrupt disabled
	LTDC_IER_TERRIE_Disabled = 0x0
	// Transfer error interrupt enabled
	LTDC_IER_TERRIE_Enabled = 0x1
	// Position of FUIE field.
	LTDC_IER_FUIE_Pos = 0x1
	// Bit mask of FUIE field.
	LTDC_IER_FUIE_Msk = 0x2
	// Bit FUIE.
	LTDC_IER_FUIE = 0x2
	// FIFO underrun interrupt disabled
	LTDC_IER_FUIE_Disabled = 0x0
	// FIFO underrun interrupt enabled
	LTDC_IER_FUIE_Enabled = 0x1
	// Position of LIE field.
	LTDC_IER_LIE_Pos = 0x0
	// Bit mask of LIE field.
	LTDC_IER_LIE_Msk = 0x1
	// Bit LIE.
	LTDC_IER_LIE = 0x1
	// Line interrupt disabled
	LTDC_IER_LIE_Disabled = 0x0
	// Line interrupt enabled
	LTDC_IER_LIE_Enabled = 0x1

	// ISR: Interrupt Status Register
	// Position of RRIF field.
	LTDC_ISR_RRIF_Pos = 0x3
	// Bit mask of RRIF field.
	LTDC_ISR_RRIF_Msk = 0x8
	// Bit RRIF.
	LTDC_ISR_RRIF = 0x8
	// No register reload
	LTDC_ISR_RRIF_NoReload = 0x0
	// Register reload interrupt generated when a vertical blanking reload occurs (and the first line after the active area is reached)
	LTDC_ISR_RRIF_Reload = 0x1
	// Position of TERRIF field.
	LTDC_ISR_TERRIF_Pos = 0x2
	// Bit mask of TERRIF field.
	LTDC_ISR_TERRIF_Msk = 0x4
	// Bit TERRIF.
	LTDC_ISR_TERRIF = 0x4
	// No transfer error
	LTDC_ISR_TERRIF_NoError = 0x0
	// Transfer error interrupt generated when a bus error occurs
	LTDC_ISR_TERRIF_Error = 0x1
	// Position of FUIF field.
	LTDC_ISR_FUIF_Pos = 0x1
	// Bit mask of FUIF field.
	LTDC_ISR_FUIF_Msk = 0x2
	// Bit FUIF.
	LTDC_ISR_FUIF = 0x2
	// No FIFO underrun
	LTDC_ISR_FUIF_NoUnderrun = 0x0
	// FIFO underrun interrupt generated, if one of the layer FIFOs is empty and pixel data is read from the FIFO
	LTDC_ISR_FUIF_Underrun = 0x1
	// Position of LIF field.
	LTDC_ISR_LIF_Pos = 0x0
	// Bit mask of LIF field.
	LTDC_ISR_LIF_Msk = 0x1
	// Bit LIF.
	LTDC_ISR_LIF = 0x1
	// Programmed line not reached
	LTDC_ISR_LIF_NotReached = 0x0
	// Line interrupt generated when a programmed line is reached
	LTDC_ISR_LIF_Reached = 0x1

	// ICR: Interrupt Clear Register
	// Position of CRRIF field.
	LTDC_ICR_CRRIF_Pos = 0x3
	// Bit mask of CRRIF field.
	LTDC_ICR_CRRIF_Msk = 0x8
	// Bit CRRIF.
	LTDC_ICR_CRRIF = 0x8
	// Clears the RRIF flag in the ISR register
	LTDC_ICR_CRRIF_Clear = 0x1
	// Position of CTERRIF field.
	LTDC_ICR_CTERRIF_Pos = 0x2
	// Bit mask of CTERRIF field.
	LTDC_ICR_CTERRIF_Msk = 0x4
	// Bit CTERRIF.
	LTDC_ICR_CTERRIF = 0x4
	// Clears the TERRIF flag in the ISR register
	LTDC_ICR_CTERRIF_Clear = 0x1
	// Position of CFUIF field.
	LTDC_ICR_CFUIF_Pos = 0x1
	// Bit mask of CFUIF field.
	LTDC_ICR_CFUIF_Msk = 0x2
	// Bit CFUIF.
	LTDC_ICR_CFUIF = 0x2
	// Clears the FUIF flag in the ISR register
	LTDC_ICR_CFUIF_Clear = 0x1
	// Position of CLIF field.
	LTDC_ICR_CLIF_Pos = 0x0
	// Bit mask of CLIF field.
	LTDC_ICR_CLIF_Msk = 0x1
	// Bit CLIF.
	LTDC_ICR_CLIF = 0x1
	// Clears the LIF flag in the ISR register
	LTDC_ICR_CLIF_Clear = 0x1

	// LIPCR: Line Interrupt Position Configuration Register
	// Position of LIPOS field.
	LTDC_LIPCR_LIPOS_Pos = 0x0
	// Bit mask of LIPOS field.
	LTDC_LIPCR_LIPOS_Msk = 0x7ff

	// CPSR: Current Position Status Register
	// Position of CXPOS field.
	LTDC_CPSR_CXPOS_Pos = 0x10
	// Bit mask of CXPOS field.
	LTDC_CPSR_CXPOS_Msk = 0xffff0000
	// Position of CYPOS field.
	LTDC_CPSR_CYPOS_Pos = 0x0
	// Bit mask of CYPOS field.
	LTDC_CPSR_CYPOS_Msk = 0xffff

	// CDSR: Current Display Status Register
	// Position of HSYNCS field.
	LTDC_CDSR_HSYNCS_Pos = 0x3
	// Bit mask of HSYNCS field.
	LTDC_CDSR_HSYNCS_Msk = 0x8
	// Bit HSYNCS.
	LTDC_CDSR_HSYNCS = 0x8
	// Currently not in HSYNC phase
	LTDC_CDSR_HSYNCS_NotActive = 0x0
	// Currently in HSYNC phase
	LTDC_CDSR_HSYNCS_Active = 0x1
	// Position of VSYNCS field.
	LTDC_CDSR_VSYNCS_Pos = 0x2
	// Bit mask of VSYNCS field.
	LTDC_CDSR_VSYNCS_Msk = 0x4
	// Bit VSYNCS.
	LTDC_CDSR_VSYNCS = 0x4
	// Currently not in VSYNC phase
	LTDC_CDSR_VSYNCS_NotActive = 0x0
	// Currently in VSYNC phase
	LTDC_CDSR_VSYNCS_Active = 0x1
	// Position of HDES field.
	LTDC_CDSR_HDES_Pos = 0x1
	// Bit mask of HDES field.
	LTDC_CDSR_HDES_Msk = 0x2
	// Bit HDES.
	LTDC_CDSR_HDES = 0x2
	// Currently not in horizontal Data Enable phase
	LTDC_CDSR_HDES_NotActive = 0x0
	// Currently in horizontal Data Enable phase
	LTDC_CDSR_HDES_Active = 0x1
	// Position of VDES field.
	LTDC_CDSR_VDES_Pos = 0x0
	// Bit mask of VDES field.
	LTDC_CDSR_VDES_Msk = 0x1
	// Bit VDES.
	LTDC_CDSR_VDES = 0x1
	// Currently not in vertical Data Enable phase
	LTDC_CDSR_VDES_NotActive = 0x0
	// Currently in vertical Data Enable phase
	LTDC_CDSR_VDES_Active = 0x1

	// LAYER.CR: Layerx Control Register
	// Position of CLUTEN field.
	LTDC_LAYER_CR_CLUTEN_Pos = 0x4
	// Bit mask of CLUTEN field.
	LTDC_LAYER_CR_CLUTEN_Msk = 0x10
	// Bit CLUTEN.
	LTDC_LAYER_CR_CLUTEN = 0x10
	// Color look-up table disabled
	LTDC_LAYER_CR_CLUTEN_Disabled = 0x0
	// Color look-up table enabled
	LTDC_LAYER_CR_CLUTEN_Enabled = 0x1
	// Position of COLKEN field.
	LTDC_LAYER_CR_COLKEN_Pos = 0x1
	// Bit mask of COLKEN field.
	LTDC_LAYER_CR_COLKEN_Msk = 0x2
	// Bit COLKEN.
	LTDC_LAYER_CR_COLKEN = 0x2
	// Color keying disabled
	LTDC_LAYER_CR_COLKEN_Disabled = 0x0
	// Color keying enabled
	LTDC_LAYER_CR_COLKEN_Enabled = 0x1
	// Position of LEN field.
	LTDC_LAYER_CR_LEN_Pos = 0x0
	// Bit mask of LEN field.
	LTDC_LAYER_CR_LEN_Msk = 0x1
	// Bit LEN.
	LTDC_LAYER_CR_LEN = 0x1
	// Layer disabled
	LTDC_LAYER_CR_LEN_Disabled = 0x0
	// Layer enabled
	LTDC_LAYER_CR_LEN_Enabled = 0x1

	// LAYER.WHPCR: Layerx Window Horizontal Position Configuration Register
	// Position of WHSPPOS field.
	LTDC_LAYER_WHPCR_WHSPPOS_Pos = 0x10
	// Bit mask of WHSPPOS field.
	LTDC_LAYER_WHPCR_WHSPPOS_Msk = 0xfff0000
	// Position of WHSTPOS field.
	LTDC_LAYER_WHPCR_WHSTPOS_Pos = 0x0
	// Bit mask of WHSTPOS field.
	LTDC_LAYER_WHPCR_WHSTPOS_Msk = 0xfff

	// LAYER.WVPCR: Layerx Window Vertical Position Configuration Register
	// Position of WVSPPOS field.
	LTDC_LAYER_WVPCR_WVSPPOS_Pos = 0x10
	// Bit mask of WVSPPOS field.
	LTDC_LAYER_WVPCR_WVSPPOS_Msk = 0x7ff0000
	// Position of WVSTPOS field.
	LTDC_LAYER_WVPCR_WVSTPOS_Pos = 0x0
	// Bit mask of WVSTPOS field.
	LTDC_LAYER_WVPCR_WVSTPOS_Msk = 0x7ff

	// LAYER.CKCR: Layerx Color Keying Configuration Register
	// Position of CKRED field.
	LTDC_LAYER_CKCR_CKRED_Pos = 0x10
	// Bit mask of CKRED field.
	LTDC_LAYER_CKCR_CKRED_Msk = 0xff0000
	// Position of CKGREEN field.
	LTDC_LAYER_CKCR_CKGREEN_Pos = 0x8
	// Bit mask of CKGREEN field.
	LTDC_LAYER_CKCR_CKGREEN_Msk = 0xff00
	// Position of CKBLUE field.
	LTDC_LAYER_CKCR_CKBLUE_Pos = 0x0
	// Bit mask of CKBLUE field.
	LTDC_LAYER_CKCR_CKBLUE_Msk = 0xff

	// LAYER.PFCR: Layerx Pixel Format Configuration Register
	// Position of PF field.
	LTDC_LAYER_PFCR_PF_Pos = 0x0
	// Bit mask of PF field.
	LTDC_LAYER_PFCR_PF_Msk = 0x7
	// ARGB8888
	LTDC_LAYER_PFCR_PF_ARGB8888 = 0x0
	// RGB888
	LTDC_LAYER_PFCR_PF_RGB888 = 0x1
	// RGB565
	LTDC_LAYER_PFCR_PF_RGB565 = 0x2
	// ARGB1555
	LTDC_LAYER_PFCR_PF_ARGB1555 = 0x3
	// ARGB4444
	LTDC_LAYER_PFCR_PF_ARGB4444 = 0x4
	// L8 (8-bit luminance)
	LTDC_LAYER_PFCR_PF_L8 = 0x5
	// AL44 (4-bit alpha, 4-bit luminance)
	LTDC_LAYER_PFCR_PF_AL44 = 0x6
	// AL88 (8-bit alpha, 8-bit luminance)
	LTDC_LAYER_PFCR_PF_AL88 = 0x7

	// LAYER.CACR: Layerx Constant Alpha Configuration Register
	// Position of CONSTA field.
	LTDC_LAYER_CACR_CONSTA_Pos = 0x0
	// Bit mask of CONSTA field.
	LTDC_LAYER_CACR_CONSTA_Msk = 0xff

	// LAYER.DCCR: Layerx Default Color Configuration Register
	// Position of DCALPHA field.
	LTDC_LAYER_DCCR_DCALPHA_Pos = 0x18
	// Bit mask of DCALPHA field.
	LTDC_LAYER_DCCR_DCALPHA_Msk = 0xff000000
	// Position of DCRED field.
	LTDC_LAYER_DCCR_DCRED_Pos = 0x10
	// Bit mask of DCRED field.
	LTDC_LAYER_DCCR_DCRED_Msk = 0xff0000
	// Position of DCGREEN field.
	LTDC_LAYER_DCCR_DCGREEN_Pos = 0x8
	// Bit mask of DCGREEN field.
	LTDC_LAYER_DCCR_DCGREEN_Msk = 0xff00
	// Position of DCBLUE field.
	LTDC_LAYER_DCCR_DCBLUE_Pos = 0x0
	// Bit mask of DCBLUE field.
	LTDC_LAYER_DCCR_DCBLUE_Msk = 0xff

	// LAYER.BFCR: Layerx Blending Factors Configuration Register
	// Position of BF1 field.
	LTDC_LAYER_BFCR_BF1_Pos = 0x8
	// Bit mask of BF1 field.
	LTDC_LAYER_BFCR_BF1_Msk = 0x700
	// BF1 = constant alpha
	LTDC_LAYER_BFCR_BF1_Constant = 0x4
	// BF1 = pixel alpha * constant alpha
	LTDC_LAYER_BFCR_BF1_Pixel = 0x6
	// Position of BF2 field.
	LTDC_LAYER_BFCR_BF2_Pos = 0x0
	// Bit mask of BF2 field.
	LTDC_LAYER_BFCR_BF2_Msk = 0x7
	// BF2 = 1 - constant alpha
	LTDC_LAYER_BFCR_BF2_Constant = 0x5
	// BF2 = 1 - pixel alpha * constant alpha
	LTDC_LAYER_BFCR_BF2_Pixel = 0x7

	// LAYER.CFBAR: Layerx Color Frame Buffer Address Register
	// Position of CFBADD field.
	LTDC_LAYER_CFBAR_CFBADD_Pos = 0x0
	// Bit mask of CFBADD field.
	LTDC_LAYER_CFBAR_CFBADD_Msk = 0xffffffff

	// LAYER.CFBLR: Layerx Color Frame Buffer Length Register
	// Position of CFBP field.
	LTDC_LAYER_CFBLR_CFBP_Pos = 0x10
	// Bit mask of CFBP field.
	LTDC_LAYER_CFBLR_CFBP_Msk = 0x1fff0000
	// Position of CFBLL field.
	LTDC_LAYER_CFBLR_CFBLL_Pos = 0x0
	// Bit mask of CFBLL field.
	LTDC_LAYER_CFBLR_CFBLL_Msk = 0x1fff

	// LAYER.CFBLNR: Layerx ColorFrame Buffer Line Number Register
	// Position of CFBLNBR field.
	LTDC_LAYER_CFBLNR_CFBLNBR_Pos = 0x0
	// Bit mask of CFBLNBR field.
	LTDC_LAYER_CFBLNR_CFBLNBR_Msk = 0x7ff

	// LAYER.CLUTWR: Layerx CLUT Write Register
	// Position of CLUTADD field.
	LTDC_LAYER_CLUTWR_CLUTADD_Pos = 0x18
	// Bit mask of CLUTADD field.
	LTDC_LAYER_CLUTWR_CLUTADD_Msk = 0xff000000
	// Position of RED field.
	LTDC_LAYER_CLUTWR_RED_Pos = 0x10
	// Bit mask of RED field.
	LTDC_LAYER_CLUTWR_RED_Msk = 0xff0000
	// Position of GREEN field.
	LTDC_LAYER_CLUTWR_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	LTDC_LAYER_CLUTWR_GREEN_Msk = 0xff00
	// Position of BLUE field.
	LTDC_LAYER_CLUTWR_BLUE_Pos = 0x0
	// Bit mask of BLUE field.
	LTDC_LAYER_CLUTWR_BLUE_Msk = 0xff
)

// Bitfields for SAI1: Serial audio interface
const (
	// GCR: Global configuration register
	// Position of SYNCIN field.
	SAI_GCR_SYNCIN_Pos = 0x0
	// Bit mask of SYNCIN field.
	SAI_GCR_SYNCIN_Msk = 0x3
	// Position of SYNCOUT field.
	SAI_GCR_SYNCOUT_Pos = 0x4
	// Bit mask of SYNCOUT field.
	SAI_GCR_SYNCOUT_Msk = 0x30

	// CH.CR1: AConfiguration register 1
	// Position of MCKDIV field.
	SAI_CH_CR1_MCKDIV_Pos = 0x14
	// Bit mask of MCKDIV field.
	SAI_CH_CR1_MCKDIV_Msk = 0xf00000
	// Position of NODIV field.
	SAI_CH_CR1_NODIV_Pos = 0x13
	// Bit mask of NODIV field.
	SAI_CH_CR1_NODIV_Msk = 0x80000
	// Bit NODIV.
	SAI_CH_CR1_NODIV = 0x80000
	// Master clock generator is enabled
	SAI_CH_CR1_NODIV_MasterClock = 0x0
	// No divider used in the clock generator (in this case Master Clock Divider bit has no effect)
	SAI_CH_CR1_NODIV_NoDiv = 0x1
	// Position of DMAEN field.
	SAI_CH_CR1_DMAEN_Pos = 0x11
	// Bit mask of DMAEN field.
	SAI_CH_CR1_DMAEN_Msk = 0x20000
	// Bit DMAEN.
	SAI_CH_CR1_DMAEN = 0x20000
	// DMA disabled
	SAI_CH_CR1_DMAEN_Disabled = 0x0
	// DMA enabled
	SAI_CH_CR1_DMAEN_Enabled = 0x1
	// Position of SAIEN field.
	SAI_CH_CR1_SAIEN_Pos = 0x10
	// Bit mask of SAIEN field.
	SAI_CH_CR1_SAIEN_Msk = 0x10000
	// Bit SAIEN.
	SAI_CH_CR1_SAIEN = 0x10000
	// SAI audio block disabled
	SAI_CH_CR1_SAIEN_Disabled = 0x0
	// SAI audio block enabled
	SAI_CH_CR1_SAIEN_Enabled = 0x1
	// Position of OUTDRIV field.
	SAI_CH_CR1_OUTDRIV_Pos = 0xd
	// Bit mask of OUTDRIV field.
	SAI_CH_CR1_OUTDRIV_Msk = 0x2000
	// Bit OUTDRIV.
	SAI_CH_CR1_OUTDRIV = 0x2000
	// Audio block output driven when SAIEN is set
	SAI_CH_CR1_OUTDRIV_OnStart = 0x0
	// Audio block output driven immediately after the setting of this bit
	SAI_CH_CR1_OUTDRIV_Immediately = 0x1
	// Position of MONO field.
	SAI_CH_CR1_MONO_Pos = 0xc
	// Bit mask of MONO field.
	SAI_CH_CR1_MONO_Msk = 0x1000
	// Bit MONO.
	SAI_CH_CR1_MONO = 0x1000
	// Stereo mode
	SAI_CH_CR1_MONO_Stereo = 0x0
	// Mono mode
	SAI_CH_CR1_MONO_Mono = 0x1
	// Position of SYNCEN field.
	SAI_CH_CR1_SYNCEN_Pos = 0xa
	// Bit mask of SYNCEN field.
	SAI_CH_CR1_SYNCEN_Msk = 0xc00
	// audio sub-block in asynchronous mode
	SAI_CH_CR1_SYNCEN_Asynchronous = 0x0
	// audio sub-block is synchronous with the other internal audio sub-block. In this case, the audio sub-block must be configured in slave mode
	SAI_CH_CR1_SYNCEN_Internal = 0x1
	// audio sub-block is synchronous with an external SAI embedded peripheral. In this case the audio sub-block should be configured in Slave mode
	SAI_CH_CR1_SYNCEN_External = 0x2
	// Position of CKSTR field.
	SAI_CH_CR1_CKSTR_Pos = 0x9
	// Bit mask of CKSTR field.
	SAI_CH_CR1_CKSTR_Msk = 0x200
	// Bit CKSTR.
	SAI_CH_CR1_CKSTR = 0x200
	// Data strobing edge is falling edge of SCK
	SAI_CH_CR1_CKSTR_FallingEdge = 0x0
	// Data strobing edge is rising edge of SCK
	SAI_CH_CR1_CKSTR_RisingEdge = 0x1
	// Position of LSBFIRST field.
	SAI_CH_CR1_LSBFIRST_Pos = 0x8
	// Bit mask of LSBFIRST field.
	SAI_CH_CR1_LSBFIRST_Msk = 0x100
	// Bit LSBFIRST.
	SAI_CH_CR1_LSBFIRST = 0x100
	// Data are transferred with MSB first
	SAI_CH_CR1_LSBFIRST_MsbFirst = 0x0
	// Data are transferred with LSB first
	SAI_CH_CR1_LSBFIRST_LsbFirst = 0x1
	// Position of DS field.
	SAI_CH_CR1_DS_Pos = 0x5
	// Bit mask of DS field.
	SAI_CH_CR1_DS_Msk = 0xe0
	// 8 bits
	SAI_CH_CR1_DS_Bit8 = 0x2
	// 10 bits
	SAI_CH_CR1_DS_Bit10 = 0x3
	// 16 bits
	SAI_CH_CR1_DS_Bit16 = 0x4
	// 20 bits
	SAI_CH_CR1_DS_Bit20 = 0x5
	// 24 bits
	SAI_CH_CR1_DS_Bit24 = 0x6
	// 32 bits
	SAI_CH_CR1_DS_Bit32 = 0x7
	// Position of PRTCFG field.
	SAI_CH_CR1_PRTCFG_Pos = 0x2
	// Bit mask of PRTCFG field.
	SAI_CH_CR1_PRTCFG_Msk = 0xc
	// Free protocol. Free protocol allows to use the powerful configuration of the audio block to address a specific audio protocol
	SAI_CH_CR1_PRTCFG_Free = 0x0
	// SPDIF protocol
	SAI_CH_CR1_PRTCFG_Spdif = 0x1
	// AC’97 protocol
	SAI_CH_CR1_PRTCFG_Ac97 = 0x2
	// Position of MODE field.
	SAI_CH_CR1_MODE_Pos = 0x0
	// Bit mask of MODE field.
	SAI_CH_CR1_MODE_Msk = 0x3
	// Master transmitter
	SAI_CH_CR1_MODE_MasterTx = 0x0
	// Master receiver
	SAI_CH_CR1_MODE_MasterRx = 0x1
	// Slave transmitter
	SAI_CH_CR1_MODE_SlaveTx = 0x2
	// Slave receiver
	SAI_CH_CR1_MODE_SlaveRx = 0x3

	// CH.CR2: AConfiguration register 2
	// Position of COMP field.
	SAI_CH_CR2_COMP_Pos = 0xe
	// Bit mask of COMP field.
	SAI_CH_CR2_COMP_Msk = 0xc000
	// No companding algorithm
	SAI_CH_CR2_COMP_NoCompanding = 0x0
	// μ-Law algorithm
	SAI_CH_CR2_COMP_MuLaw = 0x2
	// A-Law algorithm
	SAI_CH_CR2_COMP_ALaw = 0x3
	// Position of CPL field.
	SAI_CH_CR2_CPL_Pos = 0xd
	// Bit mask of CPL field.
	SAI_CH_CR2_CPL_Msk = 0x2000
	// Bit CPL.
	SAI_CH_CR2_CPL = 0x2000
	// 1’s complement representation
	SAI_CH_CR2_CPL_OnesComplement = 0x0
	// 2’s complement representation
	SAI_CH_CR2_CPL_TwosComplement = 0x1
	// Position of MUTECN field.
	SAI_CH_CR2_MUTECN_Pos = 0x7
	// Bit mask of MUTECN field.
	SAI_CH_CR2_MUTECN_Msk = 0x1f80
	// Position of MUTEVAL field.
	SAI_CH_CR2_MUTEVAL_Pos = 0x6
	// Bit mask of MUTEVAL field.
	SAI_CH_CR2_MUTEVAL_Msk = 0x40
	// Bit MUTEVAL.
	SAI_CH_CR2_MUTEVAL = 0x40
	// Bit value 0 is sent during the mute mode
	SAI_CH_CR2_MUTEVAL_SendZero = 0x0
	// Last values are sent during the mute mode
	SAI_CH_CR2_MUTEVAL_SendLast = 0x1
	// Position of MUTE field.
	SAI_CH_CR2_MUTE_Pos = 0x5
	// Bit mask of MUTE field.
	SAI_CH_CR2_MUTE_Msk = 0x20
	// Bit MUTE.
	SAI_CH_CR2_MUTE = 0x20
	// No mute mode
	SAI_CH_CR2_MUTE_Disabled = 0x0
	// Mute mode enabled
	SAI_CH_CR2_MUTE_Enabled = 0x1
	// Position of TRIS field.
	SAI_CH_CR2_TRIS_Pos = 0x4
	// Bit mask of TRIS field.
	SAI_CH_CR2_TRIS_Msk = 0x10
	// Bit TRIS.
	SAI_CH_CR2_TRIS = 0x10
	// Position of FFLUSH field.
	SAI_CH_CR2_FFLUSH_Pos = 0x3
	// Bit mask of FFLUSH field.
	SAI_CH_CR2_FFLUSH_Msk = 0x8
	// Bit FFLUSH.
	SAI_CH_CR2_FFLUSH = 0x8
	// No FIFO flush
	SAI_CH_CR2_FFLUSH_NoFlush = 0x0
	// FIFO flush. Programming this bit to 1 triggers the FIFO Flush. All the internal FIFO pointers (read and write) are cleared
	SAI_CH_CR2_FFLUSH_Flush = 0x1
	// Position of FTH field.
	SAI_CH_CR2_FTH_Pos = 0x0
	// Bit mask of FTH field.
	SAI_CH_CR2_FTH_Msk = 0x7
	// FIFO empty
	SAI_CH_CR2_FTH_Empty = 0x0
	// 1⁄4 FIFO
	SAI_CH_CR2_FTH_Quarter1 = 0x1
	// 1⁄2 FIFO
	SAI_CH_CR2_FTH_Quarter2 = 0x2
	// 3⁄4 FIFO
	SAI_CH_CR2_FTH_Quarter3 = 0x3
	// FIFO full
	SAI_CH_CR2_FTH_Full = 0x4

	// CH.FRCR: AFRCR
	// Position of FSOFF field.
	SAI_CH_FRCR_FSOFF_Pos = 0x12
	// Bit mask of FSOFF field.
	SAI_CH_FRCR_FSOFF_Msk = 0x40000
	// Bit FSOFF.
	SAI_CH_FRCR_FSOFF = 0x40000
	// FS is asserted on the first bit of the slot 0
	SAI_CH_FRCR_FSOFF_OnFirst = 0x0
	// FS is asserted one bit before the first bit of the slot 0
	SAI_CH_FRCR_FSOFF_BeforeFirst = 0x1
	// Position of FSPOL field.
	SAI_CH_FRCR_FSPOL_Pos = 0x11
	// Bit mask of FSPOL field.
	SAI_CH_FRCR_FSPOL_Msk = 0x20000
	// Bit FSPOL.
	SAI_CH_FRCR_FSPOL = 0x20000
	// FS is active low (falling edge)
	SAI_CH_FRCR_FSPOL_FallingEdge = 0x0
	// FS is active high (rising edge)
	SAI_CH_FRCR_FSPOL_RisingEdge = 0x1
	// Position of FSDEF field.
	SAI_CH_FRCR_FSDEF_Pos = 0x10
	// Bit mask of FSDEF field.
	SAI_CH_FRCR_FSDEF_Msk = 0x10000
	// Bit FSDEF.
	SAI_CH_FRCR_FSDEF = 0x10000
	// Position of FSALL field.
	SAI_CH_FRCR_FSALL_Pos = 0x8
	// Bit mask of FSALL field.
	SAI_CH_FRCR_FSALL_Msk = 0x7f00
	// Position of FRL field.
	SAI_CH_FRCR_FRL_Pos = 0x0
	// Bit mask of FRL field.
	SAI_CH_FRCR_FRL_Msk = 0xff

	// CH.SLOTR: ASlot register
	// Position of SLOTEN field.
	SAI_CH_SLOTR_SLOTEN_Pos = 0x10
	// Bit mask of SLOTEN field.
	SAI_CH_SLOTR_SLOTEN_Msk = 0xffff0000
	// Inactive slot
	SAI_CH_SLOTR_SLOTEN_Inactive = 0x0
	// Active slot
	SAI_CH_SLOTR_SLOTEN_Active = 0x1
	// Position of NBSLOT field.
	SAI_CH_SLOTR_NBSLOT_Pos = 0x8
	// Bit mask of NBSLOT field.
	SAI_CH_SLOTR_NBSLOT_Msk = 0xf00
	// Position of SLOTSZ field.
	SAI_CH_SLOTR_SLOTSZ_Pos = 0x6
	// Bit mask of SLOTSZ field.
	SAI_CH_SLOTR_SLOTSZ_Msk = 0xc0
	// The slot size is equivalent to the data size (specified in DS[3:0] in the SAI_xCR1 register)
	SAI_CH_SLOTR_SLOTSZ_DataSize = 0x0
	// 16-bit
	SAI_CH_SLOTR_SLOTSZ_Bit16 = 0x1
	// 32-bit
	SAI_CH_SLOTR_SLOTSZ_Bit32 = 0x2
	// Position of FBOFF field.
	SAI_CH_SLOTR_FBOFF_Pos = 0x0
	// Bit mask of FBOFF field.
	SAI_CH_SLOTR_FBOFF_Msk = 0x1f

	// CH.IM: AInterrupt mask register2
	// Position of LFSDETIE field.
	SAI_CH_IM_LFSDETIE_Pos = 0x6
	// Bit mask of LFSDETIE field.
	SAI_CH_IM_LFSDETIE_Msk = 0x40
	// Bit LFSDETIE.
	SAI_CH_IM_LFSDETIE = 0x40
	// Interrupt is disabled
	SAI_CH_IM_LFSDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_LFSDETIE_Enabled = 0x1
	// Position of AFSDETIE field.
	SAI_CH_IM_AFSDETIE_Pos = 0x5
	// Bit mask of AFSDETIE field.
	SAI_CH_IM_AFSDETIE_Msk = 0x20
	// Bit AFSDETIE.
	SAI_CH_IM_AFSDETIE = 0x20
	// Interrupt is disabled
	SAI_CH_IM_AFSDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_AFSDETIE_Enabled = 0x1
	// Position of CNRDYIE field.
	SAI_CH_IM_CNRDYIE_Pos = 0x4
	// Bit mask of CNRDYIE field.
	SAI_CH_IM_CNRDYIE_Msk = 0x10
	// Bit CNRDYIE.
	SAI_CH_IM_CNRDYIE = 0x10
	// Interrupt is disabled
	SAI_CH_IM_CNRDYIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_CNRDYIE_Enabled = 0x1
	// Position of FREQIE field.
	SAI_CH_IM_FREQIE_Pos = 0x3
	// Bit mask of FREQIE field.
	SAI_CH_IM_FREQIE_Msk = 0x8
	// Bit FREQIE.
	SAI_CH_IM_FREQIE = 0x8
	// Interrupt is disabled
	SAI_CH_IM_FREQIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_FREQIE_Enabled = 0x1
	// Position of WCKCFGIE field.
	SAI_CH_IM_WCKCFGIE_Pos = 0x2
	// Bit mask of WCKCFGIE field.
	SAI_CH_IM_WCKCFGIE_Msk = 0x4
	// Bit WCKCFGIE.
	SAI_CH_IM_WCKCFGIE = 0x4
	// Interrupt is disabled
	SAI_CH_IM_WCKCFGIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_WCKCFGIE_Enabled = 0x1
	// Position of MUTEDETIE field.
	SAI_CH_IM_MUTEDETIE_Pos = 0x1
	// Bit mask of MUTEDETIE field.
	SAI_CH_IM_MUTEDETIE_Msk = 0x2
	// Bit MUTEDETIE.
	SAI_CH_IM_MUTEDETIE = 0x2
	// Interrupt is disabled
	SAI_CH_IM_MUTEDETIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_MUTEDETIE_Enabled = 0x1
	// Position of OVRUDRIE field.
	SAI_CH_IM_OVRUDRIE_Pos = 0x0
	// Bit mask of OVRUDRIE field.
	SAI_CH_IM_OVRUDRIE_Msk = 0x1
	// Bit OVRUDRIE.
	SAI_CH_IM_OVRUDRIE = 0x1
	// Interrupt is disabled
	SAI_CH_IM_OVRUDRIE_Disabled = 0x0
	// Interrupt is enabled
	SAI_CH_IM_OVRUDRIE_Enabled = 0x1

	// CH.SR: AStatus register
	// Position of FLVL field.
	SAI_CH_SR_FLVL_Pos = 0x10
	// Bit mask of FLVL field.
	SAI_CH_SR_FLVL_Msk = 0x70000
	// FIFO empty
	SAI_CH_SR_FLVL_Empty = 0x0
	// FIFO <= 1⁄4 but not empty
	SAI_CH_SR_FLVL_Quarter1 = 0x1
	// 1⁄4 < FIFO <= 1⁄2
	SAI_CH_SR_FLVL_Quarter2 = 0x2
	// 1⁄2 < FIFO <= 3⁄4
	SAI_CH_SR_FLVL_Quarter3 = 0x3
	// 3⁄4 < FIFO but not full
	SAI_CH_SR_FLVL_Quarter4 = 0x4
	// FIFO full
	SAI_CH_SR_FLVL_Full = 0x5
	// Position of LFSDET field.
	SAI_CH_SR_LFSDET_Pos = 0x6
	// Bit mask of LFSDET field.
	SAI_CH_SR_LFSDET_Msk = 0x40
	// Bit LFSDET.
	SAI_CH_SR_LFSDET = 0x40
	// No error
	SAI_CH_SR_LFSDET_NoError = 0x0
	// Frame synchronization signal is not present at the right time
	SAI_CH_SR_LFSDET_NoSync = 0x1
	// Position of AFSDET field.
	SAI_CH_SR_AFSDET_Pos = 0x5
	// Bit mask of AFSDET field.
	SAI_CH_SR_AFSDET_Msk = 0x20
	// Bit AFSDET.
	SAI_CH_SR_AFSDET = 0x20
	// No error
	SAI_CH_SR_AFSDET_NoError = 0x0
	// Frame synchronization signal is detected earlier than expected
	SAI_CH_SR_AFSDET_EarlySync = 0x1
	// Position of CNRDY field.
	SAI_CH_SR_CNRDY_Pos = 0x4
	// Bit mask of CNRDY field.
	SAI_CH_SR_CNRDY_Msk = 0x10
	// Bit CNRDY.
	SAI_CH_SR_CNRDY = 0x10
	// External AC’97 Codec is ready
	SAI_CH_SR_CNRDY_Ready = 0x0
	// External AC’97 Codec is not ready
	SAI_CH_SR_CNRDY_NotReady = 0x1
	// Position of FREQ field.
	SAI_CH_SR_FREQ_Pos = 0x3
	// Bit mask of FREQ field.
	SAI_CH_SR_FREQ_Msk = 0x8
	// Bit FREQ.
	SAI_CH_SR_FREQ = 0x8
	// No FIFO request
	SAI_CH_SR_FREQ_NoRequest = 0x0
	// FIFO request to read or to write the SAI_xDR
	SAI_CH_SR_FREQ_Request = 0x1
	// Position of WCKCFG field.
	SAI_CH_SR_WCKCFG_Pos = 0x2
	// Bit mask of WCKCFG field.
	SAI_CH_SR_WCKCFG_Msk = 0x4
	// Bit WCKCFG.
	SAI_CH_SR_WCKCFG = 0x4
	// Clock configuration is correct
	SAI_CH_SR_WCKCFG_Correct = 0x0
	// Clock configuration does not respect the rule concerning the frame length specification
	SAI_CH_SR_WCKCFG_Wrong = 0x1
	// Position of MUTEDET field.
	SAI_CH_SR_MUTEDET_Pos = 0x1
	// Bit mask of MUTEDET field.
	SAI_CH_SR_MUTEDET_Msk = 0x2
	// Bit MUTEDET.
	SAI_CH_SR_MUTEDET = 0x2
	// No MUTE detection on the SD input line
	SAI_CH_SR_MUTEDET_NoMute = 0x0
	// MUTE value detected on the SD input line (0 value) for a specified number of consecutive audio frame
	SAI_CH_SR_MUTEDET_Mute = 0x1
	// Position of OVRUDR field.
	SAI_CH_SR_OVRUDR_Pos = 0x0
	// Bit mask of OVRUDR field.
	SAI_CH_SR_OVRUDR_Msk = 0x1
	// Bit OVRUDR.
	SAI_CH_SR_OVRUDR = 0x1
	// No overrun/underrun error
	SAI_CH_SR_OVRUDR_NoError = 0x0
	// Overrun/underrun error detection
	SAI_CH_SR_OVRUDR_Overrun = 0x1

	// CH.CLRFR: AClear flag register
	// Position of CLFSDET field.
	SAI_CH_CLRFR_CLFSDET_Pos = 0x6
	// Bit mask of CLFSDET field.
	SAI_CH_CLRFR_CLFSDET_Msk = 0x40
	// Bit CLFSDET.
	SAI_CH_CLRFR_CLFSDET = 0x40
	// Clears the LFSDET flag
	SAI_CH_CLRFR_CLFSDET_Clear = 0x1
	// Position of CAFSDET field.
	SAI_CH_CLRFR_CAFSDET_Pos = 0x5
	// Bit mask of CAFSDET field.
	SAI_CH_CLRFR_CAFSDET_Msk = 0x20
	// Bit CAFSDET.
	SAI_CH_CLRFR_CAFSDET = 0x20
	// Clears the AFSDET flag
	SAI_CH_CLRFR_CAFSDET_Clear = 0x1
	// Position of CCNRDY field.
	SAI_CH_CLRFR_CCNRDY_Pos = 0x4
	// Bit mask of CCNRDY field.
	SAI_CH_CLRFR_CCNRDY_Msk = 0x10
	// Bit CCNRDY.
	SAI_CH_CLRFR_CCNRDY = 0x10
	// Clears the CNRDY flag
	SAI_CH_CLRFR_CCNRDY_Clear = 0x1
	// Position of CWCKCFG field.
	SAI_CH_CLRFR_CWCKCFG_Pos = 0x2
	// Bit mask of CWCKCFG field.
	SAI_CH_CLRFR_CWCKCFG_Msk = 0x4
	// Bit CWCKCFG.
	SAI_CH_CLRFR_CWCKCFG = 0x4
	// Clears the WCKCFG flag
	SAI_CH_CLRFR_CWCKCFG_Clear = 0x1
	// Position of CMUTEDET field.
	SAI_CH_CLRFR_CMUTEDET_Pos = 0x1
	// Bit mask of CMUTEDET field.
	SAI_CH_CLRFR_CMUTEDET_Msk = 0x2
	// Bit CMUTEDET.
	SAI_CH_CLRFR_CMUTEDET = 0x2
	// Clears the MUTEDET flag
	SAI_CH_CLRFR_CMUTEDET_Clear = 0x1
	// Position of COVRUDR field.
	SAI_CH_CLRFR_COVRUDR_Pos = 0x0
	// Bit mask of COVRUDR field.
	SAI_CH_CLRFR_COVRUDR_Msk = 0x1
	// Bit COVRUDR.
	SAI_CH_CLRFR_COVRUDR = 0x1
	// Clears the OVRUDR flag
	SAI_CH_CLRFR_COVRUDR_Clear = 0x1

	// CH.DR: AData register
	// Position of DATA field.
	SAI_CH_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SAI_CH_DR_DATA_Msk = 0xffffffff
)

// Bitfields for DMA2D: DMA2D controller
const (
	// CR: control register
	// Position of MODE field.
	DMA2D_CR_MODE_Pos = 0x10
	// Bit mask of MODE field.
	DMA2D_CR_MODE_Msk = 0x30000
	// Memory-to-memory (FG fetch only)
	DMA2D_CR_MODE_MemoryToMemory = 0x0
	// Memory-to-memory with PFC (FG fetch only with FG PFC active)
	DMA2D_CR_MODE_MemoryToMemoryPFC = 0x1
	// Memory-to-memory with blending (FG and BG fetch with PFC and blending)
	DMA2D_CR_MODE_MemoryToMemoryPFCBlending = 0x2
	// Register-to-memory
	DMA2D_CR_MODE_RegisterToMemory = 0x3
	// Position of CEIE field.
	DMA2D_CR_CEIE_Pos = 0xd
	// Bit mask of CEIE field.
	DMA2D_CR_CEIE_Msk = 0x2000
	// Bit CEIE.
	DMA2D_CR_CEIE = 0x2000
	// CE interrupt disabled
	DMA2D_CR_CEIE_Disabled = 0x0
	// CE interrupt enabled
	DMA2D_CR_CEIE_Enabled = 0x1
	// Position of CTCIE field.
	DMA2D_CR_CTCIE_Pos = 0xc
	// Bit mask of CTCIE field.
	DMA2D_CR_CTCIE_Msk = 0x1000
	// Bit CTCIE.
	DMA2D_CR_CTCIE = 0x1000
	// CTC interrupt disabled
	DMA2D_CR_CTCIE_Disabled = 0x0
	// CTC interrupt enabled
	DMA2D_CR_CTCIE_Enabled = 0x1
	// Position of CAEIE field.
	DMA2D_CR_CAEIE_Pos = 0xb
	// Bit mask of CAEIE field.
	DMA2D_CR_CAEIE_Msk = 0x800
	// Bit CAEIE.
	DMA2D_CR_CAEIE = 0x800
	// CAE interrupt disabled
	DMA2D_CR_CAEIE_Disabled = 0x0
	// CAE interrupt enabled
	DMA2D_CR_CAEIE_Enabled = 0x1
	// Position of TWIE field.
	DMA2D_CR_TWIE_Pos = 0xa
	// Bit mask of TWIE field.
	DMA2D_CR_TWIE_Msk = 0x400
	// Bit TWIE.
	DMA2D_CR_TWIE = 0x400
	// TW interrupt disabled
	DMA2D_CR_TWIE_Disabled = 0x0
	// TW interrupt enabled
	DMA2D_CR_TWIE_Enabled = 0x1
	// Position of TCIE field.
	DMA2D_CR_TCIE_Pos = 0x9
	// Bit mask of TCIE field.
	DMA2D_CR_TCIE_Msk = 0x200
	// Bit TCIE.
	DMA2D_CR_TCIE = 0x200
	// TC interrupt disabled
	DMA2D_CR_TCIE_Disabled = 0x0
	// TC interrupt enabled
	DMA2D_CR_TCIE_Enabled = 0x1
	// Position of TEIE field.
	DMA2D_CR_TEIE_Pos = 0x8
	// Bit mask of TEIE field.
	DMA2D_CR_TEIE_Msk = 0x100
	// Bit TEIE.
	DMA2D_CR_TEIE = 0x100
	// TE interrupt disabled
	DMA2D_CR_TEIE_Disabled = 0x0
	// TE interrupt enabled
	DMA2D_CR_TEIE_Enabled = 0x1
	// Position of ABORT field.
	DMA2D_CR_ABORT_Pos = 0x2
	// Bit mask of ABORT field.
	DMA2D_CR_ABORT_Msk = 0x4
	// Bit ABORT.
	DMA2D_CR_ABORT = 0x4
	// Transfer abort requested
	DMA2D_CR_ABORT_AbortRequest = 0x1
	// Position of SUSP field.
	DMA2D_CR_SUSP_Pos = 0x1
	// Bit mask of SUSP field.
	DMA2D_CR_SUSP_Msk = 0x2
	// Bit SUSP.
	DMA2D_CR_SUSP = 0x2
	// Transfer not suspended
	DMA2D_CR_SUSP_NotSuspended = 0x0
	// Transfer suspended
	DMA2D_CR_SUSP_Suspended = 0x1
	// Position of START field.
	DMA2D_CR_START_Pos = 0x0
	// Bit mask of START field.
	DMA2D_CR_START_Msk = 0x1
	// Bit START.
	DMA2D_CR_START = 0x1
	// Launch the DMA2D
	DMA2D_CR_START_Start = 0x1

	// ISR: Interrupt Status Register
	// Position of CEIF field.
	DMA2D_ISR_CEIF_Pos = 0x5
	// Bit mask of CEIF field.
	DMA2D_ISR_CEIF_Msk = 0x20
	// Bit CEIF.
	DMA2D_ISR_CEIF = 0x20
	// Position of CTCIF field.
	DMA2D_ISR_CTCIF_Pos = 0x4
	// Bit mask of CTCIF field.
	DMA2D_ISR_CTCIF_Msk = 0x10
	// Bit CTCIF.
	DMA2D_ISR_CTCIF = 0x10
	// Position of CAEIF field.
	DMA2D_ISR_CAEIF_Pos = 0x3
	// Bit mask of CAEIF field.
	DMA2D_ISR_CAEIF_Msk = 0x8
	// Bit CAEIF.
	DMA2D_ISR_CAEIF = 0x8
	// Position of TWIF field.
	DMA2D_ISR_TWIF_Pos = 0x2
	// Bit mask of TWIF field.
	DMA2D_ISR_TWIF_Msk = 0x4
	// Bit TWIF.
	DMA2D_ISR_TWIF = 0x4
	// Position of TCIF field.
	DMA2D_ISR_TCIF_Pos = 0x1
	// Bit mask of TCIF field.
	DMA2D_ISR_TCIF_Msk = 0x2
	// Bit TCIF.
	DMA2D_ISR_TCIF = 0x2
	// Position of TEIF field.
	DMA2D_ISR_TEIF_Pos = 0x0
	// Bit mask of TEIF field.
	DMA2D_ISR_TEIF_Msk = 0x1
	// Bit TEIF.
	DMA2D_ISR_TEIF = 0x1

	// IFCR: interrupt flag clear register
	// Position of CCEIF field.
	DMA2D_IFCR_CCEIF_Pos = 0x5
	// Bit mask of CCEIF field.
	DMA2D_IFCR_CCEIF_Msk = 0x20
	// Bit CCEIF.
	DMA2D_IFCR_CCEIF = 0x20
	// Clear the CEIF flag in the ISR register
	DMA2D_IFCR_CCEIF_Clear = 0x1
	// Position of CCTCIF field.
	DMA2D_IFCR_CCTCIF_Pos = 0x4
	// Bit mask of CCTCIF field.
	DMA2D_IFCR_CCTCIF_Msk = 0x10
	// Bit CCTCIF.
	DMA2D_IFCR_CCTCIF = 0x10
	// Clear the CTCIF flag in the ISR register
	DMA2D_IFCR_CCTCIF_Clear = 0x1
	// Position of CAECIF field.
	DMA2D_IFCR_CAECIF_Pos = 0x3
	// Bit mask of CAECIF field.
	DMA2D_IFCR_CAECIF_Msk = 0x8
	// Bit CAECIF.
	DMA2D_IFCR_CAECIF = 0x8
	// Clear the CAEIF flag in the ISR register
	DMA2D_IFCR_CAECIF_Clear = 0x1
	// Position of CTWIF field.
	DMA2D_IFCR_CTWIF_Pos = 0x2
	// Bit mask of CTWIF field.
	DMA2D_IFCR_CTWIF_Msk = 0x4
	// Bit CTWIF.
	DMA2D_IFCR_CTWIF = 0x4
	// Clear the TWIF flag in the ISR register
	DMA2D_IFCR_CTWIF_Clear = 0x1
	// Position of CTCIF field.
	DMA2D_IFCR_CTCIF_Pos = 0x1
	// Bit mask of CTCIF field.
	DMA2D_IFCR_CTCIF_Msk = 0x2
	// Bit CTCIF.
	DMA2D_IFCR_CTCIF = 0x2
	// Clear the TCIF flag in the ISR register
	DMA2D_IFCR_CTCIF_Clear = 0x1
	// Position of CTEIF field.
	DMA2D_IFCR_CTEIF_Pos = 0x0
	// Bit mask of CTEIF field.
	DMA2D_IFCR_CTEIF_Msk = 0x1
	// Bit CTEIF.
	DMA2D_IFCR_CTEIF = 0x1
	// Clear the TEIF flag in the ISR register
	DMA2D_IFCR_CTEIF_Clear = 0x1

	// FGMAR: foreground memory address register
	// Position of MA field.
	DMA2D_FGMAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA2D_FGMAR_MA_Msk = 0xffffffff

	// FGOR: foreground offset register
	// Position of LO field.
	DMA2D_FGOR_LO_Pos = 0x0
	// Bit mask of LO field.
	DMA2D_FGOR_LO_Msk = 0x3fff

	// BGMAR: background memory address register
	// Position of MA field.
	DMA2D_BGMAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA2D_BGMAR_MA_Msk = 0xffffffff

	// BGOR: background offset register
	// Position of LO field.
	DMA2D_BGOR_LO_Pos = 0x0
	// Bit mask of LO field.
	DMA2D_BGOR_LO_Msk = 0x3fff

	// FGPFCCR: foreground PFC control register
	// Position of ALPHA field.
	DMA2D_FGPFCCR_ALPHA_Pos = 0x18
	// Bit mask of ALPHA field.
	DMA2D_FGPFCCR_ALPHA_Msk = 0xff000000
	// Position of AM field.
	DMA2D_FGPFCCR_AM_Pos = 0x10
	// Bit mask of AM field.
	DMA2D_FGPFCCR_AM_Msk = 0x30000
	// No modification of alpha channel
	DMA2D_FGPFCCR_AM_NoModify = 0x0
	// Replace with value in ALPHA[7:0]
	DMA2D_FGPFCCR_AM_Replace = 0x1
	// Multiply with value in ALPHA[7:0]
	DMA2D_FGPFCCR_AM_Multiply = 0x2
	// Position of CS field.
	DMA2D_FGPFCCR_CS_Pos = 0x8
	// Bit mask of CS field.
	DMA2D_FGPFCCR_CS_Msk = 0xff00
	// Position of START field.
	DMA2D_FGPFCCR_START_Pos = 0x5
	// Bit mask of START field.
	DMA2D_FGPFCCR_START_Msk = 0x20
	// Bit START.
	DMA2D_FGPFCCR_START = 0x20
	// Start the automatic loading of the CLUT
	DMA2D_FGPFCCR_START_Start = 0x1
	// Position of CCM field.
	DMA2D_FGPFCCR_CCM_Pos = 0x4
	// Bit mask of CCM field.
	DMA2D_FGPFCCR_CCM_Msk = 0x10
	// Bit CCM.
	DMA2D_FGPFCCR_CCM = 0x10
	// CLUT color format ARGB8888
	DMA2D_FGPFCCR_CCM_ARGB8888 = 0x0
	// CLUT color format RGB888
	DMA2D_FGPFCCR_CCM_RGB888 = 0x1
	// Position of CM field.
	DMA2D_FGPFCCR_CM_Pos = 0x0
	// Bit mask of CM field.
	DMA2D_FGPFCCR_CM_Msk = 0xf
	// Color mode ARGB8888
	DMA2D_FGPFCCR_CM_ARGB8888 = 0x0
	// Color mode RGB888
	DMA2D_FGPFCCR_CM_RGB888 = 0x1
	// Color mode RGB565
	DMA2D_FGPFCCR_CM_RGB565 = 0x2
	// Color mode ARGB1555
	DMA2D_FGPFCCR_CM_ARGB1555 = 0x3
	// Color mode ARGB4444
	DMA2D_FGPFCCR_CM_ARGB4444 = 0x4
	// Color mode L8
	DMA2D_FGPFCCR_CM_L8 = 0x5
	// Color mode AL44
	DMA2D_FGPFCCR_CM_AL44 = 0x6
	// Color mode AL88
	DMA2D_FGPFCCR_CM_AL88 = 0x7
	// Color mode L4
	DMA2D_FGPFCCR_CM_L4 = 0x8
	// Color mode A8
	DMA2D_FGPFCCR_CM_A8 = 0x9
	// Color mode A4
	DMA2D_FGPFCCR_CM_A4 = 0xa

	// FGCOLR: foreground color register
	// Position of RED field.
	DMA2D_FGCOLR_RED_Pos = 0x10
	// Bit mask of RED field.
	DMA2D_FGCOLR_RED_Msk = 0xff0000
	// Position of GREEN field.
	DMA2D_FGCOLR_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	DMA2D_FGCOLR_GREEN_Msk = 0xff00
	// Position of BLUE field.
	DMA2D_FGCOLR_BLUE_Pos = 0x0
	// Bit mask of BLUE field.
	DMA2D_FGCOLR_BLUE_Msk = 0xff

	// BGPFCCR: background PFC control register
	// Position of ALPHA field.
	DMA2D_BGPFCCR_ALPHA_Pos = 0x18
	// Bit mask of ALPHA field.
	DMA2D_BGPFCCR_ALPHA_Msk = 0xff000000
	// Position of AM field.
	DMA2D_BGPFCCR_AM_Pos = 0x10
	// Bit mask of AM field.
	DMA2D_BGPFCCR_AM_Msk = 0x30000
	// No modification of alpha channel
	DMA2D_BGPFCCR_AM_NoModify = 0x0
	// Replace with value in ALPHA[7:0]
	DMA2D_BGPFCCR_AM_Replace = 0x1
	// Multiply with value in ALPHA[7:0]
	DMA2D_BGPFCCR_AM_Multiply = 0x2
	// Position of CS field.
	DMA2D_BGPFCCR_CS_Pos = 0x8
	// Bit mask of CS field.
	DMA2D_BGPFCCR_CS_Msk = 0xff00
	// Position of START field.
	DMA2D_BGPFCCR_START_Pos = 0x5
	// Bit mask of START field.
	DMA2D_BGPFCCR_START_Msk = 0x20
	// Bit START.
	DMA2D_BGPFCCR_START = 0x20
	// Start the automatic loading of the CLUT
	DMA2D_BGPFCCR_START_Start = 0x1
	// Position of CCM field.
	DMA2D_BGPFCCR_CCM_Pos = 0x4
	// Bit mask of CCM field.
	DMA2D_BGPFCCR_CCM_Msk = 0x10
	// Bit CCM.
	DMA2D_BGPFCCR_CCM = 0x10
	// CLUT color format ARGB8888
	DMA2D_BGPFCCR_CCM_ARGB8888 = 0x0
	// CLUT color format RGB888
	DMA2D_BGPFCCR_CCM_RGB888 = 0x1
	// Position of CM field.
	DMA2D_BGPFCCR_CM_Pos = 0x0
	// Bit mask of CM field.
	DMA2D_BGPFCCR_CM_Msk = 0xf
	// Color mode ARGB8888
	DMA2D_BGPFCCR_CM_ARGB8888 = 0x0
	// Color mode RGB888
	DMA2D_BGPFCCR_CM_RGB888 = 0x1
	// Color mode RGB565
	DMA2D_BGPFCCR_CM_RGB565 = 0x2
	// Color mode ARGB1555
	DMA2D_BGPFCCR_CM_ARGB1555 = 0x3
	// Color mode ARGB4444
	DMA2D_BGPFCCR_CM_ARGB4444 = 0x4
	// Color mode L8
	DMA2D_BGPFCCR_CM_L8 = 0x5
	// Color mode AL44
	DMA2D_BGPFCCR_CM_AL44 = 0x6
	// Color mode AL88
	DMA2D_BGPFCCR_CM_AL88 = 0x7
	// Color mode L4
	DMA2D_BGPFCCR_CM_L4 = 0x8
	// Color mode A8
	DMA2D_BGPFCCR_CM_A8 = 0x9
	// Color mode A4
	DMA2D_BGPFCCR_CM_A4 = 0xa

	// BGCOLR: background color register
	// Position of RED field.
	DMA2D_BGCOLR_RED_Pos = 0x10
	// Bit mask of RED field.
	DMA2D_BGCOLR_RED_Msk = 0xff0000
	// Position of GREEN field.
	DMA2D_BGCOLR_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	DMA2D_BGCOLR_GREEN_Msk = 0xff00
	// Position of BLUE field.
	DMA2D_BGCOLR_BLUE_Pos = 0x0
	// Bit mask of BLUE field.
	DMA2D_BGCOLR_BLUE_Msk = 0xff

	// FGCMAR: foreground CLUT memory address register
	// Position of MA field.
	DMA2D_FGCMAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA2D_FGCMAR_MA_Msk = 0xffffffff

	// BGCMAR: background CLUT memory address register
	// Position of MA field.
	DMA2D_BGCMAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA2D_BGCMAR_MA_Msk = 0xffffffff

	// OPFCCR: output PFC control register
	// Position of CM field.
	DMA2D_OPFCCR_CM_Pos = 0x0
	// Bit mask of CM field.
	DMA2D_OPFCCR_CM_Msk = 0x7
	// ARGB8888
	DMA2D_OPFCCR_CM_ARGB8888 = 0x0
	// RGB888
	DMA2D_OPFCCR_CM_RGB888 = 0x1
	// RGB565
	DMA2D_OPFCCR_CM_RGB565 = 0x2
	// ARGB1555
	DMA2D_OPFCCR_CM_ARGB1555 = 0x3
	// ARGB4444
	DMA2D_OPFCCR_CM_ARGB4444 = 0x4

	// OCOLR: output color register
	// Position of APLHA field.
	DMA2D_OCOLR_APLHA_Pos = 0x18
	// Bit mask of APLHA field.
	DMA2D_OCOLR_APLHA_Msk = 0xff000000
	// Position of RED field.
	DMA2D_OCOLR_RED_Pos = 0x10
	// Bit mask of RED field.
	DMA2D_OCOLR_RED_Msk = 0xff0000
	// Position of GREEN field.
	DMA2D_OCOLR_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	DMA2D_OCOLR_GREEN_Msk = 0xff00
	// Position of BLUE field.
	DMA2D_OCOLR_BLUE_Pos = 0x0
	// Bit mask of BLUE field.
	DMA2D_OCOLR_BLUE_Msk = 0xff

	// OMAR: output memory address register
	// Position of MA field.
	DMA2D_OMAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA2D_OMAR_MA_Msk = 0xffffffff

	// OOR: output offset register
	// Position of LO field.
	DMA2D_OOR_LO_Pos = 0x0
	// Bit mask of LO field.
	DMA2D_OOR_LO_Msk = 0x3fff

	// NLR: number of line register
	// Position of PL field.
	DMA2D_NLR_PL_Pos = 0x10
	// Bit mask of PL field.
	DMA2D_NLR_PL_Msk = 0x3fff0000
	// Position of NL field.
	DMA2D_NLR_NL_Pos = 0x0
	// Bit mask of NL field.
	DMA2D_NLR_NL_Msk = 0xffff

	// LWR: line watermark register
	// Position of LW field.
	DMA2D_LWR_LW_Pos = 0x0
	// Bit mask of LW field.
	DMA2D_LWR_LW_Msk = 0xffff

	// AMTCR: AHB master timer configuration register
	// Position of DT field.
	DMA2D_AMTCR_DT_Pos = 0x8
	// Bit mask of DT field.
	DMA2D_AMTCR_DT_Msk = 0xff00
	// Position of EN field.
	DMA2D_AMTCR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA2D_AMTCR_EN_Msk = 0x1
	// Bit EN.
	DMA2D_AMTCR_EN = 0x1
	// Disabled AHB/AXI dead-time functionality
	DMA2D_AMTCR_EN_Disabled = 0x0
	// Enabled AHB/AXI dead-time functionality
	DMA2D_AMTCR_EN_Enabled = 0x1

	// FGCLUT: FGCLUT
	// Position of APLHA field.
	DMA2D_FGCLUT_APLHA_Pos = 0x18
	// Bit mask of APLHA field.
	DMA2D_FGCLUT_APLHA_Msk = 0xff000000
	// Position of RED field.
	DMA2D_FGCLUT_RED_Pos = 0x10
	// Bit mask of RED field.
	DMA2D_FGCLUT_RED_Msk = 0xff0000
	// Position of GREEN field.
	DMA2D_FGCLUT_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	DMA2D_FGCLUT_GREEN_Msk = 0xff00
	// Position of BLUE field.
	DMA2D_FGCLUT_BLUE_Pos = 0x0
	// Bit mask of BLUE field.
	DMA2D_FGCLUT_BLUE_Msk = 0xff

	// BGCLUT: BGCLUT
	// Position of APLHA field.
	DMA2D_BGCLUT_APLHA_Pos = 0x18
	// Bit mask of APLHA field.
	DMA2D_BGCLUT_APLHA_Msk = 0xff000000
	// Position of RED field.
	DMA2D_BGCLUT_RED_Pos = 0x10
	// Bit mask of RED field.
	DMA2D_BGCLUT_RED_Msk = 0xff0000
	// Position of GREEN field.
	DMA2D_BGCLUT_GREEN_Pos = 0x8
	// Bit mask of GREEN field.
	DMA2D_BGCLUT_GREEN_Msk = 0xff00
	// Position of BLUE field.
	DMA2D_BGCLUT_BLUE_Pos = 0x0
	// Bit mask of BLUE field.
	DMA2D_BGCLUT_BLUE_Msk = 0xff
)

// Bitfields for QUADSPI: QuadSPI interface
const (
	// CR: control register
	// Position of PRESCALER field.
	QUADSPI_CR_PRESCALER_Pos = 0x18
	// Bit mask of PRESCALER field.
	QUADSPI_CR_PRESCALER_Msk = 0xff000000
	// Position of PMM field.
	QUADSPI_CR_PMM_Pos = 0x17
	// Bit mask of PMM field.
	QUADSPI_CR_PMM_Msk = 0x800000
	// Bit PMM.
	QUADSPI_CR_PMM = 0x800000
	// Position of APMS field.
	QUADSPI_CR_APMS_Pos = 0x16
	// Bit mask of APMS field.
	QUADSPI_CR_APMS_Msk = 0x400000
	// Bit APMS.
	QUADSPI_CR_APMS = 0x400000
	// Position of TOIE field.
	QUADSPI_CR_TOIE_Pos = 0x14
	// Bit mask of TOIE field.
	QUADSPI_CR_TOIE_Msk = 0x100000
	// Bit TOIE.
	QUADSPI_CR_TOIE = 0x100000
	// Position of SMIE field.
	QUADSPI_CR_SMIE_Pos = 0x13
	// Bit mask of SMIE field.
	QUADSPI_CR_SMIE_Msk = 0x80000
	// Bit SMIE.
	QUADSPI_CR_SMIE = 0x80000
	// Position of FTIE field.
	QUADSPI_CR_FTIE_Pos = 0x12
	// Bit mask of FTIE field.
	QUADSPI_CR_FTIE_Msk = 0x40000
	// Bit FTIE.
	QUADSPI_CR_FTIE = 0x40000
	// Position of TCIE field.
	QUADSPI_CR_TCIE_Pos = 0x11
	// Bit mask of TCIE field.
	QUADSPI_CR_TCIE_Msk = 0x20000
	// Bit TCIE.
	QUADSPI_CR_TCIE = 0x20000
	// Position of TEIE field.
	QUADSPI_CR_TEIE_Pos = 0x10
	// Bit mask of TEIE field.
	QUADSPI_CR_TEIE_Msk = 0x10000
	// Bit TEIE.
	QUADSPI_CR_TEIE = 0x10000
	// Position of FTHRES field.
	QUADSPI_CR_FTHRES_Pos = 0x8
	// Bit mask of FTHRES field.
	QUADSPI_CR_FTHRES_Msk = 0x1f00
	// Position of FSEL field.
	QUADSPI_CR_FSEL_Pos = 0x7
	// Bit mask of FSEL field.
	QUADSPI_CR_FSEL_Msk = 0x80
	// Bit FSEL.
	QUADSPI_CR_FSEL = 0x80
	// Position of DFM field.
	QUADSPI_CR_DFM_Pos = 0x6
	// Bit mask of DFM field.
	QUADSPI_CR_DFM_Msk = 0x40
	// Bit DFM.
	QUADSPI_CR_DFM = 0x40
	// Position of SSHIFT field.
	QUADSPI_CR_SSHIFT_Pos = 0x4
	// Bit mask of SSHIFT field.
	QUADSPI_CR_SSHIFT_Msk = 0x10
	// Bit SSHIFT.
	QUADSPI_CR_SSHIFT = 0x10
	// Position of TCEN field.
	QUADSPI_CR_TCEN_Pos = 0x3
	// Bit mask of TCEN field.
	QUADSPI_CR_TCEN_Msk = 0x8
	// Bit TCEN.
	QUADSPI_CR_TCEN = 0x8
	// Position of DMAEN field.
	QUADSPI_CR_DMAEN_Pos = 0x2
	// Bit mask of DMAEN field.
	QUADSPI_CR_DMAEN_Msk = 0x4
	// Bit DMAEN.
	QUADSPI_CR_DMAEN = 0x4
	// Position of ABORT field.
	QUADSPI_CR_ABORT_Pos = 0x1
	// Bit mask of ABORT field.
	QUADSPI_CR_ABORT_Msk = 0x2
	// Bit ABORT.
	QUADSPI_CR_ABORT = 0x2
	// Position of EN field.
	QUADSPI_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	QUADSPI_CR_EN_Msk = 0x1
	// Bit EN.
	QUADSPI_CR_EN = 0x1

	// DCR: device configuration register
	// Position of FSIZE field.
	QUADSPI_DCR_FSIZE_Pos = 0x10
	// Bit mask of FSIZE field.
	QUADSPI_DCR_FSIZE_Msk = 0x1f0000
	// Position of CSHT field.
	QUADSPI_DCR_CSHT_Pos = 0x8
	// Bit mask of CSHT field.
	QUADSPI_DCR_CSHT_Msk = 0x700
	// Position of CKMODE field.
	QUADSPI_DCR_CKMODE_Pos = 0x0
	// Bit mask of CKMODE field.
	QUADSPI_DCR_CKMODE_Msk = 0x1
	// Bit CKMODE.
	QUADSPI_DCR_CKMODE = 0x1

	// SR: status register
	// Position of FLEVEL field.
	QUADSPI_SR_FLEVEL_Pos = 0x8
	// Bit mask of FLEVEL field.
	QUADSPI_SR_FLEVEL_Msk = 0x7f00
	// Position of BUSY field.
	QUADSPI_SR_BUSY_Pos = 0x5
	// Bit mask of BUSY field.
	QUADSPI_SR_BUSY_Msk = 0x20
	// Bit BUSY.
	QUADSPI_SR_BUSY = 0x20
	// Position of TOF field.
	QUADSPI_SR_TOF_Pos = 0x4
	// Bit mask of TOF field.
	QUADSPI_SR_TOF_Msk = 0x10
	// Bit TOF.
	QUADSPI_SR_TOF = 0x10
	// Position of SMF field.
	QUADSPI_SR_SMF_Pos = 0x3
	// Bit mask of SMF field.
	QUADSPI_SR_SMF_Msk = 0x8
	// Bit SMF.
	QUADSPI_SR_SMF = 0x8
	// Position of FTF field.
	QUADSPI_SR_FTF_Pos = 0x2
	// Bit mask of FTF field.
	QUADSPI_SR_FTF_Msk = 0x4
	// Bit FTF.
	QUADSPI_SR_FTF = 0x4
	// Position of TCF field.
	QUADSPI_SR_TCF_Pos = 0x1
	// Bit mask of TCF field.
	QUADSPI_SR_TCF_Msk = 0x2
	// Bit TCF.
	QUADSPI_SR_TCF = 0x2
	// Position of TEF field.
	QUADSPI_SR_TEF_Pos = 0x0
	// Bit mask of TEF field.
	QUADSPI_SR_TEF_Msk = 0x1
	// Bit TEF.
	QUADSPI_SR_TEF = 0x1

	// FCR: flag clear register
	// Position of CTOF field.
	QUADSPI_FCR_CTOF_Pos = 0x4
	// Bit mask of CTOF field.
	QUADSPI_FCR_CTOF_Msk = 0x10
	// Bit CTOF.
	QUADSPI_FCR_CTOF = 0x10
	// Position of CSMF field.
	QUADSPI_FCR_CSMF_Pos = 0x3
	// Bit mask of CSMF field.
	QUADSPI_FCR_CSMF_Msk = 0x8
	// Bit CSMF.
	QUADSPI_FCR_CSMF = 0x8
	// Position of CTCF field.
	QUADSPI_FCR_CTCF_Pos = 0x1
	// Bit mask of CTCF field.
	QUADSPI_FCR_CTCF_Msk = 0x2
	// Bit CTCF.
	QUADSPI_FCR_CTCF = 0x2
	// Position of CTEF field.
	QUADSPI_FCR_CTEF_Pos = 0x0
	// Bit mask of CTEF field.
	QUADSPI_FCR_CTEF_Msk = 0x1
	// Bit CTEF.
	QUADSPI_FCR_CTEF = 0x1

	// DLR: data length register
	// Position of DL field.
	QUADSPI_DLR_DL_Pos = 0x0
	// Bit mask of DL field.
	QUADSPI_DLR_DL_Msk = 0xffffffff

	// CCR: communication configuration register
	// Position of DDRM field.
	QUADSPI_CCR_DDRM_Pos = 0x1f
	// Bit mask of DDRM field.
	QUADSPI_CCR_DDRM_Msk = 0x80000000
	// Bit DDRM.
	QUADSPI_CCR_DDRM = 0x80000000
	// Position of DHHC field.
	QUADSPI_CCR_DHHC_Pos = 0x1e
	// Bit mask of DHHC field.
	QUADSPI_CCR_DHHC_Msk = 0x40000000
	// Bit DHHC.
	QUADSPI_CCR_DHHC = 0x40000000
	// Position of SIOO field.
	QUADSPI_CCR_SIOO_Pos = 0x1c
	// Bit mask of SIOO field.
	QUADSPI_CCR_SIOO_Msk = 0x10000000
	// Bit SIOO.
	QUADSPI_CCR_SIOO = 0x10000000
	// Position of FMODE field.
	QUADSPI_CCR_FMODE_Pos = 0x1a
	// Bit mask of FMODE field.
	QUADSPI_CCR_FMODE_Msk = 0xc000000
	// Position of DMODE field.
	QUADSPI_CCR_DMODE_Pos = 0x18
	// Bit mask of DMODE field.
	QUADSPI_CCR_DMODE_Msk = 0x3000000
	// Position of DCYC field.
	QUADSPI_CCR_DCYC_Pos = 0x12
	// Bit mask of DCYC field.
	QUADSPI_CCR_DCYC_Msk = 0x7c0000
	// Position of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Pos = 0x10
	// Bit mask of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Msk = 0x30000
	// Position of ABMODE field.
	QUADSPI_CCR_ABMODE_Pos = 0xe
	// Bit mask of ABMODE field.
	QUADSPI_CCR_ABMODE_Msk = 0xc000
	// Position of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Pos = 0xc
	// Bit mask of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Msk = 0x3000
	// Position of ADMODE field.
	QUADSPI_CCR_ADMODE_Pos = 0xa
	// Bit mask of ADMODE field.
	QUADSPI_CCR_ADMODE_Msk = 0xc00
	// Position of IMODE field.
	QUADSPI_CCR_IMODE_Pos = 0x8
	// Bit mask of IMODE field.
	QUADSPI_CCR_IMODE_Msk = 0x300
	// Position of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Pos = 0x0
	// Bit mask of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Msk = 0xff

	// AR: address register
	// Position of ADDRESS field.
	QUADSPI_AR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	QUADSPI_AR_ADDRESS_Msk = 0xffffffff

	// ABR: ABR
	// Position of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Pos = 0x0
	// Bit mask of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Msk = 0xffffffff

	// DR: data register
	// Position of DATA field.
	QUADSPI_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	QUADSPI_DR_DATA_Msk = 0xffffffff

	// PSMKR: polling status mask register
	// Position of MASK field.
	QUADSPI_PSMKR_MASK_Pos = 0x0
	// Bit mask of MASK field.
	QUADSPI_PSMKR_MASK_Msk = 0xffffffff

	// PSMAR: polling status match register
	// Position of MATCH field.
	QUADSPI_PSMAR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	QUADSPI_PSMAR_MATCH_Msk = 0xffffffff

	// PIR: polling interval register
	// Position of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Pos = 0x0
	// Bit mask of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Msk = 0xffff

	// LPTR: low-power timeout register
	// Position of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Msk = 0xffff
)

// Bitfields for CEC: HDMI-CEC controller
const (
	// CR: control register
	// Position of TXEOM field.
	CEC_CR_TXEOM_Pos = 0x2
	// Bit mask of TXEOM field.
	CEC_CR_TXEOM_Msk = 0x4
	// Bit TXEOM.
	CEC_CR_TXEOM = 0x4
	// Position of TXSOM field.
	CEC_CR_TXSOM_Pos = 0x1
	// Bit mask of TXSOM field.
	CEC_CR_TXSOM_Msk = 0x2
	// Bit TXSOM.
	CEC_CR_TXSOM = 0x2
	// Position of CECEN field.
	CEC_CR_CECEN_Pos = 0x0
	// Bit mask of CECEN field.
	CEC_CR_CECEN_Msk = 0x1
	// Bit CECEN.
	CEC_CR_CECEN = 0x1

	// CFGR: configuration register
	// Position of SFT field.
	CEC_CFGR_SFT_Pos = 0x0
	// Bit mask of SFT field.
	CEC_CFGR_SFT_Msk = 0x7
	// Position of RXTOL field.
	CEC_CFGR_RXTOL_Pos = 0x3
	// Bit mask of RXTOL field.
	CEC_CFGR_RXTOL_Msk = 0x8
	// Bit RXTOL.
	CEC_CFGR_RXTOL = 0x8
	// Position of BRESTP field.
	CEC_CFGR_BRESTP_Pos = 0x4
	// Bit mask of BRESTP field.
	CEC_CFGR_BRESTP_Msk = 0x10
	// Bit BRESTP.
	CEC_CFGR_BRESTP = 0x10
	// Position of BREGEN field.
	CEC_CFGR_BREGEN_Pos = 0x5
	// Bit mask of BREGEN field.
	CEC_CFGR_BREGEN_Msk = 0x20
	// Bit BREGEN.
	CEC_CFGR_BREGEN = 0x20
	// Position of LBPEGEN field.
	CEC_CFGR_LBPEGEN_Pos = 0x6
	// Bit mask of LBPEGEN field.
	CEC_CFGR_LBPEGEN_Msk = 0x40
	// Bit LBPEGEN.
	CEC_CFGR_LBPEGEN = 0x40
	// Position of BRDNOGEN field.
	CEC_CFGR_BRDNOGEN_Pos = 0x7
	// Bit mask of BRDNOGEN field.
	CEC_CFGR_BRDNOGEN_Msk = 0x80
	// Bit BRDNOGEN.
	CEC_CFGR_BRDNOGEN = 0x80
	// Position of SFTOP field.
	CEC_CFGR_SFTOP_Pos = 0x8
	// Bit mask of SFTOP field.
	CEC_CFGR_SFTOP_Msk = 0x100
	// Bit SFTOP.
	CEC_CFGR_SFTOP = 0x100
	// Position of OAR field.
	CEC_CFGR_OAR_Pos = 0x10
	// Bit mask of OAR field.
	CEC_CFGR_OAR_Msk = 0x7fff0000
	// Position of LSTN field.
	CEC_CFGR_LSTN_Pos = 0x1f
	// Bit mask of LSTN field.
	CEC_CFGR_LSTN_Msk = 0x80000000
	// Bit LSTN.
	CEC_CFGR_LSTN = 0x80000000

	// TXDR: Tx data register
	// Position of TXD field.
	CEC_TXDR_TXD_Pos = 0x0
	// Bit mask of TXD field.
	CEC_TXDR_TXD_Msk = 0xff

	// RXDR: Rx Data Register
	// Position of RXDR field.
	CEC_RXDR_RXDR_Pos = 0x0
	// Bit mask of RXDR field.
	CEC_RXDR_RXDR_Msk = 0xff

	// ISR: Interrupt and Status Register
	// Position of TXACKE field.
	CEC_ISR_TXACKE_Pos = 0xc
	// Bit mask of TXACKE field.
	CEC_ISR_TXACKE_Msk = 0x1000
	// Bit TXACKE.
	CEC_ISR_TXACKE = 0x1000
	// Position of TXERR field.
	CEC_ISR_TXERR_Pos = 0xb
	// Bit mask of TXERR field.
	CEC_ISR_TXERR_Msk = 0x800
	// Bit TXERR.
	CEC_ISR_TXERR = 0x800
	// Position of TXUDR field.
	CEC_ISR_TXUDR_Pos = 0xa
	// Bit mask of TXUDR field.
	CEC_ISR_TXUDR_Msk = 0x400
	// Bit TXUDR.
	CEC_ISR_TXUDR = 0x400
	// Position of TXEND field.
	CEC_ISR_TXEND_Pos = 0x9
	// Bit mask of TXEND field.
	CEC_ISR_TXEND_Msk = 0x200
	// Bit TXEND.
	CEC_ISR_TXEND = 0x200
	// Position of TXBR field.
	CEC_ISR_TXBR_Pos = 0x8
	// Bit mask of TXBR field.
	CEC_ISR_TXBR_Msk = 0x100
	// Bit TXBR.
	CEC_ISR_TXBR = 0x100
	// Position of ARBLST field.
	CEC_ISR_ARBLST_Pos = 0x7
	// Bit mask of ARBLST field.
	CEC_ISR_ARBLST_Msk = 0x80
	// Bit ARBLST.
	CEC_ISR_ARBLST = 0x80
	// Position of RXACKE field.
	CEC_ISR_RXACKE_Pos = 0x6
	// Bit mask of RXACKE field.
	CEC_ISR_RXACKE_Msk = 0x40
	// Bit RXACKE.
	CEC_ISR_RXACKE = 0x40
	// Position of LBPE field.
	CEC_ISR_LBPE_Pos = 0x5
	// Bit mask of LBPE field.
	CEC_ISR_LBPE_Msk = 0x20
	// Bit LBPE.
	CEC_ISR_LBPE = 0x20
	// Position of SBPE field.
	CEC_ISR_SBPE_Pos = 0x4
	// Bit mask of SBPE field.
	CEC_ISR_SBPE_Msk = 0x10
	// Bit SBPE.
	CEC_ISR_SBPE = 0x10
	// Position of BRE field.
	CEC_ISR_BRE_Pos = 0x3
	// Bit mask of BRE field.
	CEC_ISR_BRE_Msk = 0x8
	// Bit BRE.
	CEC_ISR_BRE = 0x8
	// Position of RXOVR field.
	CEC_ISR_RXOVR_Pos = 0x2
	// Bit mask of RXOVR field.
	CEC_ISR_RXOVR_Msk = 0x4
	// Bit RXOVR.
	CEC_ISR_RXOVR = 0x4
	// Position of RXEND field.
	CEC_ISR_RXEND_Pos = 0x1
	// Bit mask of RXEND field.
	CEC_ISR_RXEND_Msk = 0x2
	// Bit RXEND.
	CEC_ISR_RXEND = 0x2
	// Position of RXBR field.
	CEC_ISR_RXBR_Pos = 0x0
	// Bit mask of RXBR field.
	CEC_ISR_RXBR_Msk = 0x1
	// Bit RXBR.
	CEC_ISR_RXBR = 0x1

	// IER: interrupt enable register
	// Position of TXACKIE field.
	CEC_IER_TXACKIE_Pos = 0xc
	// Bit mask of TXACKIE field.
	CEC_IER_TXACKIE_Msk = 0x1000
	// Bit TXACKIE.
	CEC_IER_TXACKIE = 0x1000
	// Position of TXERRIE field.
	CEC_IER_TXERRIE_Pos = 0xb
	// Bit mask of TXERRIE field.
	CEC_IER_TXERRIE_Msk = 0x800
	// Bit TXERRIE.
	CEC_IER_TXERRIE = 0x800
	// Position of TXUDRIE field.
	CEC_IER_TXUDRIE_Pos = 0xa
	// Bit mask of TXUDRIE field.
	CEC_IER_TXUDRIE_Msk = 0x400
	// Bit TXUDRIE.
	CEC_IER_TXUDRIE = 0x400
	// Position of TXENDIE field.
	CEC_IER_TXENDIE_Pos = 0x9
	// Bit mask of TXENDIE field.
	CEC_IER_TXENDIE_Msk = 0x200
	// Bit TXENDIE.
	CEC_IER_TXENDIE = 0x200
	// Position of TXBRIE field.
	CEC_IER_TXBRIE_Pos = 0x8
	// Bit mask of TXBRIE field.
	CEC_IER_TXBRIE_Msk = 0x100
	// Bit TXBRIE.
	CEC_IER_TXBRIE = 0x100
	// Position of ARBLSTIE field.
	CEC_IER_ARBLSTIE_Pos = 0x7
	// Bit mask of ARBLSTIE field.
	CEC_IER_ARBLSTIE_Msk = 0x80
	// Bit ARBLSTIE.
	CEC_IER_ARBLSTIE = 0x80
	// Position of RXACKIE field.
	CEC_IER_RXACKIE_Pos = 0x6
	// Bit mask of RXACKIE field.
	CEC_IER_RXACKIE_Msk = 0x40
	// Bit RXACKIE.
	CEC_IER_RXACKIE = 0x40
	// Position of LBPEIE field.
	CEC_IER_LBPEIE_Pos = 0x5
	// Bit mask of LBPEIE field.
	CEC_IER_LBPEIE_Msk = 0x20
	// Bit LBPEIE.
	CEC_IER_LBPEIE = 0x20
	// Position of SBPEIE field.
	CEC_IER_SBPEIE_Pos = 0x4
	// Bit mask of SBPEIE field.
	CEC_IER_SBPEIE_Msk = 0x10
	// Bit SBPEIE.
	CEC_IER_SBPEIE = 0x10
	// Position of BREIE field.
	CEC_IER_BREIE_Pos = 0x3
	// Bit mask of BREIE field.
	CEC_IER_BREIE_Msk = 0x8
	// Bit BREIE.
	CEC_IER_BREIE = 0x8
	// Position of RXOVRIE field.
	CEC_IER_RXOVRIE_Pos = 0x2
	// Bit mask of RXOVRIE field.
	CEC_IER_RXOVRIE_Msk = 0x4
	// Bit RXOVRIE.
	CEC_IER_RXOVRIE = 0x4
	// Position of RXENDIE field.
	CEC_IER_RXENDIE_Pos = 0x1
	// Bit mask of RXENDIE field.
	CEC_IER_RXENDIE_Msk = 0x2
	// Bit RXENDIE.
	CEC_IER_RXENDIE = 0x2
	// Position of RXBRIE field.
	CEC_IER_RXBRIE_Pos = 0x0
	// Bit mask of RXBRIE field.
	CEC_IER_RXBRIE_Msk = 0x1
	// Bit RXBRIE.
	CEC_IER_RXBRIE = 0x1
)

// Bitfields for SPDIFRX: Receiver Interface
const (
	// CR: Control register
	// Position of SPDIFEN field.
	SPDIF_RX_CR_SPDIFEN_Pos = 0x0
	// Bit mask of SPDIFEN field.
	SPDIF_RX_CR_SPDIFEN_Msk = 0x3
	// Position of RXDMAEN field.
	SPDIF_RX_CR_RXDMAEN_Pos = 0x2
	// Bit mask of RXDMAEN field.
	SPDIF_RX_CR_RXDMAEN_Msk = 0x4
	// Bit RXDMAEN.
	SPDIF_RX_CR_RXDMAEN = 0x4
	// Position of RXSTEO field.
	SPDIF_RX_CR_RXSTEO_Pos = 0x3
	// Bit mask of RXSTEO field.
	SPDIF_RX_CR_RXSTEO_Msk = 0x8
	// Bit RXSTEO.
	SPDIF_RX_CR_RXSTEO = 0x8
	// Position of DRFMT field.
	SPDIF_RX_CR_DRFMT_Pos = 0x4
	// Bit mask of DRFMT field.
	SPDIF_RX_CR_DRFMT_Msk = 0x30
	// Position of PMSK field.
	SPDIF_RX_CR_PMSK_Pos = 0x6
	// Bit mask of PMSK field.
	SPDIF_RX_CR_PMSK_Msk = 0x40
	// Bit PMSK.
	SPDIF_RX_CR_PMSK = 0x40
	// Position of VMSK field.
	SPDIF_RX_CR_VMSK_Pos = 0x7
	// Bit mask of VMSK field.
	SPDIF_RX_CR_VMSK_Msk = 0x80
	// Bit VMSK.
	SPDIF_RX_CR_VMSK = 0x80
	// Position of CUMSK field.
	SPDIF_RX_CR_CUMSK_Pos = 0x8
	// Bit mask of CUMSK field.
	SPDIF_RX_CR_CUMSK_Msk = 0x100
	// Bit CUMSK.
	SPDIF_RX_CR_CUMSK = 0x100
	// Position of PTMSK field.
	SPDIF_RX_CR_PTMSK_Pos = 0x9
	// Bit mask of PTMSK field.
	SPDIF_RX_CR_PTMSK_Msk = 0x200
	// Bit PTMSK.
	SPDIF_RX_CR_PTMSK = 0x200
	// Position of CBDMAEN field.
	SPDIF_RX_CR_CBDMAEN_Pos = 0xa
	// Bit mask of CBDMAEN field.
	SPDIF_RX_CR_CBDMAEN_Msk = 0x400
	// Bit CBDMAEN.
	SPDIF_RX_CR_CBDMAEN = 0x400
	// Position of CHSEL field.
	SPDIF_RX_CR_CHSEL_Pos = 0xb
	// Bit mask of CHSEL field.
	SPDIF_RX_CR_CHSEL_Msk = 0x800
	// Bit CHSEL.
	SPDIF_RX_CR_CHSEL = 0x800
	// Position of NBTR field.
	SPDIF_RX_CR_NBTR_Pos = 0xc
	// Bit mask of NBTR field.
	SPDIF_RX_CR_NBTR_Msk = 0x3000
	// Position of WFA field.
	SPDIF_RX_CR_WFA_Pos = 0xe
	// Bit mask of WFA field.
	SPDIF_RX_CR_WFA_Msk = 0x4000
	// Bit WFA.
	SPDIF_RX_CR_WFA = 0x4000
	// Position of INSEL field.
	SPDIF_RX_CR_INSEL_Pos = 0x10
	// Bit mask of INSEL field.
	SPDIF_RX_CR_INSEL_Msk = 0x70000

	// IMR: Interrupt mask register
	// Position of RXNEIE field.
	SPDIF_RX_IMR_RXNEIE_Pos = 0x0
	// Bit mask of RXNEIE field.
	SPDIF_RX_IMR_RXNEIE_Msk = 0x1
	// Bit RXNEIE.
	SPDIF_RX_IMR_RXNEIE = 0x1
	// Position of CSRNEIE field.
	SPDIF_RX_IMR_CSRNEIE_Pos = 0x1
	// Bit mask of CSRNEIE field.
	SPDIF_RX_IMR_CSRNEIE_Msk = 0x2
	// Bit CSRNEIE.
	SPDIF_RX_IMR_CSRNEIE = 0x2
	// Position of PERRIE field.
	SPDIF_RX_IMR_PERRIE_Pos = 0x2
	// Bit mask of PERRIE field.
	SPDIF_RX_IMR_PERRIE_Msk = 0x4
	// Bit PERRIE.
	SPDIF_RX_IMR_PERRIE = 0x4
	// Position of OVRIE field.
	SPDIF_RX_IMR_OVRIE_Pos = 0x3
	// Bit mask of OVRIE field.
	SPDIF_RX_IMR_OVRIE_Msk = 0x8
	// Bit OVRIE.
	SPDIF_RX_IMR_OVRIE = 0x8
	// Position of SBLKIE field.
	SPDIF_RX_IMR_SBLKIE_Pos = 0x4
	// Bit mask of SBLKIE field.
	SPDIF_RX_IMR_SBLKIE_Msk = 0x10
	// Bit SBLKIE.
	SPDIF_RX_IMR_SBLKIE = 0x10
	// Position of SYNCDIE field.
	SPDIF_RX_IMR_SYNCDIE_Pos = 0x5
	// Bit mask of SYNCDIE field.
	SPDIF_RX_IMR_SYNCDIE_Msk = 0x20
	// Bit SYNCDIE.
	SPDIF_RX_IMR_SYNCDIE = 0x20
	// Position of IFEIE field.
	SPDIF_RX_IMR_IFEIE_Pos = 0x6
	// Bit mask of IFEIE field.
	SPDIF_RX_IMR_IFEIE_Msk = 0x40
	// Bit IFEIE.
	SPDIF_RX_IMR_IFEIE = 0x40

	// SR: Status register
	// Position of RXNE field.
	SPDIF_RX_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPDIF_RX_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPDIF_RX_SR_RXNE = 0x1
	// Position of CSRNE field.
	SPDIF_RX_SR_CSRNE_Pos = 0x1
	// Bit mask of CSRNE field.
	SPDIF_RX_SR_CSRNE_Msk = 0x2
	// Bit CSRNE.
	SPDIF_RX_SR_CSRNE = 0x2
	// Position of PERR field.
	SPDIF_RX_SR_PERR_Pos = 0x2
	// Bit mask of PERR field.
	SPDIF_RX_SR_PERR_Msk = 0x4
	// Bit PERR.
	SPDIF_RX_SR_PERR = 0x4
	// Position of OVR field.
	SPDIF_RX_SR_OVR_Pos = 0x3
	// Bit mask of OVR field.
	SPDIF_RX_SR_OVR_Msk = 0x8
	// Bit OVR.
	SPDIF_RX_SR_OVR = 0x8
	// Position of SBD field.
	SPDIF_RX_SR_SBD_Pos = 0x4
	// Bit mask of SBD field.
	SPDIF_RX_SR_SBD_Msk = 0x10
	// Bit SBD.
	SPDIF_RX_SR_SBD = 0x10
	// Position of SYNCD field.
	SPDIF_RX_SR_SYNCD_Pos = 0x5
	// Bit mask of SYNCD field.
	SPDIF_RX_SR_SYNCD_Msk = 0x20
	// Bit SYNCD.
	SPDIF_RX_SR_SYNCD = 0x20
	// Position of FERR field.
	SPDIF_RX_SR_FERR_Pos = 0x6
	// Bit mask of FERR field.
	SPDIF_RX_SR_FERR_Msk = 0x40
	// Bit FERR.
	SPDIF_RX_SR_FERR = 0x40
	// Position of SERR field.
	SPDIF_RX_SR_SERR_Pos = 0x7
	// Bit mask of SERR field.
	SPDIF_RX_SR_SERR_Msk = 0x80
	// Bit SERR.
	SPDIF_RX_SR_SERR = 0x80
	// Position of TERR field.
	SPDIF_RX_SR_TERR_Pos = 0x8
	// Bit mask of TERR field.
	SPDIF_RX_SR_TERR_Msk = 0x100
	// Bit TERR.
	SPDIF_RX_SR_TERR = 0x100
	// Position of WIDTH5 field.
	SPDIF_RX_SR_WIDTH5_Pos = 0x10
	// Bit mask of WIDTH5 field.
	SPDIF_RX_SR_WIDTH5_Msk = 0x7fff0000

	// IFCR: Interrupt Flag Clear register
	// Position of PERRCF field.
	SPDIF_RX_IFCR_PERRCF_Pos = 0x2
	// Bit mask of PERRCF field.
	SPDIF_RX_IFCR_PERRCF_Msk = 0x4
	// Bit PERRCF.
	SPDIF_RX_IFCR_PERRCF = 0x4
	// Position of OVRCF field.
	SPDIF_RX_IFCR_OVRCF_Pos = 0x3
	// Bit mask of OVRCF field.
	SPDIF_RX_IFCR_OVRCF_Msk = 0x8
	// Bit OVRCF.
	SPDIF_RX_IFCR_OVRCF = 0x8
	// Position of SBDCF field.
	SPDIF_RX_IFCR_SBDCF_Pos = 0x4
	// Bit mask of SBDCF field.
	SPDIF_RX_IFCR_SBDCF_Msk = 0x10
	// Bit SBDCF.
	SPDIF_RX_IFCR_SBDCF = 0x10
	// Position of SYNCDCF field.
	SPDIF_RX_IFCR_SYNCDCF_Pos = 0x5
	// Bit mask of SYNCDCF field.
	SPDIF_RX_IFCR_SYNCDCF_Msk = 0x20
	// Bit SYNCDCF.
	SPDIF_RX_IFCR_SYNCDCF = 0x20

	// DR: Data input register
	// Position of DR field.
	SPDIF_RX_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPDIF_RX_DR_DR_Msk = 0xffffff
	// Position of PE field.
	SPDIF_RX_DR_PE_Pos = 0x18
	// Bit mask of PE field.
	SPDIF_RX_DR_PE_Msk = 0x1000000
	// Bit PE.
	SPDIF_RX_DR_PE = 0x1000000
	// Position of V field.
	SPDIF_RX_DR_V_Pos = 0x19
	// Bit mask of V field.
	SPDIF_RX_DR_V_Msk = 0x2000000
	// Bit V.
	SPDIF_RX_DR_V = 0x2000000
	// Position of U field.
	SPDIF_RX_DR_U_Pos = 0x1a
	// Bit mask of U field.
	SPDIF_RX_DR_U_Msk = 0x4000000
	// Bit U.
	SPDIF_RX_DR_U = 0x4000000
	// Position of C field.
	SPDIF_RX_DR_C_Pos = 0x1b
	// Bit mask of C field.
	SPDIF_RX_DR_C_Msk = 0x8000000
	// Bit C.
	SPDIF_RX_DR_C = 0x8000000
	// Position of PT field.
	SPDIF_RX_DR_PT_Pos = 0x1c
	// Bit mask of PT field.
	SPDIF_RX_DR_PT_Msk = 0x30000000

	// CSR: Channel Status register
	// Position of USR field.
	SPDIF_RX_CSR_USR_Pos = 0x0
	// Bit mask of USR field.
	SPDIF_RX_CSR_USR_Msk = 0xffff
	// Position of CS field.
	SPDIF_RX_CSR_CS_Pos = 0x10
	// Bit mask of CS field.
	SPDIF_RX_CSR_CS_Msk = 0xff0000
	// Position of SOB field.
	SPDIF_RX_CSR_SOB_Pos = 0x18
	// Bit mask of SOB field.
	SPDIF_RX_CSR_SOB_Msk = 0x1000000
	// Bit SOB.
	SPDIF_RX_CSR_SOB = 0x1000000

	// DIR: Debug Information register
	// Position of THI field.
	SPDIF_RX_DIR_THI_Pos = 0x0
	// Bit mask of THI field.
	SPDIF_RX_DIR_THI_Msk = 0x1fff
	// Position of TLO field.
	SPDIF_RX_DIR_TLO_Pos = 0x10
	// Bit mask of TLO field.
	SPDIF_RX_DIR_TLO_Msk = 0x1fff0000
)

// Bitfields for SDMMC1: Secure digital input/output interface
const (
	// POWER: power control register
	// Position of PWRCTRL field.
	SDMMC_POWER_PWRCTRL_Pos = 0x0
	// Bit mask of PWRCTRL field.
	SDMMC_POWER_PWRCTRL_Msk = 0x3

	// CLKCR: SDI clock control register
	// Position of HWFC_EN field.
	SDMMC_CLKCR_HWFC_EN_Pos = 0xe
	// Bit mask of HWFC_EN field.
	SDMMC_CLKCR_HWFC_EN_Msk = 0x4000
	// Bit HWFC_EN.
	SDMMC_CLKCR_HWFC_EN = 0x4000
	// Position of NEGEDGE field.
	SDMMC_CLKCR_NEGEDGE_Pos = 0xd
	// Bit mask of NEGEDGE field.
	SDMMC_CLKCR_NEGEDGE_Msk = 0x2000
	// Bit NEGEDGE.
	SDMMC_CLKCR_NEGEDGE = 0x2000
	// Position of WIDBUS field.
	SDMMC_CLKCR_WIDBUS_Pos = 0xb
	// Bit mask of WIDBUS field.
	SDMMC_CLKCR_WIDBUS_Msk = 0x1800
	// Position of BYPASS field.
	SDMMC_CLKCR_BYPASS_Pos = 0xa
	// Bit mask of BYPASS field.
	SDMMC_CLKCR_BYPASS_Msk = 0x400
	// Bit BYPASS.
	SDMMC_CLKCR_BYPASS = 0x400
	// Position of PWRSAV field.
	SDMMC_CLKCR_PWRSAV_Pos = 0x9
	// Bit mask of PWRSAV field.
	SDMMC_CLKCR_PWRSAV_Msk = 0x200
	// Bit PWRSAV.
	SDMMC_CLKCR_PWRSAV = 0x200
	// Position of CLKEN field.
	SDMMC_CLKCR_CLKEN_Pos = 0x8
	// Bit mask of CLKEN field.
	SDMMC_CLKCR_CLKEN_Msk = 0x100
	// Bit CLKEN.
	SDMMC_CLKCR_CLKEN = 0x100
	// Position of CLKDIV field.
	SDMMC_CLKCR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	SDMMC_CLKCR_CLKDIV_Msk = 0xff

	// ARG: argument register
	// Position of CMDARG field.
	SDMMC_ARG_CMDARG_Pos = 0x0
	// Bit mask of CMDARG field.
	SDMMC_ARG_CMDARG_Msk = 0xffffffff

	// CMD: command register
	// Position of CE_ATACMD field.
	SDMMC_CMD_CE_ATACMD_Pos = 0xe
	// Bit mask of CE_ATACMD field.
	SDMMC_CMD_CE_ATACMD_Msk = 0x4000
	// Bit CE_ATACMD.
	SDMMC_CMD_CE_ATACMD = 0x4000
	// Position of NIEN field.
	SDMMC_CMD_NIEN_Pos = 0xd
	// Bit mask of NIEN field.
	SDMMC_CMD_NIEN_Msk = 0x2000
	// Bit NIEN.
	SDMMC_CMD_NIEN = 0x2000
	// Position of ENCMDcompl field.
	SDMMC_CMD_ENCMDcompl_Pos = 0xc
	// Bit mask of ENCMDcompl field.
	SDMMC_CMD_ENCMDcompl_Msk = 0x1000
	// Bit ENCMDcompl.
	SDMMC_CMD_ENCMDcompl = 0x1000
	// Position of SDIOSuspend field.
	SDMMC_CMD_SDIOSuspend_Pos = 0xb
	// Bit mask of SDIOSuspend field.
	SDMMC_CMD_SDIOSuspend_Msk = 0x800
	// Bit SDIOSuspend.
	SDMMC_CMD_SDIOSuspend = 0x800
	// Position of CPSMEN field.
	SDMMC_CMD_CPSMEN_Pos = 0xa
	// Bit mask of CPSMEN field.
	SDMMC_CMD_CPSMEN_Msk = 0x400
	// Bit CPSMEN.
	SDMMC_CMD_CPSMEN = 0x400
	// Position of WAITPEND field.
	SDMMC_CMD_WAITPEND_Pos = 0x9
	// Bit mask of WAITPEND field.
	SDMMC_CMD_WAITPEND_Msk = 0x200
	// Bit WAITPEND.
	SDMMC_CMD_WAITPEND = 0x200
	// Position of WAITINT field.
	SDMMC_CMD_WAITINT_Pos = 0x8
	// Bit mask of WAITINT field.
	SDMMC_CMD_WAITINT_Msk = 0x100
	// Bit WAITINT.
	SDMMC_CMD_WAITINT = 0x100
	// Position of WAITRESP field.
	SDMMC_CMD_WAITRESP_Pos = 0x6
	// Bit mask of WAITRESP field.
	SDMMC_CMD_WAITRESP_Msk = 0xc0
	// Position of CMDINDEX field.
	SDMMC_CMD_CMDINDEX_Pos = 0x0
	// Bit mask of CMDINDEX field.
	SDMMC_CMD_CMDINDEX_Msk = 0x3f

	// RESPCMD: command response register
	// Position of RESPCMD field.
	SDMMC_RESPCMD_RESPCMD_Pos = 0x0
	// Bit mask of RESPCMD field.
	SDMMC_RESPCMD_RESPCMD_Msk = 0x3f

	// RESP1: response 1..4 register
	// Position of CARDSTATUS1 field.
	SDMMC_RESP1_CARDSTATUS1_Pos = 0x0
	// Bit mask of CARDSTATUS1 field.
	SDMMC_RESP1_CARDSTATUS1_Msk = 0xffffffff

	// RESP2: response 1..4 register
	// Position of CARDSTATUS2 field.
	SDMMC_RESP2_CARDSTATUS2_Pos = 0x0
	// Bit mask of CARDSTATUS2 field.
	SDMMC_RESP2_CARDSTATUS2_Msk = 0xffffffff

	// RESP3: response 1..4 register
	// Position of CARDSTATUS3 field.
	SDMMC_RESP3_CARDSTATUS3_Pos = 0x0
	// Bit mask of CARDSTATUS3 field.
	SDMMC_RESP3_CARDSTATUS3_Msk = 0xffffffff

	// RESP4: response 1..4 register
	// Position of CARDSTATUS4 field.
	SDMMC_RESP4_CARDSTATUS4_Pos = 0x0
	// Bit mask of CARDSTATUS4 field.
	SDMMC_RESP4_CARDSTATUS4_Msk = 0xffffffff

	// DTIMER: data timer register
	// Position of DATATIME field.
	SDMMC_DTIMER_DATATIME_Pos = 0x0
	// Bit mask of DATATIME field.
	SDMMC_DTIMER_DATATIME_Msk = 0xffffffff

	// DLEN: data length register
	// Position of DATALENGTH field.
	SDMMC_DLEN_DATALENGTH_Pos = 0x0
	// Bit mask of DATALENGTH field.
	SDMMC_DLEN_DATALENGTH_Msk = 0x1ffffff

	// DCTRL: data control register
	// Position of SDIOEN field.
	SDMMC_DCTRL_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	SDMMC_DCTRL_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	SDMMC_DCTRL_SDIOEN = 0x800
	// Position of RWMOD field.
	SDMMC_DCTRL_RWMOD_Pos = 0xa
	// Bit mask of RWMOD field.
	SDMMC_DCTRL_RWMOD_Msk = 0x400
	// Bit RWMOD.
	SDMMC_DCTRL_RWMOD = 0x400
	// Position of RWSTOP field.
	SDMMC_DCTRL_RWSTOP_Pos = 0x9
	// Bit mask of RWSTOP field.
	SDMMC_DCTRL_RWSTOP_Msk = 0x200
	// Bit RWSTOP.
	SDMMC_DCTRL_RWSTOP = 0x200
	// Position of RWSTART field.
	SDMMC_DCTRL_RWSTART_Pos = 0x8
	// Bit mask of RWSTART field.
	SDMMC_DCTRL_RWSTART_Msk = 0x100
	// Bit RWSTART.
	SDMMC_DCTRL_RWSTART = 0x100
	// Position of DBLOCKSIZE field.
	SDMMC_DCTRL_DBLOCKSIZE_Pos = 0x4
	// Bit mask of DBLOCKSIZE field.
	SDMMC_DCTRL_DBLOCKSIZE_Msk = 0xf0
	// Position of DMAEN field.
	SDMMC_DCTRL_DMAEN_Pos = 0x3
	// Bit mask of DMAEN field.
	SDMMC_DCTRL_DMAEN_Msk = 0x8
	// Bit DMAEN.
	SDMMC_DCTRL_DMAEN = 0x8
	// Position of DTMODE field.
	SDMMC_DCTRL_DTMODE_Pos = 0x2
	// Bit mask of DTMODE field.
	SDMMC_DCTRL_DTMODE_Msk = 0x4
	// Bit DTMODE.
	SDMMC_DCTRL_DTMODE = 0x4
	// Position of DTDIR field.
	SDMMC_DCTRL_DTDIR_Pos = 0x1
	// Bit mask of DTDIR field.
	SDMMC_DCTRL_DTDIR_Msk = 0x2
	// Bit DTDIR.
	SDMMC_DCTRL_DTDIR = 0x2
	// Position of DTEN field.
	SDMMC_DCTRL_DTEN_Pos = 0x0
	// Bit mask of DTEN field.
	SDMMC_DCTRL_DTEN_Msk = 0x1
	// Bit DTEN.
	SDMMC_DCTRL_DTEN = 0x1

	// DCOUNT: data counter register
	// Position of DATACOUNT field.
	SDMMC_DCOUNT_DATACOUNT_Pos = 0x0
	// Bit mask of DATACOUNT field.
	SDMMC_DCOUNT_DATACOUNT_Msk = 0x1ffffff

	// STA: status register
	// Position of CEATAEND field.
	SDMMC_STA_CEATAEND_Pos = 0x17
	// Bit mask of CEATAEND field.
	SDMMC_STA_CEATAEND_Msk = 0x800000
	// Bit CEATAEND.
	SDMMC_STA_CEATAEND = 0x800000
	// Position of SDIOIT field.
	SDMMC_STA_SDIOIT_Pos = 0x16
	// Bit mask of SDIOIT field.
	SDMMC_STA_SDIOIT_Msk = 0x400000
	// Bit SDIOIT.
	SDMMC_STA_SDIOIT = 0x400000
	// Position of RXDAVL field.
	SDMMC_STA_RXDAVL_Pos = 0x15
	// Bit mask of RXDAVL field.
	SDMMC_STA_RXDAVL_Msk = 0x200000
	// Bit RXDAVL.
	SDMMC_STA_RXDAVL = 0x200000
	// Position of TXDAVL field.
	SDMMC_STA_TXDAVL_Pos = 0x14
	// Bit mask of TXDAVL field.
	SDMMC_STA_TXDAVL_Msk = 0x100000
	// Bit TXDAVL.
	SDMMC_STA_TXDAVL = 0x100000
	// Position of RXFIFOE field.
	SDMMC_STA_RXFIFOE_Pos = 0x13
	// Bit mask of RXFIFOE field.
	SDMMC_STA_RXFIFOE_Msk = 0x80000
	// Bit RXFIFOE.
	SDMMC_STA_RXFIFOE = 0x80000
	// Position of TXFIFOE field.
	SDMMC_STA_TXFIFOE_Pos = 0x12
	// Bit mask of TXFIFOE field.
	SDMMC_STA_TXFIFOE_Msk = 0x40000
	// Bit TXFIFOE.
	SDMMC_STA_TXFIFOE = 0x40000
	// Position of RXFIFOF field.
	SDMMC_STA_RXFIFOF_Pos = 0x11
	// Bit mask of RXFIFOF field.
	SDMMC_STA_RXFIFOF_Msk = 0x20000
	// Bit RXFIFOF.
	SDMMC_STA_RXFIFOF = 0x20000
	// Position of TXFIFOF field.
	SDMMC_STA_TXFIFOF_Pos = 0x10
	// Bit mask of TXFIFOF field.
	SDMMC_STA_TXFIFOF_Msk = 0x10000
	// Bit TXFIFOF.
	SDMMC_STA_TXFIFOF = 0x10000
	// Position of RXFIFOHF field.
	SDMMC_STA_RXFIFOHF_Pos = 0xf
	// Bit mask of RXFIFOHF field.
	SDMMC_STA_RXFIFOHF_Msk = 0x8000
	// Bit RXFIFOHF.
	SDMMC_STA_RXFIFOHF = 0x8000
	// Position of TXFIFOHE field.
	SDMMC_STA_TXFIFOHE_Pos = 0xe
	// Bit mask of TXFIFOHE field.
	SDMMC_STA_TXFIFOHE_Msk = 0x4000
	// Bit TXFIFOHE.
	SDMMC_STA_TXFIFOHE = 0x4000
	// Position of RXACT field.
	SDMMC_STA_RXACT_Pos = 0xd
	// Bit mask of RXACT field.
	SDMMC_STA_RXACT_Msk = 0x2000
	// Bit RXACT.
	SDMMC_STA_RXACT = 0x2000
	// Position of TXACT field.
	SDMMC_STA_TXACT_Pos = 0xc
	// Bit mask of TXACT field.
	SDMMC_STA_TXACT_Msk = 0x1000
	// Bit TXACT.
	SDMMC_STA_TXACT = 0x1000
	// Position of CMDACT field.
	SDMMC_STA_CMDACT_Pos = 0xb
	// Bit mask of CMDACT field.
	SDMMC_STA_CMDACT_Msk = 0x800
	// Bit CMDACT.
	SDMMC_STA_CMDACT = 0x800
	// Position of DBCKEND field.
	SDMMC_STA_DBCKEND_Pos = 0xa
	// Bit mask of DBCKEND field.
	SDMMC_STA_DBCKEND_Msk = 0x400
	// Bit DBCKEND.
	SDMMC_STA_DBCKEND = 0x400
	// Position of STBITERR field.
	SDMMC_STA_STBITERR_Pos = 0x9
	// Bit mask of STBITERR field.
	SDMMC_STA_STBITERR_Msk = 0x200
	// Bit STBITERR.
	SDMMC_STA_STBITERR = 0x200
	// Position of DATAEND field.
	SDMMC_STA_DATAEND_Pos = 0x8
	// Bit mask of DATAEND field.
	SDMMC_STA_DATAEND_Msk = 0x100
	// Bit DATAEND.
	SDMMC_STA_DATAEND = 0x100
	// Position of CMDSENT field.
	SDMMC_STA_CMDSENT_Pos = 0x7
	// Bit mask of CMDSENT field.
	SDMMC_STA_CMDSENT_Msk = 0x80
	// Bit CMDSENT.
	SDMMC_STA_CMDSENT = 0x80
	// Position of CMDREND field.
	SDMMC_STA_CMDREND_Pos = 0x6
	// Bit mask of CMDREND field.
	SDMMC_STA_CMDREND_Msk = 0x40
	// Bit CMDREND.
	SDMMC_STA_CMDREND = 0x40
	// Position of RXOVERR field.
	SDMMC_STA_RXOVERR_Pos = 0x5
	// Bit mask of RXOVERR field.
	SDMMC_STA_RXOVERR_Msk = 0x20
	// Bit RXOVERR.
	SDMMC_STA_RXOVERR = 0x20
	// Position of TXUNDERR field.
	SDMMC_STA_TXUNDERR_Pos = 0x4
	// Bit mask of TXUNDERR field.
	SDMMC_STA_TXUNDERR_Msk = 0x10
	// Bit TXUNDERR.
	SDMMC_STA_TXUNDERR = 0x10
	// Position of DTIMEOUT field.
	SDMMC_STA_DTIMEOUT_Pos = 0x3
	// Bit mask of DTIMEOUT field.
	SDMMC_STA_DTIMEOUT_Msk = 0x8
	// Bit DTIMEOUT.
	SDMMC_STA_DTIMEOUT = 0x8
	// Position of CTIMEOUT field.
	SDMMC_STA_CTIMEOUT_Pos = 0x2
	// Bit mask of CTIMEOUT field.
	SDMMC_STA_CTIMEOUT_Msk = 0x4
	// Bit CTIMEOUT.
	SDMMC_STA_CTIMEOUT = 0x4
	// Position of DCRCFAIL field.
	SDMMC_STA_DCRCFAIL_Pos = 0x1
	// Bit mask of DCRCFAIL field.
	SDMMC_STA_DCRCFAIL_Msk = 0x2
	// Bit DCRCFAIL.
	SDMMC_STA_DCRCFAIL = 0x2
	// Position of CCRCFAIL field.
	SDMMC_STA_CCRCFAIL_Pos = 0x0
	// Bit mask of CCRCFAIL field.
	SDMMC_STA_CCRCFAIL_Msk = 0x1
	// Bit CCRCFAIL.
	SDMMC_STA_CCRCFAIL = 0x1

	// ICR: interrupt clear register
	// Position of CEATAENDC field.
	SDMMC_ICR_CEATAENDC_Pos = 0x17
	// Bit mask of CEATAENDC field.
	SDMMC_ICR_CEATAENDC_Msk = 0x800000
	// Bit CEATAENDC.
	SDMMC_ICR_CEATAENDC = 0x800000
	// Position of SDIOITC field.
	SDMMC_ICR_SDIOITC_Pos = 0x16
	// Bit mask of SDIOITC field.
	SDMMC_ICR_SDIOITC_Msk = 0x400000
	// Bit SDIOITC.
	SDMMC_ICR_SDIOITC = 0x400000
	// Position of DBCKENDC field.
	SDMMC_ICR_DBCKENDC_Pos = 0xa
	// Bit mask of DBCKENDC field.
	SDMMC_ICR_DBCKENDC_Msk = 0x400
	// Bit DBCKENDC.
	SDMMC_ICR_DBCKENDC = 0x400
	// Position of STBITERRC field.
	SDMMC_ICR_STBITERRC_Pos = 0x9
	// Bit mask of STBITERRC field.
	SDMMC_ICR_STBITERRC_Msk = 0x200
	// Bit STBITERRC.
	SDMMC_ICR_STBITERRC = 0x200
	// Position of DATAENDC field.
	SDMMC_ICR_DATAENDC_Pos = 0x8
	// Bit mask of DATAENDC field.
	SDMMC_ICR_DATAENDC_Msk = 0x100
	// Bit DATAENDC.
	SDMMC_ICR_DATAENDC = 0x100
	// Position of CMDSENTC field.
	SDMMC_ICR_CMDSENTC_Pos = 0x7
	// Bit mask of CMDSENTC field.
	SDMMC_ICR_CMDSENTC_Msk = 0x80
	// Bit CMDSENTC.
	SDMMC_ICR_CMDSENTC = 0x80
	// Position of CMDRENDC field.
	SDMMC_ICR_CMDRENDC_Pos = 0x6
	// Bit mask of CMDRENDC field.
	SDMMC_ICR_CMDRENDC_Msk = 0x40
	// Bit CMDRENDC.
	SDMMC_ICR_CMDRENDC = 0x40
	// Position of RXOVERRC field.
	SDMMC_ICR_RXOVERRC_Pos = 0x5
	// Bit mask of RXOVERRC field.
	SDMMC_ICR_RXOVERRC_Msk = 0x20
	// Bit RXOVERRC.
	SDMMC_ICR_RXOVERRC = 0x20
	// Position of TXUNDERRC field.
	SDMMC_ICR_TXUNDERRC_Pos = 0x4
	// Bit mask of TXUNDERRC field.
	SDMMC_ICR_TXUNDERRC_Msk = 0x10
	// Bit TXUNDERRC.
	SDMMC_ICR_TXUNDERRC = 0x10
	// Position of DTIMEOUTC field.
	SDMMC_ICR_DTIMEOUTC_Pos = 0x3
	// Bit mask of DTIMEOUTC field.
	SDMMC_ICR_DTIMEOUTC_Msk = 0x8
	// Bit DTIMEOUTC.
	SDMMC_ICR_DTIMEOUTC = 0x8
	// Position of CTIMEOUTC field.
	SDMMC_ICR_CTIMEOUTC_Pos = 0x2
	// Bit mask of CTIMEOUTC field.
	SDMMC_ICR_CTIMEOUTC_Msk = 0x4
	// Bit CTIMEOUTC.
	SDMMC_ICR_CTIMEOUTC = 0x4
	// Position of DCRCFAILC field.
	SDMMC_ICR_DCRCFAILC_Pos = 0x1
	// Bit mask of DCRCFAILC field.
	SDMMC_ICR_DCRCFAILC_Msk = 0x2
	// Bit DCRCFAILC.
	SDMMC_ICR_DCRCFAILC = 0x2
	// Position of CCRCFAILC field.
	SDMMC_ICR_CCRCFAILC_Pos = 0x0
	// Bit mask of CCRCFAILC field.
	SDMMC_ICR_CCRCFAILC_Msk = 0x1
	// Bit CCRCFAILC.
	SDMMC_ICR_CCRCFAILC = 0x1

	// MASK: mask register
	// Position of CEATAENDIE field.
	SDMMC_MASK_CEATAENDIE_Pos = 0x17
	// Bit mask of CEATAENDIE field.
	SDMMC_MASK_CEATAENDIE_Msk = 0x800000
	// Bit CEATAENDIE.
	SDMMC_MASK_CEATAENDIE = 0x800000
	// Position of SDIOITIE field.
	SDMMC_MASK_SDIOITIE_Pos = 0x16
	// Bit mask of SDIOITIE field.
	SDMMC_MASK_SDIOITIE_Msk = 0x400000
	// Bit SDIOITIE.
	SDMMC_MASK_SDIOITIE = 0x400000
	// Position of RXDAVLIE field.
	SDMMC_MASK_RXDAVLIE_Pos = 0x15
	// Bit mask of RXDAVLIE field.
	SDMMC_MASK_RXDAVLIE_Msk = 0x200000
	// Bit RXDAVLIE.
	SDMMC_MASK_RXDAVLIE = 0x200000
	// Position of TXDAVLIE field.
	SDMMC_MASK_TXDAVLIE_Pos = 0x14
	// Bit mask of TXDAVLIE field.
	SDMMC_MASK_TXDAVLIE_Msk = 0x100000
	// Bit TXDAVLIE.
	SDMMC_MASK_TXDAVLIE = 0x100000
	// Position of RXFIFOEIE field.
	SDMMC_MASK_RXFIFOEIE_Pos = 0x13
	// Bit mask of RXFIFOEIE field.
	SDMMC_MASK_RXFIFOEIE_Msk = 0x80000
	// Bit RXFIFOEIE.
	SDMMC_MASK_RXFIFOEIE = 0x80000
	// Position of TXFIFOEIE field.
	SDMMC_MASK_TXFIFOEIE_Pos = 0x12
	// Bit mask of TXFIFOEIE field.
	SDMMC_MASK_TXFIFOEIE_Msk = 0x40000
	// Bit TXFIFOEIE.
	SDMMC_MASK_TXFIFOEIE = 0x40000
	// Position of RXFIFOFIE field.
	SDMMC_MASK_RXFIFOFIE_Pos = 0x11
	// Bit mask of RXFIFOFIE field.
	SDMMC_MASK_RXFIFOFIE_Msk = 0x20000
	// Bit RXFIFOFIE.
	SDMMC_MASK_RXFIFOFIE = 0x20000
	// Position of TXFIFOFIE field.
	SDMMC_MASK_TXFIFOFIE_Pos = 0x10
	// Bit mask of TXFIFOFIE field.
	SDMMC_MASK_TXFIFOFIE_Msk = 0x10000
	// Bit TXFIFOFIE.
	SDMMC_MASK_TXFIFOFIE = 0x10000
	// Position of RXFIFOHFIE field.
	SDMMC_MASK_RXFIFOHFIE_Pos = 0xf
	// Bit mask of RXFIFOHFIE field.
	SDMMC_MASK_RXFIFOHFIE_Msk = 0x8000
	// Bit RXFIFOHFIE.
	SDMMC_MASK_RXFIFOHFIE = 0x8000
	// Position of TXFIFOHEIE field.
	SDMMC_MASK_TXFIFOHEIE_Pos = 0xe
	// Bit mask of TXFIFOHEIE field.
	SDMMC_MASK_TXFIFOHEIE_Msk = 0x4000
	// Bit TXFIFOHEIE.
	SDMMC_MASK_TXFIFOHEIE = 0x4000
	// Position of RXACTIE field.
	SDMMC_MASK_RXACTIE_Pos = 0xd
	// Bit mask of RXACTIE field.
	SDMMC_MASK_RXACTIE_Msk = 0x2000
	// Bit RXACTIE.
	SDMMC_MASK_RXACTIE = 0x2000
	// Position of TXACTIE field.
	SDMMC_MASK_TXACTIE_Pos = 0xc
	// Bit mask of TXACTIE field.
	SDMMC_MASK_TXACTIE_Msk = 0x1000
	// Bit TXACTIE.
	SDMMC_MASK_TXACTIE = 0x1000
	// Position of CMDACTIE field.
	SDMMC_MASK_CMDACTIE_Pos = 0xb
	// Bit mask of CMDACTIE field.
	SDMMC_MASK_CMDACTIE_Msk = 0x800
	// Bit CMDACTIE.
	SDMMC_MASK_CMDACTIE = 0x800
	// Position of DBCKENDIE field.
	SDMMC_MASK_DBCKENDIE_Pos = 0xa
	// Bit mask of DBCKENDIE field.
	SDMMC_MASK_DBCKENDIE_Msk = 0x400
	// Bit DBCKENDIE.
	SDMMC_MASK_DBCKENDIE = 0x400
	// Position of STBITERRIE field.
	SDMMC_MASK_STBITERRIE_Pos = 0x9
	// Bit mask of STBITERRIE field.
	SDMMC_MASK_STBITERRIE_Msk = 0x200
	// Bit STBITERRIE.
	SDMMC_MASK_STBITERRIE = 0x200
	// Position of DATAENDIE field.
	SDMMC_MASK_DATAENDIE_Pos = 0x8
	// Bit mask of DATAENDIE field.
	SDMMC_MASK_DATAENDIE_Msk = 0x100
	// Bit DATAENDIE.
	SDMMC_MASK_DATAENDIE = 0x100
	// Position of CMDSENTIE field.
	SDMMC_MASK_CMDSENTIE_Pos = 0x7
	// Bit mask of CMDSENTIE field.
	SDMMC_MASK_CMDSENTIE_Msk = 0x80
	// Bit CMDSENTIE.
	SDMMC_MASK_CMDSENTIE = 0x80
	// Position of CMDRENDIE field.
	SDMMC_MASK_CMDRENDIE_Pos = 0x6
	// Bit mask of CMDRENDIE field.
	SDMMC_MASK_CMDRENDIE_Msk = 0x40
	// Bit CMDRENDIE.
	SDMMC_MASK_CMDRENDIE = 0x40
	// Position of RXOVERRIE field.
	SDMMC_MASK_RXOVERRIE_Pos = 0x5
	// Bit mask of RXOVERRIE field.
	SDMMC_MASK_RXOVERRIE_Msk = 0x20
	// Bit RXOVERRIE.
	SDMMC_MASK_RXOVERRIE = 0x20
	// Position of TXUNDERRIE field.
	SDMMC_MASK_TXUNDERRIE_Pos = 0x4
	// Bit mask of TXUNDERRIE field.
	SDMMC_MASK_TXUNDERRIE_Msk = 0x10
	// Bit TXUNDERRIE.
	SDMMC_MASK_TXUNDERRIE = 0x10
	// Position of DTIMEOUTIE field.
	SDMMC_MASK_DTIMEOUTIE_Pos = 0x3
	// Bit mask of DTIMEOUTIE field.
	SDMMC_MASK_DTIMEOUTIE_Msk = 0x8
	// Bit DTIMEOUTIE.
	SDMMC_MASK_DTIMEOUTIE = 0x8
	// Position of CTIMEOUTIE field.
	SDMMC_MASK_CTIMEOUTIE_Pos = 0x2
	// Bit mask of CTIMEOUTIE field.
	SDMMC_MASK_CTIMEOUTIE_Msk = 0x4
	// Bit CTIMEOUTIE.
	SDMMC_MASK_CTIMEOUTIE = 0x4
	// Position of DCRCFAILIE field.
	SDMMC_MASK_DCRCFAILIE_Pos = 0x1
	// Bit mask of DCRCFAILIE field.
	SDMMC_MASK_DCRCFAILIE_Msk = 0x2
	// Bit DCRCFAILIE.
	SDMMC_MASK_DCRCFAILIE = 0x2
	// Position of CCRCFAILIE field.
	SDMMC_MASK_CCRCFAILIE_Pos = 0x0
	// Bit mask of CCRCFAILIE field.
	SDMMC_MASK_CCRCFAILIE_Msk = 0x1
	// Bit CCRCFAILIE.
	SDMMC_MASK_CCRCFAILIE = 0x1

	// FIFOCNT: FIFO counter register
	// Position of FIFOCOUNT field.
	SDMMC_FIFOCNT_FIFOCOUNT_Pos = 0x0
	// Bit mask of FIFOCOUNT field.
	SDMMC_FIFOCNT_FIFOCOUNT_Msk = 0xffffff

	// FIFO: data FIFO register
	// Position of FIFOData field.
	SDMMC_FIFO_FIFOData_Pos = 0x0
	// Bit mask of FIFOData field.
	SDMMC_FIFO_FIFOData_Msk = 0xffffffff
)

// Bitfields for LPTIM1: Low power timer
const (
	// ISR: Interrupt and Status Register
	// Position of DOWN field.
	LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_ISR_DOWN = 0x40
	// Position of UP field.
	LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_ISR_UP = 0x20
	// Position of ARROK field.
	LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_ISR_ARROK = 0x10
	// Position of CMPOK field.
	LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_ISR_CMPOK = 0x8
	// Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_ISR_EXTTRIG = 0x4
	// Position of ARRM field.
	LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_ISR_ARRM = 0x2
	// Position of CMPM field.
	LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_ISR_CMPM = 0x1

	// ICR: Interrupt Clear Register
	// Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_ICR_DOWNCF = 0x40
	// Position of UPCF field.
	LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_ICR_UPCF = 0x20
	// Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_ICR_ARROKCF = 0x10
	// Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_ICR_CMPOKCF = 0x8
	// Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_ICR_EXTTRIGCF = 0x4
	// Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_ICR_ARRMCF = 0x2
	// Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_ICR_CMPMCF = 0x1

	// IER: Interrupt Enable Register
	// Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_IER_DOWNIE = 0x40
	// Position of UPIE field.
	LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_IER_UPIE = 0x20
	// Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_IER_ARROKIE = 0x10
	// Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_IER_CMPOKIE = 0x8
	// Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_IER_EXTTRIGIE = 0x4
	// Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_IER_ARRMIE = 0x2
	// Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_IER_CMPMIE = 0x1

	// CFGR: Configuration Register
	// Position of ENC field.
	LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_CFGR_ENC = 0x1000000
	// Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_CFGR_COUNTMODE = 0x800000
	// Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_CFGR_PRELOAD = 0x400000
	// Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_CFGR_WAVPOL = 0x200000
	// Position of WAVE field.
	LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_CFGR_WAVE = 0x100000
	// Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_CFGR_TIMOUT = 0x80000
	// Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// Position of PRESC field.
	LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_CFGR_PRESC_Msk = 0xe00
	// Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk = 0x18
	// Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk = 0x6
	// Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_CFGR_CKSEL = 0x1

	// CR: Control Register
	// Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_CR_CNTSTRT = 0x4
	// Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_CR_SNGSTRT = 0x2
	// Position of ENABLE field.
	LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_CR_ENABLE = 0x1

	// CMP: Compare Register
	// Position of CMP field.
	LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff

	// ARR: Autoreload Register
	// Position of ARR field.
	LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff

	// CNT: Counter Register
	// Position of CNT field.
	LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_CR1_TXIE_Disabled = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_CR1_TXIE_Enabled = 0x1
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_CR1_RXIE_Disabled = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_CR1_RXIE_Enabled = 0x1
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_CR1_ADDRIE_Disabled = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_CR1_ADDRIE_Enabled = 0x1
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_CR1_NACKIE_Disabled = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_CR1_NACKIE_Enabled = 0x1
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_CR1_STOPIE_Disabled = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_CR1_STOPIE_Enabled = 0x1
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_CR1_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	I2C_CR1_TCIE_Enabled = 0x1
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_CR1_ERRIE_Disabled = 0x0
	// Error detection interrupts enabled
	I2C_CR1_ERRIE_Enabled = 0x1
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_CR1_DNF_NoFilter = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_CR1_DNF_Filter1 = 0x1
	// Digital filter enabled and filtering capability up to 2 tI2CCLK
	I2C_CR1_DNF_Filter2 = 0x2
	// Digital filter enabled and filtering capability up to 3 tI2CCLK
	I2C_CR1_DNF_Filter3 = 0x3
	// Digital filter enabled and filtering capability up to 4 tI2CCLK
	I2C_CR1_DNF_Filter4 = 0x4
	// Digital filter enabled and filtering capability up to 5 tI2CCLK
	I2C_CR1_DNF_Filter5 = 0x5
	// Digital filter enabled and filtering capability up to 6 tI2CCLK
	I2C_CR1_DNF_Filter6 = 0x6
	// Digital filter enabled and filtering capability up to 7 tI2CCLK
	I2C_CR1_DNF_Filter7 = 0x7
	// Digital filter enabled and filtering capability up to 8 tI2CCLK
	I2C_CR1_DNF_Filter8 = 0x8
	// Digital filter enabled and filtering capability up to 9 tI2CCLK
	I2C_CR1_DNF_Filter9 = 0x9
	// Digital filter enabled and filtering capability up to 10 tI2CCLK
	I2C_CR1_DNF_Filter10 = 0xa
	// Digital filter enabled and filtering capability up to 11 tI2CCLK
	I2C_CR1_DNF_Filter11 = 0xb
	// Digital filter enabled and filtering capability up to 12 tI2CCLK
	I2C_CR1_DNF_Filter12 = 0xc
	// Digital filter enabled and filtering capability up to 13 tI2CCLK
	I2C_CR1_DNF_Filter13 = 0xd
	// Digital filter enabled and filtering capability up to 14 tI2CCLK
	I2C_CR1_DNF_Filter14 = 0xe
	// Digital filter enabled and filtering capability up to 15 tI2CCLK
	I2C_CR1_DNF_Filter15 = 0xf
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_CR1_ANFOFF_Enabled = 0x0
	// Analog noise filter disabled
	I2C_CR1_ANFOFF_Disabled = 0x1
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_CR1_TXDMAEN_Disabled = 0x0
	// DMA mode enabled for transmission
	I2C_CR1_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_CR1_RXDMAEN_Disabled = 0x0
	// DMA mode enabled for reception
	I2C_CR1_RXDMAEN_Enabled = 0x1
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_CR1_SBC_Disabled = 0x0
	// Slave byte control enabled
	I2C_CR1_SBC_Enabled = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Wakeup from Stop mode disabled
	I2C_CR1_WUPEN_Disabled = 0x0
	// Wakeup from Stop mode enabled
	I2C_CR1_WUPEN_Enabled = 0x1
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed
	I2C_CR1_GCEN_Disabled = 0x0
	// General call enabled. Address 0b00000000 is ACKed
	I2C_CR1_GCEN_Enabled = 0x1
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Host address disabled. Address 0b0001000x is NACKed
	I2C_CR1_SMBHEN_Disabled = 0x0
	// Host address enabled. Address 0b0001000x is ACKed
	I2C_CR1_SMBHEN_Enabled = 0x1
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Device default address disabled. Address 0b1100001x is NACKed
	I2C_CR1_SMBDEN_Disabled = 0x0
	// Device default address enabled. Address 0b1100001x is ACKed
	I2C_CR1_SMBDEN_Enabled = 0x1
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// In device mode (SMBHEN=Disabled) Releases SMBA pin high and Alert Response Address Header disabled (0001100x) followed by NACK. In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) not supported
	I2C_CR1_ALERTEN_Disabled = 0x0
	// In device mode (SMBHEN=Disabled) Drives SMBA pin low and Alert Response Address Header enabled (0001100x) followed by ACK.In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) supported
	I2C_CR1_ALERTEN_Enabled = 0x1
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_CR1_PECEN_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_PECEN_Enabled = 0x1

	// CR2: Control register 2
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer
	I2C_CR2_PECBYTE_NoPec = 0x0
	// PEC transmission/reception is requested
	I2C_CR2_PECBYTE_Pec = 0x1
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low
	I2C_CR2_AUTOEND_Software = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred
	I2C_CR2_AUTOEND_Automatic = 0x1
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART will follow)
	I2C_CR2_RELOAD_Completed = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES will be reloaded)
	I2C_CR2_RELOAD_NotCompleted = 0x1
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte
	I2C_CR2_NACK_Ack = 0x0
	// a NACK is sent after current received byte
	I2C_CR2_NACK_Nack = 0x1
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// No Stop generation
	I2C_CR2_STOP_NoStop = 0x0
	// Stop generation after current byte transfer
	I2C_CR2_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// No Start generation
	I2C_CR2_START_NoStart = 0x0
	// Restart/Start generation
	I2C_CR2_START_Start = 0x1
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence
	I2C_CR2_HEAD10R_Complete = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction
	I2C_CR2_HEAD10R_Partial = 0x1
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode
	I2C_CR2_ADD10_Bit7 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_CR2_ADD10_Bit10 = 0x1
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer
	I2C_CR2_RD_WRN_Write = 0x0
	// Master requests a read transfer
	I2C_CR2_RD_WRN_Read = 0x1
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address
	I2C_OAR1_OA1MODE_Bit7 = 0x0
	// Own address 1 is a 10-bit address
	I2C_OAR1_OA1MODE_Bit10 = 0x1
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed
	I2C_OAR1_OA1EN_Disabled = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed
	I2C_OAR1_OA1EN_Enabled = 0x1

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_OAR2_OA2MSK_NoMask = 0x0
	// OA2[1] is masked and don’t care. Only OA2[7:2] are compared
	I2C_OAR2_OA2MSK_Mask1 = 0x1
	// OA2[2:1] are masked and don’t care. Only OA2[7:3] are compared
	I2C_OAR2_OA2MSK_Mask2 = 0x2
	// OA2[3:1] are masked and don’t care. Only OA2[7:4] are compared
	I2C_OAR2_OA2MSK_Mask3 = 0x3
	// OA2[4:1] are masked and don’t care. Only OA2[7:5] are compared
	I2C_OAR2_OA2MSK_Mask4 = 0x4
	// OA2[5:1] are masked and don’t care. Only OA2[7:6] are compared
	I2C_OAR2_OA2MSK_Mask5 = 0x5
	// OA2[6:1] are masked and don’t care. Only OA2[7] is compared.
	I2C_OAR2_OA2MSK_Mask6 = 0x6
	// OA2[7:1] are masked and don’t care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged
	I2C_OAR2_OA2MSK_Mask7 = 0x7
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed
	I2C_OAR2_OA2EN_Disabled = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed
	I2C_OAR2_OA2EN_Enabled = 0x1

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_TIMEOUTR_TIDLE_Disabled = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_TIMEOUTR_TIDLE_Enabled = 0x1
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_TIMEOUTR_TIMOUTEN_Disabled = 0x0
	// SCL timeout detection is enabled
	I2C_TIMEOUTR_TIMOUTEN_Enabled = 0x1
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_TIMEOUTR_TEXTEN_Disabled = 0x0
	// Extended clock timeout detection is enabled
	I2C_TIMEOUTR_TEXTEN_Enabled = 0x1

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode
	I2C_ISR_DIR_Write = 0x0
	// Read transfer, slave enters transmitter mode
	I2C_ISR_DIR_Read = 0x1
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// No communication is in progress on the bus
	I2C_ISR_BUSY_NotBusy = 0x0
	// A communication is in progress on the bus
	I2C_ISR_BUSY_Busy = 0x1
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// SMBA alert is not detected
	I2C_ISR_ALERT_NoAlert = 0x0
	// SMBA alert event is detected on SMBA pin
	I2C_ISR_ALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// No timeout occured
	I2C_ISR_TIMEOUT_NoTimeout = 0x0
	// Timeout occured
	I2C_ISR_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Received PEC does match with PEC register
	I2C_ISR_PECERR_Match = 0x0
	// Received PEC does not match with PEC register
	I2C_ISR_PECERR_NoMatch = 0x1
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// No overrun/underrun error occurs
	I2C_ISR_OVR_NoOverrun = 0x0
	// slave mode with NOSTRETCH=1, when an overrun/underrun error occurs
	I2C_ISR_OVR_Overrun = 0x1
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// No arbitration lost
	I2C_ISR_ARLO_NotLost = 0x0
	// Arbitration lost
	I2C_ISR_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// No bus error
	I2C_ISR_BERR_NoError = 0x0
	// Misplaced Start and Stop condition is detected
	I2C_ISR_BERR_Error = 0x1
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Transfer is not complete
	I2C_ISR_TCR_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TCR_Complete = 0x1
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Transfer is not complete
	I2C_ISR_TC_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TC_Complete = 0x1
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// No Stop condition detected
	I2C_ISR_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_ISR_STOPF_Stop = 0x1
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// No NACK has been received
	I2C_ISR_NACKF_NoNack = 0x0
	// NACK has been received
	I2C_ISR_NACKF_Nack = 0x1
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Adress mismatched or not received
	I2C_ISR_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_ISR_ADDR_Match = 0x1
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// The RXDR register is empty
	I2C_ISR_RXNE_Empty = 0x0
	// Received data is copied into the RXDR register, and is ready to be read
	I2C_ISR_RXNE_NotEmpty = 0x1
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// The TXDR register is not empty
	I2C_ISR_TXIS_NotEmpty = 0x0
	// The TXDR register is empty and the data to be transmitted must be written in the TXDR register
	I2C_ISR_TXIS_Empty = 0x1
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1
	// TXDR register not empty
	I2C_ISR_TXE_NotEmpty = 0x0
	// TXDR register empty
	I2C_ISR_TXE_Empty = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Clears the ALERT flag in ISR register
	I2C_ICR_ALERTCF_Clear = 0x1
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Clears the TIMOUT flag in ISR register
	I2C_ICR_TIMOUTCF_Clear = 0x1
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Clears the PEC flag in ISR register
	I2C_ICR_PECCF_Clear = 0x1
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Clears the OVR flag in ISR register
	I2C_ICR_OVRCF_Clear = 0x1
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Clears the ARLO flag in ISR register
	I2C_ICR_ARLOCF_Clear = 0x1
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Clears the BERR flag in ISR register
	I2C_ICR_BERRCF_Clear = 0x1
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Clears the STOP flag in ISR register
	I2C_ICR_STOPCF_Clear = 0x1
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Clears the NACK flag in ISR register
	I2C_ICR_NACKCF_Clear = 0x1
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8
	// Clears the ADDR flag in ISR register
	I2C_ICR_ADDRCF_Clear = 0x1

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// AM or 24-hour format
	RTC_TR_PM_AM = 0x0
	// PM
	RTC_TR_PM_PM = 0x1
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// RTC/16 clock is selected
	RTC_CR_WUCKSEL_Div16 = 0x0
	// RTC/8 clock is selected
	RTC_CR_WUCKSEL_Div8 = 0x1
	// RTC/4 clock is selected
	RTC_CR_WUCKSEL_Div4 = 0x2
	// RTC/2 clock is selected
	RTC_CR_WUCKSEL_Div2 = 0x3
	// ck_spre (usually 1 Hz) clock is selected
	RTC_CR_WUCKSEL_ClockSpare = 0x4
	// ck_spre (usually 1 Hz) clock is selected and 2^16 is added to the WUT counter value
	RTC_CR_WUCKSEL_ClockSpareWithOffset = 0x6
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// RTC_TS input rising edge generates a time-stamp event
	RTC_CR_TSEDGE_RisingEdge = 0x0
	// RTC_TS input falling edge generates a time-stamp event
	RTC_CR_TSEDGE_FallingEdge = 0x1
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// RTC_REFIN detection disabled
	RTC_CR_REFCKON_Disabled = 0x0
	// RTC_REFIN detection enabled
	RTC_CR_REFCKON_Enabled = 0x1
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken from the shadow registers, which are updated once every two RTCCLK cycles
	RTC_CR_BYPSHAD_ShadowReg = 0x0
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken directly from the calendar counters
	RTC_CR_BYPSHAD_BypassShadowReg = 0x1
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// 24 hour/day format
	RTC_CR_FMT_Twenty_Four_Hour = 0x0
	// AM/PM hour format
	RTC_CR_FMT_AM_PM = 0x1
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Alarm A disabled
	RTC_CR_ALRAE_Disabled = 0x0
	// Alarm A enabled
	RTC_CR_ALRAE_Enabled = 0x1
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Alarm B disabled
	RTC_CR_ALRBE_Disabled = 0x0
	// Alarm B enabled
	RTC_CR_ALRBE_Enabled = 0x1
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Wakeup timer disabled
	RTC_CR_WUTE_Disabled = 0x0
	// Wakeup timer enabled
	RTC_CR_WUTE_Enabled = 0x1
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Timestamp disabled
	RTC_CR_TSE_Disabled = 0x0
	// Timestamp enabled
	RTC_CR_TSE_Enabled = 0x1
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Alarm A interrupt disabled
	RTC_CR_ALRAIE_Disabled = 0x0
	// Alarm A interrupt enabled
	RTC_CR_ALRAIE_Enabled = 0x1
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Alarm B Interrupt disabled
	RTC_CR_ALRBIE_Disabled = 0x0
	// Alarm B Interrupt enabled
	RTC_CR_ALRBIE_Enabled = 0x1
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Wakeup timer interrupt disabled
	RTC_CR_WUTIE_Disabled = 0x0
	// Wakeup timer interrupt enabled
	RTC_CR_WUTIE_Enabled = 0x1
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Time-stamp Interrupt disabled
	RTC_CR_TSIE_Disabled = 0x0
	// Time-stamp Interrupt enabled
	RTC_CR_TSIE_Enabled = 0x1
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Adds 1 hour to the current time. This can be used for summer time change outside initialization mode
	RTC_CR_ADD1H_Add1 = 0x1
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Subtracts 1 hour to the current time. This can be used for winter time change outside initialization mode
	RTC_CR_SUB1H_Sub1 = 0x1
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Daylight Saving Time change has not been performed
	RTC_CR_BKP_DST_Not_Changed = 0x0
	// Daylight Saving Time change has been performed
	RTC_CR_BKP_DST_Changed = 0x1
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Calibration output is 512 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_512Hz = 0x0
	// Calibration output is 1 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_1Hz = 0x1
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// The pin is high when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_High = 0x0
	// The pin is low when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_Low = 0x1
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Output disabled
	RTC_CR_OSEL_Disabled = 0x0
	// Alarm A output enabled
	RTC_CR_OSEL_AlarmA = 0x1
	// Alarm B output enabled
	RTC_CR_OSEL_AlarmB = 0x2
	// Wakeup output enabled
	RTC_CR_OSEL_Wakeup = 0x3
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Calibration output disabled
	RTC_CR_COE_Disabled = 0x0
	// Calibration output enabled
	RTC_CR_COE_Enabled = 0x1
	// Position of ITSE field.
	RTC_CR_ITSE_Pos = 0x18
	// Bit mask of ITSE field.
	RTC_CR_ITSE_Msk = 0x1000000
	// Bit ITSE.
	RTC_CR_ITSE = 0x1000000

	// ISR: initialization and status register
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1
	// Alarm update not allowed
	RTC_ISR_ALRAWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRAWF_UpdateAllowed = 0x1
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Alarm update not allowed
	RTC_ISR_ALRBWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRBWF_UpdateAllowed = 0x1
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Wakeup timer configuration update not allowed
	RTC_ISR_WUTWF_UpdateNotAllowed = 0x0
	// Wakeup timer configuration update allowed
	RTC_ISR_WUTWF_UpdateAllowed = 0x1
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// No shift operation is pending
	RTC_ISR_SHPF_NoShiftPending = 0x0
	// A shift operation is pending
	RTC_ISR_SHPF_ShiftPending = 0x1
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Calendar has not been initialized
	RTC_ISR_INITS_NotInitalized = 0x0
	// Calendar has been initialized
	RTC_ISR_INITS_Initalized = 0x1
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Calendar shadow registers not yet synchronized
	RTC_ISR_RSF_NotSynced = 0x0
	// Calendar shadow registers synchronized
	RTC_ISR_RSF_Synced = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_RSF_Clear = 0x0
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Calendar registers update is not allowed
	RTC_ISR_INITF_NotAllowed = 0x0
	// Calendar registers update is allowed
	RTC_ISR_INITF_Allowed = 0x1
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Free running mode
	RTC_ISR_INIT_FreeRunningMode = 0x0
	// Initialization mode used to program time and date register (RTC_TR and RTC_DR), and prescaler register (RTC_PRER). Counters are stopped and start counting from the new value when INIT is reset.
	RTC_ISR_INIT_InitMode = 0x1
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm A register (RTC_ALRMAR)
	RTC_ISR_ALRAF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRAF_Clear = 0x0
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm B register (RTC_ALRMBR)
	RTC_ISR_ALRBF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRBF_Clear = 0x0
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// This flag is set by hardware when the wakeup auto-reload counter reaches 0
	RTC_ISR_WUTF_Zero = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_WUTF_Clear = 0x0
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// This flag is set by hardware when a time-stamp event occurs
	RTC_ISR_TSF_TimestampEvent = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSF_Clear = 0x0
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// This flag is set by hardware when a time-stamp event occurs while TSF is already set
	RTC_ISR_TSOVF_Overflow = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSOVF_Clear = 0x0
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP1F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP1F_Clear = 0x0
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP2F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP2F_Clear = 0x0
	// Position of TAMP3F field.
	RTC_ISR_TAMP3F_Pos = 0xf
	// Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F_Msk = 0x8000
	// Bit TAMP3F.
	RTC_ISR_TAMP3F = 0x8000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP3F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP3F_Clear = 0x0
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000
	// The RECALPF status flag is automatically set to 1 when software writes to the RTC_CALR register, indicating that the RTC_CALR register is blocked. When the new calibration settings are taken into account, this bit returns to 0
	RTC_ISR_RECALPF_Pending = 0x1

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMAR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMAR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMAR_PM_AM = 0x0
	// PM
	RTC_ALRMAR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMBR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMBR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMBR_PM_AM = 0x0
	// PM
	RTC_ALRMBR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Add one second to the clock/calendar
	RTC_SHIFTR_ADD1S_Add1 = 0x1
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: time stamp time register
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// No RTCCLK pulses are added
	RTC_CALR_CALP_NoChange = 0x0
	// One RTCCLK pulse is effectively inserted every 2^11 pulses (frequency increased by 488.5 ppm)
	RTC_CALR_CALP_IncreaseFreq = 0x1
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// When CALW8 is set to ‘1’, the 8-second calibration cycle period is selected
	RTC_CALR_CALW8_Eight_Second = 0x1
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// When CALW16 is set to ‘1’, the 16-second calibration cycle period is selected.This bit must not be set to ‘1’ if CALW8=1
	RTC_CALR_CALW16_Sixteen_Second = 0x1
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAMPCR: tamper configuration register
	// Position of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAMPCR_TAMP1E = 0x1
	// Position of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAMPCR_TAMP1TRG = 0x2
	// Position of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAMPCR_TAMPIE = 0x4
	// Position of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAMPCR_TAMP2E = 0x8
	// Position of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAMPCR_TAMP2TRG = 0x10
	// Position of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Pos = 0x5
	// Bit mask of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Msk = 0x20
	// Bit TAMP3E.
	RTC_TAMPCR_TAMP3E = 0x20
	// Position of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Pos = 0x6
	// Bit mask of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Msk = 0x40
	// Bit TAMP3TRG.
	RTC_TAMPCR_TAMP3TRG = 0x40
	// Position of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAMPCR_TAMPTS = 0x80
	// Position of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Msk = 0x700
	// Position of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Msk = 0x1800
	// Position of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Msk = 0x6000
	// Position of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAMPCR_TAMPPUDIS = 0x8000
	// Position of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Pos = 0x10
	// Bit mask of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Msk = 0x10000
	// Bit TAMP1IE.
	RTC_TAMPCR_TAMP1IE = 0x10000
	// Position of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Pos = 0x11
	// Bit mask of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Msk = 0x20000
	// Bit TAMP1NOERASE.
	RTC_TAMPCR_TAMP1NOERASE = 0x20000
	// Position of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Pos = 0x12
	// Bit mask of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Msk = 0x40000
	// Bit TAMP1MF.
	RTC_TAMPCR_TAMP1MF = 0x40000
	// Position of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Pos = 0x13
	// Bit mask of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Msk = 0x80000
	// Bit TAMP2IE.
	RTC_TAMPCR_TAMP2IE = 0x80000
	// Position of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Pos = 0x14
	// Bit mask of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Msk = 0x100000
	// Bit TAMP2NOERASE.
	RTC_TAMPCR_TAMP2NOERASE = 0x100000
	// Position of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Pos = 0x15
	// Bit mask of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Msk = 0x200000
	// Bit TAMP2MF.
	RTC_TAMPCR_TAMP2MF = 0x200000
	// Position of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Pos = 0x16
	// Bit mask of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Msk = 0x400000
	// Bit TAMP3IE.
	RTC_TAMPCR_TAMP3IE = 0x400000
	// Position of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Pos = 0x17
	// Bit mask of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Msk = 0x800000
	// Bit TAMP3NOERASE.
	RTC_TAMPCR_TAMP3NOERASE = 0x800000
	// Position of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Pos = 0x18
	// Bit mask of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Msk = 0x1000000
	// Bit TAMP3MF.
	RTC_TAMPCR_TAMP3MF = 0x1000000

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// OR: option register
	// Position of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Pos = 0x0
	// Bit mask of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Msk = 0x1
	// Bit RTC_ALARM_TYPE.
	RTC_OR_RTC_ALARM_TYPE = 0x1
	// Position of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Pos = 0x1
	// Bit mask of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Msk = 0x2
	// Bit RTC_OUT_RMP.
	RTC_OR_RTC_OUT_RMP = 0x2

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	// Position of M1 field.
	USART_CR1_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_M1 = 0x10000000
	// Use M0 to set the data bits
	USART_CR1_M1_M0 = 0x0
	// 1 start bit, 7 data bits, n stop bits
	USART_CR1_M1_Bit7 = 0x1
	// Position of EOBIE field.
	USART_CR1_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_EOBIE = 0x8000000
	// Interrupt is inhibited
	USART_CR1_EOBIE_Disabled = 0x0
	// A USART interrupt is generated when the EOBF flag is set in the ISR register
	USART_CR1_EOBIE_Enabled = 0x1
	// Position of RTOIE field.
	USART_CR1_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_RTOIE = 0x4000000
	// Interrupt is inhibited
	USART_CR1_RTOIE_Disabled = 0x0
	// An USART interrupt is generated when the RTOF bit is set in the ISR register
	USART_CR1_RTOIE_Enabled = 0x1
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_OVER8_Oversampling16 = 0x0
	// Oversampling by 8
	USART_CR1_OVER8_Oversampling8 = 0x1
	// Position of CMIE field.
	USART_CR1_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_CMIE = 0x4000
	// Interrupt is disabled
	USART_CR1_CMIE_Disabled = 0x0
	// Interrupt is generated when the CMF bit is set in the ISR register
	USART_CR1_CMIE_Enabled = 0x1
	// Position of MME field.
	USART_CR1_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_MME_Disabled = 0x0
	// Receiver can switch between mute mode and active mode
	USART_CR1_MME_Enabled = 0x1
	// Position of M0 field.
	USART_CR1_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_M0 = 0x1000
	// 1 start bit, 8 data bits, n stop bits
	USART_CR1_M0_Bit8 = 0x0
	// 1 start bit, 9 data bits, n stop bits
	USART_CR1_M0_Bit9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// Idle line
	USART_CR1_WAKE_Idle = 0x0
	// Address mask
	USART_CR1_WAKE_Address = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// Interrupt is disabled
	USART_CR1_PEIE_Disabled = 0x0
	// Interrupt is generated whenever PE=1 in the ISR register
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// Interrupt is disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// Interrupt is generated whenever TXE=1 in the ISR register
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// Interrupt is disabled
	USART_CR1_TCIE_Disabled = 0x0
	// Interrupt is generated whenever TC=1 in the ISR register
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// Interrupt is disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// Interrupt is generated whenever ORE=1 or RXNE=1 in the ISR register
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// Interrupt is disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// Interrupt is generated whenever IDLE=1 in the ISR register
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter is disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter is enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver is disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver is enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of UESM field.
	USART_CR1_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_UESM = 0x2
	// USART not able to wake up the MCU from Stop mode
	USART_CR1_UESM_Disabled = 0x0
	// USART able to wake up the MCU from Stop mode
	USART_CR1_UESM_Enabled = 0x1
	// Position of UE field.
	USART_CR1_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_UE = 0x1
	// UART is disabled
	USART_CR1_UE_Disabled = 0x0
	// UART is enabled
	USART_CR1_UE_Enabled = 0x1
	// Position of DEAT field.
	USART_CR1_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_DEAT_Msk = 0x3e00000
	// Position of DEDT field.
	USART_CR1_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_DEDT_Msk = 0x1f0000

	// CR2: Control register 2
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Receiver timeout feature disabled
	USART_CR2_RTOEN_Disabled = 0x0
	// Receiver timeout feature enabled
	USART_CR2_RTOEN_Enabled = 0x1
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Auto baud rate detection is disabled
	USART_CR2_ABREN_Disabled = 0x0
	// Auto baud rate detection is enabled
	USART_CR2_ABREN_Enabled = 0x1
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// data is transmitted/received with data bit 0 first, following the start bit
	USART_CR2_MSBFIRST_LSB = 0x0
	// data is transmitted/received with MSB (bit 7/8/9) first, following the start bit
	USART_CR2_MSBFIRST_MSB = 0x1
	// Position of DATAINV field.
	USART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	USART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	USART_CR2_DATAINV = 0x40000
	// Logical data from the data register are send/received in positive/direct logic
	USART_CR2_DATAINV_Positive = 0x0
	// Logical data from the data register are send/received in negative/inverse logic
	USART_CR2_DATAINV_Negative = 0x1
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// TX pin signal works using the standard logic levels
	USART_CR2_TXINV_Standard = 0x0
	// TX pin signal values are inverted
	USART_CR2_TXINV_Inverted = 0x1
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// RX pin signal works using the standard logic levels
	USART_CR2_RXINV_Standard = 0x0
	// RX pin signal values are inverted
	USART_CR2_RXINV_Inverted = 0x1
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// TX/RX pins are used as defined in standard pinout
	USART_CR2_SWAP_Standard = 0x0
	// The TX and RX pins functions are swapped
	USART_CR2_SWAP_Swapped = 0x1
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bit
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bit
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bit
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// The clock pulse of the last data bit is not output to the CK pin
	USART_CR2_LBCL_NotOutput = 0x0
	// The clock pulse of the last data bit is output to the CK pin
	USART_CR2_LBCL_Output = 0x1
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Interrupt is inhibited
	USART_CR2_LBDIE_Disabled = 0x0
	// An interrupt is generated whenever LBDF=1 in the ISR register
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_Bit10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_Bit11 = 0x1
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// 4-bit address detection
	USART_CR2_ADDM7_Bit4 = 0x0
	// 7-bit address detection
	USART_CR2_ADDM7_Bit7 = 0x1
	// Position of ABRMOD field.
	USART_CR2_ABRMOD_Pos = 0x15
	// Bit mask of ABRMOD field.
	USART_CR2_ABRMOD_Msk = 0x600000
	// Measurement of the start bit is used to detect the baud rate
	USART_CR2_ABRMOD_Start = 0x0
	// Falling edge to falling edge measurement
	USART_CR2_ABRMOD_Edge = 0x1
	// 0x7F frame detection
	USART_CR2_ABRMOD_Frame7F = 0x2
	// 0x55 frame detection
	USART_CR2_ABRMOD_Frame55 = 0x3
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x18
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xff000000

	// CR3: Control register 3
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Interrupt is inhibited
	USART_CR3_WUFIE_Disabled = 0x0
	// An USART interrupt is generated whenever WUF=1 in the ISR register
	USART_CR3_WUFIE_Enabled = 0x1
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// WUF active on address match
	USART_CR3_WUS_Address = 0x0
	// WuF active on Start bit detection
	USART_CR3_WUS_Start = 0x2
	// WUF active on RXNE
	USART_CR3_WUS_RXNE = 0x3
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// DE signal is active high
	USART_CR3_DEP_High = 0x0
	// DE signal is active low
	USART_CR3_DEP_Low = 0x1
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// DE function is disabled
	USART_CR3_DEM_Disabled = 0x0
	// The DE signal is output on the RTS pin
	USART_CR3_DEM_Enabled = 0x1
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// DMA is not disabled in case of reception error
	USART_CR3_DDRE_NotDisabled = 0x0
	// DMA is disabled following a reception error
	USART_CR3_DDRE_Disabled = 0x1
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Overrun Error Flag, ORE, is set when received data is not read before receiving new data
	USART_CR3_OVRDIS_Enabled = 0x0
	// Overrun functionality is disabled. If new data is received while the RXNE flag is still set the ORE flag is not set and the new received data overwrites the previous content of the RDR register
	USART_CR3_OVRDIS_Disabled = 0x1
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_Sample3 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_Sample1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Interrupt is inhibited
	USART_CR3_CTSIE_Disabled = 0x0
	// An interrupt is generated whenever CTSIF=1 in the ISR register
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS mode enabled, data is only transmitted when the CTS input is asserted
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS output enabled, data is only requested when there is space in the receive buffer
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard Mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard Mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_NotSelected = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_Selected = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Interrupt is inhibited
	USART_CR3_EIE_Disabled = 0x0
	// An interrupt is generated when FE=1 or ORE=1 or NF=1 in the ISR register
	USART_CR3_EIE_Enabled = 0x1

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xffff

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff

	// RTOR: Receiver timeout register
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff

	// RQR: Request register
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10
	// Set the TXE flags. This allows to discard the transmit data
	USART_RQR_TXFRQ_Discard = 0x1
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// clears the RXNE flag. This allows to discard the received data without reading it, and avoid an overrun condition
	USART_RQR_RXFRQ_Discard = 0x1
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Puts the USART in mute mode and sets the RWU flag
	USART_RQR_MMRQ_Mute = 0x1
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// sets the SBKF flag and request to send a BREAK on the line, as soon as the transmit machine is available
	USART_RQR_SBKRQ_Break = 0x1
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1
	// resets the ABRF flag in the USART_ISR and request an automatic baud rate measurement on the next received data frame
	USART_RQR_ABRRQ_Request = 0x1

	// ISR: Interrupt & status register
	// Position of REACK field.
	USART_ISR_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_BUSY = 0x10000
	// Position of ABRF field.
	USART_ISR_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_ABRF = 0x8000
	// Position of ABRE field.
	USART_ISR_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_ABRE = 0x4000
	// Position of EOBF field.
	USART_ISR_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_EOBF = 0x1000
	// Position of RTOF field.
	USART_ISR_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_RTOF = 0x800
	// Position of CTS field.
	USART_ISR_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_CTSIF = 0x200
	// Position of LBDF field.
	USART_ISR_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_LBDF = 0x100
	// Position of TXE field.
	USART_ISR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_TXE = 0x80
	// Position of TC field.
	USART_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_TC = 0x40
	// Position of RXNE field.
	USART_ISR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_RXNE = 0x20
	// Position of IDLE field.
	USART_ISR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_ORE = 0x8
	// Position of NF field.
	USART_ISR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_ISR_NF_Msk = 0x4
	// Bit NF.
	USART_ISR_NF = 0x4
	// Position of FE field.
	USART_ISR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FE = 0x2
	// Position of PE field.
	USART_ISR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_PE = 0x1

	// ICR: Interrupt flag clear register
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000
	// Clears the WUF flag in the ISR register
	USART_ICR_WUCF_Clear = 0x1
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Clears the CMF flag in the ISR register
	USART_ICR_CMCF_Clear = 0x1
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Clears the EOBF flag in the ISR register
	USART_ICR_EOBCF_Clear = 0x1
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Clears the RTOF flag in the ISR register
	USART_ICR_RTOCF_Clear = 0x1
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Clears the CTSIF flag in the ISR register
	USART_ICR_CTSCF_Clear = 0x1
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Clears the LBDF flag in the ISR register
	USART_ICR_LBDCF_Clear = 0x1
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Clears the TC flag in the ISR register
	USART_ICR_TCCF_Clear = 0x1
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Clears the IDLE flag in the ISR register
	USART_ICR_IDLECF_Clear = 0x1
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Clears the ORE flag in the ISR register
	USART_ICR_ORECF_Clear = 0x1
	// Position of NCF field.
	USART_ICR_NCF_Pos = 0x2
	// Bit mask of NCF field.
	USART_ICR_NCF_Msk = 0x4
	// Bit NCF.
	USART_ICR_NCF = 0x4
	// Clears the NF flag in the ISR register
	USART_ICR_NCF_Clear = 0x1
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Clears the FE flag in the ISR register
	USART_ICR_FECF_Clear = 0x1
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1
	// Clears the PE flag in the ISR register
	USART_ICR_PECF_Clear = 0x1

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff
)

// Bitfields for OTG_FS_GLOBAL: USB on the go full speed
const (
	// OTG_FS_GOTGCTL: OTG_FS control and status register (OTG_FS_GOTGCTL)
	// Position of SRQSCS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQSCS_Pos = 0x0
	// Bit mask of SRQSCS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQSCS_Msk = 0x1
	// Bit SRQSCS.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQSCS = 0x1
	// Position of SRQ field.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQ_Pos = 0x1
	// Bit mask of SRQ field.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQ_Msk = 0x2
	// Bit SRQ.
	USB_OTG_FS_OTG_FS_GOTGCTL_SRQ = 0x2
	// Position of HNGSCS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNGSCS_Pos = 0x8
	// Bit mask of HNGSCS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNGSCS_Msk = 0x100
	// Bit HNGSCS.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNGSCS = 0x100
	// Position of HNPRQ field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNPRQ_Pos = 0x9
	// Bit mask of HNPRQ field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNPRQ_Msk = 0x200
	// Bit HNPRQ.
	USB_OTG_FS_OTG_FS_GOTGCTL_HNPRQ = 0x200
	// Position of HSHNPEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HSHNPEN_Pos = 0xa
	// Bit mask of HSHNPEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_HSHNPEN_Msk = 0x400
	// Bit HSHNPEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_HSHNPEN = 0x400
	// Position of DHNPEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_DHNPEN_Pos = 0xb
	// Bit mask of DHNPEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_DHNPEN_Msk = 0x800
	// Bit DHNPEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_DHNPEN = 0x800
	// Position of CIDSTS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_CIDSTS_Pos = 0x10
	// Bit mask of CIDSTS field.
	USB_OTG_FS_OTG_FS_GOTGCTL_CIDSTS_Msk = 0x10000
	// Bit CIDSTS.
	USB_OTG_FS_OTG_FS_GOTGCTL_CIDSTS = 0x10000
	// Position of DBCT field.
	USB_OTG_FS_OTG_FS_GOTGCTL_DBCT_Pos = 0x11
	// Bit mask of DBCT field.
	USB_OTG_FS_OTG_FS_GOTGCTL_DBCT_Msk = 0x20000
	// Bit DBCT.
	USB_OTG_FS_OTG_FS_GOTGCTL_DBCT = 0x20000
	// Position of ASVLD field.
	USB_OTG_FS_OTG_FS_GOTGCTL_ASVLD_Pos = 0x12
	// Bit mask of ASVLD field.
	USB_OTG_FS_OTG_FS_GOTGCTL_ASVLD_Msk = 0x40000
	// Bit ASVLD.
	USB_OTG_FS_OTG_FS_GOTGCTL_ASVLD = 0x40000
	// Position of BSVLD field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BSVLD_Pos = 0x13
	// Bit mask of BSVLD field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BSVLD_Msk = 0x80000
	// Bit BSVLD.
	USB_OTG_FS_OTG_FS_GOTGCTL_BSVLD = 0x80000
	// Position of VBVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOEN_Pos = 0x2
	// Bit mask of VBVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOEN_Msk = 0x4
	// Bit VBVALOEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOEN = 0x4
	// Position of VBVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOVAL_Pos = 0x3
	// Bit mask of VBVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOVAL_Msk = 0x8
	// Bit VBVALOVAL.
	USB_OTG_FS_OTG_FS_GOTGCTL_VBVALOVAL = 0x8
	// Position of AVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOEN_Pos = 0x4
	// Bit mask of AVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOEN_Msk = 0x10
	// Bit AVALOEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOEN = 0x10
	// Position of AVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOVAL_Pos = 0x5
	// Bit mask of AVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOVAL_Msk = 0x20
	// Bit AVALOVAL.
	USB_OTG_FS_OTG_FS_GOTGCTL_AVALOVAL = 0x20
	// Position of BVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOEN_Pos = 0x6
	// Bit mask of BVALOEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOEN_Msk = 0x40
	// Bit BVALOEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOEN = 0x40
	// Position of BVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOVAL_Pos = 0x7
	// Bit mask of BVALOVAL field.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOVAL_Msk = 0x80
	// Bit BVALOVAL.
	USB_OTG_FS_OTG_FS_GOTGCTL_BVALOVAL = 0x80
	// Position of EHEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_EHEN_Pos = 0xc
	// Bit mask of EHEN field.
	USB_OTG_FS_OTG_FS_GOTGCTL_EHEN_Msk = 0x1000
	// Bit EHEN.
	USB_OTG_FS_OTG_FS_GOTGCTL_EHEN = 0x1000
	// Position of OTGVER field.
	USB_OTG_FS_OTG_FS_GOTGCTL_OTGVER_Pos = 0x14
	// Bit mask of OTGVER field.
	USB_OTG_FS_OTG_FS_GOTGCTL_OTGVER_Msk = 0x100000
	// Bit OTGVER.
	USB_OTG_FS_OTG_FS_GOTGCTL_OTGVER = 0x100000

	// OTG_FS_GOTGINT: OTG_FS interrupt register (OTG_FS_GOTGINT)
	// Position of SEDET field.
	USB_OTG_FS_OTG_FS_GOTGINT_SEDET_Pos = 0x2
	// Bit mask of SEDET field.
	USB_OTG_FS_OTG_FS_GOTGINT_SEDET_Msk = 0x4
	// Bit SEDET.
	USB_OTG_FS_OTG_FS_GOTGINT_SEDET = 0x4
	// Position of SRSSCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_SRSSCHG_Pos = 0x8
	// Bit mask of SRSSCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_SRSSCHG_Msk = 0x100
	// Bit SRSSCHG.
	USB_OTG_FS_OTG_FS_GOTGINT_SRSSCHG = 0x100
	// Position of HNSSCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_HNSSCHG_Pos = 0x9
	// Bit mask of HNSSCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_HNSSCHG_Msk = 0x200
	// Bit HNSSCHG.
	USB_OTG_FS_OTG_FS_GOTGINT_HNSSCHG = 0x200
	// Position of HNGDET field.
	USB_OTG_FS_OTG_FS_GOTGINT_HNGDET_Pos = 0x11
	// Bit mask of HNGDET field.
	USB_OTG_FS_OTG_FS_GOTGINT_HNGDET_Msk = 0x20000
	// Bit HNGDET.
	USB_OTG_FS_OTG_FS_GOTGINT_HNGDET = 0x20000
	// Position of ADTOCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_ADTOCHG_Pos = 0x12
	// Bit mask of ADTOCHG field.
	USB_OTG_FS_OTG_FS_GOTGINT_ADTOCHG_Msk = 0x40000
	// Bit ADTOCHG.
	USB_OTG_FS_OTG_FS_GOTGINT_ADTOCHG = 0x40000
	// Position of DBCDNE field.
	USB_OTG_FS_OTG_FS_GOTGINT_DBCDNE_Pos = 0x13
	// Bit mask of DBCDNE field.
	USB_OTG_FS_OTG_FS_GOTGINT_DBCDNE_Msk = 0x80000
	// Bit DBCDNE.
	USB_OTG_FS_OTG_FS_GOTGINT_DBCDNE = 0x80000
	// Position of IDCHNG field.
	USB_OTG_FS_OTG_FS_GOTGINT_IDCHNG_Pos = 0x14
	// Bit mask of IDCHNG field.
	USB_OTG_FS_OTG_FS_GOTGINT_IDCHNG_Msk = 0x100000
	// Bit IDCHNG.
	USB_OTG_FS_OTG_FS_GOTGINT_IDCHNG = 0x100000

	// OTG_FS_GAHBCFG: OTG_FS AHB configuration register (OTG_FS_GAHBCFG)
	// Position of GINT field.
	USB_OTG_FS_OTG_FS_GAHBCFG_GINT_Pos = 0x0
	// Bit mask of GINT field.
	USB_OTG_FS_OTG_FS_GAHBCFG_GINT_Msk = 0x1
	// Bit GINT.
	USB_OTG_FS_OTG_FS_GAHBCFG_GINT = 0x1
	// Position of TXFELVL field.
	USB_OTG_FS_OTG_FS_GAHBCFG_TXFELVL_Pos = 0x7
	// Bit mask of TXFELVL field.
	USB_OTG_FS_OTG_FS_GAHBCFG_TXFELVL_Msk = 0x80
	// Bit TXFELVL.
	USB_OTG_FS_OTG_FS_GAHBCFG_TXFELVL = 0x80
	// Position of PTXFELVL field.
	USB_OTG_FS_OTG_FS_GAHBCFG_PTXFELVL_Pos = 0x8
	// Bit mask of PTXFELVL field.
	USB_OTG_FS_OTG_FS_GAHBCFG_PTXFELVL_Msk = 0x100
	// Bit PTXFELVL.
	USB_OTG_FS_OTG_FS_GAHBCFG_PTXFELVL = 0x100

	// OTG_FS_GUSBCFG: OTG_FS USB configuration register (OTG_FS_GUSBCFG)
	// Position of TOCAL field.
	USB_OTG_FS_OTG_FS_GUSBCFG_TOCAL_Pos = 0x0
	// Bit mask of TOCAL field.
	USB_OTG_FS_OTG_FS_GUSBCFG_TOCAL_Msk = 0x7
	// Position of PHYSEL field.
	USB_OTG_FS_OTG_FS_GUSBCFG_PHYSEL_Pos = 0x6
	// Bit mask of PHYSEL field.
	USB_OTG_FS_OTG_FS_GUSBCFG_PHYSEL_Msk = 0x40
	// Bit PHYSEL.
	USB_OTG_FS_OTG_FS_GUSBCFG_PHYSEL = 0x40
	// Position of SRPCAP field.
	USB_OTG_FS_OTG_FS_GUSBCFG_SRPCAP_Pos = 0x8
	// Bit mask of SRPCAP field.
	USB_OTG_FS_OTG_FS_GUSBCFG_SRPCAP_Msk = 0x100
	// Bit SRPCAP.
	USB_OTG_FS_OTG_FS_GUSBCFG_SRPCAP = 0x100
	// Position of HNPCAP field.
	USB_OTG_FS_OTG_FS_GUSBCFG_HNPCAP_Pos = 0x9
	// Bit mask of HNPCAP field.
	USB_OTG_FS_OTG_FS_GUSBCFG_HNPCAP_Msk = 0x200
	// Bit HNPCAP.
	USB_OTG_FS_OTG_FS_GUSBCFG_HNPCAP = 0x200
	// Position of TRDT field.
	USB_OTG_FS_OTG_FS_GUSBCFG_TRDT_Pos = 0xa
	// Bit mask of TRDT field.
	USB_OTG_FS_OTG_FS_GUSBCFG_TRDT_Msk = 0x3c00
	// Position of FHMOD field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FHMOD_Pos = 0x1d
	// Bit mask of FHMOD field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FHMOD_Msk = 0x20000000
	// Bit FHMOD.
	USB_OTG_FS_OTG_FS_GUSBCFG_FHMOD = 0x20000000
	// Position of FDMOD field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FDMOD_Pos = 0x1e
	// Bit mask of FDMOD field.
	USB_OTG_FS_OTG_FS_GUSBCFG_FDMOD_Msk = 0x40000000
	// Bit FDMOD.
	USB_OTG_FS_OTG_FS_GUSBCFG_FDMOD = 0x40000000

	// OTG_FS_GRSTCTL: OTG_FS reset register (OTG_FS_GRSTCTL)
	// Position of CSRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_CSRST_Pos = 0x0
	// Bit mask of CSRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_CSRST_Msk = 0x1
	// Bit CSRST.
	USB_OTG_FS_OTG_FS_GRSTCTL_CSRST = 0x1
	// Position of HSRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_HSRST_Pos = 0x1
	// Bit mask of HSRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_HSRST_Msk = 0x2
	// Bit HSRST.
	USB_OTG_FS_OTG_FS_GRSTCTL_HSRST = 0x2
	// Position of FCRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_FCRST_Pos = 0x2
	// Bit mask of FCRST field.
	USB_OTG_FS_OTG_FS_GRSTCTL_FCRST_Msk = 0x4
	// Bit FCRST.
	USB_OTG_FS_OTG_FS_GRSTCTL_FCRST = 0x4
	// Position of RXFFLSH field.
	USB_OTG_FS_OTG_FS_GRSTCTL_RXFFLSH_Pos = 0x4
	// Bit mask of RXFFLSH field.
	USB_OTG_FS_OTG_FS_GRSTCTL_RXFFLSH_Msk = 0x10
	// Bit RXFFLSH.
	USB_OTG_FS_OTG_FS_GRSTCTL_RXFFLSH = 0x10
	// Position of TXFFLSH field.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFFLSH_Pos = 0x5
	// Bit mask of TXFFLSH field.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFFLSH_Msk = 0x20
	// Bit TXFFLSH.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFFLSH = 0x20
	// Position of TXFNUM field.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFNUM_Pos = 0x6
	// Bit mask of TXFNUM field.
	USB_OTG_FS_OTG_FS_GRSTCTL_TXFNUM_Msk = 0x7c0
	// Position of AHBIDL field.
	USB_OTG_FS_OTG_FS_GRSTCTL_AHBIDL_Pos = 0x1f
	// Bit mask of AHBIDL field.
	USB_OTG_FS_OTG_FS_GRSTCTL_AHBIDL_Msk = 0x80000000
	// Bit AHBIDL.
	USB_OTG_FS_OTG_FS_GRSTCTL_AHBIDL = 0x80000000

	// OTG_FS_GINTSTS: OTG_FS core interrupt register (OTG_FS_GINTSTS)
	// Position of CMOD field.
	USB_OTG_FS_OTG_FS_GINTSTS_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	USB_OTG_FS_OTG_FS_GINTSTS_CMOD_Msk = 0x1
	// Bit CMOD.
	USB_OTG_FS_OTG_FS_GINTSTS_CMOD = 0x1
	// Position of MMIS field.
	USB_OTG_FS_OTG_FS_GINTSTS_MMIS_Pos = 0x1
	// Bit mask of MMIS field.
	USB_OTG_FS_OTG_FS_GINTSTS_MMIS_Msk = 0x2
	// Bit MMIS.
	USB_OTG_FS_OTG_FS_GINTSTS_MMIS = 0x2
	// Position of OTGINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_OTGINT_Pos = 0x2
	// Bit mask of OTGINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_OTGINT_Msk = 0x4
	// Bit OTGINT.
	USB_OTG_FS_OTG_FS_GINTSTS_OTGINT = 0x4
	// Position of SOF field.
	USB_OTG_FS_OTG_FS_GINTSTS_SOF_Pos = 0x3
	// Bit mask of SOF field.
	USB_OTG_FS_OTG_FS_GINTSTS_SOF_Msk = 0x8
	// Bit SOF.
	USB_OTG_FS_OTG_FS_GINTSTS_SOF = 0x8
	// Position of RXFLVL field.
	USB_OTG_FS_OTG_FS_GINTSTS_RXFLVL_Pos = 0x4
	// Bit mask of RXFLVL field.
	USB_OTG_FS_OTG_FS_GINTSTS_RXFLVL_Msk = 0x10
	// Bit RXFLVL.
	USB_OTG_FS_OTG_FS_GINTSTS_RXFLVL = 0x10
	// Position of NPTXFE field.
	USB_OTG_FS_OTG_FS_GINTSTS_NPTXFE_Pos = 0x5
	// Bit mask of NPTXFE field.
	USB_OTG_FS_OTG_FS_GINTSTS_NPTXFE_Msk = 0x20
	// Bit NPTXFE.
	USB_OTG_FS_OTG_FS_GINTSTS_NPTXFE = 0x20
	// Position of GINAKEFF field.
	USB_OTG_FS_OTG_FS_GINTSTS_GINAKEFF_Pos = 0x6
	// Bit mask of GINAKEFF field.
	USB_OTG_FS_OTG_FS_GINTSTS_GINAKEFF_Msk = 0x40
	// Bit GINAKEFF.
	USB_OTG_FS_OTG_FS_GINTSTS_GINAKEFF = 0x40
	// Position of GOUTNAKEFF field.
	USB_OTG_FS_OTG_FS_GINTSTS_GOUTNAKEFF_Pos = 0x7
	// Bit mask of GOUTNAKEFF field.
	USB_OTG_FS_OTG_FS_GINTSTS_GOUTNAKEFF_Msk = 0x80
	// Bit GOUTNAKEFF.
	USB_OTG_FS_OTG_FS_GINTSTS_GOUTNAKEFF = 0x80
	// Position of ESUSP field.
	USB_OTG_FS_OTG_FS_GINTSTS_ESUSP_Pos = 0xa
	// Bit mask of ESUSP field.
	USB_OTG_FS_OTG_FS_GINTSTS_ESUSP_Msk = 0x400
	// Bit ESUSP.
	USB_OTG_FS_OTG_FS_GINTSTS_ESUSP = 0x400
	// Position of USBSUSP field.
	USB_OTG_FS_OTG_FS_GINTSTS_USBSUSP_Pos = 0xb
	// Bit mask of USBSUSP field.
	USB_OTG_FS_OTG_FS_GINTSTS_USBSUSP_Msk = 0x800
	// Bit USBSUSP.
	USB_OTG_FS_OTG_FS_GINTSTS_USBSUSP = 0x800
	// Position of USBRST field.
	USB_OTG_FS_OTG_FS_GINTSTS_USBRST_Pos = 0xc
	// Bit mask of USBRST field.
	USB_OTG_FS_OTG_FS_GINTSTS_USBRST_Msk = 0x1000
	// Bit USBRST.
	USB_OTG_FS_OTG_FS_GINTSTS_USBRST = 0x1000
	// Position of ENUMDNE field.
	USB_OTG_FS_OTG_FS_GINTSTS_ENUMDNE_Pos = 0xd
	// Bit mask of ENUMDNE field.
	USB_OTG_FS_OTG_FS_GINTSTS_ENUMDNE_Msk = 0x2000
	// Bit ENUMDNE.
	USB_OTG_FS_OTG_FS_GINTSTS_ENUMDNE = 0x2000
	// Position of ISOODRP field.
	USB_OTG_FS_OTG_FS_GINTSTS_ISOODRP_Pos = 0xe
	// Bit mask of ISOODRP field.
	USB_OTG_FS_OTG_FS_GINTSTS_ISOODRP_Msk = 0x4000
	// Bit ISOODRP.
	USB_OTG_FS_OTG_FS_GINTSTS_ISOODRP = 0x4000
	// Position of EOPF field.
	USB_OTG_FS_OTG_FS_GINTSTS_EOPF_Pos = 0xf
	// Bit mask of EOPF field.
	USB_OTG_FS_OTG_FS_GINTSTS_EOPF_Msk = 0x8000
	// Bit EOPF.
	USB_OTG_FS_OTG_FS_GINTSTS_EOPF = 0x8000
	// Position of IEPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_IEPINT_Pos = 0x12
	// Bit mask of IEPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_IEPINT_Msk = 0x40000
	// Bit IEPINT.
	USB_OTG_FS_OTG_FS_GINTSTS_IEPINT = 0x40000
	// Position of OEPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_OEPINT_Pos = 0x13
	// Bit mask of OEPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_OEPINT_Msk = 0x80000
	// Bit OEPINT.
	USB_OTG_FS_OTG_FS_GINTSTS_OEPINT = 0x80000
	// Position of IISOIXFR field.
	USB_OTG_FS_OTG_FS_GINTSTS_IISOIXFR_Pos = 0x14
	// Bit mask of IISOIXFR field.
	USB_OTG_FS_OTG_FS_GINTSTS_IISOIXFR_Msk = 0x100000
	// Bit IISOIXFR.
	USB_OTG_FS_OTG_FS_GINTSTS_IISOIXFR = 0x100000
	// Position of IPXFR_INCOMPISOOUT field.
	USB_OTG_FS_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT_Pos = 0x15
	// Bit mask of IPXFR_INCOMPISOOUT field.
	USB_OTG_FS_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT_Msk = 0x200000
	// Bit IPXFR_INCOMPISOOUT.
	USB_OTG_FS_OTG_FS_GINTSTS_IPXFR_INCOMPISOOUT = 0x200000
	// Position of HPRTINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_HPRTINT_Pos = 0x18
	// Bit mask of HPRTINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_HPRTINT_Msk = 0x1000000
	// Bit HPRTINT.
	USB_OTG_FS_OTG_FS_GINTSTS_HPRTINT = 0x1000000
	// Position of HCINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_HCINT_Pos = 0x19
	// Bit mask of HCINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_HCINT_Msk = 0x2000000
	// Bit HCINT.
	USB_OTG_FS_OTG_FS_GINTSTS_HCINT = 0x2000000
	// Position of PTXFE field.
	USB_OTG_FS_OTG_FS_GINTSTS_PTXFE_Pos = 0x1a
	// Bit mask of PTXFE field.
	USB_OTG_FS_OTG_FS_GINTSTS_PTXFE_Msk = 0x4000000
	// Bit PTXFE.
	USB_OTG_FS_OTG_FS_GINTSTS_PTXFE = 0x4000000
	// Position of CIDSCHG field.
	USB_OTG_FS_OTG_FS_GINTSTS_CIDSCHG_Pos = 0x1c
	// Bit mask of CIDSCHG field.
	USB_OTG_FS_OTG_FS_GINTSTS_CIDSCHG_Msk = 0x10000000
	// Bit CIDSCHG.
	USB_OTG_FS_OTG_FS_GINTSTS_CIDSCHG = 0x10000000
	// Position of DISCINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_DISCINT_Pos = 0x1d
	// Bit mask of DISCINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_DISCINT_Msk = 0x20000000
	// Bit DISCINT.
	USB_OTG_FS_OTG_FS_GINTSTS_DISCINT = 0x20000000
	// Position of SRQINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_SRQINT_Pos = 0x1e
	// Bit mask of SRQINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_SRQINT_Msk = 0x40000000
	// Bit SRQINT.
	USB_OTG_FS_OTG_FS_GINTSTS_SRQINT = 0x40000000
	// Position of WKUPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_WKUPINT_Pos = 0x1f
	// Bit mask of WKUPINT field.
	USB_OTG_FS_OTG_FS_GINTSTS_WKUPINT_Msk = 0x80000000
	// Bit WKUPINT.
	USB_OTG_FS_OTG_FS_GINTSTS_WKUPINT = 0x80000000
	// Position of RSTDET field.
	USB_OTG_FS_OTG_FS_GINTSTS_RSTDET_Pos = 0x17
	// Bit mask of RSTDET field.
	USB_OTG_FS_OTG_FS_GINTSTS_RSTDET_Msk = 0x800000
	// Bit RSTDET.
	USB_OTG_FS_OTG_FS_GINTSTS_RSTDET = 0x800000

	// OTG_FS_GINTMSK: OTG_FS interrupt mask register (OTG_FS_GINTMSK)
	// Position of MMISM field.
	USB_OTG_FS_OTG_FS_GINTMSK_MMISM_Pos = 0x1
	// Bit mask of MMISM field.
	USB_OTG_FS_OTG_FS_GINTMSK_MMISM_Msk = 0x2
	// Bit MMISM.
	USB_OTG_FS_OTG_FS_GINTMSK_MMISM = 0x2
	// Position of OTGINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_OTGINT_Pos = 0x2
	// Bit mask of OTGINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_OTGINT_Msk = 0x4
	// Bit OTGINT.
	USB_OTG_FS_OTG_FS_GINTMSK_OTGINT = 0x4
	// Position of SOFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_SOFM_Pos = 0x3
	// Bit mask of SOFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_SOFM_Msk = 0x8
	// Bit SOFM.
	USB_OTG_FS_OTG_FS_GINTMSK_SOFM = 0x8
	// Position of RXFLVLM field.
	USB_OTG_FS_OTG_FS_GINTMSK_RXFLVLM_Pos = 0x4
	// Bit mask of RXFLVLM field.
	USB_OTG_FS_OTG_FS_GINTMSK_RXFLVLM_Msk = 0x10
	// Bit RXFLVLM.
	USB_OTG_FS_OTG_FS_GINTMSK_RXFLVLM = 0x10
	// Position of NPTXFEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_NPTXFEM_Pos = 0x5
	// Bit mask of NPTXFEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_NPTXFEM_Msk = 0x20
	// Bit NPTXFEM.
	USB_OTG_FS_OTG_FS_GINTMSK_NPTXFEM = 0x20
	// Position of GINAKEFFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_GINAKEFFM_Pos = 0x6
	// Bit mask of GINAKEFFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_GINAKEFFM_Msk = 0x40
	// Bit GINAKEFFM.
	USB_OTG_FS_OTG_FS_GINTMSK_GINAKEFFM = 0x40
	// Position of GONAKEFFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_GONAKEFFM_Pos = 0x7
	// Bit mask of GONAKEFFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_GONAKEFFM_Msk = 0x80
	// Bit GONAKEFFM.
	USB_OTG_FS_OTG_FS_GINTMSK_GONAKEFFM = 0x80
	// Position of ESUSPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ESUSPM_Pos = 0xa
	// Bit mask of ESUSPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ESUSPM_Msk = 0x400
	// Bit ESUSPM.
	USB_OTG_FS_OTG_FS_GINTMSK_ESUSPM = 0x400
	// Position of USBSUSPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_USBSUSPM_Pos = 0xb
	// Bit mask of USBSUSPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_USBSUSPM_Msk = 0x800
	// Bit USBSUSPM.
	USB_OTG_FS_OTG_FS_GINTMSK_USBSUSPM = 0x800
	// Position of USBRST field.
	USB_OTG_FS_OTG_FS_GINTMSK_USBRST_Pos = 0xc
	// Bit mask of USBRST field.
	USB_OTG_FS_OTG_FS_GINTMSK_USBRST_Msk = 0x1000
	// Bit USBRST.
	USB_OTG_FS_OTG_FS_GINTMSK_USBRST = 0x1000
	// Position of ENUMDNEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ENUMDNEM_Pos = 0xd
	// Bit mask of ENUMDNEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ENUMDNEM_Msk = 0x2000
	// Bit ENUMDNEM.
	USB_OTG_FS_OTG_FS_GINTMSK_ENUMDNEM = 0x2000
	// Position of ISOODRPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ISOODRPM_Pos = 0xe
	// Bit mask of ISOODRPM field.
	USB_OTG_FS_OTG_FS_GINTMSK_ISOODRPM_Msk = 0x4000
	// Bit ISOODRPM.
	USB_OTG_FS_OTG_FS_GINTMSK_ISOODRPM = 0x4000
	// Position of EOPFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_EOPFM_Pos = 0xf
	// Bit mask of EOPFM field.
	USB_OTG_FS_OTG_FS_GINTMSK_EOPFM_Msk = 0x8000
	// Bit EOPFM.
	USB_OTG_FS_OTG_FS_GINTMSK_EOPFM = 0x8000
	// Position of IEPINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_IEPINT_Pos = 0x12
	// Bit mask of IEPINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_IEPINT_Msk = 0x40000
	// Bit IEPINT.
	USB_OTG_FS_OTG_FS_GINTMSK_IEPINT = 0x40000
	// Position of OEPINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_OEPINT_Pos = 0x13
	// Bit mask of OEPINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_OEPINT_Msk = 0x80000
	// Bit OEPINT.
	USB_OTG_FS_OTG_FS_GINTMSK_OEPINT = 0x80000
	// Position of IISOIXFRM field.
	USB_OTG_FS_OTG_FS_GINTMSK_IISOIXFRM_Pos = 0x14
	// Bit mask of IISOIXFRM field.
	USB_OTG_FS_OTG_FS_GINTMSK_IISOIXFRM_Msk = 0x100000
	// Bit IISOIXFRM.
	USB_OTG_FS_OTG_FS_GINTMSK_IISOIXFRM = 0x100000
	// Position of IPXFRM_IISOOXFRM field.
	USB_OTG_FS_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM_Pos = 0x15
	// Bit mask of IPXFRM_IISOOXFRM field.
	USB_OTG_FS_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM_Msk = 0x200000
	// Bit IPXFRM_IISOOXFRM.
	USB_OTG_FS_OTG_FS_GINTMSK_IPXFRM_IISOOXFRM = 0x200000
	// Position of PRTIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_PRTIM_Pos = 0x18
	// Bit mask of PRTIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_PRTIM_Msk = 0x1000000
	// Bit PRTIM.
	USB_OTG_FS_OTG_FS_GINTMSK_PRTIM = 0x1000000
	// Position of HCIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_HCIM_Pos = 0x19
	// Bit mask of HCIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_HCIM_Msk = 0x2000000
	// Bit HCIM.
	USB_OTG_FS_OTG_FS_GINTMSK_HCIM = 0x2000000
	// Position of PTXFEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_PTXFEM_Pos = 0x1a
	// Bit mask of PTXFEM field.
	USB_OTG_FS_OTG_FS_GINTMSK_PTXFEM_Msk = 0x4000000
	// Bit PTXFEM.
	USB_OTG_FS_OTG_FS_GINTMSK_PTXFEM = 0x4000000
	// Position of CIDSCHGM field.
	USB_OTG_FS_OTG_FS_GINTMSK_CIDSCHGM_Pos = 0x1c
	// Bit mask of CIDSCHGM field.
	USB_OTG_FS_OTG_FS_GINTMSK_CIDSCHGM_Msk = 0x10000000
	// Bit CIDSCHGM.
	USB_OTG_FS_OTG_FS_GINTMSK_CIDSCHGM = 0x10000000
	// Position of DISCINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_DISCINT_Pos = 0x1d
	// Bit mask of DISCINT field.
	USB_OTG_FS_OTG_FS_GINTMSK_DISCINT_Msk = 0x20000000
	// Bit DISCINT.
	USB_OTG_FS_OTG_FS_GINTMSK_DISCINT = 0x20000000
	// Position of SRQIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_SRQIM_Pos = 0x1e
	// Bit mask of SRQIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_SRQIM_Msk = 0x40000000
	// Bit SRQIM.
	USB_OTG_FS_OTG_FS_GINTMSK_SRQIM = 0x40000000
	// Position of WUIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_WUIM_Pos = 0x1f
	// Bit mask of WUIM field.
	USB_OTG_FS_OTG_FS_GINTMSK_WUIM_Msk = 0x80000000
	// Bit WUIM.
	USB_OTG_FS_OTG_FS_GINTMSK_WUIM = 0x80000000
	// Position of RSTDETM field.
	USB_OTG_FS_OTG_FS_GINTMSK_RSTDETM_Pos = 0x17
	// Bit mask of RSTDETM field.
	USB_OTG_FS_OTG_FS_GINTMSK_RSTDETM_Msk = 0x800000
	// Bit RSTDETM.
	USB_OTG_FS_OTG_FS_GINTMSK_RSTDETM = 0x800000
	// Position of LPMIN field.
	USB_OTG_FS_OTG_FS_GINTMSK_LPMIN_Pos = 0x1b
	// Bit mask of LPMIN field.
	USB_OTG_FS_OTG_FS_GINTMSK_LPMIN_Msk = 0x8000000
	// Bit LPMIN.
	USB_OTG_FS_OTG_FS_GINTMSK_LPMIN = 0x8000000

	// OTG_FS_GRXSTSR_Device: OTG_FS Receive status debug read(Device mode)
	// Position of EPNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_EPNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_PKTSTS_Msk = 0x1e0000
	// Position of FRMNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Device_FRMNUM_Msk = 0x1e00000

	// OTG_FS_GRXSTSR_Host: OTG_FS Receive status debug read(Host mode)
	// Position of CHNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_CHNUM_Pos = 0x0
	// Bit mask of CHNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_CHNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSR_Host_PKTSTS_Msk = 0x1e0000

	// OTG_FS_GRXSTSP_Device: OTG status read and pop register (Device mode)
	// Position of EPNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_EPNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_PKTSTS_Msk = 0x1e0000
	// Position of FRMNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Device_FRMNUM_Msk = 0x1e00000

	// OTG_FS_GRXSTSP_Host: OTG status read and pop register (Host mode)
	// Position of CHNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_CHNUM_Pos = 0x0
	// Bit mask of CHNUM field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_CHNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_FS_OTG_FS_GRXSTSP_Host_PKTSTS_Msk = 0x1e0000

	// OTG_FS_GRXFSIZ: OTG_FS Receive FIFO size register (OTG_FS_GRXFSIZ)
	// Position of RXFD field.
	USB_OTG_FS_OTG_FS_GRXFSIZ_RXFD_Pos = 0x0
	// Bit mask of RXFD field.
	USB_OTG_FS_OTG_FS_GRXFSIZ_RXFD_Msk = 0xffff

	// OTG_FS_DIEPTXF0_Device: OTG_FS Endpoint 0 Transmit FIFO size
	// Position of TX0FSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF0_Device_TX0FSA_Pos = 0x0
	// Bit mask of TX0FSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF0_Device_TX0FSA_Msk = 0xffff
	// Position of TX0FD field.
	USB_OTG_FS_OTG_FS_DIEPTXF0_Device_TX0FD_Pos = 0x10
	// Bit mask of TX0FD field.
	USB_OTG_FS_OTG_FS_DIEPTXF0_Device_TX0FD_Msk = 0xffff0000

	// OTG_FS_HNPTXFSIZ_Host: OTG_FS Host non-periodic transmit FIFO size register
	// Position of NPTXFSA field.
	USB_OTG_FS_OTG_FS_HNPTXFSIZ_Host_NPTXFSA_Pos = 0x0
	// Bit mask of NPTXFSA field.
	USB_OTG_FS_OTG_FS_HNPTXFSIZ_Host_NPTXFSA_Msk = 0xffff
	// Position of NPTXFD field.
	USB_OTG_FS_OTG_FS_HNPTXFSIZ_Host_NPTXFD_Pos = 0x10
	// Bit mask of NPTXFD field.
	USB_OTG_FS_OTG_FS_HNPTXFSIZ_Host_NPTXFD_Msk = 0xffff0000

	// OTG_FS_HNPTXSTS: OTG_FS non-periodic transmit FIFO/queue status register (OTG_FS_GNPTXSTS)
	// Position of NPTXFSAV field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTXFSAV_Pos = 0x0
	// Bit mask of NPTXFSAV field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTXFSAV_Msk = 0xffff
	// Position of NPTQXSAV field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTQXSAV_Pos = 0x10
	// Bit mask of NPTQXSAV field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTQXSAV_Msk = 0xff0000
	// Position of NPTXQTOP field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTXQTOP_Pos = 0x18
	// Bit mask of NPTXQTOP field.
	USB_OTG_FS_OTG_FS_HNPTXSTS_NPTXQTOP_Msk = 0x7f000000

	// OTG_FS_GI2CCTL: OTG I2C access register
	// Position of RWDATA field.
	USB_OTG_FS_OTG_FS_GI2CCTL_RWDATA_Pos = 0x0
	// Bit mask of RWDATA field.
	USB_OTG_FS_OTG_FS_GI2CCTL_RWDATA_Msk = 0xff
	// Position of REGADDR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_REGADDR_Pos = 0x8
	// Bit mask of REGADDR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_REGADDR_Msk = 0xff00
	// Position of ADDR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_ADDR_Pos = 0x10
	// Bit mask of ADDR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_ADDR_Msk = 0x7f0000
	// Position of I2CEN field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CEN_Pos = 0x17
	// Bit mask of I2CEN field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CEN_Msk = 0x800000
	// Bit I2CEN.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CEN = 0x800000
	// Position of ACK field.
	USB_OTG_FS_OTG_FS_GI2CCTL_ACK_Pos = 0x18
	// Bit mask of ACK field.
	USB_OTG_FS_OTG_FS_GI2CCTL_ACK_Msk = 0x1000000
	// Bit ACK.
	USB_OTG_FS_OTG_FS_GI2CCTL_ACK = 0x1000000
	// Position of I2CDEVADR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDEVADR_Pos = 0x1a
	// Bit mask of I2CDEVADR field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDEVADR_Msk = 0xc000000
	// Position of I2CDATSE0 field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDATSE0_Pos = 0x1c
	// Bit mask of I2CDATSE0 field.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDATSE0_Msk = 0x10000000
	// Bit I2CDATSE0.
	USB_OTG_FS_OTG_FS_GI2CCTL_I2CDATSE0 = 0x10000000
	// Position of RW field.
	USB_OTG_FS_OTG_FS_GI2CCTL_RW_Pos = 0x1e
	// Bit mask of RW field.
	USB_OTG_FS_OTG_FS_GI2CCTL_RW_Msk = 0x40000000
	// Bit RW.
	USB_OTG_FS_OTG_FS_GI2CCTL_RW = 0x40000000
	// Position of BSYDNE field.
	USB_OTG_FS_OTG_FS_GI2CCTL_BSYDNE_Pos = 0x1f
	// Bit mask of BSYDNE field.
	USB_OTG_FS_OTG_FS_GI2CCTL_BSYDNE_Msk = 0x80000000
	// Bit BSYDNE.
	USB_OTG_FS_OTG_FS_GI2CCTL_BSYDNE = 0x80000000

	// OTG_FS_GCCFG: OTG_FS general core configuration register (OTG_FS_GCCFG)
	// Position of PWRDWN field.
	USB_OTG_FS_OTG_FS_GCCFG_PWRDWN_Pos = 0x10
	// Bit mask of PWRDWN field.
	USB_OTG_FS_OTG_FS_GCCFG_PWRDWN_Msk = 0x10000
	// Bit PWRDWN.
	USB_OTG_FS_OTG_FS_GCCFG_PWRDWN = 0x10000
	// Position of BCDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_BCDEN_Pos = 0x11
	// Bit mask of BCDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_BCDEN_Msk = 0x20000
	// Bit BCDEN.
	USB_OTG_FS_OTG_FS_GCCFG_BCDEN = 0x20000
	// Position of DCDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_DCDEN_Pos = 0x12
	// Bit mask of DCDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_DCDEN_Msk = 0x40000
	// Bit DCDEN.
	USB_OTG_FS_OTG_FS_GCCFG_DCDEN = 0x40000
	// Position of PDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_PDEN_Pos = 0x13
	// Bit mask of PDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_PDEN_Msk = 0x80000
	// Bit PDEN.
	USB_OTG_FS_OTG_FS_GCCFG_PDEN = 0x80000
	// Position of SDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_SDEN_Pos = 0x14
	// Bit mask of SDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_SDEN_Msk = 0x100000
	// Bit SDEN.
	USB_OTG_FS_OTG_FS_GCCFG_SDEN = 0x100000
	// Position of VBDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_VBDEN_Pos = 0x15
	// Bit mask of VBDEN field.
	USB_OTG_FS_OTG_FS_GCCFG_VBDEN_Msk = 0x200000
	// Bit VBDEN.
	USB_OTG_FS_OTG_FS_GCCFG_VBDEN = 0x200000
	// Position of DCDET field.
	USB_OTG_FS_OTG_FS_GCCFG_DCDET_Pos = 0x0
	// Bit mask of DCDET field.
	USB_OTG_FS_OTG_FS_GCCFG_DCDET_Msk = 0x1
	// Bit DCDET.
	USB_OTG_FS_OTG_FS_GCCFG_DCDET = 0x1
	// Position of PDET field.
	USB_OTG_FS_OTG_FS_GCCFG_PDET_Pos = 0x1
	// Bit mask of PDET field.
	USB_OTG_FS_OTG_FS_GCCFG_PDET_Msk = 0x2
	// Bit PDET.
	USB_OTG_FS_OTG_FS_GCCFG_PDET = 0x2
	// Position of SDET field.
	USB_OTG_FS_OTG_FS_GCCFG_SDET_Pos = 0x2
	// Bit mask of SDET field.
	USB_OTG_FS_OTG_FS_GCCFG_SDET_Msk = 0x4
	// Bit SDET.
	USB_OTG_FS_OTG_FS_GCCFG_SDET = 0x4
	// Position of PS2DET field.
	USB_OTG_FS_OTG_FS_GCCFG_PS2DET_Pos = 0x3
	// Bit mask of PS2DET field.
	USB_OTG_FS_OTG_FS_GCCFG_PS2DET_Msk = 0x8
	// Bit PS2DET.
	USB_OTG_FS_OTG_FS_GCCFG_PS2DET = 0x8

	// OTG_FS_CID: core ID register
	// Position of PRODUCT_ID field.
	USB_OTG_FS_OTG_FS_CID_PRODUCT_ID_Pos = 0x0
	// Bit mask of PRODUCT_ID field.
	USB_OTG_FS_OTG_FS_CID_PRODUCT_ID_Msk = 0xffffffff

	// OTG_FS_GLPMCFG: OTG core LPM configuration register
	// Position of LPMEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMEN_Pos = 0x0
	// Bit mask of LPMEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMEN_Msk = 0x1
	// Bit LPMEN.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMEN = 0x1
	// Position of LPMACK field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMACK_Pos = 0x1
	// Bit mask of LPMACK field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMACK_Msk = 0x2
	// Bit LPMACK.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMACK = 0x2
	// Position of BESL field.
	USB_OTG_FS_OTG_FS_GLPMCFG_BESL_Pos = 0x2
	// Bit mask of BESL field.
	USB_OTG_FS_OTG_FS_GLPMCFG_BESL_Msk = 0x3c
	// Position of REMWAKE field.
	USB_OTG_FS_OTG_FS_GLPMCFG_REMWAKE_Pos = 0x6
	// Bit mask of REMWAKE field.
	USB_OTG_FS_OTG_FS_GLPMCFG_REMWAKE_Msk = 0x40
	// Bit REMWAKE.
	USB_OTG_FS_OTG_FS_GLPMCFG_REMWAKE = 0x40
	// Position of L1SSEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1SSEN_Pos = 0x7
	// Bit mask of L1SSEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1SSEN_Msk = 0x80
	// Bit L1SSEN.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1SSEN = 0x80
	// Position of BESLTHRS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_BESLTHRS_Pos = 0x8
	// Bit mask of BESLTHRS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_BESLTHRS_Msk = 0xf00
	// Position of L1DSEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1DSEN_Pos = 0xc
	// Bit mask of L1DSEN field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1DSEN_Msk = 0x1000
	// Bit L1DSEN.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1DSEN = 0x1000
	// Position of LPMRST field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRST_Pos = 0xd
	// Bit mask of LPMRST field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRST_Msk = 0x6000
	// Position of SLPSTS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SLPSTS_Pos = 0xf
	// Bit mask of SLPSTS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SLPSTS_Msk = 0x8000
	// Bit SLPSTS.
	USB_OTG_FS_OTG_FS_GLPMCFG_SLPSTS = 0x8000
	// Position of L1RSMOK field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1RSMOK_Pos = 0x10
	// Bit mask of L1RSMOK field.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1RSMOK_Msk = 0x10000
	// Bit L1RSMOK.
	USB_OTG_FS_OTG_FS_GLPMCFG_L1RSMOK = 0x10000
	// Position of LPMCHIDX field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMCHIDX_Pos = 0x11
	// Bit mask of LPMCHIDX field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMCHIDX_Msk = 0x1e0000
	// Position of LPMRCNT field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRCNT_Pos = 0x15
	// Bit mask of LPMRCNT field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRCNT_Msk = 0xe00000
	// Position of SNDLPM field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SNDLPM_Pos = 0x18
	// Bit mask of SNDLPM field.
	USB_OTG_FS_OTG_FS_GLPMCFG_SNDLPM_Msk = 0x1000000
	// Bit SNDLPM.
	USB_OTG_FS_OTG_FS_GLPMCFG_SNDLPM = 0x1000000
	// Position of LPMRCNTSTS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRCNTSTS_Pos = 0x19
	// Bit mask of LPMRCNTSTS field.
	USB_OTG_FS_OTG_FS_GLPMCFG_LPMRCNTSTS_Msk = 0xe000000
	// Position of ENBESL field.
	USB_OTG_FS_OTG_FS_GLPMCFG_ENBESL_Pos = 0x1c
	// Bit mask of ENBESL field.
	USB_OTG_FS_OTG_FS_GLPMCFG_ENBESL_Msk = 0x10000000
	// Bit ENBESL.
	USB_OTG_FS_OTG_FS_GLPMCFG_ENBESL = 0x10000000

	// OTG_FS_GPWRDN: OTG power down register
	// Position of ADPMEN field.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPMEN_Pos = 0x0
	// Bit mask of ADPMEN field.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPMEN_Msk = 0x1
	// Bit ADPMEN.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPMEN = 0x1
	// Position of ADPIF field.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPIF_Pos = 0x17
	// Bit mask of ADPIF field.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPIF_Msk = 0x800000
	// Bit ADPIF.
	USB_OTG_FS_OTG_FS_GPWRDN_ADPIF = 0x800000

	// OTG_FS_GADPCTL: OTG ADP timer, control and status register
	// Position of PRBDSCHG field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBDSCHG_Pos = 0x0
	// Bit mask of PRBDSCHG field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBDSCHG_Msk = 0x3
	// Position of PRBDELTA field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBDELTA_Pos = 0x2
	// Bit mask of PRBDELTA field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBDELTA_Msk = 0xc
	// Position of PRBPER field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBPER_Pos = 0x4
	// Bit mask of PRBPER field.
	USB_OTG_FS_OTG_FS_GADPCTL_PRBPER_Msk = 0x30
	// Position of RTIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_RTIM_Pos = 0x6
	// Bit mask of RTIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_RTIM_Msk = 0x1ffc0
	// Position of ENAPRB field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENAPRB_Pos = 0x11
	// Bit mask of ENAPRB field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENAPRB_Msk = 0x20000
	// Bit ENAPRB.
	USB_OTG_FS_OTG_FS_GADPCTL_ENAPRB = 0x20000
	// Position of ENASNS field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENASNS_Pos = 0x12
	// Bit mask of ENASNS field.
	USB_OTG_FS_OTG_FS_GADPCTL_ENASNS_Msk = 0x40000
	// Bit ENASNS.
	USB_OTG_FS_OTG_FS_GADPCTL_ENASNS = 0x40000
	// Position of ADPRST field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPRST_Pos = 0x13
	// Bit mask of ADPRST field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPRST_Msk = 0x80000
	// Bit ADPRST.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPRST = 0x80000
	// Position of ADPEN field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPEN_Pos = 0x14
	// Bit mask of ADPEN field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPEN_Msk = 0x100000
	// Bit ADPEN.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPEN = 0x100000
	// Position of ADPPRBIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIF_Pos = 0x15
	// Bit mask of ADPPRBIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIF_Msk = 0x200000
	// Bit ADPPRBIF.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIF = 0x200000
	// Position of ADPSNSIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIF_Pos = 0x16
	// Bit mask of ADPSNSIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIF_Msk = 0x400000
	// Bit ADPSNSIF.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIF = 0x400000
	// Position of ADPTOIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIF_Pos = 0x17
	// Bit mask of ADPTOIF field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIF_Msk = 0x800000
	// Bit ADPTOIF.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIF = 0x800000
	// Position of ADPPRBIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIM_Pos = 0x18
	// Bit mask of ADPPRBIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIM_Msk = 0x1000000
	// Bit ADPPRBIM.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPPRBIM = 0x1000000
	// Position of ADPSNSIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIM_Pos = 0x19
	// Bit mask of ADPSNSIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIM_Msk = 0x2000000
	// Bit ADPSNSIM.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPSNSIM = 0x2000000
	// Position of ADPTOIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIM_Pos = 0x1a
	// Bit mask of ADPTOIM field.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIM_Msk = 0x4000000
	// Bit ADPTOIM.
	USB_OTG_FS_OTG_FS_GADPCTL_ADPTOIM = 0x4000000
	// Position of AR field.
	USB_OTG_FS_OTG_FS_GADPCTL_AR_Pos = 0x1b
	// Bit mask of AR field.
	USB_OTG_FS_OTG_FS_GADPCTL_AR_Msk = 0x18000000

	// OTG_FS_HPTXFSIZ: OTG_FS Host periodic transmit FIFO size register (OTG_FS_HPTXFSIZ)
	// Position of PTXSA field.
	USB_OTG_FS_OTG_FS_HPTXFSIZ_PTXSA_Pos = 0x0
	// Bit mask of PTXSA field.
	USB_OTG_FS_OTG_FS_HPTXFSIZ_PTXSA_Msk = 0xffff
	// Position of PTXFSIZ field.
	USB_OTG_FS_OTG_FS_HPTXFSIZ_PTXFSIZ_Pos = 0x10
	// Bit mask of PTXFSIZ field.
	USB_OTG_FS_OTG_FS_HPTXFSIZ_PTXFSIZ_Msk = 0xffff0000

	// OTG_FS_DIEPTXF1: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF1)
	// Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF1_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF1_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF1_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF1_INEPTXFD_Msk = 0xffff0000

	// OTG_FS_DIEPTXF2: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF2)
	// Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF2_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF2_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF2_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF2_INEPTXFD_Msk = 0xffff0000

	// OTG_FS_DIEPTXF3: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF3)
	// Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF3_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF3_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF3_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF3_INEPTXFD_Msk = 0xffff0000

	// OTG_FS_DIEPTXF4: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF4)
	// Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF4_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF4_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF4_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF4_INEPTXFD_Msk = 0xffff0000

	// OTG_FS_DIEPTXF5: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF5)
	// Position of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF5_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_FS_OTG_FS_DIEPTXF5_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF5_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_FS_OTG_FS_DIEPTXF5_INEPTXFD_Msk = 0xffff0000
)

// Bitfields for OTG_HS_GLOBAL: USB on the go high speed
const (
	// OTG_HS_GOTGCTL: OTG_HS control and status register
	// Position of SRQSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS_Pos = 0x0
	// Bit mask of SRQSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS_Msk = 0x1
	// Bit SRQSCS.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQSCS = 0x1
	// Position of SRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ_Pos = 0x1
	// Bit mask of SRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ_Msk = 0x2
	// Bit SRQ.
	USB_OTG_HS_OTG_HS_GOTGCTL_SRQ = 0x2
	// Position of HNGSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS_Pos = 0x8
	// Bit mask of HNGSCS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS_Msk = 0x100
	// Bit HNGSCS.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNGSCS = 0x100
	// Position of HNPRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ_Pos = 0x9
	// Bit mask of HNPRQ field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ_Msk = 0x200
	// Bit HNPRQ.
	USB_OTG_HS_OTG_HS_GOTGCTL_HNPRQ = 0x200
	// Position of HSHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN_Pos = 0xa
	// Bit mask of HSHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN_Msk = 0x400
	// Bit HSHNPEN.
	USB_OTG_HS_OTG_HS_GOTGCTL_HSHNPEN = 0x400
	// Position of DHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN_Pos = 0xb
	// Bit mask of DHNPEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN_Msk = 0x800
	// Bit DHNPEN.
	USB_OTG_HS_OTG_HS_GOTGCTL_DHNPEN = 0x800
	// Position of CIDSTS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS_Pos = 0x10
	// Bit mask of CIDSTS field.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS_Msk = 0x10000
	// Bit CIDSTS.
	USB_OTG_HS_OTG_HS_GOTGCTL_CIDSTS = 0x10000
	// Position of DBCT field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT_Pos = 0x11
	// Bit mask of DBCT field.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT_Msk = 0x20000
	// Bit DBCT.
	USB_OTG_HS_OTG_HS_GOTGCTL_DBCT = 0x20000
	// Position of ASVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD_Pos = 0x12
	// Bit mask of ASVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD_Msk = 0x40000
	// Bit ASVLD.
	USB_OTG_HS_OTG_HS_GOTGCTL_ASVLD = 0x40000
	// Position of BSVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD_Pos = 0x13
	// Bit mask of BSVLD field.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD_Msk = 0x80000
	// Bit BSVLD.
	USB_OTG_HS_OTG_HS_GOTGCTL_BSVLD = 0x80000
	// Position of EHEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_EHEN_Pos = 0xc
	// Bit mask of EHEN field.
	USB_OTG_HS_OTG_HS_GOTGCTL_EHEN_Msk = 0x1000
	// Bit EHEN.
	USB_OTG_HS_OTG_HS_GOTGCTL_EHEN = 0x1000

	// OTG_HS_GOTGINT: OTG_HS interrupt register
	// Position of SEDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET_Pos = 0x2
	// Bit mask of SEDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET_Msk = 0x4
	// Bit SEDET.
	USB_OTG_HS_OTG_HS_GOTGINT_SEDET = 0x4
	// Position of SRSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG_Pos = 0x8
	// Bit mask of SRSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG_Msk = 0x100
	// Bit SRSSCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_SRSSCHG = 0x100
	// Position of HNSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG_Pos = 0x9
	// Bit mask of HNSSCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG_Msk = 0x200
	// Bit HNSSCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_HNSSCHG = 0x200
	// Position of HNGDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET_Pos = 0x11
	// Bit mask of HNGDET field.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET_Msk = 0x20000
	// Bit HNGDET.
	USB_OTG_HS_OTG_HS_GOTGINT_HNGDET = 0x20000
	// Position of ADTOCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG_Pos = 0x12
	// Bit mask of ADTOCHG field.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG_Msk = 0x40000
	// Bit ADTOCHG.
	USB_OTG_HS_OTG_HS_GOTGINT_ADTOCHG = 0x40000
	// Position of DBCDNE field.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE_Pos = 0x13
	// Bit mask of DBCDNE field.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE_Msk = 0x80000
	// Bit DBCDNE.
	USB_OTG_HS_OTG_HS_GOTGINT_DBCDNE = 0x80000
	// Position of IDCHNG field.
	USB_OTG_HS_OTG_HS_GOTGINT_IDCHNG_Pos = 0x14
	// Bit mask of IDCHNG field.
	USB_OTG_HS_OTG_HS_GOTGINT_IDCHNG_Msk = 0x100000
	// Bit IDCHNG.
	USB_OTG_HS_OTG_HS_GOTGINT_IDCHNG = 0x100000

	// OTG_HS_GAHBCFG: OTG_HS AHB configuration register
	// Position of GINT field.
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT_Pos = 0x0
	// Bit mask of GINT field.
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT_Msk = 0x1
	// Bit GINT.
	USB_OTG_HS_OTG_HS_GAHBCFG_GINT = 0x1
	// Position of HBSTLEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_HBSTLEN_Pos = 0x1
	// Bit mask of HBSTLEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_HBSTLEN_Msk = 0x1e
	// Position of DMAEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN_Pos = 0x5
	// Bit mask of DMAEN field.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN_Msk = 0x20
	// Bit DMAEN.
	USB_OTG_HS_OTG_HS_GAHBCFG_DMAEN = 0x20
	// Position of TXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL_Pos = 0x7
	// Bit mask of TXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL_Msk = 0x80
	// Bit TXFELVL.
	USB_OTG_HS_OTG_HS_GAHBCFG_TXFELVL = 0x80
	// Position of PTXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL_Pos = 0x8
	// Bit mask of PTXFELVL field.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL_Msk = 0x100
	// Bit PTXFELVL.
	USB_OTG_HS_OTG_HS_GAHBCFG_PTXFELVL = 0x100

	// OTG_HS_GUSBCFG: OTG_HS USB configuration register
	// Position of TOCAL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TOCAL_Pos = 0x0
	// Bit mask of TOCAL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TOCAL_Msk = 0x7
	// Position of PHYSEL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL_Pos = 0x6
	// Bit mask of PHYSEL field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL_Msk = 0x40
	// Bit PHYSEL.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYSEL = 0x40
	// Position of SRPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP_Pos = 0x8
	// Bit mask of SRPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP_Msk = 0x100
	// Bit SRPCAP.
	USB_OTG_HS_OTG_HS_GUSBCFG_SRPCAP = 0x100
	// Position of HNPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP_Pos = 0x9
	// Bit mask of HNPCAP field.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP_Msk = 0x200
	// Bit HNPCAP.
	USB_OTG_HS_OTG_HS_GUSBCFG_HNPCAP = 0x200
	// Position of TRDT field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TRDT_Pos = 0xa
	// Bit mask of TRDT field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TRDT_Msk = 0x3c00
	// Position of PHYLPCS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS_Pos = 0xf
	// Bit mask of PHYLPCS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS_Msk = 0x8000
	// Bit PHYLPCS.
	USB_OTG_HS_OTG_HS_GUSBCFG_PHYLPCS = 0x8000
	// Position of ULPIFSLS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS_Pos = 0x11
	// Bit mask of ULPIFSLS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS_Msk = 0x20000
	// Bit ULPIFSLS.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIFSLS = 0x20000
	// Position of ULPIAR field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR_Pos = 0x12
	// Bit mask of ULPIAR field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR_Msk = 0x40000
	// Bit ULPIAR.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIAR = 0x40000
	// Position of ULPICSM field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM_Pos = 0x13
	// Bit mask of ULPICSM field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM_Msk = 0x80000
	// Bit ULPICSM.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPICSM = 0x80000
	// Position of ULPIEVBUSD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD_Pos = 0x14
	// Bit mask of ULPIEVBUSD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD_Msk = 0x100000
	// Bit ULPIEVBUSD.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSD = 0x100000
	// Position of ULPIEVBUSI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI_Pos = 0x15
	// Bit mask of ULPIEVBUSI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI_Msk = 0x200000
	// Bit ULPIEVBUSI.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIEVBUSI = 0x200000
	// Position of TSDPS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS_Pos = 0x16
	// Bit mask of TSDPS field.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS_Msk = 0x400000
	// Bit TSDPS.
	USB_OTG_HS_OTG_HS_GUSBCFG_TSDPS = 0x400000
	// Position of PCCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI_Pos = 0x17
	// Bit mask of PCCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI_Msk = 0x800000
	// Bit PCCI.
	USB_OTG_HS_OTG_HS_GUSBCFG_PCCI = 0x800000
	// Position of PTCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI_Pos = 0x18
	// Bit mask of PTCI field.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI_Msk = 0x1000000
	// Bit PTCI.
	USB_OTG_HS_OTG_HS_GUSBCFG_PTCI = 0x1000000
	// Position of ULPIIPD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD_Pos = 0x19
	// Bit mask of ULPIIPD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD_Msk = 0x2000000
	// Bit ULPIIPD.
	USB_OTG_HS_OTG_HS_GUSBCFG_ULPIIPD = 0x2000000
	// Position of FHMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD_Pos = 0x1d
	// Bit mask of FHMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD_Msk = 0x20000000
	// Bit FHMOD.
	USB_OTG_HS_OTG_HS_GUSBCFG_FHMOD = 0x20000000
	// Position of FDMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD_Pos = 0x1e
	// Bit mask of FDMOD field.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD_Msk = 0x40000000
	// Bit FDMOD.
	USB_OTG_HS_OTG_HS_GUSBCFG_FDMOD = 0x40000000

	// OTG_HS_GRSTCTL: OTG_HS reset register
	// Position of CSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST_Pos = 0x0
	// Bit mask of CSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST_Msk = 0x1
	// Bit CSRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_CSRST = 0x1
	// Position of HSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST_Pos = 0x1
	// Bit mask of HSRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST_Msk = 0x2
	// Bit HSRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_HSRST = 0x2
	// Position of FCRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST_Pos = 0x2
	// Bit mask of FCRST field.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST_Msk = 0x4
	// Bit FCRST.
	USB_OTG_HS_OTG_HS_GRSTCTL_FCRST = 0x4
	// Position of RXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH_Pos = 0x4
	// Bit mask of RXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH_Msk = 0x10
	// Bit RXFFLSH.
	USB_OTG_HS_OTG_HS_GRSTCTL_RXFFLSH = 0x10
	// Position of TXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH_Pos = 0x5
	// Bit mask of TXFFLSH field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH_Msk = 0x20
	// Bit TXFFLSH.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFFLSH = 0x20
	// Position of TXFNUM field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFNUM_Pos = 0x6
	// Bit mask of TXFNUM field.
	USB_OTG_HS_OTG_HS_GRSTCTL_TXFNUM_Msk = 0x7c0
	// Position of AHBIDL field.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL_Pos = 0x1f
	// Bit mask of AHBIDL field.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL_Msk = 0x80000000
	// Bit AHBIDL.
	USB_OTG_HS_OTG_HS_GRSTCTL_AHBIDL = 0x80000000
	// Position of DMAREQ field.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ_Pos = 0x1e
	// Bit mask of DMAREQ field.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ_Msk = 0x40000000
	// Bit DMAREQ.
	USB_OTG_HS_OTG_HS_GRSTCTL_DMAREQ = 0x40000000

	// OTG_HS_GINTSTS: OTG_HS core interrupt register
	// Position of CMOD field.
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD_Msk = 0x1
	// Bit CMOD.
	USB_OTG_HS_OTG_HS_GINTSTS_CMOD = 0x1
	// Position of MMIS field.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS_Pos = 0x1
	// Bit mask of MMIS field.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS_Msk = 0x2
	// Bit MMIS.
	USB_OTG_HS_OTG_HS_GINTSTS_MMIS = 0x2
	// Position of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT_Pos = 0x2
	// Bit mask of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT_Msk = 0x4
	// Bit OTGINT.
	USB_OTG_HS_OTG_HS_GINTSTS_OTGINT = 0x4
	// Position of SOF field.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF_Pos = 0x3
	// Bit mask of SOF field.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF_Msk = 0x8
	// Bit SOF.
	USB_OTG_HS_OTG_HS_GINTSTS_SOF = 0x8
	// Position of RXFLVL field.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL_Pos = 0x4
	// Bit mask of RXFLVL field.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL_Msk = 0x10
	// Bit RXFLVL.
	USB_OTG_HS_OTG_HS_GINTSTS_RXFLVL = 0x10
	// Position of NPTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE_Pos = 0x5
	// Bit mask of NPTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE_Msk = 0x20
	// Bit NPTXFE.
	USB_OTG_HS_OTG_HS_GINTSTS_NPTXFE = 0x20
	// Position of GINAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF_Pos = 0x6
	// Bit mask of GINAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF_Msk = 0x40
	// Bit GINAKEFF.
	USB_OTG_HS_OTG_HS_GINTSTS_GINAKEFF = 0x40
	// Position of BOUTNAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF_Pos = 0x7
	// Bit mask of BOUTNAKEFF field.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF_Msk = 0x80
	// Bit BOUTNAKEFF.
	USB_OTG_HS_OTG_HS_GINTSTS_BOUTNAKEFF = 0x80
	// Position of ESUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP_Pos = 0xa
	// Bit mask of ESUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP_Msk = 0x400
	// Bit ESUSP.
	USB_OTG_HS_OTG_HS_GINTSTS_ESUSP = 0x400
	// Position of USBSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP_Pos = 0xb
	// Bit mask of USBSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP_Msk = 0x800
	// Bit USBSUSP.
	USB_OTG_HS_OTG_HS_GINTSTS_USBSUSP = 0x800
	// Position of USBRST field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST_Pos = 0xc
	// Bit mask of USBRST field.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST_Msk = 0x1000
	// Bit USBRST.
	USB_OTG_HS_OTG_HS_GINTSTS_USBRST = 0x1000
	// Position of ENUMDNE field.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE_Pos = 0xd
	// Bit mask of ENUMDNE field.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE_Msk = 0x2000
	// Bit ENUMDNE.
	USB_OTG_HS_OTG_HS_GINTSTS_ENUMDNE = 0x2000
	// Position of ISOODRP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP_Pos = 0xe
	// Bit mask of ISOODRP field.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP_Msk = 0x4000
	// Bit ISOODRP.
	USB_OTG_HS_OTG_HS_GINTSTS_ISOODRP = 0x4000
	// Position of EOPF field.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF_Pos = 0xf
	// Bit mask of EOPF field.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF_Msk = 0x8000
	// Bit EOPF.
	USB_OTG_HS_OTG_HS_GINTSTS_EOPF = 0x8000
	// Position of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT_Pos = 0x12
	// Bit mask of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT_Msk = 0x40000
	// Bit IEPINT.
	USB_OTG_HS_OTG_HS_GINTSTS_IEPINT = 0x40000
	// Position of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT_Pos = 0x13
	// Bit mask of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT_Msk = 0x80000
	// Bit OEPINT.
	USB_OTG_HS_OTG_HS_GINTSTS_OEPINT = 0x80000
	// Position of IISOIXFR field.
	USB_OTG_HS_OTG_HS_GINTSTS_IISOIXFR_Pos = 0x14
	// Bit mask of IISOIXFR field.
	USB_OTG_HS_OTG_HS_GINTSTS_IISOIXFR_Msk = 0x100000
	// Bit IISOIXFR.
	USB_OTG_HS_OTG_HS_GINTSTS_IISOIXFR = 0x100000
	// Position of PXFR_INCOMPISOOUT field.
	USB_OTG_HS_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT_Pos = 0x15
	// Bit mask of PXFR_INCOMPISOOUT field.
	USB_OTG_HS_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT_Msk = 0x200000
	// Bit PXFR_INCOMPISOOUT.
	USB_OTG_HS_OTG_HS_GINTSTS_PXFR_INCOMPISOOUT = 0x200000
	// Position of DATAFSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_DATAFSUSP_Pos = 0x16
	// Bit mask of DATAFSUSP field.
	USB_OTG_HS_OTG_HS_GINTSTS_DATAFSUSP_Msk = 0x400000
	// Bit DATAFSUSP.
	USB_OTG_HS_OTG_HS_GINTSTS_DATAFSUSP = 0x400000
	// Position of HPRTINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_HPRTINT_Pos = 0x18
	// Bit mask of HPRTINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_HPRTINT_Msk = 0x1000000
	// Bit HPRTINT.
	USB_OTG_HS_OTG_HS_GINTSTS_HPRTINT = 0x1000000
	// Position of HCINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_HCINT_Pos = 0x19
	// Bit mask of HCINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_HCINT_Msk = 0x2000000
	// Bit HCINT.
	USB_OTG_HS_OTG_HS_GINTSTS_HCINT = 0x2000000
	// Position of PTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_PTXFE_Pos = 0x1a
	// Bit mask of PTXFE field.
	USB_OTG_HS_OTG_HS_GINTSTS_PTXFE_Msk = 0x4000000
	// Bit PTXFE.
	USB_OTG_HS_OTG_HS_GINTSTS_PTXFE = 0x4000000
	// Position of CIDSCHG field.
	USB_OTG_HS_OTG_HS_GINTSTS_CIDSCHG_Pos = 0x1c
	// Bit mask of CIDSCHG field.
	USB_OTG_HS_OTG_HS_GINTSTS_CIDSCHG_Msk = 0x10000000
	// Bit CIDSCHG.
	USB_OTG_HS_OTG_HS_GINTSTS_CIDSCHG = 0x10000000
	// Position of DISCINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_DISCINT_Pos = 0x1d
	// Bit mask of DISCINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_DISCINT_Msk = 0x20000000
	// Bit DISCINT.
	USB_OTG_HS_OTG_HS_GINTSTS_DISCINT = 0x20000000
	// Position of SRQINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_SRQINT_Pos = 0x1e
	// Bit mask of SRQINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_SRQINT_Msk = 0x40000000
	// Bit SRQINT.
	USB_OTG_HS_OTG_HS_GINTSTS_SRQINT = 0x40000000
	// Position of WKUINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_WKUINT_Pos = 0x1f
	// Bit mask of WKUINT field.
	USB_OTG_HS_OTG_HS_GINTSTS_WKUINT_Msk = 0x80000000
	// Bit WKUINT.
	USB_OTG_HS_OTG_HS_GINTSTS_WKUINT = 0x80000000

	// OTG_HS_GINTMSK: OTG_HS interrupt mask register
	// Position of MMISM field.
	USB_OTG_HS_OTG_HS_GINTMSK_MMISM_Pos = 0x1
	// Bit mask of MMISM field.
	USB_OTG_HS_OTG_HS_GINTMSK_MMISM_Msk = 0x2
	// Bit MMISM.
	USB_OTG_HS_OTG_HS_GINTMSK_MMISM = 0x2
	// Position of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_OTGINT_Pos = 0x2
	// Bit mask of OTGINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_OTGINT_Msk = 0x4
	// Bit OTGINT.
	USB_OTG_HS_OTG_HS_GINTMSK_OTGINT = 0x4
	// Position of SOFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_SOFM_Pos = 0x3
	// Bit mask of SOFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_SOFM_Msk = 0x8
	// Bit SOFM.
	USB_OTG_HS_OTG_HS_GINTMSK_SOFM = 0x8
	// Position of RXFLVLM field.
	USB_OTG_HS_OTG_HS_GINTMSK_RXFLVLM_Pos = 0x4
	// Bit mask of RXFLVLM field.
	USB_OTG_HS_OTG_HS_GINTMSK_RXFLVLM_Msk = 0x10
	// Bit RXFLVLM.
	USB_OTG_HS_OTG_HS_GINTMSK_RXFLVLM = 0x10
	// Position of NPTXFEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_NPTXFEM_Pos = 0x5
	// Bit mask of NPTXFEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_NPTXFEM_Msk = 0x20
	// Bit NPTXFEM.
	USB_OTG_HS_OTG_HS_GINTMSK_NPTXFEM = 0x20
	// Position of GINAKEFFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_GINAKEFFM_Pos = 0x6
	// Bit mask of GINAKEFFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_GINAKEFFM_Msk = 0x40
	// Bit GINAKEFFM.
	USB_OTG_HS_OTG_HS_GINTMSK_GINAKEFFM = 0x40
	// Position of GONAKEFFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_GONAKEFFM_Pos = 0x7
	// Bit mask of GONAKEFFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_GONAKEFFM_Msk = 0x80
	// Bit GONAKEFFM.
	USB_OTG_HS_OTG_HS_GINTMSK_GONAKEFFM = 0x80
	// Position of ESUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ESUSPM_Pos = 0xa
	// Bit mask of ESUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ESUSPM_Msk = 0x400
	// Bit ESUSPM.
	USB_OTG_HS_OTG_HS_GINTMSK_ESUSPM = 0x400
	// Position of USBSUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_USBSUSPM_Pos = 0xb
	// Bit mask of USBSUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_USBSUSPM_Msk = 0x800
	// Bit USBSUSPM.
	USB_OTG_HS_OTG_HS_GINTMSK_USBSUSPM = 0x800
	// Position of USBRST field.
	USB_OTG_HS_OTG_HS_GINTMSK_USBRST_Pos = 0xc
	// Bit mask of USBRST field.
	USB_OTG_HS_OTG_HS_GINTMSK_USBRST_Msk = 0x1000
	// Bit USBRST.
	USB_OTG_HS_OTG_HS_GINTMSK_USBRST = 0x1000
	// Position of ENUMDNEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ENUMDNEM_Pos = 0xd
	// Bit mask of ENUMDNEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ENUMDNEM_Msk = 0x2000
	// Bit ENUMDNEM.
	USB_OTG_HS_OTG_HS_GINTMSK_ENUMDNEM = 0x2000
	// Position of ISOODRPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ISOODRPM_Pos = 0xe
	// Bit mask of ISOODRPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_ISOODRPM_Msk = 0x4000
	// Bit ISOODRPM.
	USB_OTG_HS_OTG_HS_GINTMSK_ISOODRPM = 0x4000
	// Position of EOPFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_EOPFM_Pos = 0xf
	// Bit mask of EOPFM field.
	USB_OTG_HS_OTG_HS_GINTMSK_EOPFM_Msk = 0x8000
	// Bit EOPFM.
	USB_OTG_HS_OTG_HS_GINTMSK_EOPFM = 0x8000
	// Position of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_IEPINT_Pos = 0x12
	// Bit mask of IEPINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_IEPINT_Msk = 0x40000
	// Bit IEPINT.
	USB_OTG_HS_OTG_HS_GINTMSK_IEPINT = 0x40000
	// Position of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_OEPINT_Pos = 0x13
	// Bit mask of OEPINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_OEPINT_Msk = 0x80000
	// Bit OEPINT.
	USB_OTG_HS_OTG_HS_GINTMSK_OEPINT = 0x80000
	// Position of IISOIXFRM field.
	USB_OTG_HS_OTG_HS_GINTMSK_IISOIXFRM_Pos = 0x14
	// Bit mask of IISOIXFRM field.
	USB_OTG_HS_OTG_HS_GINTMSK_IISOIXFRM_Msk = 0x100000
	// Bit IISOIXFRM.
	USB_OTG_HS_OTG_HS_GINTMSK_IISOIXFRM = 0x100000
	// Position of PXFRM_IISOOXFRM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PXFRM_IISOOXFRM_Pos = 0x15
	// Bit mask of PXFRM_IISOOXFRM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PXFRM_IISOOXFRM_Msk = 0x200000
	// Bit PXFRM_IISOOXFRM.
	USB_OTG_HS_OTG_HS_GINTMSK_PXFRM_IISOOXFRM = 0x200000
	// Position of FSUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_FSUSPM_Pos = 0x16
	// Bit mask of FSUSPM field.
	USB_OTG_HS_OTG_HS_GINTMSK_FSUSPM_Msk = 0x400000
	// Bit FSUSPM.
	USB_OTG_HS_OTG_HS_GINTMSK_FSUSPM = 0x400000
	// Position of PRTIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PRTIM_Pos = 0x18
	// Bit mask of PRTIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PRTIM_Msk = 0x1000000
	// Bit PRTIM.
	USB_OTG_HS_OTG_HS_GINTMSK_PRTIM = 0x1000000
	// Position of HCIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_HCIM_Pos = 0x19
	// Bit mask of HCIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_HCIM_Msk = 0x2000000
	// Bit HCIM.
	USB_OTG_HS_OTG_HS_GINTMSK_HCIM = 0x2000000
	// Position of PTXFEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PTXFEM_Pos = 0x1a
	// Bit mask of PTXFEM field.
	USB_OTG_HS_OTG_HS_GINTMSK_PTXFEM_Msk = 0x4000000
	// Bit PTXFEM.
	USB_OTG_HS_OTG_HS_GINTMSK_PTXFEM = 0x4000000
	// Position of CIDSCHGM field.
	USB_OTG_HS_OTG_HS_GINTMSK_CIDSCHGM_Pos = 0x1c
	// Bit mask of CIDSCHGM field.
	USB_OTG_HS_OTG_HS_GINTMSK_CIDSCHGM_Msk = 0x10000000
	// Bit CIDSCHGM.
	USB_OTG_HS_OTG_HS_GINTMSK_CIDSCHGM = 0x10000000
	// Position of DISCINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_DISCINT_Pos = 0x1d
	// Bit mask of DISCINT field.
	USB_OTG_HS_OTG_HS_GINTMSK_DISCINT_Msk = 0x20000000
	// Bit DISCINT.
	USB_OTG_HS_OTG_HS_GINTMSK_DISCINT = 0x20000000
	// Position of SRQIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_SRQIM_Pos = 0x1e
	// Bit mask of SRQIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_SRQIM_Msk = 0x40000000
	// Bit SRQIM.
	USB_OTG_HS_OTG_HS_GINTMSK_SRQIM = 0x40000000
	// Position of WUIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_WUIM_Pos = 0x1f
	// Bit mask of WUIM field.
	USB_OTG_HS_OTG_HS_GINTMSK_WUIM_Msk = 0x80000000
	// Bit WUIM.
	USB_OTG_HS_OTG_HS_GINTMSK_WUIM = 0x80000000
	// Position of RSTDE field.
	USB_OTG_HS_OTG_HS_GINTMSK_RSTDE_Pos = 0x17
	// Bit mask of RSTDE field.
	USB_OTG_HS_OTG_HS_GINTMSK_RSTDE_Msk = 0x800000
	// Bit RSTDE.
	USB_OTG_HS_OTG_HS_GINTMSK_RSTDE = 0x800000
	// Position of LPMINTM field.
	USB_OTG_HS_OTG_HS_GINTMSK_LPMINTM_Pos = 0x1b
	// Bit mask of LPMINTM field.
	USB_OTG_HS_OTG_HS_GINTMSK_LPMINTM_Msk = 0x8000000
	// Bit LPMINTM.
	USB_OTG_HS_OTG_HS_GINTMSK_LPMINTM = 0x8000000

	// OTG_HS_GRXSTSR_Host: OTG_HS Receive status debug read register (host mode)
	// Position of CHNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_CHNUM_Pos = 0x0
	// Bit mask of CHNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_CHNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Host_PKTSTS_Msk = 0x1e0000

	// OTG_HS_GRXSTSR_Device: OTG_HS Receive status debug read register (peripheral mode mode)
	// Position of EPNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_EPNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_PKTSTS_Msk = 0x1e0000
	// Position of FRMNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSR_Device_FRMNUM_Msk = 0x1e00000

	// OTG_HS_GRXSTSP_Host: OTG_HS status read and pop register (host mode)
	// Position of CHNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_CHNUM_Pos = 0x0
	// Bit mask of CHNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_CHNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Host_PKTSTS_Msk = 0x1e0000

	// OTG_HS_GRXSTSP_Device: OTG_HS status read and pop register (peripheral mode)
	// Position of EPNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_EPNUM_Pos = 0x0
	// Bit mask of EPNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_EPNUM_Msk = 0xf
	// Position of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_BCNT_Pos = 0x4
	// Bit mask of BCNT field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_BCNT_Msk = 0x7ff0
	// Position of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_DPID_Pos = 0xf
	// Bit mask of DPID field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_DPID_Msk = 0x18000
	// Position of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_PKTSTS_Pos = 0x11
	// Bit mask of PKTSTS field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_PKTSTS_Msk = 0x1e0000
	// Position of FRMNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_FRMNUM_Pos = 0x15
	// Bit mask of FRMNUM field.
	USB_OTG_HS_OTG_HS_GRXSTSP_Device_FRMNUM_Msk = 0x1e00000

	// OTG_HS_GRXFSIZ: OTG_HS Receive FIFO size register
	// Position of RXFD field.
	USB_OTG_HS_OTG_HS_GRXFSIZ_RXFD_Pos = 0x0
	// Bit mask of RXFD field.
	USB_OTG_HS_OTG_HS_GRXFSIZ_RXFD_Msk = 0xffff

	// OTG_HS_HNPTXFSIZ_Host: OTG_HS nonperiodic transmit FIFO size register (host mode)
	// Position of NPTXFSA field.
	USB_OTG_HS_OTG_HS_HNPTXFSIZ_Host_NPTXFSA_Pos = 0x0
	// Bit mask of NPTXFSA field.
	USB_OTG_HS_OTG_HS_HNPTXFSIZ_Host_NPTXFSA_Msk = 0xffff
	// Position of NPTXFD field.
	USB_OTG_HS_OTG_HS_HNPTXFSIZ_Host_NPTXFD_Pos = 0x10
	// Bit mask of NPTXFD field.
	USB_OTG_HS_OTG_HS_HNPTXFSIZ_Host_NPTXFD_Msk = 0xffff0000

	// OTG_HS_DIEPTXF0_Device: Endpoint 0 transmit FIFO size (peripheral mode)
	// Position of TX0FSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF0_Device_TX0FSA_Pos = 0x0
	// Bit mask of TX0FSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF0_Device_TX0FSA_Msk = 0xffff
	// Position of TX0FD field.
	USB_OTG_HS_OTG_HS_DIEPTXF0_Device_TX0FD_Pos = 0x10
	// Bit mask of TX0FD field.
	USB_OTG_HS_OTG_HS_DIEPTXF0_Device_TX0FD_Msk = 0xffff0000

	// OTG_HS_GNPTXSTS: OTG_HS nonperiodic transmit FIFO/queue status register
	// Position of NPTXFSAV field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTXFSAV_Pos = 0x0
	// Bit mask of NPTXFSAV field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTXFSAV_Msk = 0xffff
	// Position of NPTQXSAV field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTQXSAV_Pos = 0x10
	// Bit mask of NPTQXSAV field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTQXSAV_Msk = 0xff0000
	// Position of NPTXQTOP field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTXQTOP_Pos = 0x18
	// Bit mask of NPTXQTOP field.
	USB_OTG_HS_OTG_HS_GNPTXSTS_NPTXQTOP_Msk = 0x7f000000

	// OTG_HS_GCCFG: OTG_HS general core configuration register
	// Position of PWRDWN field.
	USB_OTG_HS_OTG_HS_GCCFG_PWRDWN_Pos = 0x10
	// Bit mask of PWRDWN field.
	USB_OTG_HS_OTG_HS_GCCFG_PWRDWN_Msk = 0x10000
	// Bit PWRDWN.
	USB_OTG_HS_OTG_HS_GCCFG_PWRDWN = 0x10000
	// Position of BCDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_BCDEN_Pos = 0x11
	// Bit mask of BCDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_BCDEN_Msk = 0x20000
	// Bit BCDEN.
	USB_OTG_HS_OTG_HS_GCCFG_BCDEN = 0x20000
	// Position of DCDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_DCDEN_Pos = 0x12
	// Bit mask of DCDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_DCDEN_Msk = 0x40000
	// Bit DCDEN.
	USB_OTG_HS_OTG_HS_GCCFG_DCDEN = 0x40000
	// Position of PDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_PDEN_Pos = 0x13
	// Bit mask of PDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_PDEN_Msk = 0x80000
	// Bit PDEN.
	USB_OTG_HS_OTG_HS_GCCFG_PDEN = 0x80000
	// Position of SDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_SDEN_Pos = 0x14
	// Bit mask of SDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_SDEN_Msk = 0x100000
	// Bit SDEN.
	USB_OTG_HS_OTG_HS_GCCFG_SDEN = 0x100000
	// Position of VBDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_VBDEN_Pos = 0x15
	// Bit mask of VBDEN field.
	USB_OTG_HS_OTG_HS_GCCFG_VBDEN_Msk = 0x200000
	// Bit VBDEN.
	USB_OTG_HS_OTG_HS_GCCFG_VBDEN = 0x200000
	// Position of DCDET field.
	USB_OTG_HS_OTG_HS_GCCFG_DCDET_Pos = 0x0
	// Bit mask of DCDET field.
	USB_OTG_HS_OTG_HS_GCCFG_DCDET_Msk = 0x1
	// Bit DCDET.
	USB_OTG_HS_OTG_HS_GCCFG_DCDET = 0x1
	// Position of PDET field.
	USB_OTG_HS_OTG_HS_GCCFG_PDET_Pos = 0x1
	// Bit mask of PDET field.
	USB_OTG_HS_OTG_HS_GCCFG_PDET_Msk = 0x2
	// Bit PDET.
	USB_OTG_HS_OTG_HS_GCCFG_PDET = 0x2
	// Position of SDET field.
	USB_OTG_HS_OTG_HS_GCCFG_SDET_Pos = 0x2
	// Bit mask of SDET field.
	USB_OTG_HS_OTG_HS_GCCFG_SDET_Msk = 0x4
	// Bit SDET.
	USB_OTG_HS_OTG_HS_GCCFG_SDET = 0x4
	// Position of PS2DET field.
	USB_OTG_HS_OTG_HS_GCCFG_PS2DET_Pos = 0x3
	// Bit mask of PS2DET field.
	USB_OTG_HS_OTG_HS_GCCFG_PS2DET_Msk = 0x8
	// Bit PS2DET.
	USB_OTG_HS_OTG_HS_GCCFG_PS2DET = 0x8

	// OTG_HS_CID: OTG_HS core ID register
	// Position of PRODUCT_ID field.
	USB_OTG_HS_OTG_HS_CID_PRODUCT_ID_Pos = 0x0
	// Bit mask of PRODUCT_ID field.
	USB_OTG_HS_OTG_HS_CID_PRODUCT_ID_Msk = 0xffffffff

	// OTG_HS_GLPMCFG: OTG core LPM configuration register
	// Position of LPMEN field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMEN_Pos = 0x0
	// Bit mask of LPMEN field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMEN_Msk = 0x1
	// Bit LPMEN.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMEN = 0x1
	// Position of LPMACK field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMACK_Pos = 0x1
	// Bit mask of LPMACK field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMACK_Msk = 0x2
	// Bit LPMACK.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMACK = 0x2
	// Position of BESL field.
	USB_OTG_HS_OTG_HS_GLPMCFG_BESL_Pos = 0x2
	// Bit mask of BESL field.
	USB_OTG_HS_OTG_HS_GLPMCFG_BESL_Msk = 0x3c
	// Position of REMWAKE field.
	USB_OTG_HS_OTG_HS_GLPMCFG_REMWAKE_Pos = 0x6
	// Bit mask of REMWAKE field.
	USB_OTG_HS_OTG_HS_GLPMCFG_REMWAKE_Msk = 0x40
	// Bit REMWAKE.
	USB_OTG_HS_OTG_HS_GLPMCFG_REMWAKE = 0x40
	// Position of L1SSEN field.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1SSEN_Pos = 0x7
	// Bit mask of L1SSEN field.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1SSEN_Msk = 0x80
	// Bit L1SSEN.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1SSEN = 0x80
	// Position of BESLTHRS field.
	USB_OTG_HS_OTG_HS_GLPMCFG_BESLTHRS_Pos = 0x8
	// Bit mask of BESLTHRS field.
	USB_OTG_HS_OTG_HS_GLPMCFG_BESLTHRS_Msk = 0xf00
	// Position of L1DSEN field.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1DSEN_Pos = 0xc
	// Bit mask of L1DSEN field.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1DSEN_Msk = 0x1000
	// Bit L1DSEN.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1DSEN = 0x1000
	// Position of LPMRST field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMRST_Pos = 0xd
	// Bit mask of LPMRST field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMRST_Msk = 0x6000
	// Position of SLPSTS field.
	USB_OTG_HS_OTG_HS_GLPMCFG_SLPSTS_Pos = 0xf
	// Bit mask of SLPSTS field.
	USB_OTG_HS_OTG_HS_GLPMCFG_SLPSTS_Msk = 0x8000
	// Bit SLPSTS.
	USB_OTG_HS_OTG_HS_GLPMCFG_SLPSTS = 0x8000
	// Position of L1RSMOK field.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1RSMOK_Pos = 0x10
	// Bit mask of L1RSMOK field.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1RSMOK_Msk = 0x10000
	// Bit L1RSMOK.
	USB_OTG_HS_OTG_HS_GLPMCFG_L1RSMOK = 0x10000
	// Position of LPMCHIDX field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMCHIDX_Pos = 0x11
	// Bit mask of LPMCHIDX field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMCHIDX_Msk = 0x1e0000
	// Position of LPMRCNT field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMRCNT_Pos = 0x15
	// Bit mask of LPMRCNT field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMRCNT_Msk = 0xe00000
	// Position of SNDLPM field.
	USB_OTG_HS_OTG_HS_GLPMCFG_SNDLPM_Pos = 0x18
	// Bit mask of SNDLPM field.
	USB_OTG_HS_OTG_HS_GLPMCFG_SNDLPM_Msk = 0x1000000
	// Bit SNDLPM.
	USB_OTG_HS_OTG_HS_GLPMCFG_SNDLPM = 0x1000000
	// Position of LPMRCNTSTS field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMRCNTSTS_Pos = 0x19
	// Bit mask of LPMRCNTSTS field.
	USB_OTG_HS_OTG_HS_GLPMCFG_LPMRCNTSTS_Msk = 0xe000000
	// Position of ENBESL field.
	USB_OTG_HS_OTG_HS_GLPMCFG_ENBESL_Pos = 0x1c
	// Bit mask of ENBESL field.
	USB_OTG_HS_OTG_HS_GLPMCFG_ENBESL_Msk = 0x10000000
	// Bit ENBESL.
	USB_OTG_HS_OTG_HS_GLPMCFG_ENBESL = 0x10000000

	// OTG_HS_HPTXFSIZ: OTG_HS Host periodic transmit FIFO size register
	// Position of PTXSA field.
	USB_OTG_HS_OTG_HS_HPTXFSIZ_PTXSA_Pos = 0x0
	// Bit mask of PTXSA field.
	USB_OTG_HS_OTG_HS_HPTXFSIZ_PTXSA_Msk = 0xffff
	// Position of PTXFD field.
	USB_OTG_HS_OTG_HS_HPTXFSIZ_PTXFD_Pos = 0x10
	// Bit mask of PTXFD field.
	USB_OTG_HS_OTG_HS_HPTXFSIZ_PTXFD_Msk = 0xffff0000

	// OTG_HS_DIEPTXF1: OTG_HS device IN endpoint transmit FIFO size register
	// Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF1_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF1_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF1_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF1_INEPTXFD_Msk = 0xffff0000

	// OTG_HS_DIEPTXF2: OTG_HS device IN endpoint transmit FIFO size register
	// Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF2_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF2_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF2_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF2_INEPTXFD_Msk = 0xffff0000

	// OTG_HS_DIEPTXF3: OTG_HS device IN endpoint transmit FIFO size register
	// Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF3_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF3_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF3_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF3_INEPTXFD_Msk = 0xffff0000

	// OTG_HS_DIEPTXF4: OTG_HS device IN endpoint transmit FIFO size register
	// Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF4_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF4_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF4_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF4_INEPTXFD_Msk = 0xffff0000

	// OTG_HS_DIEPTXF5: OTG_HS device IN endpoint transmit FIFO size register
	// Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF5_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF5_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF5_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF5_INEPTXFD_Msk = 0xffff0000

	// OTG_HS_DIEPTXF6: OTG_HS device IN endpoint transmit FIFO size register
	// Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF6_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF6_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF6_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF6_INEPTXFD_Msk = 0xffff0000

	// OTG_HS_DIEPTXF7: OTG_HS device IN endpoint transmit FIFO size register
	// Position of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF7_INEPTXSA_Pos = 0x0
	// Bit mask of INEPTXSA field.
	USB_OTG_HS_OTG_HS_DIEPTXF7_INEPTXSA_Msk = 0xffff
	// Position of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF7_INEPTXFD_Pos = 0x10
	// Bit mask of INEPTXFD field.
	USB_OTG_HS_OTG_HS_DIEPTXF7_INEPTXFD_Msk = 0xffff0000
)

// Bitfields for MDIOS: Management data input/output slave
const (
	// CR: MDIOS configuration register
	// Position of EN field.
	MDIOS_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	MDIOS_CR_EN_Msk = 0x1
	// Bit EN.
	MDIOS_CR_EN = 0x1
	// Position of WRIE field.
	MDIOS_CR_WRIE_Pos = 0x1
	// Bit mask of WRIE field.
	MDIOS_CR_WRIE_Msk = 0x2
	// Bit WRIE.
	MDIOS_CR_WRIE = 0x2
	// Position of RDIE field.
	MDIOS_CR_RDIE_Pos = 0x2
	// Bit mask of RDIE field.
	MDIOS_CR_RDIE_Msk = 0x4
	// Bit RDIE.
	MDIOS_CR_RDIE = 0x4
	// Position of EIE field.
	MDIOS_CR_EIE_Pos = 0x3
	// Bit mask of EIE field.
	MDIOS_CR_EIE_Msk = 0x8
	// Bit EIE.
	MDIOS_CR_EIE = 0x8
	// Position of DPC field.
	MDIOS_CR_DPC_Pos = 0x7
	// Bit mask of DPC field.
	MDIOS_CR_DPC_Msk = 0x80
	// Bit DPC.
	MDIOS_CR_DPC = 0x80
	// Position of PORT_ADDRESS field.
	MDIOS_CR_PORT_ADDRESS_Pos = 0x8
	// Bit mask of PORT_ADDRESS field.
	MDIOS_CR_PORT_ADDRESS_Msk = 0x1f00

	// WRFR: MDIOS write flag register
	// Position of WRF field.
	MDIOS_WRFR_WRF_Pos = 0x0
	// Bit mask of WRF field.
	MDIOS_WRFR_WRF_Msk = 0xffffffff

	// CWRFR: MDIOS clear write flag register
	// Position of CWRF field.
	MDIOS_CWRFR_CWRF_Pos = 0x0
	// Bit mask of CWRF field.
	MDIOS_CWRFR_CWRF_Msk = 0xffffffff

	// RDFR: MDIOS read flag register
	// Position of RDF field.
	MDIOS_RDFR_RDF_Pos = 0x0
	// Bit mask of RDF field.
	MDIOS_RDFR_RDF_Msk = 0xffffffff

	// CRDFR: MDIOS clear read flag register
	// Position of CRDF field.
	MDIOS_CRDFR_CRDF_Pos = 0x0
	// Bit mask of CRDF field.
	MDIOS_CRDFR_CRDF_Msk = 0xffffffff

	// SR: MDIOS status register
	// Position of PERF field.
	MDIOS_SR_PERF_Pos = 0x0
	// Bit mask of PERF field.
	MDIOS_SR_PERF_Msk = 0x1
	// Bit PERF.
	MDIOS_SR_PERF = 0x1
	// Position of SERF field.
	MDIOS_SR_SERF_Pos = 0x1
	// Bit mask of SERF field.
	MDIOS_SR_SERF_Msk = 0x2
	// Bit SERF.
	MDIOS_SR_SERF = 0x2
	// Position of TERF field.
	MDIOS_SR_TERF_Pos = 0x2
	// Bit mask of TERF field.
	MDIOS_SR_TERF_Msk = 0x4
	// Bit TERF.
	MDIOS_SR_TERF = 0x4

	// CLRFR: MDIOS clear flag register
	// Position of CPERF field.
	MDIOS_CLRFR_CPERF_Pos = 0x0
	// Bit mask of CPERF field.
	MDIOS_CLRFR_CPERF_Msk = 0x1
	// Bit CPERF.
	MDIOS_CLRFR_CPERF = 0x1
	// Position of CSERF field.
	MDIOS_CLRFR_CSERF_Pos = 0x1
	// Bit mask of CSERF field.
	MDIOS_CLRFR_CSERF_Msk = 0x2
	// Bit CSERF.
	MDIOS_CLRFR_CSERF = 0x2
	// Position of CTERF field.
	MDIOS_CLRFR_CTERF_Pos = 0x2
	// Bit mask of CTERF field.
	MDIOS_CLRFR_CTERF_Msk = 0x4
	// Bit CTERF.
	MDIOS_CLRFR_CTERF = 0x4

	// DINR0: MDIOS input data register 0
	// Position of DIN field.
	MDIOS_DINR_DIN_Pos = 0x0
	// Bit mask of DIN field.
	MDIOS_DINR_DIN_Msk = 0xffff

	// DOUTR0: MDIOS output data register 0
	// Position of DOUT field.
	MDIOS_DOUTR_DOUT_Pos = 0x0
	// Bit mask of DOUT field.
	MDIOS_DOUTR_DOUT_Msk = 0xffff
)

// Bitfields for DFSDM: Digital filter for sigma delta modulators
const (
	// DFSDM_CHCFG0R1: DFSDM channel configuration 0 register 1
	// Position of SITP field.
	DFSDM_DFSDM_CHCFG0R1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_DFSDM_CHCFG0R1_SITP_Msk = 0x3
	// Position of SPICKSEL field.
	DFSDM_DFSDM_CHCFG0R1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_DFSDM_CHCFG0R1_SPICKSEL_Msk = 0xc
	// Position of SCDEN field.
	DFSDM_DFSDM_CHCFG0R1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_DFSDM_CHCFG0R1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_DFSDM_CHCFG0R1_SCDEN = 0x20
	// Position of CKABEN field.
	DFSDM_DFSDM_CHCFG0R1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_DFSDM_CHCFG0R1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_DFSDM_CHCFG0R1_CKABEN = 0x40
	// Position of CHEN field.
	DFSDM_DFSDM_CHCFG0R1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_DFSDM_CHCFG0R1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_DFSDM_CHCFG0R1_CHEN = 0x80
	// Position of CHINSEL field.
	DFSDM_DFSDM_CHCFG0R1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_DFSDM_CHCFG0R1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_DFSDM_CHCFG0R1_CHINSEL = 0x100
	// Position of DATMPX field.
	DFSDM_DFSDM_CHCFG0R1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_DFSDM_CHCFG0R1_DATMPX_Msk = 0x3000
	// Position of DATPACK field.
	DFSDM_DFSDM_CHCFG0R1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_DFSDM_CHCFG0R1_DATPACK_Msk = 0xc000
	// Position of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG0R1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG0R1_CKOUTDIV_Msk = 0xff0000
	// Position of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG0R1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG0R1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_DFSDM_CHCFG0R1_CKOUTSRC = 0x40000000
	// Position of DFSDMEN field.
	DFSDM_DFSDM_CHCFG0R1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_DFSDM_CHCFG0R1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_DFSDM_CHCFG0R1_DFSDMEN = 0x80000000

	// DFSDM_CHCFG0R2: DFSDM channel configuration 0 register 2
	// Position of DTRBS field.
	DFSDM_DFSDM_CHCFG0R2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_DFSDM_CHCFG0R2_DTRBS_Msk = 0xf8
	// Position of OFFSET field.
	DFSDM_DFSDM_CHCFG0R2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_DFSDM_CHCFG0R2_OFFSET_Msk = 0xffffff00

	// DFSDM_AWSCD0R: DFSDM analog watchdog and short-circuit detector register
	// Position of SCDT field.
	DFSDM_DFSDM_AWSCD0R_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_DFSDM_AWSCD0R_SCDT_Msk = 0xff
	// Position of BKSCD field.
	DFSDM_DFSDM_AWSCD0R_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_DFSDM_AWSCD0R_BKSCD_Msk = 0xf000
	// Position of AWFOSR field.
	DFSDM_DFSDM_AWSCD0R_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_DFSDM_AWSCD0R_AWFOSR_Msk = 0x1f0000
	// Position of AWFORD field.
	DFSDM_DFSDM_AWSCD0R_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_DFSDM_AWSCD0R_AWFORD_Msk = 0xc00000

	// DFSDM_CHWDAT0R: DFSDM channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_DFSDM_CHWDAT0R_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_DFSDM_CHWDAT0R_WDATA_Msk = 0xffff

	// DFSDM_CHDATIN0R: DFSDM channel data input register
	// Position of INDAT0 field.
	DFSDM_DFSDM_CHDATIN0R_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_DFSDM_CHDATIN0R_INDAT0_Msk = 0xffff
	// Position of INDAT1 field.
	DFSDM_DFSDM_CHDATIN0R_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_DFSDM_CHDATIN0R_INDAT1_Msk = 0xffff0000

	// DFSDM_CHCFG1R1: DFSDM channel configuration 1 register 1
	// Position of SITP field.
	DFSDM_DFSDM_CHCFG1R1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_DFSDM_CHCFG1R1_SITP_Msk = 0x3
	// Position of SPICKSEL field.
	DFSDM_DFSDM_CHCFG1R1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_DFSDM_CHCFG1R1_SPICKSEL_Msk = 0xc
	// Position of SCDEN field.
	DFSDM_DFSDM_CHCFG1R1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_DFSDM_CHCFG1R1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_DFSDM_CHCFG1R1_SCDEN = 0x20
	// Position of CKABEN field.
	DFSDM_DFSDM_CHCFG1R1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_DFSDM_CHCFG1R1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_DFSDM_CHCFG1R1_CKABEN = 0x40
	// Position of CHEN field.
	DFSDM_DFSDM_CHCFG1R1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_DFSDM_CHCFG1R1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_DFSDM_CHCFG1R1_CHEN = 0x80
	// Position of CHINSEL field.
	DFSDM_DFSDM_CHCFG1R1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_DFSDM_CHCFG1R1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_DFSDM_CHCFG1R1_CHINSEL = 0x100
	// Position of DATMPX field.
	DFSDM_DFSDM_CHCFG1R1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_DFSDM_CHCFG1R1_DATMPX_Msk = 0x3000
	// Position of DATPACK field.
	DFSDM_DFSDM_CHCFG1R1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_DFSDM_CHCFG1R1_DATPACK_Msk = 0xc000
	// Position of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG1R1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG1R1_CKOUTDIV_Msk = 0xff0000
	// Position of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG1R1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG1R1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_DFSDM_CHCFG1R1_CKOUTSRC = 0x40000000
	// Position of DFSDMEN field.
	DFSDM_DFSDM_CHCFG1R1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_DFSDM_CHCFG1R1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_DFSDM_CHCFG1R1_DFSDMEN = 0x80000000

	// DFSDM_CHCFG1R2: DFSDM channel configuration 1 register 2
	// Position of DTRBS field.
	DFSDM_DFSDM_CHCFG1R2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_DFSDM_CHCFG1R2_DTRBS_Msk = 0xf8
	// Position of OFFSET field.
	DFSDM_DFSDM_CHCFG1R2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_DFSDM_CHCFG1R2_OFFSET_Msk = 0xffffff00

	// DFSDM_AWSCD1R: DFSDM analog watchdog and short-circuit detector register
	// Position of SCDT field.
	DFSDM_DFSDM_AWSCD1R_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_DFSDM_AWSCD1R_SCDT_Msk = 0xff
	// Position of BKSCD field.
	DFSDM_DFSDM_AWSCD1R_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_DFSDM_AWSCD1R_BKSCD_Msk = 0xf000
	// Position of AWFOSR field.
	DFSDM_DFSDM_AWSCD1R_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_DFSDM_AWSCD1R_AWFOSR_Msk = 0x1f0000
	// Position of AWFORD field.
	DFSDM_DFSDM_AWSCD1R_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_DFSDM_AWSCD1R_AWFORD_Msk = 0xc00000

	// DFSDM_CHWDAT1R: DFSDM channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_DFSDM_CHWDAT1R_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_DFSDM_CHWDAT1R_WDATA_Msk = 0xffff

	// DFSDM_CHDATIN1R: DFSDM channel data input register
	// Position of INDAT0 field.
	DFSDM_DFSDM_CHDATIN1R_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_DFSDM_CHDATIN1R_INDAT0_Msk = 0xffff
	// Position of INDAT1 field.
	DFSDM_DFSDM_CHDATIN1R_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_DFSDM_CHDATIN1R_INDAT1_Msk = 0xffff0000

	// DFSDM_CHCFG2R1: DFSDM channel configuration 2 register 1
	// Position of SITP field.
	DFSDM_DFSDM_CHCFG2R1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_DFSDM_CHCFG2R1_SITP_Msk = 0x3
	// Position of SPICKSEL field.
	DFSDM_DFSDM_CHCFG2R1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_DFSDM_CHCFG2R1_SPICKSEL_Msk = 0xc
	// Position of SCDEN field.
	DFSDM_DFSDM_CHCFG2R1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_DFSDM_CHCFG2R1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_DFSDM_CHCFG2R1_SCDEN = 0x20
	// Position of CKABEN field.
	DFSDM_DFSDM_CHCFG2R1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_DFSDM_CHCFG2R1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_DFSDM_CHCFG2R1_CKABEN = 0x40
	// Position of CHEN field.
	DFSDM_DFSDM_CHCFG2R1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_DFSDM_CHCFG2R1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_DFSDM_CHCFG2R1_CHEN = 0x80
	// Position of CHINSEL field.
	DFSDM_DFSDM_CHCFG2R1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_DFSDM_CHCFG2R1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_DFSDM_CHCFG2R1_CHINSEL = 0x100
	// Position of DATMPX field.
	DFSDM_DFSDM_CHCFG2R1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_DFSDM_CHCFG2R1_DATMPX_Msk = 0x3000
	// Position of DATPACK field.
	DFSDM_DFSDM_CHCFG2R1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_DFSDM_CHCFG2R1_DATPACK_Msk = 0xc000
	// Position of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG2R1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG2R1_CKOUTDIV_Msk = 0xff0000
	// Position of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG2R1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG2R1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_DFSDM_CHCFG2R1_CKOUTSRC = 0x40000000
	// Position of DFSDMEN field.
	DFSDM_DFSDM_CHCFG2R1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_DFSDM_CHCFG2R1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_DFSDM_CHCFG2R1_DFSDMEN = 0x80000000

	// DFSDM_CHCFG2R2: DFSDM channel configuration 2 register 2
	// Position of DTRBS field.
	DFSDM_DFSDM_CHCFG2R2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_DFSDM_CHCFG2R2_DTRBS_Msk = 0xf8
	// Position of OFFSET field.
	DFSDM_DFSDM_CHCFG2R2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_DFSDM_CHCFG2R2_OFFSET_Msk = 0xffffff00

	// DFSDM_AWSCD2R: DFSDM analog watchdog and short-circuit detector register
	// Position of SCDT field.
	DFSDM_DFSDM_AWSCD2R_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_DFSDM_AWSCD2R_SCDT_Msk = 0xff
	// Position of BKSCD field.
	DFSDM_DFSDM_AWSCD2R_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_DFSDM_AWSCD2R_BKSCD_Msk = 0xf000
	// Position of AWFOSR field.
	DFSDM_DFSDM_AWSCD2R_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_DFSDM_AWSCD2R_AWFOSR_Msk = 0x1f0000
	// Position of AWFORD field.
	DFSDM_DFSDM_AWSCD2R_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_DFSDM_AWSCD2R_AWFORD_Msk = 0xc00000

	// DFSDM_CHWDAT2R: DFSDM channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_DFSDM_CHWDAT2R_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_DFSDM_CHWDAT2R_WDATA_Msk = 0xffff

	// DFSDM_CHDATIN2R: DFSDM channel data input register
	// Position of INDAT0 field.
	DFSDM_DFSDM_CHDATIN2R_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_DFSDM_CHDATIN2R_INDAT0_Msk = 0xffff
	// Position of INDAT1 field.
	DFSDM_DFSDM_CHDATIN2R_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_DFSDM_CHDATIN2R_INDAT1_Msk = 0xffff0000

	// DFSDM_CHCFG3R1: DFSDM channel configuration 3 register 1
	// Position of SITP field.
	DFSDM_DFSDM_CHCFG3R1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_DFSDM_CHCFG3R1_SITP_Msk = 0x3
	// Position of SPICKSEL field.
	DFSDM_DFSDM_CHCFG3R1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_DFSDM_CHCFG3R1_SPICKSEL_Msk = 0xc
	// Position of SCDEN field.
	DFSDM_DFSDM_CHCFG3R1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_DFSDM_CHCFG3R1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_DFSDM_CHCFG3R1_SCDEN = 0x20
	// Position of CKABEN field.
	DFSDM_DFSDM_CHCFG3R1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_DFSDM_CHCFG3R1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_DFSDM_CHCFG3R1_CKABEN = 0x40
	// Position of CHEN field.
	DFSDM_DFSDM_CHCFG3R1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_DFSDM_CHCFG3R1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_DFSDM_CHCFG3R1_CHEN = 0x80
	// Position of CHINSEL field.
	DFSDM_DFSDM_CHCFG3R1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_DFSDM_CHCFG3R1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_DFSDM_CHCFG3R1_CHINSEL = 0x100
	// Position of DATMPX field.
	DFSDM_DFSDM_CHCFG3R1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_DFSDM_CHCFG3R1_DATMPX_Msk = 0x3000
	// Position of DATPACK field.
	DFSDM_DFSDM_CHCFG3R1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_DFSDM_CHCFG3R1_DATPACK_Msk = 0xc000
	// Position of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG3R1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG3R1_CKOUTDIV_Msk = 0xff0000
	// Position of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG3R1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG3R1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_DFSDM_CHCFG3R1_CKOUTSRC = 0x40000000
	// Position of DFSDMEN field.
	DFSDM_DFSDM_CHCFG3R1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_DFSDM_CHCFG3R1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_DFSDM_CHCFG3R1_DFSDMEN = 0x80000000

	// DFSDM_CHCFG3R2: DFSDM channel configuration 3 register 2
	// Position of DTRBS field.
	DFSDM_DFSDM_CHCFG3R2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_DFSDM_CHCFG3R2_DTRBS_Msk = 0xf8
	// Position of OFFSET field.
	DFSDM_DFSDM_CHCFG3R2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_DFSDM_CHCFG3R2_OFFSET_Msk = 0xffffff00

	// DFSDM_AWSCD3R: DFSDM analog watchdog and short-circuit detector register
	// Position of SCDT field.
	DFSDM_DFSDM_AWSCD3R_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_DFSDM_AWSCD3R_SCDT_Msk = 0xff
	// Position of BKSCD field.
	DFSDM_DFSDM_AWSCD3R_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_DFSDM_AWSCD3R_BKSCD_Msk = 0xf000
	// Position of AWFOSR field.
	DFSDM_DFSDM_AWSCD3R_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_DFSDM_AWSCD3R_AWFOSR_Msk = 0x1f0000
	// Position of AWFORD field.
	DFSDM_DFSDM_AWSCD3R_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_DFSDM_AWSCD3R_AWFORD_Msk = 0xc00000

	// DFSDM_CHWDAT3R: DFSDM channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_DFSDM_CHWDAT3R_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_DFSDM_CHWDAT3R_WDATA_Msk = 0xffff

	// DFSDM_CHDATIN3R: DFSDM channel data input register
	// Position of INDAT0 field.
	DFSDM_DFSDM_CHDATIN3R_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_DFSDM_CHDATIN3R_INDAT0_Msk = 0xffff
	// Position of INDAT1 field.
	DFSDM_DFSDM_CHDATIN3R_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_DFSDM_CHDATIN3R_INDAT1_Msk = 0xffff0000

	// DFSDM_CHCFG4R1: DFSDM channel configuration 4 register 1
	// Position of SITP field.
	DFSDM_DFSDM_CHCFG4R1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_DFSDM_CHCFG4R1_SITP_Msk = 0x3
	// Position of SPICKSEL field.
	DFSDM_DFSDM_CHCFG4R1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_DFSDM_CHCFG4R1_SPICKSEL_Msk = 0xc
	// Position of SCDEN field.
	DFSDM_DFSDM_CHCFG4R1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_DFSDM_CHCFG4R1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_DFSDM_CHCFG4R1_SCDEN = 0x20
	// Position of CKABEN field.
	DFSDM_DFSDM_CHCFG4R1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_DFSDM_CHCFG4R1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_DFSDM_CHCFG4R1_CKABEN = 0x40
	// Position of CHEN field.
	DFSDM_DFSDM_CHCFG4R1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_DFSDM_CHCFG4R1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_DFSDM_CHCFG4R1_CHEN = 0x80
	// Position of CHINSEL field.
	DFSDM_DFSDM_CHCFG4R1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_DFSDM_CHCFG4R1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_DFSDM_CHCFG4R1_CHINSEL = 0x100
	// Position of DATMPX field.
	DFSDM_DFSDM_CHCFG4R1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_DFSDM_CHCFG4R1_DATMPX_Msk = 0x3000
	// Position of DATPACK field.
	DFSDM_DFSDM_CHCFG4R1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_DFSDM_CHCFG4R1_DATPACK_Msk = 0xc000
	// Position of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG4R1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG4R1_CKOUTDIV_Msk = 0xff0000
	// Position of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG4R1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG4R1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_DFSDM_CHCFG4R1_CKOUTSRC = 0x40000000
	// Position of DFSDMEN field.
	DFSDM_DFSDM_CHCFG4R1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_DFSDM_CHCFG4R1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_DFSDM_CHCFG4R1_DFSDMEN = 0x80000000

	// DFSDM_CHCFG4R2: DFSDM channel configuration 4 register 2
	// Position of DTRBS field.
	DFSDM_DFSDM_CHCFG4R2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_DFSDM_CHCFG4R2_DTRBS_Msk = 0xf8
	// Position of OFFSET field.
	DFSDM_DFSDM_CHCFG4R2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_DFSDM_CHCFG4R2_OFFSET_Msk = 0xffffff00

	// DFSDM_AWSCD4R: DFSDM analog watchdog and short-circuit detector register
	// Position of SCDT field.
	DFSDM_DFSDM_AWSCD4R_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_DFSDM_AWSCD4R_SCDT_Msk = 0xff
	// Position of BKSCD field.
	DFSDM_DFSDM_AWSCD4R_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_DFSDM_AWSCD4R_BKSCD_Msk = 0xf000
	// Position of AWFOSR field.
	DFSDM_DFSDM_AWSCD4R_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_DFSDM_AWSCD4R_AWFOSR_Msk = 0x1f0000
	// Position of AWFORD field.
	DFSDM_DFSDM_AWSCD4R_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_DFSDM_AWSCD4R_AWFORD_Msk = 0xc00000

	// DFSDM_CHWDAT4R: DFSDM channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_DFSDM_CHWDAT4R_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_DFSDM_CHWDAT4R_WDATA_Msk = 0xffff

	// DFSDM_CHDATIN4R: DFSDM channel data input register
	// Position of INDAT0 field.
	DFSDM_DFSDM_CHDATIN4R_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_DFSDM_CHDATIN4R_INDAT0_Msk = 0xffff
	// Position of INDAT1 field.
	DFSDM_DFSDM_CHDATIN4R_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_DFSDM_CHDATIN4R_INDAT1_Msk = 0xffff0000

	// DFSDM_CHCFG5R1: DFSDM channel configuration 5 register 1
	// Position of SITP field.
	DFSDM_DFSDM_CHCFG5R1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_DFSDM_CHCFG5R1_SITP_Msk = 0x3
	// Position of SPICKSEL field.
	DFSDM_DFSDM_CHCFG5R1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_DFSDM_CHCFG5R1_SPICKSEL_Msk = 0xc
	// Position of SCDEN field.
	DFSDM_DFSDM_CHCFG5R1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_DFSDM_CHCFG5R1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_DFSDM_CHCFG5R1_SCDEN = 0x20
	// Position of CKABEN field.
	DFSDM_DFSDM_CHCFG5R1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_DFSDM_CHCFG5R1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_DFSDM_CHCFG5R1_CKABEN = 0x40
	// Position of CHEN field.
	DFSDM_DFSDM_CHCFG5R1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_DFSDM_CHCFG5R1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_DFSDM_CHCFG5R1_CHEN = 0x80
	// Position of CHINSEL field.
	DFSDM_DFSDM_CHCFG5R1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_DFSDM_CHCFG5R1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_DFSDM_CHCFG5R1_CHINSEL = 0x100
	// Position of DATMPX field.
	DFSDM_DFSDM_CHCFG5R1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_DFSDM_CHCFG5R1_DATMPX_Msk = 0x3000
	// Position of DATPACK field.
	DFSDM_DFSDM_CHCFG5R1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_DFSDM_CHCFG5R1_DATPACK_Msk = 0xc000
	// Position of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG5R1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG5R1_CKOUTDIV_Msk = 0xff0000
	// Position of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG5R1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG5R1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_DFSDM_CHCFG5R1_CKOUTSRC = 0x40000000
	// Position of DFSDMEN field.
	DFSDM_DFSDM_CHCFG5R1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_DFSDM_CHCFG5R1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_DFSDM_CHCFG5R1_DFSDMEN = 0x80000000

	// DFSDM_CHCFG5R2: DFSDM channel configuration 5 register 2
	// Position of DTRBS field.
	DFSDM_DFSDM_CHCFG5R2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_DFSDM_CHCFG5R2_DTRBS_Msk = 0xf8
	// Position of OFFSET field.
	DFSDM_DFSDM_CHCFG5R2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_DFSDM_CHCFG5R2_OFFSET_Msk = 0xffffff00

	// DFSDM_AWSCD5R: DFSDM analog watchdog and short-circuit detector register
	// Position of SCDT field.
	DFSDM_DFSDM_AWSCD5R_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_DFSDM_AWSCD5R_SCDT_Msk = 0xff
	// Position of BKSCD field.
	DFSDM_DFSDM_AWSCD5R_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_DFSDM_AWSCD5R_BKSCD_Msk = 0xf000
	// Position of AWFOSR field.
	DFSDM_DFSDM_AWSCD5R_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_DFSDM_AWSCD5R_AWFOSR_Msk = 0x1f0000
	// Position of AWFORD field.
	DFSDM_DFSDM_AWSCD5R_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_DFSDM_AWSCD5R_AWFORD_Msk = 0xc00000

	// DFSDM_CHWDAT5R: DFSDM channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_DFSDM_CHWDAT5R_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_DFSDM_CHWDAT5R_WDATA_Msk = 0xffff

	// DFSDM_CHDATIN5R: DFSDM channel data input register
	// Position of INDAT0 field.
	DFSDM_DFSDM_CHDATIN5R_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_DFSDM_CHDATIN5R_INDAT0_Msk = 0xffff
	// Position of INDAT1 field.
	DFSDM_DFSDM_CHDATIN5R_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_DFSDM_CHDATIN5R_INDAT1_Msk = 0xffff0000

	// DFSDM_CHCFG6R1: DFSDM channel configuration 6 register 1
	// Position of SITP field.
	DFSDM_DFSDM_CHCFG6R1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_DFSDM_CHCFG6R1_SITP_Msk = 0x3
	// Position of SPICKSEL field.
	DFSDM_DFSDM_CHCFG6R1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_DFSDM_CHCFG6R1_SPICKSEL_Msk = 0xc
	// Position of SCDEN field.
	DFSDM_DFSDM_CHCFG6R1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_DFSDM_CHCFG6R1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_DFSDM_CHCFG6R1_SCDEN = 0x20
	// Position of CKABEN field.
	DFSDM_DFSDM_CHCFG6R1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_DFSDM_CHCFG6R1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_DFSDM_CHCFG6R1_CKABEN = 0x40
	// Position of CHEN field.
	DFSDM_DFSDM_CHCFG6R1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_DFSDM_CHCFG6R1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_DFSDM_CHCFG6R1_CHEN = 0x80
	// Position of CHINSEL field.
	DFSDM_DFSDM_CHCFG6R1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_DFSDM_CHCFG6R1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_DFSDM_CHCFG6R1_CHINSEL = 0x100
	// Position of DATMPX field.
	DFSDM_DFSDM_CHCFG6R1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_DFSDM_CHCFG6R1_DATMPX_Msk = 0x3000
	// Position of DATPACK field.
	DFSDM_DFSDM_CHCFG6R1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_DFSDM_CHCFG6R1_DATPACK_Msk = 0xc000
	// Position of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG6R1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG6R1_CKOUTDIV_Msk = 0xff0000
	// Position of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG6R1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG6R1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_DFSDM_CHCFG6R1_CKOUTSRC = 0x40000000
	// Position of DFSDMEN field.
	DFSDM_DFSDM_CHCFG6R1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_DFSDM_CHCFG6R1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_DFSDM_CHCFG6R1_DFSDMEN = 0x80000000

	// DFSDM_CHCFG6R2: DFSDM channel configuration 6 register 2
	// Position of DTRBS field.
	DFSDM_DFSDM_CHCFG6R2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_DFSDM_CHCFG6R2_DTRBS_Msk = 0xf8
	// Position of OFFSET field.
	DFSDM_DFSDM_CHCFG6R2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_DFSDM_CHCFG6R2_OFFSET_Msk = 0xffffff00

	// DFSDM_AWSCD6R: DFSDM analog watchdog and short-circuit detector register
	// Position of SCDT field.
	DFSDM_DFSDM_AWSCD6R_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_DFSDM_AWSCD6R_SCDT_Msk = 0xff
	// Position of BKSCD field.
	DFSDM_DFSDM_AWSCD6R_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_DFSDM_AWSCD6R_BKSCD_Msk = 0xf000
	// Position of AWFOSR field.
	DFSDM_DFSDM_AWSCD6R_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_DFSDM_AWSCD6R_AWFOSR_Msk = 0x1f0000
	// Position of AWFORD field.
	DFSDM_DFSDM_AWSCD6R_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_DFSDM_AWSCD6R_AWFORD_Msk = 0xc00000

	// DFSDM_CHWDAT6R: DFSDM channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_DFSDM_CHWDAT6R_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_DFSDM_CHWDAT6R_WDATA_Msk = 0xffff

	// DFSDM_CHDATIN6R: DFSDM channel data input register
	// Position of INDAT0 field.
	DFSDM_DFSDM_CHDATIN6R_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_DFSDM_CHDATIN6R_INDAT0_Msk = 0xffff
	// Position of INDAT1 field.
	DFSDM_DFSDM_CHDATIN6R_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_DFSDM_CHDATIN6R_INDAT1_Msk = 0xffff0000

	// DFSDM_CHCFG7R1: DFSDM channel configuration 7 register 1
	// Position of SITP field.
	DFSDM_DFSDM_CHCFG7R1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_DFSDM_CHCFG7R1_SITP_Msk = 0x3
	// Position of SPICKSEL field.
	DFSDM_DFSDM_CHCFG7R1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_DFSDM_CHCFG7R1_SPICKSEL_Msk = 0xc
	// Position of SCDEN field.
	DFSDM_DFSDM_CHCFG7R1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_DFSDM_CHCFG7R1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_DFSDM_CHCFG7R1_SCDEN = 0x20
	// Position of CKABEN field.
	DFSDM_DFSDM_CHCFG7R1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_DFSDM_CHCFG7R1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_DFSDM_CHCFG7R1_CKABEN = 0x40
	// Position of CHEN field.
	DFSDM_DFSDM_CHCFG7R1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_DFSDM_CHCFG7R1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_DFSDM_CHCFG7R1_CHEN = 0x80
	// Position of CHINSEL field.
	DFSDM_DFSDM_CHCFG7R1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_DFSDM_CHCFG7R1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_DFSDM_CHCFG7R1_CHINSEL = 0x100
	// Position of DATMPX field.
	DFSDM_DFSDM_CHCFG7R1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_DFSDM_CHCFG7R1_DATMPX_Msk = 0x3000
	// Position of DATPACK field.
	DFSDM_DFSDM_CHCFG7R1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_DFSDM_CHCFG7R1_DATPACK_Msk = 0xc000
	// Position of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG7R1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_DFSDM_CHCFG7R1_CKOUTDIV_Msk = 0xff0000
	// Position of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG7R1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_DFSDM_CHCFG7R1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_DFSDM_CHCFG7R1_CKOUTSRC = 0x40000000
	// Position of DFSDMEN field.
	DFSDM_DFSDM_CHCFG7R1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_DFSDM_CHCFG7R1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_DFSDM_CHCFG7R1_DFSDMEN = 0x80000000

	// DFSDM_CHCFG7R2: DFSDM channel configuration 7 register 2
	// Position of DTRBS field.
	DFSDM_DFSDM_CHCFG7R2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_DFSDM_CHCFG7R2_DTRBS_Msk = 0xf8
	// Position of OFFSET field.
	DFSDM_DFSDM_CHCFG7R2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_DFSDM_CHCFG7R2_OFFSET_Msk = 0xffffff00

	// DFSDM_AWSCD7R: DFSDM analog watchdog and short-circuit detector register
	// Position of SCDT field.
	DFSDM_DFSDM_AWSCD7R_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_DFSDM_AWSCD7R_SCDT_Msk = 0xff
	// Position of BKSCD field.
	DFSDM_DFSDM_AWSCD7R_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_DFSDM_AWSCD7R_BKSCD_Msk = 0xf000
	// Position of AWFOSR field.
	DFSDM_DFSDM_AWSCD7R_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_DFSDM_AWSCD7R_AWFOSR_Msk = 0x1f0000
	// Position of AWFORD field.
	DFSDM_DFSDM_AWSCD7R_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_DFSDM_AWSCD7R_AWFORD_Msk = 0xc00000

	// DFSDM_CHWDAT7R: DFSDM channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_DFSDM_CHWDAT7R_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_DFSDM_CHWDAT7R_WDATA_Msk = 0xffff

	// DFSDM_CHDATIN7R: DFSDM channel data input register
	// Position of INDAT0 field.
	DFSDM_DFSDM_CHDATIN7R_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_DFSDM_CHDATIN7R_INDAT0_Msk = 0xffff
	// Position of INDAT1 field.
	DFSDM_DFSDM_CHDATIN7R_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_DFSDM_CHDATIN7R_INDAT1_Msk = 0xffff0000

	// DFSDM0_CR1: DFSDM control register 1
	// Position of DFEN field.
	DFSDM_DFSDM0_CR1_DFEN_Pos = 0x0
	// Bit mask of DFEN field.
	DFSDM_DFSDM0_CR1_DFEN_Msk = 0x1
	// Bit DFEN.
	DFSDM_DFSDM0_CR1_DFEN = 0x1
	// Position of JSWSTART field.
	DFSDM_DFSDM0_CR1_JSWSTART_Pos = 0x1
	// Bit mask of JSWSTART field.
	DFSDM_DFSDM0_CR1_JSWSTART_Msk = 0x2
	// Bit JSWSTART.
	DFSDM_DFSDM0_CR1_JSWSTART = 0x2
	// Position of JSYNC field.
	DFSDM_DFSDM0_CR1_JSYNC_Pos = 0x3
	// Bit mask of JSYNC field.
	DFSDM_DFSDM0_CR1_JSYNC_Msk = 0x8
	// Bit JSYNC.
	DFSDM_DFSDM0_CR1_JSYNC = 0x8
	// Position of JSCAN field.
	DFSDM_DFSDM0_CR1_JSCAN_Pos = 0x4
	// Bit mask of JSCAN field.
	DFSDM_DFSDM0_CR1_JSCAN_Msk = 0x10
	// Bit JSCAN.
	DFSDM_DFSDM0_CR1_JSCAN = 0x10
	// Position of JDMAEN field.
	DFSDM_DFSDM0_CR1_JDMAEN_Pos = 0x5
	// Bit mask of JDMAEN field.
	DFSDM_DFSDM0_CR1_JDMAEN_Msk = 0x20
	// Bit JDMAEN.
	DFSDM_DFSDM0_CR1_JDMAEN = 0x20
	// Position of JEXTSEL field.
	DFSDM_DFSDM0_CR1_JEXTSEL_Pos = 0x8
	// Bit mask of JEXTSEL field.
	DFSDM_DFSDM0_CR1_JEXTSEL_Msk = 0x1f00
	// Position of JEXTEN field.
	DFSDM_DFSDM0_CR1_JEXTEN_Pos = 0xd
	// Bit mask of JEXTEN field.
	DFSDM_DFSDM0_CR1_JEXTEN_Msk = 0x6000
	// Position of RSWSTART field.
	DFSDM_DFSDM0_CR1_RSWSTART_Pos = 0x11
	// Bit mask of RSWSTART field.
	DFSDM_DFSDM0_CR1_RSWSTART_Msk = 0x20000
	// Bit RSWSTART.
	DFSDM_DFSDM0_CR1_RSWSTART = 0x20000
	// Position of RCONT field.
	DFSDM_DFSDM0_CR1_RCONT_Pos = 0x12
	// Bit mask of RCONT field.
	DFSDM_DFSDM0_CR1_RCONT_Msk = 0x40000
	// Bit RCONT.
	DFSDM_DFSDM0_CR1_RCONT = 0x40000
	// Position of RSYNC field.
	DFSDM_DFSDM0_CR1_RSYNC_Pos = 0x13
	// Bit mask of RSYNC field.
	DFSDM_DFSDM0_CR1_RSYNC_Msk = 0x80000
	// Bit RSYNC.
	DFSDM_DFSDM0_CR1_RSYNC = 0x80000
	// Position of RDMAEN field.
	DFSDM_DFSDM0_CR1_RDMAEN_Pos = 0x15
	// Bit mask of RDMAEN field.
	DFSDM_DFSDM0_CR1_RDMAEN_Msk = 0x200000
	// Bit RDMAEN.
	DFSDM_DFSDM0_CR1_RDMAEN = 0x200000
	// Position of RCH field.
	DFSDM_DFSDM0_CR1_RCH_Pos = 0x18
	// Bit mask of RCH field.
	DFSDM_DFSDM0_CR1_RCH_Msk = 0x7000000
	// Position of FAST field.
	DFSDM_DFSDM0_CR1_FAST_Pos = 0x1d
	// Bit mask of FAST field.
	DFSDM_DFSDM0_CR1_FAST_Msk = 0x20000000
	// Bit FAST.
	DFSDM_DFSDM0_CR1_FAST = 0x20000000
	// Position of AWFSEL field.
	DFSDM_DFSDM0_CR1_AWFSEL_Pos = 0x1e
	// Bit mask of AWFSEL field.
	DFSDM_DFSDM0_CR1_AWFSEL_Msk = 0x40000000
	// Bit AWFSEL.
	DFSDM_DFSDM0_CR1_AWFSEL = 0x40000000

	// DFSDM0_CR2: DFSDM control register 2
	// Position of JEOCIE field.
	DFSDM_DFSDM0_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_DFSDM0_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_DFSDM0_CR2_JEOCIE = 0x1
	// Position of REOCIE field.
	DFSDM_DFSDM0_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_DFSDM0_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_DFSDM0_CR2_REOCIE = 0x2
	// Position of JOVRIE field.
	DFSDM_DFSDM0_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_DFSDM0_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_DFSDM0_CR2_JOVRIE = 0x4
	// Position of ROVRIE field.
	DFSDM_DFSDM0_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_DFSDM0_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_DFSDM0_CR2_ROVRIE = 0x8
	// Position of AWDIE field.
	DFSDM_DFSDM0_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_DFSDM0_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_DFSDM0_CR2_AWDIE = 0x10
	// Position of SCDIE field.
	DFSDM_DFSDM0_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_DFSDM0_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_DFSDM0_CR2_SCDIE = 0x20
	// Position of CKABIE field.
	DFSDM_DFSDM0_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_DFSDM0_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_DFSDM0_CR2_CKABIE = 0x40
	// Position of EXCH field.
	DFSDM_DFSDM0_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_DFSDM0_CR2_EXCH_Msk = 0xff00
	// Position of AWDCH field.
	DFSDM_DFSDM0_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_DFSDM0_CR2_AWDCH_Msk = 0xff0000

	// DFSDM0_ISR: DFSDM interrupt and status register
	// Position of JEOCF field.
	DFSDM_DFSDM0_ISR_JEOCF_Pos = 0x0
	// Bit mask of JEOCF field.
	DFSDM_DFSDM0_ISR_JEOCF_Msk = 0x1
	// Bit JEOCF.
	DFSDM_DFSDM0_ISR_JEOCF = 0x1
	// Position of REOCF field.
	DFSDM_DFSDM0_ISR_REOCF_Pos = 0x1
	// Bit mask of REOCF field.
	DFSDM_DFSDM0_ISR_REOCF_Msk = 0x2
	// Bit REOCF.
	DFSDM_DFSDM0_ISR_REOCF = 0x2
	// Position of JOVRF field.
	DFSDM_DFSDM0_ISR_JOVRF_Pos = 0x2
	// Bit mask of JOVRF field.
	DFSDM_DFSDM0_ISR_JOVRF_Msk = 0x4
	// Bit JOVRF.
	DFSDM_DFSDM0_ISR_JOVRF = 0x4
	// Position of ROVRF field.
	DFSDM_DFSDM0_ISR_ROVRF_Pos = 0x3
	// Bit mask of ROVRF field.
	DFSDM_DFSDM0_ISR_ROVRF_Msk = 0x8
	// Bit ROVRF.
	DFSDM_DFSDM0_ISR_ROVRF = 0x8
	// Position of AWDF field.
	DFSDM_DFSDM0_ISR_AWDF_Pos = 0x4
	// Bit mask of AWDF field.
	DFSDM_DFSDM0_ISR_AWDF_Msk = 0x10
	// Bit AWDF.
	DFSDM_DFSDM0_ISR_AWDF = 0x10
	// Position of JCIP field.
	DFSDM_DFSDM0_ISR_JCIP_Pos = 0xd
	// Bit mask of JCIP field.
	DFSDM_DFSDM0_ISR_JCIP_Msk = 0x2000
	// Bit JCIP.
	DFSDM_DFSDM0_ISR_JCIP = 0x2000
	// Position of RCIP field.
	DFSDM_DFSDM0_ISR_RCIP_Pos = 0xe
	// Bit mask of RCIP field.
	DFSDM_DFSDM0_ISR_RCIP_Msk = 0x4000
	// Bit RCIP.
	DFSDM_DFSDM0_ISR_RCIP = 0x4000
	// Position of CKABF field.
	DFSDM_DFSDM0_ISR_CKABF_Pos = 0x10
	// Bit mask of CKABF field.
	DFSDM_DFSDM0_ISR_CKABF_Msk = 0xff0000
	// Position of SCDF field.
	DFSDM_DFSDM0_ISR_SCDF_Pos = 0x18
	// Bit mask of SCDF field.
	DFSDM_DFSDM0_ISR_SCDF_Msk = 0xff000000

	// DFSDM0_ICR: DFSDM interrupt flag clear register
	// Position of CLRJOVRF field.
	DFSDM_DFSDM0_ICR_CLRJOVRF_Pos = 0x2
	// Bit mask of CLRJOVRF field.
	DFSDM_DFSDM0_ICR_CLRJOVRF_Msk = 0x4
	// Bit CLRJOVRF.
	DFSDM_DFSDM0_ICR_CLRJOVRF = 0x4
	// Position of CLRROVRF field.
	DFSDM_DFSDM0_ICR_CLRROVRF_Pos = 0x3
	// Bit mask of CLRROVRF field.
	DFSDM_DFSDM0_ICR_CLRROVRF_Msk = 0x8
	// Bit CLRROVRF.
	DFSDM_DFSDM0_ICR_CLRROVRF = 0x8
	// Position of CLRCKABF field.
	DFSDM_DFSDM0_ICR_CLRCKABF_Pos = 0x10
	// Bit mask of CLRCKABF field.
	DFSDM_DFSDM0_ICR_CLRCKABF_Msk = 0xff0000
	// Position of CLRSCDF field.
	DFSDM_DFSDM0_ICR_CLRSCDF_Pos = 0x18
	// Bit mask of CLRSCDF field.
	DFSDM_DFSDM0_ICR_CLRSCDF_Msk = 0xff000000

	// DFSDM0_JCHGR: DFSDM injected channel group selection register
	// Position of JCHG field.
	DFSDM_DFSDM0_JCHGR_JCHG_Pos = 0x0
	// Bit mask of JCHG field.
	DFSDM_DFSDM0_JCHGR_JCHG_Msk = 0xff

	// DFSDM0_FCR: DFSDM filter control register
	// Position of IOSR field.
	DFSDM_DFSDM0_FCR_IOSR_Pos = 0x0
	// Bit mask of IOSR field.
	DFSDM_DFSDM0_FCR_IOSR_Msk = 0xff
	// Position of FOSR field.
	DFSDM_DFSDM0_FCR_FOSR_Pos = 0x10
	// Bit mask of FOSR field.
	DFSDM_DFSDM0_FCR_FOSR_Msk = 0x3ff0000
	// Position of FORD field.
	DFSDM_DFSDM0_FCR_FORD_Pos = 0x1d
	// Bit mask of FORD field.
	DFSDM_DFSDM0_FCR_FORD_Msk = 0xe0000000

	// DFSDM0_JDATAR: DFSDM data register for injected group
	// Position of JDATACH field.
	DFSDM_DFSDM0_JDATAR_JDATACH_Pos = 0x0
	// Bit mask of JDATACH field.
	DFSDM_DFSDM0_JDATAR_JDATACH_Msk = 0x7
	// Position of JDATA field.
	DFSDM_DFSDM0_JDATAR_JDATA_Pos = 0x8
	// Bit mask of JDATA field.
	DFSDM_DFSDM0_JDATAR_JDATA_Msk = 0xffffff00

	// DFSDM0_RDATAR: DFSDM data register for the regular channel
	// Position of RDATACH field.
	DFSDM_DFSDM0_RDATAR_RDATACH_Pos = 0x0
	// Bit mask of RDATACH field.
	DFSDM_DFSDM0_RDATAR_RDATACH_Msk = 0x7
	// Position of RPEND field.
	DFSDM_DFSDM0_RDATAR_RPEND_Pos = 0x4
	// Bit mask of RPEND field.
	DFSDM_DFSDM0_RDATAR_RPEND_Msk = 0x10
	// Bit RPEND.
	DFSDM_DFSDM0_RDATAR_RPEND = 0x10
	// Position of RDATA field.
	DFSDM_DFSDM0_RDATAR_RDATA_Pos = 0x8
	// Bit mask of RDATA field.
	DFSDM_DFSDM0_RDATAR_RDATA_Msk = 0xffffff00

	// DFSDM0_AWHTR: DFSDM analog watchdog high threshold register
	// Position of BKAWH field.
	DFSDM_DFSDM0_AWHTR_BKAWH_Pos = 0x0
	// Bit mask of BKAWH field.
	DFSDM_DFSDM0_AWHTR_BKAWH_Msk = 0xf
	// Position of AWHT field.
	DFSDM_DFSDM0_AWHTR_AWHT_Pos = 0x8
	// Bit mask of AWHT field.
	DFSDM_DFSDM0_AWHTR_AWHT_Msk = 0xffffff00

	// DFSDM0_AWLTR: DFSDM analog watchdog low threshold register
	// Position of BKAWL field.
	DFSDM_DFSDM0_AWLTR_BKAWL_Pos = 0x0
	// Bit mask of BKAWL field.
	DFSDM_DFSDM0_AWLTR_BKAWL_Msk = 0xf
	// Position of AWLT field.
	DFSDM_DFSDM0_AWLTR_AWLT_Pos = 0x8
	// Bit mask of AWLT field.
	DFSDM_DFSDM0_AWLTR_AWLT_Msk = 0xffffff00

	// DFSDM0_AWSR: DFSDM analog watchdog status register
	// Position of AWLTF field.
	DFSDM_DFSDM0_AWSR_AWLTF_Pos = 0x0
	// Bit mask of AWLTF field.
	DFSDM_DFSDM0_AWSR_AWLTF_Msk = 0xff
	// Position of AWHTF field.
	DFSDM_DFSDM0_AWSR_AWHTF_Pos = 0x8
	// Bit mask of AWHTF field.
	DFSDM_DFSDM0_AWSR_AWHTF_Msk = 0xff00

	// DFSDM0_AWCFR: DFSDM analog watchdog clear flag register
	// Position of CLRAWLTF field.
	DFSDM_DFSDM0_AWCFR_CLRAWLTF_Pos = 0x0
	// Bit mask of CLRAWLTF field.
	DFSDM_DFSDM0_AWCFR_CLRAWLTF_Msk = 0xff
	// Position of CLRAWHTF field.
	DFSDM_DFSDM0_AWCFR_CLRAWHTF_Pos = 0x8
	// Bit mask of CLRAWHTF field.
	DFSDM_DFSDM0_AWCFR_CLRAWHTF_Msk = 0xff00

	// DFSDM0_EXMAX: DFSDM Extremes detector maximum register
	// Position of EXMAXCH field.
	DFSDM_DFSDM0_EXMAX_EXMAXCH_Pos = 0x0
	// Bit mask of EXMAXCH field.
	DFSDM_DFSDM0_EXMAX_EXMAXCH_Msk = 0x7
	// Position of EXMAX field.
	DFSDM_DFSDM0_EXMAX_EXMAX_Pos = 0x8
	// Bit mask of EXMAX field.
	DFSDM_DFSDM0_EXMAX_EXMAX_Msk = 0xffffff00

	// DFSDM0_EXMIN: DFSDM Extremes detector minimum register
	// Position of EXMINCH field.
	DFSDM_DFSDM0_EXMIN_EXMINCH_Pos = 0x0
	// Bit mask of EXMINCH field.
	DFSDM_DFSDM0_EXMIN_EXMINCH_Msk = 0x7
	// Position of EXMIN field.
	DFSDM_DFSDM0_EXMIN_EXMIN_Pos = 0x8
	// Bit mask of EXMIN field.
	DFSDM_DFSDM0_EXMIN_EXMIN_Msk = 0xffffff00

	// DFSDM0_CNVTIMR: DFSDM conversion timer register
	// Position of CNVCNT field.
	DFSDM_DFSDM0_CNVTIMR_CNVCNT_Pos = 0x4
	// Bit mask of CNVCNT field.
	DFSDM_DFSDM0_CNVTIMR_CNVCNT_Msk = 0xfffffff0

	// DFSDM1_CR1: DFSDM control register 1
	// Position of DFEN field.
	DFSDM_DFSDM1_CR1_DFEN_Pos = 0x0
	// Bit mask of DFEN field.
	DFSDM_DFSDM1_CR1_DFEN_Msk = 0x1
	// Bit DFEN.
	DFSDM_DFSDM1_CR1_DFEN = 0x1
	// Position of JSWSTART field.
	DFSDM_DFSDM1_CR1_JSWSTART_Pos = 0x1
	// Bit mask of JSWSTART field.
	DFSDM_DFSDM1_CR1_JSWSTART_Msk = 0x2
	// Bit JSWSTART.
	DFSDM_DFSDM1_CR1_JSWSTART = 0x2
	// Position of JSYNC field.
	DFSDM_DFSDM1_CR1_JSYNC_Pos = 0x3
	// Bit mask of JSYNC field.
	DFSDM_DFSDM1_CR1_JSYNC_Msk = 0x8
	// Bit JSYNC.
	DFSDM_DFSDM1_CR1_JSYNC = 0x8
	// Position of JSCAN field.
	DFSDM_DFSDM1_CR1_JSCAN_Pos = 0x4
	// Bit mask of JSCAN field.
	DFSDM_DFSDM1_CR1_JSCAN_Msk = 0x10
	// Bit JSCAN.
	DFSDM_DFSDM1_CR1_JSCAN = 0x10
	// Position of JDMAEN field.
	DFSDM_DFSDM1_CR1_JDMAEN_Pos = 0x5
	// Bit mask of JDMAEN field.
	DFSDM_DFSDM1_CR1_JDMAEN_Msk = 0x20
	// Bit JDMAEN.
	DFSDM_DFSDM1_CR1_JDMAEN = 0x20
	// Position of JEXTSEL field.
	DFSDM_DFSDM1_CR1_JEXTSEL_Pos = 0x8
	// Bit mask of JEXTSEL field.
	DFSDM_DFSDM1_CR1_JEXTSEL_Msk = 0x1f00
	// Position of JEXTEN field.
	DFSDM_DFSDM1_CR1_JEXTEN_Pos = 0xd
	// Bit mask of JEXTEN field.
	DFSDM_DFSDM1_CR1_JEXTEN_Msk = 0x6000
	// Position of RSWSTART field.
	DFSDM_DFSDM1_CR1_RSWSTART_Pos = 0x11
	// Bit mask of RSWSTART field.
	DFSDM_DFSDM1_CR1_RSWSTART_Msk = 0x20000
	// Bit RSWSTART.
	DFSDM_DFSDM1_CR1_RSWSTART = 0x20000
	// Position of RCONT field.
	DFSDM_DFSDM1_CR1_RCONT_Pos = 0x12
	// Bit mask of RCONT field.
	DFSDM_DFSDM1_CR1_RCONT_Msk = 0x40000
	// Bit RCONT.
	DFSDM_DFSDM1_CR1_RCONT = 0x40000
	// Position of RSYNC field.
	DFSDM_DFSDM1_CR1_RSYNC_Pos = 0x13
	// Bit mask of RSYNC field.
	DFSDM_DFSDM1_CR1_RSYNC_Msk = 0x80000
	// Bit RSYNC.
	DFSDM_DFSDM1_CR1_RSYNC = 0x80000
	// Position of RDMAEN field.
	DFSDM_DFSDM1_CR1_RDMAEN_Pos = 0x15
	// Bit mask of RDMAEN field.
	DFSDM_DFSDM1_CR1_RDMAEN_Msk = 0x200000
	// Bit RDMAEN.
	DFSDM_DFSDM1_CR1_RDMAEN = 0x200000
	// Position of RCH field.
	DFSDM_DFSDM1_CR1_RCH_Pos = 0x18
	// Bit mask of RCH field.
	DFSDM_DFSDM1_CR1_RCH_Msk = 0x7000000
	// Position of FAST field.
	DFSDM_DFSDM1_CR1_FAST_Pos = 0x1d
	// Bit mask of FAST field.
	DFSDM_DFSDM1_CR1_FAST_Msk = 0x20000000
	// Bit FAST.
	DFSDM_DFSDM1_CR1_FAST = 0x20000000
	// Position of AWFSEL field.
	DFSDM_DFSDM1_CR1_AWFSEL_Pos = 0x1e
	// Bit mask of AWFSEL field.
	DFSDM_DFSDM1_CR1_AWFSEL_Msk = 0x40000000
	// Bit AWFSEL.
	DFSDM_DFSDM1_CR1_AWFSEL = 0x40000000

	// DFSDM1_CR2: DFSDM control register 2
	// Position of JEOCIE field.
	DFSDM_DFSDM1_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_DFSDM1_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_DFSDM1_CR2_JEOCIE = 0x1
	// Position of REOCIE field.
	DFSDM_DFSDM1_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_DFSDM1_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_DFSDM1_CR2_REOCIE = 0x2
	// Position of JOVRIE field.
	DFSDM_DFSDM1_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_DFSDM1_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_DFSDM1_CR2_JOVRIE = 0x4
	// Position of ROVRIE field.
	DFSDM_DFSDM1_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_DFSDM1_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_DFSDM1_CR2_ROVRIE = 0x8
	// Position of AWDIE field.
	DFSDM_DFSDM1_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_DFSDM1_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_DFSDM1_CR2_AWDIE = 0x10
	// Position of SCDIE field.
	DFSDM_DFSDM1_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_DFSDM1_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_DFSDM1_CR2_SCDIE = 0x20
	// Position of CKABIE field.
	DFSDM_DFSDM1_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_DFSDM1_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_DFSDM1_CR2_CKABIE = 0x40
	// Position of EXCH field.
	DFSDM_DFSDM1_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_DFSDM1_CR2_EXCH_Msk = 0xff00
	// Position of AWDCH field.
	DFSDM_DFSDM1_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_DFSDM1_CR2_AWDCH_Msk = 0xff0000

	// DFSDM1_ISR: DFSDM interrupt and status register
	// Position of JEOCF field.
	DFSDM_DFSDM1_ISR_JEOCF_Pos = 0x0
	// Bit mask of JEOCF field.
	DFSDM_DFSDM1_ISR_JEOCF_Msk = 0x1
	// Bit JEOCF.
	DFSDM_DFSDM1_ISR_JEOCF = 0x1
	// Position of REOCF field.
	DFSDM_DFSDM1_ISR_REOCF_Pos = 0x1
	// Bit mask of REOCF field.
	DFSDM_DFSDM1_ISR_REOCF_Msk = 0x2
	// Bit REOCF.
	DFSDM_DFSDM1_ISR_REOCF = 0x2
	// Position of JOVRF field.
	DFSDM_DFSDM1_ISR_JOVRF_Pos = 0x2
	// Bit mask of JOVRF field.
	DFSDM_DFSDM1_ISR_JOVRF_Msk = 0x4
	// Bit JOVRF.
	DFSDM_DFSDM1_ISR_JOVRF = 0x4
	// Position of ROVRF field.
	DFSDM_DFSDM1_ISR_ROVRF_Pos = 0x3
	// Bit mask of ROVRF field.
	DFSDM_DFSDM1_ISR_ROVRF_Msk = 0x8
	// Bit ROVRF.
	DFSDM_DFSDM1_ISR_ROVRF = 0x8
	// Position of AWDF field.
	DFSDM_DFSDM1_ISR_AWDF_Pos = 0x4
	// Bit mask of AWDF field.
	DFSDM_DFSDM1_ISR_AWDF_Msk = 0x10
	// Bit AWDF.
	DFSDM_DFSDM1_ISR_AWDF = 0x10
	// Position of JCIP field.
	DFSDM_DFSDM1_ISR_JCIP_Pos = 0xd
	// Bit mask of JCIP field.
	DFSDM_DFSDM1_ISR_JCIP_Msk = 0x2000
	// Bit JCIP.
	DFSDM_DFSDM1_ISR_JCIP = 0x2000
	// Position of RCIP field.
	DFSDM_DFSDM1_ISR_RCIP_Pos = 0xe
	// Bit mask of RCIP field.
	DFSDM_DFSDM1_ISR_RCIP_Msk = 0x4000
	// Bit RCIP.
	DFSDM_DFSDM1_ISR_RCIP = 0x4000
	// Position of CKABF field.
	DFSDM_DFSDM1_ISR_CKABF_Pos = 0x10
	// Bit mask of CKABF field.
	DFSDM_DFSDM1_ISR_CKABF_Msk = 0xff0000
	// Position of SCDF field.
	DFSDM_DFSDM1_ISR_SCDF_Pos = 0x18
	// Bit mask of SCDF field.
	DFSDM_DFSDM1_ISR_SCDF_Msk = 0xff000000

	// DFSDM1_ICR: DFSDM interrupt flag clear register
	// Position of CLRJOVRF field.
	DFSDM_DFSDM1_ICR_CLRJOVRF_Pos = 0x2
	// Bit mask of CLRJOVRF field.
	DFSDM_DFSDM1_ICR_CLRJOVRF_Msk = 0x4
	// Bit CLRJOVRF.
	DFSDM_DFSDM1_ICR_CLRJOVRF = 0x4
	// Position of CLRROVRF field.
	DFSDM_DFSDM1_ICR_CLRROVRF_Pos = 0x3
	// Bit mask of CLRROVRF field.
	DFSDM_DFSDM1_ICR_CLRROVRF_Msk = 0x8
	// Bit CLRROVRF.
	DFSDM_DFSDM1_ICR_CLRROVRF = 0x8
	// Position of CLRCKABF field.
	DFSDM_DFSDM1_ICR_CLRCKABF_Pos = 0x10
	// Bit mask of CLRCKABF field.
	DFSDM_DFSDM1_ICR_CLRCKABF_Msk = 0xff0000
	// Position of CLRSCDF field.
	DFSDM_DFSDM1_ICR_CLRSCDF_Pos = 0x18
	// Bit mask of CLRSCDF field.
	DFSDM_DFSDM1_ICR_CLRSCDF_Msk = 0xff000000

	// DFSDM1_JCHGR: DFSDM injected channel group selection register
	// Position of JCHG field.
	DFSDM_DFSDM1_JCHGR_JCHG_Pos = 0x0
	// Bit mask of JCHG field.
	DFSDM_DFSDM1_JCHGR_JCHG_Msk = 0xff

	// DFSDM1_FCR: DFSDM filter control register
	// Position of IOSR field.
	DFSDM_DFSDM1_FCR_IOSR_Pos = 0x0
	// Bit mask of IOSR field.
	DFSDM_DFSDM1_FCR_IOSR_Msk = 0xff
	// Position of FOSR field.
	DFSDM_DFSDM1_FCR_FOSR_Pos = 0x10
	// Bit mask of FOSR field.
	DFSDM_DFSDM1_FCR_FOSR_Msk = 0x3ff0000
	// Position of FORD field.
	DFSDM_DFSDM1_FCR_FORD_Pos = 0x1d
	// Bit mask of FORD field.
	DFSDM_DFSDM1_FCR_FORD_Msk = 0xe0000000

	// DFSDM1_JDATAR: DFSDM data register for injected group
	// Position of JDATACH field.
	DFSDM_DFSDM1_JDATAR_JDATACH_Pos = 0x0
	// Bit mask of JDATACH field.
	DFSDM_DFSDM1_JDATAR_JDATACH_Msk = 0x7
	// Position of JDATA field.
	DFSDM_DFSDM1_JDATAR_JDATA_Pos = 0x8
	// Bit mask of JDATA field.
	DFSDM_DFSDM1_JDATAR_JDATA_Msk = 0xffffff00

	// DFSDM1_RDATAR: DFSDM data register for the regular channel
	// Position of RDATACH field.
	DFSDM_DFSDM1_RDATAR_RDATACH_Pos = 0x0
	// Bit mask of RDATACH field.
	DFSDM_DFSDM1_RDATAR_RDATACH_Msk = 0x7
	// Position of RPEND field.
	DFSDM_DFSDM1_RDATAR_RPEND_Pos = 0x4
	// Bit mask of RPEND field.
	DFSDM_DFSDM1_RDATAR_RPEND_Msk = 0x10
	// Bit RPEND.
	DFSDM_DFSDM1_RDATAR_RPEND = 0x10
	// Position of RDATA field.
	DFSDM_DFSDM1_RDATAR_RDATA_Pos = 0x8
	// Bit mask of RDATA field.
	DFSDM_DFSDM1_RDATAR_RDATA_Msk = 0xffffff00

	// DFSDM1_AWHTR: DFSDM analog watchdog high threshold register
	// Position of BKAWH field.
	DFSDM_DFSDM1_AWHTR_BKAWH_Pos = 0x0
	// Bit mask of BKAWH field.
	DFSDM_DFSDM1_AWHTR_BKAWH_Msk = 0xf
	// Position of AWHT field.
	DFSDM_DFSDM1_AWHTR_AWHT_Pos = 0x8
	// Bit mask of AWHT field.
	DFSDM_DFSDM1_AWHTR_AWHT_Msk = 0xffffff00

	// DFSDM1_AWLTR: DFSDM analog watchdog low threshold register
	// Position of BKAWL field.
	DFSDM_DFSDM1_AWLTR_BKAWL_Pos = 0x0
	// Bit mask of BKAWL field.
	DFSDM_DFSDM1_AWLTR_BKAWL_Msk = 0xf
	// Position of AWLT field.
	DFSDM_DFSDM1_AWLTR_AWLT_Pos = 0x8
	// Bit mask of AWLT field.
	DFSDM_DFSDM1_AWLTR_AWLT_Msk = 0xffffff00

	// DFSDM1_AWSR: DFSDM analog watchdog status register
	// Position of AWLTF field.
	DFSDM_DFSDM1_AWSR_AWLTF_Pos = 0x0
	// Bit mask of AWLTF field.
	DFSDM_DFSDM1_AWSR_AWLTF_Msk = 0xff
	// Position of AWHTF field.
	DFSDM_DFSDM1_AWSR_AWHTF_Pos = 0x8
	// Bit mask of AWHTF field.
	DFSDM_DFSDM1_AWSR_AWHTF_Msk = 0xff00

	// DFSDM1_AWCFR: DFSDM analog watchdog clear flag register
	// Position of CLRAWLTF field.
	DFSDM_DFSDM1_AWCFR_CLRAWLTF_Pos = 0x0
	// Bit mask of CLRAWLTF field.
	DFSDM_DFSDM1_AWCFR_CLRAWLTF_Msk = 0xff
	// Position of CLRAWHTF field.
	DFSDM_DFSDM1_AWCFR_CLRAWHTF_Pos = 0x8
	// Bit mask of CLRAWHTF field.
	DFSDM_DFSDM1_AWCFR_CLRAWHTF_Msk = 0xff00

	// DFSDM1_EXMAX: DFSDM Extremes detector maximum register
	// Position of EXMAXCH field.
	DFSDM_DFSDM1_EXMAX_EXMAXCH_Pos = 0x0
	// Bit mask of EXMAXCH field.
	DFSDM_DFSDM1_EXMAX_EXMAXCH_Msk = 0x7
	// Position of EXMAX field.
	DFSDM_DFSDM1_EXMAX_EXMAX_Pos = 0x8
	// Bit mask of EXMAX field.
	DFSDM_DFSDM1_EXMAX_EXMAX_Msk = 0xffffff00

	// DFSDM1_EXMIN: DFSDM Extremes detector minimum register
	// Position of EXMINCH field.
	DFSDM_DFSDM1_EXMIN_EXMINCH_Pos = 0x0
	// Bit mask of EXMINCH field.
	DFSDM_DFSDM1_EXMIN_EXMINCH_Msk = 0x7
	// Position of EXMIN field.
	DFSDM_DFSDM1_EXMIN_EXMIN_Pos = 0x8
	// Bit mask of EXMIN field.
	DFSDM_DFSDM1_EXMIN_EXMIN_Msk = 0xffffff00

	// DFSDM1_CNVTIMR: DFSDM conversion timer register
	// Position of CNVCNT field.
	DFSDM_DFSDM1_CNVTIMR_CNVCNT_Pos = 0x4
	// Bit mask of CNVCNT field.
	DFSDM_DFSDM1_CNVTIMR_CNVCNT_Msk = 0xfffffff0

	// DFSDM2_CR1: DFSDM control register 1
	// Position of DFEN field.
	DFSDM_DFSDM2_CR1_DFEN_Pos = 0x0
	// Bit mask of DFEN field.
	DFSDM_DFSDM2_CR1_DFEN_Msk = 0x1
	// Bit DFEN.
	DFSDM_DFSDM2_CR1_DFEN = 0x1
	// Position of JSWSTART field.
	DFSDM_DFSDM2_CR1_JSWSTART_Pos = 0x1
	// Bit mask of JSWSTART field.
	DFSDM_DFSDM2_CR1_JSWSTART_Msk = 0x2
	// Bit JSWSTART.
	DFSDM_DFSDM2_CR1_JSWSTART = 0x2
	// Position of JSYNC field.
	DFSDM_DFSDM2_CR1_JSYNC_Pos = 0x3
	// Bit mask of JSYNC field.
	DFSDM_DFSDM2_CR1_JSYNC_Msk = 0x8
	// Bit JSYNC.
	DFSDM_DFSDM2_CR1_JSYNC = 0x8
	// Position of JSCAN field.
	DFSDM_DFSDM2_CR1_JSCAN_Pos = 0x4
	// Bit mask of JSCAN field.
	DFSDM_DFSDM2_CR1_JSCAN_Msk = 0x10
	// Bit JSCAN.
	DFSDM_DFSDM2_CR1_JSCAN = 0x10
	// Position of JDMAEN field.
	DFSDM_DFSDM2_CR1_JDMAEN_Pos = 0x5
	// Bit mask of JDMAEN field.
	DFSDM_DFSDM2_CR1_JDMAEN_Msk = 0x20
	// Bit JDMAEN.
	DFSDM_DFSDM2_CR1_JDMAEN = 0x20
	// Position of JEXTSEL field.
	DFSDM_DFSDM2_CR1_JEXTSEL_Pos = 0x8
	// Bit mask of JEXTSEL field.
	DFSDM_DFSDM2_CR1_JEXTSEL_Msk = 0x1f00
	// Position of JEXTEN field.
	DFSDM_DFSDM2_CR1_JEXTEN_Pos = 0xd
	// Bit mask of JEXTEN field.
	DFSDM_DFSDM2_CR1_JEXTEN_Msk = 0x6000
	// Position of RSWSTART field.
	DFSDM_DFSDM2_CR1_RSWSTART_Pos = 0x11
	// Bit mask of RSWSTART field.
	DFSDM_DFSDM2_CR1_RSWSTART_Msk = 0x20000
	// Bit RSWSTART.
	DFSDM_DFSDM2_CR1_RSWSTART = 0x20000
	// Position of RCONT field.
	DFSDM_DFSDM2_CR1_RCONT_Pos = 0x12
	// Bit mask of RCONT field.
	DFSDM_DFSDM2_CR1_RCONT_Msk = 0x40000
	// Bit RCONT.
	DFSDM_DFSDM2_CR1_RCONT = 0x40000
	// Position of RSYNC field.
	DFSDM_DFSDM2_CR1_RSYNC_Pos = 0x13
	// Bit mask of RSYNC field.
	DFSDM_DFSDM2_CR1_RSYNC_Msk = 0x80000
	// Bit RSYNC.
	DFSDM_DFSDM2_CR1_RSYNC = 0x80000
	// Position of RDMAEN field.
	DFSDM_DFSDM2_CR1_RDMAEN_Pos = 0x15
	// Bit mask of RDMAEN field.
	DFSDM_DFSDM2_CR1_RDMAEN_Msk = 0x200000
	// Bit RDMAEN.
	DFSDM_DFSDM2_CR1_RDMAEN = 0x200000
	// Position of RCH field.
	DFSDM_DFSDM2_CR1_RCH_Pos = 0x18
	// Bit mask of RCH field.
	DFSDM_DFSDM2_CR1_RCH_Msk = 0x7000000
	// Position of FAST field.
	DFSDM_DFSDM2_CR1_FAST_Pos = 0x1d
	// Bit mask of FAST field.
	DFSDM_DFSDM2_CR1_FAST_Msk = 0x20000000
	// Bit FAST.
	DFSDM_DFSDM2_CR1_FAST = 0x20000000
	// Position of AWFSEL field.
	DFSDM_DFSDM2_CR1_AWFSEL_Pos = 0x1e
	// Bit mask of AWFSEL field.
	DFSDM_DFSDM2_CR1_AWFSEL_Msk = 0x40000000
	// Bit AWFSEL.
	DFSDM_DFSDM2_CR1_AWFSEL = 0x40000000

	// DFSDM2_CR2: DFSDM control register 2
	// Position of JEOCIE field.
	DFSDM_DFSDM2_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_DFSDM2_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_DFSDM2_CR2_JEOCIE = 0x1
	// Position of REOCIE field.
	DFSDM_DFSDM2_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_DFSDM2_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_DFSDM2_CR2_REOCIE = 0x2
	// Position of JOVRIE field.
	DFSDM_DFSDM2_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_DFSDM2_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_DFSDM2_CR2_JOVRIE = 0x4
	// Position of ROVRIE field.
	DFSDM_DFSDM2_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_DFSDM2_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_DFSDM2_CR2_ROVRIE = 0x8
	// Position of AWDIE field.
	DFSDM_DFSDM2_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_DFSDM2_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_DFSDM2_CR2_AWDIE = 0x10
	// Position of SCDIE field.
	DFSDM_DFSDM2_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_DFSDM2_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_DFSDM2_CR2_SCDIE = 0x20
	// Position of CKABIE field.
	DFSDM_DFSDM2_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_DFSDM2_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_DFSDM2_CR2_CKABIE = 0x40
	// Position of EXCH field.
	DFSDM_DFSDM2_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_DFSDM2_CR2_EXCH_Msk = 0xff00
	// Position of AWDCH field.
	DFSDM_DFSDM2_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_DFSDM2_CR2_AWDCH_Msk = 0xff0000

	// DFSDM2_ISR: DFSDM interrupt and status register
	// Position of JEOCF field.
	DFSDM_DFSDM2_ISR_JEOCF_Pos = 0x0
	// Bit mask of JEOCF field.
	DFSDM_DFSDM2_ISR_JEOCF_Msk = 0x1
	// Bit JEOCF.
	DFSDM_DFSDM2_ISR_JEOCF = 0x1
	// Position of REOCF field.
	DFSDM_DFSDM2_ISR_REOCF_Pos = 0x1
	// Bit mask of REOCF field.
	DFSDM_DFSDM2_ISR_REOCF_Msk = 0x2
	// Bit REOCF.
	DFSDM_DFSDM2_ISR_REOCF = 0x2
	// Position of JOVRF field.
	DFSDM_DFSDM2_ISR_JOVRF_Pos = 0x2
	// Bit mask of JOVRF field.
	DFSDM_DFSDM2_ISR_JOVRF_Msk = 0x4
	// Bit JOVRF.
	DFSDM_DFSDM2_ISR_JOVRF = 0x4
	// Position of ROVRF field.
	DFSDM_DFSDM2_ISR_ROVRF_Pos = 0x3
	// Bit mask of ROVRF field.
	DFSDM_DFSDM2_ISR_ROVRF_Msk = 0x8
	// Bit ROVRF.
	DFSDM_DFSDM2_ISR_ROVRF = 0x8
	// Position of AWDF field.
	DFSDM_DFSDM2_ISR_AWDF_Pos = 0x4
	// Bit mask of AWDF field.
	DFSDM_DFSDM2_ISR_AWDF_Msk = 0x10
	// Bit AWDF.
	DFSDM_DFSDM2_ISR_AWDF = 0x10
	// Position of JCIP field.
	DFSDM_DFSDM2_ISR_JCIP_Pos = 0xd
	// Bit mask of JCIP field.
	DFSDM_DFSDM2_ISR_JCIP_Msk = 0x2000
	// Bit JCIP.
	DFSDM_DFSDM2_ISR_JCIP = 0x2000
	// Position of RCIP field.
	DFSDM_DFSDM2_ISR_RCIP_Pos = 0xe
	// Bit mask of RCIP field.
	DFSDM_DFSDM2_ISR_RCIP_Msk = 0x4000
	// Bit RCIP.
	DFSDM_DFSDM2_ISR_RCIP = 0x4000
	// Position of CKABF field.
	DFSDM_DFSDM2_ISR_CKABF_Pos = 0x10
	// Bit mask of CKABF field.
	DFSDM_DFSDM2_ISR_CKABF_Msk = 0xff0000
	// Position of SCDF field.
	DFSDM_DFSDM2_ISR_SCDF_Pos = 0x18
	// Bit mask of SCDF field.
	DFSDM_DFSDM2_ISR_SCDF_Msk = 0xff000000

	// DFSDM2_ICR: DFSDM interrupt flag clear register
	// Position of CLRJOVRF field.
	DFSDM_DFSDM2_ICR_CLRJOVRF_Pos = 0x2
	// Bit mask of CLRJOVRF field.
	DFSDM_DFSDM2_ICR_CLRJOVRF_Msk = 0x4
	// Bit CLRJOVRF.
	DFSDM_DFSDM2_ICR_CLRJOVRF = 0x4
	// Position of CLRROVRF field.
	DFSDM_DFSDM2_ICR_CLRROVRF_Pos = 0x3
	// Bit mask of CLRROVRF field.
	DFSDM_DFSDM2_ICR_CLRROVRF_Msk = 0x8
	// Bit CLRROVRF.
	DFSDM_DFSDM2_ICR_CLRROVRF = 0x8
	// Position of CLRCKABF field.
	DFSDM_DFSDM2_ICR_CLRCKABF_Pos = 0x10
	// Bit mask of CLRCKABF field.
	DFSDM_DFSDM2_ICR_CLRCKABF_Msk = 0xff0000
	// Position of CLRSCDF field.
	DFSDM_DFSDM2_ICR_CLRSCDF_Pos = 0x18
	// Bit mask of CLRSCDF field.
	DFSDM_DFSDM2_ICR_CLRSCDF_Msk = 0xff000000

	// DFSDM2_JCHGR: DFSDM injected channel group selection register
	// Position of JCHG field.
	DFSDM_DFSDM2_JCHGR_JCHG_Pos = 0x0
	// Bit mask of JCHG field.
	DFSDM_DFSDM2_JCHGR_JCHG_Msk = 0xff

	// DFSDM2_FCR: DFSDM filter control register
	// Position of IOSR field.
	DFSDM_DFSDM2_FCR_IOSR_Pos = 0x0
	// Bit mask of IOSR field.
	DFSDM_DFSDM2_FCR_IOSR_Msk = 0xff
	// Position of FOSR field.
	DFSDM_DFSDM2_FCR_FOSR_Pos = 0x10
	// Bit mask of FOSR field.
	DFSDM_DFSDM2_FCR_FOSR_Msk = 0x3ff0000
	// Position of FORD field.
	DFSDM_DFSDM2_FCR_FORD_Pos = 0x1d
	// Bit mask of FORD field.
	DFSDM_DFSDM2_FCR_FORD_Msk = 0xe0000000

	// DFSDM2_JDATAR: DFSDM data register for injected group
	// Position of JDATACH field.
	DFSDM_DFSDM2_JDATAR_JDATACH_Pos = 0x0
	// Bit mask of JDATACH field.
	DFSDM_DFSDM2_JDATAR_JDATACH_Msk = 0x7
	// Position of JDATA field.
	DFSDM_DFSDM2_JDATAR_JDATA_Pos = 0x8
	// Bit mask of JDATA field.
	DFSDM_DFSDM2_JDATAR_JDATA_Msk = 0xffffff00

	// DFSDM2_RDATAR: DFSDM data register for the regular channel
	// Position of RDATACH field.
	DFSDM_DFSDM2_RDATAR_RDATACH_Pos = 0x0
	// Bit mask of RDATACH field.
	DFSDM_DFSDM2_RDATAR_RDATACH_Msk = 0x7
	// Position of RPEND field.
	DFSDM_DFSDM2_RDATAR_RPEND_Pos = 0x4
	// Bit mask of RPEND field.
	DFSDM_DFSDM2_RDATAR_RPEND_Msk = 0x10
	// Bit RPEND.
	DFSDM_DFSDM2_RDATAR_RPEND = 0x10
	// Position of RDATA field.
	DFSDM_DFSDM2_RDATAR_RDATA_Pos = 0x8
	// Bit mask of RDATA field.
	DFSDM_DFSDM2_RDATAR_RDATA_Msk = 0xffffff00

	// DFSDM2_AWHTR: DFSDM analog watchdog high threshold register
	// Position of BKAWH field.
	DFSDM_DFSDM2_AWHTR_BKAWH_Pos = 0x0
	// Bit mask of BKAWH field.
	DFSDM_DFSDM2_AWHTR_BKAWH_Msk = 0xf
	// Position of AWHT field.
	DFSDM_DFSDM2_AWHTR_AWHT_Pos = 0x8
	// Bit mask of AWHT field.
	DFSDM_DFSDM2_AWHTR_AWHT_Msk = 0xffffff00

	// DFSDM2_AWLTR: DFSDM analog watchdog low threshold register
	// Position of BKAWL field.
	DFSDM_DFSDM2_AWLTR_BKAWL_Pos = 0x0
	// Bit mask of BKAWL field.
	DFSDM_DFSDM2_AWLTR_BKAWL_Msk = 0xf
	// Position of AWLT field.
	DFSDM_DFSDM2_AWLTR_AWLT_Pos = 0x8
	// Bit mask of AWLT field.
	DFSDM_DFSDM2_AWLTR_AWLT_Msk = 0xffffff00

	// DFSDM2_AWSR: DFSDM analog watchdog status register
	// Position of AWLTF field.
	DFSDM_DFSDM2_AWSR_AWLTF_Pos = 0x0
	// Bit mask of AWLTF field.
	DFSDM_DFSDM2_AWSR_AWLTF_Msk = 0xff
	// Position of AWHTF field.
	DFSDM_DFSDM2_AWSR_AWHTF_Pos = 0x8
	// Bit mask of AWHTF field.
	DFSDM_DFSDM2_AWSR_AWHTF_Msk = 0xff00

	// DFSDM2_AWCFR: DFSDM analog watchdog clear flag register
	// Position of CLRAWLTF field.
	DFSDM_DFSDM2_AWCFR_CLRAWLTF_Pos = 0x0
	// Bit mask of CLRAWLTF field.
	DFSDM_DFSDM2_AWCFR_CLRAWLTF_Msk = 0xff
	// Position of CLRAWHTF field.
	DFSDM_DFSDM2_AWCFR_CLRAWHTF_Pos = 0x8
	// Bit mask of CLRAWHTF field.
	DFSDM_DFSDM2_AWCFR_CLRAWHTF_Msk = 0xff00

	// DFSDM2_EXMAX: DFSDM Extremes detector maximum register
	// Position of EXMAXCH field.
	DFSDM_DFSDM2_EXMAX_EXMAXCH_Pos = 0x0
	// Bit mask of EXMAXCH field.
	DFSDM_DFSDM2_EXMAX_EXMAXCH_Msk = 0x7
	// Position of EXMAX field.
	DFSDM_DFSDM2_EXMAX_EXMAX_Pos = 0x8
	// Bit mask of EXMAX field.
	DFSDM_DFSDM2_EXMAX_EXMAX_Msk = 0xffffff00

	// DFSDM2_EXMIN: DFSDM Extremes detector minimum register
	// Position of EXMINCH field.
	DFSDM_DFSDM2_EXMIN_EXMINCH_Pos = 0x0
	// Bit mask of EXMINCH field.
	DFSDM_DFSDM2_EXMIN_EXMINCH_Msk = 0x7
	// Position of EXMIN field.
	DFSDM_DFSDM2_EXMIN_EXMIN_Pos = 0x8
	// Bit mask of EXMIN field.
	DFSDM_DFSDM2_EXMIN_EXMIN_Msk = 0xffffff00

	// DFSDM2_CNVTIMR: DFSDM conversion timer register
	// Position of CNVCNT field.
	DFSDM_DFSDM2_CNVTIMR_CNVCNT_Pos = 0x4
	// Bit mask of CNVCNT field.
	DFSDM_DFSDM2_CNVTIMR_CNVCNT_Msk = 0xfffffff0

	// DFSDM3_AWHTR: DFSDM analog watchdog high threshold register
	// Position of BKAWH field.
	DFSDM_DFSDM3_AWHTR_BKAWH_Pos = 0x0
	// Bit mask of BKAWH field.
	DFSDM_DFSDM3_AWHTR_BKAWH_Msk = 0xf
	// Position of AWHT field.
	DFSDM_DFSDM3_AWHTR_AWHT_Pos = 0x8
	// Bit mask of AWHT field.
	DFSDM_DFSDM3_AWHTR_AWHT_Msk = 0xffffff00

	// DFSDM3_AWLTR: DFSDM analog watchdog low threshold register
	// Position of BKAWL field.
	DFSDM_DFSDM3_AWLTR_BKAWL_Pos = 0x0
	// Bit mask of BKAWL field.
	DFSDM_DFSDM3_AWLTR_BKAWL_Msk = 0xf
	// Position of AWLT field.
	DFSDM_DFSDM3_AWLTR_AWLT_Pos = 0x8
	// Bit mask of AWLT field.
	DFSDM_DFSDM3_AWLTR_AWLT_Msk = 0xffffff00

	// DFSDM3_AWSR: DFSDM analog watchdog status register
	// Position of AWLTF field.
	DFSDM_DFSDM3_AWSR_AWLTF_Pos = 0x0
	// Bit mask of AWLTF field.
	DFSDM_DFSDM3_AWSR_AWLTF_Msk = 0xff
	// Position of AWHTF field.
	DFSDM_DFSDM3_AWSR_AWHTF_Pos = 0x8
	// Bit mask of AWHTF field.
	DFSDM_DFSDM3_AWSR_AWHTF_Msk = 0xff00

	// DFSDM3_AWCFR: DFSDM analog watchdog clear flag register
	// Position of CLRAWLTF field.
	DFSDM_DFSDM3_AWCFR_CLRAWLTF_Pos = 0x0
	// Bit mask of CLRAWLTF field.
	DFSDM_DFSDM3_AWCFR_CLRAWLTF_Msk = 0xff
	// Position of CLRAWHTF field.
	DFSDM_DFSDM3_AWCFR_CLRAWHTF_Pos = 0x8
	// Bit mask of CLRAWHTF field.
	DFSDM_DFSDM3_AWCFR_CLRAWHTF_Msk = 0xff00

	// DFSDM3_EXMAX: DFSDM Extremes detector maximum register
	// Position of EXMAXCH field.
	DFSDM_DFSDM3_EXMAX_EXMAXCH_Pos = 0x0
	// Bit mask of EXMAXCH field.
	DFSDM_DFSDM3_EXMAX_EXMAXCH_Msk = 0x7
	// Position of EXMAX field.
	DFSDM_DFSDM3_EXMAX_EXMAX_Pos = 0x8
	// Bit mask of EXMAX field.
	DFSDM_DFSDM3_EXMAX_EXMAX_Msk = 0xffffff00

	// DFSDM3_EXMIN: DFSDM Extremes detector minimum register
	// Position of EXMINCH field.
	DFSDM_DFSDM3_EXMIN_EXMINCH_Pos = 0x0
	// Bit mask of EXMINCH field.
	DFSDM_DFSDM3_EXMIN_EXMINCH_Msk = 0x7
	// Position of EXMIN field.
	DFSDM_DFSDM3_EXMIN_EXMIN_Pos = 0x8
	// Bit mask of EXMIN field.
	DFSDM_DFSDM3_EXMIN_EXMIN_Msk = 0xffffff00

	// DFSDM3_CNVTIMR: DFSDM conversion timer register
	// Position of CNVCNT field.
	DFSDM_DFSDM3_CNVTIMR_CNVCNT_Pos = 0x4
	// Bit mask of CNVCNT field.
	DFSDM_DFSDM3_CNVTIMR_CNVCNT_Msk = 0xfffffff0

	// DFSDM3_JCHGR: DFSDM injected channel group selection register
	// Position of JCHG field.
	DFSDM_DFSDM3_JCHGR_JCHG_Pos = 0x0
	// Bit mask of JCHG field.
	DFSDM_DFSDM3_JCHGR_JCHG_Msk = 0xff

	// DFSDM3_FCR: DFSDM filter control register
	// Position of IOSR field.
	DFSDM_DFSDM3_FCR_IOSR_Pos = 0x0
	// Bit mask of IOSR field.
	DFSDM_DFSDM3_FCR_IOSR_Msk = 0xff
	// Position of FOSR field.
	DFSDM_DFSDM3_FCR_FOSR_Pos = 0x10
	// Bit mask of FOSR field.
	DFSDM_DFSDM3_FCR_FOSR_Msk = 0x3ff0000
	// Position of FORD field.
	DFSDM_DFSDM3_FCR_FORD_Pos = 0x1d
	// Bit mask of FORD field.
	DFSDM_DFSDM3_FCR_FORD_Msk = 0xe0000000

	// DFSDM3_JDATAR: DFSDM data register for injected group
	// Position of JDATACH field.
	DFSDM_DFSDM3_JDATAR_JDATACH_Pos = 0x0
	// Bit mask of JDATACH field.
	DFSDM_DFSDM3_JDATAR_JDATACH_Msk = 0x7
	// Position of JDATA field.
	DFSDM_DFSDM3_JDATAR_JDATA_Pos = 0x8
	// Bit mask of JDATA field.
	DFSDM_DFSDM3_JDATAR_JDATA_Msk = 0xffffff00

	// DFSDM3_RDATAR: DFSDM data register for the regular channel
	// Position of RDATACH field.
	DFSDM_DFSDM3_RDATAR_RDATACH_Pos = 0x0
	// Bit mask of RDATACH field.
	DFSDM_DFSDM3_RDATAR_RDATACH_Msk = 0x7
	// Position of RPEND field.
	DFSDM_DFSDM3_RDATAR_RPEND_Pos = 0x4
	// Bit mask of RPEND field.
	DFSDM_DFSDM3_RDATAR_RPEND_Msk = 0x10
	// Bit RPEND.
	DFSDM_DFSDM3_RDATAR_RPEND = 0x10
	// Position of RDATA field.
	DFSDM_DFSDM3_RDATAR_RDATA_Pos = 0x8
	// Bit mask of RDATA field.
	DFSDM_DFSDM3_RDATAR_RDATA_Msk = 0xffffff00

	// DFSDM3_CR1: DFSDM control register 1
	// Position of DFEN field.
	DFSDM_DFSDM3_CR1_DFEN_Pos = 0x0
	// Bit mask of DFEN field.
	DFSDM_DFSDM3_CR1_DFEN_Msk = 0x1
	// Bit DFEN.
	DFSDM_DFSDM3_CR1_DFEN = 0x1
	// Position of JSWSTART field.
	DFSDM_DFSDM3_CR1_JSWSTART_Pos = 0x1
	// Bit mask of JSWSTART field.
	DFSDM_DFSDM3_CR1_JSWSTART_Msk = 0x2
	// Bit JSWSTART.
	DFSDM_DFSDM3_CR1_JSWSTART = 0x2
	// Position of JSYNC field.
	DFSDM_DFSDM3_CR1_JSYNC_Pos = 0x3
	// Bit mask of JSYNC field.
	DFSDM_DFSDM3_CR1_JSYNC_Msk = 0x8
	// Bit JSYNC.
	DFSDM_DFSDM3_CR1_JSYNC = 0x8
	// Position of JSCAN field.
	DFSDM_DFSDM3_CR1_JSCAN_Pos = 0x4
	// Bit mask of JSCAN field.
	DFSDM_DFSDM3_CR1_JSCAN_Msk = 0x10
	// Bit JSCAN.
	DFSDM_DFSDM3_CR1_JSCAN = 0x10
	// Position of JDMAEN field.
	DFSDM_DFSDM3_CR1_JDMAEN_Pos = 0x5
	// Bit mask of JDMAEN field.
	DFSDM_DFSDM3_CR1_JDMAEN_Msk = 0x20
	// Bit JDMAEN.
	DFSDM_DFSDM3_CR1_JDMAEN = 0x20
	// Position of JEXTSEL field.
	DFSDM_DFSDM3_CR1_JEXTSEL_Pos = 0x8
	// Bit mask of JEXTSEL field.
	DFSDM_DFSDM3_CR1_JEXTSEL_Msk = 0x1f00
	// Position of JEXTEN field.
	DFSDM_DFSDM3_CR1_JEXTEN_Pos = 0xd
	// Bit mask of JEXTEN field.
	DFSDM_DFSDM3_CR1_JEXTEN_Msk = 0x6000
	// Position of RSWSTART field.
	DFSDM_DFSDM3_CR1_RSWSTART_Pos = 0x11
	// Bit mask of RSWSTART field.
	DFSDM_DFSDM3_CR1_RSWSTART_Msk = 0x20000
	// Bit RSWSTART.
	DFSDM_DFSDM3_CR1_RSWSTART = 0x20000
	// Position of RCONT field.
	DFSDM_DFSDM3_CR1_RCONT_Pos = 0x12
	// Bit mask of RCONT field.
	DFSDM_DFSDM3_CR1_RCONT_Msk = 0x40000
	// Bit RCONT.
	DFSDM_DFSDM3_CR1_RCONT = 0x40000
	// Position of RSYNC field.
	DFSDM_DFSDM3_CR1_RSYNC_Pos = 0x13
	// Bit mask of RSYNC field.
	DFSDM_DFSDM3_CR1_RSYNC_Msk = 0x80000
	// Bit RSYNC.
	DFSDM_DFSDM3_CR1_RSYNC = 0x80000
	// Position of RDMAEN field.
	DFSDM_DFSDM3_CR1_RDMAEN_Pos = 0x15
	// Bit mask of RDMAEN field.
	DFSDM_DFSDM3_CR1_RDMAEN_Msk = 0x200000
	// Bit RDMAEN.
	DFSDM_DFSDM3_CR1_RDMAEN = 0x200000
	// Position of RCH field.
	DFSDM_DFSDM3_CR1_RCH_Pos = 0x18
	// Bit mask of RCH field.
	DFSDM_DFSDM3_CR1_RCH_Msk = 0x7000000
	// Position of FAST field.
	DFSDM_DFSDM3_CR1_FAST_Pos = 0x1d
	// Bit mask of FAST field.
	DFSDM_DFSDM3_CR1_FAST_Msk = 0x20000000
	// Bit FAST.
	DFSDM_DFSDM3_CR1_FAST = 0x20000000
	// Position of AWFSEL field.
	DFSDM_DFSDM3_CR1_AWFSEL_Pos = 0x1e
	// Bit mask of AWFSEL field.
	DFSDM_DFSDM3_CR1_AWFSEL_Msk = 0x40000000
	// Bit AWFSEL.
	DFSDM_DFSDM3_CR1_AWFSEL = 0x40000000

	// DFSDM3_CR2: DFSDM control register 2
	// Position of JEOCIE field.
	DFSDM_DFSDM3_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_DFSDM3_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_DFSDM3_CR2_JEOCIE = 0x1
	// Position of REOCIE field.
	DFSDM_DFSDM3_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_DFSDM3_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_DFSDM3_CR2_REOCIE = 0x2
	// Position of JOVRIE field.
	DFSDM_DFSDM3_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_DFSDM3_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_DFSDM3_CR2_JOVRIE = 0x4
	// Position of ROVRIE field.
	DFSDM_DFSDM3_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_DFSDM3_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_DFSDM3_CR2_ROVRIE = 0x8
	// Position of AWDIE field.
	DFSDM_DFSDM3_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_DFSDM3_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_DFSDM3_CR2_AWDIE = 0x10
	// Position of SCDIE field.
	DFSDM_DFSDM3_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_DFSDM3_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_DFSDM3_CR2_SCDIE = 0x20
	// Position of CKABIE field.
	DFSDM_DFSDM3_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_DFSDM3_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_DFSDM3_CR2_CKABIE = 0x40
	// Position of EXCH field.
	DFSDM_DFSDM3_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_DFSDM3_CR2_EXCH_Msk = 0xff00
	// Position of AWDCH field.
	DFSDM_DFSDM3_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_DFSDM3_CR2_AWDCH_Msk = 0xff0000

	// DFSDM3_ISR: DFSDM interrupt and status register
	// Position of JEOCF field.
	DFSDM_DFSDM3_ISR_JEOCF_Pos = 0x0
	// Bit mask of JEOCF field.
	DFSDM_DFSDM3_ISR_JEOCF_Msk = 0x1
	// Bit JEOCF.
	DFSDM_DFSDM3_ISR_JEOCF = 0x1
	// Position of REOCF field.
	DFSDM_DFSDM3_ISR_REOCF_Pos = 0x1
	// Bit mask of REOCF field.
	DFSDM_DFSDM3_ISR_REOCF_Msk = 0x2
	// Bit REOCF.
	DFSDM_DFSDM3_ISR_REOCF = 0x2
	// Position of JOVRF field.
	DFSDM_DFSDM3_ISR_JOVRF_Pos = 0x2
	// Bit mask of JOVRF field.
	DFSDM_DFSDM3_ISR_JOVRF_Msk = 0x4
	// Bit JOVRF.
	DFSDM_DFSDM3_ISR_JOVRF = 0x4
	// Position of ROVRF field.
	DFSDM_DFSDM3_ISR_ROVRF_Pos = 0x3
	// Bit mask of ROVRF field.
	DFSDM_DFSDM3_ISR_ROVRF_Msk = 0x8
	// Bit ROVRF.
	DFSDM_DFSDM3_ISR_ROVRF = 0x8
	// Position of AWDF field.
	DFSDM_DFSDM3_ISR_AWDF_Pos = 0x4
	// Bit mask of AWDF field.
	DFSDM_DFSDM3_ISR_AWDF_Msk = 0x10
	// Bit AWDF.
	DFSDM_DFSDM3_ISR_AWDF = 0x10
	// Position of JCIP field.
	DFSDM_DFSDM3_ISR_JCIP_Pos = 0xd
	// Bit mask of JCIP field.
	DFSDM_DFSDM3_ISR_JCIP_Msk = 0x2000
	// Bit JCIP.
	DFSDM_DFSDM3_ISR_JCIP = 0x2000
	// Position of RCIP field.
	DFSDM_DFSDM3_ISR_RCIP_Pos = 0xe
	// Bit mask of RCIP field.
	DFSDM_DFSDM3_ISR_RCIP_Msk = 0x4000
	// Bit RCIP.
	DFSDM_DFSDM3_ISR_RCIP = 0x4000
	// Position of CKABF field.
	DFSDM_DFSDM3_ISR_CKABF_Pos = 0x10
	// Bit mask of CKABF field.
	DFSDM_DFSDM3_ISR_CKABF_Msk = 0xff0000
	// Position of SCDF field.
	DFSDM_DFSDM3_ISR_SCDF_Pos = 0x18
	// Bit mask of SCDF field.
	DFSDM_DFSDM3_ISR_SCDF_Msk = 0xff000000

	// DFSDM3_ICR: DFSDM interrupt flag clear register
	// Position of CLRJOVRF field.
	DFSDM_DFSDM3_ICR_CLRJOVRF_Pos = 0x2
	// Bit mask of CLRJOVRF field.
	DFSDM_DFSDM3_ICR_CLRJOVRF_Msk = 0x4
	// Bit CLRJOVRF.
	DFSDM_DFSDM3_ICR_CLRJOVRF = 0x4
	// Position of CLRROVRF field.
	DFSDM_DFSDM3_ICR_CLRROVRF_Pos = 0x3
	// Bit mask of CLRROVRF field.
	DFSDM_DFSDM3_ICR_CLRROVRF_Msk = 0x8
	// Bit CLRROVRF.
	DFSDM_DFSDM3_ICR_CLRROVRF = 0x8
	// Position of CLRCKABF field.
	DFSDM_DFSDM3_ICR_CLRCKABF_Pos = 0x10
	// Bit mask of CLRCKABF field.
	DFSDM_DFSDM3_ICR_CLRCKABF_Msk = 0xff0000
	// Position of CLRSCDF field.
	DFSDM_DFSDM3_ICR_CLRSCDF_Pos = 0x18
	// Bit mask of CLRSCDF field.
	DFSDM_DFSDM3_ICR_CLRSCDF_Msk = 0xff000000
)

// Bitfields for JPEG: JPEG codec
const (
	// JPEG_CONFR0: JPEG codec configuration register 0
	// Position of START field.
	JPEG_JPEG_CONFR0_START_Pos = 0x0
	// Bit mask of START field.
	JPEG_JPEG_CONFR0_START_Msk = 0x1
	// Bit START.
	JPEG_JPEG_CONFR0_START = 0x1

	// JPEG_CONFR1: JPEG codec configuration register 1
	// Position of NF field.
	JPEG_JPEG_CONFR1_NF_Pos = 0x0
	// Bit mask of NF field.
	JPEG_JPEG_CONFR1_NF_Msk = 0x3
	// Position of DE field.
	JPEG_JPEG_CONFR1_DE_Pos = 0x3
	// Bit mask of DE field.
	JPEG_JPEG_CONFR1_DE_Msk = 0x8
	// Bit DE.
	JPEG_JPEG_CONFR1_DE = 0x8
	// Position of COLORSPACE field.
	JPEG_JPEG_CONFR1_COLORSPACE_Pos = 0x4
	// Bit mask of COLORSPACE field.
	JPEG_JPEG_CONFR1_COLORSPACE_Msk = 0x30
	// Position of NS field.
	JPEG_JPEG_CONFR1_NS_Pos = 0x6
	// Bit mask of NS field.
	JPEG_JPEG_CONFR1_NS_Msk = 0xc0
	// Position of HDR field.
	JPEG_JPEG_CONFR1_HDR_Pos = 0x8
	// Bit mask of HDR field.
	JPEG_JPEG_CONFR1_HDR_Msk = 0x100
	// Bit HDR.
	JPEG_JPEG_CONFR1_HDR = 0x100
	// Position of YSIZE field.
	JPEG_JPEG_CONFR1_YSIZE_Pos = 0x10
	// Bit mask of YSIZE field.
	JPEG_JPEG_CONFR1_YSIZE_Msk = 0xffff0000

	// JPEG_CONFR2: JPEG codec configuration register 2
	// Position of NMCU field.
	JPEG_JPEG_CONFR2_NMCU_Pos = 0x0
	// Bit mask of NMCU field.
	JPEG_JPEG_CONFR2_NMCU_Msk = 0x3ffffff

	// JPEG_CONFR3: JPEG codec configuration register 3
	// Position of XSIZE field.
	JPEG_JPEG_CONFR3_XSIZE_Pos = 0x10
	// Bit mask of XSIZE field.
	JPEG_JPEG_CONFR3_XSIZE_Msk = 0xffff0000

	// JPEG_CONFR4: JPEG codec configuration register 4
	// Position of HD field.
	JPEG_JPEG_CONFR4_HD_Pos = 0x0
	// Bit mask of HD field.
	JPEG_JPEG_CONFR4_HD_Msk = 0x1
	// Bit HD.
	JPEG_JPEG_CONFR4_HD = 0x1
	// Position of HA field.
	JPEG_JPEG_CONFR4_HA_Pos = 0x1
	// Bit mask of HA field.
	JPEG_JPEG_CONFR4_HA_Msk = 0x2
	// Bit HA.
	JPEG_JPEG_CONFR4_HA = 0x2
	// Position of QT field.
	JPEG_JPEG_CONFR4_QT_Pos = 0x2
	// Bit mask of QT field.
	JPEG_JPEG_CONFR4_QT_Msk = 0xc
	// Position of NB field.
	JPEG_JPEG_CONFR4_NB_Pos = 0x4
	// Bit mask of NB field.
	JPEG_JPEG_CONFR4_NB_Msk = 0xf0
	// Position of VSF field.
	JPEG_JPEG_CONFR4_VSF_Pos = 0x8
	// Bit mask of VSF field.
	JPEG_JPEG_CONFR4_VSF_Msk = 0xf00
	// Position of HSF field.
	JPEG_JPEG_CONFR4_HSF_Pos = 0xc
	// Bit mask of HSF field.
	JPEG_JPEG_CONFR4_HSF_Msk = 0xf000

	// JPEG_CONFR5: JPEG codec configuration register 5
	// Position of HD field.
	JPEG_JPEG_CONFR5_HD_Pos = 0x0
	// Bit mask of HD field.
	JPEG_JPEG_CONFR5_HD_Msk = 0x1
	// Bit HD.
	JPEG_JPEG_CONFR5_HD = 0x1
	// Position of HA field.
	JPEG_JPEG_CONFR5_HA_Pos = 0x1
	// Bit mask of HA field.
	JPEG_JPEG_CONFR5_HA_Msk = 0x2
	// Bit HA.
	JPEG_JPEG_CONFR5_HA = 0x2
	// Position of QT field.
	JPEG_JPEG_CONFR5_QT_Pos = 0x2
	// Bit mask of QT field.
	JPEG_JPEG_CONFR5_QT_Msk = 0xc
	// Position of NB field.
	JPEG_JPEG_CONFR5_NB_Pos = 0x4
	// Bit mask of NB field.
	JPEG_JPEG_CONFR5_NB_Msk = 0xf0
	// Position of VSF field.
	JPEG_JPEG_CONFR5_VSF_Pos = 0x8
	// Bit mask of VSF field.
	JPEG_JPEG_CONFR5_VSF_Msk = 0xf00
	// Position of HSF field.
	JPEG_JPEG_CONFR5_HSF_Pos = 0xc
	// Bit mask of HSF field.
	JPEG_JPEG_CONFR5_HSF_Msk = 0xf000

	// JPEG_CONFR6: JPEG codec configuration register 6
	// Position of HD field.
	JPEG_JPEG_CONFR6_HD_Pos = 0x0
	// Bit mask of HD field.
	JPEG_JPEG_CONFR6_HD_Msk = 0x1
	// Bit HD.
	JPEG_JPEG_CONFR6_HD = 0x1
	// Position of HA field.
	JPEG_JPEG_CONFR6_HA_Pos = 0x1
	// Bit mask of HA field.
	JPEG_JPEG_CONFR6_HA_Msk = 0x2
	// Bit HA.
	JPEG_JPEG_CONFR6_HA = 0x2
	// Position of QT field.
	JPEG_JPEG_CONFR6_QT_Pos = 0x2
	// Bit mask of QT field.
	JPEG_JPEG_CONFR6_QT_Msk = 0xc
	// Position of NB field.
	JPEG_JPEG_CONFR6_NB_Pos = 0x4
	// Bit mask of NB field.
	JPEG_JPEG_CONFR6_NB_Msk = 0xf0
	// Position of VSF field.
	JPEG_JPEG_CONFR6_VSF_Pos = 0x8
	// Bit mask of VSF field.
	JPEG_JPEG_CONFR6_VSF_Msk = 0xf00
	// Position of HSF field.
	JPEG_JPEG_CONFR6_HSF_Pos = 0xc
	// Bit mask of HSF field.
	JPEG_JPEG_CONFR6_HSF_Msk = 0xf000

	// JPEG_CONFR7: JPEG codec configuration register 7
	// Position of HD field.
	JPEG_JPEG_CONFR7_HD_Pos = 0x0
	// Bit mask of HD field.
	JPEG_JPEG_CONFR7_HD_Msk = 0x1
	// Bit HD.
	JPEG_JPEG_CONFR7_HD = 0x1
	// Position of HA field.
	JPEG_JPEG_CONFR7_HA_Pos = 0x1
	// Bit mask of HA field.
	JPEG_JPEG_CONFR7_HA_Msk = 0x2
	// Bit HA.
	JPEG_JPEG_CONFR7_HA = 0x2
	// Position of QT field.
	JPEG_JPEG_CONFR7_QT_Pos = 0x2
	// Bit mask of QT field.
	JPEG_JPEG_CONFR7_QT_Msk = 0xc
	// Position of NB field.
	JPEG_JPEG_CONFR7_NB_Pos = 0x4
	// Bit mask of NB field.
	JPEG_JPEG_CONFR7_NB_Msk = 0xf0
	// Position of VSF field.
	JPEG_JPEG_CONFR7_VSF_Pos = 0x8
	// Bit mask of VSF field.
	JPEG_JPEG_CONFR7_VSF_Msk = 0xf00
	// Position of HSF field.
	JPEG_JPEG_CONFR7_HSF_Pos = 0xc
	// Bit mask of HSF field.
	JPEG_JPEG_CONFR7_HSF_Msk = 0xf000

	// JPEG_CR: JPEG control register
	// Position of JCEN field.
	JPEG_JPEG_CR_JCEN_Pos = 0x0
	// Bit mask of JCEN field.
	JPEG_JPEG_CR_JCEN_Msk = 0x1
	// Bit JCEN.
	JPEG_JPEG_CR_JCEN = 0x1
	// Position of IFTIE field.
	JPEG_JPEG_CR_IFTIE_Pos = 0x1
	// Bit mask of IFTIE field.
	JPEG_JPEG_CR_IFTIE_Msk = 0x2
	// Bit IFTIE.
	JPEG_JPEG_CR_IFTIE = 0x2
	// Position of IFNFIE field.
	JPEG_JPEG_CR_IFNFIE_Pos = 0x2
	// Bit mask of IFNFIE field.
	JPEG_JPEG_CR_IFNFIE_Msk = 0x4
	// Bit IFNFIE.
	JPEG_JPEG_CR_IFNFIE = 0x4
	// Position of OFTIE field.
	JPEG_JPEG_CR_OFTIE_Pos = 0x3
	// Bit mask of OFTIE field.
	JPEG_JPEG_CR_OFTIE_Msk = 0x8
	// Bit OFTIE.
	JPEG_JPEG_CR_OFTIE = 0x8
	// Position of OFNEIE field.
	JPEG_JPEG_CR_OFNEIE_Pos = 0x4
	// Bit mask of OFNEIE field.
	JPEG_JPEG_CR_OFNEIE_Msk = 0x10
	// Bit OFNEIE.
	JPEG_JPEG_CR_OFNEIE = 0x10
	// Position of EOCIE field.
	JPEG_JPEG_CR_EOCIE_Pos = 0x5
	// Bit mask of EOCIE field.
	JPEG_JPEG_CR_EOCIE_Msk = 0x20
	// Bit EOCIE.
	JPEG_JPEG_CR_EOCIE = 0x20
	// Position of HPDIE field.
	JPEG_JPEG_CR_HPDIE_Pos = 0x6
	// Bit mask of HPDIE field.
	JPEG_JPEG_CR_HPDIE_Msk = 0x40
	// Bit HPDIE.
	JPEG_JPEG_CR_HPDIE = 0x40
	// Position of IDMAEN field.
	JPEG_JPEG_CR_IDMAEN_Pos = 0xb
	// Bit mask of IDMAEN field.
	JPEG_JPEG_CR_IDMAEN_Msk = 0x800
	// Bit IDMAEN.
	JPEG_JPEG_CR_IDMAEN = 0x800
	// Position of ODMAEN field.
	JPEG_JPEG_CR_ODMAEN_Pos = 0xc
	// Bit mask of ODMAEN field.
	JPEG_JPEG_CR_ODMAEN_Msk = 0x1000
	// Bit ODMAEN.
	JPEG_JPEG_CR_ODMAEN = 0x1000
	// Position of IFF field.
	JPEG_JPEG_CR_IFF_Pos = 0xd
	// Bit mask of IFF field.
	JPEG_JPEG_CR_IFF_Msk = 0x2000
	// Bit IFF.
	JPEG_JPEG_CR_IFF = 0x2000
	// Position of OFF field.
	JPEG_JPEG_CR_OFF_Pos = 0xe
	// Bit mask of OFF field.
	JPEG_JPEG_CR_OFF_Msk = 0x4000
	// Bit OFF.
	JPEG_JPEG_CR_OFF = 0x4000

	// JPEG_SR: JPEG status register
	// Position of IFTF field.
	JPEG_JPEG_SR_IFTF_Pos = 0x1
	// Bit mask of IFTF field.
	JPEG_JPEG_SR_IFTF_Msk = 0x2
	// Bit IFTF.
	JPEG_JPEG_SR_IFTF = 0x2
	// Position of IFNFF field.
	JPEG_JPEG_SR_IFNFF_Pos = 0x2
	// Bit mask of IFNFF field.
	JPEG_JPEG_SR_IFNFF_Msk = 0x4
	// Bit IFNFF.
	JPEG_JPEG_SR_IFNFF = 0x4
	// Position of OFTF field.
	JPEG_JPEG_SR_OFTF_Pos = 0x3
	// Bit mask of OFTF field.
	JPEG_JPEG_SR_OFTF_Msk = 0x8
	// Bit OFTF.
	JPEG_JPEG_SR_OFTF = 0x8
	// Position of OFNEF field.
	JPEG_JPEG_SR_OFNEF_Pos = 0x4
	// Bit mask of OFNEF field.
	JPEG_JPEG_SR_OFNEF_Msk = 0x10
	// Bit OFNEF.
	JPEG_JPEG_SR_OFNEF = 0x10
	// Position of EOCF field.
	JPEG_JPEG_SR_EOCF_Pos = 0x5
	// Bit mask of EOCF field.
	JPEG_JPEG_SR_EOCF_Msk = 0x20
	// Bit EOCF.
	JPEG_JPEG_SR_EOCF = 0x20
	// Position of HPDF field.
	JPEG_JPEG_SR_HPDF_Pos = 0x6
	// Bit mask of HPDF field.
	JPEG_JPEG_SR_HPDF_Msk = 0x40
	// Bit HPDF.
	JPEG_JPEG_SR_HPDF = 0x40
	// Position of COF field.
	JPEG_JPEG_SR_COF_Pos = 0x7
	// Bit mask of COF field.
	JPEG_JPEG_SR_COF_Msk = 0x80
	// Bit COF.
	JPEG_JPEG_SR_COF = 0x80

	// JPEG_CFR: JPEG clear flag register
	// Position of CEOCF field.
	JPEG_JPEG_CFR_CEOCF_Pos = 0x5
	// Bit mask of CEOCF field.
	JPEG_JPEG_CFR_CEOCF_Msk = 0x20
	// Bit CEOCF.
	JPEG_JPEG_CFR_CEOCF = 0x20
	// Position of CHPDF field.
	JPEG_JPEG_CFR_CHPDF_Pos = 0x6
	// Bit mask of CHPDF field.
	JPEG_JPEG_CFR_CHPDF_Msk = 0x40
	// Bit CHPDF.
	JPEG_JPEG_CFR_CHPDF = 0x40

	// JPEG_DIR: JPEG data input register
	// Position of DATAIN field.
	JPEG_JPEG_DIR_DATAIN_Pos = 0x0
	// Bit mask of DATAIN field.
	JPEG_JPEG_DIR_DATAIN_Msk = 0xffffffff

	// JPEG_DOR: JPEG data output register
	// Position of DATAOUT field.
	JPEG_JPEG_DOR_DATAOUT_Pos = 0x0
	// Bit mask of DATAOUT field.
	JPEG_JPEG_DOR_DATAOUT_Msk = 0xffffffff

	// QMEM0_0: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_0_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_0_QMem_RAM_Msk = 0xffffffff

	// QMEM0_1: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_1_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_1_QMem_RAM_Msk = 0xffffffff

	// QMEM0_2: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_2_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_2_QMem_RAM_Msk = 0xffffffff

	// QMEM0_3: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_3_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_3_QMem_RAM_Msk = 0xffffffff

	// QMEM0_4: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_4_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_4_QMem_RAM_Msk = 0xffffffff

	// QMEM0_5: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_5_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_5_QMem_RAM_Msk = 0xffffffff

	// QMEM0_6: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_6_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_6_QMem_RAM_Msk = 0xffffffff

	// QMEM0_7: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_7_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_7_QMem_RAM_Msk = 0xffffffff

	// QMEM0_8: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_8_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_8_QMem_RAM_Msk = 0xffffffff

	// QMEM0_9: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_9_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_9_QMem_RAM_Msk = 0xffffffff

	// QMEM0_10: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_10_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_10_QMem_RAM_Msk = 0xffffffff

	// QMEM0_11: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_11_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_11_QMem_RAM_Msk = 0xffffffff

	// QMEM0_12: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_12_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_12_QMem_RAM_Msk = 0xffffffff

	// QMEM0_13: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_13_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_13_QMem_RAM_Msk = 0xffffffff

	// QMEM0_14: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_14_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_14_QMem_RAM_Msk = 0xffffffff

	// QMEM0_15: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM0_15_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM0_15_QMem_RAM_Msk = 0xffffffff

	// QMEM1_0: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_0_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_0_QMem_RAM_Msk = 0xffffffff

	// QMEM1_1: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_1_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_1_QMem_RAM_Msk = 0xffffffff

	// QMEM1_2: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_2_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_2_QMem_RAM_Msk = 0xffffffff

	// QMEM1_3: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_3_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_3_QMem_RAM_Msk = 0xffffffff

	// QMEM1_4: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_4_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_4_QMem_RAM_Msk = 0xffffffff

	// QMEM1_5: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_5_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_5_QMem_RAM_Msk = 0xffffffff

	// QMEM1_6: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_6_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_6_QMem_RAM_Msk = 0xffffffff

	// QMEM1_7: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_7_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_7_QMem_RAM_Msk = 0xffffffff

	// QMEM1_8: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_8_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_8_QMem_RAM_Msk = 0xffffffff

	// QMEM1_9: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_9_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_9_QMem_RAM_Msk = 0xffffffff

	// QMEM1_10: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_10_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_10_QMem_RAM_Msk = 0xffffffff

	// QMEM1_11: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_11_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_11_QMem_RAM_Msk = 0xffffffff

	// QMEM1_12: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_12_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_12_QMem_RAM_Msk = 0xffffffff

	// QMEM1_13: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_13_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_13_QMem_RAM_Msk = 0xffffffff

	// QMEM1_14: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_14_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_14_QMem_RAM_Msk = 0xffffffff

	// QMEM1_15: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM1_15_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM1_15_QMem_RAM_Msk = 0xffffffff

	// QMEM2_0: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_0_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_0_QMem_RAM_Msk = 0xffffffff

	// QMEM2_1: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_1_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_1_QMem_RAM_Msk = 0xffffffff

	// QMEM2_2: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_2_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_2_QMem_RAM_Msk = 0xffffffff

	// QMEM2_3: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_3_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_3_QMem_RAM_Msk = 0xffffffff

	// QMEM2_4: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_4_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_4_QMem_RAM_Msk = 0xffffffff

	// QMEM2_5: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_5_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_5_QMem_RAM_Msk = 0xffffffff

	// QMEM2_6: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_6_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_6_QMem_RAM_Msk = 0xffffffff

	// QMEM2_7: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_7_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_7_QMem_RAM_Msk = 0xffffffff

	// QMEM2_8: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_8_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_8_QMem_RAM_Msk = 0xffffffff

	// QMEM2_9: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_9_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_9_QMem_RAM_Msk = 0xffffffff

	// QMEM2_10: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_10_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_10_QMem_RAM_Msk = 0xffffffff

	// QMEM2_11: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_11_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_11_QMem_RAM_Msk = 0xffffffff

	// QMEM2_12: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_12_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_12_QMem_RAM_Msk = 0xffffffff

	// QMEM2_13: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_13_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_13_QMem_RAM_Msk = 0xffffffff

	// QMEM2_14: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_14_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_14_QMem_RAM_Msk = 0xffffffff

	// QMEM2_15: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM2_15_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM2_15_QMem_RAM_Msk = 0xffffffff

	// QMEM3_0: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_0_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_0_QMem_RAM_Msk = 0xffffffff

	// QMEM3_1: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_1_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_1_QMem_RAM_Msk = 0xffffffff

	// QMEM3_2: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_2_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_2_QMem_RAM_Msk = 0xffffffff

	// QMEM3_3: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_3_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_3_QMem_RAM_Msk = 0xffffffff

	// QMEM3_4: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_4_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_4_QMem_RAM_Msk = 0xffffffff

	// QMEM3_5: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_5_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_5_QMem_RAM_Msk = 0xffffffff

	// QMEM3_6: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_6_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_6_QMem_RAM_Msk = 0xffffffff

	// QMEM3_7: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_7_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_7_QMem_RAM_Msk = 0xffffffff

	// QMEM3_8: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_8_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_8_QMem_RAM_Msk = 0xffffffff

	// QMEM3_9: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_9_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_9_QMem_RAM_Msk = 0xffffffff

	// QMEM3_10: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_10_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_10_QMem_RAM_Msk = 0xffffffff

	// QMEM3_11: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_11_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_11_QMem_RAM_Msk = 0xffffffff

	// QMEM3_12: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_12_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_12_QMem_RAM_Msk = 0xffffffff

	// QMEM3_13: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_13_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_13_QMem_RAM_Msk = 0xffffffff

	// QMEM3_14: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_14_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_14_QMem_RAM_Msk = 0xffffffff

	// QMEM3_15: JPEG quantization tables
	// Position of QMem_RAM field.
	JPEG_QMEM3_15_QMem_RAM_Pos = 0x0
	// Bit mask of QMem_RAM field.
	JPEG_QMEM3_15_QMem_RAM_Msk = 0xffffffff

	// HUFFMIN_0: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_0_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_0_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_1: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_1_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_1_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_2: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_2_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_2_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_3: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_3_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_3_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_4: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_4_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_4_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_5: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_5_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_5_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_6: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_6_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_6_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_7: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_7_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_7_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_8: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_8_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_8_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_9: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_9_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_9_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_10: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_10_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_10_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_11: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_11_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_11_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_12: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_12_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_12_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_13: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_13_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_13_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_14: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_14_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_14_HuffMin_RAM_Msk = 0xffffffff

	// HUFFMIN_15: JPEG HuffMin tables
	// Position of HuffMin_RAM field.
	JPEG_HUFFMIN_15_HuffMin_RAM_Pos = 0x0
	// Bit mask of HuffMin_RAM field.
	JPEG_HUFFMIN_15_HuffMin_RAM_Msk = 0xffffffff

	// HUFFBASE0: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE0_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE0_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE0_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE0_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE1: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE1_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE1_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE1_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE1_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE2: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE2_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE2_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE2_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE2_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE3: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE3_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE3_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE3_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE3_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE4: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE4_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE4_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE4_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE4_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE5: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE5_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE5_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE5_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE5_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE6: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE6_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE6_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE6_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE6_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE7: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE7_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE7_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE7_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE7_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE8: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE8_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE8_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE8_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE8_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE9: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE9_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE9_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE9_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE9_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE10: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE10_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE10_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE10_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE10_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE11: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE11_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE11_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE11_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE11_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE12: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE12_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE12_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE12_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE12_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE13: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE13_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE13_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE13_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE13_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE14: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE14_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE14_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE14_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE14_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE15: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE15_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE15_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE15_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE15_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE16: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE16_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE16_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE16_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE16_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE17: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE17_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE17_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE17_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE17_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE18: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE18_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE18_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE18_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE18_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE19: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE19_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE19_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE19_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE19_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE20: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE20_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE20_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE20_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE20_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE21: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE21_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE21_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE21_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE21_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE22: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE22_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE22_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE22_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE22_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE23: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE23_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE23_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE23_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE23_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE24: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE24_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE24_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE24_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE24_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE25: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE25_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE25_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE25_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE25_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE26: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE26_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE26_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE26_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE26_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE27: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE27_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE27_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE27_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE27_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE28: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE28_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE28_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE28_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE28_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE29: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE29_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE29_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE29_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE29_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE30: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE30_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE30_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE30_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE30_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFBASE31: JPEG HuffSymb tables
	// Position of HuffBase_RAM_0 field.
	JPEG_HUFFBASE31_HuffBase_RAM_0_Pos = 0x0
	// Bit mask of HuffBase_RAM_0 field.
	JPEG_HUFFBASE31_HuffBase_RAM_0_Msk = 0x1ff
	// Position of HuffBase_RAM_1 field.
	JPEG_HUFFBASE31_HuffBase_RAM_1_Pos = 0x10
	// Bit mask of HuffBase_RAM_1 field.
	JPEG_HUFFBASE31_HuffBase_RAM_1_Msk = 0x1ff0000

	// HUFFSYMB0: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB0_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB0_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB1: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB1_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB1_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB2: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB2_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB2_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB3: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB3_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB3_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB4: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB4_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB4_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB5: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB5_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB5_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB6: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB6_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB6_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB7: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB7_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB7_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB8: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB8_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB8_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB9: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB9_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB9_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB10: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB10_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB10_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB11: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB11_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB11_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB12: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB12_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB12_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB13: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB13_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB13_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB14: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB14_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB14_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB15: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB15_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB15_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB16: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB16_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB16_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB17: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB17_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB17_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB18: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB18_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB18_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB19: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB19_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB19_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB20: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB20_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB20_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB21: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB21_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB21_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB22: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB22_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB22_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB23: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB23_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB23_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB24: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB24_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB24_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB25: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB25_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB25_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB26: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB26_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB26_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB27: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB27_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB27_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB28: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB28_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB28_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB29: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB29_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB29_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB30: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB30_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB30_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB31: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB31_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB31_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB32: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB32_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB32_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB33: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB33_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB33_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB34: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB34_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB34_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB35: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB35_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB35_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB36: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB36_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB36_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB37: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB37_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB37_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB38: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB38_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB38_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB39: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB39_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB39_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB40: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB40_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB40_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB41: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB41_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB41_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB42: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB42_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB42_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB43: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB43_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB43_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB44: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB44_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB44_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB45: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB45_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB45_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB46: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB46_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB46_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB47: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB47_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB47_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB48: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB48_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB48_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB49: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB49_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB49_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB50: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB50_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB50_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB51: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB51_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB51_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB52: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB52_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB52_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB53: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB53_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB53_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB54: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB54_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB54_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB55: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB55_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB55_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB56: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB56_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB56_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB57: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB57_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB57_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB58: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB58_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB58_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB59: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB59_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB59_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB60: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB60_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB60_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB61: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB61_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB61_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB62: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB62_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB62_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB63: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB63_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB63_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB64: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB64_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB64_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB65: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB65_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB65_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB66: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB66_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB66_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB67: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB67_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB67_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB68: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB68_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB68_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB69: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB69_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB69_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB70: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB70_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB70_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB71: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB71_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB71_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB72: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB72_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB72_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB73: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB73_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB73_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB74: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB74_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB74_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB75: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB75_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB75_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB76: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB76_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB76_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB77: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB77_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB77_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB78: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB78_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB78_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB79: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB79_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB79_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB80: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB80_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB80_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB81: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB81_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB81_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB82: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB82_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB82_HuffSymb_RAM_Msk = 0xffffffff

	// HUFFSYMB83: JPEG HUFFSYMB tables
	// Position of HuffSymb_RAM field.
	JPEG_HUFFSYMB83_HuffSymb_RAM_Pos = 0x0
	// Bit mask of HuffSymb_RAM field.
	JPEG_HUFFSYMB83_HuffSymb_RAM_Msk = 0xffffffff

	// DHTMEM0: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM0_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM0_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM2: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM2_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM2_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM3: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM3_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM3_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM4: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM4_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM4_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM5: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM5_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM5_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM6: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM6_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM6_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM7: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM7_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM7_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM8: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM8_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM8_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM9: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM9_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM9_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM10: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM10_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM10_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM11: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM11_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM11_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM12: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM12_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM12_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM13: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM13_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM13_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM14: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM14_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM14_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM15: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM15_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM15_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM16: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM16_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM16_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM17: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM17_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM17_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM18: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM18_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM18_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM19: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM19_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM19_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM20: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM20_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM20_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM21: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM21_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM21_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM22: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM22_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM22_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM23: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM23_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM23_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM24: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM24_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM24_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM25: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM25_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM25_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM26: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM26_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM26_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM27: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM27_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM27_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM28: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM28_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM28_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM29: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM29_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM29_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM30: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM30_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM30_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM31: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM31_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM31_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM32: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM32_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM32_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM33: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM33_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM33_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM34: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM34_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM34_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM35: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM35_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM35_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM36: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM36_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM36_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM37: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM37_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM37_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM38: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM38_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM38_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM39: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM39_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM39_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM40: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM40_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM40_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM41: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM41_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM41_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM42: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM42_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM42_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM43: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM43_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM43_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM44: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM44_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM44_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM45: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM45_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM45_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM46: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM46_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM46_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM47: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM47_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM47_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM48: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM48_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM48_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM49: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM49_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM49_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM50: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM50_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM50_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM51: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM51_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM51_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM52: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM52_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM52_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM53: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM53_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM53_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM54: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM54_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM54_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM55: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM55_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM55_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM56: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM56_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM56_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM57: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM57_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM57_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM58: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM58_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM58_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM59: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM59_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM59_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM60: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM60_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM60_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM61: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM61_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM61_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM62: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM62_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM62_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM63: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM63_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM63_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM64: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM64_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM64_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM65: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM65_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM65_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM66: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM66_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM66_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM67: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM67_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM67_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM68: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM68_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM68_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM69: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM69_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM69_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM70: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM70_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM70_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM71: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM71_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM71_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM72: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM72_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM72_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM73: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM73_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM73_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM74: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM74_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM74_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM75: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM75_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM75_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM76: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM76_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM76_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM77: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM77_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM77_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM78: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM78_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM78_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM79: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM79_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM79_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM80: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM80_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM80_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM81: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM81_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM81_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM82: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM82_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM82_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM83: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM83_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM83_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM84: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM84_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM84_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM85: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM85_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM85_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM86: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM86_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM86_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM87: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM87_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM87_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM88: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM88_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM88_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM89: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM89_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM89_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM90: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM90_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM90_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM91: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM91_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM91_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM92: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM92_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM92_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM93: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM93_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM93_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM94: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM94_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM94_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM95: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM95_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM95_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM96: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM96_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM96_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM97: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM97_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM97_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM98: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM98_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM98_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM99: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM99_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM99_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM100: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM100_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM100_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM101: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM101_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM101_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM102: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM102_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM102_DHTMem_RAM_Msk = 0xffffffff

	// DHTMEM103: JPEG DHTMem tables
	// Position of DHTMem_RAM field.
	JPEG_DHTMEM103_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_DHTMEM103_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_0: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_0_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_0_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_1: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_1_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_1_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_2: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_2_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_2_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_3: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_3_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_3_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_4: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_4_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_4_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_5: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_5_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_5_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_6: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_6_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_6_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_7: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_7_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_7_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_8: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_8_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_8_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_9: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_9_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_9_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_10: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_10_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_10_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_11: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_11_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_11_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_12: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_12_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_12_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_13: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_13_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_13_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_14: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_14_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_14_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_15: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_15_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_15_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_16: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_16_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_16_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_17: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_17_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_17_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_18: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_18_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_18_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_19: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_19_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_19_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_20: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_20_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_20_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_21: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_21_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_21_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_22: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_22_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_22_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_23: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_23_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_23_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_24: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_24_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_24_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_25: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_25_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_25_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_26: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_26_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_26_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_27: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_27_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_27_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_28: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_28_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_28_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_29: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_29_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_29_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_30: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_30_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_30_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_31: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_31_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_31_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_32: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_32_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_32_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_33: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_33_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_33_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_34: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_34_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_34_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_35: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_35_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_35_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_36: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_36_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_36_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_37: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_37_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_37_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_38: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_38_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_38_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_39: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_39_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_39_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_40: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_40_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_40_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_41: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_41_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_41_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_42: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_42_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_42_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_43: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_43_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_43_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_44: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_44_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_44_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_45: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_45_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_45_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_46: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_46_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_46_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_47: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_47_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_47_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_48: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_48_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_48_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_49: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_49_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_49_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_50: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_50_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_50_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_51: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_51_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_51_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_52: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_52_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_52_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_53: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_53_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_53_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_54: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_54_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_54_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_55: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_55_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_55_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_56: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_56_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_56_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_57: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_57_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_57_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_58: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_58_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_58_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_59: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_59_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_59_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_60: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_60_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_60_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_61: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_61_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_61_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_62: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_62_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_62_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_63: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_63_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_63_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_64: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_64_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_64_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_65: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_65_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_65_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_66: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_66_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_66_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_67: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_67_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_67_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_68: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_68_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_68_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_69: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_69_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_69_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_70: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_70_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_70_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_71: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_71_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_71_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_72: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_72_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_72_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_73: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_73_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_73_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_74: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_74_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_74_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_75: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_75_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_75_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_76: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_76_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_76_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_77: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_77_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_77_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_78: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_78_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_78_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_79: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_79_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_79_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_80: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_80_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_80_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_81: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_81_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_81_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_82: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_82_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_82_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_83: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_83_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_83_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_84: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_84_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_84_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_85: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_85_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_85_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_86: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_86_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_86_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC0_87: JPEG encoder, AC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_87_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC0_87_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_0: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_0_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_0_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_1: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_1_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_1_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_2: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_2_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_2_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_3: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_3_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_3_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_4: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_4_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_4_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_5: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_5_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_5_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_6: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_6_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_6_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_7: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_7_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_7_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_8: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_8_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_8_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_9: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_9_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_9_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_10: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_10_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_10_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_11: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_11_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_11_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_12: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_12_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_12_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_13: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_13_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_13_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_14: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_14_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_14_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_15: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_15_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_15_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_16: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_16_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_16_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_17: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_17_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_17_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_18: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_18_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_18_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_19: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_19_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_19_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_20: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_20_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_20_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_21: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_21_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_21_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_22: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_22_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_22_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_23: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_23_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_23_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_24: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_24_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_24_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_25: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_25_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_25_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_26: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_26_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_26_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_27: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_27_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_27_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_28: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_28_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_28_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_29: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_29_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_29_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_30: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_30_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_30_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_31: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_31_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_31_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_32: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_32_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_32_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_33: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_33_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_33_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_34: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_34_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_34_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_35: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_35_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_35_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_36: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_36_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_36_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_37: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_37_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_37_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_38: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_38_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_38_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_39: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_39_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_39_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_40: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_40_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_40_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_41: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_41_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_41_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_42: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_42_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_42_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_43: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_43_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_43_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_44: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_44_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_44_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_45: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_45_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_45_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_46: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_46_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_46_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_47: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_47_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_47_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_48: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_48_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_48_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_49: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_49_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_49_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_50: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_50_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_50_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_51: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_51_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_51_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_52: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_52_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_52_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_53: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_53_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_53_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_54: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_54_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_54_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_55: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_55_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_55_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_56: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_56_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_56_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_57: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_57_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_57_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_58: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_58_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_58_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_59: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_59_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_59_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_60: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_60_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_60_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_61: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_61_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_61_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_62: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_62_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_62_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_63: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_63_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_63_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_64: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_64_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_64_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_65: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_65_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_65_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_66: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_66_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_66_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_67: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_67_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_67_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_68: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_68_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_68_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_69: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_69_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_69_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_70: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_70_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_70_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_71: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_71_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_71_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_72: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_72_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_72_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_73: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_73_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_73_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_74: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_74_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_74_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_75: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_75_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_75_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_76: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_76_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_76_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_77: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_77_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_77_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_78: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_78_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_78_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_79: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_79_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_79_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_80: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_80_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_80_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_81: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_81_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_81_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_82: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_82_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_82_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_83: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_83_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_83_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_84: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_84_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_84_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_85: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_85_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_85_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_86: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_86_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_86_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_AC1_87: JPEG encoder, AC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_87_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_AC1_87_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC0_0: JPEG encoder, DC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_0_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_0_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC0_1: JPEG encoder, DC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_1_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_1_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC0_2: JPEG encoder, DC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_2_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_2_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC0_3: JPEG encoder, DC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_3_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_3_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC0_4: JPEG encoder, DC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_4_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_4_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC0_5: JPEG encoder, DC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_5_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_5_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC0_6: JPEG encoder, DC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_6_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_6_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC0_7: JPEG encoder, DC Huffman table 0
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_7_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC0_7_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC1_0: JPEG encoder, DC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_0_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_0_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC1_1: JPEG encoder, DC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_1_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_1_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC1_2: JPEG encoder, DC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_2_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_2_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC1_3: JPEG encoder, DC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_3_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_3_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC1_4: JPEG encoder, DC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_4_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_4_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC1_5: JPEG encoder, DC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_5_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_5_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC1_6: JPEG encoder, DC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_6_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_6_DHTMem_RAM_Msk = 0xffffffff

	// HUFFENC_DC1_7: JPEG encoder, DC Huffman table 1
	// Position of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_7_DHTMem_RAM_Pos = 0x0
	// Bit mask of DHTMem_RAM field.
	JPEG_HUFFENC_DC1_7_DHTMem_RAM_Msk = 0xffffffff
)

// Bitfields for DSI: DSI Host
const (
	// DSI_VR: DSI Host Version Register
	// Position of VERSION field.
	DSI_DSI_VR_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	DSI_DSI_VR_VERSION_Msk = 0xffffffff

	// DSI_CR: DSI Host Control Register
	// Position of EN field.
	DSI_DSI_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DSI_DSI_CR_EN_Msk = 0x1
	// Bit EN.
	DSI_DSI_CR_EN = 0x1

	// DSI_CCR: DSI HOST Clock Control Register
	// Position of TXECKDIV field.
	DSI_DSI_CCR_TXECKDIV_Pos = 0x0
	// Bit mask of TXECKDIV field.
	DSI_DSI_CCR_TXECKDIV_Msk = 0xff
	// Position of TOCKDIV field.
	DSI_DSI_CCR_TOCKDIV_Pos = 0x8
	// Bit mask of TOCKDIV field.
	DSI_DSI_CCR_TOCKDIV_Msk = 0xff00

	// DSI_LVCIDR: DSI Host LTDC VCID Register
	// Position of VCID field.
	DSI_DSI_LVCIDR_VCID_Pos = 0x0
	// Bit mask of VCID field.
	DSI_DSI_LVCIDR_VCID_Msk = 0x3

	// DSI_LCOLCR: DSI Host LTDC Color Coding Register
	// Position of COLC field.
	DSI_DSI_LCOLCR_COLC_Pos = 0x0
	// Bit mask of COLC field.
	DSI_DSI_LCOLCR_COLC_Msk = 0xf
	// Position of LPE field.
	DSI_DSI_LCOLCR_LPE_Pos = 0x8
	// Bit mask of LPE field.
	DSI_DSI_LCOLCR_LPE_Msk = 0x100
	// Bit LPE.
	DSI_DSI_LCOLCR_LPE = 0x100

	// DSI_LPCR: DSI Host LTDC Polarity Configuration Register
	// Position of DEP field.
	DSI_DSI_LPCR_DEP_Pos = 0x0
	// Bit mask of DEP field.
	DSI_DSI_LPCR_DEP_Msk = 0x1
	// Bit DEP.
	DSI_DSI_LPCR_DEP = 0x1
	// Position of VSP field.
	DSI_DSI_LPCR_VSP_Pos = 0x1
	// Bit mask of VSP field.
	DSI_DSI_LPCR_VSP_Msk = 0x2
	// Bit VSP.
	DSI_DSI_LPCR_VSP = 0x2
	// Position of HSP field.
	DSI_DSI_LPCR_HSP_Pos = 0x2
	// Bit mask of HSP field.
	DSI_DSI_LPCR_HSP_Msk = 0x4
	// Bit HSP.
	DSI_DSI_LPCR_HSP = 0x4

	// DSI_LPMCR: DSI Host Low-Power mode Configuration Register
	// Position of VLPSIZE field.
	DSI_DSI_LPMCR_VLPSIZE_Pos = 0x0
	// Bit mask of VLPSIZE field.
	DSI_DSI_LPMCR_VLPSIZE_Msk = 0xff
	// Position of LPSIZE field.
	DSI_DSI_LPMCR_LPSIZE_Pos = 0x10
	// Bit mask of LPSIZE field.
	DSI_DSI_LPMCR_LPSIZE_Msk = 0xff0000

	// DSI_PCR: DSI Host Protocol Configuration Register
	// Position of ETTXE field.
	DSI_DSI_PCR_ETTXE_Pos = 0x0
	// Bit mask of ETTXE field.
	DSI_DSI_PCR_ETTXE_Msk = 0x1
	// Bit ETTXE.
	DSI_DSI_PCR_ETTXE = 0x1
	// Position of ETRXE field.
	DSI_DSI_PCR_ETRXE_Pos = 0x1
	// Bit mask of ETRXE field.
	DSI_DSI_PCR_ETRXE_Msk = 0x2
	// Bit ETRXE.
	DSI_DSI_PCR_ETRXE = 0x2
	// Position of BTAE field.
	DSI_DSI_PCR_BTAE_Pos = 0x2
	// Bit mask of BTAE field.
	DSI_DSI_PCR_BTAE_Msk = 0x4
	// Bit BTAE.
	DSI_DSI_PCR_BTAE = 0x4
	// Position of ECCRXE field.
	DSI_DSI_PCR_ECCRXE_Pos = 0x3
	// Bit mask of ECCRXE field.
	DSI_DSI_PCR_ECCRXE_Msk = 0x8
	// Bit ECCRXE.
	DSI_DSI_PCR_ECCRXE = 0x8
	// Position of CRCRXE field.
	DSI_DSI_PCR_CRCRXE_Pos = 0x4
	// Bit mask of CRCRXE field.
	DSI_DSI_PCR_CRCRXE_Msk = 0x10
	// Bit CRCRXE.
	DSI_DSI_PCR_CRCRXE = 0x10

	// DSI_GVCIDR: DSI Host Generic VCID Register
	// Position of VCID field.
	DSI_DSI_GVCIDR_VCID_Pos = 0x0
	// Bit mask of VCID field.
	DSI_DSI_GVCIDR_VCID_Msk = 0x3

	// DSI_MCR: DSI Host mode Configuration Register
	// Position of CMDM field.
	DSI_DSI_MCR_CMDM_Pos = 0x0
	// Bit mask of CMDM field.
	DSI_DSI_MCR_CMDM_Msk = 0x1
	// Bit CMDM.
	DSI_DSI_MCR_CMDM = 0x1

	// DSI_VMCR: DSI Host Video mode Configuration Register
	// Position of VMT field.
	DSI_DSI_VMCR_VMT_Pos = 0x0
	// Bit mask of VMT field.
	DSI_DSI_VMCR_VMT_Msk = 0x3
	// Position of LPVSAE field.
	DSI_DSI_VMCR_LPVSAE_Pos = 0x8
	// Bit mask of LPVSAE field.
	DSI_DSI_VMCR_LPVSAE_Msk = 0x100
	// Bit LPVSAE.
	DSI_DSI_VMCR_LPVSAE = 0x100
	// Position of LPVBPE field.
	DSI_DSI_VMCR_LPVBPE_Pos = 0x9
	// Bit mask of LPVBPE field.
	DSI_DSI_VMCR_LPVBPE_Msk = 0x200
	// Bit LPVBPE.
	DSI_DSI_VMCR_LPVBPE = 0x200
	// Position of LPVFPE field.
	DSI_DSI_VMCR_LPVFPE_Pos = 0xa
	// Bit mask of LPVFPE field.
	DSI_DSI_VMCR_LPVFPE_Msk = 0x400
	// Bit LPVFPE.
	DSI_DSI_VMCR_LPVFPE = 0x400
	// Position of LPVAE field.
	DSI_DSI_VMCR_LPVAE_Pos = 0xb
	// Bit mask of LPVAE field.
	DSI_DSI_VMCR_LPVAE_Msk = 0x800
	// Bit LPVAE.
	DSI_DSI_VMCR_LPVAE = 0x800
	// Position of LPHBPE field.
	DSI_DSI_VMCR_LPHBPE_Pos = 0xc
	// Bit mask of LPHBPE field.
	DSI_DSI_VMCR_LPHBPE_Msk = 0x1000
	// Bit LPHBPE.
	DSI_DSI_VMCR_LPHBPE = 0x1000
	// Position of LPHFPE field.
	DSI_DSI_VMCR_LPHFPE_Pos = 0xd
	// Bit mask of LPHFPE field.
	DSI_DSI_VMCR_LPHFPE_Msk = 0x2000
	// Bit LPHFPE.
	DSI_DSI_VMCR_LPHFPE = 0x2000
	// Position of FBTAAE field.
	DSI_DSI_VMCR_FBTAAE_Pos = 0xe
	// Bit mask of FBTAAE field.
	DSI_DSI_VMCR_FBTAAE_Msk = 0x4000
	// Bit FBTAAE.
	DSI_DSI_VMCR_FBTAAE = 0x4000
	// Position of LPCE field.
	DSI_DSI_VMCR_LPCE_Pos = 0xf
	// Bit mask of LPCE field.
	DSI_DSI_VMCR_LPCE_Msk = 0x8000
	// Bit LPCE.
	DSI_DSI_VMCR_LPCE = 0x8000
	// Position of PGE field.
	DSI_DSI_VMCR_PGE_Pos = 0x10
	// Bit mask of PGE field.
	DSI_DSI_VMCR_PGE_Msk = 0x10000
	// Bit PGE.
	DSI_DSI_VMCR_PGE = 0x10000
	// Position of PGM field.
	DSI_DSI_VMCR_PGM_Pos = 0x14
	// Bit mask of PGM field.
	DSI_DSI_VMCR_PGM_Msk = 0x100000
	// Bit PGM.
	DSI_DSI_VMCR_PGM = 0x100000
	// Position of PGO field.
	DSI_DSI_VMCR_PGO_Pos = 0x18
	// Bit mask of PGO field.
	DSI_DSI_VMCR_PGO_Msk = 0x1000000
	// Bit PGO.
	DSI_DSI_VMCR_PGO = 0x1000000

	// DSI_VPCR: DSI Host Video Packet Configuration Register
	// Position of VPSIZE field.
	DSI_DSI_VPCR_VPSIZE_Pos = 0x0
	// Bit mask of VPSIZE field.
	DSI_DSI_VPCR_VPSIZE_Msk = 0x3fff

	// DSI_VCCR: DSI Host Video Chunks Configuration Register
	// Position of NUMC field.
	DSI_DSI_VCCR_NUMC_Pos = 0x0
	// Bit mask of NUMC field.
	DSI_DSI_VCCR_NUMC_Msk = 0x1fff

	// DSI_VNPCR: DSI Host Video Null Packet Configuration Register
	// Position of NPSIZE field.
	DSI_DSI_VNPCR_NPSIZE_Pos = 0x0
	// Bit mask of NPSIZE field.
	DSI_DSI_VNPCR_NPSIZE_Msk = 0x1fff

	// DSI_VHSACR: DSI Host Video HSA Configuration Register
	// Position of HSA field.
	DSI_DSI_VHSACR_HSA_Pos = 0x0
	// Bit mask of HSA field.
	DSI_DSI_VHSACR_HSA_Msk = 0xfff

	// DSI_VHBPCR: DSI Host Video HBP Configuration Register
	// Position of HBP field.
	DSI_DSI_VHBPCR_HBP_Pos = 0x0
	// Bit mask of HBP field.
	DSI_DSI_VHBPCR_HBP_Msk = 0xfff

	// DSI_VLCR: DSI Host Video Line Configuration Register
	// Position of HLINE field.
	DSI_DSI_VLCR_HLINE_Pos = 0x0
	// Bit mask of HLINE field.
	DSI_DSI_VLCR_HLINE_Msk = 0x7fff

	// DSI_VVSACR: DSI Host Video VSA Configuration Register
	// Position of VSA field.
	DSI_DSI_VVSACR_VSA_Pos = 0x0
	// Bit mask of VSA field.
	DSI_DSI_VVSACR_VSA_Msk = 0x3ff

	// DSI_VVBPCR: DSI Host Video VBP Configuration Register
	// Position of VBP field.
	DSI_DSI_VVBPCR_VBP_Pos = 0x0
	// Bit mask of VBP field.
	DSI_DSI_VVBPCR_VBP_Msk = 0x3ff

	// DSI_VVFPCR: DSI Host Video VFP Configuration Register
	// Position of VFP field.
	DSI_DSI_VVFPCR_VFP_Pos = 0x0
	// Bit mask of VFP field.
	DSI_DSI_VVFPCR_VFP_Msk = 0x3ff

	// DSI_VVACR: DSI Host Video VA Configuration Register
	// Position of VA field.
	DSI_DSI_VVACR_VA_Pos = 0x0
	// Bit mask of VA field.
	DSI_DSI_VVACR_VA_Msk = 0x3fff

	// DSI_LCCR: DSI Host LTDC Command Configuration Register
	// Position of CMDSIZE field.
	DSI_DSI_LCCR_CMDSIZE_Pos = 0x0
	// Bit mask of CMDSIZE field.
	DSI_DSI_LCCR_CMDSIZE_Msk = 0xffff

	// DSI_CMCR: DSI Host Command mode Configuration Register
	// Position of TEARE field.
	DSI_DSI_CMCR_TEARE_Pos = 0x0
	// Bit mask of TEARE field.
	DSI_DSI_CMCR_TEARE_Msk = 0x1
	// Bit TEARE.
	DSI_DSI_CMCR_TEARE = 0x1
	// Position of ARE field.
	DSI_DSI_CMCR_ARE_Pos = 0x1
	// Bit mask of ARE field.
	DSI_DSI_CMCR_ARE_Msk = 0x2
	// Bit ARE.
	DSI_DSI_CMCR_ARE = 0x2
	// Position of GSW0TX field.
	DSI_DSI_CMCR_GSW0TX_Pos = 0x8
	// Bit mask of GSW0TX field.
	DSI_DSI_CMCR_GSW0TX_Msk = 0x100
	// Bit GSW0TX.
	DSI_DSI_CMCR_GSW0TX = 0x100
	// Position of GSW1TX field.
	DSI_DSI_CMCR_GSW1TX_Pos = 0x9
	// Bit mask of GSW1TX field.
	DSI_DSI_CMCR_GSW1TX_Msk = 0x200
	// Bit GSW1TX.
	DSI_DSI_CMCR_GSW1TX = 0x200
	// Position of GSW2TX field.
	DSI_DSI_CMCR_GSW2TX_Pos = 0xa
	// Bit mask of GSW2TX field.
	DSI_DSI_CMCR_GSW2TX_Msk = 0x400
	// Bit GSW2TX.
	DSI_DSI_CMCR_GSW2TX = 0x400
	// Position of GSR0TX field.
	DSI_DSI_CMCR_GSR0TX_Pos = 0xb
	// Bit mask of GSR0TX field.
	DSI_DSI_CMCR_GSR0TX_Msk = 0x800
	// Bit GSR0TX.
	DSI_DSI_CMCR_GSR0TX = 0x800
	// Position of GSR1TX field.
	DSI_DSI_CMCR_GSR1TX_Pos = 0xc
	// Bit mask of GSR1TX field.
	DSI_DSI_CMCR_GSR1TX_Msk = 0x1000
	// Bit GSR1TX.
	DSI_DSI_CMCR_GSR1TX = 0x1000
	// Position of GSR2TX field.
	DSI_DSI_CMCR_GSR2TX_Pos = 0xd
	// Bit mask of GSR2TX field.
	DSI_DSI_CMCR_GSR2TX_Msk = 0x2000
	// Bit GSR2TX.
	DSI_DSI_CMCR_GSR2TX = 0x2000
	// Position of GLWTX field.
	DSI_DSI_CMCR_GLWTX_Pos = 0xe
	// Bit mask of GLWTX field.
	DSI_DSI_CMCR_GLWTX_Msk = 0x4000
	// Bit GLWTX.
	DSI_DSI_CMCR_GLWTX = 0x4000
	// Position of DSW0TX field.
	DSI_DSI_CMCR_DSW0TX_Pos = 0x10
	// Bit mask of DSW0TX field.
	DSI_DSI_CMCR_DSW0TX_Msk = 0x10000
	// Bit DSW0TX.
	DSI_DSI_CMCR_DSW0TX = 0x10000
	// Position of DSW1TX field.
	DSI_DSI_CMCR_DSW1TX_Pos = 0x11
	// Bit mask of DSW1TX field.
	DSI_DSI_CMCR_DSW1TX_Msk = 0x20000
	// Bit DSW1TX.
	DSI_DSI_CMCR_DSW1TX = 0x20000
	// Position of DSR0TX field.
	DSI_DSI_CMCR_DSR0TX_Pos = 0x12
	// Bit mask of DSR0TX field.
	DSI_DSI_CMCR_DSR0TX_Msk = 0x40000
	// Bit DSR0TX.
	DSI_DSI_CMCR_DSR0TX = 0x40000
	// Position of DLWTX field.
	DSI_DSI_CMCR_DLWTX_Pos = 0x13
	// Bit mask of DLWTX field.
	DSI_DSI_CMCR_DLWTX_Msk = 0x80000
	// Bit DLWTX.
	DSI_DSI_CMCR_DLWTX = 0x80000
	// Position of MRDPS field.
	DSI_DSI_CMCR_MRDPS_Pos = 0x18
	// Bit mask of MRDPS field.
	DSI_DSI_CMCR_MRDPS_Msk = 0x1000000
	// Bit MRDPS.
	DSI_DSI_CMCR_MRDPS = 0x1000000

	// DSI_GHCR: DSI Host Generic Header Configuration Register
	// Position of DT field.
	DSI_DSI_GHCR_DT_Pos = 0x0
	// Bit mask of DT field.
	DSI_DSI_GHCR_DT_Msk = 0x3f
	// Position of VCID field.
	DSI_DSI_GHCR_VCID_Pos = 0x6
	// Bit mask of VCID field.
	DSI_DSI_GHCR_VCID_Msk = 0xc0
	// Position of WCLSB field.
	DSI_DSI_GHCR_WCLSB_Pos = 0x8
	// Bit mask of WCLSB field.
	DSI_DSI_GHCR_WCLSB_Msk = 0xff00
	// Position of WCMSB field.
	DSI_DSI_GHCR_WCMSB_Pos = 0x10
	// Bit mask of WCMSB field.
	DSI_DSI_GHCR_WCMSB_Msk = 0xff0000

	// DSI_GPDR: DSI Host Generic Payload Data Register
	// Position of DATA1 field.
	DSI_DSI_GPDR_DATA1_Pos = 0x0
	// Bit mask of DATA1 field.
	DSI_DSI_GPDR_DATA1_Msk = 0xff
	// Position of DATA2 field.
	DSI_DSI_GPDR_DATA2_Pos = 0x8
	// Bit mask of DATA2 field.
	DSI_DSI_GPDR_DATA2_Msk = 0xff00
	// Position of DATA3 field.
	DSI_DSI_GPDR_DATA3_Pos = 0x10
	// Bit mask of DATA3 field.
	DSI_DSI_GPDR_DATA3_Msk = 0xff0000
	// Position of DATA4 field.
	DSI_DSI_GPDR_DATA4_Pos = 0x18
	// Bit mask of DATA4 field.
	DSI_DSI_GPDR_DATA4_Msk = 0xff000000

	// DSI_GPSR: DSI Host Generic Packet Status Register
	// Position of CMDFE field.
	DSI_DSI_GPSR_CMDFE_Pos = 0x0
	// Bit mask of CMDFE field.
	DSI_DSI_GPSR_CMDFE_Msk = 0x1
	// Bit CMDFE.
	DSI_DSI_GPSR_CMDFE = 0x1
	// Position of CMDFF field.
	DSI_DSI_GPSR_CMDFF_Pos = 0x1
	// Bit mask of CMDFF field.
	DSI_DSI_GPSR_CMDFF_Msk = 0x2
	// Bit CMDFF.
	DSI_DSI_GPSR_CMDFF = 0x2
	// Position of PWRFE field.
	DSI_DSI_GPSR_PWRFE_Pos = 0x2
	// Bit mask of PWRFE field.
	DSI_DSI_GPSR_PWRFE_Msk = 0x4
	// Bit PWRFE.
	DSI_DSI_GPSR_PWRFE = 0x4
	// Position of PWRFF field.
	DSI_DSI_GPSR_PWRFF_Pos = 0x3
	// Bit mask of PWRFF field.
	DSI_DSI_GPSR_PWRFF_Msk = 0x8
	// Bit PWRFF.
	DSI_DSI_GPSR_PWRFF = 0x8
	// Position of PRDFE field.
	DSI_DSI_GPSR_PRDFE_Pos = 0x4
	// Bit mask of PRDFE field.
	DSI_DSI_GPSR_PRDFE_Msk = 0x10
	// Bit PRDFE.
	DSI_DSI_GPSR_PRDFE = 0x10
	// Position of PRDFF field.
	DSI_DSI_GPSR_PRDFF_Pos = 0x5
	// Bit mask of PRDFF field.
	DSI_DSI_GPSR_PRDFF_Msk = 0x20
	// Bit PRDFF.
	DSI_DSI_GPSR_PRDFF = 0x20
	// Position of RCB field.
	DSI_DSI_GPSR_RCB_Pos = 0x6
	// Bit mask of RCB field.
	DSI_DSI_GPSR_RCB_Msk = 0x40
	// Bit RCB.
	DSI_DSI_GPSR_RCB = 0x40

	// DSI_TCCR0: DSI Host Timeout Counter Configuration Register 0
	// Position of LPRX_TOCNT field.
	DSI_DSI_TCCR0_LPRX_TOCNT_Pos = 0x0
	// Bit mask of LPRX_TOCNT field.
	DSI_DSI_TCCR0_LPRX_TOCNT_Msk = 0xffff
	// Position of HSTX_TOCNT field.
	DSI_DSI_TCCR0_HSTX_TOCNT_Pos = 0x10
	// Bit mask of HSTX_TOCNT field.
	DSI_DSI_TCCR0_HSTX_TOCNT_Msk = 0xffff0000

	// DSI_TCCR1: DSI Host Timeout Counter Configuration Register 1
	// Position of HSRD_TOCNT field.
	DSI_DSI_TCCR1_HSRD_TOCNT_Pos = 0x0
	// Bit mask of HSRD_TOCNT field.
	DSI_DSI_TCCR1_HSRD_TOCNT_Msk = 0xffff

	// DSI_TCCR2: DSI Host Timeout Counter Configuration Register 2
	// Position of LPRD_TOCNT field.
	DSI_DSI_TCCR2_LPRD_TOCNT_Pos = 0x0
	// Bit mask of LPRD_TOCNT field.
	DSI_DSI_TCCR2_LPRD_TOCNT_Msk = 0xffff

	// DSI_TCCR3: DSI Host Timeout Counter Configuration Register 3
	// Position of HSWR_TOCNT field.
	DSI_DSI_TCCR3_HSWR_TOCNT_Pos = 0x0
	// Bit mask of HSWR_TOCNT field.
	DSI_DSI_TCCR3_HSWR_TOCNT_Msk = 0xffff
	// Position of PM field.
	DSI_DSI_TCCR3_PM_Pos = 0x18
	// Bit mask of PM field.
	DSI_DSI_TCCR3_PM_Msk = 0x1000000
	// Bit PM.
	DSI_DSI_TCCR3_PM = 0x1000000

	// DSI_TCCR4: DSI Host Timeout Counter Configuration Register 4
	// Position of LSWR_TOCNT field.
	DSI_DSI_TCCR4_LSWR_TOCNT_Pos = 0x0
	// Bit mask of LSWR_TOCNT field.
	DSI_DSI_TCCR4_LSWR_TOCNT_Msk = 0xffff

	// DSI_TCCR5: DSI Host Timeout Counter Configuration Register 5
	// Position of BTA_TOCNT field.
	DSI_DSI_TCCR5_BTA_TOCNT_Pos = 0x0
	// Bit mask of BTA_TOCNT field.
	DSI_DSI_TCCR5_BTA_TOCNT_Msk = 0xffff

	// DSI_CLCR: DSI Host Clock Lane Configuration Register
	// Position of DPCC field.
	DSI_DSI_CLCR_DPCC_Pos = 0x0
	// Bit mask of DPCC field.
	DSI_DSI_CLCR_DPCC_Msk = 0x1
	// Bit DPCC.
	DSI_DSI_CLCR_DPCC = 0x1
	// Position of ACR field.
	DSI_DSI_CLCR_ACR_Pos = 0x1
	// Bit mask of ACR field.
	DSI_DSI_CLCR_ACR_Msk = 0x2
	// Bit ACR.
	DSI_DSI_CLCR_ACR = 0x2

	// DSI_CLTCR: DSI Host Clock Lane Timer Configuration Register
	// Position of LP2HS_TIME field.
	DSI_DSI_CLTCR_LP2HS_TIME_Pos = 0x0
	// Bit mask of LP2HS_TIME field.
	DSI_DSI_CLTCR_LP2HS_TIME_Msk = 0x3ff
	// Position of HS2LP_TIME field.
	DSI_DSI_CLTCR_HS2LP_TIME_Pos = 0x10
	// Bit mask of HS2LP_TIME field.
	DSI_DSI_CLTCR_HS2LP_TIME_Msk = 0x3ff0000

	// DSI_DLTCR: DSI Host Data Lane Timer Configuration Register
	// Position of MRD_TIME field.
	DSI_DSI_DLTCR_MRD_TIME_Pos = 0x0
	// Bit mask of MRD_TIME field.
	DSI_DSI_DLTCR_MRD_TIME_Msk = 0x7fff
	// Position of LP2HS_TIME field.
	DSI_DSI_DLTCR_LP2HS_TIME_Pos = 0x10
	// Bit mask of LP2HS_TIME field.
	DSI_DSI_DLTCR_LP2HS_TIME_Msk = 0xff0000
	// Position of HS2LP_TIME field.
	DSI_DSI_DLTCR_HS2LP_TIME_Pos = 0x18
	// Bit mask of HS2LP_TIME field.
	DSI_DSI_DLTCR_HS2LP_TIME_Msk = 0xff000000

	// DSI_PCTLR: DSI Host PHY Control Register
	// Position of DEN field.
	DSI_DSI_PCTLR_DEN_Pos = 0x1
	// Bit mask of DEN field.
	DSI_DSI_PCTLR_DEN_Msk = 0x2
	// Bit DEN.
	DSI_DSI_PCTLR_DEN = 0x2
	// Position of CKE field.
	DSI_DSI_PCTLR_CKE_Pos = 0x2
	// Bit mask of CKE field.
	DSI_DSI_PCTLR_CKE_Msk = 0x4
	// Bit CKE.
	DSI_DSI_PCTLR_CKE = 0x4

	// DSI_PCONFR: DSI Host PHY Configuration Register
	// Position of NL field.
	DSI_DSI_PCONFR_NL_Pos = 0x0
	// Bit mask of NL field.
	DSI_DSI_PCONFR_NL_Msk = 0x3
	// Position of SW_TIME field.
	DSI_DSI_PCONFR_SW_TIME_Pos = 0x8
	// Bit mask of SW_TIME field.
	DSI_DSI_PCONFR_SW_TIME_Msk = 0xff00

	// DSI_PUCR: DSI Host PHY ULPS Control Register
	// Position of URCL field.
	DSI_DSI_PUCR_URCL_Pos = 0x0
	// Bit mask of URCL field.
	DSI_DSI_PUCR_URCL_Msk = 0x1
	// Bit URCL.
	DSI_DSI_PUCR_URCL = 0x1
	// Position of UECL field.
	DSI_DSI_PUCR_UECL_Pos = 0x1
	// Bit mask of UECL field.
	DSI_DSI_PUCR_UECL_Msk = 0x2
	// Bit UECL.
	DSI_DSI_PUCR_UECL = 0x2
	// Position of URDL field.
	DSI_DSI_PUCR_URDL_Pos = 0x2
	// Bit mask of URDL field.
	DSI_DSI_PUCR_URDL_Msk = 0x4
	// Bit URDL.
	DSI_DSI_PUCR_URDL = 0x4
	// Position of UEDL field.
	DSI_DSI_PUCR_UEDL_Pos = 0x3
	// Bit mask of UEDL field.
	DSI_DSI_PUCR_UEDL_Msk = 0x8
	// Bit UEDL.
	DSI_DSI_PUCR_UEDL = 0x8

	// DSI_PTTCR: DSI Host PHY TX Triggers Configuration Register
	// Position of TX_TRIG field.
	DSI_DSI_PTTCR_TX_TRIG_Pos = 0x0
	// Bit mask of TX_TRIG field.
	DSI_DSI_PTTCR_TX_TRIG_Msk = 0xf

	// DSI_PSR: DSI Host PHY Status Register
	// Position of PD field.
	DSI_DSI_PSR_PD_Pos = 0x1
	// Bit mask of PD field.
	DSI_DSI_PSR_PD_Msk = 0x2
	// Bit PD.
	DSI_DSI_PSR_PD = 0x2
	// Position of PSSC field.
	DSI_DSI_PSR_PSSC_Pos = 0x2
	// Bit mask of PSSC field.
	DSI_DSI_PSR_PSSC_Msk = 0x4
	// Bit PSSC.
	DSI_DSI_PSR_PSSC = 0x4
	// Position of UANC field.
	DSI_DSI_PSR_UANC_Pos = 0x3
	// Bit mask of UANC field.
	DSI_DSI_PSR_UANC_Msk = 0x8
	// Bit UANC.
	DSI_DSI_PSR_UANC = 0x8
	// Position of PSS0 field.
	DSI_DSI_PSR_PSS0_Pos = 0x4
	// Bit mask of PSS0 field.
	DSI_DSI_PSR_PSS0_Msk = 0x10
	// Bit PSS0.
	DSI_DSI_PSR_PSS0 = 0x10
	// Position of UAN0 field.
	DSI_DSI_PSR_UAN0_Pos = 0x5
	// Bit mask of UAN0 field.
	DSI_DSI_PSR_UAN0_Msk = 0x20
	// Bit UAN0.
	DSI_DSI_PSR_UAN0 = 0x20
	// Position of RUE0 field.
	DSI_DSI_PSR_RUE0_Pos = 0x6
	// Bit mask of RUE0 field.
	DSI_DSI_PSR_RUE0_Msk = 0x40
	// Bit RUE0.
	DSI_DSI_PSR_RUE0 = 0x40
	// Position of PSS1 field.
	DSI_DSI_PSR_PSS1_Pos = 0x7
	// Bit mask of PSS1 field.
	DSI_DSI_PSR_PSS1_Msk = 0x80
	// Bit PSS1.
	DSI_DSI_PSR_PSS1 = 0x80
	// Position of UAN1 field.
	DSI_DSI_PSR_UAN1_Pos = 0x8
	// Bit mask of UAN1 field.
	DSI_DSI_PSR_UAN1_Msk = 0x100
	// Bit UAN1.
	DSI_DSI_PSR_UAN1 = 0x100

	// DSI_ISR0: DSI Host Interrupt & Status Register 0
	// Position of AE0 field.
	DSI_DSI_ISR0_AE0_Pos = 0x0
	// Bit mask of AE0 field.
	DSI_DSI_ISR0_AE0_Msk = 0x1
	// Bit AE0.
	DSI_DSI_ISR0_AE0 = 0x1
	// Position of AE1 field.
	DSI_DSI_ISR0_AE1_Pos = 0x1
	// Bit mask of AE1 field.
	DSI_DSI_ISR0_AE1_Msk = 0x2
	// Bit AE1.
	DSI_DSI_ISR0_AE1 = 0x2
	// Position of AE2 field.
	DSI_DSI_ISR0_AE2_Pos = 0x2
	// Bit mask of AE2 field.
	DSI_DSI_ISR0_AE2_Msk = 0x4
	// Bit AE2.
	DSI_DSI_ISR0_AE2 = 0x4
	// Position of AE3 field.
	DSI_DSI_ISR0_AE3_Pos = 0x3
	// Bit mask of AE3 field.
	DSI_DSI_ISR0_AE3_Msk = 0x8
	// Bit AE3.
	DSI_DSI_ISR0_AE3 = 0x8
	// Position of AE4 field.
	DSI_DSI_ISR0_AE4_Pos = 0x4
	// Bit mask of AE4 field.
	DSI_DSI_ISR0_AE4_Msk = 0x10
	// Bit AE4.
	DSI_DSI_ISR0_AE4 = 0x10
	// Position of AE5 field.
	DSI_DSI_ISR0_AE5_Pos = 0x5
	// Bit mask of AE5 field.
	DSI_DSI_ISR0_AE5_Msk = 0x20
	// Bit AE5.
	DSI_DSI_ISR0_AE5 = 0x20
	// Position of AE6 field.
	DSI_DSI_ISR0_AE6_Pos = 0x6
	// Bit mask of AE6 field.
	DSI_DSI_ISR0_AE6_Msk = 0x40
	// Bit AE6.
	DSI_DSI_ISR0_AE6 = 0x40
	// Position of AE7 field.
	DSI_DSI_ISR0_AE7_Pos = 0x7
	// Bit mask of AE7 field.
	DSI_DSI_ISR0_AE7_Msk = 0x80
	// Bit AE7.
	DSI_DSI_ISR0_AE7 = 0x80
	// Position of AE8 field.
	DSI_DSI_ISR0_AE8_Pos = 0x8
	// Bit mask of AE8 field.
	DSI_DSI_ISR0_AE8_Msk = 0x100
	// Bit AE8.
	DSI_DSI_ISR0_AE8 = 0x100
	// Position of AE9 field.
	DSI_DSI_ISR0_AE9_Pos = 0x9
	// Bit mask of AE9 field.
	DSI_DSI_ISR0_AE9_Msk = 0x200
	// Bit AE9.
	DSI_DSI_ISR0_AE9 = 0x200
	// Position of AE10 field.
	DSI_DSI_ISR0_AE10_Pos = 0xa
	// Bit mask of AE10 field.
	DSI_DSI_ISR0_AE10_Msk = 0x400
	// Bit AE10.
	DSI_DSI_ISR0_AE10 = 0x400
	// Position of AE11 field.
	DSI_DSI_ISR0_AE11_Pos = 0xb
	// Bit mask of AE11 field.
	DSI_DSI_ISR0_AE11_Msk = 0x800
	// Bit AE11.
	DSI_DSI_ISR0_AE11 = 0x800
	// Position of AE12 field.
	DSI_DSI_ISR0_AE12_Pos = 0xc
	// Bit mask of AE12 field.
	DSI_DSI_ISR0_AE12_Msk = 0x1000
	// Bit AE12.
	DSI_DSI_ISR0_AE12 = 0x1000
	// Position of AE13 field.
	DSI_DSI_ISR0_AE13_Pos = 0xd
	// Bit mask of AE13 field.
	DSI_DSI_ISR0_AE13_Msk = 0x2000
	// Bit AE13.
	DSI_DSI_ISR0_AE13 = 0x2000
	// Position of AE14 field.
	DSI_DSI_ISR0_AE14_Pos = 0xe
	// Bit mask of AE14 field.
	DSI_DSI_ISR0_AE14_Msk = 0x4000
	// Bit AE14.
	DSI_DSI_ISR0_AE14 = 0x4000
	// Position of AE15 field.
	DSI_DSI_ISR0_AE15_Pos = 0xf
	// Bit mask of AE15 field.
	DSI_DSI_ISR0_AE15_Msk = 0x8000
	// Bit AE15.
	DSI_DSI_ISR0_AE15 = 0x8000
	// Position of PE0 field.
	DSI_DSI_ISR0_PE0_Pos = 0x10
	// Bit mask of PE0 field.
	DSI_DSI_ISR0_PE0_Msk = 0x10000
	// Bit PE0.
	DSI_DSI_ISR0_PE0 = 0x10000
	// Position of PE1 field.
	DSI_DSI_ISR0_PE1_Pos = 0x11
	// Bit mask of PE1 field.
	DSI_DSI_ISR0_PE1_Msk = 0x20000
	// Bit PE1.
	DSI_DSI_ISR0_PE1 = 0x20000
	// Position of PE2 field.
	DSI_DSI_ISR0_PE2_Pos = 0x12
	// Bit mask of PE2 field.
	DSI_DSI_ISR0_PE2_Msk = 0x40000
	// Bit PE2.
	DSI_DSI_ISR0_PE2 = 0x40000
	// Position of PE3 field.
	DSI_DSI_ISR0_PE3_Pos = 0x13
	// Bit mask of PE3 field.
	DSI_DSI_ISR0_PE3_Msk = 0x80000
	// Bit PE3.
	DSI_DSI_ISR0_PE3 = 0x80000
	// Position of PE4 field.
	DSI_DSI_ISR0_PE4_Pos = 0x14
	// Bit mask of PE4 field.
	DSI_DSI_ISR0_PE4_Msk = 0x100000
	// Bit PE4.
	DSI_DSI_ISR0_PE4 = 0x100000

	// DSI_ISR1: DSI Host Interrupt & Status Register 1
	// Position of TOHSTX field.
	DSI_DSI_ISR1_TOHSTX_Pos = 0x0
	// Bit mask of TOHSTX field.
	DSI_DSI_ISR1_TOHSTX_Msk = 0x1
	// Bit TOHSTX.
	DSI_DSI_ISR1_TOHSTX = 0x1
	// Position of TOLPRX field.
	DSI_DSI_ISR1_TOLPRX_Pos = 0x1
	// Bit mask of TOLPRX field.
	DSI_DSI_ISR1_TOLPRX_Msk = 0x2
	// Bit TOLPRX.
	DSI_DSI_ISR1_TOLPRX = 0x2
	// Position of ECCSE field.
	DSI_DSI_ISR1_ECCSE_Pos = 0x2
	// Bit mask of ECCSE field.
	DSI_DSI_ISR1_ECCSE_Msk = 0x4
	// Bit ECCSE.
	DSI_DSI_ISR1_ECCSE = 0x4
	// Position of ECCME field.
	DSI_DSI_ISR1_ECCME_Pos = 0x3
	// Bit mask of ECCME field.
	DSI_DSI_ISR1_ECCME_Msk = 0x8
	// Bit ECCME.
	DSI_DSI_ISR1_ECCME = 0x8
	// Position of CRCE field.
	DSI_DSI_ISR1_CRCE_Pos = 0x4
	// Bit mask of CRCE field.
	DSI_DSI_ISR1_CRCE_Msk = 0x10
	// Bit CRCE.
	DSI_DSI_ISR1_CRCE = 0x10
	// Position of PSE field.
	DSI_DSI_ISR1_PSE_Pos = 0x5
	// Bit mask of PSE field.
	DSI_DSI_ISR1_PSE_Msk = 0x20
	// Bit PSE.
	DSI_DSI_ISR1_PSE = 0x20
	// Position of EOTPE field.
	DSI_DSI_ISR1_EOTPE_Pos = 0x6
	// Bit mask of EOTPE field.
	DSI_DSI_ISR1_EOTPE_Msk = 0x40
	// Bit EOTPE.
	DSI_DSI_ISR1_EOTPE = 0x40
	// Position of LPWRE field.
	DSI_DSI_ISR1_LPWRE_Pos = 0x7
	// Bit mask of LPWRE field.
	DSI_DSI_ISR1_LPWRE_Msk = 0x80
	// Bit LPWRE.
	DSI_DSI_ISR1_LPWRE = 0x80
	// Position of GCWRE field.
	DSI_DSI_ISR1_GCWRE_Pos = 0x8
	// Bit mask of GCWRE field.
	DSI_DSI_ISR1_GCWRE_Msk = 0x100
	// Bit GCWRE.
	DSI_DSI_ISR1_GCWRE = 0x100
	// Position of GPWRE field.
	DSI_DSI_ISR1_GPWRE_Pos = 0x9
	// Bit mask of GPWRE field.
	DSI_DSI_ISR1_GPWRE_Msk = 0x200
	// Bit GPWRE.
	DSI_DSI_ISR1_GPWRE = 0x200
	// Position of GPTXE field.
	DSI_DSI_ISR1_GPTXE_Pos = 0xa
	// Bit mask of GPTXE field.
	DSI_DSI_ISR1_GPTXE_Msk = 0x400
	// Bit GPTXE.
	DSI_DSI_ISR1_GPTXE = 0x400
	// Position of GPRDE field.
	DSI_DSI_ISR1_GPRDE_Pos = 0xb
	// Bit mask of GPRDE field.
	DSI_DSI_ISR1_GPRDE_Msk = 0x800
	// Bit GPRDE.
	DSI_DSI_ISR1_GPRDE = 0x800
	// Position of GPRXE field.
	DSI_DSI_ISR1_GPRXE_Pos = 0xc
	// Bit mask of GPRXE field.
	DSI_DSI_ISR1_GPRXE_Msk = 0x1000
	// Bit GPRXE.
	DSI_DSI_ISR1_GPRXE = 0x1000

	// DSI_IER0: DSI Host Interrupt Enable Register 0
	// Position of AE0IE field.
	DSI_DSI_IER0_AE0IE_Pos = 0x0
	// Bit mask of AE0IE field.
	DSI_DSI_IER0_AE0IE_Msk = 0x1
	// Bit AE0IE.
	DSI_DSI_IER0_AE0IE = 0x1
	// Position of AE1IE field.
	DSI_DSI_IER0_AE1IE_Pos = 0x1
	// Bit mask of AE1IE field.
	DSI_DSI_IER0_AE1IE_Msk = 0x2
	// Bit AE1IE.
	DSI_DSI_IER0_AE1IE = 0x2
	// Position of AE2IE field.
	DSI_DSI_IER0_AE2IE_Pos = 0x2
	// Bit mask of AE2IE field.
	DSI_DSI_IER0_AE2IE_Msk = 0x4
	// Bit AE2IE.
	DSI_DSI_IER0_AE2IE = 0x4
	// Position of AE3IE field.
	DSI_DSI_IER0_AE3IE_Pos = 0x3
	// Bit mask of AE3IE field.
	DSI_DSI_IER0_AE3IE_Msk = 0x8
	// Bit AE3IE.
	DSI_DSI_IER0_AE3IE = 0x8
	// Position of AE4IE field.
	DSI_DSI_IER0_AE4IE_Pos = 0x4
	// Bit mask of AE4IE field.
	DSI_DSI_IER0_AE4IE_Msk = 0x10
	// Bit AE4IE.
	DSI_DSI_IER0_AE4IE = 0x10
	// Position of AE5IE field.
	DSI_DSI_IER0_AE5IE_Pos = 0x5
	// Bit mask of AE5IE field.
	DSI_DSI_IER0_AE5IE_Msk = 0x20
	// Bit AE5IE.
	DSI_DSI_IER0_AE5IE = 0x20
	// Position of AE6IE field.
	DSI_DSI_IER0_AE6IE_Pos = 0x6
	// Bit mask of AE6IE field.
	DSI_DSI_IER0_AE6IE_Msk = 0x40
	// Bit AE6IE.
	DSI_DSI_IER0_AE6IE = 0x40
	// Position of AE7IE field.
	DSI_DSI_IER0_AE7IE_Pos = 0x7
	// Bit mask of AE7IE field.
	DSI_DSI_IER0_AE7IE_Msk = 0x80
	// Bit AE7IE.
	DSI_DSI_IER0_AE7IE = 0x80
	// Position of AE8IE field.
	DSI_DSI_IER0_AE8IE_Pos = 0x8
	// Bit mask of AE8IE field.
	DSI_DSI_IER0_AE8IE_Msk = 0x100
	// Bit AE8IE.
	DSI_DSI_IER0_AE8IE = 0x100
	// Position of AE9IE field.
	DSI_DSI_IER0_AE9IE_Pos = 0x9
	// Bit mask of AE9IE field.
	DSI_DSI_IER0_AE9IE_Msk = 0x200
	// Bit AE9IE.
	DSI_DSI_IER0_AE9IE = 0x200
	// Position of AE10IE field.
	DSI_DSI_IER0_AE10IE_Pos = 0xa
	// Bit mask of AE10IE field.
	DSI_DSI_IER0_AE10IE_Msk = 0x400
	// Bit AE10IE.
	DSI_DSI_IER0_AE10IE = 0x400
	// Position of AE11IE field.
	DSI_DSI_IER0_AE11IE_Pos = 0xb
	// Bit mask of AE11IE field.
	DSI_DSI_IER0_AE11IE_Msk = 0x800
	// Bit AE11IE.
	DSI_DSI_IER0_AE11IE = 0x800
	// Position of AE12IE field.
	DSI_DSI_IER0_AE12IE_Pos = 0xc
	// Bit mask of AE12IE field.
	DSI_DSI_IER0_AE12IE_Msk = 0x1000
	// Bit AE12IE.
	DSI_DSI_IER0_AE12IE = 0x1000
	// Position of AE13IE field.
	DSI_DSI_IER0_AE13IE_Pos = 0xd
	// Bit mask of AE13IE field.
	DSI_DSI_IER0_AE13IE_Msk = 0x2000
	// Bit AE13IE.
	DSI_DSI_IER0_AE13IE = 0x2000
	// Position of AE14IE field.
	DSI_DSI_IER0_AE14IE_Pos = 0xe
	// Bit mask of AE14IE field.
	DSI_DSI_IER0_AE14IE_Msk = 0x4000
	// Bit AE14IE.
	DSI_DSI_IER0_AE14IE = 0x4000
	// Position of AE15IE field.
	DSI_DSI_IER0_AE15IE_Pos = 0xf
	// Bit mask of AE15IE field.
	DSI_DSI_IER0_AE15IE_Msk = 0x8000
	// Bit AE15IE.
	DSI_DSI_IER0_AE15IE = 0x8000
	// Position of PE0IE field.
	DSI_DSI_IER0_PE0IE_Pos = 0x10
	// Bit mask of PE0IE field.
	DSI_DSI_IER0_PE0IE_Msk = 0x10000
	// Bit PE0IE.
	DSI_DSI_IER0_PE0IE = 0x10000
	// Position of PE1IE field.
	DSI_DSI_IER0_PE1IE_Pos = 0x11
	// Bit mask of PE1IE field.
	DSI_DSI_IER0_PE1IE_Msk = 0x20000
	// Bit PE1IE.
	DSI_DSI_IER0_PE1IE = 0x20000
	// Position of PE2IE field.
	DSI_DSI_IER0_PE2IE_Pos = 0x12
	// Bit mask of PE2IE field.
	DSI_DSI_IER0_PE2IE_Msk = 0x40000
	// Bit PE2IE.
	DSI_DSI_IER0_PE2IE = 0x40000
	// Position of PE3IE field.
	DSI_DSI_IER0_PE3IE_Pos = 0x13
	// Bit mask of PE3IE field.
	DSI_DSI_IER0_PE3IE_Msk = 0x80000
	// Bit PE3IE.
	DSI_DSI_IER0_PE3IE = 0x80000
	// Position of PE4IE field.
	DSI_DSI_IER0_PE4IE_Pos = 0x14
	// Bit mask of PE4IE field.
	DSI_DSI_IER0_PE4IE_Msk = 0x100000
	// Bit PE4IE.
	DSI_DSI_IER0_PE4IE = 0x100000

	// DSI_IER1: DSI Host Interrupt Enable Register 1
	// Position of TOHSTXIE field.
	DSI_DSI_IER1_TOHSTXIE_Pos = 0x0
	// Bit mask of TOHSTXIE field.
	DSI_DSI_IER1_TOHSTXIE_Msk = 0x1
	// Bit TOHSTXIE.
	DSI_DSI_IER1_TOHSTXIE = 0x1
	// Position of TOLPRXIE field.
	DSI_DSI_IER1_TOLPRXIE_Pos = 0x1
	// Bit mask of TOLPRXIE field.
	DSI_DSI_IER1_TOLPRXIE_Msk = 0x2
	// Bit TOLPRXIE.
	DSI_DSI_IER1_TOLPRXIE = 0x2
	// Position of ECCSEIE field.
	DSI_DSI_IER1_ECCSEIE_Pos = 0x2
	// Bit mask of ECCSEIE field.
	DSI_DSI_IER1_ECCSEIE_Msk = 0x4
	// Bit ECCSEIE.
	DSI_DSI_IER1_ECCSEIE = 0x4
	// Position of ECCMEIE field.
	DSI_DSI_IER1_ECCMEIE_Pos = 0x3
	// Bit mask of ECCMEIE field.
	DSI_DSI_IER1_ECCMEIE_Msk = 0x8
	// Bit ECCMEIE.
	DSI_DSI_IER1_ECCMEIE = 0x8
	// Position of CRCEIE field.
	DSI_DSI_IER1_CRCEIE_Pos = 0x4
	// Bit mask of CRCEIE field.
	DSI_DSI_IER1_CRCEIE_Msk = 0x10
	// Bit CRCEIE.
	DSI_DSI_IER1_CRCEIE = 0x10
	// Position of PSEIE field.
	DSI_DSI_IER1_PSEIE_Pos = 0x5
	// Bit mask of PSEIE field.
	DSI_DSI_IER1_PSEIE_Msk = 0x20
	// Bit PSEIE.
	DSI_DSI_IER1_PSEIE = 0x20
	// Position of EOTPEIE field.
	DSI_DSI_IER1_EOTPEIE_Pos = 0x6
	// Bit mask of EOTPEIE field.
	DSI_DSI_IER1_EOTPEIE_Msk = 0x40
	// Bit EOTPEIE.
	DSI_DSI_IER1_EOTPEIE = 0x40
	// Position of LPWREIE field.
	DSI_DSI_IER1_LPWREIE_Pos = 0x7
	// Bit mask of LPWREIE field.
	DSI_DSI_IER1_LPWREIE_Msk = 0x80
	// Bit LPWREIE.
	DSI_DSI_IER1_LPWREIE = 0x80
	// Position of GCWREIE field.
	DSI_DSI_IER1_GCWREIE_Pos = 0x8
	// Bit mask of GCWREIE field.
	DSI_DSI_IER1_GCWREIE_Msk = 0x100
	// Bit GCWREIE.
	DSI_DSI_IER1_GCWREIE = 0x100
	// Position of GPWREIE field.
	DSI_DSI_IER1_GPWREIE_Pos = 0x9
	// Bit mask of GPWREIE field.
	DSI_DSI_IER1_GPWREIE_Msk = 0x200
	// Bit GPWREIE.
	DSI_DSI_IER1_GPWREIE = 0x200
	// Position of GPTXEIE field.
	DSI_DSI_IER1_GPTXEIE_Pos = 0xa
	// Bit mask of GPTXEIE field.
	DSI_DSI_IER1_GPTXEIE_Msk = 0x400
	// Bit GPTXEIE.
	DSI_DSI_IER1_GPTXEIE = 0x400
	// Position of GPRDEIE field.
	DSI_DSI_IER1_GPRDEIE_Pos = 0xb
	// Bit mask of GPRDEIE field.
	DSI_DSI_IER1_GPRDEIE_Msk = 0x800
	// Bit GPRDEIE.
	DSI_DSI_IER1_GPRDEIE = 0x800
	// Position of GPRXEIE field.
	DSI_DSI_IER1_GPRXEIE_Pos = 0xc
	// Bit mask of GPRXEIE field.
	DSI_DSI_IER1_GPRXEIE_Msk = 0x1000
	// Bit GPRXEIE.
	DSI_DSI_IER1_GPRXEIE = 0x1000

	// DSI_FIR0: DSI Host Force Interrupt Register 0
	// Position of FAE0 field.
	DSI_DSI_FIR0_FAE0_Pos = 0x0
	// Bit mask of FAE0 field.
	DSI_DSI_FIR0_FAE0_Msk = 0x1
	// Bit FAE0.
	DSI_DSI_FIR0_FAE0 = 0x1
	// Position of FAE1 field.
	DSI_DSI_FIR0_FAE1_Pos = 0x1
	// Bit mask of FAE1 field.
	DSI_DSI_FIR0_FAE1_Msk = 0x2
	// Bit FAE1.
	DSI_DSI_FIR0_FAE1 = 0x2
	// Position of FAE2 field.
	DSI_DSI_FIR0_FAE2_Pos = 0x2
	// Bit mask of FAE2 field.
	DSI_DSI_FIR0_FAE2_Msk = 0x4
	// Bit FAE2.
	DSI_DSI_FIR0_FAE2 = 0x4
	// Position of FAE3 field.
	DSI_DSI_FIR0_FAE3_Pos = 0x3
	// Bit mask of FAE3 field.
	DSI_DSI_FIR0_FAE3_Msk = 0x8
	// Bit FAE3.
	DSI_DSI_FIR0_FAE3 = 0x8
	// Position of FAE4 field.
	DSI_DSI_FIR0_FAE4_Pos = 0x4
	// Bit mask of FAE4 field.
	DSI_DSI_FIR0_FAE4_Msk = 0x10
	// Bit FAE4.
	DSI_DSI_FIR0_FAE4 = 0x10
	// Position of FAE5 field.
	DSI_DSI_FIR0_FAE5_Pos = 0x5
	// Bit mask of FAE5 field.
	DSI_DSI_FIR0_FAE5_Msk = 0x20
	// Bit FAE5.
	DSI_DSI_FIR0_FAE5 = 0x20
	// Position of FAE6 field.
	DSI_DSI_FIR0_FAE6_Pos = 0x6
	// Bit mask of FAE6 field.
	DSI_DSI_FIR0_FAE6_Msk = 0x40
	// Bit FAE6.
	DSI_DSI_FIR0_FAE6 = 0x40
	// Position of FAE7 field.
	DSI_DSI_FIR0_FAE7_Pos = 0x7
	// Bit mask of FAE7 field.
	DSI_DSI_FIR0_FAE7_Msk = 0x80
	// Bit FAE7.
	DSI_DSI_FIR0_FAE7 = 0x80
	// Position of FAE8 field.
	DSI_DSI_FIR0_FAE8_Pos = 0x8
	// Bit mask of FAE8 field.
	DSI_DSI_FIR0_FAE8_Msk = 0x100
	// Bit FAE8.
	DSI_DSI_FIR0_FAE8 = 0x100
	// Position of FAE9 field.
	DSI_DSI_FIR0_FAE9_Pos = 0x9
	// Bit mask of FAE9 field.
	DSI_DSI_FIR0_FAE9_Msk = 0x200
	// Bit FAE9.
	DSI_DSI_FIR0_FAE9 = 0x200
	// Position of FAE10 field.
	DSI_DSI_FIR0_FAE10_Pos = 0xa
	// Bit mask of FAE10 field.
	DSI_DSI_FIR0_FAE10_Msk = 0x400
	// Bit FAE10.
	DSI_DSI_FIR0_FAE10 = 0x400
	// Position of FAE11 field.
	DSI_DSI_FIR0_FAE11_Pos = 0xb
	// Bit mask of FAE11 field.
	DSI_DSI_FIR0_FAE11_Msk = 0x800
	// Bit FAE11.
	DSI_DSI_FIR0_FAE11 = 0x800
	// Position of FAE12 field.
	DSI_DSI_FIR0_FAE12_Pos = 0xc
	// Bit mask of FAE12 field.
	DSI_DSI_FIR0_FAE12_Msk = 0x1000
	// Bit FAE12.
	DSI_DSI_FIR0_FAE12 = 0x1000
	// Position of FAE13 field.
	DSI_DSI_FIR0_FAE13_Pos = 0xd
	// Bit mask of FAE13 field.
	DSI_DSI_FIR0_FAE13_Msk = 0x2000
	// Bit FAE13.
	DSI_DSI_FIR0_FAE13 = 0x2000
	// Position of FAE14 field.
	DSI_DSI_FIR0_FAE14_Pos = 0xe
	// Bit mask of FAE14 field.
	DSI_DSI_FIR0_FAE14_Msk = 0x4000
	// Bit FAE14.
	DSI_DSI_FIR0_FAE14 = 0x4000
	// Position of FAE15 field.
	DSI_DSI_FIR0_FAE15_Pos = 0xf
	// Bit mask of FAE15 field.
	DSI_DSI_FIR0_FAE15_Msk = 0x8000
	// Bit FAE15.
	DSI_DSI_FIR0_FAE15 = 0x8000
	// Position of FPE0 field.
	DSI_DSI_FIR0_FPE0_Pos = 0x10
	// Bit mask of FPE0 field.
	DSI_DSI_FIR0_FPE0_Msk = 0x10000
	// Bit FPE0.
	DSI_DSI_FIR0_FPE0 = 0x10000
	// Position of FPE1 field.
	DSI_DSI_FIR0_FPE1_Pos = 0x11
	// Bit mask of FPE1 field.
	DSI_DSI_FIR0_FPE1_Msk = 0x20000
	// Bit FPE1.
	DSI_DSI_FIR0_FPE1 = 0x20000
	// Position of FPE2 field.
	DSI_DSI_FIR0_FPE2_Pos = 0x12
	// Bit mask of FPE2 field.
	DSI_DSI_FIR0_FPE2_Msk = 0x40000
	// Bit FPE2.
	DSI_DSI_FIR0_FPE2 = 0x40000
	// Position of FPE3 field.
	DSI_DSI_FIR0_FPE3_Pos = 0x13
	// Bit mask of FPE3 field.
	DSI_DSI_FIR0_FPE3_Msk = 0x80000
	// Bit FPE3.
	DSI_DSI_FIR0_FPE3 = 0x80000
	// Position of FPE4 field.
	DSI_DSI_FIR0_FPE4_Pos = 0x14
	// Bit mask of FPE4 field.
	DSI_DSI_FIR0_FPE4_Msk = 0x100000
	// Bit FPE4.
	DSI_DSI_FIR0_FPE4 = 0x100000

	// DSI_FIR1: DSI Host Force Interrupt Register 1
	// Position of FTOHSTX field.
	DSI_DSI_FIR1_FTOHSTX_Pos = 0x0
	// Bit mask of FTOHSTX field.
	DSI_DSI_FIR1_FTOHSTX_Msk = 0x1
	// Bit FTOHSTX.
	DSI_DSI_FIR1_FTOHSTX = 0x1
	// Position of FTOLPRX field.
	DSI_DSI_FIR1_FTOLPRX_Pos = 0x1
	// Bit mask of FTOLPRX field.
	DSI_DSI_FIR1_FTOLPRX_Msk = 0x2
	// Bit FTOLPRX.
	DSI_DSI_FIR1_FTOLPRX = 0x2
	// Position of FECCSE field.
	DSI_DSI_FIR1_FECCSE_Pos = 0x2
	// Bit mask of FECCSE field.
	DSI_DSI_FIR1_FECCSE_Msk = 0x4
	// Bit FECCSE.
	DSI_DSI_FIR1_FECCSE = 0x4
	// Position of FECCME field.
	DSI_DSI_FIR1_FECCME_Pos = 0x3
	// Bit mask of FECCME field.
	DSI_DSI_FIR1_FECCME_Msk = 0x8
	// Bit FECCME.
	DSI_DSI_FIR1_FECCME = 0x8
	// Position of FCRCE field.
	DSI_DSI_FIR1_FCRCE_Pos = 0x4
	// Bit mask of FCRCE field.
	DSI_DSI_FIR1_FCRCE_Msk = 0x10
	// Bit FCRCE.
	DSI_DSI_FIR1_FCRCE = 0x10
	// Position of FPSE field.
	DSI_DSI_FIR1_FPSE_Pos = 0x5
	// Bit mask of FPSE field.
	DSI_DSI_FIR1_FPSE_Msk = 0x20
	// Bit FPSE.
	DSI_DSI_FIR1_FPSE = 0x20
	// Position of FEOTPE field.
	DSI_DSI_FIR1_FEOTPE_Pos = 0x6
	// Bit mask of FEOTPE field.
	DSI_DSI_FIR1_FEOTPE_Msk = 0x40
	// Bit FEOTPE.
	DSI_DSI_FIR1_FEOTPE = 0x40
	// Position of FLPWRE field.
	DSI_DSI_FIR1_FLPWRE_Pos = 0x7
	// Bit mask of FLPWRE field.
	DSI_DSI_FIR1_FLPWRE_Msk = 0x80
	// Bit FLPWRE.
	DSI_DSI_FIR1_FLPWRE = 0x80
	// Position of FGCWRE field.
	DSI_DSI_FIR1_FGCWRE_Pos = 0x8
	// Bit mask of FGCWRE field.
	DSI_DSI_FIR1_FGCWRE_Msk = 0x100
	// Bit FGCWRE.
	DSI_DSI_FIR1_FGCWRE = 0x100
	// Position of FGPWRE field.
	DSI_DSI_FIR1_FGPWRE_Pos = 0x9
	// Bit mask of FGPWRE field.
	DSI_DSI_FIR1_FGPWRE_Msk = 0x200
	// Bit FGPWRE.
	DSI_DSI_FIR1_FGPWRE = 0x200
	// Position of FGPTXE field.
	DSI_DSI_FIR1_FGPTXE_Pos = 0xa
	// Bit mask of FGPTXE field.
	DSI_DSI_FIR1_FGPTXE_Msk = 0x400
	// Bit FGPTXE.
	DSI_DSI_FIR1_FGPTXE = 0x400
	// Position of FGPRDE field.
	DSI_DSI_FIR1_FGPRDE_Pos = 0xb
	// Bit mask of FGPRDE field.
	DSI_DSI_FIR1_FGPRDE_Msk = 0x800
	// Bit FGPRDE.
	DSI_DSI_FIR1_FGPRDE = 0x800
	// Position of FGPRXE field.
	DSI_DSI_FIR1_FGPRXE_Pos = 0xc
	// Bit mask of FGPRXE field.
	DSI_DSI_FIR1_FGPRXE_Msk = 0x1000
	// Bit FGPRXE.
	DSI_DSI_FIR1_FGPRXE = 0x1000

	// DSI_VSCR: DSI Host Video Shadow Control Register
	// Position of EN field.
	DSI_DSI_VSCR_EN_Pos = 0x0
	// Bit mask of EN field.
	DSI_DSI_VSCR_EN_Msk = 0x1
	// Bit EN.
	DSI_DSI_VSCR_EN = 0x1
	// Position of UR field.
	DSI_DSI_VSCR_UR_Pos = 0x8
	// Bit mask of UR field.
	DSI_DSI_VSCR_UR_Msk = 0x100
	// Bit UR.
	DSI_DSI_VSCR_UR = 0x100

	// DSI_LCVCIDR: DSI Host LTDC Current VCID Register
	// Position of VCID field.
	DSI_DSI_LCVCIDR_VCID_Pos = 0x0
	// Bit mask of VCID field.
	DSI_DSI_LCVCIDR_VCID_Msk = 0x3

	// DSI_LCCCR: DSI Host LTDC Current Color Coding Register
	// Position of COLC field.
	DSI_DSI_LCCCR_COLC_Pos = 0x0
	// Bit mask of COLC field.
	DSI_DSI_LCCCR_COLC_Msk = 0xf
	// Position of LPE field.
	DSI_DSI_LCCCR_LPE_Pos = 0x8
	// Bit mask of LPE field.
	DSI_DSI_LCCCR_LPE_Msk = 0x100
	// Bit LPE.
	DSI_DSI_LCCCR_LPE = 0x100

	// DSI_LPMCCR: DSI Host Low-Power mode Current Configuration Register
	// Position of VLPSIZE field.
	DSI_DSI_LPMCCR_VLPSIZE_Pos = 0x0
	// Bit mask of VLPSIZE field.
	DSI_DSI_LPMCCR_VLPSIZE_Msk = 0xff
	// Position of LPSIZE field.
	DSI_DSI_LPMCCR_LPSIZE_Pos = 0x10
	// Bit mask of LPSIZE field.
	DSI_DSI_LPMCCR_LPSIZE_Msk = 0xff0000

	// DSI_VMCCR: DSI Host Video mode Current Configuration Register
	// Position of VMT field.
	DSI_DSI_VMCCR_VMT_Pos = 0x0
	// Bit mask of VMT field.
	DSI_DSI_VMCCR_VMT_Msk = 0x3
	// Position of LPVSAE field.
	DSI_DSI_VMCCR_LPVSAE_Pos = 0x2
	// Bit mask of LPVSAE field.
	DSI_DSI_VMCCR_LPVSAE_Msk = 0x4
	// Bit LPVSAE.
	DSI_DSI_VMCCR_LPVSAE = 0x4
	// Position of LPVBPE field.
	DSI_DSI_VMCCR_LPVBPE_Pos = 0x3
	// Bit mask of LPVBPE field.
	DSI_DSI_VMCCR_LPVBPE_Msk = 0x8
	// Bit LPVBPE.
	DSI_DSI_VMCCR_LPVBPE = 0x8
	// Position of LPVFPE field.
	DSI_DSI_VMCCR_LPVFPE_Pos = 0x4
	// Bit mask of LPVFPE field.
	DSI_DSI_VMCCR_LPVFPE_Msk = 0x10
	// Bit LPVFPE.
	DSI_DSI_VMCCR_LPVFPE = 0x10
	// Position of LPVAE field.
	DSI_DSI_VMCCR_LPVAE_Pos = 0x5
	// Bit mask of LPVAE field.
	DSI_DSI_VMCCR_LPVAE_Msk = 0x20
	// Bit LPVAE.
	DSI_DSI_VMCCR_LPVAE = 0x20
	// Position of LPHBPE field.
	DSI_DSI_VMCCR_LPHBPE_Pos = 0x6
	// Bit mask of LPHBPE field.
	DSI_DSI_VMCCR_LPHBPE_Msk = 0x40
	// Bit LPHBPE.
	DSI_DSI_VMCCR_LPHBPE = 0x40
	// Position of LPHFE field.
	DSI_DSI_VMCCR_LPHFE_Pos = 0x7
	// Bit mask of LPHFE field.
	DSI_DSI_VMCCR_LPHFE_Msk = 0x80
	// Bit LPHFE.
	DSI_DSI_VMCCR_LPHFE = 0x80
	// Position of FBTAAE field.
	DSI_DSI_VMCCR_FBTAAE_Pos = 0x8
	// Bit mask of FBTAAE field.
	DSI_DSI_VMCCR_FBTAAE_Msk = 0x100
	// Bit FBTAAE.
	DSI_DSI_VMCCR_FBTAAE = 0x100
	// Position of LPCE field.
	DSI_DSI_VMCCR_LPCE_Pos = 0x9
	// Bit mask of LPCE field.
	DSI_DSI_VMCCR_LPCE_Msk = 0x200
	// Bit LPCE.
	DSI_DSI_VMCCR_LPCE = 0x200

	// DSI_VPCCR: DSI Host Video Packet Current Configuration Register
	// Position of VPSIZE field.
	DSI_DSI_VPCCR_VPSIZE_Pos = 0x0
	// Bit mask of VPSIZE field.
	DSI_DSI_VPCCR_VPSIZE_Msk = 0x3fff

	// DSI_VCCCR: DSI Host Video Chunks Current Configuration Register
	// Position of NUMC field.
	DSI_DSI_VCCCR_NUMC_Pos = 0x0
	// Bit mask of NUMC field.
	DSI_DSI_VCCCR_NUMC_Msk = 0x1fff

	// DSI_VNPCCR: DSI Host Video Null Packet Current Configuration Register
	// Position of NPSIZE field.
	DSI_DSI_VNPCCR_NPSIZE_Pos = 0x0
	// Bit mask of NPSIZE field.
	DSI_DSI_VNPCCR_NPSIZE_Msk = 0x1fff

	// DSI_VHSACCR: DSI Host Video HSA Current Configuration Register
	// Position of HSA field.
	DSI_DSI_VHSACCR_HSA_Pos = 0x0
	// Bit mask of HSA field.
	DSI_DSI_VHSACCR_HSA_Msk = 0xfff

	// DSI_VHBPCCR: DSI Host Video HBP Current Configuration Register
	// Position of HBP field.
	DSI_DSI_VHBPCCR_HBP_Pos = 0x0
	// Bit mask of HBP field.
	DSI_DSI_VHBPCCR_HBP_Msk = 0xfff

	// DSI_VLCCR: DSI Host Video Line Current Configuration Register
	// Position of HLINE field.
	DSI_DSI_VLCCR_HLINE_Pos = 0x0
	// Bit mask of HLINE field.
	DSI_DSI_VLCCR_HLINE_Msk = 0x7fff

	// DSI_VVSACCR: DSI Host Video VSA Current Configuration Register
	// Position of VSA field.
	DSI_DSI_VVSACCR_VSA_Pos = 0x0
	// Bit mask of VSA field.
	DSI_DSI_VVSACCR_VSA_Msk = 0x3ff

	// DSI_VVBPCCR: DSI Host Video VBP Current Configuration Register
	// Position of VBP field.
	DSI_DSI_VVBPCCR_VBP_Pos = 0x0
	// Bit mask of VBP field.
	DSI_DSI_VVBPCCR_VBP_Msk = 0x3ff

	// DSI_VVFPCCR: DSI Host Video VFP Current Configuration Register
	// Position of VFP field.
	DSI_DSI_VVFPCCR_VFP_Pos = 0x0
	// Bit mask of VFP field.
	DSI_DSI_VVFPCCR_VFP_Msk = 0x3ff

	// DSI_VVACCR: DSI Host Video VA Current Configuration Register
	// Position of VA field.
	DSI_DSI_VVACCR_VA_Pos = 0x0
	// Bit mask of VA field.
	DSI_DSI_VVACCR_VA_Msk = 0x3fff

	// DSI_WCFGR: DSI Wrapper Configuration Register
	// Position of VSPOL field.
	DSI_DSI_WCFGR_VSPOL_Pos = 0x7
	// Bit mask of VSPOL field.
	DSI_DSI_WCFGR_VSPOL_Msk = 0x80
	// Bit VSPOL.
	DSI_DSI_WCFGR_VSPOL = 0x80
	// Position of AR field.
	DSI_DSI_WCFGR_AR_Pos = 0x6
	// Bit mask of AR field.
	DSI_DSI_WCFGR_AR_Msk = 0x40
	// Bit AR.
	DSI_DSI_WCFGR_AR = 0x40
	// Position of TEPOL field.
	DSI_DSI_WCFGR_TEPOL_Pos = 0x5
	// Bit mask of TEPOL field.
	DSI_DSI_WCFGR_TEPOL_Msk = 0x20
	// Bit TEPOL.
	DSI_DSI_WCFGR_TEPOL = 0x20
	// Position of TESRC field.
	DSI_DSI_WCFGR_TESRC_Pos = 0x4
	// Bit mask of TESRC field.
	DSI_DSI_WCFGR_TESRC_Msk = 0x10
	// Bit TESRC.
	DSI_DSI_WCFGR_TESRC = 0x10
	// Position of COLMUX field.
	DSI_DSI_WCFGR_COLMUX_Pos = 0x1
	// Bit mask of COLMUX field.
	DSI_DSI_WCFGR_COLMUX_Msk = 0xe
	// Position of DSIM field.
	DSI_DSI_WCFGR_DSIM_Pos = 0x0
	// Bit mask of DSIM field.
	DSI_DSI_WCFGR_DSIM_Msk = 0x1
	// Bit DSIM.
	DSI_DSI_WCFGR_DSIM = 0x1

	// DSI_WCR: DSI Wrapper Control Register
	// Position of DSIEN field.
	DSI_DSI_WCR_DSIEN_Pos = 0x3
	// Bit mask of DSIEN field.
	DSI_DSI_WCR_DSIEN_Msk = 0x8
	// Bit DSIEN.
	DSI_DSI_WCR_DSIEN = 0x8
	// Position of LTDCEN field.
	DSI_DSI_WCR_LTDCEN_Pos = 0x2
	// Bit mask of LTDCEN field.
	DSI_DSI_WCR_LTDCEN_Msk = 0x4
	// Bit LTDCEN.
	DSI_DSI_WCR_LTDCEN = 0x4
	// Position of SHTDN field.
	DSI_DSI_WCR_SHTDN_Pos = 0x1
	// Bit mask of SHTDN field.
	DSI_DSI_WCR_SHTDN_Msk = 0x2
	// Bit SHTDN.
	DSI_DSI_WCR_SHTDN = 0x2
	// Position of COLM field.
	DSI_DSI_WCR_COLM_Pos = 0x0
	// Bit mask of COLM field.
	DSI_DSI_WCR_COLM_Msk = 0x1
	// Bit COLM.
	DSI_DSI_WCR_COLM = 0x1

	// DSI_WIER: DSI Wrapper Interrupt Enable Register
	// Position of RRIE field.
	DSI_DSI_WIER_RRIE_Pos = 0xd
	// Bit mask of RRIE field.
	DSI_DSI_WIER_RRIE_Msk = 0x2000
	// Bit RRIE.
	DSI_DSI_WIER_RRIE = 0x2000
	// Position of PLLUIE field.
	DSI_DSI_WIER_PLLUIE_Pos = 0xa
	// Bit mask of PLLUIE field.
	DSI_DSI_WIER_PLLUIE_Msk = 0x400
	// Bit PLLUIE.
	DSI_DSI_WIER_PLLUIE = 0x400
	// Position of PLLLIE field.
	DSI_DSI_WIER_PLLLIE_Pos = 0x9
	// Bit mask of PLLLIE field.
	DSI_DSI_WIER_PLLLIE_Msk = 0x200
	// Bit PLLLIE.
	DSI_DSI_WIER_PLLLIE = 0x200
	// Position of ERIE field.
	DSI_DSI_WIER_ERIE_Pos = 0x1
	// Bit mask of ERIE field.
	DSI_DSI_WIER_ERIE_Msk = 0x2
	// Bit ERIE.
	DSI_DSI_WIER_ERIE = 0x2
	// Position of TEIE field.
	DSI_DSI_WIER_TEIE_Pos = 0x0
	// Bit mask of TEIE field.
	DSI_DSI_WIER_TEIE_Msk = 0x1
	// Bit TEIE.
	DSI_DSI_WIER_TEIE = 0x1

	// DSI_WISR: DSI Wrapper Interrupt & Status Register
	// Position of RRIF field.
	DSI_DSI_WISR_RRIF_Pos = 0xd
	// Bit mask of RRIF field.
	DSI_DSI_WISR_RRIF_Msk = 0x2000
	// Bit RRIF.
	DSI_DSI_WISR_RRIF = 0x2000
	// Position of RRS field.
	DSI_DSI_WISR_RRS_Pos = 0xc
	// Bit mask of RRS field.
	DSI_DSI_WISR_RRS_Msk = 0x1000
	// Bit RRS.
	DSI_DSI_WISR_RRS = 0x1000
	// Position of PLLUIF field.
	DSI_DSI_WISR_PLLUIF_Pos = 0xa
	// Bit mask of PLLUIF field.
	DSI_DSI_WISR_PLLUIF_Msk = 0x400
	// Bit PLLUIF.
	DSI_DSI_WISR_PLLUIF = 0x400
	// Position of PLLLIF field.
	DSI_DSI_WISR_PLLLIF_Pos = 0x9
	// Bit mask of PLLLIF field.
	DSI_DSI_WISR_PLLLIF_Msk = 0x200
	// Bit PLLLIF.
	DSI_DSI_WISR_PLLLIF = 0x200
	// Position of PLLLS field.
	DSI_DSI_WISR_PLLLS_Pos = 0x8
	// Bit mask of PLLLS field.
	DSI_DSI_WISR_PLLLS_Msk = 0x100
	// Bit PLLLS.
	DSI_DSI_WISR_PLLLS = 0x100
	// Position of BUSY field.
	DSI_DSI_WISR_BUSY_Pos = 0x2
	// Bit mask of BUSY field.
	DSI_DSI_WISR_BUSY_Msk = 0x4
	// Bit BUSY.
	DSI_DSI_WISR_BUSY = 0x4
	// Position of ERIF field.
	DSI_DSI_WISR_ERIF_Pos = 0x1
	// Bit mask of ERIF field.
	DSI_DSI_WISR_ERIF_Msk = 0x2
	// Bit ERIF.
	DSI_DSI_WISR_ERIF = 0x2
	// Position of TEIF field.
	DSI_DSI_WISR_TEIF_Pos = 0x0
	// Bit mask of TEIF field.
	DSI_DSI_WISR_TEIF_Msk = 0x1
	// Bit TEIF.
	DSI_DSI_WISR_TEIF = 0x1

	// DSI_WIFCR: DSI Wrapper Interrupt Flag Clear Register
	// Position of CRRIF field.
	DSI_DSI_WIFCR_CRRIF_Pos = 0xd
	// Bit mask of CRRIF field.
	DSI_DSI_WIFCR_CRRIF_Msk = 0x2000
	// Bit CRRIF.
	DSI_DSI_WIFCR_CRRIF = 0x2000
	// Position of CPLLUIF field.
	DSI_DSI_WIFCR_CPLLUIF_Pos = 0xa
	// Bit mask of CPLLUIF field.
	DSI_DSI_WIFCR_CPLLUIF_Msk = 0x400
	// Bit CPLLUIF.
	DSI_DSI_WIFCR_CPLLUIF = 0x400
	// Position of CPLLLIF field.
	DSI_DSI_WIFCR_CPLLLIF_Pos = 0x9
	// Bit mask of CPLLLIF field.
	DSI_DSI_WIFCR_CPLLLIF_Msk = 0x200
	// Bit CPLLLIF.
	DSI_DSI_WIFCR_CPLLLIF = 0x200
	// Position of CERIF field.
	DSI_DSI_WIFCR_CERIF_Pos = 0x1
	// Bit mask of CERIF field.
	DSI_DSI_WIFCR_CERIF_Msk = 0x2
	// Bit CERIF.
	DSI_DSI_WIFCR_CERIF = 0x2
	// Position of CTEIF field.
	DSI_DSI_WIFCR_CTEIF_Pos = 0x0
	// Bit mask of CTEIF field.
	DSI_DSI_WIFCR_CTEIF_Msk = 0x1
	// Bit CTEIF.
	DSI_DSI_WIFCR_CTEIF = 0x1

	// DSI_WPCR1: DSI Wrapper PHY Configuration Register 1
	// Position of TCLKPOSTEN field.
	DSI_DSI_WPCR1_TCLKPOSTEN_Pos = 0x1b
	// Bit mask of TCLKPOSTEN field.
	DSI_DSI_WPCR1_TCLKPOSTEN_Msk = 0x8000000
	// Bit TCLKPOSTEN.
	DSI_DSI_WPCR1_TCLKPOSTEN = 0x8000000
	// Position of TLPXCEN field.
	DSI_DSI_WPCR1_TLPXCEN_Pos = 0x1a
	// Bit mask of TLPXCEN field.
	DSI_DSI_WPCR1_TLPXCEN_Msk = 0x4000000
	// Bit TLPXCEN.
	DSI_DSI_WPCR1_TLPXCEN = 0x4000000
	// Position of THSEXITEN field.
	DSI_DSI_WPCR1_THSEXITEN_Pos = 0x19
	// Bit mask of THSEXITEN field.
	DSI_DSI_WPCR1_THSEXITEN_Msk = 0x2000000
	// Bit THSEXITEN.
	DSI_DSI_WPCR1_THSEXITEN = 0x2000000
	// Position of TLPXDEN field.
	DSI_DSI_WPCR1_TLPXDEN_Pos = 0x18
	// Bit mask of TLPXDEN field.
	DSI_DSI_WPCR1_TLPXDEN_Msk = 0x1000000
	// Bit TLPXDEN.
	DSI_DSI_WPCR1_TLPXDEN = 0x1000000
	// Position of THSZEROEN field.
	DSI_DSI_WPCR1_THSZEROEN_Pos = 0x17
	// Bit mask of THSZEROEN field.
	DSI_DSI_WPCR1_THSZEROEN_Msk = 0x800000
	// Bit THSZEROEN.
	DSI_DSI_WPCR1_THSZEROEN = 0x800000
	// Position of THSTRAILEN field.
	DSI_DSI_WPCR1_THSTRAILEN_Pos = 0x16
	// Bit mask of THSTRAILEN field.
	DSI_DSI_WPCR1_THSTRAILEN_Msk = 0x400000
	// Bit THSTRAILEN.
	DSI_DSI_WPCR1_THSTRAILEN = 0x400000
	// Position of THSPREPEN field.
	DSI_DSI_WPCR1_THSPREPEN_Pos = 0x15
	// Bit mask of THSPREPEN field.
	DSI_DSI_WPCR1_THSPREPEN_Msk = 0x200000
	// Bit THSPREPEN.
	DSI_DSI_WPCR1_THSPREPEN = 0x200000
	// Position of TCLKZEROEN field.
	DSI_DSI_WPCR1_TCLKZEROEN_Pos = 0x14
	// Bit mask of TCLKZEROEN field.
	DSI_DSI_WPCR1_TCLKZEROEN_Msk = 0x100000
	// Bit TCLKZEROEN.
	DSI_DSI_WPCR1_TCLKZEROEN = 0x100000
	// Position of TCLKPREPEN field.
	DSI_DSI_WPCR1_TCLKPREPEN_Pos = 0x13
	// Bit mask of TCLKPREPEN field.
	DSI_DSI_WPCR1_TCLKPREPEN_Msk = 0x80000
	// Bit TCLKPREPEN.
	DSI_DSI_WPCR1_TCLKPREPEN = 0x80000
	// Position of PDEN field.
	DSI_DSI_WPCR1_PDEN_Pos = 0x12
	// Bit mask of PDEN field.
	DSI_DSI_WPCR1_PDEN_Msk = 0x40000
	// Bit PDEN.
	DSI_DSI_WPCR1_PDEN = 0x40000
	// Position of TDDL field.
	DSI_DSI_WPCR1_TDDL_Pos = 0x10
	// Bit mask of TDDL field.
	DSI_DSI_WPCR1_TDDL_Msk = 0x10000
	// Bit TDDL.
	DSI_DSI_WPCR1_TDDL = 0x10000
	// Position of CDOFFDL field.
	DSI_DSI_WPCR1_CDOFFDL_Pos = 0xe
	// Bit mask of CDOFFDL field.
	DSI_DSI_WPCR1_CDOFFDL_Msk = 0x4000
	// Bit CDOFFDL.
	DSI_DSI_WPCR1_CDOFFDL = 0x4000
	// Position of FTXSMDL field.
	DSI_DSI_WPCR1_FTXSMDL_Pos = 0xd
	// Bit mask of FTXSMDL field.
	DSI_DSI_WPCR1_FTXSMDL_Msk = 0x2000
	// Bit FTXSMDL.
	DSI_DSI_WPCR1_FTXSMDL = 0x2000
	// Position of FTXSMCL field.
	DSI_DSI_WPCR1_FTXSMCL_Pos = 0xc
	// Bit mask of FTXSMCL field.
	DSI_DSI_WPCR1_FTXSMCL_Msk = 0x1000
	// Bit FTXSMCL.
	DSI_DSI_WPCR1_FTXSMCL = 0x1000
	// Position of HSIDL1 field.
	DSI_DSI_WPCR1_HSIDL1_Pos = 0xb
	// Bit mask of HSIDL1 field.
	DSI_DSI_WPCR1_HSIDL1_Msk = 0x800
	// Bit HSIDL1.
	DSI_DSI_WPCR1_HSIDL1 = 0x800
	// Position of HSIDL0 field.
	DSI_DSI_WPCR1_HSIDL0_Pos = 0xa
	// Bit mask of HSIDL0 field.
	DSI_DSI_WPCR1_HSIDL0_Msk = 0x400
	// Bit HSIDL0.
	DSI_DSI_WPCR1_HSIDL0 = 0x400
	// Position of HSICL field.
	DSI_DSI_WPCR1_HSICL_Pos = 0x9
	// Bit mask of HSICL field.
	DSI_DSI_WPCR1_HSICL_Msk = 0x200
	// Bit HSICL.
	DSI_DSI_WPCR1_HSICL = 0x200
	// Position of SWDL1 field.
	DSI_DSI_WPCR1_SWDL1_Pos = 0x8
	// Bit mask of SWDL1 field.
	DSI_DSI_WPCR1_SWDL1_Msk = 0x100
	// Bit SWDL1.
	DSI_DSI_WPCR1_SWDL1 = 0x100
	// Position of SWDL0 field.
	DSI_DSI_WPCR1_SWDL0_Pos = 0x7
	// Bit mask of SWDL0 field.
	DSI_DSI_WPCR1_SWDL0_Msk = 0x80
	// Bit SWDL0.
	DSI_DSI_WPCR1_SWDL0 = 0x80
	// Position of SWCL field.
	DSI_DSI_WPCR1_SWCL_Pos = 0x6
	// Bit mask of SWCL field.
	DSI_DSI_WPCR1_SWCL_Msk = 0x40
	// Bit SWCL.
	DSI_DSI_WPCR1_SWCL = 0x40
	// Position of UIX4 field.
	DSI_DSI_WPCR1_UIX4_Pos = 0x0
	// Bit mask of UIX4 field.
	DSI_DSI_WPCR1_UIX4_Msk = 0x3f

	// DSI_WPCR2: DSI Wrapper PHY Configuration Register 2
	// Position of LPRXFT field.
	DSI_DSI_WPCR2_LPRXFT_Pos = 0x19
	// Bit mask of LPRXFT field.
	DSI_DSI_WPCR2_LPRXFT_Msk = 0x6000000
	// Position of FLPRXLPM field.
	DSI_DSI_WPCR2_FLPRXLPM_Pos = 0x16
	// Bit mask of FLPRXLPM field.
	DSI_DSI_WPCR2_FLPRXLPM_Msk = 0x400000
	// Bit FLPRXLPM.
	DSI_DSI_WPCR2_FLPRXLPM = 0x400000
	// Position of HSTXSRCDL field.
	DSI_DSI_WPCR2_HSTXSRCDL_Pos = 0x12
	// Bit mask of HSTXSRCDL field.
	DSI_DSI_WPCR2_HSTXSRCDL_Msk = 0xc0000
	// Position of HSTXSRCCL field.
	DSI_DSI_WPCR2_HSTXSRCCL_Pos = 0x10
	// Bit mask of HSTXSRCCL field.
	DSI_DSI_WPCR2_HSTXSRCCL_Msk = 0x30000
	// Position of SDCC field.
	DSI_DSI_WPCR2_SDCC_Pos = 0xc
	// Bit mask of SDCC field.
	DSI_DSI_WPCR2_SDCC_Msk = 0x1000
	// Bit SDCC.
	DSI_DSI_WPCR2_SDCC = 0x1000
	// Position of LPSRDL field.
	DSI_DSI_WPCR2_LPSRDL_Pos = 0x8
	// Bit mask of LPSRDL field.
	DSI_DSI_WPCR2_LPSRDL_Msk = 0x300
	// Position of LPSRCL field.
	DSI_DSI_WPCR2_LPSRCL_Pos = 0x6
	// Bit mask of LPSRCL field.
	DSI_DSI_WPCR2_LPSRCL_Msk = 0xc0
	// Position of HSTXDLL field.
	DSI_DSI_WPCR2_HSTXDLL_Pos = 0x2
	// Bit mask of HSTXDLL field.
	DSI_DSI_WPCR2_HSTXDLL_Msk = 0xc
	// Position of HSTXDCL field.
	DSI_DSI_WPCR2_HSTXDCL_Pos = 0x0
	// Bit mask of HSTXDCL field.
	DSI_DSI_WPCR2_HSTXDCL_Msk = 0x3

	// DSI_WPCR3: DSI Wrapper PHY Configuration Register 3
	// Position of THSTRAIL field.
	DSI_DSI_WPCR3_THSTRAIL_Pos = 0x18
	// Bit mask of THSTRAIL field.
	DSI_DSI_WPCR3_THSTRAIL_Msk = 0xff000000
	// Position of THSPREP field.
	DSI_DSI_WPCR3_THSPREP_Pos = 0x10
	// Bit mask of THSPREP field.
	DSI_DSI_WPCR3_THSPREP_Msk = 0xff0000
	// Position of TCLKZEO field.
	DSI_DSI_WPCR3_TCLKZEO_Pos = 0x8
	// Bit mask of TCLKZEO field.
	DSI_DSI_WPCR3_TCLKZEO_Msk = 0xff00
	// Position of TCLKPREP field.
	DSI_DSI_WPCR3_TCLKPREP_Pos = 0x0
	// Bit mask of TCLKPREP field.
	DSI_DSI_WPCR3_TCLKPREP_Msk = 0xff

	// DSI_WPCR4: DSI_WPCR4
	// Position of TLPXC field.
	DSI_DSI_WPCR4_TLPXC_Pos = 0x18
	// Bit mask of TLPXC field.
	DSI_DSI_WPCR4_TLPXC_Msk = 0xff000000
	// Position of THSEXIT field.
	DSI_DSI_WPCR4_THSEXIT_Pos = 0x10
	// Bit mask of THSEXIT field.
	DSI_DSI_WPCR4_THSEXIT_Msk = 0xff0000
	// Position of TLPXD field.
	DSI_DSI_WPCR4_TLPXD_Pos = 0x8
	// Bit mask of TLPXD field.
	DSI_DSI_WPCR4_TLPXD_Msk = 0xff00
	// Position of THSZERO field.
	DSI_DSI_WPCR4_THSZERO_Pos = 0x0
	// Bit mask of THSZERO field.
	DSI_DSI_WPCR4_THSZERO_Msk = 0xff

	// DSI_WPCR5: DSI Wrapper PHY Configuration Register 5
	// Position of THSZERO field.
	DSI_DSI_WPCR5_THSZERO_Pos = 0x0
	// Bit mask of THSZERO field.
	DSI_DSI_WPCR5_THSZERO_Msk = 0xff

	// DSI_WRPCR: DSI Wrapper Regulator and PLL Control Register
	// Position of REGEN field.
	DSI_DSI_WRPCR_REGEN_Pos = 0x18
	// Bit mask of REGEN field.
	DSI_DSI_WRPCR_REGEN_Msk = 0x1000000
	// Bit REGEN.
	DSI_DSI_WRPCR_REGEN = 0x1000000
	// Position of ODF field.
	DSI_DSI_WRPCR_ODF_Pos = 0x10
	// Bit mask of ODF field.
	DSI_DSI_WRPCR_ODF_Msk = 0x30000
	// Position of IDF field.
	DSI_DSI_WRPCR_IDF_Pos = 0xb
	// Bit mask of IDF field.
	DSI_DSI_WRPCR_IDF_Msk = 0x7800
	// Position of NDIV field.
	DSI_DSI_WRPCR_NDIV_Pos = 0x2
	// Bit mask of NDIV field.
	DSI_DSI_WRPCR_NDIV_Msk = 0x1fc
	// Position of PLLEN field.
	DSI_DSI_WRPCR_PLLEN_Pos = 0x0
	// Bit mask of PLLEN field.
	DSI_DSI_WRPCR_PLLEN_Msk = 0x1
	// Bit PLLEN.
	DSI_DSI_WRPCR_PLLEN = 0x1
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ISER2: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER2_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ICER2: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER2_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ISPR2: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// ICPR2: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IABR2: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_P