/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProcessorBase;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.LimitLatch;
import org.apache.tomcat.util.threads.ResizableExecutor;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public abstract class AbstractEndpoint<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractEndpoint.class);
    private static final int INITIAL_ERROR_DELAY = 50;
    private static final int MAX_ERROR_DELAY = 1600;
    protected volatile boolean running = false;
    protected volatile boolean paused = false;
    protected volatile boolean internalExecutor = true;
    private volatile LimitLatch connectionLimitLatch = null;
    protected SocketProperties socketProperties = new SocketProperties();
    protected Acceptor[] acceptors;
    protected SynchronizedStack<SocketProcessorBase<S>> processorCache;
    private ObjectName oname = null;
    private String defaultSSLHostConfigName = "_default_";
    protected ConcurrentMap<String, SSLHostConfig> sslHostConfigs = new ConcurrentHashMap<String, SSLHostConfig>();
    private boolean useSendfile = true;
    private long executorTerminationTimeoutMillis = 5000L;
    protected int acceptorThreadCount = 1;
    protected int acceptorThreadPriority = 5;
    private int maxConnections = 10000;
    private Executor executor = null;
    private int port;
    private InetAddress address;
    private int acceptCount = 100;
    private boolean bindOnInit = true;
    private volatile BindState bindState = BindState.UNBOUND;
    private Integer keepAliveTimeout = null;
    private boolean SSLEnabled = false;
    private int minSpareThreads = 10;
    private int maxThreads = 200;
    protected int threadPriority = 5;
    private int maxKeepAliveRequests = 100;
    private int maxHeaderCount = 100;
    private String name = "TP";
    private String domain;
    private boolean daemon = true;
    private boolean useAsyncIO = true;
    protected final List<String> negotiableProtocols = new ArrayList<String>();
    private Handler<S> handler = null;
    protected HashMap<String, Object> attributes = new HashMap();

    public static long toTimeout(long l) {
        return l > 0L ? l : Long.MAX_VALUE;
    }

    public SocketProperties getSocketProperties() {
        return this.socketProperties;
    }

    public String getDefaultSSLHostConfigName() {
        return this.defaultSSLHostConfigName;
    }

    public void setDefaultSSLHostConfigName(String string) {
        this.defaultSSLHostConfigName = string.toLowerCase(Locale.ENGLISH);
    }

    public void addSslHostConfig(SSLHostConfig sSLHostConfig) throws IllegalArgumentException {
        this.addSslHostConfig(sSLHostConfig, false);
    }

    public void addSslHostConfig(SSLHostConfig sSLHostConfig, boolean bl) throws IllegalArgumentException {
        String string = sSLHostConfig.getHostName();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(sm.getString("endpoint.noSslHostName"));
        }
        if (this.bindState != BindState.UNBOUND && this.bindState != BindState.SOCKET_CLOSED_ON_STOP && this.isSSLEnabled()) {
            try {
                this.createSSLContext(sSLHostConfig);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        if (bl) {
            SSLHostConfig sSLHostConfig2 = this.sslHostConfigs.put(string, sSLHostConfig);
            if (sSLHostConfig2 != null) {
                this.unregisterJmx(sSLHostConfig);
            }
            this.registerJmx(sSLHostConfig);
        } else {
            SSLHostConfig sSLHostConfig3 = this.sslHostConfigs.putIfAbsent(string, sSLHostConfig);
            if (sSLHostConfig3 != null) {
                this.releaseSSLContext(sSLHostConfig);
                throw new IllegalArgumentException(sm.getString("endpoint.duplicateSslHostName", new Object[]{string}));
            }
            this.registerJmx(sSLHostConfig);
        }
    }

    public SSLHostConfig removeSslHostConfig(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals(this.getDefaultSSLHostConfigName())) {
            throw new IllegalArgumentException(sm.getString("endpoint.removeDefaultSslHostConfig", new Object[]{string}));
        }
        SSLHostConfig sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.remove(string2);
        this.unregisterJmx(sSLHostConfig);
        return sSLHostConfig;
    }

    public void reloadSslHostConfig(String string) {
        SSLHostConfig sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get(string.toLowerCase(Locale.ENGLISH));
        if (sSLHostConfig == null) {
            throw new IllegalArgumentException(sm.getString("endpoint.unknownSslHostName", new Object[]{string}));
        }
        this.addSslHostConfig(sSLHostConfig, true);
    }

    public void reloadSslHostConfigs() {
        for (String string : this.sslHostConfigs.keySet()) {
            this.reloadSslHostConfig(string);
        }
    }

    public SSLHostConfig[] findSslHostConfigs() {
        return this.sslHostConfigs.values().toArray(new SSLHostConfig[0]);
    }

    protected abstract void createSSLContext(SSLHostConfig var1) throws Exception;

    protected void destroySsl() throws Exception {
        if (this.isSSLEnabled()) {
            for (SSLHostConfig sSLHostConfig : this.sslHostConfigs.values()) {
                this.releaseSSLContext(sSLHostConfig);
            }
        }
    }

    protected void releaseSSLContext(SSLHostConfig sSLHostConfig) {
        for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates(true)) {
            SSLContext sSLContext;
            if (sSLHostConfigCertificate.getSslContext() == null || (sSLContext = sSLHostConfigCertificate.getSslContext()) == null) continue;
            sSLContext.destroy();
        }
    }

    protected SSLHostConfig getSSLHostConfig(String string) {
        SSLHostConfig sSLHostConfig = null;
        if (string != null) {
            sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get(string);
            if (sSLHostConfig != null) {
                return sSLHostConfig;
            }
            int n = string.indexOf(46);
            if (n > -1) {
                sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get("*" + string.substring(n));
            }
        }
        if (sSLHostConfig == null) {
            sSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get(this.getDefaultSSLHostConfigName());
        }
        if (sSLHostConfig == null) {
            throw new IllegalStateException();
        }
        return sSLHostConfig;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseSendfile(boolean bl) {
        this.useSendfile = bl;
    }

    public long getExecutorTerminationTimeoutMillis() {
        return this.executorTerminationTimeoutMillis;
    }

    public void setExecutorTerminationTimeoutMillis(long l) {
        this.executorTerminationTimeoutMillis = l;
    }

    public void setAcceptorThreadCount(int n) {
        this.acceptorThreadCount = n;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public void setAcceptorThreadPriority(int n) {
        this.acceptorThreadPriority = n;
    }

    public int getAcceptorThreadPriority() {
        return this.acceptorThreadPriority;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            if (n == -1) {
                this.releaseConnectionLatch();
            } else {
                limitLatch.setLimit((long)n);
            }
        } else if (n > 0) {
            this.initializeConnectionLatch();
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getConnectionCount() {
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            return limitLatch.getCount();
        }
        return -1L;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.internalExecutor = executor == null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public final int getLocalPort() {
        try {
            InetSocketAddress inetSocketAddress = this.getLocalAddress();
            if (inetSocketAddress == null) {
                return -1;
            }
            return inetSocketAddress.getPort();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    protected abstract InetSocketAddress getLocalAddress() throws IOException;

    public void setAcceptCount(int n) {
        if (n > 0) {
            this.acceptCount = n;
        }
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    @Deprecated
    public void setBacklog(int n) {
        this.setAcceptCount(n);
    }

    @Deprecated
    public int getBacklog() {
        return this.getAcceptCount();
    }

    public boolean getBindOnInit() {
        return this.bindOnInit;
    }

    public void setBindOnInit(boolean bl) {
        this.bindOnInit = bl;
    }

    public int getKeepAliveTimeout() {
        if (this.keepAliveTimeout == null) {
            return this.getConnectionTimeout();
        }
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int n) {
        this.keepAliveTimeout = n;
    }

    public boolean getTcpNoDelay() {
        return this.socketProperties.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean bl) {
        this.socketProperties.setTcpNoDelay(bl);
    }

    public int getConnectionLinger() {
        return this.socketProperties.getSoLingerTime();
    }

    public void setConnectionLinger(int n) {
        this.socketProperties.setSoLingerTime(n);
        this.socketProperties.setSoLingerOn(n >= 0);
    }

    @Deprecated
    public int getSoLinger() {
        return this.getConnectionLinger();
    }

    @Deprecated
    public void setSoLinger(int n) {
        this.setConnectionLinger(n);
    }

    public int getConnectionTimeout() {
        return this.socketProperties.getSoTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.socketProperties.setSoTimeout(n);
    }

    @Deprecated
    public int getSoTimeout() {
        return this.getConnectionTimeout();
    }

    @Deprecated
    public void setSoTimeout(int n) {
        this.setConnectionTimeout(n);
    }

    public boolean isSSLEnabled() {
        return this.SSLEnabled;
    }

    public void setSSLEnabled(boolean bl) {
        this.SSLEnabled = bl;
    }

    public abstract boolean isAlpnSupported();

    public void setMinSpareThreads(int n) {
        this.minSpareThreads = n;
        Executor executor = this.executor;
        if (this.internalExecutor && executor instanceof java.util.concurrent.ThreadPoolExecutor) {
            ((java.util.concurrent.ThreadPoolExecutor)executor).setCorePoolSize(n);
        }
    }

    public int getMinSpareThreads() {
        return Math.min(this.getMinSpareThreadsInternal(), this.getMaxThreads());
    }

    private int getMinSpareThreadsInternal() {
        if (this.internalExecutor) {
            return this.minSpareThreads;
        }
        return -1;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
        Executor executor = this.executor;
        if (this.internalExecutor && executor instanceof java.util.concurrent.ThreadPoolExecutor) {
            ((java.util.concurrent.ThreadPoolExecutor)executor).setMaximumPoolSize(n);
        }
    }

    public int getMaxThreads() {
        if (this.internalExecutor) {
            return this.maxThreads;
        }
        return -1;
    }

    public void setThreadPriority(int n) {
        this.threadPriority = n;
    }

    public int getThreadPriority() {
        if (this.internalExecutor) {
            return this.threadPriority;
        }
        return -1;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int n) {
        this.maxKeepAliveRequests = n;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderCount(int n) {
        this.maxHeaderCount = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public boolean getDaemon() {
        return this.daemon;
    }

    public void setUseAsyncIO(boolean bl) {
        this.useAsyncIO = bl;
    }

    public boolean getUseAsyncIO() {
        return this.useAsyncIO;
    }

    protected abstract boolean getDeferAccept();

    public void addNegotiatedProtocol(String string) {
        this.negotiableProtocols.add(string);
    }

    public boolean hasNegotiableProtocols() {
        return this.negotiableProtocols.size() > 0;
    }

    public void setHandler(Handler<S> handler) {
        this.handler = handler;
    }

    public Handler<S> getHandler() {
        return this.handler;
    }

    public void setAttribute(String string, Object object) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("endpoint.setAttribute", new Object[]{string, object}));
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        Object object = this.attributes.get(string);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("endpoint.getAttribute", new Object[]{string, object}));
        }
        return object;
    }

    public boolean setProperty(String string, String string2) {
        this.setAttribute(string, string2);
        try {
            if (string.startsWith("socket.")) {
                return IntrospectionUtils.setProperty((Object)this.socketProperties, (String)string.substring("socket.".length()), (String)string2);
            }
            return IntrospectionUtils.setProperty((Object)this, (String)string, (String)string2, (boolean)false);
        }
        catch (Exception exception) {
            this.getLog().error((Object)("Unable to set attribute \"" + string + "\" to \"" + string2 + "\""), (Throwable)exception);
            return false;
        }
    }

    public String getProperty(String string) {
        Object object;
        String string2 = (String)this.getAttribute(string);
        if (string2 == null && string.startsWith("socket.") && (object = IntrospectionUtils.getProperty((Object)this.socketProperties, (String)string.substring("socket.".length()))) != null) {
            string2 = object.toString();
        }
        return string2;
    }

    public int getCurrentThreadCount() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getPoolSize();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getPoolSize();
            }
            return -1;
        }
        return -2;
    }

    public int getCurrentThreadsBusy() {
        Executor executor = this.executor;
        if (executor != null) {
            if (executor instanceof ThreadPoolExecutor) {
                return ((ThreadPoolExecutor)executor).getActiveCount();
            }
            if (executor instanceof ResizableExecutor) {
                return ((ResizableExecutor)executor).getActiveCount();
            }
            return -1;
        }
        return -2;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void createExecutor() {
        this.internalExecutor = true;
        TaskQueue taskQueue = new TaskQueue();
        TaskThreadFactory taskThreadFactory = new TaskThreadFactory(this.getName() + "-exec-", this.daemon, this.getThreadPriority());
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue)taskQueue, (ThreadFactory)taskThreadFactory);
        taskQueue.setParent((ThreadPoolExecutor)this.executor);
    }

    public void shutdownExecutor() {
        Executor executor = this.executor;
        if (executor != null && this.internalExecutor) {
            this.executor = null;
            if (executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                threadPoolExecutor.shutdownNow();
                long l = this.getExecutorTerminationTimeoutMillis();
                if (l > 0L) {
                    try {
                        threadPoolExecutor.awaitTermination(l, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (threadPoolExecutor.isTerminating()) {
                        this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}));
                    }
                }
                TaskQueue taskQueue = (TaskQueue)threadPoolExecutor.getQueue();
                taskQueue.setParent(null);
            }
        }
    }

    protected void unlockAccept() {
        block26: {
            int n = 0;
            for (Acceptor acceptor : this.acceptors) {
                if (acceptor.getState() != Acceptor.AcceptorState.RUNNING) continue;
                ++n;
            }
            if (n == 0) {
                return;
            }
            Object var2_3 = null;
            InetSocketAddress inetSocketAddress = null;
            try {
                inetSocketAddress = this.getLocalAddress();
            }
            catch (IOException l) {
                this.getLog().debug((Object)sm.getString("endpoint.debug.unlock.localFail", new Object[]{this.getName()}), (Throwable)l);
            }
            if (inetSocketAddress == null) {
                this.getLog().warn((Object)sm.getString("endpoint.debug.unlock.localNone", new Object[]{this.getName()}));
                return;
            }
            try {
                InetSocketAddress inetSocketAddress2 = AbstractEndpoint.getUnlockAddress(inetSocketAddress);
                for (int throwable = 0; throwable < n; ++throwable) {
                    Socket socket = new Socket();
                    Object object = null;
                    try {
                        int n2 = 2000;
                        int n3 = 2000;
                        if (this.getSocketProperties().getSoTimeout() > n2) {
                            n2 = this.getSocketProperties().getSoTimeout();
                        }
                        if (this.getSocketProperties().getUnlockTimeout() > n3) {
                            n3 = this.getSocketProperties().getUnlockTimeout();
                        }
                        socket.setSoTimeout(n2);
                        socket.setSoLinger(this.getSocketProperties().getSoLingerOn(), this.getSocketProperties().getSoLingerTime());
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)("About to unlock socket for:" + inetSocketAddress2));
                        }
                        socket.connect(inetSocketAddress2, n3);
                        if (this.getDeferAccept()) {
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), "ISO-8859-1");
                            outputStreamWriter.write("OPTIONS * HTTP/1.0\r\nUser-Agent: Tomcat wakeup connection\r\n\r\n");
                            outputStreamWriter.flush();
                        }
                        if (!this.getLog().isDebugEnabled()) continue;
                        this.getLog().debug((Object)("Socket unlock completed for:" + inetSocketAddress2));
                        continue;
                    }
                    catch (Throwable throwable2) {
                        object = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (socket != null) {
                            if (object != null) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                socket.close();
                            }
                        }
                    }
                }
                long l = 1000L;
                for (Acceptor acceptor : this.acceptors) {
                    while (l > 0L && acceptor.getState() == Acceptor.AcceptorState.RUNNING) {
                        Thread.sleep(5L);
                        l -= 5L;
                    }
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (!this.getLog().isDebugEnabled()) break block26;
                this.getLog().debug((Object)sm.getString("endpoint.debug.unlock.fail", new Object[]{"" + this.getPort()}), throwable);
            }
        }
    }

    private static InetSocketAddress getUnlockAddress(InetSocketAddress inetSocketAddress) throws SocketException {
        if (inetSocketAddress.getAddress().isAnyLocalAddress()) {
            InetAddress inetAddress = null;
            InetAddress inetAddress2 = null;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress3 = enumeration2.nextElement();
                    if (!inetSocketAddress.getAddress().getClass().isAssignableFrom(inetAddress3.getClass())) continue;
                    if (inetAddress3.isLoopbackAddress()) {
                        if (inetAddress != null) continue;
                        inetAddress = inetAddress3;
                        continue;
                    }
                    if (inetAddress3.isLinkLocalAddress()) {
                        if (inetAddress2 != null) continue;
                        inetAddress2 = inetAddress3;
                        continue;
                    }
                    return new InetSocketAddress(inetAddress3, inetSocketAddress.getPort());
                }
            }
            if (inetAddress != null) {
                return new InetSocketAddress(inetAddress, inetSocketAddress.getPort());
            }
            if (inetAddress2 != null) {
                return new InetSocketAddress(inetAddress2, inetSocketAddress.getPort());
            }
            return new InetSocketAddress("localhost", inetSocketAddress.getPort());
        }
        return inetSocketAddress;
    }

    public boolean processSocket(SocketWrapperBase<S> socketWrapperBase, SocketEvent socketEvent, boolean bl) {
        try {
            if (socketWrapperBase == null) {
                return false;
            }
            SocketProcessorBase<S> socketProcessorBase = (SocketProcessorBase<S>)this.processorCache.pop();
            if (socketProcessorBase == null) {
                socketProcessorBase = this.createSocketProcessor(socketWrapperBase, socketEvent);
            } else {
                socketProcessorBase.reset(socketWrapperBase, socketEvent);
            }
            Executor executor = this.getExecutor();
            if (bl && executor != null) {
                executor.execute(socketProcessorBase);
            } else {
                socketProcessorBase.run();
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.getLog().warn((Object)sm.getString("endpoint.executor.fail", new Object[]{socketWrapperBase}), (Throwable)rejectedExecutionException);
            return false;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.getLog().error((Object)sm.getString("endpoint.process.fail"), throwable);
            return false;
        }
        return true;
    }

    protected abstract SocketProcessorBase<S> createSocketProcessor(SocketWrapperBase<S> var1, SocketEvent var2);

    public abstract void bind() throws Exception;

    public abstract void unbind() throws Exception;

    public abstract void startInternal() throws Exception;

    public abstract void stopInternal() throws Exception;

    public void init() throws Exception {
        if (this.bindOnInit) {
            this.bind();
            this.bindState = BindState.BOUND_ON_INIT;
        }
        if (this.domain != null) {
            this.oname = new ObjectName(this.domain + ":type=ThreadPool,name=\"" + this.getName() + "\"");
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            ObjectName objectName = new ObjectName(this.domain + ":type=SocketProperties,name=\"" + this.getName() + "\"");
            this.socketProperties.setObjectName(objectName);
            Registry.getRegistry(null, null).registerComponent((Object)this.socketProperties, objectName, null);
            for (SSLHostConfig sSLHostConfig : this.findSslHostConfigs()) {
                this.registerJmx(sSLHostConfig);
            }
        }
    }

    private void registerJmx(SSLHostConfig sSLHostConfig) {
        if (this.domain == null) {
            return;
        }
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(this.domain + ":type=SSLHostConfig,ThreadPool=\"" + this.getName() + "\",name=" + ObjectName.quote(sSLHostConfig.getHostName()));
            sSLHostConfig.setObjectName(objectName);
            try {
                Registry.getRegistry(null, null).registerComponent((Object)sSLHostConfig, objectName, null);
            }
            catch (Exception exception) {
                this.getLog().warn((Object)sm.getString("endpoint.jmxRegistrationFailed", new Object[]{objectName}), (Throwable)exception);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            this.getLog().warn((Object)sm.getString("endpoint.invalidJmxNameSslHost", new Object[]{sSLHostConfig.getHostName()}), (Throwable)malformedObjectNameException);
        }
        for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates()) {
            ObjectName objectName2 = null;
            try {
                objectName2 = new ObjectName(this.domain + ":type=SSLHostConfigCertificate,ThreadPool=\"" + this.getName() + "\",Host=" + ObjectName.quote(sSLHostConfig.getHostName()) + ",name=" + (Object)((Object)sSLHostConfigCertificate.getType()));
                sSLHostConfigCertificate.setObjectName(objectName2);
                try {
                    Registry.getRegistry(null, null).registerComponent((Object)sSLHostConfigCertificate, objectName2, null);
                }
                catch (Exception exception) {
                    this.getLog().warn((Object)sm.getString("endpoint.jmxRegistrationFailed", new Object[]{objectName2}), (Throwable)exception);
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                this.getLog().warn((Object)sm.getString("endpoint.invalidJmxNameSslHostCert", new Object[]{sSLHostConfig.getHostName(), sSLHostConfigCertificate.getType()}), (Throwable)malformedObjectNameException);
            }
        }
    }

    private void unregisterJmx(SSLHostConfig sSLHostConfig) {
        Registry registry = Registry.getRegistry(null, null);
        registry.unregisterComponent(sSLHostConfig.getObjectName());
        for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates()) {
            registry.unregisterComponent(sSLHostConfigCertificate.getObjectName());
        }
    }

    public final void start() throws Exception {
        if (this.bindState == BindState.UNBOUND) {
            this.bind();
            this.bindState = BindState.BOUND_ON_START;
        }
        this.startInternal();
    }

    protected final void startAcceptorThreads() {
        int n = this.getAcceptorThreadCount();
        this.acceptors = new Acceptor[n];
        for (int i = 0; i < n; ++i) {
            this.acceptors[i] = this.createAcceptor();
            String string = this.getName() + "-Acceptor-" + i;
            this.acceptors[i].setThreadName(string);
            Thread thread = new Thread((Runnable)this.acceptors[i], string);
            thread.setPriority(this.getAcceptorThreadPriority());
            thread.setDaemon(this.getDaemon());
            thread.start();
        }
    }

    protected abstract Acceptor createAcceptor();

    public void pause() {
        if (this.running && !this.paused) {
            this.paused = true;
            this.unlockAccept();
            this.getHandler().pause();
        }
    }

    public void resume() {
        if (this.running) {
            this.paused = false;
        }
    }

    public final void stop() throws Exception {
        this.stopInternal();
        if (this.bindState == BindState.BOUND_ON_START || this.bindState == BindState.SOCKET_CLOSED_ON_STOP) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
    }

    public final void destroy() throws Exception {
        if (this.bindState == BindState.BOUND_ON_INIT) {
            this.unbind();
            this.bindState = BindState.UNBOUND;
        }
        Registry registry = Registry.getRegistry(null, null);
        registry.unregisterComponent(this.oname);
        registry.unregisterComponent(this.socketProperties.getObjectName());
        for (SSLHostConfig sSLHostConfig : this.findSslHostConfigs()) {
            this.unregisterJmx(sSLHostConfig);
        }
    }

    protected abstract Log getLog();

    protected LimitLatch initializeConnectionLatch() {
        if (this.maxConnections == -1) {
            return null;
        }
        if (this.connectionLimitLatch == null) {
            this.connectionLimitLatch = new LimitLatch((long)this.getMaxConnections());
        }
        return this.connectionLimitLatch;
    }

    protected void releaseConnectionLatch() {
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            limitLatch.releaseAll();
        }
        this.connectionLimitLatch = null;
    }

    protected void countUpOrAwaitConnection() throws InterruptedException {
        if (this.maxConnections == -1) {
            return;
        }
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            limitLatch.countUpOrAwait();
        }
    }

    protected long countDownConnection() {
        if (this.maxConnections == -1) {
            return -1L;
        }
        LimitLatch limitLatch = this.connectionLimitLatch;
        if (limitLatch != null) {
            long l = limitLatch.countDown();
            if (l < 0L) {
                this.getLog().warn((Object)sm.getString("endpoint.warn.incorrectConnectionCount"));
            }
            return l;
        }
        return -1L;
    }

    protected int handleExceptionWithDelay(int n) {
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (n == 0) {
            return 50;
        }
        if (n < 1600) {
            return n * 2;
        }
        return 1600;
    }

    public final void closeServerSocketGraceful() {
        if (this.bindState == BindState.BOUND_ON_START) {
            this.bindState = BindState.SOCKET_CLOSED_ON_STOP;
            try {
                this.doCloseServerSocket();
            }
            catch (IOException iOException) {
                this.getLog().warn((Object)sm.getString("endpoint.serverSocket.closeFailed", new Object[]{this.getName()}), (Throwable)iOException);
            }
        }
    }

    protected abstract void doCloseServerSocket() throws IOException;

    public static abstract class Acceptor
    implements Runnable {
        protected volatile AcceptorState state = AcceptorState.NEW;
        private String threadName;

        public final AcceptorState getState() {
            return this.state;
        }

        protected final void setThreadName(String string) {
            this.threadName = string;
        }

        protected final String getThreadName() {
            return this.threadName;
        }

        public static enum AcceptorState {
            NEW,
            RUNNING,
            PAUSED,
            ENDED;

        }
    }

    protected static enum BindState {
        UNBOUND,
        BOUND_ON_INIT,
        BOUND_ON_START,
        SOCKET_CLOSED_ON_STOP;

    }

    public static interface Handler<S> {
        public SocketState process(SocketWrapperBase<S> var1, SocketEvent var2);

        public Object getGlobal();

        public Set<S> getOpenSockets();

        public void release(SocketWrapperBase<S> var1);

        public void pause();

        public void recycle();

        public static enum SocketState {
            OPEN,
            CLOSED,
            LONG,
            ASYNC_END,
            SENDFILE,
            UPGRADING,
            UPGRADED,
            SUSPENDED;

        }
    }
}

