/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sa;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.graalvm.visualvm.coredump.CoreDump;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.sa.SaModelImpl;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import org.graalvm.visualvm.tools.sa.SaModel;
import org.openide.util.Utilities;

public class SaModelProvider
extends AbstractModelProvider<SaModel, DataSource> {
    private static final Logger LOGGER = Logger.getLogger(SaModelProvider.class.getName());
    private static final String SA_JAR = "lib/sa-jdi.jar";
    private static final String SA_JMOD = "jmods/jdk.hotspot.agent.jmod";

    SaModelProvider() {
    }

    public SaModel createModelFor(DataSource ds) {
        if (ds instanceof Application) {
            Application app = (Application)ds;
            if (Host.LOCALHOST.equals((Object)app.getHost())) {
                File jdkHome;
                File saLib;
                JvmJvmstatModel jvmstat = JvmJvmstatModelFactory.getJvmstatModelFor((Application)app);
                if (jvmstat == null) {
                    return null;
                }
                if (Utilities.isWindows()) {
                    Boolean this64bitArch = SaModelProvider.is64BitArchitecture();
                    Boolean app64bitArch = SaModelProvider.is64BitArchitecture(jvmstat);
                    if (this64bitArch != null && app64bitArch != null && !this64bitArch.equals(app64bitArch)) {
                        return null;
                    }
                }
                if ((saLib = SaModelProvider.getSaJar(jdkHome = this.getJdkHome(jvmstat))) == null && (saLib = SaModelProvider.getSaJmod(jdkHome)) == null) {
                    return null;
                }
                try {
                    return new SaModelImpl(jdkHome, saLib, app.getPid());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Error getting SA agent", ex);
                }
                catch (LinkageError ex) {
                    LOGGER.log(Level.INFO, "Error getting SA agent", ex);
                }
                return null;
            }
        } else if (ds instanceof CoreDump) {
            CoreDump coredump = (CoreDump)ds;
            File executable = new File(coredump.getExecutable());
            File coreFile = coredump.getFile();
            if (executable.exists() && coreFile.exists()) {
                File jdkHome = executable.getParentFile().getParentFile();
                File saLib = SaModelProvider.getSaJar(jdkHome);
                if (saLib == null && (saLib = SaModelProvider.getSaJmod(jdkHome)) == null) {
                    return null;
                }
                try {
                    return new SaModelImpl(jdkHome, saLib, executable, coreFile);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Unable to retrieve SA agent", ex);
                    return null;
                }
            }
        }
        return null;
    }

    private File getJdkHome(JvmJvmstatModel jvmstat) {
        String javaHome = jvmstat.getJavaHome();
        if (javaHome != null) {
            File jdkHome = new File(javaHome);
            if ("jre".equals(jdkHome.getName())) {
                jdkHome = jdkHome.getParentFile();
            }
            return jdkHome;
        }
        return null;
    }

    private static File getJar(File jdkHome, String saName) {
        if (jdkHome != null) {
            File saJar = new File(jdkHome, saName);
            try {
                if (saJar.exists()) {
                    return saJar.getCanonicalFile();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, saJar.getPath(), ex);
            }
        }
        return null;
    }

    private static File getSaJar(File jdkHome) {
        return SaModelProvider.getJar(jdkHome, SA_JAR);
    }

    private static File getSaJmod(File jdkHome) {
        return SaModelProvider.getJar(jdkHome, SA_JMOD);
    }

    private static Boolean is64BitArchitecture(JvmJvmstatModel jvmstat) {
        String name = jvmstat.getVmName();
        if (name != null) {
            return name.toLowerCase().contains("64-bit");
        }
        return null;
    }

    private static Boolean is64BitArchitecture() {
        String thisArch = System.getProperty("sun.arch.data.model");
        if (thisArch != null) {
            return "64".equals(thisArch);
        }
        return null;
    }
}

