/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.ui.UIConstants;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.FilterComponent;
import org.graalvm.visualvm.lib.ui.components.JExtendedTable;
import org.graalvm.visualvm.lib.ui.components.table.ClassNameTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.ExtendedTableModel;
import org.graalvm.visualvm.lib.ui.components.table.LabelBracketTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.MethodNameTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.SortableTableModel;
import org.graalvm.visualvm.lib.ui.cpu.CPUResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.cpu.CPUResultsPanel;
import org.graalvm.visualvm.lib.ui.cpu.CPUSelectionHandler;

public abstract class FlatProfilePanel
extends CPUResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.cpu.Bundle");
    private static final String FILTER_ITEM_NAME = messages.getString("FlatProfilePanel_FilterItemName");
    private static final String METHOD_COLUMN_NAME = messages.getString("FlatProfilePanel_MethodColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_MethodColumnToolTip");
    private static final String METHOD_FILTER_HINT = messages.getString("FlatProfilePanel_MethodFilterHint");
    private static final String CLASS_COLUMN_NAME = messages.getString("FlatProfilePanel_ClassColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_ClassColumnToolTip");
    private static final String CLASS_FILTER_HINT = messages.getString("FlatProfilePanel_ClassFilterHint");
    private static final String PACKAGE_COLUMN_NAME = messages.getString("FlatProfilePanel_PackageColumnName");
    private static final String PACKAGE_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_PackageColumnToolTip");
    private static final String PACKAGE_FILTER_HINT = messages.getString("FlatProfilePanel_PackageFilterHint");
    private static final String SELFTIME_REL_COLUMN_NAME = messages.getString("FlatProfilePanel_SelfTimeRelColumnName");
    private static final String SELFTIME_REL_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_SelfTimeRelColumnToolTip");
    private static final String SELFTIME_COLUMN_NAME = messages.getString("FlatProfilePanel_SelfTimeColumnName");
    private static final String SELFTIME_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_SelfTimeColumnToolTip");
    private static final String SELFTIME_CPU_COLUMN_NAME = messages.getString("FlatProfilePanel_SelfTimeCpuColumnName");
    private static final String SELFTIME_CPU_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_SelfTimeCpuColumnToolTip");
    private static final String TOTALTIME_COLUMN_NAME = messages.getString("FlatProfilePanel_TotalTimeColumnName");
    private static final String TOTALTIME_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_TotalTimeColumnToolTip");
    private static final String TOTALTIME_CPU_COLUMN_NAME = messages.getString("FlatProfilePanel_TotalTimeCpuColumnName");
    private static final String TOTALTIME_CPU_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_TotalTimeCpuColumnToolTip");
    private static final String INVOCATIONS_COLUMN_NAME = messages.getString("FlatProfilePanel_InvocationsColumnName");
    private static final String SAMPLES_COLUMN_NAME = messages.getString("FlatProfilePanel_SamplesColumnName");
    private static final String INVOCATIONS_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_InvocationsColumnToolTip");
    private static final String SAMPLES_COLUMN_TOOLTIP = messages.getString("FlatProfilePanel_SamplesColumnToolTip");
    private static final String TABLE_ACCESS_NAME = messages.getString("FlatProfilePanel_TableAccessName");
    private static final String NO_RELEVANT_DATA = messages.getString("FlatProfilePanel_NoRelevantData");
    protected CustomBarCellRenderer barRenderer;
    protected ExtendedTableModel resTableModel;
    protected FilterComponent filterComponent;
    protected FlatProfileContainer flatProfileContainer;
    protected JExtendedTable resTable;
    protected JScrollPane jScrollPane;
    protected String filterString = "";
    protected boolean collectingTwoTimeStamps;
    protected boolean sortOrder;
    protected double valueFilterValue = 0.0;
    protected int filterType = 20;
    protected int sortBy;
    protected int threadId;
    private CPUSelectionHandler selectionHandler;
    private JPanel noDataPanel;
    private int minNamesColumnWidth;
    private int sortingColumn;

    public FlatProfilePanel(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
        this(actionsHandler, null, sampling);
    }

    public FlatProfilePanel(CPUResUserActionsHandler actionsHandler, CPUSelectionHandler selectionHandler, Boolean sampling) {
        super(actionsHandler, sampling);
        this.selectionHandler = selectionHandler;
        this.setDefaultSorting();
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.cornerPopup = new JPopupMenu();
        this.jScrollPane = this.createScrollPaneVerticalScrollBarAlways();
        this.jScrollPane.setCorner("UPPER_RIGHT_CORNER", this.createHeaderPopupCornerButton(this.cornerPopup));
        this.jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.jScrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (FlatProfilePanel.this.resTable != null) {
                    FlatProfilePanel.this.resTable.mouseWheelMoved(e);
                }
            }
        });
        this.initFilterPanel();
    }

    public void clearSelection() {
        this.resTable.clearSelection();
    }

    public void setCPUSelectionHandler(CPUSelectionHandler handler) {
        this.selectionHandler = handler;
    }

    @Override
    public int getCurrentThreadId() {
        return this.threadId;
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    public int getFilterType() {
        return this.filterComponent.getFilterType();
    }

    public String getFilterValue() {
        return this.filterComponent.getFilterValue();
    }

    public void setFilterValues(String filterValue, int filterType) {
        this.filterComponent.setFilter(filterValue, filterType);
    }

    public void setFindString(String findString) {
        this.resTable.setFindParameters(findString, 0);
    }

    public String getFindString() {
        return this.resTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.resTable.isFindStringDefined();
    }

    public void setResultsAvailable(boolean available) {
        JComponent viewComponent;
        JViewport viewport = this.jScrollPane.getViewport();
        JComponent jComponent = viewComponent = available ? this.resTable : this.noDataPanel;
        if (viewComponent != viewport.getView()) {
            viewport.setView(viewComponent);
            this.revalidate();
            this.repaint();
        }
    }

    public Object getResultsViewReference() {
        return this.resTable;
    }

    public int getSortBy(int column) {
        switch (column) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return this.collectingTwoTimeStamps ? 3 : 5;
            }
            case 4: {
                return this.collectingTwoTimeStamps ? 5 : 4;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 4;
            }
        }
        return 2;
    }

    public void setSorting(int sColumn, boolean sOrder) {
        this.setSorting(sColumn, sOrder, false);
    }

    public void setSorting(int sColumn, boolean sOrder, boolean refreshUI) {
        if (!refreshUI && sColumn == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = sColumn;
            this.sortOrder = sOrder;
            this.sortBy = this.getSortBy(this.sortingColumn);
        }
        if (refreshUI) {
            this.resTableModel.setInitialSorting(this.resTableModel.getVirtualColumn(sColumn), sOrder);
            this.resTableModel.sortByColumn(sColumn, sOrder);
        }
    }

    @Override
    public int getSortingColumn() {
        if (this.resTableModel == null) {
            return -1;
        }
        return this.resTableModel.getRealColumn(this.resTableModel.getSortingColumn());
    }

    @Override
    public boolean getSortingOrder() {
        if (this.resTableModel == null) {
            return false;
        }
        return this.resTableModel.getSortingOrder();
    }

    public void addFilterListener(ChangeListener listener) {
        this.filterComponent.addChangeListener(listener);
    }

    public void addResultsViewFocusListener(FocusListener listener) {
        this.resTable.addFocusListener(listener);
    }

    public boolean findFirst() {
        return this.resTable.findFirst();
    }

    public boolean findNext() {
        return this.resTable.findNext();
    }

    public boolean findPrevious() {
        return this.resTable.findPrevious();
    }

    @Override
    public void prepareResults() {
        this.prepareResults(true);
    }

    public void removeFilterListener(ChangeListener listener) {
        this.filterComponent.removeChangeListener(listener);
    }

    public void removeResultsViewFocusListener(FocusListener listener) {
        this.resTable.removeFocusListener(listener);
    }

    @Override
    public void requestFocus() {
        if (this.resTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FlatProfilePanel.this.resTable.requestFocus();
                }
            });
        }
    }

    @Override
    public void reset() {
        this.jScrollPane.setViewportView(null);
        this.flatProfileContainer = null;
        this.resTable = null;
        this.resTableModel = null;
    }

    public void selectMethod(int methodId) {
        if (methodId == 0) {
            this.resTable.getSelectionModel().clearSelection();
            return;
        }
        int sel = this.resTable.getSelectedRow();
        if (sel >= this.flatProfileContainer.getNRows()) {
            sel = this.flatProfileContainer.getNRows() - 1;
        }
        if (sel != -1 && this.getCurrentThreadId() == this.threadId && this.flatProfileContainer.getMethodIdAtRow(sel) == methodId) {
            return;
        }
        for (int i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            if (this.flatProfileContainer.getMethodIdAtRow(i) != methodId) continue;
            this.resTable.getSelectionModel().setSelectionInterval(i, i);
            this.resTable.scrollRectToVisible(this.resTable.getCellRect(i, 0, true));
            break;
        }
    }

    public void selectMethod(String methodName) {
        for (int i = 0; i < this.resTable.getRowCount(); ++i) {
            if (!this.resTable.getValueAt(i, 0).toString().equals(methodName)) continue;
            this.resTable.getSelectionModel().setSelectionInterval(i, i);
            this.resTable.scrollRectToVisible(this.resTable.getCellRect(i, 0, true));
            return;
        }
        this.resTable.getSelectionModel().clearSelection();
    }

    @Override
    protected String getSelectedMethodName() {
        if (this.resTable == null || this.resTableModel == null) {
            return null;
        }
        if (this.resTable.getSelectedRow() == -1) {
            return null;
        }
        return this.resTable.getValueAt(this.resTable.getSelectedRow(), 0).toString();
    }

    @Override
    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            menuItem.setActionCommand(Integer.toString(i));
            this.addMenuItemListener(menuItem);
            if (this.resTable != null) {
                menuItem.setState(this.resTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.cornerPopup.add(menuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem filterMenuItem = new JCheckBoxMenuItem(FILTER_ITEM_NAME);
        filterMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(filterMenuItem);
        if (this.filterComponent == null) {
            filterMenuItem.setState(true);
        } else {
            filterMenuItem.setState(this.filterComponent.getComponent().isVisible());
        }
        this.cornerPopup.add(filterMenuItem);
        this.cornerPopup.pack();
    }

    protected void initColumnsData() {
        this.columnCount = this.collectingTwoTimeStamps ? 7 : 5;
        this.columnsVisibility = new boolean[this.columnCount];
        for (int i = 0; i < this.columnCount - 1; ++i) {
            this.columnsVisibility[i] = true;
        }
        if (this.isSampling() != null && !this.isSampling().booleanValue()) {
            this.columnsVisibility[this.columnCount - 1] = true;
        }
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = METHOD_COLUMN_NAME;
        this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
        this.columnNames[1] = SELFTIME_REL_COLUMN_NAME;
        this.columnToolTips[1] = SELFTIME_REL_COLUMN_TOOLTIP;
        this.columnNames[2] = SELFTIME_COLUMN_NAME;
        this.columnToolTips[2] = SELFTIME_COLUMN_TOOLTIP;
        if (this.collectingTwoTimeStamps) {
            this.columnNames[3] = SELFTIME_CPU_COLUMN_NAME;
            this.columnToolTips[3] = SELFTIME_CPU_COLUMN_TOOLTIP;
            this.columnNames[4] = TOTALTIME_COLUMN_NAME;
            this.columnToolTips[4] = TOTALTIME_COLUMN_TOOLTIP;
            this.columnNames[5] = TOTALTIME_CPU_COLUMN_NAME;
            this.columnToolTips[5] = TOTALTIME_CPU_COLUMN_TOOLTIP;
            if (this.isSampling() != null && this.isSampling().booleanValue()) {
                this.columnNames[6] = SAMPLES_COLUMN_NAME;
                this.columnToolTips[6] = SAMPLES_COLUMN_TOOLTIP;
            } else {
                this.columnNames[6] = INVOCATIONS_COLUMN_NAME;
                this.columnToolTips[6] = INVOCATIONS_COLUMN_TOOLTIP;
            }
        } else {
            this.columnNames[3] = TOTALTIME_COLUMN_NAME;
            this.columnToolTips[3] = TOTALTIME_COLUMN_TOOLTIP;
            if (this.isSampling() != null && this.isSampling().booleanValue()) {
                this.columnNames[4] = SAMPLES_COLUMN_NAME;
                this.columnToolTips[4] = SAMPLES_COLUMN_TOOLTIP;
            } else {
                this.columnNames[4] = INVOCATIONS_COLUMN_NAME;
                this.columnToolTips[4] = INVOCATIONS_COLUMN_TOOLTIP;
            }
        }
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = maxWidth;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        for (int i = 3; i < this.columnCount; ++i) {
            this.columnWidths[i - 1] = maxWidth;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
        if (this.isSampling() == null) {
            --this.columnCount;
        }
    }

    protected abstract void obtainResults();

    protected void prepareResults(boolean firstTime) {
        int currentColumnCount;
        if (this.threadId < -1) {
            return;
        }
        int n = currentColumnCount = this.collectingTwoTimeStamps ? 7 : 5;
        if (this.columnCount != currentColumnCount) {
            this.initColumnsData();
        } else if (this.resTable != null) {
            this.saveColumnsData();
        }
        if (this.resTableModel == null || this.resTable == null) {
            this.initComponents();
        }
        if (firstTime) {
            this.obtainResults();
            String firstColumnName = this.columnNames[0];
            this.initFirstColumnName();
            if (this.resTable != null && !this.columnNames[0].equals(firstColumnName)) {
                this.resTable.getColumnModel().getColumn(0).setHeaderValue(this.columnNames[0]);
            }
        }
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.resTable.invalidate();
        this.jScrollPane.revalidate();
        this.resTable.repaint();
    }

    protected void saveColumnsData() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) continue;
            this.columnWidths[index - 1] = colModel.getColumn(i).getPreferredWidth();
        }
        this.columnsVisibility = this.resTableModel.getColumnsVisibility();
    }

    protected void updateResults() {
        int currentColumnCount;
        if (this.threadId < -1) {
            return;
        }
        int n = currentColumnCount = this.collectingTwoTimeStamps ? 7 : 5;
        if (this.columnCount != currentColumnCount) {
            this.initColumnsData();
        } else if (this.resTable != null) {
            this.saveColumnsData();
        }
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.jScrollPane.setViewportView(this.resTable);
        this.jScrollPane.getViewport().setBackground(this.resTable.getBackground());
    }

    private void setColumnsData() {
        switch (this.currentView) {
            case 0: {
                this.columnRenderers[0] = new MethodNameTableCellRenderer();
                break;
            }
            case 1: {
                this.columnRenderers[0] = new ClassNameTableCellRenderer();
                break;
            }
            case 2: {
                this.columnRenderers[0] = new LabelTableCellRenderer();
            }
        }
        TableColumnModel colModel = this.resTable.getColumnModel();
        for (int i = 0; i < this.resTableModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) {
                colModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Filter")) {
                    FlatProfilePanel.this.filterComponent.getComponent().setVisible(!FlatProfilePanel.this.filterComponent.getComponent().isVisible());
                    return;
                }
                boolean sortResults = false;
                int column = Integer.parseInt(e.getActionCommand());
                int currentSortingColumn = FlatProfilePanel.this.resTableModel.getSortingColumn();
                int realSortingColumn = FlatProfilePanel.this.resTableModel.getRealColumn(currentSortingColumn);
                boolean isColumnVisible = FlatProfilePanel.this.resTableModel.isRealColumnVisible(column);
                if (isColumnVisible && column == realSortingColumn) {
                    currentSortingColumn = currentSortingColumn + 1 == FlatProfilePanel.this.resTableModel.getColumnCount() ? currentSortingColumn - 1 : currentSortingColumn + 1;
                    realSortingColumn = FlatProfilePanel.this.resTableModel.getRealColumn(currentSortingColumn);
                    sortResults = true;
                }
                FlatProfilePanel.this.resTableModel.setRealColumnVisibility(column, !isColumnVisible);
                FlatProfilePanel.this.resTable.createDefaultColumnsFromModel();
                FlatProfilePanel.this.resTableModel.setTable(FlatProfilePanel.this.resTable);
                currentSortingColumn = FlatProfilePanel.this.resTableModel.getVirtualColumn(realSortingColumn);
                if (sortResults) {
                    FlatProfilePanel.this.sortOrder = FlatProfilePanel.this.resTableModel.getInitialSorting(currentSortingColumn);
                    FlatProfilePanel.this.sortBy = FlatProfilePanel.this.getSortBy(realSortingColumn);
                    FlatProfilePanel.this.flatProfileContainer.sortBy(FlatProfilePanel.this.sortBy, FlatProfilePanel.this.sortOrder);
                    FlatProfilePanel.this.resTable.repaint();
                }
                FlatProfilePanel.this.sortingColumn = realSortingColumn;
                FlatProfilePanel.this.resTableModel.setInitialSorting(currentSortingColumn, FlatProfilePanel.this.sortOrder);
                FlatProfilePanel.this.resTable.getTableHeader().repaint();
                FlatProfilePanel.this.setColumnsData();
            }
        });
    }

    private void initComponents() {
        this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

            @Override
            public String getColumnName(int col) {
                return FlatProfilePanel.this.columnNames[col];
            }

            @Override
            public int getRowCount() {
                if (FlatProfilePanel.this.flatProfileContainer == null) {
                    return 0;
                }
                return FlatProfilePanel.this.flatProfileContainer.getNRows();
            }

            @Override
            public int getColumnCount() {
                return FlatProfilePanel.this.columnCount;
            }

            public Class getColumnClass(int col) {
                if (col == 1) {
                    return Number.class;
                }
                return String.class;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return FlatProfilePanel.this.computeValueAt(row, col);
            }

            @Override
            public String getColumnToolTipText(int col) {
                return FlatProfilePanel.this.columnToolTips[col];
            }

            @Override
            public void sortByColumn(int column, boolean order) {
                FlatProfilePanel.this.sortingColumn = column;
                FlatProfilePanel.this.sortBy = FlatProfilePanel.this.getSortBy(column);
                FlatProfilePanel.this.sortOrder = order;
                int selectedRow = FlatProfilePanel.this.resTable.getSelectedRow();
                String selectedRowContents = null;
                if (selectedRow != -1) {
                    selectedRowContents = (String)FlatProfilePanel.this.resTable.getValueAt(selectedRow, 0);
                }
                FlatProfilePanel.this.updateResults();
                if (selectedRowContents != null) {
                    FlatProfilePanel.this.resTable.selectRowByContents(selectedRowContents, 0, true);
                }
            }

            @Override
            public boolean getInitialSorting(int column) {
                switch (column) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }
        });
        if (this.columnsVisibility != null) {
            this.resTableModel.setColumnsVisibility(this.columnsVisibility);
        }
        this.resTable = new JExtendedTable(this.resTableModel){

            @Override
            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                for (int i = 0; i < FlatProfilePanel.this.resTableModel.getColumnCount(); ++i) {
                    int index = FlatProfilePanel.this.resTableModel.getRealColumn(i);
                    if (index == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    this.getColumnModel().getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, FlatProfilePanel.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.resTable.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
        this.resTableModel.setTable(this.resTable);
        this.resTableModel.setInitialSorting(this.sortingColumn, this.sortOrder);
        this.resTable.setRowSelectionAllowed(true);
        this.resTable.setSelectionMode(0);
        this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.resTable.setShowHorizontalLines(false);
        this.resTable.setShowVerticalLines(true);
        this.resTable.setRowMargin(0);
        this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.resTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.resTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatProfilePanel.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.resTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.resTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        this.resTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            private int lastSelection = -1;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = FlatProfilePanel.this.resTable.getSelectedRow();
                int n = FlatProfilePanel.this.methodId = selectedRow != -1 ? FlatProfilePanel.this.flatProfileContainer.getMethodIdAtRow(selectedRow) : -1;
                if (FlatProfilePanel.this.selectionHandler != null) {
                    FlatProfilePanel.this.selectionHandler.methodSelected(this.lastSelection, FlatProfilePanel.this.methodId, FlatProfilePanel.this.currentView);
                }
                this.lastSelection = FlatProfilePanel.this.methodId;
            }
        });
        this.resTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedRow;
                if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = FlatProfilePanel.this.resTable.getSelectedRow()) != -1) {
                    if (FlatProfilePanel.this.popupShowSource != null) {
                        FlatProfilePanel.this.popupShowSource.setVisible(true);
                    }
                    if (FlatProfilePanel.this.popupShowReverse != null) {
                        FlatProfilePanel.this.popupShowReverse.setVisible(true);
                    }
                    FlatProfilePanel.this.popupPath = null;
                    FlatProfilePanel.this.methodId = FlatProfilePanel.this.flatProfileContainer.getMethodIdAtRow(selectedRow);
                    Rectangle cellRect = FlatProfilePanel.this.resTable.getCellRect(selectedRow, 0, false);
                    FlatProfilePanel.this.callGraphPopupMenu.show(e.getComponent(), cellRect.x + FlatProfilePanel.this.resTable.getSize().width > 50 ? 50 : 5, cellRect.y);
                }
            }
        });
        this.resTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int line;
                if (e.getModifiers() == 4 && (line = FlatProfilePanel.this.resTable.rowAtPoint(e.getPoint())) != -1) {
                    FlatProfilePanel.this.resTable.setRowSelectionInterval(line, line);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int line = FlatProfilePanel.this.resTable.rowAtPoint(e.getPoint());
                if (line == -1) {
                    if (FlatProfilePanel.this.popupShowSource != null) {
                        FlatProfilePanel.this.popupShowSource.setVisible(false);
                    }
                    if (FlatProfilePanel.this.popupShowReverse != null) {
                        FlatProfilePanel.this.popupShowReverse.setVisible(false);
                    }
                    if (e.getModifiers() == 4) {
                        FlatProfilePanel.this.popupPath = null;
                        FlatProfilePanel.this.callGraphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                } else {
                    FlatProfilePanel.this.resTable.getSelectionModel().setSelectionInterval(line, line);
                    if (FlatProfilePanel.this.popupShowSource != null) {
                        FlatProfilePanel.this.popupShowSource.setVisible(true);
                    }
                    if (FlatProfilePanel.this.popupShowReverse != null) {
                        FlatProfilePanel.this.popupShowReverse.setVisible(true);
                    }
                    FlatProfilePanel.this.methodId = FlatProfilePanel.this.flatProfileContainer.getMethodIdAtRow(line);
                    if (e.getModifiers() == 4) {
                        FlatProfilePanel.this.popupPath = null;
                        FlatProfilePanel.this.callGraphPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                        FlatProfilePanel.this.showSourceForMethod(FlatProfilePanel.this.methodId);
                    }
                }
            }
        });
        this.noDataPanel = new JPanel(new BorderLayout());
        this.noDataPanel.add((Component)new JLabel(NO_RELEVANT_DATA), "North");
        this.noDataPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.noDataPanel.setBackground(this.resTable.getBackground());
        this.jScrollPane.setViewportView(null);
        this.jScrollPane.getViewport().setBackground(this.resTable.getBackground());
    }

    protected Object computeValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.flatProfileContainer.getMethodNameAtRow(row);
            }
            case 1: {
                return new Float(this.flatProfileContainer.getPercentAtRow(row));
            }
            case 2: {
                return StringUtils.mcsTimeToString((long)this.flatProfileContainer.getTimeInMcs0AtRow(row)) + " ms (" + this.percentFormat.format(this.flatProfileContainer.getPercentAtRow(row) / 100.0f) + ")";
            }
            case 3: {
                return this.collectingTwoTimeStamps ? StringUtils.mcsTimeToString((long)this.flatProfileContainer.getTimeInMcs1AtRow(row)) + " ms" : StringUtils.mcsTimeToString((long)this.flatProfileContainer.getTotalTimeInMcs0AtRow(row)) + " ms";
            }
            case 4: {
                return this.collectingTwoTimeStamps ? StringUtils.mcsTimeToString((long)this.flatProfileContainer.getTotalTimeInMcs0AtRow(row)) + " ms" : this.intFormat.format(this.flatProfileContainer.getNInvocationsAtRow(row));
            }
            case 5: {
                return StringUtils.mcsTimeToString((long)this.flatProfileContainer.getTotalTimeInMcs1AtRow(row)) + " ms";
            }
            case 6: {
                return this.intFormat.format(this.flatProfileContainer.getNInvocationsAtRow(row));
            }
        }
        return null;
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create(true, true);
        this.filterComponent.setFilter(this.filterString, this.filterType);
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selectedRow;
                String selectedRowContents = null;
                if (FlatProfilePanel.this.resTable != null && (selectedRow = FlatProfilePanel.this.resTable.getSelectedRow()) != -1) {
                    selectedRowContents = (String)FlatProfilePanel.this.resTable.getValueAt(selectedRow, 0);
                }
                FlatProfilePanel.this.filterString = FlatProfilePanel.this.filterComponent.getFilterValue();
                FlatProfilePanel.this.filterType = FlatProfilePanel.this.filterComponent.getFilterType();
                if (FlatProfilePanel.this.flatProfileContainer != null) {
                    FlatProfilePanel.this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterValues(FlatProfilePanel.this.filterString), FlatProfilePanel.this.filterType, FlatProfilePanel.this.valueFilterValue);
                    FlatProfilePanel.this.flatProfileContainer.sortBy(FlatProfilePanel.this.sortBy, FlatProfilePanel.this.sortOrder);
                }
                if (FlatProfilePanel.this.resTable != null) {
                    FlatProfilePanel.this.resTable.invalidate();
                    FlatProfilePanel.this.jScrollPane.revalidate();
                    FlatProfilePanel.this.resTable.repaint();
                    if (selectedRowContents != null) {
                        FlatProfilePanel.this.resTable.selectRowByContents(selectedRowContents, 0, true);
                    }
                }
            }
        });
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    private void initFirstColumnName() {
        switch (this.currentView) {
            case 0: {
                this.columnNames[0] = METHOD_COLUMN_NAME;
                this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
                this.filterComponent.setHint(METHOD_FILTER_HINT);
                break;
            }
            case 1: {
                this.columnNames[0] = CLASS_COLUMN_NAME;
                this.columnToolTips[0] = CLASS_COLUMN_TOOLTIP;
                this.filterComponent.setHint(CLASS_FILTER_HINT);
                break;
            }
            case 2: {
                this.columnNames[0] = PACKAGE_COLUMN_NAME;
                this.columnToolTips[0] = PACKAGE_COLUMN_TOOLTIP;
                this.filterComponent.setHint(PACKAGE_FILTER_HINT);
            }
        }
        if (this.resTable != null) {
            this.resTable.getTableHeader().repaint();
        }
    }

    @Override
    public void setColumnsVisibility(boolean[] columnsVisibility) {
        this.resTableModel.setColumnsVisibility(columnsVisibility);
        this.resTable.createDefaultColumnsFromModel();
        this.resTableModel.setTable(this.resTable);
        this.setColumnsData();
    }

    @Override
    public boolean[] getColumnsVisibility() {
        return this.resTableModel.getColumnsVisibility();
    }

    public void setFilterVisible(boolean visible) {
        if (this.filterComponent != null) {
            this.filterComponent.getComponent().setVisible(visible);
        }
    }

    public boolean isFilterVisible() {
        return this.filterComponent == null ? false : this.filterComponent.getComponent().isVisible();
    }
}

