/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.charts.ChartFactory;
import org.graalvm.visualvm.charts.SimpleXYChartDescriptor;
import org.graalvm.visualvm.charts.SimpleXYChartSupport;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.NotSupportedDisplayer;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.utils.TimeRecord;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.monitor.JFRSnapshotMonitorViewProvider;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.openide.util.NbBundle;

class MonitorViewSupport {
    private static final String UNKNOWN = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Unknown");

    MonitorViewSupport() {
    }

    static class ThreadsViewSupport
    extends JPanel
    implements JFREventVisitor {
        private static final String LIVE = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Live_threads");
        private static final String LIVE_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Live_threads_leg");
        private static final String DAEMON = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Daemon_threads");
        private static final String DAEMON_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Daemon_threads_leg");
        private static final String PEAK = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Live_threads_peak");
        private static final String STARTED = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Started_threads_total");
        private final JFRModel jfrModel;
        private final boolean liveModel = false;
        private boolean threadsMonitoringSupported;
        private SimpleXYChartSupport chartSupport;
        private List<Threads> records;
        private JFREvent lastEvent;
        private long lastEventTime = Long.MIN_VALUE;

        ThreadsViewSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Threads"), null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new ArrayList<Threads>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.JavaThreadStatistics".equals(typeName)) {
                try {
                    Threads record = new Threads(event, this.jfrModel);
                    this.records.add(record);
                    if (this.lastEventTime < record.time) {
                        this.lastEvent = event;
                        this.lastEventTime = record.time;
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            Collections.sort(this.records, TimeRecord.COMPARATOR);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long lastTime = -9223372036854775807L;
                    for (Threads record : records) {
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.active, record.daemon});
                        lastTime = time;
                    }
                    if (!records.isEmpty()) {
                        records.clear();
                        try {
                            long activeCount = lastEvent.getLong("activeCount");
                            long daemonCount = lastEvent.getLong("daemonCount");
                            long peakCount = lastEvent.getLong("peakCount");
                            long accumulatedCount = lastEvent.getLong("accumulatedCount");
                            chartSupport.updateDetails(new String[]{chartSupport.formatDecimal(activeCount), chartSupport.formatDecimal(daemonCount), chartSupport.formatDecimal(peakCount), chartSupport.formatDecimal(accumulatedCount)});
                        }
                        catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                            // empty catch block
                        }
                    }
                    records = null;
                    lastEvent = null;
                }
            });
        }

        private void initModels() {
            this.threadsMonitoringSupported = true;
            if (this.threadsMonitoringSupported) {
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.decimal((long)3L, (boolean)false, (int)Integer.MAX_VALUE);
                chartDescriptor.addLineItems(new String[]{LIVE_LEG, DAEMON_LEG});
                chartDescriptor.setDetailsItems(new String[]{LIVE, DAEMON, PEAK, STARTED});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                this.chartSupport.setZoomingEnabled(true);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.threadsMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer("JFR snapshot"), "Center");
            }
        }

        private static final class Threads
        extends TimeRecord {
            final long active;
            final long daemon;

            Threads(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.active = event.getLong("activeCount");
                this.daemon = event.getLong("daemonCount");
            }
        }
    }

    static class ClassesViewSupport
    extends JPanel
    implements JFREventVisitor {
        private static final String TOTAL_LOADED = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Total_loaded_classes");
        private static final String TOTAL_LOADED_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Total_loaded_classes_leg");
        private static final String TOTAL_UNLOADED = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Total_unloaded_classes");
        private final JFRModel jfrModel;
        private final boolean liveModel = false;
        private boolean classMonitoringSupported;
        private SimpleXYChartSupport chartSupport;
        private List<Classes> records;
        private JFREvent lastEvent;
        private long lastEventTime = Long.MIN_VALUE;

        ClassesViewSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Classes"), null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new ArrayList<Classes>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.ClassLoadingStatistics".equals(typeName)) {
                try {
                    Classes record = new Classes(event, this.jfrModel);
                    this.records.add(record);
                    if (this.lastEventTime < record.time) {
                        this.lastEvent = event;
                        this.lastEventTime = record.time;
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            Collections.sort(this.records, TimeRecord.COMPARATOR);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long lastTime = -9223372036854775807L;
                    for (Classes record : records) {
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.loaded});
                        lastTime = time;
                    }
                    if (!records.isEmpty()) {
                        records.clear();
                        try {
                            long loadedClassCount = lastEvent.getLong("loadedClassCount");
                            long unloadedClassCount = lastEvent.getLong("unloadedClassCount");
                            chartSupport.updateDetails(new String[]{chartSupport.formatDecimal(loadedClassCount), chartSupport.formatDecimal(unloadedClassCount)});
                        }
                        catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                            // empty catch block
                        }
                    }
                    records = null;
                    lastEvent = null;
                }
            });
        }

        private void initModels() {
            this.classMonitoringSupported = true;
            if (this.classMonitoringSupported) {
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.decimal((long)100L, (boolean)false, (int)Integer.MAX_VALUE);
                chartDescriptor.addLineItems(new String[]{TOTAL_LOADED_LEG});
                chartDescriptor.setDetailsItems(new String[]{TOTAL_LOADED, TOTAL_UNLOADED});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                this.chartSupport.setZoomingEnabled(true);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.classMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer("JFR snapshot"), "Center");
            }
        }

        private static final class Classes
        extends TimeRecord {
            final long loaded;

            Classes(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.loaded = event.getLong("loadedClassCount");
            }
        }
    }

    static class MetaspaceViewSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel jfrModel;
        private final boolean liveModel = false;
        private boolean memoryMonitoringSupported;
        private final String heapName = "Metaspace";
        private SimpleXYChartSupport chartSupport;
        private List<Metaspace> records;
        private JFREvent lastEvent;
        private long lastEventTime = Long.MIN_VALUE;

        public MetaspaceViewSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Metaspace", null, 20, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new ArrayList<Metaspace>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.MetaspaceSummary".equals(typeName)) {
                try {
                    Metaspace record = new Metaspace(event, this.jfrModel);
                    this.records.add(record);
                    if (this.lastEventTime < record.time) {
                        this.lastEvent = event;
                        this.lastEventTime = record.time;
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            Collections.sort(this.records, TimeRecord.COMPARATOR);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long lastTime = -9223372036854775807L;
                    for (Metaspace record : records) {
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.commited, record.used});
                        lastTime = time;
                    }
                    if (!records.isEmpty()) {
                        records.clear();
                        try {
                            long metaspace_used = lastEvent.getLong("metaspace.used");
                            long metaspace_committed = lastEvent.getLong("metaspace.committed");
                            long metaspace_reserved = lastEvent.getLong("metaspace.reserved");
                            chartSupport.updateDetails(new String[]{chartSupport.formatBytes(metaspace_used), chartSupport.formatBytes(metaspace_committed), chartSupport.formatBytes(metaspace_reserved)});
                        }
                        catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                            // empty catch block
                        }
                    }
                    records = null;
                    lastEvent = null;
                }
            });
        }

        private void initModels() {
            this.memoryMonitoringSupported = true;
            if (this.memoryMonitoringSupported) {
                String HEAP_SIZE = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Heap_size");
                String HEAP_SIZE_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Heap_size_leg", (Object)"Metaspace");
                String USED_HEAP = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Used_heap");
                String USED_HEAP_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Used_heap_leg", (Object)"Metaspace".toLowerCase());
                String MAX_HEAP = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Max_Heap");
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0xA00000L, (boolean)false, (int)Integer.MAX_VALUE);
                chartDescriptor.addLineFillItems(new String[]{HEAP_SIZE_LEG, USED_HEAP_LEG});
                chartDescriptor.setDetailsItems(new String[]{HEAP_SIZE, USED_HEAP, MAX_HEAP});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                this.chartSupport.setZoomingEnabled(true);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.memoryMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer("JFR snapshot"), "Center");
            }
        }

        private static final class Metaspace
        extends TimeRecord {
            final long used;
            final long commited;

            Metaspace(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.used = event.getLong("metaspace.used");
                this.commited = event.getLong("metaspace.committed");
            }
        }
    }

    static class PermGenViewSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel jfrModel;
        private final boolean liveModel = false;
        private boolean memoryMonitoringSupported;
        private final String heapName = "PermGen";
        private SimpleXYChartSupport chartSupport;
        private List<PermGen> records;
        private JFREvent lastEvent;
        private long lastEventTime = Long.MIN_VALUE;

        public PermGenViewSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("PermGen", null, 20, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new ArrayList<PermGen>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("http://www.oracle.com/hotspot/jvm/vm/gc/heap/perm_gen_summary".equals(typeName)) {
                try {
                    PermGen record = new PermGen(event, this.jfrModel);
                    this.records.add(record);
                    if (this.lastEventTime < record.time) {
                        this.lastEvent = event;
                        this.lastEventTime = record.time;
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            Collections.sort(this.records, TimeRecord.COMPARATOR);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long lastTime = -9223372036854775807L;
                    for (PermGen record : records) {
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.commited, record.used});
                        lastTime = time;
                    }
                    if (!records.isEmpty()) {
                        records.clear();
                        try {
                            long permspace_used = lastEvent.getLong("objectSpace.used");
                            long permspace_committed = lastEvent.getLong("permSpace.committedSize");
                            long permspace_reserved = lastEvent.getLong("permSpace.reservedSize");
                            chartSupport.updateDetails(new String[]{chartSupport.formatBytes(permspace_used), chartSupport.formatBytes(permspace_committed), chartSupport.formatBytes(permspace_reserved)});
                        }
                        catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                            // empty catch block
                        }
                    }
                    records = null;
                    lastEvent = null;
                }
            });
        }

        private void initModels() {
            this.memoryMonitoringSupported = true;
            if (this.memoryMonitoringSupported) {
                String HEAP_SIZE = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Heap_size");
                String HEAP_SIZE_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Heap_size_leg", (Object)"PermGen");
                String USED_HEAP = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Used_heap");
                String USED_HEAP_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Used_heap_leg", (Object)"PermGen".toLowerCase());
                String MAX_HEAP = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Max_Heap");
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0xA00000L, (boolean)false, (int)Integer.MAX_VALUE);
                chartDescriptor.addLineFillItems(new String[]{HEAP_SIZE_LEG, USED_HEAP_LEG});
                chartDescriptor.setDetailsItems(new String[]{HEAP_SIZE, USED_HEAP, MAX_HEAP});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                this.chartSupport.setZoomingEnabled(true);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.memoryMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer("JFR snapshot"), "Center");
            }
        }

        private static final class PermGen
        extends TimeRecord {
            final long used;
            final long commited;

            PermGen(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.used = event.getLong("objectSpace.used");
                this.commited = event.getLong("permSpace.committedSize");
            }
        }
    }

    static class HeapViewSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel jfrModel;
        private final boolean liveModel = false;
        private boolean memoryMonitoringSupported;
        private final String heapName = "Heap";
        private SimpleXYChartSupport chartSupport;
        private List<Heap> records;
        private JFREvent lastEvent;
        private long lastEventTime = Long.MIN_VALUE;

        public HeapViewSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Heap", null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new ArrayList<Heap>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.GCHeapSummary".equals(typeName)) {
                try {
                    Heap record = new Heap(event, this.jfrModel);
                    this.records.add(record);
                    if (this.lastEventTime < record.time) {
                        this.lastEvent = event;
                        this.lastEventTime = record.time;
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            Collections.sort(this.records, TimeRecord.COMPARATOR);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long lastTime = -9223372036854775807L;
                    for (Heap record : records) {
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.commited, record.used});
                        lastTime = time;
                    }
                    if (!records.isEmpty()) {
                        records.clear();
                        try {
                            long heapUsed = lastEvent.getLong("heapUsed");
                            long heapSpace_committedSize = lastEvent.getLong("heapSpace.committedSize");
                            long heapSpace_reservedSize = lastEvent.getLong("heapSpace.reservedSize");
                            chartSupport.updateDetails(new String[]{chartSupport.formatBytes(heapUsed), chartSupport.formatBytes(heapSpace_committedSize), chartSupport.formatBytes(heapSpace_reservedSize)});
                        }
                        catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                            // empty catch block
                        }
                    }
                    records = null;
                    lastEvent = null;
                }
            });
        }

        private void initModels() {
            this.memoryMonitoringSupported = true;
            if (this.memoryMonitoringSupported) {
                String HEAP_SIZE = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Heap_size");
                String HEAP_SIZE_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Heap_size_leg", (Object)"Heap");
                String USED_HEAP = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Used_heap");
                String USED_HEAP_LEG = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Used_heap_leg", (Object)"Heap".toLowerCase());
                String MAX_HEAP = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Max_Heap");
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.bytes((long)0xA00000L, (boolean)false, (int)Integer.MAX_VALUE);
                chartDescriptor.addLineFillItems(new String[]{HEAP_SIZE_LEG, USED_HEAP_LEG});
                chartDescriptor.setDetailsItems(new String[]{HEAP_SIZE, USED_HEAP, MAX_HEAP});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                this.chartSupport.setZoomingEnabled(true);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.memoryMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer("JFR snapshot"), "Center");
            }
        }

        private static final class Heap
        extends TimeRecord {
            final long used;
            final long commited;

            Heap(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.used = event.getLong("heapUsed");
                this.commited = event.getLong("heapSpace.committedSize");
            }
        }
    }

    static class CPUViewSupport
    extends JPanel
    implements JFREventVisitor {
        private static final String CPU = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Cpu");
        private static final String CPU_USAGE = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Cpu_Usage");
        private final JFRModel jfrModel;
        private final boolean liveModel = false;
        private boolean cpuMonitoringSupported;
        private boolean gcMonitoringSupported;
        private SimpleXYChartSupport chartSupport;
        private List<CPU> records;

        CPUViewSupport(JFRModel jfrModel) {
            this.jfrModel = jfrModel;
            this.initModels();
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(CPU, null, 10, (JComponent)this, null);
        }

        @Override
        public void init() {
            this.records = new ArrayList<CPU>();
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.CPULoad".equals(typeName)) {
                try {
                    this.records.add(new CPU(event, this.jfrModel));
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            Collections.sort(this.records, TimeRecord.COMPARATOR);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    long lastTime = -9223372036854775807L;
                    for (CPU record : records) {
                        long time = jfrModel.nsToAbsoluteMillis(record.time);
                        if (time <= lastTime) {
                            time = lastTime + 1L;
                        }
                        chartSupport.addValues(time, new long[]{record.value});
                        lastTime = time;
                    }
                    if (!records.isEmpty()) {
                        CPU last = (CPU)records.get(records.size() - 1);
                        records.clear();
                        String cpuDetail = chartSupport.formatPercent(last.value);
                        chartSupport.updateDetails(new String[]{cpuDetail});
                    }
                    records = null;
                }
            });
        }

        private void initModels() {
            this.cpuMonitoringSupported = true;
            this.gcMonitoringSupported = false;
            if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
                SimpleXYChartDescriptor chartDescriptor = SimpleXYChartDescriptor.percent((boolean)false, (double)0.1, (int)Integer.MAX_VALUE);
                chartDescriptor.addLineItems(new String[]{CPU_USAGE});
                chartDescriptor.setDetailsItems(new String[]{CPU_USAGE});
                this.chartSupport = ChartFactory.createSimpleXYChart((SimpleXYChartDescriptor)chartDescriptor);
                this.chartSupport.setZoomingEnabled(true);
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.cpuMonitoringSupported || this.gcMonitoringSupported) {
                this.add((Component)this.chartSupport.getChart(), "Center");
                this.chartSupport.updateDetails(new String[]{UNKNOWN, UNKNOWN});
            } else {
                this.add((Component)new NotSupportedDisplayer("JFR snapshot"), "Center");
            }
        }

        private static final class CPU
        extends TimeRecord {
            final long value;

            CPU(JFREvent event, JFRModel jfrModel) throws JFRPropertyNotAvailableException {
                super(event, jfrModel);
                this.value = Math.round(event.getFloat("jvmUser") * 1000.0f) + Math.round(event.getFloat("jvmSystem") * 1000.0f);
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel {
        private final JFRModel model;
        private HTMLTextArea area;

        MasterViewSupport(JFRModel model) {
            this.model = model;
            this.initComponents();
        }

        abstract void firstShown();

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Monitor"), null, (JComponent)this);
        }

        void dataComputed() {
            final String telemetry = this.getBasicTelemetry(this.model);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    area.setText(telemetry);
                }
            });
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this.model == null) {
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else if (!this.model.containsEvent(JFRSnapshotMonitorViewProvider.EventChecker.class)) {
                ArrayList<String> eventTypes = new ArrayList<String>();
                eventTypes.addAll(Arrays.asList(JFRSnapshotMonitorViewProvider.EventChecker.checkedTypes()));
                eventTypes.remove("http://www.oracle.com/hotspot/jvm/vm/gc/heap/perm_gen_summary");
                this.add((Component)MessageComponent.noData(NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Monitor"), eventTypes.toArray(new String[0])), "Center");
            } else {
                this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
                this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
                this.add((Component)this.area, "Center");
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.firstShown();
                                }
                            });
                        }
                    }
                });
            }
        }

        private String getBasicTelemetry(JFRModel model) {
            boolean terminated;
            Instant startTime = model.getJvmStartTime();
            Instant endTime = model.getJvmShutdownTime();
            boolean bl = terminated = endTime != null;
            if (!terminated) {
                endTime = model.getLastEventTime();
            }
            String ret = NbBundle.getMessage(MonitorViewSupport.class, (String)"LBL_Uptime", (Object)(startTime == null ? "&lt;unknown&gt;" : MasterViewSupport.getTime(startTime, endTime)));
            if (terminated) {
                String reason = model.getJvmShutdownReason();
                ret = ret + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>Terminated:</b> " + (reason != null ? reason : "&lt;unknown reason&gt;");
            }
            return ret;
        }

        private static String getTime(Instant startTime, Instant endTime) {
            long millis = ValuesConverter.durationToMillis(Duration.between(startTime, endTime));
            long hours = millis / 3600000L;
            String sHours = hours == 0L ? null : new DecimalFormat("#0").format(hours);
            long minutes = (millis %= 3600000L) / 60000L;
            String sMinutes = new DecimalFormat(hours > 0L ? "00" : "#0").format(minutes);
            String sSeconds = new DecimalFormat("#0.000").format((double)(millis %= 60000L) / 1000.0);
            if (sHours == null) {
                return NbBundle.getMessage(MonitorViewSupport.class, (String)"FORMAT_ms", (Object[])new Object[]{sMinutes, sSeconds});
            }
            return NbBundle.getMessage(MonitorViewSupport.class, (String)"FORMAT_hms", (Object[])new Object[]{sHours, sMinutes, sSeconds});
        }
    }
}

