/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.impl;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.api.scripting.Scripting;
import org.netbeans.core.network.proxy.pac.PacHelperMethods;
import org.netbeans.core.network.proxy.pac.PacJsEntryFunction;
import org.netbeans.core.network.proxy.pac.PacParsingException;
import org.netbeans.core.network.proxy.pac.PacScriptEvaluator;
import org.netbeans.core.network.proxy.pac.PacUtils;
import org.netbeans.core.network.proxy.pac.PacValidationException;
import org.netbeans.core.network.proxy.pac.impl.Bundle;
import org.netbeans.core.network.proxy.pac.impl.HelperScriptFactory;
import org.netbeans.core.network.proxy.pac.impl.NbPacHelperMethods;
import org.netbeans.core.network.utils.SimpleObjCache;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class NbPacScriptEvaluator
implements PacScriptEvaluator {
    private static final Logger LOGGER = Logger.getLogger(NbPacScriptEvaluator.class.getName());
    private final boolean canUseURLCaching;
    private final PacScriptEngine scriptEngine;
    private final SimpleObjCache<URI, List<Proxy>> resultCache;
    private static final String PAC_PROXY = "PROXY";
    private static final String PAC_DIRECT = "DIRECT";
    private static final String PAC_SOCKS = "SOCKS";
    private static final String PAC_SOCKS4_FFEXT = "SOCKS4";
    private static final String PAC_SOCKS5_FFEXT = "SOCKS5";
    private static final String PAC_HTTP_FFEXT = "HTTP";
    private static final String PAC_HTTPS_FFEXT = "HTTPS";
    private final String pacScriptSource;

    public NbPacScriptEvaluator(String string) throws PacParsingException {
        this.pacScriptSource = string;
        this.scriptEngine = this.getScriptEngine(string);
        this.canUseURLCaching = !NbPacScriptEvaluator.usesTimeDateFunctions(string);
        this.resultCache = this.canUseURLCaching ? new SimpleObjCache(100) : null;
    }

    @Override
    public List<Proxy> findProxyForURL(URI uRI) throws PacValidationException {
        List<Proxy> list;
        if (this.resultCache != null && (list = this.resultCache.get(uRI)) != null) {
            return list;
        }
        try {
            Object object = this.scriptEngine.findProxyForURL(PacUtils.toStrippedURLStr(uRI), uRI.getHost());
            list = this.analyzeResult(uRI, object);
            if (this.canUseURLCaching && this.resultCache != null) {
                this.resultCache.put(uRI, list);
            }
            return list;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        catch (ScriptException scriptException) {
            LOGGER.log(Level.WARNING, "Error when executing PAC script function " + this.scriptEngine.getJsMainFunction().getJsFunctionName() + " : ", scriptException);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        catch (Exception exception) {
            if (exception.getCause() != null && exception.getCause() instanceof ClassNotFoundException) {
                LOGGER.log(Level.WARNING, "The downloaded PAC script is attempting to access Java class ''{0}'' which may be a sign of maliciousness. You should investigate this with your network administrator.", exception.getCause().getMessage());
                return Collections.singletonList(Proxy.NO_PROXY);
            }
            LOGGER.log(Level.WARNING, "Error when executing PAC script function " + this.scriptEngine.getJsMainFunction().getJsFunctionName() + " : ", exception);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
    }

    @Override
    public boolean usesCaching() {
        return this.canUseURLCaching && this.resultCache != null;
    }

    @Override
    public String getJsEntryFunction() {
        return this.scriptEngine.getJsMainFunction().getJsFunctionName();
    }

    @Override
    public String getEngineInfo() {
        ScriptEngineFactory scriptEngineFactory = this.scriptEngine.getScriptEngine().getFactory();
        return scriptEngineFactory.getEngineName() + " version " + scriptEngineFactory.getEngineVersion();
    }

    @Override
    public String getPacScriptSource() {
        return this.pacScriptSource;
    }

    private PacScriptEngine getScriptEngine(String string) throws PacParsingException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            ScriptEngine scriptEngine = NbPacScriptEvaluator.newAllowedPacEngine(stringBuilder);
            if (scriptEngine == null) {
                throw new PacParsingException(stringBuilder.toString());
            }
            LOGGER.log(Level.FINE, "PAC script evaluator using:  {0}", this.getEngineInfo(scriptEngine));
            PacHelperMethods pacHelperMethods = (PacHelperMethods)Lookup.getDefault().lookup(PacHelperMethods.class);
            if (pacHelperMethods == null) {
                pacHelperMethods = new NbPacHelperMethods();
            }
            String[] stringArray = "Object,Function,Array,String,Date,Number,BigInt,Boolean,RegExp,Math,JSON,NaN,Infinity,undefined,isNaN,isFinite,parseFloat,parseInt,encodeURI,encodeURIComponent,decodeURI,decodeURIComponent,eval,escape,unescape,Error,EvalError,RangeError,ReferenceError,SyntaxError,TypeError,URIError,ArrayBuffer,Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array,BigInt64Array,BigUint64Array,DataView,Map,Set,WeakMap,WeakSet,Symbol,Reflect,Proxy,Promise,SharedArrayBuffer,Atomics,console,performance,arguments".split(",");
            Object object = scriptEngine.eval("(function(allowed) {\n   var names = Object.getOwnPropertyNames(this);\n   MAIN: for (var i = 0; i < names.length; i++) {\n     for (var j = 0; j < allowed.length; j++) {\n       if (names[i] === allowed[j]) {\n         continue MAIN;\n       }\n     }\n     delete this[names[i]];\n   }\n})");
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(object, "call", null, stringArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ScriptException(noSuchMethodException);
            }
            scriptEngine.eval(string);
            String string2 = HelperScriptFactory.getPacHelperSource();
            LOGGER.log(Level.FINER, "PAC Helper JavaScript :\n{0}", string2);
            Object object2 = scriptEngine.eval(string2);
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(object2, "call", null, pacHelperMethods);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ScriptException(noSuchMethodException);
            }
            PacJsEntryFunction pacJsEntryFunction = this.testScriptEngine(scriptEngine, false);
            return new PacScriptEngine(scriptEngine, pacJsEntryFunction);
        }
        catch (ScriptException scriptException) {
            throw new PacParsingException(scriptException);
        }
    }

    private static ScriptEngine newAllowedPacEngine(StringBuilder stringBuilder) {
        return NbPacScriptEvaluator.newAllowedPacEngine(null, stringBuilder);
    }

    public static ScriptEngine newAllowedPacEngine(String string, StringBuilder stringBuilder) {
        if (string == null) {
            string = Bundle.ALLOWED_PAC_ENGINES();
        }
        ScriptEngineManager scriptEngineManager = Scripting.newBuilder().build();
        for (String string2 : string.split(",")) {
            ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(string2);
            if (scriptEngine == null) continue;
            return scriptEngine;
        }
        if (stringBuilder != null) {
            NbPacScriptEvaluator.logWarning(stringBuilder, string, scriptEngineManager);
        }
        return null;
    }

    private static void logWarning(StringBuilder stringBuilder, String string, ScriptEngineManager scriptEngineManager) {
        stringBuilder.append("Cannot find secure PAC script engine.\n");
        stringBuilder.append("Allowed engines: ").append(string).append("\n");
        stringBuilder.append("Found engines:\n");
        for (ScriptEngineFactory scriptEngineFactory : scriptEngineManager.getEngineFactories()) {
            stringBuilder.append("  ").append(scriptEngineFactory.getEngineName()).append("\n");
        }
        stringBuilder.append("Will not resolve proxy configuration.\n");
        stringBuilder.append("Brand ALLOWED_PAC_ENGINES key in org.netbeans.core.network.proxy.pac.impl.Bundle to configure.\n");
    }

    private PacJsEntryFunction testScriptEngine(ScriptEngine scriptEngine, boolean bl) throws PacParsingException {
        if (this.isJsFunctionAvailable(scriptEngine, PacJsEntryFunction.IPV6_AWARE.getJsFunctionName(), bl)) {
            return PacJsEntryFunction.IPV6_AWARE;
        }
        if (this.isJsFunctionAvailable(scriptEngine, PacJsEntryFunction.STANDARD.getJsFunctionName(), bl)) {
            return PacJsEntryFunction.STANDARD;
        }
        throw new PacParsingException("Function " + PacJsEntryFunction.STANDARD.getJsFunctionName() + " or " + PacJsEntryFunction.IPV6_AWARE.getJsFunctionName() + " not found in PAC Script.");
    }

    private boolean isJsFunctionAvailable(ScriptEngine scriptEngine, String string, boolean bl) {
        try {
            Object object = scriptEngine.eval("(function(name) { return typeof this[name]; })");
            Object object2 = ((Invocable)((Object)scriptEngine)).invokeMethod(object, "call", null, string);
            return "function".equals(object2);
        }
        catch (NoSuchMethodException | ScriptException exception) {
            LOGGER.log(Level.WARNING, null, exception);
            return false;
        }
    }

    private static boolean usesTimeDateFunctions(String string) {
        Pattern pattern = Pattern.compile(".*(timeRange\\s*\\(|dateRange\\s*\\(|weekdayRange\\s*\\().*", 32);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private String getEngineInfo(ScriptEngine scriptEngine) {
        StringBuilder stringBuilder = new StringBuilder();
        ScriptEngineFactory scriptEngineFactory = scriptEngine.getFactory();
        stringBuilder.append("LanguageName=");
        stringBuilder.append("\"").append(scriptEngineFactory.getLanguageName()).append("\"");
        stringBuilder.append(" ");
        stringBuilder.append("LanguageVersion=");
        stringBuilder.append("\"").append(scriptEngineFactory.getLanguageVersion()).append("\"");
        stringBuilder.append(" ");
        stringBuilder.append("EngineName=");
        stringBuilder.append("\"").append(scriptEngineFactory.getEngineName()).append("\"");
        stringBuilder.append(" ");
        stringBuilder.append("EngineNameAliases=");
        stringBuilder.append(Arrays.toString(scriptEngineFactory.getNames().toArray(new String[scriptEngineFactory.getNames().size()])));
        stringBuilder.append(" ");
        stringBuilder.append("EngineVersion=");
        stringBuilder.append("\"").append(scriptEngineFactory.getEngineVersion()).append("\"");
        return stringBuilder.toString();
    }

    private List<Proxy> analyzeResult(URI uRI, Object object) throws PacValidationException {
        if (object == null) {
            LOGGER.log(Level.FINE, "Null result for {0}", uRI);
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ";");
        LinkedList<Proxy> linkedList = new LinkedList<Proxy>();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            linkedList.add(NbPacScriptEvaluator.getProxy(string));
        }
        return linkedList;
    }

    private static Proxy getProxy(String string) throws PacValidationException {
        Proxy.Type type;
        if (string.equals(PAC_DIRECT)) {
            return Proxy.NO_PROXY;
        }
        String[] stringArray = string.split(" +");
        if (stringArray.length != 2) {
            throw new PacValidationException("The value \"" + string + "\" has incorrect format");
        }
        switch (stringArray[0]) {
            case "PROXY": 
            case "HTTP": 
            case "HTTPS": {
                type = Proxy.Type.HTTP;
                break;
            }
            case "SOCKS": 
            case "SOCKS4": 
            case "SOCKS5": {
                type = Proxy.Type.SOCKS;
                break;
            }
            default: {
                throw new PacValidationException("The value \"" + stringArray[0] + "\" is an unknown proxy type");
            }
        }
        String string2 = stringArray[1];
        int n = string2.lastIndexOf(":");
        if (n <= 0 || n == string2.length() - 1) {
            throw new PacValidationException("The string \"" + stringArray[1] + "\" has no port number");
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PacValidationException("The portno value \"" + string4 + "\" cannot be converted to an integer");
        }
        return new Proxy(type, new InetSocketAddress(string3, n2));
    }

    private static class PacScriptEngine {
        private final ScriptEngine scriptEngine;
        private final PacJsEntryFunction jsMainFunction;
        private final Invocable invocable;

        public PacScriptEngine(ScriptEngine scriptEngine, PacJsEntryFunction pacJsEntryFunction) {
            this.scriptEngine = scriptEngine;
            this.jsMainFunction = pacJsEntryFunction;
            this.invocable = (Invocable)((Object)scriptEngine);
        }

        public PacJsEntryFunction getJsMainFunction() {
            return this.jsMainFunction;
        }

        public ScriptEngine getScriptEngine() {
            return this.scriptEngine;
        }

        public Invocable getInvocable() {
            return this.invocable;
        }

        public Object findProxyForURL(String string, String string2) throws ScriptException, NoSuchMethodException {
            return this.invocable.invokeFunction(this.jsMainFunction.getJsFunctionName(), string, string2);
        }
    }
}

