/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.gtk;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import org.netbeans.swing.plaf.util.UIUtils;

final class ThemeValue
implements UIDefaults.ActiveValue {
    private final Object fallback;
    private final Region aRegion;
    private ColorType aColorType = null;
    private boolean darken = false;
    private Object value = null;
    private static Boolean functioning = null;
    private int ct = 0;
    private static boolean log = Boolean.getBoolean("themeValue.log");
    private static JButton dummyButton = null;
    private static Class<?> gtkColorType = null;
    private static Method synthStyle_getColorForState = null;
    private static Method synthStyle_getFontForState = null;
    static ColorType LIGHT = null;
    static ColorType DARK = null;
    static ColorType BLACK = null;
    static ColorType WHITE = null;
    static ColorType MID = null;
    private static HashSet<ThemeValue> instances = null;

    public ThemeValue(Region region, ColorType colorType, Object fallback) {
        this.fallback = fallback;
        this.aRegion = region;
        this.aColorType = colorType;
        ThemeValue.register(this);
    }

    public ThemeValue(Region region, ColorType colorType, Object fallback, boolean darken) {
        this.fallback = fallback;
        this.aRegion = region;
        this.aColorType = colorType;
        this.darken = darken;
        ThemeValue.register(this);
    }

    public ThemeValue(Region region, Font fallback) {
        this.fallback = fallback;
        this.aRegion = region;
        ThemeValue.register(this);
    }

    @Override
    public Object createValue(UIDefaults table) {
        if (this.value == null) {
            if (!ThemeValue.functioning()) {
                this.value = this.fallback;
            } else if (this.fallback instanceof Font) {
                Font val = this.getFont();
                if (this.ct++ < 4) {
                    return val;
                }
                this.value = val;
            } else {
                this.value = this.getColor();
            }
        }
        return this.value != null ? this.value : this.fallback;
    }

    void clear() {
        this.value = null;
    }

    public Font getFont() {
        block4: {
            SynthStyle style = ThemeValue.getSynthStyle(this.aRegion);
            if (Boolean.TRUE.equals(functioning)) {
                try {
                    Font result = (Font)synthStyle_getFontForState.invoke((Object)style, ThemeValue.getSynthContext());
                    if (result == null) {
                        result = (Font)this.fallback;
                    }
                    return result;
                }
                catch (Exception e) {
                    functioning = Boolean.FALSE;
                    if (!log) break block4;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Color getColor() {
        block5: {
            SynthStyle style = ThemeValue.getSynthStyle(this.aRegion);
            if (Boolean.TRUE.equals(functioning)) {
                try {
                    Color result = (Color)synthStyle_getColorForState.invoke((Object)style, ThemeValue.getSynthContext(), this.aColorType);
                    if (result == null) {
                        result = (Color)this.fallback;
                    }
                    if (this.darken) {
                        result = result.darker();
                    }
                    return result;
                }
                catch (Exception e) {
                    functioning = Boolean.FALSE;
                    if (!log) break block5;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean functioning() {
        if (functioning == null) {
            ThemeValue.checkFunctioning();
        }
        return functioning;
    }

    private static void checkFunctioning() {
        functioning = Boolean.FALSE;
        try {
            gtkColorType = UIUtils.classForName("com.sun.java.swing.plaf.gtk.GTKColorType");
            synthStyle_getColorForState = SynthStyle.class.getDeclaredMethod("getColorForState", SynthContext.class, ColorType.class);
            synthStyle_getColorForState.setAccessible(true);
            synthStyle_getFontForState = SynthStyle.class.getDeclaredMethod("getFontForState", SynthContext.class);
            synthStyle_getFontForState.setAccessible(true);
            LIGHT = (ColorType)ThemeValue.valueOfField(gtkColorType, "LIGHT");
            DARK = (ColorType)ThemeValue.valueOfField(gtkColorType, "DARK");
            MID = (ColorType)ThemeValue.valueOfField(gtkColorType, "MID");
            BLACK = (ColorType)ThemeValue.valueOfField(gtkColorType, "BLACK");
            WHITE = (ColorType)ThemeValue.valueOfField(gtkColorType, "WHITE");
            functioning = Boolean.TRUE;
        }
        catch (Exception e) {
            System.err.println("Cannot initialize GTK colors - using hardcoded defaults: " + e);
            if (log) {
                e.printStackTrace();
            }
            return;
        }
    }

    private static JButton getDummyButton() {
        if (dummyButton == null) {
            dummyButton = new JButton();
            CellRendererPane crp = new CellRendererPane();
            crp.add(dummyButton);
        }
        ButtonModel mdl = dummyButton.getModel();
        return dummyButton;
    }

    private static SynthContext getSynthContext() {
        try {
            JButton dummyButton = ThemeValue.getDummyButton();
            ButtonUI bui = dummyButton.getUI();
            if (bui instanceof SynthUI) {
                return ((SynthUI)((Object)bui)).getContext(dummyButton);
            }
            throw new IllegalStateException("I don't have a SynthButtonUI to play with");
        }
        catch (Exception e) {
            functioning = Boolean.FALSE;
            if (log) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static SynthStyle getSynthStyle(Region region) {
        return SynthLookAndFeel.getStyle(ThemeValue.getDummyButton(), region);
    }

    private static Object valueOfField(Class clazz, String field) throws NoSuchFieldException, IllegalAccessException {
        Field f = clazz.getDeclaredField(field);
        f.setAccessible(true);
        return f.get(null);
    }

    private static synchronized void register(ThemeValue value) {
        if (instances == null) {
            instances = new HashSet();
            ThemeValue.registerPcl();
        }
        instances.add(value);
    }

    private static void registerPcl() {
        Listener l = new Listener();
        UIManager.addPropertyChangeListener(l);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Gtk/FontName", l);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Xft/DPI", l);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("gnome.Net/ThemeName", l);
    }

    static {
        ThemeValue.functioning();
    }

    private static class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getSource() instanceof UIManager && "lookAndFeel".equals(pce.getPropertyName())) {
                String s = UIManager.getLookAndFeel().getClass().getName();
                if (s.indexOf("gtk") < 0) {
                    UIManager.removePropertyChangeListener(this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Gtk/FontName", this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Xft/DPI", this);
                    Toolkit.getDefaultToolkit().removePropertyChangeListener("gnome.Net/ThemeName", this);
                }
            } else {
                for (ThemeValue tv : instances) {
                    tv.clear();
                }
            }
        }
    }
}

