/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVConfig;
import mediathek.daten.DatenMediaDB;
import mediathek.daten.DatenMediaPath;
import mediathek.file.GetFile;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.messages.mediadb.MediaDbStartEvent;
import mediathek.gui.messages.mediadb.MediaDbStopEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.TextCopyPasteHandler;
import mediathek.tool.cellrenderer.CellRendererMediaDB;
import mediathek.tool.models.NonEditableTableModel;
import mediathek.tool.models.TModelMediaDB;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelMediaDB
extends PanelVorlage {
    private final NonEditableTableModel modelPath = new NonEditableTableModel(new Object[0][], DatenMediaPath.COLUMN_NAMES);
    private final TModelMediaDB modelMediaDB = new TModelMediaDB(new Object[0][], DatenMediaDB.COLUMN_NAMES);
    private static final Logger logger = LogManager.getLogger();
    private JButton btnClean;
    private JButton btnDel;
    private JButton btnExtAdd;
    private JButton btnExtPath;
    private JComboBox<String> cbxExtMedien;
    private JButton jButtonAdd;
    private JButton jButtonExport;
    private JButton jButtonExportPath;
    private JButton jButtonHelp;
    private JButton jButtonMakeIndex;
    private JButton jButtonPath;
    private JButton jButtonRemove;
    private JCheckBox jCheckBoxMediaDB;
    private JLabel jLabelSizeIndex;
    private JRadioButton jRadioButtonMitSuffix;
    private JRadioButton jRadioButtonOhneSuffix;
    private JTable jTableMediaDB;
    private JTable jTablePath;
    private JTextField jTextFieldExportPath;
    private JTextField jTextFieldPath;
    private JTextField jTextFieldSuffix;
    private JToggleButton jToggleButtonLoad;
    private JProgressBar progress;

    @Handler
    private void handleMediaDbStartEvent(MediaDbStartEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.setIndex(false);
            this.modelMediaDB.setRowCount(0);
            this.jToggleButtonLoad.setSelected(false);
        });
    }

    @Handler
    private void handleMediaDbStopEvent(MediaDbStopEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.jLabelSizeIndex.setText("" + this.daten.getListeMediaDB().size());
            this.setIndex(true);
        });
    }

    public PanelMediaDB(Daten d, JFrame parent) {
        super(d, parent);
        this.initComponents();
        this.daten = d;
        MessageBus.getMessageBus().subscribe(this);
        this.progress.setVisible(false);
        this.progress.setIndeterminate(true);
        this.progress.setMaximum(0);
        this.progress.setMinimum(0);
        this.progress.setValue(0);
        this.jTablePath.setModel(this.modelPath);
        this.jTablePath.getColumnModel().getColumn(this.jTablePath.convertColumnIndexToView(1)).setMinWidth(0);
        this.jTablePath.getColumnModel().getColumn(this.jTablePath.convertColumnIndexToView(1)).setPreferredWidth(0);
        this.jTablePath.getColumnModel().getColumn(this.jTablePath.convertColumnIndexToView(1)).setMaxWidth(0);
        CellRendererMediaDB cellRenderer = new CellRendererMediaDB();
        this.jTableMediaDB.setDefaultRenderer(Object.class, cellRenderer);
        this.jTableMediaDB.setModel(this.modelMediaDB);
        this.jTextFieldSuffix.setText(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX));
        this.jTextFieldSuffix.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX, PanelMediaDB.this.jTextFieldSuffix.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX, PanelMediaDB.this.jTextFieldSuffix.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX, PanelMediaDB.this.jTextFieldSuffix.getText());
            }
        });
        this.jTextFieldExportPath.setText(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_EXPORT_DATEI));
        this.jTextFieldExportPath.getDocument().addDocumentListener(new BeobTextFeld());
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldExportPath);
        this.jTextFieldExportPath.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldPath);
        this.jTextFieldPath.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldSuffix);
        this.jTextFieldSuffix.setComponentPopupMenu(handler.getPopupMenu());
        this.jRadioButtonOhneSuffix.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX_OHNE)));
        this.jRadioButtonMitSuffix.setSelected(!Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX_OHNE)));
        this.jRadioButtonOhneSuffix.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX_OHNE, Boolean.toString(this.jRadioButtonOhneSuffix.isSelected())));
        this.jRadioButtonMitSuffix.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_SUFFIX_OHNE, Boolean.toString(this.jRadioButtonOhneSuffix.isSelected())));
        this.jCheckBoxMediaDB.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_ECHTZEITSUCHE)));
        this.jCheckBoxMediaDB.addActionListener(ae -> MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_ECHTZEITSUCHE, Boolean.toString(this.jCheckBoxMediaDB.isSelected())));
        this.jButtonMakeIndex.addActionListener(e -> {
            this.jLabelSizeIndex.setText("0");
            this.daten.getListeMediaDB().createMediaDB("");
        });
        this.btnDel.addActionListener(l -> {
            int ret = JOptionPane.showConfirmDialog(this.parentComponent, "Auch die Medien aus externen Laufwerken l\u00f6schen?", "L\u00f6schen", 1);
            if (ret == 0) {
                this.daten.getListeMediaDB().delList(false);
            } else if (ret == 1) {
                this.daten.getListeMediaDB().delList(true);
            }
        });
        this.jButtonPath.setIcon(IconFontSwing.buildIcon(FontAwesome.FOLDER_OPEN_O, 16.0f));
        this.jButtonAdd.setIcon(Icons.ICON_BUTTON_ADD);
        this.jButtonRemove.setIcon(Icons.ICON_BUTTON_REMOVE);
        this.jButtonPath.addActionListener(new BeobPath(false));
        this.jButtonAdd.addActionListener(e -> this.addPath());
        this.jButtonRemove.addActionListener(e -> this.removePath());
        this.jButtonHelp.setIcon(IconFontSwing.buildIcon(FontAwesome.QUESTION_CIRCLE_O, 16.0f));
        this.jButtonHelp.addActionListener(e -> new DialogHilfe(MediathekGui.ui(), true, new GetFile().getHilfeSuchen("hilfetext_panel_mediaDb.txt")).setVisible(true));
        this.jButtonExportPath.setIcon(IconFontSwing.buildIcon(FontAwesome.FOLDER_OPEN_O, 16.0f));
        this.jButtonExport.addActionListener(l -> this.filmeExportieren());
        this.jButtonExportPath.addActionListener(new BeobPfad());
        this.btnExtAdd.addActionListener(l -> {
            String s2 = (String)this.cbxExtMedien.getSelectedItem();
            if (s2 != null && !s2.isEmpty()) {
                this.daten.getListeMediaDB().createMediaDB(s2);
            }
        });
        this.btnExtPath.addActionListener(new BeobPath(true));
        this.btnClean.addActionListener(l -> this.daten.getListeMediaDB().cleanList());
        this.jToggleButtonLoad.addActionListener(e -> {
            if (this.jToggleButtonLoad.isSelected()) {
                this.daten.getListeMediaDB().getModelMediaDB(this.modelMediaDB);
            } else {
                this.modelMediaDB.setRowCount(0);
            }
        });
        this.setCbkExt("");
        this.setTablePath();
    }

    private void filmeExportieren() {
        String exporDatei = this.jTextFieldExportPath.getText();
        if (exporDatei.equals("")) {
            MVMessageDialog.showMessageDialog(this.parentComponent, "Keine Datei angegeben", "Pfad", 1);
        } else {
            try {
                int ret = new File(exporDatei).exists() ? JOptionPane.showConfirmDialog(this.parentComponent, "Datei:  \"" + exporDatei + "\"  existiert bereits", "\u00dcberschreiben?", 0) : 0;
                if (ret == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.updateUI();
                    this.daten.getListeMediaDB().exportListe(exporDatei);
                    if (!new File(exporDatei).exists()) {
                        MVMessageDialog.showMessageDialog(this.parentComponent, "Datei:  \"" + exporDatei + "\"  Konnte nicht erstellt werden!", "Fehler", 0);
                    }
                }
            }
            catch (Exception ex) {
                logger.error("filmeExportieren()", (Throwable)ex);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setIndex(boolean noIndex) {
        this.progress.setVisible(!noIndex);
        this.jTextFieldPath.setEnabled(noIndex);
        this.jButtonMakeIndex.setEnabled(noIndex);
        this.jButtonAdd.setEnabled(noIndex);
        this.jButtonPath.setEnabled(noIndex);
        this.jButtonRemove.setEnabled(noIndex);
    }

    private void addPath() {
        String add = this.jTextFieldPath.getText();
        if (add.isEmpty()) {
            return;
        }
        for (DatenMediaPath mp : this.daten.getListeMediaPath()) {
            if (!mp.arr[0].equals(add)) continue;
            return;
        }
        this.daten.getListeMediaPath().add(new DatenMediaPath(add, false));
        this.setTablePath();
    }

    private void removePath() {
        int row = this.jTablePath.getSelectedRow();
        if (row < 0) {
            NoSelectionErrorDialog.show();
            return;
        }
        String path = this.jTablePath.getModel().getValueAt(this.jTablePath.convertRowIndexToModel(row), 0).toString();
        this.daten.getListeMediaPath().removeIf(mp -> mp.arr[0].equals(path));
        this.setTablePath();
    }

    private void setTablePath() {
        this.daten.getListeMediaPath().addObjectData(this.modelPath);
    }

    private void setCbkExt(String add) {
        if (!add.isEmpty()) {
            this.daten.getListeMediaPath().addSave(new DatenMediaPath(add, true));
            this.cbxExtMedien.setModel(this.daten.getListeMediaPath().getComboModel());
            this.cbxExtMedien.setSelectedItem(add);
        } else {
            this.cbxExtMedien.setModel(this.daten.getListeMediaPath().getComboModel());
        }
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        this.jButtonHelp = new JButton();
        this.progress = new JProgressBar();
        this.jButtonMakeIndex = new JButton();
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        JPanel jPanel6 = new JPanel();
        JLabel jLabel5 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTablePath = new JTable();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.jTextFieldPath = new JTextField();
        this.jButtonPath = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        JScrollPane jScrollPane3 = new JScrollPane();
        JTextArea jTextArea1 = new JTextArea();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel8 = new JPanel();
        this.cbxExtMedien = new JComboBox();
        this.btnExtAdd = new JButton();
        this.btnExtPath = new JButton();
        JScrollPane jScrollPane4 = new JScrollPane();
        JTextArea jTextArea2 = new JTextArea();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.jCheckBoxMediaDB = new JCheckBox();
        this.btnClean = new JButton();
        this.btnDel = new JButton();
        JPanel jPanel2 = new JPanel();
        this.jRadioButtonOhneSuffix = new JRadioButton();
        this.jRadioButtonMitSuffix = new JRadioButton();
        this.jTextFieldSuffix = new JTextField();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JPanel jPanel7 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jTextFieldExportPath = new JTextField();
        this.jButtonExportPath = new JButton();
        this.jButtonExport = new JButton();
        JPanel jPanel5 = new JPanel();
        this.jToggleButtonLoad = new JToggleButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.jTableMediaDB = new JTable();
        JLabel jLabel2 = new JLabel();
        this.jLabelSizeIndex = new JLabel();
        this.setMinimumSize(new Dimension(2, 483));
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHelp.setToolTipText("Hilfe anzeigen");
        this.jButtonMakeIndex.setText("Index neu aufbauen");
        this.jButtonMakeIndex.setToolTipText("");
        jLabel5.setText("In den Pfaden nach Medien suchen");
        this.jTablePath.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        jScrollPane1.setViewportView(this.jTablePath);
        jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)), "Pfad hinzuf\u00fcgen/l\u00f6schen"));
        jLabel4.setText("Pfad:");
        this.jButtonPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonPath.setToolTipText("Pfad ausw\u00e4hlen");
        this.jButtonAdd.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-add.png")));
        this.jButtonAdd.setToolTipText("vorgegebenen Pfad hinzuf\u00fcgen");
        this.jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-remove.png")));
        this.jButtonRemove.setToolTipText("ausgew\u00e4hlten Pfad entfernen");
        jTextArea1.setEditable(false);
        jTextArea1.setColumns(20);
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(3);
        jTextArea1.setText("Die Pfade werden beim Programmstart nach Medien durchsucht. Die Mediensammlung wird so aktuell gehalten.");
        jTextArea1.setWrapStyleWord(true);
        jScrollPane3.setViewportView(jTextArea1);
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane3).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPath).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemove))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonAdd).addComponent(this.jButtonPath).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.jTextFieldPath, -2, -1, -2)).addComponent(this.jButtonRemove)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jScrollPane3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonAdd, this.jButtonPath, this.jButtonRemove, this.jTextFieldPath);
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, -1, 499, Short.MAX_VALUE).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addComponent(jLabel5).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 205, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel1, -2, -1, -2).addContainerGap()));
        jTabbedPane1.addTab("Pfade", jPanel6);
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)), "Externe Medien dauerhaft hinzuf\u00fcgen"));
        this.cbxExtMedien.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.btnExtAdd.setText("Pfad absuchen");
        this.btnExtAdd.setToolTipText("Ausgew\u00e4hlten Pfad nach Medien absuchen");
        this.btnExtPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.btnExtPath.setToolTipText("Pfad ausw\u00e4hlen");
        jTextArea2.setEditable(false);
        jTextArea2.setColumns(20);
        jTextArea2.setLineWrap(true);
        jTextArea2.setRows(3);
        jTextArea2.setText("Hier k\u00f6nnen Medien aus externen Quellen hinzugef\u00fcgt werden. Die gefundenen Medien werden gespeichert und sind  dann dauerhaft verf\u00fcgbar.");
        jTextArea2.setWrapStyleWord(true);
        jScrollPane4.setViewportView(jTextArea2);
        GroupLayout jPanel8Layout = new GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane4, -1, 465, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel8Layout.createSequentialGroup().addComponent(this.cbxExtMedien, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnExtPath)).addGroup(GroupLayout.Alignment.TRAILING, jPanel8Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnExtAdd))).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnExtPath).addComponent(this.cbxExtMedien, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnExtAdd).addGap(18, 18, 18).addComponent(jScrollPane4, -2, 54, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel9Layout = new GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(jPanel8, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(jPanel8, -2, -1, -2).addContainerGap(201, Short.MAX_VALUE)));
        jTabbedPane1.addTab("Externe Medien", jPanel9);
        jPanel3.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jCheckBoxMediaDB.setText("Echtzeitsuche in der Mediensammlung");
        this.btnClean.setText("Doppelte Eintr\u00e4ge l\u00f6schen");
        this.btnClean.setToolTipText("Doppelte Eintr\u00e4ge in der Mediendatenbak l\u00f6schen");
        this.btnDel.setText("Index l\u00f6schen");
        this.btnDel.setToolTipText("Komplette Mediendatenbank l\u00f6schen");
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBoxMediaDB).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.btnClean).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnDel, -2, 222, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClean).addComponent(this.btnDel)).addGap(18, 18, 18).addComponent(this.jCheckBoxMediaDB).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        buttonGroup1.add(this.jRadioButtonOhneSuffix);
        this.jRadioButtonOhneSuffix.setSelected(true);
        this.jRadioButtonOhneSuffix.setText("Keine Dateien mit diesem Suffix");
        buttonGroup1.add(this.jRadioButtonMitSuffix);
        this.jRadioButtonMitSuffix.setText("Nur Dateien mit diesem Suffix");
        this.jTextFieldSuffix.setText("txt,xml");
        jLabel6.setText("(z.B.: txt,xml,jpg)");
        jLabel7.setText("(z.B.: mp4,flv,m4v)");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldSuffix).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonMitSuffix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jLabel7)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonOhneSuffix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 104, Short.MAX_VALUE).addComponent(jLabel6))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonOhneSuffix).addComponent(jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonMitSuffix).addComponent(jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldSuffix, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        jPanel7.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        jLabel1.setText("Export Index:");
        this.jButtonExportPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonExportPath.setToolTipText("Datei ausw\u00e4hlen");
        this.jButtonExport.setText("Exportieren");
        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldExportPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExportPath)).addGroup(GroupLayout.Alignment.TRAILING, jPanel7Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonExport))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel1).addComponent(this.jTextFieldExportPath, -2, -1, -2).addComponent(this.jButtonExportPath)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonExport).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.linkSize(1, this.jButtonExportPath, this.jTextFieldExportPath);
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel3, -1, -1, Short.MAX_VALUE).addComponent(jPanel2, -1, -1, Short.MAX_VALUE).addComponent(jPanel7, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel7, -2, -1, -2).addContainerGap(79, Short.MAX_VALUE)));
        jTabbedPane1.addTab("Verwalten", jPanel4);
        this.jToggleButtonLoad.setText("Laden");
        this.jTableMediaDB.setModel(new DefaultTableModel(new Object[][]{{null}}, new String[]{"Title 1"}));
        jScrollPane2.setViewportView(this.jTableMediaDB);
        GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane2, -1, 499, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jToggleButtonLoad, -2, 160, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane2, -1, 333, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToggleButtonLoad).addContainerGap()));
        jTabbedPane1.addTab("Medienliste", jPanel5);
        jLabel2.setText("Anzahl Medien:");
        this.jLabelSizeIndex.setText("0");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jTabbedPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.progress, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSizeIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMakeIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.progress, -2, -1, -2).addComponent(jLabel2).addComponent(this.jLabelSizeIndex).addComponent(this.jButtonMakeIndex).addComponent(this.jButtonHelp)).addContainerGap()));
    }

    private class BeobTextFeld
    implements DocumentListener {
        private BeobTextFeld() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tusEinfach();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tusEinfach();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tusEinfach();
        }

        void tusEinfach() {
            MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_EXPORT_DATEI, PanelMediaDB.this.jTextFieldExportPath.getText());
        }
    }

    private class BeobPath
    implements ActionListener {
        boolean ext;

        public BeobPath(boolean ext) {
            this.ext = ext;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog chooser = new FileDialog((Frame)MediathekGui.ui(), "Pfad zu den Filmen w\u00e4hlen");
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        String path = new File(chooser.getDirectory() + chooser.getFile()).getAbsolutePath();
                        if (this.ext) {
                            PanelMediaDB.this.setCbkExt(path);
                        } else {
                            PanelMediaDB.this.jTextFieldPath.setText(path);
                        }
                    }
                    catch (Exception ex) {
                        logger.error("BeobPath.actionPerformed", (Throwable)ex);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                int returnVal;
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                if (!PanelMediaDB.this.jTextFieldPath.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(PanelMediaDB.this.jTextFieldPath.getText()));
                }
                if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                    try {
                        String path = chooser.getSelectedFile().getPath();
                        if (this.ext) {
                            PanelMediaDB.this.setCbkExt(path);
                        } else {
                            PanelMediaDB.this.jTextFieldPath.setText(path);
                        }
                    }
                    catch (Exception ex) {
                        logger.error("BeobPath.actionPerformed", (Throwable)ex);
                    }
                }
            }
        }
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog((Frame)MediathekGui.ui(), "Filme exportieren");
                chooser.setMode(1);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        PanelMediaDB.this.jTextFieldExportPath.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error(ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!PanelMediaDB.this.jTextFieldExportPath.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(PanelMediaDB.this.jTextFieldExportPath.getText()));
                }
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        PanelMediaDB.this.jTextFieldExportPath.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error("BeobPfad.actionPerformed", (Throwable)ex);
                    }
                }
            }
        }
    }
}

