/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.Utils;

public class QuotedPrintableCodec
implements BinaryEncoder,
BinaryDecoder,
StringEncoder,
StringDecoder {
    private final Charset charset;
    private final boolean strict;
    private static final BitSet PRINTABLE_CHARS;
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int SAFE_LENGTH = 73;

    public QuotedPrintableCodec() {
        this(Charsets.UTF_8, false);
    }

    public QuotedPrintableCodec(boolean strict) {
        this(Charsets.UTF_8, strict);
    }

    public QuotedPrintableCodec(Charset charset) {
        this(charset, false);
    }

    public QuotedPrintableCodec(Charset charset, boolean strict) {
        this.charset = charset;
        this.strict = strict;
    }

    public QuotedPrintableCodec(String charsetName) throws IllegalCharsetNameException, IllegalArgumentException, UnsupportedCharsetException {
        this(Charset.forName(charsetName), false);
    }

    private static final int encodeQuotedPrintable(int b, ByteArrayOutputStream buffer) {
        buffer.write(61);
        char hex1 = Utils.hexDigit(b >> 4);
        char hex2 = Utils.hexDigit(b);
        buffer.write(hex1);
        buffer.write(hex2);
        return 3;
    }

    private static int getUnsignedOctet(int index2, byte[] bytes2) {
        int b = bytes2[index2];
        if (b < 0) {
            b = 256 + b;
        }
        return b;
    }

    private static int encodeByte(int b, boolean encode, ByteArrayOutputStream buffer) {
        if (encode) {
            return QuotedPrintableCodec.encodeQuotedPrintable(b, buffer);
        }
        buffer.write(b);
        return 1;
    }

    private static boolean isWhitespace(int b) {
        return b == 32 || b == 9;
    }

    public static final byte[] encodeQuotedPrintable(BitSet printable, byte[] bytes2) {
        return QuotedPrintableCodec.encodeQuotedPrintable(printable, bytes2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] encodeQuotedPrintable(BitSet printable, byte[] bytes2, boolean strict) {
        if (bytes2 == null) {
            return null;
        }
        if (printable == null) {
            printable = PRINTABLE_CHARS;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (strict) {
            void var7_11;
            boolean encode;
            int pos = 1;
            for (int i = 0; i < bytes2.length - 3; ++i) {
                int b = QuotedPrintableCodec.getUnsignedOctet(i, bytes2);
                if (pos < 73) {
                    pos += QuotedPrintableCodec.encodeByte(b, !printable.get(b), buffer);
                    continue;
                }
                QuotedPrintableCodec.encodeByte(b, !printable.get(b) || QuotedPrintableCodec.isWhitespace(b), buffer);
                buffer.write(61);
                buffer.write(13);
                buffer.write(10);
                pos = 1;
            }
            int b = QuotedPrintableCodec.getUnsignedOctet(bytes2.length - 3, bytes2);
            boolean bl = encode = !printable.get(b) || QuotedPrintableCodec.isWhitespace(b) && pos > 68;
            if ((pos += QuotedPrintableCodec.encodeByte(b, encode, buffer)) > 71) {
                buffer.write(61);
                buffer.write(13);
                buffer.write(10);
            }
            int n = bytes2.length - 2;
            while (var7_11 < bytes2.length) {
                b = QuotedPrintableCodec.getUnsignedOctet((int)var7_11, bytes2);
                encode = !printable.get(b) || var7_11 > bytes2.length - 2 && QuotedPrintableCodec.isWhitespace(b);
                QuotedPrintableCodec.encodeByte(b, encode, buffer);
                ++var7_11;
            }
        } else {
            for (int n : bytes2) {
                int b = n;
                if (b < 0) {
                    b = 256 + b;
                }
                if (printable.get(b)) {
                    buffer.write(b);
                    continue;
                }
                QuotedPrintableCodec.encodeQuotedPrintable(b, buffer);
            }
        }
        return buffer.toByteArray();
    }

    public static final byte[] decodeQuotedPrintable(byte[] bytes2) throws DecoderException {
        if (bytes2 == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes2.length; ++i) {
            byte b = bytes2[i];
            if (b == 61) {
                try {
                    if (bytes2[++i] == 13) continue;
                    int u = Utils.digit16(bytes2[i]);
                    int l = Utils.digit16(bytes2[++i]);
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    throw new DecoderException("Invalid quoted-printable encoding", e2);
                }
            }
            if (b == 13 || b == 10) continue;
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    @Override
    public byte[] encode(byte[] bytes2) {
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, bytes2, this.strict);
    }

    @Override
    public byte[] decode(byte[] bytes2) throws DecoderException {
        return QuotedPrintableCodec.decodeQuotedPrintable(bytes2);
    }

    @Override
    public String encode(String str2) throws EncoderException {
        return this.encode(str2, this.getCharset());
    }

    public String decode(String str2, Charset charset) throws DecoderException {
        if (str2 == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(str2)), charset);
    }

    public String decode(String str2, String charset) throws DecoderException, UnsupportedEncodingException {
        if (str2 == null) {
            return null;
        }
        return new String(this.decode(StringUtils.getBytesUsAscii(str2)), charset);
    }

    @Override
    public String decode(String str2) throws DecoderException {
        return this.decode(str2, this.getCharset());
    }

    @Override
    public Object encode(Object obj) throws EncoderException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.encode((byte[])obj);
        }
        if (obj instanceof String) {
            return this.encode((String)obj);
        }
        throw new EncoderException("Objects of type " + obj.getClass().getName() + " cannot be quoted-printable encoded");
    }

    @Override
    public Object decode(Object obj) throws DecoderException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.decode((byte[])obj);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new DecoderException("Objects of type " + obj.getClass().getName() + " cannot be quoted-printable decoded");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }

    public String encode(String str2, Charset charset) {
        if (str2 == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(str2.getBytes(charset)));
    }

    public String encode(String str2, String charset) throws UnsupportedEncodingException {
        if (str2 == null) {
            return null;
        }
        return StringUtils.newStringUsAscii(this.encode(str2.getBytes(charset)));
    }

    static {
        int i;
        PRINTABLE_CHARS = new BitSet(256);
        for (i = 33; i <= 60; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        for (i = 62; i <= 126; ++i) {
            PRINTABLE_CHARS.set(i);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

