/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.InheritanceTree;

final class DelegatingStorage<Transaction>
implements Serializable,
AbstractLookup.Storage<Transaction> {
    private AbstractLookup.Storage<Transaction> delegate;
    private Thread owner;

    public DelegatingStorage(AbstractLookup.Storage<Transaction> storage) {
        this.delegate = storage;
        this.owner = Thread.currentThread();
    }

    public Object writeReplace() {
        return this.delegate;
    }

    public void checkForTreeModification() {
        if (Thread.currentThread() == this.owner) {
            throw new AbstractLookup.ISE("You are trying to modify lookup from lookup query!");
        }
    }

    public static boolean isSimple(AbstractLookup.Storage storage) {
        if (storage instanceof DelegatingStorage) {
            return ((DelegatingStorage)storage).delegate instanceof ArrayStorage;
        }
        return storage instanceof ArrayStorage;
    }

    public AbstractLookup.Storage<Transaction> exitDelegate() {
        if (Thread.currentThread() != this.owner) {
            throw new IllegalStateException("Onwer: " + this.owner + " caller: " + Thread.currentThread());
        }
        AbstractLookup.Storage<Transaction> storage = this.delegate;
        this.delegate = null;
        return storage;
    }

    @Override
    public boolean add(AbstractLookup.Pair<?> pair, Transaction Transaction2) {
        return this.delegate.add(pair, Transaction2);
    }

    @Override
    public void remove(AbstractLookup.Pair pair, Transaction Transaction2) {
        this.delegate.remove(pair, Transaction2);
    }

    @Override
    public void retainAll(Map map, Transaction Transaction2) {
        this.delegate.retainAll(map, Transaction2);
    }

    private void changeDelegate(InheritanceTree inheritanceTree) {
        this.delegate = inheritanceTree;
    }

    @Override
    public Transaction beginTransaction(int n) {
        try {
            return this.delegate.beginTransaction(n);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ArrayStorage arrayStorage = (ArrayStorage)this.delegate;
            InheritanceTree inheritanceTree = new InheritanceTree();
            this.changeDelegate(inheritanceTree);
            Enumeration<AbstractLookup.Pair<Object>> enumeration = arrayStorage.lookup(Object.class);
            while (enumeration.hasMoreElements()) {
                if (inheritanceTree.add(enumeration.nextElement(), new ArrayList<Class>())) continue;
                throw new IllegalStateException("All objects have to be accepted");
            }
            AbstractLookup.ReferenceToResult referenceToResult = arrayStorage.cleanUpResult(null);
            if (referenceToResult != null) {
                referenceToResult.cloneList(inheritanceTree);
            }
            return this.delegate.beginTransaction(n);
        }
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template template) {
        return this.delegate.cleanUpResult(template);
    }

    @Override
    public void endTransaction(Transaction Transaction2, Set<AbstractLookup.R> set) {
        this.delegate.endTransaction(Transaction2, set);
    }

    @Override
    public <T> Enumeration<AbstractLookup.Pair<T>> lookup(Class<T> clazz) {
        return this.delegate.lookup(clazz);
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult referenceToResult) {
        return this.delegate.registerReferenceToResult(referenceToResult);
    }

    @Override
    public <T> Lookup.Result<T> findResult(Lookup.Template<T> template) {
        return this.delegate.findResult(template);
    }
}

