/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.servicecontext;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.servicecontext.ServiceContextData;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;

public class ServiceContextRegistry {
    private ORB orb;
    private Vector scCollection = new Vector();

    private void dprint(String msg) {
        ORBUtility.dprint(this, msg);
    }

    public ServiceContextRegistry(ORB orb) {
        this.orb = orb;
    }

    public void register(Class cls) {
        ServiceContextData scd;
        if (ORB.ORBInitDebug) {
            this.dprint("Registering service context class " + cls);
        }
        if (this.findServiceContextData((scd = new ServiceContextData(cls)).getId()) != null) {
            throw new BAD_PARAM("Tried to register duplicate service context");
        }
        this.scCollection.addElement(scd);
    }

    public ServiceContextData findServiceContextData(int scId) {
        if (ORB.ORBInitDebug) {
            this.dprint("Searching registry for service context id " + scId);
        }
        Enumeration enumeration = this.scCollection.elements();
        while (enumeration.hasMoreElements()) {
            ServiceContextData scd = (ServiceContextData)enumeration.nextElement();
            if (scd.getId() != scId) continue;
            if (ORB.ORBInitDebug) {
                this.dprint("Service context data found: " + scd);
            }
            return scd;
        }
        if (ORB.ORBInitDebug) {
            this.dprint("Service context data not found");
        }
        return null;
    }
}

